C           Program BOOTSUMM.  Source code, FORTRAN-90.
C This summarizes results from HYBALL rotations of bootstrap factor solutions
C with a common origin.
C
C                 Last revised:  31 July 2000

      CHARACTER(12) WORD*80, F1, F2, NAME(80), CF, CLN*8, CH1*1
      REAL  GRAND(5,2,2)
      REAL(8) T

CCC      LOGICAL IFIX(MV)
CCC      INTEGER ORDER(MF), IN(MF*(MV+MF)), JLST(MV), KLST(MV),
CCC     +        MATCH(MF,MREC*(MREC+1)/2)
CCC      REAL A1(MV,MF), A2(MV,MF), SDA(MV,MF), C1(MF,MF), C2(MF,MF),
CCC     +     SDC(MF,MF), CLOS(2,MREC*(MREC+1)/2), CFF(MF), COMM(MV),
CCC     +     SDCM(MV), FOOT(5,2,MF)

      LOGICAL,ALLOCATABLE :: IFIX(:)
      INTEGER,ALLOCATABLE :: ORDER(:), IN(:), JLST(:), KLST(:),
     +         MATCH(:,:)
      REAL,ALLOCATABLE :: A1(:,:), A2(:,:), SDA(:,:), C1(:,:), C2(:,:),
     +      SDC(:,:), CLOS(:,:), CFF(:), COMM(:), SDCM(:), FOOT(:,:,:)
      EXTERNAL SCAN
      COMMON  NV, NF, MV, MF
      COMMON /CF/ CF
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      CH1 = ''
C      FOOT(J,K,L): Summaries at foot of Pattern tables
C      GRAND(J,K,M): Grand summaries of Pattern/Covar tables
C       J: 1,max ; 2, min; 3, mean unsigned diff; 4, RMS; 5, mean signed diff
C       K: 1, boot average minus target; 2, SD of boot productions
C       L: 1, pattern; 2, factor
C       M: 1, pattern; 2, covariances

CC TEST LINES
C      OPEN(21,FILE='JUNK')

      OPEN(2,STATUS='SCRATCH')
      KP = 132
      CALL SYSTEM('cls')
      CALL PRNT(0,KP,6)
      RAD = 90/ACOS(0.)
C
C     NOTE: 2-char bootstrap identifier moves from middle of COV-file name
C           to start of name for HYBALL output ready for BOOTSUMM analysis
      WRITE(6,'(/" The factor solutions from bootstrapped covarian",
     +  "ces available here are:")')
      CALL LOOK(1,'*.H*',NAME,40,NN)
      MST = 0
      DO J = 1,NN
        IF(NAME(J)(:2)=='(-') MST = MST+1
        IF(NAME(J)(:2)=='(-') JLST(MST) = J
      END DO
      IF(NN-MST==0) WRITE(6,'(/ " There are no bootstrap results ",
     + "here.  Look elsewhere.")')
      IF(NN-MST==1) WRITE(6,'(/ " A singleton is not enough to ",
     + "summarize.  Go make some more.")')
      IF(NN-MST<=1) STOP
      WORD(:11) = 's          ' ! WORD(K:2) => K=2 singular, K=1 plural
      IF(MST>1) WORD(3:11) = 'These are'
      WRITE(6,'(5X,"These include ",A," master bootfile",A,"whose na"
     +  "me begins with one of"/20X,"(-   )-   [-   ]-   {-   }-"/5X,
     +  "to flag that it is a factor solution derived from the actual"/
     +  5X,"data covariances, that is, no bootstraps sampling.  ",A)')
     +  CF(:JF(MST)), WORD(3-MIN(2,MST):2), WORD(3:11)
      IF(MST>1) WRITE(6,'(5(/10X,4(I2,". ",A)))')
     +  (J,NAME(JLST(J)),J=1,MST)
      N1 = 1
      IF(MST>0) N1 = JLST(1)
7     F2 = NAME(N1)
      CALL CAP(F2,12)
      CALL LAST(LF,F2,12)
      IF(MST==1) THEN
        WRITE(6,'(/" Master bootfile ",A," will serve as the pattern",
     +    "-alignment template.")') F2(:LF)
        WRITE(6,'(/" If these are the bootstrap solutions you want ",
     +    "to summarize, hit RETURN."/" Otherwise, enter anything",
     +    " to abort the run.")')
        CALL SCAN(J,0,'B',5)
        IF(J/=0) STOP
        GOTO 12
      ELSE IF(MST>1) THEN
        WRITE(6,'(/"   Master bootfile ",A," is set to be the patter",
     +    "n-alignment template."/"   To accept this, hit RETURN.  O",
     +    "therwise, if you want another, enter its"/3X,"index from ",
     +    "the short list above.")') F2(:LF)
        CALL SCAN(J,0,'IB',5)
        IF(J==0) GOTO 12
        IF(J>0) THEN
          READ(2,*) N1
          N1 = JLST(MAX(1,MIN(MST,N1)))
        END IF
        GOTO 7
      ELSE
        WRITE(6,'(/" Since no master bootfile is present, you need",
     +    " a temporary surrogate for that.")')
10      WRITE(6,'(" The one now picked to delimit the summary collec",
     +    "tion is ",A,"."/" (Patterns that do not match this in ",
     +    "data source, variables factored,"/" and number of facto",
     +    "rs will be disregarded.)  Hit RETURN if OK,"/" or enter "
     +    "the index of another selection from this list."/)') F2(:LF)
        CALL SCAN(J,1,'I',5)
        IF(J<0) GOTO 10
        IF(J>0) THEN
          READ(2,*) N1
          N1 = MAX(1,MIN(NN,N1))
          GOTO 7
        END IF
      END IF
      WRITE(6,'(/" Starting the summary.")')
      MST = MIN(1,MST)
C Pick out files that suitably match F2
12    WRITE(6,'(/" Scanning bootstrap solutions to be summarized",
     +  " . . .")')
      CALL START(4,F2)  ! First, load the template
      READ(4,*) NV, NF, I, KODE, F1  ! F1 is the non-boot source COV-file
      MV = NV; MF = NF
      ALLOCATE ( IFIX(MV),IN(MF*(MV+MF)),JLST(MV),KLST(MV),ORDER(MF) )
      ALLOCATE ( A1(MV,MF), A2(MV,MF), C1(MF,MF), C2(MF,MF), CFF(MF),
     +       COMM(MV), FOOT(5,2,MF), SDA(MV,MF), SDC(MF,MF), SDCM(MV) )
      KODE = MOD(KODE,100000)
      NVF = NV*NF
      LOTS = NVF+2+NF*NF
      READ(4,*) (IN(I),I=1,LOTS)
      IF(KODE>=0) GOTO 15  ! Negative KODE flags block structure
      READ(4,*) (J,I=1,NF+NV)   ! Dummy read, block assignments of items
      READ(4,*) (J,I=1,J)       ! Dummy read, block dependencies
15    READ(4,*) (JLST(I),I=1,NV)
      CLOSE(4)
      KODE = MOD(ABS(KODE),100000)
      IF(MST>0) OPEN(18,STATUS='SCRATCH',FORM='UNFORMATTED')
      IF(MST>0) WRITE(18) (.001*IN(I),I=1,NVF),(.001*IN(I),
     +             I=NVF+3,LOTS)
      OPEN(19,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +     RECL=4*LOTS+8)   ! Last 8 is wiggle room not really needed
      NPAT = 0
      DO 20 K = 1,NN
        IF(NAME(K)(:2)=='(-') GOTO 22
        CALL START(4,NAME(K)) ! Open and position file NAME(K)
        READ(4,*) NV1, NF1, I, KD, M, F3  ! F3 is the non-boot source COV-file
        KD1 = MOD(KD,100000)
C          IF(NV1/=NV.OR.NF1/=NF.OR.KD1/=KODE.OR.F3/=F1) GOTO 22
C          ***** WORK ON THIS *****
        IF(NV1/=NV.OR.NF1/=NF) GOTO 22   ! Temporary
        READ(4,*) (IN(I),I=1,LOTS)
        IF(KD>=0) GOTO 24  ! Negative KODE flags block structure
        READ(4,*) (J,I=1,NF+NV)   ! Dummy read, block assignments of items
        READ(4,*) (J,I=1,J)       ! Dummy read, block dependencies
24      READ(4,*) (KLST(I),I=1,NV)
        CLOSE(4)
        DO I = 1,NV
          IF(JLST(I)/=KLST(I)) GOTO 22
        END DO
        NPAT = NPAT+1
        WRITE(19,REC=NPAT) (.001*IN(I),I=1,NVF),(.001*IN(I),I=NVF+3,
     +          LOTS)
        CYCLE
22      NAME(K) = '?           '
20    END DO
      NP = 0
      DO I = 1,NN
        IF(NAME(I)(1:1)=='?') CYCLE
        NP = NP+1
        NAME(NP) = NAME(I)
      END DO
      IF(MST>0) THEN   ! Permute to match master bootfile
        REWIND 18
        READ(18) ((A2(I,J),J=1,NF),I=1,NV),((C2(I,J),J=1,NF),I=1,NF)
        DO K = 1,NPAT
          READ(19,REC=K) ((A1(I,J),J=1,NF),I=1,NV), ((C1(I,J),J=1,NF),
     +        I=1,NF)
          CALL ALIGN(A1,A2,ORDER,CFF,IN,RAD,AV,HI)
          CALL PERM(A1,C1,ORDER,IN)  ! Permute/reflect K into master
          WRITE(19,REC=K) ((A1(I,J),J=1,NF),I=1,NV), ((C1(I,J),J=1,NF),
     +        I=1,NF)
        END DO
      END IF
      IF(NPAT==NN-MST) WRITE(6,'(/" All these bootstrap patterns",
     +  " suitably match ",A)') F2(:LF)
      IF(NPAT==1) WRITE(6,'(/" Inadequately many patterns match ",
     +  A," here; summary cannot continue.")') F2(:LF)
      IF(NPAT==1) STOP
      IF(NPAT==NN-MST) GOTO 40
      WRITE(6,'(/3X,"After patterns not suitably matching ",A,
     +  " are eliminated,"/3X,A," remain over which to summarize ",
     +  "bootstrap results.  If that is OK,"/3X,"hit RETURN to co",
     +  "ntinue.  Otherwise, enter anything to quit.")') F2(:LF),
     +  CF(:JF(NPAT))
      IF(NPAT<=1) WRITE(6,'(/3X,"On second thought, don''t ",
     +  "bother")')
      IF(NPAT<=1) STOP
      CALL SCAN(J,0,'B',5)
      IF(J/=0) STOP
C
40    F2 = 'SEEBOOT     '
      OPEN(7,FILE=F2)
      CALL LAST(L,F1,12)
      WRITE(7,'(" Summary of the bootstrap-origin factor solutions ",
     + "in files",20(/5(3X,A)))') (NAME(I),I=1,NPAT)
      WRITE(7,'(/" These are all patterns of ",A," variables on ",
     +  A," factors obtained from bootstrap"/" counterparts of ",A,
     +  " (Code No. ",A,")")') CF(:JF(NV)), CF(:JF(NF)), F1(:L),
     +  CF(:JF(KODE))
      CALL DAY(7)
      IF(MST>0) GOTO 90
C
C Make pairwise comparisons
      ALLOCATE  ( MATCH(MF,LO(NPAT,NPAT)), CLOS(2,LO(NPAT,NPAT)) )
      WRITE(6,'(/" Finding most typical pattern in this collect",
     +  "ion.")')
      DO L = 2,NPAT
        READ(19,REC=L)((A2(I,J),J=1,NF),I=1,NV), ((C2(I,J),J=1,NF),
     +        I=1,NF)
        DO K = 1,L-1
          READ(19,REC=K) ((A1(I,J),J=1,NF),I=1,NV), ((C1(I,J),J=1,NF),
     +        I=1,NF)
          CALL ALIGN(A1,A2,MATCH(1,LO(K,L)),CFF,IN,RAD,AV,HI)
          CLOS(1,LO(K,L)) = AV
          CLOS(2,LO(K,L)) = HI
        END DO
      END DO
C Rate each pattern for typicality
      AAV = 100.
      HHI = 100.
      NAV = 0
      NHI = 0
      DO K = 1,NPAT
        AV = 0.
        HI = 0.
        DO J = 1,NPAT
          IF(J==K) CYCLE
          AV = AV + CLOS(1,LOC(J,K))
          HI = HI + CLOS(2,LOC(J,K))
        END DO
        AV = AV/(NPAT-1)
        HI = HI/(NPAT-1)
        CLOS(1,LO(K,K)) = AV
        CLOS(2,LO(K,K)) = HI
        IF(AV<AAV) THEN
          NAV = K
          AAV = AV
        END IF
        IF(HI<HHI) THEN
          NHI = K
          HHI = HI
        END IF
      END DO
      DO K = 6,7
        WRITE(K,'(/" Most central on AV divergence: ",A,", with",
     +    " mean <AV,HI> = <",A4,1X,A4,">")') NAME(NAV),
     +    CLN(AAV,4,1), CLN(CLOS(2,LO(NHI,NHI)),4,1)
        WRITE(K,'(" Most central on HI divergence: ",A,", with",
     +    " mean <AV,HI> = <",A4,1X,A4,">")') NAME(NHI),
     +    CLN(CLOS(1,LO(NAV,NAV)),4,1), CLN(HHI,4,1)
      END DO
      NPIK = NAV
      IF(NAV==NHI) GOTO 66
      M = NAV+NHI
64    NPIK = M-NPIK
      WRITE(6,'(/" Pattern ",A," is now picked to be the alignme",
     +  "nt standard.  Hit RETURN if OK,"/" or enter anything to",
     +  " choose pattern ",A," instead.")') CF(:JF(NPIK)),
     +  CF(:JF(M-NPIK))
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 64
66    CONTINUE

C TEST LINES
C      WRITE(21,'(//" Pattern alignments as received:")')
C      DO 1011 J = 2,NPAT
C       DO 1011 I = 1,J-1
C1011    WRITE(21,'(" Patterns",I2," on",I2,": <AV,HI> divergenc",
C     +   "e = <",2A5,">; ORDER =",10I3)') I, J, CLN(CLOS(1,LO(I,J
C     +   )),5,1), CLN(CLOS(2,LO(I,J)),5,1), (MATCH(K,LO(I,J)),K=1,NF)
C      DO 1021 K = 1,NPAT
C1021   WRITE(21,'(" Pattern",I2,": Mean <AV,HI> = <",A4,1X,A4,">"
C     +  )') K, CLN(CLOS(1,LO(K,K)),4,1), CLN(CLOS(2,LO(K,K)),4,1)
C      WRITE(21,'(/" Most central on AV divergence: Pattern",I3,
C     + " with mean <AV,HI> = <",A4,1X,A4,">")') NAV,
C     + CLN(AAV,4,1), CLN(CLOS(2,LO(NHI,NHI)),4,1)
C      WRITE(21,'(" Most central on HI divergence: Pattern",I3,
C     + " with mean <AV,HI> = <",A4,1X,A4,">")') NHI,
C     + CLN(CLOS(1,LO(NAV,NAV)),4,1), CLN(HHI,4,1)
C      WRITE(21,'(/" Pattern ",A," was picked to be the alignme",
C     + "nt standard.")') CF(:JF(NPIK))

C
C Align all patterns with pattern NPIK
      BG: DO K = 1,NPAT
        DO I = 1,NF
          IF(K<NPIK) THEN  ! MATCH stores K => NPIK alignment
            ORDER(I) = MATCH(I,LO(K,NPIK))  ! K => NPIK
          ELSE IF(K>NPIK) THEN    ! MATCH stores NPIK => K alignment
            L = MATCH(I,LOC(K,NPIK))
            ORDER(ABS(L)) = SIGN(I,L)    ! K => NPIK alignment
          ELSE
            MATCH(I,LO(K,NPIK)) = I
          END IF
        END DO
        IF(K==NPIK) CYCLE BG
        READ(19,REC=K)((A1(I,J),J=1,NF),I=1,NV), ((C1(I,J),J=1,NF),
     +        I=1,NF)
        CALL PERM(A1,C1,ORDER,IN)  ! Permute/reflect K into K'
        WRITE(19,REC=K) ((A1(I,J),J=1,NF),I=1,NV), ((C1(I,J),J=1,NF),
     +        I=1,NF)
C   Noww work out the new J' => K' alignment for J < K
        DO J = 1,K-1
          IF(J==NPIK) CYCLE
          DO I = 1,NF
            IF(J<NPIK) THEN
              L = MATCH(I,LO(J,NPIK))
              JLST(ABS(L)) = SIGN(I,L)  ! Inverse of J => NPIK alignment
            ELSE IF(J>NPIK) THEN
              JLST(I) = MATCH(I,LO(NPIK,J))  ! Inverse of J => NPIK alignment
            END IF  ! Inverse of J => NPIK is J' => J transformation
            KLST(I) = MATCH(I,LOC(J,K))  ! J => K alignment
          END DO
          DO I = 1,NF
            IN(I) = KLST(ABS(JLST(I)))*SIGN(1,JLST(I))  ! J' => K alignment
          END DO
C            If A' = P(A) where P is a signed PUT-permutation <p1,...,pn> on
C            n-tuple A, then A'(abs[pi]) = A(i)*sign-of-pi.
C            But if P and Q are PUT-permutations and R = Q(P) is the composition
C            of P into Q, then R(i) = Q(P(i)*sign-of-P(i).
          DO I = 1,NF
            IF(K<NPIK) THEN
              KLST(I) = MATCH(I,LO(K,NPIK))  ! K => NPIK alignment
            ELSE
              L = MATCH(I,LO(NPIK,K))
              KLST(ABS(L)) = SIGN(I,L)  ! K => NPIK alignment
            END IF  ! K => NPIK is K => K' transformation
          END DO
          DO I = 1,NF
            MATCH(I,LOC(J,K)) = KLST(ABS(IN(I)))*SIGN(1,IN(I))
          END DO
C            Composition of J' => K into K => K'
        END DO
      END DO BG
C
C Bootstrap solutions are optimally aligned; now determine their agreement.
C Sum pattern/covs in A1/C1, sum-sqares in SDA/SDC

90    WRITE(6,'(/" Computing summary of aligned patterns")')
      NFIX = 0

C      DO J = 1,NF    ! Ascertain if any factors are fixed inputs
C        JFIX(J) = .FALSE.    ! Not yet sure if JFIX is actually needed
C        DO I = 1,NV
C          IFIX(J) = .FALSE.
C          IF(1.-ABS(A1(I,J))<.0001) THEN
C            JFIX(J) = .TRUE.
C            IFIX(I) = .TRUE.
C            DO K = 1,NF
C             IF(I/=K .AND. ABS(A1(I,K))>.0001) JFIX(J) = .FALSE.
C             IF(.NOT.JFIX(J)) IFIX(I) = .FALSE.
C            END DO
C          END IF
C          IF(JFIX(J)) GOTO 91
C        END DO
C91        IF(JFIX(J)) NFIX = NFIX+1
C      END DO

      DO I = 1,NV    ! Ascertain if any factors are fixed inputs
        IFIX(I) = .FALSE.
        DO J = 1,NF
          IF(1.-ABS(A1(I,J))<.0001) THEN
            IFIX(I) = .TRUE.
            DO K = 1,NV
              IF(K/=I .AND. ABS(A1(K,J))>.0001) IFIX(I) = .FALSE.
            END DO
          END IF
          IF(IFIX(I)) GOTO 92
        END DO
92      IF(IFIX(I)) NFIX = NFIX+1
      END DO
      A1 = 0.
      SDA = 0.
      C1 = 0.
      SDC = 0.
      COMM = 0.
      SDCM = 0.
      DO I = 1,5
        S = 0.
        IF(I==2) S = 9.  ! Initialize Minimum
        DO J = 1,2
          DO K = 1,NF
            FOOT(I,J,K) = S
          END DO
          DO K = 1,2
            GRAND(I,J,K) = S
          END DO
        END DO
      END DO
      DO K = 1,NPAT  ! Get raw sums and sum-squares
        READ(19,REC=K)((A2(I,J),J=1,NF),I=1,NV),((C2(I,J),J=1,NF),
     +        I=1,NF)
        DO I = 1,NV   ! Start with bootstrap communalities
          T = 0.
          DO J = 1,NF
            DO L = 1,NF
              T = T + A2(I,J)*C2(J,L)*A2(I,L)
            END DO
          END DO
          COMM(I) = COMM(I) + T
          SDCM(I) = SDCM(I) + T*T
        END DO
        DO J = 1,NF
          DO I = 1,NV
            A1(I,J) = A1(I,J) + A2(I,J)
            SDA(I,J) = SDA(I,J) + A2(I,J)*A2(I,J)
          END DO
          DO I = 1,NF
            C1(I,J) = C1(I,J) + C2(I,J)
            SDC(I,J) = SDC(I,J) + C2(I,J)*C2(I,J)
          END DO
        END DO
      END DO
      DO J = 1,NF   ! Get means and SDs
        DO I = 1,NV
          A1(I,J) = A1(I,J)/NPAT
          SDA(I,J) = SQRT(SDA(I,J)/NPAT - A1(I,J)*A1(I,J))
        END DO
        DO I = 1,NF
          C1(I,J) = C1(I,J)/NPAT
          SDC(I,J) = SQRT(MAX(0.,SDC(I,J)/NPAT - C1(I,J)*C1(I,J)))
        END DO
      END DO
       DO I = 1,NV
         COMM(I) = COMM(I)/NPAT
         SDCM(I) = SQRT(MAX(.00001,SDCM(I)/NPAT - COMM(I)*COMM(I)))
       END DO
C Start printing results
      WRITE(6,'(/" Printing results in SEEBOOT.")')
      WRITE(7,'(/" After alignment, the sampling mean of these boot",
     +  "strap patterns/covariances is")')
      CALL SHOW(A1,C1,COMM,3,7,0)
      WRITE(7,'(//" The corresponding sampling SDs are")')
      CALL SHOW(SDA,SDC,SDCM,3,7,1)
C   Get table summaries
CC    FOOT(K1,K2,KF): Summaries at foot of Pattern tables
CC    GRAND(K1,K2,KG): Grand summaries of Pattern/Covar tables
CC     K1: 1,max ; 2, min; 3, mean unsigned diff; 4, RMS; 5, mean signed diff
CC     K2: 1, mean boot productions; 2, SD of boot productions
CC     KF: Factors
CC     KG: 1, pattern; 2, covariances
      NP = 0
      DO J = 1,NF
        DO I = 1,NV
          A1(I,J) = A1(I,J) - A2(I,J)
          IF(IFIX(I)) CYCLE
          NP = NP+1
          DO K = 1,2
            IF(K==1) S = A1(I,J)
            IF(K==2) S = SDA(I,J)
             FOOT(1,K,J) = MAX(FOOT(1,K,J),ABS(S))
            GRAND(1,K,1) = MAX(GRAND(1,K,1),ABS(S))
             FOOT(2,K,J) = MIN(FOOT(2,K,J),ABS(S))
            GRAND(2,K,1) = MIN(GRAND(2,K,1),ABS(S))
             FOOT(3,K,J) = FOOT(3,K,J) + ABS(S)
            GRAND(3,K,1) = GRAND(3,K,1) + ABS(S)
             FOOT(4,K,J) = FOOT(4,K,J) + S*S
            GRAND(4,K,1) = GRAND(4,K,1) + S*S
             FOOT(5,K,J) = FOOT(5,K,J) + S
            GRAND(5,K,1) = GRAND(5,K,1) + S
          END DO
        END DO
      END DO
      NC = 0
      LP1: DO J = 1,NF
        DO I = 1,J
          C1(I,J) = C1(I,J) - C2(I,J)
          IF(I==J) CYCLE LP1
          NC = NC+1
          DO K = 1,2
            IF(K==1) S = C1(I,J)
            IF(K==2) S = SDC(I,J)
            GRAND(1,K,2) = MAX(GRAND(1,K,2),ABS(S))
            GRAND(2,K,2) = MIN(GRAND(2,K,2),ABS(S))
            GRAND(3,K,2) = GRAND(3,K,2) + ABS(S)
            GRAND(4,K,2) = GRAND(4,K,2) + S*S
            GRAND(5,K,2) = GRAND(5,K,2) + S
          END DO
        END DO
      END DO LP1
      DO J = 1,2
        DO K = 1,NF
          DO I = 3,5
            FOOT(I,J,K) = FOOT(I,J,K)/(NV-NFIX)
          END DO
          FOOT(4,J,K) = SQRT(FOOT(4,J,K))
        END DO
      END DO
      DO K = 1,2
        If(K==1) N = (NV-NFIX)*NF
        If(K==2) N = NC
        DO J = 1,2
          DO I = 3,5
            GRAND(I,J,K) = GRAND(I,J,K)/N
          END DO
            GRAND(4,J,K) = SQRT(GRAND(4,J,K))
        END DO
      END DO
      WRITE(7,'(200A)') (CH1,I=1,12+2*(1+(NF-1)/5)+6*NF )
      DO I = 1,4  ! Append column summaries to the sampling SDs table
        IF(I==1) WORD(:12) = '   Max Size:'
        IF(I==2) WORD(:12) = '   Min Size:'
        IF(I==3) WORD(:12) = '       Mean:'
        IF(I==4) WORD(:12) = '        RMS:'
        WRITE(7,'(A,4(2X,5A6),90(:/14X,3(2X,5A6)))') WORD(:12),
     +    (CLN(FOOT(I,2,J),6,3),J=1,NF)
      END DO
      IF(NFIX>0) WRITE(7,'(12X,"Note: X-set rows are omitted ",
     +  "from column summaries")')
      CALL SHOW(SDA,SDC,SDCM,3,7,2)
C
      IF(MST>0) THEN   ! Retrieve target into A2/C2
        REWIND 18
        READ(18) ((A2(I,J),J=1,NF),I=1,NV),((C2(I,J),J=1,NF),I=1,NF)
      ELSE
        READ(19,REC=NPIK)((A2(I,J),J=1,NF),I=1,NV),((C2(I,J),J=1,NF),
     +    I=1,NF)
      END IF
      DO I = 1,NV
        S = 0.
        DO J = 1,NF
          DO L = 1,NF
            S = S + A2(I,J)*C2(J,L)*A2(I,L)
          END DO
        END DO
        COMM(I) = COMM(I) - S
      END DO
      IF(MST==0) F2 = NAME(NPIK)
      WRITE(7,'(//" Difference of the mean bootstrap pattern/covar",
     +  "iances from the target solution in ",A,":")') F2(:LF)
      CALL SHOW(A1,C1,COMM,3,7,1)
      WRITE(7,'(200A)') (CH1,I=1,12+2*(1+(NF-1)/5)+6*NF)
      DO I = 1,5  ! Append column summaries to the diff-from-target table
        IF(I==1) WORD(:12) = '   Max Size:'
        IF(I==2) WORD(:12) = '   Min Size:'
        IF(I==3) WORD(:12) = '  Mean Size:'
        IF(I==4) WORD(:12) = '        RMS:'
        IF(I==5) WORD(:12) = '       Mean:'
        WRITE(7,'(A,4(2X,5A6),90(:/14X,3(2X,5A6)))') WORD(:12),
     +    (CLN(FOOT(I,1,J),6,3),J=1,NF)
      END DO
      IF(NFIX>0) WRITE(7,'(12X,"Note: X-set rows are omitted ",
     +  "from column summaries")')
      CALL SHOW(A1,C1,COMM,3,7,2)
      WRITE(7,'(//3X,"Each element in the middle pair of tables abov",
     +  "e is the algebraic difference"/3X,"of the mean bootstrap-sa",
     +  "mple estimate of a particular factor loading or"/3X,"factor",
     +  " correlation from that parameter''s real-covariances estima",
     +  "te.  And the"/3X,"corresponding standard deviations of thos",
     +  "e bootstrap-sample parameter"/3X,"estimates are in the last",
     +  " pair of tables.  The distribution of differences"/3X,"or ",
     +  "SDs in each of these tables can be globally summarized as ",
     +  "follows."/3X,"(""Size"" of a difference is how large it is",
     +  " regardless of its sign.)")')
      WRITE(7,'(/5X,"Departure of sampling means from target in:  ",
     +  "Pattern  Covariances")')
      WRITE(7,'(5X,"Maximum size of difference",19X,A5,6X,A5)')
     +  (CLN(GRAND(1,1,J),5,3),J=1,2)
      WRITE(7,'(5X,"Minimum size of difference",19X,A5,6X,A5)')
     +  (CLN(GRAND(2,1,J),5,3),J=1,2)
      WRITE(7,'(5X,"Mean size of difference",22X,A5,6X,A5)')
     +  (CLN(GRAND(3,1,J),5,3),J=1,2)
      WRITE(7,'(5X,"Standard (RMS) difference",20X,A5,6X,A5)')
     +  (CLN(GRAND(4,1,J),5,3),J=1,2)
      WRITE(7,'(5X,"Mean algebraic difference (bias)",13X,A5,6X,A5)')
     +  (CLN(GRAND(5,1,J),5,3),J=1,2)

      WRITE(7,'(/5X,"Standard deviations of bootstrap estimates:  ",
     +  "Patttern  Covariances")')
      WRITE(7,'(5X,"Maximum SD",35X,A5,6X,A5)')
     +  (CLN(GRAND(1,2,J),5,3),J=1,2)
      WRITE(7,'(5X,"Minimum SD",35X,A5,6X,A5)')
     +  (CLN(GRAND(2,2,J),5,3),J=1,2)
      WRITE(7,'(5X,"Standard (RMS) size of SDs",19X,A5,6X,A5)')
     +  (CLN(GRAND(4,2,J),5,3),J=1,2)
      WRITE(7,'(5X,"Mean SD",38X,A5,6X,A5)')
     +  (CLN(GRAND(5,2,J),5,3),J=1,2)
      IF(NFIX>0) WRITE(7,'("   (Pattern on X-set items is omit",
     +  "ted from these summaries.)")')
      WRITE(7,'()')
      WRITE(6,'(/21X,">>>>>> Done <<<<<<")')

      STOP
      END
C
C
      SUBROUTINE ALIGN(A,B,ORDER,DG,WORK,RAD,AV,HI)
C This compares the columns of NV-by-NF matrix A to those of matrix B, and puts
C into vector ORDER the permutation (and reflection if signalled by negative
C ORDER value) of A's columns that aligns A with B most closely. The congruence
C coefficients for the best match are converted to degrees difference and
C reported in vector DG with their average in AV and max in HI.
      INTEGER ORDER(*)
      REAL A(MV,*), B(MV,*), WORK(MV,*), DG(*), WK(MV,2)
      COMMON  NV, NF, MV, MF
      DO J = 1,NF
        ORDER(J) = 0
        WK(J,1) = 0
        WK(J,2) = 0
        DO I = 1,NV
          WK(J,1) = WK(J,1) + A(I,J)*A(I,J)
          WK(J,2) = WK(J,2) + B(I,J)*B(I,J)
        END DO
      END DO
      DO J = 1,NF
        DO K = 1,NF
          SAB = 0
          DO I = 1,NV
            SAB = SAB + A(I,J)*B(I,K)
          END DO
          WORK(J,K) = SAB/SQRT(MAX(WK(J,1)*WK(K,2),1.E-8))
        END DO
      END DO
      AV = 0.
      HI = 0.
      BIG: DO K = 1,NF
        NI = 0
        NJ = 0
        X = 0.
        BG: DO J = 1,NF
          DO L = 1,NF
            IF(ABS(ORDER(L))==J) CYCLE BG
C            Skip J if already matched
          END DO
          DO I = 1,NF
            IF(ORDER(I)/=0) CYCLE
C            Skip I if already matched
            R = ABS(WORK(I,J))
            IF(R<=X) CYCLE
            X = MIN(1.0,R)
            NI = I
            NJ = J
          END DO
        END DO BG
        ORDER(NI) = SIGN(NJ,NINT(WORK(NI,NJ)))
C         A-factor NI matches B-factor NJ while negative NJ tells PERM to reflect.
C         ORDER permutes A into B-matching order.
       DG(NJ) = ACOS(X)*RAD
C        DG(J) is divergence of B-factor J from its matching A-factor
C        DG(ABS(ORDER(K))) is divergence of A-factor K from matching B-factor
        AV = AV+DG(NJ)
        HI = MAX(HI,DG(NJ))
      END DO BIG
      AV = AV/NF
      END SUBROUTINE
C
      SUBROUTINE CAP(WORD,L)
C This makes the first L letters in WORD all upper-case.
      CHARACTER WORD*(*)
      DO I = 1,L
        N = ICHAR(WORD(I:I))
        IF(N>=97 .AND. N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      END SUBROUTINE

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
C      SAVE /CF/  ! This doesn't appear to be needed
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      CLN = '        '
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      LD = ABS(ND)
      IF(ABS(X)<1.0E-12) THEN !  Special for vanishingly small X
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X))) !  M is space free for decimal (or M-1 if X<0) )
      IF(M<0 .OR.  M<1.AND.X<0.) GOTO 55
      IF(ND>=10) LD = 0; LD = MIN(LD,M)
      DO I = 1,KW
        WK(I) = ' '
      END DO
      IF(LD==0) N = NINT(ABS(X))         ! Shouldn't be needed, but is
      IF(LD/=0) N = NINT(ABS(X)*10**LD)  ! This can overflow if LD is large
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' *******'
      END FUNCTION
C
      SUBROUTINE LAST(L,WORD,M)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as L. If the string is empty, LAST is returned as 0.
      CHARACTER WORD*(*)
      WORD(:M) = ADJUSTL(WORD(:M))
      L = LEN_TRIM(WORD(:M))
      END SUBROUTINE
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
      LOGICAL PRM, QY
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP
      CHARACTER CH, E   ! <<<  Special characters as needed
      WD = GET
      CALL LAST(M,WD,40)
      LL = 1
5     LL = LL+1
      E = WD(LL+1:LL+1)
      IF(E/='|' .AND. E/='/' .AND. LL<M) GOTO 5  ! *** No longer relevant??
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD   ! Bootstrap flags: ( ) [ ] { }
      CH = WORD(:1); IF(CH==' ' .OR. CH=='.') GOTO 10
      IF(CH/='('.AND.CH/=')'.AND.CH/='['.AND.CH/=']'.AND.
     +  CH/='{'.AND.CH/='}') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
      CALL LAST(L,WORD,14)
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4) .AND. NAME(I)(L+5:L+5)==' ')
     +    GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NL)
      IF(NL>0) WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      CALL LAST(L1,NAM1,LEN(NAM1)); CALL LAST(L2,NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      CALL LAST(L1,WRD1,LEN(WRD1)); CALL LAST(L2,WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A number terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION
C
      SUBROUTINE PERM(A1,C1,ORDER,W)
C This permutes/reflects factors as instructed
      REAL A1(MV,*), C1(MF,*), W(MV,*)
      INTEGER ORDER(MF)
      COMMON  NV, NF, MV, MF
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
30    K = 1
      DO I = 1,NF
        IF(ORDER(I)/=I) K = 0
      END DO
      IF(K==1) RETURN
      DO J = 1,NF
        IF(ORDER(J)>0) CYCLE
        ORDER(J) = -ORDER(J)
        DO I = 1,NV
        A1(I,J) = -A1(I,J)
        END DO
        DO I = 1,NF
          C1(I,J) = -C1(I,J)
          C1(J,I) = -C1(J,I)
        END DO
      END DO
      DO I = 1,NV
        DO J = 1,NF
          W(I,ORDER(J)) = A1(I,J)
        END DO
        DO J = 1,NF
          A1(I,J) = W(I,J)
        END DO
      END DO
      DO J = 1,NF
        DO I = 1,NF
          W(ORDER(J),ORDER(I)) = C1(I,J)
        END DO
      END DO
      DO J = 1,NF
        DO I = 1,NF
          C1(I,J) = W(I,J)
        END DO
      END DO
      END SUBROUTINE
C
      SUBROUTINE PRNT(JOB,KP,KFILE)
C Set printer codes. JOB=0/1/2 if job is find-linewidth/set-normal-print/set-
C HYBALL-pattern-plots.  KP is linewidth. KFILE is file to write.
      CHARACTER QFMT, WORD*55
      IF(QFMT('PRNTR')=='U') THEN
        IF(JOB==0) WRITE(KFILE,'(/" WARNING: There is no printer ",
     +    "definition in this subdirectory.")')
        IF(JOB==1) WRITE(KFILE,'(" %")')
        IF(JOB==2) WRITE(KFILE,'(" #")')
        RETURN
      END IF
      OPEN(1,FILE='PRNTR')
      READ(1,'(A)') WORD
      IF(WORD(:1)=='*') KP = 80
      IF(JOB==0) GOTO 10
      IF(WORD(:1)/='%') READ(1,'(A)') WORD
      IF(JOB==1) WRITE(KFILE,'(A)') WORD(3:)
      IF(JOB==1) GOTO 10
      READ(1,'(A)') WORD
      WRITE(KFILE,'(A)') WORD(3:)
10    CLOSE(1)
      END SUBROUTINE
C
      SUBROUTINE SCAN(NL,NS,SEQ,KF)
C This reads the keyboard string, cleans it for list-directed reading of
C the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.  Termination of an input line by "*" allows up to
C two continuation lines.) NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number
C string returned in File 2 is non-null but does not match SEQ, and
C gives the total count of numbers in the returned string otherwise.
C *** If SEQ is "B", NL returns 0 if the input line is blank, and
C     returns -1 otherwise.
      CHARACTER  AA, SEQ*(*), WA*240, WB*240
      NL = 0
5     NLL = NL + 80
      READ(KF,'(A80)') WA(NL+1:NLL)
      IP = NL
      NL = NLL+1
10    NL = NL-1
      IF(NL==0) RETURN
      IF(WA(NL:NL)==' ') GOTO 10
      IF(WA(NL:NL)=='*' .AND. NL>IP) GOTO 5
      IF(SEQ(1:1)=='B') NL = -1
      IF(SEQ(1:1)=='B') RETURN
      WB(NL+1:NL+1) = ' '
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +      WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
        ELSE IF (WA(I:I) /= '0') THEN
          IP = 0
        END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF (WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) RETURN
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     +  "number sequence requested. Try again.")')
      RETURN
60    REWIND 2
      WRITE(2,'(A)') WB(1:NL)
      NL = NN
      REWIND 2
      END SUBROUTINE
C
      SUBROUTINE SHOW(A1,C1,COMM,LD,KF,JOB)
C Print the pattern and factor covariances.  ND stipulates 2 or 3 decimal print
C JOB = 1,2,0 prints pattern/covars/both
      CHARACTER FMT1*40, FMT2*53, CLN*8, CH4*4
      REAL A1(MV,*), C1(MF,*), COMM(*)
      COMMON  NV, NF, MV, MF
      FMT1 = '(4X,7X,3(2X,5A5),90(:/13X,3(2X,5A5)))'
      IF(LD==3) FMT1 = '(4X,8X,3(2X,5A6),90(:/14X,3(2X,5A6)))'
      FMT2 = '(I4,". (",A3,")"'//FMT1(7:)
      IF(LD==3) FMT2 = '(I4,". (",A4,")"'//FMT1(7:)
      IF(JOB>=2) GOTO 50
      WRITE(KF,'(/" Factor pattern")')
      DO I = 1,NV
        IF(MOD(I-1,5)==0) WRITE(KF,'()')
        CH4 = CLN(COMM(I),LD+1,LD)//' '
        WRITE(KF,FMT2) I, CH4, (CLN(A1(I,J),LD+3,LD),J=1,NF)
      END DO
      IF(JOB==1) RETURN
50    IF(LD==2) FMT2 = '(" Factor",I3,"."'//FMT1(7:)
      IF(LD==3) FMT2 = '("  Factor",I3,"."'//FMT1(7:)
      WRITE(KF,'(/" Factor correlations")')
      DO J = 1,NF
        IF(MOD(J-1,5)==0) WRITE(KF,'()')
        WRITE(KF,FMT2) J, (CLN(C1(I,J),LD+3,LD),I=1,J)
      END DO
      END SUBROUTINE
C
      SUBROUTINE START(J,F1)
C This opens formatted file F1 with unit-number J, and finds its first line
C beginning with a digit.
      CHARACTER F1*(*), CH*80
      OPEN(J,FILE=F1)
10    READ(J,'(A)',END=50) CH
      K = 0
12    K = K+1
      L = ICHAR(CH(K:K))
      IF((L==32 .OR. L==0) .AND. K<80) GOTO 12
      IF(L<48 .OR. L>57) GOTO 10
      BACKSPACE J
      RETURN
50    CALL LAST(L,F1,12)
      WRITE(6,'(/" File ",A," is defective.")')  F1(:L)
      STOP
      END SUBROUTINE
C
      SUBROUTINE SUBST(WORD,CHA,CHB)
C  Replace all WORD(:LL)-occurrences of chars in CHA with matching chars in CH2
      CHARACTER WORD*(*), CHA*(*), CHB*(*), CH1, CH2
      M = LEN(WORD)
      N = MIN(LEN(CHA),LEN(CHB))
      DO K = 1,N
        CH1 = CHA(K:K)
        CH2 = CHB(K:K)
        DO I = 1,M
          IF(WORD(I:I)==CH1) WORD(I:I) = CH2
        END DO
      END DO
      RETURN
      END
C
C *************************************************************************
C
C SUBS.LHY: The following subprograms are specific to the Lahey compiler.
C
      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12
      COMMON /CF/ CF
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48
      IF(ZZZ(5:6)=='01') WORD = CF(:JF(M))//' January '//ZZZ(:4)
      IF(ZZZ(5:6)=='02') WORD = CF(:JF(M))//' February '//ZZZ(:4)
      IF(ZZZ(5:6)=='03') WORD = CF(:JF(M))//' March '//ZZZ(:4)
      IF(ZZZ(5:6)=='04') WORD = CF(:JF(M))//' April '//ZZZ(:4)
      IF(ZZZ(5:6)=='05') WORD = CF(:JF(M))//' May '//ZZZ(:4)
      IF(ZZZ(5:6)=='06') WORD = CF(:JF(M))//' June '//ZZZ(:4)
      IF(ZZZ(5:6)=='07') WORD = CF(:JF(M))//' July '//ZZZ(:4)
      IF(ZZZ(5:6)=='08') WORD = CF(:JF(M))//' August '//ZZZ(:4)
      IF(ZZZ(5:6)=='09') WORD = CF(:JF(M))//' September '//ZZZ(:4)
      IF(ZZZ(5:6)=='00') WORD = CF(:JF(M))//' October '//ZZZ(:4)
      IF(ZZZ(5:6)=='11') WORD = CF(:JF(M))//' November '//ZZZ(:4)
      IF(ZZZ(5:6)=='12') WORD = CF(:JF(M))//' December '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE
C
      FUNCTION QFMT(F1)
C This determines the status of file F1, returning 'Y' if it is Formatted,
C 'N' if it is Not, and 'U' if it is Unknown (does not exist).
      CHARACTER QFMT, F1*(*)
      INQUIRE(FILE=F1,FORMATTED=QFMT)
      END FUNCTION

