C          Program FINDBLK.  Source code, FORTRAN-90
C  This receives a set of item groups, augments these to include all their
C  intersection subsets, works out the array of path-structured item blocks
C  under which each item group G corresponds to a block B such that G is the
C  union of B and all blocks path-antecedent to B, and indexes these blocks so
C  that block i path-precedes block j only if i < j. Block B may be empty, in
C  which case it is omitted from the printout.
C
C        Copyright (c) 1989 by W. W. Rozeboom.   All rights reserved.
C
C                 Last revised:  31 July 2000
C
CCC             PARAMETER (MV=500, MB=600)
C         MB limits number of groups, but needs more than HYBLOCK's maximum 30
C           to allow many null intersections during FINDBLK's construction
      CHARACTER F1*11, F2*11, CH3*3, BN*2, CF*12
CC      INTEGER KGRP(0:MV,MB), KTL(MB,MB), LST1(MB), LST2(MB)
      INTEGER,ALLOCATABLE :: KGRP(:,:), KTL(:,:), LST1(:), LST2(:)
C       Effective use of MATCH requires groups to be listed in columns
      EXTERNAL SCAN
      COMMON /CF/ CF
      OPEN(2,STATUS='SCRATCH')
      CALL SYSTEM('cls')
C
      WRITE(6,'(16X,"Welcome to utility program FINDBLK.")')
      WRITE(6,'(/" You are here to enter the indices in two or more ",
     +  "Groups of data variables,"/" selected from the Y-set of a ",
     +  "factor solution by MODA, to learn what blocks"/" of these ",
     +  "items will preserve each stipulated group''s common-part ",
     +  "subspace"/" under HYBLOCK/HYBALL factor rotation.  You sh",
     +  "ould already have written down"/" a list of these groups,",
     +  " taking care that the indices you have grouped are"/" the",
     +  " ones assigned to the Y-set variables in the particular MODA",
     +  " solution"/" on which HYBLOCK will operate. (This may dif",
     +  "fer from these variables''"/" indexing in their origin",
     +  "al dataset.)")')
      WRITE(6,'(//3X,"Enter the total number of Y-set variables fro",
     +  "m which items assigned to"/3X,"restricted Groups will be ",
     +  "selected.  Do NOT count items that HYBLOCK"/3X,"will rec",
     +  "eive as fixed inputs (X-set variables)."/)')
      READ(5,*) NV
CC      IF(NV>MV) WRITE(6,'(/" The maximum number of variables th",
CC     +  "at HYBLOCK/HYBALL can accept is",I4,".")') MV
      NV = MAX(2,MIN(NV,1000))
      WRITE(6,'(/" The total number of Y-set items is now set at ",A,
     +  ".  If this is incorrect,"/" hit Ctrl-C to abort run and",
     +  " start again.")') CF(:JF(NV))

      MV = NV; MB = 2*MV  ! Need for MB should never exceed NV
      ALLOCATE ( KGRP(0:MV,MB), KTL(MB,MB), LST1(MB), LST2(MB) )
      KGRP(0,1) = NV; KTL = 0
      DO I = 1,NV  ! Enter Group 1 comprising all items
        KGRP(I,1) = I
      END DO
      DO J = 2,MB
        KGRP(0,J) = 0
      END DO
      IF(NV<=9) THEN
        CH3 = CHAR(48+NV)//'  '
      ELSE IF(NV<=99) THEN
        CH3 = CHAR(48+NV/10)//CHAR(48+MOD(NV,10))//' '
      ELSE
        CH3 = CHAR(48+NV/100)//CHAR(48+MOD(NV/10,10))//CHAR(48+MOD(
     +        NV,10))
      END IF
      F1 = 'BLKSEE.'//CH3  ! See-report of block solution
      F2 = 'BLKREC.'//CH3  ! Transfers block solution to HYBLOCK (binary)
      OPEN(7,FILE=F1)
      WRITE(7,'(/" FINDBLK report on the block structure needed for",
     +  " HYBLOCK/HYBALL preservation of the common-part subspaces"/
     +  10X,"of item groups entered as")')
C
C Enter the wanted item groups
      WRITE(6,'(/6X,"You must define your Groups sequentially; but",
     +  " the order in which"/6X,"you enter them is arbitrary.  ",
     +  "That is all you need to do here.")')
      WRITE(6,'(/" Each Group will be defined by entering the items ",
     +  "it contains. Your entry"/" method may require more than ",
     +  "one line.  Entering EXACTLY TWO indices N1,N2"/" followed",
     +  " by RETURN will be read as the sequence from N1 to N2.  Any ",
     +  "other"/" line of integers will be read as just the items ",
     +  "listed. (To enter a pair with"/" this interval interpreta",
     +  "tion disabled, duplicate one or also enter zero.)")')
      NG = 2
C       Column NG of KGRP contains indices of Group NG-1; column 1 contains
C       indices for the All-items group.
10    KG = KGRP(0,NG)

      IF(NG>MB) THEN
        WRITE(6,'(/" Limit on Groups has been reached.")')
        NG = MB; GOTO 15
      END IF
      IF(KG>0) WRITE(6,'(/" The items in Group ",A," are now",
     +  2(2X,5(1X,A)),8(:/10X,3(2X,5(1X,A)))))') CF(:JF(NG-1)),
     +  (CF(:JF(KGRP(I,NG))),I=1,KG)
      IF(KG==0) WRITE(6,'(/" Group ",A," is now EMPTY.  (Leave ",
     +  "it so if no more Groups are wanted.)")') CF(:JF(NG-1))
      WRITE(6,'(/" Hit RETURN if correct and complete. Otherwise, e",
     +  "nter additional indices,"/" or any letter to empty the gr",
     +  "oup and start again.   Remember that entering"/" just TWO",
     +  " indices selects all the indices in that interval."/)')
      CALL GETLST(KG,LST1,J,NV,LST2)
      IF(J<0) KGRP(0,NG) = 0
      IF(J>0) CALL MATCH(NV,KGRP(1,1),KG,LST1,KGRP(0,NG),KGRP(1,NG))
      IF(J==0) THEN
        IF(KGRP(0,NG)==0) GOTO 15
        IF(KGRP(0,NG)==NV) KGRP(0,NG) = 0
        NG = NG+1
      END IF
      GOTO 10
15    WRITE(6,'(25X,10(" *")//" Entry of Groups is complete.  If",
     +  " you want to review or alter these Groups,"/" enter anyth",
     +  "ing.  Otherwise, hit RETURN to finish this job.")')
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 17
      NG = 2
      GOTO 10
C
C Expand the item groups to include all group intersections
17    IB = 0
      DO J = 1,NG

C TEST LINES
C       IF(KGRP(0,J)==0) WRITE(7,'(/" Group ",I2," is empty")')
C     +  IB+1

        IF(KGRP(0,J)==0) CYCLE
        IB = IB+1
        WRITE(7,'(/" Group ",A,":",30(1X,A),5(:/10X,30(1X,A)))')
     +    CF(:JF(IB)), (CF(:JF(KGRP(I,J))),I=1,KGRP(0,J))
      END DO
      WRITE(7,'(/80("_"))')
      N1 = NG
      N2 = NG
      JG1 = 2
22    DO IG = 2,N1
        DO JG = MAX(IG+1,JG1),N2
          CALL MATCH(KGRP(0,IG),KGRP(1,IG),KGRP(0,JG),KGRP(1,JG),
     +       KGRP(0,NG+1),KGRP(1,NG+1))
          IF(KGRP(0,NG+1)==0 .OR. KGRP(0,NG+1)>=MIN(KGRP(0,IG),
     +       KGRP(0,JG))) CYCLE
          NG = NG+1
          IF(NG>MB) WRITE(6,'(/" The expansion of your list of ",
     +      "Groups to include all their intersections"/" has ex",
     +      "ceeded its space allocation and cannot continue.")')
          IF(NG>MB) STOP
        END DO
      END DO
      IF(N2==NG) GOTO 30
      JG1 = N2+1
      N2 = NG
      GOTO 22
C
C Set KTL(I,J) = 1 if Group I is a subset of Group J
30    DO I = 2,NG
        KTL(I,1) = 1
      END DO
C      WRITE(7,'(/" TEST: After Group formation, NG =",I3)') NG
      DO I = 2,NG-1
        DO J = I+1,NG
          CALL MATCH(KGRP(0,I),KGRP(1,I),KGRP(0,J),KGRP(1,J),N,LST1)
          IF(N==0) N = -1
          IF(N==KGRP(0,I)) KTL(I,J) = 1
          IF(N==KGRP(0,J)) KTL(J,I) = 1
C          IF(N==KGRP(0,I).AND.N==KGRP(0,J)) WRITE(7,'(" TEST: <",
C     +     I2,I3,"> is an equivalence")') I, J
          IF(N==KGRP(0,I) .AND. N==KGRP(0,J)) KTL(I,I) = 1
          IF(N==KGRP(0,I) .AND. N==KGRP(0,J)) KTL(J,J) = 1
        END DO
      END DO

C      WRITE(7,'(/" TEST: Before equivalence search, KTL is")')
C      DO I = 1,NG
C        WRITE(7,'(4X,80I3)') (KTL(I,J),J=1,NG)
C      END DO

C  Look for equivalence sets
      DO I = 1,NG
        IF(KTL(I,I)<=0) CYCLE
        DO J = I+1,NG
          IF(KTL(I,J)*KTL(J,I)==0) CYCLE
          DO K = 1,NG
            KTL(J,K) = 0
            KTL(K,J) = 0
          END DO
          KTL(J,J) = -I
        KTL(I,I) = MIN(KTL(I,I),0)
        END DO
      END DO
C      WRITE(7,'(/" TEST: After equivalence search, KTL is")')
C      DO I = 1,NG
C        WRITE(7,'(4X,80I3)') (KTL(I,J),J=1,NG)
C      END DO
C
C  Count depth of antecedence and find order that reflects this
      DO I = 1,NG
        LST1(I) = I
        IF(KTL(I,I)<0) LST2(I) = KTL(I,I)
        IF(KTL(I,I)<0) CYCLE
        LST2(I) = 0
        DO J = 1,NG
          LST2(I) = LST2(I) + KTL(I,J)
        END DO
      END DO
      CALL SEQ(NG,LST1,LST2)
C      WRITE(7,'(/" TEST2: LST1 is",80I3)') (LST1(I),I=1,NG)
C      WRITE(7,'(" TEST2: LST2 is",80I3)') (LST2(I),I=1,NG)
C       LST1(_) lists equivalence-pruned Group indices in order of dependency
C       precedence, followed by the higher members of any equivalence set of
C       Groups; LST2(J) is the number of antecedents to Group LST(J) if J is
C       before the higher-equivalence indices, or else the Group to which
C       LST1(J) is equivalent.
      NL = NG+1
48    NL = NL - 1
      IF(LST2(NL)<0) GOTO 48
C       NL is the last position in LST1(_) before any higher-equiv. indices.
C
C  For nonequivalent indices, make KTL(I,J) the maximum path length from I to J
      DO I = NL-1,1,-1
        I1 = LST1(I)
        DO J = I+1,NL
          J1 = LST1(J)
          IF(KTL(I1,J1)==0) CYCLE
          DO K = I+1,J-1
            K1 = LST1(K)
            KTL(I1,J1) = MAX(KTL(I1,J1),KTL(I1,K1)*KTL(K1,J1)+1)
          END DO
        END DO
      END DO
C
C  Order groups by maximum max-path length
      DO I = 1,NL
        I1 = LST1(I)
        LST2(I) = 0
        DO J = I+1,NL
          LST2(I) = MAX(LST2(I),KTL(I1,LST1(J)))
        END DO
      END DO
      CALL SEQ(NL,LST1,LST2)

C TEST LINES
C      WRITE(7,'(/" TEST3: LST1 is",80I3)') (LST1(I),I=1,NG)
C      WRITE(7,'(" TEST3: LST2 is",80I3)') (LST2(I),I=1,NG)

      WRITE(7,'(//" After expansion to include all group intersect",
     + "ions, the well-ordered subspace-preservation Groups are")')
      IB = 0
      DO J = 1,NL
        JG = LST1(J)
        IF(KGRP(0,JG)==0) CYCLE
        IB = IB+1
        WRITE(7,'(/" Group ",A,":",30(1X,A),5(:/10X,30(1X,A)))') BN(IB),
     +    (CF(:JF(KGRP(I,JG))),I=1,KGRP(0,JG))
      END DO

C Construct Blocks by deleting from each Group the indices that precede it.
CCC      DO I = 1,NL-1
CCC        IG = LST1(I)
CCC        DO J = I+1,NL
CCC          JG = LST1(J)
CCC          IF(KTL(IG,JG)<=0) CYCLE
CCC          DO K = 1,KGRP(0,IG)
CCC            DO L = 1,KGRP(0,JG)
CCC              IF(KGRP(K,IG)==KGRP(L,JG)) KGRP(L,JG) = 0
CCC            END DO
CCC          END DO
CCC        END DO
CCC      END DO

CCC      DO I = 1,NL
CCC        IG = LST1(I)
CCC        N = 0
CCC        DO J = 1,KGRP(0,IG)
CCC          IF(KGRP(J,IG)==0) CYCLE
CCC          N = N+1
CCC          KGRP(N,IG) = KGRP(J,IG)
CCC        END DO
CCC        KGRP(0,IG) = N
CCC      END DO

C
C Delete empty blocks
      N = 0
      DO I = 1,NL
        IF(KGRP(0,LST1(I))==0) CYCLE
        N = N+1
        LST1(N) = LST1(I)
      END DO
C   LST1(K) is now the raw group index of the Kth well-ordered item block.
      NL = N
C      WRITE(7,'(/" TEST: After deleting null blocks, NL =",I3)') NL
C
C Record block results
      WRITE(7,'(//" The corresponding item blocks that preserve th",
     +  "ese subspaces under HYBLOCK/HYBALL rotation are")')
      DO J = 1,NL
        JG = LST1(J)
        WRITE(7,'(/" Block ",A,":",30(1X,A),5(:/10X,30(1X,A)))') BN(J),
     +    (CF(:JF(KGRP(I,JG))),I=1,KGRP(0,JG))
      END DO
C
C  List each block's dependencies
      WRITE(7,'(/" Forward block dependencies.")')
      DO I = 1,NL
        N = 0
        DO J = I+1,NL
          IF(KTL(LST1(I),LST1(J))==0) CYCLE
          N = N+1
          LST2(N) = J
        END DO
        WRITE(7,'(" Block ",A," => ",23A3,5(/13X,25A3))') BN(I),
     +    (BN(LST2(J)),J=1,N)
      END DO
      WRITE(7,'(/" Backward block dependencies.")')
      DO I = 1,NL
        KTL(I,MB) = 0
        N = 0
        DO J = 1,I-1
          IF(KTL(LST1(J),LST1(I))==0) CYCLE
          N = N+1
          LST2(N) = J
          KTL(I,MB) = KTL(I,MB) + 2**(J-1)
        END DO
        WRITE(7,'(" Block ",A," <= ",23A3,5(/13X,25A3))') BN(I),
     +    (BN(LST2(J)),J=1,N)
      END DO
C      WRITE(6,'(/" TEST: FIX string is:",10I3)') (KTL(I,MB),I=1,NL)
C
C Record block structure in file BLKREC for transfer to HYBLOCK
      IF(NL>23) GOTO 95
      LB = 0
      DO I = 1,NL
        J = LST1(I)
        IB = I
C        IF(J==1) IB = 99  ! Can't set Y-block if Waifs are allowed
C        IF(J==1) LB = I
        DO K = 1,KGRP(0,J)
         LST2(KGRP(K,J)) = IB
        END DO
      END DO
      OPEN(4,FILE=F2,FORM='UNFORMATTED')
ccc      WRITE(4) NV, NL, LB     ! Old version,
      WRITE(4) NV, NL, LB     ! *****

CCC   NL,NB are NB0,NB in HYBLOCK.  BLOKREC also specifies NB0,NB
C Clarifying code lines from HYBLOCK:
C202   NB0 = NB
C      IF(.NOT.QW) NB1 = NB
C  NB0 = NB  NB1 = NB0+1 if there are waifs
C  Will have NB0 = NB-1 if QY=T
C      IF(QY) NB0 = NB-1       ! QY=T flags block NB as fully dependent
c      WRITE(3) (NINT(BL(I)),I=1,NF), (NINT(LIST(I)),I=1,NV)
C      WRITE(3) NB0, (BS(I),I=1,NB0)  Written to HYBALL-input file

      WRITE(4) (LST2(I),I=1,NV)
      WRITE(4) (KTL(I,MB),I=1,NL)

C TEST LINES
C      WRITE(7,'(/" TEST: <NV, NL, LB> = <",3I3,">")') NV,NL,LB
C      WRITE(7,'(/" TEST: LST1 = ",25I3)') (LST1(I),I=1,NL)
C      WRITE(7,'(/" TEST: LST2 = ",25I3)') (LST2(I),I=1,NV)

C      WRITE(4,'(3I4,I7)') NV, NL, LB
C      WRITE(4,'(50I3,20(/3X,50I3))') (LST2(I),I=1,NV)
C      WRITE(4,'(10I10,3(/3X,10I10))') (KTL(I,MB),I=1,NL)
C
C95    CONTINUE
95    WRITE(7,'(/" Each Group J is the union of Block J and all ",
     + "blocks on which Block J is dependent.")')
      IF(NL<=30) GOTO 97
      WRITE(7,'(/" WARNING: The number (",A,") of item blocks",
     +  " here is greater than the number (30) that HYBLOCK can",
     +  " accept.")') CF(:JF(NL))
      WRITE(6,'(/" WARNING: The number (",A,") of item blocks he",
     +  "re is greater than the number (30)"/10X," that HYBLOCK ca",
     +  "n accept.  However, a report on the block structure"/" in",
     +  "tended for transmission to HYBLOCK is in file ",A)')
     +  CF(:JF(NL)), F1
      STOP
97    CONTINUE
      WRITE(6,'(/" Block identification is complete. It is reported ",
     +  "in ASCII file ",A/" and recorded for input to HYBLOCK in un",
     +  "formatted file ",A,".")') F1, F2
      WRITE(7,'(/" NOTE. This block structure has been recorded in un",
     +  "formatted file ",A,".  When"/7X,"HYBLOCK is run in a subdire",
     +  "ctory that contains this, it will be loaded if the"/7X,"patt",
     +  "ern called for block-structuring contains ",A," Y-set variab",
     +  "les."//)') F2, CF(:JF(NV))
      STOP
      END
C
      FUNCTION BN(N)
c Converts block integer code N into letter code
      CHARACTER BN*2
      J = (N-1)/23
      K = MOD(N-1,23)
      BN = ' *'
      IF(N>598) RETURN
      BN(2:2) = CHAR(64+K)
      IF(J>=1) BN(1:1) = CHAR(64+J)
      RETURN
      END
C
      SUBROUTINE GETLST(N,LIST,J,NV,KW)
C Enter N distinct indices no larger than NV into LIST in sequential order.
C LIST(N+_) receives in order the indices from 1 to NV omitted from LIST.
C KW is a workspace. LIST may be partly formed at input, SCAN provides the rest.
      INTEGER LIST(*), KW(*)
      EXTERNAL SCAN
      CALL SCAN(J,0,'I',5)
      IF(J<=0) RETURN
      NX = N
      DO I = 1,NX
        KW(I) = LIST(I)
      END DO
8     READ(2,*) (LIST(I),I=1,J)
      IF(J/=2) THEN
        DO I = 1,J
          KW(NX+I) = LIST(I)
        END DO
        NX = NX+J
      ELSE
        L = MAX(1,MIN(NV,LIST(1),LIST(2)))
        M = MIN(NV,MAX(1,LIST(1),LIST(2)))
        DO I = L,M
          KW(NX+I-L+1) = I
        END DO
        NX = NX+M-L+1
      END IF
25    WRITE(6,'(/" Enter more indices, or hit RETURN if list is ",
     + "complete."/)')
      CALL SCAN(J,0,'I',5)
      IF(J<0) GOTO 25
      IF(J>0) GOTO 8
C Order list with any duplicates removed
C      CALL SORT(KW,NX,LIST,1,NV)
      DO I = 1,NX
        LIST(I) = KW(I)
      END DO
      N = NX
      J = N
      END SUBROUTINE

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
C      SAVE /CF/  ! This doesn't appear to be needed
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
C
      SUBROUTINE MATCH(N1,LST1,N2,LST2,N3,LST3)
C This matches the N1 entries in LST1 against the N2 entries in LST2 and puts
C the N3 common terms into LST3 in LST1 order.  (Any duplicates in LST1, but
C not in LST2, are also duplicated in LST3.)
      INTEGER LST1(*), LST2(*), LST3(*)
      N3 = 0
      LP1: DO I = 1,N1
        DO J = 1,N2
          IF(LST1(I)/=LST2(J)) CYCLE
          N3 = N3+1
          LST3(N3) = LST1(I)
          CYCLE LP1
        END DO
      END DO LP1
      END SUBROUTINE
C
      SUBROUTINE SCAN(NL,NS,SEQ,KF)
C This reads the keyboard string, cleans it for list-directed reading of
C the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.  Termination of an input line by "*" allows up to
C two continuation lines.) NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number
C string returned in File 2 is non-null but does not match SEQ, and
C gives the total count of numbers in the returned string otherwise.
C *** If SEQ is "B", NL returns 0 if the input line is blank, and
C     returns -1 otherwise.
      CHARACTER  AA, SEQ*(*), WA*240, WB*240
      NL = 0
5     NLL = NL + 80
      READ(KF,'(A80)') WA(NL+1:NLL)
      IP = NL
      NL = NLL+1
10    NL = NL-1
      IF(NL==0) RETURN
      IF(WA(NL:NL)==' ') GOTO 10
      IF(WA(NL:NL)=='*' .AND. NL>IP) GOTO 5
      IF(SEQ(1:1)=='B') NL = -1
      IF(SEQ(1:1)=='B') RETURN
      WB(NL+1:NL+1) = ' '
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +      WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
        ELSE IF (WA(I:I) /= '0') THEN
          IP = 0
        END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF (WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) RETURN
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     + "number sequence requested. Try again.")')
      RETURN
60    REWIND 2
      WRITE(2,'(A)') WB(1:NL)
      NL = NN
      REWIND 2
      END SUBROUTINE
C
      SUBROUTINE SEQ(NV,LST1,LST2)
C This permutes the paired terms in LST1/2 into ascending order in LST2
      INTEGER LST1(*), LST2(*)
      DO L = 1,NV-1
        DO I = 1,NV-L
          IF(LST2(I)>=LST2(I+1)) CYCLE
          K = LST1(I+1)
          LST1(I+1) = LST1(I)
          LST1(I) = K
          K = LST2(I+1)
          LST2(I+1) = LST2(I)
          LST2(I) = K
        END DO
      END DO
      END SUBROUTINE

