C Program FIXDATA.  (Source code, FORTRAN-90)  Subroutine package EIGLIB must
C also be loaded.
C
C        Copyright (c) 2001 by W. W. Rozeboom.   All rights reserved.
C
C                  Last revised: 14 May 2002
C
C HYDATA uploads a HYDATA-standard datafile <base>.Di with missing scores,
C and iterates between estimating those by regression on the good data and
C updating the data correlations from which the regression weights are derived.
C Logfile of successive covariance imputations is on hold in lines Cxx
      LOGICAL QY
      CHARACTER(12) F1,F2,F3,F4,F5,F6, FMN*38, FMT*38, FM1*38,FM2*95,
     +  CF, WORD*200, CH*2, CLN*8, NAME(40), CH4(5)*4
C  F1 is the D-file source, F3(11) the EIG-file, F4(8) the D-log,
C  F5(7) the FIXed data, F6(9) the SEEFIX (<base>.FXi) file
      CHARACTER C11,C12,C21,C22, BAR,LIN
      INTEGER NUL, WD, LPAS(99)  ! LPAS records sequence of NR settings
C              ^  Unnecessary declaration calls attention to NUL read of Blank
      REAL ZMAG(5), ZDIF(5), SE(3)
      CHARACTER(8),ALLOCATABLE :: IDENT(:)
      INTEGER,ALLOCATABLE :: KISS(:), KV(:), KZ(:), LST(:,:), LTMP(:),
     +      MISS(:), OMIT(:), WTS(:), KX(:)
      REAL,ALLOCATABLE :: T(:,:), CV(:,:), CW(:,:), AV(:), SD(:), HI(:),
     +      LOW(:), B(:,:), ZZ(:), X(:), PFRM(:,:), CVV(:,:), CINV(:,:),
     +      CB(:), CR(:), CE(:), AVV(:,:), SDD(:,:), ZHI(:),ZLO(:), F(:)
      COMMON /CF/ CF

C       PFRM(J,K):
C         J=1. Item-K sum of estimates exceeding HI
C         J=2. Item-K count of estimates exceeding HI
C         J=3. Item-K sum of estimates below LOW
C         J=4. Item-K count of estimates below LOW

      DATA C11,C12,C21,C22,BAR,LIN/'','','','','',''/
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      CUT = .0005
      OPEN(2,STATUS='SCRATCH')
      CALL SYSTEM('cls')

CC TEST LINES
C      OPEN(21,FILE='F:\JUNK')

C      | FIXDATA estimates missing scores in a HYDATA-standard datafile  |
C      | <base>.Di by iterating between their approximate regressions on |
C      | the good data and updating the data correlations from which the |
C      | regression weights are approximated.  The procedure involves    |
C      | some adjustable idealizations of the variables' loadings on     |
C      | their principal axes, and there will be running choices for     |
C      | you to make in management of those.                             |

      WRITE(6,'(6X,67A)') C11, (LIN,I=1,65), C12
      WRITE(6,'(6X,A," FIXDATA estimates missing scores in a HYDATA-s",
     +  "tandard datafile  ",A,/6X,A," <base>.Di by iteration between",
     +  " their approximate regressions on ",A/6X,A," the good data a",
     +  "nd updating the data correlations from which the ",A/6X,A,1X,
     +  "regression weights are approximated.  The procedure involves",
     +  4X,A/6X,A," some adjustable idealizations of the variables'' ",
     +  "loadings on",5X,A/6X,A," their principal axes, and there wil",
     +  "l be running choices for",5X,A/6X,A," you to make in managem",
     +  "ent of those.",29X,A)') (BAR,I=1,14)
      WRITE(6,'(6X,67A)') C21, (LIN,I=1,65), C22
      WRITE(6,'(/" The HYDATA-standard D-files available here are:")')
      CALL LOOK(1,'*.D*',NAME,40,NF)
      IF(NF==0) WRITE(6,'(/ " No D-files here.  Go get one.")')
      IF(NF==0) STOP
      NN = 1
10    F1 = NAME(NN)
      CALL CAP(F1,12)  ! Not really needed
      CALL LAST(LF1,F1,12)
13    IF(NF>1) WRITE(6,'(/" To load file ",A,", hit RETURN.  Othe",
     +  "rwise,"/" enter the index of another selection from this ",
     +  "list."/)') F1(:LF1)
      IF(NF==1) WRITE(6,'(/" Hit RETURN to continue with file ",A,
     +  ", or enter anything to abort.")') F1(:LF1) ! If only one file qualifies
      CALL SCANN(J,0,'I',5,CH)
      IF(J<0) GOTO 13
      IF(J/=0 .AND. NF==1) STOP
      IF(J>0) THEN
        READ(2,*) NN
        NN = MAX(1,MIN(NN,NF))
        GOTO 10
      END IF
      OPEN(3,FILE=F1)  ! Input D-file
C HYDATA-standard datafile xxxxxxxxxxxx: xxx variables, xxxx records; maximum ID No. xxxxxxxxx; transcribed under DEV = xxxx
C        from rawdata source xxxxxxxxxxxx; datafix xx; xxxxxxx missing scores.
      READ(3,'(A)') WORD; F3 = WORD(27:38); CALL LAST(LF3,F3,12)
      IF(F3(:LF3)/=F1(:LF1)) THEN ! ^ WORD not yet L-justified by SCAN
        WRITE(6,'("  ERROR: The name of file ",A," does not match the",
     +    " name starting its"/8X,"header line.  If this is a problem",
     +    ", hit RETURN to fix the discrepancy"/8X,"and try again.  ",
     +    "Otherwise, enter anything to continue.")') F1(:LF1)
        CALL SCANN(J,0,'B',5,CH)
        IF(J==0) STOP
      END IF
      CALL SCANN(J,4,'IIIR',-1,WORD(39:))
      READ(2,*) NV, NRC, MXID, DEV; NVV = LO(NV,NV)
      READ(3,'(A)') WORD; F2 = WORD(29:40) ; CALL LAST(LF2,F2,12) ! Rawdata filename
      CALL SCANN(J,2,'II',-1,WORD(41:))
      READ(2,*)  NFIX, MIS
      IF(MIS==0) THEN
        WRITE(6,'(/" ***** According to its header, no scores are mi",
     +    "ssing in datafile ",A,".")') F1(:LF1); NN = 1
        IF(NF==1) WRITE(6,'(7X,"Go find one that is needier.")')
        IF(NF==1) STOP
        WRITE(6,'(7X,"Try again.")'); GOTO 10
      END IF
      WRITE(6,'(/" The header of datafile ",A," reads"/)') F1(:LF1)
      WRITE(6,'(6X,"HYDATA-standard datafile ",A,": ",A," variables, ",
     +  A," records;"/6X,"largest ID, ",A,"; transcribed under DEV =",
     +  F5.1," from rawdata"/6X,"source ",A,"; datafix ",A,"; ",A,
     +  " missing scores.")') F3(:LF3), CF(:JF(NV)), CF(:JF(NRC)),
     +  CF(:JF(MXID)), DEV, F2(:LF2), CF(:JF(NFIX)), CF(:JF(MIS))

C HYDATA-standard datafile xxxxxxxxxx: xxx variables, xxxx records; largest
C ID, xxxxxxxxx; transcribed under DEV = xxxx from rawdata source xxxxxxxxxx ;
C datafix xx; xxxxxxx missing scores.
C      HYDATA-standard datafile xxxxxxxxxx: xxx variables, xxxx records;
C      largest ID, xxxxxxxxx; transcribed under DEV = xxxx from rawdata
C      source xxxxxxxxxx; datafix xx; xxxxxxx missing scores.

      WRITE(6,'(/" If this is the datafile you want, hit RETURN. ",
     +  "Otherwise,"/" enter anything to abort.")')
      CALL SCANN(J,0,'B',5,CH)
      IF(J/=0) STOP
      ALLOCATE ( IDENT(NV), AV(NV), SD(NV), HI(NV), LOW(NV), KV(NV) )
      ALLOCATE ( F(NV), KZ(NV), KISS(NV), MISS(NV), OMIT(0:NV), ZZ(NV),
     +           PFRM(4,NV), X(NV), ZHI(NV), ZLO(NV) )
      ALLOCATE ( CB(NVV), CE(NVV), CR(NVV), WTS(NVV) )
      READ(3,*,ERR=18) (IDENT(I),I=1,NV); GOTO 15
18    WRITE(6,'(/" FIXDATA has been unable to read item names from ",
     +  A," succesfully.  Why?")') F1(:LF1); STOP
15    NUL = -99; PFRM = 0.; HI = -98.; LOW = 999.; NNN = 0
      K = LF1-2; IF(F1(K:K)/='.') K = K+1
      F3 = F1(:K)//'EIG'; K = 0; CALL LAST(LF3,F3,12)
17    INQUIRE(FILE=F3,EXIST=QY)
      IF(QY .AND. K<9) THEN
        K = K+1; F3(LF3:LF3) = CHAR(48+K); GOTO 17
      END IF
      IF(QY .AND. K>=9) F3(LF3:LF3) = '0'

C Set up data registers
      ALLOCATE ( LST(NRC,2), LTMP(NV) )
      J = JF(MXID); K = JF(J); NSX = 0
      FM1 = '(I'//CF(:K)//',1X,50I3,20(:/'//CF(:K)//'X,1X,50I3))'
      FM2 = '(A,I'//CF(:K)//',":",10(1X,I3,",",A5,"(",A4,")",:";"),'//
     +      '50(/'//CF(:K)//'X,5X,10(1X,I3,",",A5,"(",A4,")",:";")))'
      READ(3,'(A)') WORD
      IF(WORD(:7)=='Rescale') THEN
        ALLOCATE ( KX(NV) )
        BACKSPACE 3
        READ(3,'(20(8X,8(2X,5I3):/))') (KX(I),I=1,NV)
        DO I = 1,NV; IF(KX(I)/=0) NSX = NSX+1; END DO
        READ(3,'(A)') WORD
      END IF
      BACKSPACE 3
      WORD(:1) = 'X'; CALL LAST(LL,WORD,LEN(WORD)) ! Start of WORD mustn't be blank
      LL = LL-J-1  ! Length of scorelist in line
      L4 = 4*MIN(45,NV)   ! ; L3 = 3*MIN(50,NV)
      WD = 3; IF(LL==L4) WD = 4
      IF(WD==4) THEN
        FM1 = '(I'//CF(:K)//',1X,45I4,20(:/'//CF(:K)//'X,1X,45I4))'
        NUL = -999; HI = -998.; LOW = 9999.
      END IF

      NREC=0; AV=0.; SD=0.     ! NREC counts number of records
      NPAT = 0; IP = 0  ! Number of miss/kiss patterns excluding all-or-none extremes
      NSOM = 0   ! NSOM counts recs with some but not all missing scores
      NALL = 0; NONE = 0  ! No. complete records; No. completely empty records
      MAXMS = 0; DLIM = 999.; WTS = 0 ! WTS(i,j) counts recs incomplete on Cov(i,j)
      NUFF = 10; CLOS = .01; BIGD = 1.; QY=.FALSE.  ! Initialize for multiple-iterations option
      CV = 0.  ! Needed in case any records are all blank
      KBYT = 4*NV+8  ! Number of bytes needed (plus 4 wiggle room) for buffer record
      OPEN(17,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +     RECL=KBYT)  ! Load all records
20    READ(3,FM1,END=22) ID, (KZ(I),I=1,NV)  ! <<< Read next record
      NREC = NREC+1;
      WRITE(17,REC=NREC) ID, (KZ(I),I=1,NV)
      DO I = 1,NV ! Omit any all-bad records
        IF(KZ(I)/=NUL) GOTO 21
      END DO
      NONE = NONE+1; GOTO 20
21    DO I = 1,NV
        IF(KZ(I)==NUL) THEN; MISS(I) = MISS(I)+1; CYCLE; END IF
        AV(I) = AV(I) + KZ(I)    ! Get means
        SD(I) = SD(I) + KZ(I)**2 ! Get SDs
      END DO  ! MISS(I) gets bad-score count for item I
      GOTO 20
22    CLOSE(3); N0 = 0  ! End of read from input datafile
      KISS = NREC-MISS ! KISS gets good-score count
      DO I = 1,NV
        D = MAX(.0001,1.*KISS(I)) ! Divisor for variance
        S = AV(I)/D; V = SD(I)/D - S*S  ! S is Mean(I) over good scores
        IF(V<.1**4) THEN ! **** Can replace OMIT throughout by WTS
          N0 = N0+1; OMIT(N0) = I ! tmp list of zero-variance items
          KISS(I) = 0   ! Mark KISS for deletion of zero-variance items
        END IF
      END DO
      OPEN(34,STATUS='SCRATCH',FORM='UNFORMATTED')
      IF(N0==0) THEN; N0 = 1; OMIT(1) = -99; END IF
      WRITE(34) MAX(1,N0), OMIT(MAX(1,N0))

C Get distribution of bad-score counts over variables from the raw count
C list in MISS
      CALL ISORT(NV,MISS)  ! ISORT is decreasing, so worst is first
      KM = 1; MM = 10**4; KZ(1) = MISS(1)*MM + 1; OMIT = 0
      DO J = 2,NV   ! Combine bad-score count with its occurrence frequency
        IF(MISS(J)==0) GOTO 72
        IF(MISS(J)==KZ(KM)/MM) THEN; KZ(KM) = KZ(KM)+1; CYCLE; END IF
        KM = KM+1; KZ(KM) = MISS(J)*MM + 1
      END DO   !   ^ KZ now holds the histogram of bad-score counts
72    K1 = (NREC-KZ(1)/MM); K2 = MOD(KZ(1),MM)
      KZ(1) =  K1*MM + K2; OMIT(1) = 3+JF(K1)+JF(K2)
      DO J = 2,KM ! Convert to cumulative good-score distribution
        K1 = (NREC-KZ(J)/MM); K2 = MOD(KZ(J-1),MM) + MOD(KZ(J),MM)
        KZ(J) = K1*MM + K2; OMIT(J) = OMIT(J-1) + 3+JF(K1)+JF(K2)
      END DO  ! REM: KM is count of terms in cum good-score list, not OMIT count
      MG = INT(NREC*.5); KF = 1  ! KF flags a display
C       KZ now lists the cum raw dist of good scores over items at points i of
C       successive increase: for each i = 1,..KM, KZ(i)/MM is no. of items
C       having MOD(KZ(i),MM) or fewer good scores. All-good is not in list
24    J = 0
25    J = J+1; IF(J<NV.AND.MG>KZ(J+1)/MM) GOTO 25; IF(KF>0) J = MAX(2,J)
      MG = KZ(J)/MM; JG=MOD(KZ(J),MM)  ! Always show at least two to start
      M=2; IF(MG==1) M=1; CH = 's ' ! 2:2 if sing; 1:2 if pl or zero
      IF(KF==0) GOTO 27  ! Only show once
      LL = 0; OMIT(KM+1) = 80    ! Want cycle test to fail when J=KM
      DO J = 1,KM   ! Find line breaks for display of good-scores cum-freq
        IF(OMIT(J+1)<=77) CYCLE
        LL = LL+1; OMIT(LL) = J ! Index to terminate line LL
        DO I = J+1,KM; OMIT(I) = OMIT(I) - OMIT(J); END DO
      END DO ! Line J goes from OMIT(J-1)+1 to OMIT(J)
      NK = MIN(4,LL); LM = OMIT(1) ! <<<< Temporary fixed NK
26    WRITE(6,'(3X,A," variables here have ",A," or less good score",A,
     +  "(",A3,"% over ",A," records)"/3X,"and at least one has only ",
     +  A,".  More specifically, here is a list of"/3X,"the ",A," sma",
     +  "llest occurent good-score counts followed in parentheses"/3X,
     +  "by the cumulative number of items having no more than that:"/
     +  )') CF(:JF(JG)), CF(:JF(MG)), CH(3-M:), CLN(MG*100./NREC,3,1),
     +  CF(:JF(NREC)), CF(:JF(KZ(1)/MM)), CF(:JF(OMIT(NK)))
      DO K = 1,NK
        WRITE(6,'(3X,20(A,"(",A,") ",:))') (CF(:JF(KZ(J)/MM)),
     +    CF(:JF(MOD(KZ(J),MM))),J=OMIT(K-1)+1,OMIT(K))
      END DO
C   xxxx variables here have  xxx or less good scores (xxx% over xxx records)
C   and at least one has only xxx.  More specifically, here is a list of
C   the xx smallest occurent good-score counts followed in parentheses by
C   the cumulative number of items having no more than that:
C   xxx(xxx) xxx(xxx)  xxx(xxx)  xxx(xxx)  xxx(xxx) xxx(xxx) xxx(xxx) xxx(xxx)
C   To suppress all imputations to/from the xxx items having at most MG = xxx
C   good scores, hit RETURN.  Otherwise, enter another choice of good-score
C   cutoff MG or any letter to waive exclusions of score-deficient items.
C   cutoff MG or any letter to exclude just the xxx items with zero variance

27    CH = 's,'; M=2; IF(MG==1) M=1  ! (Why IF(KF...?) IF(KF==0) M = MAX(1,MIN(2,MG))
      WRITE(6,'(/3X,"To suppress all imputations to/from the ",A," ite",
     +  "ms having at most MG = ",A/3X,"good score",A," hit RETURN.  O",
     +  "therwise, enter another choice of good-score")')
     +  CF(:JF(JG)), CF(:JF(MG)), CH(3-M:)
      IF(N0==0) WRITE(6,'(3X,"cutoff MG, or any letter to waive ex",
     +  "clusions of score-deficient items."/)')
      IF(NN>0) WRITE(6,'(3X,"cutoff MG, or any letter to exclude just",
     +  " the ",A," items with zero variance."/)') CF(:JF(N0))
      CALL SCANN(J,1,'I',5,CH)
      IF(J==-2) GOTO 26
      IF(J>0) THEN
        READ(2,*) N; MG = MAX(1,MIN(N,NREC-1)); KF=0; GOTO 24
      END IF
      IF(J==-1) MG = 0
      NX = 0; KOM = 0
      IF(N0+MG>0) THEN
        DO I = 1,NV ! Rem: zero-variance items are now zero in KISS
          K = 1; IF(KISS(I)<=MG) K = 0
          IF(K>0)  THEN;  NX = NX+1;  KISS(NX) = I; END IF
          IF(K==0) THEN; KOM = KOM+1; OMIT(KOM) = I; END IF
        END DO
      END IF

CCC Strip excluded items out of data records
CCC ***** Eventually, this should be made a user option
        WRITE(34) KOM, (OMIT(I),I=1,KOM)
        WRITE(34) KOM, (IDENT(OMIT(I)),I=1,KOM)  ! Retrieve for print to LOG-file
CCCC  Scratchfile 34 has three lists preceded by number in list:
CCCC    1, zero-variance items; 2, omit-item indices; 3, omit-item names
      IF(NX<NV) THEN
        DO I = 1,NX
          IDENT(I) = IDENT(KISS(I))
        END DO
        DO KR = 1,NREC
          READ(17,REC=KR) ID, (KV(I),I=1,NV)
          WRITE(17,REC=KR) ID, (KV(KISS(I)),I=1,NX)
        END DO
        NV = NX; NVV = LO(NV,NV)
      END IF
      ALLOCATE ( T(NV,NV), CV(NV,NV), CW(NV,NV), AVV(NV,2), SDD(NV,2),
     +           CVV(NVV,2), CINV(NV,NV) )
30    OPEN(33,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +     RECL=KBYT+8)  ! List pattern: MS,KS, MISS(1,..,MS), KS(1,..,KS)
C   Set up registers for iteration of estimates
      WRITE(6,'(/" Computing the data statistics needed for imputat",
     +  "ion.")')
      CW = 0.; AVV = 0.; SDD = 0.; CVV = 0.; T1 = TM(1)
      DO KR = 1,NREC
        READ(17,REC=KR) ID, (KZ(I),I=1,NV)  ! <<< Read next record
        T1 = TM(-1)  ! Reset timer 1 only after screen report
        IF(T1>6.) THEN
          WRITE(6,'(4X,"Processing score record ",A)') CF(:JF(KR))
          T1 = TM(1)  ! NOW reset timer 1
        END IF
        MS = 0; KS = 0
        DO J = 1,NV  ! Get miss/kiss pattern for this record
          IF(KZ(J)==NUL) THEN
            MS = MS+1; MISS(MS) = J
          ELSE  ! ^Bad-score/vGood-score indices in COV-file listing
            KS = KS+1; KISS(KS) = J
          END IF
        END DO
        IF(MS==0) THEN
          NALL = NALL+1; GOTO 47
        ELSE IF(MS==NV) THEN  ! Should no longer be possible
          WRITE(6,'(/" ***** Programming error: All-blank record No.",
     +      A," should have been dumped.")') CF(:JF(KR)); PAUSE
        END IF
        NSOM = NSOM+1; MAXMS = MAX(MAXMS,MS)
        OUTER:DO K = 1,NPAT  ! Determine if this is a new m/k pattern
          READ(33,REC=K) M1, N, (LTMP(J),J=1,M1)  ! Don't need KISS info
          IF(M1/=MS) CYCLE OUTER
          DO J = 1,MS
            IF(LTMP(J)/=MISS(J)) CYCLE OUTER
          END DO
          IP = K; GOTO 45   ! Current pattern matches previous pattern K
        END DO OUTER
        NPAT = NPAT+1; IP = NPAT  ! Record has new m/k pattern
        WRITE(33,REC=NPAT) MS, KS, (MISS(I),I=1,MS), (KISS(I),I=1,KS)
45      LST(NSOM,1) = KR; LST(NSOM,2) = IP

C  Startup estimates: Take mean i of good scores on each Xi for each bad
C  Xi. Collect in CW[i,j] the sum of good Xi-scores in records with bad Xj.
C  Then if [IJ], [Ij], [iJ], [ij] denote summation within cells with
C  (I)good or (i)bad scores on Xi, and (J)good or (j)bad scores on Xj, the
C  sum of both good and imputed products over all records is   XiYj =
C        ([IJ] XiXj) + (j[Ij] Xi) + (i[iJ] Xj) + ([ij] ij) =
C        ([IJ] XiXj) + (jCW[i,j]) + (iCW[j,i]) + ([ij] ij)
C  Accumulate raw stats separately for ALL (complete) and SOM (incomplete) records:
47      IF(MS==0) THEN  ! Put complete-record sums in AVV/SDD/CVV(-,2) (section 2)
          DO J = 1,NV
            HI(J) = MAX(HI(J),1.*KZ(J));  LOW(J) = MIN(LOW(J),1.*KZ(J))
            AVV(J,2) = AVV(J,2) + KZ(J)
            SDD(J,2) = SDD(J,2) + KZ(J)**2
            DO I = 1,J
              CVV(LO(I,J),2) = CVV(LO(I,J),2) + KZ(I)*KZ(J)
            END DO
          END DO
        ELSE    ! Put incomplete-record sums in AVV/SDD/CVV(-,1) (section 1)
          DO JJ = 1,KS; J = KISS(JJ)
            HI(J) = MAX(HI(J),1.*KZ(J));  LOW(J) = MIN(LOW(J),1.*KZ(J))
            AVV(J,1) = AVV(J,1) + KZ(J)
            SDD(J,1) = SDD(J,1) + KZ(J)**2
            DO II = 1,JJ; I = KISS(II)
              CVV(LOC(I,J),1) = CVV(LOC(I,J),1) + KZ(I)*KZ(J)
              WTS(LOC(I,J)) = WTS(LOC(I,J)) + 1
            END DO          !  ^ Count incomplete recs good on both items I,J
            DO II = 1,MS    ! NSOM minus this will be count bad on at least one of I,J
              I = MISS(II); CW(J,I) = CW(J,I) + KZ(J)
            END DO   ! Xj is good, Xi is bad
          END DO
          DO JJ = 1,MS    ! Count records in which Xi,Xj are both bad
            J = MISS(JJ)
            DO II = 1,JJ
              I = MISS(II);  CR(LOC(I,J)) = CR(LOC(I,J)) + 1.
            END DO
          END DO
        END IF
      END DO
      WRITE(6,'(1X,A," missing-data patterns identified."/)')
     +  CF(:JF(NPAT))
      CALL ISORT2(NSOM,LST,NRC)  ! Bad recs are indexed in LST(-,1) in increasing m/s pattern order
      IF(NREC+NONE/=NRC) THEN
CC        IF(NREC/=NRC) WRITE(6,'(" The number ",A," of records read fr",
        WRITE(6,'(" The number ",A," of records read fr",
     +    "om the input datafile does not match the"/" number ",A," cl",
     +    "aimed in its filehead.  Enter anything to continue anyway,"/
     +    " or hit RETURN to abort the run and investigate the discre",
     +    "pancy",A)') CF(:JF(NREC+NONE)), CF(:JF(NRC))
        IF(NONE>0) WRITE(6,'(" (The problem may involve the ",A,
     +    " blank records.)")') CF(:JF(NONE))
        CALL SCANN(J,0,'B',5,CH)
        IF(J==0) STOP
      END IF
      SW = 0. ! SW is sum of weights in weighted CV-change
      DO J = 1,NV  ! Initial imputation of means,SDs,normed-high,normed-low
        NJ = NINT(CR(LO(J,J)))   ! Count of records with bad scores on Xj
        AV(J) = (AVV(J,1)+AVV(J,2))/MAX(1,NREC-NJ)
        SD(J) = ((SDD(J,1)+SDD(J,2)) + NJ*AV(J)**2)/NREC - AV(J)**2
        SD(J) = SQRT(MAX(.0001,SD(J)))
        ZHI(J) = (HI(J)-AV(J))/SD(J); ZLO(J) = (LOW(J)-AV(J))/SD(J)
        CV(J,J) = 1.; WTS(LO(J,J)) = NSOM - WTS(LO(J,J)) ! Count of recs bad on item J
        DO I = 1,J-1
          NIJ = NINT(CR(LO(I,J)))  ! Count of records with bad scores on both Xi,Xj
          S = NIJ*AV(I)*AV(J) + AV(J)*CW(I,J) + AV(I)*CW(J,I)  !  imputed XiXj
          CV(I,J) = CVV(LO(I,J),1) + CVV(LO(I,J),2) + S
          CV(I,J) = (CV(I,J)/NREC - AV(I)*AV(J))/(SD(I)*SD(J))
          CV(J,I) = CV(I,J)
          WTS(LO(I,J)) = NSOM - WTS(LO(I,J)); SW = SW + WTS(LO(I,J))
        END DO       ! ^ Count of recs incomplete on at least one of I,J
        IF(NREC-NJ<=1) CV(J,J) = 0.
      END DO
      OPEN(11,FILE=F3(:LF3))
      WRITE(11,'(/" Eigenstructure information on the ",A,"-item cova",
     +  "riances imputed from datafile ",A)') CF(:JF(NV)), F1(:LF1)
      CALL DAY(11)
      WRITE(6,'(/" Solving for eigenstructure.")')
      CALL EIGS(NV,NV,CV,NV,ZZ,T,NV,1,IER,11)  ! Use ZZ for roots
      NF = NV      !  NF<NV calling LINV with this NF setting still in force
C**      NF = NV+1  !   ***^ Warning if NF<NV provision is reinstated.
C**62    NF = NF-1  ! Scan backwards from last root
C**      IF(ZZ(NF)<CUT) GOTO 62     ! NF becomes number of appreciable roots
C**      IF(NZ<=NV) THEN
      CV = 0.; CINV = 0.
      DO J = 1,NV
        DO I = 1,J
          DO K = 1,NV
            R = MAX(CUT,ZZ(K)); S = T(I,K)*T(J,K)
            CV(I,J) = CV(I,J) + S*R; CINV(I,J) = CINV(I,J) + S/R
          END DO
          CV(J,I) = CV(I,J); CINV(J,I) = CINV(I,J)
        END DO
      END DO
C**    END IF
      DO J = 1,NV
        S = SQRT(MAX(.0,ZZ(J)))
        DO I = 1,NV
          T(I,J) = S*T(I,J)
        END DO
      END DO
      WRITE(6,'(/" The complete startup scree of ",A," data-correlat",
     +  "ion eigenvalues is:")') CF(:JF(NV))
      WRITE(6,'(50(1X,3(5(1X,A4),:,2X)/))') (CLN(ZZ(I),4,3),I=1,NV)
      WRITE(11,'(/"  The initially imputed data covariances'' scree of",
     +  1X,A," eigenvalues is:")') CF(:JF(NV))
      WRITE(11,'(50(1X,3(5(1X,A4),:,2X)/))') (CLN(ZZ(I),4,3),I=1,NV)
      DO K = 6,11,5
        WRITE(K,'(/"  Each eigenvalue is the sum of squared item coe",
     +    "fficients on the corresponding"/"  normalized (unit-varia",
     +    "nce) principal axis of the data variables.")')
      END DO
      WRITE(6,'(/" Hit RETURN to continue.")'); READ(5,'()')
      ALLOCATE ( B(MAXMS,NV) )

C     FIXDATA imputes missing scores in each incomplete record from the
C good scores therein by estimating their components in the space of the
C data variables' non-negligible principal axes (normalized eigenvectors)
C extracted from the imputed data covariances.  You start this process,
C which iterates between estimating bad scores and updating the covariances,
C with a lower-bound guess at how many leading axes best minimizes the
C number NR retained while not losing any that can estimate an appreciable
C part of any item on which scores are missing.  Your initial NR can and
C should be increased as the iteration proceeds.
C     To assist your choice of NR, you will receive information about how
C these items load on their principal axes, briefly on screen and more
C extensively in textfile xxxxxxx.EIG.  You may, but need not, break off
C this run to examine its EIG-report before making your first choice of NR.

      DO K = 6,11,5
        WRITE(K,'(/5X,"FIXDATA imputes missing scores in each incomple",
     +   "te record from the"/" good scores therein by estimating thei",
     +   "r components in the space of the"/" data variables''s non-ne",
     +   "gligible principal axes (normalized eigenvectors)"/" extract",
     +   "ed from the imputed data covariances.  You start this proces",
     +   "s,"/" which iterates between estimating bad scores and updat",
     +   "ing the covariances,"/" with a lower-bound guess at how many",
     +   " leading axes best minimizes the "/" number NR retained whil",
     +   "e not losing any that can estimate an appreciable"/" part of",
     +   " any item on which scores are missing.  Your initial NR can"/
     +   " and should be increased as the iteration proceeds.")')
      END DO
      WRITE(6,'(/5X,"To assist your choice of NR, you will receive in",
     +  "formation about how"/" these items load on their principal ",
     +  "axes, briefly on screen and more"/" extensively in textfile ",
     +  A,".  You may, but need not, break off "/" this run to examin",
     +  "e its EIG-report before making your first choice of NR.")')
     +  F3(:LF3)
      WRITE(6,'(/" Hit RETURN to continue.")'); READ(5,'()')
      L2 = 0; L3 = 0; NR = 0
      DO J = 1,NV
        N2 = 0; N3 = 0; N = 0
        DO I = 1,NV
          Q = ABS(T(I,J))
          IF(Q>.20) N2=N2+1; IF(Q>.30) N3=N3+1; IF(Q>.25) N=N+1
        END DO
        IF(N3 >= 3) L3=J; IF(N2 >= 2) L2=J; IF(N >= 2) NR=J
      END DO

C     For computational efficiency and robust estimation, FIXDATA ignores
C axes on which item loadings are negligible.  Specifically, for your choice
C of retention count NR, it estimates just the components of missing scores
C in the data's most prominent NR-dimensional subspace.  Pending more study
C of how choice of NR affects results, a provisional rule of thumb is that
C NR should initially exclude axes which have less than two item loadings
C over .20 in size but not exclude any with at least three over .30.
C According to this rule you should here start with NR between xx and xx;
C while xx, the weakest axis on which two exceed .25, is offered as default.
C On subsequent passes, you will be invited to increase NR in light of
C updated information on residuals and imputation performance.  (NOTE:
C Early returns suggest that in practice, results are rather insensitive
C to the path on NR prior to your final choice of this.)

      KL = 11 ! If branchback, KL = 6
68    DO K = 6,KL,5
      WRITE(K,'(/5X,"For computational efficiency and robust estimat",
     +  "ion, FIXDATA ignores"/" axes on which item loadings are neg",
     +  "ligible.  Specifically, for your choice"/" of retention cou",
     +  "nt NR, it estimates just the components of missing scores"/
     +  " in the data''s most prominent NR-dimensional subspace.  Pen",
     +  "ding more study"/" of how choice of NR affects results, a pr",
     +  "ovisional rule of thumb is that"/" NR should initially exclu",
     +  "de axes which have less than two item loadings"/" over .20 ",
     +  "in size but not exclude any with at least three over .30."/
     +  " According to this rule you should here start with NR betwe",
     +  "en ",A," and ",A,","/" while ",A,", the weakest axis on whi",
     +  "ch two exceed .25, is offered as default."/" On subsequent p",
     +  "asses, you will be invited to increase NR in light of"/" upd",
     +  "ated information on residuals and imputation performance.  ",
     +  "NOTE:"/" Early returns suggest that in practice, results are",
     +  " rather insensitive"/" to the path on NR prior to your final",
     +  " choice of this."/)') CF(:JF(L3)), CF(:JF(L2)), CF(:JF(NR))
      END DO
      WRITE(6,'(/" Hit RETURN to continue")')
      READ(5,'()')
      WRITE(11,'(/" In the following listings, each term of form "" J",
     +  ": Count(Av) "" states that loadings"/" on axis J larger than",
     +  " the stipulated CUT are Count in number with mean size Av.")')
      CALL KOUNT(NV,NV,T,NR,CE,1)

C At this point you can either
C    1) Pick an initial number NR of imputation axes and begin score fix.
C    2) Exit to consult additional information written to file xxxxx.EIG
C    3) Review the on-screen information just inspected.
C Enter the index of your preference.
70    WRITE(6,'(/" At this point you can either"/4X,"1) Pick an ini",
     +  "tial number NR of imputation axes and begin score fix"/4X,
     +  "2) Exit to consult additional information written to file ",
     +  A/4X,"3) Review the on-screen information just examined."/
     +  " Enter the index of your preference."/)') F3(:LF3)
      CALL SCANN(J,0,'I',5,CH)
      KL = 6; IF(J<=0) GOTO 70
      READ(2,*) JB; IF(JB<1 .OR. JB>3) GOTO 70
      IF(JB==3) GOTO 68
      IF(JB==2) GOTO 80
75    WRITE(6,'(3X,"Hit RETURN to approve retention of NR = ",A,1X,
     +  "principal axes.  Otherwise"/3X,"enter another choice of NR",
     +  ", or any letter to reconsider your options."/)') CF(:JF(NR))
      CALL SCANN(J,0,'I',5,CH)
      IF(J<0) GOTO 70
      IF(J==0) GOTO 82
      READ(2,*) NR; NR = MAX(1,MIN(NR,NV)); GOTO 75
80    WRITE(6,'(/" Filing additional information in ",A,
     +  " . . . . ."/)') F3(:LF3)             ! CR passed for workspace
      CALL GETINFO(NV,NV,L3,L2,ZZ,T,CE,CR,0)  ! T is pattern, not eivecs
      WRITE(6,'(/" Information file ",A," is ready for inspecti",
     +  "on.  Come back soon.")') F3(:LF3); STOP
82    DO J = 1,NV  ! Initialize backfile for change comparison
        DO I = 1,J
          CB(LO(I,J)) = CV(I,J)
        END DO
      END DO
      F5 = F1; CALL NAME1(F5,F4,7,LF4)  ! F5 now the FIXed data name, F4 the D-Logfile
      CALL LAST(LF5,F5,12)
      OPEN(8,FILE=F4)
      CALL FNDEND(8,0); NPASS = 0
      WRITE(8,'(/40("<>")/" New datafile ",A,": FIXDATA estimates of ",
     +  "missing scores in datafile ",A," by"/" multiple regressions ",
     +  "among its ",A," items.")') F5(:LF5), F1(:LF1), CF(:JF(NV))
      CALL DAY(8)
      LM = 3
      DO I = 1,NV
        CALL LAST(N,IDENT(I),8); LM = MAX(LM,N)
      END DO
      N = 125/(6+LM)   ! Number of fields per line
      FMT = '(80(1X,'//CF(:JF(N))//'(I4,": ",A),:/))'//'      '
      IF(KOM==0) WRITE(8,'(/" The variables are named")')
      IF(KOM>0) WRITE(8,'(/" The list of variables after omission of ",
     +  "useless items (",A," with zero variance,"/1X,A," with fewer ",
     +  "than ",A," good scores) is")') CF(:JF(N0)), CF(:JF(KOM-N0)),
     +  CF(:JF(MG))
      WRITE(8,FMT) (I,IDENT(I)(:LM),I=1,NV)
      IF(KOM>0) THEN  ! If no zero-var items, 1st line is 1,-99
        REWIND 34; READ(34) I ! Number of zero-var items (followed by list not now used)
        READ(34) KOM, (OMIT(I),I=1,KOM)  ! Original omitted-item indices
        READ(34) KOM, (IDENT(I),I=NX+1,NX+KOM)
        WRITE(8,'(/" Useless items (with their indices in ",A,
     +    ") excluded from these imputations:")')
        WRITE(8,FMT) (OMIT(I),IDENT(NX+I)(:LM),I=1,KOM)
      END IF
CCC      F6 = 'SEEFIX.1  '; K = 1
      LF6 = LF4; F6 = F4(:LF4-3)//'FX1'; K = 1
91    INQUIRE(FILE=F6,EXIST=QY)
CCC      IF(QY .AND. K<=99) THEN
      IF(QY .AND. K<=9) THEN
        K = K+1; F6(LF6:LF6) = CF(:JF(MOD(K,10)))
        IF(K<10) GOTO 91
      END IF
CCC      LF6 = 7+JF(K)
cc      F7 = F6; F7(:6) = 'FIXBUF'; LF7 = LF6   ! Not installed at present
      OPEN(9,FILE=F6)  ! QY is now free for other use
      QY = .FALSE.   ! ??? Initialization for automated iterations??
      WRITE(9,'(/" Uncropped estimates of Z-scores (sigma distance a",
     +  "bove mean) of bad scores in datafile ",A,".")')  F1(:LF1)
      CALL DAY(9)
      WRITE(9,'(/" The variables are named")')
      WRITE(9,FMT) (I,IDENT(I)(:LM),I=1,NV)
Cxx      OPEN(13,FILE=F7,FORM='UNFORMATTED')  ! FIXBUF store of imputed covariances
Cxx      WRITE(13) NV, NVV, F1(:LF1), F6(:LF6), (WTS(I),I=1,NVV)  ! Don't really need to save SEEFIX name
Cxx      WRITE(13) 0, 0, (AV(I),I=1,NV), (SD(I),I=1,NV), (CB(I),I=1,NVV)
      I = TM(3)  ! Initialize global timer

C Ready to roll
      WRITE(8,'(/" The data correlations'' first ",A," eigenvalues",
     +  " are:")') CF(:JF(NR))
      WRITE(8,'(20(4(2X,5A5,:)/))') (CLN(ZZ(I),5,-2),I=1,NR)
      WRITE(9,'(/" Reported below are the estimates of missing scores",
     +  " on successive passes: Each"/" entry starts with the ID of a",
     +  "n incomplete data record and lists the index of"/" each scor",
     +  "e missing from this record followed by that score''s untrimm",
     +  "ed Z-scale"/" estimate with its approximate standard error a",
     +  "ppended in parentheses.  When"/" needed, trimming is to the ",
     +  "nearest extreme in the good-score distribution on"/" this ",
     +  "item.")')
      WRITE(9,'(/" NOTE: Records are generally listed in ID order onl",
     +  "y within blocks having the"/7X,"same pattern of missing scor",
     +  "es.  Each Pass runs these patterns in their"/7X,"order of se",
     +  "tup encounter, but all records with the same pattern (here"/
     +  7X,"flagged after the first in each block by "" + "") are pro",
     +  "cessed before"/7X,"the next pattern is run.")')

C >>>>> Fileheads are written; now estimate missing data in each record
C working from the reduced D-file's internal storage
C ******** Re-enter here for passes after the 1st
500   NPASS = NPASS+1; WORD(:3) = ''; PFRM = 0.; I=TM(1); I=TM(2)
      WRITE(6,'(/" Commencing datafix pass ",A)')CF(:JF(NPASS));J=JF(NR)
      WRITE(9,'(/" ",A,"Ŀ")') WORD(:J)
      WRITE(9,'( "   Pass",I3,", NR = ",A,"  ",72(""))') NPASS,CF(:J)
      WRITE(9,'( " ",A,"")') WORD(:J)
      IF(NPASS<=99) LPAS(NPASS) = NR
      IF(QY .AND. BIGD<=.05) WRITE(9,'(/" New automated-iteration",
     +  "estimates omitted: last pass was nearly convergent.")')
      NN=0; MMIS=0; NFAIL=0; IP=0; F=0.; NTRM = 0  ! ; ERV = 0.
      ZMAG=0.; ZDIF=0.; LARG=0; SE=0.; KNT=0  ! KNT counts successful imputations
      DO J = 1,NV        ! Put the NR-axes part of the latest CV in CR
        DO I = 1,J       ! and the NR-residual covars from latest CV in CE
          S = 0.
          DO K = NR+1,NV
            S = S + T(J,K)*T(I,K)
          END DO
          CE(LO(I,J)) = S    ! Don't really need full CE; variances suffice??
          CR(LO(I,J)) = CB(LO(I,J)) - S   ! Could just as well use CV for CB
        END DO
      END DO
      WRITE(9,'(/" Variances of the normed items excluded from esti",
     +  "mation space on this pass:",20(/1X,3(5(1X,A4):2X)))')
     +  (CLN(CE(LO(I,I)),4,3),I=1,NV)
      S = 0.; M = 0
      DO I = 1,NV
        F(I) = 1/MAX(.000001,CINV(I,I))
        K = WTS(LO(I,I)); S = S + F(I)*K; M = M+K
      END DO
      WRITE(9,'(/" Variances of the normed items orthogonal to all t",
     +  "he others (imputation-weighted mean = ",A4,"):",20(/1X,3(5(1X,
     +  A4):2X)))') CLN(S/M,4,3), (CLN(F(I),4,3),I=1,NV)
      WRITE(9,'(/" The corresponding dataspace-uniqueness SDs are",
     +  20(/1X,3(5(1X,A4):2X)))') (CLN(SQRT(F(I)),4,3),I=1,NV)
      IF(NF<NV) WRITE(9,'(/" Imputation weights will be found by L-i",
     +  "nersion: Imputed item space has nullity ",A)') CF(:JF(NV-NF))
      WRITE(9,'()')
      DO J = 1,NV  ! Re-initialize adjustable accumulations, renorm HI,LOW
        AVV(J,1) = 0.; SDD(J,1) = 0.
        DO I = 1,J
          CVV(LO(I,J),1) = 0.
        END DO
        ZHI(J) = (HI(J)-AV(J))/SD(J); ZLO(J) = (LOW(J)-AV(J))/SD(J)
      END DO
100   NN = NN+1  ! Fix next bad record.
      KREC = LST(NN,1); CH = '+ '
      IF(LST(NN,2)==IP) GOTO 120  ! B-weights already computed; start estimatin
      IP = IP+1; B = 0.; CH = '  '  ! Start computation of B for next pattern
      T1 = TM(-1)  ! Don't reset timer 1 yet
      IF(T1>3.) THEN
        WRITE(6,'(4X,"Starting imputation for bad-score pattern ",A)')
     +    CF(:JF(IP)); T1 = TM(1)  ! NOW reset timer 1
      END IF
      READ(33,REC=IP) MS, KS, (MISS(I),I=1,MS), (KISS(I),I=1,KS)
      EER = 0.
105   METH=1; IF(KS<=MS) METH=2; IF(NF<NV.OR.EER>.05) METH = 3
      IF(METH<3) THEN  ! CV for all NV items has good inverse
        CW = CV   ! Pass CV in CW for test
        IF(KS>MS) CALL INV1(NV,KS,MS,KISS,MISS,CINV,CW,CUT,EER)  ! Return inverse of
        IF(KS<=MS) CALL INV2(NV,KS,KISS,CV,CW,CUT,EER)           ! KISS covars in CW
        IF(EER>.05) GOTO 105
C Get B(MISS,KISS) = T(MISS,F)*T(KISS,F)'*Inv[CV(KISS,KISS)] = CR(MISS,KISS)*CW
        DO I = 1,MS  !     ^         ^ F above is NR leading prin-axes
          DO J = 1,KS
            DO K = 1,KS
              B(I,J) = B(I,J) + CR(LOC(MISS(I),KISS(K)))*CW(K,J)
            END DO
          END DO
        END DO
      ELSE
        CALL LINV(KS,NF,T,NV,KISS,CW,CUT,N0,IER)
        IF(IER>0) GOTO 120   !  ^ returns the transposed L-inverse of pattern T
C Estimated MISS-scores Y are MISS rows of pattern T times Linv(T) times column
C of KISS scores X: Yi = T(MISS(i),_)*CW'(_,_)*ZZ(KISS(_)).  That is, the ith
C Y-item's factor coeffs are row MISS(i) of T, so its structural coefficients
C on X are b = T(MISS(i),-)*CW'.
        DO I = 1,MS
          DO J = 1,KS  ! First, get the unpolished struct.coeffs. of MISS on KISS
            DO K = 1,NR           !  Linv[T( ,KISS) = CW': NRxKS
              B(I,J) = B(I,J) + T(MISS(I),K)*CW(J,K)
            END DO
          END DO
        END DO
      END IF
C   Adjust weights B for full-space regression and find SE of imputations:
C   First get the covar Ciz of NR-space component m(i) of MISS(i) with z =def
C   b(i)X(KISS), and the full-space variance Vz of z.  Then s = Ciz/Vz is the
C   regression coeff of m(i) on b(i)X(KISS) and the improved imputation of
C   m(i) from KISS is s*z = sb(i)X(KISS) with accounted-for variance sCiz.
C   NOTE: Because the predictors do not generally lie fully in NR-space, this
C   accounted-for variance is less than the variance of m(i) in NR-space
      DO I = 1,MS
        CZ = 0.; VZ = 0.
        DO J = 1,KS
          CZ = CZ + B(I,J)*CR(LOC(MISS(I),KISS(J)))      ! Ciz
          DO K = 1,KS
            VZ = VZ + B(I,J)*CV(KISS(J),KISS(K))*B(I,K)  ! Vz
          END DO
        END DO
        S = CZ/VZ      ! Regres coeff of Ith Miss item on B(I,Kiss)*Z(Kiss)
        DO J = 1,KS           ! Adjusted imputation weights (shouldn't
          B(I,J) = S*B(I,J)   !   matter for NF=NV computation of B)
        END DO
        F(I) = MAX(0.,1.-S*CZ)  ! Expected Err-sq of estimate
C             Exp err  ^  is resid var in NR-space plus var on discarded axes
      END DO
C   Estimate scores missing in record KREC
120   READ(17,REC=KREC) ID, (KV(I),I=1,NV)
      IF(IER>0) THEN
         NFAIL = NFAIL+1; MMIS = MMIS+MS; GOTO 175
      END IF
      KNT = KNT+MS; NNN = NNN+MS
      X = 0.; LTMP = 0
      ZZ = 0.
      DO JJ = 1,KS  ! Z-scaling of good data in NV-space
        J = KISS(JJ); ZZ(J) = (KV(J)-AV(J))/SD(J)
      END DO
      DO I = 1,MS
        IF(NPASS>1) LTMP(I) = (ABS(KV(MISS(I)))/1000) - 5000   ! Retrieve last Z-est times 100
        DO J = 1,KS  ! Impute bad datum Z-scaled in NV-space
          X(I) = X(I) + B(I,J)*ZZ(KISS(J))
        END DO
        D = ABS(X(I)); ZMAG(1) = ZMAG(1) + D; ZMAG(2) = ZMAG(2) + D*D
        IF(D>ZMAG(3)) THEN
          ZMAG(3) = D; ZMAG(4) = KREC; ZMAG(5) = MISS(I)
        END IF
C Record excesses before trimming to limits
        IF(IER>0) GOTO 175
        IF(X(I)>ZHI(MISS(I))) THEN
          PFRM(1,MISS(I)) = PFRM(1,MISS(I)) + X(I)
          PFRM(2,MISS(I)) = PFRM(2,MISS(I)) + 1.; NTRM = NTRM+1
        ELSE IF(X(I)<ZLO(MISS(I))) THEN
          PFRM(3,MISS(I)) = PFRM(3,MISS(I)) + X(I)
          PFRM(4,MISS(I)) = PFRM(4,MISS(I)) + 1.; NTRM = NTRM+1
        END IF
      END DO    ! ******** See <base>.FXi for ID and estimates going wrong
      WRITE(9,FM2) CH, ID, (MISS(K), CLN(X(K),5,2), CLN(SQRT(F(K)),
     +  4,3),K=1,MS)
      DO I = 1,MS  ! Trim estimates within input-data limits
        X(I) = MAX(ZLO(MISS(I)),MIN(ZHI(MISS(I)),X(I)))
      END DO
C
C Update score estimates in buffer file, compile raw revised statistics
      DO K = 1,MS
        IY = MISS(K)  ! Index of the Kth variable in MISS
        S = .01*LTMP(K); D = X(K)-S
        IF(ABS(D)>DLIM) THEN  ! DLIM limits change in X = old(S) + change(D)
          X(K) = S + SIGN(DLIM,D); LARG = LARG+1; D = X(K)-S  ! Need revised D
        END IF
        D = D*SIGN(1.,S)  ! Prior-directed shift
        ZDIF(1) = ZDIF(1)+D; ZDIF(2) = ZDIF(2)+D*D
        IF(D>ZDIF(3)) THEN
          ZDIF(3) = D; ZDIF(4) = KREC; ZDIF(5) = IY
        END IF
        KV(IY) = NINT(X(K)*SD(IY)+AV(IY))
      END DO
      DO J = 1,NV
        AVV(J,1) = AVV(J,1) + 1.*KV(J)
        SDD(J,1) = SDD(J,1) + 1.*KV(J)*KV(J)
        DO I = 1,J
          CVV(LO(I,J),1) = CVV(LO(I,J),1) + 1.*KV(I)*KV(J)
        END DO
      END DO
      DO II = 1,MS
        I = MISS(II); MZ = 5000+NINT(100*X(II)); S = SQRT(F(II))
        KV(I) = SIGN(ABS(KV(I))+MZ*1000,KV(I))  ! Store Z-value with imputation
        SE(1) = SE(1)+S; SE(2) = SE(2)+F(II); SE(3) = SE(3)+1
      END DO
      GOTO 180
175   DO I = 1,MS
        KV(MISS(I)) = -99    ! Score estimation failed (never happens?)
      END DO
180   WRITE(17,REC=KREC) ID, (KV(I),I=1,NV)
      IF(NN<NSOM) GOTO 100   ! Do next record with missing scores

C Compute revised statistics, and re-estimate
      NN = NALL + NSOM - NFAIL
      BIGD = 0; AVD = 0.; ED = 0; AVW = 0.; EW = 0
      DO J = 1,NV
        AVV(J,1) = (AVV(J,1)+AVV(J,2))/NN
        SDD(J,1) = (SDD(J,1)+SDD(J,2))/NN - AVV(J,1)**2   ! Var(J)
        SDD(J,1) = SQRT(MAX(.0001,SDD(J,1)))              ! SD(J)
        CVV(LO(J,J),1) = 1.0
        DO I = 1,J-1
          CVV(LO(I,J),1) = ( (CVV(LO(I,J),1)+CVV(LO(I,J),2))/NN -
     +      (AVV(I,1)*AVV(J,1))); C1 = CVV(LO(I,J),1)  ! Raw-scale Cov estimate
          R = C1/(SDD(I,1)*SDD(J,1)); CVV(LO(I,J),1) = R
          D = (CB(LO(I,J))-R)*SIGN(1.,R)  ! Corr error not corrected for imputation SD
          AVD = AVD+D; ED = ED+D*D; BIGD = MAX(BIGD,ABS(D))
          S = WTS(LO(I,J))*D; AVW = AVW + S; EW = EW + S*D
        END DO
      END DO
      NUF = MAX(0,NUF-1)               ! <<<<< Where does this matter ???
      IF(BIGD>CLOS .AND. NUF>0) THEN   ! <<<<< Job 3; but only affects print
        DO J = 1,NSOM
          BACKSPACE 9
        END DO
202     BACKSPACE 9; BACKSPACE 9
        READ(9,'(A)') CH
        IF(CH/=' ') GOTO 202
        WRITE(9,'(/" [ Imputed scores are not recorded on automated p",
     +    "asses prior to the last in series.",7X,"]"/" [ Excluded va",
     +    "riance residuals, unchanged throughout the series, are rep",
     +    "orted at its end. ]")')
      END IF
      N = NVV-NV; AVD = AVD/N; ED = SQRT(ED/N); CINV = 0.
      AVW = AVW/SW; EW = SQRT(EW/SW)
      DO J = 1,NV
        AV(J) = AVV(J,1); SD(J) = SDD(J,1)
        DO I = 1,J
          CV(I,J) = CVV(LO(I,J),1); CV(J,I) = CV(I,J)
          CB(LO(I,J)) = CV(I,J)
        END DO
      END DO
      CALL EIGS(NV,NV,CV,NV,ZZ,T,NV,1,IER,11)  ! Use ZZ for roots
      NF = NV+1
205   NF = NF-1
      IF(ZZ(NF)<CUT) GOTO 205   ! Roots after the NFth are negligible
CC      IF(NF==NV) THEN
        DO J = 1,NV
          DO I = 1,J
            DO K = 1,NV
              CINV(I,J) = CINV(I,J) + T(I,K)*T(J,K)/MAX(CUT,ZZ(K))
            END DO
            CINV(J,I) = CINV(I,J)
          END DO
        END DO
CC      END IF
      DO J = 1,NV
        IF(ZZ(J)>.02) NL = J  ! NL is upper end of default GETINFO range
        S = SQRT(MAX(0.,ZZ(J)))
        DO I = 1,NV   ! Convert T to prin-axis pattern
          T(I,J) = T(I,J)*S
        END DO
      END DO
      T1=TM(2); F = ZZ  ! ; CW = T   ! Save for exit GETINFO (No longer seems needed)
      WRITE(6,'(/" Ending Pass ",A," (NR = ",A,"), the revised COV''s",
     +  " complete eigenvalue scree is:")') CF(:JF(NPASS)), CF(:JF(NR))
      WRITE(6,'(50(1X,3(5(1X,A4),:,2X)/))') (CLN(ZZ(I),4,2),I=1,NV)
      WRITE(11,'(//" >>>>> Pass ",A,", NR = ",A," ",72(""))')
     +  CF(:JF(NPASS)), CF(:JF(NR))
      WRITE(11,'(/" Ending Pass ",A,", the revised COV''s complete s",
     +  "cree of ",A," eigenvalues is:")') CF(:JF(NPASS)), CF(:JF(NV))
      WRITE(11,'(50(1X,3(5(1X,A5),:,2X)/))') (CLN(ZZ(I),5,3),I=1,NV)
      WRITE(11,'(/" Time of this pass: ",A4," seconds")') CLN(T1,4,3)
      ZMAG(1)=ZMAG(1)/KNT; ZMAG(2)=SQRT(ZMAG(2)/KNT)
      ZDIF(1)=ZDIF(1)/KNT; ZDIF(2)=SQRT(ZDIF(2)/KNT)
      IF(.NOT.QY) CALL WAIT(0)
      DO M = 1,3  ! Report on-screen and in both SEE-files
        KF = 6; IF(M==2) KF = 9; IF(M==3) KF = 11
        WRITE(KF,'(/"  Size of the standardized covariance changes re",
     +    "sulting from Pass ",A," (NR = ",A,"):"/5X,"Measures ""dif",
     +    "f"" give equal weight to each unsigned Cov(i,j) change"/5X,
     +    "(excluding variances); their counterparts that weigh each ",
     +    "change by"/5X,"the number of imputations affecting it are",
     +    " appended in parentheses."/"  Mean diff = ",A4," (",A4,")",
     +    3X,"RMS diff = ",A4," (",A4,")",3X,"Maximum diff = ",A4)')
     +    CF(:JF(NPASS)), CF(:JF(NR)), CLN(AVD,4,3), CLN(AVW,4,3),
     +    CLN(ED,4,3), CLN(EW,4,3), CLN(BIGD,4,3)

C  Size of the standardized covariance changes resulting from Pass xx (NR = xx):
C     Measures "diff" give equal weight to each unsigned Cov(i,j) change
C     (excluding variances); their counterparts that weight each change by
C     the number of imputations affecting it are appended in parentheses.
C  Mean diff = .xxx (.xxx)   RMS diff = .xxx (.xxx)   Maximum diff = .xxx

        IF(KF/=6) WRITE(KF,'(/5X,"Mean, RMS, and Maximum size of the",
     +    "se imputed Z-scores (untrimmed):"/10X,"Mean = ",A4,3X,
     +    "RMS = ",A4,3X,"Max = ",A4," (Rec ",A,", Item ",A,")")')
     +    (CLN(ZMAG(I),4,3),I=1,3), (CF(:JF(NINT(ZMAG(I)))),I=4,5)
        IF(KF==6) WRITE(KF,'()')
        WRITE(KF,'(5X,"Mean, RMS, and largest size of the imputed Z-sc",
     +    "ore changes (",A," trimmed):"/10X,"Mean = ",A4,3X,"RMS = ",
     +    A4,3X,"Max = ",A4," (Rec ",A,", Item ",A,")")') CF(:JF(NTRM)),
     +    (CLN(ZDIF(I),4,3),I=1,3), (CF(:JF(NINT(ZDIF(I)))),I=4,5)
      END DO
C     Mean, RMS, and Maximum size of the imputed scores (untrimmed):
C     Mean, RMS, and largest size of the imputed-score changes (xxx trimmed):
C        Pass xxx:    Mean = x.xx    RMS = x.xx    Max = x.xx
C          ( Number of changes clipped to previous Max: x )

C Changes in the data covariances resulting from Pass xx:
C     Mean size of diff = .xxx   RMS diff = .xxx   Maximum diff = .xxx
C
C     Mean, RMS, and Maximum size of these imputed Z-scores (untrimmed):
C          Mean = .xxx   RMS = .xxx   Max = x.xx (Rec xxx, Item xx)
C     Mean, RMS, and largest size of the imputed Z-score changes (trimmed):
C          Mean = .xxx   RMS = .xxx   Max = .xxx (Rec xxx, Item xxx)
C          ( Number of changes clipped to previous Max: xx )
c >>> Note: Max clipped diff here can be larger than the untrimmed difference
c >>>       because clips can expand an unclipped difference
C     Distribution of these imputations' estimated Z-scale standard errors:
C               Mean SE = xxxx     Standard Deviation = xxxx

      IF(LARG>0) WRITE(9,'(10X,"( Number of changes clipped to prev",
     +  "ious Max: ",A," )")') CF(:JF(LARG))
      SE(1) = SE(1)/SE(3); SE(2) = SQRT(SE(2)/SE(3) - SE(1)**2)
      WRITE(9,'(5X,"Distribution of these imputations'' estimated Z-",
     +  "scale standard errors:"/15X,"Mean SE = ",A4,5X,"Standard de",
     +  "viation = ",A4)') CLN(SE(1),4,3), CLN(SE(2),4,3)
      IF(QY.AND.NUF>0) GOTO 500  ! OK ???

C    1. Do another pass with NR = xx.
C    2. View the loading strengths on trailing axes, maybe increase NR.
C    3. Set stopping criteria for iteration of passes without intervention.
C    4. Generate the completed datafile and quit.  (xxx passes completed).
C    5. Quit without recording the completed datafile.

      JOB = 1
210   CH4 = '    '; CH4(JOB) = ' >> '; QY = .FALSE.
211   WRITE(6,'(/"  At this point, you may"/A,"1. Do another pass wit",
     +  "h NR = ",A,"."/A,"2. View the loading strengths on trailing ",
     +  "axes, maybe increase NR."/A,"3. Set stopping criteria for it",
     +  "eration of passes without intervention."/A,"4. Generate the ",
     +  "completed datafile and quit.  (",A," passes completed.)"/A,
     +  "5. Quit without recording the completed datafile.")') CH4(1),
     +  CF(:JF(NR)),(CH4(I),I=2,4), CF(:JF(NPASS)), CH4(5)
      WRITE(6,'(/" To execute Option",I2,", hit RETURN.  Otherwise, ",
     +  "enter another from this list."/)') JOB
      CALL SCANN(J,0,'I',5,CH)
      IF(J<0) GOTO 211
      IF(J>0) THEN
        READ(2,*) I; JOB = MAX(1,MIN(5,I)); GOTO 210
      END IF
      IF(JOB==4) GOTO 260
      IF(JOB==5) THEN
CC        WRITE(8,'(/" >>>>> No go: This FIXDATA run was terminated with",
CC     +    "out saving the imputed datafile.")')
216     BACKSPACE 8; BACKSPACE 8
        READ(8,'(A)') CH
        IF(CH/='<>') GOTO 216
        BACKSPACE 8; ENDFILE 8; CLOSE(8)
        CLOSE(4,STATUS='DELETE')
        WRITE(9,'(/" >>>> The imputations reported above have NOT be",
     +    "en saved (no D-file).")')
        WRITE(6,'(/" To record imputationally current information a",
     +    "bout trailing covariance"/" residuals before exiting, en",
     +    "ter anything.  Otherwise, hit RETURN.")')
        CALL SCANN(J,0,'B',5,CH)
cc        IF(J/=0) T = CW  ! Restore last full eigensolution no longer needed
        IF(J/=0) CALL GETINFO(NV,NV,NR,NL,F,T,CW,CE,NPASS)    ! CE passed for workspace
        WRITE(6,'(/" **** Your report on residuals is in file ",A,
     +    ", while running details"/6X,"on the iterated imputations",
     +    " are in ",A,".  Come back soon.")') F3(:LF3), F6(:LF6)
        STOP
      END IF
      IF(JOB==1) THEN
        IF(BIGD <= CLOS) THEN  ! ****** Make score change the criterion instead?
          WRITE(6,'(6X,"The latest changes are quite small, so enter a",
     +      "nything to confirm"/6X,"that you indeed want another pass",
     +      ".  Otherwise, hit RETURN to file"/6X,"results and quit.")')
          CALL SCANN(J,0,'B',5,CH)
          IF(J==0) GOTO 260
        END IF
        GOTO 500
      ELSE IF(JOB==2) THEN
        N = NR
        CALL KOUNT(NV,NV,T,NR,CE,0)    ! T is new pattern, not eigvecs
        JOB = 1; IF(NR>N) DLIM = 999.
        GOTO 210
      ELSE  ! JOB = 3  $$$$$$$ How is this acted on ????

C     If you approve, FIXDATA will iterate estimation passes without pause
C     for continuation approval until either the maximum COV change (that
C     is, in a data covariance computed with estimates of missing scores)
C     is smaller than CLOSE or a limit of NUFF passes has been executed.
C     To start the iteration with CLOSE = xxx and NUFF = xxx, hit RETURN.
C     Otherwise, enter one or both of your preferences for CLOSE (in unit
C     interval) and NUFF (integer), or any letter to abort this iteration.

        WRITE(6,'(5X,"If you approve, FIXDATA will iterate estimatio",
     +    "n passes without pause"/5X,"for continuation approval unt",
     +    "il either the maximum COV change (that"/5X,"is, in a data",
     +    " covariance computed with estimates of missing scores)"/5X,
     +    "is smaller than CLOSE or a limit of NUFF passes have been",
     +    " executed.")')
        NUF = NUFF
225     WRITE(6,'(/5X,"To start the iteration with CLOSE =",A5," and",
     +    " NUFF = ",A,", hit RETURN."/5X,"Otherwise, enter one or b",
     +    "oth of your preferences for CLOSE (in unit"/5X,"interval)",
     +    " and NUFF (integer), or any letter to abort this iteratio",
     +    "n."/)') CLN(CLOS,5,3), CF(:JF(NUF))
        CALL SCANN(J,0,'R',5,CH)
        IF(J<0) GOTO 210
        IF(J==0) THEN; QY = .TRUE.; GOTO 500; END IF
        READ(2,*) (F(I),I=1,J)
        DO I = 1,J
          IF(F(I)<=0.) GOTO 225
          IF(F(I)<1.) CLOS = F(I)
          IF(F(I)>=1.) THEN
            IF(F(I)==ANINT(F(I))) THEN
              NUF = NINT(F(I))
            ELSE
              NUF = INT(F(I)); CLOS = F(I)-NUF
            END IF
            NUF = MAX(1,MIN(100,NUF))
          END IF
        END DO
        GOTO 225
      END IF
260   OPEN(7,FILE=F5)  ! Transcription datafile
      J = JF(JF(MXID))
      FMT = '(I'//CF(:J)//',":",50I3,20(:/'//CF(:J)//'X,1X,50I3))'
      IF(WD==4) FMT = '(I'//CF(:J)//',":",45I4,20(:/'//CF(:J)//'X,1X,
     +  45I4))'
      WORD = ' '; WORD((13-LF5)/2:12) = F5(:LF5)
      WORD(12+(13-LF1)/2:24) = F1
      WRITE(7,'(" HYDATA-standard datafile ",A,": ",A," variables, ",A,
     +  " records; largest ID, ",A,"; imputed under DEV =",F5.1/6X,"fr",
     +  "om D-file precursor ",A,"; datafix ",A,"; ",A," missing scor",
     +  "es.")') WORD(:12), CF(:JF(NV)), CF(:JF(NREC)), CF(:JF(MXID)),
     +  DEV, WORD(12:24), CF(:JF(NFIX+NPASS)), CF(:JF(MMIS))
      N = 150/(LM+1)
      FMN = '(90('//CF(:JF(N))//'(1X,A),:/))'//'                '
      WRITE(7,FMN) (IDENT(I)(:LM),I=1,NV)
      IF(NSX>0) WRITE(7,'("Rescale",8(2X,5I3),20(/8X,8(2X,5I3)))')
     +   (KX(I),I=1,NY)
      NN = 0; IP = 0
300   NN = NN+1  ! Strip Z-scores off the raw-score estimates
      KREC = LST(NN,1)
      IF(LST(NN,2)==IP) GOTO 310  ! Correct MISS pattern already loaded
      IP = IP+1; B = 0.; CH = '  '  ! Start computation of B for next pattern
      READ(33,REC=IP) MS, KS, (MISS(I),I=1,MS)
310   READ(17,REC=KREC) ID, (KV(I),I=1,NV)
      DO II = 1,MS
        I = MISS(II); KV(I) = MOD(KV(I),1000)
      END DO
      WRITE(17,REC=KREC) ID, (KV(I),I=1,NV)
      IF(NN<NSOM) GOTO 300   ! Clean next record with missing scores

      REWIND 17   ! Write the imputed D-file
320   READ(17,END=330) ID, (KV(I),I=1,NV)
      WRITE(7,FMT) ID, (KV(I),I=1,NV)
      GOTO 320
330   WRITE(8,'(/" Total number of missing scores estimated: ",A,
     +  " out of ",A)') CF(:JF(KNT)), CF(:JF(MIS))
      WRITE(8,'(" Number of records remaining incomplete due to impu",
     +  "tation failure: ",A)') CF(:JF(NFAIL))
      WRITE(6,'(/" ***** Job is done.  The purefied datafile is ",A,
     +  ", and some details of"/7X,"the estimation are reported in ",A,
     +  ", ",A,", and ",A,".")') F5(:LF5), F6(:LF6), F3(:LF3), F4(:LF4)
      TIM = TM(3)
      DO K = 6,8,2
        WRITE(K,'(" Time taken by job: ",A4," minutes; or ",A4," secon",
     +    "ds per estimate.")') CLN(TIM/60,4,2),CLN(TIM/(NNN+.001),4,2)
      END DO
      WRITE(8,'(/" Here listed in form ""...  Pass:NR ..."" is the ",
     +  "number of leading axes (NR)"/" retained on each Pass in ",
     +  "the iteration sequence:",50(/10(2X,I2,":",A)))')
     +  (J,CF(:MAX(3,JF(LPAS(J)))),J=1,MIN(99,NPASS))
      WRITE(9,'(/" >>>> The imputations reported above have been sav",
     +  "ed in datafile ",A,".")') F5(:LF5)

C                         DUBIOUS-ESTIMATES REPORT
C Indicated here for each variable is its number of missing scores estimated to lie
C above/below its real-data range and the mean extremity (unsigned sigma distance from
C mean) of those outlier estimates prior to trimming at the the nearest observed score.
C In each tabled entry of form " N: Knt, Dev ", N is the rawdata index of a variable
C having outlier estimates in the given direction, Knt is the number of these, and
C Dev is their average extremity. (Since one or both of a variable's real-data limits
C may be a floor/ceiling scoring limitation, a large number of extremities here
C well under 2 are not to worry.)
C Excessive Highs:   xxx: xx, x.xx   xxx: xx, x.xx   xxx: xx, x.xx   xxx: xx, x.xx
C    xxx: xx, x.xx   xxx: xx, x.xx

      WRITE(8,'(/25X,"DUBIOUS-ESTIMATES REPORT"/" Indicated here for ",
     +  "each variable is its number of missing scores estimated to l",
     +  "ie"/" above/below its real-data range and the mean extremity",
     +  " (unsigned sigma distance from"/" mean) of those outlier est",
     +  "imates prior to trimming at the the nearest observed score."/
     +  " In each tabled entry of form ""(N: Knt, Dev ""), N is the ra",
     +  "wdata index of a variable"/" having outlier estimates in the",
     +  " given direction, Knt is the number of these, and"/" Dev is ",
     +  "their average extremity.  (Since one or both of a variable''",
     +  "s real-data limits"/" may be a floor/ceiling scoring limitat",
     +  "ion, a large number of extremities here"/" well under 2 are ",
     +  "not to worry.)")')
      MM=0; KK=0; KNT=0; MHI=0; KLO=0
      DO I = 1,NV
        IF(PFRM(2,I)>0) THEN
          MM = MM+1
          MHI = MHI+PFRM(2,I)
          MISS(MM) = I
          PFRM(1,I) = PFRM(1,I)/PFRM(2,I)
        END IF
        IF(PFRM(4,I)>.01) THEN
          KK = KK+1
          KLO = KLO+PFRM(4,I)
          KISS(KK) = I
          PFRM(3,I) = -PFRM(3,I)/PFRM(4,I)
        END IF
      END DO
      IF(MM==0) WRITE(8,'(/" Excessive Highs:  None")')
      IF(MM>0) WRITE(8,'(/" Excessive Highs (total, ",A,"):")')
     +  CF(:JF(MHI))
      IF(MM>0) WRITE(8,'(100(5(2X,"(",A,": ",A,", ",A4,")":)/))')
     +   (CF(:JF(MISS(I))), CF(:JF(NINT(PFRM(2,MISS(I))))),
     +   CLN(PFRM(1,MISS(I)),4,2),I=1,MM)
      IF(KK==0) WRITE(8,'(/" Excessive Lows:   None")')
      IF(KK>0) WRITE(8,'(/" Excessive Lows: (total, ",A,"):")')
     +  CF(:JF(KLO))
      IF(KK>0) WRITE(8,'(100(5(2X,"(",A,":",A,", ",A4,")":)/))')
     +   (CF(:JF( KISS(I))),CF(:JF(NINT(PFRM(4,KISS(I))))),
     +   CLN(PFRM(3,KISS(I)),4,2),I=1,KK)
      WRITE(8,'(/" >>> Details on the individual score imputations ",
     +  "are in SEE-file ",A,".")') F6(:LF6)
      STOP
      END
C
      SUBROUTINE CAP(WORD,L)
C This makes the first L letters in WORD all upper-case.
      CHARACTER WORD*(*)
      DO I = 1,L
        N = ICHAR(WORD(I:I))
       IF(N>=97 .AND. N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      END SUBROUTINE
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
c >>>> In this special modification, X=999999. returns CLN = '        '
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      CLN = '        '
      IF(X==999999.) RETURN
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      LD = ABS(ND)
      IF(ABS(X)<1.0E-12) THEN !  Special for vanishingly small X
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X))) !  M is space free for decimal (or M-1 if X<0) )
      IF(M<0 .OR.  M<1.AND.X<0.) GOTO 55
      IF(ND>=10) LD = 0; LD = MIN(LD,M)
      DO I = 1,KW
        WK(I) = ' '
      END DO
      IF(LD==0) N = NINT(ABS(X))         ! Shouldn't be needed, but is
      IF(LD/=0) N = NINT(ABS(X)*10**LD)  ! This can overflow if LD is large
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' *******'
      END FUNCTION

      SUBROUTINE DELET(N1,LST1,N2,LST2) !,KD)
C Delete from the list of integers in LST1 all that are also listed in LST2.
C Ni {i=1,2} is the in/out length of LSTi. KD is the count of deletions.
      INTEGER LST1(*), LST2(*)
      A:DO I = 1,N1
        DO J = 1,N2
          IF(LST1(I)==LST2(J)) LST1(I) = 0
          IF(LST1(I)==0) CYCLE A
        END DO
      END DO A
      NN = 0
      DO J = 1,N1
        IF(LST1(J)==0) CYCLE
        NN = NN+1; LST1(NN) = LST1(J)
      END DO
      KD = N1-NN; N1 = NN
      END SUBROUTINE
C
      SUBROUTINE FNDEND(K,NB)
C Positions file K for writing after line Last-minus-NB; Lahey, Microsoft,
C and Sun UNIX compilers all require NB  0.  To READ line Last-minus-NB,
C replace NB with NB+1.
C **** In particular, use NB=0 to append to end, but NB=1 to READ last line.
      BACKSPACE K
10    READ(K,'()',END=20)
      GOTO 10
20    DO I = 1,NB+1
        BACKSPACE K
      END DO
      END SUBROUTINE

      SUBROUTINE GETINFO(NV,NF,L3,L2,R,T,CV,LST,JP)
C   >>> For JP>0, put L3 = NR, L2 = NR+?
C Show strength of weakest principal components. Input: Pattern T of NV items
C on NF axes, eigenvalues R, workspace C for residual covar; JP = NPASS
C For each downcount N = NF-1,..,NS, list the largest residual vars/covars
C left by N principal axes. L<k> (k=3,2) indexes the weakest axis on which
C there are k loadings larger than .10*k.
      CHARACTER CLN*8, CF*12, CH
      INTEGER LST(*)    ! Size-NVV workspace
      REAL R(*), T(NV,*), CV(NV,*), X(2)
      COMMON /CF/ CF
      NA = L3; NB = L2; LIM = 10; SML = .02
      IF(JP==0) WRITE(11,'(/" NOTE: The following information is for",
     +  " the startup correlations, imputed by"/7X,"taking good-score",
     +  " means for the missing data.")')
      IF(JP>0) WRITE(11,'(//" NOTE: The following information is for",
     +  " the imputed correlations ending Pass ",A,".")') CF(:JF(JP))
10    WRITE(6,'(" For each prospective retained-axis choice from NA = ",
     +  A," up to NB = ",A,", the"/" largest residual item variances/c",
     +  "ovariances unaccounted for by their leading"/" NR principal a",
     +  "xes will be listed.  (Only a leading fragment of this will be"/
     +  " shown on screen; the full display will be available in this ",
     +  "run''s EIG-file.)"/" Hit RETURN to accept this display range,",
     +  " or enter your preferred pair of"/" bounds <NB,NA>."/)')
     +  CF(:JF(NA)), CF(:JF(NB))
      CALL SCANN(J,0,'I',5,CH)
      IF(J==0) GOTO 20
      IF(J==1) THEN
        READ(2,*) N1
        NA = MIN(1,N1,NA); NB = MIN(NF,MAX(N1,NB))
      ELSE IF(J>1) THEN
        READ(2,*) N1,N2
        NA = MAX(1,MIN(N1,N2)); NB = MIN(NF,MAX(N1,N2))
      END IF
      GOTO 10
20    WRITE(6,'(/" For each NR from ",A," to ",A,", to be listed in d",
     +  "ecreasing size is the NL largest"/" residual item variances ",
     +  "and, separately, proper covariances that remain after"/" the",
     +  " items'' leading NR principal axes are partialled out.  Up t",
     +  "o display"/" limit LIM, NL is the number of variances (covar",
     +  "iances) whose residual"/" exceeds value SMALL.  To accept se",
     +  "ttings <LIM, SMALL> = <",A,",",A5,"> of "/" these display pa",
     +  "rameters, hit RETURN.  Otherwise, enter your preference"/" f",
     +  "or one or both of LIM and SMALL."/)') CF(:JF(NA)), CF(:JF(NB)),
     +  CF(:JF(LIM)), CLN(SML,5,3)
      CALL SCANN(J,0,'R',5,CH)
      IF(J==0) GOTO 30; IF(J<0) GOTO 20
      READ(2,*) (X(I),I=1,J)
      IF(X(1)<0. .OR. X(J)<0.) GOTO 20
      DO I = 1,MIN(J,2)
        IF(X(I)==ANINT(X(I))) THEN
          LIM = NINT(X(I))
        ELSE IF(X(I)<.9999) THEN
          SML = X(I)
        ELSE
          LIM = INT(X(I)); SML = X(I)-LIM
        END IF
      END DO
      GOTO 20
30    WRITE(6,'(/" Collecting information on residuals . . . . .")')
      DO J = 1,NV   ! Initialize residuals
        DO I = 1,J
          CV(I,J) = 0.
          DO K = NA,NF
             CV(I,J) = CV(I,J) + T(I,K)*T(J,K)
          END DO
        END DO
      END DO

C Show residuals after principal axis KF
C ͵ Residuals at end of Pass xxx  

      WRITE(11,'(/19("")," Residuals at end of Pass ",A," ",
     +  23(""))') CF(:JF(JP))
      WRITE(11,'(/" For each NR from ",A," to ",A,", listed below in",
     +  " decreasing size are the LM largest"/" residual item varian",
     +  "ces and, separately, proper covariances with signs omitted"/
     +  " that remain after the items'' leading NR principal axes are",
     +  " partialled out.  Up to display"/" limit ",A,", NL is the n",
     +  "umber of variances (covariances) whose residual"/" exceeds ",
     +  "value ",A4,"."/)') CF(:JF(NA)), CF(:JF(NB)), CF(:JF(LIM)),
     +  CLN(SML,4,3)
      KF = NA-1
50    KF = KF+1; KF1 = KF+1
C Ŀ
C  Truncate after NR = xx (eigenvalue .xxx) 
C 
      WRITE(11,'(/" Ŀ")')
      WRITE(11,'("  Truncate after NR =",I3," (eigenvalue ",A4,") ",
     +  40(""))')  KF, CLN(R(KF),4,3)
      WRITE(11,'(" ")')
      WRITE(11,'(/" Largest residual variances/covariances lost if ",
     +  "just ",A," principal axes are retained:")') CF(:JF(KF))
      DO J = 1,NV
        DO I = 1,J
           CV(I,J) = CV(I,J) - T(I,KF1)*T(J,KF1)
        END DO
      END DO      ! Residuals of 1st KF axes are in CV
      LL = 0; J = 0
55    J = J+1     ! Put qualified variance residuals in LST
      IF(CV(J,J)>SML) THEN
        LL = LL+1; LST(LL) = NINT(1000*CV(J,J))*10**3 + J
      END IF
      IF(J<NV) GOTO 55
      CALL ISORT(LL,LST)
      WRITE(11,'(/" VARIANCES, listed in form ""( Item index i; ",
     +  "Residual Var(i) )""")')
      WRITE(11,'(90(6(2X,"(",A,";",A5,")",:)/))') (CF(:JF(MOD(LST(I),
     +  1000))),CLN(.001*(LST(I)/1000),5,3), I=1,MIN(LL,LIM))
C  (xx; .xxx)  (xx; .xxx)  (xx; .xxx)  (xx; .xxx)  (xx; .xxx)  (xx; .xxx)
      LL = 0
60    DO J = 2,NV    ! Put qualified covariance residuals in LST
        DO I = 1,J-1
          IF(ABS(CV(I,J))>SML) THEN
            LL = LL+1
            LST(LL) = NINT(1000*ABS(CV(I,J)))*10**6 + I*10**3 + J
          END IF
        END DO
      END DO
      CALL ISORT(LL,LST)
      WRITE(11,'(/" COVARIANCES (no variances), listed in form ""( It",
     +  "em indices i,j; Residual Cov(i,j) )""")')
      WRITE(11,'(90(5(2X,"(",A,",",A,";",A5,")",:)/))')
     +  ( CF(:JF(MOD(LST(I)/1000,1000))), CF(:JF(MOD(LST(I),1000))),
     +  CLN(.001*(LST(I)/10**6),5,3) ,I=1,MIN(LL,LIM))
      IF(JP>0 .AND. KF==NA) THEN
cc        WRITE(6,'(/" Ŀ")')
        WRITE(6,'(/"  Truncate after NR =",I3," (eigenvalue ",A4,") ",
     +    34(""))')  KF, CLN(R(KF),4,3)
cc        WRITE(6,'(" ")')
        WRITE(6,'(/" Proper covars (NR = ",A,") listed in form ""( I",
     +    "tem indices i,j; Resid Cov(i,j) )""")') CF(:JF(KF))
        WRITE(6,'(90(5(2X,"(",A,",",A,";",A5,")",:)/))')
     +    ( CF(:JF(MOD(LST(I)/1000,1000))), CF(:JF(MOD(LST(I),1000))),
     +    CLN(.001*(LST(I)/10**6),5,3) ,I=1,MIN(15,LL))
      END IF
      IF(KF<MIN(NB,NF-1)) GOTO 50
      END SUBROUTINE

      SUBROUTINE INV1(NV,KS,MS,KISS,MISS,CINV,CC,CUT,EER)  ! Use when KS > MS
C Given KS KISS-items, MS MISS-items, and inverse CINV of the full-set CV,
C derive from the KISS,MISS-selected subsets of CINV the KISS-set covars
C inverse to return in CC. For test of inversion, CC inputs CV
c      CHARACTER(8) CLN ! TEST LINE
      INTEGER KISS(*), MISS(*)
      REAL CINV(NV,*), CC(NV,*)
      REAL G(MS,MAX(MS,KS)), H(MS,MS), Q(KS,KS), QQ(NV,NV), R(MS)
      DO J = 1,KS   ! Put Cov(KISS,KISS) in QQ for inversion check
        DO I = 1,KS
          QQ(I,J) = CC(KISS(I),KISS(J))
        END DO
      END DO
C                                           A B'
C Theory: With item covars ordered as CV =  B D  with A = Cov(KISS,KISS),
C     B = Cov(MISS,KISS), D = Cov(MISS,MISS), corresponding Inv(CV) =  E G'
C     yields Inv(A) = E - G'Inv(H)G.                                 G H 
      IF(MS==1) THEN
        H(1,1) = 1./MAX(CUT,CINV(MISS(1),MISS(1)))
        GOTO 50
      END IF
      DO J = 1,MS
        DO I = 1,MS
          H(I,J) = CINV(MISS(I),MISS(J))
        END DO
      END DO
      CALL EIGS(MS,MS,H,MS,R,G,MS,1,IER,11)
      H = 0.
      DO J = 1,MS
        DO I = 1,J
          DO K = 1,MS
            H(I,J) = H(I,J) + G(I,K)*G(J,K)/MAX(CUT,R(K))
          END DO
          H(J,I) = H(I,J)
        END DO
      END DO
50    DO I = 1,MS
        DO J = 1,KS
          G(I,J) = CINV(MISS(I),KISS(J))
        END DO
      END DO
CCC      Q = MATMUL(TRANSPOSE(G),MATMUL(H,G))  ! BAD SHOW
C Efficient storage style of getting matrix product Q = G'*H*G:
C Q(i,j) = kl G'(i,k)*H(k,l)*G(l,j) = k G'(i,k)*( l H(k,l)*G(l,j) )
C Q <= G'*H*G       G: MS-by-KS;  H: MS-by-MS;  Q: KS-by-KS
      Q = 0.
      DO J = 1,KS
        DO K = 1,MS
          S = 0.
          DO L = 1,MS
            S = S + H(K,L)*G(L,J)
          END DO
          DO I = 1,J
            Q(I,J) = Q(I,J) + G(K,I)*S
          END DO
        END DO
        DO I = 1,J-1
          Q(J,I) = Q(I,J)
        END DO
        DO I = 1,J   ! CC now becomes the KISS-covar inverse
          CC(I,J) = CINV(KISS(I),KISS(J)) - Q(I,J); CC(J,I) = CC(I,J)
        END DO
      END DO
      CALL INVCHK(KS,NV,QQ,CC,EER) ! ,II,JJ,EERR)
      END SUBROUTINE

      SUBROUTINE INV2(NV,KS,KISS,CV,CC,CUT,EER)  ! Use when KS  MS
C Pick the KISS covariance submatrix out of CV and return its inverse in CC
c      CHARACTER(8) CLN ! TEST LINE
      INTEGER KISS(*)
      REAL CV(NV,*), CC(NV,NV), T(KS,KS), R(KS), QQ(NV,NV)
      CC = 0.    !    ^ Needs full declaration to allow easy specification
      DO J = 1,KS
        DO I = 1,J
          CC(I,J) = CV(KISS(I),KISS(J)); CC(J,I) = CC(I,J)
          QQ(I,J) = CC(I,J); QQ(J,I) = CC(I,J)
        END DO
      END DO
      CALL EIGS(KS,KS,CC,NV,R,T,KS,1,IER,11)
      CC = 0.
      DO J = 1,KS
        DO I = 1,J
          DO K = 1,KS
            CC(I,J) = CC(I,J) + T(I,K)*T(J,K)/MAX(CUT,R(K))
          END DO
        END DO
      END DO
      CALL INVCHK(KS,NV,QQ,CC,EER) ! ,II,JJ,EERR)
      END SUBROUTINE

      SUBROUTINE INVCHK(NV,MV,CV,CINV,EER) ! ,II,JJ,EERR)
C Check how tightly CINV is the inverse of order-NV square matrix CV:
C EER returns the largest size of terms in CVCINV - I.  The location of
C EER is ready to return in <II,JJ> with the sum of errors in EERR
      REAL CV(MV,*), CINV(MV,*)
CC      EERR = 0.
      DO J = 1,NV   ! CC inputs CV for this test
        DO I = 1,NV
          S = 0.; IF(I==J) S = -1.
          DO K = 1,NV
            S = S + CV(I,K)*CINV(K,J)
          END DO
          IF(ABS(S)>EER) THEN
            EER = ABS(S)  ! ; II = I; JJ = J
          END IF
CC          EERR = EERR + ABS(S)
        END DO
      END DO
      END SUBROUTINE
C
      SUBROUTINE ISORT(N,LST)
C Sort LST integers into descending (or ascending) order
      INTEGER LST(*)
      DO J = 2,N
        L = LST(J)
        DO I = J-1,1,-1
C          IF(LST(I)<=L) GOTO 12    ! Increasing order
          IF(LST(I)>=L) GOTO 12    ! Decreasing order
          LST(I+1) = LST(I)
        END DO
        I = 0
12      LST(I+1) = L
      END DO
      END SUBROUTINE
C
      SUBROUTINE ISORT2(N,LST,NR)
C Sort LST of paired integers into descending (or ascending) order on 2nd term
      INTEGER LST(NR,2)
      DO J = 2,N
        L1 = LST(J,1); L2 = LST(J,2)
        DO I = J-1,1,-1
          IF(LST(I,2)<=L2) GOTO 12    ! Increasing order
C          IF(LST(I,2)>=L2) GOTO 12    ! Decreasing order
          LST(I+1,1) = LST(I,1); LST(I+1,2) = LST(I,2)
        END DO
        I = 0
12      LST(I+1,1) = L1; LST(I+1,2) = L2
      END DO
      END SUBROUTINE

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      SUBROUTINE KOUNT(NV,NF,A,NR,LST,JOB)
C For each column of pattern A, tell how many entries therein exceed threshold
C CUT and show Mean(Count) of saliences as controlled by JOB: If JOB>0, show
C Count on screen and write Mean(Count) to file; if JOB=0, write Mean(Count)
C to screen.  JOB>0 allows new choice of NR and call of GETINFO. LST is wkspace
      CHARACTER CLN*8, CF*12, CH
      INTEGER LST(2,*), LCUT(NF)
      REAL A(NV,*)
      COMMON /CF/ CF
      CUT = .20; NOLD = NR   ! NOLD allows increase in NR to be reversed
50    DO J = 1,NF
        N = 0; Z = 0.
        DO I = 1,NV
          IF(ABS(A(I,J)) < CUT) CYCLE
          N = N+1; Z = Z+ABS(A(I,J))   ! Get count/mean above Cut
        END DO
        LST(1,J) = N; LST(2,J) = NINT(Z*10**4)
      END DO
      NCUT = 1; LCUT(1) = 1  ! List axes just with item loadings above CUT
      DO J = 2,NF
        IF(LST(1,J)==0) CYCLE
        NCUT = NCUT+1; LCUT(NCUT) = J
      END DO
      LAST = LCUT(NCUT)
      IF(JOB==1) THEN
        WRITE(6,'(/" On each axis, the count of items with loadings ",
     +    "larger than CUT =",A4," is")') CLN(CUT,4,2)
        WRITE(6,'(20(5I5,2X,5I5,2X,5I5:/))') (LST(1,J),J=1,LAST)
        IF(LAST<NF) WRITE(6,'(" The axes from ",A," to ",A," have ze",
     +    "ro count at this level.")') CF(:JF(1+LAST)), CF(:JF(NF))
        WRITE(6,'()')
      END IF
      M1 = 1   ! For JOB=1
      IF(JOB < 1) THEN
        M1 = LAST+1
12      M1 = M1-1   ! M1 gets index of the first axis with count < 10
        IF(M1>1 .AND. LST(1,M1-1)<10) GOTO 12
      END IF
      DO I = M1,NCUT
        J = LCUT(I); LST(2,J) = LST(2,J)/MAX(1,LST(1,J))  ! Mean sal x 10**4
      END DO
      IF(JOB==1) THEN
        WRITE(11,'(/" The initial pattern''s Count(Mean) of loading",
     +    "s exceeding CUT = ",A3," are")') CLN(CUT,3,2)
        WRITE(11,'(50(6(1X,A,": ",A,"(",A4,")",):/))') (CF(:JF(I)),
     +   CF(:JF(LST(1,I))),CLN(LST(2,I)/10.**4,4,3),I=1,LAST)
        IF(LAST<NF) WRITE(11,'(" The axes from ",A," to ",A," have ze",
     +    "ro count at this level.")') CF(:JF(1+LAST)), CF(:JF(NF))
      ELSE
        DO KF= 6,11,5
          WRITE(KF,'(/" Starting display with the axis following the ",
     +      "last with Count > 10, the latest"/" pattern''s Count(Mea",
     +      "n) of loadings exceeding CUT = ",A3," are")') CLN(CUT,3,2)
          WRITE(KF,'(50(6(1X,A,": ",A,"(",A4,")",):/))')
     +      (CF(:JF(LCUT(I))),CF(:JF(LST(1,LCUT(I)))),
     +      CLN(LST(2,LCUT(I))/10.**4,4,3),I=M1,NCUT)
        END DO
        WRITE(11,'(" Axes not listed have zero Count at this level.")')
      END IF
      CUT = CUT + SIGN(.05,JOB-.5)
41    WRITE(6,'(/4X,"Hit RETURN to see this information at CUT level",
     +  A4,".  Otherwise, enter")') CLN(CUT,4,2)
      IF(JOB==1) WRITE(6,'(4X,"another choice of CUT or any letter ",
     +  "to move on."/)')
      IF(JOB<1) WRITE(6,'(4X,"(a) another choice of CUT, (b) a num",
     +  "ber of leading axes you pick for"/4X,"NR larger than ",A,
     +  "), or (c) any letter to move on with NR = ",A,"."/)')
     +  CF(:JF(NOLD)), CF(:JF(NR))
      CALL SCANN(J,0,'R',5,CH)
      IF(J==0) GOTO 50
      IF(J<0) RETURN
      READ(2,*) Q
      IF(JOB==1) GOTO 45
      NN = NINT(Q)
      IF(Q==NN) THEN   ! Just if Q is an integer
        IF(NN<NOLD) GOTO 41
        NR = MIN(NN,NF); RETURN
      END IF
45    IF(Q>=.9) THEN; Q = Q/10; GOTO 45; END IF
      CUT = MAX(.005,Q)
      GOTO 41
      END SUBROUTINE
C
      SUBROUTINE LAST(L,WORD,M)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as L. If the string is empty, LAST is returned as 0.
      CHARACTER WORD*(*)
      WORD(:M) = ADJUSTL(WORD(:M))
      L = LEN_TRIM(WORD(:M))
      END SUBROUTINE

CCC This is the model for LINV using Ginv from EIGS
CC      SUBROUTINE LINV(NY,NF,A,AL,N0,IER)   ! OK to make A and AL the same space
CCC Find the left-inverse of NS x NF matrix A and return its transpose in AL.
CCC NY is leading dimension of A and AL.
CCC Workspaces needed: T(NF,NF), R(NF), W(NF,NF)
CC      REAL A(NY,*), AL(NY,*), R(NF), W(NF,NF)
CC      IF(NY<1) RETURN
CC      W = 0.; IER = 0
CC      DO J = 1,NF
CC        DO I = 1,J
CC          DO K = 1,NY
CC            W(I,J) = W(I,J) + A(K,I)*A(K,J)
CC          END DO
CC          W(J,I) = W(I,J)
CC        END DO
CC      END DO
CC      CALL EIGS(NF,0,W,NV,R,W,0,NF,IER,7) !  JOB calls return of Ginv(AL)
CC      IF(IER>0) RETURN                    !  Don't need eigvecs
CC      DO I = 1,NY
CC        DO J = 1,NF
CC          AL(I,J) = 0.
CC          DO K = 1,NF
CC            AL(I,J) = AL(I,J) + A(I,K)*W(K,J)
CC          END DO
CC        END DO
CC      END DO
CC      END SUBROUTINE

C
      SUBROUTINE LINV(KS,NF,A,NV,KISS,AL,CUT,N0,IER)
C Find the left-inverse of the KS x NF submatrix of A picked by the row indices
C in KISS, and return its transpose in AL.  NV is leading dimension of A and AL.
C CUT is cut on negligible roots.  Workspaces needed: T(NF,NF), R(NF), W(NF,NF)
      INTEGER KISS(*)
      REAL A(NV,*), AL(NV,*), T(NF,NF), R(NF), W(NF,NF)
      IF(KS<1) RETURN
      IER = 0
      DO J = 1,NF
        DO I = 1,J
          S = 0.
          DO K = 1,KS
            S = S + A(KISS(K),I)*A(KISS(K),J)
          END DO
          AL(I,J) = S; AL(J,I) = AL(I,J)
        END DO
      END DO
      NN = MIN(NF,KS); IER = 0
      CALL EIGS(NF,NN,AL,NV,R,T,NF,1,IER,11)
      IF(IER>0) RETURN
      NR = NN+1
20    NR = NR-1
      IF(R(NR)<CUT) GOTO 20
      NR = MAX(1,NR)   ! CUT can never force NR < 1
      N0 = NF-NR
      DO J = 1,NR
        R(J) = 1./R(J)
      END DO
      DO J = 1,NF
        DO I = 1,J
          S = 0.
          DO K = 1,NR
            S = S + T(I,K)*R(K)*T(J,K)
          END DO
        W(I,J) = S
        W(J,I) = W(I,J)
        END DO
      END DO
      DO I = 1,KS
        DO J = 1,NF
CC          S = 0.0D0
          S = 0.
          DO K = 1,NF
            S = S + A(KISS(I),K)*W(K,J)
          END DO
CC          AL(I,J) = SNGL(S)
          AL(I,J) = S
        END DO
      END DO
      END SUBROUTINE

      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
      LOGICAL PRM, QY
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP
      CHARACTER E   ! <<<  Special characters as needed
      WD = GET
      CALL LAST(M,WD,40)
      LL = 1
5     LL = LL+1; IF(LL<M) GOTO 5
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(WORD(:1)==' ' .OR. WORD(:1)=='.') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
C       Filter out lines other than filenames
      CALL LAST(L,WORD,14)
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
      J = ICHAR(WORD(11:11));  IF(J<48 .OR. J>57) GOTO 10
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)

C Check whether any scores are declared missing (Special D-file exclusions)
      OPEN(31,FILE=WORD(:L+4)); READ(31,'()')  ! Open and skip 1st line
C      from D-file precursor   SORSA.D0   ; datafix 18; 0 missing scores.
      READ(31,*) (E,I=1,8)  ! ^form of line to be read
      CLOSE(31)
      IF(E=='0') GOTO 10

      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4) .AND. NAME(I)(L+5:L+5)==' ')
     +    GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NL)
      IF(NL>0) WORD(:12) = NAME(NL)
      RETURN
      END
C
      SUBROUTINE NAME1(F1,F2,M,L)
C This receives a filename in F1 (presumed to start in position 1), solves
C for <head> to be the part of F1 prior to '.' up to M characters, scans the
C subdirectory for the lowest i=1,2,...,99 such that file <head>.Di does not
C already exist, returns <head>.Di in F1(:12), <head>.LOG in F2, and the end
C position of the latter in L.
      LOGICAL QY
      CHARACTER F1*(*), F2*(*), DIGIT
      DIGIT(I) = CHAR(48+I)
      L = 0
10    L = L+1
      IF(L<=M .AND. F1(L:L)/=' ' .AND. F1(L:L)/='.') GOTO 10
      DO I = L+2,12
        F1(I:I) = ' '
      END DO
      F2 = F1
      F1(L:L+1) = '.D'
      F2(L:L+3) = '.LOG'
      L = L+2
      I = 0
20    I = I+1
      IF(I<=9) F1(L:L) = DIGIT(I)
      IF(I>9) F1(L:L+1) = DIGIT(I/10)//DIGIT(MOD(I,10))
      INQUIRE(FILE=F1,EXIST=QY)
      IF(QY .AND. I<99) GOTO 20
      IF(QY .AND. I==99) F1(L:L+1) = DIGIT(0)//DIGIT(0)
      L = L+1
      END SUBROUTINE
C
      SUBROUTINE SCANN(NL,NS,SEQ,KF,CH)
C This reads a string from ASCII file KF, cleans it for list-directed reading
C of the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether all
C its numbers are of the first I/R kind listed in SEQ. (Integers are accepted
C also as reals.)  NL returns 0 if the input string is blank, -1 if this
C contains only non-numeric characters, -2 if the cleaned number string
C returned in File 2 is non-null but does not match SEQ, and gives the total
C count of numbers in the returned string otherwise.  If SEQ is "B", NL
C returns 0 if the input line is blank, and returns -1 otherwise.
C ***** In this version, input is read from CH if KF < 0.
      CHARACTER  AA, SEQ*(*), CH*(*), WA*80, WB*81
      IF(KF>0) THEN
        READ(KF,'(A)') WA
        CALL LAST(NL,WA,80)
      ELSE
        LN = LEN(CH)
        CALL LAST(NL,CH,LN)
        IF(NL>0) WA(:NL) = CH
      END IF
      IF(NL==0) RETURN
      IF(SEQ(1:1)=='B') NL = -1
      IF(SEQ(1:1)=='B') RETURN
      WB(NL+1:NL+1) = ' '
      DO 20 I = 1,NL
       WB(I:I) = ' '
       IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) GOTO 20
       WB(I:I) = WA(I:I)
       WA(I:I) = '0'
20     CONTINUE
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO 30 I = 2,NL
       IF(WA(I:I)=='-') THEN
        IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +   =='0')) WB(I:I) = '-'
        IP = 0
       ELSE IF (WA(I:I)=='.') THEN
        IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +  WB(I:I) = '.'
        IF(WB(I:I) == '.') IP = 1
       ELSE IF (WA(I:I) /= '0') THEN
        IP = 0
       END IF
30     CONTINUE
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO 40 I = 2,NL+1
       IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
        NN = NN + 1
        WA(NN:NN) = AA
        AA = 'I'
       ELSE IF (WB(I:I)=='.') THEN
        AA = 'R'
       END IF
40     CONTINUE
      IF(NN==0) NL = -1
      IF(NN==0) RETURN
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     +  "number sequence requested. Try again.")')
      RETURN
60    REWIND 2
      WRITE(2,'(A)') WB(1:NL)
      NL = NN
      REWIND 2
      RETURN
      END
C
      SUBROUTINE SEENAM(NX,IDENT,LST,LS,KF)
C This writes to file KF the NX names in IDENT.
C LM is max namelength.  LS is number of lines to leave at top of screen.
C ***** WARNING: When LST is proper, items are listed with original indices
      CHARACTER*8 IDENT(*), FMT*30, CH2*2
      INTEGER LST(*)
      LM = 3
      DO I = 1,NX
        CALL LAST(N,IDENT(LST(I)),8)
        IF(N>0) LM = MAX(LM,N)
      END DO
      LL = 79/(6+LM)   ! Number of fields per line
      LB = (23-LS)*LL  ! Number of fields in 23-LS lines
      NS = MIN(1,MOD(79,6+LM)/2)  ! Number of spaces starting display line
      NK = 0
      CH2 = CHAR(48+NS)//CHAR(48+LL)
      FMT = '(80('//CH2(1:1)//'X,'//CH2(2:2)//'(I4,": ",A),:/))'
20    WRITE(KF,FMT) (LST(I),IDENT(LST(I))(:LM),I=NK+1,NK+MIN(LB,NX-NK))
      IF(1+(NX-NK)/LL<=18) RETURN   ! Number of lines needed to finish
      WRITE(6,'(" Hit RETURN to continue")')
      READ(5,'(A1)')
      NK = NK+LB
      LB = 23*LL  ! Hereafter use full screen
      IF(NK>=NX) RETURN
      GOTO 20
      END SUBROUTINE

      SUBROUTINE START(J,F1)
C This opens formatted file F1 with unit-number J, and finds its first line
C beginning with a digit.
      CHARACTER F1*(*), CH*80
      OPEN(J,FILE=F1)
10    READ(J,'(A)',END=50) CH
      K = 0
12    K = K+1
      L = ICHAR(CH(K:K))
      IF((L==32 .OR. L==0) .AND. K<80) GOTO 12
      IF(L<48 .OR. L>57) GOTO 10
      BACKSPACE J
      RETURN
50    WRITE(6,'(/" File ",A," is defective.")') F1
      END SUBROUTINE
C
      FUNCTION QFMT(F1)
C This determines the status of file F1, returning 'Y' if it is Formatted,
C 'N' if it is Not, and 'U' if it is Unknown (does not exist).
      CHARACTER QFMT, F1*(*)
      INQUIRE(FILE=F1,FORMATTED=QFMT)
      RETURN
      END
C
      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12, LST(12)*10
      COMMON /CF/ CF
      DATA LST/'January  7','February 8','March    5','April    5',
     +         'May      3','June     4','July     4','August   6',
     +         'September9','October  7','November 8','December 8'/
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48  ! M gets day of month
      READ(ZZZ(5:6),*) L; K = ICHAR(LST(L)(10:10))-48
      WORD = CF(:JF(M))//' '//LST(L)(:K)//' '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE
C
      FUNCTION TM(KSET)
C Function TM returns the time in seconds since last reset of timer K = |KSET|
C if K is in range 1 to KTM, with new timer reset just if KSET is positive.
C KSET = 0 resets all the timers and returns zero elapsed time.
      PARAMETER (KTM=10)
      INTEGER JPREV(KTM)
      DATA JPREV/KTM*0/
      CALL SYSTEM_CLOCK(J)
      K = IABS(KSET)
      IF(K==0 .OR. K>KTM) THEN
        DO I = 1,KTM
          JPREV(I) = J
        END DO
        TM = 0.
        RETURN
      END IF
      TM = (J+1-JPREV(K))*.01
      IF(TM<0.) TM = TM + 86400
      IF(TM>=16400.) TM = 0.
      IF(KSET<0) RETURN
      JPREV(K) = J
      END FUNCTION


      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      CALL LAST(L1,NAM1,LEN(NAM1)); CALL LAST(L2,NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      CALL LAST(L1,WRD1,LEN(WRD1)); CALL LAST(L2,WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A number terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION
C
      SUBROUTINE WAIT(N)
C  N < 0 calls for space before screen display
      IF(N>0) WRITE(6,'()')
      WRITE(6,'(" Hit RETURN to continue")')
      READ(5,'()')
      RETURN
      END
