
C Program HYBALL. (Source code, FORTRAN-90. No external library needed.)

C >>>>> Put more info in printout of pattern schemata. Goto bookmark $$$$$$


C*Q: Lines to comment out when disabling rotation of quad-factor solutions
C    To cancel deletion, enter "<delete-all> C*Q" in editor.  Trace marks
C    "!C**Q" will not be deleted and quickly show where C*Q goes.

C        Copyright (c) 2002 by W. W. Rozeboom.   All rights reserved.
C
C                   Last revised: 29 March 2005

C    [ The documentation immediately below persists with little change   ]
C    [ from HYBALL's inception and some details are obsolete, especially ]
C    [ its advice on array sizes which are now essentially unlimited.    ]
C    [ See README.DOC and UPDATE.DOC for current specifics.              ]

C    This routine rotates a received factor pattern for NV variables on NF
C  factors to oblique simple structure under subspace fixations if stipulated,
C  and omissions of selected variables from hyperplane search interactively
C  stipulated in control array OMIT as the run progresses.
C    Single-plane rotation searches for hyperplanes either by polished step-
C  down regression or by brute-force scanning for minimal hyperplane misfit.
C  Control parameters for step-down regression, in degrees of angle, are
C  search window  B0, hyperplane width  B1, and window-reduction step DB.
C  Control params for brute-force scanning are search window  B0 (degrees),
C  hyperplane width  BH (pattern coef.), inner/outer hyperplane sharpness
C  JA/JB (powering integers), proximal-misfit curvature CV, and hyperplane-
C  salience weighting WSAL.  Global rotation is controlled by shift-damping
C  fraction DF, convergence criterion TOL, and iteration limit IMAX.
C
C             To install limits NV  mv and NF  mf, declare
C                     MV=mv, MC=mc, MF=mf, MT=mt
C       in all PARAMETER-statement occurrences of MV/MC/MF/MQ, where mv
C       is at least nv (plus 1 for quad-factoring problems), mf at least nf
C       (plus 1 for quad-factoring), mt at least 2*nf + mq where mq is 0 for
C       1st-level factoring but at least (mf+1)*(mf+2)/2 for quad-factoring,
C       and the setting of MC depends on your job as explained next.  Making
C       mq apppreciable will likely require decrese in mv or mf.
C          MC is the maximim number of 1st or 2nd level factor covariances
C       allowed. Unless you are rotating the input factors' quad-moments,
C       make mc  nf*(nf+1)/2 (say mc=295 for nf=25). But to rotate the
C       factors' quad-moments along with the 1st-level factor pattern, MC
C       must be at least [mf*mf*mf + 2*mf*mf + 3*mf + 2]*[mf/8] (mf=nf+1),
C       e.g. 1035 for nf=8.
C
C  NOTES ON FIX:  Each constrained factor is assigned a low-integer rotation
C  code, while factors whose rotation is unconstrained receive an internally
C  high code that is shown on-screen as "Y".  FIX code -1 demarks exclusion;
C  the factor neither moves nor contributes to rotation of others.  Factors
C  with FIX code 0 do not move but contribute to rotation of all factors with
C  higher codes.  For each FIX code K>0, factors with code K contribute to
C  rotation of all factors in code blocks K and Y, as well as to all in any
C  other block of higher code if so specified in the block structure entered
C  in FIX following the individual-factor codings.  When FIX is input from
C  HYBLOCK, -1 codes Waif factors (block Z).
C
C  NOTES ON INPUT/OUTPUT.
C    INPUT: HYBALL reads a 1st-level factor pattern, together with either the
C  factors' standardized quad-moments or just their 1st-level covariances,
C  from file <head>ij.M<n> (integer i from HYDATA, integers j and n from MODA)
C  from file INHYBL, or from HYBUF.#<n>. The first two normally contain new
C  material, whereas HYBUF.#<N> saves results from a previous run now resumed.
C    OUTPUT: All rotations are collected in unformatted file HYBUF.#, from which
C  any can be recalled at any stage of this or a later run. On command to stop,
C  the currently active pattern is sent to ASCII file $<hea>ij.H<n> where <hea>
C  is the start of <head>. This pattern is also recorded in an ASCII file
C  FAC*ij.H<n> which be passed to HYFAC for designing item composites for
C  predicting the factors and which HYBALL too accepts as input.

C  Warning: Printer technology has advanced to where the advice below probably
C  has little cogency. I am not sure at present how this should be updated.
C  So at present only 80-column printout is enabled and you should ignore
C  files SETPRNT and PRNTR.  I will appreciate feedback on how HYBALL's
C  present output is suboptimal for your printer and whether whether there
C  may be a way Hyball can be adapted to that, or conversely.

C    PRINT WIDTH: Line length in your printer output is determined by control
C  parameter KP, which gives 80-character lines if KP = 80 or 132-character
C  lines if KP = 132.  The latter is far superior to the former, especially
C  for pattern plots, and is HYBALL's default setting.  But it will be over-
C  ridden by KP = 80 if your printer-definition file PRNTR in the active sub-
C  directory declares that pitch for 132-character lines is unavailable.
C    PRINTER SETTINGS:  HYBALL's programmed output in RESULTS will include the
C  specific controls needed to set your printer for attractive hard copy just
C  in case the subdirectory in which HYBALL is running contains a file PRNTR
C  containing the appropriate printer-control code.  If HYBALL does not find
C  PRNTR, it writes tokens % and # to mark locations where this code should be
C  inserted.  To create your printer-definition file PRNTR, run program
C  SETPRNT with your printer manual at hand and enter the code appropriate to
C  each feature queried by the program. This will yield an ASCII file PRNTR
C  whose 1st line starts with * if your printer does not provide 132-character
C  print width, and top lines specify % and # as follows:
C     %: (Basic setup.) Narrow left margin (1/4 inch) and flush right margin.
C          For vertical spacing, single-space with 6 or 7 LPI (lines-per-inch)
C          if your type is 10 or 12 point, or with 8 LPI if it is 7-point.
C          Horizontal spacing should be set for at least 132-character lines
C          (17 pitch, or Condensed type).
C     %: (Modified basic setup for KP=80.) Same margins and vertical spacing
C          as above, but only prints 80-character lines and can hence use any
C          pitch you have available.
C     #: (For KP=132 pattern-plots.) Set this for Condensed type (17 pitch) at
C          12 LPI.
C     #: (For KP=80 pattern-plots.) Set this for Pica type (10 pitch) at 7 LPI
C          or your closest LPI larger than 7.
C  ***** Note: If you instruct PRNTR that your printer cannot write line-draw
C          characters under the other options you have chosen, it flags need
C          for a simulation of these by adding 1 to KP.
C  Print Results as a DOS file, not from a word processor unless using fixed-pitch type.
C

      PARAMETER (MREC=200, MMF=50, MOM=1000, MSEE=100 )  !, MB=30 was explicit limit on NB
C       Note: MSEE is limit on number of factors displayed on screen by RECORD.
C             More would be absurd; also, this lets RECORD be passed in common block
      LOGICAL QB, QBB, QL, QN, QS, QLOG, QPR  ! QB=T flags HYBLOCK input
C        QL=T if COV-file item indices; QPR=T if SEE-file produced
      CHARACTER CH, CS, TR, BN, QFMT, WRD(0:4)*6, CLN*8, DSP*5, CH4*4
      CHARACTER(41) FMT, FMT1, FMT2*44, WORD*100, CHV*5
      CHARACTER(12) F1,F2,F3,F4, CF, NAME(80)
      INTEGER FIX1(MMF), PFIX1(MMF), OMIT(MOM), RECORD(MREC,0:MSEE)
      REAL CUM(4,0:4), DE(MREC)
C       Rows 1/2/3/4 of CUM are accumulated time/cycles/solutions/nonconvergences

      CHARACTER(8),ALLOCATABLE :: IDENT(:)
      INTEGER,ALLOCATABLE :: FIX(:), KBB(:), KTL(:,:), LMP(:),
     +         LST1(:), LST2(:), ORDER(:), PFIX(:), TMP(:)
C       LST2 gets HYBLOCK items' block assignments
      REAL,ALLOCATABLE :: A0(:,:), A1(:,:), C1(:,:), CFF(:), CG(:),
     +      COMM(:), DG(:), T1(:,:), W(:,:)

C     NOTE: >>>  KBB will sometimes pass KBL(0:NB+1,0:NF) to subroutines
C                LMP is used to accumulate raw distribution of SPIN lumps

CCC      CHARACTER(8)  IDENT(MVX)
CCC      INTEGER  FIX(MFX), KBB(32*MFX+1), KTL(MFX,MFX+1), LMP(now MV+MSEE),
CCC     +         LST1(MVX),  LST2(MVX), ORDER(MFX), PFIX(MVX), TMP(MVX)
CCC      REAL  A0(MVX,2*MFX), A1(MVX,0:2*MFX), C1(MFX,MFX), CFF(MCX),
CCC     +      CG(MCX), COMM(MVX), DG(MFX), DE(MFX), T1(MVX,2*MFX+2),
CCC     +      W(MVX,MFX)
C*Q     REAL QREC(MREC,5)
      EXTERNAL SCAN
      COMMON  NV, NF, MV, MF
      COMMON /BL1/ B1TAN, DBRAD
      COMMON /BL2/ LIM, CV, PD1, MODE, GAM
      COMMON /BL3/ BH, JA, JB, CV1, ADD, R0, R1, WSAL
      COMMON /BL4/ NN, NTOT
      COMMON /BL5/ B0RAD, B0TAN, FINE
      COMMON /BL6/ B0, B1, DB, DF, TOL, IMAX
      COMMON /BL7/ JFLAG, NSPN, KNV, TT, ICYC
      COMMON /FX/ NB, NPFIX, FIX1, PFIX1, NX, NXX, NOQB
      COMMON /TTR/ KR, KND, NLD
      COMMON /OBL/ JOBL, WOBL, BOBL, COBL
      COMMON /OM/ NOM, OMIT
      COMMON /REC/ LSEE, RECORD
      COMMON /CM/ CUM
      COMMON /CF/ CF
C       KR > 0 tells function TR to use surrogates for 8-bit ASCII characters
C       NLD=1 flags unavailability of line-draw in printer
      LO(I,J) = J*(J-1)/2 + I
      IDF(I,J) = I*(2*NF-I+1)/2 + J+1
      DATA QB,QBB,QL,QN,QPR/5*.FALSE./, NEW,NOPLOT,KOM/2*1,2/, MUTE/10/,
     +     IER,KB,KD,KFB,KODE,MTH,NFIX/7*0/, DSP/'     '/, NPC/100/
C       QBB=T first flags not-yet-allocated; afterward, block spacing in output.
C       NOQB>0 flags logged rotations wherein HYBLOCKing has been released
C       KFB>0 flags that input source is a bootstraps sample.
C       MTH=0 flags that rotated pattern isn't a suitable bootstraps target,
C          mainly for datasource not D-file, or pattern from HYBLOCK, or
C          item names not available.  ABS(MTH) = 1,..,5 tells factoring method;
C          MTH>0 (<0) flags pairwise (listwise) missing-data treatment.
      DATA WRD/'STEP/S','STEP/P','SCAN/S','SCAN/P','OBLMIN'/
C*Q      DATA NR/0/  ! Quad-factoring needs NR
      NOQB = 0  ! Flags release of HYBLOCKing in Hybuf records
      LM = 3    ! Initialize longest namelength
      NB = 0    ! NB is in COMMON, so can't initialize in DATA
      KR = 0    ! ****** This and function TR need to be deleted
      CS = '$'; IF(KND>0) CS = '#' ! Use # to mark SEE-file for Unix
      OPEN(11,STATUS='SCRATCH',FORM='UNFORMATTED')
      OPEN(24,STATUS='SCRATCH',FORM='UNFORMATTED'); WRITE(24) 0,0,0,0
      OPEN(2,STATUS='SCRATCH') ! ^F24 passes Spin params to BOOTDATA

CC TEST LINES
C     OPEN(21,FILE='JUNK')

C  Set default parameters and other initializations
      KP = 80; LD = 2   ! KP = 132
C       KP sets print columns, LD sets number of decimals in display.
      CALL SYSTEM('cls'); TT=TM(1) ! ?? Initializing timer needed ??
      CALL PRNT(0,KP,6)
      NLD = 0; IF(KP==81.OR.KP>132) NLD = 1  ! NLD=1 flags no printer line draw
      FMT = '(4X,7X,2(2X,5A5),90(:/13X,2(2X,5A5)))'   ! Screen display of input
      IF(KP<=100) FMT1 = FMT
      IF(KP>100) FMT1 = '(4X,7X,4(2X,5A5),90(:/13X,4(2X,5A5)))'
      LIM=10; MODE=1; PD1=.5; DF=.6; BH=.20; FINE=.05; GAM=0; CUM = 0.
C        LIM is HYPGET limit on polish-stroke iterations; PD1 is a damping coeff.
C        for STEP polish-stroking; DF is a damping coefficient for global rotation
C        shifts; FINE is initial STEP size; GAM is Oblimin parameter
      NB=0;NX=0;NXX=0; NPFIX=0; NTOT=0; TOL=1.0; WSAL=0.;JA=2;JB=2;CV=1.
C        JA,JB,CV,WSAL are MISFIT parameters
      IMAX=50; B0=60.; B1=15.; DB=5.  ! B0,B1,DB are STEP parameters
      CH = ' '   ! Shouldn't really need this
      CALL GETSIZ(NEW,MV,MF,NX,QB,F1,F4,CHV,KFB)
      MC = LO(MF,MF); MT = 2*MF+2; MV = MV+NX  ! NX not yet flagged
C          Need MT = NF+3, but no larger except for Quad-factoring?

      ALLOCATE ( FIX(MF), KTL(MF,MF+1), LMP(MV+MSEE), LST1(MV),
     +   LST2(MV), ORDER(MF), TMP(MV), PFIX(MV), IDENT(MV) )
      ALLOCATE ( A0(MV,MF), A1(MV,0:2*MF), C1(MF,MF), CFF(MC), CG(MC),
     +       COMM(MV), DG(MF), T1(MV,MT), W(MV,MF) )
      IDENT = '??      '; CFF = 0.

C Paths from start to Main Menu access. (FIX affects Waif,Orthomax operations)
C 1. New input not from HYBLOCK: NX=0 unless direct input from MODA stipulates
C      NX  1 X-set factors; create FIX list of factor blocking (NX zeros, the
C      rest 99); no Waif pruning but initial Orthomax rotation; set NB=0, QB=F;
C      leave list LST2 of items' factor-block assignments empty, include NX in
C      NV and minus-flag NX before returning from GO.
C 2. New input from HYBLOCK: Set NX=0, QB=T; read block info FIX,LST2,FIX1 from
C      input; prune received Waifs; initial Orthomax rotation within blocks.
C 3. Reload from logfile: Determine QB; load initial LST2,FIX1 but FIX stays
C      empty until read from last rotation; no Waif,Orthomax operations.
C      NX retains flagged input value and is used only for BOOTDATA and
C      FAC-files.  Item blocking LST2 is always all-0 except for HYBLOCK input.

999   CALL GO(NEW,MV,MF,QB,QL,NTOT,NV1,NF1,KODE,NFF1,NFQ,MTH,NX,NB,KFB,
     +         LM,F1,F2,F4,WORD,IDENT,LST1,LST2,FIX,NFIX,FIX1,A0,CFF)
      OPEN(19,FORM='UNFORMATTED',STATUS='SCRATCH') ! Store fallback in ROTATE/SPIN
C       KFB>0 flags bootstrap input for final collection by BOOTSUMM
      CVAR = FLOAT(ABS(KODE)/1000000)/100
      KOD = MOD(ABS(KODE),1000000)
      KIND = MIN(1,NFF1-NF1)
C       KIND=1 if the input file is for quadratic data; KIND=0 if the input
C       file identifies itself as containing just 1st-level data
      NV = NV1-KIND; NF = NF1-KIND; NFF = NF*(NF+1)/2
      IF(KODE<0 .AND. KIND==1) KD = MOD(KODE-1,2) - 1
C       For artificial GENQ1/GENQ2 data, KD becomes -1/-2. Only case KD=-2
C       receives special treatment.
      N = 2*NF+KIND*(NF+1)*(NF+2)
      IF(N>MT) WRITE(6,'(" ***  ALLOCATION ERROR: For this prob",
     +  "lem, parameter MT must be at least",I4)') N
      IF(N>MT) STOP
      CALL LAST(LF4,F4,12)
      A1 = 0.
      DO J = 1,NF
        ORDER(J) = J
        DG(J) = J
        DO I = 1,NV
          A1(I,J) = A0(I+KIND,J+KIND)
        END DO
        DO I = 1,J
          C1(I,J) = CFF(LO(I+KIND,J+KIND))
          C1(J,I) = C1(I,J)
        END DO
      END DO
      COMM = 0.
      LMP = 0
      DO I = 1,NV
        DO J = 1,NF; DO K = 1,NF
          COMM(I) = COMM(I) + A1(I,J)*C1(J,K)*A1(I,K)
        END DO; END DO
      END DO
      OPEN(14,STATUS='SCRATCH',FORM='UNFORMATTED') ! ********  Delete if KNORMing
      WRITE(14) (SQRT(MAX(.1,COMM(I))),I=1,NV)     ! ********  proves unhelpful
      LG = 1
C If pattern is from HYBLOCK, allow permutation/deletion of some or all Waifs
C When start is from logfile, FIX is 0 at this point
      IF(.NOT.QB) GOTO 75
      CUT = .20
      K = 1
60    K = K+1
      IF(K<NF .AND. FIX(K+1)>=0) GOTO 60  ! K is the last non-Waif pattern column
      LW = NF-K   ! LW is the received number of Waifs
      BIGIF1: IF(K<NF-1) THEN  ! %%% flags start and finish of Long IF
        WRITE(6,'(" Doing Varimax rotation of ",A," Waif factors")')
     +    CF(:JF(LW))
        CALL VARIM(NV,LW,A1(1,K+1),MV,1.,IER)
        CALL RMS(NV,LW,A1(1,K+1),MV,DG,ORDER(K+1))  ! ORDER returns Put sequence
        DO J = K+1,NF
          ORDER(J) = ORDER(J)+K  ! Indices returned by RMS have K subtracted
          DG(ORDER(J)) = J  ! Use this to hold concatenated Get
        END DO
        L = LW
        CALL PERM(ORDER,FIX,1,-1,A1,C1,W,QB) ! -1 flags to permute pattern only
63      DO J = 1,L
          DE(J) = 0.; N = 0
          DO I = 1,NV
            Q = ABS(A1(I,J+K))
            IF(Q>CUT) DE(J) = DE(J)+Q  ! Sum loadings over CUT
            IF(Q>CUT) N = N+1          ! Count  "       "   "
          END DO
          LMP(J) = N    ! Number of loadings greater than CUT
          IF(N>=1) DE(J) = DE(J)/N  ! Mean loading greater than CUT
        END DO
        DO I = 1,NF-K
          DE(I) = MAX(1.E-8,DE(I))
        END DO
        WRITE(6,'(/4X,"This HYBLOCK-structured input includes ",A,
     +    " Waif factors.  For each of"/4X,"these, the mean size",
     +    " (and number) of its loadings over Cut = ",A3," is"/
     +    10(:/5X,8(A5,"(",A,")")))') CF(:JF(NF-K)), CLN(CUT,3,2),
     +    (CLN(DE(I),5,3),CF(:JF(LMP(I))),I=1,NF-K)
66      WRITE(6,'(/4X,"To delete these from the pattern, hit RETURN.  ",
     +    "Otherwise, enter the"/4X,"number of leading Waifs to be ret",
     +    "ained, or any letter to keep all."/4X,"To see Mean(Count) a",
     +    "t a different size level, enter new Cut less"/4X,"than .99.",
     +    "  Or shift two or more Waifs to head the list by entering"/
     +    4X,"their present list positions in your choice of order.  ",
     +    "(You need only"/4X,"list the ones you want to promote.)"/)')
        CALL SCAN(J,0,'R',5)
        IF(J==0) L = 0
        IF(J==1) THEN
          READ(2,*) CUT
          IF(ANINT(CUT)==CUT) THEN       ! Input is integer, so L
            L = MAX(1,MIN(LW,NINT(CUT)))   ! tells how many to keep
         ELSE
            IF(CUT>1.) GOTO 66  ! Improper input, so try again
            GOTO 63
          END IF
        ELSE IF(J>1) THEN
          READ(2,*) (DE(I),I=1,J)
          DO I = 1,L+J
            IF(I<=J) LMP(I) = NINT(DE(I))
            IF(I>J) LMP(I) = I-J  ! Fill tail of LMP with all the Waif indices
          END DO
          M = 1
          LP1: DO I = 2,L+J  ! Pick out of LMP the distinct indices in order
            DO JJ = 1,I  ! Doesn't JJ from 1 to M suffice?
              IF(JJ<=M .AND. LMP(I)==LMP(JJ)) CYCLE LP1
            END DO
            M = M+1
            LMP(M) = LMP(I)
          END DO LP1   ! LMP is in Get sequence
ccc            get(i+k) = dg(k+lmp(i))    (Get from raw input)
ccc            put(k+lmp(i)) = i+k        (Put from varimax output)
          DO J = 1,NF
            IF(J<=K) ORDER(J) = J
            IF(J>K) ORDER(K+LMP(J-K)) = J  ! ORDER is Put seqence for PERM
70          IF(J>K) DE(J) = DG(K+LMP(J-K))
          END DO
          DO J = K+1,NF
            DG(J) = DE(J)  ! DG holds concatenated (global) Get
          END DO
          CALL PERM(ORDER,FIX,1,-1,A1,C1,W,QB) ! -1 flags to permute pattern only
          GOTO 63
        END IF
        DG(1) = -NF ! Input NF
        DG(2) = K   ! Number of non-Waifs
        DG(3) = L   ! Number of retained Waifs
        NF = K+L    ! Provisionl new NF
        NFF = LO(NF,NF)
        NF1 = NF+KIND  ! Because Hybuf rec. 0 writes NF1
        NFF1 = NF1     ! These differ only in quadratic factoring
        NFQ = NFF      ! Likewise
        WRITE(6,'(/10X,"Hit RETURN to continue with ",A," Waif fact",
     +    "ors retained,"/10X,"or abort run with CTRL-C to start ag",
     +    "ain.")') CF(:JF(L))
        READ(5,'(A1)')
      END IF BIGIF1    ! %%% flags start and finish of long IF
C Display factor pattern/covariances to be rotated
75    CALL LAST(LF1,F1,12)  ! MODA-input name is in F1
      CALL QUIZ(A1,C1,NTOT,X,IMX,JMX,0)
      LMP = 0
      WRITE(6,'(/" Pattern of ",A," items on ",A," factors received ",
     +  "from ",A,", Code No. ",A,A3)') CF(:JF(NV)), CF(:JF(NF)),
     +  F1(:LF1), CF(:JF(KOD)), CLN(CVAR,3,2)
      IF(NF>12) WRITE(6,'(17X,"(Communalities are in parentheses)")')
      CALL SHOW(6,FMT,QBB,LST2,COMM,A1,C1,NB,K,2)  ! K is a dummy here
      IF(.NOT.QB .OR. IDENT(1)(:2)=='??') GOTO 80
      WRITE(6,'(/" This initial pattern was structured by HYBLOCK. ",
     +  "To see the items'' block"/" assignments, enter anything.  ",
     +  "Otherwise, hit RETURN to waive this report.")')
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 80
      NL = MIN(9,70/(5+LM))      ! LM is max namelength
      WORD(:55) = '(" Block ",A,": ",5(I4,":",A):/50(10X,5('//
     +            'I4,":",A):/))'
      WORD(19:19) = CF(:JF(NL))  ! Number of names per line (  9 )
      WORD(39:39) = WORD(19:19)
C       (' Block ',A,': ',5(I4,':',A):/50(10X,5(I4,':',A):/))
      M = 0
      DO K = 0,NB  ! Get items in block K
        N = 0
        DO L = 1,NV
          IF(LST2(L)/=K) CYCLE
          N = N+1
          TMP(N) = L    ! Assemble list of Block-K items
        END DO
        J = 1+(N-1)/NL
        IF(J>3 .AND. M+J>=21) THEN
          CALL WAIT(1)
          M = 0
        END IF
        IF(N>0) WRITE(6,WORD(:66)) BN(K),(TMP(I),IDENT(ABS(TMP(I)))
     +    (:LM),I=1,N)
C        IF(N>0) WRITE(6,'(" Block ",A,":",5(I4,": ",A):/
C     +    50(10X,5(I4,": ",A):/))') BN(K),(TMP(I),IDENT(ABS(TMP(I)))
C     +    (:LM),I=1,N)  ! N is number of items listed in TMP
        IF(N>0) M = M+J  ! Number of lines to show block
      END DO
      N = 0
      DO L = 1,NV
        IF(LST2(L)==99) N = N+1
      END DO
      IF(N>0) WRITE(6,'(" Block ",A,":   The ",A," remaining ite",
     + "ms.")') BN(99), CF(:JF(N))
      WORD(:3) = 'ed '
      L = 3
      IF(QLOG(F1)) L = 1
      WRITE(6,'(/5X,"Later, you can see the factor blocking for any ",
     +  "active pattern by"/5X,"calling Main Menu option 9.  It may ",
     +  "not be the same for all stored"/5X,"patterns if you tinker",
     +  A,"with this after loading the input pattern.")') WORD(L:3)
      CALL WAIT(1)
C
C Transfer input data to SEE file
80    IF(F1(:6)=='INHYBL') THEN
        F3 = CS//'HYBL.H'//CHAR(48+MOD(NF,10))//'    '
        IF(NF>9) F3(8:9) = CHAR(48+NF/10)//CHAR(48+MOD(NF,10))
        MM = 5
        LL = 8
        GOTO 87
      END IF
      L = 1
85    L = L+1
      IF(L<=8 .AND. F1(L:L)/='.' .AND. F1(L:L)/=' ') GOTO 85
      K = L-1 ! Rightmost char left of dot is not a numeral when from HYBLOCK
86    K = K-1
      J = ICHAR(F1(K:K))
      IF(J>=48 .AND. J<=57) GOTO 86
C       L is position of ext. dot in F1; K is end of chars left of number code
      M = MIN(K,8+K-L) ! M is the number of usable start letters in F1
      F3 = CS//F1(:M)//F1(K+1:L)//'H'//F1(L+2:L+3)//'  '
      MM = 1+MIN(K,6+K-L) ! End of usable start of F3
      LL = M+2 ! Start of base-end digits in F3
C        FAC-filename will be 'FAC'//F3(2:MM)//F3(LL:) [No longer put into F2]
87    OPEN(7,FILE=F3)
      CALL PRNT(1,KP,7)
      WRITE(7,'(" HYBALL rotation of factor pattern with code No. ",A,
     +  A3," in file ",A)') CF(:JF(KOD)), CLN(CVAR,3,2), F1
      CALL DAY(7)
      IF(F2(:3)=='   ' .OR. IDENT(1)(:2)=='??') THEN
        WRITE(7,'(/" Names for the variables are unavailable.")')
        GOTO 91
      END IF
      TMP = (/(I,I=1,MV)/)
      IF(IDENT(1)(:1)=='[' .AND. ABS(LST1(NV))>NV) THEN
        WRITE(7,'(/" Surrogates for the variables'' unavailable nam",
     +    "es created from their COV-file indices:")')
      ELSE
        WRITE(7,'(/" The variables are named")')
      END IF
      CALL SEENAM(NV,IDENT,TMP,1,KP-1,LM,7)
      QN = .TRUE.  ! Flags presence of names; used in SCHEMA
      N = 0
      DO I = 1,NV
        IF(LST1(I)<0) N = N+1
        IF(LST1(I)<0) TMP(N) = ABS(LST1(I))
      END DO
      IF(N==0) GOTO 91
      CALL LAST(LF4,F4,12)
      CALL LAST(L,F2,12)
      WRITE(7,'(/1X,A," of these have been reflected from their orien",
     +  "tation in ",A,", namely,")') CF(:JF(N)), F2(:L)
      CALL SEENAM(N,IDENT,TMP,0,KP-1,LM,7)
91    WRITE(7,'(/" The input pattern (and communalities) of ",A," va",
     +  "riables on ",A," factors is")') CF(:JF(NV)), CF(:JF(NF))
      CALL SHOW(7,FMT1,QBB,LST2,COMM,A1,C1,NB,K,2)  ! K is a dummy here
      IF(QB) THEN   ! This info is wiped under abbreviated Option 10 output
        WRITE(7,'(/" This pattern arrived from HYBLOCK with the varia",
     +    "bles variously assigned to blocks")')
        IF(KP>=100) WRITE(7,'(10(:/10(2X,5A2)))')(BN(LST2(I)),I=1,NV)
        IF(KP<100) WRITE(7,'(20(:/6(2X,5A2)))')(BN(LST2(I)),I=1,NV)
        N = -NINT(DG(1)); K = NINT(DG(2)); L = NINT(DG(3)) != NF-K
C         ^Input NF         ^No. non-Waifs   ^No. Waifs retained
        IF(N>NF) THEN    ! N-K = Total no. of Waifs;
          WRITE(7,'(/" It initially contained ",A," factors of which ",
     +      A," were Waifs.  After Varimax rotation of the Waifs,")')
     +      CF(:JF(N)), CF(:JF(N-K))
          IF(L==0) WRITE(7,'(" all were discarded.")')
          IF(L==N-K) WRITE(7,'(" all were retained.")')
          IF(L>0.AND.L<N-K) WRITE(7,'(1X,A," were discarded.  P",
     +      "ost-Varimax indices of the ",A," retained:",30(1X,A))')
     +      CF(:JF(L)), CF(:JF(NINT(DG(3)))), (CF(:JF(NINT(DG(KD+I)))),
     +      I=K+1,NF)
        END IF
      END IF
C*Q      IF(KIND==1) WRITE(7,915) (CLN(CFF(I),6,LD),I=1,NFQ)            !C**Q
C*Q915   FORMAT(/' These covariances are the 1st-level part of factor ', !C**Q
C*Q     + 'quad-moment array'/90(10(/4X,10A6,3X,10A6)))                  !C**Q
      IF(-NX==1 .AND. KB==0) WRITE(7,'(/" (The first factor is a ",
     +  "manfest-input variable.)")')
      IF(-NX==1 .AND. KB>0) WRITE(7,'(/" (The first factor is align",
     +  "ed with dichotomous manifest input.)")')
      IF(-NX>1 .AND. KB==0) WRITE(7,'(/" (The first ",A," factors ",
     +  "are manifest-input variables.)")') CF(:JF(-NX))
      IF(-NX>1 .AND. KB>0) WRITE(7,'(/" (The first ",A," factors are",
     +  " aligned with manifest inputs, ",A," of them dichotomies.")')
     +  CF(:JF(-NX)), CF(:JF(KB))
C Retrieve HYBUF patterns or store new start
      IF(NEW>=1) GOTO 98   ! NEW=0 is Logfile reload; NEW=1,2 is external
      READ(8,END=97) NN, (X,I=1,NV*NF+NF*NF+7), KB, (OMIT(I),I=1,KB)
      BACKSPACE 8; IF(KB==0) GOTO 95  ! ^ Reading rec NN=1 (NN=0 read in GO)
C       Rec 1 contains Off-norm info in OMIT if KB > 0
        OPEN(33,FORM='UNFORMATTED')  ! If opened, never closed
        WRITE(33) KB, (OMIT(I)*.0001,I=1,KB); REWIND 33
95    READ(8,END=97) NN, ((A1(I,J),I=1,NV),J=1,NF)
      NTOT = NN
      CALL BUFF(0,A1,C1,FIX)
      GOTO 95
97    NN = NTOT
      BACKSPACE 8
      BACKSPACE 8
      READ(8) NN, ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF),
     +  LIM, BH, CV, JA, JB, WSAL, PD1, NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX, (PFIX1(I),
     +  I=1,NPFIX), B0, B1, DB, DF, TT, I, JJ, T, JFLAG  ! ********* JFLAG recalled heare
      MODE = MOD(JFLAG/1000,10)
      IF(MODE==4) GAM = T
      JFL = JFLAG/100000
      PFIX = 0   ! Unspecified PFIX seems to be causing trouble
      CALL REPFIX(NF,NPFIX,PFIX,PFIX1,1)
      L = 5
      CALL BLOCK(L,QB,NF,FIX,PFIX,KTL,WORD,MF)
      CALL TELL(NN,JFL,WRD(MODE),NOM,NPFIX,WORD,C1)  ! Need NOM but not OMIT
C            ! WORD(1:2) passes factor-constraint info from BLOCK
      IF(JJ>1000) THEN
        JJ = JJ/1000; QB = .FALSE.
        WRITE(6,'(" > NOTE: The freeze on factor blocking set by HYB",
     +    "LOCK was lifted after"/10X,"storage of pattern No. ",A,".")')
     +    CF(:JF(JJ-1))
      END IF
      JFLAG = MOD(JFLAG,10000)
      GOTO 145
98    CH = QFMT('HYBUF')   ! Check whether HYBUF is present
      IF(CH/='U') CALL SYSTEM('copy HYBUF HYBUF.OLD >nul')
      OPEN(8,FILE=F4,FORM='UNFORMATTED')
      N = NX  !  Reminder: NX is minus-flagged, is needed for setting BOOTDATA
      IF(QB) N = NV1  !; IF(QB) KODE = -(ABS(KODE)) << HYBLOCK already flags this
      WRITE(8) NTOT, NV1, NF1, KODE, NFF1, NFQ, MTH, ((A0(I,J),I=1,NV1),
     +  J=1,NF1), (CFF(I),I=1,NFQ), F1, F2, (LST1(I),I=1,NV1), N,
     +  (LST2(I),I=1,MAX(0,N)), NB, (FIX1(I),I=1,NB) ! In Quad-factoring, NFQ >> NFF1
CCC     If input from HYBLOCK, N=NV and LST2 holds items' block assignments;
CCC         otherwise, N=-NX and LST2 is empty
CCC     FIX record can be added but serves no real point since FIX (also FIX1)
CCC     can be pulled from Rec. 1.  When Waifs are cut from HYBLOCK input, only
CCC     reduced NF is available to record in Rec. 0.
CCC     F1 is the pattern input file, F2 is its COV-file origin.
      JFLAG = 301000
      KB = NOM     ! No. of binaries listed by GO in OMIT to save in Rec 1
      CALL BUFF(1,A1,C1,FIX); NOM = 0
C       Raw SDs of now-standardized binary X-items are now stored in Rec 1 OMIT
C       Input-form info stored as record No. 0 is also stored as Rec No.1 in
C       HYBUF-retrieval form with Type=3, MODE=1
      NN = NTOT
C       NN indexes the pattern currently active
      IF(NEW==0) GOTO 145
C   EQUAMAX/VARIMAX pre-rotation; omit if input is not orthonormal or from HYBLOCK
      IF(OBQ(C1,0)<.001 .AND. .NOT.QB) CALL VVAR(NEW,A1,C1,W,FIX,NB,
     +  ABS(NX),ORDER,JFLAG)
C Enter controls
      WRITE(6,'(/" Standard rotation controls are now in force. To re",
     +  "view or alter these,"/" choose Option 1 at the Main Menu.")')
      CALL BLOCK(0,QB,NF,FIX,PFIX,KTL,WORD,MF)
      GOTO 145
C   Set control parameters
128   CALL CONTRL(A1,WRD,KR)
      JFLAG = JFLAG+(MODE-MOD(JFLAG/1000,10))*1000  ! Update MODE in JFLAG
C   Revise lists of data points to be disregarded in hyperplane search
160   IF(NEW>=1 .OR. NOM==0) GOTO 145
      WRITE(6,'(/" If you wish to clear all item exclusions, enter an",
     + "ything.  Otherwise,"/" hit RETURN to leave the OMIT list unch",
     + "anged."/)')
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 145
      NOM = 0; OMIT = 0
      WRITE(6,'(/" All item exclusions have been removed.  To reins",
     + "tate the list just cleared,"/" elect Main Menu Option 6 and ",
     + "retrieve pattern No. ",A,".")') CF(:JF(NN))
C  Set subroutine parameters
145   CALL AUXPAR(CV)
      NEW = 0
      CALL RELOAD(NN,A1)
      GOTO 300
C
C     Try SPIN search for better hyperplanes.
170   NOLD = NTOT
      MAXSPN = MIN(MREC-NTOT,99)
C       MAXSPN greater than 99 requires reprogramming of solution ordering
C         in SPIN array RR as well as increase in parameter MRR
      IF(MAXSPN<20) WRITE(6,'(/" WARNING.  Allocated space remaining ",
     + "for pattern storage will allow only"/8X,"the",I3," best Tries",
     + " to be saved on any one Spin call.")') MAXSPN
      CALL SPIN(A1,T1,C1,CG,FIX,PFIX,NPFIX,KTL,COMM,NTOT,NN,IMAX,LMP,
     +          LG,MAXSPN,W,WRD(MODE))
      IF(NOLD==NTOT) GOTO 300
      INQUIRE(9,OPENED=QS)
      IF(.NOT.QS) GOTO 300
      IF(NPFIX>0) WRITE(9,'(" Factors on which pattern was fixed:",
     +  30I3)') (PFIX1(I),I=1,NPFIX)
      DO K = 6,9,3
        IF(LG==1) WRITE(K,'(3X,"Lump Count of close matches to the ",
     +    "best distinct patterns from latest Spin:",20(/3X,5("No.",
     +     I3," (",I3,")",:,";  ")))') (I,LMP(I),I=NOLD+1,NTOT)
        IF(LG==0) WRITE(K,'(3X,"Total accumulated Lump Count of clos",
     +    "e matches from Spin to ALL Hybuf records:",20(/3X,5("No.",
     +    I3," (",I3,")",:,";  ")))') (I,LMP(I),I=1,NTOT)
      END DO
      LG = ABS(LG)
      GOTO 174
C
C Commence cycles of HYBALL rotation
172   WRITE(6,'(/" Rotation is now executing. Wait for it.")')
      CALL ROTATE(KTL,A1,C1,W,T1,CG,DE,DG,FIX,PFIX,WSAL,IER)
174   CALL WAIT(1)
C
C Provide menu of branch alternatives
300   WRITE(6,'(//" At this point, you can do any of the following:")')
      J=15; K=36; IF(QB) J=1; IF(WSAL<0.) K=16; CH4 = CLN(-WSAL,3,2)
      L = 42; IF(MODE==4) L = 37
C      WORD(:31) = ' WITHIN BLOCKS. Comp2-weighted '
      WORD(:42) = ' WITHIN BLOCKS. Comp2('//CH4(:3)//')-weighted       '
      IF(MODE>3) THEN
        CH4(:1) = '('; CH4(2:4) = CLN(GAM,3,2); WORD(37:42) = CH4//') '
      END IF
      WRITE(6,'(/8X,"1. Revise rotation parameters.")')
      WRITE(6,980) WORD(K:36), WRD(MODE), WORD(L:42), CF(:JF(NN)),
     +  WORD(J:15), WORD(K:36), WRD(MODE)
980   FORMAT(8X,'2. Execute',3A,'rotation of pattern No. ',A,'.'/
     +  8X,'3. Inspect tables of the present pattern/correlations.'/
     +  8X,'4. Examine graphic plots of the current factor planes.'/
     +  8X,'5. Permute/reflect factor axes',A,/
     +  8X,'6. Recall some other stored pattern.'/
     +  8X,'7. Try SPIN search by',2A,' rotation.'/
     +  8X,'8. Show congruence of current pattern to other patterns.'/
     +  8X,'9. Inspect/change rotation constraints.'/
     +  7X,'10. Print results without plane plots, maybe stop.'/
     +  7X,'11. Print results with optional plane plots, and stop.')
      IF(MTH/=0) WRITE(6,'(7X,"12. Select Pattern No. ",A," for",
     +       " bootstrap sampling study.")') CF(:JF(NN))
      IF(KD==-2) WRITE(6,'(7X,"13. Match current pattern/quad-mom",
     +  "ents to source structure.")')
      WORD = 'without printing.'; IF(QPR) WORD = 'this run.         '
      WRITE(6,'(/" Enter the index of your choice, or any letter to ",
     +  "Quit ",A)') WORD(:17)
      IF(NPFIX/=0) WRITE(6,'(5X,"(NOTE: Pattern fixations are curr",
     +  "ently in force.)")')
      WRITE(6,'()')
      CALL SCAN(JJ,1,'I',5)
      IF(JJ==0) GOTO 300
      IF(JJ<0) THEN
        WRITE(6,'("  *****  Terminating rotation of patterns archiv",
     +    "ed in ",A)') F4
        GOTO 450  ! GOTO 451 does not delete the Hyball-output file
      END IF
      READ(2,*) M
      GOTO (128,172,230,244,330,202,170,210,240,260,259,350,238), M
901   WRITE(6,'(/" Numeral ",A," is not an operative choice.  Try ",
     +  "again.")') CF(:JF(M))
      GOTO 300
C
C Retrieve a pattern produced previously
202   REWIND 11  ! Buffer latest controls
      WRITE(11) LIM, BH, CV,JA,JB, WSAL, PD1, NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX,
     +  (PFIX1(I),I=1,NPFIX), B0, B1, DB, DF, TOL, IMAX, MODE
      BB = BH; IF(BH>=1.) BB =.20
      L = 20/((LSEE+7)/8)  ! Max number of full pats showable without page break
      KK = 1; IF(NTOT>L) KK = 5  ! KK also picks length of DSP
203   IF(KK==1) DSP = '     '; IF(KK==1) CH4 = 'less'
      IF(KK>1) DSP = 'mean '; IF(KK>1) CH4 = 'more'
      WRITE(6,'(/" You have stored ",A," patterns, whose ",A,"of  ",
     +  A3," hyperplane percentages are")') CF(:JF(NTOT)), DSP(:KK),
     +  CLN(BB,3,2)
      IF(KK>1) THEN   ! Show only means over factors
        WRITE(6,'(15(8(I4,A,A4),:/))') (I,':',CLN(.1*RECORD(I,0),
     +    4,1),I=1,NN-1), NN,'',CLN(.1*RECORD(NN,0),4,1), (I,':',
     +    CLN(.1*RECORD(I,0),4,1),I=NN+1,NTOT)
      WRITE(6,'(" The pattern marked ""  "" is currently active.")')
      ELSE               ! Show individual factors
        DO I = 1,NTOT
          CH = ' '; IF(I==NN) CH = '>'
ccc          IF(NPFIX==NF) CH = '-'             ! This flags that all factors
ccc          IF(CH=='-' .AND. I==NN) CH = '='   ! are aligned with items.
          WRITE(6,'(1X,A,I3," (Av =",A5,") ",20I3,8(:/20X,20I3))') CH,
     +      I, CLN(.1*RECORD(I,0),5,1), (RECORD(I,J),J=1,LSEE)
          M = 1+(LSEE-1)/20
          IF(MOD(I,20/M)==0.AND.I<NTOT) CALL WAIT(0)
        END DO
      WRITE(6,'(" The pattern marked "" > "" is currently active.")')
      END IF
      WRITE(6,'(/"   Enter the number N indexing the pattern you wa",
     +  "nt, or any letter to"/"   see a ",A," detailed display.  ",
     +  "Otherwise,  hit RETURN to abort."/"   To delete all patter",
     +  "ns stored after the one selected, enter -N."/)') CH4
      CALL SCAN(J,1,'I',5)
      IF(J==0) GOTO 300
      IF(J<=-1) THEN
        KK = 6-KK
        GOTO 203
      END IF
      READ(2,*) MM
      NK = MIN(NTOT,MAX(1,ABS(MM))); MM = SIGN(NK,MM)
205   REWIND 8
206   READ(8) J
      IF(J<NK-1) GOTO 206
      READ(8) NK, ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF),
     +  LIM, BH, CV, JA,JB, WSAL,PD1, NOM, (OMIT(I),I=1,NOM), (FIX(I),
     +  I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX, (PFIX1(I),I=1,NPFIX),
     +  B0, B1, DB, DF, TOL, IMAX, J, T, JFLAG    ! ******** JFLAG recalled here
      MODE = MOD(JFLAG/1000,10)
      IF(MODE==4) GAM = T  ! GAM's negation is Oblimin's Gamma parameter
      JFL = JFLAG/100000
      IF(OBQ(C1,0)<.001) MODE = 1  ! Orthogonal patterns are stored with STEP/P
      WORD(:2) = '  '
      CALL TELL(NK,JFL,WRD(MODE),NOM,NPFIX,WORD,C1)
      WORD(:22) = ' and deletion option.)'; K = 1; IF(MM>0) K = 21
      WRITE(6,'("   Choose:"/5X,"To recall this pattern with its sto",
     +  "red controls, hit RETURN."/5X,"To recall this pattern while",
     +  " retaining your currently active"/7X,"control settings, ent",
     +  "er any letter."/5X,"To consider recall of some other patter",
     +  "n, enter its index N."/7X,"(N = 0 will repeat the pattern d",
     +  "isplay",A/)') WORD(K:22)
      CALL SCAN(J,0,'I',5)
      IF(J>0) THEN
        MM = 0                          !  Wipe exclusion flag if set
        READ(2,*) NK
        IF(NK<1 .OR. NK>NTOT) GOTO 203  ! If out of range, repeat pattern display
        GOTO 205                        ! Show another pattern
      ELSE IF(J<0) THEN  ! Accept picked pattern but not its controls
        REWIND 11
        READ(11) LIM, BH, CV, JA,JB, WSAL, PD1, NOM, (OMIT(I),I=1,NOM),
     +    (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX,
     +    (PFIX1(I),I=1,NPFIX), B0, B1, DB, DF, TOL, IMAX, MODE
        WRITE(6,'(5X,"Done: Latest control settings are retained.")')
      ELSE               ! Accept picked pattern and also its controls
        CALL RELOAD(SIGN(NK,MM),A1)  ! Get new hyperplane count
        CALL REPFIX(NF,NPFIX,PFIX,PFIX1,1)
        L = 5
        CALL BLOCK(L,QB,NF,FIX,PFIX,KTL,WORD,MF)
C        L returns 5 plus the number of factors aligned by SPIN with variables.
        CH = '.'
        IF(L>6) CH = 's'
        IF(L>5) WRITE(6,'(" WARNING: Recall of this pattern has react",
     +    "ivated SPIN fixation of ",A," factor",A/" To remove this, ",
     +    "either start SPIN again or call Main Menu Option 9.")')
     +    CF(:JF(L-5)), CH
      END IF
      CALL AUXPAR(CV); NN = NK
      JFLAG = NN + MODE*1000  ! New JFLAG starts with recalled MODE and Rec No.
      IF(MM>=0) GOTO 300
      J = JF(NN)
      WRITE(6,'(/6X,70A)') TR(''), (TR(''),I=1,65), TR('')
      WRITE(6,'(6X,A," Unless you abort run by hitting CTRL-C, all ",
     +  "patterns now stored ",A/6X,A,"   after No. ",A," will be er",
     +  "ased when you hit RETURN to continue.",4A)') (TR(''),I=1,3),
     +  CF(:J), (' ',I=1,4-J), TR('')
      WRITE(6,'(6X,70A)') TR(''), (TR(''),I=1,65), TR('')
      READ(5,'()')
      ENDFILE 8
      DO I = NN+1,NTOT
        LMP(I) = 0
      END DO
      NTOT = NN
      GOTO 300
C
C Report congruence divergences from other patterns
210   CALL SYSTEM('cls')
      IF(NPC/=NN) THEN
        NPB = NPC; NPC = NN  ! NPB is target pattern on last Option 8 call
      END IF
      WRITE(6,'(/" Congruence match (degrees divergence) of patt",
     +  "ern No. ",A," with patterns")') CF(:JF(NN))
      INQUIRE(17,OPENED=QS); IF(QS) CLOSE(17) ! WHY ???
      OPEN(17,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +  RECL=4*(NF+3))
      REWIND 8
      READ(8) J   ! Skip record 0
      DO K = 1,NTOT
        IF(K/=NN) THEN
          READ(8) J, ((T1(I,L),I=1,NV),L=1,NF)
          CALL ALIGN(T1,A1(1,1),ORDER,DG,NV,NF,CH,AV,HI,MV)
          WRITE(17,REC=J) AV, (DG(I),I=1,NF), CH
          DE(K) = AV
        ELSE
          READ(8) J
          WRITE(17,REC=J) 999999., (0.,I=1,NF)
          DE(K) = 999999.   ! So CLN will return asterisk string
        END IF
      END DO
      IF(NPB>NTOT .OR. NPB==NPC) THEN
        WRITE(6,'(15(8(I4,":",A4),:/))') (I,CLN(DE(I),4,1),I=1,NTOT)
        WRITE(6,'(/8X,"*** marks the currently active pattern")')
      ELSE
        WRITE(6,'(15(8(I4,A,A4),:/))') (I,':',CLN(DE(I),4,1),I=1,NPB-1),
     +    NPB,'',CLN(DE(NPB),4,1), (I,':',CLN(DE(I),4,1),I=NPB+1,NTOT)
        WRITE(6,'(/4X,"*** marks the currently active pattern, flags",
     +    " the last checked previously")')
      END IF
      WRITE(6,'(/"  Hit RETURN if this summary is all the congruence ",
     +  "information you want."/"  Otherwise, to see the detailed div",
     +  "ergence of pattern No. ",A," from another"/"  pattern, enter",
     +  " the latter''s index.  (Flag "" * "" will signal that the"/2X,
     +  "matching factors are not in the same order.)  Entering two i",
     +  "ndices will"/"  call detailed congruences with all patterns ",
     +  "in that range."/)')  CF(:JF(NN))
212   CALL SCAN(J,0,'I',5)
      IF(J<=0) CLOSE(17)
      IF(J<=0) GOTO 300
      READ(2,*) (ORDER(I),I=1,J)
      IF(J==1) ORDER(2) = ORDER(1)
      L1 = MAX(1,MIN(NTOT,ORDER(1),ORDER(2)))
      L2 = MIN(NTOT,MAX(1,ORDER(1),ORDER(2)))
      IF(L1==L2. AND. L2==NN) GOTO 300
      IF(L1==NN) L1 = L1+1
      IF(L2==NN) L2 = L2-1
      WRITE(6,'(/" Congruence match (degrees divergence) of patt",
     +  "ern No. ",A," with pattern")') CF(:JF(NN))
      L = 1 + (NF-1)/20   ! Lines needed to display one detailed match
      LL = 0              ! Screen count; Wait if LL+L  20 (or 18 at end)
      DO J = L1,L2
        IF(J==NN) CYCLE
        READ(17,REC=J) AV, (DG(I),I=1,NF), CH
        WRITE(6,'(1X,A,I3,": (Av =",A5,") ",20I3,4(:/19X,20I3))')
     +    CH, J, CLN(AV,5,1), (NINT(DG(I)),I=1,NF)
        LL = LL+L
        IF(LL>20 .OR. J==L2-1.AND.LL>18) CALL WAIT(0); LL = 0
      END DO
      WRITE(6,'(/" To see detailed divergences from another pattern,",
     +  " enter its index"/" (or index range).  Otherwise, hit RETU",
     +  "RN."/)')
      GOTO 212
C
C Report match to GEN2 source structure
238   IF(KD>-2) GOTO 901
C*Q      KD = -3                                              ! Start C**Q
C*Q      GOTO 260
C*Q239   WRITE(6,'(/" The coefficients in pattern",I3," approximate ",
C*Q     +  "their GEN2 source values with"/10X,"Stand. Error =",A6,4X,
C*Q     +  "Max. Error =",A6)') NN, CLN(SE1,6,3), CLN(XE1,6,3)
C*Q      WRITE(6,'(/" The quad-moments for pattern",I3," approximate",
C*Q     +  " their GEN2 source values with"/10X,"Stand. Error =",A6,4X,
C*Q     +  "Max. Error =",A6)') NN, CLN(SE,6,3), CLN(XE,6,3)
C*Q      NR = NR+1
C*Q      QREC(NR,1) = NN
C*Q      QREC(NR,2) = SE1
C*Q      QREC(NR,3) = XE1
C*Q      QREC(NR,4) = SE
C*Q      QREC(NR,5) = XE
C*Q      KD = -2
C*Q      WRITE(6,'(/" Enter anything to see accumulated record of mat",
C*Q     +  "ches to source structure."/" Otherwise, hit RETURN.")')
C*Q      CALL SCAN(J,0,'B',5)
C*Q      IF(J==0) GOTO 300
C*Q      WRITE(6,'(/"          ",A,"    Pattern    ",A,"  Quad-",
C*Q     +  "moments " A)') (TR(''),I=1,3)
C*Q      WRITE(6,'("   Record ",A,"   S.E.    Max ",A,"  QS.E.",
C*Q     +  "   Max  " A)') (TR(''),I=1,3)
C*QC      WRITE(6,'("   Ĵ")')
C*Q      WRITE(6,'(3X,40A)') (TR(''),I=1,7), TR(''), (TR(''),I=1,15),
C*Q     +  TR(''), (TR(''),I=1,15), TR('')
C*Q      DO 237 I = 1,NR
C*Q237    WRITE(6,'(4X,F4.0,2X,,A,,2F7.3,1X,A,,2F7.3,1X,A)')
C*Q     + QREC(I,1),TR(''), (QREC(I,J),QREC(I,J+1),TR(''),J=2,5,2)
C*Q      CALL WAIT(1)
C*Q      GOTO 300                                                ! End C**Q
C
C Exhibit numerical rotation results
230   WRITE(6,'(/" Hit RETURN to scroll the current pattern/correlatio",
     +  "ns just as recorded."/" Otherwise, enter any number CUT < 1.",
     +  "0 to see a schematic display in which "/" loadings smaller ",
     +  "than CUT are blanked while the rest are rounded to one"/" de",
     +  "cimal with point omitted. (Loadings larger than .95 are roun",
     +  "ded down.)")')
      IF(KB>0) CALL PIKKB(KB,W,WORD,LL,0)
      WRITE(6,'()'); CALL SCAN(JJ,0,'R',5)
      IF(KB==0 .AND. JJ<0) GOTO 230
      IF(JJ<0) CALL RESCAL(A1,C1,KB,1)
      IF(JJ<=0) THEN
        WRITE(6,'(//" Pattern solution No. ",A," is")') CF(:JF(NN))
        CALL SHOW(6,FMT,QBB,LST2,COMM,A1,C1,NB,K,LD)  ! K is a dummy here
        IF(JJ<0) CALL RESCAL(A1,C1,KB,0)
      ELSE
        READ(2,*) CUT
        CUT = MAX(0.,CUT)
234     IF(CUT>=1.) CUT = CUT/10   ! CUT entries out of range are downsized
        IF(CUT>=1.) GOTO 234
        WRITE(6,'(//" Schematic pattern solution No. ",A," is")')
     +    CF(:JF(NN))
        CALL SCHEMA(NV,NF,CUT,A1,MV,QBB,QN,NB,K,LM,IDENT,6)  ! K is a dummy here
      END IF
      GOTO 300
C
C Permute/reflect factors as instructed and store in HYBUF
330   WRITE(6,'(//" Your options for permuting factors are:"/6X,
     +  "1. Permute other patterns to match the one now active."/6X,
     +  "2. Order the active pattern in decreasing size of RMS load",
     +  "ings."/6X,"3. Permute/reflect the active pattern as you st",
     +  "ipulate.")')
      WRITE(6,'(/" Enter the index of your choice or hit RETURN for",
     +  " return to Main Menu."/)')
      CALL SCAN(J,1,'I',5)
      IF(J==0) GOTO 300
      IF(J<0) GOTO 330
      READ(2,*) M
      GOTO (334,335,331), M
      WRITE(6,'(/" Index ",A," is inoperative. Try again.")')
     +  CF(:JF(M))
      GOTO 330
334   WRITE(6,'(/" If you want to permute all stored patterns to ",
     +  "match current pattern No. ",A,","/" hit RETURN.  Other",
     +  "wise, to permute all between No. L and No. M inclusive,"/
     +  " enter L and also M if less than ",A,".  To abort permut",
     +  "ation, enter any letter."/)') CF(:JF(NN)), CF(:JF(NTOT))
      CALL SCAN(J,0,'I',5)
      IF(J<0) GOTO 300
      L1 = 1
      L2 = NTOT
      IF(J==0) GOTO 414
      ORDER(2) = NTOT
      READ(2,*) (ORDER(I),I=1,J)
      L1 = MAX(1,MIN(NTOT,ORDER(1),ORDER(2)))
      L2 = MIN(NTOT,MAX(1,ORDER(1),ORDER(2)))
      WRITE(6,'(/3X,"Hit RETURN to permute all stored patterns from ",
     +  "No. ",A," to No. ",A," to match"/3X,"current pattern No. ",A,
     +  ".  Otherwise, enter anything to choose again.")')
     +  CF(:JF(L1)), CF(:JF(L2)), CF(:JF(NN))
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 330
414   DO J = 1,NF
        DO I = 1,NV
          A0(I,J) = A1(I,J)
        END DO
      END DO
      REWIND 11
      REWIND 8
420   READ(8) J
      IF(J<L1-1) GOTO 420
421   READ(8,END=422) N,((A1(I,J),I=1,NV),J=1,NF),((C1(I,J),I=1,NF),
     +  J=1,NF), LIM,BH,CV,JA,JB,WSAL,PD1, NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX, (PFIX1(I),I=1,
     +  NPFIX), B0, B1, DB, DF, TOL, IMAX, L, T, M   ! L is ICYC, M is JFLAG
      WRITE(11) N,((A1(I,J),I=1,NV),J=1,NF),((C1(I,J),I=1,NF),J=1,NF),
     +  LIM,BH,CV,JA,JB,WSAL,PD1, NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX, (PFIX1(I),I=1,
     +  NPFIX), B0, B1, DB, DF, TOL, IMAX, L, T, M
      GOTO 421
422   REWIND 8
423   READ(8) J
      IF(J<L1) GOTO 423
      BACKSPACE 8
C       Hybuf file is now repositioned to receive permuted patterns
      REWIND 11
425   READ(11,END=430) N,((A1(I,J),I=1,NV),J=1,NF),((C1(I,J),I=1,NF),
     +  J=1,NF), LIM,BH,CV,JA,JB,WSAL,PD1, NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX, (PFIX1(I),
     +  I=1,NPFIX), B0, B1, DB, DF, TOL, IMAX, L, T, M  ! M is JFLAG
C      IF(N==NN .OR.N>L2) GOTO 427
      IF(N>L2) GOTO 427
      WRITE(6,'(" Permuting pattern No. ",A)') CF(:JF(N))
      CALL ALIGN(A1(1,1),A0,ORDER,DG,NV,NF,CH,AV,HI,MV)
      CALL PERM(ORDER,FIX,1,N,A1,C1,W,QB)
      CALL BLOCK(3,QB,NF,FIX,PFIX,KTL,WORD,MF)
427   WRITE(8) N,((A1(I,J),I=1,NV),J=1,NF),((C1(I,J),I=1,NF),J=1,NF),
     +  LIM,BH,CV,JA,JB,WSAL,PD1, NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX, (ORDER(PFIX1(I)),
     +  I=1,NPFIX), B0, B1, DB, DF, TOL, IMAX, L, T, M
C       Pattern fixations are permuted in this Write
      GOTO 425
430   REWIND 8
431   READ(8) J
      IF(J<NN-1) GOTO 431
      READ(8) J, ((A1(I,J),I=1,NV),J=1,NF),((C1(I,J),I=1,NF),J=1,NF),
     +  LIM, BH, CV, JA, JB, WSAL, PD1, NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX,
     +  (PFIX1(I),I=1,NPFIX), B0, B1, DB, DF, TOL, IMAX, L, T, M
      MODE = MOD(JFLAG/1000,10)
C       Active pattern NN is restored
      WRITE(6,'(" Done as ordered.")')
      GOTO 300  ! Option 1 returns to Main Menu
335   CALL RMS(NV,NF,A1(1,1),MV,DG,ORDER)   ! Option 2 entry; Opt 3 enters at 331
331   CALL PERM(ORDER,FIX,3-M,NN,A1,C1,W,QB) ! M is Option 2 or 3 at Label 330
      CALL BLOCK(3,QB,NF,FIX,PFIX,KTL,WORD,MF)
      IF(KFB<0) GOTO 499  ! Return to recording bootstraps pattern
      IF(NPFIX>0) THEN
        WRITE(2,'(50I4)') (ORDER(PFIX1(I)),I=1,NPFIX)
        BACKSPACE 2
        READ(2,*) (PFIX1(I),I=1,NPFIX)
        CALL REPFIX(NF,NPFIX,PFIX,PFIX1,1)
      END IF
      WRITE(6,'(/6X,"If you also want to permute other stored patte",
     +  "rns to match this one,"/6X,"hit RETURN.  Otherwise, enter",
     +  " anything.")')
      READ(5,'(A)') CH
      IF(CH==' ') M = 1
      IF(CH==' ') GOTO 334
      IF(QB) WRITE(6,'(" Done as ordered, except for keeping blocks",
     +  " intact by disallowing permutations"/" between blocks.  ",
     +  "But only the active pattern has been affected; the one")')
      IF(.NOT.QB) WRITE(6,'(" Done as ordered.  But only the active",
     +  " pattern has been affected; the one")')
      WRITE(6,'(" in store from which this was retrieved remains unc",
     +  "hanged.  To save this"/" permutation immediately as No. ",A,
     +  ", enter anything.  Otherwise, hit RETURN"/" to carry out ",
     +  "Main Menu operations before adding to store.")')
     +  CF(:JF(NTOT))
241   CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 300
      NTT = NN   ! BUFF will change NN to NTOT
      CALL BUFF(-1,A1,C1,FIX)
445   WRITE(6,'(" This permutation of pattern No. ",A," has been stor",
     +  "ed as No. ",A," and is active.")') CF(:JF(NTT)), CF(:JF(NTOT))
      GOTO 300
C
C Revise rotation constraints
240   L = 1  ! Need to make L a variable so BLOCK can change it
      IF(OBQ(C1,0)<.001) L = -1 ! Flag Orthomax rotation possible
      CALL BLOCK(L,QB,NF,FIX,PFIX,KTL,WORD,MF)
      IF(L>=0) THEN
        WRITE(6,'(" If you want the current pattern stored again wi",
     +    "th these new FIX codes,"/" enter anything.  Otherwise, ",
     +    "hit RETURN to rotate before storage.")')
C       WRITE(6,'(/" WARNING: Retrieving another pattern from store ",
C     +   "will reinstate the rotation"/10X,"controls in force duri",
C     +   "ng that solution.")')
        GOTO 241
      ELSE IF(L==-2) THEN
        CALL VVAR(0,A1,C1,W,FIX,NB,ABS(NX),ORDER,JFLAG)
      END IF
      GOTO 300
C
C Display factor-plane plots (NOM is count of item omits; KOM is a control index)
244   KUT = 10       !  CALL PREP(FRAME,10,A1,OMIT)
      IF(NOM>0) KOM = 1; IF(KOM==3) GOTO 245
      IF(NOM>0) THEN
        WRITE(6,'(/6X,"Hit RETURN to leave the ",A," currently set i",
     +    "tem exclusions in place for"/6X,"local adjustments.  Othe",
     +    "rwise, enter anything to wipe their list.")') CF(:JF(NOM))
        CALL SCAN(J,0,'B',5)
CCC          goto 245 if J=0; else clear list and display menu
        IF(J==0) GOTO 245; NOM = 0; OMIT = 0
      END IF
      WRITE(6,'(/5X,"When examining a plane plot, you can revise the",
     +  " list of items to be"/5X,"ignored (usually none) during sub",
     +  "sequent rotations of this plane."/5X, "How often do you wan",
     +  "t to be prompted with this option?"/)')
444   WORD = ' ';  WORD(4*KOM-3:4*KOM) = ' => '
      WRITE(6,'(A,"1. Allow item omissions immediately, with a quer",
     +  "y on each plane."/A,"2. Suppress this option until the next",
     +  " round of pattern inspections."/A,"3. Suppress item omissio",
     +  "ns for the remainder of this run unless a"/9X,"rotation usi",
     +  "ng these is retrieved from log store.")')
     +  (WORD(4*K-3:4*K),K=1,3)
      WRITE(6,'(/" Hit RETURN to pick",I2,", or enter the index of",
     +  " another choice."/)') KOM
      CALL SCAN(J,1,'I',5)
      IF(J==0) GOTO 245; IF(J<0) GOTO 444
      IF(J>0) READ(2,*) KOM; KOM = MAX(1,MIN(3,KOM))
      WRITE(6,'(" Your options here remain")')
      GOTO 444
245   WRITE(6,'(/" To terminate this round of pattern inspections, hi",
     +  "t RETURN.  Otherwise, call a"/" factor-plane display by ente",
     +  "ring its pair of factor indices, horizontal first."/)')
      CALL SCAN(J,2,'II',5)
      IF(J==0) GOTO 300
      IF(J<=-1) GOTO 245
      READ(2,*) M, N
      IF(M<=NF .AND. N<=NF .AND. M>=1 .AND. N>=1) GOTO 246
      WRITE(6,'(/" Factor plane <",A,", ",A,"> is closed for ",
     + "repairs. Try again.")') CF(:JF(M)), CF(:JF(N))
      GOTO 245
246   CALL PLOT(M,N,6,A1,C1(M,N),KTL,NN,KUT,KOM,KP)
      GOTO 245
C
C If KD=-2, read original simple-structure factor pattern/quad-moments
C and align final HYBALL solution with them before recording results
259   NOPLOT = 0
260   IF(KD>-2) GOTO 400

C*Q      OPEN(4,FILE=F1,FORM='UNFORMATTED')                 ! Start C**Q
C*Q      DO 258 I = 1,4
C*Q258    READ(4)
C*Q      READ(4) ((A0(I,NF1+J),I=1,NV),J=1,NF)
C*Q      READ(4) (CFF(NFQ+I),I=1,NFQ)
C*Q      CLOSE(4)
C*Q      CALL ALIGN(A1(1,1),A0(1,NF1+1),ORDER,DG,NV,NF,CH,AV,HI,MV)
C*Q      CALL PERM(ORDER,FIX,1,0,A1,C1,W,QB)                    ! End C**Q
C
C Select pattern-print format and profuseness of output
400   L1 = -1
      IF(KFB>0) GOTO 301   ! Bootstrap output
      IF(NOPLOT==0) GOTO 262
      WRITE(6,'(/" To print only schematics for a range of patterns, ",
     +  "enter the lowest and,"/" if less than ",A,", the highest pa",
     +  "ttern No. wanted.  Otherwise hit RETURN."/)') CF(:JF(NTOT))
      CALL SCAN(J,0,'I',5)
      IF(J<=-1) GOTO 262
      IF(J>0) THEN
        IF(J==1) READ(2,*) M
        IF(J==1) N = NTOT
        IF(J>1) READ(2,*) M, N
        L1 = MAX(1,MIN(NTOT,M,N))
        L2 = MIN(NTOT,MAX(1,M,N))
        CUT = .2
401     WRITE(6,'(" Loadings less than",A4," in pattern schema ",A,
     +    " to ",A," will be blanked. Hit RETURN"/" if OK, or enter",
     +    " new CUT. (Or enter any letter to change the pattern ran",
     +    "ge.)"/)') CLN(CUT,4,2), CF(:JF(L1)), CF(:JF(L2))
        CALL SCAN(J,1,'R',5)
        IF(J==0) GOTO 403
        IF(J<0) GOTO 400
        READ(2,*) CUT
        CUT = MAX(0.,CUT)
402     IF(CUT>=1.) CUT = CUT/10
        IF(CUT>=1.) GOTO 402
        GOTO 401
403     REWIND 8
      END IF
262   IF(L1<=0) WRITE(6,'(/" Recording results for pattern No. ",A,
     +   ":")') CF(:JF(NN))
      QPR = .TRUE.
      IF(KFB>0) MUTE = 0
      IF(F1(:3)=='HYF') THEN  ! In this case, source is factor covs
        MUTE = 1
C         Give full print but skip FAC/HYF for 2nd-order factoring.
      ELSE IF(MUTE>1) THEN
C         The user gets only one shot at this choice.
        IF(L1>0) MUTE = -1; IF(L1>0) GOTO 408
        WRITE(6,'(/" To omit print of the input information and rota",
     +    "tion matrix, and waive writing"/" the FAC.. and HYF.. fil",
     +    "es for item-scale construction and 2nd-order factoring,"/
     +    " enter anything.  Otherwise, hit RETURN for full output.")')
        CALL SCAN(MUTE,0,'B',5)
C         SCAN returns MUTE=-1 if input is not blank
408     IF(MUTE/=0) THEN
          IF(L1<0) WRITE(6,'(" Output will be abbreviated.")')
          REWIND 7
271       READ(7,'(A)',END=270) WORD(:10)
          IF(WORD(:10)/=' The input') GOTO 271
          BACKSPACE 7
          IF(KP>=100) WRITE(7,'(" Communalities:",100(:/10(I4,
     +      ". (",A3,") ")))') (I,CLN(COMM(I),3,2),I=1,NV)
          IF(KP<100) WRITE(7,'(" Communalities:",200(:/5(I4,
     +      ". (",A3,") ")))') (I,CLN(COMM(I),3,2),I=1,NV)
        ELSE
C       Set up factor namelist for HYF... files
          DO J = 1,NF
            NAME(J)(:6) = 'FAC'//CF(:JF(J))//'  '
          END DO
        END IF
      END IF
      IF(L1<0) GOTO 270
410   READ(8) NN, ((A1(I,J),I=1,NV),J=1,NF)
      IF(NN<L1) GOTO 410
      WRITE(6,'(" Writing schematic pattern No. ",A)') CF(:JF(NN))
      WRITE(7,'(/" Pattern No. ",A,", schematic:")') CF(:JF(NN))
      CALL SCHEMA(NV,NF,CUT,A1,MV,QBB,QN,NB,KBB,LM,IDENT,7)  ! K is a dummy here
      IF(NN<L2) GOTO 410  ! KBB (<=KBL) used only if last^ term is negative and QBB = t
      GOTO 319
270   M = 5-LD
      WRITE(6,'(/" If you want terms printed to",I2," decimals, hit RE",
     +  "TURN. Otherwise,"/" enter anything for",I2," decimals.")') LD,M
      CALL SCAN(J,0,'B',5)
      IF(J/=0) LD = M
      IF(J/=0) GOTO 270
      M = 10*LD + MIN(1,KP/100)
      IF(M==20) FMT1 = '(4X,7X,2(2X,5A5),90(:/13X,2(2X,5A5)))'
      IF(M==21) FMT1 = '(4X,7X,4(2X,5A5),90(:/13X,4(2X,5A5)))'
      IF(M==30) FMT1 = '(4X,8X,2(2X,5A6),90(:/14X,2(2X,5A6)))'
      IF(M==31) FMT1 = '(4X,8X,3(2X,5A6),90(:/14X,3(2X,5A6)))'
      FMT2 = '(I4,".",2X'//FMT1(7:)
      WRITE(6,'(/" Filing of this solution is underway.")')
C
C Compute matrix that rotates input factors into terminal axis placement
      IF(MUTE<0 .AND. KIND==0) GOTO 261
      DO J = 1,NF     ! If A1 = A0T then T = Inv[A1'A1](A1'A0)
        DO I = 1,J
          SIJ = 0.
          DO K = 1,NV
            SIJ = SIJ + A1(K,I)*A1(K,J)
          END DO
          W(I,J) = SIJ; W(J,I) = SIJ
        END DO
      END DO
      CALL MINV(NF,W,MV,IER)
      IF(IER/=0) WRITE(6,'(/" *** Rotation disqualified by matrix ",
     +  "singularity. Reinstate prior pattern"/"    and try other ro",
     +  "tation parameters.")')
      IF(IER/=0) GOTO 202
      DO I = 1,NF
        DO J = 1,NF
          A1(I,NF+J) = 0.
          J1 = J+KIND
          DO K = 1,NV
            A1(I,NF+J) = A1(I,NF+J) + A1(K,I)*A0(K+KIND,J1)
          END DO
        END DO
      END DO
      DO I = 1,NF
        I1 = I+KIND
        DO J = 1,NF
          J1 = J+KIND
          T1(I1,J1) = 0.
          DO K = 1,NF
            T1(I1,J1) = T1(I1,J1) + W(I,K)*A1(K,NF+J)
          END DO
        END DO
      END DO
      IF(KIND==0) GOTO 261
      T1(1,1) = 1.
      DO I = 2,NF1
        T1(1,I) = 0.
        T1(I,1) = 0.
      END DO
C   1st-level rotation matrix is now stored in T1
      IF(KD==-3) GOTO 288
C
C Send final 1st-level results to RESULTS file after check of control matrix
C KTL for rotation constraints.
261   NFIX = 0; Q = 0.; N = 0; NW = 0
      DO I = 1,NF
        IF(FIX(I)/=99) N = N+1
        IF(FIX(I)==0 .OR. FIX(I)>100) THEN
           NFIX = NFIX+1  ! NFIX is number of factors fixed in this rotation
           ORDER(NFIX) = I
        END IF
        IF(FIX(I)==-1) NW = NW+1
      END DO
      WRITE(7,'(/80("=")/15X,"Solution No. ",A," in archive ",A)')
     +  CF(:JF(NN)), F4(:LF4)
      IF(N==0) WRITE(7,'(/" Rotation to this solution was uncon",
     +  "strained.")')
      IF(N==0 .OR. MUTE<0) GOTO 268
      WRITE(7,'(/" Final axis positioning in this solution was cons",
     +  "trained by control matrix KTL:"/)')
      DO I = 1,NF
        IF(NF<=40) WRITE(7,'(6X,150I3)') (KTL(I,J), J=1,NF)
        IF(NF>40) WRITE(7,'(4X,150I2)') (KTL(I,J), J=1,NF)
      END DO
      WORD(:7) = '       '; IF(NF>1) WORD(:7) = 'Varimax'
      WRITE(7,'(/7X,"wherein KTL(I,J) = 0 disallows rotation of fac",
     +  "tor I by factor J."/7X,"The stage of rotation at which this",
     +  " KTL was imposed can"/7X,"be determined from a HYLOG report",
     +  " on logfile ",A,".")') F4(:LF4)
      IF(QB .AND. NW>1) WRITE(7,'(7X,A," rotation of the ",A," Wa",
     +  "ifs occurred at Hyball outset.")') WORD(:7), CF(:JF(NW))
268   CALL SHOWB(NF,NB,FIX,FIX1,QB,7)
      IF(MUTE>=0) THEN
        WRITE(7,'(//" The input pattern was transformed by factor-",
     +    "rotation matrix")')
        M1 = 1+KIND
        DO I = M1,NF1
          IF(MOD(I-1+KIND,5)==0) WRITE(7,'()')
CC973        WRITE(7,FMT1) (CLN(KTL(I,J)*T1(I,J),3+LD,LD),J=M1,NF1) !! Show hard zeros
C            Zeros in KTL not always the same as zeros in the rotation from input
           WRITE(7,FMT1) (CLN(T1(I,J),3+LD,LD),J=M1,NF1) ! $$$$$$ T1 printing as Identity matrix
        END DO
        WRITE(7,'(/" into rotated factor solution"/)')
      ELSE
        WRITE(7,'(/" Rotated factor solution No. ",A,":")')
     +    CF(:JF(NN))
      END IF
      L = 7
      IF(QB) THEN ! If HYBLOCK input, tag A1(-,NF+2) with spacing of blocked items
        QBB = QB
        A1(1,NF+2) = 1.
        DO I = 2,NV
          IF(LST2(I-1)>LST2(I)) THEN   ! Items aren't in ascending-block order
            QBB = .FALSE.  ! Tell SHOW and SCHEMA to forget block spacing
            GOTO 962
          END IF
          A1(I,NF+2) = 0.
          IF(LST2(I)>LST2(I-1)) A1(I,NF+2) = 1.
        END DO
        IF(ALLOCATED(KBB)) DEALLOCATE(KBB); ALLOCATE(KBB((NB+2)*(NF+1)))
        CALL GETKBL(NF,NB,FIX,KBB)  ! SHOW and SCHEMA will read KBB as KBL
962     L = -7  ! Negative flag tells SHOW to list block memberships
      END IF
      JJ=0; IF(KB>0) THEN
        CALL PIKKB(KB,W,WORD,LL,1); WRITE(6,'(11X,"Otherwise, hit",
     +    " RETURN to stay with all-standard scaling.")')
        CALL SCAN(JJ,0,'R',5)
        IF(JJ<0) CALL RESCAL(A1,C1,KB,1); JJ = KB
      END IF
      CALL SHOW(L,FMT1,QBB,LST2,COMM,A1,C1,NB,KBB,LD) ! KBB passes KBL
      IF(JJ>0) CALL RESCAL(A1,C1,KB,0)
      IF(JJ==1) WRITE(7,'(/" Note: Loadings on dichotomous factor",
     +  A," are for its binary scaling. Its"/7X,"data marker remains ",
     +  "standardized with factor loading hence inflated.")') WORD(:LL)
      IF(JJ>1) WRITE(7,'(/" Note: Loadings on the dichotomous fac",
     +  "tors (",A,") are for their binary scalings."/7X,"Their data",
     +  " markers remain standardized with factor loadings hence in",
     +  "flated.")') WORD(:LL)
      IF(QB) WRITE(7,'(/" The items'' Block memberships are shown ",
     +  "above in parentheses.")')
      WRITE(6,'(/" If you also want a schematic printout of this pat",
     +  "tern with loadings less than"/" CUT blanked out, enter your",
     +  " choice of CUT < 1.0 .  Otherwise, hit RETURN."/)')
      CALL SCAN(J,1,'R',5)
      IF(J>0) THEN
        READ(2,*) CUT
        CUT = MAX(0.,CUT)
972     IF(CUT>=1.) CUT = CUT/10
        IF(CUT>=1.) GOTO 972
        WRITE(7,'(//" Loadings over",A4," in pattern No. ",A,", rounded",
     +    " to one decimal (point omitted):")') CLN(CUT,4,2),CF(:JF(NN))
        IF(.NOT.QBB) L = 7
        CALL SCHEMA(NV,NF,CUT,A1,MV,QBB,QN,NB,KBB,LM,IDENT,L) ! KBL still in KBB
        WRITE(6,'(" Pattern schema with CUT =",A4," has been record",
     +    "ed.")') CLN(CUT,4,2)
      END IF
      IF(KFB>0) GOTO 320     ! Reminder: KFB>0 flags bootstrap input
      WRITE(6,'(/" To list the most salient items on each factor, hit",
     +  " RETURN.  Otherwise,"/" enter anything to waive this informa",
     +  "tion.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 370
      WRITE(7,'(/" Most salient items on each factor (size of each ",
     +  "loading in parentheses)")')
      DO J = 1,NF
        M = MIN(6,NINT(.25*NV))  ! Max number of salients to list for a factor
        DO I = 1,NV
          TMP(I) =  1000*NINT(1000*(4-ABS(A1(I,J)))) + I
        END DO
        CALL SORT(NV,TMP)
        DO I = 1,NV
          TMP(I) = MOD(TMP(I),1000)  ! TMP orders items in decreasing factor-J loading
        END DO
C         Criteria for salience: Count not more than Min(6,NV/4), and loading
C                              at least 2/3rds the size of max loading.
        L = 2   ! Always list at least the top two
        X = ABS(A1(TMP(1),J))*.67
364     L = L+1
        IF(L<M .AND. ABS(A1(TMP(L),J))>X) GOTO 364  ! Print 1 past criterion
        WRITE(7,'( "  Factor",I3,":",20(2X,A,"(",A4,")"))')
     +    J, (CF(:JF(TMP(I))),CLN(ABS(A1(TMP(I),J)),4,3),I=1,L)
      END DO
370   IF(MUTE<0) GOTO 288
      WRITE(6,'(/" If you want the variables'' correlations with ",
     +  "the factors, enter anything."/" Otherwise, hit RETURN.")')
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 287
C   Produce variable/factor correlations
      DO I = 1,NV
        DO J = 1,NF
          SIJ = 0.
          DO K = 1,NF
            SIJ = SIJ + A1(I,K)*C1(K,J)
          END DO
          A1(I,NF+J) = SIJ
        END DO
      END DO
      WRITE(7,'(//" The variables'' correlations with these rotated",
     +  " factors are")')
      DO I = 1,NV
        IF(MOD(I-1,5)==0) WRITE(7,'()')
        WRITE(7,FMT2)  I, (CLN(A1(I,NF+J),3+LD,LD),J=1,NF)
      END DO
C  Compute rescaling multipliers for converting pattern columns into
C  structure columns
287   WRITE(6,'(/" If you want the rescaling multipliers for convert",
     +  "ing factor pattern into"/" reference structure, enter anyth",
     +  "ing. Otherwise, hit RETURN.")')
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 288
      DO I = 1,NF
        DO J = 1,NF
          W(I,J) = C1(I,J)
        END DO
      END DO
      CALL MINV(NF,W,MV,IER)
      IF(IER/=0) WRITE(6,'(/" The rotated factor-correlation matrix",
     +  " is singular.")')
      IF(IER/=0) GOTO 288
      DO I = 1,NF
        DG(I) = 1./SQRT(W(I,I))
      END DO
      WRITE(7,'(/" The column multipliers for converting the rotated",
     +  " primary-factor pattern"/" into reference-axis structure ",
     +  "are, in order,")')
      FMT2(2:7) = '6X    '
      WRITE(7,FMT2) (CLN(DG(I),3+LD,LD),I=1,NF)
      FMT2(2:7) = 'I4,"."'
C
C If KIND=1, expand 1st-level rotation T1 into quadratic rotation matrix
288   IF(KIND==0) GOTO 301
C*Q      DO 285 I=1,NF1                              ! Start C**Q lines
C*Q        DO 285 J=I,NF1
C*Q        DO 285 K=1,NF1
C*Q        DO 285 L=K,NF1
C*Q          IF(K/=L) T1(IDF(I-1,J-1),IDF(K-1,L-1)) = T1(I,K)*T1(J,L) +
C*Q     +        T1(I,L)*T1(J,K)
C*Q285       IF(K==L) T1(IDF(I-1,J-1),IDF(K-1,L-1)) = T1(I,K)*T1(J,L)
C*QC
C*QC  Compute rotated 2nd-level factor covariances
C*Q      DO 290 I = 1,NFF1
C*Q        DO 290 J = I,NFF1
C*Q          SIJ = 0.
C*Q          DO 291 K = 1,NFF1
C*Q            DO 291 L = 1,NFF1
C*Q              IF(K<=L) SIJ = SIJ + T1(I,K)*CFF(LO(K,L))*T1(J,L)
C*Q291           IF(K>L) SIJ = SIJ + T1(I,K)*CFF(LO(L,K))*T1(J,L)
C*Q290       CG(LO(I,J)) = SIJ
C*Q      IF(KD==-3) GOTO 292
C*QC
C*QC Send rotated moments to SEE file
C*Q      WRITE(7,'(/" The rotated quadratic factor moments are:",
C*Q     + 50(10(/4X,10A6,3X,10A6)))') (CLN(CG(I),6,2),I=1,NFQ)
C*Q      IF(NF<=9) CALL CHART(NF,T1)
C*Q      DO 295 I = 1,NF
C*Q        II = IDF(I,I)
C*Q        W(1,I) = CG(LO(II,II))
C*Q295     W(2,I) = CG(LO(I+1,II))
C*Q      WRITE(7,'(//" The higher unmixed moments in this array are"/
C*Q     +  2X,"<II,II>:",30A6)') (CLN(W(1,I),6,2),I=1,NF)
C*Q      WRITE(7,'(2X,"<0I,II>:",30A6)') (CLN(W(2,I),6,2),I=1,NF)
C*Q      IF(KD>=-1) GOTO 301
C*Q292   SE = 0.
C*Q      XE = 0.
C*Q      DO 332 I = 1,NFQ
C*Q        DIFF = CFF(NFQ+I) - CG(I)
C*Q        CFF(NFQ+I) = DIFF
C*Q        XE = MAX(XE,ABS(DIFF))
C*Q332     SE = SE + DIFF*DIFF
C*Q       SE = SQRT(SE/NFQ)
C*Q       IF(KD>-3) WRITE(7,'(/" These rotated 2nd-level factor momen",
C*Q     +   "ts approximate those of the simple-structure factors from whi",
C*Q     +   "ch the quad-data were produced with"//20X,"Standard Error =",
C*Q     +   A6,10X,"Maximum Error =",A6//" The string of individual",
C*Q     +   " approximation errors is:"/90(10(/4X,10A6,3X,10A6)/))')
C*Q     +   CLN(SE,6,3), CLN(XE,6,3), (CLN(CFF(NFQ+I),6,2),I=1,NFQ)
C*Q      SE1 = 0.
C*Q      XE1 = 0.
C*Q      DO 333 I = 1,NV
C*Q       DO 333 J = 1,NF
C*Q        DIFF = A0(I,NF1+J) - A1(I,J)
C*Q        A0(I,NF1+J) = DIFF
C*Q        XE1 = MAX(XE1,ABS(DIFF))
C*Q333     SE1 = SE1 + DIFF*DIFF
C*Q      SE1 = SQRT(SE1/(NV*NF))
C*Q      IF(KD==-3) GOTO 239
C*Q      WRITE(7,'(/" The rotated 1st-level factor pattern approximate",
C*Q     +  "s the simple-structure pattern from which the artificial da",
C*Q     +  "ta were produced with"//20X,"Standard Error =",A6,10X,
C*Q     +  "Maximum Error =",A6//" The Variables-by-Factors array of ",
C*Q     +  "of individual pattern-approximation errors is:")')
C*Q     +   CLN(SE1,6,3), CLN(XE1,6,3)
C*Q      DO 939 I = 1,NV
C*Q       IF(MOD(I-1,5)==0) WRITE(7,'()')
C*Q939    WRITE(7,FMT2)  I, (CLN(A0(I,NF1+J),6,LD),J=1,NF)    ! End C**Q lines
C
C Save in ASCII file FAC<da>ij.H<n>, or in (<da>ij.H<n> if a bootstrap result,
C a copy of the pattern sent to SEE file.    ! ******** HYFAC input
C Fixed-input flags:
C   KODE < 0: Blocking by HYBLOCK of both items and factors; NX = 0
C   NX < 0: X-set items/factors direct from MODA, items added to bottom of pattern
C          NXX/=-NX flags that FIX no longer starts with ABS(NX) zeros.
301   IF(MUTE/=0 .AND. KFB==0) GOTO 307
      IF(NB>0) KODE = -ABS(KODE)   ! KODE < 0 flags HYBLOCK item blocking,
      WORD(:12) = 'FAC'//F3(2:MM)//F3(LL:) ! ******^  not X-set direct from MODA
      IF(KFB==0) GOTO 501   ! FAC-output
      KFB = -KFB  ! Negative flag maybe not needed
      M = 2  ! Signals to do RMS permutation just of active pattern
      GOTO 335  ! Permute to RMS order
499   KFB = ABS(KFB)  ! Return from permutation (WORD diddled with there)
      WORD(:12) = F1(KFB:KFB+1)//F1(:KFB-1)//F3(LL:) ! Bootstraps output
501   OPEN(3,FILE=WORD(:12))   ! Bootstrap or FAC output selected by KFB
      WRITE(3,'("Factor solution No.",I3," in SEE-file ",A,", found ",
     +  "by rotation of HYBALL-input file ",A)') NN,F3,F1 ! *** Don't touch spacing
      WRITE(3,'(/6(1X,A))') CF(:JF(NV)), CF(:JF(NF)), CF(:JF(NX)),
     +  CF(:JF(KODE)), ' 0', F2  ! F2 still COV-file name
C       FAC* and bootstrap files follow MODA-output format, including NX
      DO I = 1,NV                   ! But X-set items are included in NV
        WRITE(3,'(25I7,8(:/25I7))') (NINT(10000*A1(I,J)),J=1,NF)
      END DO
      WRITE(3,'(/2(1X,A))') CF(:JF(NF)), CF(:JF(NFF))
      DO J = 1,NF
        WRITE(3,'(25I7,8(:/27I6))') (NINT(10000*C1(I,J)),I=1,J)
      END DO
      IF(KIND/=0 .OR. KODE>=0) GOTO 304  ! Negative KODE flags block structure
      WRITE(3,'()')
      WRITE(3,'(50I3,20(:/50I3))') (FIX(I),I=1,NF), (LST2(I),I=1,NV)
      WRITE(3,'(30(1X,A),50(:/20(1X,A)))') CF(:JF(NB)), (CF(:JF(FIX1(
     +  I))),I=1,NB)
304   IF(QL) WRITE(3,'(30(:/40I4))') (LST1(I),I=1,NV)
      IF(QL .AND. KB>0) THEN ! Don't add binary info if no LST1
        READ(33) KB, (W(I,1),I=1,KB); REWIND 33
        WRITE(3,'(I3,20(1X,A):,50(/20(1X,A):))') KB,
     +    (CF(:JF(NINT(W(I,1)*10000))),I=1,KB)
      END IF
      CLOSE(3)
      IF(KFB>0) GOTO 262
C
C Save the factor correlations in ASCII file HYF*ij.C<n>   ! ******** HYF covars
      IF(NB+NFIX>0 .OR. KIND/=0 .OR. NF<5 .OR. QB) GOTO 307
      WORD(:12) = 'HYF'//F3(4:)
      L = 11
305   L = L-1
      IF(WORD(L:L)/='.') GOTO 305
      WORD(L+1:L+1) = 'C'
      OPEN(3,FILE=WORD(:12))
      WRITE(3,'(" Factor correlations for the rotation of HYBALL-in",
     +  "put file ",A," detailed in ",A)') F1, F3
      WRITE(3,'(I4,2X,A,2X,A,I3,2X,A,2X,I7)') NF, CF(:JF(NFF)),
     +  CF(:JF(KODE)), 0, F1(:LF1), -9999
      WRITE(3,'(25I6,8(:/25I6))') ((NINT(10000*C1(I,J)),I=1,J),J=1,NF)
C       HYDATA cov-output: NV, NVV, KODE, MTH, F1(inputfile), BLANK
      WRITE(3,'(/"Names assigned to the 1st-order factors:"/,
     +  90(16A8,:/))') (NAME(I)(:6),I=1,NF)
      CLOSE(3)
C
C Send pattern plots to RESULTS file after recording factor-block regressions.
307   IF(NB>0 .OR. NFIX>0) THEN
         WRITE(6,'(/" If you want each factor''s regression on the fa",
     +     "ctors prior to it in your block-"/" dependency structure,",
     +     " hit RETURN.  Otherwise, enter anything to omit these.")')
        CALL SCAN(J,0,'B',5)
        IF(J==0) CALL REGRES(NF,NB,C1,MF,FIX,FIX1,T1,W,KP) ! T1,W,CFF,CG are workspaces
      END IF
      IF(NOPLOT==1) GOTO 319
      CALL PRNT(2,KP,7)
      IF(KP>=100) KUT = 20    !  CALL PREP(FRAME,20,A1,OMIT)
      IF(KP<100) KUT = 10    !  CALL PREP(FRAME,10,A1,OMIT)
      WRITE(6,'(/" To record just selected pattern planes, hit RET",
     +  "URN. Otherwise enter"/" anything to print all planes ex",
     +  "cept possibly ones with fixed factors."/)')
      CALL SCAN(J,0,'B',5)
      BIGIF2: IF(J==0) THEN
        IF(NFIX==1) WRITE(6,'(/" REMINDER. The fixed factor is:",
     +    20I3)') ORDER(1)
        IF(NFIX>1) WRITE(6,'(/" REMINDER. The fixed factors are:",
     +    20I3)') (ORDER(I),I=1,NFIX)
        M = 1
        N = 2
310     WRITE(6,'(/" Factor plane <",I2,",",I2,"> has been selected.",
     +    " Hit RETURN to record this, or enter"/" preferred pair of",
     +    " factor indices. (Entering zero for either index will"/
     +    " abort recording any more plane plots.)"/)') M, N
        CALL SCAN(J,2,'II',5)
        IF(J==0) GOTO 312
311     IF(J<0) GOTO 310
        READ(2,*) M, N
        IF(M<=0 .OR. N<=0) GOTO 320
        M = MIN(NF,M)
        N = MIN(NF,N)
        GOTO 310
312     CALL PLOT(M,N,7,A1,C1(M,N),KTL,NN,KUT,KOM,KP)
        WRITE(6,'(/" Factor plane <",I2,",",I2,"> has been filed in ",
     +   A,". To record another,"/" enter its index pair. Otherwise,",
     +   " hit RETURN."/)')  M, N, F3(:10)
        CALL SCAN(J,2,'II',5)
        IF(J==0) GOTO 320
        GOTO 311
      ELSE BIGIF2
        NOTE = 0
        IF(NFIX==0) GOTO 315
        WRITE(6,'(/" If you want print-out of any pattern planes ",
     +    "with fixed factors, hit RETURN."/" Otherwise, enter ",
     +    "anything.")')
        CALL SCAN(J,0,'B',5)
        IF(J/=0) GOTO 315
        NOTE = 1
        IF(NFIX<=1) GOTO 315
        WRITE(6,'(/" If you want print-out of pattern planes with ",
     +   " both factors fixed, enter"/" anything. Otherwise, hit ",
     +   "RETURN.")')
        CALL SCAN(J,0,'B',5)
        IF(J==0) GOTO 315
        NOTE = 2
315     WRITE(6,'(/" Filing of pattern plots is in progress. Have ",
     +   "patience.")')
        NF0 = NF-1
        DO M = 1,NF0
          IF(FIX(M)<=0 .OR. FIX(M)>100) J = 999
          M1 = M+1
          DO N = M1,NF
            IF(FIX(N)<=0 .OR. FIX(N)>100) K = 999
            IF(NOTE==0 .AND. (J==999 .OR. K==999)) CYCLE
            IF(NOTE==1 .AND. (J==999 .AND. K==999)) CYCLE
            CALL PLOT(M,N,7,A1,C1(M,N),KTL,NN,KUT,KOM,KP)
          END DO
        END DO
        GOTO 320
      END IF BIGIF2
C
319   WRITE(6,'(/" Enter anything for return to Main Menu, or hit ",
     +  "RETURN to stop.")')
      IF(MUTE<0) WRITE(6,'(" (Only abbreviated printout is now",
     +  " available.)")')
      CALL SCAN(J,0,'B',5)
      LD = 2
      KR = KND
      IF(J/=0) GOTO 300
320   IF(QLOG(F4)) GOTO 451
      WRITE(6,'(/" Your results are ready for inspection in file ",
     +  A)') F3
      WRITE(7,'("")')
      STOP
350   IF(NXX/=ABS(NX) .OR. NPFIX>0) THEN  ! Only BOOTDATA call reaches here
        WRITE(6,'(6X,"This pattern''s production constraints make it",
     +    " a poor bootstrap"/6X,"recovery target.  Pick another.")')
        GOTO 300
      END IF
      INQUIRE(13,OPENED=QS)
      IF(QS) THEN
        REWIND 13                  ! Contains full pathname of COV-file
        READ(13) LLL, WORD(:LLL)   ! Only time this file is read
        CLOSE(13)
      ELSE
        CALL GETNAM(F2,WORD,LLL,MTH,1)
        IF(LLL==0) GOTO 300   ! F2 not found; GETNAM sets MTH = 0
      END IF
      OPEN(4,FILE=WORD(:LLL))
cStandardized covariances (correlations) computed from datafile xxxxxxxxxxxx
      READ(4,*,ERR=353,END=353) (CH,I=1,6), WORD(:12) ! Dummy CH read skips the 1st six words
      READ(4,*) NT
      IF(ALLOCATED(KBB)) DEALLOCATE(KBB); ALLOCATE(KBB(NT))
352   READ(4,*,ERR=353,END=354) CH
      IF(CH=='T') READ(4,*,ERR=353,END=353) (KBB(I),I=1,NT)  ! Recover rawdata indices of COV-file items.
      GOTO 352
353   WRITE(6,'(/" Item indices cannot be found in this COV-file.  ",
     +  "BOOTDATA has not been set.")')
      CLOSE(4)
      GOTO 449
354   NW = 0; K = 0
      DO I=1,NF; IF(FIX(I)==-1) NW=NW+1; IF(FIX(I)>99) K=K+1; END DO
      IF(K>1) THEN
        WRITE(6,'("  >>>>> Pattern ",A," has ",A," factors in forced",
     +    " alignment with items;"/7X,"not an approved bootstrap tar",
     +    "get.  Select another."/)'); GOTO 300
      END IF
      OPEN(10,FILE='BOOTDATA',FORM='UNFORMATTED')
      REWIND 24; READ(24) MSPN, NUFF, FOB, GAP  ! SPIN params  ***** But are they the correct ones ???
      N=NX; IF(.NOT.QB) LST2=0; NG=NF-NW   ! Delete NW waifs
      WRITE(10) NV,NG,ABS(NX),KODE, JFLAG, MTH+NB*100, F2,F1,WORD(:12),
     +  (SIGN(1000*LST2(I)+KBB(ABS(LST1(I))),LST1(I)),I=1,NV),
     +  (FIX(I),I=1,NG), NB, (FIX1(I),I=1,NB), MSPN,NUFF,FOB,GAP   ! Line 1
C      F2 is COV-file, F1 is extraction-input file, WORD is rawdata file.
C      LST1 lists in HYBALL-input order these items' indices in the COV-file
C        from which MODA selected them, with minus signs flagging reflection in
C        MODA. If QB=t, HYBLOCK may have permuted MODA-output LST1 into block order.
C      KBB lists in COV-output order the COV-items' rawdata indices.  If input
C        is not from HYBLOCK, N=-NX and LST2 is blank.  Otherwise, when QB=t:
C        (a) LST2 lists in HYBALL-input order these items' block assignments and
C        (b) KBB(ABS(LST1(I))) lists their D-source indices in that same order,
C        so (c) 1000*LST2(I)+KBB(ABS(LST1(I)) gives for each HYBALL-input item
C        both its D-source index and, in QB=t cases, its block assignment.
      WRITE(10) NN, ((A1(I,J),I=1,NV),J=1,NG),((C1(I,J),I=1,J),J=1,NG),  ! Note sym-storage of C1
     +  LIM, BH, CV, JA,JB, WSAL, PD1, B0, B1, DB, DF, TOL, IMAX, GAM,
     +  NOM, (OMIT(I),I=1,NOM)  !, NPFIX, (ORDER(PFIX1(I)),I=1,NPFIX)  ! Line 2
      KK = MOD(JFLAG,100)
      REWIND 8
208   READ(8) J; IF(J<KK-1) GOTO 208  ! Recover this pattern's immediate source
      READ(8) NK, ((W(I,J),I=1,NV),J=1,NF),((T1(I,J),I=1,NF),J=1,NF),
     +  (X,I=1,7), N,(J,I=1,N), (X,I=1,NF), N,(J,I=1,N), N,(J,I=1,N),
     +  (X,I=1,8), JJ  ! ********* JJ gets JFLAG of source pattern
      WRITE(10) JJ,((W(I,J),I=1,NV),J=1,NF), ((T1(I,J),I=1,J),J=1,NF)   ! Line 3
      WRITE(10) 0, 0.  ! Initialize accumulations    ! Line 4
      WRITE(6,'(" Control file BOOTDATA has been initialized for boot",
     +  "straps study of sampling"/" noise in Pattern No. ",A,".  To ",
     +  "use this immediately, hit RETURN to exit HYBALL"/" and call ",
     +  "HYBOOT.  Otherwise, enter anything for return to Main Menu.")')
     +  CF(:JF(NN))
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 451
449   DEALLOCATE ( KBB ); ALLOCATE ( KBB(32*MF+1) )
      GOTO 300  ! Last branch back
450   CLOSE(7,STATUS='DELETE')
451   F2 = F1     ! MODA-input name is in F1 with length LF1
      N = LH(F2,LL) + 2   ! Before change, F2 was the COV-file name
      F2(N:N) = '#'
      CLOSE(8); CLOSE(9)
C F4(8) is the active logfile.
C If F4 /= 'HYBUF', close F4 and copy to HYBUF
C If F4 = HYBUF, F2 is the logname based on input from MODA
c    F4 recorded unconditionlly, F2 if CH = ' '
      CH = 'X'  ! Initially non-blank
      IF(NEW>0 .OR. F4(:5)=='HYBUF') THEN
        WRITE(6,'(/4X,"To archive this run''s logfile under name ",A,
     +    ", hit RETURN."/4X,"Otherwise, enter anything to save ",
     +    "just under generic name HYBUF.")') F2(:LL)
        READ(5,'(A)') CH
      END IF
      IF(F4(:5)=='HYBUF') THEN
        IF(F4(6:6)/=' ') CALL SYSTEM('copy '//F4//' HYBUF >nul')
        IF(CH==' ') CALL SYSTEM('copy HYBUF '//F2(:LL)//' >nul')
        IF(CH==' ') WRITE(6,'(/4X,"Done.  This run''s logfile is ",
     +    "saved in ",A," as well as in HYBUF.")') F2(:LL)
      ELSE
        F2 = 'HYBUF'; CALL SYSTEM('copy '//F4//' HYBUF >nul')
      END IF
      INQUIRE(FILE='LUMP',EXIST=QB)
      IF(.NOT.QB) GOTO 455
      F1(N:N+2) = 'LMP'
      INQUIRE(FILE=F1(:N+2),EXIST=QB)
      IF(QB) CALL SYSTEM('copy '//F1//' LUMP.OLD >nul')
      CALL SYSTEM('copy LUMP '//F1//' >nul') ! <nam>.LMP gets <nam> from MODA filename
455   IF(JJ>=0) WRITE(6,'(4X,"Reminder:  This run''s SEE-output is",
     +  " in ",A)') F3
      STOP
      END
C
      SUBROUTINE ALIGN(A,B,ORDER,DG,NV,NF,CH,AV,HI,MV)
C This compares the columns of NV-by-NF matrix A to those of matrix B, and puts
C into vector ORDER the permutation (and reflection if signalled by negative
C ORDER value) of A's columns that aligns A with B most closely. The congruence
C coefficients for the best match are converted to degrees difference and
C reported in vector DG with their average in AV and max in HI.  And CH returns
C '*' if optimal axis alignment requires a proper (non-identity) permutation.
      CHARACTER CH
      INTEGER ORDER(*)
      REAL A(MV,*), B(MV,*), DG(*)
      REAL(8) SAB, R, X, RAD, WORK(NF,NF), WK(MV,2)
      RAD = 90/DACOS(0.D0)
      DO J = 1,NF
        ORDER(J) = 0
        WK(J,1) = 0.D0
        WK(J,2) = 0.D0
        DO I = 1,NV
          WK(J,1) = WK(J,1) + A(I,J)*A(I,J)
          WK(J,2) = WK(J,2) + B(I,J)*B(I,J)
        END DO
        WK(J,1) = MAX(WK(J,1),1.D-20)
        WK(J,2) = MAX(WK(J,2),1.D-20)
      END DO
      DO J = 1,NF
        DO K = 1,NF
          SAB = 0
          DO I = 1,NV
            SAB = SAB + A(I,J)*B(I,K)
          END DO
          WORK(J,K) = SAB/SQRT(MAX(WK(J,1)*WK(K,2),1.D-20))
        END DO
      END DO
      CH = ' '
      AV = 0.
      HI = 0.
      BIG: DO K = 1,NF
        NI = 0
        NJ = 0
         X = 0.
        BG: DO J = 1,NF
          DO L = 1,NF
            IF(ABS(ORDER(L))==J) CYCLE BG
C             Skip J if already matched
          END DO
          DO I = 1,NF
            IF(ORDER(I)/=0) CYCLE
C             Skip I if already matched
            R = ABS(WORK(I,J))
            IF(R<X) CYCLE
            X = MIN(1.D0,R)
            NI = I
            NJ = J
          END DO
        END DO BG
        ORDER(NI) = SIGN(NJ,FLOOR(WORK(NI,NJ)))
C         A-factor NI matches B-factor NJ while negative NJ tells PERM to reflect.
C         ORDER permutes A into B-matching order.
        IF(NI/=NJ) CH = '*'
        DG(NJ) = ACOS(X)*RAD
C         DG(J) is divergence of B-factor J from its matching A-factor
C         DG(ABS(ORDER(K))) is divergence of A-factor K from matching B-factor
        AV = AV+DG(NJ)
        HI = MAX(HI,DG(NJ))
      END DO BIG
      AV = AV/NF
      END SUBROUTINE

      SUBROUTINE AUXPAR(CV)
C Set auxillary functions of adjustable rotation parameters
      COMMON /BL1/ B1TAN, DBRAD
      COMMON /BL3/ BH, JA, JB, CV1, ADD, R0, R1, WSAL
      COMMON /BL5/ B0RAD, B0TAN, FINE
      COMMON /BL6/ B0, B1, DB, DF, TOL, IMAX
      RAD = 90/ACOS(0.)  ! Radians-to-degrees coefficient
      B0RAD = B0/RAD
      B0TAN = TAN(B0RAD)
      B1TAN = TAN(B1/RAD)
      DBRAD = DB/RAD
      CV1 = CV+1
      IF(JA>=0) R0 = CV/(JA+1)    ! Don't have CV in COMMONs
      IF(JA<0) R0 = 1./(1.-JA)
      IF(JA<0) CV1 = R0-1.
      R1 = 1./(JB-1)
      IF(JA>=0) ADD = JB*R1 + JA*R0
      IF(JA<0) ADD = (1.-JA) + R1
      END SUBROUTINE
C
      SUBROUTINE BLOCK(LEAP,QB,NF,FIX,PFIX,KTL,WORD,MF)
C This enters the subspace-fixation structure into KTL. LEAP=0 is for inital
C setup, LEAP=1 for Main Menu calls, LEAP>1 for noninteractive FIX changes.
C When LEAP is 5 on input, it returns 5 plus the number of factors aligned
C by SPIN with variables.  NOTES:
C   1) NB is the number of positive-FIX (less than 99) control blocks.
C   2) If a factor J is aligned (only in SPIN) with item I, FIX(J) = 100+I
C   3) FIX1 codes dependencies on blocks with indices in range 1-98 (set in this subroutine below)
C   4) Pattern fixations are managed by PFIX; no connection with FIX,FIX1
C *** When LEAP>1, KBL/TMP1/TMP2 are unused and WORD(:2) contains flags.
      PARAMETER (MMF=50)  ! Not allocated in order to avoid clumsy array passing
      LOGICAL QB
      CHARACTER BN, WORD*(*),TR, CF*12
      INTEGER FIX(*), FIX1(MMF), KTL(MF,*), PFIX(*), PFIX1(MMF), TMP(NF)
      INTEGER,ALLOCATABLE:: KBL(:,:), KTL1(:,:), TB(:), TMP1(:),TMP2(:)
CCC      INTEGER  KTL1(NF,NF), TB(NF), TMP1(NF), TMP2(NF), TMP(NF)
      EXTERNAL SCAN
      COMMON /FX/ NB, NPFIX, FIX1, PFIX1, NX, NXX, NOQB
      COMMON /CF/ CF
      SAVE KFLG, NOTE, NOTE1
      DATA KFLG/0/, NOTE/1/, NOTE1/1/
C       KFLG = 0/1 defaults to constrain-factor-locations/fix-pattern
      ALLOCATE( KTL1(NF,NF), KBL(-1:NB+1,0:NF) )
C  First unpack block codes; delete any minus flag on L
      LIN = LEAP; LEAP = ABS(LEAP)   ! Neg LEAP is orthogonality flag
      N2 = 0; KTL1 = 0
      DO L = 1,NF  ! Do extra in anticipation of block insertions
        KTL1(L,L) = 1; N1 = FIX1(L)
        DO J = 1,L-1   ! KTL1 charts dependencies only for blocks, not factors
          KTL1(L,J) = MOD(N1,2); N1 = N1/2
        END DO
      END DO
      DO I = 1,NF
        IF(FIX(I)>99) THEN
          N2 = N2+1
          TMP(N2) = I
        END IF
      END DO
      IF(N2>0) THEN
        ALLOCATE( TB(NF) )
        DO I = 1,N2
          TB(I) = TMP(I)
        END DO
      END IF
      IF(LEAP==1 .AND. N2>0) THEN
        WRITE(6,'(/" Some factors have been temporarily aligned in SP",
     +    "IN with data variables."/" Hit RETURN to free these, or en",
     +    "ter anything to continue them.")')
        CALL SCAN(J,0,'B',5)
        IF(J==0) THEN
          DO I = 1,NF
            FIX(I) = MIN(FIX(I),99)
          END DO
          N2 = 0
        END IF
      END IF
      IF(LEAP==1) GOTO 8
      IF(LEAP>=2) GOTO 55   ! No TMP on this branch
      NX = 0  ! Number of fixed-input factors
      N1 = 0  ! Number of factors not whollly unconstrained
      DO I = 1,NF             ! Initial setup only
        IF(FIX(I)/=99) N1 = N1+1
        IF(FIX(I)==0) NX = NX+1
      END DO
      IF(N1==0) GOTO 55   ! No constraints in place
      IF(NX==N1) THEN     ! Just X-set constraints
        IF(NX==1) WRITE(6,'(/" One factor is a manifest input vari",
     +    "able, so presumably you want location")')
        IF(NX>1) WRITE(6,'(/1X,A," factors are manifest input var",
     +    "iables, so presumably you want location")') CF(:JF(NX))
        WRITE(6,'(" constraints. Hit RETURN to accept the default se",
     +    "ttings of these, or enter"/" anything to review or adjust",
     +    " them.")')
      ELSE  ! Some constraints other than X-set
        WRITE(6,'(/" Location constraints have been imposed on this ",
     +    "pattern. Enter anything to"/" examine/revise these const",
     +    "raints, or hit RETURN to skip this inspection.")')
      END IF
      CALL SCAN(LL,0,'B',5)
      IF(LL==0) GOTO 55
      GOTO 10
8     IF(QB) GOTO 120
      IF(NOTE==1) THEN
        WRITE(6,'(/3X,80A)') TR(''), (TR(''),I=1,72), TR('')
        WRITE(6,'(3X,A,6X,"Option 9 allows you to impose either (a) ",
     +   "Location Constraints or  ",A,/3X,A," (b) Pattern Fixations",
     +   ".  The former restrict axis repositioning, are    ",A/3X,A,
     +   " best set by MODA or HYBLOCK before the input pattern reac",
     +   "hes HYBALL,   ",A/3X,A," and normally remain in place thro",
     +   "ughout all rotations of this problem. ",A/3X,A," In contra",
     +   "st, Pattern Fixations hold the pattern coefficients on eac",
     +   "h   ",A/3X,A," selected factor constant except for modest ",
     +   "scaling adjustments, and    ",A/3X,A," are usually tempor",
     +   "ary.  A factor on which the PATTERN is fixed is",6X,A/3X,A,
     +   " generally still free to move; and if it does, variance no",
     +   "rmalization   ",A/3X,A," requires its otherwise-unchanged ",
     +   "loadings to be shrunk or expanded by  ",A/3X,A," a rescali",
     +   "ng multiplier that has no effect on its congruences.",10X,A/
     +   3X,A,72(" "),A/3X,A,11X,"[ This advice box will not reappea",
     +   "r on this run. ]",11X,A)') (TR(''),I=1,24)
        WRITE(6,'(3X,80A)') TR(''), (TR(''),I=1,72), TR('')
      END IF
      NOTE = 0
9     IF(KFLG==0) WRITE(6,'(/" To examine or edit your LOCATION CONS",
     +  "TRAINTS, hit RETURN.  Otherwise,"/" enter anything to consi",
     +  "der Pattern Fixations.")')
      IF(KFLG==1) WRITE(6,'(/" To examine or revise your PATTERN FIX",
     +  "ATIONS, hit RETURN.  Otherwise,"/" enter anything to consid",
     +  "er Location Constraints.")')
      CALL SCAN(J,0,'B',5)
      IF(J==0 .AND. KFLG==1) GOTO 101
      IF(J==0 .AND. KFLG==0) GOTO 10
      KFLG = 1-KFLG
      GOTO 9

C  Enter block codes (FIX codes) for individual factors after saving old codes
10    IF(.NOT.ALLOCATED(TMP1))  ALLOCATE ( TMP1(NF) )
      IF(ALLOCATED(KBL)) DEALLOCATE(KBL); ALLOCATE( KBL(-1:NB+1,0:NF) )
      DO I = 1,NF               ! This overwrites initial TMP, but info still in FIX1
        TMP(I) = FIX(I)         ! TMP  here needs size NF
        TMP1(I) = FIX1(I)       ! TMP1 here needs size NF
      END DO
13    IF(NOTE1==1) THEN
        WRITE(6,'(/2X,80A)') TR(''), (TR(''),I=1,75), TR('')
        WRITE(6,'(2X,A,13X,"EXPLANATION OF BLOCK-CODED LOCATION",
     +   " CONSTRAINTS",15X,A/2X,A,75(" "),A)') (TR(''),I=1,4)
        WRITE(6,'(2X,A," To describe imposition of blocked location ",
     +    "constraints, say that factor",3X,A/2X,A," Fi is ""rotatio",
     +    "nally dependent"" on factor Fj or, equivalently, that Fj",
     +    5X,A/2X,A," rotates Fi, just in case shifts in factor posi",
     +    "tioning are allowed to",6X,A/2X,A," replace the current Fi",
     +    " by some composite of the current axes in which",5X,A/2X,A,
     +    " Fj has nonzero weight. Location constraints are stipulate",
     +    "d by assigning   ",A/2X,A," the factors to disjoint blocks",
     +    " identified by letter codes as follows:",5X,A/2X,A,75(" "),
     +    A/2X,A," Factors in block Z (""zeros"") are isolates that n",
     +    "either move nor rotate",4X,A/2X,A,"   any other factors.  ",
     +    "(Undeleted Waif factors from HYBLOCK are coded Z.)  ",A/2X,
     +    A," Factors in block X (global sources) do not themselves ",
     +    "move but rotate all ",A/2X,A,"   other factors not coded ",
     +    "Z.  (Fixed-input factors from MODA are in X.)",3X,A/2X,A,
     +    " Factors in block Y (fully dependent) are rotated by all",
     +    " factors not in Z, ",A)') (TR(''),I=1,24)
        WRITE(6,'(2X,A,3X,"but themselves rotate only Y-factors.",
     +    35(" "),A/2X,A," Factors in any block whose letter code ",
     +    "<L> is not one of the above do not ",A/2X,A,"   rotate ",
     +    "factors in any block alphabetically prior to <L>, but ar",
     +    "e rotat- ",A/2X,A,3X,"ionally dependent on all factors ",
     +    "in <L> as well as in whatever prior",4X,A/2X,A,"   blo",
     +    "cks are set to rotate <L> by your choice of block depend",
     +    "encies.",6X,A/2X,A,75(" "),A/2X,A,10(" "),
     +    "[ This information box will not reappear on this run. ]",
     +    10(" "),A)') (TR(''),I=1,14)
        WRITE(6,'(2X,80A)') TR(''), (TR(''),I=1,75), TR('')
        CALL WAIT(0)
        NOTE1 = 0
      END IF

C  Ŀ
C               EXPLANATION OF BLOCK-CODED LOCATION CONSTRAINTS               
C                                                                             
C   To describe imposition of blocked rotation constraints, say that factor   
C   Fi is "rotationally dependent" on factor Fj or, equivalently, that Fj     
C   rotates Fi, just in case shifts in factor positioning are allowed to      
C   replace the current Fi by some composite of the current axes in which     
C   Fj has nonzero weight. Location constraints are stipulated by assigning   
C   the factors to disjoint blocks identified by letter codes as follows:     
C                                                                             
C   Factors in block Z ("zeros") are isolates that neither move nor rotate    
C     any other factors.  (Undeleted Waif factors from HYBLOCK are coded Z.   
C   Factors in block X (global sources) do not themselves move but rotate all 
C     other factors not coded Z.  (Fixed-input factors from MODA are in X.)   
C   Factors in block Y (fully dependent) are rotated by all factors not in Z, 
C     but themselves rotate only Y-factors.                                   
C   Factors in any block whose letter code <L> is not one of the above do not 
C     rotate factors in any block alphabetically prior to <L>, but are rotat- 
C     ionally dependent on all factors in <L> as well as in whatever prior    
C     blocks are set to rotate <L> by your choice of block dependencies.      
C                                                                             
C            [ This information box will not reappear on this run. ]          
C  

120   CALL GETKBL(NF,NB,FIX,KBL)  ! FIX and NB are input
      IF(QB) THEN
        CALL SHOWB(NF,NB,FIX,FIX1,QB,6)
121     WRITE(6,'(/" So long as this structure is flagged as a ",
     +    "Hyblock imposition, you may only"/6X,"1. Delete the",
     +    " Hyblock flag to enable unrestricted reblocking.")')
        NW = KBL(-1,0); KY = KBL(NB+1,0)  ! Number of Waifs/Ys,
        KL = 2
        IF(NW>0) THEN
          K = MIN(1,NW-1); WORD(:4) = 's a '  ! K is 0/1 for sing/plur
          WRITE(6,'(6X,"2. Convert the Waif",A,"(Block Z) to",A,"bloc",
     +      "k-Y (fully dependent)"/11X,"factor",A,"on which factors ",
     +      "in no prior blocks depend.")') WORD(2-K:2), WORD(2:4-2*K),
     +      WORD(2-K:2)
          IF(KY==0.AND.NB>0) WRITE(6,'(6X,"3. Add the Waif",A,"to bloc",
     +      "k ",A,", your most-dependent block.")') WORD(2-K:2), BN(NB)
          KL = 3; IF(KY==0.AND.NB>0) KL = 4
        END IF
        KK = KL
        WRITE(6,'(I7,". Return to Main Menu."/)') KL
122     WRITE(6,'("   Option",I2," is now selected.  Hit RETURN to e",
     +   "xecute this or enter the"/"   index of your choice."/)') KK
        CALL SCAN(J,1,'I',5)
        IF(J<0) GOTO 121
        IF(J==0) GOTO 123
        READ(2,*) KK
        IF(KK<=0 .OR. KK>KL) KK = KL
        GOTO 122
123     IF(KK==KL) LEAP = -1
        IF(KK==1) QB = .FALSE.; IF(KK==1) NOQB = 1000
        IF(KK==KL .OR. KK==1) RETURN
        IF(KK==2) K = 99
        IF(KK==3) K = NB
        DO J = 1,NW
          FIX(KBL(-1,J)) = K
        END DO
        WORD(:17) = 'withoutincluding '
        WRITE(6,'("   Option",I2," has been implemented, and will ",
     +    "affect subsequent rotations."/"   Note that recall of a",
     +    " previously stored pattern will reinstate the"/"   earl",
     +    "ier block structure ",A," the Hyblock flag."/)') KK,
     +    WORD(1+7*MIN(1,KK-1):7+9*MIN(1,KK-1))
        RETURN
      END IF
      WORD(:13) = ' firm butAlso'
      J = MIN(1,N2); JJ = NF-KBL(NB+1,0) ! JJ is no. of constrained factors
      IF(JJ==0) WRITE(6,'(/" No",A,"location constraints are now ",
     +  "in force")') WORD(:1+5*J)
      IF(JJ>0) CALL SHOWB(NF,NB,FIX,FIX1,QB,6)
      IF(N2>0) WRITE(6,'(1X,A,1X,A," factors still temporarily ",
     +  "aligned with data variables are"/4X,50(1X,A))')
     +  WORD(7+3*J:9+4*J), CF(:JF(N2)), (CF(:JF(TB(I))),I=1,N2)
130   IF(JJ>0) WRITE(6,'(/" Hit RETURN to accept the blocking shown.",
     +  "  Otherwise, enter any letter to"/" revise blocks in order,",
     +  " or any number to wipe all clean and start afresh.")')
      IF(JJ==0) WRITE(6,'(/" Hit RETURN to resume rotation with no ",
     +  "factor blocking.  Otherwise, enter"/" any letter to respec",
     +  "ify block constraints.")')
      CALL SCAN(J,0,'R',5)
      IF(J==0 .AND. N1<0) GOTO 75  ! N1 can go -1 just before Label 75 below
      IF(J==0 .AND.N1>=0) GOTO 42 ! N1<0 flags response to call for review
CCC      IF(J==0 .AND. JJ>0) GOTO 42  ! => Refresh KTL, maybe check for change;
CCC      >>> GOTO 42 when new changes need KTL to be respecified

      IF(J>0) THEN
        K = MIN(KBL(0,0),1) + 2*MIN(KBL(-1,0),1)
        WORD(:9) = ' X       '; IF(K==2) WORD(2:2) = 'Z'
        IF(K==3) WORD(:9) = 's X and Z'
        IF(K>0) WRITE(6,'(4X,"WARNING: Blockwipe includes emptying ",
     +    "block",A)') WORD(:9)
        WRITE(6,'(4X,"Hit RETURN to confirm blockwipe, or enter any ",
     +    "letter to reconsider.")')
        CALL SCAN(J,0,'B',5); IF(J/=0) GOTO 130
        FIX(1:NF) = (/(99,I=1,NF)/); FIX1=0; KFLG=0; N1=0; NB=0
        GOTO 10
      END IF
      CALL REFIX(0,NF,NB,FIX,FIX1,KTL1)   ! Continue with block revisions
      WRITE(6,'(4X,"You will be presented with each factor block in o",
     +  "rder of increasing"/4X,"dependency and allowed to adjust its",
     +  " current listing.  (Any deletion"/4X,"is to be entered as th",
     +  "e factor''s index immediately preceded by a minus"/4X,"sign, "
     +  "and will be cached in Block Y.)  Also, you can open a new bl",
     +  "ock"/4X,"immediately following the one presented unless that",
     +  " is Y or Z.  Changing"/4X,"the number of blocks will require",
     +  " revision of their dependeny structure"/4X,"which you will ",
     +  "enter after completing the block-membership adjustments.")')
      CALL WAIT(1)
159   IB = -2
      BIG: DO WHILE( IB < NB+MIN(1,KBL(NB+1,0)) )
        IB = IB+1
165     NIB = KBL(IB,0); IBB = IB; IF(IB>NB) IBB = 99
        WORD(51:90) = ' is now empty.      now contains factors'  ! 1:20, 21:40
        K = MIN(1,NIB)               ! K = 0 if empty, 1 if not =>  1+19*K : 20+20*K
        IF(NIB==NF) WORD(70:90) = ' contains all factors'
        IF(IB==-1) WORD(:46) = 'Block Z (isolates)'//
     +    WORD(51+19*K:70+20*K)//'              '
        IF(IB==0) WORD(:46) =  'Block X (global sources)'//
     +    WORD(51+19*K:70+20*K)//'        '
        IF(IB>0) WORD(:46) =  'Block '//BN(IBB)//
     +    WORD(51+19*K:70+20*K)//'    '
        WRITE(6,'(/" Ŀ"/"  Block ",A,"    ",A/
     +   " ")') BN(IBB), WORD(:50)
        IF(NIB>0.AND.NIB<NF) WRITE(6,'(14X,25(1X,A),4(/14X,25(1X,A)))')
     +    (CF(:JF(KBL(IB,I))),I=1,NIB)
        IF(IB<=NB) THEN
          WRITE(6,'(/"  Enter the indices of any factors you want to ",
     +      "add to this block, as well as"/"  the indices of any you",
     +      " want to delete immediately preceded by minus signs.")')
          IF(IB<0) WRITE(6,'("  Otherwise, hit RETURN to leave this",
     +      " block unchanged."/)')
          IF(IB>0 .AND. NIB==0) WRITE(6,'("  Otherwise, hit RETURN ",
     +      "to omit this block.")')
          IF(IB>=0 .AND. (IB==0.OR.NIB>0)) THEN
            WRITE(6,'("  Otherwise hit RETURN to leave this block unc",
     +        "hanged, or enter any letter to"/"  accept this block b",
     +        "ut insert a new block between this one and the next.")')
            IF(IB==NB .AND. (NB==0.OR.NIB>0)) WRITE(6,'(" > NOTE: Th",
     +        "is is now the last position at which block insertions ",
     +        "are allowed.")')
          END IF
        ELSE
          IF(NIB<NF) WRITE(6,'(/" Enter the indices of any factors ",
     +      "you want to add to block Y (no deletions)."/" Otherwise,",
     +      " hit RETURN to leave this block unchanged."/)')
          IF(NIB==NF) CYCLE BIG
        END IF
        WRITE(6,'()'); CALL SCAN(J1,0,'I',5)
        IF(J1==0) CYCLE
        IF(J1<0 .AND. IB>=0 .AND. (NB==0.OR.NIB>0)) THEN
          CALL REFIX(IB+1,NF,NB,FIX,FIX1,KTL1)  ! insert empty block, NB => NB+1
          DEALLOCATE ( KBL);  ALLOCATE( KBL(-1:NB+1,0:NF) )
          CALL GETKBL(NF,NB,FIX,KBL)
          WRITE(6,'(/"   Block indices higher than ",A," have been ",
     +      "shifted up one letter to make room"/"   for new block ",
     +      A,".  If you leave this empty, it will be deleted.")')
     +      BN(IB+1), BN(IB+1)
            CYCLE BIG
        ELSE IF(J1>0) THEN
          ALLOCATE ( TMP2(MMF) )
          READ(2,*) (TMP2(I),I=1,J1)   ! TMP2 shouldn't need size over MMB
          DO I = 1,J1
            K = TMP2(I); KK = ABS(K); IF(K==0 .OR. KK>NF) CYCLE
            IF(K<0 .AND. FIX(KK)==IB) FIX(KK) = 99
            IF(K>0) FIX(K) = IB
          END DO
          DEALLOCATE ( TMP2 )
          CALL GETKBL(NF,NB,FIX,KBL); GOTO 165
        END IF
      END DO BIG
      IB = 0; KC = 0
      DO WHILE (IB<=NB) ! Delete any blank blocks
        IB = IB+1
        IF(KC>0 .AND. KBL(IB,0)>0) KC = KC+100
        IF(KBL(IB,0)==0) THEN
          CALL REFIX(-IB,NF,NB,FIX,FIX1,KTL1)
          KC = KC+1; IB = MAX(0,IB-1)
        END IF
      END DO
      IF(KC>0) THEN
        KD = KC/100; KC = MOD(KC,100)
        DEALLOCATE ( KBL);  ALLOCATE( KBL(-1:NB+1,0:NF) )
        WORD(:10) = ' has haves'  ! 1-4, 4-9
        N1 = 4; NN = 9; M1 = 4  ! >>> Don't use N2 !!
        IF(KC==1) N1=1; IF(KC==1) NN=4; IF(KD==1) M1=5
        WRITE(6,'(I5," empty block",A," been deleted, downshifting ",
     +    A, " higher block label",A)') KC, WORD(N1:NN), CF(:JF(KD)),
     +    WORD(M1:M1)
        CALL GETKBL(NF,NB,FIX,KBL)
      END IF
      WRITE(6,'(/" Your current assignment of factors to blocks:")')
      IF(KBL(NB+1,0)<NF) CALL SHOWB(NF,NB,FIX,FIX1,QB,6)
      WRITE(6,'(/" If satisfied, hit RETURN.  Otherwise, enter any ",
     +  "letter to do more revisions"/" or any number to reinstate",
     +  " your original block assignments and start again.")')
      CALL SCAN(J,0,'R',5)
      IF(J>0) THEN
        DO I = 1,NF
          FIX(I) = TMP(I)
        END DO
        CALL GETKBL(NF,NB,FIX,KBL)
      END IF
      IF(J/=0) GOTO 159
C Factors are assigned to blocks; now do block dependencies.
      IF(NB<2) GOTO 42
      WRITE(6,'(/"   You may now impose or adjust a dependency struc",
     +  "ture on blocks A - ",A,"."/"   After studying the DepOn col",
     +  "umn displayed above to get clear on how"/"   if at all you ",
     +  "want to change that, hit RETURN to continue.")') BN(NB)
      READ(5,'()')
C  Enter block structure from keyboard. KTL1(I,J) = 1 signifies that
C  block I is rotated by (is dependent on) block J.
      DO IB = 1,NB  ! Not needed unless a block has been added or deleted
        KTL1(IB,IB) = 1; N1 = FIX1(IB)
        DO J = 1,IB-1
          KTL1(IB,J) = MOD(N1,2); N1 = N1/2
        END DO
      END DO
      WORD(:12) = '.           '
      IF(KBL(0,0)>0) WORD(:12) = ' (except X).'
      WRITE(6,'(/2X,"Factor Block A is never rotated by any other ",
     +    "block",A)') WORD(:12)
      BG: DO IB = 2,NB
        KTL1(IB,IB) = 1
26      LB = 0
        DO JB = 1,IB-1
          IF(KTL1(IB,JB)==1) THEN
            LB = LB+1
            KTL1(NB+1,LB) = JB  ! For write to screen
          END IF
        END DO
30      IF(LB==0) WRITE(6,'(/2X,"Factor Block ",A," is now rotat",
     +    "ed by NO other blocks",A)') BN(IB), WORD(:12)
        WORD(:2) = 's '
        IF(LB>0) WRITE(6,'(/"  Factor Block ",A," is now rotat",
     +    "ed just by prior block",A,8A2,10(:/5X,25A2))') BN(IB),
     +  WORD(3-MIN(2,LB):2), (BN(KTL1(NB+1,JB)),JB=1,LB)
        WRITE(6,'("  Hit RETURN if OK.  Otherwise, enter correct li",
     +    "st of block codes (letters)"/"  prior to ",A," or any ",
     +    "number to clear list and try again."/)') BN(IB)
        READ(5,'(A)') WORD
        CALL LAST(L,WORD(:30),30)
        IF(L==0) CYCLE BG
        CALL SUBST(WORD(:L),'abcdefghijklmnopqrstuvw',
     +                      'ABCDEFGHIJKLMNOPQRSTUVW')
        KTL1(IB,IB) = 1
        LB = 0
        DO J = 1,IB-1
          KTL1(IB,J) = 0
          DO I = 1,L
            IF(J+64==ICHAR(WORD(I:I))) KTL1(IB,J) = 1
            IF(KTL1(IB,J)>0) LB = LB+1
          END DO
        END DO
        GOTO 26
25    END DO BG
C  Insure that KTL1 is transitive
      DO I = NB-2,1,-1
        DO J = I+1,NB-1
          DO K = J+1,NB
35          IF(KTL1(K,J)*KTL1(J,I)==1) KTL1(K,I) = 1
          END DO
        END DO
      END DO
C  Recode block structure into FIX1
      DO I = 1,NB
        FIX1(I) = 0; K = 1
        DO J = 1,I-1
          IF(KTL1(I,J)==1) FIX1(I) = FIX1(I) + K; K = K*2
        END DO                             !   ^  K = 2**(J-1)
      END DO
C Check whether changes are for real
42    IF(LEAP/=1) GOTO 55  ! => if call wasn't from Main Menu
      KK = 1
      DO I = 1,NF
        IF(FIX(I)/=TMP(I)) KK = 0     ! TMP needs size NF
      END DO
      DO I = 1,NF
        IF(FIX1(I)/=TMP1(I)) KK = 0   ! TMP1 needs size NF
      END DO
      IF(KK==1) WRITE(6,'(" Your location constraints have not ",
     + "been changed.")')
      IF(KK==1) LEAP = -1  ! Signal to caller
C  Construct rotation-control matrix KTL from FIX codes. (Also clear PFIX.)
55    DO I = 1,NF
       DO J = 1,NF+1
         KTL(I,J) = 0
        END DO
      END DO
      K = 0
      LP1: DO I = 1,NF  ! Factor being rotated
        KTL(I,I) = 1
        IB = FIX(I)
        IF(IB<99) K = K+1
        IF(LEAP>=5 .AND. IB>100) LEAP = LEAP+1
        IF(IB>100) IB = 0
        IF(IB<=0) CYCLE LP1  ! Comprises blocks X, Z, and temporarily aligned
        DO J = 1,NF  ! Factor contributing to rotation
          IF(I==J) CYCLE
          JB = FIX(J)
          IF(JB>100) JB = 0
          IF(JB==0 .OR. IB>=NF.AND.JB>0) KTL(I,J) = 1
          IF(JB>0.AND.JB<=IB.AND.IB<=NB) KTL(I,J) = KTL1(IB,JB)
          KTL(I,NF+1) = KTL(I,NF+1)+KTL(I,J)  ! Tell if factor I is movable
        END DO
      END DO LP1     ! No more KTL1
      WORD(1:1) = CHAR(32+K)      ! Code for no. of firmly constrained factors
      WORD(2:2) = CHAR(32+LEAP-5) ! Code for no. of temporarily aligned factors
      IF(LL==0 .OR. LEAP/=1) RETURN  ! LL=0 if inspection was waived above
      IF(K==0) WRITE(6,'(" Your factors are now free of any loc",
     +   "ation constraints.")')
      WRITE(6,'(/" If you want to see the rotation-control matrix ",
     +  "implied by this block structure,"/" enter anything.  Oth",
     +  "erwise, hit RETURN.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) THEN
        WRITE(6,'(" Your rotation-control matrix, with KTL(I,J) = 1 ",
     +    "signifying"/" that factor J rotates factor I, is now:"/)')
        DO I = 1,NF
          WRITE(6,'(4X,25I3,10(:/9X,24I3))') (KTL(I,J), J=1,NF)
        END DO
      END IF
      WRITE(6,'(/" If you want to review your new location-constra",
     +  "int block structure,"/" enter anything.  Otherwise, hit ",
     +  "RETURN.")')
      CALL SCAN(N1,0,'B',5)  ! N1 = -1 if something entered
      IF(N1/=0) GOTO 10
75    IF(LIN<1) THEN
        WRITE(6,'(/" Since your factors are currently orthogonal, ",
     +    "you can do VARIMAX/EQUAMAX"/" rotation under your prese",
     +    "nt location constraints.  Enter anything to"/" exercise",
     +    " that option, or hit RETURN to regain the Main Menu.")')
        CALL SCAN(J,0,'B',5)
        IF(J/=0) LEAP = -2
      END IF
      IF(NXX>0) NX = 0
      RETURN
101   CALL REPFIX(NF,NPFIX,PFIX,PFIX1,0)
      WRITE(6,'(/" Factors on which the current pattern is now ",
     +  "set to remain essentially unchanged")')
      IF(NPFIX>0) WRITE(6,'(" by rotation:",30(1X,A))')
     +  (CF(:JF(PFIX1(I))),I=1,NPFIX)
      IF(NPFIX==0) WRITE(6,'(" by rotation:  None.")')
      LEAP = -1  ! Signal to caller
      WRITE(6,'(/" Hit RETURN if OK.  Otherwise, enter new list of ",
     +  "fixed-pattern factors"/" or any letter to clear list."/)')
      CALL SCAN(J,0,'I',5)
      IF(J==0) RETURN
      IF(J<0) NPFIX = 0
      IF(J<0) GOTO 101
      READ(2,*) (PFIX1(I),I=1,J)
      NPFIX = 0
110   LP3: DO I = 1,NF ! Insure increasing order and no duplicates
        DO K = NPFIX+1,J
          IF(PFIX1(K)==I) THEN
            NPFIX = NPFIX+1
            PFIX1(K) = PFIX1(NPFIX)  ! Swap the term replaced with its replacer
            PFIX1(NPFIX) = I
            CYCLE LP3
          END IF
114     END DO
      END DO LP3
      NPFIX = MIN(NPFIX,NF)
      GOTO 101
      END
C
      FUNCTION BN(N)
c Converts block integer code N into the block's letter code
      CHARACTER BN
      IF(N==99) THEN
        BN = 'Y'
      ELSE IF(N==0) THEN
        BN = 'X'
      ELSE IF(N<0) THEN
        BN = 'Z'
      ELSE IF(N<88) THEN  ! Letters A-W
        BN = CHAR(64+N)
      ELSE
        BN = CHAR(N-39)  ! Continue with digits starting with 1
      END IF
      RETURN
      END
C
      SUBROUTINE BUFF(NEW,A1,C1,FIX)
C Unless NEW=0, this adds to file HYBUF the latest pattern solution. On all
C calls, it puts into RECORD the hyperplane count for pattern NTOT. NEW=0 is
C used to load RECORD on resumption of previous run or to recount hyperplanes.
C Negative NEW omits writing the current hyperplane count to screen.
      PARAMETER (MMF=50, MREC=200, MSEE=100, MOM=1000)
      CHARACTER CH4*4, CLN*8
      INTEGER RECORD(MREC,0:MSEE)
      INTEGER FIX(*), FIX1(MMF), PFIX1(MMF), OMIT(MOM)
      REAL A1(MV,0:*), C1(MF,*)
      COMMON  NV, NF, MV, MF
      COMMON /BL1/ B1TAN, DBRAD
      COMMON /BL2/ LIM, CV, PD1, MODE, GAM
      COMMON /BL3/ BH, JA, JB, CV1, ADD, R0, R1, WSAL
      COMMON /BL4/ NN, NTOT
      COMMON /BL5/ B0RAD, B0TAN, FINE
      COMMON /BL6/ B0, B1, DB, DF, TOL, IMAX
      COMMON /BL7/ JFLAG, NSPN, KNV, TT, ICYC
      COMMON /FX/ NB, NPFIX, FIX1, PFIX1, NX, NXX, NOQB
      COMMON /OM/ NOM, OMIT
      COMMON /REC/ LSEE, RECORD
      LSEE = MIN(NF,MSEE)
      IF(NEW==0) GOTO 6
      REWIND 8
4     READ(8,END=5) LAST
      NTOT = LAST+1  ! Increase NTOT for Buffing new record
      GOTO 4
5     BACKSPACE 8
6     IJSUM = 0
      B = BH; IF(BH>=1.) BH = .20  ! B = BH-MIN(1,INT(BH))*(BH-.20)   ! B is BH if BH<1, otherwise is .20
      DO J = 1,NF
        IP = 0
        DO I = 1,NV
          IF(ABS(A1(I,J))<=B) IP = IP+1
        END DO
        IJSUM = IJSUM + IP
        IF(J>MSEE) CYCLE
        RECORD(NTOT,J) = NINT((IP*100.)/NV)  ! Percents
      END DO
      RECORD(NTOT,0) = NINT((IJSUM*1000.)/(NV*NF)) ! NOTE: 10xPercent
      IF(NEW==0) RETURN
      IF(JFLAG/100000/=0) GOTO 24     ! Zero flags MODE-controlled rotation
      CH4 = 'STEP'
      IF(LIM<0) CH4 = 'SCAN'
      IF(TT<-1.) CH4 = ' fix'
      IF(NEW>=1) WRITE(6,'(" The  ",A3," hyperplane percentages ",
     +  "for this ", A," rotation are"/4X,"(Av =",A5,")",20I3,
     +  8(:/15X,20I3))') CLN(B,3,2),CH4, CLN(.1*RECORD(NTOT,0),5,1),
     +  (RECORD(NTOT,J),J=1,LSEE)
      IF(LSEE<NF) WRITE(6,'(20X,I3," factors have been omitted")')
     +  NF-LSEE
      WRITE(6,'()')
24    IF(MOD(JFLAG/1000,10)==4) TT = GAM
      IF(NOQB==1000) NOQB = NOQB*NTOT
      WRITE(8) NTOT,((A1(I,J),I=1,NV),J=1,NF),((C1(I,J),I=1,NF),
     +  J=1,NF), LIM,BH,CV,JA,JB,WSAL,PD1, NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX, (PFIX1(I),I=1,
     +  NPFIX), B0, B1, DB, DF, TOL, IMAX, ICYC+NOQB, TT, JFLAG
C       JFLAG: Integer coding of four fields
C         MOD(JFLAG,1000) (digits 1-3): Record No. of most recent recorded
C           pattern (NSORC) from which current pattern A1 derives. If Spin
C           result, leading digit is 1 if 1st saved; otherwise, unfiltered
C           rank (9) in series.
C         MOD(JFLAG/1000,10) (digit 4): Rotation MODE
C           0-4: STEP/S, STEP/P, SCAN/S, SCAN/P, OBLMIN
C         MOD(JFLAG/10000,10) (digit 5): 1 if permutation/reflection has
C           occurred in derivation sequence between NSORC and A1; else 0
C         JFLAG/100000) (digit 6): Type of pattern; 1 or 2 if Oblique or
C           Orthogonal Spin, 3 if initiating input, 4 or 5 if VARIMAX or
C           EQUAMAX rotation of input, 9 if all free axes are item-aligned,
C           0 if MODE-controlled rotation without Spin.
      TT = 0.
      NN = NTOT
      JFLAG = MODE*1000+NTOT ! First entry in JFLAG for next pattern
      IF(NX/=0) THEN
        DO I = 1,ABS(NX)
          IF(FIX(I)/=0) NX = 0
        END DO
      END IF
      N = MREC-NTOT
      IF(N>10) RETURN
      WRITE(6,'(" The space available for pattern storage will hold ",
     +  "only",I3," more.")') N
      RETURN
      END
C
C*Q      SUBROUTINE CHART(NV,W)
C*QC This prints out the symmetric-storage quad-moment-matrix location chart.
C*Q      IMPLICIT INTEGER(H)
C*Q      REAL W(*)
C*Q      LO(I,J) = J*(J-1)/2 + I
C*Q      ID(I,J) = I*(2*NV-I+1)/2 + J+1
C*Q      IF(NV>9) RETURN
C*Q      NV1 = NV+1
C*Q      NQ = NV1*(NV+2)/2
C*Q      NR = NQ*(NQ+1)/2
C*Q      DO 3 H1=1,NV1
C*Q       H=H1-1
C*Q       DO 3 I1=H1,NV1
C*Q        I=I1-1
C*Q        DO 3 J1=I1,NV1
C*Q         J=J1-1
C*Q         DO 3 K1=J1,NV1
C*Q          K=K1-1
C*Q          W(LO(ID(H,I),ID(J,K))) = H*10 + I + J*.1 + K*.01
C*Q          W(LO(ID(H,J),ID(I,K))) = H*10 + J + I*.1 + K*.01
C*Q3         IF(H<I) W(LO(ID(H,K),ID(I,J))) = H*10 + K + I*.1 + J*.01
C*Q      WRITE(7,9) NV, (W(I), I=1,NR)
C*Q9     FORMAT(/' Chart of print-out positions for',I2,'-var. quadrat',
C*Q     + 'ic-matrix cells.  "HI.JK" locates cell in row <H,I> and col',
C*Q     + 'umn <J,K>.',50(10(/4X,10F6.2,3X,10F6.2)))
C*Q      RETURN
C*Q      END
C
      SUBROUTINE CHEK(IER,NV,NF,A)
C Return IER = 1 if pattern is intolerably bizarre
      REAL A(NV,*)
      IER = 0
      DO I = 1,NV
        DO J = 1,NF
          IF(ABS(A(I,J))>10.) THEN
            IER = 1
            RETURN
          END IF
        END DO
      END DO
      END SUBROUTINE

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      CLN = '        '
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      LD = ABS(ND)
      IF(ABS(X)<1.0E-12) THEN !  Special for vanishingly small X
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X))) !  M is space free for decimal (or M-1 if X<0) )
      IF(M<0 .OR.  M<1.AND.X<0.) GOTO 55
      IF(ND>=10) LD = 0; LD = MIN(LD,M)
      DO I = 1,KW
        WK(I) = ' '
      END DO
      IF(LD==0) N = NINT(ABS(X))         ! Shouldn't be needed, but is
      IF(LD/=0) N = NINT(ABS(X)*10**LD)  ! This can overflow if LD is large
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' *******'
      END FUNCTION
C
      FUNCTION COD(N,L)
C Code nonneg integer N < 2700 as char string with letter coding part over 99
C and blank for N=0.  L = 0 when called by PLOT or L=1 when called by SPRED.
      CHARACTER(3) COD
      COMMON /TTR/ KR, KND, NLD
      COD = '   '
      IF(N<=0 .OR. N>=2700) RETURN
      IF(N<=9) THEN
        COD(2+L:2+L) = CHAR(48+N)
      ELSE IF(N<=99) THEN
        COD(2:3) = CHAR(48+N/10)//CHAR(48+MOD(N,10))
      ELSE
        COD = CHAR(96+N/100)//CHAR(48+MOD(N/10,10))//CHAR(48+MOD(N,10))
      END IF
      RETURN
      END
C
      FUNCTION COMP2(AJ,AK,SS)
C Given an item I's squared loadings AJ and AK on factors J,K and its sum
C of squared loadings SS, compute its Comp2 salience in plane JK as follows:
C P = (AJ+AK)/SS is its prominance of this plane in I's composition, and
C R = Min(|AJ|,|AK|)/MAX(|AJ|,|AK|) [or some monotone increasing function
C f(R) thereof] reflects the degree to which these two factors are equally
C prominant in I.  Then COMP2 = P*R (or [P*f(R)] equals 1.0 when item I lies
C entirely in plane JK with the same weight on both factors, and decreases
C to zero as either factor P or R decreases.
      P = (AJ**2 + AK**2)/SS
      BJ = ABS(AJ); BK = ABS(AK)
      R = MIN(BJ,BK)/MAX(BJ,BK,.0001)  ! AJ and AK can both be negligible
      COMP2 = P*R
      END FUNCTION
C
      SUBROUTINE CONTRL(A1,WRD,KR)
C This permits keyboard entry of various control parameters.
      CHARACTER*78 WRD(0:6)*6, CLN*8, TR*1, LBL(9)*4, LINE, LTMP,
     +  CH2*2, CH7*7, CH6*6, CH5*5, CH1(0:9)*1
      INTEGER LL(9)
      REAL A1(MV,0:*), CUM(4,0:4)
      EXTERNAL SCAN
      COMMON  NV, NF, MV, MF
      COMMON /BL2/ LIM, CV, PD1, MODE, GAM
      COMMON /BL3/ BH, JA, JB, CV1, ADD, R0, R1, WSAL
      COMMON /BL6/ B0, B1, DB, DF, TOL, IMAX
      COMMON /CM/ CUM
C          MODE is BUFFed as digit 4 of JFLAG
      SAVE LBL, LL, CH1, KCH
      DATA LBL/'MODE','WND ','WSAL','BH  ','JAJB','CV  ','DF  ','TOL ',
     +         'IMAX'/, LL/4,3,4,2,4,2,2,3,4/, CH1/10*' '/, KCH/0/
C     MODE = 0/1/2/3/4. STEP vs. SCAN: MODE/2;  Serial vs. Parallel: MOD(MODE,2); OBLMIN, MODE=4
      M = KCH; KF1 = 0; KF2 = 0; WARN = 0.
100   CALL SYSTEM('cls')
      MM = MODE/2; CH2 = 'CV'; IF(MM==2) CH2 = 'GM'
      IF(CH1(M)=='*') KCH = M
      WRITE(6,'(//11X,"Here are the current settings of your rotatio",
     +  "n controls."/13X,"The one changed most recently is flagged ",
     +  "by "" * ""."/)')

C  ķ
C   Solution style   Hyperplane-misfit parameters    Convergence controls 
C  Ķ
C   1 MODE  2 WND  3 WSAL  4 BH  5 JA,JB  6 CV  7 DF  8 TOL  9 IMAX 
C   SCAN/P * 50.0    1.0    .20     1, 2   1.0   .60   1.00     50  
C  Ľ

      LTMP = '  '//
     +       'Ķ '
      LINE = LTMP
      CALL SUBST(LINE,'׶','ҷ')
      IF(KR>0) CALL TRLIN(LINE)
      WRITE(6,'(A)') LINE
      WRITE(6,'(2X,A," Solution style ",A,"  Hyperplane-misfit ",
     +  "parameters  ",A,"  Convergence controls ",A,)') TR(''),
     +  TR(''), TR(''), TR('')
      LINE = LTMP
      IF(KR>0) CALL TRLIN(LINE)
      WRITE(6,'(A)') LINE
      WRITE(6,'(2X,A," 1 MODE ",A," 2 WND ",A," 3 WSAL ",A," 4 BH ",A,
     +  " 5 JA,JB ",A," 6 ",A,1X,A," 7 DF ",A," 8 TOL ",A," 9 IMAX ",
     +  A)') TR(''), TR(''), TR(''), TR(''), TR(''), TR(''), CH2,
     +  TR(''), TR(''), TR(''), TR('')
      CH1(KCH) = '*';
      X = CV; IF(MM==2) X = GAM
      IF(MODE==4) WSAL = 0.  ! MM=2 and MODE=4 are both Oblimin
      WRITE(6,'(2X,A,A,A6,1X,A,A,A5,1X,A,A,A5,2X,A,A,A4,1X,A,A,I4,",",
     +  I2,1X,A,A,A4,1X,A,A,A4,1X,A,A,A5,1X,A,A,I5,2X,A)') TR(''),
     +  CH1(1), WRD(MODE),TR(''), CH1(2), CLN(B0,5,1), TR(''),CH1(3),
     +  CLN(WSAL,5,2),TR(''), CH1(4), CLN(BH,4,2), TR(''),CH1(5), JA,
     +  JB, TR(''),CH1(6), CLN(X,4,1), TR(''), CH1(7), CLN(DF,4,2),
     +  TR(''),CH1(8), CLN(TOL,5,2), TR(''), CH1(9), IMAX ,TR('')
      CH1(KCH) = ' '
      LINE = LTMP
      CALL SUBST(LINE,'׶','н')
      IF(KR>0) CALL TRLIN(LINE)
      WRITE(6,'(A)') LINE
      IF(KF1==1) WRITE(6,'(5X,"Default value ",A3," of WSAL for mo",
     +  "de ",A," has been reinstated.")') CLN(WSAL,3,1),WRD(MODE)
      IF(KF2==1) WRITE(6,'(4X,"STEP modes do not allow negative JA.")')
      IF(MODE==4) WRITE(6,'(8X,"Controls 2 - 5 and 7 do not affect OB",
     +  "LMIN rotation; but in"/8X,"this mode, control 6 (now GM), se",
     +  "ts Oblimin''s Gamma parameter."/8X,"Its default value is 0 ",
     +  " (Quartimin).  To see details, enter -6.")')
      IF(WARN<0.) WRITE(6,'(6X,"WARNING: Current setting ",A4," of ",
     +  A," is much larger than standard."/15X," Make sure that this",
     +  " is what you really want.")') CLN(-WARN,4,2), LBL(M)(:LL(M))
cc      IF(MODE/=4 .AND. WSAL<-.001) WRITE(6,'(5X,"Reminder: Negative",
      IF(MODE/=4) WRITE(6,'(5X,"Reminder: Negative",
     +  " WSAL tries to encourage Complexity-2 items.")')
      KF2 = 0; WARN = 0.; KF1 = 0    ! Flag to report on default WSAL
101   WRITE(6,'(/5X,"To revise one of these or see information on it,",
     +  " enter its index"/5X,"with minus sign to display the documen",
     +  "tation, or unsigned if you"/5X,"prefer to omit that.  Otherw",
     +  "ise, hit RETURN to regain Main Menu."/)')
      CALL SCAN(J,1,'I',5)
      IF(J<=0) RETURN
      READ(2,*) M
      INFO = -SIGN(1,M); M = ABS(M)
      IF(M<1 .OR. M>9) WRITE(6,'(I6," does not index a HYBALL param",
     +  "eter.  Try again.")') M
      IF(M<1 .OR. M>9) GOTO 101
      CALL SYSTEM('cls')
      GOTO(10,20,30,40,50,60,70,80,90) M
c--------------------------------------------------------------------------------
c                          SOLUTION MODE:
c  HYBALL searches for factor axes on which overall hyperplane quality is
c  optimal by iterating planar rotations in which each movable axis is shifted
c  to the position that minimizes HYBALL's currently parameterized hyperplane-
c  misfit measure for the other factor in that plane.  Two styles of solution
c  for planar minima are available, STEP ("Step-down Regression") and SCAN
c  ("Brute-force Scanning"); and the iterations can be paced in two ways, Serial
c  or Parallel.  All you need to know about these here is that SCAN generally
c  (though not always) yields mildly better solutions than STEP but is much
c  slower than it, while Serial iteration is appreciably faster than Parallel
c  but somewhat more restricted in the solutions it can locate by Spin search.
c  These rotation-style alternative jointly define four solution modes, namely
c              STEP/S,   STEP/P,   SCAN/S,    SCAN/P.
c  listed here in ascending order both of likely solution quality and compu-
c  tation time.  Note, however, that the quality of STEP solutions may equal
c  or surpass SCAN results when hyperplanes are either very clean or very
c  noisy.  Conditions favoring Serial over Parallel iteration remain unknown.

CCC10    IF(INFO>0) WRITE(6,'(/26X,"SOLUTION MODE:"/"  HYBALL searche",
10    IF(INFO<0) GOTO 13
      WRITE(6,'(/26X,"SOLUTION MODE:"/"  HYBALL searches for factor ",
     +  "axes on which overall hyperplane quality is"/"  optimal by ",
     +  "iterating planar rotations in which each movable axis is sh",
     +  "ifted"/"  to the position that minimizes HYBALL''s currentl",
     +  "y parameterized hyperplane-"/"  misfit measure for the othe",
     +  "r factor in that plane.  Two styles of solution"/"  for pla",
     +  "nar minima are available, STEP (""Step-down Regression"") a",
     +  "nd SCAN"/"  (""Brute-force Scanning""); and the iterations ",
     +  "can be paced in two ways, Serial"/"  or Parallel.  All you ",
     +  "need to know about these here is that SCAN generally"/2X,
     +  "(though not always) yields mildly better solutions than STE",
     +  "P but is much"/"  slower than it, while Serial iteration is",
     +  " appreciably faster than Parallel"/"  but somewhat more re",
     +  "stricted in the solutions it can locate by Spin search."/2X,
     +  "(Returns under Serial tend to be a subset of the patterns ",
     +  "found by Parallel.)"/"  These rotation-style alternatives ",
     +  "jointly define four solution modes, namely")')
      WRITE(6,'(/15X, "STEP/S,    STEP/P,    SCAN/S,    SCAN/P,"//2X,
     +  "listed here in ascending order both of likely solution quali",
     +  "ty and compu-"/"  tation time.  Note, however, that the qual",
     +  "ity of STEP solutions may equal"/"  or surpass SCAN results ",
     +  "when hyperplanes are either very clean or very"/"  noisy.  C",
     +  "onditions favoring Serial over Parallel iteration remain un",
     +  "known.")')
      WRITE(6,'(/" Note 1. Fifth mode OBLMIN is serial rotation by ",
     +  "direct Oblimin."/" Note 2. For advice on Comp2 item weight",
     +  "ing, see the WSAL documentation.")')
      IF(INFO>0) CALL WAIT(1)
13    MD = MODE
      WRITE(6,'(/"  The list of solution MODE alternatives below mark",
     +  "s your current choice while"/"  reporting for each its Speed",
     +  " (mean seconds per iteration cycle), Frugality"/"  (mean cyc",
     +  "les per solution), and percent of solutions that were nonver",
     +  "gent"/"  since its performance register was last cleared.  ",
     +  "(NOTE: Unlike Speed,"/"  Frugality and Nonconvergence are co",
     +  "nsiderably affected by several of"/"  the control settings ",
     +  "as well as your rotation''s start position.)")')
      WRITE(6,'(/14X,"MODE alternative  Speed  Frugality  Nonconv",
     +  "erg")')
      DO I = 0,4
        CH2 = '  '
        IF(MODE==I) CH2 = '=>'
        CH7 = '    ?  '
        CH6 =  '   ?  '
        CH5 =   '  ?  '
        IF(CUM(2,I)>=1.) THEN
          CH7 = CLN(CUM(1,I)/CUM(2,I),7,2)
          CH6 = CLN(CUM(2,I)/CUM(3,I),6,1)
          R = 100*CUM(4,I)/CUM(3,I)
          IF(R>=1.) CH5 = CLN(R,5,1)
          IF(R<1. .AND. R>=.001) CH5 = CLN(R,5,2)
          IF(R<.001) CH5 = CLN(R,4,11)
        END IF

C             MODE alternative  Speed  Frugality  Nonconverg  TooOblique
C                 1. SCAN/S   xx23.54   xx40.1      x13.2%
C              => 2. SCAN/P   xx23.51     40.1

        WRITE(6,'(15X,A,I2,". ",A,3X,A7,3X,A6,6X,A5)') CH2, I+1,
     +    WRD(I), CH7, CH6, CH5
      END DO
      WRITE(6,'(/" Hit RETURN if => picks the mode you want. Otherw",
     + "ise, enter the index of your"/" choice.  To clear its per",
     + "formance register, enter its index with a minus sign."/)')
      CALL SCAN(J,1,'I',5)
      IF(J==0) GOTO 16
      IF(J<0) GOTO 13
      READ(2,*) K
      MODE = MIN(4,MAX(0,ABS(K)-1))
      IF(MODE/=MD) KCH = 1  ! Flags change in MODE
      IF(K<0) THEN
        WRITE(6,'(" Enter anything to confirm that you want to clear",
     +   " the ",A," performance"/" register.  Otherwise, hit RETURN",
     +   " to leave this untouched.")') WRD(MODE)
        CALL SCAN(J,0,'B',5)
        IF(J==0) GOTO 16
        DO I = 1,4
          CUM(I,MODE) = 0.
        END DO
      END IF
16    IF(MODE>=4 .OR. WSAL<0.) GOTO 100  ! Keep WSAL if set for Comp2 weighting
      MM = MODE/2   ! MM is 0 for STEP, 1 for SCAN, 2 for OBLMIN
      IF(MM==0) JA = MAX(0,JA)
      IF(MM/=MD/2) THEN  ! MD is previous MODE
        LIM = 10-11*MM
        KF1 = 1          ! flag to report reinstatement of default WSAL
        WSAL = 1.*MM     ! Default WSAL
      END IF
      GOTO 100
c-----------------------------------------------------------------------------
c                   MISFIT POWERING PARAMETERS JA,JB
c JA and JB are integer exponents in the hyperplane-misfit function that affect
c its curvature respectively within and outside of the hyperplane band. JA is
c unbounded whereas JB cannot be less than 2; but neither should exceed single-
c digit size in ordinary applications.  Source-recovery studies suggest that
c low positive values may generally be best for JA but establish no strong
c recommendations for it beyond avoidance of all but its smallest negative
c values.  For JB, value 2 appeared slightly better than 4 and much better
c than 6 in SCAN mode; whereas in STEP mode, 4 and 6 seemed slightly superior
c to 2.  (NOTE: Since negative JA often yields degeneracies under STEP,
c this control combination is not allowed.)
c     Default recommendations: Take JA to be 2, or under SCAN perhaps 1;
c                               and JB to be 2, or under STEP perhaps 4.

50    IF(INFO>0) WRITE(6,'(19X,"MISFIT POWERING PARAMETERS JA,JB"/
     +  " JA and JB are integer exponents in the hyperplane-misfit f",
     +  "uction that affect "/" its curvature respectively within a",
     +  "nd outside of the hyperplane band. JA is"/" unbounded wher",
     +  "eas JB cannot be less than 2; but neither should exceed si",
     +  "ngle-"/" digit size in ordinary applications.  Source-recov",
     +  "ery studies suggest"/" that low positive values may general",
     +  "ly be best for JA but establish no strong"/" recommendation",
     +  "s for it beyond avoidance of all but its smallest negative"/
     +  " values.  For JB, value 2 appeared slightly better than 4 a",
     +  "nd much better"/" than 6 in SCAN mode; whereas in STEP mode,",
     +  " 4 and 6 seemed slightly superior"/" to 2.  (NOTE: Since neg",
     +  "ative JA often yields degeneracies under STEP,"/" this cont",
     +  "rol combination is not allowed."//5X,"Default recommendatio",
     +  "ns: Take JA to be 2, or under SCAN perhaps 1;"/31X,"and JB ",
     +  "to be 2, or under STEP perhaps 4.")')
      KA = JA
      KB = JB
53    WRITE(6,'(/" Your hyperplane-powering parameters are now <JA,",
     +  "JB> = <",I3,",",I2,">."/" Hit RETURN to accept these sett",
     +  "ings or enter an alternative pair of integers."/)') JA, JB
      CALL SCAN(J,0,'I',5)
      IF(J<0) GOTO 53
      IF(J==0) GOTO 100
      IF(J==1) READ(2,*) JA
      IF(J>1) READ(2,*) JA, JB
      JB = MAX(2,JB)
      IF(MM==0 .AND. JA<0) THEN
        JA = MAX(0,JA)
        KF2 = 1
      END IF
      IF(JA/=KA .OR. JB/=KB) KCH = 5
      GOTO 100

c--------------------------------------------------------------------------------
C                     PLANAR SEARCH WINDOW (WND)
C  When repositioning a factor K in a factor plane <J,K> to maximize the
C  density of items close to the K-axis, all pattern points whose vectoral
C  angle in the plane to K's start position exceeds angle WND are ignored.
C  (This reduces the risk that competition between factors for the same item
C  alignment will result in nonconvergent oscillations or factor collapse.)
C  Its permitted range, in degrees, is 10 to 90.  Its choice appears not to
C  matter much for results beyond greater incidence of nonconvergence from
C  large values and needless reduction of solution speed from small ones
C     Default recommendation for WND: 50 or 60.

20    IF(INFO>0) WRITE(6,'(/26X,"PLANAR SEARCH WINDOW (WND)"/2X,
     +  "When repositioning a factor K in a factor plane <J,K> to ma",
     +  "ximize the"/"  density of items close to the K-axis, all pa",
     +  "ttern points whose vectoral"/"  angle in the plane to K''s ",
     +  "start position exceeds angle WND are ignored."/"  (This red",
     +  "uces the risk that competition between factors for the same",
     +  " item"/"  alignment will result in nonconvergent oscillatio",
     +  "ns or factor collapse.)"/"  Its permitted range, in degrees,",
     +  " is 10 to 90.  Its choice appears not to"/"  matter much fo",
     +  "r results beyond greater incidence of nonconvergence from"/2X,
     +  "large values and needless reduction of solution speed from s",
     +  "mall ones."//6X,"Default recommendation for WND: 50 or 60.")')
      WARN = 99.
      CALL SETPAR(B0,LBL(M),LL(M),10.,90.,4,1,WARN,KCH,M)
      GOTO 100

c--------------------------------------------------------------------------------
C                     SALIENCE WEIGHTING ( WSAL > 0. )
C  HYBALL measures the overall quality of a factor pattern by averaging misfit
C  ratings of the loadings therein. (An item i's misfit to factor j's hyper-
C  plane is an increasing function of the magnitude of i's pattern coefficient
C  on factor j).  This averaging is either unweighted (WSAL=0) or weighted by
C  a WSAL-powered function of item i's loadings on the factors other than j.
C  WSAL cannot be negative, and should seldom be set much larger than 1.
C  Source-recovery studies have obtained best results for STEP from WSAL=0;
C  but under SCAN, setting 1.0 was clearly superior to 0 and mildly better
C  than .5.  In all tested cases, 2.0 was much inferior to lower WSAL values.
C      Default recommendation for WSAL: 0 under STEP but 1.0 under SCAN.

C                  COMP(LEXITY)-2 WEIGHTING ( WSAL < .0 )
C  Item weighting that decreases preference under STEP and SCAN for items having
C  only one appreciable loading (complexity 1) rather than two (complexity 2)
C  can now be selected by setting WSAL between 0 and 1 with with NEGATIVE sign.
C  The larger is WSAL's negative size, the more equally ideal are complexities
C  1 and 2.  NOTE: Early returns show that benefits from Comp2 weighting emerge
C  only under Spin search, with Kaiser norming often appreciably beneficial.
C  > To include Kaiser norming, add 1 to your WSAL choice before negating.

30    IF(INFO>0) WRITE(6,'(/21X,"SALIENCE WEIGHTING ( WSAL > 0. ) "/
     +  "  HYBALL measures the overall quality of a factor pattern by",
     +  " averaging misfit"/"  ratings of the loadings therein. (An i",
     +  "tem i''s misfit to factor j''s hyper-"/"  plane is an increa",
     +  "sing function of the magnitude of i''s pattern coefficient"/2X,
     +  "on factor j.)  This averaging is either unweighted (WSAL=0) ",
     +  "or weighted by"/"  a WSAL-powered function of item i''s load",
     +  "ings on the factors other than j. "/"  WSAL cannot be negati",
     +  "ve, and should seldom be set much larger than 1."/2X,"Source",
     +  "-recovery studies have obtained best results for STEP frrm W",
     +  "SAL=0;"/"  but under SCAN, setting 1.0 was clearly superior",
     +  " to 0 and mildly better"/"  than .5.  In all tested cases, ",
     +  "2.0 was much inferior to lower WSAL values.  "/6X,"Default ",
     +  "recommendation for WSAL: 0 under STEP but 1.0 under SCAN.")')
      IF(INFO>0) WRITE(6,'(/19X,"COMP(LEXITY)-2 WEIGHTING ( WSAL <",
     +  " .0 )"/" Item weighting that decreases preference under STEP",
     +  " and SCAN for items having"/" only one appreciable loading ",
     +  "(complexity 1) rather than two (complexity 2)"/" can now be ",
     +  "selected by setting WSAL between 0 and 1 with NEGATIVE sign."/
     +  " The larger is WSAL''s negative size, the more equally ideal",
     +  " are complexities"/" 1 and 2.  NOTE: Early returns show that "
     +  "benefits from Comp2 weighting emerge"/" only under Spin sear",
     +  "ch, with Kaiser norming often appreciably beneficial."/" > ",
     +  "To include Kaiser norming, add 1 to your WSAL choice before",
     +  " negating."/)')
      WARN = 5.
      CALL SETPAR(WSAL,LBL(M),LL(M),-2.,9.,4,1,WARN,KCH,M)
      IF(WSAL<-2.) THEN
        WRITE(6,'(" WSAL =",A5," is disallowed.  For Comp2 weighting ",
     +    "this must be negation of"/" a weight in the unit interval,",
     +    " plus 1 if you want Kaiser norming.")') CLN(WSAL,5,1)
        GOTO 30
      END IF
      GOTO 100

C Comp2 theory:  For each item i, let i be the sum of i's squared loadings
C while i(jk) is their sum only on factors i and j.  Then iP = i(jk)/i
C measures the prominence of factor plane jk in i, while if iMj = A(i,j),
C iR = Min(iMj,iMk)/Max(iMj,iMk) reflects the degree to which these two factors
C are equally prominent in item i.  So Comp2(i) =def iP*iR is maximal at 1.0
C when i lies entirely in plane jk with the same weight on both factors, and
C decreases to zero as either P or R decreases.  Finally, with moderator
C parameter Q chosen in the unit interval, item i's factor loadings are
C multiplicatively attenuated during subcycles of axis repositioning in the
C jk-plane by item weight iW =def 1-Q*Comp2(i).  The rotational consequences
C thereof range from null (iW = 1) when item i has zero loading on one of
C factors j,k as currently positioned, down to maximal damping of i's influence
C in this plane at iW = 1-Q when Comp2(i) = 1.

c--------------------------------------------------------------------------------
C                       HYPERPLANE BANDWIDTH BH
C  Classically, a factor's "hyperplane" is a band of small loadings thereon
C  that are viewed interpretively as nonsalient or nearly negligible.  HYBALL
C  defines loadings on a factor to be in its hyperplane just in case they
C  are in the interval zero  BH for your choice of positive BH.  Source
C  recovery studies suggest that BH is best between .15 and .25 or so,
C  somewhat larger than traditional.
C      Default recommendation for BH: .20.

40    IF(INFO>0) WRITE(6,'(26X,"HYPERPLANE BANDWIDTH (BH)"/"  Classi",
     +  "cally, a factor''s ""hyperplane"" is a band of small loadin",
     +  "gs thereon"/"  that are viewed interpretively as nonsalient",
     +  " or nearly negligible.  HYBALL"/"  defines loadings on a fa",
     +  "ctor to be in its hyperplane just in case they"/"  are in th",
     +  "e interval zero  BH for your choice of positive BH.  Source"/
     +  "  recovery studies suggest that BH is best between .15 ",
     +  "and .25 or so,"/"  somewhat larger than traditional."//6X,
     +  "Default recommendation for BH: .20 or thereabouts.")')
      IF(NF<=9) WRITE(6,'(/"  To see the current distribution of fa",
     +  "ctor loadings (each factor separately)"/"  before adjustin",
     +  "g BH, enter anything.  Otherwise, hit RETURN.")')
      IF(NF>9) WRITE(6,'(/"  To see the current distribution of fac",
     +  "tor loadings (all factors combined)"/"  before adjusting B",
     +  "H, enter anything.  Otherwise, hit RETURN.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) CALL SPRED(NV,NF,A1,BH,MV)
      WARN = .6
      CALL SETPAR(BH,LBL(M),LL(M),.05,1.1,3,2,WARN,KCH,M)
      B1 = MIN(B0,100*BH) ! B1 is angular counterpart of BH for STEP
      GOTO 100
c--------------------------------------------------------------------------------
c                 WITHIN-HYPERPLANE MISFIT CURVATURE (CV)
c  As CV approaches its lower limit of -1.0, the hyperplane misfit function
c  becomes increasingly indifferent to the size of loadings within the hyper-
c  plane band.  CV has no upper limit, but increasing its value beyond 1 or 2
c  changes its character from modulating within-hyperplane curvature to multi-
c  plying JB's muting of misfit differences among loadings outside of the
c  hyperplane.  CV = -1 yields noticably higher hyperplane counts than does
c  positive CV, but this apparent gain in hyperplane quality is spurious: In
c  studies of artificial data with complex source structure, negative CV has
c  been substantially inferior to positive CV in source recovery.  CV settings
c  1 and 2 were clearly best over the range tested; whether even larger CV*JB
c  is sometimes beneficial still remains for inquiry. (Note: Negative JA makes
c  CV ineffectual; otherwise, choosing value 0 either for CV or for JA makes
c  the other''s setting irrelevant.)
c      Default recommendation for CV: 1.0 or 2.0.

c                    OBLIMIN GAMMA PARAMETER (-GM)
c  Oblimin rotation seeks to minimize a one-parameter Loss measure that for
c  each variable is an increasing function of the extent to which that item
c  has appreciable loading on more than one factor.  This criterion proves
c  to be especially powerful at recovering source patterns in which a high
c  proportion of the variables have complexity 1; however, it is rather less
c  successful with patterns in which considerable factor complexity prevails.
c      Oblimin's parameter, usually called "Gamma," can be any real number.
c  However, positive values are not recommended since when Gamma increases
c  above +.5, it first passes through an interval of rotation degeneracy and
c  after recovering from that never yields results superior to non-positive
c  Gamma.  Oblimin with Gamma=0 is known as "Quartimin," and appears to be
c  virtually as good at locating moderately complex source patterns as any
c  negative setting of Gamma.  In tests of recovering source patterns wherein
c  complexity 1 was weak, Gamma -1 was markedly superior to Gamma 0 but
c  neither approached the success of SCAN with Comp2 weighting.

c      When OBLMIN is Hyball's solution Mode, the negation of control GM is
c  taken for Oblimin's Gamma setting.  Thus GM=0 sets Gamma=0 (Quartimin) and
c  GM=g sets Gamma=-g.  Should you wish to experiment with positive Gamma,
c  choices of GM are allowed down to -1 (that is, Gamma up to +1).

60    IF(INFO>0. .AND. MM<2) WRITE(6,'(/18X,"WITHIN-HYPERPLANE",
     +  " MISFIT CURVATURE (CV)"/"  As CV approaches its lower limit ",
     +  "of -1.0, the hyperplane misfit function"/"  becomes increasi",
     +  "ngly indifferent to the size of loadings within the hyper-"/
     +  "  plane band.  CV has no upper limit, but increasing its va",
     +  "lue beyond 1 or 2"/"  changes its character from modulating",
     +  " within-hyperplane curvature to multi-"/"  plying JB''s mut",
     +  "ing of misfit differences among loadings outside of the"/2X,
     +  "hyperplane.  CV = -1 yields noticably higher hyperplane cou",
     +  "nts than does"/"  positive CV, but this apparent gain in hy",
     +  "perplane quality is spurious: In"/"  studies of artificial ",
     +  "data with complex source structure, negative CV has"/"  bee",
     +  "n substantially inferior to positive CV in source recovery.",
     +  "  CV settings"/"  1 and 2 were clearly best over the range ",
     +  "tested; whether even larger CV*JB"/"  is sometimes benefici",
     +  "ial still remains for inquiry. (Note: Negative JA makes"/2X,
     +  "CV ineffectual; otherwise, choosing value 0 either for CV ",
     +  "or for JA makes"/"  the other''s setting irrelevant.)"/4X,
     +  "Default recommendation for CV: 1.0 or 2.0.")')
      IF(INFO>0. .AND. MM==2) THEN
         WRITE(6,'(/18X,"OBLIMIN GAMMA PARAMETER (-GM)"/"  Oblimin ro",
     +     "tation seeks to minimize a one-parameter Loss measure tha",
     +     "t for"/"  each variable is an increasing function of the ",
     +     "extent to which that item"/"  has appreciable loading on ",
     +     "more than one factor.  This criterion proves"/"  to be es",
     +     "pecially powerful at recovering source patterns in which ",
     +     "a high"/"  proportion of the variables have complexity 1;",
     +     " however, it is rather less"/"  successful with patterns ",
     +     "in which considerable factor complexity prevails."/6X,"Ob",
     +     "limin''s parameter, commonly called ""Gamma,"" can be any",
     +     " real number."/"  However, positive values are not recomm",
     +     "ended since when Gamma increases"/"  above +.5, it first ",
     +     "passes through an interval of rotation degeneracy and"/2X,
     +     "after recovering from that never yields results superior ",
     +     "to non-positive"/"  Gamma.  Oblimin with Gamma=0 is known",
     +     " as ""Quartimin"", and appears to be"/"  virtually as goo",
     +     "d at locating moderately complex source patterns as any"/
     +     "  negative setting of Gamma.  In tests of recovering sou",
     +     "rce patterns wherein"/"  complexity 1 was weak, Gamma -1",
     +     " was markedly superior to Gamma 0, but"/"  neither appro",
     +     "ached the success of SCAN with Comp2 weighting."/)')
        WRITE(6,'(6X,"When OBLMIN is Hyball''s solution Mode, the neg",
     +    "ation of control GM is"/"  taken for Oblimin''s Gamma sett",
     +    "ing.  Thus GM=0 sets Gamma=0 (Quartimin) and"/"  GM=g sets",
     +    " Gamma=-g.  Should you wish to experiment with positive Ga",
     +    "mma,"/2X,"choices of GM are allowed down to -1 (that is, ",
     +    "Gamma up to +1.)")')
      ELSE IF(INFO<=0. .AND. MM==2) THEN
        WRITE(6,'(/5X,"Control 6 now selects a variant of Oblimin ro",
     +    "tation, with Quartimin"/5X,"chosen by its default setting",
     +    " GM = 0.  Negative GM is unwise.")')
      END IF
      WARN = 10.     ! M is the chosen control param; if changed, M=>KCH
      IF(MM<2) CALL SETPAR(CV,LBL(M),LL(M),-1.0,50.,4,1,WARN,KCH,M)
      IF(MM==2) CALL SETPAR(GAM,'GM ',LL(M),-1.0,50.,4,1,WARN,KCH,M)
      GOTO 100   ! CV and GAM are kept separate except in I/O
c--------------------------------------------------------------------------------
c                      SHIFT-DAMPING FRACTION (DF)
c  On each cycle of Parallel iteration,S HYBALL computes a provisionally optimal
c  shift for each movable factor and then at cycle's end simultaneously moves
c  all factors a proportion DF of the computed shifts.  Like WND, decreases
c  in DF yield smoother convergence (less oscillation of factor movement) at
c  modestly slower speed.  If you are having trouble with cyclic nonconverence,
c  try smaller settings of DF and WND.
c      Default recommendation for DF: .6 or therabouts.

70    IF(INFO>0) WRITE(6,'(/22X,"SHIFT-DAMPING FRACTION (DF)"/2X,
     +  "On each cycle of Parallel iteration, HYBALL computes a prov",
     +  "isionally optimal"/"  shift for each movable factor and then",
     +  " at cycle''s end simultaneously moves"/"  all factors a prop",
     +  "ortion DF of the computed shifts.  Like WND, decreases"/2X,
     +  "in DF yield smoother convergence (less oscillation of factor",
     +  " movement) at"/"  modestly slower speed.  If you are having ",
     +  "trouble with cyclic nonconvergence,"/"  try smaller settings",
     +  " of DF and/or WND."//6X,"Default recommendation for DF: .6 ",
     +  "or therabouts.")')
      WARN = 1.0
      CALL SETPAR(DF,LBL(M),LL(M),.1,1.5,4,1,WARN,KCH,M)
      GOTO 100
c--------------------------------------------------------------------------------
C                      CONVERGENCE TOLERANCE (TOL)
C     HYBALL judges a rotation iteration to have converged when the largest
C     factor shift on the last cycle is less than a tiny displacement TOL
C     (before/after correlation scaled as degrees of angle).  Increasing
C     TOL coarsens convergence but increases its frugality.
C         Default recommendation for TOL: 1.0 or 2.0.

80    IF(INFO>0) WRITE(6,'(/22X,"CONVERGENCE TOLERANCE (TOL)"/5X,
     +  "HYBALL judges a rotation iteration to have converged when t",
     +  "he largest"/5X,"factor shift on the last cycle is less than",
     +  " a tiny displacement TOL"/5X,"(before/after correlation sca",
     +  "led as degrees of angle).  Increasing"/5X,"TOL coarsens con",
     +  "vergence but increases its frugality."//9X,"Default recomme",
     +  "ndation for TOL: 1.0 or 2.0.")')
      WARN = 10.
      CALL SETPAR(TOL,LBL(M),LL(M),.01,50.,4,1,WARN,KCH,M)
      GOTO 100
c--------------------------------------------------------------------------------
C                      ITERATION LIMIT (IMAX)
C       As its name implies, iteration limit IMAX is the maximum number
C       of iteration cycles allowed for any one rotation.  Once started,
C       a rotation terminates either when its convergence satisfies TOL,
C       or when it has completed IMAX cycles, whichever comes first.
C           Default recommendation for IMAX: 50 or thereabouts.

90    IF(INFO>0) WRITE(6,'(/24X,"ITERATION LIMIT (IMAX)"/7X,"As its ",
     +  "name implies, iteration limit IMAX is the maximum number"/7X,
     +  "of itertion cycles allowed for any one rotation.  Once star",
     +  "ted,"/7X,"a rotation terminates either when its convergence",
     +  " satisfies TOL,"/7X,"or when it has completed IMAX cycles, ",
     +  "whichever comes first."//11X,"Default recommendation for ",
     +  "IMAX: 50 or thereabouts.")')
      X = IMAX
      WARN = 100.
      CALL SETPAR(X,LBL(M),LL(M),1.,500.,4,10,WARN,KCH,M)
      IMAX = NINT(X)                 !      ^ Suppresses CLN decimal
      GOTO 100
      END SUBROUTINE
C
      SUBROUTINE FNDEND(K)
C Finds end of file K for appending; Lahey and Microsoft compilers requires
C backspace. *** WARNING: This is more primitive than FNDEND in HYDATA.
      BACKSPACE K
10    READ(K,'()',END=20)
      GOTO 10
20    BACKSPACE K
      END SUBROUTINE
C
      SUBROUTINE GETKBL(NF,NB,FIX,KBL)
C Reconstruct factors' block assignments from FIX and NB: Blocks -1,0,...,NB
C are Z (Waifs/Isolates), X (fixed inputs), A,..,{last lettered block};
C block Y (fully dependent) is block NB+1
      INTEGER FIX(*), KBL(-1:NB+1,0:*)  ! KBL needs size KBL(-1:NB+1,0:NF)
      DO I = -1,NB+1                    ! NB  30
        KBL(I,0) = 0
      END DO
      DO I = 1,NF
        IB = MIN(FIX(I),NB+1)   !  No discrimination among FIX flags > NB
        KBL(IB,0) = KBL(IB,0) + 1
        KBL(IB,KBL(IB,0)) = I   ! Block assignments are now loaded in KBL
      END DO
      END SUBROUTINE

      SUBROUTINE GETNAM(F2,WORD,LLL,MTH,JOB)  ! JOB=0/1 picks message
      CHARACTER QFMT, F2*12, WORD*(*), TR
      CALL LAST(LF2,F2,12)
      IF(QFMT(F2(:LF2))=='Y') THEN
        WORD = F2
        LLL = LF2
        RETURN
      END IF
      LLL = 1
      IF(JOB==0) WORD(:34) = 'names of the variables            '
      IF(JOB>0) WORD(:34) = 'the raw item indices              '
      WRITE(6,'(/9X,63A)') TR(''), (TR(''),I=1,61), TR('')
      WRITE(6,'(9X,A," WARNING. File ",A," containing ",3A/9X,A,
     + " has not been copied to this subdirectory. To read it, enter",
     + 1X,A/9X,A," the full subdirectory name (with leading but not",
     + " trailing   ",A/9X,A," path-slash, and drive letter if ",
     + "needed) which contains this.",A)') TR(''), F2(:LF2),
     + WORD(:22), WORD(23:34-LF2), (TR(''),I=1,7)
      IF(JOB==0) WRITE(6,'(9X,A," Otherwise, hit RETURN to con",
     + "tinue without variable names.   ",A)') TR(''), TR('')
      IF(JOB>0) WRITE(6,'(9X,A," Otherwise, hit RETURN to con",
     + "tinue without setting BOOTDATA. ",A)') TR(''), TR('')
      WRITE(6,'(9X,63A//)') TR(''), (TR(''),I=1,61), TR('')
10    READ(5,'(A)') WORD(:40)
      CALL LAST(LL,WORD,40)
      IF(LL==0) GOTO 30
      DO I = 1,LL
        N = ICHAR(WORD(I:I))
        IF(N>=97.AND.N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      LLL = LL+1+LF2
      WORD(LL+1:LLL) = '/'//F2(:LF2)
      IF(QFMT(WORD(:LLL))/='Y') THEN
        IF(JOB==0) WRITE(6,'(" File ",A," has eluded detecti",
     +   "on. The variables remain nameless.")') WORD(:LLL)
        IF(JOB>0) WRITE(6,'(" File ",A," has eluded detecti",
     +   "on. BOOTDATA cannot be set.")') WORD(:LLL)
        LLL = 0
        WRITE(6,'(" Hit RETURN to continue, or enter another path ",
     +   "head to try again."/)')
        GOTO 10
      END IF
30    MTH = MTH*(MIN(1,LLL))
      END SUBROUTINE
C
      SUBROUTINE GETSIZ(NEW,MV,MF,NX,QB,F1,F4,CHV,KFB)
      LOGICAL QB, QLOG    ! Reminder: QLOG is a function
      CHARACTER CH, QFMT, TR, CH1, CHV*5
      CHARACTER(12) F1, F4, CF, NAME(80)
      COMMON /CF/ CF
      EXTERNAL SCAN
      WRITE(6,'(/" WELCOME TO THE MAGICAL WORLD OF HYBALL FACTOR",
     +  " ROTATION.")')
      WRITE(6,'(/" The factor patterns here available for rotation ",
     +  "are the following:")')
      CALL LOOK(1,'*.*',NAME,80,N)
      IF(N==0) WRITE(6,'(/ " Nothing for HYBALL here. Go find some",
     +  "thing else to do.")')
      IF(N==0) STOP
      NN = 0
      DO I = N,1,-1
        IF(QLOG(NAME(I))) NN = I
        IF(NAME(I)(:6)=='HYBUF ') GOTO 5
      END DO
C5     IF(NN>=1) WRITE(6,'(15X,"  "" + "" flags logfiles of previ",
5     IF(NN>=1) WRITE(6,'("  "" + "" flags logfiles of previ",
     +  "ous runs")')
15    F4 = NAME(MAX(1,NN))
20    WRITE(6,'(/" The pattern file now picked for rotation is ",A)') F4
      IF(F4(:6)=='HYBUF ') WRITE(6,'(" Retrieving this logfile will",
     +  " continue your last HYBALL run.")')
      WRITE(6,'(" Hit RETURN if OK, or enter the index of another sel",
     +  "ection from this list."/)')
      CALL SCAN(J,1,'I',5)
      IF(J<0) GOTO 20
      IF(J>0) THEN
        READ(2,*) NN
        NN = MAX(1,MIN(NN,N))
        GOTO 15
      END IF
      CALL LAST(L,F4,12)          ! <<< F4 has been picked as input file
      IF(F4(L-2:L-1)=='.B' .OR. F4(L-3:L-2)=='.B') QB = .TRUE.
C       Not all HYBUFs containing blocked data can be identified this way
      DO K = 2,6  ! Determine if input is a bootstrap product
        CH1 = F4(K:K)
        IF(CH1=='('.OR.CH1==')'.OR.CH1=='['.OR.CH1==']'.OR.
     +    CH1=='{'.OR.CH1=='}') KFB = K  ! Position of bootstrap flag ! <<<
      END DO
      IF(.NOT.QLOG(F4)) THEN  ! HYBLOCK input identified by QB in this case
        F1 = F4; F4 = 'HYBUF       '   ! If QLOG(F4), F1 is read from F4
        CH = QFMT('HYBUF')   ! Check whether HYBUF is present
        IF(CH/='U' .AND. .NOT.QB) THEN
          WRITE(6,'(/10X,80A)') TR(''), (TR(''),I=1,58), TR('')
          WRITE(6,'(10X,A," Unless you abort this run immediately by ",
     +      "hitting CTRL-C, ",A/10X,A," your current HYBUF archive ",
     +      "will be transferred to file   ",A/10X,A," HYBUF.OLD, ov",
     +      "erwriting any previous results saved there. ",A)')
     +      (TR(''),I=1,6)
          WRITE(6,'(10X,80A)') TR(''), (TR(''),I=1,58), TR('')
          CALL WAIT(1)
        END IF
        GOTO 25   ! Start read of new input at label 25
      END IF
C Read data to be rotated from Hybuf logfile
      NEW = 0                             ! NEW = 0 for logfile
      OPEN(8,FILE=F4,FORM='UNFORMATTED')  ! NEW = 1,2 for ASCII/BINARY new input
      READ(8) N, MV, MF    ! NX=0 by default
      CLOSE(8)
      RETURN   ! Now allocate arrays in MAIN   ! F1 not set if F4 not logfile

C   Read from new input
C   In all cases F1 is the original input filename and F4 is the active logfile.
25    IF(QFMT(F1)=='Y') THEN
        NEW = 1
        CALL START(4,F1,K)  ! K returns number of entries in 1st data line
        IF(K>=3) READ(4,*) MV, MF, NX
        IF(K==2) READ(4,*) MV, MF
      ELSE
        NEW = 2
        OPEN(4,FILE=F1,FORM='UNFORMATTED')
        READ(4) MV, MF, NX
      END IF
      CLOSE(4)
      RETURN  ! Now allocate arrays in MAIN
      END SUBROUTINE
C
      SUBROUTINE GO(NEW,MV,MF,QB,QL,NTOT,NV1,NF1,KODE,NFF1,NFQ,MTH,
     +  NX,NB,KFB,LM,F1,F2,F4,WORD,IDENT,LST1,LST2,FIX,NFIX,FIX1,A0,CFF)
C Any pre-set block structure or record of original item indices go into
C FIX/LST2/FIX1 and LST1, respectively.  For 1st-level input only, NV1
C and NF1 are the numbers NV and NF of proper variables and factors, and
C NFF1 = NF1.  When the input includes quad-moments, NV1 = NV+1 and
C NF1=NF+1 for inclusion of the unit variable/factor, while NFF1 is the
C number of 2nd-level factors.  In both cases, NFQ = NFF1*(NFF1+1)/2.
      PARAMETER (MOM=1000)
      LOGICAL QB, QL, QT
      CHARACTER(8)  IDENT(*), COVNAM(:) !, CLN*8 ! Activate CLN when testing
      CHARACTER(12) F1, F2, F4, CF, WORD*80, CH1*1
      INTEGER FIX(*), FIX1(*), LST1(*), LST2(*), OMIT(MOM)  ! Size of FIX,FIX1 set by MAIN parameter
      REAL A0(MV,*), CFF(*), WK(MF*MF)
      ALLOCATABLE :: COVNAM
      COMMON /CF/ CF
      COMMON /OM/ NOM, OMIT
      EXTERNAL SCAN
      LO(I,J) = J*(J-1)/2 + I
      NOM = 0; KB = 0; IF(NEW==0) GOTO 10   ! NOM will be surrogate KBO
      DO I = 1,MF
        FIX(I) = 99   ! New input specifies FIX only if from HYBLOCK
      END DO
      IF(NEW==1) GOTO 15   ! Formatted input
      IF(NEW==2) GOTO 30   ! Unformatted input
10    OPEN(8,FILE=F4,FORM='UNFORMATTED')
      READ(8) NTOT, NV1, NF1, KODE, NFF1, NFQ, MTH, ((A0(I,J),I=1,NV1),
     +  J=1,NF1), (CFF(I),I=1,NFQ), F1, F2, (LST1(I),I=1,NV1), NX,
     +  (LST2(I),I=1,MAX(0,NX)), NB, (FIX1(I),I=1,NB)
CCC     If input from HYBLOCK, NX=NV1 and LST2 holds items' block assignments;
CCC     otherwise, -NX is MODA-output NX and LST2 is empty.
      IF(NF1==NFF1 .AND. KODE<0) QB = .TRUE. ! HYBLOCK input in this case
      IF(QB.AND.NX/=NV1) THEN
        WRITE(6,'(/" >> ERROR: Inconsistent signals of pre-proces",
     +    "sing by HYBLOCK.")')
        M = LH(F4,L4)+2; IF(F4(M:M)=='B') WRITE(6,'(11X,"Flag ""B"" ",
     +    "in this filename''s extension may be a renaming error.")')
      END IF
      IF(QB.AND.NX/=NV1) STOP
      IF(NX==NV1) NX = 0  ! Original NX from MODA is needed for BOOTDATA
      QL = .TRUE.
      CALL LAST(LF1,F1,12)
      GOTO 100
C   Read from new input
15    OPEN(4,F1); CALL LAST(LF1,F1,12)
      READ(4,'(A)') WORD  !; CALL LAST(J,WORD,80)
      CALL START(4,F1,KK)  ! KK returns number of entries in 1st data line
      IF(KK>=6) READ(4,*,ERR=55) NV1, NF1, NX, KODE, MTH, F2
      IF(KK<6) THEN  ! Nonstandard input   ! ^ If from Hyblock, KODE < 0 and NX=NV1
        WRITE(6,'(/" WARNING: This input file of nonstandard origin ",
     +    "has header starting"//" [ ",A,"]"//10X,"If this is what ",
     +    "you want, hit RETURN to continue."/10X,"Otherwise, enter",
     +    " anything to abort.")') WORD(:MIN(J,76))
        READ(5,'(A)') CH1; IF(CH1/=' ')  STOP
        WRITE(6,'(" The first data line in ",A," contains just",I2,
     +    " entries.  Default"/" values will be presumed for the re",
     +    "maining header entries expected.")') F1(:LF1), KK
        READ(4,*) NV1, NF1; NX = 0
        DO J = 1,NF1  ! Default omitted factor covars to orthonormal
          CFF(LO(J,J)) = 1.   ! CFF=0. was initialized in MAIN
        END DO
        R = 1.; F2 = '?           '
      END IF
C       Read ASCII input with provision for nonstandard format, assuming
C       pattern and factor covars have the same scale diagnosed from the 1st
C       two variances.  The COV array can be either triangular or full-square,
C       but must be normalized apart from common scale.
55    DO I = 1,NV1
        READ(4,*) (A0(I,J),J=1,NF1)
        LST1(I) = I  ! Default for unorthodox input
      END DO
      NFF1 = NF1; NFQ = LO(NF1,NF1); R = 1. ! When input after the pattern
      READ(4,*,END=22,ERR=22) N1, N2  ! For 1st-order input, N1 = NF1 with N2 either LO(NF1,NF1) or NF1
C Normal case 1: N1 = NF1, N2 = LO(NF1,NF1); Need NFF1 = NF1 at return from Go
C Nonstandard input case 2A: N1 = NF1, N2 = LO(NF1,NF1); triangle covars
C Nonstandard input case 2B: N1 = NF1, N2 = NF1; square covars
C Nonstandard input case 3: N1 = 1, N2 = Scaling-factor; implicitly orthonormal covars
C Quad-factoring (currently inoperative) N1 => NFF1, N2 => NFQ
      IF(N1<NF1) THEN      ! Unorthodox input presumes orthonormal covars
        R = 1.*N2; WK = 0.; QT = .TRUE.
        DO J = 1,NF1
          WK(LO(J,J)) = R
        END DO
        GOTO 22    ! R is a scaling factor for the pattern
      END IF
      NFF = LO(NF1,NF1)
      NF2 = NF1*NF1
      IF(N1/=NF1 .OR. (N2/=NFF.AND.N2/=NF2)) THEN
        WRITE(6,'(/" Input file ",A," incorrectly specifies how the c",
     +    "orrelations are entered."/" Its first line after the facto",
     +    "r pattern must immediately precede the array CF"/" of fact",
     +    "or correlations and must begin with the number NF of facto",
     +    "rs followed"/" (with separation by space or comma) by the",
     +    " number NF2 of entries in CF."/" NF2 equals NF*(NF+1)/2 ",
     +    "if CF is lower-triangular, or is NF if CF is square."/
     +    " Fix the problem and try again.")') F1(:LF1)
        STOP  ! *** Revise this if 2nd-order inputs are resurrected.
      END IF
      READ(4,*,END=22,ERR=22) (WK(J),J=1,N2)   ! Covariance input
      QT = .TRUE.; IF(N2==NF2) QT=.FALSE.
      R = WK(1) ! Scaling factor presumably corresponding to unit variance
22    DO J = 1,NF1
        DO I = 1,NV1
          A0(I,J) = A0(I,J)/R
        END DO
        IF(KK<6) CYCLE
        DO I = 1,J
          IF(QT) CFF(LO(I,J)) = WK(LO(I,J))/R          ! Triangle input
          IF(.NOT.QT) CFF(LO(I,J)) = WK(I+(J-1)*NF1)/R ! Full-matrix input
        END DO
      END DO                              ! WK is now free
      DO J = 2,NF1
        IF(ABS(1.-CFF(LO(J,J)))>.001) THEN
          WRITE(6,'(" The factor covariances violate HYBALL''s unit-",
     +      "norming presumption: No go.")')
          STOP
       END IF
      END DO
      IF(QB) THEN  ! ! Input from HYBLOCK
        READ(4,*,END=35) (FIX(I),I=1,NF1), (LST2(I),I=1,NV1)
        READ(4,*,END=35) NB, (FIX1(I),I=1,NB)
C         FIX has block assignments of factors, and LST2 block assignments of
C         items, from HYBLOCK; FIX1 has compressed code for block dependencies
        MTH = 0
      END IF
      READ(4,*,END=35) (LST1(I),I=1,NV1+NX)
      READ(4,*,END=35) NOM, (WK(I),I=1,NOM)  ! WK loads OFFL; maybe info on off-norm X-items
      QL = .TRUE.
      GOTO 35
30    OPEN(4,FILE=F1,FORM='UNFORMATTED')
      READ(4) NV1, NF1, NX, KODE, MTH, F2
      IF(NV1>MV .OR. NF1>MF) STOP
      READ(4) ((A0(I,J),I=1,NV1),J=1,NF1)
      READ(4) NFF1, NFQ
      READ(4) (CFF(I),I=1,NFQ)
      IF(QB) THEN  ! Input from HYBLOCK
C       In this case, the data are 1st-level and block-structured
        READ(4,END=35) (FIX(I),I=1,NF1), (LST2(I),I=1,NV1)
        READ(4,END=35) NB, (FIX1(I),I=1,NB)
        MTH = 0
      END IF
      READ(4,END=35) (LST1(I),I=1,NV1+NX)
      QL= .TRUE.     ! Flags input of MODA-output item indices
      READ(4,END=35) NOM, (WK(I),I=1,NOM) ! WK loads OFFL; NOM is NBO in MODA
C       Elements of OFFL give info about off-norm X-items and have form
C       [f]j+s, where flag f is a minus sign if this item is not binary,
C       j is its X-set index, and s is its input SD prior to standardization.
35    IF(.NOT.QL) THEN
        DO I = 1,NV1+NX  ! Shouldn't ever be needed
          LST1(I) = I
        END DO
        MTH = 0   ! No item indices received
      END IF
      IF(KFB>0) THEN
        MTH = 0  ! Don't set BOOTDATA from bootstrap input
        IF(NEW>0) F4 = 'HYBUF'//F1(KFB:KFB+1)//'     '
      END IF
C  Add manifest-input factors to list of dependent variables
      NFIX = NX  ! NFIX may be altered by later BLOCK call; NX is fixed by MODA
      IF(NX>0) THEN  !  For input from HYBLOCK, NX = 0
        DO I = 1,NX
          FIX(I) = 0
          DO J = 1,NF1
            A0(NV1+I,J) = 0.
          END DO
          A0(NV1+I,I) = 1.
        END DO
C  Treatment of off-norm X-item info received by WK in form (flag)[index+off-norm
C  variance): Minus-flagged non-binary X-items with estimated reliabilies get
C  their reliability index as pattern weight and are treated as undistinguished
C  X-items thereafter.  Received indices of binary items (position in X-set if
C  from MODA, index in pattern if from HYBLOCK) are converted to indices of
C  corresponding factors, saved in logfile Rec 1 OMIT for retrieval on hybuf
C  runs, and passed during the hyball run in scratchfile 33.
        DO I = 1,NOM   ! Any unreliable X-items?
          K = INT(ABS(WK(I)))
          WK(I) = WK(I) + SIGN(1.*NV1,WK(I))
          IF(WK(I)>0) CYCLE  ! Minus flags (nonbinary X-item + reliability index)
          Z = ABS(WK(I)); J = INT(Z)
          A0(J,K) = Z-J  ! X-item with reliability index as factor loading
        END DO
        NV1 = NV1+NX
        NXX = NX; NX = -NX  ! NXX+NX/=0 will later signal permutation or other change in fixed factors
      END IF
      IF(NOM>0) THEN
        DO I = 1,NOM  ! Convert binary item indices to binary factor indices
          IF(WK(I)<0) CYCLE  ! Minus flags (nonbinary X-item + reliability index)
          KB = KB+1; J = INT(WK(I)); K = 0
          DO WHILE (K>=0 .AND. K<=NF1)
            K = K+1
            IF(A0(J,K)>.1) THEN
              WK(I) = WK(I) - J + K; K = -1
            END IF
          END DO
        END DO
      END IF
      NOM = KB
      DO I = 1,NOM  ! Prepare to buff binary info in Rec 1 OMIT
        OMIT(I) = NINT(WK(I)*10000)
      END DO
      OPEN(33,FORM='UNFORMATTED')
      WRITE(33) KB, (WK(I),I=1,KB); REWIND 33

C Read in the original list of variable names
100   IF(.NOT.QL) GOTO 111   ! No list of COV-name indices (should never arise?)
      IF(F2(1:1)=='?') THEN
        J = 2  ! Just in case some input file lacks a 2 or 3 char extension
        IF(F1(LF1-3:LF1-3)=='.') J = LF1-4
        IF(F1(LF1-4:LF1-4)=='.') J = LF1-5 ! J is 2nd position before dot
        IF(QB) J = J-1     ! Drop last two basename chars from *.B* input
        F2 = F1(:J-1)//'.COV '//'      '
      END IF
      CALL GETNAM(F2,WORD,LLL,MTH,0)   ! WORD gets name of file with item names
      IF(LLL<=1) GOTO 111
      OPEN(13,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(13) LLL, WORD(:LLL)   ! Put in scratchfile because LLL may be long
      CALL START(4,WORD(:LLL),I)  ! Read COV-file
      READ(4,*) NT  ! Number of variables in COV-file; may exceed NV
      K = 0
107   READ(4,*,END=111) CH1  ! Search COV-file for namelist
      IF(CH1=='N') THEN
        ALLOCATE ( COVNAM(NT) )
        READ(4,*,ERR=111,END=111) (COVNAM(I),I=1,NT)
        IF(NT<NV1) WRITE(6,'(/" WARNING: ",A," contains names for ",A,
     +    " variables."/10X,"Fewer than wanted, so namelist must be ",
     +    "incorrect.")') WORD(:LLL), CF(:JF(NT))  ! Shd never be needed
        DO I = 1,NV1
          IDENT(I) = COVNAM(ABS(LST1(I)))
        END DO
        DEALLOCATE ( COVNAM )
        K = 1
        GOTO 110
      END IF
      GOTO 107
111   DO I = 1,NV1
        IDENT(I) = '['//CF(:JF(LST1(I)))//']     '
      END DO
110   CLOSE(4)
      MTH = MTH*K  ! Multiply, not add (K is binary)
      LM = 3
      DO I = 1,NV1
        CALL LAST(N,IDENT(I),8)
        IF(N>0) LM = MAX(LM,N)
      END DO
      END SUBROUTINE

CCCCCC   $$$$$$   ######  !!!!!! End of HYBALLA, start of HYBALLB
C
      FUNCTION HYFIND(K,L,A1,WSAL,WW)
C This finds coefficient for rotating factor K by factor L to the misfit-
C minimizing hyperplane by brute-force scanning.
C *** New: When WSAL < 0, WW contains Comp2 weights.
      REAL A1(MV,0:*), WW(*), MISFIT
      COMMON  NV, NF, MV, MF
      COMMON /BL5/ B0RAD, B0TAN, FINE
      CALL OMSET(K,L,A1,R,NV,MF,JL,0)   ! For JOB=0, R is a dummy
      DO I = 1,NV    ! OMSET has put 999. in A1(I,0) if omit, otherwise 0.
        IF(ABS(A1(I,K))<.01 .OR. ABS(A1(I,L))/(.001+ABS(A1(I,K)))
     +    >B0TAN) A1(I,0) = 999.
        IF(A1(I,0)<1) THEN
C                  ^ Any value here less than 999 would do as well
          IF(WSAL>.01) A1(I,0) = ABS(A1(I,K))**WSAL ! Salience weighting
          IF(WSAL<-.01) A1(I,0) = WW(I)   ! Comp2 Weighting
        END IF
      END DO
      HYFIND = 0.
      SMALL = MISFIT(K,L,A1,HYFIND)
      WIDE = B0RAD
      STEP = FINE
15    START = ATAN(HYFIND)
      SHIFT = 0.
      X = 0.
20    SHIFT = SHIFT+STEP
      X = TAN(START+SHIFT)
      S = MISFIT(K,L,A1,X)
      IF(S>=SMALL) GOTO 30
      HYFIND = X
      SMALL = S
30    X = TAN(START-SHIFT)
      S = MISFIT(K,L,A1,X)
      IF(S>=SMALL) GOTO 40
      HYFIND = X
      SMALL = S
40    IF(SHIFT<WIDE) GOTO 20
      IF(STEP < .01) RETURN
      WIDE = 1.5*STEP
      STEP = STEP/4.
      GOTO 15
      END FUNCTION
C
      FUNCTION HYPGET(K,L,A1,WW)
C This finds the coefficient for rotating factor K by factor L to hyperplane
C position in the K/L plane by step-down regression. The unweighted solution
C is followed by at most LIM polish strokes of weighted-regression fit of the
C hyperplane coeff.  In polishing, each pattern-point I is multiplied by a
C weight SQRT(WI) that increases in I's distance from the factor-L hyperplane.
C Unless JA<0, WI=1 when I lies on the edge (+/- BH) of factor L's hyperplane.
C Defining deviancy measure E for point I as
C
C            E =def [(I's L-loading)/BH]**2 ,
C
C WI is computed from exponential parameters JA and JB when JA>=0 as
C
C            WI = 1 + CV(1 - E**JA)   if E < 1 ,
C            WI = 1/E**JB             if E > 1 .
C
C When JA<0, the E<1 leg of this is replaced by WI = ROOT*(E**(ROOT-1)),
C where ROOT = 1/(1+ABS(JA)).  JA is allowed to go no lower than 0 in HYPGET
C polishing calls; but MISFIT accepts the loss function whose derivative WI is
C for all negative JA.   When WSAL>0, each pattern point is further weighted
C by a WSAL-powered function of its prominence on factor K.  KNT gets minor
C polish information.  **** New: When WSAL < 0, WW contains Comp2 weights
      REAL A1(MV,0:2*MF), B1(MV,0:2), WW(*)
      INTEGER KNT(-2:50)
      COMMON  NV, NF, MV, MF
      COMMON /BL1/ B1TAN, DBRAD
      COMMON /BL2/ LIM, CV, PD1, MODE, GAM
      COMMON /BL3/ BH, JA, JB, CV1, ADD, R0, R1, WSAL
      COMMON /BL5/ B0RAD, B0TAN, FINE
      COMMON /KNT/ KNT
      HYPGET = 0.; PD0 = 1.-PD1
      JJA = MAX(0,JA)
      IF(LIM>0) JJA = JA
      CALL OMSET(K,L,A1,R,NV,MF,JL,0)   ! For JOB=0, R is a dummy
      DO I = 1,NV    ! OMSET has put 999. in A1(I,0) if omit, otherwise 0.
        IF(ABS(A1(I,K))<.01 .OR. ABS(A1(I,L))/(.001+ABS(A1(I,K)))
     +   >B0TAN) A1(I,0) = 999.
        IF(A1(I,0)>998.) CYCLE
        A1(I,0) = A1(I,L)/A1(I,K)
        B1(I,0) = ABS(A1(I,K))/BH
        B1(I,1) = A1(I,K)*A1(I,K)
        B1(I,2) = A1(I,K)*A1(I,L)
        IF(WSAL==0.) CYCLE
        IF(WSAL>.0) WI = ABS(A1(I,K))**WSAL   ! Salience weighting
        IF(WSAL<.0) WI = WW(I)                ! Comp2 weighting
        B1(I,1) = B1(I,1)*WI
        B1(I,2) = B1(I,2)*WI
      END DO
      B = B0RAD + DBRAD
30    B = B - DBRAD
      BT = TAN(B)
      BT = MAX(BT,B1TAN)
      SK = 0.
      SL = 0.
      DO I = 1,NV
        IF(ABS(A1(I,0)-HYPGET) > BT) CYCLE
        SK = SK + B1(I,1)
        SL = SL + B1(I,2)
      END DO
      IF(SK>=.0001) HYPGET = SL/SK
      IF(BT>B1TAN) GOTO 30
      IF(LIM<=0) RETURN
      HYPO = HYPGET
      KOUNT = 0
50    KOUNT = KOUNT+1
      HYP1 = HYPO
      HYPO = HYPGET
      DO I = 1,NV
        ANG = ABS(A1(I,0)-HYPGET)
        IF(ANG>=1.) CYCLE
        E = ABS(B1(I,0)*ANG)
        IF(E>=1.) GOTO 70
        X = 1.
        IF(JJA==0 .OR. CV==0.) GOTO 60
        DO J = 1,JJA
          X = X*E
        END DO
60      WI = CV1 - CV*X
        GOTO 80
70      WI = 1./(E**4)
        IF(JB<=2) GOTO 80
        DO J = 3,JB
          WI = WI/E
        END DO
80      SK = SK + B1(I,1)*WI
        SL = SL + B1(I,2)*WI
      END DO
      IF(SK>.0001) HYPGET = SL/SK
      E = ABS(HYPGET-HYPO)
      HYPGET = PD1*HYPGET + PD0*HYPO
      B = HYPO - HYP1
      IF(ABS(B)<.001) GOTO 101
      X = (HYPGET-HYP1)/B
      IF(X<-.001) KNT(0) = KNT(0) + 1
      IF(X>1.01) KNT(-2) = KNT(-2) + 1
      IF(X>.001 .AND. X<.99) KNT(-1) = KNT(-1) + 1
101   IF(KOUNT<LIM .AND. E>.01) GOTO 50
      KNT(MIN(50,KOUNT)) = KNT(MIN(50,KOUNT)) + 1
      END FUNCTION
C
      SUBROUTINE INVF(W,NV,IER)
C This triangularly Gram-factors an order-NV symmetric matrix W in
C sym-storage and returns the inverse of this triangular pattern in W.
      REAL W(*)
      LO(I,J) = J*(J-1)/2 + I
      IER = 0
C  Replace W by its lower-triangular Gram-factor
      BIG: DO I = 1,NV
        I0 = I-1
        I1 = I+1
        LII = LO(I,I)
        IF(I0==0) GOTO 20
        DO  K = 1,I0
          WIK = W(LO(K,I))
          W(LII) = W(LII) - WIK*WIK
        END DO
20      IF(W(LII)>1.0E-35) GOTO 21
        IER = 2
        IF(W(LII)<0.) IER = 1
C        IF(IER==1) WRITE(6,'(/" *** Subroutine INVF cannot invert ",
C     ++   "non-Gramian matrix")')
C        IF(IER==2) WRITE(6,'(/" *** Subroutine INVF cannot invert ",
C     ++   "singular matrix")')
        IF(IER>=1) WRITE(6,'(/" *** SPIN cannot invert random rota",
     +    "tion matrix; will try again")')
        RETURN
21      W(LII) = SQRT(W(LII))
        IF(I1>NV) GOTO 50
        DO J = I1,NV
          LIJ = LO(I,J)
          IF(I0==0) GOTO 35
          DO K = 1,I0
            W(LIJ) = W(LIJ) - W(LO(K,J))*W(LO(K,I))
          END DO
35        W(LIJ) = W(LIJ)/W(LII)
        END DO
      END DO BIG
C Imvert triangular Gram-factor
50    W(LO(1,1)) = 1./W(LO(1,1))
      IF(NV==1) RETURN
      DO I = 2,NV
        I0 = I-1
        LII = LO(I,I)
        DO J = 1,I0
          X = 0.
          DO K = J,I0
            X = X - W(LO(K,I))*W(LO(J,K))
          END DO
          W(LO(J,I)) = X/W(LII)
        END DO
        W(LII) = 1./W(LII)
      END DO
      END SUBROUTINE

      SUBROUTINE LAST(L,WORD,M)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as L. If the string is empty, LAST is returned as 0.
      CHARACTER WORD*(*)
      WORD(:M) = ADJUSTL(WORD(:M))
      L = LEN_TRIM(WORD(:M))
      END SUBROUTINE

      FUNCTION LH(WORD,LN)
C Look for extension dot in WORD.  If found, LH returns number of characters
C prior to that; otherwise, LH returns full length LN of WORD.
      CHARACTER WORD*(*)
      N = LEN(WORD)
      CALL LAST(LN,WORD,N)
      LH = LN
      IF(LN==0) RETURN
      DO LH = 1,LN-1
        IF(WORD(LH+1:LH+1)=='.') RETURN
      END DO
      END FUNCTION
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
C ***** Note: This version of LOOK contains a FLAG provision
      LOGICAL PRM, QY, QLOG
      CHARACTER GET*(*), NAME(*)*12, WORD*40, WD*40, TMP*12, FLAG(80), E
      FLAG = ' '
      WD = GET; CALL LAST(M,WD,40)
      LL = 1
5     LL = LL+1
      E = WD(LL+1:LL+1)
      IF(E/='|' .AND. E/='/' .AND. LL<M) GOTO 5  ! *** No longer relevant??
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(WORD(:4)=='INHY' .OR. QLOG(WORD(:12))) GOTO 19
      IF(WORD(:1)==' '.OR.WORD(:1)=='.'.OR.WORD(:1)=='$'.OR.
     +   WORD(:1)=='#'.OR.WORD(:4)=='LUMP'.OR.WORD(:3)=='FAC'.
     +   OR.WORD(:1)==')'.OR.WORD(:1)=='(') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! Skip directory names
C       Filter out lines other than filenames
      CALL LAST(L,WORD,14)
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
      J = ICHAR(WORD(11:11)); IF(J<48 .OR. J>57) GOTO 10 ! Will exclude HYBUF files
      IF(WORD(:3)=='SEE') GOTO 10
      E = WORD(10:10)
      IF(.NOT.(E=='M'.OR.E=='K'.OR.E=='B'.OR.  ! E=='C'.OR.
     +    E=='H'.OR.E='Q'.OR.E=='#')) GOTO 10  ! Ext .Cnn is 2nd order covs
19    L = 0   ! ^Previously accepted 'F', but I can't recover why.
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4).AND.NAME(I)(L+5:L+5)==' ') GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL==0) RETURN
      DO I = 1,NL
        IF(QLOG(NAME(I))) FLAG(I) = '+'
      END DO
      WRITE(6,'(20(:/4(I5,".",2A,:)))') (I,FLAG(I),NAME(I),I=1,NL)
      WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      CALL LAST(L1,NAM1,LEN(NAM1)); CALL LAST(L2,NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      CALL LAST(L1,WRD1,LEN(WRD1)); CALL LAST(L2,WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A mumber terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION

      FUNCTION LOSS(A1)   ! HYBALL version
C Arguments needed are A1;NV,MV,NF;BH,JA,JB,CV1,ADD,R0,R1
C This version is expanded to include Comp2 weighting.
      LOGICAL QY, QZ
      REAL LOSS, A1(MV,0:2*MF), SS(NV)
      COMMON  NV, NF, MV, MF
      COMMON /BL3/ BH, JA, JB, CV1, ADD, R0, R1, WSAL
      LOSS = 0.; T = 0.; SS = 0.
      QY = .FALSE.; QZ = QY
      IF(WSAL<0.) GOTO 60
      IF(WSAL>=.01) QY = .TRUE.
      IF(.NOT.QY) GOTO 20
C Compute matrix of salience weights rescaled to average 1.
      IF(ABS(WSAL-1.)<.01) QZ = .TRUE.   ! QZ=T omits powering by WSAL=1
      DO I = 1,NV
        S = 0.
        DO J = 1,NF
          IF(QZ) A1(I,MF+J) = ABS(A1(I,J))
          IF(.NOT.QZ) A1(I,MF+J) = ABS(A1(I,J))**WSAL
          S = S + A1(I,MF+J)
        END DO
        A1(I,0) = S   !  raw weights for item i over all factors
        T = T+S
      END DO
      T = (NF-1)*T/(NF*NV)   ! NF-1 times overall mean raw weight for norming
      DO I = 1,NV
        DO J = 1,NF ! Get mean normed weight for I over factors excluding J
          A1(I,MF+J) = (A1(I,0)-A1(I,MF+J))/T  ! I's weight when rotating Fac J
        END DO
      END DO
20    DO J = 1,NF
        DO I = 1,NV
          X = FIT(A1(I,J))
          IF(QY) X = X*A1(I,MF+J)
          LOSS = LOSS + X
        END DO
      END DO
      RETURN
60    WSL = WSAL; IF(WSAL<0) WSL = AMOD(WSAL+.001,1.)-.001  ! Erase K-norming flag if present
      DO I = 1,NV                    ! Start Comp2 weighting
        DO J = 1,NF
          SS(I) = SS(I) + A1(I,J)**2
        END DO
      END DO
      DO I = 1,NV
        DO J = 2,NF
          DO K = 1,J-1
            FJ = FIT(A1(I,J))
            FK = FIT(A1(I,K))
            WI = 1. + WSL*COMP2(A1(I,J),A1(I,K),SS(I))
            LOSS = LOSS + (FJ+FK)*WI
          END DO
        END DO
      END DO
      END FUNCTION

      FUNCTION FIT(A)
C Get the unweighted misfit of coefficient A under current loss parameters
      COMMON /BL3/ BH, JA, JB, CV1, ADD, R0, R1, WSAL
      D = A/BH; E = D*D
      IF(E>=1.) GOTO 30
      IF(JA==0) X = E
      IF(JA>0) X = (CV1 - R0*(E**JA))*E
      IF(JA==-1) X = 2*ABS(D)
      IF(JA<-1) X = (E**R0)/R0
      GOTO 50
30    X = 1./E
      IF(JB<=2) GOTO 45
      DO K = 3,JB
        X = X/E
      END DO
45    X = ADD - R1*X
50    FIT = X
      RETURN
      END FUNCTION
C
      SUBROUTINE MINV(N,A,LDA,IER)
C This computes the inverse of N-by-N matrix A, with determinant available if
C wanted. LDA is the leading dimension of A declared in the calling program.
      INTEGER R(N), C(N)
      REAL A(LDA,*)
      IF(N>LDA) WRITE(6,'(/" Parameter MV in subroutine MINV ",
     +  "must be increased to ",I3)') N
      IF(N>LDA) STOP
      D = 1.
      IER = 0
      BBIG: DO K=1,N
C Search for largest element
        R(K) = K
        C(K) = K
        BIG = A(K,K)
        DO J=K,N
          DO I=K,N
            IF(ABS(BIG)>=ABS(A(I,J))) CYCLE
            BIG = A(I,J)
            R(K) = I
            C(K) = J
          END DO
        END DO
C Interchange rows
        I = R(K)
        IF(I<=K) GOTO 60
        DO J=1,N
          HOLD = A(K,J)
          A(K,J) = A(I,J)
          A(I,J) = HOLD
        END DO
C Interchange columns
60      J = C(K)
        IF(J<=K) GOTO 90
        DO I=1,N
          HOLD = A(I,K)
          A(I,K) = A(I,J)
          A(I,J) = HOLD
        END DO
C Divide column by minus pivot (saved in BIG)
90      IF(ABS(BIG)<1.0E-30) IER = 1
        IF(IER==1) RETURN
        DO I=1,N
          IF(I/=K) A(I,K) = -A(I,K)/BIG
        END DO
C Reduce matrix
        DO I=1,N
          HOLD = A(I,K)
          DO J=1,N
            IF(I==K .OR. J==K) CYCLE
            A(I,J) = A(I,J) + HOLD*A(K,J)
          END DO
        END DO
C Divide row by pivot
        DO J=1,N
          IF(J/=K) A(K,J) = A(K,J)/BIG
        END DO
C Accumulate product of pivots.  At output, D is the matrix's determinant.
        D = D*BIG
C Replace pivot by its reciprocal
        A(K,K) = 1./BIG
      END DO BBIG
C Final row/column interchange to undo permutations
      K = N
200   K = K-1
      IF(K==0) RETURN
      J = R(K)
      IF(J<=K) GOTO 240
      DO I=1,N
        HOLD = A(I,K)
        A(I,K) = A(I,J)
        A(I,J) = HOLD
      END DO
240   I = C(K)
      IF(I<=K) GOTO 200
      DO J=1,N
        HOLD = A(K,J)
        A(K,J) = A(I,J)
        A(I,J) = HOLD
      END DO
      GOTO 200
      END SUBROUTINE
C
      FUNCTION MISFIT(K,L,A1,W)  ! ******** Differs from HYBALL without Comp2
C This computes for brute-force scanning the hyperplane-misfit measure whose
C 1st derivative is used for polish weights in subroutine HYPGET. WSAL is the
C salience-weighting parameter.
      REAL A1(MV,0:*), MISFIT
      COMMON  NV, NF, MV, MF
      COMMON /BL1/ B1TAN, DBRAD
      COMMON /BL2/ LIM, CV, PD1, MODE, GAM
      COMMON /BL3/ BH, JA, JB, CV1, ADD, R0, R1, WSAL
      MISFIT = 0.
      IF(JA==2 .AND. JB==2) GOTO 80
      DO I =1,NV
        IF(A1(I,0)>NF*1.) CYCLE
        D = (A1(I,L) - A1(I,K)*W)/BH
        E = D*D
        IF(E>=1.) GOTO 30
        IF(JA==0) X = E
        IF(JA>0) X = (CV1 - R0*(E**JA))*E
        IF(JA==-1) X = 2*ABS(D)
        IF(JA<-1) X = (E**R0)/R0
        GOTO 50
30      X = 1./E
        IF(JB<=2) GOTO 45
        DO J = 3,JB
          X = X/E
        END DO
45       X = ADD - R1*X
50      IF(ABS(WSAL)>.01) X = X*A1(I,0)   ! <<<< Weight passed from HYFIND
        MISFIT = MISFIT + X
      END DO
      RETURN
80    DO I = 1,NV
        IF(A1(I,0)>NF+1.) CYCLE
        E = (A1(I,L) - A1(I,K)*W)/BH
        E = E*E
        IF(E<=1.) X = (CV1 - R0*E*E)*E
        IF(E>1.) X = ADD - 1./E
        IF(WSAL>.01) X = X*A1(I,0)
        MISFIT = MISFIT + X
      END DO
      END FUNCTION
C
      SUBROUTINE OMSET(M,N,A1,R,NV,MF,JL,JOB)
C This sets OMIT entries for factor pair <M,N>; MN = M*100 + N;
C Omissions are passed in A1(-,0) as full 0,999 flaglist for rotation control
C when JOB=0 or as JL omit indices when JOB>0.  JOB1 calls display/revision
C of omissions in screen plot display; JOB>1 flags less vertical screen space.
C JOB<0 retrieves omission list for PLOT output
      PARAMETER (LX=100, MOM=1000)
      CHARACTER CLN*8, CF*12
      INTEGER OMIT(MOM), LST(NOM+LX)
      REAL A1(*)     ! Column 0 of A1
      EXTERNAL SCAN
      COMMON /CF/ CF
      COMMON /OM/ NOM, OMIT
C Each OMIT entry is I*100*100 + M*100 + N where I is an item index,
C and <M,N> is the factor pair (M<N).  Entries are NOT in plane order.
C Scan OMIT for factor pair <M,N>'s current omission stipulations
      IF(MF>99 .AND. JOB>=0) THEN
        WRITE(6,'(10X,"HYBALL makes no provision for item exclusions ",
     +  "when"/10X,"the number of factors exceeds 99.  Be thankful.")')
        RETURN
      END IF
      JL = 0; MN = MIN(M,N)*100 + MAX(M,N)   ! Neither M or N can exceed 99
      DO K = 1,NOM    ! NOM is number of entries in OMIT
        IF(MOD(OMIT(K),10000)==MN) THEN
          JL = JL + 1
          LST(JL) = OMIT(K)/10000
          A1(JL) = 1.*LST(JL)
        END IF
      END DO   ! Col 0 of A1 ports OMIT list for plane-pair MN to PLOT
      IF(JOB>0) GOTO 101
      DO I = 1,NV    ! Load A1 (= A1(0,-)) for rotation control
        A1(I) = 0.
      END DO
      IF(JL==0 .OR. JOB<0) RETURN
      DO J = 1,JL
        A1(LST(J)) = 999.
      END DO  !       ^   Function MISFIT needs this larger than NF
      RETURN  !  Always end of JOB=0
cc101      CALL SORT(JL,LST)  ! Not needed if stored in increasing order
101   IF(JL==0) WRITE(6,'(" Corr.=",A5,6X,"Variables now ignored ",
     +  "in this plane: None")') CLN(R,5,2)
      IF(JL>0) WRITE(6,'(" Corr.=",A5,6X,"Variables now ignored ",
     +  "in this plane:",5(1X,A,:),5(/20(1X,A),:))') CLN(R,5,2),
     +  (CF(:JF(LST(J))),J=1,JL)
      IF(JOB<=1) WRITE(6,'()')
      WRITE(6,'(" Hit RETURN if OK.  Otherwise, enter the list of var",
     +  "iables to be ignored.")')
      IF(JL>0 .AND. JOB<=2) WRITE(6,'(" To delete all these omis",
     +  "sions, enter any letter."/)')
      IF(JL==0 .OR. JOB>2) WRITE(6,'()')
      CALL SCAN(JJ,0,'I',5)
      IF(JJ==0) RETURN
      IF(JJ<=-1) GOTO 110   ! Delete old items
      JJ = MIN(LX,JJ)
      READ(2,*) (LST(I),I=1,JJ)
      CALL SORT(JJ,LST)
      JL = 1; L=0
20    L = L+1
      IF(LST(L)<=0) GOTO 20     ! Surely never needed in practice
      LST(1) = LST(L)
      IF(LST(1)>NV) GOTO 101
      DO I = L+1,JJ
        IF(LST(I)<=LST(JL) .OR.LST(I)>NV) CYCLE
        JL = JL+1
        LST(JL) = LST(I)
      END DO
110   K = 0  ! First delete old list for this plane
      DO WHILE (K<=NOM)
        K = K+1
112     IF(MOD(OMIT(K),10000)==MN) THEN
          DO I = K+1,NOM
            OMIT(I-1) = OMIT(I)
          END DO
          NOM = NOM-1
          IF(K<NOM) GOTO 112
        END IF
      END DO
      IF(JJ<0) JL = 0
      IF(JJ<0) GOTO 101
      DO I = 1,JL   ! Finally, append new list for this plane
        NOM = NOM+1
        OMIT(NOM) = LST(I)*100*100 + MN
      END DO
      CALL SORT(NOM,OMIT)
      GOTO 101
      END SUBROUTINE
C
      FUNCTION OBQ(C1,JOB)
C Return the largest discrepancy of covar matrix C1 from orthonormality if
C JOB = 0, or largest proper covariance in C1 if JOB > 0.
      REAL C1(MF,*)
      COMMON  NV, NF, MV, MF
      OBQ = 0.
      DO J = 2,NF; DO I = 1,J-1
          OBQ = MAX(OBQ,ABS(C1(I,J)))
      END DO; END DO
      IF(JOB>0) RETURN
      DO J = 1,NF
        OBQ = MAX(OBQ,ABS(C1(J,J)-1.))
      END DO
      END FUNCTION
C
      SUBROUTINE PERM(PUT,FIX,JUMP,N,A1,C1,W,QB)
C This permutes/reflects factors as instructed.  If N>0, permutation includes
C hyperplane count for pattern N in RECORD. N<0 says to permute pattern only
C JUMP>0 permutes into Put sequence received in PUT. If QB, pemute only
C within blocks
      PARAMETER (MREC=200, MSEE=100, MOM=1000)
      LOGICAL QB
      CHARACTER(12) CF, FMT*28
      INTEGER OMIT(MOM), RECORD(MREC,0:MSEE)
      INTEGER PUT(*), FIX(*), GET(MF), TMP(MF)
      REAL A1(MV,0:*), C1(MF,*), W(MV,*)
      EXTERNAL SCAN
      COMMON  NV, NF, MV, MF
      COMMON /REC/ LSEE, RECORD
      COMMON /CF/ CF
      COMMON /OM/ NOM, OMIT
      LO(I,J) = J*(J-1)/2 + I
      IF(JUMP>0) GOTO 50
10    DO I = 1,NF
        GET(I) = I
      END DO
20    DO I = 1,NF
        PUT(ABS(GET(I))) = SIGN(I,GET(I))
      END DO
30    WRITE(6,'(" Axes of pattern ",A," are to be re-ordered ",
     +  "in sequence"/)') CF(:JF(N))
      FMT = '(" Get:",25I3)             '
      IF(NF>25) FMT = '(" Get:",25I3,4(:/5X,25I3))'
      WRITE(6,FMT) (GET(I),I=1,NF)
      WRITE(6,'(/" with negative indices calling for reflection.  E",
     +  "ach position J in this Get"/" list shows the current index",
     +  " of the factor that will be moved to position J"/" by this",
     +  " permutation, while each position K in the following Put ",
     +  "list shows"/" the position to which the factor currently ",
     +  "indexed K will be moved."/)')
      FMT(4:6) = 'Put'
      WRITE(6,FMT) (PUT(I),I=1,NF)
      WRITE(6,'(/" Hit RETURN if OK, or enter corrected sequence of po",
     +  "sitive/negative integers"/" from 1 to ",A," in Get order."/)')
     +  CF(:JF(NF))
      CALL SCAN(J,0,'I',5)
      IF(J==0) GOTO 50
      IF(J<0) GOTO 10
      IF(J/=NF) WRITE(6,'(/" ERROR.  You have entered ",A," indic",
     +  "ces. Try for ",A,".")') CF(:JF(J)), CF(:JF(NF))
      IF(J/=NF) GOTO 30
      READ(2,*) (GET(I),I=1,NF)
      IX = 0
40    IF(IX==NF) WRITE(6,'(//)')
      IF(IX==NF) GOTO 20
      IX = IX+1
      DO J = 1,NF
        IF(IX==ABS(GET(J))) GOTO 40
      END DO
      WRITE(6,'(/" ERROR.  Factor ",A," is not in your permutation ",
     + "sequence. Try again.")') CF(:JF(IX))
      GOTO 10
C Insure that permutation/reflection is not trivial
50    K = 1
      DO I = 1,NF
        IF(PUT(I)/=I) K = 0
      END DO
      IF(K==1 .AND. N>=0) WRITE(6,'(" This permutation/reflection ",
     +  "is an identity transform (no change).")')
      IF(K==1) RETURN
      DO J = 1,NF   ! Loop does reflection only
        IF(PUT(J)>0) CYCLE
        PUT(J) = -PUT(J)
        DO I = 1,NV
          A1(I,J) = -A1(I,J)
        END DO
        DO I = 1,NF
          C1(I,J) = -C1(I,J)
          C1(J,I) = -C1(J,I)
        END DO
      END DO
      IF(QB) THEN    ! Permute only within blocks
CCC         DO 61 I = 1,NF
CCC61        GET(PUT(I)) = I  ! Recover GET order
         DO I = 1,NF
           IF(FIX(I)>100) FIX(I) = 99  ! Clear any pattern fixations
           GET(I) = I + PUT(I)*10**3 + FIX(I)*10**6
           IF(FIX(I)==-1) GET(I) = I + PUT(I)*10**3 + 100*10**6 ! Z-factors go last
         END DO
         CALL SORT(NF,GET)
         DO I = 1,NF
           GET(I) = MOD(GET(I),1000)
         END DO
         DO I = 1,NF
           PUT(GET(I)) = I
         END DO
      END IF
      DO I = 1,NV
        DO J = 1,NF
          W(I,PUT(J)) = A1(I,J)  ! Permute in Put fashion
        END DO
        DO J = 1,NF
          A1(I,J) = W(I,J)
        END DO
      END DO
      IF(N<0) RETURN
      IF(N>0) THEN
        DO J = 1,NF
          W(1,PUT(J)) = RECORD(N,J)
        END DO
        DO J = 1,NF
          RECORD(N,J) = NINT(W(1,J))
        END DO
      END IF
      DO I = 1,NF
        DO J = 1,NF
          W(PUT(I),PUT(J)) = C1(I,J)
        END DO
      END DO
      DO I = 1,NF
        DO J = 1,NF
          C1(I,J) = W(I,J)
        END DO
      END DO
C   Permute OMIT
      IF(N>1) THEN   ! OMIT not an omissions list in Rec 1.
        DO I = 1,NOM
          L = OMIT(I)
          M = PUT(MOD(L,10000)/100)
          N = PUT(MOD(L,100))
          OMIT(I) = (L/10000)*10000 + M*10000 + N*100
        END DO
      END IF
      DO I = 1,NF
        TMP(I) = FIX(I)
      END DO
      DO I = 1,NF
        FIX(PUT(I)) = TMP(I)
      END DO
      IF(MOD(JFLAG/10000,10)==0) JFLAG = JFLAG+10000
C       JFLAG's 5th digit (permutation) is cancelled when pattern is BUFFed.
      END SUBROUTINE
C
      SUBROUTINE PIKKB(KB,W,WORD,LL,JB)
C Write info on KB dichotomous factors to screen. JJ returns choice
C of display while WORD(:LL) is info to be used when JB=1
      CHARACTER WORD*(*), CF*12, CH7*7
      REAL W(*)
      COMMON /CF/ CF
      CH7 = ' To see'; IF(JB>0) CH7 = 'To show'
      READ(33) KB, (W(J),J=1,KB); REWIND 33
      IF(KB==1) THEN
        LL = JF(INT(W(1))); WORD(:LL+1) = ' '//CF(:LL)
        WRITE(6,'(" >>> Note. Factor ",A," is dichotomous. ",A," the",
     +    " pattern"/11X,"with binary scaling of this, enter any let",
     +    "ter. (Ignore how that"/11X,"inflates the loading of its s",
     +    "till-standardized data marker.)")') CF(:LL), CH7; RETURN
      END IF
      LL = 1
      DO J = 1,KB
        K = JF(INT(W(J)))  ! Fieldwidth of binary index returned in CF
        WORD(LL:LL+K+1) = ' '//CF(:K); LL = LL+K+1
        IF(LL>36 .AND. KB-J>3) THEN
          WORD(LL:LL+9) = ' and more'; LL = LL+9; GOTO 10
        END IF
      END DO  ! LL counts only length of item identification
10    WORD(LL:LL+37) = ' are dichotomous. '//CH7//' the pattern'
      IF(LL<=24) THEN
        WRITE(6,'(" >>> Note. Factors",A/11X,"with binary scaling of ",
     +    "these, enter any letter. (Ignore how that"/11X,"inflates ",
     +    "the loadings of their still-standardized data markers.)")')
     +     WORD(:LL+37)
      ELSE IF(LL<=36) THEN
        WRITE(6,'(" >>> Note. Factors",A/11X,"the pattern with binary",
     +    " scaling of these, enter any letter.")') WORD(:LL+26)
      ELSE
        WRITE(6,'(" >>> Note. Factors",A/10X,A," the pattern with bin",
     +    "ary scaling of these, enter any letter.")') WORD(:LL+17), CH7
      END IF
      IF(LL>25) WRITE(6,'(11X,"(Ignore how this inflates their we",
     +  "ights for their still-"/11X,"standardized data markers.)")')
      END SUBROUTINE

      SUBROUTINE PLOT(M,N,KFILE,A1,R,KTL,NN,KUT,KOM,KPP)
C This prints pattern plots for factor pair <M,N> either to screen if KFILE=6
C or to HYBALL's SEE-file if KFILE=7.  NN is the pattern's hybuf index.
C NEW: Revert KFILE=7 write to small display;
      PARAMETER (MOM=1000)
      LOGICAL TR0, TR1, TR2, TR3, CL
      CHARACTER(3) CHR3, CLEAR,PRIOR,BAR,LIN, FRAME(41,41), CLN*8,
     +             CF*12, COD, TR*1, WORD*7
      INTEGER GRID(MV,MF), KTL(MF,*), OMIT(MOM)
      REAL A1(MV,0:*)
      COMMON  NV, NF, MV, MF
      COMMON /BL2/ LIM, CV, PD1, MODE, GAM
      COMMON /BL3/ BH, JA, JB, CV1, ADD, R0, R1, WSAL
      COMMON /OM/ NOM, OMIT
      COMMON /TTR/ KR, KND, NLD
      COMMON /CF/ CF
C      CL(N) = N==ICHAR(' ').OR.N==ICHAR('+').OR.N>ICHAR('z')
      CL(N) = N<48.OR.N>122  ! *** Defining Statement Function, not array
      KR = KND + (NLD-KND)*MIN(ABS(KFILE-6),1) ! equals KND/NLD if KFILE is/isn't 6
      KP = KPP  ! KP = 6  ! KP = KPP if 132-column print is reinstated
      CLEAR = '   '       !   KPP currently sets just 80-column lines
      BAR = ' '//TR('')//' '
      LIN = TR('')//TR('')//TR('')
      IBH = NINT(100*BH)
C  Prepare FRAME for holding factor-plane displays (previously a separate subroutine)
      DO J = 1,41
        DO I = 1,41
          FRAME(I,J) = '   '
        END DO
      END DO
      DO I = 1,NV
        SCALE = 1.
        DO J = 1,NF
          SCALE = MAX(SCALE,ABS(A1(I,J)))
        END DO
        DO J = 1,NF
          GRID(I,J) = INT(KUT+1.5 + KUT*A1(I,J)/SCALE)
        END DO
      END DO    ! End of previous subroutine
      J = 0
      IF(KFILE==7 .AND. KP>100) J = 1
      L1 = 21 + 20*J
      L0 = L1/2 + 1
      L2 = 2 + 3*J
C       L1/L0/L2 are 41/21/5 if KFILE is for printed results with KP set for
C       long lines, and are 21/11/2 otherwise
      DO K = 1,L1
        FRAME(K,L0) = BAR
        FRAME(L0,K) = LIN
        IF(KFILE==6) CYCLE
        FRAME(K,1) = BAR
        FRAME(K,L1) = BAR
        FRAME(1,K) = LIN
        FRAME(L1,K) = LIN
      END DO
      DO K = 1+L2,L1-L2,L2
        FRAME(K,L0) = TR('')//TR('')//TR('')
        FRAME(L0,K) =  TR('')//TR('')//TR('')
        KK = K
        IF(KFILE==6) KK = L0
        FRAME(KK,1) = TR(' ')//TR('')//TR('')
        FRAME(KK,L1) = TR('')//TR('')//TR(' ')
        FRAME(1,KK) = TR('')//TR('')//TR('')
        FRAME(L1,KK) = TR('')//TR('')//TR('')
      END DO
      IF(KFILE==6) GOTO 20
      FRAME(1,1) = TR(' ')//TR('')//TR('')
      FRAME(L1,1) = TR(' ')//TR('')//TR('')
      FRAME(1,L1) = TR('')//TR('')//TR(' ')
      FRAME(L1,L1) = TR('')//TR('')//TR(' ')
      NDUP = 0
20    DO I = NV,1,-1
        IROW = GRID(I,N)
        JCOL = GRID(I,M)
        PRIOR = FRAME(IROW,JCOL)
        CHR3 = COD(I,0)
        TR0 = .FALSE.
        K = ICHAR(PRIOR(2:2))
        IF(K>=48 .AND. K<=122) TR0 = .TRUE.
C         IF(PRIOR/=LIN .AND. PRIOR(2:2)/='+' .AND. PRIOR/=BAR) TR0 = .TRUE.
C         IF(PRIOR/=CLEAR.AND.TR0) CHR3(1:1) = '@'
        IF(TR0) CHR3(1:1) = '@'; IF(TR0) NDUP = NDUP+1
        FRAME(IROW,JCOL) = CHR3
      END DO
C      KM = KTL(M,N)   ! = 0 if factor M is fixed in this plane; otherwise 1
C      KN = KTL(N,M)
      KMN = 10*KTL(M,N) + KTL(N,M)
      IF(KMN==11) WORD = 'Neither'
      IF(KMN==10) WORD = CF(:JF(N))//'      '
      IF(KMN== 1) WORD = CF(:JF(M))//'      '
      IF(KMN== 0) WORD = 'Both   '
      IF(KFILE==7) GOTO 100
C Print assembled display to screen, skipping top/bottom lines if clear.
      TR0 = .TRUE.
      TR1 = .TRUE.
      TR2 = .TRUE.
      TR3 = .TRUE.
      DO J = 1,21
        TR0 = TR0 .AND. CL(ICHAR(FRAME(21,J)(2:2)))
        TR1 = TR1 .AND. CL(ICHAR(FRAME(1,J)(2:2)))
        TR2 = TR2 .AND. CL(ICHAR(FRAME(2,J)(2:2)))
        TR3 = TR3 .AND. CL(ICHAR(FRAME(3,J)(2:2)))
      END DO  ! TRi=T says line is clear
      IB = 1
      IF(TR1) IB = 2
      IF(TR1 .AND. TR2) IB = 3
      IF(IB==3 .AND. TR3 .AND. .NOT.TR0) IB = 4
      IF(TR1 .AND. TR2 .AND. TR3) FRAME(3,11) = CLEAR
      DO I = 21,IB,-1
        WRITE(6,'(8X,21A3)') (FRAME(I,J), J=1,21)
      END DO
      IF(KMN==11) WRITE(6,'(" Horiz. factor ",A," and vertical fac",
     +  "tor ",A," are both free to move in this plane")')
     +  CF(:JF(M)), CF(:JF(N))
      IF(KMN==10) WRITE(6,'(" Horiz. factor ",A," is free in this pl",
     +  "ane; vertical factor ",A," is fixed.")') CF(:JF(M)),CF(:JF(N))
      IF(KMN==1) WRITE(6,'(" Horiz. factor ",A," is fixed in this p",
     +  "lane; vertical factor ",A," is free.")') CF(:JF(M)),CF(:JF(N))
      IF(KMN==0) WRITE(6,'(" Horiz. factor ",A," and vertical factor",
     +  1X,A," are both fixed in this plane.")') CF(:JF(M)), CF(:JF(N))
      K = 3
      IF(TR0 .OR. TR1) K = 2
      IF(TR0.AND.TR1 .OR. TR1.AND.TR2) K = 1
      IF(KOM==1) CALL OMSET(M,N,A1,R,NV,MF,JL,K)  ! List omissions on screen
      GOTO 300
C Print assembled display to SEE-file with 132-character lines
100   IF(KP<100) GOTO 200
      WRITE(7,'(""////18X,"Rotated pattern in factor plane <",A,", ",
     +  A,">. Factor ",A," is horizontal; factor ",A," is vertical.")')
     +  CF(:JF(M)), CF(:JF(N)), CF(:JF(M)), CF(:JF(N))
      IF(SCALE>1.05) WRITE(7,'(/17X,"Variables whose pattern points ",
     +  "lie outside the -unit square have been rescaled to fit.")')
      IF(NV<100) WRITE(7,'()')
      IF(NV>=100) WRITE(7,'(8X,"Leading digits of item indices ",
     + "larger than 99 are coded by corresponding letters; a-- for",
     + " 1--, b-- for 2--, etc.")')
      IF(NDUP>0) WRITE(7,'(18X,"@ prefaces coincident item indices ",
     +  "of which only the lowest is shown (",A," hidden)."////)')
     +  CF(:JF(NDUP))
      DO I = 1,40
        WRITE(7,'(5X,41A3)') (FRAME(42-I,J), J = 1,41)
        WRITE(7,'(5X,A3,57X,A3,57X,A3)') BAR, BAR, BAR
      END DO
      WRITE(7,'(5X,41A3)') (FRAME(1,J), J = 1,41)
      IF(NN==1) THEN
        WRITE(7,'(/"  ***** Retraction:  This is an unrotated plane ",
     +    "of the input pattern.")'); GOTO 300
      END IF
      IF(MODE/2==1) WRITE(7,'(///5X,"Axis correlation = ",A4,4X,
     +  "Hyperplane widths +/- .",I2," were fitted by Brute-force",
     +  " Scanning")') CLN(R,4,2), IBH
      IF(MODE/2==0.AND.LIM==0) WRITE(7,'(///5X,"Axis correlati",
     +  "on = ",A4,4X,"Hyperplanes were fitted by unpolished Step",
     +  "-down Regression")') CLN(R,4,2)
      IF(MODE/2==0.AND.LIM>0) WRITE(7,'(///5X,"Axis correlatio",
     +  "n = ",A4,4X,"Hyperplane widths +/- .",I2," were fitted",
     +  " by polished Step-down regression")') CLN(R,4,2), IBH
      IF(MODE==4) WRITE(7,'(///5X,"Axis correlation = ",A4,4X,
     +  "Hyperplanes were fitted by OBLIMIN (gamma =",A4)')
     +  CLN(R,4,2), CLN(-GAM,4,2)
      IF(MODE<4) WRITE(7,'(/32X,"Misfit params: CV =",A4,
     +  ", JA =",I2,", JB =",I2,", WSAL = ",A4)') CLN(CV,4,1),
     +  JA, JB, CLN(WSAL,4,2)
      WRITE(7,'(32X,"Factors fixed in this plane: ",A)') WORD
      CALL OMSET(M,N,A1,R,NV,MF,JL,-1)   ! Print omissions list
      IF(JL==0) WRITE(7,'(/32X,"Variables ignored by hyperplane ",
     +  "search in this plane: None")')
      IF(JL>0) WRITE(7,'(32X,"Variables now ignored in this plane:",
     +  20(1X,A))') (CF(:JF(NINT(A1(J,0)))),J=1,JL)
      GOTO 300
C Print assembled display to SEE-file with 80-character lines
200   WRITE(7,'(""/40("* ")//2X,"Rotated pattern in plane <",A,", ",A,
     +  ">. Factor ",A," is horizontal; factor ",A," is vertical.")')
     +  CF(:JF(M)), CF(:JF(N)), CF(:JF(M)), CF(:JF(N))
      IF(SCALE>1.05) WRITE(7,'(/3X,"Pattern points lying outside the ",
     +  "-unit square have been rescaled to fit.")')
      IF(NV>=100) WRITE(7,'(" Leading digits of item indices ",
     +  "larger than 99 are coded by corresponding letters;"/6X,
     +  "a-- for 1--, b-- for 2--, etc.")')
      IF(NDUP>0) WRITE(7,'(" @ prefaces coincident item indices of ",
     +  "which only the lowest is shown (",A," hidden)."////)')
     +  CF(:JF(NDUP))
      DO I = 1,20
        WRITE(7,'(7X,21A3)') (FRAME(22-I,J), J = 1,21)
        WRITE(7,'(7X,A3,27X,A3,27X,A3)') BAR, BAR, BAR
      END DO
      WRITE(7,'(7X,21A3)') (FRAME(1,J), J = 1,21)
      IF(NN==1) THEN
        WRITE(7,'(/"  ***** Retraction:  This is an unrotated plane ",
     +    "of the input pattern.")'); GOTO 300
      END IF
      IF(MODE/2==1) WRITE(7,'(6X,"Axis correlation = ",A4//1X,
     +  "Hyperplane widths +/- .",I2," were fitted by Brute-force",
     +  " Scanning")') CLN(R,4,2), IBH
      IF(MODE/2==0.AND.LIM==0) WRITE(7,'(6X,"Axis correlation =",
     +  "on = ",A4//" Hyperplanes were fitted by unpolished Step",
     +  "-down Regression")') CLN(R,4,2)
      IF(MODE/2==0.AND.LIM>0) WRITE(7,'(6X,"Axis correlation =",
     +  A4//" Hyperplane widths +/- .",I2," were fitted by polish",
     +  "ed Step-down regression")') CLN(R,4,2), IBH
      IF(MODE==4) WRITE(7,'(6X,"Axis correlation = ",A4//" Hyper",
     +  "planes were fitted by OBLIMIN (gamma =",A4)') CLN(R,4,2),
     +  CLN(-GAM,4,2)
      IF(MODE<4) WRITE(7,'(" Misfit params: CV =",A4,", JA =",
     +  I2,", JB =",I2,", WSAL = ",A4)') CLN(CV,4,1), JA, JB,
     +  CLN(WSAL,4,2)
      WRITE(7,'(" Factors fixed in this plane: ",A)') WORD
      CALL OMSET(M,N,A1,R,NV,MF,JL,-1)   ! Print omissions list
      IF(JL==0) WRITE(7,'(" Variables ignored by hyperplane search",
     +  " in this plane: None")')
      IF(JL>0) WRITE(7,'(2X,"Variables now ignored in this plane:",
     +  20(1X,A))') (CF(:JF(NINT(A1(J,0)))),J=1,JL)
300   DO I = 1,NV
        FRAME(GRID(I,N),GRID(I,M)) = CLEAR
      END DO
      RETURN
      END
C
      SUBROUTINE PRNT(JOB,KP,KFILE)
C Set printer codes. JOB=0/1/2 if job is find-linewidth/set-normal-print/set-
C HYBALL-pattern-plots.  KP is linewidth. KFILE is file to write.
      CHARACTER QFMT, WORD*55, CF*12, CH
      COMMON /CF/ CF
      IF(QFMT('PRNTR')=='U') THEN
        IF(JOB==0) THEN
          WRITE(KFILE,'(/" WARNING: There is no printer ",
     +      "definition in this subdirectory.")')
10        WRITE(6,'(10X,"To limit print lines to ",A," character len",
     +      "gth, hit RETURN"/10X,"Otherwise, enter anything to choo",
     +      "se the ",A," character limit.")') CF(:JF(KP)),
     +      CF(:JF(212-KP)); READ(5,'(A)') CH
            IF(CH/=' ') THEN; KP = 212-KP; GOTO 10; END IF
        END IF
        IF(JOB==1) WRITE(KFILE,'(" %")')
        IF(JOB==2) WRITE(KFILE,'(" #")')
        RETURN
      END IF
      OPEN(1,FILE='PRNTR')
      READ(1,'(A)',END=20,ERR=20) WORD
      IF(WORD(1:1)=='*') KP = 80
      IF(WORD(2:2)=='&') KP = KP+1
      IF(JOB==0) GOTO 15
      IF(WORD(:1)/='%') READ(1,'(A)',END=20,ERR=20) WORD
      IF(JOB==1) WRITE(KFILE,'(A)') WORD(3:)
      IF(JOB==1) GOTO 15
      READ(1,'(A)',END=20,ERR=20) WORD
      WRITE(KFILE,'(A)') WORD(3:)
15    CLOSE(1)
      RETURN
20    WRITE(6,'(/" Your PRNTR file is corrupt. Delete or replace ",
     + " this and try again.")')
      STOP
      END
C
      FUNCTION QLOG(WORD)
C  Return .TRUE. if WORD is a HYBUF file, otherwise .FALSE.
      LOGICAL QLOG
      CHARACTER WORD*(*)
      QLOG = .FALSE.
      IF(WORD(:5)=='HYBUF' .OR. WORD(9:10)==' #') QLOG = .TRUE.
      N = LH(WORD,LN)    ! Locate extension dot in WORD, if any
      IF(QLOG .OR. N>=LN-1) RETURN
      IF(WORD(N+2:N+2)=='#') QLOG = .TRUE.  ! Or if LH is not installed:
C      IF(WORD(N-2:N-2)=='#'.OR.WORD(N-1:N-1)=='#') QLOG = .TRUE.
      RETURN
      END
C
      FUNCTION RAN3()
C This is a reduction of RANGEN to its variant KTYP=2, producing a random
C number from the current generator state. ISEED is imitialized by system clock.
      REAL WK(128)
      REAL(8) DSEED, D2A, D2M
      SAVE D2A, D2M, INIT, DSEED, WK
      DATA  D2M/2147483647.0D0/, INIT/1/
C On first call, initialize generator state DSEED and shuffle-register WK
      IF(INIT/=1) GOTO 50
      INIT = 0
      CALL SYSTEM_CLOCK(ISEED)
CCC      CALL TMSEED(ISEED)
      DSEED = DBLE(MAX(1,MIN(2147483646,ISEED)))
C           Determine scaling factor for unit interval U(0,1)
      D2A = 2147483647.0D0
      TEMP = 2147483646.0D0/D2A
      IF (TEMP<1.0) GOTO 15
      D2A = 2147483655.0D0
      TEMP = 2147483646.0D0/D2A
      IF (TEMP<1.0) GOTO 15
      D2A = 2147483711.0D0
10    CONTINUE
      TEMP = 2147483646.0D0/D2A
      IF (TEMP>=1.0) THEN
         D2A = D2A + 8.0D0
         GO TO 10
      END IF
15    DO I = 1,128
         DSEED = DMOD(16807.0D0*DSEED,D2M)
         WK(I) = DSEED/D2A
      END DO
C Generate random number RAN3 and update DSEED, using RANGEN method 2
C               Use the multiplier 16807 with shuffling
50    DSEED = DMOD(16807.0D0*DSEED,D2M)
      J = DMOD(DSEED,128.0D0) + 1.0D0
      X = DSEED/D2A
      RAN3 = WK(J)
      WK(J) = X
      RETURN
      END
C
      SUBROUTINE REFIX(J,NF,NB,FIX,FIX1,KTL1) !
C If J is positive, open space for new block after J in FIX's block sequence
C shifting present blocks higher than J up one; also block depends in KTL1.
C (Rem: KTL1(I,J)=1/0 just if facbloc I rotates facbloc J. If I<J, KTL1(I,J)=0.)
C If J is negative, delete block J from the block sequence in FIX.
C If J = 0, clear any +100 pattern-fixation flags (Block Y factors only).
      INTEGER FIX(*),FIX1(*), KTL1(NF,*)
      IF(J==0) THEN
        DO I = 1,NF
          IF(FIX(I)>100) FIX(I) = 99
        END DO
        RETURN
      END IF
      JJ = ABS(J)
      M = SIGN(1,J)  ! Add/subtract 1 if J is positive/negative
      DO I = 1,NF
        IF(FIX(I)>JJ .AND. FIX(I)<99) FIX(I) = FIX(I)+M
      END DO
C Need to change dependencies in KTL1, not directly in power-coded FIX1
      J1 = JJ+1
      IF(J>0) THEN ! Insert empty row/column to KTL1 in position JJ+1
        DO I = NB+1,J1,-1
          I1 = I-1  ! Row to copy from
          DO K = 1,I1
            IF(I==J1 .OR. K==J1) KTL1(I,K) = 0
            IF(K<J1) KTL1(I,K) = KTL1(I1,K)
            IF(K>J1) KTL1(I,K) = KTL1(I1,K-1)
          END DO
        END DO
      ELSE   ! Delete row/col JJ from row/column in KTL1 in position JJ+1
        DO I = JJ,NB-1
          DO K = 1,I-1
            IF(K<JJ) KTL1(K,J) = KTL1(K,I+1)
            IF(K>=JJ) KTL1(K,J) = KTL1(K+1,I+1)
          END DO
        END DO
      END IF
      NB = NB+M
C  Recode block structure into FIX1
      DO I = 1,NB
        FIX1(I) = 0
        DO J = 1,I-1
          IF(KTL1(I,J)==1) FIX1(I) = FIX1(I) + 2**(J-1)
        END DO
      END DO
      END SUBROUTINE
C
      SUBROUTINE REPFIX(NF,NPFIX,PFIX,PFIX1,M)
C Install pattern fixations specified in PFIX1; send message if M > 0.
C Don't forget that PFIX is coded as NF 0/1 markers but PFIX1 as index list
      INTEGER PFIX(*), PFIX1(*)
      NP = 0
      DO I = 1,NF
        IF(PFIX(I)/=0) THEN
          NP = NP+1
          PFIX(I) = 0
        END IF
      END DO
      DO I = 1,NPFIX
        PFIX(PFIX1(I)) = 1   ! This is the installation  (big deal!)
      END DO
      IF(M==0) RETURN   ! No message needed
      IF(NP==0 .AND. (NPFIX==0.OR.M<=1)) RETURN
      IF(NPFIX>0) THEN
        WRITE(6,'(/" WARNING: Recall of this solution has reactiva",
     +    "ted pattern fixation on factors",10(:/10X,20I3))')
     +    (PFIX1(I),I=1,NPFIX)
        IF(M==1) RETURN
        IF(NP>0 .AND. NP/=NPFIX) WRITE(6,'(" This differs from ",
     +   "your previously active pattern fixation.")')
        IF(NP>0 .AND. NP==NPFIX) WRITE(6,'(" This may have alte",
     +   "red your previously active pattern fixation.")')
      ELSE
        WRITE(6,'(/" WARNING. This recall has cancelled your previous",
     +   " pattern fixation.")')
      END IF
      WRITE(6,'(" To reinstate that, call Main Menu Option 9."/)')
      RETURN
      END
C
      SUBROUTINE REGRES(NF,NB,C1,LDC,FIX,FIX1,B1,CE,KP)
C  This receives HYBALL's factor covariances C1, and computes the regression
C  of each dependent factor block upon its antecedent factors. These path-
C  restricted regression weights are then embedded over all dependent blocks
C  in otherwise-zero weight matrix B, so that the residuals of these
C  path-restricted regressions have composition E = F-BF = (I-B)F and the
C  matrix of all factor covariances unaccounted for by the factors' path-
C  antecedents is CE = (I-B)C1(I-B)'.  The block structure is received in
C  <FIX,FIX1>; LDC is the leading dimension of C1; B1,CE are received
C  workspaces.
      CHARACTER CLN*8, CH2*2, BN, TR  ! BN and TR are functions
      CHARACTER*5 CH5(NF,NF),FMT*(8*NF+12),FM2*(8*NF+12),LINE*(8*NF+12)
      INTEGER FIX(*), FIX1(*), KB1(0:NF,0:NF), KB2(NF,0:NF+1)
      REAL C1(LDC,*), CE(NF,*), B1(NF,NF)
      COMMON /TTR/ KR, KND, NLD
C      KR = KND + (NLD-KND)*MIN(ABS(KF-6),1) ! equals KND/NLD if KFILE is/isn't 6
      KW = KP-MOD(KP,2) ! KW is printer limit on line length; delete line-draw flag
      KR = NLD; CH5 = ' '; B1 = 0.
C First set up the block structure: KB1(IB,_) lists factors in block IB;
C KB2(IB,_) lists factors on which block IB is dependent.
      NB1 = NB+1
      KB1(0,0) = 0
      DO IB = 1,NB1
        KB1(IB,0) = 0
        KB2(IB,0) = 0
      END DO
      DO I = 1,NF         ! List X-factors at start each KB1 row
        IB = MIN(FIX(I),NB1)
        IF(IB<0) CYCLE
        KB1(IB,0) = KB1(IB,0) + 1
        KB1(IB,KB1(IB,0)) = I
      END DO
C  Put fixed-factor and fully-dependent block dependencies into KB2
      DO I = 1,KB1(0,0)
        DO IB = 1,NB
          KB2(IB,0) = KB2(IB,0) + 1
          KB2(IB,KB2(IB,0)) = I
        END DO
      END DO
      DO I = 1,NF
        IF(FIX(I)<0 .OR. FIX(I)>NB) CYCLE
        KB2(NB1,0) = KB2(NB1,0) + 1
        KB2(NB1,KB2(NB1,0)) = I
      END DO  ! Row NB1 of KB2 gets all factor indices not FIX-coded -1 or 99
C  Put block-dependency structure from compressed FIX1 code into KB2
      DO IB = 2,NB
        J = FIX1(IB)
        DO K = 1,IB-1
          IF(MOD(J,2)==0) CYCLE
          DO I = 1,KB1(K,0)
            KB2(IB,KB2(IB,0)+I) = KB1(K,I)
          END DO
          KB2(IB,0) = KB2(IB,0) + KB1(K,0)
          J = J/2
        END DO
      END DO
      DO IB = 1,NB1
        KB2(IB,NF) = KB2(IB,0)  ! Save for flag after rest of KB2 is overwitten
      END DO
      WRITE(7,'(/40(" ="))')
C Compute the block regressions and embed coefficients in B1 = I-B
      BIG: DO IB = NB1,1,-1
        N1 = KB1(IB,0)
        N2 = KB2(IB,0)
        IF(N1*N2==0) CYCLE BIG
        DO I = 1,N2
          DO J = 1,N2
            CE(I,J) = C1(KB2(IB,I),KB2(IB,J))
          END DO
        END DO
        CALL MINV(N2,CE,NF,IER)
        DO II = 1,N1
          I = KB1(IB,II)
          DO J = 1,N2
            S = 0.
            DO K = 1,N2
              S = S + C1(I,KB2(IB,K))*CE(K,J)
            END DO
            CH5(I,KB2(IB,J)) = CLN(S,5,2)
            B1(I,KB2(IB,J)) = -S
          END DO
        END DO
C           CH5 now contains the regression coefficients for block IB whose
C           negations have also been entered into weight matrix B1 for residuals.
C           Specificaly, CH5(J,K) holds b-weight iff fac J path-precedes fac K.
      END DO BIG

C Regression weights have been put in lower off-diagonal triangle of CH5;
C now put residual covars on diagonal and upper triangle of CH5.
C Compute the residual covariances among all factors unaccounted for by their
C path-antecedents starting with the unities on B1's diagonal, and put in upper
C triangle of CH5.  (Do NOT try to write resid covs in lower triangle.)

      DO I = 1,NF
        B1(I,I) = 1.
      END DO
      BG: DO J = 1,NF
        DO I = 1,J
          IF(CH5(I,J)/='     ') CYCLE BG
          S = 0.
          DO K = 1,NF
            DO L = 1,NF
              S = S + B1(I,K)*C1(K,L)*B1(J,L)
            END DO
          END DO
          CH5(I,J) = CLN(S,5,2)
        END DO
      END DO BG
      DO IB = 1,NB1
        DO II = 1,KB1(IB,0)
          I = KB1(IB,II)        ! Index of factor in dependent block
          DO JJ = 1,KB2(IB,0)
            J = KB2(IB,JJ)       ! Index of factor in predictor blocks
            CH5(J,I) = '  ---'
          END DO
        END DO
      END DO

110   WRITE(7,'(/20X,"FACTOR PATH WEIGHTS AND UNEXPLAINED RESIDUALS")')
      WRITE(7,'(/" This table gives the simultaneous regressions of t",
     +  "he factors in each block upon all factors in"/" path-anteced",
     +  "ent blocks, as well as all the factor covarariance unaccount",
     +  "ed for by these regressions."/" a) The regression coefficien",
     +  "ts (standardized Beta-weights) are in the table''s lower-tri",
     +  "angle blocks below the"/6X,"diagonal and are marked with ast",
     +  "erisks at end of their block rows to decrease the risk of co",
     +  "nfusion with"/6X,"the residual covariances.  If block J is n",
     +  "ot on a path from block I (I < J), table cell <I,J> is blank"/
     +  " b) Variances and covariances among the factors unaccounted ",
     +  "for by their regressions on the factors"/6X,"path-antecedent",
     +  " to them are in the table''s upper triangles of on-diagonal ",
     +  "blocks.  Between-block"/6X,"residual covariances that are st",
     +  "rictly zero due to the imposed path structure are shown by ",
     +  "dashes."/)')

C This table gives the simultaneous regressions of the factors in each block upon all factors in
C path-antecedent blocks, as well as all the factor covariance unaccounted for by these regressions.
C a) The regression coefficients (standardized Beta-weights) are in the table's lower-triangle blocks below the
C      diagonal and are marked with asterisks at end of their block rows to decrease the risk of confusion with
C      the residual covariances. If block J is not on a path from block I (I < J), table cell <I,J> is blank.
C b) Variances and covariances among the factors unaccounted for by their regressions on the factors
C      path-antecedent to them are in the table's upper triangles of on-diagonal blocks.  Between-block
C      residual covariances that are strictly zero due to the imposed path structure are shown by dashes.

C   First print header row of factor indices after preparing for sectioned output
      NS1 = 1  ! Number of sections needed if cut only at block boundaries
      NS2 = 1  ! Number of sections needed if cuts within blocks are allowed
      KB2(1,0) = 0 ! KB2(1,_) lists positions of NS1 cuts
      KB2(2,0) = 0 ! KB2(2,_) lists positions of NS2 cuts
      LL = 0
      LINE(:11) = '  '
      DO L1 = 0,NB1
        IF(KB1(L1,0)==0) CYCLE
        L0 = LL
        DO L2 = 1,KB1(L1,0)
          LL = LL+5
          J = KB1(L1,L2)
          CH2 = CLN(J*1.,2,10)
          FMT(LL-4:LL) = '  '//CH2//' '
          FM2(LL-4:LL) = '     '
          LINE(LL+7:LL+11) = ''
          IF(LL+11-KB2(2,NS2-1)>KW) NS2 = NS2+1
          KB2(2,NS2) = LL+11+MAX(1,2+L2-KB1(L1,0)) ! Add 1, or 2 if end of block
        END DO
        LL = LL+2
        FMT(LL-1:LL) = ' '
        FM2(LL-1:LL) = ' '
        LINE(LL+10:LL+11) = ''
        LM = (LL+L0)/2 + MOD(LL-L0+1,2) ! Add 1 if interval width is odd
        FM2(LM:LM) = 'X'
        IF(L1>0) FM2(LM:LM) = BN(L1)
        IF(L1==NB1) FM2(LM:LM) = 'Y'
        IF(LL+11-KB2(1,NS1-1)>KW) NS1 = NS1+1
        KB2(1,NS1) = LL+12
      END DO
      LEND = LL+11  ! LEND is end position in print line
      KF = 7
      IF(LEND>KW) KF = 15
      IF(LEND>KW) OPEN(KF,STATUS='SCRATCH')
      LINE(LL+11:LL+11) = ''
      IF(KR>0) CALL TRLIN(FM2)
      WRITE(KF,'("   Block  ",2A)') TR(''), FM2(:LL)
      FM2(:LL+11) = LINE(:LL+11)  ! Must preceed TRLIN(LINE)
      IF(KR>0) CALL TRLIN(LINE)
      WRITE(KF,'(A)') LINE(:LL+11)
      IF(KR>0) CALL TRLIN(FMT)
      WRITE(KF,'("   Factor ",2A)') TR(''), FMT(:LL)
      CALL SUBST(FM2(:LL+11),'Ŵ','ص')
      IF(KR>0) CALL TRLIN(FM2)
      WRITE(KF,'(A)') FM2(:LL+11)
C Now print body of table
      KK = 0  ! Index of factor heading line
      BB: DO K1 = 0,NB1
        IF(KB1(K1,0)==0) CYCLE BB
        IF(KK>0) WRITE(KF,'(A)') LINE(:LL+11)  ! Skip at start of 1st block
        DO K2 = 1,KB1(K1,0)  ! Do for each line of block K1
          KK = KB1(K1,K2)
          LL = 0  ! Construct print line in FMT
          DO L1 = 0,NB1
            IF(KB1(L1,0)==0) CYCLE
            DO L2 = 1,KB1(L1,0)
              LL = LL+5
              FMT(LL-4:LL) = CH5(KK,KB1(L1,L2))
              IF(L1==K1 .AND. L2==K2) M = LL   ! Specified for every line
C               IF(L1<K1 .AND. FMT(LL:LL)==' ') FMT(LL+1:LL+1) = ' '
              IF(L1<K1 .AND. FMT(LL:LL)/=' ') FMT(LL+1:LL+1) = '*'
            END DO
            LL = LL+2
            FMT(LL:LL) = TR('')
          END DO
          IF(K1>0) THEN
            IF(KB2(K1,NF)>0) FMT(M+1:M+1) = TR('')  ! KB2(K1,NF) tells if block is dependent
          END IF
C           IF(FMT(M-3:M-3)/='1') FMT(M+1:M+1) = TR('')
          WRITE(KF,'(I7,3X,2A)') KK, TR(''), FMT(:LL)   ! Print line
        END DO
        FMT(M+1:M+1) = ' '   ! Why?  (Needed to clear?)
      END DO BB
      CALL SUBST(LINE(:LL+11),'Ŵ','')
      IF(KR>0) CALL TRLIN(LINE)
      WRITE(KF,'(A)') LINE(:LL+11)
      WRITE(KF,'(2X,"* Direct path weights to the factor whose resid",
     + "ual variance on this line is marked ",A,".")') TR('')
      IF(KF==7) RETURN
C Now retrieve output from scratch file and print in sections as needed
      KK = 1
      IF(NS2<NS1) KK = 2
      REWIND KF
      DO L = 1,MIN(NS1,NS2)  ! Write sections to output file 7
        WRITE(7,'(/20X,"[ vertical section",I2," ]"/)') L
92      READ(KF,'(A)',END=90) FMT(:LEND)
        WRITE(7,'(1X,A)') FMT(MAX(1,KB2(KK,L-1)):KB2(KK,L))
        GOTO 92
90      REWIND KF
      END DO
      IF(KF/=7) CLOSE(KF)
      END SUBROUTINE

      SUBROUTINE RELOAD(M,A)
C Reload RECORD under new choice of BH.  If M<0, truncate pattern store after
C record Abs(N). If M>0, save record M and put it into A at exit
      REAL    A(MV,0:*)      ! Need col 0 to match BUFF array.
      COMMON  NV, NF, MV, MF
      COMMON /BL4/ NN, NTOT
      IF(M>0) OPEN(15,STATUS='SCRATCH',FORM='UNFORMATTED')
      REWIND 8
      READ(8)
5     READ(8,END=10) LAST, ((A(I,J),I=1,NV),J=1,NF)
      NTOT = LAST
      CALL BUFF(0,A,C1,LL)   ! C1,LL are inoperative in call BUFF(0,...)
      IF(LAST==M) WRITE(15) ((A(I,J),I=1,NV),J=1,NF)
      IF(M>=0 .OR. LAST<ABS(M)) GOTO 5  ! If M<0, position for ENDFILE
10    IF(M<=0) RETURN
      REWIND 15; READ(15) ((A(I,J),I=1,NV),J=1,NF); CLOSE(15)
      END SUBROUTINE
C
      SUBROUTINE RESCAL(A,C,KB,JOB)
C Adjust scaling for items declared binary in OFFL.  JOB=1 says to set
C off-norm scales with SDs in the decimal parts of OFFL entries; JOB=0
C reverts to standard scaling.
      REAL A(MV,0:*), C(MF,*), OFFL(KB)  !, SD(KB)
      COMMON  NV, NF, MV, MF
      EXTERNAL SCAN
      IF(KB==0) RETURN
      READ(33) J, (OFFL(I),I=1,KB); REWIND 33
      K = 0
      DO J = 1,NF  ! Count off-norm factors for trouble check
        IF(ABS(1.-C(J,J))>.0001) K = K+1
      END DO

      IF(JOB==1.AND.K>0) THEN  ! Shouldn't need after debugging
cc      IF(JOB==1.AND.K>0 .OR. JOB==0.AND.K/=KB) THEN  ! Shouldn't need
        IF(JOB==1.AND.K>0) WRITE(6,'(" >>>> WARNING: Call to acti",
     +    "vate binary scaling of",I3," dichtomous"/15X,"factors finds",
     +    I3," factors already off-norm.")') KB, K
cc        IF(JOB==0.AND.K/=KB) WRITE(6,'(" >>>> WARNING: Call to de",
cc     +    "activate",I3," binary scalings"/15X,"finds",I3," factors ",
cc     +    "now off-norm.")') KB, K
        WRITE(6,'(6X,"Hit RETURN to abort.  Otherwise, enter anything",
     +    " to see what ensues.")')
        CALL SCAN(J,0,'B',5); IF(J==0) STOP
      END IF

      DO JJ = 1,KB
        J = INT(OFFL(JJ)); SD = OFFL(JJ)-J
        X = SD; IF(JOB>0) X = 1./X   ! X adjusts pattern
        Y = SD; IF(JOB==0) Y = 1./Y   ! Y adjusts covariances
        DO I = 1,NV
          A(I,J) = A(I,J)*X
        END DO
cc        DO I = 1,NF  ! Leave covariances scaled as correlations
cc          C(I,J) = C(I,J)*Y
cc          C(J,I) = C(J,I)*Y
cc        END DO
cc        IF(JOB==0) C(J,J) = 1. ! Surely unnecessary
      END DO
      END SUBROUTINE
C
      SUBROUTINE RMS(N,NC,AA,MV,RP,PUT)
C Return in RP the quadratic mean (RMS) of NVxNC matrix AA's columns;
C and if NV>0, return in PUT the recommended permutation in Put order.
      REAL AA(MV,*), RP(*)
      INTEGER PUT(*)
      NV = ABS(N)
      DO J = 1,NC
        RP(J) = 0.
        DO I = 1,NV
          RP(J) = RP(J) + AA(I,J)*AA(I,J)
        END DO
        RP(J) = SQRT(RP(J)/NV)
      END DO
      IF(N<0) RETURN
      DO J = 1,NC
        PUT(J) = NINT(1000*(1.-RP(J)))*1000 + J
      END DO
      IF(N<=0) RETURN
      CALL SORT(NC,PUT) ! SORT yields ascending order
      DO J = 1,NC
        RP(J) = MOD(1.*PUT(J),1000.)
      END DO
      DO J = 1,NC
        PUT(NINT(RP(J))) = J  !  PUT is now in PUT sequence
      END DO
      END SUBROUTINE
C
      SUBROUTINE ROTATE(KTL,A1,C1,W,T1,CG,DE,DG,FIX,PFIX,WSAL,IER)
C This executes the rotation
      LOGICAL QT, QK
      CHARACTER CLN*8, TR, CH, CF*12
      INTEGER KTL(MF,*), KNT(-2:50)  ! KNT passes polishing info from HYPGET
      INTEGER FIX(*), PFIX(*)
      REAL(8) SI
      REAL A1(MV,0:*), T1(MV,*), W(MV,*), C1(MF,*), CG(*), DG(*), DE(*),
     +     CUM(4,0:4)  ! Rows 1/2/3/4 of CUM are total time/cycles/solutions/nonconvergences
      COMMON  NV, NF, MV, MF
      COMMON /BL2/ LIM, CV, PD1, MODE, GAM
      COMMON /BL6/ B0, B1, DB, DF, TOL, IMAX
      COMMON /BL7/ JFLAG, NSPN, KNV, TT, ICYC
      COMMON /CF/ CF
      COMMON /KNT/ KNT
      COMMON /CM/ CUM
      LO(I,J) = J*(J-1)/2 + I
      RAD = 90/ACOS(0.)  ! Radians-to-degrees coefficient
      CMAX = .95   ! Limit on factor correlations under Serial rotation (also Parallel)
      KFLAG = IER  ! SPIN sets IER = -1 before calling ROTATE
      MM = MODE/2  ! 0/1/2 => STEP/SCAN/OBLM
      QT = .TRUE.; QK = .FALSE.; IF(WSAL<-1.) QK = .TRUE. ! QK=t calls Kaiser norming

C TEST LINES ! Probably permanent installation
      CALL QUIZ(A1,C1,NN,ERR,IMX,JMX,1)
      IF(IER==-1 .AND. ERR>.01) THEN
        IF(ERR>.10) THEN
          OPEN(23,FILE='ERRORS')
          WRITE(23,'(" ROTATE gets a SPIN shift with Chh-reproduct",
     +      "ion error",A6)') CLN(ERR,6,2)
          WRITE(6,'(" ROTATE gets a SPIN shift with Chh-reproduct",
     +      "ion error",A6)') CLN(ERR,6,2)
        END IF
        IER = 1
        GOTO 199  ! Pattern retrieved at Label 199 was saved in SPIN
      END IF
ccc      WSL = WSAL; IF(WSL<-1.) WSL = WSL+1.
      WSL = WSAL; IF(WSAL<0) WSL = AMOD(WSAL+.001,1.)-.001
      WRITE(19) ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF)
C       May need later to retrieve pattern received from MAIN (SPIN save doesn't hurt)
      KNV = 0; TT = TM(0)  ! Initialize timing but don't reset timer (SPIN may be accumulating).
      ICYC = 0; NF1 = NF+1; NF2 = NF+2      ! 1,2=>5  3,4=>2 5=>5
      IF(CUM(2,MODE)<5.) THEN  ! CUM(2,MODE) is total count of cycles
        KS = 10; IF(MM>0) KS = 5  ! 10 for SCAN, 5 for STEP and OBLMIN
      ELSE
        S = CUM(2,MODE)/MAX(.001,CUM(1,MODE)) ! equals cycles per seconds
        IL=3; KS = MAX(5,MIN(40,5*NINT(IL*S/5)))  ! Round to steps of 5 cycles
      END IF ! IL is targeted no. seconds between displays
C      KS determines frequency of rotation-progress report to screen.
      KPRL = MOD(MODE,2)   ! 1 for Parallel, 0 for Serial
C               MOD/2 = 0 (STEP), 1 (SCAN), 2 (OBLMIN)
C      GAM = 0   ! Set OBLMIN parameter to 0 (QUARTIMIN)
      IF(QK) CALL KNORM(A1,1)
      IF(LIM<=0) GOTO 15  ! Still diagnoses STEP
      KNT = 0; NQ = 0   ! Initialize count of successive cyclic nonconvergences
15    ICYC = ICYC+1
      IF(WSAL<0.) THEN
        DO I = 1,NV ! Use cols NF1,NF2 of T1 for computing Comp2 weights
          T1(I,NF1) = A1(I,1)**2
          DO J = 2,NF
            T1(I,NF1) = T1(I,NF1) + A1(I,J)**2
          END DO
        END DO
      END IF
      IF(KPRL==1) GOTO 200  ! Jump to parallel rotation
C Do serial rotation. Note: Serial iteration uses B0 but not DF.
      DO J = 1,NF   ! Save start pattern/covars for shift comparison
        DO I = 1,NV
          T1(I,J) = A1(I,J)   ! Columns of T1 after NF+1 are free
        END DO
      END DO
      BIGA1: DO I = 1,NF    ! I is the factor rotated to change
        BIGA2: DO J = 1,NF   !   loadings on factor J
          IF(I==J .OR. KTL(I,J)/=1 .OR. PFIX(J)==1) CYCLE BIGA2
          IER = 0
          DO L = 1,NV           ! <<<<< Upper A1; needs protect during rotation
            A1(L,NF2) = A1(L,J)    ! Formerly saved in BUFA(L,2)
            A1(L,NF1) = A1(L,I)    ! Formerly saved in BUFA(L,1)
            IF(WSAL>=0.) CYCLE
            T1(L,NF+3) = A1(L,I)**2 + A1(L,J)**2  ! Used for updating T1(-,NF1)
            T1(L,NF2) = 1. + WSL*COMP2(A1(L,I),A1(L,J),T1(L,NF1))
          END DO
          IF(MM==0) WW = HYPGET(I,J,A1,T1(1,NF2))
          IF(MM==1) WW = HYFIND(I,J,A1,WSL,T1(1,NF2))
          IF(MM==2) WW = OBL(I,J,A1(1,1),C1,GAM)  ! GAM is negated in OBL
          S = SQRT(1+(2*C1(I,J)+WW)*WW)  ! SD of pre-normalized rotated factor I
          IF(S<1.E-4) THEN
            IER = 1
            CYCLE BIGA2
          END IF
          DO L = 1,NV
            A1(L,NF+2) = A1(L,NF+2) - WW*A1(L,NF+1)    ! <<<<< Upper A1; protect
            A1(L,NF+1) = S*A1(L,NF+1)
          END DO
          S = 1./S
          T = WW*S
          DO L = 1,NF
            IF(L==I) CYCLE
            A1(L,NF+3) = S*C1(L,I) + T*C1(L,J)   ! C1(L,I) = S*C1(L,I) + T*C1(L,J)
            IF(A1(L,NF+3)>CMAX) THEN
              IER = 1
              GOTO 85
            END IF
              C1(I,L) = C1(L,I)
          END DO
          A1(I,NF+3) = 1.0  ! Needed to avoid excluding L=I in Loop 162
          DO L = 1,NV
            A1(L,J) = A1(L,NF2)
            A1(L,I) = A1(L,NF1)
            IF(WSAL>=0.) CYCLE
            T1(L,NF1) = T1(L,NF1)-T1(L,NF+3) + A1(L,J)**2 + A1(L,I)**2 ! Comp2 update
          END DO
          DO L = 1,NF       ! Formerly Loop 162
            C1(L,I) = A1(L,NF+3)
            C1(I,L) = C1(L,I)
          END DO
        END DO BIGA2
      END DO BIGA1
      CALL ALIGN(A1(1,1),T1,CG,DE,NV,NF,CH,AV,HI,MV)  ! wrong-type CG isn't used
C     Keep user appraised of progress  $$$$$$$$$$$$$$$$
      IF(NF>10.AND.NF<13 .OR. NF>20) THEN
        IF(MOD(ICYC,KS)==0) WRITE(6,'(" Cycle",I3," pattern shifts (",
     +    A,"):",12(1X,A3),8(:/5X,18(1X,A3)))') ICYC, TR(''),
     +    (CLN(DE(I),3,1),I=1,NF)
      ELSE
        IF(MOD(ICYC,KS)==0) WRITE(6,'(" Cycle",I3," pattern shifts (",A,
     +    "):",10A5,8(:/5X,15A5))')ICYC, TR(''),(CLN(DE(I),5,1),I=1,NF)
      END IF
      IF(ICYC<IMAX .AND.HI>TOL) GOTO 15
C  Reflect axes to achieve mainly positive loadings
      DO J = 1,NF
        CG(J) = 0.
        DO I = 1,NV
          CG(J) = CG(J) + A1(I,J)
        END DO
      END DO
C         CG(J) will show whether factor J loadings are mainly positive
      GOTO 64
C Do parallel rotation
200   DO I = 1,NF    ! T1 is MV x 2*MF+2; all columns are free in this loop
        DO J = 1,NF
          W(I,J) = 0.
          IF(I==J .OR. KTL(I,J)/=1 .OR. PFIX(J)==1) CYCLE
          IF(WSAL<0.) THEN
            DO L = 1,NV
              T1(L,NF2) = 1. + WSL*COMP2(A1(L,I),A1(L,J),T1(L,NF1))   ! Comp2
            END DO
          END IF
          IF(MM==0) W(I,J) = HYPGET(I,J,A1,T1(1,NF2))
          IF(MM==1) W(I,J) = HYFIND(I,J,A1,WSL,T1(1,NF2))
CCC          IF(MM==2) W(I,J) = OBL(I,J,A1(1,1),C1,GAM) ! Not operative
        END DO
      END DO
C   Compute normalized factor-rotation matrix T1
      ICHK = 0; DDF = 2*DF         ! Serial rotation never gets here
210   ICHK = ICHK + 1; DDF = DDF/2
      IF(ICHK>5) GOTO 87   ! ****** This should never occur; goto 210 below
      DO I = 1,NF          !        executes only when ICHK+1  5
        DO J = 1,NF
          T1(I,J) = DDF*W(I,J)     ! Damp computed parallel rotation coeffs
        END DO
        T1(I,I) = 1.
      END DO
      DO I = 1,NF
        SI = 0.
        DO J = 1,NF
          DO K = 1,NF
             SI = SI + T1(I,J)*C1(J,K)*T1(I,K)
          END DO
        END DO
        IF(SI<1.E-6) THEN
          IF(ICHK<5) GOTO 210
          IF(KFLAG>=0) WRITE(6,'(/" *** Rotation disqualified by ill",
     +      "-conditioned rotation matrix. Reinstate"/4X,"prior patt",
     +      "ern and try other rotation parameters.")')
          IF(KFLAG<0) WRITE(6,'(/" *** Rotation disqualified by ill-",
     +      "conditioned rotation matrix."/4X,"Will try another rand",
     +      "omization")')  ! SPIN call sets neg KFLAG
          IF(QK) CALL KNORM(A1,0)
          RETURN
        END IF
cc        DE(I) = 1./SQRT(MAX(.000001,SI))
        DE(I) = 1./SQRT(SI)
      END DO
      DO J = 1,NF
        DO I = 1,NF
          T1(I,J) = DE(I)*T1(I,J)
        END DO
      END DO
C   Compute vector DE of new factor shifts in degrees
      DO I = 1,NF
        SI = 0.
        DO J = 1,NF
          SI = SI + T1(I,J)*C1(J,I)
        END DO
        IF(ABS(SI)>.99999) SI = 1.
        DE(I) = ABS(MIN(1.,SNGL(ACOS(SI))))*RAD
      END DO
C   Keep user appraised of progress $$$$$$$$$$$$$$$$
      IF(NF>10.AND.NF<13 .OR. NF>20) THEN
        IF(MOD(ICYC,KS)==0) WRITE(6,'(" Cycle",I3," pattern shifts (",
     +    A,"):",12(1X,A3),8(:/5X,18(1X,A3)))') ICYC, TR(''),
     +    (CLN(DE(I),3,1),I=1,NF)
      ELSE
        IF(MOD(ICYC,KS)==0) WRITE(6,'(" Cycle",I3," pattern shifts (",A,
     +    "):",10A5,8(:/5X,15A5))') ICYC,TR(''),(CLN(DE(I),5,1),I=1,NF)
      END IF
C Check for cyclic nonconvergence
      I1 = 0
      I2 = 0
      S = 2*TOL
      DO I = 1,NF
        IF(DE(I)<=S) I1 = I1+1
        IF(DE(I)>=15.) I2 = I2+1
      END DO
      IF(I2>=1 .AND. I2<=2 .AND. I1==NF-I2) THEN
        NQ = NQ+1  ! Initialized before start of cycles
        IF(NQ>=5) QT = .FALSE.
      ELSE
        NQ = 0
      END IF
C   Compute rotated factor covariances
      DO I = 1,NF
        DO J = I,NF
          SIJ = 0.
          DO K = 1,NF
            DO L = 1,NF
              SIJ = SIJ + T1(I,K)*C1(K,L)*T1(J,L)
            END DO
          END DO
          CG(LO(I,J)) = SIJ
        END DO
      END DO
      DO J = 1,NF
        C1(J,J) = CG(LO(J,J))
        DO I = 1,J-1
          C1(I,J) = CG(LO(I,J)); C1(J,I) = C1(I,J)
        END DO
      END DO
C   Invert factor-rotation matrix and compute new factor pattern,
C   reflecting factor axes if appropriate.
      CALL MINV(NF,T1,MV,IER)
      IF(IER==0) GOTO 57
      IF(KFLAG>=0) WRITE(6,'(/" *** Rotation disqualified by matrix",
     +  " singularity. Reinstate prior pattern"/4X,"and try other ",
     +  "rotation parameters.")')
      IF(KFLAG<0) WRITE(6,'(" Rotation defeated by matrix singular",
     +  "ity. Will try another randomization.")')
      IF(QK) CALL KNORM(A1,0)
      RETURN
57    DO J = 1,NF
        CG(J) = 0.
      END DO
      DO I = 1,NV
        DO J = 1,NF
          SIJ = 0.
          DO K = 1,NF
            SIJ = SIJ + A1(I,K)*T1(K,J)
          END DO               ! CG(J) will show whether factor J loadings are
          CG(J) = CG(J) + SIJ  ! mainly positive; DG will hold new row of A1
          DG(J) = SIJ          ! until the old row is no longer needed.
        END DO
        DO J = 1,NF
          A1(I,J) = DG(J)
        END DO
      END DO
64    R = 1.
      DO J = 1,NF
        CG(J) = SIGN(1.,CG(J))
        IF(FIX(J)<=0) CG(J) = 1.
        R = MIN(R,CG(J))
      END DO
      IF(R>=0.) GOTO 70  ! No reflections are needed
      DO J = 1,NF
        IF(CG(J)>=0) CYCLE
        DO I = 1,NV
          A1(I,J) = CG(J)*A1(I,J)
        END DO
      END DO
      DO J = 1,NF
       DO I = 1,NF
         C1(I,J) = CG(I)*CG(J)*C1(I,J)
        END DO
      END DO
70    IF(KPRL==0) GOTO 85

C   If near IMAX, prepare for pattern-congruence report in DG.
      IF(ICYC>=IMAX) QT = .FALSE.
      IF(ICYC<IMAX-1) GOTO 80
      IF(.NOT.QT) GOTO 74
      DO I = 1,NV     ! Save pattern for comparison to final rotation
        DO J = 1,NF
          A1(I,NF+J) = A1(I,J)     ! <<<<< Upper A1
        END DO                     ! Used for screen report on convergence
      END DO
      GOTO 80
74    IF(IMAX==1) GOTO 80    ! Why would IMAX ever equal 1?
      DO J = 1,NF  ! Serial rotation doesn't affect this; upper A1 is safe
        S12 = 0.; S11 = 0. ; S22 = 0.
        DO I = 1,NV
          S12 = S12 + A1(I,J)*A1(I,NF+J)    ! <<<<< Upper A1
          S11 = S11 + A1(I,J)**2
          S22 = S22 + A1(I,NF+J)**2
        END DO
        DG(J) = ACOS(MIN(1.,ABS(S12)/SQRT(S11*S22)))*RAD  ! For screen report
      END DO
C   Check for convergence
80     DIFF = 0.
       DO I= 1,NF
         DIFF = MAX(DIFF,DE(I))
       END DO
      IF(QT .AND. DIFF>=TOL) GOTO 15
C   Finish rotation   ! Serial rotation re-enters at label 85
85    IF(IER==0) CALL CHEK(IER,NV,NF,A1(1,1))
      IF(QK) CALL KNORM(A1,0)
      CALL QUIZ(A1,C1,NN,ERR,IMX,JMX,1)  ! TEST LINE; permanent?
      IF(ERR>.01) THEN
        OPEN(23,FILE='ERRORS')
        WRITE(6,'(" ROTATE rejects a rotation deviating from the in",
     +    "put Chh by",A6," in factor plane <",I2,",",I3,">")')
     +    CLN(ERR,6,2), IMX, JMX
        WRITE(23,'(" ROTATE rejects a rotation deviating from the ",
     +    "input Chh by",A6," in factor plane <",I2,",",I3,">")')
     +    CLN(ERR,6,2), IMX, JMX
        GOTO 199
      END IF
      IF(QK) CALL KNORM(A1,1)
      IF(OBQ(C1,1)>.98) IER = IER+2
87    IF(IER>0) THEN ! .OR.ICHK>5) THEN  ! ICHK isn't defined for Serial rotation
        IF(KFLAG<0) WRITE(6,'(" Rotation is aborted by a degeneracy.",
     +    "  Will try another randomization.")')
        IF(KFLAG>=0) WRITE(6,'(" This rotation has become degenerate",
     +    " and will not be saved."/" Try other rotation parameters ",
     +    "or another start position.")')
        GOTO 199
      END IF
      TT = TM(0)-TT
      CUM(1,MODE) = CUM(1,MODE) + TT
      CUM(2,MODE) = CUM(2,MODE) + ICYC
      CUM(3,MODE) = CUM(3,MODE) + 1.
      IF(.NOT.QT) CUM(4,MODE) = CUM(4,MODE) + 1.  ! QT=t flags convergent rotation
      IF(KFLAG<0) THEN; IER = -ICYC; GOTO 100; END IF  ! IER passes rotation count to SPIN
C       KFLAG<0 signals ROTATE call by SPIN
      WRITE(6,'(/" Rotation stopped after ",A," cycles with factor ",
     +  "shifts (degrees) of",9(:/4X,18(1X,A3)))') CF(:JF(ICYC)),
     +  (CLN(DE(I),3,1),I=1,NF)
      IF(QT) GOTO 90
C       If QT = TRUE at this point, convergence was achieved
      I1 = 1; I2 = 1
      DO J = 2,NF
        IF(DE(J)>DE(I1)) I1 = J  ! Largest location shift
        IF(DG(J)>DG(I2)) I2 = J  !    "    pattern shift
      END DO
      WRITE(6,'(" and pattern-congruence shifts (Degrees) of",
     +  9(:/4X,14A5))') (CLN(DG(I),5,1),I=1,NF)
      WRITE(6,'(" Most unstable was factor",I3," in the <",I2,",",I2,
     +  "> plane.")') I1, I1,I2  D
90    CONTINUE
C  >>> Polish info is visually intrusive, but save code in case someday wanted
CCC     IF(LIM<0) GOTO 100
CCC     L = MIN(LIM,MF)
CCC     IF(L>0) WRITE(6,'(/" Raw distribution of polish-stroke ",
CCC    +  "iterations:",9(/2X,15I5))') (KNT(I),I=1,L)
CCC     IF(L>0) WRITE(6,'()')
CCC     S1 = FLOAT(KNT(0) + KNT(-1))
CCC     S2 = S1 + KNT(-2)
CCC     IF(S2<1.) GOTO 100
CCC     K = INT(.5 + 100*S1/S2)
CCC     IF(K>0) WRITE(6,'(/" Polish strokes that were reversals ",
CCC    +  "or overshifts:",I4)') K
100   KNV = 0
      IF(DIFF>TOL*2) KNV = 1
C        If rotation didn't converge, flag KNV for SPIN to count
      IF(QK) CALL KNORM(A1,0)
      IF(KFLAG<0)  RETURN
      CALL BUFF(1,A1,C1,FIX)
      RETURN
199   REWIND 19 ! Reinstate old pattern/covars
      READ(19) ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF)
      END SUBROUTINE
C
      SUBROUTINE SCAN(NL,NS,SEQ,KF)
C     Copyright (c) 1999 by W. W. Rozeboom.   All rights reserved.
C This reads the keyboard string, cleans it for list-directed reading of
C the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.  Termination of an input line by "*" allows up to
C two continuation lines.) NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number
C string returned in File 2 is non-null but does not match SEQ, and
C gives the total count of numbers in the returned string otherwise.
C ***** If SEQ is "B", NL returns 0 if the input line is blank, and
C       returns -1 otherwise.
      CHARACTER  AA, SEQ*(*), WA*240, WB*240
      NL = 0
5     NLL = NL + 80
      READ(KF,'(A80)') WA(NL+1:NLL)
      IP = NL
      NL = NLL+1
10    NL = NL-1
      IF(NL==0) RETURN
      IF(WA(NL:NL)==' ') GOTO 10
      IF(WA(NL:NL)=='*' .AND. NL>IP) GOTO 5
      N=ICHAR(WA(NL:NL)); IF(N==96) THEN; NL=0; RETURN; END IF
      IF(SEQ(1:1)=='B') NL = -1  ! ^ Finger overshoot may get `
      IF(SEQ(1:1)=='B') RETURN
      WB(NL+1:NL+1) = ' '
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +      WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
        ELSE IF (WA(I:I) /= '0') THEN
          IP = 0
        END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF (WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) RETURN
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     +  "number sequence requested. Try again.")')
      RETURN
60    REWIND 2
      WRITE(2,'(A)') WB(1:NL)
      NL = NN
      REWIND 2
      END SUBROUTINE
C
      SUBROUTINE SCHEMA(NV,NF,CUT,A1,LDA,QBB,QN,NB,KBL,LM,IDENT,KK)
C Display schematized factor pattern in A1 with blanks for loadings smaller
C than CUT and others rounded to nearest lst decimal. Print-file term KK
C is negative if pattern lines are to be block-spaced.  LM is max namelength.
C NOTE: KBL is used only if KK < 0 and QBB = true
      LOGICAL QBB, QN
      CHARACTER*3 LN(:), IDENT(*)*8
      ALLOCATABLE :: LN
      INTEGER KBL(-1:NB+1,0:*)
      REAL A1(LDA,0:*)
      EXTERNAL SCAN
      ALLOCATE ( LN(NF) )
      KF = ABS(KK)
      IF(QBB.AND.KK<0) NB1 = NB+MIN(1,KBL(NB+1,0))
ccc      IF(KK/=6 .AND. QN) THEN     ! No need; IDENT is now OK in input
ccc        REWIND 15
ccc        READ(15,'(500A)') (IDENT(I),I=1,NV)
ccc      END IF
5     IF(CUT>1.5) CUT = CUT/10
      IF(CUT>1.5) GOTO 5
      DO I = 1,NV
        IF(KK<0 .AND. A1(I,NF+2)==1.) WRITE(KF,'()') ! Block spacing is in A1(_,0)
        IF(KK>0 .AND. MOD(I-1,5)==0) WRITE(KF,'()')
        DO J = 1,NF
          LN(J) = '  .'
          X = ABS(A1(I,J))
          IF(X<=CUT) CYCLE
          IF(A1(I,J)<.01) LN(J)(2:2) = '-'
          LN(J)(3:3) = CHAR(48+NINT(MIN(9.,10*X)))
        END DO
        IF(KF==6 .OR. .NOT.QN) THEN
          WRITE(KF,'(I4,".",4(1X,5A),5(:/6X,4(1X,5A)))') I, (LN(J),
     +      J=1,NF)
          IF(KF==6.AND.((MOD(I,10)==0.AND.NV-I>5).OR.I==NV))
     +      CALL WAIT(1)
        ELSE IF(QBB.AND.KK<0) THEN
          WRITE(KF,'(I4,":",A,1X,60A)')I, IDENT(I)(:LM), ((LN(KBL(IB,
     +      J)),J=1,KBL(IB,0)),'   ',IB=0,NB1), (LN(KBL(-1,J)),J=1,
     +      KBL(-1,0))
        ELSE
          WRITE(KF,'(I4,":",A,1X,8(1X,5A),5(:/6X,8(1X,5A)))')
     +      I, IDENT(I)(:LM), (LN(J), J=1,NF)
        END IF
      END DO
      END SUBROUTINE
C
      SUBROUTINE SEENAM(NX,IDENT,PIK,JOB,NW,LM,KF)
C This writes to file KF the NX names in IDENT(PIK). NW sets number of chars
C in line. LM is max namelength computed previously. JOB=0 says to print index
C listed in PIK rather than position in PIK list.
      CHARACTER*8 IDENT(*), FMT*30, CH2*2
      INTEGER PIK(*)
      MM = MAX(3,LM)
      LL = NW/(5+MM)   ! Number of fields per line
      CH2 = CHAR(48+LL/10)//CHAR(48+MOD(LL,10))
      FMT = '(80(1X,'//CH2//'(I4,":",A),:/))'
      IF(JOB/=0) WRITE(KF,FMT) (I,IDENT(ABS(PIK(I)))(:MM),I=1,NX)
      IF(JOB==0) WRITE(KF,FMT) (ABS(PIK(I)),IDENT(ABS(PIK(I)))
     +             (:MM),I=1,NX)
      RETURN
      END
C
      SUBROUTINE SETPAR(X,CH4,LL,BND1,BND2,NF,ND,WARN,KCH,M)
C       Upper bound BND now presumed always positive
      CHARACTER CH4*4, CLN*8
      EXTERNAL SCAN
      B = X
10    WRITE(6,'(/12X,"The setting of control parameter ",A," is now ",A,
     +  "."/12X,"Hit RETURN if OK, or enter new value."/)') CH4(:LL),
     +  CLN(X,NF,ND)
      CALL SCAN(J,1,'R',5)
      IF(J<0) GOTO 10
      IF(J==0) RETURN
      READ(2,*) X
20    IF(X>BND2 .OR. X<BND1) THEN
        IF(X>BND2) X = X/10
        IF(BND1>=0. .AND. X<0.) X = -X
        IF(BND1>0. .AND. X>0.) X = MAX(BND1,X)
        IF(BND1<0. .AND. X<BND1) X = X/10
        GOTO 20
      END IF
      IF(X>WARN) WARN = -X
      IF(X/=B) KCH = M
      RETURN
      END
C
      SUBROUTINE SHOW(IO,FMT1,QBB,LST2,COMM,A1,C1,NB,KBL,LD)
C This writes to screen (if IO=6) or to RESULTS file (if IO=7) the current
C factor pattern/correlations.  KBL is unused unless IO is negative.

C How to show patterns with line breaks every LSP lines and Pause where needed:
C Let NL be number of lines needed to show one pattern row.  Then after J
C items have been displayed the total pattern lines produced including header
C and breaks is NALL(J) = 2 + I*NL + I/LSP.  Let NDUN be NALL at the last page
C pause; then NCUR(J) = NALL(J)-NDUN is the count of lines on the last page
C through item J, while if MOD(J,LSP) = 0 (time for a line break), the number
C of lines needed for next LSP-block plus pause is NXT = 1+LSP*NL.  So whenever
C J hits MOD(J,LSP) = 0, do continuation pause if NCUR+NXT > 23 (leaving 2
C lines for RMS footer).

      LOGICAL QBB, QBX, QBY
      CHARACTER FMT1*(*), FMT2*53, CLN*8, BN, CH4*4, CS, CH2*2,
     +          LN*(11+6*(NF+NB+2))   ! For pattern, need only (20+8*(NB+2))
      INTEGER LST2(*), KBL(-1:NB+1,0:*)
      REAL A1(MV,0:2*MF), C1(MF,*), COMM(*)
      COMMON  NV, NF, MV, MF
      NALL(J) = 2 + J*NL + J/LSP  ! Num screen-display lines through item J (function def.)
      FMT2 = '(I4,". (",A3,")"'//FMT1(7:)
      KP = 132; IF(FMT1(10:10)=='2') KP = 80; NDUN = 0
      IF(LD==3) FMT2(12:12) = '4'
C       For IO=6, FMT1 = '(4X,7X,2(2X,5A5),90(:/13X,2(2X,5A5)))'
C             so FMT2 is  (I4,'. (',A3,')',2(2X,5A5),90(:/13X,2(2X,5A5)))
      IF(IO==6) THEN
        IF(NF>12) THEN
          FMT2(23:23) = '6'; FMT2(42:42) = '6'
        ELSE IF(NF>10) THEN  ! Matters just if NF is 11 or 12
          FMT2(18:18) = '3'
        END IF
      END IF
      NL = 1+(NF-1)/12  ! Number of display lines per record when IO=6
      LSP = 10; IF(NL>1) LSP = 5  ! No. items displayed (IO=6)between line space
      IX = ABS(IO); LN = ' '   ! ?? does this blank LN fully?
      LDD = LD+3
      NB1 = NB+MIN(1,KBL(NB+1,0))  ! NB1 > NB iff there are Y-factors
      QBX = QBB.AND.IO<0.AND.NF<=22.AND.KP>100
      QBY = QBX.AND.LD==3
      QBX = QBX.AND.LD==2
      IF(QBX) THEN   ! No block-spacing when LD=3 or KP=80
cc Create line spacing Format for blocks in LN
cc         '(I4,". (",A3,"),2X,naA5,2X,nbA5,2X,ncA5,2X,....,2X,nzA5)'
        KS = 3; CS = CHAR(48+KS)   ! Line spacing between blocks; keep 6
        LW = 16; LN(:LW) = '(I4,". (",A3,")"'
        DO IB = 0,NB1+MIN(1,KBL(-1,0))  ! Waifs, if any, are last
          IF(KBL(IB,0)==0) CYCLE
          IZ = IB; IF(IB>NB1) IZ = -1
          CH2 = CLN(1.*KBL(IZ,0),2,10)
          LN(LW+1:LW+9) = ','//CS//'X,'//CH2//'A5)' !
          LW = LW + 8   !  End ')' is overwritten on all but last addition
        END DO
          LW = LW + 1
      END IF
      DO I = 1,NV
        A1(I,0) = COMM(I)  ! Done to get RMS of COMM column
        IF(.NOT.QBB.AND.MOD(MAX(1,I-1),LSP)==0) WRITE(IX,'()')  ! Triggered by start of next block
        IF(QBB .AND. A1(I,NF+2)==1.) WRITE(IX,'()') ! A1(_,NF+2) flags item-block spacing
        IF(IO>=0) CH4 = CLN(COMM(I),LD+1,LD)//' '
        IF(IO<0) CH4 = ' '//BN(LST2(I))//'  '   ! Block assignment
        IF(QBX) THEN
          WRITE(IX,LN(:LW)) I, CH4, ((CLN(A1(I,KBL(IB,J)),5,2),
     +      J=1,KBL(IB,0)),IB=0,NB1),
     +      (CLN(A1(I,J),5,2),J=NF-KBL(-1,0)+1,NF)
        ELSE
          WRITE(IX,FMT2) I, CH4, (CLN(A1(I,J),LDD,LD),J=1,NF)
        END IF
        IF(IX/=6 .OR. MOD(I,LSP)/=0 .OR. I>=NV) CYCLE
        NCUR = NALL(I) - NDUN
        IF(NCUR+LSP*NL<=23) CYCLE
        WRITE(6,'(" Hit RETURN to continue this display, or enter ",
     +    "anything to quit it.")') ;  NDUN = NALL(I)
        READ(5,'(A)') CS
        IF(CS/=' ') RETURN
      END DO
      CALL RMS(-NV,NF+1,A1(1,0),MV,A1(1,NF+1),KK) ! Negative NV makes KK a dummy
      FMT2 = '(" RMS:'//FMT2(7:)
C        FMT2 is now   (" 000: (",A3,")",2(2X,5A5),90(:/13X,2(2X,5A5)))
CC      IF(IX==6) NL = MIN(13+5*NF+NF/6,75)
      K = 3; IF(NF<6) K = 1; IF(NF==11.OR.NF==12) K = 5  ! 1 + space between blocks
      IF(IX==6) NL = 13+5*NF + K
      IF(IX>6) NL = MIN(13+LDD*NF+2*(NF/5),119-11*(LD-2))
C      For IX=7,  Max is 119 for LD=2 and 108 for LD=3, so Max = 119 - 11*(LD-2)
      IF(.NOT.QBX) WRITE(IX,'(200A)')  ' ', ('',I=1,NL)
      IF(QBX) THEN  ! Block spacing for RMS line
ccc        KWW = 11 + KS* ( NB+MIN(1,KBL(-1,0)) + MIN(1,KBL(0,0)) +NF)
        KWW = 11+KS*( NB+MIN(1,KBL(-1,0))+MIN(1,KBL(0,0)))+5*NF
        WRITE(IX,'(200A)')  ' ', ('',I=1,KWW)
ccc        LN(:LW) = '(I4,". (",A3,")",'//CS//'X,'//CH2//'A5)'
ccc      LN(:LW+1) = '(" RMS:'//LN(7:LW); LW = LW+1
        LN(:LW) = '("     RMS:  '//LN(16:LW)//'      '
        WRITE(IX,LN(:LW))
ccc        WRITE(IX,LN(:LW)) CLN(A1(1,NF+1),LDD-2,LD),  ! shows RMS communality
     +    ((CLN(A1(1+KBL(IB,J),NF+1),5,2),J=1,KBL(IB,0)),IB=0,NB1),
     +    (CLN(A1(1+J,NF+1),5,2),J=NF-KBL(-1,0)+1,NF)
      ELSE IF(QBY) THEN   ! Only if LD = 3
        LN(:46) = '("      RMS:  "'//FMT2(18:48)
        WRITE(IX,LN(:45)) (CLN(A1(1+J,NF+1),LDD,LD),J=1,NF)
      ELSE
        WRITE(IX,FMT2) CLN(A1(1,NF+1),LDD-2,LD), (CLN(A1(1+J,NF+1),
     +    LDD,LD),J=1,NF)
      END IF
      IF(IX==6) CALL WAIT(0)
      IF(OBQ(C1,0)<.001) THEN
        WRITE(IX,'(/" The factors are orthonormal.")')
        I = -99; GOTO 31
      END IF
C      FMT2 = '(" Factor",I3,"."'//FMT1(7:)
      FMT2 = '(" Factor",I3,"."'//FMT2(18:)
      WRITE(IX,'(/" with corresponding factor correlations")')
      IF(QBX) THEN
        DO IB = 0,NB1
          IF(KBL(IB,0)>0) A1(KBL(IB,KBL(IB,0))+1,NF+3) = 10.
        END DO
        IF(KBL(-1,0)>0) A1(KBL(NB,KBL(NB,0))+1,NF+3) = 10.
      END IF
      DO I = 1,NF
        IF(.NOT.QBB .AND. MOD(I-1,5)==0) WRITE(IX,'()')
        IF(QBB.AND.(I==1.OR.A1(I,NF+3)>9.)) WRITE(IX,'()') ! A1(_,NF+3) flags block spacing
        IF(QBX) THEN  ! Can't use pattern format for triangular Covar display
          NN = 1
          DO IB = 0,NB1
            IF(KBL(IB,0)==0) CYCLE
            DO JJ = 1,KBL(IB,0)
              J = KBL(IB,JJ)
              LN(NN:NN+10) = CLN(C1(I,J),5,2)//'     '  ! Need cleaning at line's end
              NN = NN+5
              IF(J>=I) GOTO 55
            END DO
            NN = NN+KS   ! KS is extra space between blocks defined above
          END DO
          DO JJ = 1,KBL(-1,0)  ! Waifs
            J = KBL(-1,JJ)
            LN(NN:NN+10) = CLN(C1(I,J),5,2)//'     '  ! Need cleaning at line's end
            NN = NN+5
            IF(J>=I) GOTO 55
          END DO
55        WRITE(IX,'(" Factor",I3,".  ",A)') I, LN(:NN)
        ELSE
          WRITE(IX,FMT2) I, (CLN(C1(I,J),LDD,LD),J=1,I)
        END IF
        IF(IX==6 .AND. MOD(I,10)==0 .AND. I<NF-1) CALL WAIT(0)
      END DO
31    IF(IX==6 .AND. I>5 .AND. I<10) CALL WAIT(1)
      END SUBROUTINE
C
      SUBROUTINE SHOWB(NF,NB,FIX,FIX1,QB,KF)
C This prints to file KF the factor blocks and their dependency structure.
C Q > 0 signals that not all Z-factors are waifs.
      LOGICAL QB
      CHARACTER WORD*30, CH1*2, CH2*2, FMT1*90, FMT2*90, BN, TR
      INTEGER FIX(*), FIX1(*), KBL(-1:NB+1,0:NF)
      COMMON /TTR/ KR, KND, NLD
      KR = KND + (NLD-KND)*MIN(ABS(KF-6),1) ! equals KND/NLD if KFILE is/isn't 6
CCC      DO I = -1,NB+1
CCC        KBL(I,0) = 0
CCC      END DO
      KBL = 0; N1 = 0
      DO I = 1,NF
        IF(FIX(I)/=99) N1 = N1+1  ! N1 is number of factors not in block Y
        IB = MIN(FIX(I),NB+1)
        KBL(IB,0) = KBL(IB,0)+1
        KBL(IB,KBL(IB,0)) = I
      END DO
C       If any items have FIX code 99, row NB+1 of KBL will be nonempty.
      IF(N1==KBL(-1,0)+KBL(0,0)) THEN  ! If blocks A-W are empty
        WRITE(KF,'()')
        IF(N1==0) THEN
          IF(KF/=6) WRITE(KF,'(" Location constraints on this ",
     +      "rotation: None")')
          IF(KF==6) WRITE(6,'(/" All factors are now in fully-de",
     +      "pendent block Y.")')
          RETURN
        END IF
        IF(KBL(0,0)>0) THEN
          IF(KF/=6) WRITE(KF,'(" Factors constrained in this rot",
     +      "ation to be global sources (block X):")')
          IF(KF==6) WRITE(KF,'(" Factors now set to be global ",
     +      "sources (block X):")')
          WRITE(KF,'(4X,50I3)') (KBL(0,I),I=1,KBL(0,0))   ! $$$$$$$ Wrong index
        END IF
        IF(KBL(-1,0)>0) THEN
          IF(KF/=6) WRITE(KF,'(" Factors set aside in this rot",
     +      "ation as isolates (block Z):")')
          IF(KF==6) WRITE(KF,'(" Factors now set aside as iso",
     +      "lates (block Z):")')
          WRITE(KF,'(4X,50I3)') (KBL(-1,I),I=1,KBL(-1,0))
        END IF
        WRITE(KF,'(" All other factors are unconstrained (block Y)")')
        RETURN
      END IF
      MBB = MAX(8,2*((NB+1)/2))
      M = (MBB-6)/2
C       MAX(8,...) in MBB insures that M is at least 1
      CH1 = CHAR(48+M/10)//CHAR(48+MOD(M,10))
      MM = 0
      DO I = -1,NB
        MM = MAX(MM,KBL(I,0))
      END DO
      NL = KBL(NB+1,0)
      IF(NL<(65-MBB)/3) NN = MAX(30,3*MAX(MM,NL))
      IF(NL>=(65-MBB)/3) NN = MAX(30,3*MM)
      CH2 = CHAR(48+NN/10)//CHAR(48+MOD(NN,10))
      IF(KF/=6) WRITE(7,'(/" Rotation constraints were imposed by",
     +  " the following block structure.")')
      IF(KF==6) WRITE(6,'(/" Here is the current structure of your",
     +  " factors'' location constraints.")')
      WRITE(KF,'(" A block''s factors can rotate only in the sub",
     + "space of their DepOn blocks.")')
      FMT1 = '(/"  Block  ",'//CH1//'(" "),"DepOn ",'//
     +  CH1//'(" "),"   Indices of factors in block")'//'       '
      IF(KR>0) CALL TRLIN(FMT1(:90))
      WRITE(KF,FMT1)
      FMT1 = '(" ",'//CH1//'(""),"",'//CH1//'(""),
     +  "",'//CH2//'(""))'//'                         '
      IF(KR>0) CALL TRLIN(FMT1(:90))
      WRITE(KF,FMT1)
      FMT2 = '(4X,A,3X,"'//TR('')//'",1X,A,"'//TR('')//'",50I3)'//
     +  '                                  '
      IF(KBL(0,0)>0) THEN
        WORD(:30) = '                              '
        WORD(M+2:M+5) = 'none'
        WRITE(KF,FMT2) 'X', WORD(:MBB), (I,I=1,KBL(0,KBL(0,0)))
      END IF
      DO IB = 1,NB
        WORD(:30) = '                              '
        KW = MIN(1,KBL(0,0))
        IF(KW>0) WORD(1:1) = 'X'
        K = FIX1(IB)    ! FFFF
        DO I = 1,IB-1
          IF(MOD(K,2)>0) THEN
            KW = KW+1
            WORD(KW:KW) = BN(I)
          END IF
          K = K/2
        END DO
        WORD(KW+1:KW+1) = BN(IB)
        WRITE(KF,FMT2) BN(IB), WORD(:MBB), (KBL(IB,J),J=1,KBL(IB,0))
      END DO
      NL = KBL(NB+1,0)
      IF(NL<=0) GOTO 35
      WORD(:9) = '"all   ",'
      IF(KBL(-1,0)>0) WORD(:9) = '"all*  ",'
      IF(NL*3>NN) THEN
        FMT2 = '(4X,"Y    ",'//CH1//'(" "),'//WORD(:9)//CH1//
     +    '(" "),"  all remaining factors"'//WORD(5:5)//')        '
        IF(KR>0) CALL TRLIN(FMT2(:90))
        WRITE(KF,FMT2)
      ELSE
        FMT2 = '(4X,"Y    ",'//CH1//'(" "),'//WORD(:9)//CH1//
     +    '(" "),"",50I3)'//'                  '
        IF(KR>0) CALL TRLIN(FMT2(:90))
        WRITE(KF,FMT2) (KBL(NB+1,J),J=1,NL)
      END IF
35    IF(KBL(-1,0)>0) THEN
        WORD(:5) = '  Z  '
        IF(QB) WORD(:5) = 'Waifs'
        FMT2 = '(2X,A,"  ",'//CH1//'(" "),"none  ",'//
     +    CH1// '(" "),"",50I3)'//'                  '
        IF(KR>0) CALL TRLIN(FMT2(:90))
        WRITE(KF,FMT2) WORD(:5), (KBL(-1,J),J=1,KBL(-1,0))
      END IF
      CALL SUBST(FMT1,TR(''),TR(''))
      WRITE(KF,FMT1)
      CH2 = '  '; IF(KBL(-1,0)>0) CH2 = 's '
      IF(KBL(-1,0)>0 .AND. NL>0) THEN
         WORD(:13) = 'Z-isolate'//CH2//'  '
         IF(QB) WORD(:13) = 'Waif factor'//CH2
         WRITE(6,'(10X,"*Excepting the ",A)') WORD(:12)
      END IF
      END SUBROUTINE

      SUBROUTINE SORT(N,ARR)
C Sort real or integer list ARR into increasing order.
C      REAL ARR(*)
      INTEGER ARR(*), A
      DO J = 2,N
        A = ARR(J)
        DO I = J-1,1,-1
          IF(ARR(I)<=A) GOTO 10  ! Increasing order
          ARR(I+1) = ARR(I)
        END DO
        I = 0
10      ARR(I+1) = A
      END DO
      RETURN
      END
C
      SUBROUTINE SPIN(A1,T1,C1,CG,FIX,PFIX,NPFIX,KTL,COMM,NTOT,NN,
     +           IMAX,LMP,LG,MAXSPN,W,CH6)
C Give factor pattern in A1 a random rotation and/or align some axes with
C selected variables. If all or in part random, repeat NSPN times, save all
C in scratchfile 17, then add the NSAV best distinct ones to HYBUF.
C NOTE: MAXSPN (= 99) limits number of saved spins but not total allowed.
      PARAMETER (MRR=100, MREC=200)
      CHARACTER CH, CLN*8, CH3*3, TR, CF*12, C18*18, CH6*6
      INTEGER FIX(*), KTL(MF,*), LMP(*), PFIX(*), RR(MRR), LST1(NF),
     +        LST2(NF)    ! LST1,LST2 are local arrays.
      REAL LOSS, A1(MV,0:*), T1(MV,*), C1(MF,*), CG(*), COMM(*), W(*),
     +     OBLST(MAXSPN)  ! Must have MRR  MAXSPN < 100
      EXTERNAL SCAN
      COMMON  NV, NF, MV, MF
      COMMON /BL2/ LIM, CV, PD1, MODE, GAM
      COMMON /BL3/ BH, JA, JB, CV1, ADD, R0, R1, WSAL
      COMMON /BL7/ JFLAG, NSPN, KNV, TT, ICYC
      COMMON /CF/ CF
      SAVE MSPN, NUFF, FOB, GAP  ! Passed in scratchfile
      SAVE CMAX, NSAV, RN, MKT, KFLG, LFLG
      DATA CMAX,GAP,RN,NSAV,MKT,MSPN/.75,5.,.4,10,2*100/, KFLG,LFLG/2*1/
C       LG = 0/1 calls Lump over all HYBUF records/just over new ones.
C       NUFF = NINT(MSPN*RN).  {J,K,L}FLG = 0 suppresses an option.
      LO(I,J) = J*(J-1)/2 + I
      WRITE(6,'(/4X,"You are now in SPIN mode, which allows you to a",
     +  "lign some factors with"/4X,"selected variables (if no patte",
     +  "rn fixations are active) and randomly"/4X,"reposition the ",
     +  "rest.  SPIN will repeatedly rotate random starts of the"/4X,
     +  "movable factors under the present control parameters until",
     +  " your chosen"/4X,"stopping criterion has been reached."/)')
      WRITE(6,'(/8X,80A)') TR(''), (TR(''),I=1,59), TR('')
      WRITE(6,'(8X,A,6X,"Before launching SPIN for a large number of",
     +  " Tries,   ",A/ 8X,A," give thought to whether the rotation ",
     +  "controls currently   ",A/8X,A," active are what you want he",
     +  "re.  To review or alter these, ",A/8X,A," enter anything fo",
     +  "r return to the Main Menu and access to  ",A/8X,A," its Opt",
     +  "ion 1. Otherwise, hit RETURN to continue.",10X,A)')
     +  (TR(''),I=1,10)
      IF(MODE==2.OR.MODE==3) WRITE(6,'(8X,A,6X,"WARNING: Brute-force",
     +  " Scanning, your present choice,  ",A/8X,A," is considerably",
     +  " slower than Step-down Regression.",9X,A)') (TR(''),I=1,4)
      IF(NPFIX>0) WRITE(6,'(8X,A,6X,"WARNING: Pattern fixations are ",
     +  "currently in force.   ",A/8X,A," To remove these, return to",
     +  " to Main Menu and call Option 9.   ",A)') (TR(''),I=1,4)
      WRITE(6,'(8X,80A)') TR(''), (TR(''),I=1,59), TR('')
      WRITE(6,'(//)')
      CALL SCAN(JJ,0,'B',5)
      IF(JJ<0) RETURN
      N99 = 0; NCNV = 0; IMX = IMAX; OBLST = -1.
30    NA = 0    ! Count item-aligned factors
      NFREE = 0
      IF(KFLG==0) GOTO 31
      WRITE(6,'(/" The maximum correlation allowed between any Spin-",
     +  "repositioned factors"/" is now set at",A4,". Hit RETURN if ",
     +  "OK, or enter new obliquity limit.")') CLN(CMAX,4,2)
      WRITE(6,'(" To suppress this option on subsequent SPIN calls, ",
     +  "enter numeric zero.  ")')
      WRITE(6,'(" (Entering any letter returns to Main Menu.)"/)')
      CALL SCAN(J,1,'R',5)
      IF(J==0) GOTO 31
      IF(J<0) RETURN
      READ(2,*) X
      KFLG = INT(10*X)
      IF(KFLG==0) GOTO 31
      DO WHILE (X>.999); X = X/10; END DO
      CMAX = MAX(.1,MIN(.99,X))
      GOTO 30
31    MKT = 100*(10-INT(10*CMAX))
      DO I = 1,NF
        IF(FIX(I)>100) THEN  ! FIX-value over 100 flags alignment with item
          NA = NA+1 ! NA is count of received alignments
          LST1(NA) = I  ! Alignments will default to old list
          FIX(I) = 99   ! Only unconstrained factors can be item-aligned
        END IF
        IF(FIX(I)==99) THEN
          N99 = N99+1   ! Number of unconstrained factors
          RR(N99) = I   ! List of factors free for alignment with item
        END IF
        IF(FIX(I)>0) NFREE = NFREE+1  ! Number that can be moved at all
      END DO
      JFIX = NA   ! Flags part of exit message
      IF(JJ/=0) GOTO 505  ! Exit with message
      DO I = 1,NF
        T1(I,NF+1) = 1.*FIX(I)   ! Save old FIX without alignments with items
      END DO
C Select variables for axis positions; disallowed by any received pattern fixation
      IF(NPFIX>0 .OR. LFLG==0 ..OR. N99==0) GOTO 20
10    IF(NA<=0) THEN
        WRITE(6,'(/" To pick some variables as fixed factor positi",
     +    "ons during Spin rotation, enter"/" indices of up to ",A,
     +    " anchor variables.  Otherwise, hit RETURN to randomly"/
     +    " shift all movable axes at start of each Spin try, or any",
     +    " letter to abort.")') CF(:JF(N99))
        WRITE(6,'(" (To suppress this option on subsequent SPIN cal",
     +    "ls, enter numeric zero.)  "/)')
      ELSE
        WRITE(6,'(/" The variables now selected to be fixed factor ",
     +    "positions are",10(:/20(1X,A)))') (CF(:JF(LST1(I))),I=1,NA)
        WRITE(6,'(" Hit RETURN if OK.  Otherwise, enter revised list",
     +    " or any letter to start again."/)')
      END IF
      CALL SCAN(L,0,'I',5)
      IF(L==0) GOTO 16
      IF(L<0 .AND. NA<=0) GOTO 505
      IF(L<0) NA = -NA
      IF(L<0) GOTO 10
      READ(2,*) (LST1(I),I=1,L)
      LFLG = LST1(1)
      IF(LFLG==0) GOTO 16
      NA = 1
      LPA: DO J = 2,L
        IX = LST1(J)
        IF(IX<1 .OR. IX>NV) CYCLE LPA
        DO I = 1,J-1
          IF(IX==LST1(I)) CYCLE LPA
        END DO
        NA = NA+1
        LST1(NA) = IX
      END DO LPA
C       FIX items are in received order after removal of inacceptable entries
      NA = MIN(NA,N99)
      DO I = 1,NA
        IF(COMM(LST1(I))<.1) WRITE(6,'(" The communality of var",
     +    "iable ",A," is only",A4,"; not a good choice.")')
     +    CF(:JF(LST1(I))), CLN(COMM(LST1(I)),4,2)
      END DO
      GOTO 10
16    DO I = 1,NA
        FIX(RR(I)) = LST1(I) + 100
      END DO
      N99 = N99-NA
20    IF(NFREE==NA) GOTO 51  ! No Spin if all factors are item-aligned.
40    WRITE(6,'(/" This Spin run is now set for limit ",A," on num",
     +  "ber of Tries.  Hit RETURN if OK."/" Otherwise, enter new ",
     +  "Try limit or any letter for return to Main Menu."/)')
     +  CF(:JF(MSPN))
      CALL SCAN(J,1,'I',5)
ccc      IF(J==0) GOTO 42   ! Probably won't ever again want timed breaks
      IF(J==0) GOTO 45
      IF(J<0) GOTO 505
      READ(2,*) MSPN
CC      MSPN = MAX(1,MIN(MAXSPN,MSPN))  ! Don't need limit this small
      MSPN = MAX(1,MIN(9999,MSPN))
      GOTO 40
ccc42    IF(JFLG==0) GOTO 45
ccc      WRITE(6,'(/" You may set the run for breaks at timed inter",
ccc     +  "vals to permit discontinuation.")')
ccc43    IF(TMX>0.) WRITE(6,'(" Timed breaks are now set for every ",
ccc     +  A," minutes.  Hit RETURN if OK;"/" otherwise, enter new ",
ccc     +  "break length or any letter to waive timed breaks."/)')
ccc     +  CF(:JF(NINT(TMX)))
ccc       WRITE(6,'(" (To suppress this option on subsequent SPIN cal",
ccc     +   "ls, enter numeric zero.)  ")')
ccc      IF(TMX<=0.) WRITE(6,'(" Timed breaks are now waived.  Hit ",
ccc     +  "RETURN if OK, or enter break length"/" in minutes."/)')
ccc      CALL SCAN(J,1,'R',5)
ccc      IF(J==0) GOTO 45
ccc      IF(J<0) TMX = -1.
ccc      IF(J>0) READ(2,*) TMX
ccc      JFLG = NINT(TMX)
ccc      IF(JFLG==0) GOTO 45
ccc      TMX = MAX(-1.,MIN(48*60.,TMX))
ccc      GOTO 43
45    WRITE(6,'(/" You may also set the Spin run to stop when ",
     +  "NUFF successive Tries have failed"/" to improve on this",
     +  " series'' best."/)')
      NUFF = NINT(MSPN*RN)
46    IF(NUFF>0) WRITE(6,'(" To stop after ",A," successive im",
     +  "provement failures, hit RETURN.  Otherwise,"/" enter new",
     +  " NUFF count or any letter to waive this stop option."/)')
     +  CF(:JF(NUFF))
      IF(NUFF<=0) WRITE(6,'(" Stopping after a set number NUFF of",
     +  " improvement failures is now waived."/" Hit RETURN if OK,",
     +  " or enter NUFF count."/)')
      CALL SCAN(J,1,'I',5)
      IF(J==0) GOTO 50
      IF(J<0) NUFF = -1
      IF(J>0) READ(2,*) NUFF
      NUFF = MAX(-1,MIN(MSPN,NUFF))
      RN = NUFF*1./MSPN
      GOTO 46
50    WRITE(6,'(/" If you want to review your Spin controls, ent",
     +  "er anything.  Otherwise,"/" hit RETURN to start Spin ",
     +  "production.  (Good luck!)")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 30
C Update KTL with item-fixed axes
51    IF(NA>0) THEN
        NFIX = NFIX+NA
        DO I = 1,NF
          DO J = 1,NF
            IF(FIX(I)>100 .AND. I/=J) KTL(I,J) = 0
          END DO
        END DO
      END IF
      KRY = 0
      NSPN = 0
      LUFF = -1

C TEST LINES   ! Save code in case problems reappear
C      CALL QUIZ(A1,C1,NN,ERR,1)
C      IF(ERR>.01) THEN
C        OPEN(23,FILE='ERRORS')
C        WRITE(23,'(" Spin receives rotation No.",I3," with Chh-reprod",
C     +    "uction error",A6)') NN, CLN(ERR,6,2)
C      END IF

C  Recompute the minimal previous Loss under current rotation parameters
      REWIND 19 ! Save received pattern/covars as backup
      WRITE(19) ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF)
      REWIND 8
      READ(8)
54    READ(8,END=55) N, ((A1(I,J),I=1,NV),J=1,NF)
      IF(N==1) HMIN = LOSS(A1)
      IF(N>1) HMIN = MIN(HMIN,LOSS(A1))
      GOTO 54
55    XX = 1000/HMIN
      REWIND 19    ! Retrieve received A1 (C1 should still be same)
      READ(19) ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF)
CC      T = TM(1) ! *** If reinstated, fix this to let TM continue accumulating
C       Initialize timer for timed breaks
ccc      INQUIRE(17,OPENED=QS); IF(QS) CLOSE(17)  ! Grasping at straws !!!
      OPEN(17,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +  RECL=4*(NV*NF+NF*NF+4))
99    PR = .25; NIX = 0
C Start another SPIN try
100   KRY = KRY+1; KBLAB = 1; KOUNT = 0
      DAMP = 1.          !  Only relevant if FIXs
101   JORTH = MIN(1,INT(RAN3()/PR)); IF(MSPN==1) JORTH = 0
C       JORTH = 0 with probability PR; calls pre-orthogonalization if no FIXs
      DAMP = JORTH*DAMP; GOTO 110    ! ^ Now also calls orthogonal spun factors

C TEST LINES (Probably permanent)
109   REWIND 19  ! A1 corrupted, so reload spin start
      READ(19) ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF)

110   KOUNT = KOUNT + 1
      DAMP = DAMP*.8
      IF(KBLAB==0) WRITE(6,'(/" Repeating ROTATE call from random",
     +  "ized start No. ",A," in this Try.")') CF(:JF(KOUNT))
      IF(KOUNT>MKT) GOTO 240
C Randomize the factor order
      LST2 = (/(J,J=1,NF)/)
      DO J = NF,2,-1   ! Randomize the order in LST2(...)
        N = MAX(1,MIN(J,NINT(.5+J*RAN3())))  ! Pick index from 1st J in LIST
        I = LST2(J)
        LST2(J) = LST2(N)
        LST2(N) = I
      END DO
      IF(N99<NF) THEN  ! If any FIXs, order factors in ascending block order
        DO J = 1,NF
          LST2(J) = LST2(J) + J*1000 + MAX(0,FIX(LST2(J)))*10000
        END DO
        CALL SORT(NF,LST2)
        DO J = 1,NF
          LST2(J) = MOD(LST2(J),1000)
        END DO
      END IF
C Generate raw rotation matrix
      BIGA: DO I1 = 1,NF
        I = LST2(I1)
        IF(FIX(I)<=0) THEN
          DO J = 1,NF
            T1(I,J) = 0.
          END DO
          T1(I,I) = 1.
        ELSE IF(FIX(I)>100) THEN   ! Allowed only if PFIX is empty.
          K = FIX(I)-100
          S = 0.
          DO J = 1,NF
            S = S + A1(K,J)**2
          END DO
          S = SQRT(MAX(S,1.E-8))
          DO J = 1,NF
            T1(I,J) = A1(K,J)/S  ! A(k,-)*F gets F-space axis aligned with K's common part
          END DO
        ELSE
          DO J = 1,NF    ! Order not relevant
            T1(I,J) = KTL(I,J)*(RAN3()-.5)
            IF(KTL(J,I)==0) T1(I,J) = T1(I,J)*DAMP   ! Shd only occur if row J already randomized
            IF(PFIX(J)/=0) T1(I,J) = 0.
          END DO
          IF(PFIX(I)/=0) T1(I,I) = 1.
          S = 0.
          DO J = 1,NF    ! Order not relevant
            S = S + T1(I,J)**2
          END DO
          S = SQRT(MAX(S,1.E-8))
          DO J = 1,NF
            T1(I,J) = T1(I,J)/S
          END DO
C           Note: When T1 is to be block diagonal, it can be orthogonal only if
C                 it is block-diagonal under that blocking.  DAMPing above makes
C                 T1 approach block-diagonality; however, orthogonality created
C                 immediately below is not now implemented for blocked patterns.
          IF(NF<N99) CYCLE BIGA
C       Partial out previously norm'd rows correlating too highly with this one
C       NEW: Also orthogonalize T1 when JORTH = 0 to yield pattern on orthonormal axes
          BIGB: DO K1 = 1,I1-1    ! Order relevant here
            K = LST2(K1)
            IF(PFIX(K)/=0) CYCLE
            R = 0.
CC            S = 0.
            DO J = 1,NF
              R = R + T1(I,J)*T1(K,J)
CC              IF(KTL(I,J)/=0) S = S + T1(K,J)*T1(K,J) ! Restriction is foolish,
            END DO
CC            IF(S<1.E-8) CYCLE BIGA        ! especially when I is an X-set item.
C            IF(ABS(R)<=CMAX-.02*KOUNT) CYCLE BIGB  ! Decrease probably needless
            IF(ABS(R)<=CMAX-.02*KOUNT .AND. JORTH/=0) CYCLE BIGB
            IF(PFIX(I)/=0) THEN
              DO J = 1,NF
                T1(I,J) = 0.
              END DO
              T1(I,I) = 1.
              CYCLE BIGA
            END IF
            R = R/S   ! Start making T1(I,-) orthogonal to preceding cols
            S = 0.
            DO J = 1,NF
              IF(KTL(I,J)/=0 .AND. KTL(K,J)/=0) T1(I,J) = T1(I,J) -
     +          R*T1(K,J)  ! Residual of regression of T1(I,-) on T1(K,-)
              S = S + T1(I,J)**2
            END DO
            IF(S<.0001) GOTO 110
            S = SQRT(S)
            DO J = 1,NF
              T1(I,J) = T1(I,J)/S
            END DO
          END DO BIGB
        END IF
      END DO BIGA
C With probability PR, attach pre-spin orthogonalization of the current factor
C correlations to the raw spin rotation matrix:  If JORTH=0 and all factors are
C unconstrained, postmultiply T1 by inverse of C1's lower-triangle Gram-factor.
      IF(JORTH==0 .AND. N99==NF) THEN
        DO J = 1,NF
          DO I = 1,J
            CG(LO(I,J)) = C1(I,J)
          END DO
        END DO
        CALL INVF(CG,NF,IER)  ! Scarcely ever fails
        IF(IER>0) WRITE(6,'(" Will try another randomization.")')
        IF(IER>0) GOTO 110
        DO I = NF,1,-1
          DO J = 1,NF
            S = 0.
            DO K = J,NF
              S = S + T1(I,K)*CG(LO(J,K))
            END DO
          T1(I+1,J) = S
          END DO
        END DO
        DO I = 1,NF
          DO J = 1,NF
            T1(I,J) = T1(I+1,J)
          END DO
        END DO
      END IF

C Scale rotation matrix to yield normalized factors
      DO I = 1,NF
        S = 0.0
        DO J = 1,NF
          DO K = 1,NF
            S = S + T1(I,J)*C1(J,K)*T1(I,K)
          END DO
        END DO
        IF(S<1.E-8) GOTO 110        ! Scarcely ever
        CG(I) = SQRT(S)
      END DO
      DO I = 1,NF
        DO J = 1,NF
          T1(I,J) = T1(I,J)/CG(I)
        END DO
      END DO
C Compute rotated factor correlations and guard against factor collapse
      BIG = 0.0
      DO I = 1,NF
        CG(LO(I,I)) = 1.0
        DO J = I+1,NF
          S = 0.0
          DO K = 1,NF
            DO L = 1,NF
              S = S + T1(I,K)*C1(K,L)*T1(J,L)
            END DO
          END DO
          CG(LO(I,J)) = S
          IF(FIX(I)>99.AND.FIX(J)>99.AND.ABS(S)>CMAX) THEN
             WRITE(6,'(/" The common-parts correlation between var",
     +         "iables ",A," and ",A,", namely",A5,","/" exceeds ",
     +         "your limit on factor correlations.  Either raise ",
     +         "limit or remove at"/" least one of these variables",
     +         " from the set selected as factor positions.")')
     +         CF(:JF(LST1(I))), CF(:JF(LST1(J))), CLN(S,5,2)
            KFLG = 1
            GOTO 30
          END IF
          IF(KTL(I,NF+1)>1.OR.KTL(J,NF+1)>1) BIG = MAX(BIG,ABS(S))
        END DO
      END DO
      IF(BIG>=CMAX) THEN
        IF(KOUNT>MKT/2) JORTH = 0
        GOTO 110                      ! Occurs occasionally
      END IF
      DO J = 1,NF     ! ****** First change in C1
        DO I = 1,J
          C1(I,J) = CG(LO(I,J))
        END DO
      END DO
C         Upper triangle of C1 holds the new factor correlations while its
C         lower triangle still retains the old ones.  Invertibility of new C1
C         can now be checked by applying INVF to CG.
      CALL INVF(CG,NF,IER)
      DO I = 2,NF
        DO J = 1,I-1
          IF(IER>0) C1(J,I) = C1(I,J)
          IF(IER==0) C1(I,J) = C1(J,I)
        END DO
      END DO
      IF(IER>0) GOTO 110            ! Occurs occasionally
C   Invert factor-rotation matrix to get pattern-rotation matrix,
C   reflecting factor axes if appropriate.
165   CALL MINV(NF,T1,MV,IER)
      IF(IER/=0) GOTO 110            ! Scarcely ever
      NF2 = NF+2
      DO J = 1,NF
        CG(J) = 0.
      END DO
      DO I = 1,NV
        DO J = 1,NF
          SIJ = 0.
          DO K = 1,NF
            SIJ = SIJ + A1(I,K)*T1(K,J)
          END DO
          CG(J) = CG(J) + SIJ
C           CG(J) will show whether factor J loadings are mainly positive
          T1(NF2,J) = SIJ
C           T1(NF2,_) holds new row of A1 until the old row is no longer needed
        END DO
        DO J = 1,NF             ! ******* 1st change in A1
          A1(I,J) = T1(NF2,J)
        END DO
      END DO
      S = 1.
      DO J = 1,NF
        CG(J) = SIGN(1.,CG(J))
        IF(FIX(J)<=0) CG(J) = 1.
        S = MIN(S,CG(J))
      END DO
      IF(S>=0.) GOTO 170
      DO J = 1,NF
        IF(CG(J)>=0) CYCLE
        DO I = 1,NV               ! 2nd change in A1
          A1(I,J) = CG(J)*A1(I,J)
        END DO
      END DO
      DO J = 1,NF
        DO I = 1,NF
          C1(I,J) = CG(I)*CG(J)*C1(I,J)  ! 2nd change in C1
        END DO
      END DO
170   CALL CHEK(IER,NV,NF,A1(1,1)) ! Check for outlandish loadings

C TEST LINES ! Save code in case problems reappear
c      CALL QUIZ(A1,C1,NN,ERR,1)
c      IF(ERR>.01) THEN
c        OPEN(23,FILE='ERRORS')
c        WRITE(23,'("     At SPIN location 170, Chh-reproduction ",
c     +    "error is",A5)') CLN(ERR,5,2)
c        GOTO 109
c      END IF

      IF(OBQ(C1,1)>CMAX) IER = IER+2
      IF(IER>0) GOTO 109  ! Reinstate input pattern/covars (not infrequent)

C Rotate SPIN-initiated pattern, or save and return if all axes are fixed.
      IF(NA==NFREE) GOTO 400
      IF(KBLAB==1) WRITE(6,'(/" Commencing Spin try ",A,"; after ",
     +  "that, ",A," more.")') CF(:JF(KRY)),CF(:JF(MSPN-KRY))
      KBLAB = 0; NF2 = NF*NF;IER = -1  ! Signal that call is from SPIN
      CALL ROTATE(KTL,A1,C1,W,T1,CG,W(NF2+1),W(NF2+NF+1),FIX,PFIX,
     +       WSAL,IER); ICYC = -IER
C       ROTATE need W(NF,NF), DE(NF) = W(NF+1), DG(NF) = W(NF+NF+1)
      IF(IER>0 .OR. OBQ(C1,1) >CMAX) THEN
        NIX = NIX+1; GOTO 101
      END IF
      R = LOSS(A1)   ! All LOSS arguments except A1 are in common blocks
      IF(NSPN<MAXSPN) THEN   ! NSPN is number of saved Tries, limit MAXSPN
        NSPN = NSPN+1; NOK = NSPN
        NR = NSPN
      ELSE
        CALL SORT(NSPN,RR); NOK = NOK+1
        NR = MOD(RR(NSPN),100)   ! Pick rec index out of end-of-RR entry
      END IF
      RR(NSPN) = NR + 100*NINT(R*XX)
      IF(NSPN==1) RMIN = R
      LUFF = LUFF+1; IF(R<RMIN) LUFF = 0
      IC = IMAX; IF(IER<0) IC = -IER
      IF(NSPN>1) WRITE(6,'(" In proportion to best in this series, mi",
     +  "sfit rating after",I3," cycles is ",A6)') IC, CLN(R/RMIN,6,3)
      WRITE(6,'(" Number of Tries since series'' best: ",A)')
     +  CF(:JF(LUFF))
      RMIN = MAX(1.E-6,MIN(RMIN,R))
      WRITE(17,REC=NR) ((A1(I,J),I=1,NV),J=1,NF),((C1(I,J),I=1,NF),
     +  J=1,NF), TT, ICYC
      OBLST(NR) = OBQ(C1,1)
      NCNV = NCNV + KNV
      IF(NUFF>0 .AND. LUFF>=NUFF) THEN
        WRITE(6,'(/" Calling off Spin search; no further improvemen",
     +    "ts in ",A," Tries.")') CF(:JF(NUFF))
        GOTO 241
CC     ELSE IF(TMX>0 .AND. TM(0)/60>TMX) THEN
CC       T = TM(1)/60
CC       WRITE(6,'(/" Break after ",A," minutes.  Compared to the ",
CC    +    "best solution in Hybuf store,"/" the best so far in the",
CC    +    " current Spin series, obtained ",A," Tries previously"/
CC    +    ", has relative misfit",F5.2)') CF(:JF(NINT(T))),
CC    +    CF(:JF(LUFF)), RMIN/HMIN
CC       WRITE(6,'(/" Hit RETURN to continue for another ",A,
CC    +    " minutes.  Otherwise, enter anything"/" to quit Spin",
CC    +    " production and process the ",A," current Try results",
CC    +    " in hand.")') CF(:JF(NINT(TMX))), CF(:JF(NSPN))
CC       CALL SCAN(J,1,'B',5)
CC       IF(J/=0) GOTO 241
      END IF
      IF(KRY<MSPN) GOTO 100
C
C Spin collection is complete; next, sort indices in order of quality.
C File-17 index is last two digits following quality rating in RR.
240   IF(NSPN<=1) GOTO 500   ! This branch should be unnecessary.
      IF(KOUNT>MKT) WRITE(6,'(/" Failure of randomization to gen",
     +  "erate axes not verging on factor collapse"/" ends SPIN se",
     +  "arch after ",A," successful tries.")') CF(:JF(NSPN-1))
241   WRITE(6,'(/1X,A," Spin solutions are in hand; now pick the ",
     +  "ones to save.")') CF(:JF(NSPN))
      LUFF = JFLAG+(1-JFLAG/100000)*100000  ! Put 1 in 6th digit of JFLAG
      NOLD = NTOT  ! No longer any point to distinguishing NTOT from NOLD ???
      CALL SORT(NSPN,RR)
      LL = 40; N = MIN(LL,NSPN)
      OB = 0.;
      DO I = 1,NSPN
        IF(OBLST(I)>OB) THEN
          OB = OBLST(I); KOB = I
        END IF
      END DO  ! Largest obliquity is OB in pattern KOB
      WRITE(6,'(/" Expressed as proportions of the stored best, the ",
     +  A," smallest misfit ratings"/" in this collection of Spin ",
     +  "tries (NOT yet GAP-filtered) are"/6(2(2X,5F7.3),:/))')
     +  CF(:JF(N)), (RR(I)*.00001,I=1,N)
ccc      IF(NSPN==MAXSPN .AND. NSPN<=LL) WRITE(6,'(" (This is the ",
ccc     +  "complete list; lack of scratch space has precluded saving ",
ccc     +  "more.)")')
ccc      IF(NSPN==MAXSPN .AND. NSPN>LL) WRITE(6,'(" (Only the best ",
ccc     +  A," Tries have been saved.) ")') CF(:JF(NSPN))
      WRITE(6,'(/" The largest obliquity, in pattern ",A,", is ",A4)')
     +  CF(:JF(KOB)), CLN(OB,4,2); FOB = CMAX
180   WRITE(6,'(" To filter out patterns whose obliquity exceeds ",A4,
     +  ", hit RETURN."/" Otherwise, enter another limit on accepta",
     +  "ble obliquity."/)') CLN(FOB,4,2)
      CALL SCAN(J,1,'R',5)
      IF(J==0) GOTO 182
      IF(J<0) GOTO 180
      READ(2,*) FOB; FOB = MAX(.2,FOB)  ! **** Use smallest in store for min??
181   IF(FOB>1.) THEN; FOB = FOB/10; GOTO 181; END IF
      GOTO 180
182   NSAV = MIN(NSAV,NSPN,MREC-NTOT); GPP = ABS(GAP)
      WRITE(6,'(/" The NSAV best of these that are distinct from one ",
     +  "another by at least GAP"/" degrees of congruence divergence ",
     +  "either on at least one factor or, if you"/" prefer, averaged",
     +  " over all factors, will be saved in Hybuf store.")')
184   WRITE(6,'(/" <NSAV, GAP> are now <",A,", ",A3,A,">. Hit RETURN",
     +  " if OK.  Otherwise, enter either"/" preferred pair or just ",
     +  "one number to respecify NSAV."/)') CF(:JF(NSAV)),
     +  CLN(GPP,3,1), TR('')
      CALL SCAN(J,0,'R',5)
      IF(J==0) GOTO 186
      IF(J<0) GOTO 184
      IF(J==1) READ(2,*) X
      IF(J>1) READ(2,*) X,Y; IF(J>1) GPP = MAX(.1,MIN(90.,Y))
      IF(NINT(X)>MREC-NTOT) WRITE(6,'(" NSAV cannot exceed",I3,"; th",
     +  "at is all the allocated Hybuf space remaining.")') MREC-NTOT
      NSAV = MAX(1,MIN(NINT(X),NSPN,MREC-NTOT))
      GAP = SIGN(GPP,GAP)
      GOTO 184
186   IF(GAP<0.) WRITE(6,'(/" To save patterns in which the factors ",
     +  "are distinctive on average by ",A3,A," or"/" more, hit RETU",
     +  "RN.  Otherwise, enter anything for alternative.")')
     +  CLN(GPP,3,1), TR('')
      IF(GAP>0.) WRITE(6,'(/" To save patterns in which at least one ",
     +  "factor is distinctive by ",A3,A," or more,"/" hit RETURN.  ",
     +  "Otherwise, enter anything for alternative.")')
     +  CLN(GPP,3,1), TR('')
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 188
      GAP = -GAP
      GOTO 186
C193   CT0 = ((ATM/KTM)*(NOLD+NSAV)**2)/120
C      CT1 = ((ATM/KTM)*NSAV**2)/120
188   IF(LG==1) WRITE(6,'(/5X,"To require newly saved patterns to b",
     +  "e GAP-wise distinct just among"/5X,"themselves without conce",
     +  "rn for similarity to ones stored earlier,"/5X,"hit RETURN.  ",
     +  "Otherwise, enter anything for broader screening.")')
      IF(LG==0) THEN
        WRITE(6,'(/5X,"To require newly saved patterns to be GAP-wise",
     +    " distinct not merely"/5X,"among themselves but from all sto",
     +    "red previously as well, hit RETURN.")')
        WRITE(6,'(5X,"Otherwise, enter anything to screen only among ",
     +    "current saves.")')
      END IF
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 197
      LG = 1-LG
      GOTO 188
197   WRITE(6,'(/" Saving results under the stipulated selection ",
     +  "controls is underway.")')
C Pick out NSAV best that are GAP-wise distinct with less than FOB obliquity.
      N1=0; N2=0; NS=0; NUSE=0
      LP5: DO II = 1,NSPN
        HMIN = MIN(HMIN,RMIN)
        N = MOD(RR(II),100); IF(OBLST(N)>FOB) CYCLE; NUSE = NUSE+1
        READ(17,REC=N) ((A1(L,J),L=1,NV),J=1,NF), ((C1(L,J),L=1,NF),
     +    J=1,NF), TT, ICYC
        REWIND 8
201     READ(8) L
        IF(L<LG*NOLD) GOTO 201
        DO K = LG*NOLD+1,NTOT
C           Compare retrieved Spin pattern to others in HYBUF: just to the
C           new ones if LG=1; to all of them if LG=0.
          READ(8) I, ((T1(L,J),L=1,NV),J=1,NF)
          CALL ALIGN(T1,A1(1,1),LST2,CG,NV,NF,CH,AV,HI,MV)
          IF(GAP>0.AND.HI<GPP .OR. GAP<0.AND.AV<GPP) THEN
            LMP(K) = LMP(K) + 1; CYCLE LP5
          END IF
          NS = NS+1; IF(NS>1) NS = II ! For saves 2 - 8, put unfiltered rank in JFLAG
        END DO                   ! ^ UNfiltered rank not now used; but maybe someday
        JFLAG = LUFF + MIN(NS,9)*100  ! II*100 codes rating rank
        CALL BUFF(2,A1,C1,FIX)  ! Buff resets JFLAG and increases NTOT
        WRITE(6,'(" The Try ranked ",A," has been saved as Hybuf pat",
     +    "tern No. ",A)') CF(:JF(II)), CF(:JF(NTOT))
        IF(N1==0) N1 = NTOT    ! HYBUF index of first save
        IF(N2==0) N2 = N       ! File 17 index of first save
ccc        IF(NTOT-NOLD>=NSAV) GOTO 250  ! No. Tabulate all lumps even past NSAV cut
        IF(NTOT-NOLD>=NSAV) GOTO 250
      END DO LP5
C Exit with message appropriate to the result
250   IMAX = IMX
      CH = 's'
      IF(NTOT-NOLD==1) CH = ' '
      WRITE(6,'(/" SPIN has recorded ",A," new pattern",A)')
     +  CF(:JF(NTOT-NOLD)), CH
      IF(NCNV/(1.*NOK) > .1) WRITE(6,'(/" NOTE:",I3,"% of these ",
     +  "SPIN Tries were nonconvergent")') NINT((100.*NCNV)/NOK)
      IF(NIX>0) WRITE(6,'(1X,A," unlisted Trys were rejected for ",
     +  "obliquity exceeding",A4," .")') CF(:JF(NIX)), CLN(CMAX,4,2)
      IF(NCNV/(1.*NSPN) >= .25) WRITE(6,'(" You are advised to dec",
     +  "rease search window B0 or damping fraction DF"/" at the con",
     +  "vergence-parameters screen under Main Menu Option 1.")')
      OPEN(9,FILE='LUMP')
      C18 = 'Singl-factor GAP ='; IF(GAP<0) C18 = 'Avrge-factor GAP ='
      CH3 = 'nul'; IF(JA>=0) CH3=CLN(CV,3,1); NN=NSPN-NUSE; ND=NN-NIX
      WRITE(9,'(/" This ",A6," Spin search under <WSAL,BH,JA,JB,CV> ",
     +  "= <",2(A4,","),I2,",",I2,", ",A3,">,"/5X,"storing after sol",
     +  "ution No. ",A,", was filtered by ",A18,F5.1," ")') CH6,
     +  CLN(WSAL,4,2), CLN(BH,4,2), JA,JB, CH3, CF(:JF(NOLD)), C18,GPP
      WRITE(9,'(" New patterns stored: ",A," of best ",A," filtered ",
     +  "from leading ",A," in ",A," successful Trys.")')
     +  CF(:JF(NTOT-NOLD)), CF(:JF(NUSE)), CF(:JF(NSPN)), CF(:JF(NOK))
      IF(NN>0) WRITE(9,'(5X,A," in best ",A," were dropped for obliqu",
     +  "ity exceeding",A4)') CF(:JF(NN)), CF(:JF(NSPN)), CLN(FOB,4,2)
      IF(NIX>0) WRITE(9,'(5X,A," additional Trys were rejected for ",
     +  "obliquity exceeding",A4)') CF(:JF(ND)), CLN(CMAX,4,2)
      IF(NCNV/(1.*NOK) > .05) WRITE(9,'(" NOTE:",I3,"% of these Spin",
     +  " Tries were nonconvergent")') NINT((100.*NCNV)/NOK)
      IF(KOUNT>MKT) WRITE(9,'(/7X,"Persistent factor collapse ended S",
     +  "pin search after ",A," successful tries.")') CF(:JF(NSPN-1))
      WRITE(9,'(" Lumps in unfiltered best ",A," have been counted ",
     +  "over solutions No. ",A," to No. ",A,".")') CF(:JF(NSPN)),
     +   CF(:JF(NOLD*LG+1)), CF(:JF(NTOT))
      NN = MAX(1,N1)
      READ(17,REC=MAX(1,N2)) ((A1(L,J),L=1,NV),J=1,NF), ((C1(L,J),
     +  L=1,NF),J=1,NF)
      WRITE(6,'(/" Best Spin result (No. ",A,") is now active.")')
     +  CF(:JF(NN))
      IF(NA>0) THEN  ! Case NA=NFREE has already exited to Label 400
        WRITE(6,'(/6X,67A)') TR(''), (TR(''),I=1,65), TR('')
        WRITE(6,'(6X,A," If you want the factor/variable alignments n",
     +    "ow imposed on SPIN  ",A/6X,A," search here to remain as axi",
     +    "s fixations during regular rotation,",A/6X,A," enter anyth",
     +    "ing.  Otherwise, hit RETURN to drop this constraint. ",A)')
     +    (TR(''),I=1,6)
        WRITE(6,'(6X,67A)') TR(''), (TR(''),I=1,65), TR('')
        CALL SCAN(J,0,'B',5)
        IF(J==0) WRITE(6,'(/" Factors are no longer fixed by item ",
     +    "alignments.")')
        IF(J==0) GOTO 400
        WRITE(6,'(/" Factors that will remain fixed by item align",
     +   "ments:",20(1X,A))') (CF(:JF(LST1(I))),I=1,NA)
        GOTO 420
      END IF
499   IF(NA==0) GOTO 600
500   WRITE(6,'(/" No luck in ",A," attempts at random axis repositi",
     +  "oning"/ " not verging on factor collapse.")') CF(:JF(MKT))
C       Prepare to wipe FIX of any factor alignments with variables
505   WRITE(6,'(/" SPIN is aborted without any factor shifts")')
      IF(NA==0) GOTO 600
      NA = -ABS(NA)
      IF(JFIX>0) WRITE(6,'(" but factor alignments with items on",
     +  " previous SPIN call are cancelled.")')
C Remove item-fixed axes fron FIX and KTL.
400   DO I = 1,NF
        FIX(I) = NINT(T1(I,NF+1))
      END DO
      NFIX = NFIX-ABS(NA)
      CALL BLOCK(2,QB,NF,FIX,PFIX,KTL,WRD,MF)  ! LMP,WRD,QB are dummies; compiler disses QB
      IF(NA<0) GOTO 600
      IF(NA==NFREE) THEN
        JFLAG = JFLAG+(9-JFLAG/100000)*100000  ! Put 9 in 6th digit of JFLAG
        TT = NA
        LG = SIGN(LG,-1)
        WRITE(6,'(/" Storing of pattern on item-aligned factors ",
     +    "gets recorded as a rotation:")')
        CALL BUFF(1,A1,C1,FIX)
        WRITE(6,'(" This pattern with all axes anchored by variables",
     +    " has been stored as No. ",A/" without FIXing these alignm",
     +    "ents, and is ready for unfixed rotation.")') CF(:JF(NTOT))
ccc        WRITE(6,'(" Its exhibit under Main Menu Option 6 will be ",
ccc     +    flagged -, or = when it is active.")')
      END IF
420   CALL WAIT(1)
600   CONTINUE
      CLOSE(17); CLOSE(18)
      REWIND 24; WRITE(24) MSPN, NUFF, FOB, GAP
      END SUBROUTINE

      SUBROUTINE SPRED(NV,NF,A,BH,MV)
C Show the distribution of factor loadings in A for hyperplane BH
      CHARACTER FMT*50, COD*3, CF*12, TR, CH
      INTEGER LST(22)
      REAL A(MV,0:*)
      COMMON /TTR/ KR, KND, NLD
      COMMON /CF/ CF
      FMT = '("  ",aa(""),"ccc",bb(""),"",9(""))'
C       FMT is ('  ',aa(''),'ccc',bb(''),'',9(''))
      I = MAX(1,MIN(19,INT(50*MIN(.43,BH+.0001)))) ! term 'aa'
      J = 20 - I ! term 'bb'
      FMT(9:10) = CHAR(48+I/10)//CHAR(48+MOD(I,10))
      FMT(25:26) = CHAR(48+J/10)//CHAR(48+MOD(J,10))
      FMT(20:22) = '^' ! term 'ccc'
      IF(AMOD(BH,.02)<=.004) FMT(20:22) = '^'
      IF(AMOD(BH,.02)>=.016 .OR. BH>.395) FMT(20:22) = '^'
      IF(BH>.405) FMT(20:22) = 'į'
      IF(KR>0) CALL TRLIN(FMT(:50))
      K = MAX(1,MOD(MIN(NF,10),10))       !      K = NF or 1
      DO JJ = 1,K                         !      do 10 jj = 1,K
        DO L = 1,22                       !       initialize LST
          LST(L) = 0                      !       do 20 i = 1,nv
        END DO
        DO I = 1,NV                       !        j2 = nf-(nf-jj)*(k/2)
          J2 = NF-(NF-JJ)*MIN(1,K-1)      !        do 20 j = jj, j2 (j2 = jj or nf)
          DO J = JJ,J2                    ! 20      accumulate LST over A(i,jj)
            L = 1+INT(50*MIN(.43,ABS(A(I,J))))    ! 10   print
            LST(L) = LST(L)+1
          END DO
        END DO
        CH = ' '
        IF(NF<=9) CH = CHAR(48+JJ)
        WRITE(6,'(2X,2A,21A3,1X,A,I5)') CH,TR(''),(COD(LST(I),1),
     +    I=1,21), TR(''), LST(22)
      END DO
      WRITE(6,FMT)
      WRITE(6,'("  j",A,21I3,1X,A," over 42")') TR(''), (1+2*I,
     +  I=0,20), TR('')
      WRITE(6,'(5X,"Scatter of the current pattern''s ",A," factor loa",
     +  "dings.  The number above"/4X,"each label j is the raw freque",
     +  "ncy of magnitudes in interval .01(j +/- 1).")') CF(:JF(NV*NF))
      IF(LST(2)>100) WRITE(6,'(4X,"Leading digits of counts larger",
     +  " than 99 are coded by corresponding letters."/)')
      END SUBROUTINE
C
      SUBROUTINE START(J,F1,K)
C This opens formatted file F1 with unit-number J, finds its first line
C starting with a digit, and reports in K how many entries are in this line.
      CHARACTER F1*(*), CH*60
      CLOSE(J)  ! A Precaution
      OPEN(J,FILE=F1)
10    READ(J,'(A)',END=50) CH
      CALL LAST(N,CH,60)
      IF(N==0) GOTO 10
      K = ICHAR(CH(1:1))
      IF(K<48 .OR. K>57) GOTO 10
      K = 1
      DO I = 2,N-1
        IF(CH(I:I)==' ' .AND. CH(I+1:I+1)/=' ') K = K+1
      END DO
      BACKSPACE J
      RETURN
50    WRITE(6,'(/" File ",A," is defective.")') F1
      END SUBROUTINE
C
      SUBROUTINE SUBST(WORD,CHA,CHB)
C  Replace all WORD(:LL)-occurrences of chars in CHA with matching chars in CH2
      CHARACTER WORD*(*), CHA*(*), CHB*(*), CH1, CH2
      M = LEN(WORD)
      N = MIN(LEN(CHA),LEN(CHB))
      DO K = 1,N
        CH1 = CHA(K:K)
        CH2 = CHB(K:K)
        DO I = 1,M
          IF(WORD(I:I)==CH1) WORD(I:I) = CH2
        END DO
      END DO
      END SUBROUTINE
C
      SUBROUTINE TELL(NN,JFL,CH6,NOM,NPFIX,WORD,C1)
      CHARACTER*6 CH6, WORD*(*), CF*12, CLN*8
      REAL C1(MF,*)
      COMMON  NV, NF, MV, MF
      COMMON /BL2/ LIM, CV, PD1, MODE, GAM
      COMMON /BL3/ BH, JA, JB, CV1, ADD, R0, R1, WSAL
      COMMON /CF/ CF
      WORD(3:8) = 'nosome'
      WRITE(6,'(3X,"Retrieved pattern No. ",A," has obliquity",A4,
     +  " and reinstates controls ",A,","/5X,"<BH,JA,JB,CV,WSAL> = <",
     +  A3,",",2(I2,","),A4,",",A4,"> and ",A," item exclusions.")')
     +  CF(:JF(NN)), CLN(OBQ(C1,1),4,2), CH6, CLN(BH,3,2), JA,JB,
     +  CLN(CV,4,1),CLN(WSAL,4,1), WORD(3+2*MIN(1,NOM):4+4*MIN(1,NOM))
      IF(JFL==1) WRITE(6,'(24X,"It is a SPIN solution.")')
CCC      IF(JFL==1) WRITE(6,'(19X,"It is an OBLIQUE SPIN solution.")')
      IF(JFL==2) WRITE(6,'(18X,"It is an ORTHOGONAL SPIN solution.")') ! Not currently implemented
      IF(JFL==3) WRITE(6,'(20X,"This is the starting pattern.")')
      IF(JFL==4) WRITE(6,'(22X,"It is a VARIMAX solution.")')
      IF(JFL==5) WRITE(6,'(22X,"It is an EQUAMAX solution.")')
      IF(JFL==9) WRITE(6,'(14X,"All its free axes are al",
     +  "igned with selected items.")')
CC      IF(NPFIX>0) WRITE(6,'(" WARNING: Pattern constraints have ",
CC     +  "also been reactivated.")')  ! Redundant with fuller warning
      N1 = ICHAR(WORD(1:1))-32  ! Number of firmly constrained factors
      N2 = ICHAR(WORD(2:2))-32  ! Number of temporarily constrained factors
      IF(N1+N2+NPFIX>0) THEN
        WRITE(6,'(4X,"NOTE: Constraints on factor positioning have ",
     +    "also been reactivated.")')
        IF(N2+NPFIX>0) THEN
          WRITE(6,'(10X,"These include both temporary factor align",
     +      "ments and pattern fixations.")')
        ELSE IF(N2>0) THEN
          WRITE(6,'(10X,"These include some temporary factor align",
     +      "ments.")')
        ELSE IF(NPFIX>0) THEN
          WRITE(6,'(10X,"These include some temporary pattern fixa",
     +      "tions.")')
        END IF
      END IF
      END SUBROUTINE
C
      FUNCTION TR(CH)
C Translate selected 8-bit ASCII characters into 7-bit substitutes if KR > 0
      CHARACTER TR, CH
      COMMON /TTR/ KR, KND, NLD
      N = ICHAR(CH)
      IF(KR<=0 .OR. N<127) THEN
        TR = CHAR(N)
        RETURN
      END IF
      IF(N==196) THEN
        TR = '-'
      ELSE IF(N==205) THEN
        TR = '='
      ELSE IF(N==191.OR.N==192.OR.N==217.OR.N==218) THEN ! Single corners
        TR = '+'  ! Single-line corners
      ELSE IF(N==182.OR.N==183.OR.(N>=186.AND.N<=189).OR.
     +  (N>=199.AND.N<=204).OR.N==206.OR.N==208.OR.N==210
     +  .OR.N==211.OR.N==214.OR.N==215) THEN
        TR = '#' ! Double-line corners and verticals
      ELSE IF(N>=179.AND.N<=218) THEN
        TR = '|' ! Single-line verticals
      ELSE IF(N>=248) THEN
        TR = '^'  ! Elevated degree symbol
      ELSE IF(N>=242) THEN
        TR = '}'  ! <=
      ELSE IF(N>=243) THEN
        TR = '{'  ! >=
      ELSE IF(N>=223) THEN
        TR = '!'  ! 
      ELSE
        WRITE(6,'(/" A replacement for ASCII character ALT-",I3,
     +    " has not yet been programmed."/" Fix this oversight ",
     +    "and try again.")') N
        STOP
      END IF
      RETURN
      END
C
      SUBROUTINE TRLIN(WORD)
C Apply function TR to the characters in WORD
      CHARACTER TR, WORD*(*)
      LL = LEN(WORD)
      DO I = 1,LL
        WORD(I:I) = TR(WORD(I:I))
      END DO
      RETURN
      END
C
      SUBROUTINE VVAR(NEW,A1,C1,W,FIX,NB,NX,ORDER,JFLAG)
C  When current factor solution is orthonormal do ORTHOMAX rotations.
C  At start-up, also rotate within blocks of orthogonal factors.
      CHARACTER CH5*5
      INTEGER FIX(*),ORDER(*)
      REAL A1(MV,0:*), C1(MF,*), W(NV-NX,*)
      EXTERNAL SCAN
      COMMON  NV, NF, MV, MF
      CH5 = ' pre-'
      N = 1+4*MIN(NEW,1)
      WRITE(6,'(/" To",A,"rotate by VARIMAX, hit RETURN.  Otherwise, ",
     +  "enter any letter to"/A,"rotate by both VARIMAX and EQUAMAX, ",
     +  "or any number to do EQUAMAX only."//)') CH5(:N), CH5(:N)
      CALL SCAN(J,0,'I',5)
CC      KTYP = 5-MAX(0,J) ! Equals 4 if number is entered, otherwise 5
      KTYP = 4+MAX(0,J) ! Equals 5 if number is entered, otherwise 4
      NOTE = 0
CC      BIGA: DO LL = KTYP+MIN(0,J),KTYP   ! RETURN picks Equamax only
      BIGA: DO LL = KTYP,KTYP-MIN(0,J)    ! RETURN picks Varimax only
        BIGB:DO K = 1,NB+1  ! K indexes a FIX block whose members are
          KOUNT = 0         ! picked out in the M-indexed DO-loop
          DO M = 1,NF
            N = MIN(FIX(M),NB+1)
            IF(N==K) KOUNT = KOUNT+1
            IF(N==K) ORDER(KOUNT) = M
          END DO
          IF(KOUNT<2) CYCLE BIGB
C           ORTHOMAX doesn't like pattern rows having only one non-zero term.
          NOTE = 1
          DO J = 1,KOUNT
            DO I = 1,NV-NX             ! Exclude block-0 items
              W(I,J) = A1(I,ORDER(J))  ! ORDER lists factors in block
            END DO
          END DO
          X = 0.
          DO J = 1,KOUNT  ! Require factors within block to be orthogonal
            DO I = 1,NF
              IF(I/=ORDER(J)) X = MAX(X,ABS(C1(I,ORDER(J))))
            END DO
          END DO
          IF(X>.001) CYCLE BIGB
          CALL VARIM(NV-NX,KOUNT,W,MV,MAX(1.,(LL/5)*.5*NF),IER)
          DO J = 1,KOUNT
            DO I = 1,NV-NX
              A1(I,ORDER(J)) = W(I,J)
            END DO
          END DO
        END DO BIGB
        IF(NOTE==0) WRITE(6,'(/" Aborting Orthomax rotation: Loca",
     +    "tion constraints are too severe to proceed.")')
        IF(NOTE==0) RETURN
        JFLAG = JFLAG+(LL-JFLAG/100000)*100000
        CALL BUFF(-1,A1,C1,FIX)
        IF(LL==4) CH5 = ' VARI'
        IF(LL==5) CH5 = ' EQUA'
        WRITE(6,'(A,"MAX rotation has been executed.")') CH5
      END DO BIGA
      END SUBROUTINE
C
      SUBROUTINE VARIM(NV,NF,A,MV,WT,IER)
C This is a stripped copy of a subroutine for orthonormal factor rotation that
C includes QUARTIMAX, VARIMAX, and EQUAMAX as special cases. Control parameters
C can be adjusted by editing them in their entries below.
      REAL A(MV,*), SAVE(NV)
C      WT = NF*.5 ! Equamax setting
C      WT = 1.    ! Varimax setting
C       WT is the parameter that selects inter alia VARIMAX (WT=1.0),
C       QUARTIMAX (WT=0.0), and EQUAMAX (WT=NF/2.O). Best results are
C       claimed to result from WT in closed interval [1.0, 5.0*NF]. In
C       general, the larger is WT the more equal is the dispersion of
C       accounted-for variance across the factors.
      NORM = 1
C       NORM=1/0 selects whether pattern rows are or are not normalized
      IMAX = 50
C       IMAX is limit on number of iteration cycles
      EPS = .0001
C       Input convergence constant for rotation (angle).
      IER = 0
      NV2 = NV*NV
      NFF = ((NF-1)*NF)/2
      NF0 = NF-1
      EPS4 = EPS/4.0
      WTNV = WT/NV
C Normalize pattern rows
      IF(NORM==0) GOTO 10
      DO I = 1,NV
        S = 0.
        DO J = 1,NF
          S = S + A(I,J)*A(I,J)
        END DO
        S = MAX(.0001,SQRT(S))
        SAVE(I) = S
        DO J = 1,NF
          A(I,J) = A(I,J)/S
        END DO
      END DO
10    ICYC = 0
      NC = 0
      KOUNT = 0
      VVV = 0.
C Commence orthomax factoring
15    ICYC = ICYC + 1
      VV = VVV
C Calculate rotation criterion
      VVV = 0.
      DO J = 1,NF
        SS = 0.
        DD = 0.
        DO I = 1,NV
          SQ = A(I,J)*A(I,J)
          DD = DD + SQ
          SS = SS + SQ*SQ
        END DO
        VVV = VVV + (NV*SS - WT*DD*DD)/NV2
      END DO
      IF(NF<=1) GOTO 30
      IF(ICYC<=IMAX) GOTO 21
      IER = 66
      GOTO 30
21    TVV = VVV - VV
      IF(TVV>EPS*ABS(VV)) GOTO 22
      NC = NC+1
      IF(NC>=2) GOTO 30
22    BIGA: DO J = 1,NF0
        J1 = J+1
        BIGB: DO K = J1,NF
C Calculate Kaiser TAN(4*PHI) measure
          AS = 0.
          BS = 0.
          TT = 0.
          BB = 0.
          DO I = 1,NV
            U = (A(I,J)*A(I,J)) - (A(I,K)*A(I,K))
            V = 2*A(I,J)*A(I,K)
            AS = AS + U
            BS = BS + V
            BB = BB + U*U-V*V
            TT = TT + U*V
          END DO
          TT = 2*(TT - AS*BS*WTNV)
          BB = BB - (AS*AS-BS*BS)*WTNV
          IF(ABS(TT)+ABS(BB)>EPS) GOTO 25
24        KOUNT = KOUNT + 1
          IF(KOUNT<NFF) CYCLE BIGB
C Complete cycle without rotation
          GOTO 30
25        PHI = .25*ATAN2(TT,BB)
          IF(ABS(PHI)<EPS4) GOTO 24
          COSP = COS(PHI)
          SINP = SIN(PHI)
          KOUNT = 0
C Rotate axes by angle PHI
          DO I = 1,NV
             S = A(I,J)*COSP + A(I,K)*SINP
             A(I,K) = -A(I,J)*SINP + A(I,K)*COSP
             A(I,J) = S
          END DO
        END DO BIGB
      END DO BIGA
      GOTO 15
C Restore original pattern-row scaling
30    IF(NORM==0) GOTO 35
      DO I = 1,NV
        S = SAVE(I)
        DO J = 1,NF
          A(I,J) = A(I,J)*S
        END DO
      END DO
C Reflect axes with prevailingly negative loadings
35    DO J = 1,NF
        S = 0.
        DO I = 1,NV
          S = S + SIGN(A(I,J)**2,A(I,J))
        END DO
        IF(S<0) THEN
          DO I = 1,NV
            A(I,J) = -A(I,J)
          END DO
        END IF
      END DO
      IF(IER==0) RETURN
      WRITE(6,'(/" *** WT =",F4.1," ORTHOMAX on",I3," factors failed",
     +  " to converge in",I3," iterations.")') WT, NF, IMAX
      END SUBROUTINE
C
      SUBROUTINE WAIT(N)
C  N > 0 calls for space before screen display
      IF(N>0) WRITE(6,'()')
      WRITE(6,'(" Hit RETURN to continue")')
      READ(5,'()')
      RETURN
      END

C============================================================================

      FUNCTION OBL(IQ,IP,A,CF,WG)
C Find coeff ALPHA that rotates factor IQ in IQ/IP plane of received pattern/
C covars A/CF to shift loadings on IP by OBLIMIN criterion, and return ALPHA
C as value of the function.  If wanted, Kaiser pattern norming can be done in
C the calling routine.  WG = -Gamma is negation of the direct-Oblimin family's
C Gamma parameter which should be non-positive; Gamma = 0 is direct quartimin.
      REAL(8) S, WP, WQ
      REAL A(MV,*), CF(MF,*), WK3(MV)
      COMMON  NV, NF, MV, MF
      IF(IP==IQ) RETURN
      OBL = 0.
      G = -WG
C Initialize work terms
      GAM = G/NV
      A0 = 0.0
      DO J = 1,NF
        WP = 0.D0  ! Get sum-square of pattern column IP
        WQ = 0.D0  ! Get sum-square of pattern column IQ
        DO I = 1,NV
          WP = WP + A(I,IP)**2
          WQ = WQ + A(I,IQ)**2
        END DO
      END DO
      DO I = 1,NV  ! Initialize WK3 first as sum-sq of A's rows
        S = 0.D0
        DO J = 1,NF
          S = S + A(I,J)**2
        END DO
        WK3(I) = S  ! Influence here by factors additional to IP and IQ
        WK3(I) = S  ! Influence here by factors additional to IP and IQ
        A0 = A0 + S
      END DO
      G = GAM*A0
      DO I = 1,NV
        WK3(I) = WK3(I) - G
      END DO
      A0 = 0.0
      A1 = 0.0
      A2 = 0.0
      A4 = 0.0
      A5 = 0.0
      CQM = GAM*WQ
      G = GAM*(WP+WQ)
      DO I = 1,NV
        AP2 = A(I,IP)*A(I,IP)
        AQ2 = A(I,IQ)*A(I,IQ)
        APQ = A(I,IP)*A(I,IQ)
        WK3(I) = WK3(I) - AP2 - AQ2 + G
        CQ = AQ2 - CQM
        A0 = A0 + AP2*CQ
        A1 = A1 + APQ*CQ
        A2 = A2 + AQ2*CQ
        A4 = A4 + AQ2*WK3(I)   ! Effect of outside factors here
        A5 = A5 + APQ*WK3(I)   ! Effect of outside factors here
      END DO
      A1 = -2.0*A1
      RR = 2.0*CF(IP,IQ)
C      Check the cubic equation
      IF(ABS(A2)<=0.) RETURN
C      Get the cubic constants
      PP = A1/A2 + RR
      QQ = (A0+A1*RR+2.0*A4)/A2 + 1.0
      RQ = (A1+RR*(A0+A4)-2.0*A5)/A2
      ALPHA = QMIN(0.75*PP,0.5*QQ,0.25*RQ) ! Rotation coefficient
      OBL = ALPHA
      END FUNCTION
C
      REAL FUNCTION QMIN(P,Q,R)
C  Nucleus to find the minimum of a real quartic polynomial by finding the
C  zeros of its derivative and then minimizing.
      REAL(8) A, B, C1, C2, C3, CMAX, D, E, P2, T3, X, F3, R3
      PARAMETER (R3=1.0D0/3.0D0)
      F(X) = (((X/4.0D0+P/3.0D0)*X+Q/2.0D0)*X+R)*X
      P2 = P*P
      A = (3.0D0*Q-P2)/3.0D0
      B = (2.0D0*P2-9.0D0*Q)*P/27.0D0 + R
      D = B**2*0.25D0 + A**3/27.0D0
      IF(D>=0.0D0) THEN
         E = SQRT(D) - B/2.0D0
         F3 = SIGN(ABS(E)**R3,E) - P/3.0D0
         E = -(E+B)
         F3 = SIGN(ABS(E)**R3,E) + F3
      ELSE
         T3 = ACOS(-B/(2.0D0*SQRT(-A**3/27.0D0)))/3.0D0
         E = 2.0D0*SQRT(-A/3.0D0)
         C1 = COS(T3)
         C2 = COS(T3+4.1887902D0)
         C3 = COS(T3+2.0943951D0)
         F3 = MIN(C1,C2,C3)*E - P/3.0D0
         CMAX = MAX(C1,C2,C3)*E - P/3.0D0
         IF(F(CMAX)<F(F3)) F3 = CMAX
      END IF
      QMIN = SNGL(F3)
      END FUNCTION
C
      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12, LST(12)*10
      COMMON /CF/ CF
      DATA LST/'January  7','February 8','March    5','April    5',
     +         'May      3','June     4','July     4','August   6',
     +         'September9','October  7','November 8','December 8'/
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48  ! M gets day of month
      READ(ZZZ(5:6),*) L; K = ICHAR(LST(L)(10:10))-48
      WORD = CF(:JF(M))//' '//LST(L)(:K)//' '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE
C
      FUNCTION QFMT(F1)
C This determines the status of file F1, returning 'Y' if it is Formatted,
C 'N' if it is Not, and 'U' if it is Unknown (does not exist).
      CHARACTER QFMT, F1*(*)
      INQUIRE(FILE=F1,FORMATTED=QFMT)
      END FUNCTION
C
      FUNCTION TM(KSET)
C The value (real) returned by function TM is seconds since last timer reset.
C After this value is determined, the timer is reset if KSET > 0 but continues
C to accumulate if KSET = 0.
      SAVE PREV
      DATA PREV/0./
C       CALL SYSTEM_CLOCK(J,KR,KMAX)  ! Arguments are optional
C       J = tick count since zero; KR = ticks per second; KMAX = max count
C       In LF90 clock: KR = 100, KMAX = 8,640,000
      CALL SYSTEM_CLOCK(J)
      X = J*.01
      TM = X - PREV
      IF(TM < 0.) TM = TM + 86400
      IF(TM >= 16400.) TM = 0.   ! Why this??  (Not in all Hyball programs)
      IF(KSET==0) RETURN
      PREV = X
      END FUNCTION

C ===================================================================
      SUBROUTINE KNORM(A1,JOB)
C Do Kaiser norming of pattern A1 if JOB==1, or undo it otherwise
      REAL A1(MV,0:*), SCAL(NV)
      COMMON  NV, NF, MV, MF
      REWIND 14
      READ(14) (SCAL(I),I=1,NV)
      IF(JOB==1) THEN
        DO I = 1,NV; DO J = 1,NF
            A1(I,J) = A1(I,J)/SCAL(I)
        END DO; END DO
      ELSE
        DO I = 1,NV; DO J = 1,NF
            A1(I,J) = A1(I,J)*SCAL(I)
        END DO; END DO
      END IF
      END SUBROUTINE


      SUBROUTINE QUIZ(A1,C1,NN,E,IMX,JMX,JOB)  ! JOB = 0 loads the target covars
C Check whether factor solution reproduces the input item covariances
cc      CHARACTER CLN*8
      REAL A1(MV,0:*), C1(MF,*), CA(NV*(NV+1)/2), CB(NV*(NV+1)/2)
      COMMON  NV, NF, MV, MF
cc      SAVE KNT
      LO(I,J) = J*(J-1)/2 + I
C       Efficient storage style of getting matrix product Q = A*B*C:
C       Q(i,j) = kl A(i,k)*B(k,l)*C(l,j) = k A(i,k)*(l B(k,l)*C(l,j) )
      CA = 0.; NVV = LO(NV,NV)
      DO J = 1,NV
        DO K = 1,NF
          S = 0.
          DO L = 1,NF
            S = S + C1(K,L)*A1(J,L)
          END DO
          DO I = 1,J
            IJ = LO(I,J); CA(IJ) = CA(IJ) + A1(I,K)*S
          END DO
        END DO
      END DO
      IF(JOB==0) THEN
        OPEN(39,STATUS='SCRATCH',FORM='UNFORMATTED')
        WRITE(39) (CA(I),I=1,NVV)  ! ; KNT = 0; RETURN
        OPEN(23,FILE='ERRORS')
        RETURN
      END IF
      REWIND 39
      READ(39) (CB(I),I=1,NVV)
ccc      WRITE(23,'(/" QUIZ reloads source Chh")') NN
ccc      DO J = 1,NV
ccc        WRITE(23,'(30A6)') (CLN(CA(LO(I,J)),6,3),I=1,J)
ccc      END DO
      EMAX = 0.
      DO J = 1,NV
        DO I = 1,J
          E = ABS(CA(LO(I,J))-CB(LO(I,J)))
          IF(E<EMAX) CYCLE
          E = EMAX; IMX = I; JMX = J
        END DO
      END DO
cc      IF(E<.01) RETURN
cc      WRITE(23,'(/" From Rec.",I2,", reconstructed Chh is")') NN
cc      DO J = 1,NV
cc        WRITE(23,'(30A6)') (CLN(CA(LO(I,J)),6,3),I=1,J)
cc      END DO
cc      KNT = KNT+1
cc      IF(MOD(KNT,50)==0) THEN
cc        WRITE(6,'(" ERRORS file now contains",I5," entries (less one).",
cc     +    "  Hit RETURN to continue"/" or Ctrl-C to quit.")') KNT
cc        CALL WAIT(0); READ(5,'()')
cc      END IF
      END SUBROUTINE

