C  Program HYBLOCK.  (Source code, FORTRAN-90.  Subroutine package EIGS must
C    also be loaded.)

c ***** ERROR? Items' Waif-variances appear to change from varimax rotation



C        Copyright (c) 1999 by W. W. Rozeboom.   All rights reserved.

C                 Last revised: 27 June 2001

C  This rotates the axes of a factor pattern received from MODA to position
C  specified blocks of the factor axes within the subspaces spanned by the
C  true-parts of selected subsets of the factored variables. These assignments
C  have a hierarchical block structure that is passed with this intermediate
C  factor solution to HYBALL for rotation to simple structure under fixation
C  of the factor subspaces stipulated here. The only limit on the number NB
C  of blocks is that 2**NB cannot exceed the largest programmable integer.
C  For the Lahey compiler, this limit is 30.
      PARAMETER (MB=31)     ! Max-NB, plus 1 for Waifs
      LOGICAL QQ, QW, QWW, QN, QY, QP
C       QW=T if there will be Waif factors.
C       QWW=T flags computed Waifs; QWW=F resets starting Loop 202.
C       QP=T flags item permutation.
      CHARACTER QFMT, SLASH, CS, BN, TR, PL*2   ! PL, BN, TR are functions
      CHARACTER(12) F0, F1, F2, F3, F4, CF, CLN*8, CH1*2, CH2*2
      CHARACTER(90) FMT1,FMT2,FMT3, WORD*270
      REAL(8) S
      CHARACTER,ALLOCATABLE :: IDENT(:)*8, COVNAM(:)*8, NAME(:)*12
      INTEGER,ALLOCATABLE :: BL(:), BS(:), BV(:), KBZ(:,:), KBL1(:,:),
     +        KBLB(:,:), KBLF(:,:), LIST(:), LS1(:), LS2(:), LST0(:),
     +        LST1(:), PERM(:) !, LBIN(:)  ! BS gets compressed code for block structure
      REAL,ALLOCATABLE :: A1(:,:), W(:,:),W1(:), C1(:,:), CV(:), CFF(:),
     +        CVE(:,:), CVF(:,:), BZ(:,:), OFFL(:), R1(:), T1(:,:)

C     KBL1(K,_) lists the items in block K; KBLB(K,_) lists blocks on which
C       block K is dependent; KBLF(K,_) lists the factors taken from block K;
C       KBZ(K,_) lists the individual factors taken from all blocks on which
C       block K is dependent (the Z-factors for this block).
C     CV holds the input item covars; CVE gets covars between items and item
C       residuals; CVF gets covariances between items and factors; CFF gets
C       covars among factors.  In loop for factor block IB, BZ gets regression
C       coefficients of each item on the Z-factors for this block.

      EXTERNAL SCAN
      COMMON NF, MV, MF
      COMMON /TTR/ KND
      COMMON /CF/ CF
      DATA NEW/1/, PL/'s '/, EVAL/.1/, QW,QWW,QN,QY,QP/5*.FALSE./
C       EVAL is the minimum eigenvalue for factors saved by default
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      JP(N) = MAX(1,MIN(2,N))
C       PL(JP(N):2) [PL(3-JP(N):2)] is 's ' [' '] if N1 or ' ' ['s '] if N>1
      CS = '$'
      IF(KND==1) CS = '#'
      KP = 132
      CALL SYSTEM('cls')
      CALL PRNT(0,KP,FMT3,6)
      OPEN(2,STATUS='SCRATCH')
      ALLOCATE ( NAME(60) )
      WRITE(6,'(/" HYBLOCK input must be a factor pattern amenable ",
     + "to HYBALL rotation,"/" preferably one of the following pr",
     + "oduced by MODA:")')
      CALL LOOK(1,'*.M*',NAME,60,N)
      IF(N==0) WRITE(6,'(/ " No unrotated MODA-output files exist",
     + " in this subdirectory.  But")')
10    IF(N==0) THEN
        WRITE(6,'(" HYBLOCK will block-structure any of the follow",
     +   "ing patterns:")')
        CALL LOOK(0,'*.M*',NAME,60,N)
        CALL LOOK(2,'*.H*',NAME,60,N)
        CALL LOOK(2,'*.K*',NAME,60,N)
        CALL LOOK(3,'INHYBL',NAME,60,N)
        IF(N==0) WRITE(6,'(/ " Nothing for HYBLOCK here.",
     +   " Go find something else to do.")')
        IF(N==0) STOP
        N = 0
      END IF
      NN = 1
12    F1 = NAME(NN)
      CALL LAST(LFF,F1,12)
      WRITE(6,'(/" The pattern file picked for HYBLOCK factor shift",
     + "ing is now ",A/" Hit RETURN if OK; otherwise, enter the ",
     + "index of another M-selection")') F1(:LFF)
      IF(N/=0) WRITE(6,'(" or any letter to see an expanded list",
     + " of HYBLOCK input candidates."/)')
      CALL SCAN(J,1,'I',5)
      IF(J<0) N = 0
      IF(J<0) GOTO 10
      IF(J>0) THEN
        READ(2,*) NN
        NN = MAX(1,MIN(NN,N))
        GOTO 12
      END IF
      MPOS = 0  ! Allow that F1 may not be a MODA M-output (Ever needed?)
      IF(F1(LFF-1:LFF-1)=='M') MPOS = LFF-1
      IF(F1(LFF-2:LFF-2)=='M') MPOS = LFF-2
C       MPOS records position of "M" in MODA-output filename
      IF(QFMT(F1)=='Y') THEN
        CALL START(4,F1)
        READ(4,*) NV, NF, NX
      ELSE
        OPEN(4,FILE=F1,FORM='UNFORMATTED')
        READ(4) NV, NF, NX
      END IF
      CLOSE(4)
      MV = NV+NX; MF = NF
      MVV = LO(MV,MV); MFF = LO(MF,MF)
      ALLOCATE ( KBL1(0:MB,0:MV), KBLB(MB,0:MB), KBLF(MB,0:MF), BV(MV),
     +  A1(MV,MF), CV(MVV), CFF(MFF), LIST(MV), LST0(MV), LST1(MV),
     +  OFFL(MV) )
      KBL1 = 0; KBLB = 0; KBLF = 0; NBO = 0
      IF(QFMT(F1)=='Y') THEN
        CALL START(4,F1)
        READ(4,*) NV, NF, NX, KODE, MTH, F0  ! Rem: NX is not included in NV
        DO I = 1,NV
          READ(4,*) (LIST(J),J=1,NF)
          DO J = 1,NF
            A1(I,J) = .001*LIST(J)
          END DO
        END DO
        READ(4,*) N, NFF
        CALL CHECK(NF,KODE,N,NFF)
        DO I = 1,NF
          READ(4,*) (LIST(J),J=1,NF)
          DO J = I,NF
            CFF(LO(I,J)) = .001*LIST(J)
          END DO
        END DO
        READ(4,*,END=20) (LST0(J),J=1,NV+NX)
        READ(4,*,END=23) NBO, (OFFL(J),J=1,NBO)
      ELSE
        OPEN(4,FILE=F1,FORM='UNFORMATTED')
        READ(4) NV, NF, NX, KODE, MTH, F0
        READ(4) ((A1(I,J),I=1,NV),J=1,NF)
        READ(4) N, NFF
        CALL CHECK(NF,KODE,N,NFF)
        READ(4) (CFF(I),I=1,NFF)
        READ(4,END=20) (LST0(J),J=1,NV+NX)
        READ(4,END=23) NBO, (OFFL(J),J=1,NBO)
      END IF          ! LST0 picks names from COV-file list
      CLOSE(4)
      GOTO 23
20    DO I = 1,NV+NX  ! Only if input doesn't provide LST0
        LST0(I) = I
      END DO
23    NVX = NV+NX; NF1 = NF-NX
      IF(NBO==0) DEALLOCATE ( OFFL )
C       NF1 is the number of factors that are not fixed inputs
      KBL1(0,0) = NX
      DO I = 1,NX ! Append fixed inputs to pattern
        KBL1(0,I) = NV+I   ! List fixed inputs in X-row of KBL1
        DO J = 1,NX
          A1(NV+I,J) = 0.
          IF(I==J) A1(NV+J,J) = 1.
        END DO
      END DO
      DO I = 1,NBO  ! Adjustments for off-norm X-items
        IF(OFFL(I)<0) THEN  ! Minus flags nonbinary with reliability index
          Z = ABS(OFFL(I)); J = INT(Z); A1(NV+J,J) = Z-J
        END IF
        OFFL(I) = SIGN(NV+ABS(OFFL(I)), OFFL(I))
      END DO
C
C Read in the original list of variable names
      CALL LAST(LF0,F0,12)
      WORD(:24) = F0//'                  '
      LL = 0
      IF(QFMT(F0)/='Y') THEN
        WRITE(6,'(/8X,63A)') TR(''), (TR(''),I=1,61), TR('')
        WRITE(6,'(8X,A," WARNING. File ",A," containing names of ",
     +   "the variables",2A/8X,A," has not been copied to this su",
     +   "bdirectory. To read it, enter",1X,A/8X,A," the full sub",
     +   "directory name (with leading but not trailing   ",A/8X,A,
     +   " path-slash, and drive letter if needed) which contains ",
     +   "this.",A/8X,A," Otherwise, hit RETURN to continue with",
     +   "out variable names.",3X,A)') TR(''), F0(:LF0),
     +   WORD(13:24-LF0), (TR(''),I=1,9)
        WRITE(6,'(8X,63A//)') TR(''), (TR(''),I=1,61),  TR('')
        READ(5,'(A)') WORD(:40)
        CALL LAST(LL,WORD,40)
        IF(LL==0) QN = .TRUE.
        IF(QN) GOTO 32
        LL = LL+1
        WORD(LL:LL+LF0) = SLASH()//F0(:LF0)
        IF(QFMT(WORD(:LL+LF0))/='Y') THEN
          WRITE(6,'(" File ",A," has eluded detection. The vari",
     +     "ables remain nameless.")') WORD(:LL+LF0)
          QN = .TRUE.
          GOTO 32
        END IF
      END IF
      CALL START(4,WORD(:LL+LF0))
      READ(4,*,END=35) NT
30    READ(4,'(A)',END=32) WORD(1:1)
      IF(WORD(1:1)/='N') GOTO 30
      ALLOCATE ( IDENT(MV), COVNAM(NT) )
      READ(4,*,ERR=32,END=35) (COVNAM(I),I=1,NT)
      DO I = 1,NV+NX
        IDENT(I) = COVNAM(ABS(LST0(I)))
        LST1(I) = SIGN(I,LST0(I))  ! Names are now in MODA order, but index needs reflection sign
      END DO
      DEALLOCATE ( COVNAM )
      GOTO 35
32    DO I = 1,NV+NX
        IDENT(I) = '['//CF(:JF(I))//']     '
        LST1(I) = I
      END DO
35    CLOSE(4)
C
      CVAR = FLOAT(ABS(KODE)/1000000)/100
      CODE = FLOAT(MOD(ABS(KODE),1000000))
      CODE = CODE + CVAR
      ALLOCATE ( C1(MV,MV) )
      F2 = F1; K = 0; L = 0  ! ; NBIN = 0
C        K,L check for orthogonality, NBIN counts factors presumed binary
      DO J = 1,NF
        DO I = 1,J
          R = CFF(LO(I,J))
          IF(I>NX .AND. J>I .AND. ABS(R)>.001) K = 1
          IF(I<=NX .AND. J>NX .AND. ABS(R)>.001) L = 1
          IF(I==J .AND. ABS(1.-R)>.001) THEN
            IF(J>NX) K = 1
          END IF
          C1(I,J) = R   ! Transfer CFF to C1
          C1(J,I) = R
        END DO
      END DO

      IF(L>=1) WRITE(6,'(/" Not all dependent factors in ",A," are",
     +  " orthogonal to the factors"/" identified as fixed input (X-",
     +  "set) items).  Something has gone wrong here.")') F1(:LFF)
      IF(L>=1) STOP
      IF(K>=1) THEN
        WRITE(6,'(/" The dependent factors in ",A," are not orthonor",
     +    "mal.  Hit RETURN"/" if OK; otherwise, enter anything to ",
     +    "abort this run.")') F1(:LFF)
        CALL SCAN(J,0,'B',5)
        IF(J/=0) STOP
      END IF

C Reconstruct the item covariances orthogonal to the fixed factors
C (non-fixed factors start at factor index NX+1)
      ALLOCATE ( R1(MV) ); R1 = 0.
      DO J = 1,NV
        DO I = 1,J
          IF(I==1 .AND. J==2) WRITE(6,'(/" Item covariances are",
     +      " being reconstructed.")')
          S = 0.
          IF(K==0) THEN   ! Factors are orthogonal
            DO L = NX+1,NF
              S = S + A1(I,L)*A1(J,L)
            END DO
          ELSE
            DO K = NX+1,NF
              DO L = NX+1,NF
                S = S + A1(I,K)*C1(K,L)*A1(J,L)
              END DO
            END DO
          END IF
        IF(I==J) R1(I) = S   ! Reconstruct communalities in R1
        CV(LO(I,J)) = S
        END DO
      END DO
      IF(NX>0) THEN
        DO I = 1,NVX
          DO J = 1,NX
            DO K = 1,NX
              R1(I) = R1(I) + A1(I,J)*C1(J,K)*A1(I,K)
            END DO
          END DO
        END DO
      END IF
      OPEN(11,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(11) (R1(I),I=1,NVX)  ! Communalities will be retrieved in SHOW
C                                ! Now pointless to save COMMs this^ way??
      WRITE(6,'(//" You are here to reposition the factors received ",
     +  "from MODA in file ",A/" for ",A," items (data-variable comm",
     +  "on parts) on ",A," factors. You will"//"  1) select one or ",
     +  "more blocks of items, and declare a dependency ordering"/5X,
     +  "of the factor blocks they respectively distinguish;"//2X,
     +  "2) inspect each block''s eigenvalues orthogonal to the bloc",
     +  "ks preceding it"/5X,"to choose the number N of factors disti",
     +  "nguished by this item block; and"//"  3) stipulate that the",
     +  " first N principal axes of this item block are to be"/5X,
     +  "axes in the factor pattern passed to HYBALL with this block",
     +  " structure."/)') F1(:LFF), CF(:JF(NV)), CF(:JF(NF))
      IF(NX==0) GOTO 45
      IF(NX==1) WRITE(6,'(" >>> NOTE. In addition to the ",A," depe",
     +  "ndent variables, this pattern includes"/5X,"one manifest-inp",
     +  "ut item defining its first factor.  Unless you"/5X,"exercise",
     +  " your start-up option to reassign this, it will constitute")')
     +  CF(:JF(NV))
      IF(NX>1) WRITE(6,'(" >>> NOTE. In addition to the ",A," dep",
     +  "endent variables, this pattern includes"/5X,A," manifest-in",
     +  "put items defining its first ",A," factors.  Unless you"/5X,
     +  "exercise your start-up option to reassign these, they will",
     +  " constitute")') CF(:JF(NV)), CF(:JF(NX)), CF(:JF(NX))
      WRITE(6,'(5X,"a global-source block X on which all other blocks ",
     +  "are dependent but is"/5X,"not explicitly mentioned during ent",
     +  "ry of block structure and solution"/5X,"for block factors.")')
45    CALL WAIT(1)
C
      KFB = 0  ! Flag whether working on bootstrap covariances
      DO J = 1,8
        IF(F1(J:J)=='(' .OR. F1(J:J)==')') KFB = J
      END DO
      IF(KFB>0) F1(MPOS:MPOS) = 'B' ! MPOS is start position of M-file name extension
      IF(MPOS==0) THEN
        F1 = 'INHYBL      '
        LF = 6
49      WRITE(6,'(/" Hit RETURN to pick ",A," as name for the HYB",
     +   "ALL-input file to which this"/" block-structured patter",
     +   "n will be written. Otherwise enter alternative file name."/
     +   )') F1(:LF)
        READ(5,'(A12)') WORD
        CALL LAST(N,WORD,40)
        IF(N==0) GOTO 50
        F1 = WORD
        GOTO 49
      ELSE IF(KFB==0) THEN
        WORD(:3) = 'B'//F1(MPOS+1:MPOS+2)
        CALL NAMEB(F1,WORD(:3),LF1,CS,F3,LF3)
C        F1 is the HYBALL-input file; F3 is the SEE-file with leading char CS
      END IF
      CALL LAST(LF1,F1,12)
C Transfer input data to SEE-file F3
50    OPEN(7,FILE=F3)
      CALL PRNT(1,KP,FMT3,7)
      WRITE(7,'(" HYBLOCK shifting of factor pattern ",A," with code",
     +  " No. ",A,A2)') F2(:LFF), CF(:JF(INT(CODE))),
     +  CLN(MOD(CODE,1.),3,2)
CC     +  "code No. ",F9.2)') F2(:LFF), CODE
      CALL DAY(7); LW = 5
      IF(QN) WRITE(7,'(/" Names for the variables are unavailable.")')
      IF(QN) GOTO 52
      WRITE(7,'(/" The variables are named")')
      CALL SEENAM(LM,NVX,IDENT,LST1,KP-1,0,LW,FMT3,7)   ! SEENAM uses Abs(LST1)
52    WRITE(7,'(/" The input pattern (and communalities) of ",A," dep",
     +  "endent and ",A," independent variables on ",A," factors is")')
     +  CF(:JF(NV)), CF(:JF(NX)), CF(:JF(NF))
      FMT1 = '(4X,7X,2(2X,5A5),90(:/13X,2(2X,5A5)))'
      IF(KP>=100) FMT1 = '(4X,7X,3(2X,5A5),90(:/13X,3(2X,5A5)))'
      CALL SHOW(NVX,QP,FMT1,A1,C1,LIST,7)  !  LIST is unused
      IF(NX==1) WRITE(7,'(/" The first factor is a manifest-input",
     +  " variable.")')
      IF(NX>1) WRITE(7,'(/" The first ",A," factors are manifest",
     +  "-input variables.")') CF(:JF(NX))
C
C For marker-group applications of HYBLOCK, get block structure from BLKREC.
C Any global sources in input pattern have been recorded in row 0 of KBL1
      F4 = 'BLKREC.'//CF(:JF(NV))
      INQUIRE(FILE=F4,EXIST=QQ)
      IF(.NOT.QQ) GOTO 55
      CALL SYSTEM('cls')
      WRITE(6,'(/4X,"If you are merely shifting factors to MARKER-GR",
     +  "OUP positions and want"/4X,"to load the block structure fo",
     +  "r this previously identified by FINDBLK,"/4X,"hit RETURN.",
     +  "  Otherwise, enter anything to signal that this marker-group"/
     +  4X,"pre-structuring is no longer wanted.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) THEN
        CALL SYSTEM('copy '//F4//' '//'BLKREC&.'//F4(8:11)//' >nul')
        CALL SYSTEM('del '//F4)
        QQ = .FALSE.
        GOTO 55
      END IF
      ALLOCATE ( BS(MF) )
      OPEN(4,FILE='BLKREC',FORM='UNFORMATTED')
      READ(4) N, NB0, NB       ! WARNING. BLKREC's revised input of NB0,NB
      READ(4) (BV(I),I=1,NV)   !          hasn't yet been fully proofed.
      READ(4) (BS(I),I=1,NB)
      CALL GETBLK(NV,NB,BV,KBL1,BS,KBLB)
      DEALLOCATE ( BS )
      GOTO 120
C
C Display factor pattern/covariances to be rotated
55    WRITE(6,'(/" The initial pattern (and communalities) of ",A,
     +  " dependent and ",A," independent"/" variables on ",A," facto",
     +  "rs, Data Code No.", F9.2,", is:")') CF(:JF(NV)), CF(:JF(NX)),
     +  CF(:JF(NF)), CODE
      FMT1 = '(4X,7X,2(2X,5A5),90(:/13X,2(2X,5A5)))'; LW = 5
      CALL SHOW(NVX,QP,FMT1,A1,C1,LIST,6)   ! LIST is unused
      IF(IDENT(1)(:2)=='??') THEN
        WRITE(6,'(/" Names for the variables are unavailable.")')
      ELSE
        WRITE(6,'(/" The variables are named")')
        CALL SEENAM(LM,NVX,IDENT,LST1,79,0,LW,FMT3,6)  ! Names are now in MODA order
        IF(NX==1) WRITE(6,'(/3X,"NOTE: The last item in this list ",
     +    "is the manifest-input variable that"/9X,"by default will ",
     +    "define block X of global source factors.")')
        IF(NX>1) WRITE(6,'(/3X,"NOTE: The last ",A," items in this ",
     +    "list are the manifest-input variables"/9X,"that by default ",
     +    "will define block X of global source factors.")') CF(:JF(NX))
        IF(NX>=1) WRITE(6,'(9X,"You should accept this default un",
     +    "less for some reason you"/9X,"want to rotate these or mod"
     +    "el them as path-antecedent only"/9X,"to selected subsets ",
     +    "of the dependent variables."/)')
        CALL WAIT(0)
      END IF
C
C Enter blocks and their dependency structure. Start by putting
C block-defining item clusters into KBL1
      WRITE(6,'(4X,"Explicit blocks are named by sequential letters ",
     +  "and are entered in"/4X,"order of independence (A,B,C,...) ",
     +  "from least to most dependent. For"/4X,"each block, you first",
     +  " list INDICES of the items that define it and"/4X,"then iden",
     +  "tify any prior blocks on which this one is dependent.")')
      IF(NX==0) GOTO 60
      IF(NX==1) WRITE(6,'(/"  The first factor is a manifest-input",
     +  " variable.  Enter anything to"/"  make this explicit in the",
     +  " block structure.  Or hit RETURN to leave it"/"  im",
     +  "plicit in global-source block X.")')
      IF(NX>1) WRITE(6,'(/"  The first ",A," factors are manifest",
     +  "-input variables.  Enter anything to"/"  make these explicit"
     +  " in the block structure.  Or hit RETURN to leave them"/2X,
     +  "implicit in global-source block X.")') CF(:JF(NX))
      CALL SCAN(J,0,'B',5); IF(J==0) GOTO 60
      N0 = NV; NV = NVX; NFIX = NX; NX = 0; NF1 = NF; KBL1(0,0) = 0
C   If this option shifts the X-set factors into the explicit block structure,
C   add the item covariance they account for to CV.  NFIX > 0 flags this shift.
      DO J = 1,NV
        DO I = 1,J
          S = 0.
          IF(I<=N0 .AND. J<=N0) S = CV(LO(I,J))
          DO K = 1,NFIX
            DO L = 1,NFIX
              S = S + A1(I,K)*C1(K,L)*A1(J,L)
            END DO
          END DO
          CV(LO(I,J)) = S
        END DO
      END DO
60    DEALLOCATE ( C1 )
C Look for previous block-structuring of this input.
      KK = 64
      NREC = 0
      QN = .FALSE.
      DO JL = 65,90  ! Scan all capital letters
        F4 = 'BLOKREC.'//CHAR(JL)//'   '
        INQUIRE(FILE=F4,EXIST=QQ)
        IF(.NOT.QQ .AND. KK==64) KK = JL  ! Find lowest empty slot for REC name
        IF(.NOT.QQ) CYCLE
        OPEN(4,FILE=F4)
        READ(4,'(A)') WORD(:12)  ! Input file blocked
        K = 10
61      K = K-1
        IF(WORD(K:K)/='.') GOTO 61
        IF(KFB==0.AND.WORD(:K)/=F2(:K)) CYCLE
        READ(4,*,ERR=62) I1, J1, NN, K1, NB0, NB    ! NN retrieves NX
        CLOSE(4)
        IF(I1/=NV .OR. NN/=NX .OR. KFB==0.AND.K1/=KODE)
     +    GOTO 62 ! Insufficient match of content
        NREC = NREC+1
        NAME(NREC)(:12) = '(           '; L = 2
        NAME(NREC)(12:12) = CHAR(JL)
        IF(NX>0) NAME(NREC)(L:L+1) = 'X,'; IF(NX>0) L = L+2
        IF(NB0==1) THEN
          NAME(NREC)(L:L+2) = 'A,'; L = L+2
        ELSE IF(NB0>1) THEN
          NAME(NREC)(L:L+4)='A-'//BN(NB0)//','; L = L+4
        END IF
        IF(NB>NB0) NAME(NREC)(L:L) = 'Y,'; IF(NB>NB0) L = L+2;
        NAME(NREC)(L-1:L-1) = ')'
62      CONTINUE
      END DO
      NRR = 1
      IF(KK==64) KK = 65
      IF(NREC==0) F4(9:9) = CHAR(KK)
      IF(NREC==0) GOTO 70
      QN = .TRUE.
64    WRITE(6,'(/4X,"Previously created block structures applicable ",
     +   "to this pattern have been"/4X,"saved in the following fil",
     +   "es.  (Their blocks are listed in parentheses.)")')
      WRITE(6,'(9(/3(I5,". BLOKREC.",A,1X,A)))') (I,NAME(I)(12:12),
     +  NAME(I)(:11),I=1,NREC)
65    WRITE(6,'(/4X,"To see the details of structure BLOKREC.",A,
     +  " with option to reinstate it,"/4X,"hit RETURN.  Otherwise, ",
     +  "enter the index of an alternative on this list"/4X,"or any",
     +  " letter to create a new block structure from scratch."/)')
     +  NAME(NRR)(12:12)
      CALL SCAN(J,1,'I',5)
      IF(J<0) THEN
        QN = .FALSE.
        F4(9:9) = CHAR(KK)
        DO IB = 1,MB
          KBL1(IB,0) = 0
          KBLB(IB,0) = 0
        END DO
        GOTO 70
      ELSE IF(J>0) THEN
        READ(2,*) NRR
        NRR = MAX(1,MIN(NREC,NRR))
        GOTO 65
      ELSE
        F4(9:9) = NAME(NRR)(12:12)
        ALLOCATE ( BS(MB) )
        OPEN(4,FILE=F4)
        READ(4,'()')
        READ(4,*) I,I, NN, I, NB0, NB
        READ(4,*) (BV(I),I=1,NV)
        READ(4,*) (BS(I),I=1,NB)
        CLOSE(4)
        NB = MAX(NB,LB)
        CALL GETBLK(NV,NB,BV,KBL1,BS,KBLB)
        IF(NN/=KBL1(0,0)) THEN
          WRITE(6,'(/" ERROR: ",A," is corrupt: Its number of X-set ",
     +      "items declared (line 2,"/8X,"entry 3) does not match it",
     +      "s count of items flagged 0 in line 3.")') F4(:9); STOP
        END IF
        DEALLOCATE ( BS )
        WRITE(6,'(/" The block structure loaded from ",A9," is")') F4
        QQ = .FALSE.  ! Structure revision after review requires QQ = F
        GOTO 121
      END IF
C
C   If fixed factors have been freed, put them into the initial block structure
70    DO I = 1,NFIX
        KBL1(I,0) = -1  ! Flagged for review
        KBL1(I,1) = N0 + I
        DO J = NFIX+1,MB
          KBLB(J,0) = KBLB(J,0) + 1
          KBLB(J,KBLB(J,0)) = I
        END DO
      END DO
      DEALLOCATE ( NAME )
      IF(NFIX==1) WRITE(6,'(/10X,"The manifest input, item ",A,", no",
     +  "w provisionally"/10X,"defines block A.")') CF(:JF(KBL1(1,1)))
      IF(NFIX>1) WRITE(6,'(/10X,"The manifest inputs, items ",A," - ",
     +  A,", now provisionally"/10X,"define blocks A - ",A,", respect",
     +  "ively."/)') CF(:JF(KBL1(1,1))), CF(:JF(KBL1(NFIX,1))),BN(NFIX)
C Enter blocks of variables into KBL1
      WRITE(6,'(/" Enter each block''s item indices in the same way ",
     +  "you enter an item string in"/" MODA or HYFAC:  Any string on",
     +  " one line ended with RETURN can be supplemented"/" by anothe",
     +  "r.  And just two indices in a line are read as the sequence"/
     +  " bounded by those indices.")')
75    NB = 0
      NCL = 0
      LB = 0
C       NB is the running total of blocks; NCL is number of items in preceding
C       blocks; LB will be index of fully-dependent block if nonempty.
76    IF(NEW==1) WRITE(6,'(/10X,"***** Commencing entry of block",
     +  " structure *****")')
80    NB = NB+1; NIB = KBL1(NB,0); J = 1   ! Start of block entry
CC      IF(NCL<NV .AND. NB<=MIN(30,MF)) GOTO 82  ! 30 is limit on NB set by max integer
      IF(NCL<NV .AND. NB<=30) GOTO 82  ! 30 is limit on NB set by max integer
      IF(NCL>=NV) WRITE(6,'(/" All items have been assigned to ",
     +  "blocks.")')
      IF(NB>30 .AND. NCL<NV) WRITE(6,'(/" Maximum number of blocks ",
     +  "has been reached.")')
      NB = NB-1
      GOTO 120
82    KFLG = KBL1(NB,0)  ! KFLG < 0 flags review of block specification
      NIB = ABS(KFLG)
      IF(NIB==0) GOTO 92
      DO I = 1,NIB   !  LIST will list items provisionally assigned to this block
        IF(KFLG<0) LIST(I) = KBL1(NB,I)  ! Here is main need for KFLG
        DO K = 1,NCL  ! NCL=0 on pass 1;  LIST(-,NCL) set below on prior passes
          IF(LIST(I)/=BV(K)) CYCLE  ! BV lists items assigned to prior blocks
          IF(KFLG<0) THEN  ! Vacuous branch avoids unwanted write to screen
          ELSE IF(NB<=NFIX .AND. LIST(I)==NV-NFIX+NB) THEN  ! Last use of NFIX
            WRITE(6,'(" Manifest-input item ",A,"''s default definit",
     +        "ion of block ", A," has been"/" overridden by its rea",
     +        "ssigment to a prior block.")') CF(:JF(LIST(I))), BN(NB)
          ELSE
            WRITE(6,'(" Item ",A," is disallowed: Already assigned ",
     +        "to a preceding block.")') CF(:JF(LIST(I)))
          END IF
          LIST(I) = 0
        END DO
      END DO
      NIB = 0
      DO I = 1,NV
        DO K = 1,ABS(KBL1(NB,0))
          IF(LIST(K)==I) GOTO 90
        END DO
        CYCLE
90      NIB = NIB+1
        KBL1(NB,NIB) = I
        BV(NCL+NIB) = I
      END DO
      KBL1(NB,0) = NIB
      IF(NIB==0) J = -1  ! Set J for consilience with GETLST output
92    IF(NEW==0 .AND.(J==-1 .OR. KFLG<0)) WRITE(6,'(/16X,
     +  "***** Re-specify block ",A," *****")') BN(NB)
      IF(NIB==0) THEN
        IF(NB>1 .AND. J/=-1 .AND. KFLG>=0) WRITE(6,'(/10X,
     +    "***** Start specification of next block *****")')
        WRITE(6,'(/" Enter items for block ",A,", or hit RETURN to put",
     +    " all remaining items into this"/" block.  Remember that ju",
     +    "st TWO entries picks all items in that interval.")') BN(NB)
        IF(NB>NF.AND.NCL<NV) WRITE(6,'(" WARNING: No factors can be ta",
     +    "ken from this block without decreasing the"/10X,"total tak",
     +    "en from prior blocks by at least ",A,".")') CF(:JF(NB-NF))
        WRITE(6,'()')
      ELSE
        WORD(:24) = '(90(2X,'//CF(:JF(78/(LM+6)))//'(I5,":",A):/)) '
        WRITE(6,'(/" Block ",A," now contains item",A)') BN(NB),
     +    PL(3-JP(NIB):2)
        WRITE(6,WORD) (KBL1(NB,I),IDENT(ABS(LST1(KBL1(NB,I))))(:LM),
     +    I=1,KBL1(NB,0))
        WRITE(6,'(/" Hit RETURN if correct and complete. Otherwise ",
     +    "enter additional indices, or"/" any letter to clear list",
     +    " and start again.  Remember that entering just TWO"/
     +    " indices selects all the indices in that interval."/)')
      END IF
      CALL GETLST(KBL1(NB,0),LIST,J,NV)
      IF(J==-1) KBL1(NB,0) = 0
      IF(J/=0) GOTO 82 ! If GETLST added any items, J will be new NIB
      IF(NIB==0) THEN ! J=0=NIB just if block is to get all remaining items
        KK = 0
94      KK = 1-KK
        IF(KK/=0) WRITE(6,'(/" To make this remaining-items block ",
     +    "fully dependent, hit RETURN.  Otherwise,"/" enter anythin",
     +    "g to restrict its dependencies on the other blocks.")')
        IF(KK==0) WRITE(6,'(/" To restrict the dependencies of this",
     +    " remaining-items block, hit RETURN."/" Otherwise, enter an",
     +    "ything to make it dependent on all the other blocks.")')
        CALL SCAN(J,0,'B',5)
        IF(J/=0) GOTO 94
        GOTO 110
      END IF
      NCL = NCL+NIB
C   Put raw dependency structure into KBLB
      IF(NB==1) GOTO 80
      NJ = KBLB(NB,0)
      WORD(:3) = ''
      IF(KND==1) CALL SUBST(WORD(:3),'','#^#')
      IF(NB>1) WRITE(6,'(6X,A,"  Specify this block''s dependen",
     +  "cies ",A)') WORD(:3), WORD(:3)
      IF(NEW==1) WRITE(6,'(/" Enter letter indices of any lower ",
     +  "blocks on which block ",A," is dependent.")') BN(NB)
97    WORD(:12) = '.           '
      IF(NX>0) WORD(:12) = ' (except X).'
      IF(NJ==0) WRITE(6,'(/" Block ",A," is now dependent on NO ",
     +  "other blocks",A)') BN(NB), WORD(:12)
      IF(NJ>0) WRITE(6,'(/" Block ",A," is now dependent on pri",
     +  "or block",A,8A2,10(:/5X,25A2))') BN(NB), PL(3-JP(NJ):2),
     +  (BN(KBLB(NB,I)),I=1,NJ)
      WRITE(6,'(/" Hit RETURN if OK.  Otherwise, enter correct strin",
     +  "g of prior block codes"/" (letters) or any number to clear ",
     +  "list and try again."/)')
      READ(5,'(A)') WORD(:60)
      CALL LAST(J,WORD(:60),60)
      IF(J==0) GOTO 80
      CALL CAP(WORD,J)
      NJ = 0
      DO I = 1,NB-1
        L = 0
        DO K = 1,J
          IF(I+64==ICHAR(WORD(K:K))) L = 1
        END DO
        IF(L==0) CYCLE
        NJ = NJ+1
        KBLB(NB,NJ) = I
      END DO
      KBLB(NB,0) = NJ
      GOTO 97
C   Put remaining items into fully dependent block
110   NJ = 0
      LPZ: DO I = 1,NV
        DO K = 1,NCL
          IF(I==BV(K)) CYCLE LPZ
        END DO
        NJ = NJ+1
        KBL1(NB,NJ) = I
      END DO LPZ
      KBL1(NB,0) = NJ
      NJ = NB-1
      DO I = 1,NJ
        KBLB(NB,I) = I
      END DO
      KBLB(NB,0) = NJ
      N = NV - NCL
      NCL = NV
      IF(KK==0) GOTO 97  ! Permit revision of restricted-block dependencies
      WRITE(6,'(/" The ",A," items that remain are all assigned to ",
     +  "the fully-dependent block.")') CF(:JF(N))
C
C Block specifications are complete; now review
120   WRITE(6,'(/" The block assignments of your items are now")')
121   DO I = 0,NB
        IB = I
C          IF(I==NB .AND. NB0<NB) IB = 99
        IF(KBL1(I,0)>0) THEN
          DO J = 1,KBL1(I,0)
            LIST(J) = KBL1(I,J)
          END DO
          WORD(:17) = '   Block '//BN(IB)//' items:'
          CALL PRLST(6,KBL1(I,0),LIST,WORD,17,17,79)
        END IF                  !  ^  Previously used BL here
      END DO
C   Insure that block structure is fully transitive
      DO K = 2,NB
        LIST(MV) = KBLB(K,0)
        DO I = 1,KBLB(K,0)
          LIST(I) = KBLB(K,I)
        END DO
        DO L = 1,KBLB(K,0)
          KI = KBLB(K,L)
          DO I = 1,KBLB(KI,0)
            LIST(MV) = LIST(MV) + 1
            LIST(LIST(MV)) = KBLB(KI,I)
          END DO
        END DO
        KBLB(K,0) = 0
        DO I = 1,K-1
          M = 0
          DO J = 1,LIST(MV)
            IF(LIST(J)==I) M = 1
          END DO
          IF(M==1) KBLB(K,0) = KBLB(K,0) + 1
          IF(M==1) KBLB(K,KBLB(K,0)) = I
        END DO
      END DO
      IF(NX<=0) WRITE(6,'(/" Block dependencies:")')
      IF(NX>0) WRITE(6,'(/" Block dependencies additional to gl",
     +  "obal dependence on implicit block X:")')
      JL = 0
      DO J = 1,NB
        J1 = KBLB(J,0)*MIN(1,KBL1(J,0)) ! Skip if block is empty or has no dependencies
        JL = JL+J1
        IF(J1/=0) WRITE(6,'(3X,"Block ",A," is dependent on block",A,
     +    10(1X,A))') BN(J), PL(3-JP(J1):2), (BN(KBLB(J,K)),K=1,J1)
      END DO
      IF(JL==0) WRITE(6,'(4X,"None")')
      IF(QQ) CALL WAIT(0)
      IF(QQ) GOTO 135  ! IF QQ = T, block structure was loaded from BLKREC
      IF(.NOT.QN) WRITE(6,'(/" Hit RETURN if this is the block struc",
     +  "ture you want.  Otherwise,"/" enter anything to re-do.")')
      IF(QN) WRITE(6,'(/" Hit RETURN to accept this structure.  Other",
     +  "wise, enter any number"/" to modify it, or any letter to go ",
     +  "for an alternative.")')
      CALL SCAN(J,0,'R',5)
      IF(J==0) GOTO 135
      IF(QN .AND. J<0) GOTO 64
      NEW = 0
      DO I = 1,MF
        KBL1(I,0) = -KBL1(I,0)
      END DO
      GOTO 75
C
135   NB1 = NB+1
      IF(KBLB(NB,0)==NB-1) QY = .TRUE.  ! QY=T flags block NB as fully dependent
      DEALLOCATE ( LIST )
      ALLOCATE ( BZ(MV,MF), CVF(MV,MF),CVE(MV,MV), KBZ(MB,0:MF) )
      KBZ = 0; CVF = 0.
140   NLF = NF1  ! Entry for revision of block factoring
      NLV = NV
C       NLF is number of factors remaining to be fixed; NLV is number of
C       variables remaining to fix them.
C
C For each item block, partial out prior factors on which it is dependent,
C find its (residual) eigenstructure, choose number of factors to be taken
C from this block, and find the covariances of these factors with all items
C and the other factors already chosen.  If QW=T at end, put all remaining
C factors in a residual block with block code -1.

      OPEN(10,STATUS='SCRATCH',FORM='UNFORMATTED')
      BBIG: DO IB = 1,NB1 ! Block NB1 is nonempty if Waifs exist after IB=NB pass
C       List in KBZ(IB,_) all factors on which block IB is dependent (its Z-set)
        NIB = KBL1(IB,0)
        NZ = 0
        IF(QW .AND. IB==NB1) KBLB(IB,0) = NB  ! QW=T can be set on IB=NB pass
        IF(KBLB(IB,0)==0) GOTO 160
        IF(QW .AND. IB==NB1) THEN
          NW = NLF
          WRITE(6,'(/" Computing ",A," residual factor",A," (""Waifs"")"
     +      " not claimed by any item block.")') CF(:JF(NLF)),
     +      PL(3-JP(NLF):2)
          QWW = .TRUE.     ! QWW = T flags that Waifs will have been computed
          NZ = NF-NLF
          KBZ(NB1,0) = NZ
          DO I = 1,NZ
            KBZ(NB1,I) = I
          END DO
          KBL1(NB1,0) = NV
          NIB = NV
          DO I = 1,NV
            KBL1(NB1,I) = I
          END DO
          DO I = 1,NB
            KBLB(NB1,I) = I
          END DO
          KBLF(NB1,0) = NLF
          DO I = 1,NLF
            KBLF(NB1,I) = NZ+I
          END DO
        ELSE
          NZ = 0
          DO I = 1,KBLB(IB,0)
            DO J = 1,KBLF(KBLB(IB,I),0)
              NZ = NZ + 1
              KBZ(IB,NZ) = KBLF(KBLB(IB,I),J)
            END DO
          END DO
          KBZ(IB,0) = NZ
        END IF
C     Put regress weights of block's remote source factors for its items into BZ
        IF(NZ==0) GOTO 160
        ALLOCATE ( W1(MVV) )
        IF(NZ==1) THEN               !       BZ(globalitems,localfactors)
          DO I = 1,KBL1(IB,0)        !  [ could just as well be local items ]
            BZ(KBL1(IB,I),1) = CVF(KBL1(IB,I),KBZ(IB,1))
          END DO
        ELSE
          DO J = 1,NZ
            DO I = 1,J
              W1(LO(I,J)) = CFF(LOC(KBZ(IB,I),KBZ(IB,J)))
            END DO
          END DO
          CALL EIGS(NZ,0,W1,LO(NZ,NZ),R1,W1,1,NZ,IER,7)   ! JOB=NZ calls Ginv(W1)
          DO I = 1,NIB             !     ^ Dummy; MF=0 flags no eivecs
            DO J = 1,NZ
              S = 0.D0
              DO K = 1,NZ
                S = S + CVF(KBL1(IB,I),KBZ(IB,K))*W1(LOC(K,J))
              END DO
              BZ(KBL1(IB,I),J) = S
            END DO
          END DO
        END IF
        DEALLOCATE ( W1 )

C     Compute covariances of all items with item residuals in block IB;
C     submatrix for block-IB items comprises this block's residual covars.
160     DO I = 1,NV
          DO J = 1,NIB
            J1 = KBL1(IB,J)
            S = 0.D0
            DO K = 1,NZ
              S = S + CVF(I,KBZ(IB,K))*BZ(KBL1(IB,J),K)
            END DO
            CVE(I,J1) = CV(LOC(I,J1)) - S     ! CVE(global-items,global-items)
          END DO
        END DO
C         ###  Last use of CV in this loop of BBIG (but usually more to come)
C         Any waif factors will overwrite all NV columns of CVE on loop NB+1
C
C     Find eigenstructure of block-IB residuals
        IF(NLF==0) THEN
          NL = 0  ! NL will be at end the number of factors in block Y.
          IF(NIB>0) WRITE(6,'(/" No free factors remain to be fix",
     +      "ed by item-block ",A)') BN(IB)
          WRITE(10) 0       ! Record all blocks for SHONFT retrieval
          GOTO 202
        END IF
        M = MAX(0,NLF-(NLV-NIB))  ! NLF includes items in this block
C        IF(.NOT.QW.AND.M>0) WRITE(6,'(" Full-space retention now r",
C       +  "equires at least ",A," factor",A," from item-block ",A)')
C       +  CF(:JF(M)), PL(JP(M):2), BN(IB)
        NN = MIN(NIB,NLF)
        NLB = MIN(NIB,NF-NZ) ! Max in block allowed by path-antecedents
        ALLOCATE ( C1(NIB,NIB), T1(NIB,NLB) ) ! T1 gets eigvecs of NIB block items on NLB factors
        DO I = 1,NIB
          DO J = I,NIB
            C1(I,J) = CVE(KBL1(IB,I),KBL1(IB,J))
            C1(J,I) = C1(I,J)
          END DO
        END DO
        LL = IB
        IF(IB==NB .AND. LB>0) LL = 99
        IF(LL==99) NLB = NN
        IF(.NOT.QWW) WRITE(6,'(" Computing eigenvalues for block ",A)')
     +    BN(LL)
        IF(NN>0) CALL EIGS(NIB,NLB,C1,NIB,R1,T1,NIB,1,IER, 6)
        DEALLOCATE ( C1 )
        IF(QW .AND. IB==NB1) THEN  ! Save Waif eigvecs; don't need for other blocks
          NW = NLB
          DO J = 1,NW
            S = MAX(0.,SQRT(R1(J)))
            DO I = 1,NV  ! For Waifs, NIB = NV
              T1(I,J) = S*T1(I,J)  ! T1 now holds Waif loadings on prin facs
            END DO
          END DO
        END IF
        WRITE(10) NLB,(R1(J),J=1,NLB)  ! Record all blocks for SHONFT retrieval
C          All eigenvalues for block IB are saved in line IB of scratchfile 10
        IF(.NOT.QWW) THEN
          WORD(:5) = ' is  '; IF(NLB>1) WORD(:5) = 's are'
          WRITE(6,'(/" The block ",A," residual eigenvalue",A,5(/2X,2(
     +      2X,5A7)) )') BN(LL), WORD(:5), (CLN(R1(I),7,3),I=1,NLB)
        END IF
        NL = 0
        DO I = 1,NLB
          IF(R1(I)>=EVAL) NL = NL+1
        END DO
        IF(QWW .OR. LL==99) THEN      !    CVE(1+local-factor,MV+1-IB)
          NL = NN
          GOTO 172
        END IF
        NL = MAX(NL,M)
C        IF(.NOT.QW.AND.NL==M) WRITE(6,'(/I3," of these are needed to",
C     +    " capture the received factor-space dimensionality."/" But",
C     +    " if you choose less than",I3," factors for this block, the",
C     +    " remainder will"/" be passed to HYBALL as Waifs to be exc",
C     +    "luded from rotation unless you"/" override that default",
C     +    " setting there.")') NL, NL
170     WRITE(6,'(/5X,"The number of factors to be taken from this bl",
     +    "ock is now set at ",A,"."/5X,"Hit RETURN if OK, or enter ",
     +    "number wanted no greater than ",A,".")') CF(:JF(NL)),
     +    CF(:JF(NN))
        IF(NLB<NIB) WRITE(6,'(5X,"(More than this limit would create",
     +    " collinearities.)")')
        IF(KBLF(IB,0)>0) WRITE(6,'(5X,"(Previous choice for this bl",
     +    "ock was ",A,".)")') CF(:JF(KBLF(IB,0)))
        WRITE(6,'()')
        CALL SCAN(J,1,'I',5)
        IF(J<0) GOTO 170
        IF(J==0) GOTO 172
        READ(2,*) NL
        NL = MAX(0,MIN(NL,NN))
        GOTO 170
172     KBLF(IB,0) = NL
        DO I = 1,NL
          KBLF(IB,I) = NF-NLF+I
        END DO
C         Factor indices in block IB are listed in KBLF(IB,_); NL = 0 is OK
        NLF = NLF - NL
        NLV = NLV - NIB
        IF(NLF>NLV) QW = .TRUE.
        IF(.NOT.QW.AND.NLF>0) WRITE(6,'(/" After block ",A,", ",A,
     +    " factor",A,"remain",A,"to be fixed by ",A," remaining ",
     +    "item",A)') BN(IB), CF(:JF(NLF)), PL(3-JP(NLF):2),
     +    PL(JP(NLF):2), CF(:JF(NLV)), PL(3-JP(NLV):2)
C
C     Save transposed L-inverse of block-IB residuals' pattern on retained factors
        DO J = 1,NL
          S = SQRT(R1(J))
          DO I = 1,NIB  ! ********** Has recent change affected this ????
            A1(KBL1(IB,I),NX+J) = T1(I,J)/S  ! A1(global-items,NX+local-factors)
          END DO
        END DO
        IF(.NOT.(QW.AND.IB==NB1)) DEALLOCATE ( T1 )
        IF(NL==0) CYCLE BBIG  ! Don't do^ if for Waifs on last pass through loop
C
C     Compute covars of all items with factors from block IB
        DO I = 1,NV
          DO J = 1,NL
            S = 0.
            DO K = 1,NIB
              KK = KBL1(IB,K)
              S = S + CVE(I,KK)*A1(KK,NX+J)      ! Last use of CVE covariances
            END DO
            CVF(I,KBLF(IB,J)) = S               ! CVF(global-items,global-factors)
          END DO
        END DO
C   Compute covars of block-IB factors with all factors set so far.
C     Start with orthonormality within block IB
        DO I = 1,NL
          I1 = KBLF(IB,I)
          CFF(LO(I1,I1)) = 1.
          DO J = I+1,NL
            CFF(LO(I1,KBLF(IB,J))) = 0.        ! CVF(global-factors,global-factors)
          END DO
        END DO
C   For each factor block IA prior to IB, get the covariance of the block-IA
C   factors with all factors in prior blocks.
        BG: DO IA = 1,IB-1
C     Put into workspace W the covars of (the parts Yi* of block-IB items Yi
C     regressed on their remote sources) with (the factors in prior block IA)
          ALLOCATE ( W(NIB,MF) ); W = 0.
          DO I = 1,NIB     ! Do for each item in block IB
            I1 = KBL1(IB,I)
            DO J = 1,KBLF(IA,0)  ! and each factor in block IA
              J1 = KBLF(IA,J)
              S = 0.
              DO K = 1,KBZ(IB,0)
                KK = KBZ(IB,K)
                S = S + BZ(I1,K)*CFF(LOC(KK,J1))  ! W(local-items,local-factors)
              END DO
              W(I,J) = S  ! W is items-by-factors; used only from here to end of BG
            END DO
          END DO
C     Now subtract W out of covars of block-IB items with the IA factors,
C     and multiply by L-inverse of the IB-item loadings on the IB factors
          DO K = 1,KBLF(IB,0)
            K1 = KBLF(IB,K)
            DO J = 1,KBLF(IA,0)
              J1 = KBLF(IA,J)
              S = 0.                     !  A1(KBL1(IB,I),NX+J)  L-inverse
              DO I = 1,NIB
                I1 = KBL1(IB,I)
                S = S + A1(I1,NX+K)*(CVF(I1,J1)-W(I,J))
              END DO
              CFF(LOC(K1,J1)) = S
            END DO
          END DO
          DEALLOCATE ( W )
        END DO BG
      END DO BBIG  ! End of big loop.  If QW, Waifs are in block NB+1

C Display factors per block and permit revision
202   NB0 = NB
      IF(.NOT.QW) NB1 = NB
C  NB0 = NB  NB1 = NB0+1 if there are waifs
C  Will have NB0 = NB-1 if QY=T
      IF(QWW) THEN
CC       Reminder: The Waif pattern on their prin-axes isn't the same as
CC                 the data loadings computed later on the waif factors.
        IF(NW>1) WRITE(6,'(/" Hit RETURN to see details on the Waif''",
     +    "s orthogonal rotation to simple"/" structure for clues",
     +    " to augmenting your assignments of factors to blocks."/1X,
     +    "Otherwise, enter anything to omit this Waif information.")')
        IF(NW==1) WRITE(6,'(/" Hit RETURN to see how the salient ",
     +    "loadings on your singleton Waif factor"/" are distributed",
     +    " over your factor blocks.  Otherwise, enter anything to "/
     +    " omit this information.")')
        CALL SCAN(J,0,'B',5)
        IF(J/=0) GOTO 203
        IF(NW>1) THEN
          WRITE(6,'(/" Rotating Waifs to Varimax simple structure")')
          CALL VARIM(T1,NV,NW,1.,IER)
        END IF
        NWW = MIN(9,NW)
        CUT = .20
        OPEN(28,STATUS='SCRATCH')
        REWIND 28
        IF(NWW>=NW) WRITE(6,'(/"  For your choice of salience thres",
     +    "hold CUT, you will be shown for each")')
        IF(NWW<NW) WRITE(6,'(/"  For your choice of salience thres",
     +    "hold CUT, you will see for each leading")')
        WRITE(6,'("  rotated Waif factor the size (RMS) and number of",
     +    " loadings on that factor"/"  which exceed CUT over the ite",
     +    "ms separately in each block A,..,",A,".  The"/"  rotated ",
     +    "Waifs will be displayed in order of decreasing strength (",
     +    "RMS*Number)"/"  over all blocks combined) at this CUT lev",
     +    "el, and you can repeat this display"/"  at varied CUT lev",
     +    "els.")') BN(NB)
410     WRITE(6,'(/5X,"Hit RETURN to see the Waif display at CUT = ",
     +   A3,".  Otherwise, enter"/5X,"another choice of CUT or any l",
     +   "etter to waive more Waif information."/)') CLN(ABS(CUT),3,2)
        CALL SCAN(J,0,'R',5)
        IF(J<0) GOTO 203
        IF(J>0) THEN
          READ(2,*) CUT
415       IF(CUT>=.9) CUT = CUT*.1
          IF(CUT>=.9) GOTO 415
          CUT = MAX(.05,CUT)
          GOTO 410
        END IF
        CUT = ABS(CUT)
        CALL WAIFS(CUT,NV,NB,MB,NW,MF,T1,KBL1)  ! Last use of T1 (not passed to HYBALL)
        CUT = CUT-.05  ! Increase magnitude by .05
        GOTO 410
203     DEALLOCATE ( T1 )
      END IF
      QN = QY
      IF(QW) QY = .FALSE.  ! HYBALL will get Waifs, so no Y-factors
      CALL SHONFT(NB,MV,MB,QW,QY,KBLF,KP,FMT3,6) ! Display eigvals for blocks
      WRITE(6,'(/" Enter anything if you want to revise these choi",
     +  "ces. Otherwise, hit RETURN.")')
      CALL SCAN(J,0,'B',5)
204   IF(J/=0) THEN
        QW = .FALSE.
        QWW = .FALSE.
        QY = QN
        CLOSE(10)
        GOTO 140 ! Reallocations never continue beyond this point
      END IF
      IF(QY) NB0 = NB-1

C Compute pattern on block-structured factors
      ALLOCATE ( W1(NFF) )
      DO I = 1,NF1
        DO J = I,NF1
          W1(LO(I,J)) = CFF(LO(NX+I,NX+J))
        END DO
      END DO
      CALL EIGS(NF1,0,W1,LO(NF1,NF1),R1,W1,1,NF1,IER,7)   ! JOB=NF calls Ginv(W)
      DO I = 1,NV
        DO J = 1,NF1
          S = 0.
          DO K = 1,NF1
            S = S +  CVF(I,NX+K)*W1(LOC(K,J))
          END DO
          A1(I,NX+J) = S
        END DO
      END DO
CC TEST LINES. Check accuracy: Are the item covars preserved?
C      DIFF = 0
CC      OPEN(21,FILE='JUNK')
C      DO I = 1,NV
C        DO J = I,NV
C          S = 0.
C          DO K = 1,NF1
C            DO L = 1,NF1
C              S = S + A1(I,NX+K)*CFF(LOC(K,L))*A1(J,NX+L)
C            END DO
C          END DO
C          IF(I==J) W1(I) = S
C          DF = ABS(S-CV(LO(I,J)))
C          IF(DF>.005) WRITE(21,'(" For items <",2I3,">, old vs.",
C     +      " new CV are",2F8.2)') I, J, CV(LOC(I,J)), S
C          DIFF = MAX(DIFF,DF)
C        END DO
C      END DO
C      WRITE(21,'(/" The item covars have been preserved with maxi",
C     + "mum error",F8.4)') DIFF
CCC      WRITE(21,'(/" The original communalities were"/25A4)')
CCC     + (CLN(COMM(I),4,2),I=1,NV)  ! *** COMM not now defined
C      WRITE(21,'(" Orginal communalities are retained in CV as"/
C     + 50A4)') (CLN(CV(LO(I,I)),4,2),I=1,NV)
C      WRITE(21,'(/" The exiting communalities are"/50A4)')
C     + (CLN(W1(I),4,2),I=1,NV)
C      WRITE(21,'(" The computed pattern on",I3," factors is:")') NF1
C      DO I = 1,NV
C        WRITE(21,'(I3,":",20A6)') I, (CLN(A1(I,NX+J),6,2),J=1,NF1)
C      END DO

      DEALLOCATE ( W1, CVF )
C Allow permutation of variables' indices to increase in block sequence
1      NV = NVX
      NXX = NX
      NX = 0
      WRITE(6,'(/" If you want HYBALL to receive your variables re-o",
     +  "rdered in ascending block"/" sequence, hit RETURN.  Otherw",
     +  "ise, enter any letter to keep present order,"/" or any num",
     +  "ber to reconsider your block-factoring choices."/)')
      CALL SCAN(J,0,'R',5)
      IF(J>0) THEN
        ALLOCATE ( CVF(MV,MF) ); GOTO 204
      END IF
      ALLOCATE ( PERM(MV) )
      DO I = 1,NV
        PERM(I) = I
      END DO
      IF(J<0) GOTO 225
      M = 0
      DO K = 0,NB
        DO I = 1,KBL1(K,0)
          M = M+1
          PERM(M) = KBL1(K,I)
        END DO     ! PERM lists items' input indices in block sequence
      END DO
      QP = .TRUE.
C
C List variables' (LIST) and factors' (BL) block codes
225   ALLOCATE ( BS(MB), LIST(MV), BL(MV) )
      DO IB = 0,NB
        I = IB
        IF(QY .AND. IB==NB) I = 99   ! Flag Y-items only for last block
        DO J = 1,KBL1(IB,0)    ! BV lists items' block code in block sequence
           BV(KBL1(IB,J)) = I  ! Will write block assignments of items to BLOKREC
        END DO
      END DO
      DO I = 1,NV
        LIST(I) = BV(PERM(I))  ! LIST lists items' block code in input sequence
      END DO
      DEALLOCATE ( KBL1 )
C  Now set block codes in BL
      IF(QWW) THEN   ! At this point should have QWW iff QW
        DO I = 1,KBLF(NB1,0)
          BL(KBLF(NB1,I)) = -1
      END DO
      ELSE IF(QY) THEN
        DO I = 1,KBLF(NB,0)  ! Record in the Y-block line of KBLF
          BL(KBLF(NB,I)) = 99
        END DO
      END IF
C        Code for Y-block has been copied into BL; now do rest
      DO I = 1,NXX
        BL(I) = 0
      END DO
      DO IB = 1,NB0
        DO J = 1,KBLF(IB,0)
          BL(KBLF(IB,J)) = IB
        END DO
      END DO
C
C  If there are Y-factors, their block index is NB
C  Translate block structure into compressed binary HYBALL code
      DO I = 1,NB
        BS(I) = 0
        DO J = 1,KBLB(I,0)
          BS(I) = BS(I) + 2**(KBLB(I,J)-1)
        END DO
      END DO
C         HYBALL compressed code for block structure is now in BS
C Save assigned block structure in BLOKREC file F4
      IF(QQ) GOTO 300  ! QQ=T only if structure was loaded from BLKREC and unrevised
      OPEN(4,FILE=F4)
      CLOSE(4,STATUS='DELETE')
      OPEN(4,FILE=F4)
      WRITE(4,'(A," Last block structure defined for this MODA-output",
     +  " file")') F2
      WRITE(4,'(6(1X,A))') CF(:JF(NV-NXX)), CF(:JF(NF)), CF(:JF(NXX)),
     +  CF(:JF(KODE)), CF(:JF(NB0)), CF(:JF(NB))
      WRITE(4,'(50(1X,A),20(:/3X,50(1X,A)))') (CF(:JF(BV(I))),I=1,NV)
      WRITE(4,'(10(1X,A),3(:3X,10(1X,A)))') (CF(:JF(BS(I))),I=1,NB)
      CLOSE(4)
C
C Send structured pattern to HYBALL-input F3 and SEE-file F7
300   OPEN(3,FILE=F1,FORM='UNFORMATTED')
      KODE = -KODE
      WRITE(3) NV, NF, NX, KODE, MTH, F0   ! F0 passes the COV-file name
      WRITE(3) ((A1(PERM(I),J),I=1,NV),J=1,NF)
      IF(.NOT.QP) GOTO 305
        BACKSPACE 3
        READ(3) ((A1(I,J),I=1,NV),J=1,NF)
C         Pattern is now permuted to new item order
305   WRITE(3) NF, NFF
      WRITE(3) (CFF(I),I=1,NFF)
      WRITE(3) (BL(I),I=1,NF), (LIST(I),I=1,NV)
      WRITE(3) NB0, (BS(I),I=1,NB0)
      WRITE(3) (LST0(LST1(PERM(I))),I=1,NVX)
      IF(NBO==0) GOTO 310
      DO I = 1,NBO      ! Need PERM-inverse
        Z = ABS(OFFL(I)); J = INT(Z)
        DO K = 1,NV
          IF(PERM(K)/=J) CYCLE
            OFFL(I) = SIGN(K+Z-J,OFFL(I))
        END DO
      END DO
      WRITE(3) NBO, (OFFL(I),I=1,NBO)
      CLOSE(3)
C
C  Display FIX-coded block structure
310   MBB = MAX(8,2*((NB+1)/2))
      M = (MBB-6)/2
C       MAX(8,...) in MBB insures that M is at least 1
      CH1 = CHAR(48+M/10)//CHAR(48+MOD(M,10))
      MM = 0
      DO I = 1,NB1
        MM = MAX(MM,KBLF(I,0))
      END DO
      IF(NL<(65-MBB)/3) NN = MAX(30,3*MAX(MM,NL))
      IF(NL>=(65-MBB)/3) NN = MAX(30,3*MM)
      CH2 = CHAR(48+NN/10)//CHAR(48+MOD(NN,10))
      WRITE(6,'(/" At job completion, the factors in each block, ",
     +  "and the DepOn profile "/" of blocks on which it ",
     +  "is dependent, are")')
      WRITE(7,'(/" These factors were rotated to have the following",
     +  " block structure.")')
      FMT3 = '(/"  Block  ",'//CH1//'(" "),"DepOn ",'//CH1//
     +  '(" "),"   Indices of factors in block")'//'       '
      IF(KND>0) CALL TRLIN(FMT3(:90))
      WRITE(6,FMT3); WRITE(7,FMT3); FMT3 = ' '
      FMT3 = '(" ",'//CH1//'(""),"",'//CH1//
     +  '(""),"",'//CH2//'(""))'
      IF(KND>0) CALL TRLIN(FMT1(:90))
      WRITE(7,FMT3); WRITE(6,FMT3); FMT2 = ' '
      FMT2 = '(4X,A,3X,"'//TR('')//'",1X,A,"'//TR('')//'",50I3)'
      IF(NXX>0) THEN
        WORD = ' '
        WORD(M+2:M+5) = 'none'
        DO KF = 6,7
          WRITE(KF,FMT2) 'X', WORD(:MBB), (I,I=1,NXX)
        END DO
      END IF
      DO IB = 1,NB0
        WORD(:30) = '                              '
        KW = MIN(1,NXX)
        IF(KW>0) WORD(1:1) = 'X'
        K = BS(IB)
        DO I = 1,IB
          IF(MOD(K,2)>0) THEN
            KW = KW+1
            WORD(KW:KW) = BN(I)
          END IF
          K = K/2
        END DO
        WORD(KW+1:KW+1) = BN(IB)
        DO KF = 6,7
          WRITE(KF,FMT2) BN(IB), WORD(:MBB), (KBLF(IB,J),J=1,
     +      KBLF(IB,0))
        END DO
      END DO
      DEALLOCATE ( BS, BV )
      IF(.NOT.QY) GOTO 330
      WORD(:9) = '"all   ",'
      IF(NL*3>NN) THEN
        FMT2 = '(4X,"Y    ",'//CH1//'(" "),'//WORD(:9)//CH1//
     +    '(" "),"  all remaining factors"'//WORD(5:5)//'         '
        IF(KND>0) CALL TRLIN(FMT2(:90))
        WRITE(6,FMT2)
        WRITE(7,FMT2)
      ELSE
        FMT2 = '(4X,"Y    ",'//CH1//'(" "),'//WORD(:9)//CH1//
     +    '(" "),"",50I3)'//'                  '
        IF(KND>0) CALL TRLIN(FMT2(:90))
        WRITE(6,FMT2) (KBLF(NB,J),J=1,KBLF(NB,0))
        WRITE(7,FMT2) (KBLF(NB,J),J=1,KBLF(NB,0))
      END IF
330   IF(QW) THEN
        FMT2 = '("  Waifs  ",'//CH1//'(" "),"      ",'//
     +    CH1// '(" "),"",50I3)'//'                  '
        IF(KND>0) CALL TRLIN(FMT2(:90))
        WRITE(6,FMT2) (KBLF(NB1,J),J=1,KBLF(NB1,0))
        WRITE(7,FMT2) (KBLF(NB1,J),J=1,KBLF(NB1,0))
      END IF
      CALL SUBST(FMT3,TR(''),TR(''))
      WRITE(6,FMT3)
      WRITE(7,FMT3)
      CALL SHONFT(NB,MV,MB,QW,QY,KBLF,KP,FMT3,7) ! Display eigenvalues for blocks
      DEALLOCATE ( CVE )
      IF(CUT>=0) GOTO 335    ! Last WAIFS call, if any, was unsuccessful
      WRITE(7,'()')
      REWIND 28  ! Copy last WAIFS appraisal to SEE-file
333   READ(28,'(A)',END=335) WORD  ! Format reads only 1st word in line
      CALL LAST(J,WORD,250)
      IF(WORD(1:1)=='M' .OR. WORD(1:5)=='Waifs') THEN
        WRITE(7,'(5X,A)') WORD(:J)
      ELSE IF(WORD(1:1)=='W') THEN
        WRITE(7,'(2X,A)') WORD(:J)
      ELSE IF(WORD(2:2)==':') THEN
        WRITE(7,'(3X,A)') WORD(:J)
      ELSE
        WRITE(7,'(1X,A)') WORD(:J)
      END IF
      GOTO 333

C  Send block-structured pattern/covars to RESULTS file F3
335   IF(.NOT.QP) GOTO 337
      WRITE(7,'(/" The variables were put into ascending block orde",
     +  "r by permutation <.., new list position of item with input ",
     +  "index stated, ...>:")')
      IF(KP>=100) WRITE(7,'(10(:/2X,5(2X,5I4)))') (PERM(I),I=1,NV)
      IF(KP<100) WRITE(7,'(20(:/2X,3(2X,5I4)))') (PERM(I),I=1,NV)
      IF(F2(:3)=='   ' .OR. IDENT(1)(:2)=='??') GOTO 337
      IF(KP>=100) WRITE(7,'(/" Their name sequence is now",100(:/
     +  10(I5,": ",A)))') (I,IDENT(ABS(LST1(PERM(I))))(:LM),I=1,NV)
      IF(KP<100) WRITE(7,'(/" Their name sequence is now",150(:/
     +  5(I4,": ",A,2X)))') (I,IDENT(ABS(LST1(PERM(I))))(:LM),I=1,NV)
337   DEALLOCATE ( LST1, PERM )
      ALLOCATE ( C1(MV,MV) )
      DO I = 1,NF
        DO J = I,NF
          C1(I,J) = CFF(LO(I,J))
          C1(J,I) = C1(I,J)
        END DO
      END DO
      WRITE(7,'(/" The rotated pattern, with the letter-coded block",
     + " to which each item belongs shown in parentheses, is")')
      IF(KP>=100) FMT1 = '(4X,7X,3(2X,5A5),90(:/14X,3(2X,5A5)))'
      CALL SHOW(NVX,QP,FMT1,A1,C1,LIST,-7)  ! LIST indexes items' block assignment
      WRITE(7,'(/" The block codes for these factors sent to ",A,
     +  " are",5(/12(I3," ",A,:,",")))') F1(:LF1),
     +  (I,BN(BL(I)),I=1,NF) ! Rem: BN maps INTEGER indices into letter indices
      DEALLOCATE ( C1, CFF, LIST, BL )
      IF(.NOT.QW) GOTO 370
C Show Waifed residual covars (Note: A1 holds the NVxNF pattern with variables in final order)
      WRITE(6,'(/" To examine the items'' common-part covariances re",
     +  "siduated in Waif factors,"/" hit RETURN.  Otherwise, enter ",
     +  "anything to waive this information.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 370
      SE = 0.
      DO J = 2,NV    ! Only do off-diagonal residuals
        DO I = 1,J-1
          S = 0.
          DO K = NF-NW+1,NF
            S = S + A1(I,K)*A1(J,K)
          END DO
          CV(LO(I,J)) = S
          SE = SE + S*S
        END DO
      END DO
      SE = SQRT(SE/LO(NV-1,NV-1))
      CUT = MAX(.05,AINT(20*2*SE)/20)  ! Round 2*SE down to integral multiple of .05
      DEALLOCATE ( A1 )
      ALLOCATE ( LS1(MVV) )
350   KF = 0
      DO J = 2,NV
        DO I = 1,J-1
          S = ABS(CV(LO(I,J)))
          IF(SNGL(S)<=CUT) CYCLE
          KF = KF+1
          LS1(KF) = 1000000*NINT(SNGL(S)*1000) + 1000*I + J
        END DO
      END DO
      WRITE(6,'(/7X,A," of the proper Waif-residual covariances (excl",
     +  "uding variances)"/7X,"exceed Cut ",A3,", which is ",A3," tim",
     +  "es their RMS residual (",A4,").  Hit"/7X,"RETURN to record ",
     +  "these.  Otherwise enter another Cut level, or"/7X,"any lett",
     +  "er to waive listing of large Waif-residual covariances."/)')
     +  CF(:JF(KF)), CLN(CUT,3,2), CLN(CUT/SE,3,1), CLN(SE,4,3)
      CALL SCAN(J,1,'R',5)
      IF(J<0) GOTO 370
      IF(J>0) THEN
        READ(2,*) CUT
352     IF(CUT>1.) CUT = CUT/10
        IF(CUT>1.) GOTO 352
        CUT = MAX(SE,CUT)
        GOTO 350
      END IF
      ALLOCATE ( LS2(MVV) )
      IF(KF>0) THEN
        CALL SORT(KF,LS1)
        DO I = 1,KF
          LS2(I) = MOD(LS1(I)/1000,1000)
          LS1(I) = MOD(LS1(I),10**3)
        END DO
        WRITE(7,'(/1X,A," of this solution''s proper Waif-residual cov",
     +    "ariances (excluding variances)"/" exceed Cut ",A3,", which ",
     +    "is ",A3," times their RMS residual (",A4,").  Listed in for",
     +    "m"/" ""(i,j; r)"", where i,j are the output indices of vari",
     +    "ables whose Waif-residual"/" correlation is r, these are")')
     +    CF(:JF(KF)), CLN(CUT,4,3), CLN(CUT/SE,3,1), CLN(SE,4,3)
        WRITE(7,'(1000(7("  (",I3,",",I3,";",A5,")",:)/))')
     +    (LS2(I),LS1(I),CLN(CV(LO(LS2(I),LS1(I))),5,-3),I=1,KF)
      END IF
370   WRITE(6,'(/" The pattern with axes repositioned to have this bl",
     +  "ock structure has been"/" sent to file ",A," awaiting HYBALL",
     +  " rotation to simple structure,")') F1(:LF1)
      WRITE(6,'(" and is available for inspection in ASCII file ",A)')
     +  F3(:LF3)
      WRITE(7,'("")')
      STOP
      END
C
      FUNCTION BN(N)
c Converts block integer code N into the block's letter code
      CHARACTER BN
      IF(N==99) THEN
        BN = 'Y'
      ELSE IF(N==0) THEN
        BN = 'X'
      ELSE IF(N<0) THEN
        BN = 'Z'
      ELSE IF(N<88) THEN  ! Letters A-W
        BN = CHAR(64+N)
      ELSE
        BN = CHAR(N-39)  ! Continue with digits starting with 1
      END IF
      END FUNCTION
C
      SUBROUTINE CAP(WORD,L)
C This makes the first L letters in WORD all upper-case.
      CHARACTER WORD*(*)
      DO I = 1,L
        N = ICHAR(WORD(I:I))
        IF(N>=97 .AND. N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      END SUBROUTINE
C
      SUBROUTINE CHECK(NF,KODE,N,NFF)
C  Screen out inappropriate input files
      IF(NFF/=N*(N+1)/2) THEN
        WRITE(6,'(/" This input file does not include properly-recor",
     +   "ded covariances"/" ( <NF,NFF> = <",I2,I4,"> )")') N,NFF
        STOP
      ELSE IF(N/=NF) THEN
        WRITE(6,'(/" This input file was produced by QUADFAC ")')
        STOP
      ELSE IF(KODE<0) THEN
        WRITE(6,'(/" This input file has already been structured ",
     +   "by HYBLOCK")')
        STOP
      END IF
      END SUBROUTINE

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
C      SAVED/CF/  ! This doesn't appear to be needed
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      CLN = '        '
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      LD = ABS(ND)
      IF(ABS(X)<1.0E-12) THEN !  Special for vanishingly small X
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X))) !  M is space free for decimal (or M-1 if X<0) )
      IF(M<0 .OR.  M<1.AND.X<0.) GOTO 55
      IF(ND>=10) LD = 0; LD = MIN(LD,M)
      DO I = 1,KW
        WK(I) = ' '
      END DO
      IF(LD==0) N = NINT(ABS(X))         ! Shouldn't be needed, but is
      IF(LD/=0) N = NINT(ABS(X)*10**LD)  ! This can overflow if LD is large
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' *******'
      END FUNCTION
C
      SUBROUTINE GETBLK(NV,NB,LIST,KBL1,FIX,KBLB)
C Load block structure into KBL1 and KBLB; do not touch KBL1(0,_)
      PARAMETER (MB=31)
      INTEGER LIST(*), KBL1(0:MB,0:*), KBLB(MB,0:*)
      INTEGER FIX(*)
      DO I = 1,NB
        KBL1(I,0) = 0
      END DO
      DO I = 1,NV
        IB = MIN(LIST(I),NB)
        KBL1(IB,0) = KBL1(IB,0)+1
        KBL1(IB,KBL1(IB,0)) = I
      END DO
      DO I = 1,NB
        KBLB(I,0) = 0
        N = FIX(I)
        DO J = 1,I
          IF(MOD(N,2)>0) THEN
            KBLB(I,0) = KBLB(I,0) + 1
            KBLB(I,KBLB(I,0)) = J
          END IF
          N = N/2
        END DO
      END DO
      END SUBROUTINE
C
      SUBROUTINE GETLST(N,LIST,J,NV)
C Enter N distinct indices no larger than NV into LIST in sequential order.
C LIST(N+_) receives in order the indices from 1 to NV omitted from LIST.
C LIST may be partly formed at input, SCAN provides the rest.
      INTEGER KW(NV)      ! Workspace
      INTEGER LIST(*)
      EXTERNAL SCAN
      CALL SCAN(J,0,'I',5)
      IF(J<=0) RETURN
      NX = MAX(0,N)
      DO I = 1,NX
        KW(I) = LIST(I)
      END DO
8     READ(2,*) (LIST(I),I=1,J)
      IF(J/=2) THEN
        DO I = 1,J
          KW(NX+I) = LIST(I)
        END DO
        NX = NX+J
      ELSE
        L = MAX(1,MIN(NV,LIST(1),LIST(2)))
        M = MIN(NV,MAX(1,LIST(1),LIST(2)))
        DO I = L,M
          KW(NX+I-L+1) = I
        END DO
        NX = NX+M-L+1
      END IF
25    WRITE(6,'(/" Enter more indices, or hit RETURN if list is ",
     + "complete."/)')
      CALL SCAN(J,0,'I',5)
      IF(J<0) GOTO 25
      IF(J>0) GOTO 8
C Order list with any duplicates removed. (Done in MAIN; not needed here.)
C      CALL SORT(KW,NX,LIST,1,NV)
      DO I = 1,NX
        LIST(I) = KW(I)
      END DO
      N = NX
      J = N
      END SUBROUTINE
C
      SUBROUTINE LAST(L,WORD,M)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as L. If the string is empty, LAST is returned as 0.
      CHARACTER WORD*(*)
      WORD(:M) = ADJUSTL(WORD(:M))
      L = LEN_TRIM(WORD(:M))
      END SUBROUTINE
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
      LOGICAL PRM, QY
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP
      CHARACTER E   ! <<<  Special characters as needed
      WD = GET
      CALL LAST(M,WD,40)
      LL = 1
5     LL = LL+1
      E = WD(LL+1:LL+1)
      IF(E/='|' .AND. E/='/' .AND. LL<M) GOTO 5  ! *** No longer relevant??
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(WORD(:1)==' ' .OR. WORD(:1)=='.') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
C       Filter out lines other than filenames
      CALL LAST(L,WORD,14)
      IF(ICHAR(WORD(11:11))<48.OR.ICHAR(WORD(11:11))>57) GOTO 10
      IF(ICHAR(WORD(:1))>90 .OR. ICHAR(WORD(:1))<65) GOTO 10
      IF(WORD(:4)=='LUMP' .OR. WORD(:5)=='HYBUF') GOTO 10
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
      IF(WORD(:3)=='SEE') GOTO 10
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4) .AND. NAME(I)(L+5:L+5)==' ')
     +    GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NL)
      IF(NL>0) WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      CALL LAST(L1,NAM1,LEN(NAM1)); CALL LAST(L2,NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      CALL LAST(L1,WRD1,LEN(WRD1)); CALL LAST(L2,WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A number terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION
C
      SUBROUTINE NAMEB(F1,EXT,L,CH,F2,LL)
C This receives a filename in F1 (presumed to start in position 1), solves for
C <head> to be the part of F1 prior to '.' up to 8 characters, partitions <head>
C as <hd1,hd2> where <hd1> ends with the last nonnumeric character in <head>,
C and scans the subdirectory for the lowest i=A,B,...,Z such that file
C <hd1,hd2>i.EXT does not already exist.  (<hd1i> is <hd1,i> if length permits,
C else the result of replacing the last char in <hd1> by i.)  Filename
C <hd1,hd2>i.EXT is returned in F1(:12), along with its end position L and
C position M of extension dot.  Finally, F2 is F1 preceded by character CH
C and with the last arbitrary letter in its headname deleted if needed for
C length. LL and MM are the end/decimal positions in F2.
      CHARACTER F1*(*), F2*(*), EXT*(*), QFMT, CH
      L = 0
10    L = L+1
      IF(L<=8 .AND. F1(L:L)/=' ' .AND. F1(L:L)/='.') GOTO 10
      L = L-1
C       L is last position (up to 8) before dot
      K = L+1
15    K = K-1
      J = ICHAR(F1(K:K))
      IF(J>=48 .AND. J<=57) GOTO 15
C       K is position before start of basename's numerical ending
      IF(L<8) THEN
        F1(:L+5) = F1(:L)//'?.'//EXT(:3)
        L = L+1
      ELSE
        F1(K:L+4) = F1(K+1:L)//'?.'//EXT(:3)
        K = K-1
      END IF
C       L remains position of basename end before dot; K+1 is start of num. code
      DO I = L+5,12
        F1(I:I) = ' '
      END DO
      I = 0
20    I = I+1
      F1(L:L) = CHAR(I+64)
      IF(QFMT(F1)/='U' .AND. I<26) GOTO 20
      M = L+1  ! M is now position of dot
      L = L+4  ! L is now end position
      IF(F1(L:L)==' ') L = L-1
      F2(:M+1) = CH//F1(:M)
      IF(M<9) THEN
        MM = M+1
        LL = L+1
      ELSE
        F2(K+1:M) = F2(K+2:M+1)
        MM = M
        LL = L
      END IF
      F2(MM+1:LL) = F1(M+1:L)
      END SUBROUTINE
C
      SUBROUTINE PRLST(KF,NL,LST,WORD,NA,NB,LL)
C Print NL integers from list LST without waste space in lines not exceeding
C length LL, with the first line starting with WORD(:NA) and subsequent lines
C starting with a length-NB blank.
      CHARACTER CB*132, WORD*(*), CF*12
      INTEGER LST(*), NL
      COMMON /CF/ CF
      CB = WORD(:NA)
      L = NA+1
      I = 0
10    I = I+1
      J = JF(LST(I))
      CB(L+1:) = ' '//CF(:J)
      L = L+J+1
      IF(I<NL .AND. L<LL) GOTO 10
      IF(L>LL) THEN
        I = I-1
        L = L-J-1
      END IF
      WRITE(KF,'(A)') CB(:L)
      IF(I>=NL) RETURN
      DO J = 1,NB
        CB(J:J) = ' '
      END DO
      L = NB+1
      GOTO 10
      END SUBROUTINE
C
      SUBROUTINE PRNT(JOB,KP,WORD,KFILE)
C Set printer codes. JOB=0/1/2 if job is find-linewidth/set-normal-print/set-
C HYBALL-pattern-plots.  KP is linewidth. KFILE is file to write.
      CHARACTER QFMT, WORD*55
      IF(QFMT('PRNTR')=='U') THEN
        IF(JOB==0) WRITE(KFILE,'(/" WARNING: There is no printer ",
     +    "definition in this subdirectory.")')
        IF(JOB==1) WRITE(KFILE,'(" %")')
        IF(JOB==2) WRITE(KFILE,'(" #")')
        RETURN
      END IF
      OPEN(1,FILE='PRNTR')
      READ(1,'(A)',END=20,ERR=20) WORD
      IF(WORD(:1)=='*') KP = 80
      IF(JOB==0) GOTO 10
      IF(WORD(:1)/='%') READ(1,'(A)',END=20,ERR=20) WORD
      IF(JOB==1) WRITE(KFILE,'(A)') WORD(3:)
      IF(JOB==1) GOTO 10
      READ(1,'(A)',END=20,ERR=20) WORD
      WRITE(KFILE,'(A)') WORD(3:)
10    CLOSE(1)
      RETURN
20    WRITE(6,'(/" Your PRNTR file is corrupt. Delete or replace ",
     + " this and try again.")')
      STOP
      END SUBROUTINE
C
      SUBROUTINE SCAN(NL,NS,SEQ,KF)
C     Copyright (c) 1990 by W. W. Rozeboom.   All rights reserved.
C This reads the keyboard string, cleans it for list-directed reading of
C the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.  Termination of an input line by "*" allows up to
C two continuation lines.) NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number
C string returned in File 2 is non-null but does not match SEQ, and
C gives the total count of numbers in the returned string otherwise.
C ***** If SEQ is "B", NL returns 0 if the input line is blank, and
C       returns -1 otherwise.
      CHARACTER AA, SEQ*(*), WA*240, WB*240
      NL = 0
5     NLL = NL + 80
      READ(KF,'(A80)') WA(NL+1:NLL)
      IP = NL
      NL = NLL+1
10    NL = NL-1
      IF(NL==0) RETURN
      IF(WA(NL:NL)==' ') GOTO 10
      IF(WA(NL:NL)=='*' .AND. NL>IP) GOTO 5
      IF(SEQ(1:1)=='B') NL = -1
      IF(SEQ(1:1)=='B') RETURN
      WB(NL+1:NL+1) = ' '
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +      WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
        ELSE IF (WA(I:I) /= '0') THEN
          IP = 0
        END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF (WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) RETURN
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     + "number sequence requested. Try again.")')
      RETURN
60    REWIND 2
      WRITE(2,'(A)') WB(1:NL)
      NL = NN
      REWIND 2
      END SUBROUTINE
C
      SUBROUTINE SEENAM(LM,NV,IDENT,PIK,NW,LS,LW,FMT,KF)
C This writes to file KF the Abs(NV) names picked from IDENT by index list PIK.
C LM is max namelength.  LS is number of lines to leave at top of screen.
C Omit closing Wait if less than LW lines have been shown since last pause.
C NW is line length.  If NV<0, names are written with index received in PIK
      CHARACTER*8 IDENT(*), FMT*30, CH3*3
      INTEGER PIK(*)
      LM = 3; NN = ABS(NV)
      DO I = 1,NN
        CALL LAST(N,IDENT(ABS(PIK(I))),8)
        LM = MAX(LM,N)
      END DO
      LL = NW/(5+LM)   ! Number of fields per line
      LB = (23-LS)*LL       ! Number of fields in 23-LS lines
      NS = MIN(1,MOD(NW,6+LM)/2)  ! Number of spaces starting display line
      NL = (NN+LL-1)/LL  ! Number of display lines needed
      NK = 0
      CH3 = CHAR(48+NS)//CHAR(48+LL/10)//CHAR(48+MOD(LL,10))
      FMT = '(80('//CH3(1:1)//'X,'//CH3(2:3)//'(I4,":",A),:/))'
      M1 = 1; IF(NV<0) M1 = 0; M2 = 1-M1
20    NL = (NN-NK+LL-1)/LL   ! Number of display lines left to print
      WRITE(KF,FMT)(M1*I+M2*PIK(I),IDENT(ABS(PIK(I)))(:LM),I=NK+1,
     +  NK+MIN(LB,NN-NK))
      NK = NK+LB
      IF(KF==6) THEN
        IF(NK<NN .OR. NL>LW) CALL WAIT(0)
C       NL: At end, lines printed either after Call or after last internal Wait
      END IF
      LB = 23*LL  ! Hereafter use full screen
      IF(NK>=NN) RETURN
      GOTO 20
      END SUBROUTINE
C
      SUBROUTINE SHONFT(NB,MV,MB,QW,QY,KBLF,KP,FMT,KF)
C Display factors per block with eigenvalues grounding the selection.
C QW=T if there are Waifs.  QY=T flags last block (NB) as fully dependent.
      LOGICAL QY, QW
      CHARACTER TR, BN, CLN*8, C3*3, FMT*52, CH6(MB)*6
      INTEGER KBLF(MB,0:MB)
      REAL RR(MV)
      MX = 0
      NB1 = NB
      IF(QW) NB1 = NB+1
      REWIND 10
      DO IB = 1,NB1     ! Want NB1=NB+1 if there are Waifs; otherwise = NB
        READ(10) N    ! ********** ERROR; NB1 too large
        MX = MAX(MX,N)  ! Max no. eigenvalues in a block
      END DO
      REWIND 10
      WRITE(KF,'(/" The number NFT of factors taken from each block",
     +  ", and the block''s residual"/" eigenvalues on which ",
     +  "that was decided, are"/)')
      WRITE(KF,'( " Block ",A," NFT ",A,11X,"Eigenvalues")')
     +  (TR(''),I=1,2)   ! No evident reason why this should not be OK
      KFLG = (KF-6)*(KP/100)  ! 1 if KF=7 and KP>100, otherwise 0 (if KF either 6 or 7)
      LN = MIN(MX,10+6*KFLG)
      WRITE(KF,'(1X,150A)') TR(''), ((TR(''),I=1,5),TR(''),J=1,2),
     +  (TR(''),I=1,6*LN)
      C3 = '"'//TR('')//'"'
      FMT = '(3X,A,3X,A,I3,2X,A,10A6,3(:/7X,'//C3//',5X,'//C3//',10A6))'
CC     (3X,A,3X,A,I3,2X,A,10A6,3(/7X,'|',5X,'|',10A6)) ! Short lines
      IF(KF/=6 .AND. KP>=100) FMT =
     +  '(3X,A,3X,A,I3,2X,A,16A6,3(:/7X,'//C3//',5X,'//C3//',16A6))'
      DO IB = 1,NB
        READ(10) K, (RR(J),J=1,K)
        JB = IB
        IF(QY .AND. JB==NB) JB = 99  ! QY=T sets Y-factors; no Waifs
        JT = KBLF(IB,0)
        DO J = 1,K
          CH6(J) = CLN(RR(J),6,2)
        END DO
         IF(JT<K) CH6(JT+1)(1:1) = ']'   ! Not sure which display I prefer
C          IF(JT<K) CH6(JT) = CH6(JT)(2:6)//']'
         WRITE(KF,FMT) BN(JB), C3(2:2), KBLF(IB,0), C3(2:2),
     +     (CH6(J),J=1,K)
      END DO
      IF(NB<NB1) THEN
        READ(10) K, (RR(J),J=1,K)
        FMT = '(1X,"Waifs "'//FMT(9:)
        WRITE(KF,FMT) TR(''), KBLF(NB1,0), TR(''),
     +  (CLN(RR(J),6,2),J=1,N)
      END IF
      WRITE(KF,'(1X,150A)') TR(''), ((TR(''),I=1,5),TR(''),J=1,2),
     +  (TR(''),I=1,6*LN)
      END SUBROUTINE
C
      SUBROUTINE SHOW(NV,QP,FMT1,A1,C1,LIST,IO)
C This writes to screen (if IO=6) or to RESULTS file (if IO=7) the current
C factor pattern/covariances. If IO is negative, block membership is substi-
C tuted for communalities.  Notes: COMM is loaded internally from scratchfile
C and LIST is unused if IO>0; otherwise, input in LIST is substituted for COMM
      LOGICAL QP
      INTEGER LIST(*)
      REAL A1(MV,*), C1(MV,*), COMM(MV)
      CHARACTER CH1, FMT1*(*), FMT2*60, CLN*8, BN
      COMMON NF, MV, MF
      LK = 2   ! Approximate count of lines since last pause
      IF(IO>=0) FMT2 = '(I4,". (",A3,")"'//FMT1(7:)
      IF(IO<0) FMT2 = '(I4,". ( ",A," )"'//FMT1(7:)
C       For IO=6, FMT1 = '(4X,7X,2(2X,5A5),90(:/13X,2(2X,5A5)))'
C             so FMT2 is  (I4,'. (',A3,')',2(2X,5A5),90(:/13X,2(2X,5A5))
      IF(IO==6) FMT2(23:23) = '6'
      IF(IO==6) FMT2(42:42) = '6'
      NL = (NF+11)/12  ! Number of display lines per record when IO=6
      IX = ABS(IO)
      IF(IO>=0) REWIND 11
      IF(IO>=0) READ(11) (COMM(I),I=1,NV)
      DO I = 1,NV
        IF(IO<0 .AND. QP) THEN  ! Writing to SEE-file with item perms
          IF(I>1 .AND. LIST(I)/=LIST(I-1)) WRITE(IX,'()')
        ELSE IF(MOD(I-1,5)==0) THEN
          WRITE(IX,'()'); LK = LK+1
        END IF
        IF(IO>=0) WRITE(IO,FMT2) I, CLN(COMM(I),3,2), (CLN(A1(I,J),
     +    5,2),J=1,NF); LK = LK+NL
        IF(IO<0) WRITE(IX,FMT2) I, BN(LIST(I)), (CLN(A1(I,J),
     +    5,2),J=1,NF)
        IF(IX/=6 .OR. MOD(I,20/NL)/=0 .OR. LK+MIN(5,NV-I)*NL<24)
     +    CYCLE
C          Pause if I is a multiple of 5 and no room for 5 more pattern lines
        WRITE(6,'(" Hit RETURN to continue this display, or enter",
     +    " anything to quit it.")')
        READ(5,'(A)') CH1
        IF(CH1/=' ') RETURN
        LK = 2
      END DO
      WRITE(IX,'()')
      D = 0.
      DO I = 1,NF
        D = MAX(D,ABS(C1(I,I)-1.))
        DO J = I+1,NF
          D = MAX(D,ABS(C1(I,J)))
        END DO
      END DO
      IF(D<.001) WRITE(IX,'(/"  Covariances are orthonormal.")')
      IF(D<.001) RETURN
      IF(IX==6 .AND. LK+MIN(5,NF)>=22) THEN
        CALL WAIT(0); LK = 2  ! Need 2+MIN(5,NF) lines
      END IF
      WRITE(IX,'(" with corresponding factor covariances")')
      DO I = 1,NF
        IF(LK/=2 .AND. MOD(I-1,5)==0) WRITE(IX,'()')
        WRITE(IX,FMT1) (CLN(C1(I,J),5,2),J=1,I); LK = LK+1
        IF(IX/=6 .OR. MOD(I,5)/=0 .OR. LK+(1+I/10)*MIN(5,NV-I).
     +    LT.23 .OR. I>=NV-1) CYCLE
        CALL WAIT(0); LK = 2
      END DO
      IF(IX/=6) RETURN
      WRITE(IX,'()'); CALL WAIT(0)
      END SUBROUTINE
C
      SUBROUTINE SORT(N,LST)
C Sort integer list LST into decreasing order.
      INTEGER LST(*), K
10    DO J = 2,N
        K = LST(J)
        DO I = J-1,1,-1
          IF(LST(I)>=K) GOTO 12  ! Decreasing order
          LST(I+1) = LST(I)
        END DO
        I = 0
12      LST(I+1) = K
      END DO
      END SUBROUTINE
C
      SUBROUTINE START(J,F1)
C This opens formatted file F1 with unit-number J, and finds its first line
C beginning with a digit.
      CHARACTER F1*(*), CH*80
      OPEN(J,FILE=F1)
10    READ(J,'(A)',END=50) CH
      K = 0
12    K = K+1
      L = ICHAR(CH(K:K))
      IF((L==32 .OR. L==0) .AND. K<80) GOTO 12
      IF(L<48 .OR. L>57) GOTO 10
      BACKSPACE J
      RETURN
50    WRITE(6,'(/" File ",A," is defective.")') F1
      STOP
      END SUBROUTINE
C
      SUBROUTINE SUBST(WORD,CHA,CHB)
C  Replace all WORD(:LL)-occurrences of chars in CHA with matching chars in CH2
      CHARACTER WORD*(*), CHA*(*), CHB*(*), CH1, CH2
      M = LEN(WORD)
      N = MIN(LEN(CHA),LEN(CHB))
      DO K = 1,N
        CH1 = CHA(K:K)
        CH2 = CHB(K:K)
        DO I = 1,M
          IF(WORD(I:I)==CH1) WORD(I:I) = CH2
        END DO
      END DO
      END SUBROUTINE
C
      FUNCTION TR(CH)
C Translate selected 8-bit ASCII characters into 7-bit substitutes if KR > 0
      CHARACTER TR, CH
      COMMON /TTR/ KND
      SAVE /TTR/
      N = ICHAR(CH)
      IF(KND<=0 .OR. N<127) THEN
        TR = CHAR(N)
        RETURN
      END IF
      IF(N==196) THEN
        TR = '-'
      ELSE IF(N==205) THEN
        TR = '='
      ELSE IF(N==191.OR.N==192.OR.N==217.OR.N==218) THEN ! Single corners
        TR = '+'  ! Single-line corners
      ELSE IF(N==182.OR.N==183.OR.(N>=186.AND.N<=189).OR.
     +  (N>=199.AND.N<=204).OR.N==206.OR.N==208.OR.N==210
     +  .OR.N==211.OR.N==214.OR.N==215) THEN
        TR = '#' ! Double-line corners and verticals
      ELSE IF(N>=179.AND.N<=218) THEN
        TR = '|' ! Single-line verticals
      ELSE IF(N>=248) THEN
        TR = '^'  ! Elevated degree symbol
      ELSE IF(N>=242) THEN
        TR = '}'  ! <=
      ELSE IF(N>=243) THEN
        TR = '{'  ! >=
      ELSE
        WRITE(6,'(/" A replacement for ASCII character ALT-",I3,
     +    " has not yet been programmed."/" Fix this oversight ",
     +    "and try again.")') N
        STOP
      END IF
      END FUNCTION
C
      SUBROUTINE TRLIN(WORD)
C Apply function TR to the characters in WORD
      CHARACTER TR, WORD*(*)
      LL = LEN(WORD)
      DO I = 1,LL
        WORD(I:I) = TR(WORD(I:I))
      END DO
      END SUBROUTINE
C
      SUBROUTINE VARIM(A,NV,NF,WT,IER)
C This is a stripped copy of a subroutine for orthonormal factor rotation that
C includes QUARTIMAX, VARIMAX, and EQUAMAX as special cases. Control parameters
C can be adjusted by editing them in their entries below.
      REAL A(NV,*), SAVE(NV)
      WT = NF*.5 ! EQUAMAX setting
C       WT is the parameter that selects inter alia VARIMAX (WT=1.0),
C       QUARTIMAX (WT=0.0), and EQUAMAX (WT=NF/2.O). Best results are
C       claimed to result from WT in closed interval [1.0, 5.0*NF]. In
C       general, the larger is WT the more equal is the dispersion of
C       accounted-for variance across the factors.
      NORM = 1
C       NORM=1/0 selects whether pattern rows are or are not normalized
      IMAX = 50
C       IMAX is limit on number of iteration cycles
      EPS = .0001
C       Input convergence constant for rotation (angle).
      IER = 0
      IF(NF<=1) RETURN
      NV2 = NV*NV
      NFF = ((NF-1)*NF)/2
      NF0 = NF-1
      EPS4 = EPS/4.0
      WTNV = WT/NV
C Normalize pattern rows
      IF(NORM==0) GOTO 10
      DO I = 1,NV
        S = 0.
        DO J = 1,NF
          S = S + A(I,J)*A(I,J)
        END DO
        S = MAX(.0001,SQRT(S))
        SAVE(I) = S
        DO J = 1,NF
          A(I,J) = A(I,J)/S
        END DO
      END DO
10    ICYC = 0
      NC = 0
      KOUNT = 0
      VVV = 0.
C Commence orthomax factoring
15    ICYC = ICYC + 1
      VV = VVV
C Calculate rotation criterion
      VVV = 0.
      DO J = 1,NF
        SS = 0.
        DD = 0.
        DO I = 1,NV
          SQ = A(I,J)*A(I,J)
          DD = DD + SQ
          SS = SS + SQ*SQ
        END DO
        VVV = VVV + (NV*SS - WT*DD*DD)/NV2
      END DO
      IF(ICYC<=IMAX) GOTO 21
      IER = 66
      GOTO 30
21    TVV = VVV - VV
      IF(TVV>EPS*ABS(VV)) GOTO 22
      NC = NC+1
      IF(NC>=2) GOTO 30
22    BIG: DO J = 1,NF0
        J1 = J+1
        DO 27 K = J1,NF
C Calculate Kaiser TAN(4*PHI) measure
        AS = 0.
        BS = 0.
        TT = 0.
        BB = 0.
        DO I = 1,NV
          U = (A(I,J)*A(I,J)) - (A(I,K)*A(I,K))
          V = 2*A(I,J)*A(I,K)
          AS = AS + U
          BS = BS + V
          BB = BB + U*U-V*V
          TT = TT + U*V
        END DO
        TT = 2*(TT - AS*BS*WTNV)
        BB = BB - (AS*AS-BS*BS)*WTNV
        IF(ABS(TT)+ABS(BB)>EPS) GOTO 25
24      KOUNT = KOUNT + 1
        IF(KOUNT<NFF) GOTO 27
C Complete cycle without rotation
        GOTO 30
25      PHI = .25*ATAN2(TT,BB)
        IF(ABS(PHI)<EPS4) GOTO 24
        COSP = COS(PHI)
        SINP = SIN(PHI)
        KOUNT = 0
C Rotate axes by angle PHI
        DO I = 1,NV
          S = A(I,J)*COSP + A(I,K)*SINP
          A(I,K) = -A(I,J)*SINP + A(I,K)*COSP
          A(I,J) = S
        END DO
27      CONTINUE
      END DO BIG
      GOTO 15
C Restore original pattern-row scaling
30    IF(NORM==0) GOTO 35
      DO I = 1,NV
        S = SAVE(I)
        DO J = 1,NF
       A(I,J) = A(I,J)*S
        END DO
      END DO
C Reflect axes with prevailingly negative loadings
35    DO J = 1,NF
        S = 0.
        DO I = 1,NV
          S = S + A(I,J)
        END DO
        IF(S<0) THEN
          DO I = 1,NV
            A(I,J) = -A(I,J)
          END DO
        END IF
      END DO
      IF(IER==0) RETURN
      WRITE(6,'(/" *** WT =",F4.1," ORTHOMAX on",I3," factors ",
     + "failed to converge in",I3," iterations.")') WT, NF, IMAX
      END SUBROUTINE
C
      SUBROUTINE WAIFS(CUT,NV,NB,MB,NW,MF,A,KBL1)  ! KBL1(K,_) lists block K items
C Show summarized pattern info for the rotated Waifs at level CUT.
C AA(i,j),NN(i,j) are the RMS,count of loadings over CUT in block i on Waif j.
      CHARACTER BN, CLN*8, TR
      REAL A(NV,*), AA(0:NB,NW) ! A(:NV,:NW)
      INTEGER KBL1(0:MB,0:*)
      INTEGER NN(0:NB,NW), LST(NW)
      KTOT = 0  ! Check if results are worth display
      LARG = 0  ! Check if any table cell exceeds count 99
      AA = 0.; NN = 0
CC      DO K = 1,NW  ! Over Waifs
CC        DO J = 0,NB   ! Over Blocks
CC          AA(J,K) = 0.
CC          NN(J,K) = 0.
CC        END DO
CC      END DO
      DO K = 1,NW  ! Over Waifs
        DO J = 1,NB   ! Over Blocks
          DO L = 1,KBL1(J,0)  ! Do over items in Block J
            I = KBL1(J,L)
            IF(ABS(A(I,K))<=CUT) CYCLE
            KTOT = KTOT+1
            S = ABS(A(I,K))
            AA(J,K) = AA(J,K) + S
            AA(0,K) = AA(0,K) + S
            NN(J,K) = NN(J,K) + 1
            NN(0,K) = NN(0,K) + 1
          END DO
          AA(J,K) = AA(J,K)/MAX(1,NN(J,K))
          LARG = MAX(LARG,NN(J,K))
          IF(NN(J,K)>2) KTOT = KTOT+1
        END DO
      END DO
      IF(KTOT<=2) THEN
        WRITE(6,'(" CUT = ",A3," is too high to be informative.",
     +    "  Try a lower level.")') CLN(CUT,3,2)
        CUT = CUT/2
        RETURN
      END IF
      DO K = 1,NW
        LST(K) = 100*NINT(10000*AA(0,K)) + K
      END DO
      CALL SORT(NW,LST)
      DO K = 1,NW
        LST(K) = MOD(LST(K),100)
        AA(0,K) = AA(0,K)/MAX(1,NN(0,K))
      END DO
      DO KF = 6,28,22
        IF(KF==28) WRITE(KF,'()')
        WRITE(KF,'(5X,"Mean(Count) of loadings exceeding CUT =",A4,
     +    " in each item block on rotated"/5X,"Waifs ordered by C",
     +    "ut-strength (Mean x count) over all blocks combined.")')
     +    CLN(CUT,4,2)
        IF(LARG>99) WRITE(6,'(14X,"Three-digit counts are rounded",
     +    " down to 99.")')
        NWW = NW
        IF(KF==6) NWW = MIN(9,NW)
        WRITE(KF,'("  Waif:",I3,30I8)') (LST(I),I=1,NWW)
        DO J = 1,NB
          WRITE(KF,'(3X,A,":",30(1X,A3,"(",I2,")"))') BN(J),
     +      (CLN(AA(J,LST(K)),3,2),MIN(99,NN(J,LST(K))),K=1,NWW)
        END DO
        WRITE(KF,'(240A))') (TR(''),I=1,5+8*NWW)
        WRITE(KF,'(" All:",30(1X,A3,"(",I2,")") )')
     +   (CLN(AA(0,LST(K)),3,2),MIN(99,NN(0,LST(K))),K=1,NWW)
      END DO
      IF(NWW<NW) WRITE(6,'(6X,"Note. The weakest waifs have been",
     +  " cropped from this display.  The"/12X,"last complete ver",
     +  "sion will be written to this run''s SEE-file.")')
      CUT = -CUT  ! Flag that scratchfile 28 has content

C   Mean(Count) of loadings exceeding CUT = .xx in each item block on rotated
C   Waifs ordered by strength (RMS x count) over all blocks combined.
C              Three-digit counts are rounded down to 99.
C  Waif:  1       2       3       4       5       6       7       8       9
C   A: .xx( n) .xx( n) .xx( n) .xx( n) .xx( n) .xx( n) .xx( n) .xx( n) .xx( n)
C   B: .xx( n) .xx( n) .xx( n) .xx( n) .xx( n) .xx( n) .xx( n) .xx( n) .xx( n)
C 
C All: .xx( n) .xx( n) .xx( n) .xx( n) .xx( n) ( n)
C      Note. The weakest waifs have been cropped from this display.  The
C            complete version has been written to this run's SEE-file.
      END SUBROUTINE
C
      SUBROUTINE WAIT(N)
C  N < 0 calls for space before screen display
      IF(N>0) WRITE(6,'()')
      WRITE(6,'(" Hit RETURN to continue")')
      READ(5,'(A1)')
      END SUBROUTINE
C
C The following subprograms are specific to the Lahey compiler.
C
      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12, LST(12)*10
      COMMON /CF/ CF
      DATA LST/'January  7','February 8','March    5','April    5',
     +         'May      3','June     4','July     4','August   6',
     +         'September9','October  7','November 8','December 8'/
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48  ! M gets day of month
      READ(ZZZ(5:6),*) L; K = ICHAR(LST(L)(10:10))-48
      WORD = CF(:JF(M))//' '//LST(L)(:K)//' '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE
C
C      SUBROUTINE DOSFRM(WORD,L)
CC For Lahey and Microsoft/IBM compilers, this is a dummy. (Called in LOOK)
C      RETURN
C      END
C
      FUNCTION QFMT(F1)
C This determines the status of file F1, returning 'U' if it does not exist,
C 'Y' if it is formatted, and 'N' if it is not formatted.
      CHARACTER QFMT, F1*(*)
      INQUIRE(FILE=F1,FORMATTED=QFMT)
      END FUNCTION
C
      FUNCTION SLASH()
      CHARACTER SLASH
      SLASH = '\'
      END FUNCTION
C
      FUNCTION TM(KSET)
C The value (real) returned by function TM is seconds since last timer reset.
C After this value is determined, the timer is reset if KSET > 0 but continues
C to accumulate if KSET = 0.
      SAVE PREV
      DATA PREV/0./
C       CALL SYSTEM_CLOCK(J,KR,KMAX)  ! Arguments are optional
C       J = tick count since zero; KR = ticks per second; KMAX = max count
C       In LF90 clock: KR = 100, KMAX = 8,640,000
      CALL SYSTEM_CLOCK(J)
      X = J/100.
      TM = X - PREV
      IF(TM<=0.) TM = TM + 86400
      IF(KSET==0) RETURN
      PREV = X
      END FUNCTION


