C          Program HYBOOT.  (Source code: FORTRAN-77)
C
C                 Last revised: 31 July 2000
C
C This combines salient subroutines from HYDATA, MODA, and HYBALL to run a
C bootstraps sampling appraisal of factoring the covarianes in a Hydata-
C standard datafile <data>.D<i> by the extraction/rotation parameters
C previously set by factoring a COV-file from <data>.D<i>.  The parameters
C and rotated results of this prior run are saved in binary file BOOTDATA
C and read by HYBOOT at start-up.

C ***** Notes for possible extension of HYBOOT findings *****
c  6: Sum/SumSq for special correlations:
c     a.  Loading with other loadings on same factor.
c     b.  Loading with same-item loadings on other factors.
c     c.  Loading with other-item loadings on other factors.
c     d.  Factor correlation with other factor correlations.
c     e.  Factor correlation with pattern loadings.
c     f.  Loading error with magnitude of target value.
c     g.  Factor-correlation error with magnitude of target value.

ccc      PARAMETER (NV=170, NF=30, MZ=3*NV, MX=3, NVV=NV*(NV+1)/2, MT=5000,
ccc     +  NFF=NF*(NF+1)/2, NVF=NV*NF, NVF1=NV*(NF+1), NFSQ=NF*NF)
cccC          MX is number of special correlations

      LOGICAL QY, QD
      CHARACTER*12 F1, F2, F3, NAME(20), CF, WORD*100
C        F1 is dat.Di, F2 is COV-file, F3 is Hyball-input file
      CHARACTER*8 CLN, CLEAR, WRD(0:4)*6, CH6*6
      CHARACTER C11,C12,C21,C22, BAR,LIN, CH

ccc      INTEGER PK(NV)     ! Used only in COVS after loading IDENT in Main
ccc      INTEGER PIK(NV)      ! Used only in MODA after loading PK    in Main
ccc      REAL BIN(3*NVV+NV*(3*NF+NV+2))  ! BIN is a master workspace

      CHARACTER(8),ALLOCATABLE :: IDENT(:), IDN(:)
      INTEGER,ALLOCATABLE :: PIK(:), PK(:)
      REAL,ALLOCATABLE :: BIN(:)

      COMMON NV, NF
      COMMON /CF/ CF
      DATA NDUN,GAP,TT,LX,LX2/0,0.,0.,0,0/
      DATA WRD/'STEP/S','STEP/P','SCAN/S','SCAN/P','OBLMIN'/
      DATA C11,C12,C21,C22,BAR,LIN/'','','','','',''/,
     +     CLEAR/'        '/
      LO(I,J) = J*(J-1)/2 + I
      OPEN(2,STATUS='SCRATCH')
      KDO = 10
      MAXTRY = 50
      NUFF = 30
      INQUIRE(FILE='BOOTDATA',EXIST=QY)
      IF(QY) THEN  ! Otherwise, will exit before needing allocations
        OPEN(4,FILE='BOOTDATA',FORM='UNFORMATTED')
        READ(4) NV, NF !, NX  ! NV includes X-set count NX
        NVV=LO(NV,NV); NFF=LO(NF,NF); NVF=NV*NF; NF1=NF+1; NVF1=NV*NF1
        ALLOCATE (PIK(NV), PK(NV), IDENT(NV) )
C >>>>> Can't allocate BIN until NREC determined circa line 240

C  COVS: KOV:NVV, LIST:NREC, COV:NVV*2 = 3NVV + NREC
C  MODA CY:NVV, W:NVV, W1:NVV, T:NV+NF, A:2*NV*NF, U:NV, CS:2*NV*NV
C   =  3NVV + NV*(NF + 2NF + 1 + 2NV) = 3NVV + NV*(3NF + 1 + 2NV)
C  SUMRY  A1:NV*NF1, C1:NF*NF, STORA:8*NV*NF1, STORC:4*NF*NF1
C   = NV*(NF1 + 8NF1) + NF*(NF+4NF1) = 9*NV*NF1 + NF*(5NF1-1)
C   = NF1*(9NV+5NF) - NF = NF*(9NV+5NF) + 9NV+4NF
C  HYBL:  A0:NV*NF1, T1:NV*NF1, W:NV*NF, A1:NV*(2*NF+1), C1:NF*NF, C0:NF*NF, CG:NFF=NF*(NF+1)/2, OMIT:NFF*(NF+1)
C      = NV*(NF1+NF1+NF+(2*NF+1)) + NF*(NF+NF+(NF+1)/2 )
C      = NV*(5NF + 3) + NF(2NF + NF1/2)
C          NV    NVV   NV*NF   NF*NF    NV    NF   [more]
C COVS             3                                 NREC    < 2*NV + NREC
C MODA      2      3      3               1                  < 4*NV
C HYBL                    5     2+1/2     3     1            < 6*NV*NF
C SMRY                    9       5       9     2            < NF1*(9NV+5NF)
c --------------------------------------------------------------
C COVS calls for BIN-size  3*NVV+NREC
C MODA calls for BIN-size  3*NVV+3*NVF+NV+NV*(NV+2) = 3*(NVV+NVF+NV) + NV*NV
C HYBL calls for BIN-size  5*NVF1+2*NFSQ+NFF
C SMRY calls for BIN-size  NFSQ+9*NVF1+4*NF*NF1 = 9*NVF1 + 5*MFSQ + 4*NF
C       LARG = MAX(3*NVV+NREC, 5*NV*NV, NF1*(9NV+5NF) )

        REWIND 4
        READ(4) NV, NF, NX, KODE, MTH, MODE, F3, F2, F1, (PIK(I),I=1,NV)
C         F3 is COV-file, F2 is extraction pattern. F1 is rawdata,
C         PIK is reflection-signed list of pattern-item rawdata indices.
        READ(4)
        READ(4) NDUN
        IF(NDUN>0) THEN
          BACKSPACE 4
          READ(4) NDUN, TT, GAP, LX, LX2
        END IF
        CLOSE(4)
        INQUIRE(FILE=F1,EXIST=QD)
        CALL LAST(LF1,F1,12)
        CALL LAST(LF2,F2,12)
        CALL LAST(LF3,F2,12)
      END IF
      CALL SYSTEM('cls')
      IF(.NOT.QD .AND. NDUN>0 ) GOTO 12
      IF(NDUN>0) GOTO 15

C |     To run a HYBOOT study of sampling uncertainty in factor results from  |2
C | one of your Hydata-standard rawdata files <data>.D<i>, you must first     |5
C | generate a normal (not bootstrapped) COV-file from <data>.D<i> and factor |1
C | this by MODA/HYBALL under your preferred parameters for extraction and    |4
C | rotation.  These parameters and your choice of rotated pattern are saved  |2
C | in control file BOOTDATA for input to HYBOOT.                             |29
C |                                                                           |77
C |     When HYBOOT is started, it calls on this control file to identify the |1
C | rawdata filename, the selection of NV variables that were factored, the   |3
C | method and dimensionality NF of factor extraction, and the rotation       |7
C | controls that produced the axis positioning you favor.  HYBOOT then draws |1
C | many random samples WITH REPLACEMENT of records in <data>.D<i> equal in   |3
C | number to the actual record count therein, and solves each for a rotated  |2
C | pattern of these same NV variables on NF factors under the same control   |3
C | parameters as your original solution except that rotation is always by    |4
C | Spin search.  Finally, after aligning each bootstrapped factor solution   |3
C | with your chosen target pattern, HYBOOT returns details on the central    |4
C | tendency and dispersion over this multiplicity of bootstrap solutions.    |4
c                 continuation if QY and QD are both True
C |     Statistics from these bootstrap factoring repetitions are accumulated |
C | in a raw-results bin in control file BOOTDATA that is incremented and     |
C | saved after each solution.  Whenever HYBOOT's run is discontinued, either |
C | by accident or choice, it can be resumed with the accumulation already in |
C | hand (so long as BOOTDATA has not been destroyed) simply by re-entering   |
C | the " HYBOOT " command.                                                   |
C |                                                                           |
C |     Bootstrap repetitions are executed by HYBOOT in blocks of whatever    |
C | many additions you prefer.  After completion of each block, the program   |
C | will inquire how many more repetitions, if any, you want from the next    |
C | block. You will also have opportunity at block's end to adjust the MAXTRY |
C | and NUFF parameters that control thoroughness of Spin search.  MAXTRY is  |
C | the maximum number of rotation Tries that subroutine SPIN executes from   |
C | random start positions before returning its best (criterion-optimizing)   |
C | result.  Otherwise, SPIN exits whenever NUFF consecutive Tries fail to    |
C | improve on the previous best in this Try series.                          |

      WRITE(6,'(1X,77A)') C11, (LIN,I=1,75), C12
      WRITE(6,'(1X,A,4X,"To run a HYBOOT study of sampling uncertai",
     + "nty in factor results from   ",A/1X,A," one of your Hyd",
     + "ata-standard rawdata files <data>.D<i>, you must first",5X,
     + A/1X,A," generate a normal (not bootstrapped) COV-file from ",
     + "<data>.D<i> and factor ",A/1X,A," this by MODA/HYBALL und",
     + "er your preferred parameters for extraction and",4X,A/1X,A,
     + " rotation.  These parameters and your choice of rotated patt",
     + "ern are saved  ",A/1X,A," in control file BOOTDATA for inp",
     + "ut to HYBOOT.",29X,A/1X,A,75X,A/1X,A,5X,"When HYBOOT is st",
     + "arted, it calls on this control file to identify the ",A/1X,A,
     + " rawdata filename, the selection of NV variables that were f",
     + "actored, the",3X,A/1X,A," method and dimensionality NF of",
     + " factor extraction, and the rotation",7X,A/1X,A," control",
     + "s that produced the axis positioning you favor.  HYBOOT th",
     + "en draws ",A/1X,A," many random samples WITH REPLACEMENT",
     + " of records in <data>.D<i> equal in",3X,A/1X,A," number t",
     + "o the actual record count therein, and solves each for a ro",
     + "tated  ",A/1X,A," pattern of the same NV variables on NF f"
     + "actors under the same control",5X,A/1X,A," parameters as ",
     + "your original solution except that rotation is always by",4X,
     + A/1X,A," Spin search.  Finally, after aligning each bootstra",
     + "pped factor solution",3X,A/1X,A," with your chosen target",
     + " pattern, HYBOOT returns details on the central",4X,A/1X,A,
     + " tendency and dispersion over this multiplicity of bootstr",
     + "ap solutions.",4X,A)') (BAR,I=1,36)

12    IF(.NOT.(QY.AND.QD)) THEN
        IF(NDUN==0) WRITE(6,'(1X,77A)') C21, (LIN,I=1,75), C22
        IF(NDUN==0) CALL WAIT(1)
        IF(.NOT.QY) THEN  ! If NDUN>0 here, QY=T but QD=F
          WRITE(6,'(/" No BOOTDATA control file has been set here.",
     +     "  So call HYDATA to initiate"/" factoring of correla",
     +     "tions computed from one of the following datafiles:")')
          CALL LOOK(1,'*.D*',NAME,40,N)
          IF(N==0) WRITE(6,'(6X,"Oops!  There aren''t any Hyda",
     +      "ta-standard datafiles here, either."/6X,"Go get yo",
     +      "ur act together and try again."/)')
        ELSE
          WRITE(6,'(/5X,"Your BOOTDATA control file is present, ",
     +     "but the datafile ",A/5X,"it calls for is missing.  Go",
     +     " get this and try again."/)') F1
        END IF
        STOP
      END IF
C HYBOOT and datafile F1 are both present, so prepare for execution
      WRITE(6,'(1X,A,75X,A)') BAR, BAR
      CALL WAIT(0)
      WRITE(6,'(1X,A,5X,"Statistics from these bootstrap factoring ",
     +  "repetitions are accumulated ",A/1X,A," in a raw-results bin",
     +  " in control file BOOTDATA that is incremented and",5X,A/1X,A,
     +  " saved after each solution.  Whenever HYBOOT''s run is disco",
     +  "ntinued, either ",A/1X,A," by accident or choice, it can be ",
     +  "resumed with the accumulation already in ",A/1X,A," hand (so",
     +  " long as BOOTDATA has not been destroyed) simply by re-enter",
     +  "ing   ",A/1X,A," the "" HYBOOT "" command.",51X,A/1X,A,75X,A/
     +  1X,A,5X,"Bootstrap repetitions are executed by HYBOOT in bl",
     +  "ocks of whatever",4X,A/1X,A," many additions you prefer.  Af",
     +  "ter completion of each block, the program",3X,A/1X,A," will ",
     +  "inquire how many more repetitions, if any, you want from the",
     +  " next",4X,A/1X,A," block. You will also have opportunity at ",
     +  "block''s end to adjust the MAXTRY ",A/1X,A," and NUFF parame",
     +  "ters that control thoroughness of Spin search.  MAXTRY is  ",
     +  A/1X,A," the maximum number of rotation Tries that subroutine",
     +  " SPIN executes from",3X,A/1X,A," random start positions befo"
     +  "re returning its best (criterion-optimizing)",3X,A/1X,A,
     +  " result.  Otherwise, SPIN exits whenever NUFF consecutive ",
     +  "Tries fail to",4X,A/1X,A," improve on the previous best in "
     +  "this Try series.", 26X,A)') (BAR,I=1,32)
      WRITE(6,'(1X,77A)') C21, (LIN,I=1,75), C22
      CALL WAIT(1)
15    IF(NDUN>0) WRITE(6,'(/" Resuming bootstrap study of facto",
     +  "ring the data in D-file ",A,".")') F1(:LF1)
      OPEN(3,FILE=F1)
      READ(3,'(A)') WORD(:21)
      IF(WORD(2:7)/='HYDATA') THEN
        WRITE(6,'(/" File ",A," is not confirmably Hydata-stand",
     +   "ard.  No go.")') F1(:LF1)
        STOP
      END IF
      REWIND 3

CCC      READ(3,'(26X,A12,1X,I4,11X,I5,24X,I10,25X,F5.1)') WORD(:12),
CCC     +  NZ, NREC, MAXID

      READ(3,'(A)') WORD
      CALL SSCAN(J,WORD,-1)
      IF(J<4) THEN
        CALL LAST(LL,WORD,100)
        WRITE(6,'(" ERROR: Header of ",A," is"/1X,A)') F1(:LF1),
     +     WORD(:LL)
        STOP
      END IF
      READ(2,*) I, NZ, NREC, MAXID; WORD(:12) = WORD(27:38)
      CALL LAST(J,WORD,12)
      CALL SYSTEM('cls')
      WRITE(6,'(//" The Hydata-standard rawdata file to be bootstr",
     +  "ap-sampled is ",A,".")') F1(:LF1)
      IF(WORD(:LF1)/=F1(:LF1)) THEN
        WRITE(6,'(" But its D-file name is not verified in its ",
     +    "header line.  No go.")')
        STOP
      END IF
      NFSQ=NF*NF ; LARG = MAX(3*NVV+NREC, 5*NV*NV, NF1*(9*NV+5*NF) )
      ALLOCATE ( BIN(LARG), IDN(NZ) )
      READ(3,'()')
      READ(3,*) (IDN(I),I=1,NZ)  ! Namelist for all datafile variables
      DO I = 1,NV
        PK(I) = ABS(PIK(I))
        IDENT(I) = IDN(PK(I))
      END DO
      LM = 0
      DO I = 1,NV
        CALL LAST(N,IDENT(I),8)
        IF(N<=8) LM = MAX(LM,N)
      END DO
      CALL SUMMRY(NDUN,TT,GAP,LX,LX2,CH6,-1,BIN,BIN(NVF1+1),BIN(NVF1+
     +            NFSQ+1),BIN(NFSQ+9*NVF1+1))
      WRITE(6,'(/" If you would like to see the factored variable",
     + "s'' names, enter anything."/" Otherwise, hit RETURN to ",
     + "forego the name display.")')
      CALL SSCAN(J,CH,5)
      IF(J/=0) THEN
        WRITE(6,'(" The variables are named")')
        CALL SEENAM(LM,NV,IDENT,1,6)
      END IF
      IF(NDUN==0) THEN
        GAP = 0.
        WRITE(6,'(//" Instead of picking the Best Try from each Spin",
     +    " search, you can alternatively"/" save the result that ",
     +    "occurs most frequently within your choice of proximity"/
     +    " distance GAP. Two solutions are counted as the same just",
     +    " in case either their"/" AV or their HI pattern-column ",
     +    "Divergence does not exceed GAP degrees.  (See"/" HYBAL",
     +    "L''S documentation for explanation of these pattern-",
     +    "comparison measures.)"/" Default recommendations are HI ",
     +    "at GAP around 5 or 10.")')
35      IF(ABS(GAP)<.1) WRITE(6,'(/4X,"To collect BEST results, ",
     +    "hit RETURN.  Otherwise, to collect the Spin"/4X,"solut",
     +    "ions that occur most frequently at proximity grain GAP, ",
     +    "enter"/4X,"your choice of GAP and make this negative if"
     +    " you want this comparison"/4X,"to be on AV (not recomme",
     +    "nded) rather than on HI."/)')
        IF(ABS(GAP)>=.1) WRITE(6,'(/4X,"Hit RETURN if you want to ",
     +    "collect Spin solutions that are MOST FREQUENT"/4X,"at pr",
     +    "oximity GAP = "A4,".  Otherwise, enter new GAP value (w",
     +    "ith negative"/4X,"sign to compare on AV), or any letter ",
     +    "to revert to collection of BEST."/)') CLN(GAP,4,1)
        CALL SSCAN(J,CH,5)
        IF(J==0) GOTO 50
        IF(J<0) GAP = 0.
        IF(J>0) READ(2,*) GAP
        GOTO 35
      END IF

C Set controls for next block of bootstrap solutions
50    IF(NDUN>0) WRITE(6,'(/4X,"Raw results have been collec",
     +  "ted from ",A," bootstrap samples.")') CF(:JF(NDUN))
51    IF(NDUN==0) WRITE(6,'(4X,"Hit RETURN to generate an initial ",
     +  "block of ",A," bootstrap solutions in"/4X,"rotation mod"
     +  "e ",A,".  Otherwise, enter an integer to pick the initial"/
     +  4X,"blocksize."/)') CF(:JF(KDO)), WRD(MODE)
      IF(NDUN>0) THEN
        WRITE(6,'(4X,"Hit RETURN to generate a block of ",A," mor",
     +    "e bootstrap solutions (rotation"/4X,"mode ",A,"; mean",
     +    " time per solution, ",A4," minutes).  Otherwise, enter an"/
     +    4X,"integer to pick a new blocksize, or any letter to get ",
     +    "summary statistics"/4X,"from the raw results already in ",
     +    "hand."/)') CF(:JF(KDO)), WRD(MODE), CLN(TT/(60*NDUN),4,2)
      END IF
      CALL SSCAN(J,CH,5)
      IF(J<0) GOTO 200
      IF(J>0) THEN
        READ(2,*) R
        KDO = MAX(1,NINT(R))
        GOTO 51
      END IF
55    WRITE(6,'(/5X,"Your Spin-control settings are now <MAXTRY, NU",
     +  "FF> = <",A,", ",A,">."/5X,"Hit RETURN if OK, or enter",
     +  " revised pair of control integers."/)') CF(:JF(MAXTRY)),
     +  CF(:JF(NUFF))
      CALL SSCAN(J,CH,5)
      IF(J<0) GOTO 55
      IF(J==0) GOTO 60
      IF(J==1) THEN
        READ(2,*) R
        IF(NINT(R)<MAXTRY) NUFF = NINT(R)
        IF(NINT(R)>MAXTRY) MAXTRY = NINT(R)
        GOTO 55
      ELSE IF(J>1) THEN
        READ(2,*) R, S
        MAXTRY = MAX(1,NINT(R),NINT(S))
        NUFF = MAX(1,MIN(NINT(R),NINT(S)))
      END IF
      GOTO 55
60    NTARG = NDUN+KDO
        JER = 0
        KER = 0
        LER = 0
99    IF(JER+KER<KDO .OR. JER+KER==LER) GOTO 100
      WRITE(6,'(4X,"There have been ",A," failures of factor extract",
     +  "ion and ",A," of rotation"/4X,"during this block of bootstr",
     +  "ap repetitions.  Hit RETURN to keep trying;"/4X,"otherwise,",
     +  " enter anything to quit.")') CF(:JF(JER)), CF(:JF(KER))
      CALL SSCAN(J,CH,5)
      IF(J/=0) STOP
      LER = JER+KER
100   CONTINUE
      I = TM(1)
      ND = NDUN+1
C Compute bootstrap data covars
      WRITE(6,'(//3X,70A)') C11, (LIN,I=1,68), C12 ; J=JF(ND)
      WRITE(6,'(3X,A,9X,"Compute covariances for bootstrap soluti",
     +  "on No. ",A,A,4X,A)') BAR, CF(:J), CLEAR(:8-J), BAR
      WRITE(6,'(3X,70A)') C21, (LIN,I=1,68), C22
      CALL COVS(MTH,NREC,MAXID,NZ,PK,BIN,BIN(NVV+1),BIN(3*NVV+1))
C Extract NF factors
      WRITE(6,'(//3X,70A)') C11, (LIN,I=1,68), C12
      WRITE(6,'(3X,A,7X,"Extract ",A," factors from the bootstrap No.",
     +  1X,A," covariances",A,1X,A)') BAR, CF(:JF(NF)), CF(:JF(ND)),
     +  CLEAR(:8-JF(NF)-JF(ND)), BAR
      WRITE(6,'(3X,70A)') C21, (LIN,I=1,68), C22
      CALL MODA(NX,MTH,PIK,IER,BIN,BIN(NVV+1),BIN(2*NVV+1),
     +  BIN(3*NVV+1),BIN(3*NVV+NVF+1),BIN(3*NVV+3*NVF+1),
     +  BIN(3*NVV+3*NVF+NV+1))
      IF(IER>0) JER = JER+1
      IF(IER>0) GOTO 99
C Rotate factors
      WRITE(6,'(//3X,70A)') C11, (LIN,I=1,68), C12
      WRITE(6,'(3X,A,12X,"Rotate axes of bootstrap solution No. ",
     +  A,A,10X,A)') BAR, CF(:JF(ND)), CLEAR(:8-J), BAR
      WRITE(6,'(3X,70A)') C21, (LIN,I=1,68), C22
      CALL HYBALL(NV,NF,MAXTRY,NUFF,GAP,LMX,IER,BIN,BIN(NVF1+1),
     +     BIN(2*NVF1+1),BIN(3*NVF1+1),BIN(3*NVF1+NFSQ+1),
     +     BIN(3*NVF1+2*NFSQ+1),BIN(3*NVF1+2*NFSQ+NFF+1))
C           BIN needs 5*NVF1+2*NFSQ+NFF
        IF(IER>0) KER = KER+1
        IF(IER>0) GOTO 99
C Increment collection bin
      NDUN = NDUN+1
      TT = TT + TM(1)
      LX = LX+LMX
      LX2 = LX2+LMX**2
      CALL SUMMRY(NDUN,TT,GAP,LX,LX2,CH6,0,BIN,BIN(NVF1+1),
     +            BIN(NVF1+NFSQ+1),BIN(NFSQ+9*NVF1+1))
      IF(NDUN<NTARG) GOTO 100
      WRITE(6,'(1X,A," bootstrap solutions have now been complet",
     +  "ed.")') CF(:JF(NDUN))
      WRITE(6,'(" Time per solution has averaged ",A5," minutes.")')
     +  CLN(TT/(NDUN*60),5,2)
      GOTO 50
C Output summary statistics
200   WRITE(6,'(//3X,70A)') C11, (LIN,I=1,68), C12 ; J = JF(NDUN)
      WRITE(6,'(3X,A,8X,"Compute summary statistics on ",A," bootst",
     +  "rap solutions",A,4X,A)') BAR, CF(:J),CLEAR(:6-J),BAR
      WRITE(6,'(3X,70A)') C21, (LIN,I=1,68), C22
      CVAR = FLOAT(ABS(KODE)/1000000)/100
      KOD = MOD(ABS(KODE),1000000)
      OPEN(7,FILE='BOOT.SEE')
      WRITE(7,'(/" Summary of ",A," bootstrap factor solutions es",
     + "timating the sampling noise in"/" rotations of extraction",
     + " archive ",A,", Code No. ",A,A3,".  This was derived"/
     + " from the correlations in archive ",A," computed from dat",
     + "afile ",A,".")') CF(:JF(NDUN)), F2(:LF2), CF(:JF(KOD)),
     + CLN(CVAR,3,2), F3(:LF3), F1(:LF1)
      CALL DAY(7)
      WRITE(7,'(/" The variables are named")')
      CALL SEENAM(LM,NV,IDENT,1,7)
      N = 0
      DO I = 1,NV
        IF(PIK(I)>=0) CYCLE
        N = N+1
        IDENT(N) = IDENT(I)
      END DO
      IF(N>0) THEN
        L = 125/(LM+2)
        WORD(:18)='(50('//CF(:JF(L))//'(2X,A'//CF(:JF(LM))//'):/))'
        WRITE(7,'(/" Variables that have been reflected from their",
     +   " rawdata orientations:")')
        WRITE(7,WORD(:18)) (IDENT(I),I=1,N)   ! '(50(xx(2X,Ax):/))'
      END IF
      CH6 = WRD(MODE)
      CALL SUMMRY(NDUN,TT,GAP,LX,LX2,CH6,1,BIN,BIN(NVF1+1),
     +            BIN(NVF1+NFSQ+1),BIN(NFSQ+9*NVF1+1))
CCC      CALL SUMMRY(NDUN,TT,GAP,LX,LX2,CH6,0,BIN,BIN(NVF1+1),
CCC     +            BIN(NVF1+NFSQ+1),BIN(NFSQ+9*NVF1+1))

      WRITE(6,'(/" *** The current summary of ",A," bootstrap sol",
     + "utions is reported in BOOT.SEE ***")') CF(:JF(NDUN))
      STOP
      END
C
C      CALL COVS(MTH,NREC,MAXID,NZ,PK,BIN,BIN(NVV+1),BIN(3*NVV+1))
      SUBROUTINE COVS(MTH,NREC,MAXID,NZ,PK,KOV,COV,LIST)
C  COVS: PK:NV, KOV:NVV, LIST:NREC, COV:2*NVV  =  NV*(3NV + 3) + NREC
C       BIN needs 3*NVV+NREC
C       NZ is the number of input variables, NV the number for cov comp
C       MT is the max number of subjects allowed for bootstrapping.
      CHARACTER CF*12, FMA*32, CHS(0:NZ)*10  ! , CLN*8
      INTEGER PK(NV), LIST(NREC), KOV(NV*(NV+1)/2)
      REAL GET(NZ), XX(NZ)
      DOUBLE PRECISION AV(NV), SD(NV), COV(NV*(NV+1)/2), X, S2
      COMMON NV, NF
      COMMON /CF/ CF
C NOTE: AV,SD,GET,XX are at present created internally; PK is passed outside of BIN
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      KSKIP = (1-ISIGN(1,MTH))/2  ! 1 => 0, -1 => 1
      NVV = LO(NV,NV)
      L = JF(JF(MAXID))
      FMA = '(A'//CF(:L)//',1X,50A3,20(:/'//CF(:L)//'X,1X,50A3))'//' '
      BLANK = -99
C Select records WITH replacement
      CALL RANLST(NREC,NREC,LIST)
C       LIST(K) is the frequency of record K's selection
      AV = 0.D0; SD = 0.D0; KOV = 0; COV = 0.D0
C Read each record under appropriate format
      CALL FNDLOM(3,LOM)
      CALL POSN(3,LOM,IER)
      NS = 0     ! NS counts total records; no ID exclusions
      NG = 0     ! NG counts records with all good scores
      NR = 0     ! NR counts moment accumulations
50    CALL RECOVR(FMA,NZ,CHS,NS+1,JMP)
      IF(JMP==0) GOTO 70 ! JMP=0 marks end of file
      NS = NS+1 ! NS is count of records read; last one not yet processed
      NJ = LIST(NS)
      IF(NJ==0) GOTO 210
      LP1: DO I = 1,NZ
        READ(CHS(I),*,ERR=55,END=55) F   ! Error should occur only under non-* format
        XX(I) = F
        CYCLE LP1  ! This includes case where F reads Blank
55      XX(I) = -99
      END DO LP1
      DO I = 1,NV
         GET(I) = XX(PK(I))   !  ******** Out-of-range error here
      END DO
C Accumulate raw moments
      DO I = 1,NV
        CALL OMIT(K,NV,BLANK,GET,KOV) ! K returns 0/1 flag for missing data
      END DO
      IF(K/=1) NG = NG+NJ
C       K is returned as 1 (otherwise 0) if data are missing from this record
      IF(KSKIP*K==1) GOTO 220
      DO I = 1,NV
        AV(I) = AV(I) + GET(I)*NJ
        X = GET(I)*GET(I)
        SD(I) = SD(I) + X*NJ
      END DO
      DO I = 1,NV-1
        DO J =I+1,NV
          COV(LO(I,J)) = COV(LO(I,J)) + GET(I)*GET(J)*NJ
        END DO
      END DO
210   CONTINUE
       NR = NR+NJ
220   CONTINUE
C      IF(MOD(NS,LSHO)==0) WRITE(6,'(4X," Score record",I5,
C     + " has been processed")') NS
      GOTO 50
C Compute summary statistics
70    CONTINUE
      MIS = 0
      DO I = 1,NV
        NSI = (NS - KOV(LO(I,I)))*(1-KSKIP) + NG*KSKIP
        MIS = MIS + KOV(LO(I,I))
        IF(NSI==0) CYCLE
        AV(I) = AV(I)/NSI
        X = SD(I)/NSI
        SD(I) = X
      END DO
      DO I = 1,NV-1
        DO J = I+1,NV
          N = (NS - KOV(LO(I,J)))*(1-KSKIP) + NG*KSKIP
          IF(N>0) COV(LO(I,J)) = COV(LO(I,J))/N - AV(I)*AV(J)
        END DO
      END DO
      DO I = 1,NV
        X = SD(I) - AV(I)*AV(I)
        COV(LO(I,I)) = X
        SD(I) = SQRT(MAX(0.,X))
      END DO
      DO I = 1,NV
        DO J = I,NV
          S2 = SD(I)*SD(J)
          IF(S2>=1.D-35) COV(LO(I,J)) = COV(LO(I,J))/S2
        END DO
      END DO
      OPEN(9,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(9) (SNGL(COV(I)),I=1,NVV)
      RETURN
      END
C
C      CALL MODA(NX,MTH,PIK,IER,BIN,BIN(NVV+1),BIN(2*NVV+1),
C     +  BIN(3*NVV+1),BIN(3*NVV+NVF+1),BIN(3*NVV+3*NVF+1),
C     +  BIN(3*NVV+3*NVF+NV+1))
C
      SUBROUTINE MODA(NX,MTH,PIK,IER,CY,W,W1,T,A,U,CS)
C     BIN needs 3*NVV+3*NVF+NV+NV*(NV+2) = 3*(NVV+NVF+NV) + NV*NV
C  MODA CY:NVV, W:NVV, W1:NVV, T:NV+NF, A:2*NV*NF, U:NV, CS:2*NV*NV
C   +  NV*(3NV/2 + 3 + 2NF + 3NF + 1 + 2NV) = NV*(7NV/2 + 5NF + 4)
C                       ! Need PIK for item reflections
      CHARACTER CF*12   !, CLN*8
CCC      INTEGER XSET(NV), YSET(NV), PIK(NV)  ! Put XSET at end of YSET
      INTEGER YSET(NV), PIK(NV)
      REAL CY(*), W(*), W1(*), T(NV,*), A(NV,*), U(*), CS(NV,*)
      COMMON NV, NF
      COMMON /CF/ CF
      COMMON /MOD/ NY,ICYC,IMAX,TOL,SE,XE,RVAR,G
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      LSHO = 10   ! Choose how often to show factoring progress

CC Real MODA
CC      CHARACTER*12 F1,F2,F3, CF, FMA*30, FMT1*34, FMT2*41, FMT3*41,
CC     +  WORD*80, IDENT(NV)*8, CLN*8, NAME(40)
CC      CHARACTER DIGIT, SLASH, CH, QFMT, C11,C12,C21,C22, BAR,LIN
CC      INTEGER*2 LIST(NV), LSTR(NV), XSET(NV),YSET(NV), LSTF(NF),IBUF(NV)
CC      INTEGER LU(NVV)
CC      REAL CY(NVV), W(NVV), W1(NVV), T(NV,NF), A(NV,2*NF), L(NV), CS(NV,NV+2)

C Set default values of iteration limit IMAX, convergence criterion TOL.
      IMAX = 50
      TOL = .001
      NVV = LO(NV,NV)
      REWIND 9
      READ(9) (W(I),I=1,NVV)
      CLOSE(9)
C Set up X-set and Y-set
      NY = NV-NX
      DO I = 1,NV
        YSET(I) = I
      END DO
C Sort input covars W into X-covars CX, Y-covars CY, and between-Y/X covars CS
      NYY = NY*(NY+1)/2
      DO I = 1,NY
        DO J = I,NY
          CY(LO(I,J)) = W(LO(YSET(I),YSET(J)))
        END DO
      END DO
      IF(NX==0) GOTO 30
      DO I = 1,NX
        DO J = I,NX
          C = W(LO(YSET(NY+I),YSET(NY+J)))
          K = LO(I,J)
CC          CX(K) = C
          W1(K) = C
        END DO
      END DO
      OPEN(18,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(18) (W1(I),I=1,LO(NX,NX))
      DO I = 1,NY
        DO J = 1,NX
          CS(I,J) = W(LOC(YSET(I),YSET(NY+J)))
        END DO
      END DO
C If NX>0, compute regression of Y-set on X-set and the Y-residual covariances
      CALL INVS(NX,W1,1,IER)
      IF(IER/=0) WRITE(6,'(/" The X-set contains a linear depend",
     +  "ency. Will try another selection."/)')
      IF(IER/=0) RETURN
      AVAR = 0.
      DO I = 1,NY
        DO J = I,NY
          S = 0.
          DO N = 1,NX
            R = 0.
            DO K = 1,NX
              IF(K<=N) TIJ = CS(I,K)*W1(LO(K,N))
              IF(K>N) TIJ = CS(I,K)*W1(LO(N,K))
              IF(J==I) R = R + TIJ
              S = S + TIJ*CS(J,N)
            END DO
            IF(J==I) A(I,N) = R
          END DO
          IF(J==I) CS(NV,I) = S
          IF(J==I) AVAR = AVAR+S
          CY(LO(I,J)) = CY(LO(I,J)) - S
        END DO
      END DO
C   The regression coeffs for Y upon X are momentarily stored in A(_,_).
C   The individial Y-variances accounted for by X are in CS(NV,_). CX saves
C   the X-covariances. And the residual Y-covariances are in CY.
      OPEN(8,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(8) ((A(I,J),I=1,NY),J=1,NX)
C Compute SMC uniqueness bounds
30    WRITE(6,'(/" Computing initial communality estimates.")')
C New MODA code
      DO J = 1,NY
        DO I = 1,J
          A(I,J) = CY(LO(I,J))
        END DO
      END DO
      CALL EIGS(NY,NY,A,NY,U,A,NY,1,IER,7) ! Eigvecs returned in A
      DO K = 1,NY
        IF(U(K)>=1.E-6) NR = K
      END DO
      DO I = 1,NY
        S = 0.
        DO J = 1,NR
          S = S + A(I,J)*A(I,J)/U(J)
        END DO
        CS(I,NV+1) = CY(LO(I,I)) - 1./S  !  Inv(Diag[Inv(CS)]) holds best uniqueness ests
        CS(I,NV+2) = CS(I,NV+1)  ! Permanent store; other will be updated
      END DO
C   Hereafter, CS holds Y-residual items' covs, with their initial comm ests
C   saved in CS(-,NV+1) until PRINF updates those in CS(-,NV+1)
      MFAC = ABS(MTH)
      KK = NF-NX
C Factor by chosen method
      IER = 0
      IF(MFAC/=2) THEN
        CALL PRINF(KK,MFAC,LSHO,CY,CS,A,T,U,W)
      ELSE
        DO I = 1,NYY
          W(I) = CY(I)
        END DO
        CALL ALLCNT(NV,KK,A,W,CS,W1)
        WRITE(6,'(//" Iteration details for ",A," MINRES fac",
     +    "tors:"/)') CF(:JF(KK))
        CALL MINRES(KK,LSHO,IER,CY,CS,A,U,W)
      END IF
      DO J = 1,NF  ! Includes XSET factors
        DO I = 1,NF
          CS(I,J) = 0.
          IF(I==J) CS(I,J) = 1.
        END DO
      END DO
      IF(NX==0) GOTO 175
      REWIND 18
      READ(18) (W1(I),I=1,LO(NX,NX))
      DO J = 1,NX
        DO I = 1,J
          CS(I,J) = W1(LO(I,J))
          CS(J,I) = CS(I,J)
        END DO
        DO I = 1,NX
          A(NY+I,J) = 0.
          IF(I==J) A(NY+I,J) = 1.
        END DO
      END DO
        DO J = KK,1,-1
          DO I = 1,NY
            A(I,J+NX) = A(I,J)  ! Shift YSET pattern to make room for XSET
        END DO
      END DO
      REWIND 8
      READ(8) ((A(I,J),I=1,NY),J=1,NX)
      CLOSE(8)
175   OPEN(9,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(9) ((A(I,J)*ISIGN(1,PIK(I)),I=1,NV),J=1,NF), ((CS(I,J),
     +  I=1,NF),J=1,NF)
      WRITE(9) (YSET(I)*ISIGN(1,PIK(I)),I=1,NY), (YSET(NY+I),I=1,NX)
C      *** Note: Item reflections are passed in YSET/XSET signs
      RETURN
      END

      SUBROUTINE ALLCNT(NV,KF,A,W,CS,W1)
C This receives a sym-storage string W of covars among NV variables and
C solves for KF centroid factors.  The estimated centroid pattern is returned
C in A, while W is destroyed.  CS and W1 are workspaces.
      CHARACTER CF*12
      REAL A(NV,*), CS(NV,*), W(*), W1(*)
      COMMON /CF/ CF
      LO(I,J) = J*(J-1)/2 + I
      IF(KF<=0) RETURN
      K = 0
50    K = K+1
      DO I = 1,NV
        DO J = I,NV
          CS(I,J) = W(LO(I,J))
        END DO
      END DO
      DO I = 1,NV
        DO J = I+1,NV
          CS(J,I) = CS(I,J)
        END DO
      END DO
        WRITE(6,'(" Solving for centroid approximation to factor ",
     +    A,".")') CF(:JF(K))
      CALL CENT(NV,A(1,K),CS,W1)
      IF(K==KF) RETURN
      DO I = 1,NV
        DO J = I,NV
          W(LO(I,J)) = W(LO(I,J)) - A(I,K)*A(J,K)
        END DO
      END DO
      GOTO 50
      END
C
      SUBROUTINE CENT(NV,VEC,CS,W)
C This receives the covariances among NV residual variables in full matrix
C CS, re-orients these to roughly-maximal convergence, solves for their 1st
C centroid factor, puts this into vector VEC, and returns the residual covs
C left by this centroid in CS.  W is a storage space,
      REAL CS(NV,*), VEC(*), W(*)
      LO(I,J) = J*(J-1)/2 + I
      NV1 = NV+1
      DO I = 1,NV
        CS(I,NV1) = 1.0
        DO J = I,NV
          W(LO(I,J)) = CS(I,J)
        END DO
      END DO
C        Use tail of CS to keep track of reflections after saving input in W.
C Reflect variables to near-maximal convergence
10    DO J = 1,NV
        VEC(J) = 0.
        DO I = 1,NV
          IF(I/=J) VEC(J) = VEC(J) + CS(I,J)
        END DO
      END DO
      KT = 0
14    KT = KT+1
      IZ = 1
      DO J = 2,NV
        IF(VEC(J)<VEC(IZ)) IZ = J
      END DO
      IF(VEC(IZ)>=0.) GOTO 20
      DO J = 1,NV
        IF(J==IZ) CYCLE
        CS(J,IZ) = -CS(J,IZ)
        CS(IZ,J) = -CS(IZ,J)
        VEC(J) = VEC(J) + 2*CS(IZ,J)
      END DO
      CS(IZ,NV1) = -CS(IZ,NV1)
      VEC(IZ) = -VEC(IZ)
      IF(KT<NV*NV) GOTO 14
20    VT = 0.
      DO J = 1,NV
        VEC(J) = VEC(J) + CS(J,J)
        VT = VT + VEC(J)
      END DO
      VT = SQRT(VT)
      DO J = 1,NV
        VEC(J) = CS(J,NV1)*VEC(J)/VT
      END DO
C Partial out the centroid factor and return the residual covers in CS.
      DO I = 1,NV
        DO J = I,NV
          CS(I,J) = W(LO(I,J)) - VEC(I)*VEC(J)
          CS(J,I) = CS(I,J)
        END DO
      END DO
      RETURN
      END

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
C      SAVE /CF/  ! This doesn't appear to be needed
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      CLN = '        '
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      LD = ABS(ND)
      IF(ABS(X)<1.0E-12) THEN !  Special for vanishingly small X
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X))) !  M is space free for decimal (or M-1 if X<0) )
      IF(M<0 .OR.  M<1.AND.X<0.) GOTO 55
      IF(ND>=10) LD = 0; LD = MIN(LD,M)
      DO I = 1,KW
        WK(I) = ' '
      END DO
      IF(LD==0) N = NINT(ABS(X))         ! Shouldn't be needed, but is
      IF(LD/=0) N = NINT(ABS(X)*10**LD)  ! This can overflow if LD is large
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' -------'
      END FUNCTION
C
      FUNCTION COMP2(AJ,AK,SS)
C Given an item I's squared loadings AJ and AK on factors J,K and its sum
C of squared loadings SJK, compute its Comp2 salience in plane JK as follows:
C P = (AJ+AK)/SS is its prominance of this plane in I's composition, and
C R = Min(|AJ|,|AK|)/MAX(|AJ|,|AK|) [or some monotone increasing function
C f(R) thereof] reflects the degree to which these two factors are equally
C prominant in I.  Then COMP2 = P*R (or [P*f(R)] equals 1.0 when item I lies
C entirely in plane JK with the same weight on both factors, and decreases
C to zero as either factor P or R decreases.
      P = (AJ**2 + AK**2)/SS
      BJ = ABS(AJ); BK = ABS(AK); R = MIN(BJ,BK)/MAX(BJ,BK)
      COMP2 = P*R
      END FUNCTION
C
      SUBROUTINE FNDEND(K,NB)
C Positions file K for writing after line Last-minus-NB; Lahey, Microsoft,
C and Sun UNIX compilers all require NB  0.  To READ line Last-minus-NB,
C replace NB with NB+1.
C **** In particular, use NB=0 to append to end, but NB=1 to READ last line.
      BACKSPACE K
10    READ(K,'()',END=20)
      GOTO 10
20    DO I = 1,NB+1
        BACKSPACE K
      END DO
      RETURN
      END
C
      SUBROUTINE FNDLOM(K,LOM)
C This finds number LOM of lines in file K before first starting with a number.
      CHARACTER CH*20
      REWIND K
      LOM = -1
10    LOM = LOM+1
      READ(K,'(A)',END=30) CH
      CALL LAST(L,CH,20)
      I = 1
      IF(CH(1:1)=='-' .OR. CH(1:1)=='.') I = 2
      IF(CH(1:2)=='-.') I = 3
      L = ICHAR(CH(I:I))
      IF(L<48 .OR. L>57) GOTO 10
      BACKSPACE K
      RETURN
30    LOM = 1
      REWIND K
      RETURN
      END
C
      SUBROUTINE INVS(NV,W,KIND,IER)
C If KIND>0, this inverts an order-NV symmetric matrix W in symmetric storage.
C If KIND=0, this triangularly Gram-factors W and returns the inverse of that.
      DOUBLE PRECISION SDP
      REAL W(*)
      LO(I,J) = J*(J-1)/2 + I
      IER = 0
C Replace W by its lower-triangular Gram-factor
      DO I = 1,NV
        I0 = I-1
        I1 = I+1
        LII = LO(I,I)
        IF(I0==0) GOTO 20
        DO K = 1,I0
          WIK = W(LO(K,I))
          W(LII) = W(LII) - WIK*WIK
        END DO
20      IF(W(LII)>1.0E-35) GOTO 21
        IER = 2
        IF(W(LII)<0.) IER = 1
        IF(IER==1) WRITE(6,'(" *** Subroutine INVS cannot invert ",
     +    "non-Gramian matrix"/)')
        IF(IER==2) WRITE(6,'(" *** Subroutine INVS cannot invert ",
     +    "singular matrix"/)')
        RETURN
21      W(LII) = SQRT(W(LII))
        IF(I1>NV) GOTO 50
        DO J = I1,NV
          LIJ = LO(I,J)
          IF(I0==0) GOTO 35
          DO K = 1,I0
            W(LIJ) = W(LIJ) - W(LO(K,J))*W(LO(K,I))
          END DO
35        W(LIJ) = W(LIJ)/W(LII)
        END DO
      END DO
C Invert triangular Gram-factor
50    W(LO(1,1)) = 1./W(LO(1,1))
      DO I = 2,NV
        I0 = I-1
        LII = LO(I,I)
        DO J = 1,I0
          SDP = 0.
          DO K = J,I0
            SDP = SDP - W(LO(K,I))*W(LO(J,K))
          END DO
          W(LO(J,I)) = SDP/W(LII)
        END DO
        W(LII) = 1./W(LII)
      END DO
      IF(KIND==0) RETURN
C Premultiply Gram-factor inverse by its transpose
80    DO I = 1,NV
        DO J = I,NV
          SDP = 0.
          DO K = J,NV
            SDP = SDP + W(LO(I,K))*W(LO(J,K))
          END DO
          W(LO(I,J)) = SDP
        END DO
      END DO
      RETURN
      END
C
      SUBROUTINE LAST(L,WORD,M)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as L. If the string is empty, LAST is returned as 0.
C **** In this modification, negative M waives left-justification.
      CHARACTER WORD*(*)
      IF(M>=0) WORD(:M) = ADJUSTL(WORD(:M))
      L = LEN_TRIM(WORD(:ABS(M)))
      END SUBROUTINE
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
      LOGICAL PRM, QY
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP
      CHARACTER E   ! <<<  Special characters as needed
      WD = GET
      CALL LAST(M,WD,40)
      LL = 1
5     LL = LL+1
      E = WD(LL+1:LL+1)
      IF(E/='|' .AND. E/='/' .AND. LL<M) GOTO 5  ! *** No longer relevant
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Prevents no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(WORD(:1)==' ' .OR. WORD(:1)=='.') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
C       Filter out lines other than filenames
      CALL LAST(L,WORD,14)
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4) .AND. NAME(I)(L+5:L+5)==' ')
     +    GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NL)
      IF(NL>0) WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      CALL LAST(L1,NAM1,LEN(NAM1)); CALL LAST(L2,NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      CALL LAST(L1,WRD1,LEN(WRD1)); CALL LAST(L2,WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A number terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION

      SUBROUTINE MINRES(KF,LSHO,IER,CY,CS,A,U,W)
C This subroutine factors the covariances CY among NY variables for KF Minres
C factors, starting from an initial approximation to the pattern in matrix A
C and also returning the Minres solution in A. ICYC counts iteration cycles,
C and SE/XE are the standard-error/maximum-error of CY-reproduction by the
C returned pattern. Iteration stops by the same IMAX/TOL criterion used in sub-
C routine PRINF. (SHIFT can alternatively be max change in any pattern coeff.)
      CHARACTER CLN*8, CF*12
      REAL CY(*), CS(NV,*), A(NV,*), ABK(NV,KF), U(*), W(*)
      COMMON NV, NF
      COMMON /MOD/ NY,ICYC,IMAX,TOL,SE,XE,RVAR,G
      COMMON /CF/ CF
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      SE = 1.; SBK = 99.; NBK = 0; NFF = LO(KF,KF)
      DO I = 1,NY
        U(I) = 0.
      END DO
C Put the iterated factor pattern P into the 1st KF columns of A, followed by
C CY*P-less-exclusions in A(_,KF+_). Put P'*P into W(NFF+_) while its adjust-
C ment for the Ith pattern row goes into the beginning of W.
      WRITE(7,'(//" Iteration details for ",A,"-factor Minres ",
     +  "solution:")') CF(:JF(KF))
      LAST = 0; ICYC = 0
80    ICYC = ICYC + 1
      S1 = SE
      DO I = 1,NY
        DO J = 1,KF
          S = 0.
          DO K = 1,NY  ! Omit term CY(LO(I,K))*A(K,J) from sum when K=I
            IF(I/=K) S = S + CY(LOC(I,K))*A(K,J)
          END DO
          A(I,KF+J) = S
        END DO
      END DO
      DO J = 1,KF
        DO I = 1,J
          S = 0.
          DO K = 1,NY
            S = S + A(K,I)*A(K,J)
          END DO
          W(NFF+LO(I,J)) = S
        END DO
      END DO
C   Next, solve for each row of the new pattern estimate
      SHIFT = 0.
      BIG: DO K = 1,NY
        DO J = 1,KF
          DO I = 1,J
            W(LO(I,J)) = W(NFF+LO(I,J)) - A(K,I)*A(K,J)
          END DO
        END DO
        CALL INVS(KF,W,1,IER)
        IF(IER/=0) RETURN
        Z = 0.
        DO J = 1,KF
          S = 0.
          DO I = 1,KF
            S = S + A(K,KF+I)*W(LOC(I,J))
          END DO
          A(K,J) = G*S + (1.-G)*A(K,J)
          Z = Z + A(K,J)*A(K,J)
        END DO
        IF(Z<=CY(LO(K,K))) CYCLE BIG
        Z = SQRT(Z/CY(LO(K,K)))
        DO J = 1,KF
          A(K,J) = A(K,J)/Z
        END DO
      END DO BIG
C Examine accuracy of CY reproduction
      NH = 0  ! Will count Heywood cases
41    SE = 0.; XE = 0.; RVAR = 0.
      DO J = 1,NY
        DO I = 1,J
          S = 0.
          DO K = 1,KF
            S = S + A(I,K)*A(J,K)
          END DO
          S = CY(LO(I,J)) - S
          W(LO(I,J)) = S
C           W now stores errors of reproduction
          IF(I==J) THEN
            SHIFT = MAX(SHIFT,ABS(U(I)-S))
            U(I) = S  ! U(i) now contains the latest uniqueness
            RVAR = RVAR+S
            CYCLE   ! Inner loop
          END IF
          S = ABS(S)
          SE = SE + S*S
          IF(S<=XE) CYCLE   ! Inner loop
          XE = S
        END DO
      END DO
      SE = SQRT(SE/(NY*(NY-1)/2))
      IF(SE<SBK) THEN   ! Save minimal-SE pattern in ABK
        SBK = SE; NBK = ICYC
        DO J = 1,KF
          DO I = 1,NY
            ABK(I,J) = A(I,J)
          END DO
        END DO
      END IF
      IF(NH>0) GOTO 70    ! NH > 0 only at exit time
      IF(ICYC>=IMAX .OR. (SHIFT<=TOL*10 .AND. (S1-SE<=TOL/10
     + .OR.SHIFT<=TOL))) LAST = 1
      IF(MOD(ICYC-1,LSHO)==0 .OR. LAST==1) WRITE(6,'(I3," factors",
     +  ", Cycle",I3,":"/3X,"Max. comm. shift,",A5,"; <Stand.Err/Max.",
     +  "Err/Resid.Var> = <",A4,",",A5,",",A6,">")') KF, ICYC,
     +  CLN(SHIFT,5,3), CLN(SE,4,3), CLN(XE,5,3), CLN(RVAR,6,2)
C  Re-estimate pattern unless convergent or at iteration limit
      IF(LAST<1) GOTO 80   ! Do another iteration
      IF(ICYC>=IMAX .AND. SBK<SE-.0001) THEN  ! Replace current A by best
        DO J = 1,KF
          DO I = 1,NY
            A(I,J) = ABK(I,J)
          END DO
        END DO
        WRITE(7,'(" Note: Solution is nonconvergent, so best-fit pat",
     +    "tern from cycle ",A," is selected."/7X,"Stand.Err. at it",
     +    "eration limit was ",A5)') CF(:JF(NBK)), CLN(SE,5,4)
        WRITE(6,'(6X," >>>> No convergence, so best-fit pattern is sel",
     +    "ected. <<<<")')
        ICYC = NBK; NBK = -NBK; GOTO 41
      END IF
      LP1: DO I = 1,NY
        IF(U(I)<=CY(LO(I,I))) CYCLE LP1
        NH = NH+1
        S = SQRT(CY(LO(I,I))/U(I))
        DO J = 1,KF
          A(I,J) = A(I,J)*S
        END DO
        WRITE(7,'(" For KF = ",A,", loadings of variable ",A," were ",
     +    "downscaled to avoid Heywood uniqueness",A5)') CF(:JF(J)),
     +    CF(:JF(I)), CLN(W(LO(I,I)),5,2)
        CS(I,I) = CY(LO(I,I))  ! Diagonal returns communalities
      END DO LP1
      IF(NH>0) GOTO 41   ! Reappraise fit measures
70    IF(SHIFT<=TOL .AND. NBK>=0) WRITE(6,'(" Iteration converged",
     +  " on communalities.")')
      IF(S1-SE<=TOL/10 .AND. NBK>=0) WRITE(6,'(" Iteration conver",
     +  "ged on standard error of data reproduction.")')
      DO I = 1,NY  ! Save communalities for re-do factoring
        CS(I,NV+1) = CS(I,I)
      END DO
      END SUBROUTINE
C
      SUBROUTINE OMIT(K,NV,BLANK,GET,KOV)
C This replaces missing scores in GET by zero while counting in KOV(LO(I,J))
C the number of products summed in Cov(I,J) that are from zeroed missing data.
C K is returned as 1 if GET contains a missing datum, and as 0 otherwise.
      INTEGER KOV(*)
      REAL GET(*)
      LO(I,J) = J*(J-1)/2 + I
      K = 0
      LP2: DO I = 1,NV
        IF(ABS(GET(I)-BLANK)>=.0001) CYCLE LP2
C        If I isn't missing, KOV(I,J) for J>I will be increased just if J is missing.
        K = 1
        GET(I) = 0.
        KOV(LO(I,I)) = KOV(LO(I,I)) + 1
        DO J = I+1,NV
          IF(ABS(GET(J)-BLANK)>=.0001) KOV(LO(I,J)) = KOV(LO(I,J)) + 1
        END DO
C         KOV(I,J) is increased just if either I or J is missing.
C         Don't count for J<=I because it will be counted later.
        DO J = 1,I-1
          KOV(LO(J,I)) = KOV(LO(J,I)) + 1
        END DO
      END DO LP2
      RETURN
      END
C
      SUBROUTINE POSN(KF,L,IER)
C Position file KF to read line L+1. If L exceeds file length, reset to 0.
C If L is less than 0, count the number of file lines and return in IER.
      CHARACTER*12 CF
      COMMON /CF/ CF
      IER = 0
      REWIND KF
      IF(L==0) RETURN
      J = 0
10    J = J+1
      READ(KF,'()',END=20)
      IF(J==L) RETURN
      GOTO 10
20    IER = J-1
      IF(L>0) WRITE(6,'(" This file contains only ",A," lines.",
     +  "  Try again.")') CF(:JF(J-1))
      REWIND KF
      END
C
      SUBROUTINE PRINF(KF,MFAC,LSHO,CY,CS,A,T,U,W)
C This copies sym-storage input covars CY into regular storage CS; initializes
C communalities from stored SMCs and solves for KF iterated principal factors.
C The principal-factor pattern is returned as the columns of A; the communal-
C ities are returned in CS(I,I); eigenvalues are returned in L; and the common-
C factor residuals are returned in W. Iteration for communalities stops after
C IMAX iterations, or when the max communality SHIFT is less than TOL, or when
C the standard error of covariance reproduction decreases by less than TOL/10
C provided that SHIFT < TOL*10.
      CHARACTER CLN*8, CF*12
      REAL CY(*), CS(NV,*), A(NV,*), T(NV,*), U(*), W(*)
      COMMON NV, NF
      COMMON /MOD/ NY,ICYC,IMAX,TOL,SE,XE,RVAR,G
      COMMON /CF/ CF
      LO(I,J) = J*(J-1)/2 + I
      SE = 1.0
      KB = 1 ! Message file sent to EIGLIB
      OPEN(1,STATUS='SCRATCH') ! Only needed to keep EIGLIB from bitching
      LAST = 0; ICYC = 0; NH = 0
      DO I = 1,NY
        S = CS(I,NV)
        IF(MFAC==3) S = CY(LO(I,I))
        CS(I,I) = S
      END DO
8     ICYC = ICYC+1
      S1 = SE
      DO I = 1,NY-1
        DO J = I+1,NY
          CS(I,J) = CY(LO(I,J))
        END DO
      END DO
      CALL EIGS(NY,KF,CS,NV,U,T,NV,IER,1,KB)
      DO J = 1,KF
        Z = 0.
        DO I = 1,NY
          Z = Z + T(I,J)
        END DO
        S = SIGN(SQRT(MAX(0.,U(J))),Z)
        DO I = 1,NY
          A(I,J) = S*T(I,J)
        END DO
      END DO
      IF(MFAC==3) GOTO 21
      SHIFT = 0.
      DO I = 1,NY
        COMM = 0.
        DO J = 1,KF
          COMM = COMM + A(I,J)*A(I,J)
        END DO
        U(I) = COMM
        VI = CY(LO(I,I))
        IF(COMM>VI) COMM = VI
        SHIFT = MAX(SHIFT,ABS(COMM-CS(I,I)))
        CS(I,I) = COMM
      END DO
C Examine accuracy of CY reproduction; NH Will count Heywood cases
21    SE = 0.; XE = 0.; RVAR = 0.
      DO J = 1,NY
        DO I = 1,J
          S = 0.
          DO K = 1,KF
            S = S + A(I,K)*A(J,K)
          END DO
          S = CY(LO(I,J)) - S
          W(LO(I,J)) = S
C           W stores errors of reproduction
          IF(I==J) RVAR = RVAR+S
          IF(I==J) CYCLE
          S = ABS(S)
          SE = SE + S*S
          IF(S<=XE) CYCLE
          XE = S
        END DO
      END DO
      SE = SQRT(SE/(NY*(NY-1)/2))
      IF(NH>0) GOTO 101   ! NH > 0 only at exit time
      IF(ICYC>=IMAX .OR. MFAC==3. OR. (SHIFT<=TOL*10 .AND.
     +  (S1-SE<=TOL/10 .OR. SHIFT<=TOL))) LAST = 1
      IF(MOD(ICYC-1,LSHO)/=0 .AND. LAST/=1) GOTO 26
      IF(MFAC<3) WRITE(6,'(I3," factors, Cycle",I3,":"/3X,"Max.",
     +  " comm. shift,",A5,"; <Stand.Err/Max.Err/Resid.Var> = <",A4,
     +  ",",A5,",",A6,">")') KF, ICYC, CLN(SHIFT,5,3), CLN(SE,4,3),
     +  CLN(XE,5,3), CLN(RVAR,6,2)
      IF(MFAC==3) WRITE(6,'(I3," factors: <Stand.Err/Max.Err/Resid.",
     +  "Var> = <",A4,",",A5,",",A6,">")') KF, CLN(SE,4,3),CLN(XE,5,3),
     +  CLN(RVAR,6,2)
C  Re-estimate pattern unless convergent or at iteration limit (or if Components)
26    IF(MFAC==3) GOTO 70
      IF(LAST/=1) GOTO 8
      LP1: DO I = 1,NY
        IF(U(I)<=CY(LO(I,I))) CYCLE LP1
        NH = NH+1
        S = SQRT(CY(LO(I,I))/U(I))
        DO J = 1,KF
          A(I,J) = A(I,J)*S
        END DO
        WRITE(7,'(" For KF = ",A,", loadings of variable ",A,
     +    " were downscaled to avoid Heywood uniqueness",A5)')
     +    CF(:JF(KF)), CF(:JF(I)), CLN(W(LO(I,I)),5,2)
        CS(I,I) = CY(LO(I,I))
      END DO LP1
      IF(NH>0) GOTO 21   ! Reappraise fit measures
101   DO I = 1,NY
        CS(I,NV+1) = CS(I,I)  ! Save communalities for next extraction call
      END DO
      IF(SHIFT<=TOL) WRITE(6,'(" Iteration converged on communal",
     +  "ities.")')
      IF(S1-SE<=TOL/10) WRITE(6,'(" Iteration converged on stand",
     +  "ard error of data reproduction.")')
70    END SUBROUTINE
C
      FUNCTION RANDY()
C Use the compiler's random generator for a random number in the unit interval
      DATA NEW/1/
      SAVE NEW
      IF(NEW>0) THEN
        NEW = 0
        CALL RANDOM_SEED()
      END IF
      CALL RANDOM_NUMBER(RANDY)
      END FUNCTION
C
      SUBROUTINE RANLST(NS,NT,LTAG)
C This randomly selects NS of integers 1 to NT with replacement and returns
C the selection in LTAG. LTAG(i) is the number of times item i has been
C selected.  MAX is maximum number of repetitions not really needed.)
      INTEGER LTAG(*)
      DO I = 1,NS
        LTAG(I) = 0
      END DO
C Make selection WITH replacement
      DO I = 1,NS
        K = MIN(NT,1+INT(NT*RANDY()))
        LTAG(K) = LTAG(K)+1
      END DO
      RETURN
      END
C
      SUBROUTINE RECOVR(FMA,NY,CHS,NR,JMP) ! CHS returns read-string
C Read the next nonblank line in File 3
      CHARACTER*10 CHS(0:*), FMA*32, WORD*80, CF*12
      COMMON /CF/ CF
      JMP = 1
10    READ(3,'(A)',END=20) WORD
      CALL LAST(L,WORD,80)  ! Check whether blank
      IF(L>80) GOTO 10
      BACKSPACE 3
      READ(3,FMA,END=20) (CHS(I),I=0,NY)
      CHS(0) = CF(:JF(NR))//'               '
      RETURN
20    JMP = 0
      RETURN
      END
C
      SUBROUTINE SEENAM(LM,NX,IDENT,LS,KF)
C This writes to file KF the NX names in IDENT.  LM is max namelength.
C LS is number of lines to leave at top of screen.
      CHARACTER*8 IDENT(*), FMT*30, CF*12
      COMMON /CF/ CF
      MM = MAX(3,LM)
      LL = 79/(6+MM)                ! Number of fields per line
      IF(KF/=6) LL = 125/(6+MM)   ! Number of fields per line
      LB = (23-LS)*LL       ! Number of fields in 23-LS lines
      NS = MIN(1,MOD(79,6+LM)/2)  ! Number of spaces starting display line
      NK = 0
      FMT = '(80('//CF(:JF(NS))//'X,'//CF(:JF(LL))//
     +      '(I4,": ",A),:/))'//'    '
10    WRITE(KF,FMT) (I,IDENT(I)(:MM),I=NK+1,NK+MIN(LB,NX-NK))
      IF(1+(NX-NK)/LL<=18) RETURN   ! Number of lines needed to finish
      IF(KF==6) CALL WAIT(0)
      NK = NK+LB
      LB = 23*LL  ! Hereafter use full screen
      IF(NK>=NX) RETURN
      GOTO 10
      END
C
      SUBROUTINE SHOW(A1,C1,COMM,LD,KF)
C Print the pattern and factor covariances.  LD stipulates 2 or 3 decimal print
      REAL A1(NV,*), C1(NF,*), COMM(*)
      CHARACTER FMT1*47, FMT2*61, CLN*8, CH4*4, WORD*10
      COMMON NV, NF
      IF(KF==6) THEN
        FMT1 = '(4X,7X,2(2X,5(1X,A4)),90(:/13X,2(2X,5(1X,A4))))'
        FMT2 = '(I4,". (",A3,")"'//FMT1(7:)
      ELSE
        FMT1 = '(4X,8X,3(2X,5(1X,A5)),90(:/14X,3(2X,5(1X,A5))))'
        FMT2 = '(I4,". (",A4,")"'//FMT1(7:)
      END IF
      WRITE(KF,'(/" Factor pattern (communalities in parentheses)")')
      DO I = 1,NV
        IF(MOD(I-1,5)==0) WRITE(KF,'()')
        CH4 = CLN(COMM(I),LD+1,LD)//' '
        WRITE(KF,FMT2) I, CH4, (CLN(A1(I,J),LD+2,LD),J=1,NF)
        IF(KF/=6 .OR. MOD(I,10)/=0 .OR. NV-I<=5) CYCLE
        WRITE(6,'(/" Hit RETURN to continue this display, or enter",
     +    " anything to quit it.")')
        READ(5,'(A)') WORD
        IF(WORD/='          ') RETURN
      END DO
      IF(KF==6) RETURN
      IF(LD==2) FMT2 = '(" Factor",I3,"."'//FMT1(7:)
      IF(LD==3) FMT2 = '("  Factor",I3,"."'//FMT1(7:)
      WRITE(KF,'(/" Factor correlations")')
      DO J = 1,NF
        IF(MOD(J-1,5)==0) WRITE(KF,'()')
        WRITE(KF,FMT2) J, (CLN(C1(I,J),LD+2,LD),I=1,J)
      END DO
      RETURN
      END
C
      SUBROUTINE SSCAN(NL,WORD,KFILE)
C     Copyright (c) 1991 by W. W. Rozeboom.   All rights reserved.
C This is a stripped version of SCAN that reads the keyboard string and cleans
C it for list-directed readings of the numbers therein returned in scratch
C file 2.  It returns NL = 0 if the input string is empty, and NL = -1 if the
C input string is nonempty but contains no numbers.  Otherwise, NL is the
C count of numbers (real or integer) returned in the cleaned string.
C ***** In this extension, the string read is in external file KFILE
C unless KFILE < 0 in which case it is in WORD.
      CHARACTER  WA*240, WB*240, WORD*(*)
      IF(KFILE>=0) THEN
        READ(KFILE,'(A)') WA
        LN = LEN(WA); CALL LAST(NL,WA,LN)
      ELSE  ! Reminder: LN is output
        LN = LEN(WORD); CALL LAST(NL,WORD,SIGN(LN,KFILE))
        IF(NL>0) WA(:NL) = WORD
      END IF
      IF(NL<=0) RETURN
      WB(NL+1:NL+1) = ' '
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.
     +      WA(I+1:I+1)=='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND.
     +      IP==0) WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
        ELSE IF (WA(I:I) /= '0') THEN
          IP = 0
        END IF
      END DO
      NN = 0
      DO I = 1,NL+1
        IF(WB(I:I)/=' ' .AND. WB(I+1:I+1)==' ') NN = NN+1
      END DO
      REWIND 2
      WRITE(2,'(A)') WB(:NL)
      REWIND 2
      NL = -1
      IF(NN>0) NL = NN
      RETURN
      END
C
      SUBROUTINE SUMMRY(NDUN,TT,GAP,LX,LX2,CH6,JOB,A1,C1,STORA,STORC)
Cc               BIN needs NFSQ+9*NVF1+4*NF*NF1
CCC      CALL SUMMRY(NDUN,TT,GAP,LX,LX2,CH6,-1,BIN,BIN(NVF1+1),BIN(NVF1+
CCC     +            NFSQ+1),BIN(NFSQ+9*NVF1+1))
C  SUMMRY  A1:NV*NF1, C1:NF*NF, STORA:8*NV*NF1, STORC:4*NF*NF1
C     = NV*(NF1 + 8NF1) + NF*(NF+4NF1) = NV*9NF1 + NF*(5NF1-1)

C Update storage bins if JOB = 0, initialize bins if JOB < 0, or compute
C summary statistics if JOB  1.
      PARAMETER ( MX=3 )
C            MX is number of special correlations
      CHARACTER*12 CF, CH6*6, CLN*8, CH*1
      REAL A1(NV,0:NF), C1(NF,NF), GG(2,2)  ! Accumulate grand sums/sum-sqs
C          Column 0 of A0 and A1 holds communalities
      DOUBLE PRECISION STORA(NV,0:NF,4), STORC(NF*(NF+1)/2,4),
     +                 STORX(MX,6), S1, S2, S3
C      STORA/STORC sum err,err*2,err*3,err*4 of pattern/covar error terms
C      STORX collects special correlations ^ over the bootstrap repetitions:
C        For each ^ coded 1,2,...,MX, STORX(^,1-6) are
C                       N, , , , , 
C        STORX(1,_): signed loading ^ others on same item, different factor
C        STORX(2,_): signed loading ^ others on different item, same factor
C        STORX(3,_): signed loading ^ others on different item, different factor
C ?       STORX(4,_): factor covar ^ others between entirely different factors

      COMMON NV, NF
      COMMON /CF/ CF
      LO(I,J) = J*(J-1)/2 + I
      NFF = LO(NF,NF)
      OPEN(4,FILE='BOOTDATA',FORM='UNFORMATTED')
      READ(4)
      IF(JOB/=0) THEN
        READ(4) NN, ((A1(I,J),I=1,NV),J=1,NF),((C1(I,J),I=1,NF),J=1,NF),
     +    J,BH,CV,JA,JB,WSAL   ! ,PD1
        DO I = 1,NV
          A1(I,0) = 0.
          DO J = 1,NF
            DO K = 1,NF
              A1(I,0) = A1(I,0) + A1(I,J)*C1(J,K)*A1(I,K)
            END DO
          END DO
        END DO
      END IF
      IF(JOB>=0) GOTO 100
      WRITE(6,'(/" To see the target factor pattern with which boot",
     +  "strap solutions will be"/" aligned, enter anything.  Other",
     +  "wise, hit RETURN to get on with the job.")')
      CALL SSCAN(J,CH,5)
      IF(J/=0) THEN
        WRITE(6,'(" Bootstrap axes will be permuted and reflected ",
     +    "for best match with:")')
        CALL SHOW(A1(1,1),C1,A1,2,6)
      END IF
      IF(NDUN>0) GOTO 20
C Initialize bins
      DO I = 1,NV
        DO J = 0,NF
          DO K = 1,4
            STORA(I,J,K) = 0.D0
          END DO
        END DO
      END DO
      DO I = 1,NFF
        DO K = 1,4
          STORC(I,K) = 0.D0
        END DO
      END DO
      DO I = 1,MX
        DO K = 1,6
          STORX(I,K) = 0.D0
        END DO
      END DO
      WRITE(4) 0, 0., 0., 0, 0  ! NDUN, TT, GAP, LMX, LMX
      WRITE(4) (((STORA(I,J,K),I=1,NV),J=0,NF),K=1,4), ((STORC(I,K),
     +          I=1,NFF),K=1,4), ((STORX(I,K),I=1,MX),K=1,6)
20    CLOSE(4)
      RETURN

C Reload accumulations
100   IF(JOB==0) READ(4)
      READ(4)  ! Line 3 is read only at initial and reload startup.
      READ(4) (((STORA(I,J,K),I=1,NV),J=0,NF),K=1,4), ((STORC(I,K),
     +        I=1,NFF),K=1,4), ((STORX(I,K),I=1,MX),K=1,6)
      IF(JOB>=1) GOTO 200
      REWIND 11  ! Retrieve latest HYBALL deviation from target
      READ(11) ((A1(I,J),I=1,NV),J=0,NF), ((C1(I,J),I=1,NF),J=1,NF)
      CLOSE(11)
C Update accumulations
      DO J = 0,NF
        DO I = 1,NV
          S1 = A1(I,J)
          S2 = S1*S1
          STORA(I,J,1) = STORA(I,J,1) + S1
          STORA(I,J,2) = STORA(I,J,2) + S2
          STORA(I,J,3) = STORA(I,J,3) + S1*S2
          STORA(I,J,4) = STORA(I,J,4) + S2*S2
        END DO
        DO I = 1,J
          S1 = C1(I,J)
          S2 = S1*S1
          IJ = LO(I,J)
          STORC(IJ,1) = STORC(IJ,1) + S1
          STORC(IJ,2) = STORC(IJ,2) + S2
          STORC(IJ,3) = STORC(IJ,3) + S1*S2
          STORC(IJ,4) = STORC(IJ,4) + S2*S2
        END DO
      END DO
      DO I1 = 1,NV
        DO J1 = 1,NF
          DO I2 = 1,I1
            DO J2 = 1,J1
              IF(I1==I2 .AND. J1==J2) CYCLE
              S1 = A1(I1,J1)
              S2 = A1(I1,J1)
              IF(I1==I2) K = 1
              IF(J1==J2) K = 2
              IF(I1/=I2 .AND. J1/=J2) K = 3

C          STORX(K,1) = STORX(K,1) + 1.
CC          STORX(K,2) = STORX(K,2) + S1  ! Better to get Means & SDs from GG
CC          STORX(K,3) = STORX(K,3) + S2
CC          STORX(K,4) = STORX(K,4) + S1*S1
CC          STORX(K,5) = STORX(K,5) + S2*S2
C          STORX(K,6) = STORX(K,6) + S1*S2

            END DO
          END DO
        END DO
      END DO
      BACKSPACE 4
      BACKSPACE 4
      WRITE(4) NDUN, TT, GAP, LX, LX2
      WRITE(4) (((STORA(I,J,K),I=1,NV),J=0,NF),K=1,4), ((STORC(I,K),
     +          I=1,NFF),K=1,4), ((STORX(I,K),I=1,MX),K=1,6)
      CLOSE(4)
      RETURN

200   CONTINUE
      WRITE(7,'(/" The bootstrap target is No. ",A," in HYBUF arch",
     +  "ive, namely:")') CF(:JF(NN))
      CALL SHOW(A1(1,1),C1,A1,3,7)
      IF(ABS(GAP)>=.1) THEN
        AV = LX*1./NDUN
        SD = SQRT(MAX(.000001, LX2*1./NDUN - LX**2))
        WRITE(7,'(/" Each rotation collected was the most recurrent ",
     +    "under GAP = ",A4," in its Spin series.")') CLN(GAP,4,2)
        WRITE(7,'(" Their distribution of rank in series had Mean = ",
     +    A4," and SD = ",A4)') CLN(AV,4,2), CLN(SD,4,2)
      ELSE
        WRITE(7,'(/" Each rotation collected was the best in its ",
     +    "Spin series.")')
      END IF
      WRITE(7,'(" The main rotation parameters were MODE = ",A,", WSA",
     +  "L =",A4,", <BH,JA,JB,CV> = <",A3,", ",A,",",I2,",",A4,">.")')
     +  CH6, CLN(WSAL,4,1), CLN(BH,3,2), CF(:JF(JA)), JB, CLN(CV,4,1)
      WRITE(7,'(" Mean time per solution was ",A4," minutes.")')
     +  CLN(TT/(60*NDUN),4,2)
      WRITE(7,'(//130A)') ('=',I=1,100)
      DO I = 1,NV
        DO J = 0,NF
          DO K = 1,4
            STORA(I,J,K) = STORA(I,J,K)/NDUN
          END DO
        END DO
      END DO
      DO IJ = 1,NFF
        DO K = 1,4
          STORC(IJ,K) = STORC(IJ,K)/NDUN
        END DO
      END DO

C      DO I = 1,MX
C        STORX(I,6) = STORX(I,6)/STORX(I,1)
C      END DO

C       S1 = Sum1/N
C       S2 = Sum2/N
C       S3 = Sum3/N
C       SK = S3 - (3*S2 - 2*S1**2)*S1
C       KT = Sum4/N - (4*S3 - 6*S2*S1 + 3*S1**3)*S1
C        V = S2 - S1*S1
C       SD = DSQRT(DMAX1(0.,V))
C       SK = SK/(V*SD(I))
C       KT = KT/(V*V)
      DO K = 1,2
        GG(1,K) = 0.
        GG(2,K) = 0.
        DO I = 1,NV
          DO J = 1,NF
            GG(1,K) = GG(1,K) + STORA(I,J,K)   ! Means go into GG(1,_)
          END DO
        END DO
        DO IJ = 1,NFF
          GG(2,K) = GG(2,K) + STORC(IJ,K)     ! SDs go into GG(2,_)
        END DO
      END DO
      GG(1,1) = GG(1,1)/(NV*NF*NDUN)
      GG(2,1) = GG(2,1)/(NFF*NDUN)
      GG(1,2) = SQRT(MAX(0.,GG(1,2)/(NV*NF*NDUN)-GG(1,1)**2))
      GG(2,2) = SQRT(MAX(0.,GG(2,2)/(NFF*NDUN)-GG(2,1)**2))
C       Grand mean/SD for pattern loadings and factor covars are complete
      DO I = 1,NV
        DO J = 0,NF
          S1 = STORA(I,J,1)  ! Mean
          S2 = STORA(I,J,2)  ! Mean of squares
          S3 = STORA(I,J,3)  ! Mean of cubes
          STORA(I,J,3) = S3 - (3*S2 - 2*S1**2)*S1
          STORA(I,J,4) = STORA(I,J,4)- (4*S3 - 6*S2*S1 + 3*S1**3)*S1
          S2 = S2 - S1*S1
          STORA(I,J,2) = DSQRT(DMAX1(1.D-8,S2))
          IF(S2<1.D-8) THEN    ! Force dashes in CLN output
            STORA(I,J,3) = 9.D8
            STORA(I,J,4) = 9.D8
          ELSE
            STORA(I,J,3) = STORA(I,J,3)/(S2*STORA(I,J,2))
            STORA(I,J,4) = STORA(I,J,4)/(S2*S2)
          END IF
        END DO
      END DO
      DO IJ = 1,NFF
        S1 = STORC(IJ,1)  ! Mean
        S2 = STORC(IJ,2)  ! Mean of squares
        S3 = STORC(IJ,3)  ! Mean of cubes
        STORC(IJ,3) = S3 - (3*S2 - 2*S1**2)*S1
        STORC(IJ,4) = STORC(IJ,4)- (4*S3 - 6*S2*S1 + 3*S1**3)*S1
        S2 = S2 - S1*S1
        STORC(IJ,2) = DSQRT(MAX(0.D0,S2))
        IF(S2<1.D-8) THEN   ! Force dashes in CLN output
          STORC(IJ,3) = 9.D8
          STORC(IJ,4) = 9.D8
        ELSE
          STORC(IJ,3) = STORC(IJ,3)/(S2*STORC(IJ,2))
          STORC(IJ,4) = STORC(IJ,4)/(S2*S2)
        END IF
      END DO

ccc To reinstate this code block, also declare REAL GV(NV,2),GF(NF,2)
C      DO 220 I = 1,NV
C       GV(I,1) = GV(I,1)/(NV*NDUN)
C220    GV(I,2) = SQRT(MAX(0.,GV(I,2)/(NV*NDUN)-GV(I,1)**2))
CC       Marginal means/Sds for items over factors, and factors over items, are complete
C      DO 221 J = 1,NF
C       GV(J,1) = GF(J,1)/(NF*NDUN)
C221    GV(J,2) = SQRT(MAX(0.,GF(J,2)/(NF*NDUN)-GF(J,1)**2))

      DO J = 0,NF
        DO I = 1,NV
          A1(I,J) = STORA(I,J,1) + A1(I,J)
        END DO
      END DO
        DO J = 1,NF
          DO I = 1,J
            C1(I,J) = STORC(LO(I,J),1) + C1(I,J)
        END DO
      END DO
      WRITE(7,'(//" The MEAN bootstraps solution, averaged on each ",
     +  "term over all solutions, is:")')
      CALL SHOW(A1(1,1),C1,A1,3,7)
      DO K = 1,4
        IF(K==1) WRITE(7,'(//" The differences of these means from",
     +    " their respective target values are:")')
        IF(K==2) WRITE(7,'(//" The STANDARD DEVIATIONs of each sol",
     +    "ution element''s bootstrap distribution are respective",
     +    "ly:")')
        IF(K==3) WRITE(7,'(//" The SKEW of each solution elemen",
     +    "t''s bootstrap distribution:")')
        IF(K==4) WRITE(7,'(//" The KURTOSIS (standardized 4th mome",
     +    "nt) of each solution element''s bootstrap distribution:")')
        DO J = 0,NF
          DO I = 1,NV
            A1(I,J) = STORA(I,J,K)
          END DO
        END DO
        DO J = 1,NF
          DO I = 1,J
            C1(I,J) = STORC(LO(I,J),K)
          END DO
        END DO
        CALL SHOW(A1(1,1),C1,A1,3,7)
      END DO
      RETURN
      END
C
      SUBROUTINE WAIT(K)
C Space K lines before sending message
      DO I = 1,K
        WRITE(6,'()')
      END DO
      WRITE(6,'(" Hit RETURN to continue")')
      READ(5,'(A1)')
      RETURN
      END


C===========================================================================

C HYBALL stripped for HYBOOT application

      SUBROUTINE HYBALL(NV,NF,MAXTRY,NUFF,GAP,LMX,IER,A0,T1,W,C1,C0,
     +                  CG,A1)
CC      CALL HYBALL(NV,NF,MAXTRY,NUFF,GAP,LMX,IER,BIN,BIN(NVF1+1),BIN(2*NVF1+1),
CC     +     BIN(3*NVF1+1),BIN(3*NVF1+NFSQ+1),BIN(3*NVF1+2*NFSQ+1), ! ^ Need more
CC     +     BIN(3*NVF1+2*NFSQ+NFF+1)))                             ! for T1
CCC            A1(NV,0:2*NF) needs NV*(1+2*NF) < 2*NV*(1+NF) = 2*NVF1
CCC       Deviations from target solution A0/C0 are returned to MAIN in T1/C1
C  HYBL:  A0:NV*NF1=NVF1, T1:NV*NF1=NVF1, W:NV*NF=NVF, A1:NV*(2*NF+1) < 2*NVF1,
C          C1:NF*NF=NFSQ, C0:NF*NFSQ, CG:NFF
C      = NV*(NF1+NF1+NF+(2*NF+1)) + NF*(NF+NF+(NF+1)/2 )
C      = NV*(5NF + 3) + NF(2NF + NF1/2)

      INTEGER,ALLOCATABLE :: OMT(:)
      INTEGER KTL(NF,NF+1), FIX(NF), FIX1(NF), ORDER(NF)
      REAL A0(NV,0:NF), T1(NV,0:NF), W(NV,NF), C1(NF,NF), C0(NF,NF),
     +     CG(NF*(NF+1)/2), DG(NF), A1(NV,0:2*NF), LOSS
      COMMON /BL2/ BH,LIM,CV,JA,JB,PD1,ADD,B1TAN,CV1,DBRAD,PD0,R0,R1
      COMMON /BL4/ B0RAD, B0TAN, FINE
      COMMON /BL6/ WSAL, GAM
      COMMON /BL8/ B0, B1, DB, DF, TOL, IMAX, MODE
      LO(I,J) = J*(J-1)/2 + I
C  Set default parameters and other initializations
      FINE = .05
C       FINE is the initial STEP size in brute-force scanning.
      RAD = 90/ACOS(0.)
      NB = 0
C  Get rotation parameters and target pattern
      OPEN(4,FILE='BOOTDATA',FORM='UNFORMATTED')
      READ(4) NV, NF, J,J,J, MODE  ! NF includes any XSET factors
      READ(4) J, ((A0(I,J),I=1,NV),J=1,NF), ((C0(I,J),I=1,NF),J=1,NF),
     +  LIM,BH,CV,JA,JB,WSAL,PD1, NOM, (OMT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), B0, B1, DB, DF, TOL, IMAX, GAM
      CLOSE(4)
CC  hyball write to bootdata:
CC      WRITE(10) NV, NF, ABS(NX), KODE, MTH, MODE, F2, F1, WORD(:12),
CC     +  (SIGN(KBB(ABS(LST1(I))),LST1(I)),I=1,NV)  ! NX needed to instruct MODA in HYBOOT
CC      WRITE(10) N, ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF),
CC     +  LIM, BH, CV, JA,JB, WSAL, PD1, NOM, (OMIT(I),I=1,NOM),
CC     +  (FIX(I),I=1,NF), B0, B1, DB, DF, TOL, IMAX, GAM

      ALLOCATE ( OMT(NOM+1) )
C  Read pattern to be rotated
      REWIND 9
      READ(9) ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF)
      CALL BLOCK(NF,KTL,NB,FIX,FIX1)
C  Set subroutine parameters
      B0RAD = B0/RAD
      B0TAN = TAN(B0RAD)
      B1TAN = TAN(B1/RAD)
      DBRAD = DB/RAD
      CV1 = CV+1
      IF(JA>=0) R0 = CV/(JA+1)
      IF(JA<0) R0 = 1./(1.-JA)
      IF(JA<0) CV1 = R0-1.
      R1 = 1./(JB-1)
      IF(JA>=0) ADD = JB*R1 + JA*R0
      IF(JA<0) ADD = (1.-JA) + R1
      PD0 = 1.-PD1
      HMIN = LOSS(A0)
C  Do SPIN search
      CALL SPIN(A1,T1,C1,CG,W,FIX,KTL,HMIN,LIM,MAXTRY,NUFF,GAP,LMX,
     +          IER,OMT)
      IF(IER>0) RETURN
      CALL ALIGN(A1(1,1),A0(1,1),ORDER,DG,W,AV,HI)
      CALL PERM(A1(1,1),C1,ORDER,W)  ! Permute/reflect K into K'
C Return difference of rotation result from target pattern/covars
C  Compute communalities

C      DO 9710 I = 1,NV
C       S0 = 0.
C       S1 = 0.
C       DO 9711 J = 1,NF
C        DO 9711 K = 1,NF
C         S1 = S1 + A1(I,J)*C1(J,K)*A1(I,K)
C9711     S0 = S0 + A0(I,J)*C0(J,K)*A0(I,K)
C       A0(I,0) = S0
C9710   A1(I,0) = S1
C      WRITE(21,'(/" After alignment, the best SPIN pattern is")')
C      DO 3434 I = 1,NV
C3434   WRITE(21,'(" (",A5,")",10A5)') (CLN(A1(I,J),5,2),J=0,NF)
C      WRITE(21,'(/" with covariances")')
C      DO 3432 J = 1,NF
C3432   WRITE(21,'(10A5)') (CLN(C1(I,J),5,2),I=1,J)
C      WRITE(21,'(/" Target pattern remains")')
C      DO 3424 I = 1,NV
C3424   WRITE(21,'(" (",A5,")",10A5)') (CLN(A0(I,J),5,2),J=0,NF)

C  Compute communality differences
      DO I = 1,NV
        T1(I,0) = 0.
        DO J = 1,NF
          DO K = 1,NF
            T1(I,0) = T1(I,0) + A1(I,J)*C1(J,K)*A1(I,K) - A0(I,J)*
     +             C0(J,K)*A0(I,K)
          END DO
        END DO
      END DO
      DO J = 1,NF
        DO I = 1,NV
          T1(I,J) = A1(I,J) - A0(I,J)
        END DO
        DO I = 1,NF
          C1(I,J) = C1(I,J) - C0(I,J)
        END DO
      END DO
      OPEN(11,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(11) ((T1(I,J),I=1,NV),J=0,NF), ((C1(I,J),I=1,NF),J=1,NF)
      CLOSE(9)
      RETURN
      END
C
      SUBROUTINE ALIGN(A,B,ORDER,DG,WORK,AV,HI)
C This compares the co1umns of NV-by-NF matrix A to those of matrix B, and puts
C into vector ORDER the permutation (and reflection if signalled by negative
C ORDER value) of A's columns that aligns A with B most closely. The congruence
C coefficients for the best match are converted to degrees difference and
C reported in vector DG with their average in AV and max in HI.
      INTEGER ORDER(*)
      REAL A(NV,*), B(NV,*), WORK(NV,*), DG(*), WK(NV,2)
      COMMON NV, NF
      RAD = 90/ACOS(0.)
      DO J = 1,NF
        ORDER(J) = 0
        WK(J,1) = 0
        WK(J,2) = 0
        DO I = 1,NV
          WK(J,1) = WK(J,1) + A(I,J)*A(I,J)
          WK(J,2) = WK(J,2) + B(I,J)*B(I,J)
        END DO
      END DO
      DO J = 1,NF
        DO K = 1,NF
          SAB = 0
          DO I = 1,NV
            SAB = SAB + A(I,J)*B(I,K)
          END DO
          WORK(J,K) = SAB/SQRT(MAX(WK(J,1)*WK(K,2),1.E-8))
        END DO
      END DO
      AV = 0.
      HI = 0.
      DO K = 1,NF
        NI = 0
        NJ = 0
         X = 0.
        LP30: DO J = 1,NF
          DO L = 1,NF
            IF(ABS(ORDER(L))==J) CYCLE LP30
          END DO
C             Skip J if already matched
          DO I = 1,NF
            IF(ORDER(I)/=0) CYCLE
C             Skip I if already matched
            R = ABS(WORK(I,J))
            IF(R<=X) CYCLE
            X = MIN(1.0,R)
            NI = I
            NJ = J
          END DO
        END DO LP30
        ORDER(NI) = SIGN(NJ,FLOOR(WORK(NI,NJ)))
C         A-factor NI matches B-factor NJ while negative NJ tells PERM to reflect.
C         ORDER permutes A into B-matching order.
        DG(NJ) = ACOS(X)*RAD
C         DG(J) is divergence of B-factor J from its matching A-factor
C         DG(ABS(ORDER(K))) is divergence of A-factor K from matching B-factor
        AV = AV+DG(NJ)
        HI = MAX(HI,DG(NJ))
      END DO
      AV = AV/NF
      RETURN
      END
C
      SUBROUTINE BLOCK(NF,KTL,NB,FIX,FIX1)
C This enters the subspace-fixation structure into KTL.
C NB is the number of positive-FIX control blocks.
      INTEGER FIX(NF), FIX1(NF), KTL(NF,*), KTL1(NF,NF)
C  Unpack block codes
      DO L = 1,NB  ! This also initializes L for later use
        KTL1(L,L) = 1
        NI = FIX1(L)
        DO J = 1,L-1
          KTL1(L,J) = MOD(NI,2)
          NI = NI/2
        END DO
      END DO
      N0 = 0
      N1 = 0
      DO I = 1,NF
        IF(FIX(I)/=99) N1 = N1+1
        IF(FIX(I)==0) N0 = N0+1
      END DO
      IF(N1==0) GOTO 55
C  Construct rotation-control matrix KTL from FIX codes.
55    DO I = 1,NF
        DO J = 1,NF+1
          KTL(I,J) = 0
        END DO
      END DO
      DO I = 1,NF
        IB = FIX(I)
        IF(IB>100) IB = 0
        KTL(I,I) = 1
        IF(IB<=0) CYCLE
        DO J = 1,NF
          IF(I==J) CYCLE
          JB = FIX(J)
          IF(JB>100) JB = 0
          IF(JB==0 .OR. IB>=NF.AND.JB>=0) KTL(I,J) = 1
          IF(JB>0.AND.JB<=IB.AND.IB<=NB) KTL(I,J) = KTL1(IB,JB)
          KTL(I,NF+1) = KTL(I,NF+1)+KTL(I,J)  ! Tell if factor I is movable
        END DO
      END DO
      END
C
      SUBROUTINE CHEK(NV,NF,IER,A,BIG)
C Return IER = 1 if pattern is intolerably bizarre
      REAL A(NV,*)
      IER = 0
      BIG = 0.
      DO I = 1,NV
        DO J = 1,NF
          X = ABS(A(I,J))
          BIG = MAX(BIG,X)
          IF(X>10.) IER = 1
          IF(X>10.) RETURN
        END DO
      END DO
      RETURN
      END
C
      FUNCTION HYFIND(K,L,A1,WW)
C This finds coefficient for rotating factor K by factor L to the misfit-
C minimizing hyperplane by brute-force scanning.
C *** New: When WSAL < 0, WW contains Comp2 weights.
      REAL A1(NV,0:*), WW(*), MISFIT
      COMMON NV, NF
      COMMON /BL4/ B0RAD, B0TAN, FINE
      COMMON /BL6/ WSAL, GAM
      CALL OMSET(K,L,A1,NV,NF,JL)
      DO I = 1,NV    ! OMSET has put 999. in A1(I,0) if omit, otherwise 0.
        IF(ABS(A1(I,K))<.01 .OR. ABS(A1(I,L))/(.001+ABS(A1(I,K)))
     +    >B0TAN) A1(I,0) = 999.
        IF(A1(I,0)<1) THEN
          IF(WSAL>.01) A1(I,0) = ABS(A1(I,K))**WSAL ! Salience weighting
          IF(WSAL<-.01) A1(I,0) = WW(I)   ! Comp2 Weighting
        END IF
      END DO
      HYFIND = 0.
      SMALL = MISFIT(K,L,A1,HYFIND)
      WIDE = B0RAD
      STEP = FINE
15    START = ATAN(HYFIND)
      SHIFT = 0.
      X = 0.
20    SHIFT = SHIFT+STEP
      X = TAN(START+SHIFT)
      S = MISFIT(K,L,A1,X)
      IF(S>=SMALL) GOTO 30
      HYFIND = X
      SMALL = S
30    X = TAN(START-SHIFT)
      S = MISFIT(K,L,A1,X)
      IF(S>=SMALL) GOTO 40
      HYFIND = X
      SMALL = S
40    IF(SHIFT<WIDE) GOTO 20
      IF(STEP < .01) RETURN
      WIDE = 1.5*STEP
      STEP = STEP/4.
      GOTO 15
      END FUNCTION
C
      FUNCTION HYPGET(K,L,A1,WW)
C This finds the coefficient for rotating factor K by factor L to hyperplane
C position in the K/L plane by step-down regression.
      REAL A1(NV,0:2*NF), B1(NV,0:2), WW(*)
      COMMON NV, NF
      COMMON /BL2/ BH,LIM,CV,JA,JB,PD1,ADD,B1TAN,CV1,DBRAD,PD0,R0,R1
      COMMON /BL4/ B0RAD, B0TAN, FINE
      COMMON /BL6/ WSAL, GAM
      HYPGET = 0.
      JJA = MAX(0,JA)
      IF(LIM>0) JJA = JA
      CALL OMSET(K,L,A1,NV,NF,JL)
      DO I = 1,NV    ! OMSET has put 999. in A1(I,0) if omit, otherwise 0.
        IF(ABS(A1(I,K))<.01 .OR. ABS(A1(I,L))/(.001+ABS(A1(I,K)))
     +   >B0TAN) A1(I,0) = 999.
        IF(A1(I,0)>998.) CYCLE
        A1(I,0) = A1(I,L)/A1(I,K)
        B1(I,0) = ABS(A1(I,K))/BH
        B1(I,1) = A1(I,K)*A1(I,K)
        B1(I,2) = A1(I,K)*A1(I,L)
        IF(WSAL==0.) CYCLE
        IF(WSAL>.0) WI = ABS(A1(I,K))**WSAL   ! Salience weighting
        IF(WSAL<.0) WI = WW(I)                ! Comp2 weighting
        B1(I,1) = B1(I,1)*WI
        B1(I,2) = B1(I,2)*WI
      END DO
      B = B0RAD + DBRAD
30    B = B - DBRAD
      BT = TAN(B)
      BT = MAX(BT,B1TAN)
      SK = 0.
      SL = 0.
      DO I = 1,NV
        IF(ABS(A1(I,0)-HYPGET) > BT) CYCLE
        SK = SK + B1(I,1)
        SL = SL + B1(I,2)
      END DO
      IF(SK>=.0001) HYPGET = SL/SK
      IF(BT>B1TAN) GOTO 30
      IF(LIM<=0) RETURN
      HYPO = HYPGET
      KOUNT = 0
50    KOUNT = KOUNT+1
      HYP1 = HYPO
      HYPO = HYPGET
      DO I = 1,NV
        ANG = ABS(A1(I,0)-HYPGET)
        IF(ANG>=1.) CYCLE
        E = ABS(B1(I,0)*ANG)
        IF(E>=1.) GOTO 70
        X = 1.
        IF(JJA==0 .OR. CV==0.) GOTO 60
        DO J = 1,JJA
          X = X*E
        END DO
60      WI = CV1 - CV*X
        GOTO 80
70      WI = 1./(E**4)
        IF(JB<=2) GOTO 80
        DO J = 3,JB
          WI = WI/E
        END DO
80      SK = SK + B1(I,1)*WI
        SL = SL + B1(I,2)*WI
      END DO
      IF(SK>.0001) HYPGET = SL/SK
      E = ABS(HYPGET-HYPO)
      HYPGET = PD1*HYPGET + PD0*HYPO
      B = HYPO - HYP1
      IF(KOUNT<LIM .AND. E>.01) GOTO 50
      END FUNCTION
C
      FUNCTION LOSS(A1)
C Actual arguments needed are A1,BH,JA,JB,CV; also CV1/ADD/R0/R1
      LOGICAL QY
      REAL A1(NV,0:*), LOSS
      COMMON NV, NF
      COMMON /BL2/ BH,LIM,CV,JA,JB,PD1,ADD,B1TAN,CV1,DBRAD,PD0,R0,R1
      COMMON /BL6/ WSAL, GAM
      QY = .FALSE.
      IF(WSAL>=.01) QY = .TRUE.
      IF(.NOT.QY) GOTO 20
C Compute matrix of salience weights rescaled to average 1.
      T = 0.
      DO I = 1,NV
        S = 0.
        IF(ABS(WSAL-1.)<.01) THEN
          DO J = 1,NF
            A1(I,NF+J) = ABS(A1(I,J))
            S = S + A1(I,NF+J)
          END DO
        ELSE
          DO J = 1,NF
            A1(I,NF+J) = ABS(A1(I,J))**WSAL
            S = S + A1(I,NF+J)
          END DO
        END IF
        A1(I,0) = S
        T = T+S
      END DO
20    LOSS = 0.
      DO J = 1,NF
        DO I = 1,NV
          D = A1(I,J)/BH
          E = D*D
          IF(E>=1.) GOTO 30
          IF(JA==0) X = E
          IF(JA>0) X = (CV1 - R0*(E**JA))*E
          IF(JA==-1) X = 2*ABS(D)
          IF(JA<-1) X = (E**R0)/R0
          GOTO 50
30        X = 1./E
          IF(JB<=2) GOTO 45
          DO K = 3,JB
            X = X/E
          END DO
45        X = ADD - R1*X
50        IF(QY) X = X*A1(I,NF+J)
          LOSS = LOSS + X
        END DO
      END DO
      END FUNCTION
C
      SUBROUTINE MINV(N,A,LDA,IER)
C This computes the inverse of N-by-N matrix A, with determinant available if
C wanted. LDA is the leading dimension of A declared in the calling program.
      INTEGER R(N), C(N)
      REAL A(LDA,*)
      IF(N>LDA) STOP
      D = 1.
      IER = 0
      BBIG: DO K=1,N
C Search for largest element
        R(K) = K
        C(K) = K
        BIG = A(K,K)
        DO J=K,N
          DO I=K,N
            IF(ABS(BIG)>=ABS(A(I,J))) CYCLE
            BIG = A(I,J)
            R(K) = I
            C(K) = J
          END DO
        END DO
C Interchange rows
        I = R(K)
        IF(I<=K) GOTO 60
        DO J=1,N
          HOLD = A(K,J)
          A(K,J) = A(I,J)
          A(I,J) = HOLD
        END DO
C Interchange columns
60      J = C(K)
        IF(J<=K) GOTO 90
        DO I=1,N
          HOLD = A(I,K)
          A(I,K) = A(I,J)
          A(I,J) = HOLD
        END DO
C Divide column by minus pivot (saved in BIG)
90      IF(ABS(BIG)<1.0E-30) IER = 1
        IF(IER==1.) RETURN
        DO I=1,N
          IF(I/=K) A(I,K) = -A(I,K)/BIG
        END DO
C Reduce matrix
        DO I=1,N
          HOLD = A(I,K)
          DO J=1,N
            IF(I==K .OR. J==K) CYCLE
            A(I,J) = A(I,J) + HOLD*A(K,J)
          END DO
        END DO
C Divide row by pivot
        DO J=1,N
          IF(J/=K) A(K,J) = A(K,J)/BIG
        END DO
C Accumulate product of pivots.  At output, D is the matrix's determinant.
        D = D*BIG
C Replace pivot by its reciprocal
        A(K,K) = 1./BIG
      END DO BBIG
C Final row/column interchange to undo permutations
      K = N
200   K = K-1
      IF(K==0) RETURN
      J = R(K)
      IF(J<=K) GOTO 240
      DO I=1,N
        HOLD = A(I,K)
        A(I,K) = A(I,J)
        A(I,J) = HOLD
      END DO
240   I = C(K)
      IF(I<=K) GOTO 200
      DO J=1,N
        HOLD = A(K,J)
        A(K,J) = A(I,J)
        A(I,J) = HOLD
      END DO
      GOTO 200
      END SUBROUTINE
C
      FUNCTION MISFIT(K,L,A1,W)
C     Copyright (c) 1994 by W. W. Rozeboom.   All rights reserved.
C This computes for brute-force scanning the hyperplane-misfit measure whose
C 1st derivative is used for polish weights in subroutine HYPGET. WSAL is the
C salience-weighting parameter.
      REAL A1(NV,0:*), MISFIT
      COMMON NV, NF
      COMMON /BL2/ BH,LIM,CV,JA,JB,PD1,ADD,B1TAN,CV1,DBRAD,PD0,R0,R1
      COMMON /BL6/ WSAL, GAM
      MISFIT = 0.
      IF(JA==2 .AND. JB==2) GOTO 80
      DO I =1,NV
        IF(A1(I,0)>NF*1.) CYCLE
        D = (A1(I,L) - A1(I,K)*W)/BH
        E = D*D
        IF(E>=1.) GOTO 30
        IF(JA==0) X = E
        IF(JA>0) X = (CV1 - R0*(E**JA))*E
        IF(JA==-1) X = 2*ABS(D)
        IF(JA<-1) X = (E**R0)/R0
        GOTO 50
30      X = 1./E
        IF(JB<=2) GOTO 45
        DO J = 3,JB
          X = X/E
        END DO
45       X = ADD - R1*X
50      IF(WSAL>.01) X = X*A1(I,0)
        MISFIT = MISFIT + X
      END DO
      RETURN
80    DO I = 1,NV
        IF(A1(I,0)>NF+1.) CYCLE
        E = (A1(I,L) - A1(I,K)*W)/BH
        E = E*E
        IF(E<=1.) X = (CV1 - R0*E*E)*E
        IF(E>1.) X = ADD - 1./E
        IF(WSAL>.01) X = X*A1(I,0)
        MISFIT = MISFIT + X
      END DO
      END FUNCTION
C
      SUBROUTINE OMSET(M,N,A1,NV,NF,JL)
C ***** This is stripped to execute only JOB=0 *****
C This sets OMIT entries for factor pair <M,N>; MN = M*100 + N;
C Omissions are passed in A1(-,0) as full 0,999 flaglist for rotation control
C when JOB=0 or as JL omit indices when JOB>0.  JOB1 calls display/revision of
C omissions in screen plot display; JOB>1 flags less vertical screen space.
      PARAMETER (LX=100, MOM=1000)
      CHARACTER CF*12
      INTEGER OMIT(MOM), LST(NOM+LX)
      REAL A1(*)
      COMMON /BL4/ B0RAD, B0TAN, FINE
      COMMON /CF/ CF
      COMMON /OM/ NOM, OMIT
      SAVE /BL4/, /OM/
C Each OMIT entry is I*100*100 + M*100 + N where I is an item index,
C and <M,N> is the factor pair (M<N).  Entries are NOT in plane order.
C Scan OMIT for factor pair <M,N>'S current omission stipulations
      IF(NF>99) WRITE(6,'(10X,"HYBALL makes no provision for item",
     +  " exclusions when"/10X,"the number of factors exceeds 99.  ",
     +  "Be thankful.")')
      IF(NF>99) RETURN
      MN = MIN(M,N)*100 + MAX(M,N)   ! Neither M or N can exceed 99
      JL = 0
      DO K = 1,NOM    ! NOM is number of entries in OMIT
        IF(MOD(OMIT(K),10000)==MN) THEN
          JL = JL + 1
          LST(JL) = OMIT(K)/10000
          A1(JL) = 1.*LST(JL)
        END IF
      END DO   ! Col 0 of A1 ports OMIT list for plane-pair MN to PLOT
      DO I = 1,NV    ! Load A1 (= A1(0,-)) for rotation control
        A1(I) = 0.
      END DO
      IF(JL==0) RETURN
      DO J = 1,JL
        A1(LST(J)) = 999.
      END DO  !       ^   Function MISFIT needs this larger than NF
      RETURN  !  Always end of JOB=0
      END SUBROUTINE
C
      SUBROUTINE PERM(A1,C1,ORDER,W)
C This permutes/reflects factors as instructed
      REAL A1(NV,*), C1(NF,*), W(NV,*)
      INTEGER ORDER(NF)
      COMMON NV, NF
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
30    K = 1
      DO I = 1,NF
        IF(ORDER(I)/=I) K = 0
      END DO
      IF(K==1) RETURN
      DO J = 1,NF
        IF(ORDER(J)>0) CYCLE
        ORDER(J) = -ORDER(J)
        DO I = 1,NV
          A1(I,J) = -A1(I,J)
        END DO
        DO I = 1,NF
          C1(I,J) = -C1(I,J)
          C1(J,I) = -C1(J,I)
        END DO
      END DO
      DO I = 1,NV
        DO J = 1,NF
          W(I,ORDER(J)) = A1(I,J)
        END DO
        DO J = 1,NF
          A1(I,J) = W(I,J)
        END DO
      END DO
      DO J = 1,NF
        DO I = 1,NF
          W(ORDER(J),ORDER(I)) = C1(I,J)
        END DO
      END DO
      DO J = 1,NF
        DO I = 1,NF
          C1(I,J) = W(I,J)
        END DO
      END DO
      RETURN
      END
C
      SUBROUTINE ROTATE(A1,KTL,T1,C1,LIM,IER,W,CG,FIX,OMT)
      LOGICAL QT
      CHARACTER CLN*8, TRD
      INTEGER OMT(*)
      INTEGER KTL(NF,*), FIX(*), ORDER(NF)
      REAL A1(NV,0:*), T1(NV,0:*), W(NV,*), C1(NF,*), CG(*),
     +     DG(NF), DE(NF), SS(NV,3)
      DOUBLE PRECISION SI
      COMMON NV, NF
      COMMON /BL6/ WSAL, GAM
      COMMON /BL8/ B0, B1, DB, DF, TOL, IMAX, MODE
      LO(I,J) = J*(J-1)/2 + I
      RAD = 90/ACOS(0.)
      TRD = ''
      CMAX = .95   ! Limit on factor correlations under Serial rotation
      MM = MODE/2
      QT = .TRUE.
      ICYC = 0; NF1 = NF+1; NF2 = NF+2
      KS = 10
      IF((MODE)/2==0) KS = 15
C       KS determines frequeny of rotation-progress report to screen.
C     WRD/'STEP/S','STEP/P','SCAN/S','SCAN/P','OBLMIN'/  ! WRD goes from 0 to 4.
      KPRL = MOD(MODE,2)   ! 1 for Parallel, 0 for Serial
      IF(LIM<=0) GOTO 15  ! Still diagnoses STEP
      NQ = 0   ! Initialize count of successive cyclic nonconvergences
15    ICYC = ICYC+1
      IF(WSAL<0.) THEN
        DO I = 1,NV ! Use cols NF1,NF2 of T1 for computing Comp2 weights
          SS(I,1) = A1(I,1)**2
          DO J = 2,NF
            SS(I,1) = SS(I,1) + A1(I,J)**2
          END DO
        END DO
      END IF
      IF(KPRL==1) GOTO 200  ! Jump to parallel rotation
C Do serial rotation. Note: Serial iteration uses B0 but not DF.
      DO J = 1,NF   ! Save start pattern/covars for shift comparison
        DO I = 1,NV
          T1(I,J) = A1(I,J)
        END DO
      END DO
      BIGA1: DO I = 1,NF    ! I is the factor rotated to change
        BIGA2: DO J = 1,NF   !   loadings on factor J
          IF(I==J .OR. KTL(I,J)/=1) CYCLE BIGA2
          IER = 0
          DO L = 1,NV
            A1(L,NF2) = A1(L,J)    ! Formerly saved in BUFA(L,2)
            A1(L,NF1) = A1(L,I)    ! Formerly saved in BUFA(L,1)
            IF(WSAL>=0.) CYCLE
            SS(L,3) = A1(L,I)**2 + A1(L,J)**2 ! ****** Where used? (Check HYBALL2)
            SS(L,2) = 1. + WSAL*COMP2(A1(L,I),A1(L,J),SS(L,1))
          END DO
          IF(MM==0) WW = HYPGET(I,J,A1,SS(1,2))
          IF(MM==1) WW = HYFIND(I,J,A1,SS(1,2))
          IF(MM==2) WW = OBL(I,J,A1(1,1),C1)  ! GAM is negated in OBL
          S = SQRT(1+(2*C1(I,J)+WW)*WW)  ! SD of pre-normalized rotated factor I
          IF(S<1.E-5) THEN
            IER = 1
            CYCLE BIGA2
          END IF
          DO L = 1,NV
            A1(L,NF+2) = A1(L,NF+2) - WW*A1(L,NF+1)
            A1(L,NF+1) = S*A1(L,NF+1)
          END DO
          S = 1./S
          T = WW*S
          DO L = 1,NF
            IF(L==I) CYCLE
            A1(L,NF+3) = S*C1(L,I) + T*C1(L,J)   ! C1(L,I) = S*C1(L,I) + T*C1(L,J)
            IF(A1(L,NF+3)>CMAX) THEN
              IER = 1
              GOTO 85
            END IF
              C1(I,L) = C1(L,I)
          END DO
          A1(I,NF+3) = 1.0  ! Needed to avoid excluding L=I in Loop 162
          DO L = 1,NV
            A1(L,J) = A1(L,NF+2)
            A1(L,I) = A1(L,NF+1)
            IF(WSAL>=0.) CYCLE
            SS(L,1) = SS(L,1)-SS(L,3) + A1(L,J)**2 + A1(L,I)**2 ! Comp2 update
          END DO
          DO L = 1,NF
            C1(L,I) = A1(L,NF+3)
            C1(I,L) = C1(L,I)
          END DO
        END DO BIGA2
      END DO BIGA1
      CALL ALIGN(A1(1,1),T1(1,1),ORDER,DG,W,AV,HI)
C     Keep user appraised of progress
      IF(MOD(ICYC,KS)==0) WRITE(6,'(" Cycle",I3," pattern shifts (",
     +  A,"):",10A5,8(:/5X,15A5))') ICYC, TRD, (CLN(DG(I),5,1),I=1,NF)
      IF(ICYC<IMAX .AND.HI>TOL) GOTO 15
C  Reflect axes to achieve mainly positive loadings
      DO J = 1,NF
        CG(J) = 0.
        DO I = 1,NV
          CG(J) = CG(J) + A1(I,J)
        END DO
      END DO
C         CG(J) will show whether factor J loadings are mainly positive
      GOTO 64
C Do parallel rotation
200   DO I = 1,NF
        DO J = 1,NF
          W(I,J) = 0.
          IF(I==J .OR. KTL(I,J)/=1) CYCLE
          IF(WSAL<0) THEN
            DO L = 1,NV
              SS(L,2) = 1. + WSAL*COMP2(A1(L,I),A1(L,J),SS(L,1))   ! Comp2
            END DO
          END IF
          IF(MM==0) W(I,J) = HYPGET(I,J,A1,SS(1,2))
          IF(MM==1) W(I,J) = HYFIND(I,J,A1,SS(1,2))
CCC          IF(MM==2) W(I,J) = OBL(I,J,A1(1,1),C1) ! Not operative
        END DO
      END DO
C   Compute normalized factor-rotation matrix T1
      DO I = 1,NF
        DO J = 1,NF
          T1(I,J) = DF*W(I,J)
          IF(I==J) T1(I,I) = 1.
        END DO
      END DO
      DO I = 1,NF
        SI = 0.
        DO J = 1,NF
          DO K = 1,NF
            SI = SI + T1(I,J)*C1(J,K)*T1(I,K)
          END DO
        END DO
        DG(I) = 1./SQRT(SI)
      END DO
      DO J = 1,NF
        DO I = 1,NF
          T1(I,J) = DG(I)*T1(I,J)
        END DO
      END DO
C   Compute vector DE of new factor shifts in degrees
      DO I = 1,NF
        SI = 0.
        DO J = 1,NF
          SI = SI + T1(I,J)*C1(J,I)
        END DO
        IF(ABS(SI)>.99999) SI = 1.
        DE(I) = ABS(MIN(1.,ACOS(SI)))*RAD
ccc        DE(I) = ABS(MIN(1.,SNGL(ACOS(SI))))*RAD   ! Need SNGL here??
      END DO
C   Keep user appraised of progress
      IF(MOD(ICYC,KS)==0) WRITE(6,'(" Cycle",I3," factor shifts (",A,
     +  "):",10A5,8(:/5X,15A5))') ICYC, TRD, (CLN(DE(I),5,1),I=1,NF)
C Check for cyclic nonconvergence
      I1 = 0
      I2 = 0
      S = 2*TOL
      DO I = 1,NF
        IF(DE(I)<=S) I1 = I1+1
        IF(DE(I)>=15.) I2 = I2+1
      END DO
      IF(I2>=1 .AND. I2<=2 .AND. I1==NF-I2) THEN
        NQ = NQ+1  ! Initialized before start of cycles
        IF(NQ>=5) QT = .FALSE.
      ELSE
        NQ = 0
      END IF
C   Compute rotated factor covariances
      DO I = 1,NF
        DO J = I,NF
          SIJ = 0.
          DO K = 1,NF
            DO L = 1,NF
              SIJ = SIJ + T1(I,K)*C1(K,L)*T1(J,L)
            END DO
          END DO
          CG(LO(I,J)) = SIJ
        END DO
      END DO
      DO J = 1,NF
        C1(J,J) = CG(LO(J,J))
        DO I = 1,J-1
          C1(I,J) = CG(LO(I,J)); C1(J,I) = C1(I,J)
        END DO
      END DO
C   Invert factor-rotation matrix and compute new factor pattern,
C   reflecting factor axes if appropriate.
      CALL MINV(NF,T1(1,1),NV,IER)
      IF(IER/=0) RETURN
      DO J = 1,NF
        CG(J) = 0.
      END DO
      DO I = 1,NV
        DO J = 1,NF
          SIJ = 0.
          DO K = 1,NF
            SIJ = SIJ + A1(I,K)*T1(K,J)
          END DO
          CG(J) = CG(J) + SIJ
C           CG(J) will show whether factor J loadings are mainly positive
          DG(J) = SIJ
        END DO
C         DG holds new row of A1 until the old row is no longer needed
        DO J = 1,NF
          A1(I,J) = DG(J)
        END DO
      END DO
64    R = 1.
      DO J = 1,NF
        CG(J) = SIGN(1.,CG(J))
        IF(FIX(J)<=0) CG(J) = 1.
        R = MIN(R,CG(J))
      END DO
      IF(R>=0.) GOTO 70  ! No factor reflections needed
      DO J = 1,NF
        IF(CG(J)>=0) CYCLE
        DO I = 1,NV
          A1(I,J) = CG(J)*A1(I,J)
        END DO
      END DO
      DO J = 1,NF
        DO I = 1,NF
          C1(I,J) = CG(I)*CG(J)*C1(I,J)
        END DO
      END DO
70    IF(KPRL==0) GOTO 85
      IF(ICYC>=IMAX) QT = .FALSE.
80    DIFF = 0.
      DO I= 1,NF
        DIFF = MAX(DIFF,DE(I))
      END DO
      IF(QT .AND. DIFF>=TOL) GOTO 15
C   Finish rotation   ! Serial rotation re-enters at label 85
85    IF(IER==0) CALL CHEK(NV,NF,IER,A1(1,1),BIG)
      IF(IER>0) THEN
        GOTO 190
      END IF
      RETURN
190   REWIND 9 ! Reinstate old pattern/covars
      READ(9) ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF)
      RETURN
      END
C
      SUBROUTINE SORT(N,ARR)
C Sort real or integer list in ARR
C      REAL ARR(*)
      INTEGER ARR(*), A
10    DO J = 2,N
        A = ARR(J)
        DO I = J-1,1,-1
          IF(ARR(I)<=A) GOTO 12
          ARR(I+1) = ARR(I)
        END DO
        I = 0
12      ARR(I+1) = A
      END DO
      RETURN
      END
C
      SUBROUTINE SPIN(A1,T1,C1,CG,W,FIX,KTL,HMIN,LIM,MAXTRY,NUFF,
     +                GAP,LMX,IER,OMT)
C Give factor pattern in A1 a random rotation.  LMX is the Spin rank of the
C solution with highest LUMP count. Positive/negative GAP measures Lump
C distance by HI/AV.
      PARAMETER ( MKT=99, MRR=100)
      CHARACTER CLN*8
      INTEGER OMT(*)
      INTEGER FIX(*), KTL(NF,*), RR(MRR), LUMP(MRR)
      REAL A1(NV,0:*), T1(NV,0:*), C1(NF,*), CG(*), W(NV,NF), LOSS
      COMMON NV, NF
      LO(I,J) = J*(J-1)/2 + I
      IER = 0
      CMAX = .75
      KRY = 0
      NSPN = 0
      LUFF = -1
      GAP = 5.  !
C  Use the target pattern's Loss (HMIN) for reference standard
      XX = 1000/HMIN
      OPEN(17,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +  RECL=4*(NV*NF+NF*NF+4))
      OPEN(19,FORM='UNFORMATTED',STATUS='SCRATCH') ! Store fallback
      NFIX = 0
      DO I = 1,MRR
        LUMP(I) = 0
      END DO
      DO I = 1,NF
        IF(FIX(I)/=99) NFIX = NFIX+1     ! Number of constrained factors
      END DO
99    PR = .25
C Start another SPIN try
100   KRY = KRY+1
      KBLAB = 1
      KOUNT = 0
101   JORTH = INT(RANDY()/PR)
C       JORTH = 0 with probability PR; calls pre-orthogonalization
      REWIND 19 ! Save current pattern/covars as backup
      WRITE(19) ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF)
110   KOUNT = KOUNT + 1
      IF(KOUNT>MKT) THEN
        IF(KRY<5) IER = 1
        IF(KRY<5) RETURN
        GOTO 240
      END IF
      IF(KBLAB==0) WRITE(6,'(/" Repeating ROTATE call from random",
     +  "ized start No.",I3," in this Try.")') KOUNT
C Generate raw rotation matrix
      BG: DO I = 1,NF
        IF(FIX(I)>100) THEN
          K = FIX(I)-100
          S = 0.
          DO J = 1,NF
            S = S + A1(K,J)**2
          END DO
          S = SQRT(MAX(S,1.E-8))
          DO J = 1,NF
            T1(I,J) = A1(K,J)/S
          END DO
        ELSE
          DO J = 1,NF
            T1(I,J) = KTL(I,J)*(RANDY()-.5)
          END DO
          S = 0.
          DO J = 1,NF
            S = S + T1(I,J)**2
          END DO
          S = SQRT(MAX(S,1.E-8))
          DO J = 1,NF
            T1(I,J) = T1(I,J)/S
          END DO
C     Partial out previously norm'd rows correlating too highly with this one
          DO K = 1,I-1
            R = 0.
            S = 0.
            DO J = 1,NF
              R = R + T1(I,J)*T1(K,J)
              IF(KTL(I,J)/=0) S = S + T1(K,J)*T1(K,J)
            END DO
            IF(S<1.E-6) CYCLE BG
            IF(ABS(R)<=CMAX-.02*KOUNT) CYCLE
            R = R/S
            S = 0.
            DO J = 1,NF
              IF(KTL(I,J)/=0.AND.KTL(K,J)/=0) T1(I,J) = T1(I,J) -
     +          R*T1(K,J)
              S = S + T1(I,J)**2
            END DO
            IF(S<.0001) GOTO 110
            S = SQRT(S)
            DO J = 1,NF
              T1(I,J) = T1(I,J)/S
            END DO
          END DO
        END IF
      END DO BG

C With probability PR, attach pre-spin orthogonalization of the current factor
C correlations to the raw spin rotation matrix:  If JORTH=0 and all factors are
C unconstrained, postmultiply T1 by inverse of C1's lower-triangle Gram-factor.
      IF(JORTH==0 .AND. NFIX==0) THEN
        DO J = 1,NF
          DO I = 1,J
            CG(LO(I,J)) = C1(I,J)
          END DO
        END DO
        CALL INVS(NF,CG,0,IER)
        DO I = NF,1,-1
          DO J = 1,NF
            S = 0.
            DO K = J,NF
              S = S + T1(I,K)*CG(LO(J,K))
            END DO
            T1(I+1,J) = S
          END DO
        END DO
        DO I = 1,NF
          DO J = 1,NF
            T1(I,J) = T1(I+1,J)
          END DO
        END DO
      END IF
C Scale rotation matrix to yield normalized factors
      DO I = 1,NF
        S = 0.0
        DO J = 1,NF
          DO K = 1,NF
            S = S + T1(I,J)*C1(J,K)*T1(I,K)
          END DO
        END DO
          IF(S<1.E-8) GOTO 110
        CG(I) = SQRT(S)
      END DO
      DO I = 1,NF
        DO J = 1,NF
          T1(I,J) = T1(I,J)/CG(I)
        END DO
      END DO
C Compute Spin-shifted factor correlations and guard against factor collapse
      BIG = 0.0
      DO J = 1,NF
        CG(LO(J,J)) = 1.0
        DO I = 1,J-1
          S = 0.0
          DO K = 1,NF
            DO L = 1,NF
              S = S + T1(I,K)*C1(K,L)*T1(J,L)
            END DO
          END DO
          CG(LO(I,J)) = S
          IF(KTL(I,NF+1)>1.OR.KTL(J,NF+1)>1) BIG = MAX(BIG,ABS(S))
        END DO
      END DO
      IF(BIG>=CMAX) THEN
        IF(KOUNT>MKT/2) JORTH = 0
        GOTO 110
      END IF
      DO I = 1,NF
        DO J = I,NF
          C1(I,J) = CG(LO(I,J))
        END DO
      END DO
C         Upper triangle of C1 holds the new factor correlations while its
C         lower triangle still retains the old ones.  Invertibility of new C1
C         can now be checked by applying INVS(KIND=0) to CG.
      CALL INVS(NF,CG,0,IER)
      DO I = 2,NF
        DO J = 1,I-1
          IF(IER>0) C1(J,I) = C1(I,J)
          IF(IER==0) C1(I,J) = C1(J,I)
        END DO
      END DO
      IF(IER>0) GOTO 110
C   Invert factor-rotation matrix and compute new factor pattern,
C   reflecting factor axes if appropriate.
      CALL MINV(NF,T1(1,1),NV,IER)
      IF(IER/=0) GOTO 110
      NF2 = NF+2
      DO J = 1,NF
        CG(J) = 0.
      END DO
      DO I = 1,NV
        DO J = 1,NF
          SIJ = 0.
          DO K = 1,NF
            SIJ = SIJ + A1(I,K)*T1(K,J)
          END DO
          CG(J) = CG(J) + SIJ
C           CG(J) will show whether factor J loadings are mainly positive
          T1(NF2,J) = SIJ
        END DO
C         T1(NF2,_) holds new row of A1 until the old row is no longer needed
        DO J = 1,NF
          A1(I,J) = T1(NF2,J)
        END DO
      END DO
      R = 1.
      DO J = 1,NF
        CG(J) = SIGN(1.,CG(J))
        IF(FIX(J)<=0) CG(J) = 1.
        R = MIN(R,CG(J))
      END DO
      IF(R>=0.) GOTO 180
      DO J = 1,NF
        IF(CG(J)>=0) CYCLE
        DO I = 1,NV
          A1(I,J) = CG(J)*A1(I,J)
        END DO
      END DO
      DO J = 1,NF
        DO I = 1,NF
          C1(I,J) = CG(I)*CG(J)*C1(I,J)
        END DO
      END DO
180   CALL CHEK(NV,NF,IER,A1(1,1),BIG) ! Check for outlandish loadings
      IF(IER>0) THEN
        REWIND 19 ! Reinstate last pattern/covars
        READ(19) ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF)
        GOTO 110
      END IF
C Rotate SPIN-initiated pattern
      IF(KBLAB==1) WRITE(6,'(/" Commencing Spin try",I4,"; after ",
     +  "that,",I3," more.")') KRY, MAXTRY-KRY
      KBLAB = 0
      CALL ROTATE(A1,KTL,T1,C1,LIM,IER,W,CG,FIX,OMT)
      IF(IER>0) GOTO 101
      R = LOSS(A1)
C       All LOSS arguments are in common blocks
      IF(NSPN<MAXTRY) THEN
        NSPN = NSPN+1
        NR = NSPN
      ELSE
        CALL SORT(NSPN,RR)
        NR = MOD(RR(NSPN),100)
      END IF
      RR(NSPN) = NR + 100*NINT(R*XX)
      IF(NSPN==1) RMIN = R
      LUFF = LUFF+1
      IF(R<RMIN) LUFF = 0
      IF(NSPN>1) WRITE(6,'(" In proportion to best of current ",
     +  "series, misfit rating is",A6)') CLN(R/RMIN,6,3)
      WRITE(6,'(" Number of Tries since series'' best:",I3)') LUFF
      RMIN = MIN(RMIN,R)
      WRITE(17,REC=NR) ((A1(I,J),I=1,NV),J=1,NF),((C1(I,J),I=1,NF),
     +  J=1,NF)
      IF(NUFF>0 .AND. LUFF>=NUFF) GOTO 240
      IF(KRY<MAXTRY) GOTO 100
C Spin collection is complete; next, sort indices in order of quality.
C File-17 index is last two digits following quality rating in RR.
      IF(NSPN==1) THEN
        WRITE(6,'(/" All SPIN rotations of this pattern were degen",
     +   "erate.  Will try another bootstrap.")')
        IER = 1
        RETURN
      END IF
240   CALL SORT(NSPN,RR)
C  Do LUMP appraisal
      IF(ABS(GAP)<.1) THEN  ! Omit Lump concern
        NSP = 0
        LMX = 1
        GOTO 350
      END IF
      NSP = 1
      LP6:DO K = 2,NSPN
        READ(17,REC=K)((A1(I,J),I=1,NV),J=1,NF),((C1(I,J),I=1,NF),
     +    J=1,NF)
        DO L = 1,NSP
          READ(17,REC=K)((T1(I,J),I=1,NV),J=1,NF)
          CALL ALIGN(A1(1,1),T1(1,1),FIX,CG,W,AV,HI)
          IF(GAP>0..AND.HI<ABS(GAP) .OR. GAP<0. .AND.
     +        AV<ABS(GAP)) THEN
            LUMP(L) = LUMP(L) + 1
            CYCLE LP6
          END IF
        END DO
        NSP = NSP+1
        WRITE(17,REC=NSP) ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),
     +    I=1,NF),J=1,NF)
      END DO LP6
      LMX = 1
      DO I = 1,NSP
        IF(LUMP(I)>LUMP(LMX)) LMX = I
      END DO
350   N = MOD(RR(LMX),100)
      READ(17,REC=N) ((A1(I,J),I=1,NV),J=1,NF),((C1(I,J),I=1,NF),J=1,NF)
      IF(NSP==0) LMX = 0
      RETURN
      END

      FUNCTION OBL(IQ,IP,A,CF)
C Find coeff ALPHA that rotates factor IQ in IQ/IP plane of received pattern/
C covars A/CF to shift loadings on IP by OBLIMIN criterion, and return ALPHA
C as value of the function.  If wanted, Kaiser pattern norming can be done in
C the calling routine.  WG = -Gamma is negation of the direct-Oblimin family's
C Gamma parameter which should be non-positive; Gamma = 0 is direct quartimin.
      REAL(8) S, WP, WQ
      REAL A(NV,*), CF(NF,*), WK3(NV)
      COMMON NV, NF
      COMMON /BL6/ WSAL, GAM
      IF(IP==IQ) RETURN
      OBL = 0.
      G = -GAM
C Initialize work terms
      GAM = G/NV
      A0 = 0.0
      DO J = 1,NF
        WP = 0.D0  ! Get sum-square of pattern column IP
        WQ = 0.D0  ! Get sum-square of pattern column IQ
        DO I = 1,NV
          WP = WP + A(I,IP)**2
          WQ = WQ + A(I,IQ)**2
        END DO
      END DO
      DO I = 1,NV  ! Initialize WK3 first as sum-sq of A's rows
        S = 0.D0
        DO J = 1,NF
          S = S + A(I,J)**2
        END DO
        WK3(I) = S  ! Influence here by factors additional to IP and IQ
        WK3(I) = S  ! Influence here by factors additional to IP and IQ
        A0 = A0 + S
      END DO
      G = GAM*A0
      DO I = 1,NV
        WK3(I) = WK3(I) - G
      END DO
      A0 = 0.0
      A1 = 0.0
      A2 = 0.0
      A4 = 0.0
      A5 = 0.0
      CQM = GAM*WQ
      G = GAM*(WP+WQ)
      DO I = 1,NV
        AP2 = A(I,IP)*A(I,IP)
        AQ2 = A(I,IQ)*A(I,IQ)
        APQ = A(I,IP)*A(I,IQ)
        WK3(I) = WK3(I) - AP2 - AQ2 + G
        CQ = AQ2 - CQM
        A0 = A0 + AP2*CQ
        A1 = A1 + APQ*CQ
        A2 = A2 + AQ2*CQ
        A4 = A4 + AQ2*WK3(I)   ! Effect of outside factors here
        A5 = A5 + APQ*WK3(I)   ! Effect of outside factors here
      END DO
      A1 = -2.0*A1
      RR = 2.0*CF(IP,IQ)
C      Check the cubic equation
      IF(ABS(A2)<=0.0) RETURN
C      Get the cubic constants
      PP = A1/A2 + RR
      QQ = (A0+A1*RR+2.0*A4)/A2 + 1.0
      RQ = (A1+RR*(A0+A4)-2.0*A5)/A2
      ALPHA = QMIN(0.75*PP,0.5*QQ,0.25*RQ) ! Rotation coefficient
      OBL = ALPHA
      END FUNCTION
C
      REAL FUNCTION QMIN(P,Q,R)
C  Nucleus to find the minimum of a real quartic polynomial by finding the
C  zeros of its derivative and then minimizing.
      REAL(8) A, B, C1, C2, C3, CMAX, D, E, P2, T3, X, F3, R3
      PARAMETER (R3=1.0D0/3.0D0)
      F(X) = (((X/4.0D0+P/3.0D0)*X+Q/2.0D0)*X+R)*X
      P2 = P*P
      A = (3.0D0*Q-P2)/3.0D0
      B = (2.0D0*P2-9.0D0*Q)*P/27.0D0 + R
      D = B**2*0.25D0 + A**3/27.0D0
      IF(D>=0.0D0) THEN
         E = SQRT(D) - B/2.0D0
         F3 = SIGN(ABS(E)**R3,E) - P/3.0D0
         E = -(E+B)
         F3 = SIGN(ABS(E)**R3,E) + F3
      ELSE
         T3 = ACOS(-B/(2.0D0*SQRT(-A**3/27.0D0)))/3.0D0
         E = 2.0D0*SQRT(-A/3.0D0)
         C1 = COS(T3)
         C2 = COS(T3+4.1887902D0)
         C3 = COS(T3+2.0943951D0)
         F3 = MIN(C1,C2,C3)*E - P/3.0D0
         CMAX = MAX(C1,C2,C3)*E - P/3.0D0
         IF(F(CMAX)<F(F3)) F3 = CMAX
      END IF
      QMIN = SNGL(F3)
      END FUNCTION

      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12
      COMMON /CF/ CF
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48
      IF(ZZZ(5:6)=='01') WORD = CF(:JF(M))//' January '//ZZZ(:4)
      IF(ZZZ(5:6)=='02') WORD = CF(:JF(M))//' February '//ZZZ(:4)
      IF(ZZZ(5:6)=='03') WORD = CF(:JF(M))//' March '//ZZZ(:4)
      IF(ZZZ(5:6)=='04') WORD = CF(:JF(M))//' April '//ZZZ(:4)
      IF(ZZZ(5:6)=='05') WORD = CF(:JF(M))//' May '//ZZZ(:4)
      IF(ZZZ(5:6)=='06') WORD = CF(:JF(M))//' June '//ZZZ(:4)
      IF(ZZZ(5:6)=='07') WORD = CF(:JF(M))//' July '//ZZZ(:4)
      IF(ZZZ(5:6)=='08') WORD = CF(:JF(M))//' August '//ZZZ(:4)
      IF(ZZZ(5:6)=='09') WORD = CF(:JF(M))//' September '//ZZZ(:4)
      IF(ZZZ(5:6)=='10') WORD = CF(:JF(M))//' October '//ZZZ(:4)
      IF(ZZZ(5:6)=='11') WORD = CF(:JF(M))//' November '//ZZZ(:4)
      IF(ZZZ(5:6)=='12') WORD = CF(:JF(M))//' December '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE
C
      FUNCTION TM(KSET)   ! ******* Superceded ???
C The value (real) returned by function TM is seconds since last timer reset.
C After this value is determined, the timer is reset if KSET > 0 but continues
C to accumulate if KSET = 0.
      SAVE PREV
      DATA PREV/0./
      CALL TIMER(J)
      X = .01*J
      TM = X - PREV
      IF(TM<=0.) TM = TM + 86400
      IF(KSET==0) RETURN
      PREV = X
      RETURN
      END

C==================================================================
C TEST LINES
C      SUBROUTINE COMCHK(NV,NF,A1,C1,WORD,JOB) ! JOB=0 initializes
CC Test constancy of communalities
C      CHARACTER CLN*8, WORD*(*)
C      REAL A1(NV,0:*), C1(NF,*), CM(NV)
C      SAVE CM
C      DO 10 I = 1,NV
C       S = 0.
C       DO 12 J = 1,NF
C        DO 12 K = 1,NF
C12       S = S + A1(I,J)*C1(J,K)*A1(I,K)
C10     A1(I,0) = S
C      IF(JOB==0) THEN
C        DO 20 I = 1,NV
C20       CM(I) = A1(I,0)
C        WRITE(21,'(/" Communalities initiating COMCHK:"/50A6)')
C     +    (CLN(CM(I),6,3),I=1,NV)
C        RETURN
C      END IF
CC Compare current communalities to initial ones
C      B = 0.
C      DO 30 I = 1,NV
C30     B = MAX(B,ABS(A1(I,0)-CM(I)))
C      IF(JOB==0 .AND. B<.01) RETURN
C      DO 40 K = 6,21,15
C       WRITE(K,'(/" At ",A,", COMCHK reports maximum communa",
C     +  "lity shift ",A6)') WORD, CLN(B,6,3)
C       IF(K==6 .AND. JOB<0) RETURN
C       WRITE(K,'(/" The solution at ",A," is")') WORD
C       CALL SHOW(A1(1,1),C1,A1,3,K)
C40     WRITE(K,'(/" The correct communalities are"/10A6)')
C     +  (CLN(CM(I),6,3),I=1,NV)
CC Check C1 for symmetry
C      B = 0.
C      DO 50 J = 2,NF
C       DO 50 I = 1,J-2
C50      B = MAX(B,ABS(C1(I,J)-C1(J,I)))
C      IF(B<.01) RETURN
C      WRITE(6,'(/" Also, C1 is no longer symmetric")')
C      WRITE(21,'(/" Also, C1 is asymmetric. Full matrix is")')
C      DO 55 I = 1,NF
C55     WRITE(21,'(20A6)') (CLN(C1(I,J),6,3),J=1,NF)
C      PAUSE
C      RETURN
C      END


