C              Program HYDATA.  (Source code: FORTRAN-90)
C
C                  Last revised: 3 July 2003

C This receives an externally prepared raw-data file; checks it for blank
C lines, blank data cells, and readability under the format stipulated; and
C at user option transforms the data into HYDATA-standard form.

C **** This extension of HYDATA allows production of bootstrapped covariance
C      files from the input datafile and, alternatively, looks for quadratic
C      relations among the data variables.

      LOGICAL QH, QHH, QY, QL, QCV, QTR, STAR, MATCH  ! QTR=T says to transcribe data
      CHARACTER(12) F1, F2, F3, F4, CF, CHF*2, CH1*1
C       F1 is dat.xxx; F2 is dat.Dj; F3 is dat.LOG; F4 is dat.NAM
      CHARACTER(80) FMT, FMA, FMB, FMD, FMN, FM1, CLEAR, WA*130, WB*130
      CHARACTER(8) CLN, CH8, CHB,  Z2*2, CBAD(80)*10, WORD*220
      CHARACTER C11,C12,C21,C22, BAR,LIN
      INTEGER NBAD(3,0:80), DIGT, WD   ! DIGT is a function; WD is fieldwidth
      REAL(8) TST1, TST2, DD
C       IDEN2(1,J) is the number of letters starting the Jth variable's name;
C       IDEN2(2,J) is the number finishing the name (0 if none)
C       Per-variable lists: NUM, usable records. ND, number of decimals.
C       HI/LOW/AV/SD, high/low/mean/SD. SX gets rescaling multiplier.
      CHARACTER,ALLOCATABLE :: CHS(:)*10, IDENT(:)*8, NAME(:)*12
      INTEGER,ALLOCATABLE :: BNRY(:), IDEN2(:,:), KBD(:), KX(:), LST(:),
     +        LS2(:), MW(:), ND(:), NDD(:), NUM(:), ORD(:), ORD1(:)
      REAL,ALLOCATABLE :: LOW(:), HI(:), AV(:), SX(:), XX(:)
      REAL(8),ALLOCATABLE :: SD(:)
C         Arrays that will be passed as COV arguments: CHS, IDENT, XX
      COMMON F1, FMA, FMB, CLEAR, BLANK, LL, LF1, LM, LOM, LSHO, LW
      COMMON /BL1/ CBAD, NBAD
      COMMON /BL2/ LONG
      COMMON /CF/ CF
      DATA QCV,QTR/2*.TRUE./, STAR,QH,QHH/3*.FALSE./, NK,MXID/2*0/
      DATA C11,C12,C21,C22,BAR,LIN/'','','','','',''/, DEV/5./
      DATA NY,ID,MIS,MTH,NDUP/1,4*0/, CHB/'-99     '/  ! From head
      LSHO = 500
      CLEAR = ' '
      NFIX = 0; MIS = 1; NSX = 0
      FMT = '*'//CLEAR; FMB = FMT
      CBAD(1) = CLEAR  ! Bad content types are listed in CBAD
      NBAD(1,1) = 3    ! Fieldwidths go into NBAD(1,j)
      NBAD(1,0) = 1    ! Last index of Bad goes into NBAD(1,0)
      NBAD(2,1) = 0    ! Count freq of bad fields in NBAD(2,j)
      NBAD(2,0) = 0    ! Total count goes into NBAD(2,0)
      NBAD(3,1) = 0    ! Rec in which bad field last occurred
      CALL SYSTEM('cls')
      WRITE(6,'(1X,77A)') C11, (LIN,I=1,75), C12
      WRITE(6,'(1X,A,2X,"This program first checks the readibility o",
     +  "f a received ASCII datafile   ",A/1X,A,2X,"for your choice ",
     +  "of READ method and reports a diagnosis of the problem",4X,A/
     +  1X,A,2X,"if this crashes.  If the READ is successful, the pro",
     +  "gram next reports    ",A/1X,A,2X,"considerable summary infor",
     +  "mation including each data variable''s range,   ",A/1X,A,2X,
     +  "mean, SD, skew, and kurtosis in an ASCII file named <base>.L",
     +  "OG. Finally, ",A/1X,A,2X,"you are invited to select some or ",
     +  "all of the variables for computation   ",A/1X,A,2X,"of corre",
     +  "lations to be filed for later factor extraction by program M",
     +  "ODA. ",A/1X,A,2X,"You may also elect to permute your variabl",
     +  "es into alphanumeric name",6X,A/1X,A,2X,"order.  The basic ",
     +  "statistics for these selected variables, including",5X,A/1X,A,
     +  2X,"their correlations and a missing-data appraisal, are repo",
     +  "rted in ASCII   ",A/1X,A,2X,"file <base>i.SEE where i is an ",
     +  "index integer.",28X,A)') (BAR,I=1,22)
      WRITE(6,'(1X,A,75X,A)') BAR, BAR
      WRITE(6,'(1X,A,2X,"You will also be invited to transcribe your",
     +  " input data into a datafile   ",A/1X,A,2X,"<base>.Dj which ",
     +  "is standardized for score manipulations by programs",6X,A/1X,
     +  A,2X,"FIXDATA, RESCORE, MERGE, and SELECT in the Hyball pack",
     +  "age.  Information",2X,A/1X,A,2X,"about this transcription ",
     +  "will be appended to <base>.LOG.",17X,A)') (BAR,I=1,8)
      WRITE(6,'(1X,77A)') C21, (LIN,I=1,75), C22
C      CALL WAIT(1)
      WRITE(6,'(/"  If your datafile has an extension that you rem",
     +  "ember, enter it. Otherwise,"/"  hit RETURN for a",
     +  " broader screen listing of input possibilities."/)')
      READ(5,'(A)') WORD(:10); IF(ICHAR(WORD(:1))<65) WORD(:1) = ' '
      CALL LAST(N,WORD,10)
      ALLOCATE ( NAME(100), LST(100) )
5     IF(N>0) THEN
        WRITE(6,'(" Listing available files with extension ",A,":")')
     +    WORD(:N)
        CALL LOOK(1,'*.'//WORD(:N),NAME,100,N)
        IF(N==0) WRITE(6,'(" No files here with that extension.  ",
     +    "Will try a broader sweep.")')
        IF(N==0) GOTO 5
      ELSE
        WRITE(6,'(/" Unless your rawdata file''s name has a forbid",
     +    "den form, it should be on list"/)')
        CALL LOOK(1,'*.*',NAME,100,N)
      END IF
      IF(N==0) THEN
        WRITE(6,'(/" No acceptably named raw-data files are present.",
     +    "  Fix the problem and try again.")')
        STOP
      END IF
      OPEN(2,STATUS='SCRATCH')
      NL = 0
      OUTER: DO J = 1,N    ! N is length of LOOK list
        DO I = 2,9
          IF(NAME(J)(I:I+1)=='.D'.AND.DIGT(NAME(J)(I+2:I+2))==1.OR.
     +      NAME(J)(I:I+3)=='.RAW'.OR.NAME(J)(I-1:I+1)=='DAT') THEN
              NL = NL+1
              LST(NL) = J
              CYCLE OUTER
          END IF
        END DO
      ENDDO OUTER
      IF(NL>0.AND.N>12) WRITE(6,'(/" It is probably one of",
     +  20(/4(I5,". ",A,:)))') (LST(I),NAME(LST(I)),I=1,NL)
      NN = 1
      IF(NL>0) NN = LST(NL)
7     F1 = NAME(NN)
      CALL CAP(F1,12)
      CALL LAST(LF1,F1,12)
9     WRITE(6,'(/4X,"The datafile now picked for HYDATA processing ",
     +  "is ",A,".  Hit RETURN"/4X,"if OK, or enter the index of ",
     +  "another raw-data file on this list."/)') F1(:LF1)
      CALL SCANB(J,1,'I',5,CH8,L,WA,WB)
      IF(J<0) GOTO 9
      IF(J>0) THEN
        READ(2,*) NN
        GOTO 7
      END IF
      DEALLOCATE ( NAME, LST )
      OPEN(3,FILE=F1)
      READ(3,'(A)') WORD(:21)
      CALL FNDLOM(3,LOM)
      READ(3,'(A)') F3
      DO I = 1,12
        IF(F3(I:I)==':') ID = 1
      END DO
      F2 = F1
      CALL NAME1(F2,F3,6,LFF) ! F2 becomes <base>.Di, F3(:LFF) becomes <base>.LOG
      CALL LAST(LF2,F2,12)
      F4 = F1(:LFF-3)//'NAM'
      LF4 = LFF
      IF(WORD(2:7)=='HYDATA') THEN
        QH = .TRUE.
        MTH = 1   ! Tells COVS that input is Hydata-standard
        REWIND 3
C       Get NY from Hydata-standard file
        READ(3,'(A)') WORD    !!! NOTE: SCAN call L-justifies WORD
        CALL SCANB(J,4,'IIIR',-1,WORD(39:),L,WA,WB)
        IF(J<4) THEN
          CALL LAST(LL,WORD,130)
          WRITE(6,'(" ERROR: Header of ",A," is"/1X,A)') F1(:LF1),
     +       WORD(:LL)
          STOP
        END IF
        READ(2,*) NY, NREC, MXID, DEV; WORD(:12) = WORD(26:37) ! WORD(:12) not needed?
        NYE = NY+50   ! Extra space in namelist needed for >-shifts
        ALLOCATE ( CHS(0:NY+1), IDENT(NYE), IDEN2(2,NYE), KBD(0:NY),
     +             MW(NY), ND(NY), ORD(NY) )
        ORD = (/(I,I=1,NY)/)
        DO I = 1,NY   ! In case names are missing
          IDENT(I) = '['//CF(:JF(I))//']     '
        END DO
        READ(3,'(A)') WORD

C Improved filehead read, but write will need revision of all Hydata-supp programs
        K = 25
11      K = K+1; IF(WORD(K:K)/=':') GOTO 11
        CALL SCANB(J,2,'II',-1,WORD(K:),L,WA,WB)  ! #######
cc        CALL SCANB(J,2,'II',-1,WORD(41:),L,WA,WB)      ! Otherw Need this
        READ(2,*)  NFIX, MIS
        READ(3,*,END=13,ERR=13) (IDENT(I),I=1,NY)
13      CALL GETLM(LM,NY,ORD,IDENT)
        J = JF(MXID); K = JF(J)
        READ(3,'(A)') WORD
CCC     Code for reading rescaling powers from head of D-file
ccc      IF(NSX>0) WRITE(7,'("Rescale",8(2X,5I3),20(/8X,8(2X,5I3)))') (KX(I),I=1,NY)
CCC---------------------------^No space ---------------------------------
c       NSX = 0 ! ***** Make sure this is entered somewhere
        IF(WORD(:7)=='Rescale') THEN
          ALLOCATE ( KX(NY) )
          BACKSPACE 3
          READ(3,'(20(8X,8(2X,5I3):/))') (KX(I),I=1,NY)
          DO I = 1,NY; IF(KX(I)/=0) NSX = NSX+1; END DO
          READ(3,'(A)') WORD
        END IF
CCC---------------------------------------------------------------------
        BACKSPACE 3; WD = 0   ! WD is declared to be integer
        WORD(:1) = 'X'; CALL LAST(LL,WORD,LEN(WORD)) ! Start of WORD mustn't be blank
        LL = LL-J-1  ! Length of scorelist in line
        L3 = 3*MIN(50,NY); L4 = 4*MIN(45,NY); L5 = 5*MIN(40,NY)
        IF(L3==LL) WD = 3; IF(L4==LL) WD = 4; IF(L5==LL) WD = 5
        IF(WD==0 .OR. WD>5) THEN  ! Shd never be needed if input is genuinely Hydata-standard
          WRITE(6,'(/" HYDATA has been unable to identify D-file ",
     +      "fieldwidth.  Go fix the problem.")'); STOP
        END IF
        J = JF(MXID); K = JF(J)
        FMT = 'I'//CF(:K)//',1X,50I3,20(:/'//CF(:K)//'X,1X,50I3)    '
        IF(WD==4) FMT = 'I'//CF(:K)//',1X,45I4,20(:/'//CF(:K)//
     +                  'X,1X,45I4)    '
        IF(WD==5) FMT = 'I'//CF(:K)//',1X,40I5,20(:/'//CF(:K)//
     +                  'X,1X,40I5)    '
        FMA = FMT; FMB = FMT
        CHB = '-99     '; BLANK = -99.
        IF(WD==4) THEN; CHB = '-999    '; BLANK = -999. ; END IF
        IF(WD==5) THEN; CHB = '-9999   '; BLANK = -9999. ; END IF
        LL = 29;  ND = 0; MW = 3
        CALL LAST(LF1,F1,12)
        WRITE(6,'(/" Since ",A," has been HYDATA-standardized, it nee",
     +    "ds no pre-processing."/" Enter anything if you want a modi",
     +    "fied copy of it with revised names of"/" variables or decr",
     +    "eased extremity of acceptable outliers.  Otherwise, hit"/1X,
     +    "RETURN to begin computation of the covariances.")') F1(:LF1)
        READ(5,'(A)') CH1
        IF(CH1==' ') THEN
          QHH = .TRUE. ! Flag to start COVS after format check
          DEALLOCATE ( ORD )
          GOTO 35
        END IF
        WRITE(6,'(/"   First, review your variables and decide if ",
     +    "any should be renamed.")')
        CALL SETNAM(NY,NK,2,LM,IDENT,IDEN2,ORD,' ',IER)
        NY1 = NY+ID
        IF(IER>0) GOTO 45
        GOTO 35
C        GOTO 50  ! Replace GOTO 35 by this if READ check proves pointless
      END IF
C
      INQUIRE(FILE='LASTFORM',EXIST=QL)
      IF(.NOT.QL) GOTO 17
      OPEN(4,FILE='LASTFORM'); KF = 4
      READ(4,*,ERR=17) LOM, (WA,I=1,7)  ! Get filename listed 8th on line
      QTR = .FALSE.; IF(WA(:LF1)==F1(:LF1)) QTR = .TRUE.    ! temp use of QTR
      IF(.NOT.QTR) THEN          ! flags match of LASTFORM(.nn) to input data
        WB(:12) = 'LASTFORM.'//F1(:3)
        INQUIRE(FILE=WB(:12),EXIST=QL)
        IF(QL) THEN
          OPEN(9,FILE=WB(:12))
          READ(9,*,ERR=17) LOM, (WA,I=1,7)
          IF(WB(:LF1)==F1(:LF1)) QTR = .TRUE.
          IF(QTR) THEN ! Use secondary LASTFORM
             CLOSE(4); KF=9; WA(:12) = WB(:12)
          END IF
        END IF
        QL = .TRUE.  ! Restore T for primary LASTFORM
      END IF
      CALL LAST(LFL,WA,12)
      READ(KF,*,END=17) NY; NYE = NY+50
      ALLOCATE ( CHS(0:NY+1), IDENT(NYE), IDEN2(2,NYE), ORD(NY),
     +             KBD(0:NY), ND(NY), MW(NY) )
      ORD = (/(I,I=1,NY)/)
      READ(KF,*,END=16) ID
      READ(KF,'(A)',END=16) FMB
      READ(KF,'(A)',END=16) CHB ! Sun UNIX reads unquoted * as a repetition flag
      READ(KF,*,END=16,ERR=16) (IDENT(I),I=1,NY)
      CLOSE(KF); GOTO 19
16    DEALLOCATE ( IDEN2, ORD )
17    QL = .FALSE.

19    CALL SYSTEM('cls')
      IF(.NOT.QL) CALL FNDLOM(3,LOM)
      WRITE(6,'(1X,78A)') C11, (LIN,I=1,76), C12
      WRITE(6,'(1X,A,"  To read this datafile, HYDATA will need to",
     +  " be advised",21X,A)')  BAR, BAR
      WRITE(6,'(1X,A,76X,A)') BAR, BAR
      WRITE(6,'(1X,A,"  1. Whether it has correctly diagnosed the numb",
     +  "er of text lines preceding  ",A/1X,A,7X,"the first score reco",
     +  "rd;",46X,A/1X,A,2X,"2. Whether each score record begins with ",
     +  "a numeric identification index;",2X,A/1X,A,2X,"3. The number ",
     +  "of scores, NOT including ID No. if present, to be read",6X,A/
     +  1X,A,7X,"from each record;",52X,A/1X,A,"  4. Whether scores in",
     +  " each record are separated by commas and/or blanks;   ",A/1X,A,
     +  7X,"and if not, the FORTRAN format required to read them;",16X,
     +  A/1X,A,"  5. What number, if any, stands for missing data in ",
     +  "this file.  (Any entry ",A/1X,A,7X,"that is not numeric will",
     +  " be treated automatically as missing.)",7X,A)') (BAR,I=1,18)
      WRITE(6,'(1X,A,76X,A)') BAR, BAR
      WRITE(6,'(1X,A,"  Note: ""Record"" here means the total string",
     +  " of input entries for a single  ",A/1X,A,8X,"subject (""cas",
     +  "e""). This may comprise several consecutive file lines. ",A)')
     +  (BAR,I=1,4)
      WRITE(6,'(1X,78A)') C21, (LIN,I=1,76), C22
      IF(QL) THEN
        WRITE(6,'(" Defaults are taken from a previous run on dat",
     +    "afile ",A,", whose name")') WA(:LFL)
        IF(QTR) WRITE(6,'(" matches the present upload so these def",
     +    "aults are probably correct.")')
        IF(.NOT.QTR) THEN
          WRITE(6,'(" differs from the present upload so those settin",
     +      "gs are probably not now correct."/" Hitting RETURN will ",
     +      "continue with these defaults, but you may want to abort"/
     +      " by entering CTRL-C and make sure you have correct repl",
     +      "acements for them in hand.")')
          READ(5,'()')
        END IF
      END IF
      WRITE(6,'(/"  To refresh your memory of this datafile''s lay",
     +  "out, you will be shown a block of"/"  its lines starting ",
     +  "a little before the diagnosed first score record.  Lines"/
     +  "  longer than screen width are truncated with a numerical",
     +  " report of their length.")')
      CALL RECSIZ(LONG,10,LOM,3)  ! Determine how long a read line is needed
      CALL WAIT(1)
20    CALL SHOREC(3,LOM,3,16)
      WRITE(6,'(/" If >>>> points to the start of the first score rec",
     +  "ord, hit RETURN.  Otherwise,"/" enter the number at start of",
     +  " the line JUST ABOVE the 1st score record.  If"/" the 1st da",
     +  "ta line is not visible, enter a guess at how many lines pre",
     +  "cede it."/)')
      CALL SCANB(J,1,'I',5,CH8,L,WA,WB)
      IF(J==0) GOTO 22
      IF(J>0) READ(2,*) LOM
      GOTO 20
C
C Set ID = 1 if records start with ID No.
22    IF(ID==1) WRITE(6,'(/" If the first entry in each score rec",
     +  "ord is a numeric ID index, hit RETURN."/" Otherwise, enter ",
     +  "anything to read all entries as data scores.")')
      IF(ID==0) WRITE(6,'(/" If the score records do NOT begin ",
     +  "with numeric ID indices, hit RETURN."/" Otherwise, enter ",
     +  "anything to treat each record''s first entry as the"/
     +  " subject''s ID.")')
      READ(5,'(A)') CH1
      IF(CH1/=' ') THEN
        ID = 1-ID
        GOTO 22
      END IF
C
23    IF(ID==1) WRITE(6,'(/" The number of variables, NOT counting",
     +  " ID, to be read from file ",A/" is now set at ",A,". Hit ",
     +  "RETURN if OK; otherwise, enter correct number."/)') F1,
     +  CF(:JF(NY))
      IF(ID==0) WRITE(6,'(/" The number of variables to be read fr",
     +  "om file ",A," is now set at ",A,"."/" Hit RETURN if OK, oth",
     +  "erwise, enter correct number."/)') F1(:LF1), CF(:JF(NY))
      CALL SCANB(J,1,'I',5,CH8,L,WA,WB)
      IF(J==0 .AND. NY>1) GOTO 25
      IF(J>0) READ(2,*) NY          ! <<< Stipulate NY from keyboard
      IF(J==0 .AND. NY<=1) WRITE(6,'(" Just",I2," variable?  You",
     +  " gotta be kidding.  Try again.")') NY
      GOTO 23
25    NYE = NY+50
C
C Allocations conditional on input:
C    Case 1, Rawdata with LASTFORM:    (QH=F)
C    Case 2, Rawdata without LASTFORM  (QH=F)
C    Case 3, Hydata-standard but treated as rawdata (QH=T, QHH=F)
C    Case 4, Hydata-standard, immediate COV computation (QHH=T)
C >>> At this point CHS,IDENT,IDEN2,ORD,ND,MW are all allocated in Case 1,
C        but none otherwise

      IF(ALLOCATED(CHS) ) DEALLOCATE ( CHS )
      IF(ALLOCATED(IDENT)) DEALLOCATE ( IDENT )
      IF(ALLOCATED(IDEN2)) DEALLOCATE ( IDEN2 )
      IF(ALLOCATED(ORD)) DEALLOCATE ( ORD )
      IF(ALLOCATED(ND)) DEALLOCATE ( ND )
      IF(ALLOCATED(MW)) DEALLOCATE ( MW )
      ALLOCATE ( CHS(0:NY+1), IDENT(NYE), IDEN2(2,NYE), ORD(NY),
     +           ND(NY), MW(NY) )
      DO I = 1,NY   ! In case names are missing
        ORD(I) = I
        IDENT(I) = '['//CF(:JF(I))//']     '
      END DO
C Set treatment of missing data
      WRITE(6,'(/" Enter the number SUB that substitutes for missing",
     +  " scores in file"/1X,A,".  If not a number, treat this as un",
     +  "known.  (No problem.)")') F1(:LF1)
27    CALL LAST(L,CHB,8)
      IF(CHB(:2)=='.0') CHB(:2) = '0.'
      IF(L>2. AND. CHB(L-1:L)=='.0') L = L-1
      WRITE(6,'(" SUB is now ",A,"  Hit RETURN if OK, or enter the co",
     +  "rrect value."/" If none or unknown, enter any letter."/)')
     +   CHB(:L)
      CALL SCANB(J,1,'R',5,CH8,L,WA,WB)
      IF(J==0) GOTO 30
      IF(J<0) BLANK = -9999.
      IF(J>0) READ(2,*) BLANK
      CHB = CLN(BLANK,8,1)
      IF(J>0) GOTO 27
C
C Set READ format; convert I-format to F-format for user convenience, and
C warn if the first entry is not skipped when IDs are known to be present.
30    WA(:12) = ' '; IF(QTR) WA(:12) = F1
      CALL SETFMT(FMT,LL,WA(:12),FMB,NY,ID,C11,C12,C21,C22,BAR,LIN)   ! LL is length of FMT
      FMB = FMT
      INQUIRE(FILE=F4,EXIST=QY)
      IF(QY) THEN
        OPEN(4,FILE=F4)  ! NAM-file; must start with namelist
        READ(4,*,ERR=35) (IDENT(I),I=1,NY)
        CLOSE(4)
      END IF
      IF(FMT(1:1)=='*') GOTO 35
      K = 0
32    K = K+1
      IF(FMT(K:K)=='I') THEN
        IF(DIGT(FMT(K+2:K+2))==1) THEN
          WRITE(6,'(/" Fields of width 10 or more can only be read in",
     +      " F-format. Please adjust your"/" READ format accordingly",
     +      ".  (Position of decimal in that shouldn''t matter.)")')
          CALL WAIT(1)
          GOTO 30
        END IF
        DO J = LL,K+2,-1
          FMT(J+2:J+2) = FMT(J:J)
        END DO
        FMT(K+2:K+3) = '.0'
        FMT(K:K) = 'F'
        LL = LL+2
      END IF
      IF(K<LL) GOTO 32
C       I-format has been converted to F-format for user convenience.
      IF(ID==0) GOTO 35
      IF(FMT(2:2)/='X' .AND. FMT(3:3)/='X') GOTO 35
      WRITE(6,'(/" WARNING: Your READ format appears to skip over th",
     +  "e ID numbers. IF you are sure"/" you want this, hit RETURN."
     +  " Otherwise, enter anything to re-specify your format.")')
      READ(5,'(A)') CH1
      IF(CH1==' ') GOTO 35
      FMT = FMB
      GOTO 30
C
C Check adequacy of format specification.  ! **** When CH, none of this down to 40 seems needed
35    REWIND 3
      NY1 = NY+ID
      WORD = FMT
      FMT = '('//WORD(:LL)//')'//' '
      IF(FMT(2:2)=='*') STAR = .TRUE.
      IF(FMT(2:2)=='*') GOTO 40
      FMA = FMT
      LW = 1  ! Find maximum fieldwidth in FMT
      LREC = 1 ! Find number of lines per record recognized by FMT
      DO I = 2,LL+1
        IF(FMA(I:I)=='/') LREC = LREC+1
        IF(FMA(I:I)=='I' .OR. FMA(I:I)=='F') THEN
          FMA(I:I) = 'A'
          KD = 2
          LW1 = ICHAR(FMT(I+1:I+1))-48
          IF(DIGT(FMA(I+2:I+2))==1) THEN
            KD = 3
            LW1 = LW1*10 + ICHAR(FMT(I+2:I+2))-48
          END IF
          LW = MAX(LW,LW1)
          IF(FMT(I:I)=='F') FMA(I+KD:I+KD+1) = '  '
        END IF
      END DO
      IF(QHH) GOTO 501   ! HYDATA-standard input usually exits here
      IF(QH) GOTO 50       ! Go to 50 if input is hydata-standard
40    CALL POSN(3,LOM,IER)
      READ(3,'(A)') WORD
      BACKSPACE 3
      IF(LONG>1) CALL RECSIZ(LONG,10,LOM,3)  ! Determine how long a read line is needed
      WRITE(6,'(/" The first data record after line ",A," in file ",A,
     +  " begins"/1X, A79// " while the ",A," fields picked from this",
     +  " record by your specified format contain")') CF(:JF(LOM)),
     +  F1(:LF1), WORD, CF(:JF(NY1))
      IF(STAR) CALL GETREC(NY1,3,CHS(1),'bad'//CLEAR(:7),LW,0,LREC)
C        To replace 'bad' with 'xyz', must send 'xyz     ' with content on left
      IF(.NOT.STAR) THEN
        READ(3,FMA) (CHS(I),I=1,NY1)
        LW = 3
        DO I = 1,NY1
         CALL LAST(L,CHS(I),10)
         LW = MAX(LW,L)
        END DO
      END IF
      J = MIN(8,MAX(3,LW))
      L = 80/(MIN(LW,8)+1)
      CH8(:2) = CHAR(48+L/10)//CHAR(48+MOD(L,10))
      FM1 = '(80('//CH8(:2)//'("|",A),:/))'//CLEAR
      WRITE(6,FM1) (ADJUSTR(CHS(I)(:J)),I=1,NY1)
      IF(LW>8) WRITE(6,'(/" NOTE: Display fields have been cropped",
     +  " to 8-character width.")')
      FM1 = '(" Record",I5," contains unreadable cell [ ",A,"]")' ! *** Where used ???
      IF(.NOT.STAR .AND. CHS(NY1)=='        ') WRITE(6,'(/" WARNING:",
     + " Unless the last entry in Record 2 is blank, you have probably"/
     +  " omitted a line-feed slash needed at your format''s end.")')
      WORD(:5) = ' NOT ' ! pick 5-4*ID
      WRITE(6,'(/" Hit RETURN if these seem correct and if, as you st",
     +  "ipulated, the first"/" entry is",A,"an ID number.  Otherwise",
     +  ", enter anything to re-examine the"/" file layout and revise",
     +  " your instructions how to read it."/)') WORD(:5-4*ID)
      READ(5,'(A)') CH1
      IF(CH1/=' ') GOTO 20
      LV = JF(NY)
      CALL SYSTEM('cls')
      WRITE(6,'(1X,78A)') C11, (LIN,I=1,76), C12
      WRITE(6,'(1X,A,"  Names for these variables, each starting wit",
     +  "h a letter and at most eight  ",A/1X,A,"  characters long, ",
     +  "can be entered and subsequently revised in several ways: ",A/
     +  1X,A,76X,A)') (BAR,I=1,6)
      WRITE(6,'(1X,A,"  1. A file of input specifications named LAST",
     +  "FORM may linger in this",7X,A/1X,A,5X,"subdirectory from a ",
     +  "previous run of HYDATA.  If so, the variables",A,5X,A/1X,A,5X,
     +  "names therein will initialize the current namelist.",20X,A)')
     +  (BAR,I=1,3), '''', (BAR,I=1,3) ! *** Four 's is correct.
      Z2 = '  '; WORD = CLEAR          !     ^ entry has form 'string'
      IF(QY) Z2='>'; IF(QY) WORD(:31)=' NOTE:> flags loaded NAM-file.'
      WRITE(6,'(1X,2A,"2. If this subdirectory contains an ASCII fi",
     +  "le named ",A,", starting ",2A/1X,A,5X,"with a string of ",A,
     +  " or more names separated by blanks and/or commas,",2A/1X,A,5X,
     +  "the first ",A," of these (truncated if necessary to eight ch",
     +  "aracters)",2A/1X,A,5X,"have already been loaded.  NAM-files ",
     +  "must be prepared manually, with   ",A/1X,A,5X,"the namelist ",
     +  "prior to any documentation.",2A)') BAR, Z2, F4(:LF4),
     +  CLEAR(:10-LF4), BAR, BAR, CF(:JF(NY)), CLEAR(:5-LV), BAR, BAR,
     +  CF(:JF(NY)), CLEAR(:7-LV), (BAR,I=1,4), WORD(:31), BAR
      WRITE(6,'(1X,A,"  3. If the present datafile contains variable ",
     +  "names in a string parsed by  ",A/1X,A,5X,"blanks and/or comm",
     +  "as, you can load these (truncated if necessary) by",3X,A/1X,A,
     +  5X,"entering the number of file lines preceding this namelist.",
     +  13X,A/1X,A,"  4. If no previously prepared list of variable n",
     +  "ames is available, you can ",A/1X,A,5X,"enter these from keyb"
     +  "oard in a choice of ways that will be described.  ",A/1X,A,5X,
     +  "In all cases, you will have opportunity to study and revise ",
     +  "whatever   ",A/1X,A,5X,"namelist is first imported or creat",
     +  "ed.",33X,A)') (BAR,I=1,14)
      WRITE(6,'(1X,78A)') C21, (LIN,I=1,76), C22
      IF(LOM<=0) CALL WAIT(1)
      IF(LOM<=0) GOTO 47
42    IF(.NOT.QY) WRITE(6,'(/3X,"If the head of this datafile inclu",
     +  "des a list of variable names you want"/3X,"loaded, enter t",
     +  "he number of file lines preceding them.  (Guess 0 if you "/
     +  3X,"are unsure.)  Otherwise, hit RETURN for additional in",
     +  "structions."/)')
      IF(QY) WRITE(6,'(/3X,"If the head of this datafile lists vari",
     +  "able names that you want to replace"/3X,"the NAM-list alre",
     +  "ady loaded, enter the number of preceding file-header"/3X,
     +  "lines.  (Guess 0 if you are unsure.)  Otherwise, hit RETUR",
     +  "N to continue."/)')
      CALL SCANB(J,1,'I',5,CH8,L,WA,WB)
      IF(J==0) GOTO 47
      IF(J<0) GOTO 42
      READ(2,*) L
44    CALL SHOREC(3,L,3,10)
45    WRITE(6,'(/" If >>>> points to the start of the namelist, hit",
     +  " RETURN.  Otherwise, enter the"/" count of lines preceding",
     +  " this, or 0 if the file begins with the namelist."/" (To ",
     +  "abort reading names from this file, enter any letter.)"/)')
      CALL SCANB(J,1,'I',5,CH8,L,WA,WB)
      IF(J>0) THEN
        READ(2,*) L
        GOTO 44
      ELSE IF(J==0) THEN
        CALL POSN(3,L,IER)
        IF(IER>0) L = 0
        IF(IER>0) GOTO 44
        READ(3,*) (IDENT(I),I=1,NY)
      END IF
47    CALL SYSTEM('cls')
      WRITE(6,'(/"   Here are your options for creating or revising",
     +  " the names of your variables.")')
      CALL SETNAM(NY,NK,LOM,LM,IDENT,IDEN2,ORD,' ',IER)   ! IDEN2 is output
      IF(IER>0) GOTO 45
C
C Scan data records for blank data cells; also find Min, Max, Average,
C and SD of each variable, and maximum ID No. if IDs are declared present.
C Alse test claim that IDs are present/absent.
50    CALL SYSTEM('cls')    ! Hydata-standard input continues here
C  Both input routes converge on Label 50 and are ready for remaining NY allocations
      ALLOCATE ( BNRY(NY), NDD(NY), NUM(NY), ORD1(NY), KX(NY) )
      ALLOCATE ( LOW(NY), HI(NY), AV(NY), SD(NY), SX(NY), XX(NY) )
CC      ALLOCATE ( AAV(NY), SSD(NY) )  ! Maybe install later
C      DEALLOCATE ( BNRY, NDD, NUM, ORD1, LOW, HI, AV, SX, XX, SD )
      TST1 = 0.; TST2 = 0.; KX = 0
      READ(CHB,*) BLANK
      NUM = 0; LOW = 999999.; HI = -9999.
      ND = 0; AV = 0.; SD = 0.D0
CC      AAV = 0. ; SSD = 0. ! Maybe install later
      CALL POSN(3,LOM,IER)  ! Initial Read check necessitates repositioning
      OPEN(8,FILE=F3)
      CALL FNDEND(8,0)
C       End of .LOG file has been found, ready for appending.
      WRITE(8,'("%%"/40("* ")/" Report on HYDATA scan of data",
     +  "file ",A)') F1
      CALL DAY(8)
      N = 130/(6+LM)
      WORD(:2) = CHAR(48+N/10)//CHAR(48+MOD(N,10))
      FMN = '(90('//WORD(:2)//'(I4,": ",A),:/))'//CLEAR
      WRITE(8,'(/" The input variables are named")')
      WRITE(8,FMN) (I,IDENT(I)(:LM),I=1,NY)
      IF(.NOT.QH) THEN
        WRITE(6,'(/5X,"Processing of file ",A," is ready to commence.",
     +    "  It will first"/5X,"be scanned for readability by the for",
     +    "mat you have approved, after"/5X,"which it will compute th",
     +    "e variables'' covariances and/or write a"/5X,"HYDATA-stand",
     +    "ard transcription of these data as you desire.")') F1(:LF1)
        WORD(:5) = ' NOT '    ! Pick 5-4*ID
        L = JF(NY1)
        CH8(:L) = CLN(NY1*1.,L,11)
        CALL LAST(LL,FMB,80)
        WRITE(8,'(/" Each record after line ",A," has been scanned ",
     +    "for ",A," terms,"A,"including IDs, under format (",A,").")')
     +    CF(:JF(LOM)), CF(:JF(NY1)), WORD(:5-4*ID), FMB(:LL)
      END IF
      READ(CHB,*) BLANK  ! Also needed for later data transcription
      IF(MATCH(BLANK,-9999.)) WRITE(8,'(/" No missing-datum surrogate",
     +  " has been declared.")')
      IF(.NOT.QH .AND. .NOT.MATCH(BLANK,-9999.)) THEN
        IF(MATCH(BLANK,ANINT(BLANK))) CHB = CLN(BLANK,8,11)
        CALL LAST(L,CHB,8)
        WRITE(8,'(/" Missing-datum surrogate declared: ",A)') CHB(:L)
      END IF
      NQ = 1   ! Updating this will sample records
      MXF = 0; QTR = .TRUE.
      KREC = 4*NY+4  ! Number of bytes needed (plus 4 wiggle room) for buffer record
      WRITE(6,'(/5X,"To generate a HYDATA-standard transcription of t",
     +  "his datafile while"/5X,"retaining the option to compute cova",
     +  "riances from the original data,"/5X,"hit RETURN.  Otherwise,",
     +  " enter "" Q "" to Quit afer the READ test, or"/5X,"anything ",
     +  "else to compute covariances but waive data transcription."/)')
      CALL SCANB(J,0,'B',5,CH8,L,WA,WB)
      IF(CH8(:1)=='Q' .OR. CH8(:1)=='q') QCV = .FALSE.
      IF(J/=0) QTR = .FALSE.
      WA(:12) = F3  ! Need if D-file changes basename
      IF(QTR) THEN
        OPEN(19,STATUS='SCRATCH',FORM='UNFORMATTED',
     +      ACCESS='DIRECT',RECL=KREC)
56      WRITE(6,'(6X,"If you want the transcription of datafile ",A,
     +    " to have"/6X,"basename ",A,", hit RETURN.  Otherwise, ent",
     +    "er another"/6X,"choice of transcription basename not over",
     +    " 6 characters.")') F1(:LF1), F2(:LFF-4)
        IF(F1/=F2 .AND. F2(LFF-2:LFF-1)/='D1') WRITE(6,'(6X,"WARNIN",
     +    "G: Other D-files with basename ",A," already exist in th",
     +    "is"/6X,"subdirectory.  Unless this file is to be merged ",
     +    "with others"/6X,"in that series, you are advised to choo",
     +    "se another basename.")') F2(:LFF-4)
        WRITE(6,'()')
        READ(5,'(A)') WORD(:12)
        IF(WORD(:1)/=' ') THEN            ! F2 now changed
          F2 = WORD(:12); CALL CAP(F2,12); CALL NAME1(F2,F3,6,LFF)
          CALL LAST(LF2,F2,12); GOTO 56;  ! Done^ here to see if warning needed
        END IF
      END IF
C
C Read each record under appropriate format
      NR = 0; JBAD = 0; MIS = 0; KBD = 0
      NBAD(1,1) = LW           ! ^ Dist over records of bad-score count
      CALL POSN(3,LOM,IER)
      OPEN(15,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(6,'(/" Datafile inspection is underway")')
59    CALL RECOVR(STAR,FMA,NY,ID,CHS,CHB,LW,NR+1,WORD,JMP)  ! Read next record
      IF(JMP==0) GOTO 80  ! JMP=0 marks end of file
      NR = NR+1
      IF(MOD(NR,LSHO)==0) WRITE(6,'(6X,"Examining Record ",A)')
     +  CF(:JF(NR))
      MW = 3  ! Initialize full array
      NRR = NR; MJS = MIS
      ILOOP: DO I = 1,NY
        READ(CHS(I),*,ERR=67,END=67) F   ! Reading CHS(I) as internal file
        XX(I) = F
        IF(MATCH(F,BLANK)) MIS = MIS+1   ! Increments on blank
        IF(MATCH(F,BLANK)) CYCLE ILOOP
        NUM(I) = NUM(I)+1
        LOW(I) = MIN(LOW(I),F)
        HI(I) = MAX(HI(I),F)
        AV(I) = AV(I) + F
        SD(I) = SD(I) + F*F
        IF(NR/=NQ) CYCLE ILOOP
C     Find number ND(I) of significant decimals in field for scattered
C     records and largest MW(I) fieldwidth needed to hold number.
        CALL LAST(L,CHS(I),10)
        MW(I) = L
        MXF = MIN(8,MAX(5,MXF,1+MW(I))) ! Largest fieldwidth needed for full display
        K = 1
64      IF(CHS(I)(K:K)/='.' .AND. K<L) THEN
          K = K+1
          GOTO 64
        END IF
        ND(I) = MAX(ND(I),L-K)  ! L-K is number of decimals
        CYCLE ILOOP ! ^ Recognizes that recs may not all have same number of decimals
67      XX(I) = BLANK
        CALL BADLST(CHS(I),NR,LW)
        MIS = MIS+1   ! increments on unreadable field
      ENDDO ILOOP
      M = MIS-MJS
      KBD(M) = KBD(M)+1  ! Counting records with M bad scores
      IF(NR>=NQ) NQ = NR+1
      IF(NR>50 .AND. MOD(NQ,2)==1) NQ = (NQ-1)*2  ! Sample in pairs
C       NQ samples records in pairs at increasing intervals for decimals check
      IDNUM = NR
      IF(ID==0) GOTO 75
C   Update ID list and keep track of any duplicate IDs
      READ(CHS(0),*,ERR=72,END=72) IDNUM
      GOTO 75
72    IF(JBAD==0) WRITE(8,'()')
      JBAD = JBAD+1
      CALL LAST(L,CHS(0),12)
      IF(L==0) L = 6
      DO I = 6,8,2
        WRITE(8,'(" ID field [",A,"] for record No. ",A," (count po",
     +    "sition) is unreadable")') CHS(0)(:M), CF(:JF(NR))
      END DO
      CHS(0) = '0'//CLEAR
      GOTO 77
75    MXID = MAX(MXID,IDNUM)
      TST1 = TST1 + IDNUM           !  Double precision
      TST2 = TST2 + DBLE(IDNUM)**2  !     "       "
77    CONTINUE
CCC      LST(NR) = IDNUM    ! Still need record count to allocate LST/LS2
CCC      LS2(NR) = NR
      WRITE(15) NR, IDNUM
      IF(QTR) WRITE(19) IDNUM, (XX(I),I=1,NY)   ! Buffer store
      GOTO 59  ! End processing of input record; get next record
80    IF(NR==NRR) GOTO 81
      WRITE(6,'(/" WARNING: This datafile lacks an End-of-File marker",
     +  "; its last line has not been"/" checked.  Fix this by hittin",
     +  "g RETURN to stop, and perform some trivial"/" operation on t",
     +  "he file in a text editor.  Or enter anything to continue.")')
      READ(5,'(A)') CH1
      IF(CH1==' ') STOP
C
81    WRITE(6,'(/4X,"Number of records scanned:",I6)') NR
      WRITE(8,'(/4X,"Number of records scanned:",I6)') NR
      NBNRY = 0   ! Total number of dichotomous variables
      KBNRY = 0   ! Number that are scored 0/1 (binary)
      ALLOCATE ( LST(NR+1), LS2(NR+1) )
      REWIND 15
      DO I = 1,NR
        READ(15) LS2(I), LST(I)  ! LS2 gets list position, LST gets ID
      END DO
      CLOSE(15)
      DO I = 1,NY
        BNRY(I) = -1  ! -1 flags non-dichotomous variables
        IF(NUM(I)==0) THEN
          HI(I) = BLANK
          LOW(I) = BLANK
          AV(I) = BLANK
          SD(I) = BLANK
          BNRY(I) = BLANK
          CYCLE
        END IF
        AV(I) = AV(I)/NUM(I)
        SD(I) = SQRT(MAX(0.D0,SD(I)/NUM(I) - AV(I)*AV(I)))
        DD = (HI(I)-AV(I))*(AV(I)-LOW(I)) - SD(I)*SD(I)
C         DD = 0 if item I is dichotomous, less than 0 otherwise
C         Proof: When item x is scaled to <Hi,Lo> = <1,0>,   Av(1-Av)
C                with equality iff the item is dichotomous.  The theorem
C                follows by rescaling x to have arbitrary Hi and Lo
        IF(DD<.0001) THEN
          BNRY(I) = 0    ! 0,1 flag dichotomy; D-file production uses BNRY
          NBNRY = NBNRY+1  ! Number of dichotomies
          ORD1(NBNRY) = I  !   List "      "
          IF(ABS(HI(I)-1.)+ABS(LOW(I))<=.000001) THEN  ! Moreover, binary
            BNRY(I) = 1   ! Flags 1 for binary may be increased under Label 101
            KBNRY = KBNRY+1
          ELSE
            ORD(NBNRY-KBNRY) = I   ! List of non-binary dichotomies
          END IF
        END IF  ! ORD1 lists dichotomies; ORD, non-binary dichotomies
      END DO  ! BINRY flags each item with 1 => binary, 0 => other dich., -1 => neither
      TST1 = TST1/(NR-JBAD)
      TST2 = DSQRT( MAX(0.D0,TST2/(NR-JBAD) - TST1*TST1) )
C       TST2 is the SD of the alleged IDs
      NW = 130/(1+MXF)  ! Number of fieldwidth MXF entries in line
      CH8 = CHAR(48+NW/10)//CHAR(48+MOD(NW,10))//'(1X,A'//CHAR(48+MXF)
C      FMD = '(/A,15(1X,A7),80(:/5X,15(1X,A7)))'//CLEAR
      FMD = '(/A,'//CH8//'),80(:/5X,'//CH8//')))'//CLEAR
      WRITE(8,'(//" The mean (AV), standard deviation (SD), and ex",
     +  "tremes of readable scores on each variable (Var) are")')
      DO I = 1,NY
        NDD(I) = ND(I)
        IF(ND(I)==0) NDD(I) = 11
      END DO
      WRITE(8,FMD) ' Var:', (CLN(1.*I,MXF,11),I=1,NY)
      WRITE(8,FMD) '  AV:', (CLN(AV(I),MXF,1+ND(I)),I=1,NY)
      WRITE(8,FMD) '  SD:', (CLN(SNGL(SD(I)),MXF,2+ND(I)),I=1,NY)
      WRITE(8,FMD) '  HI:', (CLN(HI(I),MXF,NDD(I)),I=1,NY)
      WRITE(8,FMD) '  LO:', (CLN(LOW(I),MXF,NDD(I)),I=1,NY)
      WRITE(8,'(/" Deviancies (unsigned sigma distances from mean) ",
     +  "of these high/low scores are")')
      CALL DEVN(NY,HI,XX,SD,AV,Z)
      IF(Z>3.) WRITE(8,FMD) '  HI:', (CLN(XX(I),MXF,2),I=1,NY)
      IF(Z<=3.) WRITE(8,'(/"  HI:   No deviancies over 3.0")')
      CALL DEVN(NY,LOW,XX,SD,AV,Z)
      IF(Z>3.) WRITE(8,FMD) '  LO:', (CLN(XX(I),MXF,2),I=1,NY)
      IF(Z<=3.) WRITE(8,'(/"  LO:   No deviancies over 3.0")')
      IF(MATCH(BLANK,-9999.)) WRITE(8,'(/" These spread summaries ",
     +  "may include an undeclared missing-datum surrogate.")')
      IF(NBNRY==1) THEN
        J = ORD1(1); WORD(:8) = IDENT(J); L = LEN_TRIM(IDENT(J))
        IF(KBNRY==1) WRITE(8,'(/" One variable, namely ",A," (No. ",
     +    A,"), is binary (a dichotomy scored 0/1).")') IDENT(J)(:L),
     +    CF(:JF(J))
        IF(KBNRY==0) WRITE(8,'(/" One variable, namely ",A," (No. ",
     +    A,"), is a dichotomy.  Its received scoring is NOT binary",
     +    " (0/1).")') IDENT(J)(:L), CF(:JF(J))
      ELSE IF(NBNRY>1) THEN
        K = NBNRY-KBNRY
        IF(K==0) WRITE(8,'(/" Dichotomous variables, all ",A,
     +    " of which are binary (scored 0/1):")')
     +    CF(:JF(NBNRY))
        IF(K*KBNRY>0) WRITE(8,'(/" Dichotomous variables, only "
     +    ,A," out of ",A," received with binary (0/1) scoring:")')
     +    CF(:JF(KBNRY)), CF(:JF(NBNRY))
        IF(KBNRY==0) WRITE(8,'(/" Dichotomous variables, none rec"
     +    "eived with binary (0/1) scoring:")')
        CALL SEENAM(LZ,NBNRY,ORD1,IDENT,1,20,8)
        IF(K*KBNRY>0) WRITE(8,'(" Indices of the ",A," whose rece",
     +    "ived scoring is not binary:",8(1X,A),10(:/4X,20(1X,A)))')
     +    CF(:JF(K)), (CF(:JF(ORD(I))),I=1,K)
      END IF
      IF(MIS==0) WRITE(8,'(/" No variable had any bad entries ",
     +  "(blank, unreadable, or flagged as missing).")')
      IF(MIS>0) THEN
        WRITE(8,'(/" The number of bad entries (blank, unreadable, or",
     +    " flagged as missing) for each variable is")')
        WRITE(8,FMD) ' Bad:', (CLN(1.*NR-NUM(I),MXF,11),I=1,NY)
      END IF
      N = SUM(NUM)
      NYR = NY*NR; MIS = NYR-N  ! Total count of scores less total bad ones
      IF(MIS>0) WRITE(8,'(5X," totalling ",A," out of ",A," scores (",
     +  A5,"% ) in all.")') CF(:JF(MIS)), CF(:JF(NYR)),
     +  CLN(MIS*100./NYR,5,1)
      IF(NBAD(2,0)<=0) THEN
        WRITE(8,'(/" No non-numeric data fields were encountered.")')
        GOTO 91
      END IF
      WRITE(8,'()')
      WORD(:2) = 's '
      DO I = 1,NBAD(1,0)
        IF(NBAD(2,I)>0) WRITE(8,'(4X,"Entry [",A,"] occurred ",A,
     +    " time", A,"in or before record ",A)') CBAD(I)(:NBAD(1,I)),
     +    CF(:JF(NBAD(2,I))), WORD(3-MIN(2,1*NBAD(2,I)):2),
     +    CF(:JF(NBAD(3,I)))
      END DO
      KK = 0
      DO I = 1,NY
        IF(KBD(I)==0) CYCLE
        KK = KK+1; ORD(KK) = I; KBD(KK) = KBD(I)
      END DO
      WRITE(8,'(/" Bad-score distribution over ",A," records: Each en",
     +  "try of form [M:N] in this list"/4X,"reports that the number ",
     +  "of records containing just M bad scores is N."/4X,"![0:",A,
     +  "]!",2X,9("[",A,":",A,"] ":),99(/4X,10("[",A,":",A,"] ":)))')
     +  CF(:JF(NR)), CF(:JF(KBD(0))), (CF(:JF(ORD(I))),
     +  CF(:JF(KBD(I))),I=1,KK)   !   [xxx:xxx] [xxx:xxx]  "[",A,":",A,"] ',
      IF(KK<=10) GOTO 91
      DO I = 1,KK/2 ! Reverse order.
        L = KK+1-I
        N = ORD(I); ORD(I) = ORD(L); ORD(L) = N
        N = KBD(I); KBD(I) = KBD(L); KBD(L) = N
      END DO  ! ORD holds bad-score count, KDB its frequency
      DO I = 1,KK-1  ! Convert to cumulative frequency at centiles
        KBD(I+1) = KBD(I) + KBD(I+1)
        ORD(I) = 1+INT(ORD(I)*100./NY) ! Closest integer upper-bound
      END DO; KBD(KK) = 100; NB = 0; NJ = 0
      WRITE(8,'(/"  In case you want to expunge all of this datafile''",
     +  "s records having fewer"/"  good scores than the mimimum you ",
     +  "consider tolerable, here is the preceding"/"  distribution e",
     +  "xpressed as a sequence of form ... [K:P%] ... where K is the"/
     +  "  count of records having more than P% bad scores.  To delet",
     +  "e the K records"/"  having more than P percent of bad scores",
     +  ", load a D-file transcription of"/2X,A," into SELECT and ch",
     +  "oose P for the value of its FAIL parameter."/)') F1(:LF1)
85    LL = 4; NL = 0
86    K = 7+JF(KBD(NJ+1))
      IF(LL+K<80 .AND. NJ<KK-1) THEN; NJ=NJ+1; LL=LL+K; GOTO 86
      ELSE
        WRITE(8,'(4X,20("[",A,":",A,"%] ":))') (CF(:JF(KBD(I))),
     +    CF(:JF(ORD(I))),I=NB+1,MIN(NJ,KK-1))
        NB = NJ; IF(NB<KK-1) GOTO 85
      END IF
91    WRITE(8,'()')
      IF(ID==1.AND.TST2>NR/4. .OR. ID==0.AND.SD(1)<NR/4.)
     +  GOTO 90
      IF(ID==0 .AND. SD(1)>NR/4.) WRITE(6,'(/" WARNING: Although y",
     +  "ou have declared these data records NOT to begin with ID"/
     +  " numbers, scores on the first variable read from them app",
     +  "ear to be either ranks"/" or IDs.  Enter anything if th",
     +  "is seems OK. Otherwise, hit RETURN to revise your"/" in",
     +  "put specifications.")')
      IF(ID==1 .AND. TST2<NR/4.) WRITE(6,'(/" WARNING: Although you",
     +  " have declared these data records to begin with IDs, the"/
     +  " numbers read as IDs have less variance than usual for IDs.",
     +  "  Enter anything if"/" this seems OK. Otherwise, hit RETURN",
     +  " to revise your input specifications.")')
      READ(5,'(A)') CH1
      IF(CH1/=' ') GOTO 90
CC      K = 1
89    BACKSPACE 8
      BACKSPACE 8
      READ(8,'(A)') CH8(1:1)
CC      K = K+1
CC      IF(K>500) WRITE(6,'(/" Run terminated by backspacing prob",
CC     +  "lem in LOG-file. Start again.")') ! No problem of this sort for a long time.
CC      IF(K>500) STOP
      IF(CH8(1:1)/='*') GOTO 89
      BACKSPACE 8
      DEALLOCATE ( BNRY, NDD, NUM, ORD1, LOW, HI, AV, SX, XX, SD )
      GOTO 20
C
C Save LASTFORM before variables are reordered
90    OPEN(9,FILE='LASTFORM')
      OPEN(10,FILE='LASTFORM.'//F1(:3))
      CALL LAST(LL,FMB,80)
      DO KF = 9,10
        WRITE(KF,'(I6,"  Last line before scores in datafile ",A)')
     +    LOM, F1
        WRITE(KF,'(I6,"  Number of variables")') NY
        WRITE(KF,'(I2,6X,"IDs in first column?")') ID
        WRITE(KF,'(A)') FMB(:LL)  ! FMT should NOT be saved in parens
        IF(.NOT.MATCH(BLANK,-9999.)) WRITE(KF,'(A)') CHB
        IF(MATCH(BLANK,-9999.)) WRITE(KF,'(I6)') -99
        WRITE(KF,'(50(12(1X,A),:/))') (IDENT(I)(:LM),I=1,NY)
      END DO
      CLOSE(10)
      IF(QY) THEN
        OPEN(10,FILE=F4)
        WRITE(10,'(50(12(1X,A),:/))') (IDENT(I)(:LM),I=1,NY)
        CLOSE(10)
      END IF
      WRITE(6,'(/4X,"READ-testing of datafile ",A," is complete.",
     +  "  Its report has been"/4X,"written to ASCII file ",A/)')
     +  F1(:LF1), WA(:12)  ! WA saves original LOG-name; F3 may now be different
      IF(.NOT.QTR .AND. .NOT.QCV) STOP
      CALL WAIT(1)
      IF(.NOT.QTR) GOTO 501
C
      CALL SYSTEM('cls')
      WRITE(6,'(//3X,69A)') C11, (LIN,I=1,67), C12
      WRITE(6,'(3X,A,19X,"COMMENCE DATA TRANSCRIPTION",21X,A)') BAR,
     +  BAR
      WRITE(6,'(3X,69A)') C21, (LIN,I=1,67), C22
      WRITE(6,'(/11X,"The transcribed datafile will code wildly devia",
     +  "nt"/11X,"outliers as missing, and at your option will permute"/
     +  11X,"the variables into alphanumeric name order.")')
      WRITE(6,'(/" A score counts as ""wildly deviant"" if more than",
     +  " DEV sigmas from its mean.")')
92    WRITE(6,'(" DEV is now set at ",A4,".  Hit RETURN if OK, or en",
     +  "ter new value (minimally 1.0)."/" (To omit, enter any lett",
     +  "er.)"/)') CLN(DEV,4,2)
      CALL SCANB(J,1,'R',5,CH8,L,WA,WB)
      IF(J<0) DEV = 99.
      IF(J<=0) GOTO 93
      READ(2,*) DEV
      DEV = MAX(1.,MIN(99.,DEV))
      GOTO 92
93    MWIDE = 0; KFLD = 3  ! $$$$$$$$ Bookmark for new fieldwidth treatment
      DO I = 1,NY   ! Compute rescaling parameters
        MWIDE = MAX(MWIDE, JF(CEILING(HI(I))), JF(CEILING(ABS(LOW(I))))) ! CLN field
        NDD(I) = ND(I)  ! Number of decimals in Var I
        HI(I) = MIN(HI(I),AV(I) + DEV*SNGL(SD(I)))   ! Highest score to record on Var I
        LOW(I) = MAX(LOW(I),AV(I) - DEV*SNGL(SD(I)))  ! Lowest    "    "    "    "  "  "
        KX(I) = NDD(I); SX(I) = 10.**KX(I)  ! Multiplier that clears decimals
        ZH = HI(I)*SX(I)       ! Max score after shift to clear decimals
        ZL = LOW(I)*SX(I)      ! Min   "     "     "    "   "      "
        J1 = JF(NINT(ZH)); J2 = JF(NINT(ZL))
        ORD1(I) = J1  ! ORD1 holds temp fieldwidths
        IF(J2>J1) THEN; ORD1(I) = J2; KFLD = 4; END IF  ! 3-width except maybe when some scores are negative
      END DO
      BLNK = -99; IF(KFLD==4) BLNK = -999; NSX=0; NBC=0  ! NSX/NBC count rescalings / all-bad score columns
      DO I = 1,NY   ! Fieldwidth is ORD1; shrink SX by factor 10**(MAX(0,ORD1-KFLD))
        K = MAX(0,ORD1(I)-KFLD); IF(K<=1) CYCLE
        SX(I) = SX(I)/10**K; KX(I) = KX(I) - K ! Rescaling by 10**KX that both clears
        IF(KX(I)>=0) NDD(I) = 11               ! decimals and shrink-fits fieldwidth
        IF(KX(I)<0) NDD(I) = ABS(NDD(I))       ! SX,KX are now finalized
C         NDD(I) now tells CLN how to print decimal for SX(I)
        HI(I) = HI(I)*SX(I)       ! Max score after shift to clear decimals
        LOW(I) = LOW(I)*SX(I)     ! Min   "     "     "    "   "      "
        HI(I) = HI(I) + .001    ! Not sure these really needed
        LOW(I) = LOW(I) - .001
        IF(NUM(I)==0) SX(I) = -999999  ! Print * in rescaling printout
        IF(NUM(I)==0) NBC = NBC+1
        IF(SX(I)/=1.0) NSX = NSX+1
      END DO

      IF(NBNRY>0) THEN
101     CALL SYSTEM('cls')
        NNB = 0          ! May return here with new binaries assignment
        DO I = 1,NY      ! Count non-binary dichotomies (may have shifted)
          IF(BNRY(I)==0) THEN  ! Reminder: binaries are flagged 1 in BNRY
            NNB = NNB+1   ! Current count of non-binary dichotomies
            ORD(NNB) = I  ! Non-binary dichotomies
            ORD1(NNB) = I  ! Also save as anchor
          END IF
        END DO

C       When HYDATA computes covariances, these are standardized as 
C       correlations (unit-variance item scaling) with the default  
C       exception that dichotomous variables scored 0/1 retain this 
C       binary scaling under presumption that you may wish MODA to  
C       treat some or all of these as manifest inputs.  (Regression 
C       weights on predictor dichotomies are especially meaningful  
C       when these are scaled as binaries.)                         

        WRITE(6,'(7X,"",61(""),"")')
        WRITE(6,'(7X," When HYDATA computes covariances, these are s",
     +    "tandardized as "/7X," correlations (unit-variance item ",
     +    "scaling) with the default  "/7X," exception that dichot",
     +    "omous variables scored 0/1 retain this "/7X," binary sca",
     +    "ling under presumption that you may wish MODA"," to  "/7X,
     +    " treat some or all of these as manifest inputs.  (Regress",
     +    "ion "/ 7X," weights on predictor dichotomies are especia",
     +    "lly meaningful  "/7X," when these are scaled as binar",
     +    "ies.)", 25X,"")')
        WRITE(6,'(7X,"",61(""),"")')
        IF(KBNRY>0) THEN
          WORD(:5) = 'isare'; J = MAX(1,MIN(2,KBNRY))
          WRITE(6,'(/6X,A," of these variables ",A," binary and will ",
     +      "remain so here.  But that"/6X,"status can be renegotiate",
     +      "d when this COV-file is sent to MODA.")') CF(:JF(KBNRY)),
     +      WORD(2*J-1:3*J-1)
          IF(NNB==0) GOTO 102
        END IF
        IF(NNB==1) THEN
          WRITE(6,'(/4X,"Variable ",A," (No. ",A,") is a dichotoNY ",
     +      "scored other than 0/1.  To rescale"/4X,"this as binary,",
     +      " enter anything.  Otherwise, hit RETURN.")')
     +      IDENT(ORD(1))(:LEN_TRIM(IDENT(ORD(1)))), CF(:JF(ORD(1)))
        ELSE IF(NNB>1) THEN
          WRITE(6,'(/2X,A," variables are dichotomies but not scored",
     +      " 0/1 (binary), namely")') CF(:JF(NNB))
          CALL SEENAM(LZ,NNB,ORD,IDENT,1,20,6)
          WRITE(6,'(/"  To rescale all these as binary, enter any ",
     +      "letter.  Otherwise, list"/"  indices of ones to make",
     +      " binary, or hit RETURN to waive rescaling."/)')
        END IF
        CALL SCANB(J,0,'I',5,CH8,L,WA,WB)
        IF(J==0) GOTO 102
        NB = NNB
        IF(NNB>1 .AND. J>0) THEN
          READ(2,*) (ORD(I),I=1,J)
          NB = 0                         !       nb = 0
          I = 0                          !       do 10 i = 1,nn
          DO WHILE (I<NNB)               !        do 20 k = 1,j
           I = I+1                       !          if(nd(k)==ord1(i) then
           K = NB                        !            nb = nb+1
           DO WHILE (K<J)                !            n = ord1(k)
            K = K+1                      !            nd(k) = nd(nb)
            IF(ORD(K)==ORD1(I)) THEN     !            nd(nb) = n
              NB = NB+1                  !            goto 10
              N = ORD(K)  ! Buffer       !          end if
              ORD(K) = ORD(NB)           !    20  continue
              ORD(NB) = N                !    10 continue
              K = J+1  ! Exit inner loop ! Each labeled loop takes 2 fewer
            END IF                      !! lines, or 3 if not Continued, at cost
           END DO                       !! of loop labe1 and fixed loop bounds.
          END DO      ! ORD now stripped to ORD1 terms in ORD1 order
        END IF
        WRITE(6,'(" Dichotomous variables now picked for 0/1 binary ",
     +    "rescaling):")')   !  Temporary listing of these in ORD
        CALL SEENAM(LZ,NB,ORD,IDENT,1,20,6)   ! LZ is temp LM
        WRITE(6,'(" Hit RETURN if OK, or enter anything to revise.")')
        CALL SCANB(K,0,'B',5,CH8,L,WA,WB)
        IF(K<0) GOTO 101
        DO I = 1,NB             ! Reminder: all NY items have a <-1,0,1> flag
          BNRY(ORD(I)) = 1      ! Flag selected dichotomies as binary
        END DO
        NNB = NNB-NB        !   Don't really need both of these
        KBNRY = KBNRY+NB    !   "                             "
      END IF

C  ***** Start LOG of transcribed data
102   IF(F1(:LFF-4)/=F2(:LFF-4)) THEN  ! Open new LOG-FILE
        WRITE(8,'(/1X,80("=")/" File ",A," is also being transcribed",
     +   " into HYDATA-standard datafile ",A)') F1(:LF1), F2(:LF2)
        CLOSE(8)
        OPEN(8,FILE=F3)
        CALL FNDEND(8,0)
      END IF
C Copy purified/rescaled scores into transcription file F2. LOG-file is F3.
      ORD = (/(I,I=1,NY)/)
      WRITE(8,'(/40("+ ")/" Transcription of datafile ",A," into HYD",
     +  "ATA-standardized datafile ",A," under READ format (",A,")")')
     +  F1(:LF1), F2(:LF2), FMB(:LL)
      IF(ID==1) WRITE(8,'(/" The first entry in each input record",
     +  " was the subject''s ID No.")')
      IF(ID==0) WRITE(8,'(/" The input records did NOT begin with ",
     +  "ID numbers.")')
C Sort names
      QY = .FALSE.
      N0 = 0
104   IF(QY) WRITE(6,'(/"   To transcribe these data with the variab",
     +  "les in lexicographic order,"/"   hit RETURN.  Otherwise, en",
     +  "ter anything to keep their present order.")')
      IF(.NOT.QY) WRITE(6,'(/"   To transcribe these data with the ",
     +  "variables in their present order, hit "/"   RETURN.  Othe",
     +  "rwise, enter anything to order them lexicographically.")')
      READ(5,'(A)') CH1
      IF(CH1/=' ') QY = .NOT.QY
      IF(CH1/=' ') GOTO 104
      IF(.NOT.QY) GOTO 112
      WRITE(6,'(" Sorting variable names into lexicographic order.")')
      DO K = 2,NY
        ORD(K) = K
        LK = IDEN2(1,ORD(K))
        KN = ORD(K)
        DO J = K-1,1,-1
          LJ = IDEN2(1,ORD(J))
          JN = ORD(J)
C           NOTE: Numeric trailers in names need to be ordered separately
          IF(LLT(IDENT(JN)(:LJ),IDENT(KN)(:LK))) GOTO 110  ! Don't permute
          IF(LGT(IDENT(JN)(:LJ),IDENT(KN)(:LK))) GOTO 109  ! Do permute
          IF(IDEN2(2,JN)<=IDEN2(2,KN)) GOTO 110          ! Don't permute
109       ORD(J+1) = JN
        END DO  ! Last in identical sequence is last encountered
        J = 0
110     ORD(J+1) = KN
      END DO

C Check for duplicate names
      DO J = 2,NY
        IF(IDENT(ORD(J))/=IDENT(ORD(J-1))) CYCLE
        N0 = N0+1
        WRITE(6,'(" WARNING: Variables ",A, " and ",A," are both name",
     +    "d ",A)') CF(:JF(ORD(J-1))), CF(:JF(ORD(J))), IDENT(ORD(J))
        WRITE(8,'(" WARNING: Variables ",A, " and ",A," are both name",
     +    "d ",A)') CF(:JF(ORD(J-1))), CF(:JF(ORD(J))), IDENT(ORD(J))
      END DO
112   KN = 0  ! Flag for unpermuted variables
      DO I = 1,NY  ! ORD(j) is the input index of variable now in position j
        ORD1(ORD(I)) = I  ! ORD1(j) is the permuted position of input variable j
        IF(ORD(I)/=I) KN = 1
      END DO

C Sort ID numbers into ascending order
      IF(ID==1) THEN
        WRITE(6,'(" Sorting ID numbers into ascending order.")')
        DO J = 2,NR
          L = LST(J)
          M = LS2(J)
          DO I = J-1,1,-1
            IF(LST(I)<=L) GOTO 122
            LST(I+1) = LST(I)
            LS2(I+1) = LS2(I)
          END DO
          I = 0
122       LST(I+1) = L
          LS2(I+1) = M
        END DO
C Flag duplicate IDs with minus signs; don't flag the last one
        DO J = 2,NR
          IF(LST(J)==0 .OR. LST(J)/=LST(J-1)) CYCLE
          IF(NDUP==0) WRITE(8,'()')
          LST(J-1) = -IABS(LST(J-1))
          WRITE(8,'(" Records ",A," and ",A," in count order have the",
     +      " same ID = ",A,".")') CF(:JF(LS2(J-1))), CF(:JF(LS2(J))),
     +      CF(:JF(LST(J)))
          NDUP = NDUP+1
          IF(NDUP<=NY) NUM(NDUP) = LS2(J-1)
        END DO
        NRR = NR-NDUP
C        IF(NDUP+NBAD==0) GOTO 127
C        WRITE(6,'()')
C        IF(NBAD>0) WRITE(6,'(1X,A," of these records have IDs tha",
C     +    "t are blank, non-positive, or unreadable.")') CF(:JF(NBAD))
C        IF(NDUP>0) WRITE(6,'(1X,A," of these records have IDs that",
C     +    " duplicate others in this dataset.")') CF(:JF(NDUP))
C  If you would like to eliminate records with bad IDs and all but the last
C  encountered in any group with the same ID, hit RETURN.  Otherwise, enter
C  anything to transcribe all the received records.
C  If overwriting is waived, put NRR = NR

      END IF
127   IF(F1/=F2) OPEN(7,FILE=F2)
      IF(F1==F2) OPEN(7,STATUS='SCRATCH')
      IF(ID==0) MXID = NR
      CHF = CF(:JF(JF(MXID)))
      WORD(:4) = '50I3'; IF(KFLD==4) WORD(:4) = '45I4'
      IF(KFLD==5) WORD(:4) = '40I5'
      FMT = '(I'//CHF//',":",'//WORD(:4)//',20(:/'//CHF//'X,1X,'//
     +  WORD(:4)//'))     '
      WORD = ' '
      WORD((13-LF2)/2:12) = F2; WORD(12+(13-LF1)/2:24) = F1
      WRITE(7,'(" HYDATA-standard datafile ",A,": ",A," variables, ",
     +  A," records; largest ID, ",A,"; transcribed under DEV =",F5.1/
     +  8X,"from rawdata source ",A,"; datafix ",A,"; ",A," missing ",
     +  "scores; ",A," complete records.")') WORD(:12), CF(:JF(NY)),
     +  CF(:JF(NRR)), CF(:JF(MXID)), DEV, WORD(13:24), CF(:JF(NFIX)),
     +  CF(:JF(MIS)), CF(:JF(KMPR))

C HYDATA-standard datafile xxxxxxxxxxxx: xxx variables, xxxx records; largest ID No.xxxxxxxxxx; transcribed under DEV = xxxx
C        from rawdata source xxxxxxxxxxxx; datafix xx; xxxxxxx missing scores.
C *** Any change in this WRITE Line 1 must be mirrored by HYDATA READ formats.
C *** 1st name, F2, must receive a 12-space field. 2nd name is F1

      N = 150/(LM+1)
      FM1 = '(90('//CF(:JF(N))//'(1X,A),:/))'//CLEAR
      WRITE(7,FM1) (IDENT(ORD(I))(:LM),I=1,NY)
      IF(NSX>0) WRITE(7,'("Rescale",8(2X,5I3),20(/8X,8(2X,5I3)))')
     +   (KX(I),I=1,NY)
      IF(QY .AND. KN==1) THEN
        N = 130/(6+LM)
        FM1 = '(90('//CF(:JF(N))//'(I4,": ",A),:/))'//CLEAR
        WRITE(8,'(/" After lexicographic reordering, the list of ",
     +    "named variables is")')
        WRITE(8,FM1) (I,IDENT(ORD(I))(:LM),I=1,NY)
      END IF
      IF(QY .AND. KN==0) WRITE(8,'(/" The namelist is already in ",
     +  "lexicographic order.")')
      IF(.NOT.QY) WRITE(8,'(/" The namelist has been unchanged.")')
      IF(N0>0) WRITE(7,'(/" WARNING: ",A," of these variables ha",
     +  "ve duplicate names.")') CF(:JF(N0))
      IF(N0>0) WRITE(8,'(/" WARNING: ",A," of these variables ha",
     +  "ve duplicate names.")') CF(:JF(N0))
      IF(.NOT.QY) WRITE(8,'(/" The variables'' names remain in orig",
     +  "inal order.")')
      WRITE(8,'()')
      N1 = JF(NY); N2 = JF(MXID); N3 = JF(NR); N4 = 3+MWIDE
      NS = 0; M2 = MIS; KMPR = 0; NREP = 0
130   NS = NS+1 !  Start retrieval of next buffered record
      IF(MOD(NS,500)==0) WRITE(6,'(4X,"Transcribing record ",A)')
     +  CF(:JF(NS))
      IF(NS>NR) GOTO 400
      NN = LS2(NS); QH = .TRUE.  ! QH is now free
      IF(LST(NS)<1) GOTO 130  ! *** Comment this line to waive ID exclusions
      READ(19,REC=NN) IDNUM, (XX(ORD1(I)),I=1,NY) ! Recover buffered record
      DO I = 1,NY
        IF(MATCH(XX(I),BLANK)) THEN
          AV(I) = BLNK; QH = .FALSE.; CYCLE
        END IF
        AV(I) = XX(I)*SX(ORD(I))  ! AV is now workspace collecting rescaled scores
        IF(AV(I)>HI(ORD(I)) .OR. AV(I)<LOW(ORD(I))) THEN
          CBAD(1)=CLEAR; CBAD(1)(N1+1-JF(I):) = CF
          CBAD(2)=CLEAR; CBAD(2)(N2+1-JF(NN):) = CF
          CBAD(3)=CLEAR; CBAD(3)(N3+1-JF(IDNUM):) = CF
          CBAD(4) = CLN(XX(I),N4,1)
          IF(NREP==0) WRITE(8,'(" Wildly deviant score ",A," on vari",
     +      "able ",A," in record ",A," (ID No. ",A,") has been tran",
     +      "scribed as missing.")') CBAD(4)(:N4), CBAD(1)(:N1),
     +      CBAD(2)(:N2), CBAD(3)(:N3)
          MIS = MIS+1 !  ******** D-file MIS count incremented here
          AV(I) = BLNK; QH = .FALSE.
        END IF
      END DO
      IF(QH) KMPR = KMPR+1
      IF(NBNRY>0) THEN
        DO I = 1,NY   ! BNRY was computed in input order, before reordering
          J = ORD(I)  ! ORD(I) is the input index of item now in position I
          IF(BNRY(J)==1 .AND. .NOT.MATCH(XX(I),BLANK))
     +      AV(I) = ANINT( (AV(I)-LOW(J))/(HI(J)-LOW(J)) )
        END DO
      END IF
      WRITE(7,FMT) IDNUM, (NINT(AV(I)),I=1,NY)  ! Write record to D-file
      IF(NS<NR) GOTO 130
400   IF(NREP==0 .AND. M2/=MIS) THEN  ! Update MIS in transcription header
        NREP = 1; NS = 0; REWIND 7; READ(7,'()')
        READ(7,'(A)') WORD(:40); BACKSPACE 7
        WRITE(7,'(8X,"from rawdata source ",A,"; datafix ",A,"; ",A,
     +    " missing scores; ",A," complete records.")') WORD(29:40),
     +    CF(:JF(NFIX)), CF(:JF(MIS)), CF(:JF(KMPR))
        WORD(:20) = '(90('//CF(:JF(N))//'(1X,A),:/))'//CLEAR
        WRITE(7,WORD(:20)) (IDENT(ORD(I))(:LM),I=1,NY)
        GOTO 130
      END IF
C
      NREC = NR
      IF(ID==0) WRITE(8,'(" Subjects have been assigned ID numbe",
     +  "rs sequentially from 1 to ",A)') CF(:JF(NR))
      WORD(:9) = ' permuted'
      CHF = 's '         ! ND1 => (2:2) = (3-M:2, ND2 => (3-M:2)
      M = MIN(NDUP,2)
      IF(NSX>0) WRITE(8,'(/" These",A," scores have been transcribed ",
     +  "to D-file ",A," after rescaling by multipliers"/4X,4(5A6,2X),
     +  :/50(4X,4(5A6,2X),:/))') WORD(:9*KN), F2(:LF2), (CLN(SX(I),6,
     +  NDD(I)),I=1,NY)
      WRITE(8,'(/" Scores that are blank, unreadable, or deviate more",
     +  " than",F5.1," SDs from their variable''s mean are coded in ",
     +  A," as ",A)') DEV, F2(:LF2), CF(:JF(NINT(BLNK)))
      IF(NBC>0) WRITE(8,'(" Asterisks above flag variables (",A,") on",
     +  " which all scores are bad.")') CF(:JF(NBC))
      IF(M>0) THEN
        L = MIN(NDUP,NY)
        WRITE(8,'(/" Count position",A,"in ",A," of ",A," record",A,
     +    "overwritten in ",A," by a later one with the same ID:",
     +    50(/4X,20(1X,A)))') CHF(3-M:2), F2(:LF2), CF(:JF(NDUP)),
     +    CHF(3-M:2), F1(:LF1), (CF(:JF(NUM(I))),I=1,L)
      END IF
      IF(JBAD>0) WRITE(8,'(/" Number of records with unidentifia",
     +  "ble IDs, omitted from ",A,":")') F2(:LF2), CF(:JF(JBAD))
      IF(KBNRY>0) THEN
        NN = 0
        DO I = 1,NY
          IF(BNRY(I)==1) NN = NN+1
          IF(BNRY(I)==1) ORD(NN) = I
        END DO  ! NN should equal KBNRY; test if problems here
        IF(NN==1) WRITE(8,'(/" Input index of dichotomous varia",
     +    "ble transcribed as binary: ",1X,A)') CF(:JF(ORD(1)))
        IF(NN>1) WRITE(8,'(/" Input indices of dichotomous varia",
     +    "bles transcribed as binary: ",10(1X,A),8(/2X,30(1X,A)))')
     +    (CF(:JF(ORD(I))),I=1,NN)
      END IF
C
440   WRITE(6,'(/" An ASCII copy of this HYDATA report on ",A," has be",
     +  "en filed in ",A,"."/" This includes statistics on the origina",
     +  "l scales, and the rescaling multipliers"/" under which it has",
     +  " been transcribed into ",A,"."/)') F1(:LF1), F3(:LFF), F2(:LF2)
      IF(.NOT.QTR) WRITE(6,'(" Hit RETURN to continue with covariance",
     +  "s from original datafile ",A,","/" or enter anything to quit",
     +  " at this point.")') F1(:LF1)
      IF(QTR) WRITE(6,'("   To compute covariances from the transcri",
     +  "bed data, enter anything to"/"   exit, restart HYDATA, and ",
     +  "pick ",A," from the input list.  Otherwise,"/"   hit RETURN",
     +  " to compute covariances from original datafile ",A,"."//)')
     +  F2(:LF2), F1(:LF1)
      READ(5,'(A)') CH1
      IF(CH1/=' ') STOP
501   CONTINUE

C Allocations conditional on input:
C    Case 1, Rawdata with LASTFORM     (QH=F)
C    Case 2, Rawdata without LASTFORM  (QH=F)
C    Case 3, Hydata-standard but treated as rawdata (QH=T, QHH=F)
C    Case 4, Hydata-standard, immediate COV computation (QHH=T)
C >>> At this point, these are all allocated in Cases 1-3 and are
C     all deallocated in Case 4
      IF(.NOT.QHH) DEALLOCATE ( ORD,BNRY,NDD,NUM,ORD1,LOW,HI,AV,SX,
     +                          SD,LST,LS2,IDEN2 )
      CALL COVS(STAR,CHS,CHB,NY,ID,NFIX,MIS,MTH,NREC,IDENT,MW,ND)
      END
C
      SUBROUTINE BADLST(CH10,NR,LW)
C Make inventory of non-numeric fields. CBAD collects unreadable fields;
C NBAD(1,-) counts their widths, with number of different Bads in NBAD(1,0);
C NBAD(2,-) counts freq of a Bad's occurrence with total count in NBAD(2,0);
C NBAD(3,-) lists the record No. in which a Bad last occurred.
      CHARACTER(10) CH10, CBAD(80)
      INTEGER NBAD(3,0:80)
      COMMON /BL1/ CBAD, NBAD
      CALL LAST(L,CH10,10)
      IF(L==0) L = LW
      DO I = 1,NBAD(1,0)
        IF(CH10/=CBAD(I)) CYCLE
        NBAD(2,I) = NBAD(2,I)+1  ! Total encounters with this bad field
        NBAD(2,0) = NBAD(2,0)+1  ! Count of all bad fields encountered
        NBAD(3,I) = NR           ! Last record containing this bad field
        RETURN
      END DO
20    IF(NBAD(1,0)==50) RETURN
      NBAD(1,0) = NBAD(1,0)+1  ! Count of different bad fields encountered
      CBAD(NBAD(1,0)) = CH10
      NBAD(1,NBAD(1,0)) = L
      NBAD(2,NBAD(1,0)) = 1
      NBAD(2,0) = NBAD(2,0)+1  ! Count of all bad fields encountered
      NBAD(3,NBAD(1,0)) = NR
      END SUBROUTINE
C
      SUBROUTINE CAP(WORD,L)
C This makes the first L letters in WORD all upper-case.
      CHARACTER WORD*(*)
      DO I = 1,L
        N = ICHAR(WORD(I:I))
        IF(N>=97 .AND. N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      END SUBROUTINE

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      CLN = '        '
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      LD = ABS(ND)
      IF(ABS(X)<1.0E-12) THEN !  Special for vanishingly small X
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X))) !  M is space free for decimal (or M-1 if X<0) )
      IF(M<0 .OR.  M<1.AND.X<0.) GOTO 55
      IF(ND>=10) LD = 0; LD = MIN(LD,M)
      DO I = 1,KW
        WK(I) = ' '
      END DO
      IF(LD==0) N = NINT(ABS(X))         ! Shouldn't be needed, but is
      IF(LD/=0) N = NINT(ABS(X)*10**LD)  ! This can overflow if LD is large
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' *******'
      END FUNCTION
C
      SUBROUTINE COVS(STAR,CHS,CHB,NY,ID,NFIX,MIS,MTH,NREC,IDENT,MW,ND)
C       NY, the maximum number of input variables, is now same as max covaried
C       MB is the max number of subjects allowed for bootstrapping.
C       ND is max number of decimals; MW is max needed fieldwidth
C       NV will be number of variables picked for COV computation.
C       MIS is the total number of missing scores
      PARAMETER (MB=10000)
      LOGICAL STAR, MATCH
      CHARACTER(10) CHS(0:*), IDENT(*)*8
      CHARACTER(12) F1, F2, F3, F4, CF, CLN*8, CHB*8, WA, WB
      CHARACTER(80) FMA, FMB, FMN, CLEAR, WORD*100, CH2*2, CH8*8
      CHARACTER C11,C12,C21,C22, BAR,LIN, CH1
      INTEGER MW(*), ND(*)
      REAL(8) X, Y, SS
      INTEGER(2), ALLOCATABLE :: KOV(:)
      INTEGER, ALLOCATABLE :: PIK(:), PIK1(:)
      INTEGER, ALLOCATABLE ::LIST(:), MSC(:), LST(:)
      REAL, ALLOCATABLE :: GET(:), HI(:), LOW(:), XX(:)  ! Need W on LOW so no conflict with LO-function
      REAL, ALLOCATABLE :: COVQ(:), AVQ(:), SDQ(:)
      REAL(8), ALLOCATABLE :: AV(:), SD(:), SK(:), KT(:), COV(:)
      REAL(8), ALLOCATABLE :: AAV(:), SSD(:), SSK(:), KKT(:), CCOV(:)
      COMMON F1, FMA, FMB, CLEAR, BLANK, LL, LF1, LM, LOM, LSHO, LW
      COMMON /CF/ CF
      DATA C11,C12,C21,C22,BAR,LIN/'','','','','',''/
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      LOK(I,J) = NV*(J-1) + I   ! NV will be the number of vars picked for Covar comp
      KD(I,J,K) = I*1000*1000 + J*1000 + K
      KD1(L) = L/10**6
      KD2(L) = MOD(L/1000,1000)
      KD3(L) = MOD(L,10**3)
      KDO = 0  ! Number of bootstrap COV-files to be produced
      NT = -999 ! Not yet determined
      CALL SYSTEM('cls')
      WRITE(6,'(//3X,69A)') C11, (LIN,I=1,67), C12
      NV = NY  ! NV may be decreased
      NYY = LO(NY,NY)
      NVV = LO(NV,NV)  ! Don't need this here?
      ALLOCATE ( PIK(NY), PIK1(NY), XX(NY), GET(2*NY), HI(NY), LOW(NY),
     +           AV(NY), SD(NY), SK(NY), KT(NY), COV(NYY), KOV(NYY),
     +           AAV(NY), SSD(NY), SSK(NY), KKT(NY), CCOV(NYY) )
      WRITE(6,'(3X,A,15X,"COMMENCE COMPUTATION OF COVARIANCES",17X,
     +  A)') BAR, BAR
      WRITE(6,'(3X,69A)') C21, (LIN,I=1,67), C22
      F2 = F1
      CALL NAME2(F2,6,'COV',LN)
      F3 = F2(:LN-3)//'SEE'
10    PIK = (/(I,I=1,NY)/)
      PIK1 = (/(I,I=1,NY)/)
      WRITE(6,'(/6X,"If you want covariances among all ",A," vari",
     + "ables in ",A,","/6X,"hit RETURN.  Otherwise, enter anyt",
     + "hing to pick a subset of these.")') CF(:JF(NY)), F1(:LF1)
      READ(5,'(A)') CH1
      IF(CH1==' ') GOTO 20
      WRITE(6,'(" The variables available for covariance computa",
     + "tion are:")')
      CALL SEENAM(LM,NY,PIK,IDENT,1,12,6)
C  The variables are received in (not-necessarily-proper) permuted order
      PIK = 0; CALL SETVAR(NV,NY,PIK,PIK1)
      IF(PIK(1)<0) GOTO 10
      WRITE(6,'(/" The variables selected for computation of cov",
     + "ariances are now")')
      CALL SEENAM(LM,NV,PIK,IDENT,1,12,6)
      WRITE(6,'(/" Hit RETURN if OK, or enter anything to start ",
     + "again.")')
      READ(5,'(A)') CH1
      IF(CH1/=' ') GOTO 10
C
C Choose missing-data treatment
20    KSKIP = 0;
      IF(MIS==0) GOTO 30
      WORD(:85) = ' differ from one statistic to another.  *** NO'//
     +  'TE: The number of complete recommended.'
      IF(ABS(NT)<=2) WORD(74:85) = 'cancelled.  '
      WRITE(6,'(/" You can choose either (1) to omit the entirety of",
     +  " incomplete score records;"/" or (2) to use all partial rec",
     +  "ords, in which case sample size will generally")')
      IF(NT<0) WRITE(6,'(A)') WORD(:39)
      IF(NT>5) WRITE(6,'(A,"There are ",A," complete records.")')
     +  WORD(:40), CF(:JF(NT))
      IF(ABS(NT)<=5.) WRITE(6,'(A/" records is only ",A,", so Opt",
     +  "ion 1 is",A)') WORD(:72), CF(:JF(KMPR)), WORD(73:85)
25    IF(KSKIP==0) WRITE(6,'(/" Computation is now set to include",
     +  " partial records.  Hit RETURN if OK,"/" or enter anything ",
     +  "to omit them.")')
      IF(KSKIP/=0 .AND. ABS(NT)>2) WRITE(6,'(/" Computation is ",
     +  "now set to omit partial records.  Hit RETURN if OK,"/" or ",
     +  "enter anything to include them.")')
      IF(KSKIP/=0 .AND. ABS(NT)<=2) WRITE(6,'(/" Computation is ",
     +  "now set to omit partial records.  Enter anything to"/" incl",
     +  "ude them, or hit RETURN to abort the run.")')
      READ(5,'(A)') CH1
      IF(ABS(NT)<=2 .AND. KSKIP/=0 .AND. CH1==' ') THEN
        WRITE(6,'(" Enter anything to confirm that you would rather ",
     +    "quit than risk use of"/" partial records.  Otherwise, hit"
     +    " RETURN to reconsider.")')
        READ(5,'(A)') CH1
        IF(CH1==' ') GOTO 20; STOP
      ELSE IF(CH1/=' ') THEN
        KSKIP = 1 - KSKIP; GOTO 25
      END IF
      Z = NV*(NV+19)/(2.*20*60); MD = 1
      WRITE(6,'(/"  You have four alternatives for your missing-data ",
     +  "report:"/3X,"1. For each variable, the number of missing sco",
     +  "res."/3X,"2. For each pair of variables, the number of incom",
     +  "plete score-pairs."/3X,"3. For each pair of variables, the n",
     +  "umber of fully blank score-pairs."/3X,"4. Both of Reports 2 ",
     +  "and 3.")')
      IF(Z>1.5) WRITE(6,'(" WARNING: Each of Reports 2 and 3 will",
     +  " require roughly",F5.1," print pages.")') Z
29    WRITE(6,'(/" Missing-data Report",I2," is now on call. Hit RET",
     +  "URN if OK, or enter"/" preferred option index."/)') MD
      CALL SCANB(J,1,'I',5,CH2,L,WA,WB)
      IF(J<0) GOTO 29
      IF(J==0) GOTO 30
      READ(2,*) MD
      MD = MIN(4,MD)
      GOTO 29
30    NVV = LO(NV,NV)
200   IF(KDO>0) THEN      ! KDO is total number of bootstraps to be done. It
        ALLOCATE ( LST(MB) ) !   is set at label 111, then returns to label 200
        KNT = KNT+1  ! Count-index of next bootstrap production
        CALL RANLST(NS,NS,LST,J)  ! Max repetition J isn't used at present
        DO K = 1,NS
          WRITE(17,REC=K) LST(K)
        END DO
        DEALLOCATE ( LST )
        M = 1+MOD(KNT-1,26)
        N = (KNT-1)/26
        IF(N==0) CH1 = '('
        IF(N==1) CH1 = ')'
        IF(N==2) CH1 = '['
        IF(N==3) CH1 = ']'
        IF(N==4) CH1 = '{'
        IF(N>=5) CH1 = '}'
        F4(LF4-6:LF4-5) = CH1//CHAR(64+KNT)
CCC        IF(KNT<=26) F4(LF4-6:LF4-5) = '('//CHAR(64+KNT)
CCC        IF(KNT>26) F4(LF4-6:LF4-5) = ')'//CHAR(64+KNT-26)
        IF(KNT==1) WRITE(6,'(/" Starting production of ",A,
     +    " bootstrap COV-files with copy of actual"/" covarianc",
     +    "es in pseudo-bootstrap file ",A)') CF(:JF(KDO)), F4
      END IF
      HI = -999999.; LOW = 999999.; KOV = 0
C Read each record under appropriate format
      IF(KDO==0) WRITE(6,'(/" Computation of correlations is ",
     +  "underway.")')
      IF(.NOT.(KDO*KNT==0)) WRITE(6,'(/" Starting another bootstr",
     +  "ap covariance file; ",A," to go.")') CF(:JF(KDO-KNT+1))
      CALL POSN(3,LOM,IER)
      NS = 0     ! NS counts total records; no ID exclusions
      NT = 0     ! NT counts records with no bad scores
      I = TM(1)  ! Initialize timer
      AAV = 0.D0; SSD = 0.D0; SSK = 0.D0; KKT = 0.D0; CCOV = 0.D0
      AV = 0.D0; SD = 0.D0; SK = 0.D0; KT = 0.D0; COV = 0.D0
      KLUMP = INT(SQRT(1.*NREC)) ! Break score accumulations into KLUMP subsets
50    CALL RECOVR(STAR,FMA,NY,ID,CHS,CHB,LW,NS+1,WORD,JMP)   ! CHS reads input
      IF(JMP==0) GOTO 70 ! JMP=0 marks end of file
      NS = NS+1 ! NS is count of records read; last one not yet processed
      NJ=1
      IF(KDO>0) THEN
        READ(17,REC=NS) NJ  ! Number of bootstrap repetitions of record NS
        IF(NJ==0) GOTO 210
      END IF
      DO I = 1,NY
        READ(CHS(I),*,ERR=55,END=55) F   ! This should occur only under non-* format
        XX(I) = F
        CYCLE  ! This includes case where F reads BLANK
55      XX(I) = BLANK
      END DO
      DO I = 1,NV
        GET(I) = XX(PIK(I))
      END DO
C Accumulate raw moments
      DO I = 1,NV
        IF(MATCH(GET(I),BLANK)) CYCLE
        LOW(I) = MIN(LOW(I),GET(I))
        HI(I) = AMAX1(HI(I),GET(I))
      END DO
      CALL OMIT(K,NV,BLANK,GET,KOV)
      IF(K/=1) NT = NT+NJ
C       K is returned as 1 (otherwise 0) if data are missing from this record
      T = TM(0)
      IF(NS==50 .AND. KDO==0) WRITE(6,'(" Raw record process",
     +  "ing will take roughly ",A5," minutes.")')
     +  CLN(T*NREC/3000.,5,1)
      IF(KSKIP*K==1) GOTO 220  ! K is returned by OMIT
      IF(NJ==0) GOTO 210    ! NJ=1 if KDO is 0
      DO I = 1,NV
        AV(I) = AV(I) + GET(I)*NJ
        X = GET(I)*GET(I)
        SD(I) = SD(I) + X*NJ
        SK(I) = SK(I) + X*GET(I)*NJ
        KT(I) = KT(I) + X*X*NJ
      END DO
        DO J = 2,NV      ! Replace after testing ??
          DO I = 1,J-1
            COV(LO(I,J)) = COV(LO(I,J)) + GET(I)*GET(J)*NJ
        END DO
      END DO
210   CONTINUE
220   IF(MOD(NS,LSHO)==0) WRITE(6,'(4X," Score record ",A," has been",
     +  " processed")') CF(:JF(NS))
      IF(MOD(NS,KLUMP)==0) THEN
        AAV=AAV+AV; SSD=SSD+SD; SSK=SSK+SK; KKT=KKT+KT; CCOV=CCOV+COV
        AV = 0.; SD = 0.; SK = 0.; KT = 0.; COV = 0.
      END IF
      GOTO 50
C Compute summary statistics
70    CONTINUE
      AV = AAV+AV; SD = SSD+SD; SK = SSK+SK; KT = KKT+KT; COV = CCOV+COV
      DEALLOCATE ( AAV, SSD, SSK, KKT, CCOV)
      TT = TM(1)
      IF(NT<3 .AND. KSKIP==1) THEN ! *** Check old version to puzzle out why inappropriate messages
        WRITE(6,'(/" ****** PROBLEM: Only",I2," records are complete ",
     +    "for this selection of variables,")') NT
          WRITE(6,'(17X,"too few to continue.  Enter anything to abo",
     +    "rt the run, or"/17X,"hit RETURN to approve use of partial",
     +    " records.")')
        GOTO 20
      END IF
      IF(TT<99) WRITE(6,'(" Raw-record processing time was",A5,
     +  " sec."/)') CLN(TT,5,1)
      BIG = -999999.
      MIS = 0
      DO I = 1,NV
        IF(LOW(I)==999999.) LOW(I) = BLANK
        IF(HI(I)==-999999.) HI(I) = BLANK
        BIG = AMAX1(BIG,HI(I))
        NSI = NT
        IF(KSKIP==0) NSI = NS - KOV(LO(I,I))
        MIS = MIS + KOV(LO(I,I))  ! Total missing scores
        IF(NSI==0) CYCLE
        AV(I) = AV(I)/NSI
        X = SD(I)/NSI
        Y = SK(I)/NSI
        SD(I) = X
        SK(I) = Y - (3*X - 2*AV(I)**2)*AV(I)
        KT(I) = KT(I)/NSI - (4*Y - 6*X*AV(I) + 3*AV(I)**3)*AV(I)
      END DO
      DO J = 2,NV    ! Note variances not done here
        DO I = 1,J-1
          N = NT
          IF(KSKIP==0) N = NS - KOV(LO(I,J))
          IF(N>0) COV(LO(I,J)) = COV(LO(I,J))/N - AV(I)*AV(J)
        END DO
      END DO
      MARK = 0
      DO I = 1,NV
        X = SD(I) - AV(I)*AV(I)
        COV(LO(I,I)) = X
        SD(I) = SQRT(MAX(0.D0,X))
        IF(X<1.D-16) GOTO 73
        SK(I) = SK(I)/(X*SD(I))
        KT(I) = KT(I)/(X*X)
        IF(NINT(LOW(I))==0.AND.NINT(HI(I))==1) KT(I) = -KT(I) ! Flag binaries
        IF(SD(I)>=.1D0) CYCLE
73      MARK = MARK+1
        PIK1(MARK) = I
      END DO
      WORD(:4) = 's ve'
      K = MAX(0,MIN(1,MARK-1))
      IF(MARK>0) WRITE(6,'(" WARNING: ",A," variable",A,"ha",A," var",
     +  "iance on the order of measurement error."/)') CF(:JF(MARK)),
     +  WORD(2-K:2), WORD(1+2*K:1+3*K)
      DO J = 1,NV
        DO I = 1,J
          SS = SD(I)*SD(J)
          IF(KT(I)<0) SS = SD(J)     ! Use Raw SDs for binary items
          IF(KT(J)<0) SS = SD(I)     !     flagged by negative KT
          IF(KT(I)<0 .AND. KT(J)<0) SS = 1.D0
          IF(SS>=1.D-35) COV(LO(I,J)) = COV(LO(I,J))/SS
        END DO
      END DO
      IF(KDO>0) KOD = NINT(1000000*RANDY()) ! RANDY is in unit interval
      IF(KDO>0) GOTO 250  ! Branch to output of bootstraps covariances
C Send readable statistics to results file <base>.SEE
      CALL LAST(LFF,F1,12)
      KODE = NINT(1000000*RANDY()) ! RANDY is in unit interval
      OPEN(8,FILE=F3)
      IF(KSKIP==0) WRITE(8,'("%%"/" Correlations computed from file ",
     +  A," for ",A," subjects on ",A," variables; partial score rec",
     +  "ords included pairwise; code No. ",A)') F1(:LFF),
     +  CF(:JF(NS)), CF(:JF(NV)), CF(:JF(KODE))
      IF(KSKIP/=0) WRITE(8,'("%%"/" Correlations computed from file ",
     +  A," for ",A," subjects on ",A," variables; only complete sco",
     +  "re records included; code No. ",A)') F1(:LFF), CF(:JF(NS)),
     +  CF(:JF(NV)), CF(:JF(KODE))
      WRITE(8,'(" Number of missing scores after ",A," FIXDATA appli",
     +  "cations: ",A)') CF(:JF(NFIX)), CF(:JF(MIS))
      CALL DAY(8)
      WRITE(8,'(/" The data were read under format ( ",A," ) with ",
     +  "missing-datum flag ",A)') FMB(:LL), CHB
      N = 130/(6+LM)
CC      CH2 = CHAR(48+N/10)//CHAR(48+MOD(N,10))
CC      FMN = '(90('//CH2//'(I4,": ",A),:/))'//CLEAR
      FMN = '(90('//CF(:JF(N))//'(I4,": ",A),:/))'//CLEAR
      WRITE(8,'(/" The covaried variables are named")')
      WRITE(8,FMN) (I,IDENT(PIK(I))(:LM),I=1,NV)
      WRITE(8,'(/" Basic statistics for these variables'' raw-sc",
     +  "ore distribution in this collection of ",A," records:")')
     +  CF(:JF((KSKIP)*NT+(1-KSKIP)*NS))
      MXF = 0
      DO I = 1,NV
        MXF = MAX(5,MXF,1+MW(PIK(I)))
      END DO
      CLOSE(13); MXF = MIN(8,MXF)
      NW = 130/(MXF+1)
      CH8 = CF(:JF(NW))//'(1X,A'//CF(:JF(MXF))
      FMN = '(50(5X,'//CH8//'),:/))'//CLEAR
      WRITE(8,'(/" Variable No.")')
      WRITE(8,FMN) (CLN(I*1.,MXF,11),I=1,NV)
      WRITE(8,'(/" MEANS:")')
      WRITE(8,FMN) (CLN(SNGL(AV(I)),MXF,ND(PIK(I))+2),I=1,NV)
      WRITE(8,'(/" STANDARD DEVIATIONS:")')
      WRITE(8,FMN) (CLN(SNGL(SD(I)),MXF,ND(PIK(I))+2),I=1,NV)
C      IF(MARK>0) WRITE(8,'(5X,"***  Number of variables having ",
C     +  "variances on the order of measurement error:",I3)') MARK
      WRITE(8,'(/" SKEW:")')
      WRITE(8,FMN) (CLN(SNGL(SK(I)),MXF,2),I=1,NV)
      WRITE(8,'(/" KURTOSIS (Standardized 4th moment; Normal distr",
     +  "ibution = 3.0):")')
      WRITE(8,FMN) (CLN(ABS(SNGL(KT(I))),MXF,2),I=1,NV)
      WRITE(8,'(/" HIGH (All records):")')
      WRITE(8,FMN) (CLN(HI(I),MXF, ND(PIK(I))+11*(1-MIN(1,
     +  INT(ND(PIK(I)),4)))),I=1,NV)
      WRITE(8,'(/" LOW (All records:")')
      WRITE(8,FMN) (CLN(LOW(I),MXF, ND(PIK(I))+11*(1-MIN(1,
     +  INT(ND(PIK(I)),4)))),I=1,NV)
      IF(MARK>0) THEN
        WRITE(8,'(/" WARNING. The following are indices of ",
     +    "variables having zero or negligible variance:",
     +    50(:/30(2X,A)))') (CF(:JF(PIK1(I))),I=1,MARK)
      END IF
      NB = 0
      DO I = 1,NV
        IF(KT(I)>=0) CYCLE
        NB = NB+1
        PIK1(NB) = I
      END DO
      IF(NB>0) WRITE(8,'(/"Binary variables whose covariances",
     +  " remain semi-raw:",10(1X,A),8(/2X,30(1X,A)))')
     +  (CF(:JF(PIK1(I))),I=1,NB)
      WRITE(8,'(/" COVARIANCES (standardized):")')
      N2 = 0
83    N1 = N2+1
      N2 = MIN(N1+19,NV)
      DO I = N1,NV
        IF(MOD(I,5)==1 .AND. I>1) WRITE(8,'(A1)')
        IF(I>1 .AND. I==N1) WRITE(8,'(24X,"(columns ",A," - ",
     +    A,")")') CF(:JF(N1)), CF(:JF(N2))
        WRITE(8,'(I4,".",4(5A5,2X))') I, (CLN(SNGL(COV(LO(J,I))),5,2),
     +    J=N1,MIN(I,N2))
      END DO
      IF(N1<NV) GOTO 83

C  File missing-data report

C ***** Future upgrade: For large arrays, replace these full missing-data
C       reports with lists of the most prominant entries.  E.g.:
C    For K = <10,9,...,1>, the pairs of variables on which exactly K subjects
C    lack a score on at least one item in the pair.
C      Missing:       Item pairs
C         10:  (21, 187); (34, 40), ...

Ccc  Note: Best to write fieldwidths matching the cov report; however:
ccc      M = NS - NT; MMM
ccc      DO I = 1,NV  ! Get largest missing-data entry
ccc        MMM = MAX(MMM,KOV(LO(I,I)))
ccc      END DO
ccc      WORD(:30) = '(I4,".",4(5(1X,I'//JF(MMM)//'),2X))     '
ccc      WORD(:30) = '(    5X,4(5(1X,I'//JF(MMM)//'),2X))     ' ! For MD=1
      M = NS - NT
      WRITE(8,'(/" Number of incomplete records: ",A)') CF(:JF(M))
      IF(M==0) GOTO 100
      IF(KSKIP==1) WRITE(8,'(" The effective sample size for each ",
     +  "of these statistics is nominal sample size ",A," less ",A,1X,
     +  "omissions, namely, ",A)') CF(:JF(NS)), CF(:JF(M)), CF(:JF(NT))
      IF(KSKIP/=1 .AND. MOD(MD,2)==0) WRITE(8,'(" The effective s",
     +  "ample size for each of these statistics is nominal sample si",
     +  "ze ",A," less the relevant Triangle-1 entry.")') CF(:JF(NS))
      WRITE(8,'(/24X,"DATA-OMISSIONS REPORT")')
      IF(MD>1) GOTO 85
      WRITE(8,'(/" Number of scores missing on each variable ( "A,
     +  " total ):")') CF(:JF(MIS))
      WRITE(8,'(50(2X,4(5I6,2X)/))') (KOV(LO(I,I)),I=1,NV)
      GOTO 100
85    IF(MD==3) GOTO 89
      WRITE(8,'(/" Triangle 1. Entry <I,J> is the number of records",
     +  " lacking data on the product of variables I,J."/13X,"Diag",
     +  "onal entry <I,I> is the number lacking just on I.")')
      N2 = 0
87    N1 = N2+1
      N2 = MIN(N1+19,NV)
      DO I = N1,NV
        IF(MOD(I,5)==1 .AND. I>1) WRITE(8,'(A1)')
        IF(I>1 .AND. I==N1) WRITE(8,'(24X,"(columns ",A," - ",
     +    A,")")')  CF(:JF(N1)), CF(:JF(N2))
        WRITE(8,'(I4,".",4(5I6,2X))') I, (KOV(LO(J,I)),J=N1,MIN(I,N2))
      END DO
      IF(N1<NV) GOTO 87
89    IF(MD<3) GOTO 100
      DO J = 2,NV
        DO I = 1,J-1
          KOV(LO(I,J)) = KOV(LO(I,I)) + KOV(LO(J,J)) - KOV(LO(I,J))
        END DO
      END DO
      WRITE(8,'(/" Triangle 2. Entry <I,J> is the number of records",
     +  " lacking data on both of variables I,J."/13X," Diagonal en",
     +  "try <I,I> is the number lacking just on I.")')
      N2 = 0
91    N1 = N2+1
      N2 = MIN(N1+19,NV)
      DO I = N1,NV
        IF(MOD(I,5)==1 .AND. I>1) WRITE(8,'(A1)')
        IF(I>1 .AND. I==N1) WRITE(8,'(24X,"(columns ",A," - ",
     +    A,")")')  CF(:JF(N1)),  CF(:JF(N2))
        WRITE(8,'(I4,".",4(5I6,2X))') I, (KOV(LO(J,I)),J=N1,MIN(I,N2))
      END DO
      IF(N1<NV) GOTO 91
C
C Send ASCII correlations and supporting information to file *.COV (F2).
C Names are used by MODA and HYBALL, SDs by HYFAC.  The remaining info is
C needed for plotting the joint distribution of selected pairs of variables.
100   OPEN(7,FILE=F2)
      WORD = 'included pairwise; code No. '//CF(:JF(KODE))//'     '
      IF(KSKIP/=0) WORD = 'excluded; code No. '//CF(:JF(KODE))//'    '
      MTH = MTH*(1-2*KSKIP) ! MTH=1/-1 marks include/exclude partial records
C                           !!  But MTH=0 if datafile is not a D-file !!
      WRITE(7,'("Standardized covariances (correlations) computed "
     +  "from datafile ",A," with ",A," FIXDATA patches; partial ",
     +  "records ",A)') F1(:LFF),  CF(:JF(NFIX)), WORD(:36)
      WRITE(7,'()')
      WRITE(7,'(7(1X,A))') CF(:JF(NV)), CF(:JF(NVV)), CF(:JF(KODE)),
     +   CF(:JF(MTH)), F1(:LFF), CF(:JF(NY)), CF(:JF(NINT(BLANK)))
      WRITE(7,'(25I6)') (IDNINT(10000*COV(I)),I=1,NVV)  ! REAL*8 -> INTEGER
      WRITE(7,'(/"Names assigned to the variables:")')
      N = 150/(1+LM)
      CH2 = CHAR(48+N/10)//CHAR(48+MOD(N,10))
      WORD = '(80('//CH2//'(1X,A),:/))'//CLEAR
      WRITE(7,WORD) (IDENT(PIK(I))(:LM),I=1,NV)
      WRITE(7,'(/"Means of the variables are")')
      WRITE(7,FMN) (CLN(SNGL(AV(I)),MXF,ND(PIK(I))+2),I=1,NV)
      WRITE(7,'(/"SDs of the variables are")')
      WRITE(7,FMN) ( CLN(SNGL(SD(I)), MXF, ND(PIK(I))+2),I=1,NV)
      WRITE(7,'(/"Highs on the variables are")')
      WRITE(7,FMN) (CLN(HI(I),MXF, ND(PIK(I))+11*(1-MIN(1,
     +  INT(ND(PIK(I)),4)))),I=1,NV)
      WRITE(7,'(/"Lows on the variables are")')
      WRITE(7,FMN) (CLN(LOW(I),MXF, ND(PIK(I))+11*(1-MIN(1,
     +  INT(ND(PIK(I)),4)))),I=1,NV)
      WRITE(7,'(/"The indices that pick these variables out of the ",
     +  "sequence in datafile ",A, " are"/(30(32I4,:/)))') F1(:LFF),
     +  (PIK(I),I=1,NV)
      WRITE(7,'(/"Format for reading the source datafile is"/" (",
     +  A,")")') FMB(:LL)
      WORD(:2) = 's '; M = MIN(NB,2)  ! (j:2); j=1 if NB>1, j=2 if NB=1
      IF(NB>0) WRITE(7,'(/1X,A," binary variable",A,"whose covaria",
     +  "nce",A,"remain semi-raw:",50(/2X,30(1X,A)))') CF(:JF(NB)),
     +  (WORD(3-M:2),J=1,2), (CF(:JF(PIK1(I))),I=1,NB)
      CLOSE(7)

C Send unformatted covariances to file INMODA
      OPEN(7,FILE='INMODA')
      CLOSE(7,STATUS='DELETE')
      OPEN(7,FILE='INMODA',FORM='UNFORMATTED')
      WRITE(7) NV, NVV, KODE, MTH, F2, F1
C       F2: Name of corresponding COV-file.  F1: Source datafile
      WRITE(7) (SNGL(COV(I)),I=1,NVV)
      WRITE(7) (PIK(I),I=1,NV)  ! Indices of variables in F1
      WRITE(7) NB, (PIK1(I),I=1,NB)  ! List of binary items
      CLOSE(7)
      WRITE(8,'(//" The correlations from this score distribution have",
     +  " been sent to unformatted file INMODA for factoring by MODA,"/
     +  " as well as to ASCII archive ",A,", with Code No. ",A/)')
     +  F2(:LN), CF(:JF(KODE))

C Provide Bootstraps covariances from this datafile
CCC      IF(NS>MB) GOTO 300  ! Don't bootstrap if datafile is very large
      KDO = 156     ! Bootstrap section

C |  If you would like to appraise sampling error in factoring these data,    |
C |  you may generate up to xxx bootstrap COV-files (binary, not ASCII), each |
C |  containing the correlations among these xxx variables in xxxx records    |
C |  randomly sampled WITH REPLACEMENT from this datafile.  Otherwise, you    |
C |  can elect to test for quadratic trends in these variables' relations.    |

      WRITE(6,'(1X,77A)') C11, (LIN,I=1,75), C12
      WRITE(6,'(1X,A,2X,"If you would like to appraise sampling error",
     +  " in factoring these data,    ",A/1X,A,2X,"you may generate u",
     +  "p to",I4," bootstrap COV-files (binary, not ASCII), each ",A/
     +  1X,A,2X,"containing the correlations among these ",A," variab",
     +  "les in ",A," records",A,A/1X,A,2X,"randomly sampled WITH RE",
     +  "PLACEMENT from this datafile.  Otherwise, you",4X,A/1X,A,2X,
     +  "can elect to test for quadratic trends in these variables''",
     +  " relations.",4X,A)') (BAR,I=1,3), KDO, BAR, BAR, CF(:JF(NV)),
CC     +  CF(:JF(NS)), CLEAR(:11-JF(NV)-JF(NS)), (BAR,I=1,5)
     +  CF(:JF(NS)), '        '(:11-JF(NV)-JF(NS)), (BAR,I=1,5)
      WRITE(6,'(1X,77A)') C21, (LIN,I=1,75), C22
110   WRITE(6,'(/7X,"To waive bootstrap productions, hit RETURN.  ",
     +  "Otherwise, enter"/7X,"the number of bootstrap COV-files ",
     +  "wanted (at most ",I3,")."/)') KDO
      CALL SCANB(J,1,'I',5,CH2,L,WA,WB)
      IF(J==0) GOTO 300
111   READ(2,*) N
112   WRITE(6,'(/" To produce ",A," bootstrap COV-files, hit RETURN.",
     +  "  Otherwise, enter another count."/)') CF(:JF(MIN(N,KDO)))
      CALL SCANB(J,1,'I',5,CH2,L,WA,WB)
      IF(J>0) GOTO 111
      IF(J<0) GOTO 112
      IF(N<1) STOP
      OPEN(17,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +  RECL=8) !  Needed to store RANLST'S rep count; LST space used by COV
      KDO = N
      IF(LN<=9) THEN  ! HYBALL won't accept names staring with double parens
        F4 = F2(:LN-5)//'(-'//F2(LN-4:)
        LF4 = LN+2
      ELSE IF(LN>=10) THEN
        F4 = F2(:4)//'(-'//F2(LN-4:)
        LF4 = MAX(11,LN)
      END IF
      KOD = -1   !
C     Bootstrap file is <dat>(i.COV, length LF4, with index  in position LF4-5
      KNT = 0
250   CONTINUE
C Send unformatted bootstraps covariances to file F4 = <dat>(i.COV
      OPEN(7,FILE=F4)
      CLOSE(7,STATUS='DELETE')
      OPEN(7,FILE=F4,FORM='UNFORMATTED')
      WRITE(7) NV, NVV, KODE, MTH, F2, F1, KOD
C       F2: Name of master COV-file;  F1: Source datafile; KOD, code specific to this bootfile
      WRITE(7) (SNGL(COV(I)),I=1,NVV)
      WRITE(7) (PIK(I),I=1,NV)  ! Indices of variables in F1
      CLOSE(7)

CC TEST LINES.  Save for possible permanent installation
C      WORD(:LF4) = F4(:LF4-3)//'SEE'
C      OPEN(7,FILE=WORD(:LF4))
C      WRITE(7,'(" Statistics in bootstraps file ",A)') F4(:LF4)
C      WRITE(7,'(2I6,I8,F8.1,I6,2X,A)') NY, NYV, KODE, BLANK, NY, F1
C      WRITE(7,'()')
C      WRITE(7,'("Correlations:")')
C      WRITE(7,'(25I6)') (IDNINT(1000*COV(I)),I=1,NYV)
C      WRITE(7,'(/"Names:")')
C      N = 150/(1+LM)
C      CH2 = CHAR(48+N/10)//CHAR(48+MOD(N,10))
C      WORD = '(80('//CH2//'(1X,A),:/))'//CLEAR
C      WRITE(7,WORD) (IDENT(PIK(I))(:LM),I=1,NY)
C      WRITE(7,'(/"Means:")')
C      WRITE(7,FMN) (CLN(SNGL(AV(I)),MXF, NINT(ND(PIK(I))+1)),I=1,NY)
C      WRITE(7,'(/"SDs:")')
C      WRITE(7,FMN) (CLN(SNGL(SD(I)),MXF,NINT(ND(PIK(I))+2)),I=1,NY)
C      WRITE(7,'(/"Highs:")')
C      WRITE(7,FMN) (CLN(HI(I),MXF,NINT(ND(PIK(I))+11*(1-MIN(1,
C     +  ND(PIK(I)))))),I=1,NY)
C      WRITE(7,'(/"Lows:")')
C      WRITE(7,FMN) (CLN(LOW(I),MXF,NINT(ND(PIK(I))+11*(1-MIN(1,
C     +  ND(PIK(I)))))),I=1,NY)
C      WRITE(7,'(/"The indices that pick these variables out of the ",
C     + "sequence in datafile ",A, " are"/(30(32I4,:/)))')
C     + F1(:LFF), (PIK(I),I=1,NY)
C      WRITE(7,'(/"Format for reading the source datafile is"/" (",
C     +  A,")")') FMB(:LL)
C      CLOSE(7)

      IF(KNT<KDO) GOTO 200
      WRITE(6,'(//4X,"Production of bootstrapped covariances is ",
     +  "done.")')
      WRITE(6,'(/4X,"The original correlations from this score distri",
     +  "bution have"/4X,"been sent to ASCII file ",A," with Code No.",
     +  1X,A,"."/4X,"Additional summary statistics are in",A,"."/)')
     +  F2(:LN), CF(:JF(KODE)) , F3(:LN)
      STOP

300   WRITE(6,'(4X,70A)') C11, (LIN,I=1,68), C12
      WRITE(6,'(4X,A,2X,"To Quit at this point, hit RETURN.  Other",
     +  "wise, enter any letter   ",A/4X,A,2X,"to test these varia",
     +  "bles for pairwise nonlinear relations, or any  ",A/4X,A,2X,
     +  "number to change your mind about waiving bootstrap product",
     +  "ions.   ",A)') (BAR,I=1,6)
      WRITE(6,'(4X,70A/)') C21, (LIN,I=1,68), C22
      CALL SCANB(J,0,'R',5,CH2,L,WA,WB)
      IF(J==0) GOTO 500
      IF(J>0) GOTO 110

      WRITE(6,'(/" Starting nonlinearities inspection."/)')
CCC   Can't yet  DEALLOCATE ( PIK, GET, AV, SD )
      DEALLOCATE ( PIK1, HI,LOW, SK,KT, COV )
      ALLOCATE ( AVQ(2*NV), SDQ(2*NV), COVQ(NV*(2*NV+1)) )
      NQ = 2*NV; AVQ = 0.; SDQ = 0; COVQ = 0.
C Read each record under appropriate format
      CALL POSN(3,LOM,IER)
      NS = 0
      I = TM(1)  ! Initialize timer
350   CALL RECOVR(STAR,FMA,NY,ID,CHS,CHB,LW,NS+1,WORD,JMP) ! Start of READ loop
      IF(JMP==0) GOTO 400 ! JMP=0 marks end of file
      NS = NS+1 ! NS is count of records read; latest is not not yet processed
      DO I = 1,NY
        READ(CHS(I),*,ERR=355,END=355) F    ! Reading CHS(I) as internal file
        XX(I) = F
        CYCLE  ! This includes case where F reads BLANK
355     XX(I) = BLANK
      END DO
      DO I = 1,NV
        Z = XX(PIK(I))
        IF(MATCH(Z,BLANK)) THEN
          IF(KSKIP>0) GOTO 365
          Z = 0.
        ELSE IF(SD(I)>=.05D0) THEN
          Z = (Z-AV(I))/SD(I)
        ELSE    ! Ignore variables with negligible variance
          Z = 0.
        END IF
        GET(I) = Z        ! Z-scores on data variables
        GET(NV+I) = Z*Z   ! Squared Z-scores
      END DO
C Accumulate raw moments
      T = TM(0)
      IF(NS==50) WRITE(6,'(" Raw record processing will take ",
     +  "roughly ",A5," minutes.")') CLN(T*NREC/3000.,5,1)
      DO I = 1,NQ
        AVQ(I) = AVQ(I) + GET(I)
        SDQ(I) = SDQ(I) + GET(I)*GET(I)
      END DO
      DO I = 1,NV   ! Don't need the order-4 terms
        DO J = I,NQ
          COVQ(LO(I,J)) = COVQ(LO(I,J)) + GET(I)*GET(J)  ! Center all covariances
        END DO
      END DO
365   IF(MOD(NS,LSHO)==0) WRITE(6,'(4X," Score record ",A," has been",
     +  " processed")') CF(:JF(NS))
      GOTO 350

C Compute quad-moment summary statistics
400   CONTINUE  ! Branch from end of data read
      DEALLOCATE ( PIK, AV, SD )
      WRITE(6,'(" Actual raw-record processing time was",A5,
     +  " minutes")') CLN(TM(1)/60,5,1)
      DO J = 1,NQ
        J1 = MOD(J-1,NV) + 1
        N = NT
        IF(KSKIP==0) N = NS - KOV(LO(J1,J1))  ! KOV has missing-data count
        IF(N==0) CYCLE
        AVQ(J) = AVQ(J)/N
        SDQ(J) = SQRT(MAX(0.,SDQ(J)/N - AVQ(J)*AVQ(J)))
      END DO
      DO I = 1,NV  ! Compute covariances
        DO J = I,NQ
          J2 = MOD(J-1,NV) + 1
          N = NT
          IF(KSKIP==0) N = NS - KOV(LO(I,J2))
          IF(N==0) COVQ(LO(I,J)) = 0.
          IF(N>0) COVQ(LO(I,J)) = COVQ(LO(I,J))/N - AVQ(I)*AVQ(J)
        END DO
      END DO
      DEALLOCATE ( KOV )
      DO I = 1,NV  ! Standardize variances
        DO J = I,NQ
          SS = SDQ(I)*SDQ(J)   ! SDQ(I) = 1.0 for I < NV+1
          IF(SS<1.D-30) SS = 0.D0
          IF(SS>=1.D-30) SS = 1./SS
          COVQ(LO(I,J)) = COVQ(LO(I,J))*SS
        END DO
      END DO
      DEALLOCATE ( AVQ, SDQ )
      DO J = 1,NV
        J2 = NV+J
        GET(J) = COVQ(LO(J,J2))  ! Need to pull out because case I=J changes it
        GET(J2) = 1. - COVQ(LO(J,J2))**2  ! Divisor in formula for R
        IF(GET(J2)<.001) GET(J2) = 0.
        IF(GET(J2)>=.001) GET(J2) = 1./GET(J2)  ! Convert divisor to multiplier
      END DO
      BG1 = 0.; BG2 = 0.
      DO J = 1,NV
        J2 = NV+J
        DO I = 1,NV
          S = COVQ(LOC(I,J))
          T = S*S + COVQ(LO(I,J2))**2 - 2*S*COVQ(LO(I,J2))*GET(J)
          COVQ(LO(I,J2)) = T*GET(J2)
C            COVQ(LO(I,NV+J)) now contains R of Xi on <Xj,Xj> (i,j = 1,..,NV)
          IF(I/=J) BG2 = MAX(BG2,COVQ(LO(I,J2)))
        END DO
      END DO
      DO J = 1,NV
        DO I = 1,J
          COVQ(LO(I,J)) = COVQ(LO(I,J))**2
        IF(I/=J) BG1 = MAX(BG1,COVQ(LO(I,J)))
        END DO   ! Triangle contains {r(i,j)}.
      END DO
      TT = .25
      WRITE(6,'(/4X,"Nonlinearities analysis first computes, for eac",
     +  "h ordered pair <Zi,Zj>"/4X,"of standardized data variables, ",
     +  "the variance R(i,jj) of Zi accounted"/4X,"for by its quadra",
     +  "tic regression on Zj.  Only pairs whose R exceeds a"/4X,"th",
     +  "reshold value T will be examined further."/4X,"Note: Excludi",
     +  "ng cases i=j, R(i,jj)  ",A5," while r(i,j)  ",A5,".")')
     +  CLN(BG2,5,4), CLN(BG1,5,4)
420   NT = 0  ! Re-initialize count of pairs above latest TT
      DO J = 1,NV
        J2 = NV+J
        COVQ(LO(J,J2)) = -.01 ! Disable self-regressions
        DO I = 1,NV
          IF(COVQ(LO(I,J2))>=TT) NT = NT+1
        END DO
      END DO
      N = NV*(NV-1)
      Z = NT*100./N
      IF(NT<=5) THEN
        IF(TT<.05 .OR. N<=2) THEN
          WRITE(6,'(/10X,"All pairwise quadratic relations among th",
     +      "ese data variables"/10X," are negligible, so their ana",
     +      "lysis is aborted.")')
          WRITE(8,'("All pairwise quadratic relations among these ",
     +      "data variables are negligible.")')
          GOTO 500
        END IF
        TT = TT-.02
        GOTO 420
      END IF
422   WRITE(6,'(/4X,"Threshold T is now ",A4,", which is passed by ",
     +  A," (",A4,"%) of the ",A/4X,"item pairs.  Hit RETURN if OK;",
     +  " otherwise, enter new T less than 1.0.")') CLN(TT,4,3),
     +  CF(:JF(NT)), CLN(Z,4,3), CF(:JF(N))
      IF(NT==0) WRITE(6,'(4X,"WARNING: Setting the threshold this",
     +  " high will terminate the analysis.")')
      WRITE(6,'()')
      CALL SCANB(J,1,'R',5,CH8,L,WA,WB)
      IF(J<0) GOTO 422
      IF(J>0) THEN
        READ(2,*) TT
        TT = AMAX1(0.,TT)
424     IF(TT>=1.) TT = TT/10
        IF(TT>=1.) GOTO 424
        GOTO 420
      END IF
      IF(N<1) STOP
      DO J = NV+1,NQ
        DO I = 1,J
          IF(COVQ(LO(I,J))<=TT) COVQ(LO(I,J)) = -.01  ! Below threshold
        END DO
      END DO

      ALLOCATE ( MSC(NV*NV) )
      CALL QVRT(NV,NQ,COVQ,COVQ,MSC)  ! MSC returns integer-coded quad-moment info
      DEALLOCATE ( COVQ )
      ALLOCATE ( LIST(NV*NV) )

C                      Ŀ
C ͵ Pairwise Quadratic Trend Analysis 
C                      
C
C   Let r(i,j) be the variance of standardized data variable Zi accounted
C   for by its linear regression on data variable Zj, while R(i,jj) is the
C   variance of Zi accounted for by its quadratic regression on Zj.  Then
C   QR(i,j) = R(i,jj)-r(i,j) is Zi's variance accounted for by this quad-
C   regression's nonlinear residual.  And QS(i,j) = QR(i,j)/R(i,jj), the
C   quad-residual's proportionate share of variance accounted for by Zi's quad-
C   regression on Zj, may be viewed as the "Quadratic Salience" of Zj for Zi.

      WRITE(8,'(22X,"",35(""),"")')
      WRITE(8,'(22("")," Pairwise Quadratic Trend Analysis ",
     +  22(""))')
      WRITE(8,'(22X,"",35(""),""/)')
      WRITE(8,'(3X,"Let r(i,j) be the variance of standardized data ",
     +  "variable Zi accounted"/3X,"for by its linear regression on ",
     +  "data variable Zj, while R(i,jj) is the"/3X,"variance of Zi",
     +  " accounted for by its quadratic regression on Zj.  Then"/3X,
     +  "QR(i,j) = R(i,jj)-r(i,j) is Zi''s variance accounted for",
     +  " by this quad-"/3X,"regression''s nonlinear residual.  And ",
     +  "QS(i,j) = QR(i,j)/R(i,jj), the"/3X,"quad-residual''s prop",
     +  "ortionate share of variance accounted for by Zi''s quad-"/3X,
     +  "regression on Zj, may be viewed as the ""Quadratic Salien",
     +  "ce"" of Zj for Zi.")')
      WRITE(8,'(/"   Threshold for including item pair <Zi,Zj> in qua",
     +  "dratic-trend assessment"/"   has been set at R(i,jj) > ",A4,
     +  ".  (",A," pairs qualify.)")') CLN(TT,4,3), CF(:JF(NT))
C Put R(i,jj)-r(i,j) followed by I,J into LIST and reorder decreasingly
      F4 = '(R-r)/RRS'          ! (R-r)/RRS  F4(3-M:2+4*)
      F1 = 'R-rQR/R  '          ! 1-5, 6-10 => F1(5*M-4:5*M)
C      P = 10.
C      NP = NINT(NV*(NV-1)*P/100)

C  Ŀ
C               Computing quadratic-residual variances QR = R-r             
C             Computing quad-residual variance ratios QS = (R-r)/R
C  
      MLOOP: DO M = 1,2
        WRITE(6,'(/"  ",75(""),"")')
        IF(M==1) WRITE(6,'("  ",13X,"Computing quadratic-residual",
     +    " variances QR = R-r",13X,"")')
        IF(M==2) WRITE(6,'("  ",10X,"Computing quad-residual vari",
     +    "ance ratios QS = (R-r)/R",10X,"")')
        WRITE(6,'("  ",75(""),"")')
        T = TM(1)
        NN = 0
        DO J = 1,NV    ! Reminder: MSC digits 5-8 hold R, digits 1-4 hold r
          DO I = 1,NV  !           Negative value if R<T or i=j
            IJ = LOK(I,J)
            IF(MSC(IJ)<=0.) CYCLE
            K = MSC(IJ)/10000  ! R * 1000
            IJR = MAX(0, MIN(999,K - MOD(MSC(IJ),10000)) )   ! R-r * 1000
            IF(M==2 .AND. K>0) IJR = NINT(IJR*1000./K)  ! (R-r)/R * 1000
            NN = NN+1
            LIST(NN) = KD(MAX(0,MIN(999,IJR)),I,J)
          END DO
        END DO
        CALL ISORT(NN,LIST)
        CALL DIST(NN,NT,LIST,GET) ! GET(1,10) gets % of QR,QS values in interval
        WRITE(6,'(/" Time to compute and order the ",A," terms was",
     +    A5," seconds")') F4(3-M:2+4*M), CLN(TM(1),5,1)
        KLOOP: DO K = 6,8,2
          WRITE(K,'(/" Ŀ")')
          WRITE(K,'("  Q",A," findings ",62(""))')
     +      F4(10+M:10+M)
          WRITE(K,'(" ")')
          I = 11
          P = 0.
441       I = I-1
          P = P + GET(I)
          IF(P<.0001 .AND. I>2) GOTO 441
          NP = MIN(NT,INT(P*(NT+1)/100.))
          IF(I<=1 ) GOTO 442
          Z = P+GET(I-1)
          IF(Z>=P*2 .AND. NINT(Z*NT)<=21) GOTO 441
442       IF(M==1) WRITE(K,'(4X,"The QR distribution of quadratic-",
     +      "residual variances R(i,jj)-r(i,j)")')
          IF(M==2) WRITE(K,'(4X,"The QS distribution of quadratic",
     +      "-residual variances QR(i,j)/R(i,jj)")')
          WRITE(K,'(4X,"found here, shown as percent of regressions ",
     +      "(totalling ",A," after"/4X,"omission of i=j and R<",A3,
     +      " cases) in each tenth of the unit interval:")')
     +      CF(:JF(NT)), CLN(TT,3,2)
          WRITE(K,'(/7X,"% in interval  ",10(A4,""))')
     +      (CLN(GET(I),4,3),I=1,10)
          WRITE(K,'(3X,16(""),"",10(""),"Ŀ")')
          WRITE(K,'(3X,A," boundaries  0",9A5,A6,"")')
     +      F1(5*M-4:5*M), (CLN(I/10.,5,1),I=1,9), CLN(1.0,6,1)
C         F1 = 'R-rQR/R  '          ! 1-5, 6-10 => F1(5*M-4:5*M)
        ENDDO KLOOP

C    The QR distribution of quadratic-residual variances R(i,jj)-r(i,j)
C    found here, shown as percent of regressions (totalling xxxxx after
C    omission of i=j and R<.xxx cases) in each tenth of the unit interval:

C       % in interval   xx..xxxxx.x xx. xx. xx. xx. xx. xx. xx.
C   Ŀ
C   R-r boundaries  0   .1   .2   .3   .4   .5   .6   .7   .8   .9   1.0
C   QR/R boundaries  0   .1   .2   .3   .4   .5   .6   .7   .8   .9   1.0

        WRITE(6,'(/8X,"Indices <i,j> for the P% of pairwise quad-regr",
     +    "essions having the"/8X,"largest Q",A," values will be list",
     +    "ed for your choice of P or,"/8X,"alternatively, your choic",
     +    "e of the raw count corresponding to P.")') F4(10+M:10+M)
443     WRITE(6,'(/4X,"P is now ",A4,"%, which will print the ",A,
     +    " largest values.  Hit RETURN if OK."/4X,"Otherwise, ente",
     +    "r either another percentage (which can include a decimal"/
     +    4X,"refinement) or a raw count immediately preceded by a ",
     +    "minus sign."/)') CLN(P,4,2), CF(:JF(NP))
        CALL SCANB(J,1,'R',5,CH8,L,WA,WB)
        IF(J<0) GOTO 443
        IF(J>0) THEN
          READ(2,*) P
          IF(P<0.) THEN
            NP = MAX(0,MIN(NT,NINT(ABS(P))))
            P = NP*100./NT
          ELSE
444         IF(P>100.) P = P/10
            IF(P>100.) GOTO 444
            NP = MAX(0,NINT(P*NT/100.))
          END IF
          GOTO 443
        END IF
        IF(NP==0) CYCLE
        WRITE(8,'(/" High-End Q",A," Listing: In each ""(i,j;q)"" her",
     +    "e, q is Q",A,"-value ",A," for the quadratic regression of",
     +    " Zi on Zj.")') F4(10+M:10+M), F4(10+M:10+M), F4(3-M:2+4*M)
        WRITE(8,'(1000(7("  (",A,", ",A,"; ",A4,")",:)/))')
     +    (CF(:JF(KD2(LIST(I)))), CF(:JF(KD3(LIST(I)))),
     +    CLN(.001*KD1(LIST(I)),4,3),I=1,NP)
      ENDDO MLOOP

C In each "(i,j; q)" listing, q is QR-value R-r for the quadratic regression of data variable i on data variable j.
C xxx,xxx (.xxx); xxx,xxx (.xxx); xxx,xxx (.xxx); xxx,xxx (.xxx); xxx,xxx (.xxx); xxx,xxx (.xxx); xxx,xxx (.xxx); xxx,xxx (.xxx);

500   WRITE(6,'(//" Correlations from this score distribution ",
     + "have been sent to unformatted file"/" INMODA for factoring",
     + " by MODA, as well as to ASCII storage file ",A,","/
     + " with Code No. ",A,".  Additional summary statistics ",
     + "are in ",A,"."/)') F2(:LN), CF(:JF(KODE)) , F3(:LN)
      WRITE(8,'("")')
      STOP
      END SUBROUTINE
C
      SUBROUTINE DEVN(NY,A,B,SIG,AV,BIG)
C For each entry in A, this returns in B the mag of its SIG distance from AV
      REAL(8) SIG(*)
      REAL A(*), B(*), AV(*)
      BIG = 0.
      DO I = 1,NY
        B(I) = 0.
        IF(SIG(I)<1.E-35) CYCLE
        B(I) = ABS((A(I)-AV(I))/SIG(I))
        BIG = AMAX1(BIG,B(I))
      END DO
      END SUBROUTINE
C
      FUNCTION DIGT(A)
C This returns integer 1 if argument A is a digit, or 0 if it is not.
C This can be replaced by line function DIGT(CH) = (ICHAR(CH)-47)*(58-ICHAR(CH));
C it returns positive integer just if CH is a digit
      CHARACTER A
      INTEGER DIGT
      DIGT = 0
      IF(ICHAR(A)>=48 .AND. ICHAR(A)<=57) DIGT = 1
      END FUNCTION
C
      SUBROUTINE DIST(N,NT,LST,P)
C Distributed LST entries are 1st three digits of decimal followed by 6 other
C digits.  The percent of entries whose first decimal rounds up with point
C omitted to I is returned in P(I).  NT is the total number of non-omitted
C entries).
      INTEGER LST(*)
      REAL P(10)
      DO I = 1,10
        P(I) = 0.
      END DO
      NT = 0
C      B = 0.
      DO I = 1,N
        IF(LST(I)<0) GOTO 30  ! Omit the negative-flagged terms at end of SORTed list
        J = LST(I)/10**6    ! Entry is 3 decimal digits followed by 6 more digits
        NT = NT+1
C        B = AMAX1(B,J/1000.)
        K = J/100+1   ! Term's dist. category is its 1st decimal digit plus 1.
        P(K) = P(K)+1.
      END DO
30    DO I = 1,10
        P(I) = 100.*P(I)/NT
      END DO
      END SUBROUTINE
C
      SUBROUTINE FNDEND(K,NB)
C Positions file K for writing after line Last-minus-NB; Lahey, Microsoft,
C and Sun UNIX compilers all require NB  0.  To READ line Last-minus-NB,
C replace NB with NB+1.
C **** In particular, use NB=0 to append to end, but NB=1 to READ last line.
      BACKSPACE K
10    READ(K,'()',END=20)
      GOTO 10
20    DO I = 1,NB+1
        BACKSPACE K
      END DO
      END SUBROUTINE
C
      SUBROUTINE FNDLOM(K,LOM)
C This finds number LOM of lines in file K before first starting with a number.
      CHARACTER CH*20
      REWIND K
      LOM = -1
10    LOM = LOM+1
      READ(K,'(A)',END=30) CH
      CALL LAST(L,CH,20)
      I = 1
      IF(CH(1:1)=='-' .OR. CH(1:1)=='.') I = 2
      IF(CH(1:2)=='-.') I = 3
      L = ICHAR(CH(I:I))
      IF(L<48 .OR. L>57) GOTO 10
      BACKSPACE K
      RETURN
30    LOM = 1
      REWIND K
      END SUBROUTINE
C
      SUBROUTINE GETLM(LM,NX,PIK,IDENT)
C Find length LM of the longest name among the NX items picked from namelist
C IDENT by selector list PIK.
      CHARACTER(8) IDENT(*)
      INTEGER PIK(*)
      LM = 0
      DO I = 1,NX
        CALL LAST(N,IDENT(PIK(I)),8)
        IF(N>0) LM = MAX(LM,N)
      END DO
      END SUBROUTINE

      SUBROUTINE GETREC(NX,KFILE,CHS,CHB,LW,NR,NL)
C Read scores from NX consecutive fields starting with current line in file
C KFILE; code nonnumeric entries as CHB, and write scores as chars in output
C list CHS;  NR-1 is number of records previously read; LST counts fields in
C each line of record and tests for consistency over cases. NR is sequential
C record No., updated in calling program. LW is max fieldwidth.  NL returns
C number of lines in record, or 0 for end of file.

C *** See GETREC code in PREFIX.FOR for allowing irregularly spaced records

      PARAMETER (MCH=16000)
      CHARACTER(MCH) WORD, WA, WB
      CHARACTER(10) CHS(*), CHB*(*), CF*12
      INTEGER DIGT
      INTEGER LST(50)  ! Get info re lines in record; compare across records
      COMMON /BL2/ LONG
      COMMON /CF/ CF
      DATA OK/0./  ! OK>0 allows records to have different line lengths
      NS = 0      ! NS is running number of fields read from this record
      NL = 0      ! Line in record being processed
      LW = 0      ! Max fieldwidth found in line
10    READ(KFILE,'(A)',END=40) WORD  ! Start next line of record
      CALL LAST(LL,WORD,LONG)
      IF(LL==0) GOTO 10  ! Skip line if blank
      NL = NL+1  ! Next line in record
C Parse WORD into fields and identify contents.
      CALL SCANB(J,0,'R',-1,WORD,K2,WA,WB) ! Find end K2 of any initial char string
20    K1 = K2+1  ! K1 is start of new field
      NOTE = 0   ! Flag whether scanning field has found nonblank cells
21    K2 = K2+1  ! Examine next cell in current field
      NN = ICHAR(WORD(K2:K2))
      ND2 = DIGT(WORD(K2+1:K2+1)); NN2 = ICHAR(WORD(K2+1:K2+1))
      IF(NOTE==0 .AND. NN<=32) K1 = K1+1 ! Blank OK for left delimiter
      IF(NOTE==0 .AND. NN<=32) GOTO 21   ! Still drawing blanks at start
      IF((NN>32.AND.NN<=42) .OR. NN==47 .OR. NN>57) NOTE = -1 ! Bad char
C Starting + or - must be followed by . or a digit; . must be followed by a digit
      IF(NOTE==0 .AND. NN==46 .AND. ND2==0) NOTE = -1
      IF(NOTE==0.AND.(NN==43.OR.NN==45).AND.ND2==0.AND.NN2/=46) NOTE=-1

cc      IF(NOTE==0.AND.(NN==46.OR.NN==43.OR.NN==45).AND.ND2==0)
cc     +  NOTE = -1 ! No go if +, -, or . at start is not followed by digit

      IF(NOTE>=0 .AND. NN>=48 .AND. NN<=57) NOTE = 1  ! Digit in field, no prev bad chars
      IF(NN/=44 .AND. NN/=58 .AND. NN/=59 .AND. NN>32) GOTO 21 ! Accept ,:; as delimiters
      NS = NS+1  ! Righthand field delimiter found; now read datum from this field
CC      CHS(NS) = WORD(K1:K2-1)
      CHS(NS) = WORD(K1:MAX(K2-1,K1+1)) ! Let adjacent delimiters demark missing score
      READ(CHS(NS),*,ERR=25,END=25) F  ! Tests whether field can be read
      GOTO 30
25    IF(NR>0) CALL BADLST(CHS(NS),NR,LW)
      CHS(NS) = CHB
30    LW = MAX(LW,K2-K1)   ! Largest fieldwidth in this record
C Pick out next field if NX entries have not yet been read
      IF(NS<NX .AND. K2<LL) GOTO 20  ! Not yet done reading line
      IF(NR<=1) LST(NL) = NS  ! Initialize LST
      NSS = LST(NL)
      IF(NS/=NSS .AND. OK==0) THEN  ! Line scan is done; check number of reads
        WORD(:6) = ' less '
        N = ABS(NS-NSS)
        IF(NS>NSS) WORD(:6) = ' more '
        DO K = 6,8,2
         WRITE(K,'(/" WARNING: Line ",A," of record ",A," contains ",A,
     +     " recognizable fields,"/10X,2A,"than in line ",A," of the",
     +     " records read previously.")') CF(:JF(NL)), CF(:JF(NR)),
     +     CF(:JF(NS)), CF(:JF(N)), WORD(:6), CF(:JF(NL))
         WRITE(6,'(" This may not be a problem if spacing in these re",
     +     "cords is irregular; if so,"/" enter anything to continue.",
     +     "  Otherwise, hit RETURN to troubleshoot.")')
         READ(5,'(A)') WORD(:1); IF(WORD(:1)/=' ') OK = 1
         IF(OK/=0) GOTO 32
         IF(NS>NSS) WRITE(K,'(8X,"Try to diagnose the problem by stu",
     +     "dying the datafile in a"/8X,"text editor; it may be corr",
     +     "upt.")')
         IF(NS<NSS) WRITE(K,'(8X,"This may be due to inadequate sepa",
     +     "ration between adjacent"/8X,"fields or possibly to a bla",
     +     "nk field not bracketed by"/8X,"delimiters. If so, you ma",
     +     "y be able to read this file by"/8X,"entering a field-spe",
     +     "cifying format declaration (Method 2).")')
        END DO
        WRITE(6,'(/" The LOG-file reports how this line has been ",
     +    "read.")')
        WRITE(8,'(/" The fields as read from this record are"/
     +    50(8(:," [",A,"]")/))') (CHS(I),I=1,NS)
        STOP
      END IF
32    IF(NS<NX) GOTO 10  ! Read next line of record
40    LST(NL+1) = 0
      END SUBROUTINE
C
      SUBROUTINE ISORT(N,LST)
C Sort LST integers into descending (or ascending) order
      INTEGER LST(*)
10    DO J = 2,N
        L = LST(J)
        DO 11 I = J-1,1,-1
C         IF(LST(I)<=L) GOTO 12    ! Increasing order
         IF(LST(I)>=L) GOTO 12    ! Decreasing order
11       LST(I+1) = LST(I)
        I = 0
12      LST(I+1) = L
      END DO
      END SUBROUTINE
C
      SUBROUTINE LAST(L,WORD,M)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as L. If the string is empty, LAST is returned as 0.
      CHARACTER WORD*(*)
      WORD(:M) = ADJUSTL(WORD(:M))
      L = LEN_TRIM(WORD(:M))
      END SUBROUTINE
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
      LOGICAL PRM, QY
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP
      CHARACTER E, EXT*3, CH5*5   ! <<<  Special characters as needed
      INTEGER DIGT
      WD = GET
      CALL LAST(M,WD,40)
      LL = 1
5     LL = LL+1; IF(LL<M) GOTO 5
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(WORD(:1)==' ' .OR. WORD(:1)=='.') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
C       Filter out lines other than filenames
      CALL LAST(L,WORD,14)
      DO I = 1,L
        IF(WORD(I:I)=='('.OR.WORD(I:I)==')') GOTO 10
        IF(WORD(I:I)=='!') GOTO 10
      END DO
      L = ICHAR(WORD(:1))
      IF(L>90 .OR. L<65) GOTO 10
C       Screen out UNIX files with lower-case names
      EXT = WORD(10:12)
      E = WORD(10:10)
      CH5 = WORD(:5)
      IF(EXT=='BAT'.OR.EXT=='FOR'.OR.EXT=='EXE'.OR.EXT=='ZIP'
     + .OR.EXT=='SEE'.OR.EXT=='LOG'.OR.EXT=='OBJ'.OR.EXT=='COV'
     + .OR.EXT=='MAP'.OR.EXT=='LST'.OR.EXT=='FIG'.OR.EXT=='   '
     + .OR.EXT=='BAK'.OR.EXT=='PRO'.OR.EXT=='NAM'.OR.CH5(:3)==
     + 'SEE'.OR.CH5=='PRNTR'.OR.CH5=='HYBUF'.OR.CH5=='INMOD'.OR.
     + CH5(:3)=='ZZZ'.OR.WORD(14:15)=='<D'.OR.WORD(7:7)=='&'.OR.
     + CH5=='LASTF'.OR.CH5=='BOOTD'.OR.CH5(:4)=='LUMP'.OR.CH5==
     + 'BLOKR'.OR.E=='#') GOTO 10
      IF((E=='B'.OR.E=='M'.OR.E=='K'.OR.E=='H'.OR.E=='C'.OR.
     +  E=='F'.OR.E=='W') .AND. DIGT(EXT(2:2))==1) GOTO 10
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4) .AND. NAME(I)(L+5:L+5)==' ')
     +    GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NL)
      IF(NL>0) WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      CALL LAST(L1,NAM1,LEN(NAM1)); CALL LAST(L2,NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      CALL LAST(L1,WRD1,LEN(WRD1)); CALL LAST(L2,WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A number terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION
C
      FUNCTION MATCH(X,Y)
C Return T if real A essentially matches real B, otherwise return F
      LOGICAL MATCH
      MATCH = .FALSE.
      IF(ABS(X-Y)/MAX(ABS(X),ABS(Y),.0001)<=.0001) MATCH = .TRUE.
      END FUNCTION

      SUBROUTINE NAME1(F1,F2,M,L)
C This receives a filename in F1 (presumed to start in position 1), solves
C for <base> to be the part of F1 prior to '.' up to M characters, scans the
C subdirectory for the lowest i=1,2,...,99 such that file <base>.Di does not
C already exist, returns <base>.Di in F1(:12), <base>.LOG in F2, and the end
C position of the latter in L.
      LOGICAL QY
      CHARACTER F1*(*), F2*(*), DIGIT
      DIGIT(I) = CHAR(48+I)
      L = 0
10    L = L+1
      IF(L<=M .AND. F1(L:L)/=' ' .AND. F1(L:L)/='.') GOTO 10
      DO I = L+2,12
        F1(I:I) = ' '
      END DO
      F2 = F1
      F1(L:L+1) = '.D'
      F2(L:L+3) = '.LOG'
      L = L+2
      I = 0
20    I = I+1
      IF(I<=9) F1(L:L) = DIGIT(I)
      IF(I>9) F1(L:L+1) = DIGIT(I/10)//DIGIT(MOD(I,10))
      INQUIRE(FILE=F1,EXIST=QY)
      IF(QY .AND. I<99) GOTO 20
      IF(QY .AND. I==99) F1(L:L+1) = DIGIT(0)//DIGIT(0)
      L = L+1
      END SUBROUTINE
C
      SUBROUTINE NAME2(F1,M,EXT,L)
C This receives a filename in F1 (presumed to start in position 1), solves for
C <base> to be the part of F1 prior to '.' up to M characters, scans the sub-
C directory for the lowest i=1,2,...,9 such that file <base>i.EXT does not
C already exist, and returns <base>i.EXT in F1(:12), along with its end
C position L.
      LOGICAL QY
      CHARACTER F1*(*), EXT*(*), DIGIT
      DIGIT(I) = CHAR(48+I)
      L = 0
10    L = L+1
      IF(L<=M .AND. F1(L:L)/=' ' .AND. F1(L:L)/='.') GOTO 10
      F1(L:L+4) = '0.'//EXT(:3)
      DO I = L+5,12
        F1(I:I) = ' '
      END DO
      I = 0
20    I = I+1
      F1(L:L) = DIGIT(I)
      INQUIRE(FILE=F1,EXIST=QY)
      IF(QY .AND. I<9) GOTO 20
      IF(QY .AND. I==9) F1(L:L) = DIGIT(0)
      L = L+4
      END SUBROUTINE
C
      SUBROUTINE NSEQ(NS,N1,N2,LBL,LC,IDENT,IER)
C This allows specifying a sequence in namelist IDENT, starting at position
C |NS|, by naming the first <LBL>N1 and the last <LBL>N2 for integers N1 < N2.
C LC is LBL's content length. Negative NS calls early RETURN.  Otherwise,
C NS is repositioned at the last name specified.
      CHARACTER(8) IDENT(*), LBL, CF*12, BAK, CH1*1
      COMMON /CF/ CF
      IER = 0
      L2 = JF(N2)
      N = IABS(NS)-1
      BAK = IDENT(N+1)
      LM = 1
      DO I = N1,N2
        N = N+1
        IDENT(N) = LBL(:MIN(LC,8-L2))//CF(:JF(I))
        LM = MAX(LM,LC+JF(I))
      END DO
      IF(NS<0) RETURN
      NS = IABS(NS)
      WRITE(6,'(/" The names provisionally assigned to variables ",A,
     +  " through ",A," (" ,A," in all) are",20(/4X,9(1X,A)))')
     + CF(:JF(NS)), CF(:JF(N)), CF(:JF(N-NS+1)), (IDENT(I)(:LM),I=NS,N)
      KW = 0
      DO I = 1,NS-1
        IF(LBL(:LC)==IDENT(I)(:LC) .AND. ICHAR(IDENT(I)(LC+1:LC+1)).
     +    LE.64) KW = 1
      END DO
      IF(KW>0) WRITE(6,'(/" WARNING. Label ",A," has also been ",
     +  "used previously in your name list.")') LBL(:LC)
      WRITE(6,'(/" Hit RETURN if OK, or enter anything to try ag",
     +  "ain.")')
      READ(5,'(A)') CH1
      IF(CH1==' ') THEN
        NS = N
        RETURN
      END IF
      IER = 1
      IDENT(NS) = BAK
      DO I = NS+1,N
        IDENT(I) = '??      '
      END DO
      END SUBROUTINE
C
      SUBROUTINE OMIT(K,NV,BLANK,GET,KOV)
C This replaces missing scores in GET by zero while counting in KOV(LO(I,J))
C the number of products summed in Cov(I,J) that are from zeroed missing data.
C K is returned as 1 if GET contains a missing datum, and as 0 otherwise.
      LOGICAL MATCH
      INTEGER(2) KOV(*)
      REAL GET(*)
      LO(I,J) = J*(J-1)/2 + I
      IF(BLANK<-9998.) RETURN
      K = 0
      ILOOP: DO I = 1,NV
        IF(.NOT.MATCH(GET(I),BLANK)) CYCLE ILOOP
C        If I isn't missing, KOV(I,J) for J>I will be increased just if J is missing.
        K = 1
        GET(I) = 0.
        KOV(LO(I,I)) = KOV(LO(I,I)) + 1
        DO J = I+1,NV
          IF(.NOT.MATCH(GET(J),BLANK)) KOV(LO(I,J)) = KOV(LO(I,J)) + 1
        END DO
C          KOV(I,J) is increased just if either I or J is missing.
C          Don't count for J>I if J-score isn't blank because it will be counted later.
        DO J = 1,I-1
          KOV(LO(J,I)) = KOV(LO(J,I)) + 1
        END DO
      ENDDO ILOOP
      END SUBROUTINE
C
      SUBROUTINE PARS(K,L,IDENT,IDEN2)
C Get structure of variables' names from K to L
      CHARACTER(8) IDENT(*), WA, WB*9
      INTEGER IDEN2(2,*)
      DO I = K,L
        CALL SCANB(J,0,'I',-1,IDENT(I),IDEN2(1,I),WA,WB)
        IDEN2(2,I) = 0
        IF(J>0) READ(2,*) IDEN2(2,I)
      END DO
      END SUBROUTINE
C                                          ! Ignore compiler warning re type change
      SUBROUTINE QVRT(NY,NQ,COVQ,ITMP,MSC) ! COVQ and ITMP are the same location
C       Rescale reals COVQ as integers ITMP and return in MSC ***
      CHARACTER(12) CF
      INTEGER ITMP(*), MSC(*)
      REAL COVQ(*)
      COMMON /CF/ CF
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      LOK(I,J) = NY*(J-1) + I   ! NY is the number of vars picked for Covar comp
      DO J = 1,NQ
        DO I = 1,J
          ITMP(LO(I,J)) = NINT(1000*COVQ(LO(I,J))) ! Convert in place to Integers
        END DO
      END DO
      DO J = 1,NY   ! Round R and r to 3 decimals and drop point.  Then
        J2 = NY+J
        DO I = 1,NY  ! put R in digits 5-8, and r in digits 1-4, of ITMP.
          IF(ITMP(LO(I,J2))<0.) THEN  ! I=J case already made negative
            ITMP(LO(I,J2)) = -100000.
          ELSE
            ITMP(LO(I,J2)) = 10000*ITMP(LO(I,J2)) + ITMP(LOC(I,J))
          END IF
        END DO
      END DO
      DO J = 1,NY   ! Shift ITMP to MSC (formerly bottom of COVQ space)
        DO I = 1,NY
          MSC(LOK(I,J)) = ITMP(LO(I,NY+J))
C           MSC(i,j) gets ITMP rectangle (R before r; with R<T,i=j cases negative)
        END DO
      END DO
      END SUBROUTINE
C
      SUBROUTINE RECOVR(STAR,FMA,NY,ID,CHS,CHB,LW,NR,WORD,JMP)
C Read the next nonblank line in File 3
      LOGICAL STAR
      CHARACTER(10) CHS(0:*), FMA*80, WORD*80, CLN*8, CHB*8
      IF(STAR) CALL GETREC(NY+ID,3,CHS(1-ID),CHB,LW,NR,JMP)
      IF(STAR) GOTO 15
      JMP = 1
10    READ(3,'(A)',END=20) WORD
      CALL LAST(L,WORD,80)  ! Check whether blank
      IF(L==0) GOTO 10
      BACKSPACE 3
      READ(3,FMA,END=20) (CHS(I),I=1-ID,NY)
15    IF(ID==0) CHS(0) = CLN(NR*1.,JF(LW),11)//'               '
      RETURN
20    JMP = 0
      END SUBROUTINE
C
      SUBROUTINE POSN(KF,L,IER)
C Position file KF to read line L+1. If L exceeds file length, reset to 0.
C If L is less than 0, count the number of file lines and return in IER.
      CHARACTER(12) CF
      COMMON /CF/ CF
      IER = 0
      REWIND KF
      IF(L==0) RETURN
      J = 0
10    J = J+1
      READ(KF,'()',END=20)
      IF(J==L) RETURN
      GOTO 10
20    IER = J-1
      IF(L>0) WRITE(6,'(" This file contains only ",A," lines.",
     +  "  Try again.")') CF(:JF(J-1))
      REWIND KF
      END SUBROUTINE
C
      SUBROUTINE RANLST(NS,NT,LTAG,MXX)
C This randomly selects NS of integers 1 to NT with replacement and returns
C the selection in LTAG. LTAG(i) is the number of times item i has been
C selected.  (MXX is maximum number of repetitions not really needed.)
C The random generator must have been seeded previously.
      INTEGER LTAG(*)
      DO I = 1,NT
        LTAG(I) = 0
      END DO
C Make selection WITH replacement
50    DO I = 1,NS
        K = MIN(NT,1+INT(NT*RANDY()))
C       K = MIN(NT,1+INT(NT*RAN2()))
        LTAG(K) = LTAG(K)+1
      END DO
      MXX = 0
      DO I = 1,NT
        MXX = MAX(MXX,LTAG(I))
      END DO
      END SUBROUTINE

      SUBROUTINE RECSIZ(LONG,NTST,KP,KF)
C Starting at current position of file KF, return in LONG the length of longest
C line over the next NTST and reposition file at line KP
      PARAMETER (MCH=16000)
      CHARACTER (LEN=MCH) :: WORD
      LONG = 1
      L0 = MCH
      DO J = 1,NTST
        READ(KF,'(A)',END=20) WORD
        CALL LAST(L,WORD,MCH)
        IF(L>0) LONG = MAX(LONG,L)
        L0 = MIN(L0,L)
      END DO
20    CALL POSN(KF,KP,IER)
      LONG = MIN(MCH,LONG+(LONG-L0)*10+MAX(10,LONG/5))
C       ! Add plenty of wiggle room just in case
      END SUBROUTINE
C
      FUNCTION RJUST(WORD,JW)
C This returns the right-justification of string WORD in field width JW
      CHARACTER WORD*(*), RJUST*(*)
      L = LEN(WORD)
10    IF(WORD(L:L)/=' ') GOTO 20
      L = L-1
      IF(L>0) GOTO 10
20    IF(L==JW .OR. L==0) THEN
        RJUST(:JW) = WORD(:JW)
      ELSE
        RJUST(:JW) = WORD(L+1:JW)//WORD(:L)
      END IF
      END FUNCTION
C
      SUBROUTINE SCANB(NL,NS,SEQ,KFILE,CH,KK,WA,WB)
C This reads a string in I/O unit KFILE, cleans it for list-directed reading
C of the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.)  NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number string
C returned in File 2 is non-null but does not match SEQ, and gives the total
C count of numbers in the returned string otherwise.  WA and WB are workspaces.
C ***** If SEQ is "B", NL returns 0 if the input line is blank, and
C       returns -1 otherwise.
C ***** In original SCANB, CH returns the input string's first unbroken sequence
C       up to ABS(KK) terms while deleting any numbers in this if KK < 0. *** Only used in RESCORE
C ##### In this augmentation, KFILE  0 calls CH to return the initial letter
C       string in CH while KK returns its length.  If KFILE < 0, CH is read as
C       an input string while KK returns length of its alphabetic start.
ccc             Line ##### info was true of old HYDATA
c Cases: (1) Ordinary read from KFILE, but fill CH with start of input and
c              return length of alphabetic start in KK ( KFILE > 0 )
c        (2) Read CH as input, continue as in Case 1 ( KFILE < 0 )
c        (3) Read KFILE, move 1st KK chars (with deletion at source) to
c              output CH ( KFILE > 0, negative input KK; only in RESCORE )
C WARNING: KK must be a variable in Cases 1,2.  Case 3 occurs only in RESCORE

      CHARACTER AA, SEQ*(*), WA*(*), WB*(*), CH*(*)
      LCH = LEN(CH); LA = LEN(WA)
      IF(KFILE>=0) THEN
        READ(KFILE,'(A)') WA
        CALL LAST(NL,WA,LA); N = MIN(LCH,LA)
        CH(:N) = WA(:N)
      ELSE
        CALL LAST(NL,CH,LCH)
        IF(NL>0) WA(:NL) = CH
      END IF
      IF(NL==0) GOTO 70
      IF(SEQ(1:1)=='B') NL = -1         !  Original SCAN
      IF(SEQ(1:1)=='B') GOTO 70         !     "       "
      IF(KK<0) THEN   ! Case 3
        DO I = 1,ABS(KK)
          CH(I:I) = WA(I:I); WA(I:I) = ' '
        END DO     !  Case 3 now complete except for numbers read
        GOTO 15
      END IF
      KK = 0   ! Cases 1,2: KK gets length of the initial non-numeric sequence
11    N = ICHAR(WA(KK+1:KK+1))
      IF(N>=97) N = N-32    ! Capitalize lowercase letters
      IF(N<35 .OR. N>90 .OR. N>38.AND.N<60) GOTO 15
C   Accept characters in ranges 35-38, 60-90, but watch out for key reassignents
      KK = KK+1
      IF(KK<=LCH) CH(KK:KK) = CHAR(N)
      IF(KK<NL) GOTO 11   ! Last occurrence of KK
15    WB(NL+1:NL+1) = ' '    ! Crashes if LEN(WB)  LEN(WA) and NL=LN
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +    WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
       ELSE IF (WA(I:I) /= '0') THEN
         IP = 0
       END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1   ! Will crash if WB isn't longer than WA
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF(WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) GOTO 70
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     +  "number sequence requested. Try again.")')
      GOTO 70
60    REWIND 2
      WRITE(2,'(A)') WB(:NL)
      NL = NN
70    REWIND 2
      END SUBROUTINE
C
      SUBROUTINE SEENAM(LM,NX,PIK,IDENT,LS,LW,KF)
C This writes to file KF the NX names picked from IDENT by selector list PIK.
C LM is max namelength.  LS is number of lines to leave at top of screen. Omit
C ending Wait when KF=6 if less than LW lines have been shown since last pause.
      CHARACTER(8) IDENT(*), FMT*30, CH2*2
      INTEGER PIK(*)
      CALL GETLM(LM,NX,PIK,IDENT)
      MM = MAX(3,LM)
      LL = 79/(6+MM)   ! Number of fields per line
      LB = (23-LS)*LL       ! Number of fields in 23-LS lines
      NS = MIN(1,MOD(79,6+LM)/2)  ! Number of spaces starting display line
      NK = 0
      CH2 = CHAR(48+NS)//CHAR(48+LL)
      FMT = '(80('//CH2(1:1)//'X,'//CH2(2:2)//'(I4,": ",A),:/))'
10    NL = (NX-NK+LL-1)/LL   ! Number of display lines left to show
      WRITE(KF,FMT) (PIK(I),IDENT(PIK(I))(:MM),I=NK+1,NK+MIN(LB,NX-NK))
      NK = NK+LB  ! Number of full-line fields displayed
      IF(KF==6) THEN
        IF(NK<NX .OR. NL>LW) CALL WAIT(0)
C       NL: At end, lines printed either after Call or after last internal Wait
      END IF
      LB = 23*LL  ! Hereafter use full screen
      IF(NK>=NX) RETURN
      GOTO 10
      END SUBROUTINE
C
      SUBROUTINE SETFMT(FMT,LL,F1,FMB,NY,ID,C11,C12,C21,C22,BAR,LIN)
C This sets a READ-format in FMT, checking for acceptability.
      CHARACTER(80) FMT, FMB, WORD, CH*1, CLN*8, F1*12
      CHARACTER C11,C12,C21,C22, BAR,LIN
      INTEGER DIGT
      CALL SYSTEM('cls')
      CALL LAST(L0,FMB,80); CALL LAST(LF1,F1,12)  ! FMB sh arrive blank (L0=0)
      WRITE(6,'(4X,74A)') C11, (LIN,I=1,72), C12  ! if not from LASTFORM
      WRITE(6,'(4X,A,2X,"This datafile''s score records can be r",
     +  "ead in two ways:",16X,A)') BAR, BAR
      L = JF(NY); WORD(:L) = CLN(NY*1.,L,11)  !  Don't bother to install CF
      WRITE(6,'(4X,A,72X,A)') BAR, BAR
      WRITE(6,'(4X,A,2X,"1. If all entries in each record are separat",
     +  "ed by blanks and/or",7X,A/4X,A,5X,"commas, and none of the f",
     +  "irst ",A," scores is to be omitted,",6X,A,A/4X,A,5X,"you can",
     +  " simply accept the default option designated "" * "".",9X,A)')
     +  (BAR,I=1,3), WORD(:L), '      '(:6-L), (BAR,I=1,3)
      WRITE(6,'(4X,A,72X,A)') BAR, BAR
      WRITE(6,'(4X,A,2X,"2. If some scores in a record are not separ",
     +  "ated by a space or comma,",2X,A/4X,A,5X,"or if any in the r",
     +  "ecord prior to the last score wanted is to be",4X,A/4X,A,5X,
     +  "omitted, you must enter the FORTRAN I-code or F-code READ fo",
     +  "rmat",3X,A/4X,A,5X,"that selects the fields to be read in ea",
     +  "ch record.  (Note: I-code  ",A/4X,A,5X,"will also read real ",
     +  "numbers here if the fields are correct.)",7X,A)') (BAR,I=1,10)
      IF(ID==1) WRITE(6,'(4X,A,5X,"The format must begin with a field",
     +  " for the subject''s ID No.",8X,A)') BAR, BAR
      WRITE(6,'(4X,A,72X,A)') BAR, BAR
      WRITE(6,'(4X,A,2X,"WARNING: If you want to omit some entries wh",
     +  "en each record is a block ",A/4X,A,5X,"of lines, the last it",
     +  "em read under Method 1 must be in the block''s ",A/4X,A,5X,
     +  "last line.  And Method 2 needs your format to include a li",
     +  "ne-feed  ",A/4X,A,5X,"slash wherever you want to skip the ",
     +  "last entry in a block.",9X,A)') (BAR,I=1,8)
      WRITE(6,'(4X,75A)') C21, (LIN,I=1,72), C22

C   This datafile's score records can be read in two ways:
C     1. If all entries in each record are separated by blanks and/or
C          commas, and none of the first xxx scores are to be omitted,
C          you can simply accept the default option designated " * ".
C     2. If some scores in a record are not separated by a space or comma,
C          or if any in the record prior to the last score wanted is to be
C          omitted, you must enter the FORTRAN I-code or F-code READ format
C          that selects the fields to be read in each record.  (Note: I-code
C          will also read real numbers here if the fields are correct.)
C [If ID=1] This format must begin with a field for the subject's ID No.

C   |  WARNING:  If you want to omit some entries when each record is a block |
C   |      of lines, the last item read under Method 1 must be in the block's |
C   |      last line.  And Method 2 needs your format to include a line-feed  |
C   |      slash wherever you want to skip the last entry in a block.         |

C    To try reading this datafile the easy way (format *), hit RETURN.
C    Otherwise, enter the FORTRAN format that will pick out the scores wanted
C    from a single record in this file, including line-advance slashes needed
C    if the record is a block of lines.

      IF(L0>0) THEN  ! L0 is length of FMB
        WRITE(6,'(4X," Datafile ",A," has previously been read by fo",
     +    "rmat"/18X,A/4X," If this is still appropriate, hit RETURN",
     +    ".  Otherwise, enter the correct"/4X," Read-format includi",
     +    "ng line-advance slashes if needed.  (If your entry"/4X,
     +    " contains syntax errors, you will be prompted to correct",
     +    " them.)"/)') F1(:LF1),FMB(:L0)
        READ(5,'(A80)') WORD; CALL LAST(L1,WORD,80)
        IF(L1==0) THEN; FMT = FMB; LL = L0; END IF
        IF(L1>0) THEN; FMT = WORD; LL = L1; END IF
      ELSE
        WRITE(6,'(/4X,"To try reading this datafile the easy way (fo",
     +    "rmat *), hit RETURN."/4X,"Otherwise, enter the FORTRAN fo",
     +    "rmat that will pick out the scores wanted"/4X,"from a sin",
     +    "gle record in this file, including line-advance slashes ",
     +    "needed if the record is a block of lines."/)')
        READ(5,'(A80)') WORD; CALL LAST(LL,FMT,80)
        IF(LL==0) FMT = '*'//' '
      END IF

10    CALL LAST(LL,FMT,80)
      IF(FMT(:1)=='*') RETURN
      IER = 0; KI = 0; KF = 0; KP = 0; KD = 0; IK = 0
C       IK=2 if marked number is working, 1 if unmarked number working, else 0.
      DO J = 1,LL
        K = ICHAR(FMT(J:J))
        IF(K>=97 .AND. K<=122) FMT(J:J) = CHAR(K-32)
        CH = FMT(J:J)
        IF(CH=='*') THEN; FMT = '*'//' '; LL = 1; GOTO 50; END IF
        IF(DIGT(CH)==1) THEN
          IF(IK==0) IK = 1
        ELSE IF(CH=='X') THEN
          IF(IK/=1.OR.(FMT(J+1:J+1)/=','.AND.FMT(J+1:J+1)/=')')) GOTO 30
          IF(IK==1) IK = 0
        ELSE IF(CH=='I' .OR. CH=='F') THEN
          IF(IK==2 .OR. DIGT(FMT(J+1:J+1))==0) GOTO 30
          IF(IK<=1) IK = 2
        ELSE IF(CH=='.') THEN
          IF(DIGT(FMT(J-1:J-1))*DIGT(FMT(J+1:J+1))==0) GOTO 30
          IF(FMT(J-2:J-2)/='F' .AND. FMT(J-3:J-3)/='F') GOTO 30
        ELSE
          IF(IK==1 .AND. CH/='(') GOTO 30
          IK = 0
        END IF
        IF(CH=='I') KI = KI+1
        IF(CH=='F') KF = KF+1
        IF(CH=='.') KD = KD+1
        IF(CH=='(') KP = KP+1
        IF(CH==')') KP = KP-1
      END DO
      IF(KP/=0) WRITE(6,'(" Parentheses in your format are unbal",
     +  "anced. Try again.")')
      IF(KF/=KD) WRITE(6,'(" Your F-code contains an improper nu",
     +  "mber of periods. Try again.")')
      IF(KI+KF==0) WRITE(6,'(" You have entered no I-fields or F-",
     +  "fields. Try again.")')
      IF(KP/=0.OR. KI+KF==0 .OR.KF/=KD) IER = 1
      IF(L0>0 .AND. IER==0) RETURN  !  FMT from LASTFORM is still OK
      GOTO 45
30    CH = '^'
      WRITE(6,'(" Format is invalid at or flanking the position ",
     +  "marked:"/1X,A79/80A1)') FMT, (' ',I=1,J), CH
      WRITE(6,'(" Enter corrected format or abort run"/)')
40    IER = 1
45    READ(5,'(A80)') FMT; GOTO 10
50    WRITE(6,'(/" Your single-record READ format is now"//1X,A)')
     +  FMT(:LL)
      WRITE(6,'(/" Hit RETURN if OK, or enter correct format."//)')
      READ(5,'(A80)') WORD; CALL LAST(L1,WORD,80)
      IF(L1==0 .AND. IER==0) RETURN
      FMT = WORD
      GOTO 10
      END SUBROUTINE
C
      SUBROUTINE SETNAM(NY,NK,LOM,LM,IDENT,IDEN2,LST,CH,IER)
C This builds a list of names for NY variables saved in IDENT. NK is number
C of named variables received before possible change in NY.
      CHARACTER(8) IDENT(*), CH8, CF*12, WA*20, WB*20
      CHARACTER C11,C12,C21,C22, BAR,LIN, CH, CH3*3
      INTEGER IDEN2(2,*), LST(*)
      COMMON /CF/ CF
      DATA C11,C12,C21,C22,BAR,LIN/'','','','','',''/
      CH3 = '   '
      NK = MAX(NK,NY)
      WRITE(6,'(2X,78A)') C11, (LIN,I=1,76), C12
      WRITE(6,'(2X,A,"  After viewing the provisional name list you",
     +  " can:",26X,A)') BAR, BAR
      IF(CH==' ') WRITE(6,'(2X,A,76X,A)') BAR, BAR
      WRITE(6,'(2X,A,"  1. Enter (a) the index of one variable called",
     +  " for renaming, or (b) the",4X,A/2X,A,7X,"first and last inde",
     +  "x of a range of variables called for renaming.",4X,A/2X,A,7X,
     +  "Names in the range selected will then be presented for edit",
     +  "ing.",6X,A)') (BAR,I=1,6)
      WRITE(6,'(2X,A,"  2. Enter a letter "" V "" to name all ",A,
     +  " variables V1, V2, V3, ...",8X,A,A/2X,A,7X,"("" ? "" clears",
     +  " list.  "" V "" can also be a longer letter prefix.)",6X,A)')
     +  BAR, CF(:JF(NY)), CH3(:4-JF(NY)), BAR, BAR, BAR
      WRITE(6,'(2X,A,"  3. Enter "" > I J "" to shift the subsequence",
     +  " starting at position I",8X,A/2X,A,7X,"rightward to position",
     +  " J, creating J-I preceding blanks.",14X,A)') (BAR,I=1,4)
      WRITE(6,'(2X,A,"  4. Enter "" < J I "" to shift the subsequence",
     +  " starting at position J",8X,A/2X,A,7X,"leftward to position",
     +  " I, causing J-I preceding deletions.",13X,A)') (BAR,I=1,4)
      WRITE(6,'(2X,A,76X,A)') BAR, BAR
      WRITE(6,'(2X,A,"  Under options 3 and 4, omission of the 2nd ",
     +  "index calls a 1-position shift.",A)') BAR, BAR
      WRITE(6,'(2X,A,76X,A)') BAR, BAR
      WRITE(6,'(2X,A,"  Under option 1b, you cannot readjust single ",
     +  "entries until the full range  ",A/2X,A,"  has been listed. ",
     +  "At any point in range entry you can insert a sequence",4X,A/
     +  2X,A,"  with the same letter prefix LABEL indexed consecutive",
     +  "ly from integer",6X,A/2X,A,"  I > 0 to integer J < 1000 by e",
     +  "ntering "" LABEL I J "".  The sequence is",5X,A/2X,A,"  limi",
     +  "ted to your chosen range width. Errors in sequence entry can",
     +  " be fixed ",A/2X,A,"  immediately. CAUTION: Names must begin",
     +  " with letters, can be no more than  ",A/2X,A,"  eight charac",
     +  "ters long, and should never put a numeral before a letter.",
     +  4X,A)') (BAR,I=1,14)
      WRITE(6,'(2X,78A)') C21, (LIN,I=1,76), C22
      CALL WAIT(0)
10    CALL PARS(1,NY,IDENT,IDEN2)
14    WRITE(6,'(" The variables are now named")')
      CALL SEENAM(LM,NY,LST,IDENT,0,16,6)
      IER = 0
      WRITE(6,'(/" Hit RETURN if OK. Otherwise, enter a naming option",
     +  " of form"/3X,"1. "" I "" or "" I J ""  (range)    3. "" > I",
     +  " J "" (right shift from I to J)"/3X,"2. "" V "" (quick and ",
     +  "simple)     4. "" < J I "" (left shift from J to I)")')
      WRITE(6,'(" (For renewed option to read names from the datafi",
     +  "le, enter a negative number.)"/)')
      CALL SCANB(JJ,0,'I',5,CH8,LL,WA,WB)
      IF(JJ==0) RETURN  ! Blank input
      KK = 0
      IF(LL>0) KK = ICHAR(CH8(1:1))
      IF(KK>=97) KK = KK-32
      IF(JJ>0) THEN
        IF(JJ==1) THEN
          READ(2,*) I
          IF(I<0) THEN
            IER = 1
            CALL SHOREC(3,LOM,3,10)
            RETURN
          END IF
          IL = MIN(NY,MAX(1,I))
          IH = IL
          IF(KK==62) IH = IL+1
          IF(KK==60) IL = IH-1
        ELSE
          READ(2,*) I, J
          IL = MAX(1,MIN(I,J))
          IH = MIN(NY,MAX(I,J))
        END IF
        JD = IH-IL
      END IF
C  Clear list
      IF(KK==63) THEN
        DO I = 1,NY
          IDENT(I) = ' ??     '
      END DO
        GOTO 10
C  Execute naming option 2.
      ELSE IF(KK>=65 .AND. KK<=90 .AND. JJ<0) THEN
        CALL NSEQ(-1,1,NY,CH8,LL,IDENT,IER)
        GOTO 10
C  Execute naming option 3.
      ELSE IF(KK==62 .AND. JJ>0) THEN
        NK = MIN(NY,NK+JD)
        DO I = NK,IL,-1
          IDENT(I+JD) = IDENT(I)
        END DO
        DO I = IL,IH-1
          IDENT(I) = '???     '
        END DO
        CALL PARS(IL,NK,IDENT,IDEN2)
C  Execute naming option 4.
      ELSE IF(KK==60 .AND. JJ>0) THEN
        DO K = 1,JD
          CH8 = IDENT(IL)
          DO L = IL+1,NK
            IDENT(L-1) = IDENT(L)
          END DO
          IDENT(NK) = CH8
        END DO
        CALL PARS(IL,NK,IDENT,IDEN2)
C  Execute naming option 1.
      ELSE IF(JJ>0 .AND. KK==0) THEN
        WRITE(6,'(/" Naming variables ",A," through ",A,":"/)')
     +    CF(:JF(IL)), CF(:JF(IH))
40      WRITE(6,'(4X,"Variable ",A," is now named ",A,".  Hit RETURN",
     +    " if OK; otherwise, enter"/4X,"new name or sequence specif",
     +    "ied by form "" <label> I J "". Omission"/4X,"of J default",
     +    "s the sequence to end of the currently selected range."/)')
     +  CF(:JF(IL)), IDENT(IL)(:IDEN2(1,IL)+JF(IDEN2(2,IL)))
        CALL SCANB(J,0,'I',5,CH8,LL,WA,WB)  ! SCAN determines if CH8 is acceptable
        IF(J==0) GOTO 50  ! ^ ******** Case 2 ??? Returned LL is needed
        LL = MIN(8,LL)
        CALL CAP(CH8,LL)
        IF(LL==0) THEN
          WRITE(6,'(/" Name must begin with a letter. Try again.")')
          GOTO 40
        ELSE IF(J>0) THEN ! Take CH8 to give head of a sequence
          IF(J==1) READ(2,*) M
          IF(J==1) N = 999
          IF(J>1) READ(2,*) M, N
          N1 = MAX(1,MIN(M,N))
          N2 = MIN(N1+JD,MAX(M,N),999)
          CALL NSEQ(IL,N1,N2,CH8,LL,IDENT,IER)
C           NSEQ advances IL unless sequence change is aborted.
          JD = N2-N1
          IF(IER>0) THEN
            CALL PARS(IL,IL+JD,IDENT,IDEN2)
            GOTO 40
          END IF
        ELSE  ! Take CH8 to be single name
          IDENT(IL) = CH8(:LL)//'       '
          JD = 0
        END IF
        CALL PARS(IL-JD,IL,IDENT,IDEN2)
50      IL = IL+1
        JD = IH-IL
        IF(IL<=IH) GOTO 40
      ELSE
        WRITE(6,'(/" Your entry does not have one of the forms ",
     +    "specified. Try again.")')
        GOTO 14
      END IF
      K = 0
      DO I = 1,NY-1
        LI = IDEN2(1,I)
        DO J = I+1,NY
          LJ = IDEN2(1,J)
          IF(IDENT(I)(:LI)/=IDENT(J)(:LJ) .OR. IDEN2(2,I)/=
     +      IDEN2(2,J) .OR. IDENT(I)(:2)=='??')  CYCLE
          WRITE(6,'(/" WARNING: Variables ",A," and ",A," have be",
     +      "en assigned the same name.")') CF(:JF(I)), CF(:JF(J))
          K = 1
        END DO
      END DO
      IF(K==0) GOTO 10
C$$      WRITE(6,'(" Each variable with a duplicate name will overwrit",
C$$     + "e the previous one so named"/" when the datafile is trans",
C$$     + "cribed.  Hit RETURN if that is OK.  Otherwise,"/" enter ",
C$$     + "anything to revise names.")')
C$$      CALL SCANB(J,0,'B',5,CH3,L,WA,WB)
C$$      IF(J/=0) GOTO 10
      GOTO 10
      END SUBROUTINE
C
      SUBROUTINE SETVAR(NV,NY,PIK,PIK1)
C This returns in PIK a selection of indices 1,...,NY that starts in ascend-
C ing order with a chosen NV-termed subset thereof. PIK1 is inverse of PIK.
      CHARACTER CH8*8, WA*80, WB*80
      INTEGER PIK(*), PIK1(*)
9     NV = 0
      KOR = 0
10    WRITE(6,'(/" Enter INDICES of the variables in ",
     +  "this array whose covariances are wanted.")')
      WRITE(6,'(" (Your list length or entry method may require mo",
     +  "re than one line.  Spot"/" corrections by insertion/delet",
     +  "ion will be allowed after initial selection.)")')
      WRITE(6,'(" Entry of EXACTLY TWO integers N1,N2 followed by ",
     +  "RETURN will be read as the"/" index sequence from N1 to ",
     +  "N2. Any other number of integers entered on one"/" line ",
     +  "will be read as just the indices listed.")')
      WRITE(6,'(/"  Enter all or part of the list wanted as a spaced ",
     +  "index list.  Remember"/"  that entering just TWO indices sel",
     +  "ects all in that interval.  To abort"/"  item selection and ",
     +  "covary the full item array, enter any letter."/)')
      CALL SCANB(J,0,'I',5,CH8,L,WA,WB)
      IF(J<0) THEN
        PIK(1) = -1; NV = NY; RETURN
      ELSE IF(J==0) THEN
        GOTO 10
      END IF
20    READ(2,*) (PIK1(I),I=1,J)
      IF(J/=2 .OR. KOR>0) THEN
        DO I = 1,J
          K = PIK1(I)
          IF(K>0 .AND. K<=NY) PIK(K) = 1
          IF(K<0 .AND. IABS(K)<=NY) PIK(IABS(K)) = 0
        END DO
      ELSE
        L = MAX(1,MIN(NY,PIK1(1),PIK1(2)))
        M = MIN(NY,MAX(1,PIK1(1),PIK1(2)))
        DO I = L,M
          PIK(I) = 1
        END DO
      END IF
41    IF(KOR==0) WRITE(6,'(/" Enter more indices, or hit RETURN ",
     +  "if list is complete except maybe revisions."/)')
      IF(KOR>0) WRITE(6,'(/" Enter more changes, or hit RETURN ",
     +  "to see revised list."/)')
      CALL SCANB(J,0,'I',5,CH8,L,WA,WB)
      IF(J<0) GOTO 41
      IF(J>0) GOTO 20
      NV = 0
      NC = 0
C Order list followed by its complement. (Latter directs dump of excluded input)
      DO I = 1,NY
        IF(PIK(I)>0) THEN
          NV = NV+1
          PIK(NV) = I
        ELSE
          NC = NC+1
          PIK1(NC) = I
        END IF
      END DO
      DO I = 1,NC   ! NC = NY-NV
        PIK(NV+I) = PIK1(I)
      END DO
      DO I = 1,NY
        PIK1(PIK(I)) = I
      END DO
      DO I = 1,NY
        IF(PIK1(I)>NV) PIK1(I) = 0
      END DO
C       Variables with PIK position after NV will be dumped on input.
65    WRITE(6,'(/" Your selected variables are now indexed",
     +  50(:/20I4))') (PIK(I),I=1,NV)
      WRITE(6,'(/" Hit RETURN if OK.  Otherwise, make spot revisions",
     +  " as follows: (a) To insert"/" more items, list their indivi",
     +  "dual indices. (Interval insertion is disabled.)"/" (b) To ",
     +  "delete items, enter their indices immediately preceded by ",
     +  "minus signs."/" Insertions and deletions can be mixed on th",
     +  "e same entry line.  (c) To start"/" again, enter any letter",
     +  " without indices."/)')
      CALL SCANB(J,0,'I',5,CH8,L,WA,WB)
      IF(J==0) RETURN
      IF(J==-2) GOTO 65
      IF(J<0) GOTO 9
      DO I = 1,NY
        PIK(I) = 0
        IF(PIK1(I)>0) PIK(PIK1(I)) = 1
      END DO
      KOR = 1
      GOTO 20
      END SUBROUTINE
C
      SUBROUTINE SHOREC(KF,LOM,LB,LT)
C Display the first LT lines of file KF starting at line LOM-LB and truncating
C lines as necessary.
      PARAMETER (MCH=16000)
      CHARACTER (LEN=MCH) :: WORD, CH4*4
      COMMON /BL2/ LONG
      LL = MAX(0,LOM-LB)
      CALL POSN(KF,LL,IER)
      IF(IER>0) LOM = 0
      IF(IER>0) LL = 0
      LTT = LL+LT
10    LL = LL+1
      READ(KF,'(A)',END=50) WORD
      N = LEN_TRIM(WORD)
      CH4(:4)=CHAR(48+LL/100)//CHAR(48+MOD(LL/10,10))//CHAR(48+MOD(LL,
     +  10))//')'
      L = 3-JF(LL)
      CH4(:L) = '    '
      IF(LL==LOM+1) CH4(:4) = '>>>>'
      IF(N<=73) WRITE(6,'(1X,A,1X,A)') CH4, WORD(:MIN(73,N))
      IF(N>73) WRITE(6,'(1X,A,1X,A," [...",I4," chars in line]",)')
     +  CH4, WORD(:50), N
      IF(LL<LTT) GOTO 10
50    END SUBROUTINE
C
      SUBROUTINE WAIT(K)
C Space K lines before sending message
      DO I = 1,K
        WRITE(6,'()')
      END DO
      WRITE(6,'(" Hit RETURN to continue")')
      READ(5,'(A1)')
      END SUBROUTINE

C SUBS.LHY:  The following subprograms are specific to the Lahey compiler.
C
C      SUBROUTINE BBYT(KBYT)   ! Don't need this anymore
CC Find the number of bytes free on the active drive
C      CHARACTER WORD*40, WA*40, WB*40
C      CALL SYSTEM('dir *. >ZZZ')
C      OPEN(4,FILE='ZZZ')
C      CALL FNDEND(4,1)
C      READ(4,'(A)') WORD
C      DO I = 1,39
C         IF(WORD(I:I)==',') WORD(I:40) = WORD(I+1:40)//' '
C      END DO
C      WRITE(4,'(A)') WORD
C      BACKSPACE 4
C      CALL SCANB(J,1,'I',4,WORD,J,WA,WB)
C      READ(2,*) (KBYT,I=1,J)
C      CLOSE(4,STATUS='DELETE')
C      RETURN
C      END

      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12, LST(12)*10
      COMMON /CF/ CF
      DATA LST/'January  7','February 8','March    5','April    5',
     +         'May      3','June     4','July     4','August   6',
     +         'September9','October  7','November 8','December 8'/
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48  ! M gets day of month
      READ(ZZZ(5:6),*) L; K = ICHAR(LST(L)(10:10))-48
      WORD = CF(:JF(M))//' '//LST(L)(:K)//' '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE
C
      FUNCTION RANDY()
C Use the compiler's random generator for a random number in the unit interval
      DATA NEW/1/
      IF(NEW>0) THEN
        NEW = 0
        CALL RANDOM_SEED()
      END IF
      CALL RANDOM_NUMBER(RANDY)
      END FUNCTION
C
      FUNCTION TM(KSET)
C The value (real) returned by function TM is seconds since last timer reset.
C After this value is determined, the timer is reset if KSET > 0 but continues
C to accumulate if KSET = 0.
      DATA PREV/0./
C       CALL SYSTEM_CLOCK(J,KR,KMAX)  ! Arguments are optional
C       J = tick count since zero; KR = ticks per second; KMAX = max count
C       In LF90 clock: KR = 100, KMAX = 8,640,000
      CALL SYSTEM_CLOCK(J)
      X = J/100.
      TM = X - PREV
      IF(TM<=0.) TM = TM + 86400
      IF(KSET==0) RETURN
      PREV = X
      END FUNCTION

