C  Program HYFAC.  (Source code, FORTRAN-90)
C
C        Copyright (c) 1999 by W. W. Rozeboom.   All rights reserved.
C
C                 Last revised:  10 February 2003
C
C  This reads FAC-output of HYBALL (also MODA and HYBLOCK) and computes the
C  idealized regressions of the factors upon selected subsets of the data
C  variables.  The regressions are "idealized" in that the original data
C  covars are replaced by their reproductions from the factor solution.

      LOGICAL QY, QB, QN, QS, QX      ! QB/QN/QS flag blocking/namelist/SDs
C  ******* QS not yet used, may not be needed
      CHARACTER(12) F1, F2, F3, F4, F5, CF, CLN*8
C       F2[3] is the originating COV-file; F4[9] is W-export; F5 names sourcefile
      CHARACTER(45) FMT1, FMF*52, CL0, WORD*105
      CHARACTER C11,C12,C21,C22, BAR,LIN, QFMT, CH, BN
      REAL(8) S, V
      CHARACTER(8),ALLOCATABLE ::  IDENT(:), IDN(:), NAME(:)*12
      INTEGER,ALLOCATABLE :: FIX(:), FLST(:), KBL(:,:), KBS(:),
     +     LIST(:), LST(:), LST2(:), NLST(:), NUL(:)
      REAL,ALLOCATABLE :: A(:,:), B(:,:), CFF(:,:), COMM(:), CUT(:),
     +     CV(:,:), CFV(:,:), CVF(:,:), CX(:,:), SD(:), SMC(:),
     +     VAR(:), W(:)
      EXTERNAL SCAN
      COMMON NV, NF, MV, MF
      COMMON /CF/ CF
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))   ! 's'(:KSP(N)) yields 's' if N
      KSP(N) = ABS(MIN(1,N-1))           ! is 0 or >1, otherwise null
      DATA C11,C12,C21,C22,BAR,LIN/'','','','','',''/,
     +     QB,QN,QS,QX/4*.FALSE./, NX,KODE/2*0/
      OPEN(2,STATUS='SCRATCH')
      CALL SYSTEM('cls')
      KP = 132
      CALL PRNT(0,KP,6)
      WRITE(6,'(/" HYFAC accepts only factor patterns in files who",
     +  "se headnames have"/" form ""FAC..."", but will read any HY",
     +  "BALL-input file so named.")')
      ALLOCATE ( NAME(60) )
      CALL LOOK(1,'FAC*.*',NAME,40,M)
      IF(M==0) WRITE(6,'(/" There are no FAC-files in this sub",
     +  "directory. Go get one and try again.")')
      IF(M==0) STOP
      NN = 1
10    F1 = NAME(NN)
      CALL CAP(F1,12)
      CALL LAST(LF1,F1,12)
15    WRITE(6,'(/" The pattern file now picked for HYFAC study is ",
     +  A,"."/" Hit RETURN if OK, or enter the index of another ",
     +  "selection from this list."/)') F1(:LF1)
      CALL SCAN(J,1,'I',5)
      IF(J<0) GOTO 15
      IF(J>0) THEN
        READ(2,*) NN
        N = MAX(1,MIN(NN,N))
        GOTO 10
      END IF
      IF(QFMT(F1)=='Y') THEN
        OPEN(4,FILE=F1)
        READ(4,'(A)') WORD
        CALL START(4,F1)
        READ(4,*,ERR=22) NV, NF, NX, KODE, I, F2   ! When HYBALL reports -NX, NV includes NX
      ELSE  ! Should never arise
        OPEN(4,FILE=F1,FORM='UNFORMATTED')
        READ(4,ERR=22) NV, NF, NX, KODE
      END IF
22    DEALLOCATE ( NAME )
      IF(KODE<0) QB = .TRUE.; KODE = ABS(KODE)  ! KODE < 0 flags HYBLOCK blocking
      MV=NV+MAX(0,NX)+1; MF=NF+1; NFB=NF  ! Warning: MV (MF) must exceed NV (NF) by at least 1
      ALLOCATE ( B(MV,MF), CFF(MF,MF), COMM(MV), CV(MV,MV), CVF(MV,MF),
     +           IDENT(MV), SD(MV), W(LO(MF,MF)) )
      ALLOCATE ( FIX(MF), LIST(MV), LST(MV), LST2(MV), NLST(MV) )
      IF(QB) ALLOCATE ( KBS(30) )
      SD = 1.0
      DO I = 1,NV
        IDENT(I) = '['//CF(:JF(I))//']     '
      END DO
      FIX = 99
      NLST = (/(I,I=1,MV)/)
C Fixed-input flags:
C   KODE < 0: Blocking by HYBLOCK of both items and factors; NX = 0
C   NX > 0: X-set factors direct from MODA, X-set items not yet in pattern
C   NX < 0: X-set items/factors through HYBALL from MODA without HYBLOCK;
C             pattern expanded to include X-set as last ABS(NX) items
      BACKSPACE 4
      IF(QFMT(F1)=='Y') THEN    ! FAC-files from HYBALL are in ASCII
        CALL START(4,F1)
        READ(4,*) N !, NF, NX, KODE, I, F2
        READ(4,*) ((B(I,J),J=1,NF),I=1,NV)
        READ(4,*) NF1, NFQ   ! Covars can be stored either as triangle or full matrix
        NFF = LO(NF,NF)
        NF2 = NF*NF
        IF(NF1/=NF .OR. (NFQ/=NFF.AND.NFQ/=NF2)) THEN
          WRITE(6,'(/" Input file ",A," incorrectly specifies how th",
     +      "e correlations are entered."/" Its first line after the",
     +      " factor pattern must immediately precede the array CF"/
     +      " of factor correlations and must begin with the number ",
     +      "NF of factors followed"/" (with separation by space or ",
     +      "comma) by the number NF2 of entries in CF."/" NF2 equals",
     +      " NF*(NF+1)/2 if CF is lower-triangular, or is NF if CF",
     +      " is square."/" Fix the problem and try again.")') F1(:LF1)
          STOP  ! *** Revise this if 2nd-order inputs are resurrected.
        END IF
        READ(4,*) (W(I),I=1,NFQ)
        IF(NFQ==NF2) THEN  ! Convert full matrix to sym-storage
          DO I = 1,J
            W(LO(I,J)) = W(I+(J-1)*NF)        ! Full-matrix input
          END DO
        END IF
        IF(.NOT.QB) GOTO 31
          READ(4,*,END=38) (FIX(I),I=1,NF), (LST2(I),I=1,NV)
          READ(4,*,END=38) NB, (KBS(I),I=1,NB)  ! Block-structure code (FIX1 in HYBALL)
31      READ(4,*,END=38) (NLST(I),I=1,NV+MAX(0,NX))  ! If from MODA, X-set names also read
        QN = .TRUE.
      ELSE         ! Will probably never arise in practice
        READ(4) NV, NF, NX, KODE, I, F2   ! COV-file name also read from INMODA
        READ(4) ((B(I,J),I=1,NV),J=1,NF)
        READ(4) N, NFF
        READ(4) (W(I),I=1,NFF)
        IF(.NOT.QB) GOTO 32
          READ(4,END=38) (FIX(I),I=1,NF), (LST2(I),I=1,NV)
          READ(4,END=38) NB, (KBS(I),I=1,NB)  ! Block-structure code
          QB = .TRUE.
32      READ(4,END=38) (NLST(I),I=1,NV+MAX(0,NX))
        QN = .TRUE.
      END IF
38    CLOSE(4); D = 0.
      DO J = 1,NF   ! NOTE: D diagnoses a scaling constant, not a variance
        D = MAX(D,W(LO(J,J)))
      END DO
      NR = 0; NQ = 0
      DO J = 1,NF
        IF(D-W(LO(J,J))>.1) THEN  ! *** This should no longer arise
          NR = NR+1; LST(NR) = J  ! LST lists factors with nonstandard variances
          IF(J>ABS(NX)) NQ = NQ+1 ! NQ is number in LST following the X-set ones
        END IF                    ! LST shd only contain binary-input factors
        DO I = 1,NV
          B(I,J) = B(I,J)/D
          IF(I<=J) W(LO(I,J)) = W(LO(I,J))/D
        END DO
      END DO
      DO JJ = 1,NR  ! Standardize any binary-input factors
        J = LST(JJ); R = SQRT(W(LO(J,J)))   ! R is a raw binary-input SD
        DO I = 1,NF  ! Pattern stays the same to standardize the X-set item
          W(LOC(I,J)) = W(LOC(I,J))/R
        END DO
        W(LOC(J,J)) = 1.
      END DO
      IF(NX>0) THEN  ! Only when FAC-input is direct from MODA
        DO I = 1,NX
          DO J = 1,NF
            B(NV+I,J) = 0.
          END DO
          B(NV+I,I) = 1.
        END DO
        NV = NV+NX
      END IF
      NX = ABS(NX)    ! NX < 0 if HYBALL got X-set factors from MODA
      DO I = 1,NX  ! NX = 0 either if no X-set at all or if QB=T
        FIX(I) = 0  ! X-factors are at start of factor list (FIX is not item list)
      END DO
      IF(QB) ALLOCATE (KBL(-1:NB+1,0:NF) )
      DO I = 1,NF
        DO J = I,NF
          CFF(I,J) = W(LO(I,J))
          CFF(J,I) = CFF(I,J)
        END DO
      END DO
      DEALLOCATE ( W )
      IF(NQ>0) THEN
        WRITE(6,'(/5X,"File ",A," contains ",A," factor",A," havin",
     +    "g nonstandard variance"/5X,"despite not being manifest ",
     +    "(X-set) input.  If that seems wrong,"/5X,"hit RETURN to",
     +    " quit.  Otherwise, enter anything to continue.")')
     +    F1(:LF1), CF(:JF(NQ)), 's'(:KSP(NQ))
        CALL SCAN(J,1,'B',5)
        IF(J==0) STOP
      END IF
C
      CVAR = (ABS(KODE)/1000000)*.01
      KOD = MOD(ABS(KODE),1000000)
      IF(KP<100) THEN
        FMT1 = '(I4,".",2(2X,5A5),80(:/7X,2(2X,5A5)))'
        FMF  = '(" Targ ->",I4,4I5,1(2X,5I5),9(:/5X,2(2X,5I5)))'
      ELSE
        FMT1 = '(I4,".",5(2X,5A5),80(:/7X,5(2X,5A5)))'
        FMF  = '(" Targ ->",I4,4I5,3(2X,5I5),5(:/5X,4(2X,5I5)))'
      END IF
C If needed, restore original item orientations
      DO I = 1,NV
        IF(NLST(I)<0) THEN
          DO J = 1,NF
            B(I,J) = -B(I,J)
          END DO
          LST(I) = SIGN(I,NLST(I))  ! Keep record of reduced-list reflections
        END IF
      END DO
C Reconstruct the item covariances and enter full-regression list.
      ALLOCATE ( CFV(MF,MV) )
      CALL MULT(CFF,NF,NF,MF,0,B,NV,NF,MV,1,CFV,MF)   ! Only use of CFV
      CALL MULT(B,NV,NF,MV,0,CFV,NF,NV,MF,0,CV,MV)
      DEALLOCATE ( CFV )
      DO I = 1,NV
        COMM(I) = CV(I,I); CV(I,I) = 1.
      END DO
C
C Compute the item/factor covariances
      DO I = 1,NV
        DO J = 1,NF
          S = 0.
          DO K = 1,NF
            S = S + B(I,K)*CFF(K,J)
          END DO
          CVF(I,J) = S
        END DO
      END DO
C
      WORD = F2
      L = MAX(1,LPL(WORD,'.',12)); WORD(L:L) = '-'
      WRITE(6,'(//"  You have loaded the factor solution with code ",
     +  "No. ",A,A3," for ",A/2X,A,"data variables on ",A," factors.",
     +  "  Your aim is to find practical"/"  regressions of the fact",
     +  "ors on selected subsets of these items.")') CF(:JF(KOD)),
     +  CLN(CVAR,3,2), CF(:JF(NV)), WORD(:L), CF(:JF(NF))
      CALL WAIT(1)
C
C Display factor pattern/covariances to be processed
      WRITE(6,'(/" The received pattern is:")')
      CALL SHOW(6,B,COMM,CFF)
      IF(NX==1) WORD(:60) = ' The first factor is a manifest-input'//
     +  ' (X-set) variable      '
      IF(NX>1) WORD(:60) = ' The first '//CF(:JF(NX))//' factors'//
     +  ' are manifest-input (X-set) variables  '
      IF(NX>0) WRITE(6,'(A)') WORD(:60)
C
C Transfer input data to SEE-file and prepare F4 to record item weights
      F3 = F1
      F3(:3) = 'SEE'
      IF(F1(LF1-2:LF1-2)=='.') F3(LF1-1:LF1-1) = 'F'
      IF(F1(LF1-3:LF1-3)=='.') F3(LF1-2:LF1-2) = 'F'
      OPEN(7,FILE=F3)
      CALL PRNT(1,KP,7)
      WRITE(7,'(" Factor regressions for factor solution coded No. ",
     +  A,A3," in FAC-file ",A)')
     +  CF(:JF(KOD)), CLN(CVAR,3,2), F1(:LF1)
      CALL DAY(7); CALL LAST(LF2,F2,12)
      WRITE(7,'(/5X,"Derived from covariance file ",A,", the received",
     +  " pattern of"/5X,A," variables on ",A," factors (communalit",
     +  "ies in parens) is")') F2(:LF2), CF(:JF(NV)), CF(:JF(NF))
      CALL SHOW(7,B,COMM,CFF)
      IF(NX>0) WRITE(7,'(/A)') WORD(:60)
      DO I = 1,NV
        COMM(I) = 1-COMM(I)
      END DO
C        Terms in COMM are now uniquenesses of the data variables.
C
C Try to get the variables' raw SDs and names from <data>.COV file.
      IF(.NOT.QN) GOTO 100   ! This should never arise for standard FAC-input
      IF(QFMT(F2)=='Y') GOTO 57
      L = LPL(F2,'.',12)  ! L is dot position
      IF(F2(L+1:L+3)/='COV') THEN   ! Probably no real point
        F2 = WORD(88:99)   ! Reconstruct COV-file name from input
        L = LPL(F2,'.',12)-1; L2 = L+3
        F2(L:) = '.C'//F2(L2:)//' '
        IF(F2(:3)/='HYF') F2(L:L2) = 'COV'   ! HYF starts name of factor covs
      END IF
      IF(QFMT(F2)=='Y') GOTO 57     ! COV-file present; shd provide SDs
      CALL LAST(LF2,F2,12)
      WORD(:12) = F2; LL = 0
      WRITE(6,'(8X,63A)') C11, (LIN,I=1,61), C12
      WRITE(6,'(8X,A," WARNING. File ",A," containing SDs of the",
     +  " variables  ",2A/8X,A," has not been copied to this su",
     +  "bdirectory.  To get it, enter ",A/8X,A," the full subdi",
     +  "rectory name (with leading but not trailing"3X,A/8X,A,1X,
     +  "path-slash, and drive letter if needed) which contains t",
     +  "his.",A/8X,A," Otherwise, hit RETURN to continue witho",
     +  "ut the rawdata SDs   ",A)') BAR, F2(:LF2), F2(LF2+1:12),
     +  (BAR,I=1,9)
      WRITE(6,'(8X,63A//)') C21, (LIN,I=1,61), C22
      READ(5,'(A)') WORD(:40)
      CALL LAST(LL,WORD,40); LL1 = LL+1
      IF(LL==0) GOTO 100
      WORD(LL+1:LL1+LF2) = '\'//F2(:LF2)
      IF(QFMT(WORD(:LL1+LF2))=='Y') GOTO 55
      WRITE(6,'(" File ",A," has eluded detection. The SDs will",
     +  " be made unities.")') WORD(:LL1+LF2)
C Branch if COV-file not found
51    WORD(:12) = 'UNKNOWN.COV '   ! Is this needed?
      F4 = 'UNKNOWN.W*  '; LF4 = 10
      GOTO 100           ! COV-file not found; no names, no SDs
55    CALL START(3,WORD(:LL+L)); GOTO 60
57    CALL START(3,F2)
C   Common loading finish if COV-file located
60    F4 = F2(:LPL(F2,'.',12))//'W*'//'  '
      CALL LAST(LF4,F4,12)
      READ(3,*) NT, I, KD1, I, F5    ! NT is dimensionaliy of COV-file
      CALL LAST(LF5,F5,12)   ! F5 is the rawdata filename
      IF(KD1/=KOD) WRITE(6,'(/" Code No. ",A," of file ",A," does ",
     +  "not match the head code (",A," )"/" of the present pattern",
     +  " file. The raw SDs will all be treated as unity."/)')
     +   CF(:JF(KD1)), F2(:LF2), CF(:JF(KOD))
      IF(KD1/=KOD) GOTO 100
      ALLOCATE ( IDN(NT), W(NT) )
C      READ(3,*) (K,I=1,NVV)
C       Original data correlations are available here if wanted.
86    READ(3,'(A)',END=87) CH
      IF(CH=='N') THEN
        QN = .FALSE.
        READ(3,*,ERR=86) (IDN(I),I=1,NT)
        QN = .TRUE.
      ELSE IF(CH=='S') THEN   ! Standard deviations found
        READ(3,*,END=87) (W(I),I=1,NT); QS = .TRUE.
      END IF        ! QS shouldn't be needed unless SDs can be
      GOTO 86       ! missing when names are found
87    CLOSE(3)
      DO I = 1,NV  ! IDN is namelist in COV-file; NLST has item indices in HYBALL-input order
        IDENT(I) = IDN(ABS(NLST(I)))  ! IDENT now has names in hyball-output order
        SD(I) = W(ABS(NLST(I)))       ! Ditto for SDs
        LIST(I) = I
      END DO
      DO I =1,NV
        NLST(I) = LST(I)  ! NLIST now flags item reflections in HYBALL-output list
      END DO
      DEALLOCATE ( W, IDN )
C        NLST contains the variables' COV-file indices
      IF(.NOT.QN) WRITE(7,'(/" Names for the variables are unavail",
     +  "able.")')
      IF(.NOT.QN) GOTO 92
      WRITE(6,'(/" The factored variables are named")')
      CALL SEENAM(LM,NV,IDENT,LIST,1,79,1,6)
      IF(NX>=1) WRITE(6,'(/" Variables taken to be manifest-",
     +  "input factors are:",50(:/4X,6(I4,": ",A)))')
     +  (I,IDENT(I)(:LM),I=NV-NX+1,NV)
      WRITE(7,'(/" The factored variables are named")')
      CALL SEENAM(LM,NV,IDENT,LIST,1,KP-1,1,7)
      IF(QB) CALL GETBLF(NF,NB,NB1,FIX,KBL)  ! Outputs are KBL and NB1
      IF(.NOT.(QB.AND.QN)) GOTO 90  ! Bypass if no names or not from HYBLOCK
      WRITE(6,'(/" This factor pattern was structured by HYBLOCK.  ",
     +  "To see the items'' block"/" assignments, hit RETURN.  Other",
     +  "wise, enter anything to waive this reminder.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 90
      WRITE(7,'(/" This factor pattern was structured by HYBLOCK.  ",
     +  "Here are the item blocks:")')
      NL = MIN(9,70/(5+LM))      ! LM is max namelength
      WORD(:55) = '(" Block ",A,": ",5(I4,":",A):/50(10X,5('//
     +            'I4,":",A):/))'
      WORD(19:19) = CF(:JF(NL))  ! Number of names per line (  9 )
      WORD(39:39) = WORD(19:19)
C       (' Block ',A,': ',5(I4,':',A):/50(10X,5(I4,':',A):/))
      M = 0
      DO K = 0,NB  ! Get items in block K
        N = 0
        DO L = 1,NV
          IF(LST2(L)/=K) CYCLE
          N = N+1
          LST(N) = L    ! Assemble list of Block-K items
        END DO
        J = 1+(N-1)/NL
        IF(J>3 .AND. M+J>=21) THEN
          CALL WAIT(1)
          M = 0
        END IF
        IF(N==0) CYCLE
        DO JJ = 6,7
          WRITE(JJ,'()')
          WRITE(JJ,WORD(:55)) BN(K),(LST(I),IDENT(ABS(LST(I)))
     +      (:LM),I=1,N)
C         WRITE(JJ,'(" Block ",A,":",5(I4,": ",A):/50(10X,5(I4,": ",A):/))')
C     +      BN(K),(LST(I),IDENT(ABS(LST(I)))(:LM),I=1,N) ! N items in LST
          M = M+J  ! Number of lines to show block
        END DO
      END DO
      N = 0
      DO L = 1,NV
        IF(LST2(L)==99) N = N+1
      END DO
      IF(N==0) GOTO 88
      DO JJ = 6,7
        WRITE(JJ,'(" Block ",A,")   The ",A," remaining items.")')
     +    BN(99), CF(:JF(N))
      END DO
88    WRITE(6,'(/5X,"Hit RETURN to continue with the corresponding ",
     +  "blocks of factors.")')
      READ(6,'()')  !  Does this suffice for pause?  YES
      CALL SHOWB(NF,NB,FIX,KBS,KBL,QB,7)
      CALL SHOWB(NF,NB,FIX,KBS,KBL,QB,6)
      CALL WAIT(0)
90    N = 0
      DO I = 1,NV
        IF(LST(I)<0) N = N+1
        IF(LST(I)<0) LIST(N) = ABS(NLST(I))
      END DO
      IF(N==0) GOTO 92
      WRITE(7,'(/" The following variables have been reflected ",
     +  "from their datafile orientations:")')
      CALL SEENAM(LM,N,IDENT,LIST,0,KP-1,LM,7)
      WRITE(7,'(" Their factor-scale weights computed below are ",
     +  "for their datafile orientations.")')
      LIST = (/(I,I=1,MV)/)
92    IF(QS) THEN
        WRITE(7,'(/" The raw-score standard deviations of these it",
     +    "ems are respectively")')    !; BACKSPACE 7
        IF(KP>=100) WRITE(7,'(50(3(2X,5A7):/))') (CLN(SD(I),7,2),I=1,NV)
        IF(KP<100) WRITE(7,'(60(2(2X,5A7):/))') (CLN(SD(I),7,2),I=1,NV)
      ELSE
        WRITE(7,'(/" The raw-score standard deviations of these items",
     +    " have not been found; unit SDs therefore presumed.")')
      END IF
      WORD(:12) = F4
      DO I = 1,9  ! Delete any <base>.Wi* found with integer i
        WORD(LF4:LF4) = CHAR(48+I)
        INQUIRE(FILE=WORD(:12),EXIST=QY)
        IF(QY) CALL SYSTEM('del '//WORD(:12))
ccc        IF(QY) GOTO 100
      END DO
100   ALLOCATE ( FLST(MF) )  ! Input complete; now start computations
101   WRITE(6,'(/7X,"You proceed by picking a selection of factors to",
     +  " be regressed on a"/3X,"selection of data variables.  (Your ",
     +  "choice of items is specified first,"/3X,"followed by the fac",
     +  "tors you want these to estimate.  If unsure of what"/3X,"sel",
     +  "ections to make, choose all items and all factors unless on-",
     +  "screen"/3X,"advice suggests otherwise.)  After those regress",
     +  "ions are computed and"/3X,"simplified according to your inst",
     +  "ructions, you can repeat these steps"/3X,"with another choic",
     +  "e of items/factors or simplification scheme.")')
      IF(QB) THEN
        KPIK = 0
        WRITE(6,'(/7X,"Because this pattern has a block structure, y",
     +    "ou may simplify your"/3X,"selections in accord with that.",
     +    "  Specifically, you can simply name a"/3X,"dependent bloc",
     +    "k and call for regression of all factors therein on the"/
     +    3X,"items (a) just in this same block or (b) in all blocks",
     +    " path-antecedent"/3X,"to this one as well.  Blocks A thr",
     +    "ough ",A," are available.")') BN(NB)
105     IF(KPIK==0) THEN
          WRITE(6,'(/7X,"If you wish to exercise this option for th",
     +      "e factors in one of these"/3X,"blocks, enter its Lette",
     +      "r once or twice on the same line.  A single entry"/3X,
     +      "will regress that block''s factors on just the items de",
     +      "fining that block;"/3X,"doubling the entry will augment",
     +      " those with the items in antecedent blocks."/3X,"Other",
     +      "wise, hit RETURN to ignore blocking."/)')
        ELSE IF(KPIK>1000) THEN
          WRITE(6,'(/7X,"To regress the factors in block ",A," on the",
     +      " items defining this and"/3X,"all path-antecedent blocks,",
     +      " hit RETURN.  Otherwise, enter another block"/3X,"choice",
     +      " between A and ",A," with doubling to include path-antec",
     +      "ents,"/3X,"or any number to reconsider your approach."/)')
     +      BN(MOD(KPIK,1000)), BN(NB)
        ELSE
          WRITE(6,'(/7X,"To regress the factors in block ",A," on jus",
     +      "t the items defining"/3X,"this block, hit RETURN.  Other",
     +      "wise, enter another block choice between"/3X,"A and ",A,1X,
     +      "with doubling to include path-antecents, or any number to"/
     +      3X,"reconsider your approach."/)') BN(MOD(KPIK,1000)),BN(NB)
        END IF
        READ(5,'(A)') WORD
        L = LEN_TRIM(WORD); CALL CAP(WORD,L)
        IF(KPIK==0 .AND. L==0) GOTO 110    ! Move on with no block selected
        IF(KPIK>0 .AND. L==0) GOTO 145    ! Move on to block
        DO I = 1,L     ! Spacing in doubles may cause L to exeed 2
          NC = ICHAR(WORD(I:I))
          IF(NC<=32) CYCLE
          IF(NC<=64) GOTO 101
          IF(NC>NB+64) CYCLE
          KPIK = NC-64
          DO J = I+1,L
            IF(WORD(J:J)==WORD(I:I)) KPIK = KPIK + 1000
            IF(WORD(J:J)==WORD(I:I)) GOTO 105
          END DO
          GOTO 105
        END DO
      END IF
110   WRITE(6,'(/" If you want factor regressions on ALL the items, ",
     +  "hit RETURN.  Otherwise,"/" enter "" S "" to pick items by li",
     +  "sting ones for Selection, or "" E "" to list"/" items for Ex",
     +  "clusion.  Any other entry will display the item names and "/
     +  " initial advice again.")')
      READ(5,'(A)') WORD(:80)
      CALL LAST(L,WORD,20)
      IF(L==0) GOTO 130
      CH = WORD(:1)
      IF(ICHAR(CH)>=97) CH = CHAR(ICHAR(CH)-32)
      IF(CH/='S' .AND. CH/='E') THEN
        WRITE(6,'(" The factored variables are named")')
        CALL SEENAM(LM,NV,IDENT,LIST,1,79,1,6)
        GOTO 101
      END IF
      IF(CH=='S') WRITE(6,'(/" Unless you enter any letter to sw",
     +  "itch to exclusions, your entries will be"/" read as indi",
     +  "ces of variables on which the factors are to be regressed."/
     +  /" Enter some or all INDICES (not names) of items to be ",
     +  "INCLUDED. (Your entry")')
      IF(CH=='E') WRITE(6,'(/" Unless you enter any letter to swi",
     +  "tch to inclusions, your entries will be"/" read as indic",
     +  "es of variables to be omitted from the factor regressions."/
     +  /" Enter some or all INDICES (not names) of items to be EX",
     +  "CLUDED. (Your entry")')
      WRITE(6,'(" method may require more than one line.)  Entry of",
     +  " EXACTLY TWO integers N1,N2"/" followed by RETURN will b",
     +  "e read as the index sequence from N1 to N2. Any"/" other",
     +  " array of integers entered on one line will be read as jus",
     +  "t the items"/" listed. (To enter two items not read as ",
     +  "an interval, list one of them twice.)"/)')
      NY = 0
      GOTO 127
125   IF(CH=='S') WRITE(6,'(//" The list of variables on which ",
     +  "factors are to be regressed is now")')
      IF(CH=='E') WRITE(6,'(//" The list of variables to be omit",
     +  "ted from the factor regressions is now")')
      WRITE(6,'(50(:/4X,6(I4,": ",A)))') (LIST(I),IDENT(LIST(I))(:LM),
     +  I=1,NY)
      IF(NY>0) WRITE(6,'(/" Hit RETURN if correct and complete.",
     +  " Otherwise enter additional indices,"/" or any letter to",
     +  " clear list and start again. Remember that")')
131   IF(NY==0) WRITE(6,'(/" Enter all or part of the list ",
     +  "wanted as a spaced index list. Remember that")')
      WRITE(6,'(" entering just TWO indices selects all the ",
     +  "indices in that interval."/)')
127   CALL GETLST(NY,LIST,J,NV,LST)
      IF(J==-1) NY = 0
      IF(J==-1) GOTO 131
      IF(J/=0) GOTO 125
      N = 0
      IF(CH=='E') N = NY
      IF(CH=='E') NY = NV-NY
      DO I = 1,NY
        LST(I) = LIST(N+I)
      END DO
      IF(CH=='E') THEN
        WRITE(6,'(/" The items on which factors will be regressed",
     +    " are")')
        CALL SEENAM(LM,NY,IDENT,LST,1,79,1,6)
        WRITE(6,'(" Hit RETURN if satisfied.  Otherwise, enter any",
     +    "thing to try again.")')
        CALL SCAN(J,0,'B',5)
        IF(J==0) GOTO 135
        GOTO 125
      END IF
130   CH = 'A'  ! Flags that regression is on all the items
      NY = NV   !   ^ Not correct for X-set factors
      DO I = 1,NY
        LST(I) = I
      END DO
C
C Select factors for regression estimation
135   NX0=NX; NXW=0; IF(QB) NX0=KBL(0,0); IF(QB) NXW=KBL(-1,0)
      NXX = NX0+NXW; NFX = 0; IF(NXX==0) GOTO 140
      WRITE(6,'(3X,"Some factors in this pattern do not invite estima",
     +  "tion, namely")')
      IF(QB) WRITE(6,'(10X,A," manifest input",A," (X-block factor",
     +  A,") and ",A," Waif",A,".")') CF(:JF(NX0)), 's'(:KSP(NX0)),
     +  's'(:KSP(NX0)), CF(:JF(NXW)), 's'(:KSP(NXW))
      IF(.NOT.QB) WRITE(6,'(14X,A," manifest input",A," (X-block fac",
     +  "tor",A,").")') CF(:JF(NX0)), 's'(:KSP(NX0)), 's'(:KSP(NX0))
      WRITE(6,'(3X,"Hit RETURN to approve automatic exclusion of the"
     +  "se from any set of"/3X,"factors selected.  Otherwise, enter",
     +  " anything to leave them in play.")')
      CALL SCAN(J,0,'B',5)
      IF(J==0) QX = .TRUE.  ! QX = T flags omission of X-factors and Waifs
      IF(QX) NFX = NXX  ! NFX is number of globalfactor exclusions
      IF(QX.AND.QB) WRITE(6,'(5X,"Done:  Henceforth, ""All"" factors",
     +  " means all but X-factors and Waifs .")')
      IF(QX.AND..NOT.QB) WRITE(6,'(5X,"Done:  Henceforth, ""All"" fa",
     +  "ctors means all except X-factors.")')
140   NF = NFB   ! NFB is backup of input NF
      WRITE(6,'(/" If you want to regress all ",A," factors on these",
     +  " items, hit RETURN."/" Otherwise, enter individual indices ",
     +  "of selected factors (no intervals)."/" To reconsider choice",
     +  "s already made, enter a letter to start again.")')
     +  CF(:JF(NF-NFX))
      CALL SCAN(J,0,'I',5)
      IF(J<0) GOTO 101
      IF(J==0) THEN
        DO I = 1,NF
          FLST(I) = I
        END DO
      ELSE
        NF = J   ! Note: NF is respecified as the number wanted
        READ(2,*) (LIST(I),I=1,NF)
        CALL SORT(LIST,NF,FLST,1,NFB)  ! NF, FLST are output
      END IF
      N=NF; IF(QX) CALL DELETE(N,NF,FLST,FIX)  ! Drop X-factor and Waifs from FLST
      WRITE(6,'(/" The factors to be regressed on the selected it",
     +  "ems are now indexed",4(:/3X,25I3))') (FLST(I),I=1,NF)
      WRITE(6,'(/" Hit RETURN if OK, or enter anything to change ",
     +  "your factor selection.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 140     ! FLST,NF and LST,NY have been set
      GOTO 160
C
145   IB = MOD(KPIK,1000)   ! Set up block regression. LST gets items, FLST gets factors
      NF = KBL(IB,0)
      DO J = 1,NF
        FLST(J) = KBL(IB,J)
      END DO
      KOD = 0; IF(KPIK>1000) KOD = KBS(IB)
      CALL GETBLV(IB,KOD,NB,NV,LST2,LST,NY)   ! NY is number of items

C Compute the regression/multiple-correlation of the factors on the NY items
C listed in LST(_).
160   WRITE(6,'(/" Computation of the regressions is underway.")')
      IF(ALLOCATED(W) ) DEALLOCATE ( W )
      IF(.NOT.ALLOCATED(B) ) ALLOCATE ( B(MV,MF) )
      IF(.NOT.ALLOCATED(VAR) ) ALLOCATE ( VAR(MV) )
      ALLOCATE ( W(MAX(2*MF,LO(MV,MV))) )      ! Can reallocate B here
      DO J = 1,NY; DO I = 1,J
          W(LO(I,J)) = CV(LST(I),LST(J))
      END DO; END DO
      CALL EIGS(NY,0,W,LO(NY,NY),VAR,B,0,NY,IER,6)  ! Return generalized inverse.
      IF(IER<0) WRITE(6,'("  NOTE: Regression weights here are for ",
     +  "multicollinear predictors having"/7X,A,"vanishing eigenval",
     +  "ues.")') CF(:JF(ABS(IER)))  ! Eigvals not used
      DO I = 1,NY
        DO JJ = 1,NF
          J = FLST(JJ); S = 0.
          DO K = 1,NY
            S = S + W(LOC(I,K))*CVF(LST(K),J)
          END DO
          B(I,J) = S
        END DO
      END DO
C        B(I,J) is the regression weight of the Ith item in LST for factor J.
      DO JJ = 1,NF
        J = FLST(JJ); W(J) = 0.
        DO I = 1,NY; DO K = 1,NY
            W(J) = W(J) + B(I,J)*B(K,J)*CV(LST(I),LST(K))
        END DO; END DO
      END DO   ! W temporarily holds the factor-estimator variances
      MXX = FLST(1)
      DO JJ = 1,NF
        J = FLST(JJ); VAR(J) = 0.
        DO I = 1,NY
          VAR(J) = VAR(J) + B(I,J)*CVF(LST(I),J)
        END DO
        VAR(J) = (VAR(J)**2)/W(J)
        IF(VAR(J)>VAR(MXX)) MXX = J
C         VAR(J) is the variance of factor J accounted for by the items in LST.
      END DO
C
C Report results
      IF(CH=='A'.AND..NOT.QX) THEN
        WRITE(6,'(/" The ",A," factor regressions upon all the items",
     +    " have multiple R-squares")') CF(:JF(NF))
      ELSE
        WRITE(6,'(/" The ",A," factor regressions upon items",
     +    8(:/20(I4)))') CF(:JF(NF)), (LST(I),I=1,NY)
        WRITE(6,'(/" have multiple R-squares ")')
      END IF
      WRITE(6,'(1X,5A5,2(2X,5A5),5(:/1X,5A5,2(2X,5A5)))')
     +  (CLN(VAR(FLST(J)),5,2),J=1,NF)
      WRITE(6,'(/" The best-predicted factor is ",A,", for which",
     +  " these items'' beta-weights are",50(/2X,2(2X,5A6)))')
     +  CF(:JF(MXX)), (CLN(B(I,MXX),6,3),I=1,NY)
      WRITE(6,'(/" Hit RETURN to file this regression information,",
     +  " or enter anything to dump it.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 181
      IF(CH=='A') WRITE(7,'(/1X,40("==")//" Factor regressions",
     +  " upon all the items:")')
      IF(KP>=100 .AND. CH/='A') WRITE(7,'(/1X,60("==")//" Targ",
     +  "eted factor regressions upon items",30(:/1X,6(2X,5I4)))')
     +  (LST(I),I=1,NY)
      IF(KP<100 .AND. CH/='A') WRITE(7,'(/1X,40("==")//" Targeted",
     +  " factor regressions upon items",50(:/20I4))') (LST(I),I=1,NY)
      WRITE(7,'(/" Beta coefficients for targeted factor:")')
      WRITE(7,FMF) (FLST(I),I=1,NF)
      N = 12+MIN(101,5*(NF-1)+2*(NF/5))
      WRITE(7,'(1X,120A)') ('-',I=1,N)
      DO I = 1,NY
        WRITE(7,FMT1) LST(I), (CLN(B(I,FLST(J)),5,2),J=1,NF)
        IF(MOD(I,5)==0) WRITE(7,'(A1)')
      END DO
      WRITE(7,'(/" The multiple R-squares of these regressions ",
     +  "are respectively",50(/3X,3(2X,5A6)))') (CLN(VAR(FLST(J)),
     +   6,3),J=1,NF)
      WRITE(6,'(/" This standardized regression information has ",
     +  "been saved in ",A)') F3(:LF1)
181   WRITE(6,'(/" To find the factor regressions on another item",
     +  " selection instead of examining"/" these further, enter",
     +  " anything.  Otherwise, hit RETURN.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 101
      WRITE(6,'(/" If you want to study practical parsing of these",
     +  " items into subscales for the"/" factors, hit RETURN. ",
     +  "Otherwise, enter anything to exit.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) STOP
C
C Convert these standardized regressions to raw-score weights; approximate
C these by integer weighting; compute the multiple correlationss of the factors
C with these practical item composites; and finally, report the covariances
C among these item composites' unique components.
      IF(.NOT.ALLOCATED(NUL)) THEN
        ALLOCATE ( NUL(MF), CUT(MV), CX(MV,MF), SMC(MF) )
      END IF
      DO II = 1,NF
        I = FLST(II)
        NUL(I) = 20
      END DO

590   BIGDO: DO KK = 1,NF  ! In BIGDO, factors keep their original indices
        KF = FLST(KK)
        DO I = 1,NY
          LIST(I) = NINT(1000*ABS(B(I,KF)))
        END DO
        DO J = 2,NY  ! Order regression weights in increasing magnitude
          L = LIST(J)
          DO I = J-1,1,-1
            IF(LIST(I)<=L) GOTO 587
            LIST(I+1) = LIST(I)
          END DO
          I = 0
587       LIST(I+1) = L
        END DO
        JS = (68/NF)*(KK-1)
C        WRITE(6,'(69(""))')
        WRITE(6,'(100A)') ('',I=1,JS),'','Factor ',CF(:JF(KF)),
     +    ('_',I=1,69-JS)
515     WRITE(6,'(/" These items'' standardized regression weight",
     +    "s for factor ",A,", in order"/" of magnitude to 3 de",
     +    "cimals with point omitted, are",40(/20I4))') CF(:JF(KF)),
     +    (LIST(I),I=1,NY)
        WRITE(6,'(/" For converting this regression into a rounded ",
     +    "item composite, weights less"/" than a stipulated value",
     +    " NUL on the scale just shown will be replaced by zero.")')
        CUT(KF) = .001*(MIN(NUL(KF),LIST(NY))-.49)  ! Insure that at least one item passes
        DO I = 1,NY
          CX(I,KF) = B(I,KF)
          IF(ABS(B(I,KF))<CUT(KF)) CX(I,KF) = 0.
        END DO
C          CX gets the truncated regression coefficients
        S = 0.
        DO I = 1,NY
          S = S + CX(I,KF)*CVF(LST(I),KF)
        END DO
C          S is the covar between the KFth truncated regression and factor KF.
        V = 0.
        DO I = 1,NY
          DO J = 1,NY
            V = V + CX(I,KF)*CV(LST(I),LST(J))*CX(J,KF)
          END DO
        END DO
        S = S**2/V
C          V is the truncated composite's variance; S is its r with the factor
        SMC(KF) = S
        S = VAR(KF) - S
        WRITE(6,'(" NUL is now ",A," for factor ",A,", incurr",
     +    "ing SMC accuracy loss of",F7.3)') CF(:JF(NUL(KF))),
     +    CF(:JF(KF)), S
520     WRITE(6,'(/" To examine another choice of NUL for this fac",
     +    "tor enter its value."/" Otherwise, hit RETURN."/)')
        CALL SCAN(J,1,'I',5)
        IF(J<0) GOTO 520
        IF(J==0) CYCLE
        READ(2,*) NUL(KF)
        NUL(KF) = MAX(0,MIN(NUL(KF),LIST(NY)))
        GOTO 515
      END DO BIGDO

      WRITE(6,'(/" To review/revise these NUL settings for all ",
     + "factors, enter anything."/" Otherwise, hit RETURN.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 590
      WRITE(7,'(/1X,40("++")//" When these regressions are trunc",
     +  "ated by zeroing below respective cuts",20(/2X,3(2X,5A6)))')
     +  (CLN(CUT(FLST(I)),6,3),I=1,NF)
      WRITE(7,'(/" their squared multiple correlations with their ",
     +  "respective target factors are",20(/2X,3(2X,5A6)))')
     +  (CLN(SMC(FLST(I)),6,3),I=1,NF)
      WRITE(7,'(/" The SMC losses due to truncation are",20(/2X,
     +  2(2X,5A6)))') (CLN(VAR(FLST(I))-SMC(FLST(I)),6,3),I=1,NF)
C
C  Now round the raw-score weightings to integers.
      MXX = 10
      KX = 1
      WRITE(6,'(/" Raw-score regression weights will be rounded to",
     +  " integers after a scaling"/" adjustment sets the maximum ",
     +  "weight in each composite equal to MaxWt.")')
      WRITE(6,'(" If MaxWt is small, you may also want to enter, on",
     +  " the same line as MaxWt,"/" a positive digit Eq whose va",
     +  "lues larger than 1 increasingly reduce the"/" difference",
     +  "s among the rounded weights. If not entered, Eq defaults ",
     +  "to 1."/" (Eq larger than 5 or 6 is seldom beneficial.)")')
540   IF(KX==1) WRITE(6,'(/" MaxWt is now ",A,". Hit RETURN  ",
     +  "if OK, or enter wanted value."/)') CF(:JF(MXX))
      IF(KX>1) WRITE(6,'(/" <MaxWt, Eq> are now <",A,",",I2,
     +  ">. Hit RETURN if OK, or enter wanted values."/)')
     +  CF(:JF(MXX)),KX
      CALL SCAN(J,0,'I',5)
      IF(J<0) GOTO 540
      IF(J==0) GOTO 550
541   IF(J==1) READ(2,*) MXX
      KX = 1
      IF(J>1) READ(2,*) MXX, KX
      KX = MAX(1,MIN(9,KX))
      MXX = MAX(1,MIN(999,MXX))
      GOTO 540
550   ALLOCATE ( A(MV,MF) )
      DO I = 1,NY
        R = MAX(.001,SD(LST(I)))  ! SD
        DO J = 1,NF               ! <<<<< Revision of A-cols starts here
          A(I,J) = CX(I,FLST(J))/R  ! Divide  by  to get b-coeff
        END DO        ! >>>> Factor FLST(J) now has index J in A and W
      END DO
      EXP = 2./(KX+1)
      DO J = 1,NF
        S = 0.
        DO I = 1,NY
          S = MAX(S,DBLE(ABS(A(I,J))))
        END DO
        DO I = 1,NY
          X = (ABS(A(I,J))/S)**EXP
          A(I,J) = NINT(MXX*SIGN(X,A(I,J)))
        END DO
      END DO
      WRITE(6,'(" Computation of modified regressions is underway.")')
C        Columns of A are now the rounded raw-score item-composite weights.
      DO KF = 1,NF
        W(KF) = 0
        DO I = 1,NY     ! CVF still has original indices for factors
          W(KF) = W(KF) + A(I,KF)*SD(LST(I))*CVF(LST(I),FLST(KF))
C         W(K) gets the covar between rounded composite KF and factor FLST(KF).
C         Cov(zi,f) needs multiplication by SD(xi) to get Cov(xi,f)
        END DO
        W(NFB+KF) = 0.   ! NFB is original NF
        DO I = 1,NY
          DO J = 1,NY
            W(NFB+KF) = W(NFB+KF) + A(I,KF)*SD(LST(I))*CV(LST(I),
     +        LST(J))*SD(LST(J))*A(J,KF)
          END DO
        END DO
C           W(NFB+_) gets the rounded raw-score composites' variances.
      END DO
      DO I = 1,NF
        W(I) = W(I)**2/W(NFB+I)
      END DO
      CALL NAME2(F4,8,LF4)  ! This subroutine call completes F4
      OPEN(9,FILE=F4)
      WRITE(9,'("HYFAC raw-score weights of ",A," items for ",A,
     +  " factors; details in ",A,"; rawdata origin, ",A)')
     +  CF(:JF(NY)), CF(:JF(NF)), F3(:LF1), F5(:LF5)
      WRITE(7,'(/1X,40("--")//" Subsequent rounded rescaling with <M",
     +  "axWt, Eq> = <",A,",",I2,"> yields RAW-SCORE item composite"/
     +  " targeting factor Targ:")') CF(:JF(MXX)), KX
      WRITE(7,'(A1)')
      WRITE(7,FMF) (FLST(I),I=1,NF)
      N = 12+MIN(101,5*(NF-1)+2*(NF/5))
      WRITE(7,'(1X,120A)') ('-',I=1,N)
      DO I = 1,NY      !  Rem: CL0 is a function
        WRITE(7,FMT1) LST(I), (CL0(NINT(A(I,J)),5),J=1,NF)
        IF(MOD(I,5)==0) WRITE(7,'()')
        WRITE(9,'(A8,50I5)') IDENT(LST(I)), (NINT(A(I,J)),J=1,NF)
C             !      ^  Name needs to be in fixed field for RESCORE input
      END DO
      CLOSE(9)
      WRITE(7,'(/" This weight matrix has also been stored in file ",
     +  A," for possible use by program RESCORE.")') F4(:LF4)
      WRITE(7,'(/" The squared correlations between these rounded ",
     +  "item composites and their respective target factors for ",
     +  "<MaxWt, Eq> = <",A,",",I2,"> are",20(/2X,3(2X,5A6)))')
     +  CF(:JF(MXX)), KX, (CLN(W(I),6,3),I=1,NF)
      WRITE(6,'(/" The squared correlations between these rounded it",
     +  "em composites and their"/" respective target factors for",
     +  " <MaxWt, Eq> = <",A,",",I2,"> are")') CF(:JF(MXX)), KX
      WRITE(6,'(4(/2X,2(2X,5A6)))') (CLN(W(I),6,3),I=1,NF)
      DO I = 1,NF
        W(I) = SMC(FLST(I)) - W(I)    ! Factors have original indices in SMC
      END DO
      WRITE(6,'(/" which differ from the truncated regression SMCs",
     +  " by",20(/2X,2(2X,5A6)))') (CLN(W(I),6,3),I=1,NF)
      WRITE(7,'(/" which differ from the truncated regression SMCs",
     +  " by",20(/2X,3(2X,5A6)))') (CLN(W(I),6,3),I=1,NF)
C
C Determine the composites' uniqueness behavior.
      DO J = 1,NF
        DO I = 1,J
          S = 0
          DO K = 1,NY
            S = S + A(K,I)*SD(LST(K))*COMM(LST(K))*SD(LST(K))*A(K,J)
          END DO
          CFF(J,I) = S/SQRT(W(NFB+I)*W(NFB+J))
        END DO
      END DO
      DEALLOCATE ( A )
      WRITE(7,'(/" When these item composites are renormalized, the ",
     +  "covariances among their residual (unique) components are")')
      DO I = 1,NF
        IF(MOD(I,5)==1) WRITE(7,'(A1)')
        WRITE(7,FMT1) I, (CLN(CFF(I,J),5,2),J=1,I)
      END DO
      WRITE(6,'(/" To try another MaxWt setting, enter its value (",
     +  "followed by Eq if wanted)."/" Otherwise, hit RETURN."/)')
      CALL SCAN(J,0,'I',5)
      IF(J>0) GOTO 541
      WRITE(6,'(/" A more detailed report on this set of rounded ",
     +  "regressions has been added to"/1X,A," If you would like ",
     +  "to re-do the roundings for this item selection,"/" enter",
     +  " anything. Otherwise, hit RETURN.")') F3(:LF1)
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 590
      NF = NFB
      WRITE(6,'(/" Enter anything to repeat this analysis for anot",
     +  "her item selection. Otherwise,"/" hit RETURN to exit.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 101
      WRITE(7,'("")')
      STOP
      END
C
      FUNCTION BN(N)
c Converts block integer code N into the block's letter code
      CHARACTER BN
      IF(N==99) THEN
        BN = 'Y'
      ELSE IF(N==0) THEN
        BN = 'X'
      ELSE IF(N<0) THEN
        BN = 'Z'
      ELSE IF(N<88) THEN  ! Letters A-W
        BN = CHAR(64+N)
      ELSE
        BN = CHAR(N-39)  ! Continue with digits starting with 1
      END IF
      RETURN
      END
C
      SUBROUTINE CAP(WORD,L)
C This makes the first L letters in WORD all upper-case.
      CHARACTER WORD*(*)
      DO I = 1,L
        N = ICHAR(WORD(I:I))
        IF(N>=97 .AND. N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      END SUBROUTINE

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
C      SAVE /CF/  ! This doesn't appear to be needed
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      FUNCTION CL0(N,KF)
C Convert integer N into character expression of fieldwidth KF, replacing
C zero by dot. Maximum fieldwidth is 6.
      CHARACTER CL0*6, CH
      CL0 = '      '
      IF(N==0) THEN
        CL0(KF:KF) = '.'
        RETURN
      END IF
      K = IABS(N)
      DO I = KF,1,-1
        CH = CHAR(48+MOD(K,10))
        CL0(I:I) = CH
        IF(N<0) CL0(I-1:I-1) = '-'
        K = K/10
        IF(K==0) RETURN
      END DO
      RETURN
      END
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      CLN = '        '
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      LD = ABS(ND)
      IF(ABS(X)<1.0E-12) THEN !  Special for vanishingly small X
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X))) !  M is space free for decimal (or M-1 if X<0) )
      IF(M<0 .OR.  M<1.AND.X<0.) GOTO 55
      IF(ND>=10) LD = 0; LD = MIN(LD,M)
      DO I = 1,KW
        WK(I) = ' '
      END DO
      IF(LD==0) N = NINT(ABS(X))         ! Shouldn't be needed, but is
      IF(LD/=0) N = NINT(ABS(X)*10**LD)  ! This can overflow if LD is large
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' *******'
      END FUNCTION
C
      SUBROUTINE DELETE(N,NN,LIST,FIX)
C Delete indices from LIST identified in FIX as an X-set or Waif factor.
C NN returns reduced LIST length.
      INTEGER LIST(*), FIX(*)
      NN = 0
      DO I = 1,N
        K = LIST(I)
        IF(FIX(K)>0) THEN
          NN = NN+1
          LIST(NN) = K
        END IF
      END DO
      END SUBROUTINE
C
      SUBROUTINE GETBLF(NF,NB,NB1,FIX,KBL)  ! Maybe NB1 not really needed
C This extracts from FIX the KBL listing of factors in each block
      INTEGER FIX(*), KBL(-1:NB+1,0:NF)
      DO I = -1,NB+1
        KBL(I,0) = 0
      END DO
      N1 = 0
      DO I = 1,NF
        IF(FIX(I)==99) N1 = N1+1    ! Not really needed
        IB = MIN(FIX(I),NB+1)
        KBL(IB,0) = KBL(IB,0)+1
        KBL(IB,KBL(IB,0)) = I
      END DO  ! If any items have FIX code 99, row NB+1 of KBL is nonempty.
      NB1 = (NB+MIN(1,N1))            ! Not really needed
      END SUBROUTINE
C
      SUBROUTINE GETBLV(KB,KOD,NB,NV,LST2,LST,NBS)
C For factor block KB, return in LST the indices of all variables in JB and
C all other blocks coded in KOD, which is either 0 (in which case LST gets
C just items in block KB) or is KBS(KB) in Main for all blocks antecedent
C to KB.  LST2 contains the items' block assignments,
      INTEGER LST(*), LST2(*), JBB(NB)
      K = KOD; NJB = 0
      IF(K==0) GOTO 10
      DO I = 1,KB-1 ! First assemble list JBB of wanted factor blocks
        IF(MOD(K,2)>0) THEN
          NJB = NJB+1
          JBB(NJB) = I
        END IF
        K = K/2
      END DO
10    NJB = NJB+1; JBB(NJB) = KB
      NBS = 0
      DO J = 1,NJB
        JB = JBB(J)
        DO I = 1,NV
          IF(LST2(I)==JB) THEN
            NBS = NBS+1
            LST(NBS) = I
            CYCLE
          END IF
        END DO
      END DO
C Order if blocks don't preserve sequence
      DO J = 2,NBS
        L = LST(J)
        DO I = J-1,1,-1
          IF(LST(I)<=L) GOTO 12
          LST(I+1) = LST(I)
        END DO
        I = 0
12      LST(I+1) = L
      END DO
      END SUBROUTINE

      SUBROUTINE GETLST(N,LIST,J,NV,KW)
C Enter N distinct indices no larger than NV into LIST in sequential order.
C LIST(N+_) receives in order the indices from 1 to NV omitted from LIST.
C KW is a workspace. LIST may be partly formed at input, SCAN provides the rest.
      INTEGER LIST(*), KW(*)
      EXTERNAL SCAN
      CALL SCAN(J,0,'I',5)
      IF(J<=0) RETURN
      NX = N
      DO I = 1,NX
        KW(I) = LIST(I)
      END DO
8     READ(2,*) (LIST(I),I=1,J)
      IF(J/=2) THEN
        DO I = 1,J
          KW(NX+I) = LIST(I)
        END DO
        NX = NX+J
      ELSE
        L = MAX(1,MIN(NV,LIST(1),LIST(2)))
        M = MIN(NV,MAX(1,LIST(1),LIST(2)))
        DO I = L,M
          KW(NX+I-L+1) = I
        END DO
        NX = NX+M-L+1
      END IF
25    WRITE(6,'(/" Enter more indices, or hit RETURN if list is ",
     + "complete."/)')
      CALL SCAN(J,0,'I',5)
      IF(J<0) GOTO 25
      IF(J>0) GOTO 8
C Order list with any duplicates removed
      CALL SORT(KW,NX,LIST,1,NV)
      N = NX
      J = N
      END SUBROUTINE
C
      SUBROUTINE LAST(L,WORD,M)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as L. If the string is empty, LAST is returned as 0.
      CHARACTER WORD*(*)
      WORD(:M) = ADJUSTL(WORD(:M))
      L = LEN_TRIM(WORD(:M))
      END SUBROUTINE
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
      LOGICAL PRM, QY
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP
      CHARACTER E   ! <<<  Special characters as needed
      WD = GET
      CALL LAST(M,WD,40)
      LL = 1
5     LL = LL+1
      E = WD(LL+1:LL+1)
      IF(E/='|' .AND. E/='/' .AND. LL<M) GOTO 5  ! *** No longer relevant??
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(WORD(:1)==' ' .OR. WORD(:1)=='.') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
C       Filter out lines other than filenames
      CALL LAST(L,WORD,14)
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4) .AND. NAME(I)(L+5:L+5)==' ')
     +    GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NL)
      IF(NL>0) WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      CALL LAST(L1,NAM1,LEN(NAM1)); CALL LAST(L2,NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      CALL LAST(L1,WRD1,LEN(WRD1)); CALL LAST(L2,WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A number terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION
C
      SUBROUTINE MULT(V1,N1,M1,L1,K1,V2,N2,M2,L2,K2,V3,L3)
C This postmultiplies N1-by-M1 matrix V1, or its transpose if K1=1, either by
C N2-by-M2 matrix V2 or by its transpose if K2=1, and puts the product into
C matrix V3. The subroutine processes these matrices as vectors, using the
C leading dimensions L1/L2/L3 declared for 2-dimensional arrays V1/V2/V3 in
C the calling routine.
      DOUBLE PRECISION S
      REAL V1(*), V2(*), V3(*)
      KTOT = M1
      J = N2
      IF(K1==1) KTOT = N1
      IF(K2==1) J = M2
      IF(KTOT==J) GOTO 6
      WRITE(7,4)
4     FORMAT(/' Matrix dimensions are not congruent for the multipli',
     + 'cation called.')
      STOP
6     ITOT = N1
      IF(K1==1) ITOT = M1
      JTOT = M2
      IF(K2==1) JTOT = N2
      INC1 = L1
      IF(K1==1) INC1 = 1
      INC2 = 1
      IF(K2==1) INC2 = L2
      JJ = 0
      DO J = 1,JTOT
        DO I = 1,ITOT
          KA = I
          IF(K1==1) KA = L1*(I-1) + 1
          KB = J
          IF(K2/=1) KB = L2*(J-1) + 1
          S = 0.0
          DO K = 1,KTOT
            S = S + V1(KA)*V2(KB)
            KA = KA + INC1
            KB = KB + INC2
          END DO
          V3(I+JJ) = S
        END DO
        JJ = JJ + L3
      END DO
      END SUBROUTINE
C
      SUBROUTINE NAME2(F1,M,L)
C This receives a filename in F1 (presumed to start in position 1), solves
C for <head> to be the part of F1 prior to '.' up to M characters, scans the
C subdirectory for the lowest i=1,2,...,99 such that file <head>.Wi does not
C already exist, returns <head>.Wi in F1(:12), and the end position of the
C latter in L.
      LOGICAL QY
      CHARACTER F1*(*), DIGIT
      DIGIT(I) = CHAR(48+I)
      L = 0
10    L = L+1
      IF(L<=M .AND. F1(L:L)/=' ' .AND. F1(L:L)/='.') GOTO 10
      DO I = L+2,12
        F1(I:I) = ' '
      END DO
      F1(L:L+1) = '.W'
      L = L+2
      I = 0
20    I = I+1
      IF(I<=9) F1(L:L) = DIGIT(I)
      IF(I>9) F1(L:L+1) = DIGIT(I/10)//DIGIT(MOD(I,10))
      INQUIRE(FILE=F1,EXIST=QY)
      IF(QY .AND. I<99) GOTO 20
      IF(QY .AND. I==99) F1(L:L+1) = DIGIT(0)//DIGIT(0)
      L = L+1
      END SUBROUTINE
C
      FUNCTION LPL(WORD,CH,N)
C Return position of 1st occurrance of character CH in 1st N places of WORD
      CHARACTER CH, WORD*(*)
      LPL = 0
      DO I = 1,N
        LPL = LPL+1
        IF(WORD(I:I)==CH) RETURN
      END DO
      LPL = 0
      END FUNCTION
      SUBROUTINE PRNT(JOB,KP,KFILE)
C
C Set printer codes. JOB=0/1/2 if job is find-linewidth/set-normal-print/set-
C HYBALL-pattern-plots.  KP is linewidth. KFILE is file to write.
      CHARACTER QFMT, WORD*55
      IF(QFMT('PRNTR')=='U') THEN
        IF(JOB==0) WRITE(KFILE,'(/" WARNING: There is no printer ",
     +    "definition in this subdirectory.")')
        IF(JOB==1) WRITE(KFILE,'(" %")')
        IF(JOB==2) WRITE(KFILE,'(" #")')
        RETURN
      END IF
      OPEN(1,FILE='PRNTR')
      READ(1,'(A)',END=20,ERR=20) WORD
      IF(WORD(:1)=='*') KP = 80
      IF(JOB==0) GOTO 10
      IF(WORD(:1)/='%') READ(1,'(A)',END=20,ERR=20) WORD
      IF(JOB==1) WRITE(KFILE,'(A)') WORD(3:)
      IF(JOB==1) GOTO 10
      READ(1,'(A)',END=20,ERR=20) WORD
      WRITE(KFILE,'(A)') WORD(3:)
10    CLOSE(1)
      RETURN
20    WRITE(6,'(/" Your PRNTR file is corrupt. Delete or replace ",
     +  " this and try again.")')
      END SUBROUTINE
C
      SUBROUTINE SCAN(NL,NS,SEQ,KF)
C This reads the keyboard string, cleans it for list-directed reading of
C the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.  Termination of an input line by "*" allows up to
C two continuation lines.) NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number
C string returned in File 2 is non-null but does not match SEQ, and
C gives the total count of numbers in the returned string otherwise.
C ***** If SEQ is "B", NL returns 0 if the input is blank, or -1 otherwise.
      CHARACTER*1 AA, SEQ*(*), WA*240, WB*240
      NL = 0
5     NLL = NL + 80
      READ(KF,'(A80)') WA(NL+1:NLL)
      IP = NL
      NL = NLL+1
10    NL = NL-1
      IF(NL==0) RETURN
      IF(WA(NL:NL)==' ') GOTO 10
      IF(WA(NL:NL)=='*' .AND. NL>IP) GOTO 5
      IF(SEQ(1:1)=='B') NL = -1
      IF(SEQ(1:1)=='B') RETURN
      WB(NL+1:NL+1) = ' '
      DO 20 I = 1,NL
       WB(I:I) = ' '
       IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) GOTO 20
       WB(I:I) = WA(I:I)
       WA(I:I) = '0'
20     CONTINUE
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO 30 I = 2,NL
       IF(WA(I:I)=='-') THEN
        IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +   =='0')) WB(I:I) = '-'
        IP = 0
       ELSE IF (WA(I:I)=='.') THEN
        IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +  WB(I:I) = '.'
        IF(WB(I:I) == '.') IP = 1
       ELSE IF (WA(I:I) /= '0') THEN
        IP = 0
       END IF
30     CONTINUE
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO 40 I = 2,NL+1
       IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
        NN = NN + 1
        WA(NN:NN) = AA
        AA = 'I'
       ELSE IF (WB(I:I)=='.') THEN
        AA = 'R'
       END IF
40     CONTINUE
      IF(NN==0) NL = -1
      IF(NN==0) RETURN
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     +  "number sequence requested. Try again.")')
      RETURN
60    REWIND 2
      WRITE(2,'(A)') WB(1:NL)
      NL = NN
      REWIND 2
      END SUBROUTINE
C
      SUBROUTINE SEENAM(LM,NX,IDENT,PIK,JOB,NW,LS,KF)
C This writes to file KF the NX names picked from IDENT by selector list PIK.
C LM is max namelength.  LS is number of lines to leave at top of screen.
C NW is line length.
      CHARACTER*8 IDENT(*), FMT*30, CH3*3
      INTEGER PIK(*)
      N = 3
      DO I = 1,NX
        CALL LAST(N,IDENT(PIK(I)),8)
        IF(N<=8) LM = MAX(LM,N)
      END DO
      MM = MAX(3,LM)
      LL = NW/(5+MM)   ! Number of fields per line
      LB = (23-LS)*LL       ! Number of fields in 23-LS lines
      NS = MIN(1,MOD(NW,6+LM)/2)  ! Number of spaces starting display line
      NK = 0
      CH3 = CHAR(48+NS)//CHAR(48+LL/10)//CHAR(48+MOD(LL,10))
      FMT = '(80('//CH3(1:1)//'X,'//CH3(2:3)//'(I4,":",A),:/))'
ccc      WRITE(KF,'(" The factored variables are named")')
20    IF(JOB/=0) WRITE(KF,FMT) (I,IDENT(IABS(PIK(I)))(:MM),I=NK+1,
     +   NK+MIN(LB,NX-NK))
      IF(JOB==0) WRITE(KF,FMT) (IABS(PIK(I)),IDENT(IABS(PIK(I)))
     +            (:MM),I=NK+1,NK+MIN(LB,NX-NK))
      IF(1+(NX-NK)/LL<=18) RETURN   ! Number of lines needed to finish
      IF(KF==6) WRITE(6,'(" Hit RETURN to continue")')
      IF(KF==6) READ(5,'(A1)')
      NK = NK+LB
      LB = 23*LL  ! Hereafter use full screen
      IF(NK>=NX) RETURN
      GOTO 20
      END SUBROUTINE
C
      SUBROUTINE SHOW(IO,B,COMM,CV)
C This writes to screen (if IO=6) or to Results file (if IO=7) the current
C factor pattern/covariances.
      CHARACTER FMT1*40, FMT2*50, WORD*10, CLN*8
      REAL B(MV,*), COMM(*), CV(MF,*)
      COMMON NV, NF, MV, MF
      FMT1 = '(4X,8X,2(2X,6A5),90(:/14X,2(2X,6A5)))'
      IF(IO/=6) FMT1 = '(4X,7X,4(2X,5A5),90(:/14X,4(2X,5A5)))'
      FMT2 = '(I4,". (",A3,")"'//FMT1(7:)
      DO I = 1,NV
        IF(MOD(I-1,5)==0) WRITE(IO,'()')
        WRITE(IO,FMT2)  I, CLN(COMM(I),3,2), (CLN(B(I,J),5,2),J=1,NF)
        IF(IO/=6 .OR. MOD(I,10)/=0 .OR. I>=NV-2) CYCLE
        WRITE(6,'(" Hit RETURN to continue this display, or enter",
     +    " anything to quit it.")')
        READ(5,'(A)') WORD
        IF(WORD/='          ') RETURN
      END DO
      D = 0.
      DO I = 1,NF
        D = MAX(D,ABS(CV(I,I)-1.))
        DO J = I+1,NF
          D = MAX(D,ABS(CV(I,J)))
        END DO
      END DO
      IF(D<.001) WRITE(IO,'(/"  Covariances are orthonormal.")')
      IF(D<.001) RETURN
      WRITE(IO,'(/"  with corresponding factor covariances")')
      DO I = 1,NF
        IF(MOD(I-1,5)==0) WRITE(IO,'()')
        WRITE(IO,FMT1) (CLN(CV(I,J),5,2),J=1,I)
      END DO
      IF(IO==6) CALL WAIT(0)
      RETURN
      END
C
      SUBROUTINE SHOWB(NF,NB,FIX,KBS,KBL,QB,KF)
C This prints to file KF the factor blocks and their dependency structure.
      LOGICAL QB
      CHARACTER WORD*30, CH1*2, CH2*2, FMT1*90, FMT2*90, BN, CF*12
      INTEGER FIX(*), KBS(*), KBL(-1:NB+1,0:NF)
      N1 = NF-KBL(NB+1,0)
C       If any items have FIX code 99, row NB+1 of KBL will be nonempty.
      IF(N1==KBL(-1,0)+KBL(0,0)) THEN
        WRITE(KF,'()')
       IF(N1==0) THEN
          WRITE(6,'(/" All factors are in fully-dependent block Y.")')
        END IF
        IF(KBL(0,0)>0) THEN
          WRITE(KF,'(" Factors taken to be manifest input (block X):")')
          WRITE(KF,'(4X,50(1X,A))') (CF(:JF(KBL(0,I))),I=1,KBL(0,0))
        END IF
        IF(KBL(-1,0)>0) THEN
          WRITE(KF,'(" Factors set aside as isolates (block Z):")')
          WRITE(KF,'(4X,50(1X,A))') (CF(:JF(KBL(-1,I))),I=1,KBL(-1,0))
        END IF
        RETURN
      END IF
15    MBB = MAX(8,2*((NB+1)/2))
      M = (MBB-6)/2
C       MAX(8,...) in MBB insures that M is at least 1
      CH1 = CHAR(48+M/10)//CHAR(48+MOD(M,10))
      MM = 0
      DO I = -1,NB
        MM = MAX(MM,KBL(I,0))
      END DO
      NL = KBL(NB+1,0)
      IF(NL<(65-MBB)/3) NN = MAX(30,3*MAX(MM,NL))
      IF(NL>=(65-MBB)/3) NN = MAX(30,3*MM)
      CH2 = CHAR(48+NN/10)//CHAR(48+MOD(NN,10))
      WRITE(KF,'(/" Rotation constraints were imposed",
     +  " by the following block structure.")')
      WRITE(KF,'(" A block''s factors can rotate only in the sub",
     +  "space of their DepOn blocks.")')
      FMT1 = '(/"  Block  ",'//CH1//'(" "),"DepOn ",'//
     +  CH1//'(" "),"   Indices of factors in block")'//'       '
      WRITE(KF,FMT1)
      FMT1 = '(" ",'//CH1//'(""),"",'//CH1//
     +  '(""),"",'//CH2//'(""))                         '
      WRITE(KF,FMT1)
      FMT2 = '(4X,A,3X,"'//''//'",1X,A,"'//''//'",50I3)             '
      IF(KBL(0,0)>0) THEN
        WORD(:30) = '                              '
        WORD(M+2:M+5) = 'none'
        WRITE(KF,FMT2) 'X', WORD(:MBB), (I,I=1,KBL(0,KBL(0,0)))
      END IF
      DO IB = 1,NB
        WORD(:30) = '                              '
        KW = MIN(1,KBL(0,0))
        IF(KW>0) WORD(1:1) = 'X'
        K = KBS(IB)
        DO I = 1,IB-1
          IF(MOD(K,2)>0) THEN
            KW = KW+1
            WORD(KW:KW) = BN(I)
          END IF
          K = K/2
        END DO
        WORD(KW+1:KW+1) = BN(IB)
        WRITE(KF,FMT2) BN(IB), WORD(:MBB), (KBL(IB,J),J=1,KBL(IB,0))
      END DO
      NL = KBL(NB+1,0)
      IF(NL<=0) GOTO 35
      WORD(:9) = '"all   ",'
      IF(KBL(-1,0)>0) WORD(:9) = '"all*  ",'
      IF(NL*3>NN) THEN
        FMT2 = '(4X,"Y    ",'//CH1//'(" "),'//WORD(:9)//CH1//
     +    '(" "),"  all remaining factors"'//WORD(5:5)//')        '
        WRITE(KF,FMT2)
      ELSE
        FMT2 = '(4X,"Y    ",'//CH1//'(" "),'//WORD(:9)//CH1//
     +    '(" "),"",50I3)'//'                  '
        WRITE(KF,FMT2) (KBL(NB+1,J),J=1,NL)
      END IF
35    IF(KBL(-1,0)>0) THEN
        WORD(:5) = '  Z  '
        IF(QB) WORD(:5) = 'Waifs'
        FMT2 = '(2X,A,"  ",'//CH1//'(" "),"      ",'//
     +    CH1// '(" "),"",50I3)'//'                  '
        WRITE(KF,FMT2) WORD(:5), (KBL(-1,J),J=1,KBL(-1,0))
      END IF
      FMT1 = '(" ",'//CH1//'(""),"",'//CH1//
     +  '(""),"",'//CH2//'(""))                         '
      WRITE(KF,FMT1)
      CH2 = '  '
      IF(KBL(-1,0)>0) CH2 = 's '
      IF(KBL(-1,0)>0 .AND. NL>0) THEN
         WORD(:13) = 'Z-factor'//CH2//'   '
         IF(QB) WORD(:13) = 'Waif factor'//CH2
         WRITE(6,'(10X,"*Excepting the ",A)') WORD(:12)
      END IF
      END SUBROUTINE
C
      SUBROUTINE SORT(LIST,N,LST,N1,N2)
C This receives in LIST an unordered list of N integers; puts into LST(_) the
C NN distinct ones in range <N1,N2>, and into LST(N2+_) the complement of
C LST(_) over this range; finally sets N = NN for return.
      INTEGER LIST(*), LST(*)
        L = 0
        M = N
      LPA: DO I = N1,N2
        DO J = 1,N
          IF(I==LIST(J)) THEN
            L = L+1
            LST(L) = I
            CYCLE LPA
          END IF
        END DO
        M = M+1
        LST(M) = I
      END DO LPA
      N = L
      END SUBROUTINE
C
      SUBROUTINE START(J,F1)
C This opens formatted file F1 with unit-number J, and finds its first line
C beginning with a digit.
      CHARACTER F1*(*), CH*80
      OPEN(J,FILE=F1)
10    READ(J,'(A)',END=50) CH
      K = 0
12    K = K+1
      L = ICHAR(CH(K:K))
      IF((L==32 .OR. L==0) .AND. K<80) GOTO 12
      IF(L<48 .OR. L>57) GOTO 10
      BACKSPACE J
      RETURN
50    WRITE(6,'(/" File ",A," is defective.")') F1
      END SUBROUTINE
C
      SUBROUTINE WAIT(N)
C  N < 0 calls for space before screen display
      IF(N>0) WRITE(6,'()')
      WRITE(6,'(" Hit RETURN to continue")')
      READ(5,'(A1)')
      RETURN
      END
C
C SUBS.LHY: The following subprograms are specific to the Lahey compiler.
C
      FUNCTION QFMT(F1)
C This determines the status of file F1, returning 'Y' if it is Formatted,
C 'N' if it is Not, and 'U' if it is Unknown (does not exist).
      CHARACTER QFMT, F1*(*)
      INQUIRE(FILE=F1,FORMATTED=QFMT)
      END FUNCTION
C
      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12
      COMMON /CF/ CF
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48
      IF(ZZZ(5:6)=='01') WORD = CF(:JF(M))//' January '//ZZZ(:4)
      IF(ZZZ(5:6)=='02') WORD = CF(:JF(M))//' February '//ZZZ(:4)
      IF(ZZZ(5:6)=='03') WORD = CF(:JF(M))//' March '//ZZZ(:4)
      IF(ZZZ(5:6)=='04') WORD = CF(:JF(M))//' April '//ZZZ(:4)
      IF(ZZZ(5:6)=='05') WORD = CF(:JF(M))//' May '//ZZZ(:4)
      IF(ZZZ(5:6)=='06') WORD = CF(:JF(M))//' June '//ZZZ(:4)
      IF(ZZZ(5:6)=='07') WORD = CF(:JF(M))//' July '//ZZZ(:4)
      IF(ZZZ(5:6)=='08') WORD = CF(:JF(M))//' August '//ZZZ(:4)
      IF(ZZZ(5:6)=='09') WORD = CF(:JF(M))//' September '//ZZZ(:4)
      IF(ZZZ(5:6)=='10') WORD = CF(:JF(M))//' October '//ZZZ(:4)
      IF(ZZZ(5:6)=='11') WORD = CF(:JF(M))//' November '//ZZZ(:4)
      IF(ZZZ(5:6)=='12') WORD = CF(:JF(M))//' December '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE

