C           Program HYLOG  Source code, FORTRAN-90

C This extracts LOG information on HYBALL runs from their HYBUF records
C
C                 Last revised: 17 February 2005

C *** WARNING. When revising, heed that subroutine BUFF here differs from HYBALL

      PARAMETER (MK=4, MOM=1000)
C       MK is an arbitrary limit on multiple choices of GAP.
      LOGICAL SHFT, QY, QS, NW(6)
      CHARACTER CH, QFMT, U2, TR, WRD(0:4)*6, FMT*41, FMT1*41
      CHARACTER(8) CNVT*5, CLN, WORD*80, CH2*2
      CHARACTER(12) CF, F1, F2, F3, CH4(2)*4, NAME(80)
      INTEGER OMIT(MOM), OMT(MOM)
CCC      REAL GP(MOM)

CCC      INTEGER FIX(MF), FX(MF), FIX1(MF), FX1(MF), KNT(MK,NREC,MF),
CCC     +        KC(MRC,MK), LST(NREC), LST1(MFV), LTMP(NREC),
CCC     +        ORDER(MF), PFIX1(MF), PFX1(MF), RECORD(NREC,MF)
CCC      REAL A1(MV,MF), T1(MV,MF), C1(MF,MF), DG(MF), COMM(MV), GP(MK),
CCC     +     CC(MRC), CFF(MF*(MF+1)/2), STOR(NREC,0:MF+1)

      CHARACTER(8), ALLOCATABLE :: IDENT(:)
      INTEGER, ALLOCATABLE :: FIX(:),FX(:), FIX1(:),FX1(:), KNT(:,:,:),
     +        KC(:,:), LST(:), LST1(:), LST2(:), LTMP(:), ORDER(:),
     +       PFIX1(:),  PFX1(:), RECORD(:,:)
      REAL, ALLOCATABLE :: A1(:,:), T1(:,:), C1(:,:), DG(:), COMM(:),
     +        CC(:), CFF(:), STOR(:,:)    !, GP(:)
      EXTERNAL SCAN
      COMMON /BL1/ MV, MF, NV, NF, NREC
      COMMON /BL3/ BH,JA,JB,CV1,ADD,R0,R1
      COMMON /CF/ CF
      LO(I,J) = J*(J-1)/2 + I
      DATA NW/6*.TRUE./, U2/''/, CH4/'VARI','EQUA'/, QY,QS/2*.FALSE./
      DATA WRD/'STEP/S','STEP/P','SCAN/S','SCAN/P','OBLMIN'/
      BH=.20; JA=2; JB=2; CV=1; WSAL=0; GAP=5.
      OPEN(2,STATUS='SCRATCH')

CC TEST LINES
C      OPEN(21,FILE='JNK')

C  Set default parameters and other initializations
      FMT = '(4X,7X,2(2X,6A5),90(:/13X,2(2X,6A5)))'
      FMT1 = '(4X,7X,4(2X,5A5),90(:/13X,4(2X,5A5)))'
      KP = 132
      CALL SYSTEM('cls')
      CALL PRNT(0,KP,6)  ! Warns if no printer code is present
C ***** Long lines for hard copy not now adequately utilized
      NLD = 0
      IF(KP==81.OR.KP>132) NLD = 1  ! NLD=1 flags no printer line draw
      RAD = 90/ACOS(0.)
C
      WRITE(6,'(/" The HYBALL log records available for retrieval ",
     +  "here are:")')
      CALL LOOK(1,'*.*',NAME,80,NN)
      IF(NN==0) WRITE(6,'(/ " No Hybuf files are in this subdir",
     +  "ectory.")')
      IF(NN==0) STOP
      DO N = 1,NN
        IF(NAME(N)(:6)=='HYBUF ') GOTO 7
      END DO
      N = 1
7     F1 = NAME(N)
      CALL CAP(F1,12)
      LF1 = LAST(F1,12)
10    WRITE(6,'(/" The one now set for LOG retrieval is ",A,".  ",
     +  "Hit RETURN if OK,"/" or enter the index of another selec",
     +  "tion from this list."/)') F1(:LF1)
      CALL SCAN(J,1,'I',5)
      IF(J<0) GOTO 10
      IF(J>0) THEN
        READ(2,*) N
        N = MAX(1,MIN(NN,N))
        GOTO 7
      END IF
      OPEN(8,FILE=F1,STATUS='OLD',FORM='UNFORMATTED')
      READ(8) N, MV, MF
12    READ(8,END=15) NTOT   ! Ascertain number of records in logfile
      GOTO 12
15    REWIND 8
      NREC = NTOT+1; MRC = LO(NREC,NREC)
      ALLOCATE ( IDENT(MV) )
      ALLOCATE ( FIX(MF), FX(MF), FIX1(MF), FX1(MF), LST(NREC),
     +           LST1(MV), LST2(MV), LTMP(NREC), ORDER(MF),
     +           PFIX1(MF), PFX1(MF), RECORD(NREC,0:MF) )
      ALLOCATE ( A1(MV,MF), T1(MV,MF), C1(MF,MF), DG(0:MF),
     +           COMM(MV), CFF(LO(MF,MF)) )
C
C  Read in initial unrotated pattern
      READ(8) NN, NV1, NF1, KODE, NFF1, NFQ, MTH, ((T1(I,J),I=1,NV1),
     +  J=1,NF1), (CFF(I),I=1,NFQ), F3, F2, (LST1(I),I=1,NV1), NX,
     +  (LST2(I),I=1,MAX(0,NX))  !, NB, (FIX1(I),I=1,NB)
CC    If input from HYBLOCK, NX=NV1 and LST2 holds items' block assignments, else
CC    -NX is MODA's NX and LST2 is empty. In LST2, 0 and -1 code X-items and Waifs resp.
      LF3 = LAST(F3,12)  !  F3 recovers the input filename
      LST(1) = -1; IDENT(1) = '??      '; NZ = 0
      IF(NX==NV1) THEN  ! Blocks from HYBLOCK
        NX = 0
        DO I = 1,NV1
          IF(LST2(I)==0) NX = NX+1; IF(LST2(I)==-1) NZ = NZ+1
        END DO
      END IF
      IF(NX<0) NX = ABS(NX)  ! X-set factors from MODA
C
C Read in the original list of variable names
      IF(QFMT(F2)=='U') QY = .TRUE.  ! QY = T flags names unavailable
      IF(QY) GOTO 26
      CALL START(4,F2)
      READ(4,*,ERR=20,END=20) NN  ! No.vars
18    READ(4,'(A)',END=22) CH    ! Retrieve info from COV-file
      IF(CH=='N') THEN
        DEALLOCATE ( IDENT ); ALLOCATE ( IDENT(NN) )
        READ(4,*,ERR=20,END=20) (IDENT(I),I=1,NN)   ! Recover namelist from COV-file
        GOTO 22
      END IF
      GOTO 18  ! Read next line of COV-file
20    IDENT(1) = '??      '
22    CLOSE(4)
26    WORD(:12) = F2
      F2 = F3
      L = 2+LH(F2,12)  ! Position of extension start
      F2(L:L) = '$'
      OPEN(7,FILE=F2)
      CVAR = (ABS(KODE)/1000000)*.01
      KOD = MOD(ABS(KODE),1000000)
      KIND = MIN(1,NFF1-NF1)
C       KIND=1 if the input file is for quadratic data; KIND=0 if the input
C       file identifies itself as containing just 1st-level data
      MV = NV1-KIND; NV = MV
      MF = NF1-KIND; NF = MF; K1 = 1; K2 = MF
      DO J = 1,MF
        DO I = 1,J
          C1(I,J) = CFF(LO(I+KIND,J+KIND))
          C1(J,I) = C1(I,J)
        END DO
      END DO
      DO J = 1,MF
        DO I = 1,MV
          A1(I,J) = T1(I+KIND,J+KIND)
        END DO
      END DO
      COMM = 0.
      DO I = 1,MV
        DO J = 1,MF; DO K = 1,MF
           COMM(I) = COMM(I) + A1(I,J)*C1(J,K)*A1(I,K)
        END DO; END DO
      END DO
C
C Display factor pattern/covariances in HYBUF store
      CALL PRNT(1,KP,7)
      WRITE(7,'(/" Report on the HYBALL rotations of input pattern ",
     +  A,", code No. ",A,A3,", stored in logfile ",A)')
     +  F3(:LF3), CF(:JF(KOD)), CLN(CVAR,3,2), F1
      WRITE(7,'(" Note: The value of any rotation constraint or con",
     +  "trol parameter not made explicit for pattern No. N is"/7X,
     +  "unchanged from its value for pattern No. N-1, even when ",
     +  "a pattern earlier in store has been retrieved.")')
      CALL DAY(7)
      WRITE(6,'(/" The initial pattern of ",A," variables on ",A," fac",
     +  "tors, Data Code No. ",A,A3/" (communalities in parens) is:")')
     +  CF(:JF(MV)), CF(:JF(MF)), CF(:JF(KOD)), CLN(CVAR,3,2)
      CALL SHOW(6,FMT,A1,COMM,C1)
      IF(IDENT(1)(:2)/='??') GOTO 30
      IF(QY) WRITE(7,'(/" Names for the variables are unavailable. ",
     +  " If you want them here, insure"/" that sourcefile ",A," is",
     +  " copied to the active subdirectory.")') WORD(:LAST(WORD,12))
      IF(QY) GOTO 32
      IF(IDENT(1)(:2)=='??') WRITE(7,'(/" Names for the variables ",
     +  "are unavailable.  Sourcefile ",A," appears to lack"/" some ",
     +  "of the information needed.")') WORD(:LAST(WORD,12))
      QY = .TRUE.; GOTO 32
30    WRITE(7,'(/" The variables are named")')
      CALL SEENAM(NV,IDENT,LST1,1,79,7)   ! 132 line width not now used effectively
      N = 0
      DO I = 1,NV1
        IF(LST1(I)<0) N = N+1
        IF(LST1(I)<0) LST1(N) = ABS(LST1(I))
      END DO
      IF(N==0) GOTO 34
      WRITE(7,'(/" Variables that have been reflected from their ",
     +  "original orientations are:")')
      CALL SEENAM(N,IDENT,LST1,0,79,7)  ! LST1 now free for new use below
32    DO I = 1,NV1
        IDENT(I) = '['//CF(:JF(I))//']     '
      END DO
34    CALL SYSTEM('cls')

c  | HYLOG proffers three blocks of information about the rotated patterns in |
c  | this logfile in accord with your choice of report parameters.  Block 1   |
c  | identifies for each pattern, in production order, the conditions under   |
c  | which it was produced and some detail on the distribution of loadings    |
c  | therein.  Block 2 offers tables of these patterns' varied standings on   |
c  | assorted nonrelational features of their loading distributions.  And     |
c  | Block 3 provides congruence comparisons among these patterns.            |
C  |                                                                          |
c  |     Moreover, you may occasionally want HYLOG appraisals restricted      |
c       to a submatrix of loadings in these patterns, notably when they      
c  |     have been structured by HYBLOCK. So at outset you get the option     |
c  |     for this run to report on the loadings just of a selection of        |
c  |     these patterns' variables on a subsequence of their factors.         |

      WRITE(6,'(////2X,80A)') TR(''), (TR(''),I=1,74), TR('')
      WRITE(6,'(2X,A," HYLOG proffers three blocks of information abo",
     +  "ut the rotated patterns in ",A/2X,A," this logfile in accord",
     +  " with your choice of report parameters.  Block 1",3X,A/2X,A,
     +  " identifies for each pattern, in production order, the condi",
     +  "tions under   ",A/2X,A," which it was produced and some deta",
     +  "il on the distribution of loadings",4X,A/2X,A," therein.  Bl",
     +  "ock 2 offers tables of these patterns'' varied standings on",
     +  3X,A/2X,A," assorted nonrelational features of their loading ",
     +  "distributions.  And",5X,A/2X,A," Block 3 provides congruence",
     +  " comparisons among these patterns.",12X,A)') (TR(''),I=1,14)
      WRITE(6,'(2X,A,74X,A)') TR(''), TR('')
      WRITE(6,'(2X,A,5X,"Moreover, you may occasionally want HYLOG ap",
     +  "praisals restricted",6X,A/2X,A,5X,"to a submatrix of loadin",
     +  "gs in these patterns, notably when they",6X,A/2X,A,5X,"have",
     +  " been structured by HYBLOCK. So at outset you get the option",
     +  5X,A/2X,A,5X,"for this run to report on the loadings just of",
     +  " a selection of",8X,A/2X,A,5X,"these patterns'' variables o",
     +  "n a subsequence of their factors.",9X,A)') (TR(''),I=1,10)
      WRITE(6,'(2X,80A)') TR(''), (TR(''),I=1,74), TR('')
      WRITE(6,'(/3X,"To appraise complete patterns, hit RETURN.  Other",
     +  "wise, enter anything"/3X,"to select subpattern coordinates.")')
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 80
40    NR = -1
      WRITE(6,'(//5X,"If you want this run''s appraisals to include a",
     +  "ll the variables,"/5X,"hit RETURN.  Otherwise enter indices",
     +  " of items to be EXCLUDED"/5X,"or any letter to be reminded",
     +  " how to list these by intervals."/)')
46    CALL GETLST(NR,LST2,J,MV)
      IF(NR<0 .AND. J==0) GOTO 50  ! Only on fresh entry to GETLST
      IF(NR<0 .AND. J<0) GOTO 41   ! Get more advice
      IF(J<0) GOTO 40   ! Clear list and start again
      IF(J==0) GOTO 44
41    WRITE(6,'(/5X,"Enter INDICES (not names) of some or all items ",
     +  "to be excluded, not"/5X,"necessarily on just one line.  Ent",
     +  "ry of EXACTLY TWO indices N1,N2"/5X,"folllowed by RETURN wi",
     +  "ll be read as the sequence from N1 to N2.  Any"/5X,"other s",
     +  "tring of integers will be read as just the indices listed. ",
     +  "(To"/5X,"enter a pair with this interval interpretation dis",
     +  "abled, repeat one."/)')
      IF(NR<0) GOTO 46 ! NR<0 if no entries have been made
44    IF(NR<=0) WRITE(6,'(/" No variables are now declared for omis",
     +  "sion.")')
      IF(NR>0) WRITE(6,'(/" The variables declared for omission ",
     +  "are now")')
      IF(NR>0) CALL SEENAM(NR,IDENT,LST2,0,79,6)
      WRITE(6,'(" If this is not your item-omissions intent, enter a",
     +  "nything to try again."/" Otherwise, hit RETURN to consider ",
     +  "possible factor omissions.")')
      CALL SCAN(J,0,'B',5); IF(J/=0) GOTO 40

cc46    CALL GETLST(NR,LST2,J,MV) ! J=0 says omissions list is OK
ccC      IF (J==-1) is returned, NR = -1
cc      IF(J<=-1) GOTO 40   ! Start again
cc      IF(J/=0) GOTO 44    ! Display enhanced omissions list

c   To include all factors (1 to xxx) in this run's appraisals, hit RETURN.
c   Otherwise enter anything to set exclusions at ends of the factor list.
50    K1 = 1; K2 = MF
      WRITE(6,'(3X,"To include all factors (1 to ",A,") in this run''",
     +  "s appraisals, hit RETURN."/3X,"Otherwise, enter anything to ",
     +  "set exclusions at ends of the factor list.")') CF(:JF(NF))

c  In particular, you may want to omit X-set factors 1 - x or Waifs xx - xx.
c  In particular, you may want to omit X-set factors 1 - x.
c  In particular, you may want to omit Waif factors xx - xx.
c  In particular, you may want to omit Waif factor xx.
C  (Although those loadings are generaly informative, you may
C  prefer to appraise them separately from the other factors.)

      IF(NX+NZ==0) GOTO 54
      WORD(:38) = '  In particular, you may want to omit '
      IF(NX==0.AND.NZ==1) WRITE(6,'(A,"Waif factor ",A,".")')
     +  WORD(:38), CF(:JF(NF))
      IF(NX==0.AND.NZ>1) WRITE(6,'(A,"Waif factors ",A,"  ",A,".")')
     +  WORD(:38), CF(:JF(NF+1-NZ)), CF(:JF(NF))
      IF(NX==1.AND.NZ==0) WRITE(6,'(A,"X-set factor 1.")') WORD(:38)
      IF(NX==1.AND.NZ==1) WRITE(6,'(A,"X-set factor 1 and Waif factor ",
     +  A,".")') WORD(:38), CF(:JF(NF))
      IF(NX==1.AND.NZ>1) WRITE(6,'(A,"X-set factor 1 and Waif facto",
     +  "rs ",A,"  ",A,".")') WORD(:38), CF(:JF(NF+1-NZ)), CF(:JF(NF))
      IF(NX>1.AND.NZ==0) WRITE(6,'(A,"X-set factors 1  ",A,".")')
     +  WORD(:38), CF(:JF(NX))
      IF(NX>1.AND.NZ==1) WRITE(6,'(A,"X-set factors 1  ",A," and Wa",
     +  "if factor ",A,".")') WORD(:38), CF(:JF(NX)), CF(:JF(NF))
      IF(NX>1.AND.NZ>1) WRITE(6,'(A,"X-set factors 1  ",A," and Wa",
     +  "if factors ",A,"  ",A,".")') WORD(:38), CF(:JF(NX)),
     +  CF(:JF(NF+1-NZ)), CF(:JF(NF))
      WRITE(6,'("  (Although those loadings are generaly informative,",
     +  " you may"/"  prefer to appraise them separately from the ot",
     +  "her factors.)")')
54    CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 70

c     |  Unlike item omissions, HYLOG currently omits factors only by   |
c     |  exclusion from a consecutively indexed factor subset selected  |
c     |  by entering the index range [j,k] of factors to be retained.   |
C  To include all factors j = 1 to k = xx in the pattern appraisals, hit RETURN.

      WRITE(6,'(//5X,80A)') TR(''), (TR(''),I=1,65), TR('')
      WRITE(6,'(5X,A,"  Unlike item omissions, HYLOG currently omits",
     +  " factors only by",3X,A/5X,A,"  exclusion from a consecutive",
     +  "ly indexed factor subset selected",2X,A/5X,A,"  by entering",
     +  " the index range [j,k] of factors to be retained.",3X,A)')
     +  (TR(''),I=1,6)
      WRITE(6,'(5X,80A)') TR(''), (TR(''),I=1,65), TR('')

C  Hit RETURN to include all factors j = 1 to k = xx in the pattern appraisals.
C  To include all factors j = 1 to k = xx in the pattern appraisals, hit RETURN.
C  To restrict pattern appraisal to factors from j = xx to k = xx, hit RETURN.
C  Otherwise enter a different choice of factor-index range [j,k] between
C  1 and xx, or any letter to reconsider factor omissions.

56    IF(K1==1.AND.K2==NF) WRITE(6,'(/3X,"To include all factors (1 to",
     +  1X,A,") in the pattern appraisals, hit RETURN.")') CF(:JF(NF))
      IF(K1>1 .OR. K2<NF) WRITE(6,'(/3X,"To restrict pattern appraisal",
     +  " to factors from j = ",A," to k = ",A,", hit RETURN.")')
     +  CF(:JF(K1)), CF(:JF(K2))
      WRITE(6,'(3X,"Otherwise enter a different choice of factor-index",
     +  " range [j,k] between"/3X,"1 and ",A,", or any letter to recon",
     +  "sider factor omissions."/)') CF(:JF(NF))
      CALL SCAN(J,2,'II',5)
      IF(J==0) GOTO 70; IF(J==-2) GOTO 56; IF(J==-1) GOTO 40
      READ(2,*) L, M; K1 = MAX(1,MIN(L,M)); K2 = MIN(NF,MAX(L,M))
      IF(K1>1 .OR. K2>NF .OR. K1==K2) GOTO 56
70    WRITE(6,'(//16X,80A)') TR(''), (TR(''),I=1,34), TR('')
      WRITE(6,'(16X,"  Pattern-identification options  ")')
      WRITE(6,'(16X,80A)') TR(''), (TR(''),I=1,34), TR('')

c    Enter anything to omit Block-1 pattern details (unwise unless you
c    have already recorded these on a previous HYLOG run).  Otherwise,
c    hit RETURN to choose the level of pattern detail you want to see.
80    WRITE(6,'(/5X,"Enter anything to omit Block-1 pattern details ",
     +  "(unwise unless you"/5X,"have already recorded these on a pr",
     +  "evious HYLOG run).  Otherwise,"/5X,"hit RETURN to choose th",
     +  "e level of pattern detail you want to see.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 199

C      | Although HYLOG doesn't exhibit numerical pattern solutions, a  |
C      | full log report begins with each pattern's scatter of unsigned |
C      | loadings shown either in (a) one line combining all factors,   |
C      | or (b) a separate line for each factor's loading distribution. |
      WRITE(6,'(//6X,80A)') TR(''), (TR(''),I=1,64), TR('')
      WRITE(6,'(6X,A," Although HYLOG doesn''t exhibit numerical patt",
     +  "ern solutions, a  ",A/6X,A," full log report begins with eac",
     +  "h pattern''s scatter of unsigned ",A/6X,A," loadings shown e",
     +  "ither in (a) one line combining all factors,"3X,A/6X,A," or ",
     +  "(b) a separate line for each factor''s loading distribution.",
     +  1X,A)') (TR(''),I=1,8)
      WRITE(6,'(6X,80A)') TR(''), (TR(''),I=1,64), TR('')
      QY = .FALSE.
82    IF(QY) WRITE(6,'(/" To graph each pattern''s loadings with a s",
     +  "eparate line for each factor, hit"/" RETURN.  Otherwise, en",
     +  "ter anything to combine all factors on one line.")')
      IF(.NOT.QY) WRITE(6,'(/" To graph each pattern''s loadings comb",
     +  "ined in one line, hit RETURN."/" Otherwise, enter anything ",
     +  "to show each factor on a separate line.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) THEN
        QY = .NOT.QY; GOTO 82
      END IF
      WRITE(7,'(/" The input pattern of ",A," variables on ",A,
     +  " factors (communalities in parens) is")') CF(:JF(MV)),
     +  CF(:JF(MF))
      CALL SHOW(7,FMT1,A1,COMM,C1)
      CALL DIST(NV,COMM,7)
      IF(ALLOCATED(IDENT)) DEALLOCATE ( IDENT )
C Report LOG record for all stored patterns
      NR = MAX(0,NR); LST1 = (/(I,I=1,MV)/); IF(NR==0) GOTO 75
      NV = MV - NR  ! NR is Number of items Rejected
      DO I = 1,NV   ! Finalize item omissions
        LST1(I) = LST2(NR+I)  ! LST1 now lists the retained items
      END DO
C  >>> LST1 lists NV retained items; included factors are from K1 to K2
75    IF(NV<MV .OR. NF<MF) QS = .TRUE.; IF(QS) NF = K2-K1+1

c >>>> NOTE: Parts of these patterns are excluded from the summaries below.
c            Variables excluded:
c            Factors excluded: All not in range xx - xx

      IF(QS) THEN
        WRITE(7,'(/" >>>> NOTE: Parts of these patterns are exclud",
     +    "ed from the summaries below.")')
        IF(NV==MV) WRITE(7,'(12X,"Variables excluded: None")')
        IF(NV<MV) WRITE(7,'(12X,"Variables excluded:",15(1X,A):/
     +    8(12X,15(1X,A):/))') (CF(:JF(LST2(I))),I=1,NR)
        IF(NF==MF) WRITE(7,'(14X,"Factors excluded: None")')
        IF(NF<MF) WRITE(7,'(14X,"Factors excluded:",15(1X,A):/8(12X,
     +    15(1X,A):/))') (CF(:JF(I)),I=1,K1-1),(CF(:JF(I)),I=K2+1,MF)
CC        IF(NF<MF) WRITE(7,'(14X,"Factors excluded: All not in range ",
CC     +    A,"  ",A)') CF(:JF(K1)), CF(:JF(K2))
      END IF
      READ(8) NL, ((X,I=1,MV),J=1,MF), ((X,I=1,MF),J=1,MF), L, BBH,
     +  CCV, JJA,JJB, WWSAL, PPD1, NM, (OMT(I),I=1,NM), (FX(I),I=1,MF),
     +  NNB, (FX1(I),I=1,NNB), NNPFX, (PFX1(I),I=1,NNPFX), BB0, BB1,
     +  DDB, DDF, CCLOSE, IIMAX, IICYC, TT, JFLAG
      MMD = MOD(JFLAG/1000,10)    !     ^  TT may report item/factor alignment
      BACKSPACE 8 !^ Main reason for preceding read
cc      NZ = 0  ! Keep count of waifs in Rec 0 ?
      FMT1(:1) = ' '; LST = 0
100   READ(8,END=198) NN,((A1(I,J),I=1,MV),J=1,MF),((C1(I,J),I=1,MF),
     +  J=1,MF),L, BH, CV, JA, JB, WSAL, PD1, NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,MF),NB,(FIX1(I),I=1,NB),NPFIX, (PFIX1(I),I=1,NPFIX),
     +  B0, B1, DB, DF, CLOSE, IMAX, ICYC, T, JFLAG
      IF(QS) CALL STRIP(A1,C1,LST1,K1,2)  ! ^For Oblimin, t is -Gamma
C       JFLAG: Integer coding of four fields
C         MOD(JFLAG,1000) (digits 1-3): Record No. of most recent recorded
C           pattern (NSORC) from which current pattern A1 derives. Leading
c           digit is rank in current Spin series
C         MOD(JFLAG/1000,10) (digit 4): Rotation MODE
C         MOD(JFLAG/10000,10) (digit 5): 1 if permutation/reflection has
C           occurred in derivation sequence between NSORC and A1; else 0
C         JFLAG/100000) (digit 6): Type of pattern; 1 or 2 if Oblique or
C           Orthogonal Spin, 3 if initiating input, 4 or 5 if VARIMAX or
C           EQUAMAX rotation of input, 6 if all free axes are item-aligned,
C           0 if MODE-controlled rotation.
      JSORC = MOD(JFLAG,1000)
      MODE = MOD(JFLAG/1000,10)
      IF(MODE/=MMD) LST(NN) = LST(NN)+1   ! Track MODE change
CCC      IF(BH/=BBH) LST(NN) = LST(NN)+2  ! Compiler flags possible rounding artifact
      IF(ABS(BH-BBH)>.001) LST(NN) = LST(NN)+2     ! Track BH change
      JRFL = MOD(JFLAG/10000,10) !
      JTYP = JFLAG/100000; IF(JTYP>2) JS = 1 ! Save previous JS just in Spin series
      IF(JTYP==1 .OR. JTYP==2) THEN
        J = JSORC/100; JSORC = MOD(JSORC,100)
        IF(J<=1) JS = 1; IF(J>1) JS = JS+1  ! Rank in series
      END IF
      NTOT = NN; N = NF; OB = 0.
      B = BH-MIN(1,INT(BH))*(BH-.20)   ! B is BH if BH<1, otherwise is .20
      CALL BUFF(A1,BH,NTOT,RECORD)
      DO J = 2,MF; DO I = 1,J-1
        OB = MAX(OB,ABS(C1(I,J)))
      END DO; END DO
      WRITE(6,'(" Retrieving log record of Pattern No. ",A)')
     +  CF(:JF(NN))
      IF(JTYP==3) THEN  ! Initial input (should always be Rec 1)
        CALL SEEFIX(NN,NF,NB,FIX,FIX1,NZ)  ! NZ is number of waifs
        WRITE(7,'(/" Initial rotation parameters: Mode = ",A,", <BH,C",
     +    "V> = <",A3,",",A4,">; <JA,JB> = <",I2,",",I2,">; PD = ",A3,
     +    ";"/4X,"WSAL =",A4,"; <B1,DB> = <",A4,",",A4,">; <B0,DF,CL",
     +    "OSE,> = <",A4,",",A4,",",A4,">; IMAX = ",A,".")') WRD(MODE),
     +    CLN(BH,3,2),CLN(CV,4,1), JA, JB, CLN(PD1,3,1), CLN(WSAL,4,1),
     +    CLN(B1,4,2), CLN(DB,4,1), CLN(B0,4,2), CLN(DF,4,2),
     +    CLN(CLOSE,4,1), CF(:JF(IMAX))
        WRITE(7,'(//1X,15("= ")," Pattern No. ",A," (input: obliquity",
     +    A4,")",15(" ="))') CF(:JF(NN)), CLN(OB,4,2)
        WRITE(7,'(16X,"[ A rotation''s ""obliquity"" is its largest ",
     +    "factor correlation ]")')

CC     ELSE IF(ICYC==-2) THEN
CC       WRITE(7,'(//1X,8("* ")," Pattern No. ",A," is a Power-",I2
CC    +    ," PROMAX",A,"rotation.  Its hyperplane percents at BH = ",
CC    +   A3," are")') CF(:JF(NN)), KPRO, LBL(:LL), CLN(B,3,2)
CC     ELSE IF(ICYC==-3) THEN  ! *** If ever reactivated, revise ICYC codes
CC        WRITE(7,'(//1X,8("* ")," Pattern No.",I3," is a proc",
CC     +    "rustes match to target by HYSCOR.  Its hyperplane per",
CC     +    "centages (BH = ",A3,") are")') NN, CLN(BH,3,2)
CC      ELSE IF(ICYC==-4) THEN
CC        WRITE(7,'(//1X,8("* ")," Pattern No.",I3," is the so",
CC     +    "urce pattern in a HYSCOR archive.  Its hyperplane per",
CC     +    "centages (BH = ",A3,") are")') NN, CLN(BH,3,2)

      ELSE   ! Rotation MODE=4 is Oblimin
        FMT1 = ' (Gam = xx.x)'; IF(MODE==4) FMT1(9:12) = CLN(-T,3,1)
        WRITE(7,'(//1X,5("* ")," Pattern No. ",A," (obliquity",A4,
     +    ", launched from pattern No. ",A,") ",5(" *"))') CF(:JF(NN)),
     +    CLN(OB,4,2), CF(:JF(JSORC))
        CH2 = 'n '
        IF(JTYP==6) THEN
          WRITE(7,'(/" All ",A," free factor axes in this pattern",
     +      " have been aligned with data variables.")')
     +      CF(:JF(NINT(TT)))
        ELSE IF(JTYP>=4) THEN  ! 4 for Varimax, 5 for Equimax
          WRITE(7,'(27X,"This is a",2A,"MAX rotation.")')
     +     CH2(6-JTYP:2), CH4(JTYP-3)
        ELSE IF(JTYP==0) THEN
          IF(JSORC==NN-1) WRITE(7,'(7X,"This continues rotati",
     +      "on of current pattern No. ",A," in mode ",2A)')
     +      CF(:JF(NL)), WRD(MODE), FMT1(:1+12*(MODE/4))
          IF(JSORC<NN-1) WRITE(7,'(9X,"<< This rotates retrie",
     +      "ved pattern No. ",A," in mode ",2A," >>"/)')
     +      CF(:JF(JSORC)), WRD(MODE), FMT1(:1+12*(MODE/4))
          IF(JRFL>0) WRITE(7,'(/4X,"=> This rotation in mode ",2A,
     +     " began by permuting/reflecting pattern No. ",A," <="/
     +     )')  WRD(MODE), FMT1(:1+12*(MODE/4)), CF(:JF(JSORC))
        ELSE IF(JTYP<=2) THEN
          WRITE(7,'(6X,"####   This is a SPIN rotation in mode ",
     +      2A,", ranked ",A," in series   ####")') WRD(MODE),
     +      FMT1(:12*(MODE/4)), CF(:JF(JS))
C        ELSE IF(JTYP==2) THEN  ! Not curently installed
C          WRITE(7,'(14X,"####     This is an ORTHOGONAL SPIN rotat",
C     +      "ion    ####")')
        END IF
      END IF
      KK = 0
      DO I = 1,NF
        IF(FIX(I)/=FX(I)) KK = 1
      END DO
      DO I = 1,NB
        IF(FIX1(I)/=FX1(I)) KK = 1
      END DO
      IF(KK/=0) CALL SEEFIX(NN,NF,NB,FIX,FIX1,NZ)
      KK = 0
      DO I = 1,NPFIX
        IF(PFIX1(I)/=PFX1(I)) KK = 1
      END DO
      IF(KK>0 .AND. NPFIX/=0) WRITE(7,'(4X,"Fixate pattern columns",
     +  30I3)') (PFIX1(I),I=1,NPFIX)
      IF(KK>0 .AND. NPFIX==0) WRITE(7,'(4X,"Remove all pattern-column",
     +  " fixations.")')
      IF(SHFT(MODE*1.,MMD*1.,1.,1.,1.,1.)) WRITE(7,'(4X,"Change to Mo",
     +  "de ",A)') WRD(MODE)
      IF(SHFT(BH,BBH,CV,CCV,1.,1.)) WRITE(7,'(4X,"Change to <BH,CV> =",
     +  " <",A3,",",A4,">")') CLN(BH,3,2), CLN(CV,4,1)
      IF(SHFT(JA*1.,JJA*1.,JB*1.,JJB*1.,1.,1.)) WRITE(7,'(4X,"Change ",
     +  "to <JA,JB> = <",I2,",",I2,">")') JA, JB
      IF(SHFT(PD1,PPD1,1.,1.,1.,1.)) WRITE(7,'(4X,"Change to PD =",
     +  A4)') CLN(PD1,4,2)
      IF(SHFT(WSAL,WWSAL,1.,1.,1.,1.)) WRITE(7,'(4X,"Change to WSAL = ",
     +  A4)') CLN(WSAL,4,2)
      IF(SHFT(B1,BB1,DB,DDB,1.,1.)) WRITE(7,'(4X,"Change to <B1,DB> =",
     +  " <",A4,",",A4,"> (STEP parameters)")') CLN(B1,4,2),CLN(DB,4,1)
      IF(SHFT(B0,BB0,CLOSE,CCLOSE,DF,DDF)) WRITE(7,'(4X,"Change to <",
     +  "B0,DF,CLOSE> = <",A4,",",A4,",",A4,">")') CLN(B0,4,2),
     +  CLN(DF,4,2), CLN(CLOSE,4,1)
      IF(SHFT(IMAX*1.,IIMAX*1.,1.,1.,1.,1.)) WRITE(7,'(4X,"Change to ",
     +  "IMAX = ",A)') CF(:JF(IMAX))
      IF(ICYC/1000>IICYC/1000) WRITE(7,'(/" Changes in rotation constr",
     +  "aints before solution No. ",A,":"/" Deletion of the HYBLOCK-i",
     +  "nput flag to allow changes in block structure.")') CF(:JF(NN))
      IF(NOM/=NM) GOTO 110
      DO I = 1,NOM
        IF(OMIT(I)/=OMT(I)) GOTO 110
      END DO
      GOTO 125
110   WRITE(7,'(/" Item omissions are changed for rotation ",A,
     +  )') CF(:JF(NN))
C ***** Report of item omissions archived in new OMIT not installed.
      IF(NOM==0.AND.NM>0) WRITE(7,'(" cancellation of all omissions.")')
125   IF(T<0.)  WRITE(7,'(/" This aligns ",A," factors with variabl",
     +  "es.")') CF(:JF(NF))
      IF(T>=0. .AND.JTYP==0) WRITE(7,'(/" This rotation by ",A," stop",
     +  "ped after ",A," iteration cycles (limit, ",A,")")') WRD(MODE),
     +   CF(:JF(MOD(ICYC,1000))), CF(:JF(IMAX))
      IF(JTYP==3) WRITE(7,'(/" The input pattern''s hyperplane percen",
     +  "tages for BH = ",A3," are")') CLN(B,3,2)
      IF(JTYP==3) GOTO 150
CC      IF(JTYP>=4) WRITE(7,'(/" The +/- ",A3," hyperplane percen",
CC     +  "tages of this ",A,"MAX rotation are")') CLN(B,3,2),
CC     +  CH4(JTYP-3)
      WRITE(7,'(" Its +/- ",A3," hyperplane percentages are")')
     +  CLN(B,3,2)
150   WRITE(7,'(I5,". (Total =",A5,") ",18A5,9(:/22X,10A5))') NN,
     +  (CNVT(RECORD(NN,J)),J=0,NF)
      WRITE(7,'()')
      CALL SPRED(NV,NF,A1,MIN(B,.40),MV,NLD,QY,K1,7)
      BACKSPACE 8
      READ(8) NL, ((X,I=1,MV),J=1,MF), ((X,I=1,MF),J=1,MF), L, BBH,
     +  CCV, JJA, JJB, WWSAL, PPD1, NM, (OMT(I),I=1,NM),(FX(I),I=1,MF),
     +  NNB, (FX1(I),I=1,NNB), NNPFX, (PFX1(I),I=1,NNPFX), BB0, BB1,
     +  DDB, DDF, CCLOSE, IIMAX, IICYC, T, JFL
      MMD = MOD(JFL/1000,10)
      IF(MOD(IICYC,1000)<0) CCV = 1.
      GOTO 100
C
C Generate nonrelational pattern appraisals
198   CALL WAIT(1)   ! Maybe not really wanted
199   DEALLOCATE ( CFF, FIX, FX1, LST2, PFIX1, PFX1, RECORD )
      ALLOCATE ( STOR(NREC,0:MF+1) )
      OPEN(19,FORM='UNFORMATTED',STATUS='SCRATCH')
      WRITE(19) (COMM(LST1(I)),I=1,NV)
      WRITE(19) (SQRT(COMM(LST1(I))),I=1,NV)  ! Setup for Kaiser norming
      WSAL = 0.; BH = .20
200   WRITE(7,'(//1X,22("=")," HYPERPLANE APPRAISALS ",30("="))')
      IF(LST(1)>=0) WRITE(7,'(2X,"""m"" or ""b"" flags patterns ",
     +  "whose Mode or BH differs from the preceding one")')
      QY = .TRUE.    ! T flags that no hyp-appraisals have been recorded
C      ^ QY = F set just before Label 300
201   CALL SYSTEM('cls')
      WRITE(6,'(/5X,"Nonrelational pattern-appraisal options now avail",
     +  "able:"//5X,"1.  Show each pattern''s hyperplane percents at a",
     +  " stipulated bandwidth."/5X,"2.  Show each pattern''s factor-c",
     +  "omplexity distribution relative to a"/11X,"stipulated hyperpl",
     +  "ane bandwidth (""B-complexity"")."/5X,"3.  Show each pattern",
     +  "''s factor complexity measured by average loading"/11X"concent"
     +  "ration at ascending factor levels (""L-complexity"")."/5X,"4.",
     +  "  Appraise each pattern for gaps in its scatter of nonsalient",
     +  " loadings."/5X,"5.  Show each pattern''s hyperplane-misfit ap",
     +  "praisal under a choice of"/11X,"rotation parameters, expresse",
     +  "d in proportion to the best result"/11X,"by this measure.")')

C     Nonrelational pattern-appraisal options now available.
C     1.  Show each pattern's hyperplane percents at a stipulated bandwidth.
C     2.  Show each pattern's factor-complexity distribution relative to a
C           stipulated hyperplane bandwidth ("B-complexity").
C     3.  Show each pattern's factor complexity measured by average loading
C           concentration at ascending factor levels ("L-complexity").
C     4.  Appraise each pattern for gaps in its scatter of nonsalient loadings.
C     5.  Show each pattern's hyperplane-misfit appraisal under a choice of
C           rotation parameters, expressed in proportion to the best result
C           by this measure.

205   WRITE(6,'(/" To choose one of these, enter its index.  Other",
     + "wise hit RETURN to make"/" congruence comparisons ",
     + "between patterns, or enter any letter to quit."/)')
      CALL SCAN(J,1,'I',5)
      IF(J==0) THEN
        IF(QY) THEN
          BACKSPACE 7; BACKSPACE 7; BACKSPACE 7; BACKSPACE 7
        END IF
        GOTO 300
      END IF
      IF(J<0) GOTO 500
      READ(2,*) JOB
      IF(JOB<1 .OR. JOB>5) GOTO 205
      WRITE(6,'(/"   To start computation of the Option",I2," app",
     +  "raisal, hit RETURN.  Otherwise,"/"   enter any letter to",
     +  " start with a brief explanation of this measure,"/3X,"or",
     +  " any number to return to the Options menu."/)') JOB
      CALL SCAN(J,1,'I',5)
      IF(J>0) GOTO 201
      IF(J<0) CALL BLURB(JOB,NF,6)
      IF(NW(JOB)) CALL BLURB(JOB,NF,7)
      IF(NW(JOB)) NW(JOB) = .FALSE.
      CALL RATE(JOB,A1,C1,CV,WSAL,LTMP,LST,LST1,K1,QS,STOR)
      QY = .FALSE.   ! Don't backspace over section-head printout
      GOTO 201
C
C Record congruence information
300   NEW = 1
      QY = .FALSE.
      IF(ALLOCATED(STOR)) DEALLOCATE ( STOR )
      IF(.NOT.ALLOCATED(CC)) ALLOCATE ( CC(MRC), KC(MRC,MK),
     +  KNT(MK,NREC,NF), LST2(2*NREC) )
C           LST2 needs at most NREC unless list assembly needs workspace
      CALL SYSTEM('cls')
      WRITE(6,'(22X,"*** CONGRUENCE REPORT TIME ***")')
      NLST = 0
      WRITE(6,'(/3X,"You have four ways to select the stored patter",
     +  "ns whose congruences will"/3X,"be reported.  (a) To sele",
     +  "ct All, simply hit RETURN.  (b) To select all"/3X,"from ",
     +  "No. L to No. ",A,", enter just index L.  (c) To create a",
     +  " selection that"/3X,"includes all from No. L to No. M, ty",
     +  "pe L and M and hit RETURN; you will"/3X,"be allowed to in",
     +  "clude others as well.  (d) Typing three or more indices"/3X,
     +  "followed by RETURN adds these to the selection list and ",
     +  "allows continuation."/3X,"(Entering any letter aborts co",
     +  "ngruence comparison and exits program.)")') CF(:JF(NTOT))
401   IF(NLST==0) WRITE(6,'(/" ALL patterns are now on your selec",
     +  "tion list for congruence comparisons.")')
      IF(NLST>0) WRITE(6,'(/" The patterns selected for congruen",
     +  "ce comparisons are now",2(:/4X,25I3)))') (LST2(I),I=1,NLST)
      WRITE(6,'(" Hit RETURN if OK, or enter one or more pattern ",
     +  "indices to choose otherwise."/)')
      CALL SCAN(J,0,'I',5)
      IF(J<0) GOTO 500
      IF(J==0) GOTO 430

      NX = 0
405   READ(2,*) (LST2(NX+I),I=1,J)   ! Add to the NX already on list
      IF(J==1 .AND. NX==0) THEN
        L = LST2(1)-1    ! L is index just below entry
        NLST = NTOT-L
        DO I = L+1,NTOT
          LST2(I-L) = I
        END DO
        GOTO 401
      ELSE IF(J==2) THEN
        L1 = MAX(1,MIN(NTOT,LST2(NX+1),LST2(NX+2)))-1
        L2 = MIN(NTOT,MAX(1,LST2(NX+1),LST2(NX+2)))
        DO I = 1,L2-L1
          LST2(NX+I) = L1+I
        END DO
        NX = NX+L2-L1
      ELSE
        NX = NX+J
      END IF
      WRITE(6,'(" Enter more pattern indices, or hit RETURN to see"
     +  " completed listing."/)')
      CALL SCAN(J,0,'I',5)
      IF(J>0) GOTO 405
      NLST = 0
      LP1: DO I = 1,NTOT
        DO J = NLST+1,NX
          IF(I==LST2(J)) THEN
            NLST = NLST+1
            LST2(J) = LST2(NLST)
            LST2(NLST) = I
            CYCLE LP1
          END IF
        END DO
      END DO LP1
      GOTO 401
430   IF(NLST>0) GOTO 306
      NLST = NTOT
      DO I = 1,NLST
        LST2(I) = I
      END DO

306   IF(QY) WRITE(6,'(/" If you want congruence reports to include",
     +  " identification of matching factors,"/" hit RETURN.  Othe",
     +  "rwise, enter anything for less cluttered reports.")')
      IF(.NOT.QY) WRITE(6,'(/" If you want congruence reports to wa",
     +  "ive identification of matching factors,"/" hit RETURN.  ",
     +  "Otherwise, enter anything for more fulsome reports.")')
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 310
      QY = .NOT.QY
      GOTO 306

310   IF(NEW==1) THEN
        WRITE(7,'(//1X,11("==")," PATTERN DIVERGENCES ",16("=="))')
        NEW = 0; NGAP = -1
        WRITE(7,'(/" In each row M of the congruence report for a pat",
     +    "tern pair <L,M>, entry J is the angle in degrees of"/" con",
     +    "gruence divergence between the Jth column of pattern L and",
     +    " its counterpart in the best-matching")')
        IF(.NOT.QY) WRITE(7,'(" permutation of pattern M.  "" * "" si",
     +    "gnals that the permutation is proper.")')
        IF(QY) WRITE(7,'(" permutation of pattern M. Each entry J in",
     +    "cludes in brackets the index of the pattern-M column "/
     +    " matched to pattern L''s column J.")')
      END IF
      IF(NF<3) THEN; NGAP = 0; GOTO 314; END IF
      WRITE(6,'(/4X,"You may also call tables showing, for each pair ",
     +  "of solutions in the range"/4X,"selected, how many of their m",
     +  "atched columns have congruence divergence"/4X,"less than GAP",
     +  ", and for each solution how frequently each of its pattern"/
     +  4X,"columns is matched within distance GAP in the other solut",
     +  "ions, for your"/4X,"choice of one or more values of GAP.  To",
     +  " omit this information, enter any"/4X,"letter.  Otherwise, ",
     +  "enter one or more GAP choices between 1.0 and 90.0,"/4X,"or ",
     +  "hit RETURN to select just GAP =",A5,"."/)') CLN(GAP,5,1)
312   IF(NGAP>0) THEN  ! Replace GP in old code by COMM
        WRITE(6,'(/" Your GAP selection is now",2X,10A5)')
     +   (CLN(COMM(I),5,1),I=1,NGAP) ! GP <- COMM
        WRITE(6,'(" Hit RETURN if OK.  Otherwise, enter revised se",
     +   "lection or any letter to cancel."/)')
      END IF
      CALL SCAN(J,0,'R',5)
      IF(J<0) THEN
        NGAP = 0
        GOTO 319
      ELSE IF(J==0) THEN
        IF(NGAP>=0) GOTO 314
        NGAP = 1
        COMM(1) = GAP
        GOTO 314
      END IF
      NGAP = MIN(MK,J)
      READ(2,*) (COMM(I),I=1,NGAP)
      DO I = 1,NGAP
        COMM(I) = MAX(1.,MIN(90.,COMM(I)))
      END DO
      GOTO 312
314   KK = 0
      KNT = 0
      DO L = 1,NGAP
        DO M = 1,NTOT
          KC(LO(M,M),L) = NF
        END DO
      END DO
      CC(LO(LST2(NLST),LST2(NLST))) = 0.
319   BIG: DO MM = 1,NLST-1
        M = LST2(MM)
        CC(LO(M,M)) = 0.
        REWIND 8
321     READ(8) I
        IF(I<M) GOTO 321
        BACKSPACE 8
        READ(8) I, ((A1(J,K),J=1,MV),K=1,MF)
        IF(QS) CALL STRIP(A1,C1,LST2,K1,1)  ! Reduce pattern/Covs to factors called
        IF(NTOT-I>4) WRITE(6,'(" Computing congruences for ",
     +    "pattern No. ",A)') CF(:JF(I))
        IF(NTOT-I==4) WRITE(6,'(" Computing congruences for ",
     +    "patterns ",A," - ",A)') CF(:JF(I)), CF(:JF(NTOT))
        WRITE(7,'(/" Congruence match (degrees divergence) of patt",
     +    "ern No. ",A," to pattern")') CF(:JF(I))
        KK = KK+2
        BG: DO JJ = MM+1,NLST
          J = LST2(JJ)
322       READ(8) N, ((T1(I,L),I=1,MV),L=1,MF)
          IF(QS) CALL STRIP(T1,C1,LST2,K1,1)
          IF(N<J) GOTO 322
          CALL ALIGN(T1,A1,ORDER,DG(1),NV,NF,CH,RAD,AV1)
          DO K = 1,NF
            FX(ABS(ORDER(K))) = K
          END DO
C           Since no permutation needs be passed, the wanted order can be set
C           in ALIGN directly by reversing NI and NJ in ORDER specification.
          CC(LO(M,J)) = AV1
          DO L = 1,NGAP
            GAP = COMM(L)
            KT = 0
            DO K = 1,NF
              IF(DG(FX(K))<GAP) THEN
                KT = KT+1
                KNT(L,J,K) = KNT(L,J,K) + 1
                KNT(L,M,FX(K)) = KNT(L,M,FX(K)) + 1
C                  J is the pattern which ALIGN permutes to match pattern M.
C                  ORDER(I) is the M-factor matched with J-factor I, while DG(I)
C                  is the Ith M-factor's congruence with the matched J-factor.
C                  FX is the inverse of ORDER with reflection signs removed.
              END IF
            END DO
            KC(LO(M,J),L) = KT
          END DO
          IF(QY) WRITE(7,'(2X,I3,": (Av =",A5,") ",10(A5," [",I2,"]":
     +      ","),9(/18X,10(A5," [",I2,"]":",")))') J, CLN(AV1,5,1),
     +     (CLN(DG(I),5,1),FX(I),I=1,NF)
          IF(.NOT.QY) WRITE(7,'(1X,A,I3,": (Av =",A5,") ",20A5,9(:/18X,
     +      20A5))') CH,J, CLN(AV1,5,1), (CLN(DG(I),5,1),I=1,NF)
          IF(NF<=12) KK = KK+1
          IF(NF>12) KK = KK+2
C           If NF>12, each congruence string needs two lines on screen.
        END DO BG
      END DO BIG

      WRITE(7,'(/25X,"Congruence Summary:"/" For each pair of these s",
     +  "olutions, the average divergence of their matched columns"/)')
      DO II = 1,NLST
        I = LST2(II)
        WRITE(7,'(I5,": ",25A5, 5(:/7X,25A5) )') I, (CLN(
     +    CC(LO(LST2(JJ),LST2(II))),5,1),JJ=1,II)
      END DO
      IF(NGAP<=0) GOTO 345
      LPA: DO 340 L = 1,NGAP
        GAP = COMM(L)
        WRITE(7,'(/25X,"Congruence Centrality Count, GAP =",F5.1,":"/
     +    " For each factor in each solution, the number of other li",
     +    "sted solutions in which its closest match"/" diverges from",
     +    " it by at most",F5.1,A,".  ""Av"" is mean rounded to the ",
     +    "nearest integer. ")')  GAP, GAP, U2
        WRITE(7,'(/12X,"Factor: ",25I4,10(:/20X,25I4))') (J,J=1,NF)
        WRITE(7,'(1X,200A)') ('',I=1,MIN(120,20+4*NF))
        DG = 0.
        DO II = 1,NLST
          I = LST2(II)
          K = 0
          DO J = 1,NF
            DG(J) = DG(J) + KNT(L,I,J)
            K = K + KNT(L,I,J)
          END DO
          DG(0) = DG(0) + K
            WRITE(7,'(I4,": (Total =",I4,") ",25I4,5(:/20X,25I4))')
     +        I, K, (KNT(L,I,J),J=1,NF)
        END DO
        DO J = 0,NF
          DG(J) = DG(J)/NLST
        END DO
        WRITE(7,'(1X,200A)') ('',I=1,MIN(120,20+4*NF))
        WRITE(7,'("  Av: (Total = ",A4,") ",25(1X,A3),10(:/20X,25(1X,
     +   A3)))')  CLN(DG(0),4,1), (CLN(DG(J),3,1),J=1,NF)
        WRITE(7,'(/25X,"Congruence Similarity Count, GAP =",F5.1,":"/
     +    " For each pair of solutions, their number of matched pat",
     +    "tern columns with congruence divergence less than",F5.1,A,
     +    ".")') GAP, GAP, U2
        DO II = 1,NLST
          I = LST2(II)
          IF(NLST<=30) WRITE(7,'(I5,": ",100I4)') I,(KC(LO(LST2(JJ),
     +      LST2(II)),L),JJ=1,II)
          IF(NLST>30) WRITE(7,'(I5,": ",100I3)') I,(KC(LO(LST2(JJ),
     +      LST2(II)),L),JJ=1,II)
        END DO
        KPN = 1
        WRITE(7,'(/16X,"Congruence Similarity Clusters at GAP =",F5.1/
     +    " For the more salient Congruence Similarity Counts (level",
     +    "s of pattern match) shown in the table above,"/" each row",
     +    " below indexes a cluster of three or more factor patterns",
     +    " wherein each pattern matches every "/" other at the indi",
     +    "cated similarity level, followed in brackets by this clus",
     +    "ter''s penumbra "/" containing patterns almost this close",
     +    " (Match at ",A," level lower) to at least one cluster mem",
     +    "ber. ]"/)') GAP, CF(:JF(KPN))
        CALL CLUST(KPN,NLST,LST2,KC(1,L))
340   END DO LPA
345   WRITE(6,'(/" To call another selection of congruence reports,",
     +  " enter anything.  Otherwise,"/" hit RETURN to quit.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 300
500   WRITE(6,'(/" LOG retrieval is complete.  Results are in file ",
     +  A)') F2
      STOP
      END
C
      SUBROUTINE ALIGN(A,B,ORDER,DG,NV,NF,CH,RAD,AV)
C This compares the columns of NV-by-NF matrix A to those of matrix B, and puts
C into vector ORDER the permutation (and reflection if signalled by negative
C ORDER value) of A's columns that aligns A with B most closely. The congruence
C coefficients for the best match are converted to degrees difference and
C reported in vector DG with their average in AV and max in HI.  And CH returns
C '*' if optimal axis alignment requires a proper (non-identity) permutation.
      CHARACTER CH
      INTEGER ORDER(*)
      REAL A(NV,*), B(NV,*), DG(*), WORK(NV,NF), WK(NV,2)
      DO J = 1,NF
        ORDER(J) = 0
        WK(J,1) = 0
        WK(J,2) = 0
        DO I = 1,NV
          WK(J,1) = WK(J,1) + A(I,J)*A(I,J)
          WK(J,2) = WK(J,2) + B(I,J)*B(I,J)
        END DO
      END DO
      DO J = 1,NF
        DO K = 1,NF
          SAB = 0
          DO I = 1,NV
            SAB = SAB + A(I,J)*B(I,K)
          END DO
          WORK(J,K) = SAB/SQRT(MAX(WK(J,1)*WK(K,2),1.E-8))
        END DO
      END DO
      CH = ' '
      AV = 0.
      BIG: DO K = 1,NF
        NI = 0
        NJ = 0
         X = 0.
        BG: DO J = 1,NF
          DO L = 1,NF
            IF(ABS(ORDER(L))==J) CYCLE BG
C             Skip J if already matched
          END DO
          DO I = 1,NF
            IF(ORDER(I)/=0) CYCLE
C             Skip I if already matched
            R = ABS(WORK(I,J))
            IF(R<X) CYCLE
            X = MIN(1.0,R)
            NI = I
            NJ = J
          END DO
        END DO BG
        ORDER(NI) = SIGN(NJ,FLOOR(WORK(NI,NJ)))
C         A-factor NI matches B-factor NJ while negative NJ tells PERM to reflect.
C         ORDER permutes A into B-matching order.
        IF(NI/=NJ) CH = '*'
        DG(NJ) = ACOS(X)*RAD
C         DG(J) is divergence of B-factor J from its matching A-factor
C         DG(ABS(ORDER(K))) is divergence of A-factor K from matching B-factor
        AV = AV+DG(NJ)
      END DO BIG
      AV = AV/NF
      END SUBROUTINE
C
      FUNCTION BN(N)
c Converts block integer code N into the block's letter code
      CHARACTER BN
      IF(N==99) THEN
        BN = 'Y'
      ELSE IF(N==0) THEN
        BN = 'X'
      ELSE IF(N<0) THEN
        BN = 'Z'
      ELSE
        BN = CHAR(64+N)
      END IF
      END FUNCTION
C
      SUBROUTINE BLURB(JOB,NF,KF)
      CHARACTER CF*12
      COMMON /CF/ CF
      IF(JOB>1) GOTO 10
      WRITE(KF,'(/2X,"HYPERPLANE PERCENT table at bandwidth BH:"/2X,
     +  "Each pattern row''s Jth entry (J = 1,...,",A,") after Mean ",
     +  "is this pattern''s"/"  percent of variables whose loadings ",
     +  "on factor J are smaller than BH.")') CF(:JF(NF))
      RETURN
10    IF(JOB>2) GOTO 20
      WRITE(KF,'(/2X,"B-COMPLEXITY table at bandwidth BH:"/2X,"Each "
     +  "pattern row''s Jth entry (J = 0,1,2,... ) after Mean is th",
     +  "is pattern''s"/"  percent of variables having loadings lar",
     +  "ger than BH on exactly J factors.")')
      RETURN
20    IF(JOB>3) GOTO 30


C   L-COMPLEXITY table:
C   For each J = 1,2,..,n in a given pattern, let the square of any item's
C   Jth largest loading divided by its sum of squared loadings plus its
C   uniqueness, be called that item's "mass" at complexity level J.  Then
C   the pattern's L(oading)-strength at level J, shown by the table's Jth
C   entry after AV, is the mean mass of its items at level J times 100.
C   And its overall L-complexity (AV) is the mean level in its L-strength
C   distribution.  (This measure is parameter-free.)

      WRITE(KF,'(/3X,"L-COMPLEXITY table:"/3X,"For each J = 1,2,..",
     + ",",A," in a given pattern, let the square of any item''s"/
     +  3X,"Jth largest loading divided by its sum of squared loadin",
     +  "gs plus its"/3X,"uniqueness, be called that item''s ""ma",
     +  "ss"" at complexity level J.  Then"/3X,"the pattern''s L(",
     +  "oading)-strength at level J, shown by the table''s Jth"/3X,
     +  "entry after AV, is the mean mass of its items at level J ti",
     +  "mes 100."/3X,"And its overall L-complexity (AV) is the me",
     +  "an level in its L-strength"/3X,"distribution.  (This mea",
     +  "sure is parameter-free.)")')  CF(:JF(NF))
      IF(KF.EQ.6) CALL WAIT(1)
      RETURN
30    IF(JOB>4) GOTO 40

cccC   L-COMPLEXITY table ("L" for Loading and Level):
cccC   For each L = 0,1,..,NF in a given pattern, let an item's "concentration"
cccC   at level L be its variance accounted for by the L common factors on which
cccC   its loadings are largest (zero for L=0), scaled as a proportion of its
cccC   communality.  And say that the item's L-complexity at level L = 1,2,...
cccC   is its increment in L-concentration from level L-1 to level L.  Then the
cccC   L-complexity profile shown in this table's row following column ML for
cccC   each pattern is the curve on L = 1,2,..,NF whose value Comp(L) at each
cccC   level is the mean L-complexity of this pattern's items at that level.
cccC   And a pattern's ML rating is its profile mean, that is,  LComp(L).
ccc
ccc      WRITE(6,'(/3X,"L-COMPLEXITY table (""L"" for Loading and Level):"/
ccc     +  3X,"For each L = 0,1,..,NF in a given pattern, let an item''s ",
ccc     +  """concentration"""/3X,"at level L be its variance in the s",
ccc     +  "pace of the L common factors on which"/3X,"its loadings are ",
ccc     +  "largest (zero for L=0), scaled as a proportion of its"/3X,"co",
ccc     +  "mmunality.  And say that the item''s L-complexity at level L ",
ccc     +  "= 1,2,..."/3X,"is its increment in L-concentration from level",
ccc     +  " L-1 to level L.  Then the "/3X,"L-complexity profile shown ",
ccc     +  "in this table''s row following column ML for"/3X,"each patte",
ccc     +  "rn is the curve on L = 1,2,..,NF whose value Comp(L) at each"/
ccc     +  3X,"level is the mean L-complexity of this pattern''s items ",
ccc     +  "at that level."/3X,"And a pattern''s ML rating is its profi",
ccc     +  "le mean, that is,  LComp(L).")')
ccc      IF(KF==6) CALL WAIT(1)
ccc      RETURN
ccc30    IF(JOB>4) GOTO 40

C  NONSALIENT-GAPPINESS table for salience floor SF:
C  Let a pattern column's loadings be ordered in increasing size up to the
C  first exceeding a value SF construed as weak salience.  Then differences
C  between adjacent terms in this series are the nonsalient-loading gaps in
C  this pattern column; and an abstraction -- here called "Reach[K]" -- from
C  this distribution is a measure of gap-heterogeneity whose larger values
C  diagnose patterns wherein large gaps may manifest natural hyperplane
C  boundaries.  The Jth entry after Mean in each pattern's row in this table
C  gives this <K,SF>-parameterized measure of gappiness (generally times 10
C  or 100 for display convenience) for the pattern's Jth factor, while the
C  mean of these is the pattern's overall gappiness.  DETAILS: The Reach[K]
C  (K a positive integer) of a distribution d1,d2,... of magnitudes is here
C  defined to be the Kth root of the d-terms' Kth moment, divided by their
C  1st moment (arithmetic mean).  For K > 1, the Reach[K] of a magnitude
C  distribution primarily rates the standardized extremity of its largest
C  terms, with increasing K intensifying their emphasis.  To identify
C  patterns having the largest gaps separatomg small loadings best viewed as
C  recovery noise from the ones you hope are interpretively meaningful, make
C  SF a little larger than what you consider to verge on insignificance.
C  (Pattern rankings by this measure aren't very sensitive to choice of K.)

      WRITE(KF,'(/2X,"NONSALIENT-GAPPINESS table for salience floor ",
     +  "SF:"/2X,"Let a pattern column''s loadings be ordered in inc",
     +  "reasing size up to the"/2X,"first exceeding a value SF cons",
     +  "trued as weak salience.  Then differences"/2X,"between adjac",
     +  "ent terms in this series are the nonsalient-loading gaps in"/
     +  2X,"this pattern column; and an abstraction -- here called ""R",
     +  "each[K]"" -- from"/2X,"this distribution is a measure of gap-",
     +  "heterogeneity whose larger values"/2X,"diagnose patterns",
     +  " wherein large gaps may manifest natural hyperplane"/2X,"bo",
     +  "undaries.  The Jth entry after Mean in each pattern''s row ",
     +  "in this table"/2X,"gives this <K,SF>-parameterized measure ",
     +  "of gappiness (generally times 10"/2X,"or 100 for display con",
     +  "venience) for the pattern''s Jth factor, while the"/2X,"mean",
     +  " of these is the pattern''s overall gappiness.  DETAILS: The",
     +  " Reach[K]"/2X,"(K a positive integer) of a distribution d1,d",
     +  "2,... of magnitudes is here"/2X,"defined to be the Kth root ",
     +  "of the d-terms'' Kth moment, divided by their"/2X,"1st momen"
     +  "t (arithmetic mean).  For K > 1, the Reach[K] of a magnitude"/
     +  2X,"distribution primarily rates the standardized extremity of",
     +  " its largest"/2X,"terms, with increasing K intensifying their",
     +  " emphasis.  To identify"/2X,"patterns having the largest gaps",
     +  " separating small loadings best viewed as"/2X,"recovery noise",
     +  " from the ones you hope are interpretively meaningful, make"/
     +  2X,"SF a little larger than what you consider to verge on in",
     +  "significance."/2X,"(Pattern rankings by this measure aren''t",
     +  " very sensitive to choice of K.)")')
      RETURN

40    WRITE(KF,'(/2X,"HYPERPLANE-MISFIT table under rotation paramete",
     +  "rs <BH,JA,JB,CV,WSAL>:"/4X,"Each pattern row''s Jth unbracke",
     +  "ted entry (J = 1,2,...) is the relative"/4X,"misfit of facto",
     +  "r J''s hyperplane in this pattern according to the misfit"/4X,
     +  "measure picked by these rotation parameters.  The Mean and ",
     +  "SD of this"/4X,"pattern''s ",A," factor ratings are given in",
     +  " parentheses.  Ratings are given"/4X,"as proportions of this",
     +  " measure''s best mean over the patterns rated.")') CF(:JF(NF))

C   Each pattern row's Jth unbracketed entry (J = 1,2,...) is the relative
C   misfit of factor J's hyperplane in this pattern according to the misfit
C   measure picked by these rotation parameters.  The Mean and SD of this
C   pattern's factor ratings are given in parentheses.  Ratings are expressed
C   as proportions of this measure's best mean over the patterns rated.

      END SUBROUTINE
C
      SUBROUTINE BUFF(A1,BH,NTOT,RECORD)
C WARNING. This has been stripped for HYLOG use only, and also computes
C hyperplane percentages to one decimal.
      REAL A1(MV,MF)
      INTEGER RECORD(NREC,0:MF)
      COMMON /BL1/ MV, MF, NV, NF, NREC
C Count hyperplane percents and factor complexities
      IJSUM = 0
      B = BH-MIN(1,INT(BH))*(BH-.20)   ! B is BH if BH<1, otherwise is .20
      DO J = 1,NF
        IP = 0
        DO I = 1,NV
          IF(ABS(A1(I,J))<=B) IP = IP+1
        END DO
        IJSUM = IJSUM + IP
        RECORD(NTOT,J) = NINT((IP*1000.0)/NV)
      END DO
      RECORD(NTOT,0) = (IJSUM*1000.0)/(NV*NF)
      END SUBROUTINE
C
      SUBROUTINE CAP(WORD,L)
C This makes the first L letters in WORD all upper-case.
      CHARACTER WORD*(*)
      DO I = 1,L
        N = ICHAR(WORD(I:I))
        IF(N>=97 .AND. N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      END SUBROUTINE

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
C      SAVE /CF/  ! This doesn't appear to be needed
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      CLN = '        '
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      LD = ABS(ND)
CC      IF(ABS(X)<1.0E-12) THEN !  Special for vanishingly small X
      IF(ABS(X)<1.0E-6) THEN !  Special for vanishingly small X
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X))) !  M is space free for decimal (or M-1 if X<0) )
      IF(M<0 .OR.  M<1.AND.X<0.) GOTO 55
      IF(ND>=10) LD = 0; LD = MIN(LD,M)
      DO I = 1,KW
        WK(I) = ' '
      END DO
      IF(LD==0) N = NINT(ABS(X))         ! Shouldn't be needed, but is
      IF(LD/=0) N = NINT(ABS(X)*10**LD)  ! This can overflow if LD is large
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' *******'
      END FUNCTION
C
      FUNCTION COMP2(AJ,AK,SS)
C Given an item I's squared loadings AJ and AK on factors J,K and its sum
C of squared loadings SS, compute its Comp2 salience in plane JK as follows:
C P = (AJ+AK)/SS is its prominance of this plane in I's composition, and
C R = Min(|AJ|,|AK|)/MAX(|AJ|,|AK|) [or some monotone increasing function
C f(R) thereof] reflects the degree to which these two factors are equally
C prominant in I.  Then COMP2 = P*R (or [P*f(R)] equals 1.0 when item I lies
C entirely in plane JK with the same weight on both factors, and decreases
C to zero as either factor P or R decreases.
      P = (AJ**2 + AK**2)/SS
      BJ = ABS(AJ); BK = ABS(AK)
      R = MIN(BJ,BK)/MAX(BJ,BK,.0001)  ! AJ and AK can both be negligible
      COMP2 = P*R
      END FUNCTION
C
      SUBROUTINE CLUST(KPN,NLST,LST1,KC)
C Within pattern list LST1, find groups of factors within which the congruence-
C similarity counts recorded in KC all equal or exceed KNT for each level KNT.
C Store groups in the columns of LST. KPN is the penumbra distance from cluster.
      LOGICAL NWG, NWI, NWJ
      CHARACTER(2) CHA, CHB, CF*12, FMT*40, CH4
      INTEGER KKNT(0:MF), LSP(NREC), LST1(*)
      INTEGER LST(0:NREC,NREC), KC(*)  ! KC(_,K) in calling program for Gap-level K
      COMMON /BL1/ MV, MF, NV, NF, NREC
      COMMON /CF/ CF
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      KKNT = 0
      DO JJ = 2,NLST   ! KKNT(K) gets the number of pairs matching at level K
        J = LST1(JJ)
        DO II = 1,JJ-1
          I = LST1(II)
          KKNT(KC(LO(I,J))) = KKNT(KC(LO(I,J))) + 1
        END DO
      END DO
      MXX = NF+1
15    MXX = MXX-1
      IF(KKNT(MAX(0,MXX))==0) GOTO 15  ! Find highest match level
      KNT = MXX+1  ! Number of levels with 1 or more matches
      MARK = 0
50    KNT = KNT-1  ! Start new lower level
      MARK = MARK + KKNT(KNT)
      IF(KNT<=1) RETURN
      IF(MARK==0) GOTO 50   ! Omit display of this level if no new matches
      LEV = KNT-KPN  ! Match level for penumbra
      MARK = 0   ! MARK not needed?? (test of KKNT(KNT) seems to suffice)
C Find groups at level KNT
      NGRP = 0
      DO I = 1,NREC
        LST(0,NREC) = 0
      END DO
      BIG: DO JJ = 2,NLST
        J = LST1(JJ)
        BG: DO II = 1,JJ-1
          I = LST1(II)
          IF(KC(LO(I,J))<KNT) CYCLE BG
C Add to previous groups if possible; otherwise start new group
          IF(NGRP==0) GOTO 150
          NWG = .TRUE.
          LP1: DO NG = 1,NGRP
            NWI = .TRUE.
            NWJ = .TRUE.
            DO K = 1,LST(0,NG)
              KK = LST(K,NG)   ! Cycle unless KK matches both I,J at this level
              IF(KC(LOC(I,KK))<KNT.OR.KC(LOC(J,KK))<KNT) CYCLE LP1
              IF(I==KK) NWI = .FALSE.  ! Flag F if I or J already in group
              IF(J==KK) NWJ = .FALSE.
            END DO
            IF(NWI) LST(0,NG) = LST(0,NG)+1
            IF(NWI) LST(LST(0,NG),NG) = I
            IF(NWJ) LST(0,NG) = LST(0,NG)+1
            IF(NWJ) LST(LST(0,NG),NG) = J
            NWG = .FALSE.
          END DO LP1
          IF(.NOT.NWG) CYCLE BG
150       NGRP = NGRP+1  ! Start new group
          LST(0,NGRP) = 2
          LST(1,NGRP) = I
          LST(2,NGRP) = J
        END DO BG
      END DO BIG
      MXG = LST(0,1)
      DO I = 2,NGRP  ! Get size of largest group at this level
        MXG = MAX(MXG,LST(0,I))
      END DO
      IF(MXG==0) GOTO 50
      CH4 = '    '; IF(NGRP==0) CH4 = 'None'
      WRITE(7,'(/" Pattern clusters wherein each pair matches on",
     +  " at least ",A," factors at this GAP level: ",A)')
     +  CF(:JF(KNT)), CH4
      IF(NGRP>MAX((NLST)/2,8)) THEN
        WRITE(7,'(5X,"There are ",A," clusters at this match level,",
     +    " the largest containing ",A," patterns.")') CF(:JF(NGRP)),
     +    CF(:JF(MXG))
        IF(MXG<=NINT((NLST)/4.)) GOTO 50
        RETURN
      ELSE IF(MXG<=2) THEN
        IF(NGRP==1) WRITE(7,'(5X,"The only cluster at match level "
     +    A," is a doublet shown in the triangle table above.")')
     +    CF(:JF(KNT))
        IF(NGRP==2) WRITE(7,'(5X,"The two clusters at match level",
     +    1X,A," are both doublets.")') CF(:JF(KNT))
        IF(NGRP>2) WRITE(7,'(5X,"All ",A," clusters at match ",
     +    "level ",A," are doublets.")') CF(:JF(NGRP)),
     +    CF(:JF(KNT))
        GOTO 50
      END IF
      DO NG = 1,NGRP
        CALL ISORT(LST(0,NG),LST(1,NG))
      END DO
      K = 96
      MXQ = 0
      LPA: DO NG = 1,NGRP
C       First, list penumbra for this group in LSP. NP counts its size.
        NP = 0
        NL = LST(0,NG)
        LPB: DO I = 1,NF
          DO J = 1,LST(0,NG)
            IF(I==LST(J,NG)) CYCLE LPB
          END DO
          DO J = 1,NL
            IF(KC(LOC(I,LST(J,NG)))>=LEV) THEN
              NP = NP+1
              LSP(NP) = I
              CYCLE LPB
            END IF
          END DO
        END DO LPB
        MXQ = MAX(MXQ,NL+NP)
        CHA = CHAR(48+NL/10)//CHAR(48+MOD(NL,10))
        NQ = MAX(1,NP)
        CHB = CHAR(48+NQ/10)//CHAR(48+MOD(NQ,10))
        FMT = '(5X,A,".",'//CHA//'I3,:,"  [",'//CHB//'I3,"  ]")'
        K = K+1
        WRITE(7,FMT) CHAR(K), (LST(I,NG),I=1,LST(0,NG)),(LSP(I),I=1,NP)
      END DO LPA
      IF(MXQ>2+NLST/2 .OR. KNT<=MXX/2) RETURN
      GOTO 50
      END SUBROUTINE
C
      FUNCTION CNVT(N)
C The value returned is integer N written as a character string with a decimal
C before its last JD digits. JD and field width JF are subroutine parameters.
      PARAMETER (JD=1,JF=5)
      CHARACTER CNVT*5
      DO I = 1,JF
        CNVT(I:I) = ' '
      END DO
      K = JF-JD
      CNVT(K:K) = '.'
      N1 = N
      L = -1
20    L = L+1
      J = JF-L
      IF(J<=K) J = J-1
      IF(J<1) GOTO 50
      CNVT(J:J) = CHAR(48+MOD(N1,10))
      N1 = N1/10
      IF(N1>0) GOTO 20
      IF(CNVT=='100.0') CNVT = ' 100.'
      RETURN
50    DO I = 1,JF
        CNVT(I:I) = '*'
      END DO
      CNVT(1:1) = ' '
      RETURN
      END
C
      FUNCTION COD(N,L)
C Code nonneg integer N < 2700 as char string with letter coding part over 99.
C and blank for N=0.  L = 0 when called by PLOT or L=1 when called by SPRED.
      CHARACTER(3) COD
      COD = '   '
      IF(N<=0 .OR. N>=2700) RETURN
      IF(N<=9) THEN
        COD(2+L:2+L) = CHAR(48+N)
      ELSE IF(N<=99) THEN
        COD(2:3) = CHAR(48+N/10)//CHAR(48+MOD(N,10))
      ELSE
        COD = CHAR(96+N/100)//CHAR(48+MOD(N/10,10))//CHAR(48+MOD(N,10))
      END IF
      RETURN
      END
C
      SUBROUTINE DIST(N,CM,KF)
C The N entries in list CM are proportions.  The percent of entries that lie
C in interval J*.1 +/- .05 is displayed for each J = 1,...,10 in file KF
      CHARACTER(8) CLN
      REAL CM(*), P(10)
      DO J = 1,10
        P(J) = 0.
      END DO
      DO I = 1,N
        K = MAX(1,MIN(10,NINT(.5+CM(I)*10)))
        P(K) = P(K)+1.
      END DO

C   COMMUNALITIES DISTRIBUTION
C         Raw count  xx..xxxxx.x xx. xx. xx. xx. xx. xx. xx.
C     % in interval  x.x xx.xx.x xx. xx. xx. xx. xx. xx. xx.
C    Ŀ
C     Communality  0   .1   .2   .3   .4   .5   .6   .7   .8   .9   1.0

      WRITE(KF,'(/4X,"COMMUNALITIES DISTRIBUTION")')
      WRITE(KF,'(9X,"Raw Count ",10(A4,""))')
     +  (CLN(P(I),4,10),I=1,10)
30    DO J = 1,10
        P(J) = 100.*P(J)/N
      END DO
      WRITE(KF,'(5X,"% in interval ",10(A4,""))')
     +  (CLN(P(I),4,1),I=1,10)
      WRITE(KF,'(4X,13(""),"",10(""),"Ŀ")')
      WRITE(KF,'(5X,"Communality  0",9A5,A6,"")')
     +  (CLN(I/10.,5,1),I=1,9), CLN(1.0,6,1)
      END SUBROUTINE

      SUBROUTINE GETLST(N,LIST,J,NV)
C Enter N distinct indices no larger than NV into LIST in sequential order.
C LIST(N+_) receives in order the indices from 1 to NV omitted from LIST.
C LIST may be partly formed at input, SCAN provides the rest.
      INTEGER LIST(*), KW(2*NV)
      EXTERNAL SCAN    !          ^ May need slopover roon
      IF(N>0) WRITE(6,'(/4X,"Hit RETURN if correct and complete.  Ot",
     +  "herwise, enter additional"/4X,"indices or enter any letter ",
     +  "to clear list and start again."/)')
      CALL SCAN(J,0,'I',5)
      IF(N<0 .AND. J==0) RETURN
      IF(N>0 .AND. J<0) N = -1
      IF(J<=0) RETURN
      NX = MAX(0,N)
      DO I = 1,NX
        KW(I) = LIST(I)
      END DO
8     JJ = MIN(J,NV-NX)
      READ(2,*) (LIST(I),I=1,JJ)
      IF(J/=2) THEN
        DO I = 1,JJ
          KW(NX+I) = LIST(I)
        END DO
        NX = NX+JJ
      ELSE
        L = MAX(1,MIN(NV,LIST(1),LIST(2)))
        M = MIN(NV,MAX(1,LIST(1),LIST(2)))
        DO I = L,M
          KW(NX+I-L+1) = I
        END DO
        NX = MIN(NV,NX+M-L+1)
      END IF
25    WRITE(6,'(/" Enter more indices, or hit RETURN if list is ",
     +  "complete."/)')
      CALL SCAN(J,0,'I',5)
      IF(J<0) GOTO 25
      IF(J>0) GOTO 8
C Order list with any duplicates removed.
      CALL SORT(KW,NX,LIST,1,NV)
      DO I = 1,NX
        LIST(I) = KW(I)
      END DO
      N = NX
      J = N
      END SUBROUTINE
C
      FUNCTION LH(WORD,LN)
C Look for extension dot in WORD.  If found, LH returns number of characters
C prior to that; otherwise, LH returns full length LN of WORD.
      CHARACTER WORD*(*)
      N = LEN(WORD)
      LN = LAST(WORD,N)
      LH = LN
      IF(LN==0) RETURN
      DO LH = 1,LN-1
        IF(WORD(LH+1:LH+1)=='.') RETURN
      END DO
      END FUNCTION
C
      FUNCTION LAST(WORD,M)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as the function value. If the string is empty, LAST is returned as 0.
      CHARACTER WORD*(*)
      WORD(:M) = ADJUSTL(WORD(:M))
      LAST = LEN_TRIM(WORD(:M))
      END FUNCTION
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
      LOGICAL PRM, QY, QLOG
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP
      CHARACTER E   ! <<<  Special characters as needed
      WD = GET
      M = LAST(WD,40)
      LL = 1
5     LL = LL+1
      E = WD(LL+1:LL+1)
      IF(E/='|' .AND. E/='/' .AND. LL<M) GOTO 5  ! *** No longer relevant??
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(.NOT.QLOG(WORD(:12))) GOTO 10
      IF(WORD(:1)==' ' .OR. WORD(:1)=='.') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
C       Filter out lines other than filenames
      L = LAST(WORD,14)
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4) .AND. NAME(I)(L+5:L+5)==' ')
     +    GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NL)
      IF(NL>0) WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      L1 = LAST(NAM1,LEN(NAM1)); L2 = LAST(NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      L1 = LAST(WRD1,LEN(WRD1)); L2 = LAST(WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A number terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION
C
      FUNCTION SHFT(X1,Y1,X2,Y2,X3,Y3)
      LOGICAL SHFT
      SHFT = .FALSE.
      IF(ABS(X1-Y1)>.0001) SHFT = .TRUE.
      IF(ABS(X2-Y2)>.0001) SHFT = .TRUE.
      IF(ABS(X3-Y3)>.0001) SHFT = .TRUE.
      END FUNCTION
C
      SUBROUTINE PRNT(JOB,KP,KFILE)
C Set printer codes. JOB=0/1/2 if job is find-linewidth/set-normal-print/set-
C HYBALL-pattern-plots.  KP is linewidth. KFILE is file to write.
      CHARACTER QFMT, WORD*55
      IF(QFMT('PRNTR')=='U') THEN
        IF(JOB==0) WRITE(KFILE,'(/" WARNING: There is no printer ",
     +    "definition in this subdirectory.")')
        IF(JOB==1) WRITE(KFILE,'(" %")')
        IF(JOB==2) WRITE(KFILE,'(" #")')
        RETURN
      END IF
      OPEN(1,FILE='PRNTR')
      READ(1,'(A)') WORD
      IF(WORD(:1)=='*') KP = 80
      IF(JOB==0) GOTO 10
      IF(WORD(:1)/='%') READ(1,'(A)') WORD
      IF(JOB==1) WRITE(KFILE,'(A)') WORD(3:)
      IF(JOB==1) GOTO 10
      READ(1,'(A)') WORD
      WRITE(KFILE,'(A)') WORD(3:)
10    CLOSE(1)
      END SUBROUTINE
C
      FUNCTION QLOG(WORD)
C  Return .TRUE. if WORD is a HYBUF file, otherwise .FALSE.
      LOGICAL QLOG
      CHARACTER WORD*(*)
      QLOG = .FALSE.
      IF(WORD(:5)=='HYBUF' .OR. WORD(9:10)==' #') QLOG = .TRUE.
      N = LH(WORD,LN)
      IF(QLOG .OR. N>=LN-1) RETURN  ! No extension in 2nd case
      IF(WORD(N+2:N+2)=='#') QLOG = .TRUE.
      END FUNCTION
C
      SUBROUTINE SCAN(NL,NS,SEQ,KF)
C     Copyright (c) 1999 by W. W. Rozeboom.   All rights reserved.
C This reads the keyboard string, cleans it for list-directed reading of
C the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.  Termination of an input line by "*" allows up to
C two continuation lines.) NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number
C string returned in File 2 is non-null but does not match SEQ, and
C gives the total count of numbers in the returned string otherwise.
C *** If SEQ is "B", NL returns 0 if the input line is blank, and
C     returns -1 otherwise.
      CHARACTER  AA, SEQ*(*), WA*240, WB*240
      NL = 0
5     NLL = NL + 80
      READ(KF,'(A80)') WA(NL+1:NLL)
      IP = NL
      NL = NLL+1
10    NL = NL-1
      IF(NL==0) RETURN
      IF(WA(NL:NL)==' ') GOTO 10
      IF(WA(NL:NL)=='*' .AND. NL>IP) GOTO 5
      IF(SEQ(1:1)=='B') NL = -1
      IF(SEQ(1:1)=='B') RETURN
      WB(NL+1:NL+1) = ' '
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +      WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
        ELSE IF (WA(I:I) /= '0') THEN
          IP = 0
        END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF (WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) RETURN
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     +  "number sequence requested. Try again.")')
      RETURN
60    REWIND 2
      WRITE(2,'(A)') WB(1:NL)
      NL = NN
      REWIND 2
      END SUBROUTINE
C
      SUBROUTINE SEEFIX(NN,NF,NB,FIX,FIX1,NZ)
C       NZ (no. waifs) is both input and output
      CHARACTER CF*12
      INTEGER FIX(*), FIX1(*), KBL(-1:NB+1,0:NF)
      COMMON /CF/ CF
      K = 0; N0 = 0
      DO I = 1,NF
        IF(FIX(I)==-1) N0 = N0+1
        IF(FIX(I)<99 .AND. FIX(I)>=0) K = 1
      END DO
      L = K+N0
      IF(NN==1) THEN
        IF(L==0) WRITE(7,'(/" This input pattern was received with",
     +    " no rotation constraints.")')
        IF(L==0) RETURN
        WRITE(7,'(/" Rotation constraints received with the input ",
     +    "pattern:")')
        NZ = N0
      ELSE  ! Only when change detected in Main
        WRITE(7,'(/" Changes in rotation constraints before solution",
     +    " No. ",A,":")') CF(:JF(NN))
        IF(L==0) THEN
          WRITE(7,'(4X,"Block constraints on rotation of solution No. ",
     +    A,": None.")') CF(:JF(NN)); NZ = 0; RETURN
        END IF
        NZ = N0  ! Still haven't figured out why N0 was treated as below
CC        IF(NZ>0 .AND. N0/=NZ) NZ = -NZ  ! **** Minus flags change in NZ; why ??
      END IF
      IF(L/=0) CALL SHOWB(NF,NB,FIX,FIX1,KBL,NLD,NN)
cc      IF(N0>0) WRITE(7,'(" The Z-factors are rotational isolates.")')
      END SUBROUTINE
C
      SUBROUTINE SHOW(IO,FMT1,A1,COMM,C1)
C This writes to screen (if IO=6) or to RESULTS file (if IO=7) the current
C factor pattern/covariances
      CHARACTER FMT1*(*), FMT2*60, WORD*10, CLN*8
      REAL A1(MV,MF), C1(MF,MF), COMM(MV)
      COMMON /BL1/ MV, MF, NV, NF, NREC
c      FMT1 = '(4X,8X,4(2X,5A5),90(:/14X,4(2X,5A5)))'
      FMT2 = '(I4,". (",A3,")"'//FMT1(7:)
      DO I = 1,NV
        IF(MOD(I-1,5)==0) WRITE(IO,'()')
        WRITE(IO,FMT2)  I, CLN(COMM(I),3,2), (CLN(A1(I,J),5,2), J=1,NF)
        IF(IO/=6 .OR. MOD(I,10)/=0 .OR. I>=NV-2) CYCLE
        WRITE(6,'(" Hit RETURN to continue this display, or enter",
     +    " anything to quit it.")')
        READ(5,'(A)') WORD
        IF(WORD/='          ') RETURN
      END DO
      D = 0.
      DO I = 1,NF
        D = MAX(D,ABS(C1(I,I)-1.))
        DO J = I+1,NF
          D = MAX(D,ABS(C1(I,J)))
        END DO
      END DO
      IF(D<.001) WRITE(IO,'(/"  Input covariances are ortho",
     +  "normal."/)')
      IF(D<.001) RETURN
      WRITE(IO,'(/"  with corresponding factor covariances")')
      DO I = 1,NF
        IF(MOD(I-1,5)==0) WRITE(IO,'()')
        WRITE(IO,FMT1) (CLN(C1(I,J),5,2),J=1,I)
      END DO
      IF(IO==6) CALL WAIT(0)
      END SUBROUTINE
C
      SUBROUTINE SHOWB(NF,NB,FIX,FIX1,KBL,NLD,LF)
C This prints the factor blocks and their dependency structure.
C If NLD>0, substitution for line draw is needed
      CHARACTER WORD*30, CH1*2, CH2*2, FMT1*90, FMT2*90, BN, TR, CF*12
      INTEGER FIX(*), FIX1(*), KBL(-1:NB+1,0:*)
      COMMON /CF/ CF
      SAVE LB
      DATA LB/1/
      DO I = -1,NB+1
        KBL(I,0) = 0
      END DO
      N1 = 0
      DO I = 1,NF
        IF(FIX(I)/=99) N1 = N1+1  ! N1 is number of factors not in block Y
        IB = MIN(FIX(I),NB+1)
        KBL(IB,0) = KBL(IB,0)+1
        KBL(IB,KBL(IB,0)) = I
      END DO
C       If any items have FIX code 99, row NB+1 of KBL will be nonempty.
      IF(N1==KBL(-1,0)+KBL(0,0)) THEN
        WRITE(7,'()')
        IF(N1==0) THEN
          WRITE(7,'(" Location constraints on this rotation: None")')
        END IF
        IF(KBL(0,0)>0) THEN
          WRITE(7,'(" Factors constrained in this rotation to be ",
     +      "global sources (block X):")')
          WRITE(7,'(4X,50(1X,A))') (CF(:JF(KBL(0,I))),I=1,KBL(0,0))
        END IF
        IF(KBL(-1,0)>0) THEN
          WRITE(7,'(" Factors set aside in this rotation as isolates",
     +      " (block Z):")')
          WRITE(7,'(4X,50(1X,A))') (CF(:JF(KBL(-1,I))),I=1,KBL(-1,0))
        END IF
        RETURN
      END IF
15    MBB = MAX(8,2*((NB+1)/2))
      M = (MBB-6)/2
C       MAX(8,...) in MBB insures that M is at least 1
      CH1 = CHAR(48+M/10)//CHAR(48+MOD(M,10))
      MM = 0
      DO I = 1,NB
        MM = MAX(MM,KBL(I,0))
      END DO
      NL = KBL(NB+1,0)
      IF(NL<(65-MBB)/3) NN = MAX(30,3*MAX(MM,NL))
      IF(NL>=(65-MBB)/3) NN = MAX(30,3*MM)
      CH2 = CHAR(48+NN/10)//CHAR(48+MOD(NN,10))
      IF(LF>1) WRITE(7,'(" Rotation constraints were imposed by ",
     +  "the following block structure.")')
      IF(LB>0) WRITE(7,'(" A block''s factors can rotate only in ",
     +  "the subspace of their DepOn blocks.")')
      LB = 0
      FMT1 = '(/"  Block  ",'//CH1//'(" "),"DepOn ",'//CH1//
     +  '(" "),"   Indices of factors in block")'//'       '
      IF(NLD>0) CALL TRLIN(FMT1(:90))
      WRITE(7,FMT1)
      FMT1 = '(" ",'//CH1//'(""),"",'//CH1//
     +  '(""),"",'//CH2//'(""))'//'                         '
      IF(NLD>0) CALL TRLIN(FMT1(:90))
      WRITE(7,FMT1)
      FMT2 = '(4X,A,3X,"'//TR('')//'",1X,A,"'//TR('')//'",50I3)'//'  '
      IF(KBL(0,0)>0) THEN
        WORD(:30) = '                              '
        WORD(M+2:M+5) = 'none'
        WRITE(7,FMT2) 'X', WORD(:MBB), (I,I=1,KBL(0,KBL(0,0)))
      END IF
      DO IB = 1,NB
        WORD(:30) = '                              '
        KW = MIN(1,KBL(0,0))
        IF(KW>0) WORD(1:1) = 'X'
        K = FIX1(IB)
        DO I = 1,IB
          IF(MOD(K,2)>0) THEN
            KW = KW+1
            WORD(KW:KW) = BN(I)
          END IF
          K = K/2
        END DO
        WORD(KW+1:KW+1) = BN(IB)
        WRITE(7,FMT2) BN(IB), WORD(:MBB), (KBL(IB,J),J=1,KBL(IB,0))
      END DO
      NL = KBL(NB+1,0)
      IF(NL<=0) GOTO 35
      WORD(:9) = '"all   ",'
      IF(KBL(-1,0)>0) WORD(:9) = '"all*  ",'
      IF(NL*3>NN) THEN
        FMT2 = '(4X,"Y    ",'//CH1//'(" "),'//WORD(:9)//CH1//
     +    '(" "),"  all remaining factors"'//WORD(5:5)//'         '
        IF(NLD>0) CALL TRLIN(FMT2(:90))
        WRITE(7,FMT2)
      ELSE
        FMT2 = '(4X,"Y    ",'//CH1//'(" "),'//WORD(:9)//CH1//
     +    '(" "),"",50I3)'//'                  '
        IF(NLD>0) CALL TRLIN(FMT2(:90))
        WRITE(7,FMT2) (KBL(NB+1,J),J=1,NL)
      END IF
35    IF(KBL(-1,0)>0) THEN
        WORD(:5) = '  Z  '
        FMT2 = '(2X,A,"  ",'//CH1//'(" "),"      ",'//CH1//
     +    '(" "),"",50I3)'//'                  '
        IF(NLD>0) CALL TRLIN(FMT2(:90))
        WRITE(7,FMT2) WORD(:5), (KBL(-1,J),J=1,KBL(-1,0))
      END IF
      CALL SUBST(FMT1,TR(''),TR(''))
      WRITE(7,FMT1)
      CH2 = '  '
      IF(KBL(-1,0)>0) CH2 = 's '
      IF(KBL(-1,0)>0 .AND. NL>0) THEN
         WORD(:13) = 'Z-factor'//CH2//'   '
         WRITE(6,'(10X,"*Excepting the ",A)') WORD(:12)
      END IF
      END SUBROUTINE
C
      SUBROUTINE SORT(LIST,N,LST,N1,N2)
C This receives in LIST an unordered list of N integers, puts into LST(_) the
C L distinct ones in range <N1,N2>, and in LST(L+1),..,LST(L+M) (M=N2-M1+1) the
C complement of LST(_) over this range.  Both sets are ordered increasingly.
      INTEGER LIST(*), LST(*)
       L = 0
       M = N
       OUTER: DO I = N1,N2
         DO J = 1,N
           IF(I/=LIST(J)) CYCLE
           L = L+1
           LST(L) = I
           CYCLE OUTER
         END DO
        M = M+1
        LST(M) = I
      ENDDO OUTER
      IF(L<N) THEN
        DO I = 1,M
          LST(L+I) = LST(M+I)
        END DO
        N = L; M = M+L
      END IF
      END SUBROUTINE
C
      SUBROUTINE SPRED(NV,NF,A,BH,MV,NLD,QY,K1,KF)
C Show the distribution of factor loadings in A for hyperplane BH.
C K1 is low non-omit factor
      LOGICAL QY
      CHARACTER*12 CF, CLN, FMT*50, COD*3, TR*1, CH3*3
      INTEGER LST(22)
      REAL A(MV,*)
      COMMON /CF/ CF
      FMT = '("  ",aa(""),"ccc",bb(""),"",9(""))'
C       FMT is ('  ',aa(''),'ccc',bb(''),'',9(''))
      I = MAX(1,MIN(19,INT(50*MIN(.43,BH+.0001)))) ! term 'aa'
      J = 20 - I ! term 'bb'
      FMT(9:10) = CHAR(48+I/10)//CHAR(48+MOD(I,10))
      FMT(25:26) = CHAR(48+J/10)//CHAR(48+MOD(J,10))
      FMT(20:22) = '^' ! term 'ccc'
      IF(AMOD(BH,.02)<=.004) FMT(20:22) = '^'
      IF(AMOD(BH,.02)>=.016 .OR. BH>.395) FMT(20:22) = '^'
      IF(BH>.405) FMT(20:22) = 'į'
      IF(NLD>0) CALL TRLIN(FMT(:50))
CC      K = MAX(1,MOD(MIN(NF,10),10))   !      K = NF, or 1 if NF>9
      K = 1; IF(QY) K = NF
      DO JJ = 1,K
        LST = 0; KK = JJ+K1-1             !      do 10 jj = 1,K
        DO I = 1,NV                       !        initialize LST
          J2 = NF-(NF-JJ)*MIN(1,K-1)      !       do 20 i = 1,nv
          DO J = JJ,J2                    !         j2 = nf-(nf-jj)*(k/2)
            L = 1+INT(50*MIN(.43,ABS(A(I,J)))) !  do 20 j = jj, j2 (j2 = jj or nf)
            LST(L) = LST(L)+1             ! 20      accumulate LST over A(i,jj)
          END DO                          ! 10   print
        END DO
        CH3 = '   '
CC        IF(NF<=9) CH = CHAR(48+JJ)
        IF(QY) CH3 = CLN(1.*(KK),3,10)
        WRITE(KF,'(A3,A,21A3,1X,A,I5)') CH3,TR(''),(COD(LST(I),1),
     +    I=1,21), TR(''), LST(22)
      END DO
      WRITE(KF,FMT)
      WRITE(KF,'("  j",A,21I3,1X,A," over 42")') TR(''), (1+2*I,
     +  I=0,20), TR('')
      WRITE(KF,'(5X,"Scatter of this pattern''s ",A," factor loadings.",
     +  "  The number above each"/5X," label j is the raw frequency of",
     +  " magnitudes in interval .01(j  1).")') CF(:JF(NV*NF))
      IF(LST(2)>100) WRITE(KF,'(5X,"Leading digits of counts larger",
     +  " than 99 are coded by corresponding letters."/)')
      END SUBROUTINE

      SUBROUTINE ISORT(N,LST)
C Sort Integers into ascending order and return permutation order in LST
      INTEGER LST(*)
10    DO J = 2,N
        L = LST(J)
        DO I = J-1,1,-1
          IF(LST(I)<=L) GOTO 12
          LST(I+1) = LST(I)
        END DO
        I = 0
12      LST(I+1) = L
      END DO
      END SUBROUTINE
C
      SUBROUTINE WAIT(K)
      IF(K>0) WRITE(6,'()')
      WRITE(6,'(" Hit RETURN to continue")')
      READ(5,'()')
      RETURN
      END

C *************************************************************************

C Rating subroutines
C
      SUBROUTINE LOSS(L,A1,STOR,WSAL)
C Returns Hyperplane-misfit of the Lth pattern measured by the chosen rotation
C parameters.  STOR(L,J) is the misfit of pattern column J; STOR(L,0) is mean.
C Actual arguments needed are NV,NF,A1,BH,JA,JB; also CV1/ADD/R0/R1
      LOGICAL QY, QZ
      REAL A1(MV,MF), STOR(NREC,0:MF+1), SS(MV), W(MV,0:MF)
      COMMON /BL1/ MV, MF, NV, NF, NREC
      COMMON /BL3/ BH,JA,JB,CV1,ADD,R0,R1
      T = 0.; SS = 0.
      QY = .FALSE.; QZ = QY
      IF(WSAL<0.) GOTO 60
      IF(WSAL>=.01) QY = .TRUE.
      IF(.NOT.QY) GOTO 20
C Compute matrix of salience weights rescaled to average 1.
      IF(ABS(WSAL-1.)<.01) QZ = .TRUE.   ! QZ=T omits powering by WSAL=1
      DO I = 1,NV
        S = 0.
        DO J = 1,NF
          IF(QZ) W(I,J) = ABS(A1(I,J))
          IF(.NOT.QZ) W(I,J) = ABS(A1(I,J))**WSAL
          S = S + W(I,J)
        END DO
        W(I,0) = S   !  raw weights for item i over all factors
        T = T+S
      END DO
      T = (NF-1)*T/(NF*NV)   ! NF-1 times overall mean raw weight for norming
      DO I = 1,NV
        DO J = 1,NF ! Get mean normed weight for I over factors excluding J
          W(I,J) = (W(I,0)-W(I,J))/T  ! I's weight when rotating Fac J
        END DO
      END DO
20    DO J = 1,NF
        DO I = 1,NV
          X = FIT(A1(I,J))
          IF(QY) X = X*W(I,J)
          STOR(L,J) = STOR(L,J) + X
        END DO
        STOR(L,0) = STOR(L,0) + STOR(L,J)
      END DO
      GOTO 70
60    WSL = AMOD(WSAL+.001,1.)-.001
      DO I = 1,NV   ! Start Comp2 weighting
        DO J = 1,NF
          SS(I) = SS(I) + A1(I,J)**2
        END DO
      END DO
      DO I = 1,NV
        DO J = 2,NF
          DO K = 1,J-1
            FJ = FIT(A1(I,J))
            FK = FIT(A1(I,K))
            WI = 1. + WSL*COMP2(A1(I,J),A1(I,K),SS(I))
ccc            LOSS = LOSS + (FJ+FK)*WI   ! When LOSS is a function
            STOR(L,J) = STOR(L,J) + FJ*WI
            STOR(L,K) = STOR(L,K) + FK*WI
          END DO
        END DO
      END DO
      DO J = 1,NF
        STOR(L,J) = STOR(L,J)/(NF-1)
        STOR(L,0) = STOR(L,0) + STOR(L,J)
      END DO
70    STOR(L,0) = STOR(L,0)/NF
      RETURN
      END SUBROUTINE

      FUNCTION FIT(A)
C Get the unweighted misfit of coefficient A under current loss parameters
      COMMON /BL3/ BH,JA,JB,CV1,ADD,R0,R1
      D = A/BH; E = D*D
      IF(E>=1.) GOTO 30
      IF(JA==0) X = E
      IF(JA>0) X = (CV1 - R0*(E**JA))*E
      IF(JA==-1) X = 2*ABS(D)
      IF(JA<-1) X = (E**R0)/R0
      GOTO 50
30    X = 1./E
      IF(JB<=2) GOTO 45
      DO K = 3,JB
        X = X/E
      END DO
45    X = ADD - R1*X
50    FIT = X
      RETURN
      END FUNCTION
C
      SUBROUTINE HYPKNT(L,A1,STOR,BH)
C Returns hyperplane counts, as percent of maximum possible, at
C bandwidth BH.  STOR(L,J) is count for factor J.
      REAL A1(MV,MF), STOR(NREC,0:MF+1)
      COMMON /BL1/ MV, MF, NV, NF, NREC
      NT = 0.
      DO J = 1,NF
        NJ = 0
        DO I = 1,NV
          IF(ABS(A1(I,J))<=BH) NJ = NJ+1
        END DO
        NT = NT + NJ
        STOR(L,J) = (NJ*100.)/NV
      END DO
      STOR(L,0) = (NT*100.)/(NV*NF)
      END SUBROUTINE
C
      SUBROUTINE BCMPLX(L,A1,STOR,BH)
C Finds pattern A's item-complexity counts at bandwidth BH. STOR(L,J+1)
C returns the percent of items having complexity J (= 0,1,2,...) at this
C bandwidth, except that values for J10 are summed in STOR(L,11).
C STOR(L,0) returns the mean of this BH-complexity distribution.
      REAL A1(MV,MF), STOR(NREC,0:MF+1)
      COMMON /BL1/ MV, MF, NV, NF, NREC
      DO I = 1,NV
        N = 0
        DO J = 1,NF   ! Level K goes in STOR column K+1
          IF(ABS(A1(I,J))>BH) N = N+1  ! Count no. loadings greater than BH
        END DO
        STOR(L,MIN(11,N+1)) = STOR(L,MIN(11,N+1)) + 1.
      END DO
      DO J = 1,MIN(11,NF+1)
        STOR(L,J) = 100.*STOR(L,J)/NV
      END DO
C        Counts at each complexity are converted to percents
      DO J = 1,MIN(11,NF+1)
        STOR(L,0) = STOR(L,0) + STOR(L,J)*J
      END DO
      STOR(L,0) = STOR(L,0)/100
      RETURN
      END SUBROUTINE

C   L-COMPLEXITY table:
C   For each J = 1,2,..,n in a given pattern, let the square of any item's
C   Jth largest loading divided by its sum of squared loadings plus its
C   uniqueness, be called that item's "mass" at complexity level J.  Then
C   the pattern's L(oading)-strength at level J, shown by the table's Jth
C   entry after AV, is the mean mass of its items at level J times 100.
C   And its overall L-complexity (AV) is the mean level in its L-strength
C   distribution.  (This measure is parameter-free.)

ccc   L-COMPLEXITY table ("L" for Loading and Level):
ccc   For each L = 0,1,..,NF in a given pattern, let an item's "concentration"
ccc   at level L be its variance accounted for by the L common factors on which
ccc   its loadings are largest (zero for L=0), scaled as a proportion of its
ccc   communality.  And say that the item's L-complexity at level L = 1,2,...
ccc   is its increment in L-concentration from level L-1 to level L.  Then the
ccc   L-complexity profile shown in this table's row following column ML for
ccc   each pattern is the curve on L = 1,2,..,NF whose value Comp(L) at each
ccc   level is the mean L-complexity of this pattern's items at that level.
ccc   And a pattern's ML rating is its profile mean, that is,  LComp(L).
ccc
      SUBROUTINE LCMPLX(L,A1,STOR)
C Details pattern A's L-complexity (Job L). STOR(L,J) returns the mean squared
C item strength times 100 at level J, expressed as percent of total after
C uniqueness loading is added in; STOR(L,0) returns mean L-complexity over
C items
      INTEGER LST(NF)
      REAL A1(MV,*), STOR(NREC,0:*), COMM(MV)
      COMMON /BL1/ MV, MF, NV, NF, NREC
      REWIND 19; READ(19) (COMM(I),I=1,NV)
      DO I = 1,NV
        S = 10000*(1.-COMM(I))  ! Uniqueness times multiplier
        DO J = 1,NF
          R = NINT(10000*A1(I,J)**2)
          S = S + R
          LST(J) = R
        END DO
        CALL ISORT(NF,LST)  ! Sort is ascending, so reverse when storing
        DO J = 1,NF
          STOR(L,J) = STOR(L,J) + 100.*LST(NF+1-J)/S
        END DO
      END DO
      S = 0.; X = 0.
      DO J = 1,NF
        STOR(L,J) = STOR(L,J)/NV
        S = S + STOR(L,J)
        X = X + STOR(L,J)*J
      END DO
      STOR(L,0) = X/S        ! Arithmetic mean
      END SUBROUTINE

      SUBROUTINE KNORM(A1,JOB)
C Do Kaiser norming of pattern A1 if JOB==1, or undo it otherwise
      REAL A1(MV,*), SCAL(NV)
      COMMON /BL1/ MV, MF, NV, NF, NREC
      REWIND 19; READ(19)
      READ(19) (SCAL(I),I=1,NV)
      IF(JOB==1) THEN
        DO I = 1,NV; DO J = 1,NF
            A1(I,J) = A1(I,J)/SCAL(I)
        END DO; END DO
      ELSE
        DO I = 1,NV; DO J = 1,NF
            A1(I,J) = A1(I,J)*SCAL(I)
        END DO; END DO
      END IF
      END SUBROUTINE

cccc      SUBROUTINE LCMPLX(L,A1,C1,STOR,MXL)
ccccC Details pattern A's L-complexity (Job 3). STOR(L,J) returns pattern L's
ccccC mean complexity-J residual times 100. STOR(L,0) returns its mean pooled
ccccC Mass times 100.
cccc      INTEGER LST(NF)
cccc      REAL A1(MV,*),C1(MF,*), COMM(MV), STOR(NREC,0:*), W1(MF),CE(MF,MF)
cccc      COMMON /BL1/ MV, MF, NV, NF, NREC
CCCC      REWIND 19; READ(19) (COMM(I),I=1,NV)
cccc      MXL = MIN(9,NF) ! Maximum L-complexity level to show
cccc      DO I = 1,NV
cccc
ccccCCC        DO J = 1,NF
ccccCCC          LST(J) = 1000*NINT(1000*(10.-ABS(A1(I,J)))) + J
ccccCCC        END DO   ! Sort is ascending, so subtract loadings from upper bound
ccccCCC        CALL ISORT(NF,LST)
ccccCCC        DO J = 1,NF
ccccCCC          LST(J) = MOD(LST(J),1000)
ccccCCC        END DO   ! Factor indices ordered in decreasng loading size
cccc
cccc        DO J = 1,NF; DO K = 1,J Scale factors so item I has loading 1.0 on each
cccc            CE(J,K) = A1(I,J)*A1(I,K)*C1(J,K) ! ; CE(K,J) = CE(J,K)
cccc        END DO; END DO
cccc        DO M = 1,MXL
cccc
cccc        DO J = 1,MXL-1 ! Get factor-covar residuals in LST order
cccc          DO K1 = J+1,MXL; DO K2 = J+1,K1
cccc            CE(K1,K2) = CE(K1,K2) - CE(J,K1)*CE(J,K2)/MAX(.001,CE(J,J))
cccc          END DO; END DO
cccc        END DO
cccc
cccc        DO J = 1,MXL
cccc          W1(J) = CE(J,J)*A1(I,J)**2/MAX(.01,COMM(I))
cccc          STOR(L,J) = STOR(L,J) + W1(J)   ! Don't really need separate W1
cccc        END DO
cccc      END DO
cccc      DO J = 1,MXL
cccc        STOR(L,J) = STOR(L,J)/NV
cccc        STOR(L,0) = STOR(L,0) + J*STOR(L,J)
cccc      END DO
cccc      END SUBROUTINE
C
      SUBROUTINE GAPP(L,A1,KK,SF,BIG,STOR)
C For each factor, measure by Reach[K] the gaps in each column of pattern A
C loading-magnitude interval (0,SF].  Return this gap rating in STOR(L,J)
C for factor J and their average over J in STOR(L,0).
C   The Reach[K] (K a positive integer) of a distribution d1,d2,... of
C   magnitudes is here defined to be the Kth root of the d-terms' Kth
C   moment, divided by their 1st moment (arithmetic mean).
      INTEGER LST(MV)
      REAL A1(MV,*), TT(MV), STOR(NREC,0:*)
      REAL(8) P1, P2
      COMMON /BL1/ MV, MF, NV, NF, NREC
      BIG = 0.; CT = SF*10  ! WARNING: Rescaling CT of CT must match the TT scale
      DO J = 1,NF
        DO I = 1,NV
          LST(I) = NINT(10000*ABS(A1(I,J)))
        END DO
        CALL ISORT(NV,LST)
        DO I = 1,NV
          TT(I) = .001*LST(I)  ! TT is in increasing order, listing
        END DO                 ! loading sizes times 10
        P1 = 0.D0; P2 = 0.D0; NJ = 0
20      NJ = NJ+1
        G = TT(NJ+1)-TT(NJ)  ! Take gap upward in case SF falls in a major gap
        P1 = P1 + G
        P2 = P2 + G**KK
        IF(TT(NJ+1)<CT .AND. NJ<NV-1) GOTO 20  ! End of accumulation loop
        P1 = MAX(.00001,P1)  ! Preclude possible division by zero
C          Pi (i=1,2) is the power-i sum of gaps
        STOR(L,J) = ((P2/NJ)**(1./KK))/(P1/NJ)
C          STOR(L,J) is the coeff. of power-KK variation for loading gaps
        STOR(L,0) = STOR(L,0) + STOR(L,J); BIG = MAX(BIG,STOR(L,J))
      END DO
      STOR(L,0) = STOR(L,0)/NF
      END SUBROUTINE
C
      SUBROUTINE RATE(JOB,A1,C1,CV,WSAL,LTMP,LST,LSTV,K1,QS,STOR)
C Load into STOR one of five pattern appraisals on the HYBUF records.
      LOGICAL QS, QK
      CHARACTER(4) CLN*8, CF*12, CH4, C4
      INTEGER LST(*), LSTV(*), LTMP(*)
      REAL A1(MV,*), C1(MF,*), STOR(NREC,0:MF+1), XX(4)
      EXTERNAL SCAN
      COMMON /BL1/ MV, MF, NV, NF, NREC
      COMMON /BL3/ BH,JA,JB,CV1,ADD,R0,R1
      COMMON /CF/ CF
      SAVE KK, SF
      DATA KK/4/, SF/.30/
      L2(J) = MIN(1,MAX(0,J-2))
90    STOR = 0.
C Enter parameters
      IF(JOB==3) GOTO 30
      IF(JOB==5) GOTO 20
10    IF(JOB==1) WRITE(6,'(/" Hyperplane percents are now set ",
     +  "for display at bandwidth BH = ",A3,".  Hit"/" RETURN",
     +  " if OK, or enter preferred BH. (Entry of a letter returns ",
     +  "to menu.)"/)') CLN(BH,3,2)
      IF(JOB==2) WRITE(6,'(/" B-complexity is now set for display",
     +  " at bandwidth BH = ",A3,".  Hit RETURN"/" if OK, or en",
     +  "ter preferred BH. (Entry of a letter returns to menu.)"/))')
     +  CLN(BH,3,2)
      IF(JOB==4) WRITE(6,'(/" Salience floor SF for nonsalient-ga",
     +  "ppiness appraisal is now",A4,".  Hit "/" RETURN if OK, or e",
     +  "nter preferred SF. (Entry of a letter returns to menu.)"/))')
     +  CLN(SF,4,2)
      CALL SCAN(J,1,'R',5)
      IF(J<0) RETURN
      IF(J==0 .AND. JOB==4) GOTO 16
      IF(J==0) GOTO 30
      READ(2,*) X
12    IF(X>=1.) X = X/10
      IF(X>=1.) GOTO 12
      IF(JOB<=2) BH = MAX(.01,X)
      IF(JOB==4) SF = MAX(.01,X)
      GOTO 10
16    WRITE(6,'(6X,"Powering parameter for GAP appraisal is now ",A,
     +  ".  Hit RETURN to"/6X,"to approve, or enter another digit be",
     +  "tween 2 and 30."/6X,"(Entry of a letter returns to menu."/)')
     +  CF(:JF(KK))
      CALL SCAN(J,0,'I',5)
      IF(J==0) GOTO 30
      IF(J<=-1) RETURN
      READ(2,*) KK
      KK = MAX(2,MIN(30,KK))
      GOTO 16
20    WRITE(6,'(/" Hyperplane-misfit parameters <BH,JA,JB,CV> are n",
     +  "ow <",A3,",",I2,",",I2,",",A4," >."/" Hit RETURN if OK; ot",
     +  "herwise, enter new 4-tuple of settings wanted."/3X,"Notes:",
     +  " Item weighting WSAL will be approved or adjusted next."/10X,
     +  "Entering fewer than 4 terms applies those to start of list."/
     +  10X,"Entry of a letter returns to menu."/)')
     +  CLN(BH,3,2), JA, JB, CLN(CV,4,1)
      CALL SCAN(J,0,'R',5)
      IF(J==0) GOTO 26
      IF(J<=-1) RETURN
      READ(2,*) (XX(I),I=1,J)
      B = XX(1); IF(B>=.1 .AND. B<=99.) BH = B
22    IF(BH>=1.) BH = BH/10; IF(BH>=1.) GOTO 22
      IF(J<2) GOTO 20
      N = NINT(XX(2)); IF(N>=-9 .AND. N<=10) JA = N
      IF(J<3) GOTO 20
      N =  NINT(XX(3)); IF(N>=2.AND.N<=10) JB = N
      IF(J<4) GOTO 20
      B = XX(4)
      IF(B>=-1. .AND. B<=10.) CV = B
25    GOTO 20
26    CV1 = CV+1
      IF(JA>=0) R0 = CV/(JA+1)
      IF(JA<0) R0 = 1./(1.-JA)
      IF(JA<0) CV1 = R0-1.
      R1 = 1./(JB-1)
      IF(JA>=0) ADD = JB*R1 + JA*R0
      IF(JA<0) ADD = (1.-JA) + R1
28    QK = .FALSE.; IF(WSAL<-1.) QK = .TRUE.
      IF(QK) WS = AMOD(WSAL+.001,1.)-.001
      WRITE(6,'(/" Item weighting is now WSAL = ",A4,".  Hit RETURN i",
     +  "f OK; otherwise:"/"   For salience weighting, enter a positi",
     +  "ve power advisedly not greater than 2."/"   For Comp2 weigh",
     +  "ting with intensity W, choose W in the unit interval, add 1"/
     +  5X,"if you also want Kaiser-norming, and enter this with NEG",
     +  "ATIVE sign."/"   (Entry of a letter returns to the apraisal",
     +  " menu.)"/)') CLN(WSAL,4,2)
      CALL SCAN(J,0,'R',5)
      IF(J==0) GOTO 30
      IF(J<=-1) RETURN
      READ(2,*) W; WSAL = MIN(10.,W)
      IF(WSAL<-1.) THEN   ! LOSS will parse WSAL
        QK = .TRUE.; WS = AMOD(WSAL+.001,1.)-.001; WSAL = WS-1.
        WRITE(6,'(" >>> WSAL = ",A5," will be treated as Comp2 weight ",
     +    A3," with Kaiser norming.")') CLN(WSAL,5,2), CLN(-WS,3,2)
      END IF
      GOTO 28
C Load STOR with ratings
30    REWIND 8
      READ(8)
32    READ(8,END=40) L, ((A1(I,J),I=1,MV),J=1,MF), ((C1(I,J),I=1,MF),
     +  J=1,MF)
      IF(QS) CALL STRIP(A1,C1,LSTV,K1,2)
      NTOT = L
      IF(JOB==1) CALL HYPKNT(L,A1,STOR,BH)
      IF(JOB==2) CALL BCMPLX(L,A1,STOR,BH)
      IF(JOB.EQ.3) CALL LCMPLX(L,A1,STOR)
ccc      IF(JOB==3) CALL LCMPLX(L,A1,C1,STOR,MXL) ! MXL = No. of levels computed
      IF(JOB==4) CALL GAPP(L,A1,KK,SF,BG,STOR)
      IF(JOB==5) THEN
        IF(QK) CALL KNORM(A1,1)
        CALL LOSS(L,A1,STOR,WSAL)
        IF(QK) CALL KNORM(A1,0)
      END IF
      IF(L==1) FLR = STOR(L,0)
      IF(L==1) HI = FLR
      FLR = MIN(FLR,STOR(L,0))
      HI = MAX(HI,STOR(L,0))
      GOTO 32
40    CONTINUE
      IF(JOB==4) THEN
        MLT = 1000
45      IF(BG*MLT>100.) THEN; MLT = MLT/10; GOTO 45; END IF
        FLR = FLR*MLT
        DO L = 1,NTOT
          DO J = 0,NF
            STOR(L,J) = STOR(L,J)*MLT
          END DO
        END DO
      END IF
C Write results files
      C4 = 'Mean'
      LBL = 4

      IF(JOB.EQ.3) C4 = 'AV  '
ccc      IF(JOB==3) C4 = 'ML  '

      IF(JOB==3) LBL = 2
      M = 20
      IF(NF>25) M = 10
      IF(JOB==2) M = 18
      BIG: DO KF = 6,7
        IF(JOB==1) WRITE(KF,'(/" Hyperplane percents in band +/- .",
     +    I2," for all",I3," stored patterns:")') NINT(100*BH), NTOT
        IF(JOB==2) WRITE(KF,'(/" B-complexity distribution at band",
     +    "width +/- .",I2," for each stored pattern:"/18X,"J: ",11I3,
     +    " or more")') NINT(100*BH), (I-1,I=1,MIN(11,NF+1))

        IF(JOB.EQ.3) WRITE(KF,'(/" Each stored pattern''s L-strength ",
     +    "distribution with mean thereof:")')
ccc        IF(JOB==3) WRITE(KF,'(/" Each pattern''s L-complexity profile ",
ccc     +    "preceded by its profile mean (ML):"/12X,"Level:",10I6,3X,
ccc     +    ">9")') (I,I=1,MXL) ! Final ">9" not effective at present

        IF(JOB==4) WRITE(KF,'(/" Gappiness ratings (Reach[",A,"] ",
     +    "times ",A,", salience floor .",A,") for all patterns:")')
     +    CF(:JF(KK)), CF(:JF(MLT)), CF(:JF(NINT(100*SF)))
        IF(JOB==5) WRITE(KF,'(/" Hyperplane-misfit ratings under <BH",
     +    ",JA,JB,CV,WSAL> = <",A3,",",I2,",",I2,",",A4,", ",A4,">"/
     +    " by factor and on average for each stored pattern:")')
     +    CLN(BH,3,2), JA, JB, CLN(CV,4,1), CLN(WSAL,4,2)
        IF(JOB==5) GOTO 60
        JJ = 1
        IF(JOB==2.OR.JOB==3) JJ = 2
        DO L = 1,NTOT
          CH4 = CLN(L*1.,4,10)        ! Mode is 0,2; BH is 0,1
          IF(MOD(LST(L),2)>0) CH4(2:2) = 'm'
          IF(LST(L)>=2) CH4(4-LST(L):4-LST(L)) = 'b'
          IF(JOB==2) THEN
            WRITE(KF,'(1X,A,". (",A," =",A5,") ",10I3,I6)') CH4,
     +      C4(:LBL), CLN(STOR(L,0),5,2), (NINT(STOR(L,J)),J=1,
     +      MIN(11,NF+1))

cc          ELSE IF(JOB==3) THEN  ! Old Job 3 writes under code immediately below
cc            WRITE(KF,'(1X,A,". (",A," =",A5,") ",10A6)') CH4, C4(:LBL),
cc     +        CLN(STOR(L,0),5,2), (CLN(STOR(L,J),6,3),J=1,MXL)

          ELSE IF(KF==6) THEN
            WRITE(6,'(1X,A,". (",A," =",A5,") ",19I3)') CH4, C4(
     +        :LBL), CLN(STOR(L,0),5,JJ), (MIN(999,NINT(STOR(L,J))),
     +        J=1,MIN(19,NF))
          ELSE IF(KF==7) THEN
            WRITE(7,'(1X,A,". (",A," =",A5,") ",30I3,3(:/21X,
     +        30I3))') CH4, C4(:LBL),CLN(STOR(L,0),5,JJ),
     +        (MIN(999,NINT(STOR(L,J))),J=1,NF)
          END IF
          IF(KF==6 .AND. MOD(L,M)==0 .AND. L<NTOT-2) CALL WAIT(0)
        END DO
        CYCLE
60      IF(NF>10) M = 20
        DO L = 1,NTOT
          CH4 = CLN(L*1.,4,10)
          IF(MOD(LST(L),2)>0) CH4(2:2) = 'm'
          IF(LST(L)>=2) CH4(4-LST(L):4-LST(L)) = 'b'
          SG = 0.
          DO J = 1,NF
            SG = SG + (STOR(L,J)-STOR(L,0))**2
          END DO
          FLR = MAX(FLR,.0001)
          IF(NF>1) SG = SQRT(MAX(.000001,SG/NF))/FLR
          IF(KF==6) WRITE(6,'(1X,A,". (Mean = ",A5,", SD =",A4,
     +      ") ",10A5,3(:/20X,15A5))') CH4, CLN(STOR(L,0)/FLR,5,3),
     +      CLN(SG,4,2), (CLN(STOR(L,J)/FLR,5,2),J=1,MIN(9,NF))
          IF(KF==7) WRITE(7,'(1X,A,". (Mean = ",A5,", SD =",A4,
     +      ") ",20A5,3(:/32X,20A5))') CH4, CLN(STOR(L,0)/FLR,5,3),
     +      CLN(SG,4,2),(CLN(STOR(L,J)/FLR,5,2),J=1,NF)
          IF(KF==6 .AND. MOD(L,M)==0. AND. L<NTOT-2) CALL WAIT(0)
        END DO
      END DO BIG ! End of loop over KF = 6,7
C Find preference order
      IF(NTOT<=1) RETURN
      F = 1000/FLR; LTMP(L) = 0
      DO L =  1,NTOT
        LTMP(L) =  NINT(STOR(L,0)*F)*1000 + L
      END DO
      CALL ISORT(NTOT,LTMP)    ! Ascending order
      DO L = 1,NTOT
        LTMP(L) = MOD(LTMP(L),1000)
      END DO
      N = 1
      IF(JOB==1 .OR. JOB==4) N = NTOT
      WRITE(7,'(" These patterns'' preference ranking on ",A," is",
     +  5(:/40(1X,A)))') C4(:LBL), (CF(:JF(LTMP(I))),I=N,NTOT+1-N,
     +  SIGN(1,1-N))  ! Descending order when JOB is 1 or 4
      IF(JOB==3) THEN ! ########## Revision not done yet
        CALL WAIT(0)
        DO JB = 1,2
          DO L =  1,NTOT   ! Old version multiplied by 100 to drop decimals
            Q = 10000.-STOR(L,1); IF(JB==2) Q = Q - STOR(L,2)
            LTMP(L) =  NINT(Q)*1000 + L
ccc            Q = 10.-STOR(L,1); IF(JB==2) Q = Q - STOR(L,2)
ccc            LTMP(L) =  NINT(1000*Q)*1000 + L
          END DO
          CALL ISORT(NTOT,LTMP)    ! Ascending order
          DO L = 1,NTOT
            LTMP(L) = MOD(LTMP(L),1000)
          END DO
          WRITE(7,'(" Their ranking by preference for items with com",
     +      "plexity no greater than",I2,":",5(:/40(1X,A)))') JB,
     +      (CF(:JF(LTMP(I))),I=1,NTOT)
        END DO
        RETURN
      END IF
      WRITE(6,'(/"  To repeat this assessment under different para",
     +  "meters, enter anything."/"  Otherwise, hit RETURN.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 90
      END SUBROUTINE
C
      SUBROUTINE SEENAM(NX,IDENT,PIK,JOB,NW,KF)
C This writes to file KF the NX names in IDENT(PIK). NW sets num chars in line.
C JOB=0 says to print index listed in PIK rather than position in PIK list.
      CHARACTER(8) IDENT(*), FMT*30, CH2*2
      INTEGER PIK(*)
      MM = 3
      DO I = 1,NX
        N = LAST(IDENT(PIK(I)),8)
        IF(N>0) MM = MAX(MM,N)
      END DO
      LL = NW/(6+MM)   ! Number of fields per line
      CH2 = CHAR(48+LL/10)//CHAR(48+MOD(LL,10))
      FMT = '(80(1X,'//CH2//'(I4,": ",A),:/))'
      IF(JOB/=0) WRITE(KF,FMT) (I,IDENT(IABS(PIK(I)))(:MM),I=1,NX)
      IF(JOB==0) WRITE(KF,FMT) (IABS(PIK(I)),IDENT(IABS(PIK(I)))
     +            (:MM),I=1,NX)
      END SUBROUTINE
C
      SUBROUTINE START(J,F1)
C This opens formatted file F1 with unit-number J, and finds its first line
C beginning with a digit.
      CHARACTER F1*(*), CH*80
      OPEN(J,FILE=F1)
10    READ(J,'(A)',END=50) CH
      K = 0
12    K = K+1
      L = ICHAR(CH(K:K))
      IF((L==32 .OR. L==0) .AND. K<80) GOTO 12
      IF(L<48 .OR. L>57) GOTO 10
      BACKSPACE J
      RETURN
50    WRITE(6,'(/" File ",A," is defective.")') F1
      STOP
      END
C
      SUBROUTINE STRIP(A,C,LST,K1,JOB)
C Reduce factor pattern A to the NV items indexed in LST and NF factors indexed
C from K1 up.  Also, if JOB>1, similarly reduce factor covariances CF.
      INTEGER LST(*)
      REAL    A(MV,*), C(MF,*)
      COMMON /BL1/ MV, MF, NV, NF, NREC
      K0 = K1-1
      DO I = 1,NV
        DO J = 1,NF
          A(I,J) = A(LST(I),K0+J)
        END DO
      END DO
      IF(JOB<2) RETURN
      DO J = 1,NF
        DO I = 1,J
          C(I,J) = C(K0+I,K0+J)
          C(J,I) = C(I,J)
        END DO
      END DO
      END SUBROUTINE

      SUBROUTINE SUBST(WORD,CHA,CHB)
C  Replace all WORD(:LL)-occurrences of chars in CHA with matching chars in CH2
      CHARACTER WORD*(*), CHA*(*), CHB*(*), CH1, CH2
      M = LEN(WORD)
      N = MIN(LEN(CHA),LEN(CHB))
      DO K = 1,N
        CH1 = CHA(K:K)
        CH2 = CHB(K:K)
        DO I = 1,M
          IF(WORD(I:I)==CH1) WORD(I:I) = CH2
        END DO
      END DO
      END SUBROUTINE
C
      FUNCTION TR(CH) ! ******* This should be deleted
C Translate selected 8-bit ASCII characters into 7-bit substitutes if KR > 0
      CHARACTER TR, CH
      COMMON /TTR/ KR
      SAVE /TTR/
C       KR > 0 calls surrogates for 8-bit ASCII characters
      N = ICHAR(CH)
      IF(KR<=0 .OR. N<127) THEN
        TR = CHAR(N)
        RETURN
      END IF
      IF(N==196) THEN
        TR = '-'
      ELSE IF(N==205) THEN
        TR = '='
      ELSE IF(N==191.OR.N==192.OR.N==217.OR.N==218) THEN ! Single corners
        TR = '+'  ! Single-line corners
      ELSE IF(N==182.OR.N==183.OR.(N>=186.AND.N<=189).OR.
     +  (N>=199.AND.N<=204).OR.N==206.OR.N==208.OR.N==210
     +  .OR.N==211.OR.N==214.OR.N==215) THEN
        TR = '#' ! Double-line corners and verticals
      ELSE IF(N>=179.AND.N<=218) THEN
        TR = '|' ! Single-line verticals
      ELSE IF(N>=248) THEN
        TR = '^'  ! Elevated degree symbol
      ELSE IF(N>=242) THEN
        TR = '}'  ! <=
      ELSE IF(N>=243) THEN
        TR = '{'  ! >=
      ELSE IF(N>=223) THEN
        TR = '!'  ! 
      ELSE
        WRITE(6,'(/" A replacement for ASCII character ALT-",I3,
     +    " has not yet been programmed."/" Fix this oversight ",
     +    "and try again.")') N
        STOP
      END IF
      END FUNCTION
C
      SUBROUTINE TRLIN(WORD)
C Apply function TR to the characters in WORD
      CHARACTER TR, WORD*(*)
      LL = LEN(WORD)
      DO I = 1,LL
        WORD(I:I) = TR(WORD(I:I))
      END DO
      RETURN
      END
C
      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12, LST(12)*10
      COMMON /CF/ CF
      DATA LST/'January  7','February 8','March    5','April    5',
     +         'May      3','June     4','July     4','August   6',
     +         'September9','October  7','November 8','December 8'/
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48  ! M gets day of month
      READ(ZZZ(5:6),*) L; K = ICHAR(LST(L)(10:10))-48
      WORD = CF(:JF(M))//' '//LST(L)(:K)//' '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE
C
      FUNCTION QFMT(F1)
C This determines the status of file F1, returning 'Y' if it is Formatted,
C 'N' if it is Not, and 'U' if it is Unknown (does not exist).
      CHARACTER QFMT, F1*(*)
      INQUIRE(FILE=F1,FORMATTED=QFMT)
      END FUNCTION



CC *************************************************************************
CC *************************************************************************
CC The following subroutine(s) for aligning solutions by factor correlations
CC has been readied but never installed.
CC
C      SUBROUTINE CORFIT(NV,NF,L,B,A,CB,ORDER,DC,DM,W1,WK,AV)
CC Receive the pattern A on index-L solution, the pattern B and factor correls
CC CB on another solution; match B-factors to A-factors for maximal similarity;
CC rescale correlation as divergence angle; return in DV(J) the divergenge of the
CC Jth A-factor from its matched B-factor, and the latter's index in ORDER(J).
CC Workspaces both W1 and WK must be at least NF*NF.
CC ***** If ORDER(J) indexes an A-factor on input, DC(J) returns the rescaled
CC       correlation betwen A-factor J and B-factor ORDER(J)
C      PARAMETER (NV=300, NF=50)
C      INTEGER ORDER(*)
C      REAL XX(NF*(NF+1)/2), B(NV,*), A(NV,*), CB(*), DC(*), DM(*),
C     +     W1(NF,*), WK(NF,*)
C      LO(I,J) = J*(J-1)/2 + I
C      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
C      DATA LL/0/
C      SAVE LL, XX
C      RAD = 90/ACOS(0.)
C      IF(L==LL) GOTO 15
CC Compute XX = Inv(A*Trans[A]) if not saved from last call
C      LL = L
C      DO 10 J = 1,NF
C       DO 10 I = 1,J
C        S = 0.
C        DO 11 K = 1,NV
C11       S = S + A(K,I)*A(K,J)
C10      XX(LO(I,J)) = S
C       CALL INVS(NF,XX,IER)
CC Find Y = Trans[A]*B (store in WK)
C15    DO 20 J = 1,NF
C       DO 20 I = 1,NF
C        S = 0.
C        DO 21 K = 1,NV
C21       S = S + A(K,I)*B(K,J)
C20      WK(I,J) = S
CC Put XX*Y (Left-inverse of A times B) into W1
C      DO 30 I = 1,NF
C       DO 30 J = 1,NF
C        S = 0.
C        DO 31 K = 1,NF
C31       S = S + XX(LOC(I,K))*WK(K,J)
C30      W1(I,J) = S
CC W1 holds the weight matrix that rotates B-factors G into A-factors F. Now
CC postmultiply CB by its transpose to put the correlations of G with F into WK.
C      DO 40 I = 1,NF
C       DO 40 J = 1,NF
C        S = 0.
C        DO 41 K = 1,NV
C41       S = S + CB(LOC(I,K))*W1(J,K)
C40      WK(I,J) = S
C      DO 45 J = 1,NF
C       DC(J) = -1.
C       I = ORDER(J)
C45     IF(I>=1.AND.I<=NF) DC(J) = ACOS(MIN(1.,ABS(WK(I,J))))*RAD
CC WK holds correlations of G (rows) with F (columns).  Now find best matches.
CC Return in ORDER(N) the G-factor (pattern B) that correlates most highly with
CC the Nth F-factor (pattern A).
C      DO 50 K = 1,NF
CC       K is just a counter here, doesn't index anything.
C       NI = 0
C       NJ = 0
C        X = 0.
C       DO 60 I = 1,NF
C        DO 55 L = 1,NF
C55       IF(IABS(ORDER(L))==I) GOTO 60
CC          Skip I if already matched
C        DO 65 J = 1,NF
C         IF(ORDER(J)/=0) GOTO 65
CC          Skip I if already matched
C         R = ABS(WK(I,J))
C         IF(R<=X) GOTO 65
C         X = MIN(1.0,R)
C         NI = I
C         NJ = J
C65      CONTINUE
C60     CONTINUE
C      ORDER(NJ) = NI
CC       G-factor NI matches F-factor NJ. (Inverse of ordering in ALIGN.)
C      DM(NJ) = ACOS(X)*RAD
CC       DM(J) is correlation of F-factor J with its matching G-factor, rescaled
CC       as an angle of divergence.
C      AV = AV+DM(NJ)
C50    CONTINUE
C      AV = AV/NF
C      RETURN
C      END
CC
C      SUBROUTINE INVS(NV,W,IER)
CC This inverts an order-NV symmetric matrix W in symmetric storage
C      REAL W(*)
C      LO(I,J) = J*(J-1)/2 + I
C      IER = 0
CC Replace Q by its lower-triangular Gram-factor
C      DO 10 I = 1,NV
C       I0 = I-1
C       I1 = I+1
C       LII = LO(I,I)
C       IF(I0==0) GOTO 20
C       DO 15 K = 1,I0
C        QIK = W(LO(K,I))
C15      W(LII) = W(LII) - QIK*QIK
C20     IF(W(LII)>1.0E-35) GOTO 21
C        IER = 2
C       IF(W(LII)<0.) IER = 1
C       IF(IER==1) WRITE(6,18)
C18     FORMAT(/' *** Subroutine INVS cannot invert non-Gramian matrix'/)
C       WRITE(6,'(" Pivot = ",E10.3)') W(LII)
C       IF(IER==2) WRITE(6,19)
C19     FORMAT(/' *** Subroutine INVS cannot invert singular matrix ***')
C       WRITE(6,'(" Pivot = ",E10.3)') W(LII)
C       RETURN
C21     W(LII) = SQRT(W(LII))
C       IF(I1>NV) GOTO 50
C       DO 10 J = I1,NV
C        LIJ = LO(I,J)
C        IF(I0==0) GOTO 35
C        DO 30 K = 1,I0
C30       W(LIJ) = W(LIJ) - W(LO(K,J))*W(LO(K,I))
C35      W(LIJ) = W(LIJ)/W(LII)
C10     CONTINUE
CC Invert triangular Gram-factor
C50    W(LO(1,1)) = 1./W(LO(1,1))
C      IF(NV==1) GOTO 80
C      DO 60 I = 2,NV
C       I0 = I-1
C       LII = LO(I,I)
C       DO 62 J = 1,I0
C        X = 0.
C        DO 70 K = J,I0
C70       X = X - W(LO(K,I))*W(LO(J,K))
C62      W(LO(J,I)) = X/W(LII)
C60     W(LII) = 1./W(LII)
CC Premultiply Gram-factor inverse by its transpose
C80    DO 90 I = 1,NV
C       DO 90 J = I,NV
C        X = 0.
C        DO 95 K = J,NV
C95       X = X + W(LO(I,K))*W(LO(J,K))
C90      W(LO(I,J)) = X
C      RETURN
C      END

