C  Program HYPICK.  (Source code, FORTRAN-90. No external library needed.)
C  This is a stripped version of HYBALL that allows selected HYBUF records
C  to be collected in a new archive file HYBUF.PIK
C
C                   Last revised:  31 July 2000
C
      PARAMETER (MOM=1000)
      CHARACTER*12 WORD*40, CF, CLN*8, CH*1, F1, F2, NAME(80),
     +             WRD(0:4)*6
      INTEGER OMIT(MOM)
      INTEGER,ALLOCATABLE :: FIX(:), FIX1(:), LST(:), ORDER(:),
     +                       PFIX1(:), RECORD(:,:)
      REAL,ALLOCATABLE :: A1(:,:), C1(:,:), T1(:,:), DG(:), DE(:)
      EXTERNAL SCAN
      COMMON /CF/ CF
      DATA LIM/10/,BH/.20/,CV/1./,JA/2/,JB/2/,WSAL/0./,PD1/.5/,NOM/0/
      DATA B0/60./, B1/15./, DB/5./, DF/.5/
      DATA WRD/'STEP/S','STEP/P','SCAN/S','SCAN/P','OBLMIN'/
      LO(I,J) = J*(J-1)/2 + I
      OPEN(2,STATUS='SCRATCH')
      CALL SYSTEM('cls')
C
      WRITE(6,'(/7X,"HYPICK allows you to collect in Hyball archive",
     +  " file HYBUF.PIK any"/7X,"subset of the patterns saved in",
     +  " one of the following HYBUF files:")')
      CALL LOOK(1,'*.*',NAME,80,N)
      IF(N==0) WRITE(6,'(/ " No HYBUF files here. Go find ",
     +  "something else to do.")'); IF(N==0) STOP
      NN = 1
C      DO 6 I = N,1,-1
C6      IF(NAME(I)(:5)=='HYBUF') NN = I
7     F1 = NAME(NN)
      CALL CAP(F1,12)
      LF1 = LEN_TRIM(F1)
15    WRITE(6,'(/" The HYBUF file now set for picking is ",A,"."/
     + " Hit RETURN if OK, or enter the index of another selection",
     + " from this list."/)') F1(:LF1)
      CALL SCAN(J,1,'I')
      IF(J<0) GOTO 15
      IF(J>0) THEN
        READ(2,*) NN
        N = MAX(1,MIN(NN,N))
        GOTO 7
      END IF
      IF(F1(:9)=='HYBUF.PIK') THEN
        WRITE(6,'(/" HYBUF.PIK must be given another name of form ",
     +    "HYBUF*.* before it can be loaded."/" If you want to ex",
     +    "amine its contents, call HYBALL.")')
        STOP
      END IF
      CALL SYSTEM('copy '//F1(:LF1)//' HYBUF.PIK > nul')
      F2 = 'HYBUF.PIK   '
      OPEN(7,FILE=F1,FORM='UNFORMATTED')
      OPEN(8,FILE=F2,FORM='UNFORMATTED')
      READ(7) NNEW   ! Need step over 1st record, so may as well initialize NNEW
      READ(8) N, NV, NF
12    READ(8,END=25) NREC   ! Ascertain number of records in logfile
      GOTO 12
25    REWIND 8
      NREC = NREC+1
      ALLOCATE ( FIX(NF), FIX1(NF), LST(NREC), ORDER(NF), PFIX1(NF),
     +         RECORD(NREC,0:NF), DE(NREC) )
      ALLOCATE ( A1(NV,NF), T1(NV,NF), C1(NF,NF), DG(NF) )
      READ(8)   ! Reminder: File 8 was created by DOS copy of File 7
C
C Retrieve previous patterns and allow inspection of h'plane counts/congruences
      BH = .20
95    READ(7,END=97) NN, ((A1(I,J),I=1,NV),J=1,NF)
      NTOT = NN
      CALL BUFF(NTOT,NV,NF,NREC,BH,A1,RECORD)
      GOTO 95
97    NN = NTOT
      BACKSPACE 7
      BACKSPACE 7
      READ(7) N, ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF),
     +  LIM, BH, CV, JA,JB, WSAL, PD1, NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX, (PFIX1(I),I=1,
     +  NPFIX), B0, B1, DB, DF, TOL, IMAX, J, T, JFF
      IF(J<=-1) PP2 = AMOD(PP2,1.)
      WRITE(6,'(" Last rotation of this pattern and its main ",
     +  "control settings have been activated.")')
      NN = NTOT
C       NN indexes the pattern currently active
C
C Provide menu of branch alternatives
300   WRITE(6,'(//" At this point, you can do any of the follow",
     +  "ing:")')
      WRITE(6,'(8X,"1. See inventory of stored patterns."/8X,"2. See",
     +  " congruence of current pattern to other patterns.")')
      IF(NNEW==0) WRITE(6,'(8X,"3. Choose stored patterns for tran",
     +  "sfer to PIK file.")')
      IF(NNEW>0) WRITE(6,'(8X,"3. Choose stored patterns for tran",
     +  "sfer to PIK file"/11X,"additional to the",I3," already cop"
     +  "ied.")') NNEW
      WRITE(6,'(/" Enter the index of your choice, or any letter to",
     +  " Quit."/)')
      CALL SCAN(J,1,'I')
      IF(J==0) GOTO 300
      IF(J<0) GOTO 600
      READ(2,*) M
      GOTO (202,210,400), M
      WRITE(6,'(/" Numeral ",A," is not an operative choice.  Try",
     + " again.")')  CF(:JF(M))
      GOTO 300
C
C Retrieve a pattern produced previously
202   WRITE(6,'(/" This logfile contains ",A," patterns whose  .",I2,
     +  " hyperplane percentages are")') CF(:JF(NTOT)), NINT(100*BH)
      DO I = 1,NTOT
        CH = ' '
        IF(I==NN) CH = '>'
        WRITE(6,'(1X,A,I3,". (Av =",I3,")  ",20I3,:/19X,25I3)')
     +    CH, I, (RECORD(I,J), J=0,NF)
        IF(MOD(I,20)==0 .AND.I<NTOT-2) CALL WAIT(0)
      END DO
      WRITE(6,'(" The pattern marked "" > "" is currently active.")')
203   WRITE(6,'(/5X,"For more information on one of these patterns, ",
     +  "enter its index"/5X,"Otherwise, hit RETURN."/)')
      CALL SCAN(J,1,'I')
      IF(J==0) GOTO 300
      IF(J<=-1) GOTO 203
      READ(2,*) N
      NN = MIN(NTOT,MAX(1,ABS(N)))
      REWIND 7
      K = 0
206   READ(7)
      K = K+1   ! Positioned to read record K
      IF(K<NN) GOTO 206
      READ(7) NN, ((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF),
     +  LIM, BH, CV, JA,JB, WSAL, PD1, NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX, (PFIX1(I),I=1,
     +  NPFIX), B0, B1, DB, DF, TOL, IMAX, J, T, JFLAG

C       JFLAG: Integer coding of four fields
C         MOD(JFLAG,1000) (digits 1-3): Record No. of most recent recorded
C           pattern (NSORC) from which current pattern A1 derives.
C         MOD(JFLAG/1000,10) (digit 4): Rotation MODE
C         MOD(JFLAG/10000,10) (digit 5): 1 if permutation/reflection has
C           occurred in derivation sequence between NSORC and A1; else 0
C         JFLAG/100000) (digit 6): Type of pattern; 1 or 2 if Oblique or
C           Orthogonal Spin, 3 if initiating input, 4 or 5 if VARIMAX or
C           EQUAMAX rotation of input, 0 if MODE-controlled rotation.

      JFF = JFLAG/100000
      MODE = MOD(JFLAG/1000,10)
      K = 0
      L = 0
      DO I = 1,NF
        IB = FIX(I)
        IF(IB<99) K = K+1
        IF(IB>100) L = L+1
      END DO
      WORD(1:1) = CHAR(32+K) ! Code for no. of firmly constrained factors
      WORD(2:2) = CHAR(32+L) ! Code for no. of temporarily aligned factors
      CALL TELL(NF,NN,JFF,WRD(MODE),JA,JB,BH,CV,WSAL,NOM,NPFIX,WORD)
      GOTO 300
C
C Report congruences with other patterns
210   CALL SYSTEM('cls')
      WRITE(6,'(/" Congruence match (degrees divergence) of patt",
     +  "ern No. ",A," with patterns")') CF(:JF(NN))
      OPEN(17,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +  RECL=4*(NF+3))
      REWIND 8
      READ(8) J   ! Skip record 0
      DO K = 1,NTOT
        IF(K/=NN) THEN
          READ(8) J, ((T1(I,L),I=1,NV),L=1,NF)
          CALL ALIGN(T1,A1(1,1),ORDER,DG,NV,NF,CH,AV,HI)
          WRITE(17,REC=J) AV, (DG(I),I=1,NF), ICHAR(CH)
          DE(K) = AV
        ELSE
          READ(8) J
          WRITE(17,REC=J) 999999., (0.,I=1,NF)
          DE(K) = 999999.   ! So CLN will return asterisk string
        END IF
      END DO
      WRITE(6,'(15(8(I4,":",A4),:/))') (I,CLN(DE(I),4,1),I=1,NTOT)
      WRITE(6,'(/8X,"*** marks the currently active pattern")')
      WRITE(6,'(/"  Hit RETURN if this summary is all the congruence ",
     +  "information you want."/"  Otherwise, to see the detailed div",
     +  "ergence of pattern No. ",A," from another"/"  pattern, enter",
     +  " the latter''s index.  (Flag "" * "" will signal that the"/
     +  "  matching factors are not in the same order.)  Entering two",
     +  " indices will"/"  call detailed congruences to all patterns ",
     +  "in that range."/)')  CF(:JF(NN))
214   CALL SCAN(J,0,'I')
      IF(J<=0) CLOSE(17)
      IF(J<=0) GOTO 300
      READ(2,*) (ORDER(I),I=1,J)
      IF(J==1) ORDER(2) = ORDER(1)
      L1 = MAX(1,MIN(NTOT,ORDER(1),ORDER(2)))
      L2 = MIN(NTOT,MAX(1,ORDER(1),ORDER(2)))
      IF(L1==L2. AND. L2==NN) GOTO 300
      IF(L1==NN) L1 = L2+1
      IF(L2==NN) L2 = L2-1
      WRITE(6,'(/" Congruence match (degrees divergence) of patt",
     +  "ern No. ",A," with pattern")') CF(:JF(NN))
      L = 1 + (NF-1)/20   ! Lines needed to display one detailed match
      LL = 0              ! Screen count; Wait if LL+L  20 (or 18 at end)
      DO J = L1,L2
        IF(J==NN) CYCLE
        READ(17,REC=J) AV, (DG(I),I=1,NF), X
        WRITE(6,'(1X,A,I3,": (Av =",A5,") ",20I3,4(:/19X,20I3))')
     +    CHAR(NINT(X)), J, CLN(AV,5,1), (NINT(DG(I)),I=1,NF)
        LL = LL+L
        IF(LL>20 .OR. J==L2-1.AND.LL>18) CALL WAIT(0); LL = 0
      END DO
      WRITE(6,'(/" To see detailed divergences from another pattern,",
     +  " enter its index"/" (or index range).  Otherwise, hit RETU",
     +  "RN."/)')
      GOTO 214
C
400   NLST = 0
      WRITE(6,'(/3X,"You have four ways to select stored patterns ",
     +  "for transfer to HYBUF.PIK."/3X,"(a) To select All,",
     +  " simply hit RETURN.  (b) To select all from No. L to"/3X,
     +  "No. ",A,", enter just index L.  (c) To create a select",
     +  "ion that includes"/3X,"all from No. L to No. M, type L an",
     +  "d M and hit RETURN; you will be"/3X,"allowed to include",
     +  " others as well.  (d) Typing three or more indices"/3X,
     +  "followed by RETURN adds these to the selection list and ",
     +  "allows continuation."/3X,"(Entering any letter aborts ",
     +  "pattern transfer and exits program.)")') CF(:JF(NTOT))
401   IF(NLST==0) WRITE(6,'(/" ALL patterns are now on your selec",
     +  "tion list for transfer.")')
      IF(NLST>0) WRITE(6,'(/" The patterns selected for transfer",
     +   " are now",2(:/4X,25(1X,A))))') (CF(:JF(LST(I))),I=1,NLST)
      WRITE(6,'(" Hit RETURN if OK, or enter one or more pattern ",
     +  "indices to start again."/)')
      CALL SCAN(J,0,'I')
      IF(J<0) GOTO 999
      IF(J==0) GOTO 430
      NX = 0
405   READ(2,*) (LST(NX+I),I=1,J)
      IF(J==1 .AND. NX==0) THEN
        L = LST(NX+1)-1
        NLST = NTOT-L
        DO I = L+1,NTOT
          LST(I-L) = I
        END DO
        GOTO 401
      ELSE IF(J==2) THEN
        L1 = MAX(1,MIN(NTOT,LST(NX+1),LST(NX+2)))-1
        L2 = MIN(NTOT,MAX(1,LST(NX+1),LST(NX+2)))
        DO I = 1,L2-L1
          LST(NX+I) = L1+I
        END DO
        NX = NX+L2-L1
      ELSE
        NX = NX+J
      END IF
      WRITE(6,'(" Enter more pattern indices, or hit RETURN to see"
     +  " completed listing."/)')
      CALL SCAN(J,0,'I')
      IF(J>0) GOTO 405
      NLST = 0
      LP:DO I = 1,NTOT
        DO J = NLST+1,NX
          IF(I==LST(J)) THEN
            NLST = NLST+1
            LST(J) = LST(NLST)
            LST(NLST) = I
            CYCLE LP
          END IF
        END DO
      END DO LP
      GOTO 401
430   IF(NLST>0) GOTO 450
      NLST = NTOT
      DO I = 1,NLST
        LST(I) = I
      END DO
C
450   WRITE(6,'(/" Transfer of selected patterns is underway.")')
      REWIND 7
      READ(7)
      NLL = 1
      NN = 0
460   NN = NN+1
      IF(NN<LST(NLL)) THEN
        READ(7)
        GOTO 460
      END IF
      READ(7,END=300) N,((A1(I,J),I=1,NV),J=1,NF),((C1(I,J),I=1,NF),J=1,
     +  NF), LIM,BH,CV,JA,JB,WSAL,PD1,NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX, (PFIX1(I),I=1,
     +  NPFIX), B0, B1, DB, DF, TOL, IMAX, J, T, JFF
      NNEW = NNEW+1
      WRITE(8) NN,((A1(I,J),I=1,NV),J=1,NF), ((C1(I,J),I=1,NF),J=1,NF),
     +  LIM, BH, CV, JA,JB, WSAL, PD1, NOM, (OMIT(I),I=1,NOM),
     +  (FIX(I),I=1,NF), NB, (FIX1(I),I=1,NB), NPFIX, (PFIX1(I),I=1,
     +  NPFIX), B0, B1, DB, DF, TOL, IMAX, J, T, JFF
      IF(NLL>=NLST) GOTO 300
      NLL = NLL+1
      GOTO 460
C
600   CONTINUE
      WRITE(6,'(/I4," patterns have been copied to file ",A)') NNEW,F2
      ENDFILE 8
      STOP
999   CLOSE(8,STATUS='DELETE')
      END
C
      SUBROUTINE ALIGN(A,B,ORDER,DG,NV,NF,CH,AV,HI)
C This compares the columns of NV-by-NF matrix A to those of matrix B, and puts
C into vector ORDER the permutation (and reflection if signalled by negative
C ORDER value) of A's columns that aligns A with B most closely. The congruence
C coefficients for the best match are converted to degrees difference and
C reported in vector DG with their average in AV and max in HI.  And CH returns
C '*' if optimal axis alignment requires a proper (non-identity) permutation.
      CHARACTER CH
      INTEGER ORDER(*)
      REAL A(NV,*), B(NV,*), WORK(NV,NF+2), DG(*)
      RAD = 90/ACOS(0.)
      DO J = 1,NF
        ORDER(J) = 0
        WORK(J,NF+1) = 0
        WORK(J,NF+2) = 0
        DO I = 1,NV
          WORK(J,NF+1) = WORK(J,NF+1) + A(I,J)*A(I,J)
          WORK(J,NF+2) = WORK(J,NF+2) + B(I,J)*B(I,J)
        END DO
      END DO
      DO J = 1,NF
        DO K = 1,NF
          SAB = 0
          DO I = 1,NV
            SAB = SAB + A(I,J)*B(I,K)
          END DO
          WORK(J,K) = SAB/SQRT(MAX(WORK(J,NF+1)*WORK(K,NF+2),1.E-8))
        END DO
      END DO
      CH = ' '
      AV = 0.
      HI = 0.
      BIG: DO K = 1,NF
        NI = 0
        NJ = 0
         X = 0.
        BG: DO J = 1,NF
          DO L = 1,NF
            IF(ABS(ORDER(L))==J) CYCLE BG
C             Skip J if already matched
          END DO
          DO I = 1,NF
            IF(ORDER(I)/=0) CYCLE
C             Skip I if already matched
            R = ABS(WORK(I,J))
            IF(R<X) CYCLE
            X = MIN(1.0,R)
            NI = I
            NJ = J
          END DO
        END DO BG
        ORDER(NI) = SIGN(NJ,FLOOR(WORK(NI,NJ)))
C         A-factor NI matches B-factor NJ while negative NJ tells PERM to reflect.
C         ORDER permutes A into B-matching order.
        IF(NI/=NJ) CH = '*'
        DG(NJ) = ACOS(X)*RAD
C         DG(J) is divergence of B-factor J from its matching A-factor
C         DG(ABS(ORDER(K))) is divergence of A-factor K from matching B-factor
        AV = AV+DG(NJ)
        HI = MAX(HI,DG(NJ))
      END DO BIG
      AV = AV/NF
      RETURN
      END

      SUBROUTINE BUFF(NTOT,NV,NF,NREC,BH,A1,RECORD)
      INTEGER RECORD(NREC,0:*)
      REAL A1(NV,*)
      IJSUM = 0
      DO J = 1,NF
        IP = 0
        DO I = 1,NV
          IF(ABS(A1(I,J))<=BH) IP = IP+1
        END DO
        IJSUM = IJSUM + IP
        RECORD(NTOT,J) = NINT((IP*100.0)/NV)
      END DO
      RECORD(NTOT,0) = NINT((IJSUM*100.0)/(NV*NF))
      RETURN
      END
C
      SUBROUTINE CAP(WORD,L)
C This makes the first L letters in WORD all upper-case.
      CHARACTER WORD*(*)
      DO I = 1,L
        N = ICHAR(WORD(I:I))
        IF(N>=97 .AND. N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      RETURN
      END
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X)))
      LD = MIN(ABS(ND),M)
      IF(LD<0) GOTO 55
      CLN = '        '
      IF(ABS(X)>1.E9) GOTO 55
      IF(ABS(X)<1.0E-12) THEN
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      IF(LD>=10) LD = 0
      DO I = 1,KW
        WK(I) = ' '
      END DO
      N = NINT(ABS(X)*10**LD)  ! ***** Screen out X larger than max integer
      IF(LD==0) N = NINT(ABS(X))  ! Shouldn't be needed, but apparently is !
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' *******'
      END FUNCTION

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
C      SAVE /CF/  ! This doesn't appear to be needed
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      FUNCTION LH(WORD,LN)
C Look for extension dot in WORD.  If found, LH returns number of characters
C prior to that; otherwise, LH returns full length LN of WORD.
      CHARACTER WORD*(*)
      LN = LEN_TRIM(WORD)
ccc      N = LEN(WORD)     ! Test result: Length of WORD*(*) is identified here
      LH = LN
      IF(LN==0) RETURN
      DO LH = 1,LN-1
        IF(WORD(LH+1:LH+1)=='.') RETURN
      END DO
      END FUNCTION
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
C ***** Note: This version of LOOK contains a FLAG provision
      LOGICAL PRM, QY, QLOG
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP, FLAG(80)
      CHARACTER E   ! <<<  Special characters as needed
      DATA FLAG/80*' '/
      WD = GET
      CALL LAST(M,WD,40)
      LL = 1
5     LL = LL+1
      E = WD(LL+1:LL+1)
      IF(E/='|' .AND. E/='/' .AND. LL<M) GOTO 5  ! *** No longer relevant??
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(WORD(:1)==' '.OR.WORD(:1)=='.'.OR.WORD(:1)=='$'.OR.
     +   WORD(:1)=='#'.OR.WORD(:4)=='LUMP'.OR.WORD(:3)=='FAC'.
     +   OR.WORD(:1)==')'.OR.WORD(:1)=='(') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
C       Filter out lines other than filenames
      CALL LAST(L,WORD,14)
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
      IF(WORD(:4)=='INHY' .OR. QLOG(WORD(:12))) GOTO 19
      IF(WORD(:3)=='SEE') GOTO 10
      IF(K==0) GOTO 10
      J = ICHAR(WORD(11:11))
      IF(J<48 .OR. J>57) GOTO 10
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4).AND.NAME(I)(L+5:L+5)==' ') GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      IF(QLOG(NAME(NL))) THEN
        IF(QLOG(NAME(NL))) FLAG(NL) = '+'
        NN = NN+1
      END IF
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>0) WRITE(6,'(20(:/4(I5,''.'',2A,:)))') (I,FLAG(I),
     +  NAME(I),I=1,NL)
      IF(NL>0) WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      CALL LAST(L1,NAM1,LEN(NAM1)); CALL LAST(L2,NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      CALL LAST(L1,WRD1,LEN(WRD1)); CALL LAST(L2,WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A mumber terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION
C
      FUNCTION ORTH(NF,C1)
C Return the largest discrepancy of covar matrix C1 from orthonormality.
      REAL C1(NF,*)
      ORTH = 0.
      DO J = 1,NF
        ORTH = MAX(ORTH,ABS(C1(J,J)-1.))
        DO I = 1,J-1
          ORTH = MAX(ORTH,ABS(C1(I,J)))
        END DO
      END DO
      RETURN
      END
C
      FUNCTION QLOG(WORD)
C  Return .TRUE. if WORD is a HYBUF file, otherwise .FALSE.
      LOGICAL QLOG
      CHARACTER WORD*(*)
      QLOG = .FALSE.
      IF(WORD(:5)=='HYBUF' .OR. WORD(9:10)==' #') QLOG = .TRUE.
      N = LH(WORD,LN)
      IF(QLOG .OR. N>=LN-1) RETURN  ! No extension in 2nd case
      IF(WORD(N+2:N+2)=='#') QLOG = .TRUE.
      END FUNCTION

      SUBROUTINE SCAN(NL,NS,SEQ)
C This reads the keyboard string, cleans it for list-directed reading of
C the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.  Termination of an input line by "*" allows up to
C two continuation lines.) NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number
C string returned in File 2 is non-null but does not match SEQ, and
C gives the total count of numbers in the returned string otherwise.
C *** If SEQ is "B", NL returns 0 if the input line is blank, and
C     returns -1 otherwise.
      CHARACTER  AA, SEQ*(*), WA*240, WB*240
      NL = 0
5     NLL = NL + 80
      READ(5,'(A80)') WA(NL+1:NLL)
      IP = NL
      NL = NLL+1
10    NL = NL-1
      IF(NL==0) RETURN
      IF(WA(NL:NL)==' ') GOTO 10
      IF(WA(NL:NL)=='*' .AND. NL>IP) GOTO 5
      IF(SEQ(1:1)=='B') NL = -1
      IF(SEQ(1:1)=='B') RETURN
      WB(NL+1:NL+1) = ' '
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +      WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
        ELSE IF (WA(I:I) /= '0') THEN
          IP = 0
        END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF (WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) RETURN
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     +  "number sequence requested. Try again.")')
      RETURN
60    REWIND 2
      WRITE(2,'(A)') WB(1:NL)
      NL = NN
      REWIND 2
      END SUBROUTINE
C
      SUBROUTINE TELL(NF,NN,JFF,CH6,JA,JB,BH,CV,WSAL,NOM,NPFIX,WORD)
      CHARACTER*6 CH6, WORD*(*), CF*12, CLN*8
      COMMON /CF/ CF
      WORD(3:8) = 'nosome'
      WRITE(6,'(3X,"Retrieved pattern No. ",A," has obliquity",A4,
     + " and reinstates controls ",A,","/5X,"<JA,JB,BH,CV,WSAL",
     + "> = <",2(I2,","),2(A4,","),A4,"> and ",A," item ex",
     + "clusions.")') CF(:JF(NN)), CLN(ORTH(NF,C1),4,2), CH6, JA,
     + JB, CLN(BH,4,2), CLN(CV,4,1), CLN(WSAL,4,1), WORD(3+2*MIN(
     + 1,NOM):4+4*MIN(1,NOM))
      IF(JFF==1) WRITE(6,'(24X,"It is a SPIN solution.")')
CCC      IF(JFF==1) WRITE(6,'(19X,"It is an OBLIQUE SPIN solution.")')
      IF(JFF==2) WRITE(6,'(18X,"It is an ORTHOGONAL SPIN soluti",
     +  "on.")')
      IF(JFF==3) WRITE(6,'(20X,"This is the starting pattern.")')
      IF(JFF==4) WRITE(6,'(22X,"It is a VARIMAX solution.")')
      IF(JFF==5) WRITE(6,'(22X,"It is an EQUAMAX solution.")')
      N1 = ICHAR(WORD(1:1))-32  ! Number of firmly constrained factors
      N2 = ICHAR(WORD(2:2))-32  ! Number of temporarily constrained factors
      IF(N1+N2+NPFIX>0) THEN
        WRITE(6,'(5X,"NOTE: Constraints on factor positioning ",
     +    "have also been reactivated.")')
        IF(N2+NPFIX>0) THEN
          WRITE(6,'(11X,"These include temporary factor alignments ",
     +      "and pattern fixations.")')
        ELSE IF(N2>0) THEN
          WRITE(6,'(11X,"These include some temporary factor align",
     +      "ments.")')
        ELSE IF(NPFIX>0) THEN
          WRITE(6,'(11X,"These include some temporary pattern fixa",
     +      "tions.")')
        END IF
      END IF
      RETURN
      END
C
      SUBROUTINE WAIT(N)
C  N < 0 calls for space before screen display
      IF(N>0) WRITE(6,'()')
      WRITE(6,'(" Hit RETURN to continue")')
      READ(5,'(A1)')
      RETURN
      END
C
C The following subprograms are specific to the Lahey compiler.
C
      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12
      COMMON /CF/ CF
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48
      IF(ZZZ(5:6)=='01') WORD = CF(:JF(M))//' January '//ZZZ(:4)
      IF(ZZZ(5:6)=='02') WORD = CF(:JF(M))//' February '//ZZZ(:4)
      IF(ZZZ(5:6)=='03') WORD = CF(:JF(M))//' March '//ZZZ(:4)
      IF(ZZZ(5:6)=='04') WORD = CF(:JF(M))//' April '//ZZZ(:4)
      IF(ZZZ(5:6)=='05') WORD = CF(:JF(M))//' May '//ZZZ(:4)
      IF(ZZZ(5:6)=='06') WORD = CF(:JF(M))//' June '//ZZZ(:4)
      IF(ZZZ(5:6)=='07') WORD = CF(:JF(M))//' July '//ZZZ(:4)
      IF(ZZZ(5:6)=='08') WORD = CF(:JF(M))//' August '//ZZZ(:4)
      IF(ZZZ(5:6)=='09') WORD = CF(:JF(M))//' September '//ZZZ(:4)
      IF(ZZZ(5:6)=='10') WORD = CF(:JF(M))//' October '//ZZZ(:4)
      IF(ZZZ(5:6)=='11') WORD = CF(:JF(M))//' November '//ZZZ(:4)
      IF(ZZZ(5:6)=='12') WORD = CF(:JF(M))//' December '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE

