C           Program MERGE.  (Source code: FORTRAN-90)
C
C                  Last revised: 14 May 2001
C
C This merges and overlays HYDATA-standard datafiles {Fi}.  Any score for
C ID <n> on variable <name> in file Fj overwrites any score for this same
C <n> on <name> in Fi if i < j.
C
      CHARACTER(12) F2,F3,CH12, CF,CLEAR, WORD*250,NAME(40), CH2*2,CH4*4
C       IDEN2(1,J) is the number of letters starting the Jth variable's name;
C       IDEN2(2,J) is the number finishing the name (0 if none)
C       NV(i) is the number of variables in file i; NP(i) the number prior
C       to i; KF(i) the unit number assigned to file i; LF(i) the length of
C       file i's name; MXX(i) the maximum ID No. in file i.
      CHARACTER,ALLOCATABLE :: F1(:)*12, FMT(:)*35, IDENT(:)*8, CHF(:)*2
      INTEGER,ALLOCATABLE :: LST(:), NV(:), NP(:), KF(:), MXX(:), LF(:),
     +        IDEN2(:,:), ORD(:), PIK(:), KREC(:), KWD(:), NUL(:), KX(:)
      COMMON /CF/ CF
      DATA NFIX/0/, MIS/0/
      OPEN(2,STATUS='SCRATCH')
      CLEAR = '            '
      LMM = 3  ! Initialize; longest name over all files
      CALL SYSTEM('cls')
      WRITE(6,'(/" MERGE combines the data in two or more Hydata-stand",
     +  "ard datafiles into a"/" single D-file under presumption that ",
     +  "the merged files overlap in their"/" variables, subjects, or ",
     +  "both.  Common variables are identified as such"/" by their na",
     +  "mes, common subjects by their ID Numbers.  So"//3X,"WARNING:",
     +  "  Do NOT merge D-files in which the left-hand column of IDs"/
     +  13X,"is simply list position unless you are sure that the same"/
     +  13X,"subjects are in the same position in each list.")')
      WRITE(6,'(//" The HYDATA-standardized datafiles available in ",
     +  "this subdirectory are:")')
      CALL LOOK(1,'*.D*',NAME,40,MF)
      IF(MF==0) WRITE(6,'(/ " No work for MERGE here. Go find some",
     +  "thing else to do.")')
      IF(MF==1) WRITE(6,'(/ " Only one D-file here, not enough to ",
     +  "merge.")')
      IF(MF<=0) STOP
      ALLOCATE ( F1(MF), LF(MF), LST(MF), KWD(0:MF), NUL(0:MF) )
      NF = MF; KWD = 3; NUL = -99; NW4 = 0; NW5 = 0; NSX = 0
      LST = (/(I,I=1,MF)/)   ! NWk is number of files with KWD=k
10    DO I = 1,NF
        F1(I) = NAME(LST(I))
        CALL LAST(LF(I),F1(I),12)
      END DO
12    WRITE(6,'(/" The list of files to be merged/overlaid is now",
     +  5(:/6(2X,A,:,",")))') (F1(I)(:LF(I)),I=1,NF)
      WRITE(6,'(/" Hit return if OK, or enter wanted sequence of file",
     +  " indices from this list.")')
      WRITE(6,'(" Don''t forget that files later in the sequence will ",
     +  "overlay preceding files"/" wherever they have ID/Variable coo",
     +  "rdinates in common.  So if you want these"/" files processed i"
     +  "n a different order, re-enter their indices accordingly."//)')
      CALL SCANC(J,0,'I',5,CH2,L)
      IF(J==0) GOTO 15
      IF(J==-2) WRITE(6,'(" You have entered letters, not D-file ",
     +  "indices.  Try again.")')
      IF(J==-2) GOTO 12
      READ(2,*) (LST(I),I=1,J)
      LST(1) = MAX(1,MIN(MF,LST(1)))
      NF = 1     ! NF is count of files to be merged
      DO I = 2,J
        LI = LST(I)
        DO K = 1,NF
          IF(LI==LST(K) .OR. LI<1 .OR. LI>N) CYCLE
        END DO
        NF = NF+1
        LST(NF) = LI
      END DO
      GOTO 10
C
15    DEALLOCATE ( LST )
      ALLOCATE ( FMT(0:NF), CHF(0:NF) )
      ALLOCATE ( NV(NF), NP(NF), KF(NF), MXX(NF), KREC(NF) )
      NVT = 0     ! Total number of variables over files
      MREC = 0    ! Maximum number of records in any one file
      KKRC = 0    ! Sum of records over files
      MXID = 0    ! Maximum ID over files
      NP(1) = 0   ! Zero variables prior to first input file
      CHF = '  '
      DO K = 1,NF
        KF(K) = 10+K
        OPEN(KF(K),FILE=F1(K))
        NP(K) = NVT    ! total count of variables in files prior to K
        READ(KF(K),'(A)') WORD  !!! NOTE: SCAN call will L-justify WORD
        IF(WORD(2:7)/='HYDATA') THEN
          WRITE(6,'(/A," is not a HYDATA-standard datafile.  ",
     +      "The run is aborted.")') F1(K)(:LF(K)); STOP
        END IF
        CALL SCANC(J,4,'IIIR',-1,WORD(39:),L)

c HYDATA-standard datafile xxxxxxxxxxxx: xxx variables, xxxx records; maximum ID No.xxxxxxxxxx; transcribed under DEV = xxxx
c      from datafile xxxxxxxxxxxx; datafix xx; xxxxx missing scores.
c $$$ HYDATA NOW WRITES
cHYDATA-standard datafile   BUEQ.D1   : 243 variables, 558 records; largest ID, 558; transcribed under DEV = 99.0
c       from rawdata source  BUEQA.DAT  ; datafix 0; 8700 missing scores; 0 complete records.

        IF(J<4) THEN
          CALL LAST(LL,WORD,130); CALL LAST(LF(K),F1(K),12)
          WRITE(6,'(" ERROR: Header of ",A," is"/1X,A)')
     +      F1(K)(:LF(K)), WORD(:LL)
          STOP
        END IF
        READ(2,*) NV(K), KREC(K), MXX(K); WORD(:12) = WORD(26:37)
        CALL LAST(L,WORD(:12),12)
        WRITE(6,'(/1X,A," is a ",A,"-variable datafile with ",A," rec",
     +    "ords and IDs up to ",A)') F1(K)(:LF(K)), CF(:JF(NV(K))),
     +    CF(:JF(KREC(K))), CF(:JF(MXX(K)))
        IF(WORD(:L) /= F1(K)(:LF(K))) WRITE(6,'(/" It was originally ",
     +    "written under name ",A)') WORD(:L)
        WRITE(6,'(" Hit RETURN to approve, or enter anything to revi",
     +    "se your selection.")');
        CALL SCANC(J,0,'B',5,CH2,L); IF(J/=0) GOTO 12
        READ(KF(K),'(A)') WORD
        CALL SCANC(J,2,'II',-1,WORD(43:),L)  ! Both terms wanted, L not used
        READ(2,*,END=18,ERR=18)  N, M   ! Branch to 18 should never occur, but no harm if it does
        NFIX = MAX(N,NFIX)  ! Number of Fixdata passes
        MIS = MIS+M         ! Number of missing scores
18      CHF(K) = CF(:JF(JF(MXX(K))))   ! 2nd position almost always left blank; no sweat
        NVT = NVT+NV(K)   ! Total number of variables across all files
        MREC = MAX(MREC,KREC(K)) ! Largest number of records in any one file
        KKRC = KKRC + KREC(K)   ! Sum of KREC over all files
        MXID = MAX(MXID,MXX(K))  ! Largest ID over all files
      END DO
      MVV = NVT+1       ! +1 possibly needed by ORD and NBIN in TSCRB
      ALLOCATE ( LST(KKRC), IDENT(MVV), IDEN2(2,MVV) )
      ALLOCATE ( ORD(MVV), PIK(MVV), KX(MVV) )
      KX = 0  ! Initialize Rescale listing
      DO K = 1,NF
        READ(KF(K),*,ERR=20,END=20) (IDENT(NP(K)+I),I=1,NV(K))
20      READ(KF(K),'(A)') WORD

Cccc      IF(NSX>0) WRITE(7,'("Rescale",8(2X,5I3),20(/8X,8(2X,5I3)))') (KX(I),I=1,NY)
        IF(WORD(:7)=='Rescale') THEN
          BACKSPACE 3
          READ(3,'(20(8X,8(2X,5I3):/))') (KX(NP(K)+I),I=1,NV(K))
          DO I = 1,NV(K); IF(KX(NP(K)+I)/=0) NSX = NSX+1; END DO
          READ(KF(K),'(A)') WORD
        END IF

C Code for diagnosing/reading fieldwidths 4 and 5
        BACKSPACE KF(K)
        WORD(:1) = 'X'; CALL LAST(LL,WORD,LEN(WORD)) ! Start of WORD mustn't be blank
        LL = LL-1-JF(MXX(K))  ! Length of scorelist in line
        IF(LL==4*MIN(45,NV(K))) THEN
          KWD(K)=4; NUL(K) = -999; NW4=NW4+1
        ELSE IF(LL==5*MIN(40,NV(K))) THEN
          KWD(K)=5; NUL(K) = -9999; NW5=NW5+1
        END IF
        KWD(0) = MAX(KWD(0),KWD(K)); NUL(0) = MIN(NUL(0),NUL(K))
        M = L*1000 + KWD(K)  ! File index & fieldwidth to associate with item names
        DO L = NP(K)+1, NP(K)+NV(K); PIK(L) = M; END DO ! PIK gets ^ info
      END DO
      IF(NW4+NW5==0 .OR. NW4==NF .OR. NW5==NF) GOTO 21  ! All files have same fieldwidths
      DO I = 1,NVT-1
        DO J = I+1,NVT
          IF(IDENT(I)/=IDENT(J) .OR. IK==JK) CYCLE
          IK = MOD(PIK(I),1000); JK = MOD(PIK(J),1000)
          IL =  PIK(I)/1000; JL =  PIK(J)/1000
          CH12 = IDENT(I); CALL LAST(NN,CH12,12)
          WRITE(6,'(/" >>> MERGE PROBLEM:  The fieldwidth of scor",
     +      "es on item ",A," is",I2," in"/5X,"file ",A," but",I2,
     +      " in file ",A,".  (This mismatch may well"/5X,"hold fo",
     +      "r other items and between other files in this set as ",
     +      "well.)"/5X,"See ","the advice on this situation under",
     +      " MERGE in README.DOC.")') CH12(:NN), IK, F1(:LF(IL)),
     +      JK, F1(:LF(JL))
          STOP
        END DO
      END DO
21    CHF(0) = CF(:JF(JF(MXID)))
      F2 = F1(1)
      CALL NAME1(F2,F3,6,LLF)
      WRITE(6,'(/" By default, the merged file''s basename will be ",A/
     +  " Hit RETURN if OK, or enter alternative basename."/)')
     +  F2(:LLF-3)
      READ(5,'(A)') WORD; CALL LAST(J,WORD,80)
      IF(J==0) GOTO 25
23    CALL CAP(WORD,LLF)
      F2 = WORD(:12); CALL LAST(LF2,F2,12)
      CALL NAME1(F2,F3,6,LLF)
      WRITE(6,'(/" The merged file''s basename is now set to be ",A/
     +  " Hit RETURN if OK, or enter alternative."/)') F2(:LLF-3)
      READ(5,'(A)') WORD(:12); CALL LAST(J,WORD,12)
      IF(J/=0) GOTO 23
      IF(F2(:LLF-3) /= F1(1)(:LLF-3)) GOTO 27
25    WRITE(6,'(/" If you want the merged datafile to replace input ",
     +  "file ",A," under that"/" same name, enter anything.  Otherw",
     +  "ise, hit RETURN to write the merged"/" file under name ",A)')
     +  F1(1)(:LF(1)), F2(:LLF)
      CALL SCANC(J,0,'B',5,CH2,L)
      IF(J/=0) F2 = F1(1); CALL LAST(LF2,F2,12)
27    OPEN(8,FILE=F3)
      CALL FNDEND(8)
      WRITE(8,'(//40("* ")/" Datafile ",A,": Produced by merging data",
     +  "files",50(2X,A,:,","))') F2(:LF2), (F1(I)(:LF(I)),I=1,NF)
      CALL DAY(8)
      PIK = (/(I,I=1,MVV)/)
      DO I = 1,NF
        WRITE(8,'(/" The variables in file ",A," were named")')
     +    F1(I)(:LF(I))
      CALL SEENAM(LM,NV(I),PIK,IDENT(NP(I)+1),130,1,8)
      END DO
      LMM = MAX(LMM,LM)
C
C   Get ordered LST of distinct IDs from all files; ITOT is total count
      CALL GETREC(LST,ITOT,MXX,MREC,MXID,CHF,KF,NF,NV,KWD)
      NN = 0
      WRITE(6,'(//5X,"You may leave the merged variables in the order",
     +  " loaded except for"/5X,"overwriting of items earlier in the ",
     +  "sequence by ones with the same"/5X,"name encountered later, ",
     +  "or, alternatively, can permute the"/5X,"merged variables int",
     +  "o alphanumeric name order.")')
30    IF(NN==0) WRITE(6,'(/" If you prefer merged variables to rem",
     +  "ain in the order received, hit RETURN.")')
      IF(NN/=0) WRITE(6,'(/" If you prefer merged variables to be ",
     +  "ordered alphanumerically, hit RETURN.")')
      WRITE(6,'(" Otherwise, enter anything for alternative."/)')
      CALL SCANC(J,0,'B',5,CH2,L)
      IF(J/=0) NN = 1-NN
      IF(J/=0) GOTO 30
      IF(NN==0) THEN
C       Set merge without lexicographic reordering
        NX = 0
        ORD(NVT) = NVT
        LP1: DO J = 1,NVT-1
          ORD(J) = J
          DO K = J+1,NVT
            IF(IDENT(J)==IDENT(K)) THEN
              ORD(J) = -J   ! Flag that name occurs later in raw-merge list
              CYCLE LP1
            END IF
          END DO
          NX = NX+1
        END DO LP1 !! ORD is integer sequence 1,..,NVT with duplication flags
      ELSE
C       Set names in lexicographic order.
        WRITE(6,'(" Sorting variable names into lexicographic order.")')
        CALL PARS(1,NVT,IDENT,IDEN2,MVV)
        ORD(1) = 1   ! Will initialize remainder of ORD as needed
        DO K = 2,NVT
          ORD(K) = K
          LK = IDEN2(1,ORD(K))
          KN = ORD(K)
          DO J = K-1,1,-1
            LJ = IDEN2(1,ORD(J))
            JN = ORD(J)
            IF(LLT(IDENT(JN)(:LJ),IDENT(KN)(:LK))) GOTO 40  ! Don't permute
            IF(LGT(IDENT(JN)(:LJ),IDENT(KN)(:LK))) GOTO 35  ! Do permute
            IF(IDEN2(2,JN) <= IDEN2(2,KN)) GOTO 40          ! Don't permute
35          ORD(J+1) = JN
          END DO  ! Last in identical sequence is last encountered
          J = 0
40        ORD(J+1) = KN
        END DO
C     Flag duplicate names with minus signs; don't flag the last in sequence
        DO J = 2,NVT
          IF(IDENT(IABS(ORD(J)))==IDENT(IABS(ORD(J-1)))) ORD(J-1) =
     +       -ORD(J-1)
        END DO
      END IF
C Given ORD properly flagged, both orderings have same finsh
      NX = 0
      DO J = 1,NVT
        IF(ORD(J)<0) CYCLE
        NX = NX+1
        PIK(NX) = ORD(J)  ! PIK picks in wanted order the wanted names in IDENT
      END DO
      OUTER:DO J = 1,NVT
        DO K = 1,NX
          IF(IDENT(J)==IDENT(PIK(K))) THEN
            ORD(J) = K; CYCLE OUTER
          END IF
        END DO
      ENDDO OUTER

C Merge/overlay data records in scratchfile 17
      DO K = 0,NF
        CH4 = '50I3'
        IF(KWD(K)==4) CH4 = '45I4'; IF(KWD(K)==5) CH4 = '40I5'
        FMT(K) = '(I'//CHF(K)//',1X,'//CH4//',40(:/'//CHF(K)//
     +            'X,1X,'//CH4//'))'
      END DO
      FMT(0) = FMT(0)(:5)//'":"'//FMT(0)(8:)
      WRITE(6,'(/" File merging has begun.  Be patient.")')
      DO K = 1,NF
        CALL POSITN(KF(K),CHF(K))
      END DO
      CALL TSCRB(NX,NF,MF,ITOT,ORD,FMT,KF,NV,NP,LST,MVV,NMIS,NUL)
      OPEN(7,FILE=F2)
      CH12 = CLEAR; CH12((13-LF2)/2:) = F2   ! Center name in fieldwidth 12
      WRITE(7,'(" HYDATA-standard datafile ",A,": ",A," variables ",A,
     +  " records; largest ID No. ",A,";   assembled under DEV = 99.0"
     +  " by MERGE")') CH12, CF(:JF(NX)), CF(:JF(ITOT)), CF(:JF(MXID))
      CH12 = CLEAR; CH12((13-LF(1))/2:) = F1(1)//'       '
      WRITE(7,'(8X,"from headfile ",A," (datafix ",A,", missing in ",
     +  "merge, ",A,") followed by",20(2X,A))') CH12, CF(:JF(NFIX)),
     +  CF(:JF(NMIS)), (F1(I)(:LF(I)),I=2,NF)
      L = 150/(LMM+1)
      WORD(:17)='(50('//CHAR(48+L/10)//CHAR(48+MOD(L,10))//'(1X,A),:/))'
      WRITE(7,WORD(:17)) (IDENT(PIK(I))(:LMM),I=1,NX)
      IF(NSX>0) WRITE(7,'("Rescale",8(2X,5I3),20(/8X,8(2X,5I3)))')
     +  (KX(PIK(I)),I=1,NX)
      IF(NN==1) WRITE(8,'(/" The list of merged variables in ",A,
     +  ", reordered alphanumerically, is")') F2(:LLF)
      IF(NN==0) WRITE(8,'(/" The list of merged variables in ",A,
     +  "ordered as received in input except for"/" common variables ",
     +  "in positions of their last encounter, is")') F2(:LLF)
      CALL SEENAM(LM,NX,PIK,IDENT,130,1,8)
      WRITE(8,'(/" The merged file contains ",A," data records with ",
     +  "IDs ranging from ",A," to ",A)') CF(:JF(ITOT)),
     +  CF(:JF(LST(1))), CF(:JF(MXID))
      WRITE(8,'(" The number of missing scores in this merge is ",A)')
     +  CF(:JF(NMIS))
      REWIND 17
60    READ(17,END=70) (PIK(I),I=1,NX+1)
      WRITE(7,FMT(0)) (PIK(I),I=1,NX+1)
      GOTO 60
C
70    WRITE(6,'(/" Raw-data file merging is complete. The input/outpu",
     +  "t filenames and the indexed"/" list of merged variable names",
     +  " have been recorded in file ",A)') F3(:LLF)
      WRITE(6,'(/" The merged datafile is named ",A)') F2
      STOP
      END
C
      SUBROUTINE CAP(WORD,L)
C This makes the first L letters in WORD all upper-case.
      CHARACTER WORD*(*)
      DO I = 1,L
        N = ICHAR(WORD(I:I))
        IF(N>=97 .AND. N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      END SUBROUTINE

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
C      SAVE /CF/  ! This doesn't appear to be needed
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      SUBROUTINE FNDEND(K)
C Finds end of file K for appending; Lahey and Microsoft compilers requires
C backspace.
      BACKSPACE K
10    READ(K,'()',END=20)
      GOTO 10
20    BACKSPACE K
      END SUBROUTINE
C
      SUBROUTINE GETREC(IDS,ITOT,MXX,MREC,MXID,CHF,KF,NF,NV,KWD)
C This puts the merged IDs in ascending order into IDS and finds the total
C number ITOT thereof. MXID is input of the maximum ID; KF the list of input
C files; NF the number of files. KBIN is a workspace.
      CHARACTER(2) CHF(0:*), FMT*5, CF*12
      INTEGER IDS(*), KBIN(NF,0:MREC+1), KF(*), NV(*), MXX(*), KWD(*),
     +        KSP(NF)
      COMMON /CF/ CF
      WRITE(6,'(" Loading the list of IDs in all files.")')
C Put ID lists from the Kth input file into the Kth row of KBIN
      MREC = 0
      LXID = 0
      DO K = 1,NF
CC        KSP(K) = (NV(K)-1)/50; IF(KWD(K)==4) KSP(K) = (NV(K)-1)/45
        KSP = (NV(K)-1)/50; IF(KWD(K)==4) KSP(K) = (NV(K)-1)/45
        NR = 0  !  ^ Number of lines in record after the 1st
        FMT = '(I'//CHF(K)//') '
        CALL POSITN(KF(K),CHF(K))
10      READ(KF(K),FMT,END=11) N
        CALL SKIP(KF(K),KSP) ! ^ Space down KSP lines to get next ID.
        NR = NR+1
        KBIN(K,NR) = N
        LXID = MAX(LXID,N)
        GOTO 10
11      KBIN(K,0) = NR
        MREC = MAX(MREC,NR)  ! Shd also check if NRs and MREC agree with file reads ??
      END DO
      IF(LXID/=MXID)   WRITE(8,'(/" WARNING: The maximum ID (",A,
     +  ") found by MERGE does not agree with the input file header"
     +  " information.")') CF(:JF(LXID))
C Pad out the rest of KBIN just past longest row with maximum ID,
      DO K = 1,NF
        IF(KBIN(K,KBIN(K,0))/=MXX(K)) WRITE(6,'(" WARNING: The last ",
     +    "ID (",A,") in datafile ",A," does not agree with the"/" m",
     +    "aximum ID (",A,") declared in this file''s header line.")')
     +    CF(:JF(KBIN(K,KBIN(K,0)))), CF(:JF(K)), CF(:JF(MXX(K)))
        DO J = KBIN(K,0)+1,MREC+1
          KBIN(K,J) = LXID
        END DO
        KBIN(K,0) = 1  ! Initialize running row indices
      END DO
C Put merged IDs into IDS in increasing order.
      WRITE(6,'(" Sorting the merged IDs into ascending order.")')
      ITOT = 0
30    ITOT = ITOT+1
      IDS(ITOT) = LXID  ! Initialize
      DO K = 1,NF   ! Rem: KBIN(K,0) is now the 1st term in row K not yet merged
        IDS(ITOT) = MIN(IDS(ITOT),KBIN(K,KBIN(K,0)))
      END DO           ! In each row K, advance still-to-merge counter if
      DO K = 1,NF      !  start  of list is the ID just put on merge list
        IF(KBIN(K,KBIN(K,0)) <= IDS(ITOT)) KBIN(K,0) = KBIN(K,0)+1 ! Shd always be =
      END DO
      IF(IDS(ITOT) < LXID) GOTO 30
CC      IF(IDS(ITOT)==IDS(ITOT-1)) ITOT = ITOT-1  ! Surely not needed
      END SUBROUTINE
C
      SUBROUTINE LAST(L,WORD,M)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as L. If the string is empty, LAST is returned as 0.
C **** In this modification, negative M waives left-justification.
      CHARACTER WORD*(*)
      IF(M>=0) WORD(:M) = ADJUSTL(WORD(:M))
      L = LEN_TRIM(WORD(:ABS(M)))
      END SUBROUTINE
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
      LOGICAL PRM, QY
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP
      CHARACTER E   ! <<<  Special characters as needed
      WD = GET
      CALL LAST(M,WD,40)
      LL = 1
5     LL = LL+1; IF(LL<M) GOTO 5
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>.0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(WORD(:1)==' ' .OR. WORD(:1)=='.') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
C       Filter out lines other than filenames
      CALL LAST(L,WORD,14)
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
      J = ICHAR(WORD(11:11));  IF(J<48 .OR. J>57) GOTO 10
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4) .AND. NAME(I)(L+5:L+5)==' ')
     +    GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>.0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NL)
      IF(NL>.0) WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      CALL LAST(L1,NAM1,LEN(NAM1)); CALL LAST(L2,NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      CALL LAST(L1,WRD1,LEN(WRD1)); CALL LAST(L2,WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A number terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION
C
      SUBROUTINE NAME1(F1,F2,M,L)
C This receives a filename in F1 (presumed to start in position 1), solves
C for <base> to be the part of F1 prior to '.' up to M characters, scans the
C subdirectory for the lowest i=1,2,...,99 such that file <base>.Di does not
C already exist, returns <base>.Di in F1(:12), <base>.LOG in F2, and the end
C position of the latter in L.
      LOGICAL QY
      CHARACTER F1*(*), F2*(*), DIGIT
      DIGIT(I) = CHAR(48+I)
      L = 0
10    L = L+1
      IF(L<=M .AND. F1(L:L)/=' ' .AND. F1(L:L)/='.') GOTO 10
      DO I = L+2,12
        F1(I:I) = ' '
      END DO
      F2 = F1
      F1(L:L+1) = '.D'
      F2(L:L+3) = '.LOG'
      L = L+2
      I = 0
20    I = I+1
      IF(I<=9) F1(L:L) = DIGIT(I)
      IF(I>9) F1(L:L+1) = DIGIT(I/10)//DIGIT(MOD(I,10))
      INQUIRE(FILE=F1,EXIST=QY)
      IF(QY .AND. I<99) GOTO 20
      IF(QY .AND. I==99) F1(L:L+1) = DIGIT(0)//DIGIT(0)
      L = L+1
      END SUBROUTINE
C
      SUBROUTINE PARS(K,L,IDENT,IDEN2,MVV)
C Get structure of variables' names over item range K to L
      CHARACTER(8) IDENT(MVV)
      INTEGER IDEN2(2,MVV)
      LP: DO I = K,L
        IDEN2(2,I) = 0
        KFLG = 0
        DO J = 1,8
          N = ICHAR(IDENT(I)(J:J))
          IF(N<48 .OR. N>57) THEN
            IF(KFLG>0) CYCLE LP  ! Number prior to present non-numeric char
            IDEN2(1,I) = J   ! Records end of initial non-numeric string
          ELSE
            KFLG = 1
            IDEN2(2,I) = 10*IDEN2(2,I)+N-48  ! Records terminal number
          END IF
        END DO
      END DO LP
      END SUBROUTINE
C
      SUBROUTINE POSITN(K,CH2)
C This positions file K at its 1st line with ":" after position named in CH2
      CHARACTER CH*12, CH2*2
      READ(CH2,*) M
      M = M+1     ! Position in line after end of largest ID
      REWIND K
10    READ(K,'(A)',END=30) CH
      IF(CH(M:M)/=':') GOTO 10
      BACKSPACE K
      IF(CH(M:M)==':') RETURN
30    WRITE(6,'(/" Error: Cannot position input file",I3," at data ",
     +  "start.")')
      END SUBROUTINE
C
      SUBROUTINE SEENAM(LM,NX,PIK,IDENT,NW,LS,KF)
C This writes to file KF the NX names picked from IDENT by selector list PIK.
C LM is max namelength.  LS is number of lines to leave at top of screen.
C NW is max number of chars allowed in line.
      CHARACTER*8 IDENT(*), FMT*30, CH3*3
      INTEGER PIK(*)
      LM = 3
      DO I = 1,NX
        CALL LAST(N,IDENT(PIK(I)),8); LM = MAX(LM,N)
      END DO
      LL = NW/(6+LM)   ! Number of fields per line
      LB = (23-LS)*LL       ! Number of fields in 23-LS lines
      NS = MIN(1,MOD(NW,6+LM)/2)  ! Number of spaces starting display line
      NK = 0
      CH3 = CHAR(48+NS)//CHAR(48+LL/10)//CHAR(48+MOD(LL,10))
      FMT = '(80('//CH3(1:1)//'X,'//CH3(2:3)//'(I4,": ",A),:/))'
20    WRITE(KF,FMT) (I,IDENT(PIK(I))(:LM),I=NK+1,NK+MIN(LB,NX-NK))
      IF(1+(NX-NK)/LL<=18) RETURN   ! Number of lines needed to finish
      IF(KF==6) WRITE(6,'(" Hit RETURN to continue")')
      IF(KF==6) READ(5,'(A1)')
      NK = NK+LB
      LB = 23*LL  ! Hereafter use full screen
      IF(NK>=NX) RETURN
      GOTO 20
      END SUBROUTINE
C
      SUBROUTINE SKIP(KF,L)
C Advance file KF ahead L lines
      IF(L==0) RETURN
      DO I = 1,L
        READ(KF,'()')
      END DO
      END SUBROUTINE
C
      SUBROUTINE SCANC(NL,NS,SEQ,KFILE,CH,KK)
C This reads a string in I/O unit KFILE, cleans it for list-directed reading
C of the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.)  NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number string
C returned in File 2 is non-null but does not match SEQ, and gives the total
C count of numbers in the returned string otherwise.  WA and WB are workspaces.
C ***** If SEQ is "B", NL returns 0 if the input line is blank, and
C       returns -1 otherwise.
C ***** In original SCANB, CH returns the input string's first unbroken sequence
C       up to ABS(KK) terms while deleting any numbers in this if KK < 0.
C ##### In this augmentation, KFILE  0 calls CH to return the initial letter
C       string in KFILE while KK returns its length.  If KFILE < 0, CH is
C       read as an input string while KK is length of its alphabetic start.
ccc             Line ##### info was true of old HYDATA
c Cases: (1) Ordinary read from KFILE, but fill CH with start of input and
c              return length of alphabetic start in KK ( KFILE > 0 )
c        (2) Read CH as input, continue as in Case 1 ( KFILE < 0 )
c        (3) Read KFILE, move 1st KK chars (with deletion at source) to
c              output CH ( KFILE > 0, negative input KK; only in RESCORE )
C WARNING: KK must be a variable in Cases 1,2.  Case 3 occurs only in RESCORE

      CHARACTER AA, SEQ*(*), CH*(*), WA*170, WB*171
      LCH = LEN(CH); LA = LEN(WA)
      IF(KFILE>=0) THEN
        READ(KFILE,'(A)') WA
        CALL LAST(NL,WA,LA); N = MIN(LCH,LA)
        CH(:N) = WA(:N)
      ELSE
        CALL LAST(NL,CH,LCH) ! $$$$$$$$ Also in RESCORE2, MERGE2, SELECT2
        IF(NL>0) WA(:NL) = CH
      END IF
      IF(NL==0) GOTO 70
      IF(SEQ(1:1)=='B') NL = -1         !  Original SCAN
      IF(SEQ(1:1)=='B') GOTO 70         !     "       "
      IF(KK<0) THEN   ! Case 3    *** Doesn't occur in HYDATA
        DO I = 1,ABS(KK)
          CH(I:I) = WA(I:I); WA(I:I) = ' '
        END DO     !  Case 3 now complete except for numbers read
        GOTO 15
      END IF
      KK = 0   ! Cases 1,2: KK gets length of the initial non-numeric sequence
11    N = IACHAR(WA(KK+1:KK+1))
      IF(N>=97) N = N-32    ! Capitalize lowercase letters
      IF(N<35 .OR. N>90 .OR. N>38.AND.N<60) GOTO 15
C   Accept characters in ranges 35-38, 60-90, but watch out for key reassignents
      KK = KK+1
      IF(KK<=LCH) CH(KK:KK) = CHAR(N)
      IF(KK<NL) GOTO 11   ! Last occurrence of KK
15    WB(NL+1:NL+1) = ' '    ! Crashes if LEN(WB)  LEN(WA) and NL=LN
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +    WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
       ELSE IF (WA(I:I) /= '0') THEN
         IP = 0
       END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1   ! Will crash if WB isn't longer than WA
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF(WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) GOTO 70
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     +  "number sequence requested. Try again.")')
      GOTO 70
60    REWIND 2
      WRITE(2,'(A)') WB(:NL)
      NL = NN
70    REWIND 2
      END SUBROUTINE
C
      SUBROUTINE TSCRB(NX,NF,MF,ITOT,ORD,FMT,KF,NV,NP,LST,MVV,NMIS,NUL)
C       ORD(j) is the merged index of jth variable in the raw merged input list.
C       ITOT is total number of different IDs, NF is number of input files.
C       MVV is count+1 of raw-merged score list; NX is count after overwriting.
C       NV(i) is the number of variables in file i; NP(i) the number of vars
C       prior to the file-i block; KF(i) the unit number assigned to file i;
C       LST is the merged list of IDs. NMIS is count of missings in the merge
      LOGICAL QX(MF)
      CHARACTER FMT(0:MF)*35, CF*12
      INTEGER NV(*), NP(*), KF(*), LST(*), NUL(0:*), ORD(*),
     +  KBIN(0:NF,0:MVV)
      OPEN(17,FORM='UNFORMATTED',STATUS='SCRATCH')
      DO K = 1,NF  ! Initialize file bins with 1st record in each
        QX(K) = .FALSE.  ! Query if file is exhausted
        READ(KF(K),FMT(K)) (KBIN(K,J),J=0,NV(K))
      END DO
      NMIS = 0
      DO NR = 1,ITOT  ! Compile and output each merged record
        IF(MOD(K,100)==0) WRITE(6,'(" Merging scores on record ",A)')
     +    CF(:JF(NR))
        NA = LST(NR)
        KBIN(0,0) = NA  ! Start assembly line with ID
        DO I = 1,NX        ! Initialize assembly line with missing-datum flag
          KBIN(0,I) = NUL(0)
        END DO
        DO K = 1,NF  ! Fill KBIN(0,_) with merged output record
          IF(QX(K)) CYCLE
cc          IF(KBIN(K,0)<NA) WRITE(6,'(/" ERROR: BIN record from fi",
cc     +      "le",I2," has lagged behind working output record.")') K
cc          IF(KBIN(K,0)<NA) STOP  ! **** Delete when demonstrated unnecessary
          IF(KBIN(K,0)>NA) CYCLE
          DO I = 1,NV(K)     ! Map scores from input bin into output
            IF(KBIN(K,I)/=NUL(K)) KBIN(0,ORD(NP(K)+I)) = KBIN(K,I)
          END DO
          READ(KF(K),FMT(K),END=37) (KBIN(K,J),J=0,NV(K))
          CYCLE
37        QX(K) = .TRUE.
        END DO
        WRITE(17) (KBIN(0,I),I=0,NX)
        DO I = 1,NX
          IF(KBIN(0,I)==NUL(0)) NMIS = NMIS+1
        END DO
      END DO
      DO K=1,NF
        CLOSE(KF(K))
      END DO
      END SUBROUTINE
C
      SUBROUTINE WAIT
      WRITE(6,'(/" Hit RETURN to continue")')
      READ(5,'()')
      END SUBROUTINE
C
      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12, LST(12)*10
      COMMON /CF/ CF
      DATA LST/'January  7','February 8','March    5','April    5',
     +         'May      3','June     4','July     4','August   6',
     +         'September9','October  7','November 8','December 8'/
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48  ! M gets day of month
      READ(ZZZ(5:6),*) L; K = ICHAR(LST(L)(10:10))-48
      WORD = CF(:JF(M))//' '//LST(L)(:K)//' '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE

