C    >>>>> Uninstalled subroutine XCAN.SUB is in E:\ and C:\HYBL
C
C  Program MODA.  (Source code, FORTRAN-90. Subroutine pack EIGS also needed.)
C
C        Copyright (c) 2002 by W. W. Rozeboom.   All rights reserved.
C
C                   Last revised: 24 March 2005
C
C MODA (for "Multiple-Output Dependency Analysis") receives an NV-by-NV covar-
C iance matrix from input file INMODA or from <base>j.COV, partitions the
C variables into NX input variables (the X-set) vs. NY dependent variables
C (the Y-set), partials X out of Y, and extracts NF common factors from the
C Y-residuals by iterated principal-factoring, Minres, or data-space principal
C components for a stipulated selection of NF.  Solution for each NF is saved
C in unformatted file <base>i.M<NX+NF>. And a record of all results (with some
C default omissions if the Y-set is large) is sent to ASCII file <base>j.SEE.
C
C  NOTES ON INPUT/OUTPUT.
C    DATA SCALING: MODA allows arbitrary scaling of the input covariances,
C  but with two unlikely exceptions norms all to unit variance.  Information
C  on the exceptions is available on-screen at runtime or can be read below
C  circa lines 330-350.
C    OUTPUT VERBOSITY: Printed results are curtailed if the number of variables
C  exceeds KUT, whose default value can be set below as you wish and can in any
C  case be overridden at run-time.  The print is only to two decimals; if you
C  need three, you can make HYBALL divulge that for the pattern.
C    PRINT WIDTH: This is determined by control parameter KP just as in HYBALL.
C  Its default setting gives 132-character lines, but suitable specification in
C  printer-definition file PRINTR will reset it to 80-character lines.
C    I/O FILE NAMING. MODA records unformatted HYBALL-input patterns in one or
C  more files named <base>i.M<n> and ASCII results-file <base>i.SEE, where i is
C  the first digit i = 1,2,..,9,0 for which <base>i.M<n> does not already exist.
C  If the MODA-input file is named <file>.COV, or if the input is an INMODA
C  whose ASCII version is <file>.COV, <head> is <file>.  (When the factors are
C  dataspace components, "M" in the filename extension is replaced by "K".)
C
      LOGICAL QY
      CHARACTER(12) F1,F2,F3, FMA*30, FMT1*42, FMT2*42, CF,
     +  WORD*120, CLN*8, NAME(40), CH2*2
C       NOTE: MODA retrieves IDENT names only from COV-files, never from D-files
      CHARACTER CH, QFMT, C11,C12,C21,C22, BAR,LIN  ! , SLASH
      REAL CNV(2,4)
      CHARACTER, ALLOCATABLE :: IDENT(:)*8
      INTEGER, ALLOCATABLE :: IBUF(:), LB(:), LIST(:), LSTF(:), LSTR(:),
     +                        LU(:), YSET(:)
      REAL, ALLOCATABLE :: CY(:), T(:,:), CS(:,:), A(:,:), OFFL(:),
     +                     RR(:), W(:), W1(:)
      EXTERNAL SCAN
      COMMON NY,ICYC,IMAX,TOL,SE,XE,RVAR,G,IB,JB,TIM,CNV
      COMMON /CF/ CF
      DATA MFAC,MTH,NB/1,2*0/, KODE/99/
      DATA C11,C12,C21,C22,BAR,LIN/'','','','','',''/
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      NMS = 0  ! NMS=0 flags absense of variable names
      EPS = EPSILON(1.)
      LSHO = 3
C      LSHO = MAX(1,KND*3) ! Choose how often to show factoring progress
C      IF(KND>0) THEN  ! Not needed; UNIX compilation no longer supported
C        C11 = '+';C12 = '+';C21 = '+';C22 = '+';BAR = '|';LIN = '-'
C      END IF
      OPEN(2,STATUS='SCRATCH')

C Set default values of iteration limit IMAX, convergence criterion TOL,
C and full-print limit KUT; also select line length of output.
      IMAX = 50; TOL = .001; KUT = 50; KP = 132; KSAY = 1
      CH2 = 's '   !   CH2(1:2) is 's ' ending, CH(2:2) is blank
      CALL SYSTEM('cls')
      CALL PRNT(0,KP,6)
      IF(KP>=100) THEN   ! Line count in FMA shouldn't matter
        FMT1 = '(2X,4(2X,5A5),19(:/4X,4(2X,5A5)))'
        FMT2 = '(2X,4(2X,5A5),19(:/2X,4(2X,5A5)))'
        FMA  = '(99(4X,9(I4,":",A8),:/))'
      ELSE
        FMT1 = '(1X,2(5A5,2X),5A5,19(:/3X,2(5A5,2X),5A5))'
        FMT2 = '(1X,2(5A5,2X),5A5,19(:/1X,2(5A5,2X),5A5))'
        FMA  = '(99(4X,5(I4,":",A8),:/))'
      END IF
C
10    WRITE(6,'(/" The covariance files here available for MODA fac",
     +  "toring are:")')
      CALL LOOK(0,'*.C*',NAME,40,N)
      CALL LOOK(3,'INMOD*',NAME,40,N)
      IF(N==0) WRITE(6,'(/ " No work for MODA here. Go find some",
     +  "thing else to do.")')
      IF(N==0) STOP
      NN = 1
      DO J = N,1,-1
        IF(NAME(J)(:5)=='INMOD') NN = J
      END DO
12    F1 = NAME(NN); CALL LAST(LF1,F1,12)
14    WRITE(6,'(/" The covariance file now set for MODA factoring ",
     +  "is ",A/" Hit RETURN if OK, or enter the index of another ",
     +  "selection from this list."/)') F1(:LF1)
      CALL SCAN(J,1,'I',5)
      IF(J<0) GOTO 14
      IF(J>0) THEN
        READ(2,*) NN
        NN = MAX(1,MIN(NN,N))
        GOTO 12
      END IF
      NAME(1) = '            '
      CH = QFMT(F1)
      IF(CH=='U') THEN   ! Dead code -- shouldn't be possible
        WRITE(6,'(/" File ",A," does not exist in this subdirectory.",
     +    "  Try again.")') F1(:LF1)
        GOTO 10
      ELSE IF(CH=='Y') THEN   ! Formatted input
        F3 = F1                   ! F3 saves the COV-file name
        CALL START(4,F1,K)
        READ(4,*,ERR=17) NV, NVV, KODE, MTH  ! If head is incomplete, read will
17      IF(K<4) THEN                         ! move down 1 or 2 extra lines
          CLOSE(4); CALL START(4,F1,K); READ(4,'()')
          IF(K<4) MTH = 1; IF(K<3) KODE = 999; IF(K<2) NVV = LO(NV,NV)
        END IF
        IF(NVV/=LO(NV,NV)) THEN
          WRITE(6,'(/" >>> This file specifies ",A," variables, but n"
     +    "ot the number of covariances"/5X,"MODA wants for those.  ",
     +    "Hit RETURN to continue as MODA expects, or"/5X,"hit Ctrl-C",
     +    " to check out this file''s peculiarity.")') CF(:JF(NV))
          NVV = LO(NV,NV); READ(5,'()')
        END IF
      ELSE                                ! Unformatted input
        OPEN(4,FILE=F1,FORM='UNFORMATTED')
        READ(4) NV, NVV, KODE, MTH, F3(:1)
        IF(NVV/=NV*(NV+1)/2) GOTO 999
        IF(ICHAR(F3(:1))>=65 .AND. ICHAR(F3(:1))<=122) THEN
          BACKSPACE 4; READ(4) I,I,I,I, F3
          IF(F1(:5)=='INMOD') F1 = F3
        ELSE
          F3 = '????1       '
        END IF
      END IF   ! Only 1st line of input file read so far
      ALLOCATE ( W1(NVV), LB(NV), IDENT(NV) )
      OPEN(19,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(19) (I,I=1,NV)    ! Default
      IF(CH=='Y') THEN   ! Formatted input
        READ(4,*) (W1(I),I=1,NVV)  ! Input covariances
20      READ(4,*,END=21) CH
        IF(CH=='N' .OR. CH=='n') THEN
          READ(4,*,ERR=21,END=21) (IDENT(I),I=1,NV)
          NMS = 1
        ELSE IF(CH=='T') THEN
          BACKSPACE 19
          READ(4,*,ERR=21,END=21) (LB(I),I=1,NV)  ! Recover rawdata indices of COV variables
          BACKSPACE 19
          WRITE(19) (LB(I),I=1,NV)
        ELSE IF(CH=='B') THEN
          READ(4,*,END=21,ERR=21) NB,(LB(I),I=1,NB)
        END IF
        GOTO 20
      ELSE                 ! Unformatted input
        READ(4) (W1(I),I=1,NVV)   ! Input covariances
        READ(4,ERR=21,END=21) (LB(I),I=1,NV)  ! Recover rawdata indices of COV variables
        BACKSPACE 19
        WRITE(19) (LB(I),I=1,NV)
        READ(4,END=21,ERR=21) NB, (LB(I),I=1,NB)
      END IF

CCCC HYDATA output to file INMODA
CCC      OPEN(7,FILE='INMODA',FORM='UNFORMATTED')
CCC      WRITE(7) NV, NVV, KODE, MTH, F2, F1
CCCC       F2: Name of corresponding COV-file.  F1: Source datafile
CCC      WRITE(7) (SNGL(COV(I)),I=1,NVV)
CCC      WRITE(7) (PIK(I),I=1,NV)  ! Indices of variables in F1
CCC      WRITE(7) NB, (CF(:JF(PIK1(I))),I=1,NB)  ! List of binary items
CCC      CLOSE(7)

21    CLOSE(4)     ! ***** LU larger than 2*NV doesn't seem needed
      ALLOCATE ( IBUF(NV), LIST(2*NV), LSTF(NV), LSTR(NV), LU(2*NV),
     +           YSET(2*NV) )  ! Need LIST,YSET indefinitely larger than NV
      ALLOCATE ( CS(NV,NV+2), RR(NV), OFFL(NV), W(NVV) )
      KODE = MOD(KODE,1000000)
      IBUF = (/(I,I=1,NV)/)
      WRITE(6,'(/" You are about to factor the covariances among ",A,
     +  " variables in file No. ",A)') CF(:JF(NV)), CF(:JF(KODE))
C If needed, enter head for output files
      IF(F3==F1) GOTO 25
      IF(F3(:4)/='????') THEN
        WRITE(6,'(" The source name of this file is ",A)') F3
        GOTO 25
      END IF
      WRITE(6,'(/" The source name of this covariance file is unava",
     +  "ilable. So you must choose"/" a headname <head> for this ",
     +  "for this run''s output files.")')
      L = 6
23    WRITE(6,'(/" <head> is now ",A," Hit RETURN if OK, or enter ",
     +  "preferred filehead."/)') F3(:L-2)
      READ(5,'(A80)') WORD
      IF(WORD(1:20)=='                    ') GOTO 25
      CALL LAST(L,WORD,80)
      L = MIN(6,L)
      F3 = WORD(:L)//'1.'//'          '
      L = L+2
      CALL CAP(F3,L)
      GOTO 23
C
C     F1 is the input filename, F3 is the source COV-file; ordinarily, F3=F1
25    CALL NAME1(F1,7,'SEE',LF)  ! F1 becomes name of SEE-file; length is LF
      F2 = F1(:LF-3)//'M* ' ! F` gets outputs for HYBALL
      CALL LAST(LF3,F3,12)
      IF(NMS>0) GOTO 36
      IF(QFMT(F3)=='Y') THEN
        WORD(:LF) = F3(:LF)
        LN = LF-1
        GOTO 34
      END IF
      WORD(:12) = '            '
      WRITE(6,'(8X,63A)') C11, (LIN,I=1,61), C12
      WRITE(6,'(8X,A," WARNING. File ",A," containing names of the v",
     +  "ariables",2A/8X,A," has not been copied to this subdirector",
     +  "y. To read it, enter",1X,A/8X,A," the full subdirectory na",
     +  "me (with leading but not trailing   ",A/8X,A," path-slash,",
     +  " and drive letter if needed) which contains this.",A/8X,A,
     +  " Otherwise, hit RETURN to continue without variable names.",
     +  3X,A)') BAR, F3(:LF3), WORD(:12-LF3), (BAR,I=1,9)
      WRITE(6,'(8X,63A//)') C21, (LIN,I=1,61), C22
26    READ(5,'(A)') WORD(:40)
      CALL LAST(L,WORD,40)
      IF(L==0) F3 = '            '
      IF(L==0) GOTO 36
      CALL CAP(WORD,L)
      LN = L+LF  ! LF is local namelength maybe plus 1
      WORD(L+1:LN) = '\'//F3(:LF)
      IF(QFMT(WORD(:LN))/='Y') THEN
        WRITE(6,'(" File ",A," has eluded detection. The variables ",
     +    "remain nameless.")') WORD(:LN)
        LN = 0
        WRITE(6,'(" Hit RETURN to continue, or enter another path ",
     +    "head to try again."/)')
        GOTO 26
      END IF
34    OPEN(9,FILE=WORD(:LN))
      READ(9,*,ERR=36,END=36) (CH,I=1,6), NAME(1)    ! Rawdata filename
35    READ(9,'(A)',END=36) CH
      IF(CH=='N') THEN
        READ(9,*,ERR=36,END=36) (IDENT(I),I=1,NV)
        NMS = 1
      ELSE IF(CH=='T') THEN
        READ(9,*,ERR=36,END=36) (LU(I),I=1,NV)  ! Recover rawdata indices of COV variables
        BACKSPACE 19
        WRITE(19) (LU(I),I=1,NV)
      ELSE IF(CH=='B') THEN
        READ(9,*,ERR=36,END=36) NB,(LB(I),I=1,NB)
        GOTO 36
      END IF
      GOTO 35
36    IF(NMS==0) THEN
        WRITE(6,'(" Names for the input variables are unavailable.")')
        DO I = 1,NV
          IDENT(I) = '['//CF(:JF(I))//']     '
        END DO
      ELSE
        WRITE(6,'(/" The input variables are named")'); LW = 5
        CALL SEENAM(NV,IDENT,IBUF,LM,1,LW,6)
        FMA(18:18) = CF(:JF(LM))
      END IF
      CLOSE(9)  ! Scratchfile 9 now free for later unformatted reopen

C  Check standardization of variances
      S = W1(1); V = 0.;   G = 0.;          N = 1
C     ^Smallest; ^Largest; ^Second largest; ^Number equal to largest
      DO I = 1,NV
        RR(I) = W1(LO(I,I))
        IF(RR(I)>V+.001) THEN
          G = V; V = RR(I); N = 1
        ELSE IF(RR(I)>V-.001) THEN
          N = N+1
        ELSE
          G = MAX(G,RR(I))
        END IF
        S = MIN(S,RR(I))
      END DO
      IF(ABS(V-1.)>.001) THEN
        DO I = 1,NVV
          W1(I) = W1(I)/V    ! Global norming to max variance = 1.0
        END DO
      END IF
      NOFF = NB; M = 0
      OUTER:DO I = 1,NV   ! Same label in two separate DOs seems OK
        IF(W1(LO(I,I))>=.995) CYCLE  ! Count items with nonstandard variance
        Z = SQRT(W1(LO(I,I)))
        DO K = 1,NB
          IF(LB(K)==I) THEN  ! Item is binary so put Z in 1st part of OFFL
            OFFL(K) = Z; M = M+1; CYCLE OUTER  ! M checks input binary count
          END IF
        END DO
        NOFF = NOFF+1; LB(NOFF) = I; OFFL(NOFF) = Z  ! Item is not binary
      ENDDO OUTER
      IF(M<NB) THEN   ! ******* Extension of F1 has been changed to SEE
        WRITE(6,'(/" >>>>> Error: Not all variables listed in ",A,
     +    " as binary have off-norm"/7X,"variances.  Resolve the ",
     +    "inconsistency and try again.")') NAME(NN)(:LF1); STOP
      END IF
      IF(NOFF==0) GOTO 50  ! NB/NOFF: Count of items received binary/off-norm
      G = G/V; S = S/V
      WRITE(6,'(/" WARNING. These variables are not uniformly standar",
     +  "dized:  After rescaling"/10X,"by a global multiplier that ma",
     +  "kes the ",A," largest variance",A,"unity,")') CF(:JF(N)),
     +  CH2(3-MIN(2,N):2)
      IF(NOFF==1) WRITE(6,'(10X,"the remaining variance is ",A4,".")')
     +  CLN(G,4,3)
      IF(NOFF>1) WRITE(6,'(10X,"the other ",A," range from ",A4," do",
     +  "wn to ",A4,".")') CF(:JF(NOFF)), CLN(G,4,3), CLN(S,4,3)
44    WRITE(6,'(/3X,"Hit RETURN to standardize (unit-variance rescal",
     +  "ing) all variables on this"/3X,"run.  Otherwise, enter anyth",
     +  "ing to consider leaving some items off-norm.")')
      IF(NB>0) WRITE(6,'(3X,"(Either way, you can opt later for bina",
     +  "ry scaling of X-set dichotomies.)")')
      CALL SCAN(J,0,'B',5); IF(J/=0) GOTO 48
      DO I = 1,NOFF ! Normalize off-norm items including binaries
        K = LB(I); S = SQRT(W1(LO(K,K))); W1(LO(K,K)) = 1.0
        DO J = 1,NV
          IF(J/=K) W1(LOC(J,K)) = W1(LOC(J,K))/S
        END DO
      END DO
      OPEN(10,STATUS='SCRATCH') ! Buffer for later write to SEE-file
      WRITE(10,'(" All ",A," data variables received with off-norm var",
     +    "iances have been standardized")') CF(:JF(NOFF))
      NOFF = -NOFF; GOTO 50

48    WRITE(6,'(3X,"If you need clarification of MODA''s limited t",
     +  "olerance for off-norm"/3X,"item scales, enter anything.  ",
     +  "Otherwise, hit RETURN to move on.")')
      CALL SCAN(JJ,0,'B',5); IF(JJ==0) GOTO 49

C  Hyball factoring accepts off-norm items (SDs less than unity) of two kinds:
C    1) When a dichotomous data variable scored 0/1 (binary scaling) is
C       treated as manifest input (X-set item), it is standardized during
C       internal processing but retains binary scaling as an output option
C       for the factor aligned with it.  (Choice of binary vs. unit-norm
C       scaling for an X-set factor affects only the size of pattern
C       coefficients and factor covariances reported for this.)  Otherwise,
C       received binaries are standardized irretrievably.
C    2) MODA allows the variances of standard-norm (unit variance) data
C       variables to be replaced by externally estimated reliabilities, and
C       takes such reduced variances to be initial communality estimates.
C       This has no point except for items treated as manifest inputs
C       degraded by measurement error.  Factor solutions in which these are
C       assigned to the X-set replace them by their estimated true-score
C       components defining normalized X-set factors on which these items'
C       respective loadings equal their posited reliability indices.
C  Apart from these cases, MODA standardizes all variables received off-norm.
C  NOTE: All off-norm X-set variances are treated as reliabilities (Case 2).

      WRITE(6,'(" Hyball factoring accepts off-norm items (SDs less t",
     +  "han unity) of two kinds:"//4X,"1) When a dichotomous data va",
     +  "riable scored 0/1 (binary scaling) is"/7X,"treated as manife",
     +  "st input (X-set item), it is standardized during"/7X,"intern",
     +  "al processing but retains binary scaling as an output option"/
     +  7X,"for the factor aligned with it.  (Choice of binary vs. un",
     +  "it-norm"/7X,"scaling for an X-set factor affects only the si",
     +  "ze of pattern"/7X,"coefficients and factor covariances repor",
     +  "ted for this.)  Otherwise,"/7X,"received binaries are standa",
     +  "rdized irretrievably.")')
      WRITE(6,'(4X,"2) MODA allows the variances of standard-norm (un",
     +  "it-variance) data"/7X,"variables to be replaced by external",
     +  "ly estimated reliabilities, and"/7X,"takes such reduced var",
     +  "iances to be initial communality estimates."/7X,"This has n",
     +  "o point except for items treated as manifest inputs"/7X,
     +  "degraded by measurement error.  Factor solutions in which ",
     +  "these are"/7X,"assigned to the X-set replace them by their ",
     +  "estimated true-score"/7X,"components defining normalized X-",
     +  "set factors on which these items''"/7X,"respective loadings",
     +  " equal their posited reliability indices."/)')
      WRITE(6,'("  Apart from these cases, MODA standardizes all var",
     +  "iables received off-norm."/"  But all off-norm X-set varian",
     +  "ces are treated as Case 2 reliabilities."/)'); CALL WAIT(0)
49    OPEN(10,STATUS='SCRATCH') ! Buffer for later write to SEE-file
      DO KF = 6,10,4
        IF(KF==6 .AND. JJ/=0) CYCLE; IF(KF==10) WRITE(10,'()')
        WRITE(KF,'(" Variables received with off-norm variances:")')
        CALL SEENAM(NOFF,IDENT,LB,LM,0,50,KF)  ! Not screen write, so J doesn't matter
        IF(NB==NOFF) WRITE(KF,'(" All of these are binary.")')
        IF(NB<NOFF) THEN
          IF(NB==1) WRITE(KF,'(" The first of these is binary.")')
          IF(NB>1) WRITE(KF,'(" The first ",A," of these are bin",
     +      "ary.")') CF(:JF(NB))
        END IF
        IF(KF==6) CALL WAIT(0)
      END DO
      DO I = 1,NB  ! Normalize binaries
        K = LB(I); S = SQRT(W1(LO(K,K))); W1(LO(K,K)) = 1.0
        DO J = 1,NV
          IF(J/=K) W1(LOC(J,K)) = W1(LOC(J,K))/S
        END DO
      END DO
C
50    NZ1 = -1; NX1 = -1; LW = 10
      WRITE(6,'(/1X,77A)') C11, (LIN,I=1,75), C12
      WRITE(6,'(1X,A,23X,"Choose items to be excluded",25X,A)')
     +  BAR, BAR
      WRITE(6,'(1X,77A)') C21, (LIN,I=1,75), C22
      WRITE(6,'(/" If ALL the variables are to be analyzed on this ru",
     +  "n, hit RETURN.  Otherwise"/" enter indices of items to be EX",
     +  "CLUDED, or any letter to see instructions"/" on how to list ",
     +  "exclusions efficiently."/)')
      CALL GETLST(NZ1,LIST,J,NV,YSET,0,LB)
      IF(J>0) GOTO 100
      IF(J==0) NZ1 = 0
      IF(J==0) GOTO 110
      WRITE(6,'(/" Enter INDICES (not names) of some or all items to ",
     +  "be excluded. (Your entry"/" method may require more than one",
     +  " line.)  Entry of EXACTLY TWO indices N1,N2"/" folllowed by R",
     +  "ETURN will be read as the sequence from N1 to N2.  Any other"/
     +  " string of integers will be read as just the indices listed. ",
     +  "(To enter a pair"/" with this interval interpretaion disabled",
     +  ", repeat one.  If you have a"/" consecutive block comprising "
     +  "items to be excluded within which X-set"/" items are scatter",
     +  "ed, you can enter the entire block as exclusions and"/" then",
     +  " retrieve wanted X-items when you declare the X-set.)"/)')
      IF(NZ1<0) GOTO 102  ! NZ1<0 if no entries have been made
100   IF(NZ1<=0) WRITE(6,'(/" The declared list of variables to be",
     +  " omitted is now empty.")')
      IF(NZ1>0) WRITE(6,'(/" The variables declared for omission ",
     +  "are now")')
      IF(NZ1>0) CALL SEENAM(NZ1,IDENT,LIST,LM,1,LW,6)
102   CALL GETLST(NZ1,LIST,J,NV,YSET,0,LB)
C      IF (J==-1) is returned, NZ1 = -1
      IF(J==-1) GOTO 50   ! Start again
      IF(J/=0) GOTO 100   ! Display enhanced omissions list
      NZ1 = MAX(0,NZ1)
      LP1:DO I = 1,NB   ! Vacuous loop if NB = 0
        DO J = 1,LIST(NZ1)  ! Check if binary item is on Z-list already
          IF(LB(I)==LIST(J)) CYCLE LP1
        END DO
        NZ1 = NZ1+1         ! Binaries are omitted unless explicitly
        LIST(NZ1) = LB(I)   ! selected for X-set
      END DO LP1
      DO I = 1,NX1  ! On review, IBUF contains X-set list
        LIST(NZ1+I) = IBUF(I)
      END DO
C
110   IF(NX1>=0) GOTO 114
      WRITE(6,'(/1X,77A)') C11, (LIN,I=1,75), C12
      WRITE(6,'(1X,A,26X,"Choose X-set variables",27X,A)') BAR, BAR
      WRITE(6,'(1X,77A)') C21, (LIN,I=1,75), C22
      WRITE(6,'(/" Hit RETURN if there are no INDEPENDENT variables",
     +  " (the X-set). Otherwise,")')
      WRITE(6,'(" enter some or all INDICES (not names) of your X-set.",
     +  " Entry of EXACTLY TWO"/" indices N1,N2 followed by RETURN wil",
     +  "l be read as the sequence from N1 to N2."/" Any other line o",
     +  "f integers (duplicates permitted to change the count) will")')
      IF(NB==0) WRITE(6,'(" be read as just the usable indices liste",
     +  "d.  Alternatively, to see the"/" variables'' names again, ",
     +  "enter any letter."/)')
      IF(NB>0) WRITE(6,'(" be read as just the usable indices ",
     +  "listed.  To install all your binaries in"/" the X-set with",
     +  "out listing them individually, include  0  in your entry."/
     +  " Alternatively, to see the variables'' names again, enter ",
     +  "any letter."/)')
      GOTO 111
114   IF(NX1>0) WRITE(6,'(/" The list of X-set variables is now")')
      IF(NX1>0) CALL SEENAM(NX1,IDENT,LIST(NZ1+1),LM,1,LW,6)
      IF(NX1==0) WRITE(6,'(/" The list of X-set variables is now",
     + " empty.")')
111   CALL GETLST(NX1,LIST(NZ1+1),J,NV,YSET,NB,LB)
      IF(J==-1) THEN
        IF(NX1<0) WRITE(6,'(/" The input variables are named")')
        IF(NX1<0) CALL SEENAM(NV,IDENT,IBUF,LM,1,17,6)
        NX1 = -1
        GOTO 110
      END IF
      IF(J/=0) GOTO 114
      NX1 = MAX(0,NX1)
C
C Set up X-set and Y-set
115   NX = 0; NY = 0
      NZX = NZ1+NX1; NL = 0; NZ0 = NZ1
      DO I = 1,NV  ! Put item into Y-set if not already assigned
        IX = 0; IZ = 0
        DO N = 1,NZX
          IF(LIST(N)/=I) CYCLE
          IF(N<=NZ0) IZ = N  ! Item I is in Z list
          IF(N>NZ0) IX = N  ! Item I is in X list
        END DO
        IF(IX>0) NX = NX+1
        IF(IX>0) IBUF(NX) = I  ! Temp listing of X-set
        IF(IX+IZ==0) NY = NY+1
        IF(IX+IZ==0) YSET(NY) = I
        IF(IX*IZ==0) CYCLE  ! If IX*IZ > 0, item is both X and Z listed
        LIST(IZ) = 0  ! Delete from Omit list
        NZ1 = 0       ! Old NZ1 saved in NZ0
        NL = NL+1   ! Record items declared both Omit and X-set
        LSTR(NL) = I
      END DO
      IF(NZ1==0 .AND. NZ0>0) THEN  ! Squeeze out zeroed LIST items
        DO I = 1,NZ0
          IF(LIST(I)>0) THEN
            NZ1 = NZ1+1; LIST(NZ1) = LIST(I)
          END IF
        END DO
        DO I = 1,NX1
          LIST(NZ1+I) = LIST(NZ0+I)
        END DO
      END IF
      DO I = 1,NX
        YSET(NY+I) = IBUF(I)   ! XSET is now listed in YSET(NY+_)
      END DO
      IF(NL>0) WRITE(6,'(" Items whose X-set declaration will ",
     +  "overrride their omissions listing:",4(/20(1X,A):))')
     +  (CF(:JF(LSTR(I))),I=1,NL)    ! Only use of this listing)
      WRITE(6,'(/" If you want to review the omissions and X-set ",
     +  "lists, enter anything."/" Otherwise, hit RETURN.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) GOTO 100
C
C Generate 2-digit random variant-code to distinguish choices of X-set and Omits.
      KOD1 = MIN(98,INT(100*RANDY()))
C
C Sort input covars W into X-covars CX, Y-covars CY, and between-Y/X covars CS.
      NYY = LO(NY,NY); NY1 = NY+1; NEGCOV = 0
      ALLOCATE ( CY(NYY) )
      DO J = 1,NY
        DO I = 1,J
          CY(LO(I,J)) = W1(LO(YSET(I),YSET(J)))
        END DO
      END DO
      IF(NOFF>0) THEN   ! Standardize Y-set variances
        DO J = 1,NY
          S = SQRT(CY(LO(J,J)))
          DO I = 1,NY
            IF(I/=J) CY(LOC(I,J)) = CY(LOC(I,J))/S
          END DO
          CY(LO(J,J)) = 1.
        END DO
      END IF

C If NX>0, get regression of Y-set on X-set and the Y-residual covariances
      IF(NX==0) GOTO 121
      DO J = 1,NX
        DO I = 1,NY
          CS(I,J) = W1(LOC(YSET(I),YSET(NY+J)))
        END DO
        K = YSET(NY+J)  ! K is input index of Jth X-set item
        DO I = 1,J
          W(LO(I,J)) = W1(LO(YSET(NY+I),K))  ! X-set covariances
        END DO
      END DO
C   List off-norm X-set indices with SDs in OFFL; first NBX binaries followed by NOX flagged non-binary
      NBX = 0; NOX = 0
      DO I = 1,NOFF
        DO J = 1,NX
          IF(YSET(NY+J)==LB(I)) THEN
            IF(I<=NB) THEN
              NBX = NBX+1; OFFL(NBX) = J+OFFL(I)
            ELSE   ! Flag non-binaries with minus flag
              NOX = NOX+1; OFFL(NBX+NOX) = -(J+OFFL(I))
            END IF
          END IF
        END DO
      END DO
      NBO = NBX+NOX
      IF(NOX>0) THEN
        WRITE(6,'(" WARNING: Your X-set contains ",A," items with off",
     +    "-norm variances.  If all"/10X,"these are estimated reliabil",
     +    "ities, enter anything to continue."/10X,"Otherwise, hit RE",
     +    "TURN to reconsider your treatment of these.")') CF(:JF(NOX))
        CALL SCAN(J,0,'B',5)
        IF(J==0) GOTO 44
      END IF
      DO K = 1,NOX  ! Adjust covars of NOX nonbinary off-norm X-items
        Z = ABS(OFFL(NBX+K)); J = INT(Z); S = Z-J  ! S is SD of item J
        DO I = 1,NY
          CS(I,J) = CS(I,J)/S
        END DO
        DO I = 1,NX
          W(LOC(I,J)) = W(LOC(I,J))/S
        END DO
        W(LO(J,J)) = 1.  ! Rem: J is taken from Z
      END DO ! Nonbinary off-norm items are now standardized (unit variancae)
      NXX = LO(NX,NX)
      OPEN(18,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(18) (W(I),I=1,NXX) ! X-covars will be retrieved at output time
C  Compute the regression of YSET on XSET.  (Note: SEE-file 7 not yet opened)
      CALL EIGS(NX,0,W,NXX,W,T,0,NX,IER,6)   ! JOB=NX calls Ginv(W)
      IF(IER<0) WRITE(6,'(/" This X-set contains a linear dependency:",
     +  " Its regression weights are not unique."/)')
      IF(IER>0) WRITE(6,'(/" Unable to compute the regression for ",
     +  "this X-set. Try another selection."/)')
      IF(IER>0) GOTO 110
      AVAR = 0.
      ALLOCATE ( A(NY,NX) )
      BIG: DO J = 1,NY
        LP21: DO I = 1,J
          S = 0.
          LP22: DO N = 1,NX
            R = 0.
            LP23: DO K = 1,NX
              TIJ = CS(I,K)*W(LOC(K,N))
              IF(J==I) R = R + TIJ  ! Accumulating B-coeff
              S = S + TIJ*CS(J,N)     ! Accumulating accounted-for variance
            END DO LP23
            IF(I==J) A(I,N) = R
          END DO LP22
          IF(I==J) CS(I,NY1) = S
          IF(I==J) AVAR = AVAR+S
          CY(LO(I,J)) = CY(LO(I,J)) - S
        END DO LP21
      END DO BIG
C       The regression coeffs for Y upon X are momentarily stored in A(_,_).
C       Individual Y-variances accounted for by X are in CS(_,NY1).  The X-covs
C       are saved in scratchfile 18.  And the residual Y-covariances are in CY.
      OPEN(9,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(9) ((A(I,J),I=1,NY),J=1,NX)  ! Some rows of A may later need reflection
121   DO J = 1,NY
        DO I = 1,J
          CS(I,J) = CY(LO(I,J))  ! Used by 1st EIGS call but not destroyed there
          IF(CS(I,J)<.0) NEGCOV = NEGCOV+1
        END DO
      END DO ! IBUF returns KRF indices in Y-set of reflected items
      CALL REFL(NY,CY,LSTR,LSTF,W,NEGCOV,KRF) ! LSTR returns +/-1 reflect flags

CC TEST LINES : LSTF is JSGN in subroutine REFL
C      WRITE(6,'(" Back from REFL, list is ",20I3)') (LSTF(I),I=1,KRF)
C      PAUSE

C Put initial info into formatted file <head>.SEE
      OPEN(7,FILE=F1)
      CALL PRNT(1,KP,7)
      WORD(:12) = F3
      DO J = 2,6
        CH = F1(J:J)
        IF(CH=='('.OR.CH==')') WORD(:12) = F1(:J+2)//'.COV'//'    '
      END DO
      WRITE(7,'(" Multiple-Output Dependency Analysis of the covaria",
     +  "nces with Code No. ",A," for ",A," variables in file ",A)')
     +  CF(:JF(KODE)), CF(:JF(NV)), WORD(:12)
      CALL DAY(7)
      IF(NMS==0) WRITE(7,'(/" Names for the input variables are ",
     +  "unavailable.")')
      IF(NMS==0) GOTO 54
      IBUF = (/(I,I=1,NV)/)   ! $$$$$$ Can't overwrite IBUF yet
      WRITE(7,'(/" The received variables are named")')
      CALL SEENAM(NV,IDENT,IBUF,LM,1,J,7)

c test


      INQUIRE(10,EXIST=QY); IF(.NOT.QY) GOTO 54
      REWIND 10
98    READ(10,'(A)',END=54) WORD; L = LEN_TRIM(WORD)
      WRITE(7,'(A)') WORD(:L); GOTO 98
54    CLOSE(10)
      IF(NY<=KUT) GOTO 55
      IF(NY>=2*KUT) GOTO 56
      WRITE(6,'(/" Due to the Y-set''s size, factor patterns and covar",
     +  "iances are not set for"/" display in ",A,".  Hit RETURN to ap",
     +  "prove; otherwise enter anything"/" to see it all.")') F1(:LF)
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 55
      KUT = NV
      WRITE(6,'(/I4," variables are going to produce a big SEE-file.",
     +  "  If you print"/" that, first edit out the material you do",
     +  "n''t really need.")') NY
55    IF(NV<=KUT) THEN
        IF(NOFF>0) WRITE(7,'(/" The globally normed data covariances, r"
     +    "eceived with ",A," variables off-norm, are")') CF(:JF(NOFF))
        IF(NOFF==0) WRITE(7,'(/" The received data correlations are")')
        IF(NOFF<0) WRITE(7,'(/" The data correlations, received with ",
     +    A," variables off-norm, are")') CF(:JF(-NOFF))
        DO J = 1,NV
          WRITE(7,'(I4,".",4(2X,5A5),20(:/6X,4(2X,5A5)))') J,
     +      (CLN(W1(LO(I,J)),5,2),I=1,J)
          IF(MOD(J,10)==0 .AND. J<NV) WRITE(7,'()')
        END DO
      END IF
56    IF(NZ1>0) WRITE(7,'(/" Variables omitted from this run:")')
      IF(NZ1>0) CALL SEENAM(NZ1,IDENT,LIST,LM,1,LW,7)
      IF(NX==0) WRITE(7,'(/" Variables taken to be inputs (X-set):",
     +  " None")')
      IF(NX>0) THEN
        WRITE(7,'(/" Variables taken to be inputs (X-set), with ind",
     +    "exing in the X-set:")')
        WRITE(7,FMA) (I,IDENT(YSET(NY+I)),I=1,NX)
        IF(IER<0) WRITE(6,'(/" NOTE: This X-set contains a linear de",
     +    "pendency. Its regression weights are not unique."/)')
      END IF
      IF(NY==NV) WRITE(7,'(/" Variables taken to be dependent mea",
     +  "sures (Y-set): All")')
      IF(NY<NV .AND.NMS/=0 ) THEN
        WRITE(7,'(/1X,A," variables taken to be dependent measures",
     +    " (Y-set), with their new indices:")') CF(:JF(NY))
        WRITE(7,FMA) (I,IDENT(YSET(I)),I=1,NY)
      ELSE IF(NY<NV .AND.NMS==0 ) THEN
        WRITE(7,'(/" Old indices of the ",A," variables taken to be",
     +    " dependent measures (Y-set):")') CF(:JF(NY))
        WRITE(7,'(50(20(I4,:)/))') (YSET(I),I=1,NY)
      END IF
      WRITE(7,'(/" This X-set/Y-set selection has been assigned pro",
     +  "visional variant code No. ",A)') CF(:JF(KOD1))
      IF(KRF>0) THEN
        MM = MIN(2,KRF)
        WORD(:9) = ' has have'
        WRITE(7,'(/" In the following extraction patterns and resid",
     +    "uals, ",A," Y-set variable",A," been reflected.")')
     +   CF(:JF(KRF)), WORD(3*MM-2:5*MM-1)

CC TEST LINES
C      WRITE(6,'(/" Line 700: KRF =",I3)') KRF
C      WRITE(6,'(" Line 700: refl-list is ",20I3)') (LSTF(I),I=1,KRF)
C      WRITE(6,'(4X,"Start of Y-set is",20I3)') (YSET(I),I=1,KRF); PAUSE


        DO I = 1,KRF                        ! $$$$$$$
          LSTF(I) = YSET(LSTF(I))  ! List original indices of reflected items
        END DO
        IF(NMS>0) WRITE(7,'(" Their names preceded by their indic",
     +    "es in the Y-set are")')
        IF(NMS==0) WRITE(7,'(" Their input indices [in brackets] ",
     +    "preceded by their indices in the Y-set are")')
        CALL SEENAM(KRF,IDENT,LSTF,LM,1,0,7)
      END IF
      IF(NX==0) GOTO 130
      IF(KP>=100) WRITE(7,'(/64(" -"))')
      IF(KP<100) WRITE(7,'(/38(" -"))')
      SCOR = AVAR/NY; J = 0
      IF(NY>KUT .AND. J>2) THEN
        WRITE(6,'(5X,"If you want this run''s SEE-file to include the ",
     +    A," by "A," table"/5X,"of Y-set regression coefficients on ",
     +    "the X-set, enter anything."/5X,"Otherwise, hit RETURN.")')
     +    CF(:JF(NY)), CF(:JF(NX))
        CALL SCAN(J,0,'B',5)
      END IF
      IF(NY<=KUT .AND. J/=0) THEN
        WRITE(7,'(/" The matrix of regression coefficients for the ",
     +    A," Y-variables upon the ",A," X-variable",A,"is:")')
     +    CF(:JF(NY)), CF(:JF(NX)), CH2(3-MIN(2,NX):2)
        DO I = 1,NY
          IF(MOD(I-1,5)==0) WRITE(7,'()')
          WRITE(7,FMT1) (CLN(A(I,J),5,-2),J=1,NX)
        END DO
      END IF
      DO J = 1,NX
        LU(J) = 0; S = 0.; B = 0.
        DO I = 1,NY
          X = ABS(A(I,J)); S = S + X*X
          IF(X<=B) CYCLE
          LU(J) = I; B = MAX(B,X)
        END DO
        RR(J) = SQRT(MAX(0.,S/NY))
      END DO
      IF(NX==1) THEN
        WRITE(7,'(/" The Y-variables'' RMS regression loading on the",
     +    " X-variable is ",A5,"."/" Largest is ",A5,", for Y-item ",
     +    A)') CLN(RR(1),5,3), CLN(A(LU(1),1),5,3), CF(:JF(LU(1)))
      ELSE IF(NY==1) THEN
        WRITE(7,'(/" The Y-variable''s regression loadings on the ",
     +    A," X-set items are",20(:/3(2X,5A6)))') CF(:JF(NX)),
     +    (CLN(A(1,J),6,-3),J=1,NX)
        WRITE(7,'(/" This regression accounts for proportion ",A4,
     +    " of this Y-item''s variance.")') CLN(SCOR,4,3)
      ELSE
        WRITE(7,'(/" Regression summary:"/3X,"Each entry of form ""(X",
     +    "i:rms,max,Yj)"" gives the Y-variables'' RMS regression loa",
     +    "ding"/3X,"on X-item i followed by the largest of those and",
     +    " index j of the Y-item that has it.",50(/1X,5("  (X",A,": ",
     +    2(A4, ", "),"Y",A,")":)))') (CF(:JF(J)), CLN(RR(J),4,3),
     +    CLN(A(LU(J),J),4,3), CF(:JF(LU(J))), J=1,NX)
      END IF
      DEALLOCATE ( A )
      IF(NY>1) WRITE(7,'(/" The mean Y-variance accounted for by the",
     +  " X-set is",A5,"; the individual Y-variances accounted for ",
     +  "are")') CLN(SCOR,5,-3)
      IF(NY>1) WRITE(7,FMT2) (CLN(CS(I,NY1),5,-2),I=1,NY)  ! Last use of CS col NY1
      IF(NBX==1) WRITE(7,'(/" Note: One X-variable is a standardized",
     +  " dichotomy; its X-set index and binary-scale"/3X,"standard ",
     +  "deviation are ",A,":",A)') CF(:JF(INT(OFFL(1)))),
     +  CLN(MOD(OFFL(1),1.),5,3)
      IF(NBX>1) THEN
        WRITE(7,'(/" Note: ",A," of the X-variables are standardized",
     +    " dichotomies; their X-set indices i and binary scale"/3X,
     +    "standard deviations sd are here listed in form ""(Xi:sd",
     +    ")"":")') CF(:JF(NBX))
        N=18; IF(NBX==5) N=11; IF(NBX>5) N=4
        WORD = '(50('//CF(:JF(N))//'X,10(2X,"(X",A,":",A5,")",:)/))  '
        WRITE(7,WORD(:38)) (CF(:JF(INT(OFFL(I)))),CLN(MOD(OFFL(I),1.),
     +    5,3),I=1,NBX)
      END IF
      IF(NBX>0) WRITE(7,'(3X,"To convert regression coefficients on ",
     +  "a standardized binary item into predictor weights on its"/3X,
     +  "binary scale, divide them by that item''s binary-scale stan",
     +  "dard deviation.  Weights on binary"/3X,"predictors are disti"
     +  "nctively easy to interpret.")')

C Note: xx of the X-variables are standardized dichotomies; their X-set indices
C   {i} and binary-scale standard deviations {sd} are listed as "i:sd" here:
C   To convert regression coefficients on a standardized binary item into
C   regression weights on its binary scale, divide them by that item's
C   binary-scale standard deviation.  Weights on binary predictors are
C   especially easy to interpret.
C Emendation: xx of these X-items are not strictly data variables but standardized true-parts
C   thereof inferred from their externally estimated reliabilities.  Their X-set indices
C   followed by their estimated reliability indices (loadings on true-parts) are:

      IF(NOX==1) WRITE(7,'(" Emendation: X-item ",A," is not strictl",
     +  "y a data variable but the standardized true-part thereof"/3X,
     +  "inferred from its reliability index externally estimated to",
     +  " be",A5)') CF(:JF(INT(ABS(OFFL(NBX+1))))), CLN(MOD(ABS(OFFL(
     +  NBX+1)),1.),5,3)
      IF(NOX>1) THEN
        WRITE(7,'(" Emendation: ",A," of these X-items are not stric",
     +    "tly data variables but standardized true-parts"/3X,"there",
     +    "of inferred from their externally estimated reliabilities",
     +    ".  Their X-set indices"/3X,"followed by their estimated ",
     +    "reliability indices (loadings on true-parts) are:")')
     +    CF(:JF(NOX)); N=18; IF(NOX==5) N=11; IF(NOX>5) N=4
        WORD = '(50('//CF(:JF(N))//'X,10(2X,"(X",A,":",A5,"),:")/))   '
        WRITE(7,WORD(:38)) (CF(:JF(INT(ABS(OFFL(I))))),
     +    CLN(MOD(ABS(OFFL(I)),1.),5,3),I=NBX+1,NBO)
      END IF
      IF(NY<3) THEN
        IF(NX==0) WRITE(6,'(/" There are too few Y-variables to fac",
     +    "tor.  Enter anything to start again,"/" or hit RETURN to",
     +    " stop.")')
        IF(NX>0) WRITE(6,'(/" There are too few Y-residuals to fact",
     +    "or.  But information about the Y-set''s"/" regression up",
     +    "on the X-set is recorded in file ",A)') F1
        IF(NX>0) STOP
        CALL SCAN(J,0,'B',5)
        IF(J/=0) GOTO 100
        STOP
      END IF
C
C Compute SMC uniqueness bounds
130   WRITE(6,'(//" ",75(""),""/" ",8X,"Final preliminary: Inspec",
     +  "ting your data''s eigenstructure.",10X,""/" ",75(""),"")')
C   Get lower bound on communalies from EIGS-based inverse of Cyy
      ALLOCATE ( T(NY,NY) )
CC      WORD(:5) = 'large'; IF(NY>199) WORD(:5) = 'LARGE'
CC      IF(NY>99) WRITE(6,'(/" Be patient; this Cyy is ",A5,"."/)') WORD
      CALL EIGS(NY,NY,CY,NYY,RR,T,NY,1,IER,7)   ! Size of NYY flags sym-storage
      IF(IER>0) WRITE(6,'(/" Eigensolution won''t converge, presumabl",
     +  "y because Cyy is badly ill-conditioned."/" Try recomputing t",
     +  "his dataset''s covariances after imputation of missing scor",
     +  "es"/" or deletion of variables/records especially deficient",
     +  " in good data.")')
      IF(IER>0) STOP
      SMAL = TINY(1.)  ! = .1175E-37
      DO K = 1,NY
        IF(RR(K)>=SMAL) NR = K
      END DO
      IF(NR<NY) CALL FIXCOV(NY,NYY,NR,CY,RR,T,YSET,SMAL,J)
      IF(NR<NY .AND. J/=0) THEN; DEALLOCATE (T); GOTO 100; END IF
      DO I = 1,NY
        S = 0.
        DO J = 1,NR
          S = S + T(I,J)*T(I,J)/RR(J)
        END DO                                  ! Save initial communality ests
        CS(I,NV+1) = MAX(0.,CY(LO(I,I)) - 1./S) ! Inv(Diag[Inv(CS)]) is best initial Uniq est
        CS(I,NV+2) = CS(I,NV+1)  ! Permanent store; other will be updated
      END DO
C   Hereafter, CS holds Y-residual items' covs, with their initial comm ests
C   saved in CS(-,NV+1) until PRINF updates those in CS(-,NV+1)
C
C Find the Y-residual eigenstructure
      NL = NY/2+1
132   WRITE(6,'(/" The number of leading data eigenvalues to be sho",
     +  "wn is now set at ",A,"."/" Hit RETURN if OK, or enter new ",
     +  "limit.  (Maximum is ",A,".)"/)') CF(:JF(NL)), CF(:JF(NY))
      CALL SCAN(J,1,'I',5)
      IF(J==0) GOTO 135
      IF(J<=-1) GOTO 132
      READ(2,*) NL
      NL = MIN(NY,NL)
      GOTO 132
C
135   YVAR = 0.
      DO I = 1,NY
        YVAR = YVAR + CY(LO(I,I))
      END DO
      DO K = 6,7
        WRITE(K,'(/" The first ",A," eigenvalues of the to-be-factor",
     +    "ed covariances are")') CF(:JF(NL))
      END DO
      WRITE(6,'(20(1X,5A5,2X,5A5,2X,5A5:/))') (CLN(RR(I),5,-2),I=1,NL)
      WRITE(7,FMT2) CLN(RR(1),5,2), (CLN(RR(J),5,-2),J=2,NL)
      IF(NL>105) CALL WAIT(0)
      NN = 0
      DO J = 1,NL
        IF(RR(J)<=EPS) CYCLE
        NN = NN+1
        S = SQRT(RR(J))
        DO I = 1,NY          ! RR,T not quite correct if ill-conditioned
          T(I,J) = S*T(I,J)  ! CY was fixed, but shouldn't matter.
        END DO
      END DO
      CALL KOUNT(NY,NL,T,LU,JN,NX,0)
C Set parameters for common factoring
      M = MIN(NL-1,MAX(3,JN-19)-1)
      JN = MAX(M+1,JN)-M
      DO I = 1,JN
        LSTF(I) = M+I
      END DO
      LSTF(JN+1) = -1   ! Flag that default list is still active
75    WRITE(6,'(" The choices of NF (Number of Factors) now picked",
     +  " for solution are",2(:/3X,25I3))') (LSTF(I),I=1,JN)
      IF(KSAY==1) WRITE(6,'(/" Hit RETURN if OK, or enter a new list o",
     +  "f NF choices not necessarily restricted"/" to the ones now sh",
     +  "own. (Multiple NF are computed in ascending order; but since"/
     +  " you can later return to this point for additional choices ",
     +  "of NF and solution"/" method, there is not much to gain from",
     +  " picking more than one NF at a time.)"//)')
      IF(KSAY<1) WRITE(6,'(" Hit RETURN if OK, or enter a new list ",
     +  "of NF choices."/)'); KSAY = 0
      CALL SCAN(J,0,'I',5)
      IF(J==0 .AND. LSTF(JN+1)<0. AND. JN>1) THEN
        WRITE(6,'(3X,"You have approved all ",A," default choices ",
     +    "for NF.  If this is really what"/3X,"you want, enter any",
     +    " letter.  Otherwise, hit RETURN to reconsider.")')
     +    CF(:JF(JN))
        CALL SCAN(K,0,'I',5)
        IF(K>=0) GOTO 75
      END IF
      IF(JN>=1 .AND. J==0) GOTO 140
      IF(J<=0) GOTO 75
      READ(2,*) (LU(I),I=1,J)
      CALL ISORT(J,LU)
      JN = 0   ! JN will be adjusted number of NF-choices
      M = 99   ! Suppress warning about defaults (probably never needed)
      LSTF(1) = MAX(3,LU(J))   ! Backup against no acceptable entries
      DO I = MAX(1,LU(J)),LU(1)
        DO K = 1,J
          IF(I==LU(K) .AND. (JN==0.OR.I/=LSTF(JN))) THEN
            JN = JN+1
            LSTF(JN) = I
          END IF
        END DO
      END DO
      JN = MAX(1,JN)   ! In case no entries were accepted
      GOTO 75
C
140   WORD(:9) = 'variables'
      IF(NX>0) WORD(:9) = 'residuals'

C   MODA currently provides five methods of factor extraction:
C      1. Principal Axes of the Y-residuals' common parts (Principal Factors).
C      2. Minres (unweighted least-squares) solution for common parts.
C      3. Normalized Principal Components (data-space principal axes).
C      4. Maximum-likelihood common factor solution (MLFA).
C      5. Generalized least-squares (GLS: Maximum-likelihood Minres).
C   Also currently testing
C      6. Principal-factors solution by MLFA code.

      WRITE(6,'(3X,"MODA currently provides five methods of factor ex",
     +  "traction:"/6X,"1. Principal Axes of the Y-",A,"'' common par",
     +  "ts (Principal Factors)."/6X,"2. Minres (unweighted least-squ",
     +  "ares) solution for common parts."/6X,"3. Normalized Princip",
     +  "al Components (data-space principal axes)."/6X,"4. Maximum-",
     +  "likelihood common factor solution (MLFA).")') WORD(:9)
      WRITE(6,'(6X,"5. Generalized least-squares (GLS: Maximum-likli",
     +  "hood Minres).")')
cc      WRITE(6,'(6X,"6. Principal-factoring by MLFA code.")')
      IF(NR<NY) WRITE(6,'(6X,"However, ill-conditioned covariances ",
     +  "disallow MLFA and GLS in this case.")')
141   WRITE(6,'(" Hit RETURN to select method",I2,", or enter",
     +  " the index of another choice."/)') MFAC
      CALL SCAN(J,0,'I',5)
      IF(J==0) GOTO 145; IF(J<0) GOTO 141
      READ(2,*) MFAC
      MFAC = MIN(5,MAX(1,MFAC))   ! ; IF(MFAC>6) MFAC = 3
      IF(NR<NY .AND. MFAC>3) MFAC = MFAC-3
      GOTO 141
145   IF(MFAC==1) GOTO 150
      IF(MFAC==3) GOTO 170
      IF(MFAC>=4) GOTO 160
      IF(MOD(KOD1,2)==0) KOD1 = KOD1+1
      G = .8
      WRITE(6,'(8X,"Control parameters for Minres factoring are:"/8X,
     +  "IMAX (max. number of iteration cycles),"/8X,"TOL (solution ",
     +  "shift tolerated for convergence), and"/8X,"G (weight of new",
     +  " pattern when shifting previous one)."/14X,"If your solution",
     +  " resists convergence,"/14X,"decrease G and perhaps increase",
     +  " TOL."/)')
147   WRITE(6,'(/" <IMAX,TOL,G> is now <",A,",",A6,",",A4,
     +  ">. Hit RETURN if OK.  Otherwise enter"/" new parameter trip",
     +  "le or any letter to reconsider your extraction method."/)')
     +  CF(:JF(IMAX)), CLN(TOL,6,4), CLN(G,4,2)
      CALL SCAN(J,0,'R',5)
      IF(J==0) GOTO 170
      IF(J==-1) GOTO 140
      IF(J<0) GOTO 147
      IF(J>=3) READ(2,*) Z, TOL, G;
      IF(J==2) READ(2,*) Z, TOL; IF(J==1) READ(2,*) Z
      IMAX = MAX(1,MIN(500,NINT(Z)))
      GOTO 147
150   IF(MOD(KOD1,2)==1) KOD1 = KOD1-1
      WRITE(6,'(12X,"Control params for Principal Factoring are:"/
     +  12X,"IMAX (max. number of iteration cycles), and"/12X,"TOL ",
     +  "(solution shift tolerated for convergence).")')
152   WRITE(6,'(/" <IMAX,TOL> is now <",A,",",A6,">. Hit RETURN if ",
     +  "OK.  Otherwise enter new"/" parameter 2-tuple or any letter ",
     +  "to reconsider your extraction method."/)') CF(:JF(IMAX)),
     +  CLN(TOL,6,4)
      CALL SCAN(J,2,'IR',5)
      IF(J==0) GOTO 155; IF(J==-1) GOTO 140; IF(J<0) GOTO 152
      IF(J>=2) READ(2,*) Z, TOL; IF(J==1) READ(2,*) Z
      IMAX = MAX(1,MIN(500,NINT(Z)))
      GOTO 152
155   MCOM = 1
      IF(JN==1) GOTO 170
157   IF(MCOM==1) WRITE(6,'(/" If you want each solution''s communali",
     +  "ty iteration to start with the preceding"/" communality solu",
     +  "tion, hit RETURN.  Otherwise, enter anything to use the same"/
     +  " initial communality estimate for all solutions.  (Should",
     +  "n''t really matter.)")')
      IF(MCOM/=1) WRITE(6,'(/" If you want each factor solution to s",
     +  "tart with the initial SMC communality"/" estimates, hit RET",
     +  "URN.  Otherwise, enter anything for progressive starting"/
     +  " communalities.")')
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 170  ! Common path for all MFAC
      MCOM = 3-MCOM
      GOTO 157

160   WRITE(6,'(6X,"Limit IMAX on ML-factoring''s iteration cycles ",
     +  "is now set at ",A/6X "Hit RETURN if OK, or enter another ch",
     +  "oice of IMAX.  To reconsider"/6X,"your extraction method, ",
     +  "enter any letter."/)') CF(:JF(IMAX))
      CALL SCAN(J,1,'I',5)
      IF(J==0) GOTO 155   ! Allow option on starting communalities
      IF(J==-1) GOTO 140
      IF(J<0) GOTO 160
      READ(2,*) IMAX;  IMAX = MAX(1,MIN(99,IMAX))
      GOTO 160
C
C Do factoring for all factor numbers in LSTF
170   WORD(:22) = 'following solution was'
      IF(JN>1) WORD(:22) = 'ensuing solutions were'
      IF(MFAC==1) WRITE(7,'(/"  The ",A22," found by Principal Factor",
     +  "ing under control parameters <IMAX,TOL> = <",I2,",",A6,">")')
     +   WORD, IMAX, CLN(TOL,6,4)
      IF(MFAC==2) WRITE(7,'(/"  The ",A22," found by Minres factoring",
     +  " under control parameters <IMAX,TOL,G> = <",I2,",",A6,",",A4,
     +  ">")') WORD, IMAX,CLN(TOL,6,4),CLN(G,4,2)
      IF(MFAC==3) WRITE(7,'(/"  The ",A18," comprises normalized Prin",
     +  "cipal Components.")') WORD
      IF(MFAC==4) WRITE(7,'(/"  The ",A22," found by Maximum-likeli",
     +  "hood factoring (MLFA).")') WORD
      IF(MFAC==5) WRITE(7,'(/"  The ",A22," found by Maximum-likeli",
     +  "hood Minres (GLS).")') WORD
      IF(MFAC==6) WRITE(7,'(/"  The ",A22," found by MLFA code for ",
     +  "principal factoring.")') WORD
      IF(JN==1 .OR. MFAC==2.OR. MFAC==3) GOTO 171
      IF(MCOM==1) WRITE(7,'(" Starting communality estimates were",
     +  " progressive from one solution to the next.")')
      IF(MCOM/=1) WRITE(7,'(" Each solution started with the same",
     +  " SMC communality estimates.")')
171   KOD = KODE + KOD1*1000000
      MF = LSTF(JN)
      DEALLOCATE ( T ); IF(ALLOCATED(A)) DEALLOCATE ( A )
      IF(MFAC<4) ALLOCATE ( A(NY,MF), T(NY,MF) )
      IF(MFAC>=4) ALLOCATE ( A(NY,NY), T(NY,NY) )
      IF(MFAC==3) F2(LF-2:LF-2) = 'K'
      JX = JN
      BBIG: DO K1 = 1,JN
        IF(K1>JX) GOTO 261  ! Inoperative unless JX is reset below
        KK = LSTF(K1)
        WRITE(7,'(200A)')  ('',I=1,78)
C Factor by chosen method
        IER = 0
174     IF(MFAC==2.OR.MFAC==3) CALL PRINF(KK,NV,MCOM,MFAC,LSHO,CS,CY,A,
     +    T,RR,W)  ! Minres solution uses PC axes for 1st approximation
        IF(MFAC==1) THEN
          IF(MFAC==1) WRITE(6,'(//" Details on solution for ",A,
     +      " Principal Factors:"/)') CF(:JF(KK))
          IF(MFAC==3) WRITE(6,'(//" Details on solution for ",A,
     +      " Principal Components:"/)') CF(:JF(KK))
          CALL PRINF(KK,NV,MCOM,MFAC,LSHO,CS,CY,A,T,RR,W)  ! NV is leading dim,
          CALL SHOCNV(NY,CNV,ICYC)                         !   NY is in COMMON
        ELSE IF(MFAC==2) THEN
          DO J = 1,NY; DO I = 1,J
              CS(I,J) = CY(LO(I,J)); CS(J,I) = CS(I,J)
          END DO; END DO
          WRITE(6,'(//" Details on solution for ",A," MINRES fac",
     +      "tors:"/)') CF(:JF(KK))
          CALL MINRES(KK,NV,LSHO,IER,CS,CY,A,RR,W)    ! NV is leading dim,
          CALL SHOCNV(NY,CNV,ICYC)                      !   NY is in COMMON
        ELSE IF(MFAC>=4) THEN
          IF(MFAC==4) WRITE(6,'(//" Solving for ",A," Maximum-likeli",
     +      "hood common factors:")') CF(:JF(KK))
          IF(MFAC==5) WRITE(6,'(//" Solving for ",A," GLS (maximum-l",
     +      "ikelihood minres) factors:")') CF(:JF(KK))
          IF(MFAC==6) WRITE(6,'(//" Solving for ",A," principal fact",
     +      "ors by MLFA routine:")') CF(:JF(KK))
          DO I = 1,NY
            RR(I) = 1. - CS(I,NV+1)  ! SMC uniqueness estimate
          END DO
          DEALLOCATE ( W, W1 ) ! RAM saving probably pointless
          CALL MLFA(CY,KK,MFAC,RR,A,T,CS,IER)
          ALLOCATE ( W(NVV), W1(NVV))
C           Initial uniquenesses are in RR; reproduction errors returned in T
C           NY and IMAX are passed in COMMON
          IF(IER>0) THEN ! Error report just for MLFA methods
            WRITE(7,'(" Solving for NF = ",A," factors by method",I2,
     +        " reports ERROR = ",A)') CF(:JF(KK)), MFAC, CF(:JF(IER))
            IF(KP>=100) WRITE(7,'(64(" "))')
            IF(KP<100) WRITE(7,'(38(" "))')
            KK = KK-1
            IF(K1>1 .AND. LSTF(K1-1)==KK) GOTO 261
            WRITE(6,'(/" To try extraction by this same method with NF",
     +        " decreased to ",A,", hit RETURN."/" Otherwise, enter a",
     +        "nything for a broader range of continuation options.")')
     +        CF(:JF(KK))
            CALL SCAN(J,1,'B',5)
            IF(J/=0) GOTO 261
            JX = K1; GOTO 174     ! <<< JX indexes adjustable up-end of NF list
          END IF
          DO J = 1,NY
            DO I = 1,J
              W(LO(I,J)) = T(I,J)
            END DO
            CS(J,NV+1) = 1. - T(J,J)  ! Save latest communalities
          END DO
        END IF
        J = 0; IF(TIM>99.) J = 1
        WORD(:5) = CLN(TIM,5,2); IF(J>0) WORD(:5) = CLN(TIM/60,5,2)
        WORD(6:10) = ' sec.'; IF(J>0) WORD(6:10) = ' min.'
        WRITE(6,'(/" Total Method-",I1," time for ",A," factors: ",
     +    A10)') MFAC, CF(:JF(KK)), WORD(:10)
        IF(IER/=0) CYCLE BBIG
        SCOR = 1.-RVAR/YVAR
        WORD(11:12) = 's '; M = 1; IF(NX==1) M = 2
        F2(LF-1:LF) = CF(:JF(KK+NX))//' '  ! Insure that blank follows 2-char ext
        IF(NY>KUT) WRITE(7,'(/" The Y-set pattern on ",A," latent fac",
     +    "tors and ",A," X-variable",A,"has been stored in file ",A)')
     +    CF(:JF(KK)), CF(:JF(NX)), WORD(10+M:12), F2
        IF(NV>KUT) GOTO 256
        IF(NX==0) WRITE(7,'(/" The Y-set pattern on ",A," factors ",
     +    "is:")') CF(:JF(KK))
        IF(NX>0) WRITE(7,'(/" The Y-residual pattern on ",A,
     +    " factors is:")') CF(:JF(KK))
        DO I = 1,NY
          IF(MOD(I,5)==1) WRITE(7,'()')
          WRITE(7,FMT1) (CLN(A(I,J),5,2),J=1,KK)
        END DO
256     IF(MFAC/=3) WRITE(7,'(/" This solution took ",A," iterations,",
     +    " reproducing the Y-covariances in ",A10/" with <Stand.Err/",
     +    "Max.Err/Set-Determ.> = <",A5,",",A5,",",A5,">.")') CF(:JF(
     +    ABS(ICYC))), WORD(:10), CLN(SE,5,3),CLN(XE,5,3), CLN(SCOR,5,3)
        IF(MFAC==3) WRITE(7,'(/" This non-iterated dataspace solu",
     +    "tion reproduces the Y-covars with <Stand.Err/Max.Err/Set",
     +    "-Determ.> = <",A5,",",A5,",",A5,">.")') CLN(SE,5,3),
     +    CLN(XE,5,3), CLN(SCOR,5,3)
        WRITE(7,'(" Max.Err. is for variables <",A,", ",A,">. The un",
     +    "iquenesses are"/)') CF(:JF(JB)), CF(:JF(IB))
        WRITE(7,FMT2) (CLN(W(LO(I,I)),5,2),I=1,NY) ! W returned fit residuals
        INQUIRE(19,EXIST=QY)
        IF(QY) THEN
          BACKSPACE 19
          READ(19) (LU(NV+I),I=1,NV)  ! Recover rawdata indices of COV variables
        END IF
        KF = 0
        DO I = 1,NY   ! Order integer-coded uniquenesses by decreasing size
          IF(.NOT.QY) LU(I) = 0
          KF = MAX(KF,IABS(LU(YSET(I)) -I)) ! >NY if LU empty; >0 if diff from rawdata index
          LU(I) = NINT(W(LO(I,I))*1000)*10**6 + LU(NV+YSET(I))*10**3 + I
        END DO
C         LU holds item's uniqueness ^ its rawdata index ^ its index in Y-set
        CALL ISORT(NY,LU)
        DO I = 1,NY
          LU(I) = MOD(LU(I),10**6)
          IBUF(I) = LU(I)/1000     ! Reordered rawdata indices
          LU(I) = MOD(LU(I),1000)  ! Reordered Y-set indices
        END DO
        WORD(:13) = '(30(30I4,:/))'
        IF(KP<100) WORD(:13) = '(50(20I4,:/))'
        WRITE(7,'(/" In order of DECREASING UNIQUENESS, these varia",
     +   "bles'' Y-set indices are")')
        WRITE(7,WORD(:13)) (LU(I),I=1,NY)
        CALL LAST(L,NAME(1),12)
        IF(QY .AND. KF>0 .AND. L>0) THEN
          WRITE(7,'(/" Still in order of decreasing uniqueness, the",
     +      " indices of these variables"/" in rawdata sourcefile ",A,
     +      " are")') NAME(1)(:L)
          WRITE(7,WORD(:13)) (IBUF(I),I=1,NY)
        ELSE IF(KF==0) THEN
          WRITE(7,'(/" The variables identified by these Y-set indic",
     +      "es have the same indices in rawdata sourcefile ",A)')
     +    NAME(1)(:L)
        END IF
        CALL RESIDS(NY,SE,XE,W,LU,IBUF)   ! List large residuals in W
C   Store results in unformatted files <head>.M<NK> (or <head>.K<NK> for
C   Principal components)
84      KLIM = MIN(KK,NV-NX)
        NK = KLIM+NX
        NKK = LO(NK,NK)
        DO J = 1,NK
          DO I = 1,J-1
            W1(LO(I,J)) = 0.
          END DO
          W1(LO(J,J)) = 1.
        END DO
        IF(NX>0) THEN
          REWIND 18
          READ(18) (W1(I),I=1,NXX)   ! Writes into X-factors start of W1
        END IF
        INQUIRE(FILE=F2,EXIST=QY); CALL LAST(LF2,F2,12)
        OPEN(3,FILE=F2,FORM='UNFORMATTED')
        M = MTH*MFAC ! M=0 flags outputs unsuitable for HYBOOT, at this point
C          only if the source datafile is not Hydata-standard.  Otherwise,
C          IABS(M)=1/2/3/4/5 flags Prinf/Minres/Components/IMSL/GLS factoring,
C          and +/- sign of M flags item covars including/excluding partial
C          records. This latter info doesn't seem to be used (??).
        WRITE(3) NY, NK, NX, KOD, M, F3     ! F3 names the input COV-file
        IF(NX==0) THEN
          WRITE(3) ((A(I,J),I=1,NY),J=1,KLIM)
        ELSE  ! ***** Any input-covariance reflection has been done by REFL
          REWIND 9
          READ(9) ((T(I,J),I=1,NY),J=1,NX)  ! Pattern of Y-set on X-set
          WRITE(3) ((T(I,J),I=1,NY),J=1,NX), ((A(I,J),I=1,NY),J=1,KLIM)
        END IF
        WRITE(3) NK, NKK
        WRITE(3) (W1(I),I=1,NKK)  ! Reminder: NK > NX
        WRITE(3) (YSET(I)*LSTR(I),I=1,NY),(YSET(NY+I),I=1,NX)
C         *** Note: LSTR marks item reflections and is passed in YSET/XSET signs
        IF(NBO>0) WRITE(3) NBO, (OFFL(I),I=1,NBO)
C         *** Note: Elements of OFFL give info about off-norm X-items and have
C             form [f]j+s, where flag f is a minus sign if this item is not binary,
C             j is its X-set index, and s is its input SD prior to standardization
C Record the Y-variable covariance roots after removal of uniquenesses
        IF(MFAC==3) CLOSE(3)
        IF(MFAC==3) CYCLE
        DO J = 1,NY
          CS(J,J) = CY(LO(J,J)) - W(LO(J,J))
          DO I = 1,J-1
            CS(I,J) = CY(LO(I,J))
            CS(J,I) = CS(I,J)
          END DO
        END DO
        WRITE(6,'(" Computing uniqueness-reduced eigenvalues for ",
     +    "the ",A,"-factor solution"/)') CF(:JF(KK))   ! Note: NOT the common-parts covars
        CALL EIGS(NY,NL,CS,NV,RR,T,NY,0,IER,7)  ! T is a dummy for JOB=0; otherwise SIZE(T,2) must be larger
        WRITE(7,'(/" After the ",A,"-factor uniquenesses are partial",
     +    "led out, the leading ",A," eigenvalues of the Y-variable",
     +    "s'' reduced covariances are")') CF(:JF(KK)), CF(:JF(NL))
        WRITE(7,FMT2) CLN(RR(1),5,2), (CLN(RR(I),5,-2),I=2,NL)
        IF(QY) WRITE(7,'(/" >>> NOTE: Even if discarded below, this ",
     +    "new solution for ",A," factors has"/11X,"destroyed file ",
     +    A," saved earlier in this run.")') CF(:JF(NK)), F2(:LF2)
        IF(MFAC/=3) THEN
          WRITE(6,'(" Also solving for item loaings on the principal",
     +      " axes of extraction space."/)')
          DO J = 1,NY
            DO I = 1,J
              CS(I,J) = 0.
              DO K = 1,KLIM
                CS(I,J) = CS(I,J) + A(I,K)*A(J,K)
              END DO
            END DO
          END DO
          CALL EIGS(NY,KLIM,CS,NV,RR,A,NY,1,IER,7)
          DO J = 1,KLIM
            S = SQRT(MAX(0.,RR(J)))
            DO I = 1,NY
              A(I,J) = A(I,J)*S
            END DO
          END DO
        END IF
        JOB = 1  ! JOB returns ouput in this KOUNT call
        CALL KOUNT(NY,KLIM,A,LU,J,NX,JOB)  ! Kounting last extraction, not Cyy-Du
        IF(JOB>=0) CLOSE(3)
        IF(JOB<0) THEN  ! JOB returns minus-flagged count of deleted factors
          KL = ABS(JOB)
88        WRITE(6,'(/" To replace your ",A,"-factor extraction with ",
     +      "its ",A,"-factor pruning, hit RETURN."/" Otherwise, en",
     +      "ter any letter (or number) to save (or delete) both.  N",
     +      "ote that")') CF(:JF(KLIM)), CF(:JF(KL))
          NK = KL+NX; NKK = LO(NK,NK)
          F2(LF-1:LF) = CF(:JF(NK))//' '
          INQUIRE(FILE=F2,EXIST=QY)
          IF(QY) WRITE(6,'(" the pruned solution will overwrite a ",A,
     +      "-factor solution saved previously.")') CF(:JF(NK))
          IF(.NOT.QY) WRITE(6,'(" the pruned solution will NOT over",
     +      "write any solution saved previously.")')
          CALL SCAN(J,0,'R',5) ! J=0 puts new for old; J<0 saves both; J>0 saves neither
          IF(J<0) WRITE(6,'(" Enter anything to confirm that you wan",
     +      "t to save both the ",A,"-factor solution"/" and its ",A,
     +      "-factor pruning. Otherwise, hit RETURN to choose again."
     +      )') CF(:JF(KLIM)), CF(:JF(KL))
          IF(J==0) WRITE(6,'(" Enter anything to confirm that you wa",
     +      "nt to delete the ",A,"-factor solution"/" but save its ",
     +      A,"-factor pruning.  Otherwise, hit RETURN to choose aga",
     +      "in.")') CF(:JF(KLIM)), CF(:JF(KL))
          IF(J>0) WRITE(6,'(" Enter anything to confirm that you want",
     +      " to delete both the ",A,"-factor solution"/" and its ",A,
     +      "-factor pruning. Otherwise, hit RETURN to choose again.",
     +      )') CF(:JF(KLIM)), CF(:JF(KL))
          CALL SCAN(K,0,'B',5); IF(K==0) GOTO 88
          IF(J<0) CLOSE(3) ! Save unpruned
          IF(J>=0) CLOSE(3,STATUS='DELETE')
          IF(J>=0) WRITE(6,'(/" Unpruned solution for ",A," fact"
     +      "ors deleted as instructed.")') CF(:JF(KK))
          IF(J>0) CYCLE ! Don't save pruned
          OPEN(3,FILE=F2,FORM='UNFORMATTED')
          M = MTH*MFAC  ! Shouldn't be needed if M not modified
          WRITE(3) NY, NK, NX, KOD, M, F3
C            F3 is name of the input COV-file
          IF(NX==0) THEN
            WRITE(3) ((A(I,LU(J)),I=1,NY),J=1,KL)  ! LU set in KOUNT call
          ELSE
            WRITE(3) ((T(I,J),I=1,NY),J=1,NX),((A(I,LU(J)),I=1,NY),
     +        J=1,KL)
          END IF
          WRITE(3) NK, NKK
          WRITE(3) (W1(I),I=1,NKK)  ! Reminder: NK = KLIM+NX
          WRITE(3) (YSET(I)*LSTR(I),I=1,NY), (YSET(NY+I),I=1,NX)
          IF(NBO>0) WRITE(3) NBO, (OFFL(I),I=1,NBO)  ! See info above
          CLOSE(3)
          WORD(:2) = 's '
          WRITE(7,'(/" The pattern extracted on ",A," common fact",
     +      "ors has been reduced to ",A," factors"/" by selecti",
     +      "ng in order of strength its principal-factor columns"/
     +      30(1X,A))') CF(:JF(KLIM)), CF(:JF(KL)), (CF(:JF(LU(I))),
     +      I=1,KL)
          IF(NX>0) WRITE(7,'(" These are preceded in the output",
     +      " pattern by ",A," column",A,"of X-set coefficients.")')
     +      CF(:JF(NX)), WORD(3-MIN(2,NX):2)
          SE = 0.; XE = 0.; RVAR = 0.
          DO J = 1,NY
            DO I = 1,J
              S = 0.
              DO K = 1,KL
                S = S + A(I,LU(K))*A(J,LU(K))
              END DO
              S = CY(LO(I,J)) - S   ! Cij unaccounted for by pruned model
              IF(I/=J) THEN
                SE = SE + S*S; XE = MAX(XE,ABS(S))
              END IF
              W(LO(I,J)) = S
            END DO
            RVAR = RVAR+S
          END DO
          SE = SQRT(SE*2/(NY*(NY-1))); RVAR = 1.-RVAR/NY
          WRITE(7,'(/" For this pruned solution, <Stand.Err/Max.Err/S",
     +      "et-Determ.> = <",A5,",",A5,",",A5,">")') CLN(SE,5,3),
     +      CLN(XE,5,3), CLN(RVAR,5,3)
          WRITE(7,'(" Pruning increases the uniquenesses to")')
          WRITE(7,FMT2) (CLN(W(LO(I,I)),5,2),I=1,NY)
          CALL RESIDS(NY,SE,XE,W,LU,IBUF)  ! List large residuals of pruned solution
        END IF
        WORD(:3) = 's.)'
        IF(NX==1) WORD(:3) = '.) '
        WRITE(7,'(/" This pattern ready for HYBALL or HYBLOCK rotat",
     +    "ion is in file ",A," under Code No. ",A,A3,"."/" (Factor ",
     +    "count in extension includes ",A," X-set item",A)') F2(:LF),
     +    CF(:JF(KODE)), CLN(KOD1*.01,3,2), CF(:JF(NX)), WORD(:3)
        IF(QY) WRITE(7,'(" It has overwritten a previous extraction ",
     +    "with this name.")')
      END DO BBIG
C
C If wanted, re-factor.  Under option of Principal factoring with progressive
C communalities, last communality solution will start re-factoring.
261   IF(JOB<0) THEN          ! ***** $$$$$ bookmark


C > Before continuing, note that the errors of data reproduction by this pruned
C > xx-factor extraction are not identical to those of the unpruned same-method
C > extraction of xx factors.  (The former's covariance residuals tend to have
C > smaller Stand.Err but larger Max.Err than the latter's.)  To examine the
C > difference in this instance, continue with an unpruned xx-factor extraction
C > and compare the results reported in this run's SEE-file.  (The unpruned
C > version will override the pruned one's M-file, but MODA can easily recreate
C > that should you choose to pick up on the pruned solution.


        WRITE(6,'(" > Before continuing, note that the errors of data",
     +    " reproduction by this pruned"/" > ",A,"-factor extraction",
     +    " are not identical to those of the unpruned same-method"/
     +    " > extraction of ",A," factors.  (The former''s covariance",
     +    " residuals tend to have"/" > smaller Stand.Err but larger ",
     +    "Max.Err than the latter''s.)  To examine the"/" > differen",
     +    "ce in this instance, continue with an unpruned ",A,"-facto",
     +    "r extraction"/" > and compare the results reported in this",
     +    " run''s SEE-file.  (The unpruned"/" > version will overri",
     +    "de the pruned one''s M-file, but MODA can easily recreate"/
     +    " > that should you choose to pick up on the pruned soluti",
     +    "on.)"/)') (CF(:JF(KL)),I=1,3)
        LSTF(1) = KL; JN = 1
      END IF
      WRITE(6,'(/4X,"Enter anything if you want to re-do the factorin",
     +  "g in light of the"/4X,"preceding convergence behavior or loa",
     +  "dings on the extracted axes."/4X,"(New solutions will overwr",
     +  "ite preceding ones with the same number"/4X,"of factors.)  ",
     +  "Otherwise, hit RETURN to quit.")')
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 265
      WRITE(6,'(6X,"To re-start with your latest communalities solut",
     +  "ion, hit RETURN."/6X,"Otherwise enter anything to reload th",
     +  "eir initial estimates.")')
      CALL SCAN(J,0,'B',5)
      IF(J/=0) THEN
        DO I = 1,NY
          CS(I,NV+1) = CS(I,NV+2)
        END DO
      END IF
      WRITE(7,'(/4X,"",66(""),"")')
      WRITE(7,'(4X," Re-doing factor extraction; may destroy ",
     +  "results reported above.  ")')
      IF(J==0) WRITE(7,'(4X," Communality estimates will start ",
     +  "with their last prior solution. ")')
      IF(J/=0) WRITE(7,'(4X," Communality estimates will start ",
     +  "with the initial SMC estimates. ")')
      WRITE(7,'(4X,"",66(""),"")')
      GOTO 75
C
265   WRITE(6,'(/" All done here.  It''s been a pleasure to serve ",
     +  "you.")')
      CALL LAST(LF2,F2,12)
      IF(JN==1) WRITE(6,'(/" This pattern readied for HYBLOCK or",
     +  " HYBALL rotation is in file ",A)') F2(:LF2)
      IF(JN>1) WRITE(6,'(/" Your patterns ready for HYBLOCK/HYBL",
     +  "OCK rotation are in ",A," - ",A)')
     +  F2(:LF-2)//CF(:JF(LSTF(1))), F2(:LF2)
      WORD(:3) = 's.)'; IF(NX==1) WORD(:3) = '.) '
      WRITE(6,'(" under Code No. ",A,A3,". (Factor count in extens",
     +  "ion includes ",A," X-set item",A)') CF(:JF(KODE)),
     +  CLN(KOD1*.01,3,2), CF(:JF(NX)), WORD(:3)
      WRITE(6,'(/" Details of this run are reported in ",A)')
     +  F2(:LF-3)//'SEE'
      WRITE(7,'("")')
      STOP
999   IF(NVV/=NV*(NV+1)/2) WRITE(6,'(/" This input array is not",
     +  " recorded as a covariance matrix.")')
      STOP
      END
C
      SUBROUTINE ALLCNT(NY,NV,KF,A,W,CS)
C This receives a sym-storage string W of covars among NY variables and
C solves for KF centroid factors.  The estimated centroid pattern is returned
C in A, while W is destroyed.  CS is a workspace.
      REAL A(NY,*), CS(NV,*), W(*)
      LO(I,J) = J*(J-1)/2 + I
      IF(KF<=0) RETURN
      OPEN(17,STATUS='SCRATCH',FORM='UNFORMATTED')
      K = 0
50    K = K+1
      DO J = 1,NY
        DO I = 1,J
          CS(I,J) = W(LO(I,J))
          CS(J,I) = CS(I,J)
        END DO
      END DO
      REWIND 17
      WRITE(17) (W(I),I=1,LO(NY,NY))
CC      WRITE(6,'(" Solving for centroid approximation to factor",I3,
CC     +  ".")') K
      CALL CENT(NY,NV,A(1,K),CS,W)  ! Put kth centroid in kth column of A
      REWIND 17
      READ(17) (W(I),I=1,LO(NY,NY))
      IF(K==KF) GOTO 30
      DO I = 1,NY
        DO J = I,NY
          W(LO(I,J)) = W(LO(I,J)) - A(I,K)*A(J,K)
        END DO
      END DO
      GOTO 50
30    CLOSE(17)
      END
C
      SUBROUTINE CAP(WORD,L)
C This makes the first L letters in WORD all upper-case.
      CHARACTER WORD*(*)
      DO I = 1,L
        N = ICHAR(WORD(I:I))
        IF(N>=97 .AND. N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      RETURN
      END
C
      SUBROUTINE CENT(NY,NV,VEC,CS,W)
C This receives the covariances among NY residual variables in full matrix
C CS, re-orients these to roughly-maximal convergence, solves for their 1st
C centroid factor, puts this into vector VEC, and returns the residual covs
C left by this centroid in CS.  W is a storage space,
      REAL CS(NV,*), VEC(*), W(*)
      LO(I,J) = J*(J-1)/2 + I
      NY1 = NY+1
      DO I = 1,NY
        CS(I,NY1) = 1.0  ! Record reflections in tail of CS
        DO J = I,NY
          W(LO(I,J)) = CS(I,J)
        END DO
      END DO
C Reflect variables to near-maximal convergence
      DO J = 1,NY
        VEC(J) = 0.
        DO I = 1,NY
          IF(I/=J) VEC(J) = VEC(J) + CS(I,J)  !  off-diag covar column
        END DO
      END DO
      KT = 0
14    KT = KT+1
      IZ = 1
      DO J = 2,NY
        IF(VEC(J)<VEC(IZ)) IZ = J  ! Find col with smallest sum
      END DO
      IF(VEC(IZ)>=0.) GOTO 20      ! Reflect if sum is negative
      DO J = 1,NY
        IF(J==IZ) CYCLE
        CS(J,IZ) = -CS(J,IZ)
        CS(IZ,J) = -CS(IZ,J)
        VEC(J) = VEC(J) + 2*CS(IZ,J)
      END DO
      CS(IZ,NY1) = -CS(IZ,NY1)
      VEC(IZ) = -VEC(IZ)
      IF(KT<NY*NY) GOTO 14    ! Look again for neg col if KT less than limit
20    VT = 0.
      DO J = 1,NY
        VEC(J) = VEC(J) + CS(J,J) ! Complete  of col J
        VT = VT + VEC(J)          ! Variance of raw centroid
      END DO
      VT = SQRT(VT)
      DO J = 1,NY
        VEC(J) = CS(J,NY1)*VEC(J)/VT  ! Cov(normed centroid, proper oriented item)
      END DO
C Partial out the centroid factor and return the residual covers in CS,
C deleting residuals that are negligible or corrupt from nonGramian item covars
      DO J = 1,NY
        CS(J,J) = W(LO(J,J)) - VEC(J)*VEC(J)
        IF(CS(J,J)<1.E-10) CS(J,J) = 0.   ! Delete negligible or corrupt residuals
        DO I = 1,J-1
          CS(I,J) = W(LO(I,J)) - VEC(I)*VEC(J)
          IF(CS(I,I)==0. .OR. CS(J,J)==0.) CS(I,J) = 0.   ! Probably pointless
          CS(J,I) = CS(I,J)
        END DO
      END DO
      RETURN
      END

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
C      SAVE /CF/  ! This doesn't appear to be needed
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      CLN = '        '
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      LD = ABS(ND)
      IF(ABS(X)<1.0E-12) THEN !  Special for vanishingly small X
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X))) !  M is space free for decimal (or M-1 if X<0) )
      IF(M<0 .OR. M<1.AND.X<0.) GOTO 55
      IF(ND>=10) LD = 0; LD = MIN(LD,M)
      DO I = 1,KW
        WK(I) = ' '
      END DO
      IF(LD==0) N = NINT(ABS(X))         ! Shouldn't be needed, but is
      IF(LD/=0) N = NINT(ABS(X)*10**LD)  ! This can overflow if LD is large
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' *******'
      END FUNCTION
C
      SUBROUTINE GETLST(N,LIST,J,NV,KW,NB,LB)
C Enter N distinct indices no larger than NV into LIST in sequential order.
C LIST(N+_) receives in order the indices from 1 to NV omitted from LIST.
C KW is a workspace. LIST may be partly formed at input, SCAN provides the rest.
C LB lists NB binaries to be included if flagged by 0 in received LIST
      INTEGER  LIST(*), KW(*)
      INTEGER  LB(*)
      EXTERNAL SCAN
      IF(N>=0) WRITE(6,'(/4X,"Hit RETURN if correct and complete. ",
     +  "Otherwise, enter additional"/4X,"indices and/or delete some",
     +  " by entering them with minus signs. (Any"/4X,"negative ent",
     +  "ry also disables the interval reading of entry pairs.)"/)')
      CALL SCAN(J,0,'I',5)
      IF(J<=0) RETURN
      NX = MAX(0,N)
      DO I = 1,NX
        KW(I) = LIST(I)
      END DO
8     READ(2,*) (LIST(I),I=1,J)
      IF(NB==0) GOTO 15  ! No binaries or omissions-list call
      K = 0
      DO I = 1,J        ! Put binaries into X-set?
        IF(LIST(I)==0) K = K+1   ! Zero entry signals to include binaries
      END DO
      IF(K<=0) GOTO 15   ! Binaries flag not on list
      DO I = 1,NB
        KW(NX+I) = LB(I)
      END DO
      NX = NX+NB
      IF(J==1) GOTO 30  ! Only entry is zero
15    IF(J/=2 .OR. MIN(LIST(1),LIST(2))<0) THEN
        DO I = 1,J   ! ^Accepts two-item lists with a negative
          K = 0
          L = LIST(I)
          IF(L<0) THEN   ! Delete discards
            L = IABS(L)
            DO N = 1,NX
              IF(KW(N)==L) NX = NX-1
              IF(KW(N)==L) KW(N) = KW(NX+1)
            END DO
          ELSE IF(L>0) THEN
            NX = NX+1
            KW(NX) = L
          END IF
        END DO
      ELSE
        L = MAX(1,MIN(NV,LIST(1),LIST(2)))
        M = MIN(NV,MAX(1,LIST(1),LIST(2)))
        DO I = L,M
           KW(NX+I-L+1) = I
        END DO
        NX = NX+M-L+1
      END IF
30    WRITE(6,'(/4X,"Enter more indices and/or delete some by enter",
     +  "ing them as negative."/4X,"(Negative entries also disable",
     +  " the interval reading of pairs.)"/4X,"Otherwise, hit RETU",
     +  "RN to see your listing."/)')
      CALL SCAN(J,0,'I',5)
      IF(J<0) GOTO 30
      IF(J>0) GOTO 8
C Order list with any duplicates removed
      CALL SORT(KW,NX,LIST,1,NV)
      N = NX
      J = N
      END SUBROUTINE
C
      SUBROUTINE ISORT(N,LST)
C Sort LST integers into descending (or ascending) order
      INTEGER LST(*)
      DO J = 2,N
        L = LST(J)
        DO I = J-1,1,-1
C          IF(LST(I)<=L) GOTO 12    ! Increasing order
          IF(LST(I)>=L) GOTO 12    ! Decreasing order
          LST(I+1) = LST(I)
        END DO
        I = 0
12      LST(I+1) = L
      END DO
      END SUBROUTINE
C
      SUBROUTINE KOUNT(NY,NF,A,LST,KF,NX,JOB)
C For each column of A, tell how many entries therein exceed threshold CUT.
C JOB=0 just shows salience Count on eigenvalues; otherwise, principal factors
C are permuted to salience-strength order with Mean(Count) salience shown.
C KF returns the largest NF at which Count at first free Cut exceeds 2.
      CHARACTER CLN*8, CH2*2, CF*12, WORD*79
      INTEGER LST(*)
      REAL A(NY,*)
      COMMON /CF/ CF
      EXTERNAL SCAN
      CUT = .20
      KF = 0; N3 = 0; LOOK = 0
      IF(JOB/=0) N3 = 3*NF
      IF(JOB/=0) GOTO 50
      DO K = 6,7
        IF(NX==0) WRITE(K,'(/5X,"Each eigenvalue is the sum of squar",
     +    "ed item coefficients on the "/5X,"corresponding unit-vari",
     +    "ance principal axis of the Y-variables.")')
        IF(NX>0) WRITE(K,'(/" Each eigenvalue is the sum of squared i",
     +    "tem coefficients on the corresponding"/" unit-variance pri",
     +    "ncipal axis of Y-set components orthogonal to the X-set.")')
      END DO
50    DO J = 1,NF
        N = 0; Z = 0.
        DO I = 1,NY
          IF(ABS(A(I,J))<CUT) CYCLE
          N = N+1; Z = Z+ABS(A(I,J))   ! Get count/mean above Cut
        END DO
        LST(N3+J) = N
        IF(JOB/=0) LST(J) = NINT(1000*Z)*10**3 + J
        IF(LOOK<=2 .AND. N>=2) KF = J  ! Fix KF after 2 free Cut choices
      END DO
      IF(JOB==0) THEN
        DO K = 6,7
          WRITE(K,'(/"  On each axis, the count of items with load",
     +      "ings larger than CUT =",A4," is")') CLN(CUT,4,2)
          WRITE(K,'(20(5I5,2X,5I5,2X,5I5:/))') (LST(I),I=1,NF)
          WRITE(K,'()')
        END DO
      ELSE IF(JOB/=0) THEN
        CALL ISORT(NF,LST)  ! Order by decreasing Cut-strength
        CH2 = 's '
        N2 = 2*NF
        DO I = 1,NF
          LST(N2+I) = MOD(LST(I),100)     ! Factor No.
          LST(NF+I) = LST(N3+LST(N2+I))   ! Salience count
          LST(I) = LST(I)/10**3           ! ( saliences) x 10**3
          IF(LST(NF+I)>0) LAST = I  ! Last in new list with nonzero Count
          IF(LST(NF+I)>0) LST(I) = (LST(I)/LST(NF+I))  ! Mean sal x 10**3
        END DO
        IF(LOOK>0) THEN
          K = 6; IF(LOOK>1) K = 12
          DO I = 1,K; BACKSPACE(7); END DO
          WRITE(6,'()')
          DO I = 1,K
            READ(7,'(A)') WORD; WRITE(6,'(A)') WORD
          END DO
        END IF
        K1 = MAX(1,LAST-8)   ! Display-range bottom
        K2 = MIN(LAST,K1+8)  ! Display-range top
        CALL ISORT(NF-K2,LST(N2+K2+1))   ! Ascendingly order trailing indices
        DO K = 6,7
          WRITE(K,'()')  ! IF(K==7) WRITE(K,'()');
          IF(K1>1) WRITE(K,'(" This extraction pattern''s Mean(Cou",
     +      "nt) of loadings exceeding CUT = ",A3," on axes"/" after t"
     +      "he strongest ",A," in order of decreasing Cut-strength (",
     +      "Mean x Count) are")') CLN(CUT,3,2), CF(:JF(K1-1))
          IF(K1<=1) WRITE(K,'(" This extraction pattern''s Mean(Cou",
     +      "nt) of loadings exceeding CUT = ",A3/" in order of decre",
     +      "asing Cut-strength (Mean x Count) are")') CLN(CUT,3,2)
          WRITE(K,'(" Factor:",I3,10I8)') (LST(N2+I),I=K1,K2)
          WRITE(K,'(5X,9(1X,A3,"(",I2,")"))') (CLN(LST(I)/10.**3,
     +      3,2),LST(NF+I),I=K1,K2)
          IF(NF>K2) WRITE(K,'(" Factors with zero Count at cut ",A3,
     +      ":",13I3:/25I3)') CLN(CUT,3,2), (LST(N2+I),I=NF,K2+1,-1)
          IF(NF==K2) WRITE(K,'(" Factors with zero Count at this le",
     +      "vel: None")')
        END DO
25      WRITE(6,'(/3X,"To re-record this extraction pattern with its ",
     +    "factors weakest at this"/3X,"CUT-level deleted, enter the ",
     +    "index (NOT list position) of the last in"/3X,"list you wan",
     +    "t to save.  Otherwise, hit RETURN to get another CUT optio",
     +    "n,"/3X,"or enter any letter to waive pruning of extraction",
     +    " axes."/)')
        CALL SCAN(J,0,'I',5)
        IF(J==-2) GOTO 25
        IF(J<0) RETURN
        IF(J==0) GOTO 40
        READ(2,*) N
        LAST = 0
        DO I = 1,NF
          IF(LST(N2+I)==N) LAST = I
        END DO
        IF(LAST==0) WRITE(6,'(" Number ",A," does not index a fac",
     +    "tor on the list.  Try again.")') CF(:JF(N))
        IF(LAST==0) GOTO 25
        CALL ISORT(NF-LAST,LST(N2+LAST+1))
        IF(LAST<NF) WRITE(6,'(/" Hit RETURN to approve deleting fac",
     +    "tor",A,10(1X,A):/5X,20(1X,A))') CH2(3-MIN(2,NF-LAST):2),
     +    (CF(:JF(LST(N2+I))),I=NF,LAST+1,-1)
        IF(LAST>=NF) WRITE(6,'(/" Hit RETURN to delete none of the",
     +    1X,A," extracted factors,")') CF(:JF(NF))
        WRITE(6,'(" or enter anything else to try again.")')
        CALL SCAN(J,0,'I',5)
        IF(J/=0) GOTO 25
        DO I = 1,LAST
          LST(I) = LST(N2+I)
        END DO
        JOB = -LAST  ! Flagged count of retained factors
        WRITE(7,'(/" Pruning Action:"/4X,"Delete factors ",80(1X,A))')
     +    (CF(:JF(LST(N2+I))),I=NF,LAST+1,-1)
        WRITE(7,'(4X,"In order, retain",80(1X,A))') (CF(:JF(LST(I))),
     +    I=1,LAST)
        RETURN
      END IF
40    CUT = CUT+.05
      IF(CUT>.6) CUT = .1
      LOOK = LOOK+1
41    WRITE(6,'(5X,"Hit RETURN to see this information at CUT level",
     +  A4,".  Otherwise, enter"/5X,"another choice of CUT or any ",
     +  "letter to move on."/)') CLN(CUT,4,2)
      CALL SCAN(J,0,'R',5)
      IF(J<0) RETURN
      IF(J==0) GOTO 50
      READ(2,*) CUT
42    IF(CUT>=.9) CUT = CUT/10
      IF(CUT>=.9) GOTO 42
      CUT = MAX(.05,CUT)
      GOTO 41
      END
C
      SUBROUTINE LAST(L,WORD,M)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as L. If the string is empty, LAST is returned as 0.
      CHARACTER WORD*(*)
      WORD(:M) = ADJUSTL(WORD(:M))
      L = LEN_TRIM(WORD(:M))
      END SUBROUTINE
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
      LOGICAL PRM, QY
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP
      CHARACTER E   ! <<<  Special characters as needed
      WD = GET
      CALL LAST(M,WD,40)
      LL = 1
5     LL = LL+1
      E = WD(LL+1:LL+1)
      IF(E/='|' .AND. E/='/' .AND. LL<M) GOTO 5  ! *** No longer relevant??
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(WORD(:1)==' ' .OR. WORD(:1)=='.') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
C       Filter out lines other than filenames
      CALL LAST(L,WORD,14)
      J = ICHAR(WORD(11:11))
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
      IF(WORD(:6)=='INMODA' .OR. WORD(10:12)=='COV') GOTO 19
      IF(WORD(:3)=='SEE') GOTO 10
      IF(J<48 .OR. J>57) GOTO 10
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4) .AND. NAME(I)(L+5:L+5)==' ')
     +    GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NL)
      IF(NL>0) WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      CALL LAST(L1,NAM1,LEN(NAM1)); CALL LAST(L2,NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      CALL LAST(L1,WRD1,LEN(WRD1)); CALL LAST(L2,WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A mumber terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION
C
       SUBROUTINE MINRES(NF,NV,LSHO,IER,CS,CY,A,RR,W)
C This subroutine factors the covariances CY among NY variables for NF Minres
C factors, starting from an initial approximation to the pattern in matrix A
C and also returning the Minres solution in A. ICYC counts iteration cycles,
C and SE/XE are the standard-error/maximum-error of CY-reproduction by the
C returned pattern. Iteration stops by the same IMAX/TOL criterion used in sub-
C routine PRINF. (SHIFT can alternatively be max change in any pattern coeff.)
      CHARACTER CLN*8, CF*12
CCC      REAL CY(NYY), CS(NV,NV+2), A(NY,NF), T(NY,NF), RR(NY), W(NYY)
      REAL CY(*), CS(NV,*), A(NY,*), RR(*), W(*), ABK(NY,NF)
      REAL CNV(2,4), CBK(2,4), SB(NY*(NY+1)/2)
      REAL, ALLOCATABLE :: BK(:,:)
      COMMON NY,ICYC,IMAX,TOL,SE,XE,RVAR,G,IB,JB,TIM,CNV
      COMMON /CF/ CF
      EXTERNAL SCAN
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      NFF = NF*(NF+1)/2
      SE = 1.; SBK = 99.; NBK = 0; SB = 0.; IMX = IMAX; TLL = TOL
      DO I = 1,NY; RR(I) = 0.; END DO

C Put the iterated factor pattern P into the 1st NF columns of A, followed
C by CY*P-less-exclusions in ABK(_,_). Put P'*P into W(NFF+_) while its
C adjustment for the Ith pattern row goes into the beginning of W.
      WRITE(7,'(/" Details of Minres solution for ",A," common ",
     +  "factors:")') CF(:JF(NF))
      LAST = 0; ICYC = 0; I=TM(1); TIM = 0.
80    ICYC = ICYC + 1
      S1 = SE
      DO I = 1,NY
        DO J = 1,NF
          S = 0.
          DO K = 1,NY  ! Omit term CY(LO(I,K))*A(K,J) from sum when K=I
            IF(I/=K) S = S + CY(LOC(I,K))*A(K,J)
          END DO
          ABK(I,J) = S
        END DO
      END DO
      DO J = 1,NF
        DO I = 1,J
          S = 0.
          DO K = 1,NY
            S = S + A(K,I)*A(K,J)
          END DO
          W(NFF+LO(I,J)) = S
        END DO
      END DO
C   Next, solve for each row of the new pattern estimate
      BIG: DO K = 1,NY
        DO J = 1,NF
          DO I = 1,J
            W(LO(I,J)) = W(NFF+LO(I,J)) - A(K,I)*A(K,J)
          END DO
        END DO
        CALL EIGS(NF,0,W,NFF,W,X,1,NF,IER,7)   ! JOB=NF calls Ginv(W)
        IF(IER/=0) RETURN  ! ^ Also serves as dump for unwanted eivals
        Z = 0.
        DO J = 1,NF
          S = 0.
          DO I = 1,NF
            S = S + ABK(K,I)*W(LOC(I,J))
          END DO
          A(K,J) = G*S + (1.-G)*A(K,J)
          Z = Z + A(K,J)*A(K,J)
        END DO
        IF(Z<=CY(LO(K,K))) CYCLE BIG
        Z = SQRT(Z/CY(LO(K,K)))
        DO J = 1,NF
          A(K,J) = A(K,J)/Z
        END DO  ! So Heywood case shd never arise
      END DO BIG
C Examine accuracy of CY reproduction
      CNV = 0.; KNV = -1  ! Keep KNV=0 unless prior cycle is reinstated
41    SE = 0.; XE = 0.; RVAR = 0.; KNV = KNV+1; SHIFT = 0
      DO J = 1,NY
        DO I = 1,J
          S = 0.
          DO K = 1,NF
            S = S + A(I,K)*A(J,K)
          END DO
          IF(KNV==0.) THEN  ! Don't do if last pattern was modified
            D = ABS(S - SB(LO(I,J)))  ! Size of change in reproduced Cij
            K = 1; IF(I<J) K = 2
            CNV(K,1) = CNV(K,1) + D; CNV(K,2) = CNV(K,2) + D*D
            IF(D>CNV(K,3)) THEN
              CNV(K,3) = D; CNV(K,4) = 1000*I + J
            END IF
          END IF
          SB(LO(I,J)) = S
          S = CY(LO(I,J)) - S
          W(LO(I,J)) = S
C           W now stores errors of reproduction (or uniqueness if I=J)
          IF(I==J) THEN
            SHIFT = MAX(SHIFT,ABS(RR(I)-S))
            RR(I) = S  ! RR(i) now contains the latest uniqueness
            RVAR = RVAR+S
            CYCLE   ! Inner loop
          END IF
          S = ABS(S)
          SE = SE + S*S
          IF(S<=XE) CYCLE   ! Inner loop
          XE = S; IB = I; JB = J
        END DO
      END DO
      IF(NBK<0) RETURN
      SE = SQRT(SE/(NY*(NY-1)/2))
      IF(SE<SBK) THEN   ! Save minimal-SE pattern in BK
        IF(.NOT.ALLOCATED(BK)) ALLOCATE ( BK(NY,NF) )
        SBK = SE; NBK = ICYC; CBK = CNV
        DO J = 1,NF
          DO I = 1,NY
            BK(I,J) = A(I,J)
          END DO
        END DO
      END IF
      IF(ICYC>=IMX .OR. (SHIFT<=TLL*10 .AND. (S1-SE<=TOL/10 .OR.
     +  SHIFT<=TLL))) LAST = 1
      IF(MOD(ICYC-1,LSHO)==0 .OR. LAST==1) WRITE(6,'(I3," factors, C",
     +  "ycle ",A,":"/3X,"Max. comm. shift,",A5,"; <Stand.Err/Max.Er",
     +  "r/Resid.Var> = <",A4,",",A5,",",A6,">")') NF, CF(:JF(ICYC)),
     +  CLN(SHIFT,5,3), CLN(SE,4,3), CLN(XE,5,3), CLN(RVAR,6,2)
C  Re-estimate pattern unless convergent or at iteration limit
      IF(LAST<1) GOTO 80   ! Do another iteration
      TIM = TIM+TM(1)
      IF(ICYC>=IMX .AND. SBK<SE-.0001) THEN  ! Replace current A by best
        DO J = 1,NF
          DO I = 1,NY
            A(I,J) = BK(I,J)
          END DO
        END DO
        WRITE(7,'(" Note: Solution is nonconvergent, so best-fit pat",
     +    "tern from cycle ",A," is selected."/7X,"Stand.Err. at it",
     +    "eration limit (",A," cycles) was ",A5)') CF(:JF(NBK)),
     +    CF(:JF(IMX)), CLN(SE,5,4)
        WRITE(6,'(6X," >>>> No convergence, so best-fit pattern is sel",
     +    "ected. <<<<")')   ! ??? Not done in PRINF; should it be ???
        ICYC = NBK; NBK = -1; CNV = CBK; GOTO 41   ! >>> Note: LAST = 1
      END IF
      IF(SHIFT<=TOL.AND.NBK>=0 .OR. S1-SE<=TLL/10) THEN
        WRITE(6,'(/"  Cycle ",A," approaches convergence with largest",
     +    " communality shift of ",A5/"  and largest change in reprod",
     +    "uced data covariance of ",A5,".  To continue"/"  the solut",
     +    "ion iteration for N  9 more cycles, enter single-digit N."/
     +     "  Otherwise, hit RETURN to move on."/)') CF(:JF(ICYC)),
     +    CLN(CNV(1,3),5,4), CLN(CNV(2,3),5,4)
        CALL SCAN(J,1,'I',5)
        IF(J<1) GOTO 87
        READ(2,*) NN; NN = MAX(1,MIN(ABS(NN),9))
        LAST = 0; IMX = ICYC+NN; TLL = TLL/10; I=TM(1); GOTO 80
      END IF
87    DO I = 1,NY  ! Save communalities for re-do factoring
        CS(I,NV+1) = CS(I,I)
      END DO
      END SUBROUTINE
C
      SUBROUTINE NAME1(F1,M,EXT,L)
C This receives a filename in F1 (presumed to start in position 1), solves for
C <head> to be the part of F1 prior to '.' up to M characters, scans the sub-
C directory for the lowest i=1,2,...,9 such that file <head>i.EXT does not
C already exist, and returns <head>i.EXT in F1(:12), along with its end
C position L.
      CHARACTER F1*(*), EXT*(*), QFMT
      L = 0
10    L = L+1
      IF(L<=M .AND. F1(L:L)/=' ' .AND. F1(L:L)/='.') GOTO 10
      F1(L:L+4) = '0.'//EXT(:3)
      DO I = L+5,12
        F1(I:I) = ' '
      END DO
      I = 0
20    I = I+1
      F1(L:L) = CHAR(48+I)
      IF(QFMT(F1)/='U' .AND. I<9) GOTO 20
      IF(QFMT(F1)/='U' .AND. I==9) F1(L:L) = '0'
      L = L+4
      END SUBROUTINE
C
      SUBROUTINE PRINF(NF,NV,MCOM,MFAC,LSHO,CS,CY,A,T,RR,W)
C This copies sym-storage input covars CY into regular storage CS; initializes
C communalities to be the same SMC bound if MCOM=2 or the preceding communality
C solution if MCOM=l; and solves for NF iterated principal factors.  The
C principal-factor pattern is returned as the columns of A; the communalities
C are returned in CS(I,I); eigenvalues are returned in L; and the common-factor
C residuals are returned in W. Iteration for communalities stops after IMAX
C iterations, or when the max communality SHIFT is less than TOL, or when the
C standard error of covariance reproduction decreases by less than TOL/10
C provided that SHIFT < TOL*10.
C *** MFAC>1 solves for Principal Components; no communalities; MFAC=2 omits reports
      CHARACTER (120) MESS, CLN*8, CF*12
C      REAL CY(NVV), CS(NV,NV+2), A(NY,NF), T(NY,NF), RR(NY), W(NYY)
      REAL CY(*), CS(NV,*), A(NY,*), T(NY,*), RR(*), W(NY*(NY+1)/2)
      REAL CNV(2,4), SB(NY*(NY+1)/2)  ! SB saves prev. reproduced covs
      COMMON NY,ICYC,IMAX,TOL,SE,XE,RVAR,G,IB,JB,TIM,CNV
      COMMON /CF/ CF
      EXTERNAL SCAN
      LO(I,J) = J*(J-1)/2 + I
      SE = 1.0; KBLAB = 0; SB = 0.; IMX = IMAX; TLL = TOL
C       KBLAB=0 prints only last EIGS message. KBLAB/=0 prints all; but you
C       don't really want 50 reports of how initial nonconvergence was handled.
      KB = 1 + 6*MIN(1,KBLAB) ! Either 7 or 1
      IF(KBLAB==0) OPEN(1,STATUS='SCRATCH')
      IF(MFAC==1) WRITE(7,'(/" Details of Principal-Factor solution ",
     +  "for ",A," common factors :")') CF(:JF(NF))
      IF(MFAC==3) WRITE(7,'(/" Details of solution for ",A," normal",
     +  "ized Principal Components (dataspace):")') CF(:JF(NF))
      LAST = 0; ICYC = 0; TIM = 0.; I = TM(1)
      W = 0. ! Returns residuals for SEE-report
      DO I = 1,NY
        S = CS(I,NV+MCOM)
        IF(MFAC==3) S = CY(LO(I,I))  ! Note: MFAC, not MCOM
        CS(I,I) = S
      END DO
80    ICYC = ICYC+1
      S1 = SE
      DO J = 2,NY
        DO I = 1,J-1
          CS(I,J) = CY(LO(I,J))
        END DO
      END DO
      CALL EIGS(NY,NF,CS,NV,RR,T,NY,1,IER,KB)
      DO J = 1,NF
        Z = 0.
        DO I = 1,NY
          Z = Z + T(I,J)
        END DO
        S = SIGN(SQRT(MAX(0.,RR(J))),Z)
        DO I = 1,NY
          A(I,J) = S*T(I,J)
        END DO
      END DO
      IF(MFAC>1) GOTO 21
      SHIFT = 0.
      DO I = 1,NY
        VI = CY(LO(I,I)); COMM = 0.
        DO J = 1,NF
          COMM = COMM + A(I,J)*A(I,J)
        END DO
        IF(COMM>VI) THEN  ! Expunge Heywood communalities immediately
          S = SQRT(VI/COMM)
          DO J = 1,NF
            A(I,J) = S*A(I,J)
          END DO
          COMM = VI
        END IF
        RR(I) = COMM
        SHIFT = MAX(SHIFT,ABS(COMM-CS(I,I)))   ! Shd be same as CNV(1,3) below
        CS(I,I) = COMM
      END DO
C Examine accuracy of CY reproduction
      CNV = 0.
21    SE = 0.; XE = 0.; RVAR = 0.
      DO J = 1,NY
        DO I = 1,J
          S = 0.
          DO K = 1,NF
            S = S + A(I,K)*A(J,K)
          END DO
          D = ABS(S - SB(LO(I,J)))  ! Size of change in reproduced Cij
          K = 1; IF(I<J) K = 2
          CNV(K,1) = CNV(K,1) + D; CNV(K,2) = CNV(K,2) + D*D
          IF(D>CNV(K,3)) THEN
            CNV(K,3) = D; CNV(K,4) = 1000*I + J
          END IF     ! ^ Redundant with SHIFT when K=1
          SB(LO(I,J)) = S   ! Save new reproduced Cij
          S = CY(LO(I,J)) - S
          W(LO(I,J)) = S    ! W returns errors of reproduction
          IF(I==J) RVAR = RVAR+S; IF(I==J) CYCLE
          S = ABS(S); SE = SE + S*S  ! Off-diagonal errors
          IF(S<=XE) CYCLE
          XE = S; IB = I; JB = J
        END DO
      END DO
      SE = SQRT(SE/(NY*(NY-1)/2))
      IF(ICYC>=IMX .OR. MFAC>1. OR. (SHIFT<=TLL*10 .AND.
     +  (S1-SE<=TLL/10 .OR. SHIFT<=TLL))) LAST = 1
      IF(MOD(ICYC-1,LSHO)/=0 .AND. LAST/=1) GOTO 26
      IF(MFAC==1) WRITE(6,'(I3," factors, Cycle",I3,":"/3X,"Max.",
     +  " comm. shift,",A5,"; <Stand.Err/Max.Err/Resid.Var> = <",A4,
     +  ",",A5,",",A6,">")') NF, ICYC, CLN(SHIFT,5,3), CLN(SE,4,3),
     +  CLN(XE,5,3), CLN(RVAR,6,2)
      IF(MFAC==3) WRITE(6,'(I3," factors: <Stand.Err/Max.Err/Resid.",
     +  "Var> = <",A4,",",A5,",",A6,">")') NF, CLN(SE,4,3),CLN(XE,5,3),
     +  CLN(RVAR,6,2)
C  Re-estimate pattern unless convergent, at iteration limit, or Components extraction
26    TIM = TIM + TM(1)
      IF(MFAC>1) GOTO 87
      IF(LAST/=1) GOTO 80
      DO I = 1,NY
        CS(I,NV+1) = CS(I,I)  ! Save communalities for next extraction call
      END DO
      IF(SHIFT<=TOL .OR. S1-SE<=TLL/10) THEN
        WRITE(6,'(/"  Cycle ",A," approaches convergence with largest",
     +    " communality shift of ",A5/"  and largest change in reprod",
     +    "uced data covariance of ",A5,".  To continue"/"  the solut",
     +    "ion iteration for N  9 more cycles, enter single-digit N."/
     +     "  Otherwise, hit RETURN to move on."/)') CF(:JF(ICYC)),
     +    CLN(CNV(1,3),5,4), CLN(CNV(2,3),5,4)
        CALL SCAN(J,1,'I',5)
        IF(J<1) GOTO 87
        READ(2,*) NN; NN = MAX(1,MIN(ABS(NN),9))
        LAST = 0; IMX = ICYC+NN; TLL = TLL/10; I=TM(1); GOTO 80
      END IF
87    IF(KBLAB/=0) RETURN
      BACKSPACE 1
      READ(1,'(A120)',END=70) MESS
      WRITE(7,'(A120)') MESS
      CLOSE(1)
70    END SUBROUTINE
C
      SUBROUTINE PRNT(JOB,KP,KFILE)
C Set printer codes. JOB=0/1/2 if job is find-linewidth/set-normal-print/set-
C HYBALL-pattern-plots.  KP is linewidth. KFILE is file to write.
      CHARACTER QFMT, WORD*55
      IF(QFMT('PRNTR')=='U') THEN
        IF(JOB==0) WRITE(KFILE,'(/" WARNING: There is no printer ",
     +    "definition in this subdirectory.")')
        IF(JOB==1) WRITE(KFILE,'(" %")')
        IF(JOB==2) WRITE(KFILE,'(" #")')
        RETURN
      END IF
      OPEN(1,FILE='PRNTR')
      READ(1,'(A)') WORD
      IF(WORD(:1)=='*') KP = 80
      IF(JOB==0) GOTO 10
      IF(WORD(:1)/='%') READ(1,'(A)') WORD
      IF(JOB==1) WRITE(KFILE,'(A)') WORD(3:)
      IF(JOB==1) GOTO 10
      READ(1,'(A)') WORD
      WRITE(KFILE,'(A)') WORD(3:)
10    CLOSE(1)
      END SUBROUTINE
C
      SUBROUTINE REFL(NY,CY,LSTR,JSGN,WK,NEGCOV,KRF)
C Find how many negative Y-set covariances remain in CY after reflecting
C items to convergence; and return 0 in KRF if option to reflect is declined,
C or number of reflected items otherwise.  LSTR(J) is -1 or 1 if item J is to
C be reflected or not; JSGN returns list of KRF positions in YSET list (1 to NY)
C of reflected items.
      CHARACTER CH, CH4*4, CF*12
      INTEGER LSTR(*), JSGN(*)
      REAL CY(*), WK(*)
      COMMON /CF/ CF
      LO(I,J) = J*(J-1)/2 + I
      KRF = 0; NNEW = 0; LARG = 100
      IF(NY>LARG) WRITE(6,'(" Scanning for possible reduction of",
     +  " negative covariances by item reflections.")')
      IF(NY>2*LARG) WRITE(6,'(" For large item sets, this may take"
     +  " longer than you expect.")')
      CALL RFLCT(NY,CY,LSTR,WK)
C      LSTR is NY-term list of +1/-1 reflection signs
      DO J = 1,NY
        IF(LSTR(J)<0.) KRF = KRF+1
        IF(LSTR(J)<0.) JSGN(KRF) = J  ! Used to list reflections in SEE-file
        DO I = 1,J-1
          IF(LSTR(I)*LSTR(J)*CY(LO(I,J))<.0) NNEW = NNEW+1
        END DO
      END DO
      IF(NEGCOV<=NNEW) THEN  ! Don't reflect
        IF(NY>LARG) WRITE(6,'(" Scan finds nothing to gain from ",
     +    "item reflections."/)')
        RETURN
      END IF
      LL = MIN(2,NEGCOV); MM = MIN(2,KRF); CH4 = 's ve'
      KR = 0
20    IF(KR==0) WRITE(6,'(/6X,"Your Y-set''s ",A," negative cor",
     +  "relation",A,"can be reduced to ",A,/6X,"by reflecting ",A,
     +  " variable",A,TL1,".  To waive reflection, hit RETURN."/6X,
     +  "Otherwise, enter anything to approve reflection.")')
     +  CF(:JF(NEGCOV)), CH4(3-LL:2), CF(:JF(NNEW)), CF(:JF(KRF)),
     +  CH4(3-MM:2)
C       ! TLn instructs to Tab-Left n spaces (TRn is Tab-Right)
      IF(KR>0) WRITE(6,'(/6X,"To approve reflection, hit RETURN.",
     +  "  Otherwise, enter anything to"/6X,"reconsider your cho",
     +  "ice.")')
      READ(5,'(A1)') CH

CC TEST LINES  Both OK down to here
C      WRITE(6,'(/" In REFL, LSTR: ",20I3)') (LSTR(I),I=1,NY)
C      WRITE(6,'(" In REFL, JSGN: ",20I3)') (JSGN(I),I=1,KRF)
C      WRITE(6,'(/" CH reads [",A,"]")') CH; PAUSE


      IF(CH/=' ') THEN
        KR = 1-KR

CC TEST LINE
C      WRITE(6,'(/" Line 2328: KR =",I3)') KR

        GOTO 20
      END IF

CC TEST LINE
C      WRITE(6,'(/" Line 2333: KR =",I3)') KR; PAUSE

      KRF = KR*KRF
      IF(KR==0) THEN
        DO I = 1,NY
          LSTR(I) = 1
        END DO
        RETURN
      END IF
      DO J = 2,NY
        DO I = 1,J-1
          CY(LO(I,J)) = LSTR(I)*LSTR(J)*CY(LO(I,J))
        END DO
      END DO
      WRITE(6,'(/6X,A," Y-set variable ha",A," been reflected.")')
     +  CF(:JF(KRF)), CH4(MM*2-1:MM*3-1)     ! [s ve]
      END SUBROUTINE
C
      SUBROUTINE RESIDS(NY,SE,XE,CE,LST1,LST2)
C Record largest covars in sym-storage matrix of Y-residual covars CE.
C LST1 and LST2 are work vectors; LST1 must hold large integers
      CHARACTER CLN*8, CF*12
      INTEGER LST1(*), LST2(*)
      REAL CE(*)
      COMMON /CF/ CF
      EXTERNAL SCAN
      LO(I,J) = J*(J-1)/2 + I
C  List large residuals
      CUT = MIN(.10,MAX(.02,AINT(100*XE)/100))
10    KF = 0
      DO J = 2,NY
        DO I = 1,J-1
          S = ABS(CE(LO(I,J)))
          IF(S<=CUT) CYCLE
          KF = KF+1
          LST1(KF) = 1000000*NINT(S*1000) + 1000*I + J
        END DO
      END DO
      WRITE(6,'(/6X,A," of this solution''s residual Y-covariances ",
     +  "(reproduction errors)"/6X,"are larger than Cut ",A3,", whi"
     +  "ch is ",A3," times the RMS residual (",A4,")."/6X,"Hit RET"
     +  "URN to record these.  Otherwise, enter another Cut level"/
     +  6X,"or any letter to waive listing of large residuals."/)')
     +  CF(:JF(KF)), CLN(CUT,3,2), CLN(CUT/SE,3,1), CLN(SE,4,3)
      CALL SCAN(JJ,1,'R',5)
      IF(JJ<0) GOTO 45
      IF(JJ>0) THEN
        READ(2,*) CUT
30      IF(CUT>1.) CUT = CUT/10
        IF(CUT>1.) GOTO 30
        CUT = MAX(.5*SE,CUT)
        GOTO 10
      END IF
      CALL ISORT(KF,LST1)
      DO I = 1,KF
        LST2(I) = MOD(LST1(I)/1000,1000)
        LST1(I) = MOD(LST1(I),10**3)
      END DO
45    WRITE(7,'(/1X,A," of its Y-covariance reproduction residuals ex",
     +  "ceed Cut ",A3,", which is ",A3," times the RMS residual (",A4,
     +  ").")') CF(:JF(KF)), CLN(CUT,4,3), CLN(CUT/SE,3,1), CLN(SE,4,3)
      IF(JJ<0 .OR. KF<1) RETURN
      WRITE(7,'(" Listed in form ""(i,j; r)"", where i,j are the Y-se",
     +  "t indices of variables whose residual covariance is r, these",
     +  " are")')
      WRITE(7,'(1000(7("  (",I3,",",I3,";",A5,")",:)/))')
     +  (LST2(I),LST1(I),CLN(CE(LO(LST2(I),LST1(I))),5,-3),I=1,KF)
      END SUBROUTINE
C
      SUBROUTINE RFLCT(NV,C,LV,SV)
C Reflect items further to 1st and 2nd order convergence based on item
C covariances in sym-storage C. Return reflected item orientations in LV.
      INTEGER LV(*)
      REAL C(*), SV(0:*)
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      SV(0) = 0.
      DO I = 1,NV
        LV(I) = 1
      END DO
C *** PHASE 1 has been deleted here
C PHASE 2:  Find lowest two orders of convergence from item covariances
101   DO J = 1,NV
        SV(J) = 0.
        DO I = 1,J-1
          S = C(LO(I,J))*LV(I)*LV(J)
          SV(I) = SV(I) + S  ! Collect marginal sums of C in SV, omitting variances
          SV(J) = SV(J) + S
        END DO
      END DO
      K2 = 0
110   K2 = K2+1  ! Repeat Phase 2 if still getting action
C Search for order-1 convergence
      L2 = 0
120   L2 = L2+1
      IB = 0
      DO I = 1,NV
        IF(SV(I)<SV(IB)) IB = I  ! Reminder: Variances were omitted from SV
      END DO
C Reflect item IB
      IF(IB>0) THEN
        LV(IB) = -LV(IB)
        DO I = 1,NV
          IF(I/=IB) SV(I) = SV(I) + 2*LV(I)*C(LOC(I,IB))*LV(IB)
          IF(I==IB) SV(I) = -SV(I)
        END DO
        IF(L2<NV) GOTO 120  ! Repeat search for order-1 convergence
      END IF
C Search for order-2 convergence
      IB = 0
      JB = 0
      BB = 0.
      DO J = 2,NV
        DO I = 1,J-1
          B = SV(I)+SV(J) - 2*C(LO(I,J))*LV(I)*LV(J)
C           Variances were omitted from SV, so they are also dropped here
          IF(B<BB) THEN
            IB = I
            JB = J
            BB = B
          END IF
        END DO
      END DO
      IF(IB>0) THEN
C Reflect items IB and JB
        LV(IB) = -LV(IB)
        LV(JB) = -LV(JB)
        DO I = 1,NV
          IF(I/=IB .AND. I/=JB) THEN
             SV(I) = SV(I)+2*LV(I)*(C(LOC(I,IB))*LV(IB)+C(LOC(I,JB))
     +               *LV(JB))
          ELSE
             SV(I) = -SV(I) + 2*LV(IB)*C(LOC(IB,JB))*LV(JB)
          END IF
        END DO
        IF(K2<NV) GOTO 110
      END IF
      END SUBROUTINE
C
      SUBROUTINE SCAN(NL,NS,SEQ,KF)
C This reads the keyboard string, cleans it for list-directed reading of
C the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.  Termination of an input line by "*" allows up to
C two continuation lines.) NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number
C string returned in File 2 is non-null but does not match SEQ, and
C gives the total count of numbers in the returned string otherwise.
C *** If SEQ is "B", NL returns 0 if the input line is blank, and
C     returns -1 otherwise.
      CHARACTER  AA, SEQ*(*), WA*240, WB*240
      NL = 0
5     NLL = NL + 80
      READ(KF,'(A80)') WA(NL+1:NLL)
      IP = NL
      NL = NLL+1
10    NL = NL-1
      IF(NL==0) RETURN
      IF(WA(NL:NL)==' ') GOTO 10
      IF(WA(NL:NL)=='*' .AND. NL>IP) GOTO 5
      IF(SEQ(1:1)=='B') NL = -1
      IF(SEQ(1:1)=='B') RETURN
      WB(NL+1:NL+1) = ' '
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +      WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
        ELSE IF (WA(I:I) /= '0') THEN
          IP = 0
        END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF (WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) RETURN
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     +  "number sequence requested. Try again.")')
      RETURN
60    REWIND 2
      WRITE(2,'(A)') WB(1:NL)
      NL = NN
      REWIND 2
      END SUBROUTINE
C
      SUBROUTINE SEENAM(NX,IDENT,LST,LM,LS,LW,KF)
C This writes to file KF the NX names in IDENT picked by the indices in LST.
C LM is max namelength. LS is number of lines to leave at top of screen. Omit
C ending Wait when KF=6 if less than LW lines have been shown since last pause.
C ***** WARNING: When LST is proper, items are listed with original indices
      CHARACTER*8 IDENT(*), FMT*30, CH2*2
      INTEGER LST(*)
      LM = 3
      DO I = 1,NX
        CALL LAST(N,IDENT(LST(I)),8); LM = MAX(LM,N)
      END DO
      LL = 79/(5+LM)   ! Number of fields per line
      LB = (23-LS)*LL  ! Number of fields in 23-LS lines
      NS = MIN(1,MOD(79,5+LM)/2)  ! Number of spaces starting display line
      NL = (NX+LL-1)/LL  ! Number of display lines needed
      NK = 0
      CH2 = CHAR(48+NS)//CHAR(48+LL)
      FMT = '(80('//CH2(1:1)//'X,'//CH2(2:2)//'(I4,":",A),:/))'
20    NL = (NX-NK+LL-1)/LL   ! Number of display lines left to print
      WRITE(KF,FMT) (LST(I),IDENT(LST(I))(:LM),I=NK+1,NK+MIN(LB,NX-NK))
      NK = NK+LB
      IF(KF==6) THEN
        IF(NK<NX .OR. NL>LW) CALL WAIT(0)
C       NL: At end, lines printed either after Call or after last internal Wait
      END IF
      LB = 23*LL  ! Hereafter use full screen
      IF(NK>=NX) RETURN
      GOTO 20
      END SUBROUTINE

      SUBROUTINE SHOCNV(NY,CNV,ICYC)
C Print the solution stability info at convergence
      CHARACTER*12 CF, CLN
      REAL CNV(2,4)
      COMMON /CF/ CF
      IF(CNV(1,3)+CNV(2,3) == 0.) RETURN
      M = NY; MY = NY*(NY-1)/2
      CNV(1,1) = CNV(1,1)/M; CNV(1,2) = SQRT(CNV(1,2)/M)
      CNV(2,1) = CNV(2,1)/MY; CNV(2,2) = SQRT(CNV(2,2)/MY)

C    Solution stabiilty: The mean, RMS, and maximum unsigned change in
C    (a) the communalities and (b) the reproduced data covariances on
C    the last of xx iteration cycles.
C
      WRITE(7,'(/4X,"Solution stabiilty: The mean, RMS, and maximum ",
     +  "unsigned change in"/4X,"(a) the communalities and (b) the ",
     +  "reproduced data covariances on"/4X,"the last of ",A," iter",
     +  "ation cycles."/)') CF(:JF(ICYC))
      M = NINT(CNV(1,4)); M0 = M/1000
      M = NINT(CNV(2,4)); M1 = M/1000; M2 = MOD(M,1000)
      J0 = JF(M0); J1 = JF(M1)+JF(M2); J2 = 9+J1; J3 = 18+J1
      WRITE(7,'(23X," Mean    RMS    Maximum",20A)') (' ',I=1,J2),''
      WRITE(7,'(8X,15(""),2(""),"",30A)') ('',I=1,J3),''
      WRITE(7,'(9X,"Communalities",3("  ",A5)," (Item ",A,")",20A)')
     +  (CLN(CNV(1,J),5,4),J=1,3),CF(:JF(M0)), (' ',I=1,4+J1-J0),''
      WRITE(7,'(9X,"Covariances  ",3("  ",A5)," (Items ",A,", ",A,
     +  20A)') (CLN(CNV(2,J),5,4),J=1,3),CF(:JF(M1)),CF(:JF(M2)),') '
      WRITE(7,'(8X,15(""),2(""),"",30A)') ('',I=1,J3),''
      END SUBROUTINE
C                        Mean    RMS    Maximum                9+J1 spaces
C        Ĵ
C         Communalities  .xxxx  .xxxx  .xxxx (Item xxx)        4+J1-J0 spaces
C         Covariances    .xxxx  .xxxx  .xxxx (Items xxx, xxx) 
C         18+J1

C
      SUBROUTINE SORT(LIST,N,LST,N1,N2)
C This receives in LIST an unordered list of N integers; puts into LST(_) the
C NN distinct ones in range <N1,N2>, and into LST(N2+_) the complement of LST(_)
C over this range; and sets N = NN for return.
      INTEGER LIST(*), LST(*)
       L = 0
       M = N
       OUTER: DO I = N1,N2
         DO J = 1,N
           IF(I/=LIST(J)) CYCLE
           L = L+1
           LST(L) = I
           CYCLE OUTER
         END DO
        M = M+1
        LST(M) = I
      ENDDO OUTER
      N = L
      END SUBROUTINE
C
      SUBROUTINE START(J,F1,K)
C This opens formatted file F1 with unit-number J, and finds its first line
C beginning with a digit.
      CHARACTER F1*(*), CH*80
      OPEN(J,FILE=F1)
10    READ(J,'(A)',END=50) CH
      CALL LAST(N,CH,60)
      IF(N==0) GOTO 10
      K = ICHAR(CH(1:1))
      IF(K<48 .OR. K>57) GOTO 10
      K = 1
      DO I = 2,N-1 ! Count inputs in first line starting with an integer
        IF(CH(I:I)==' ' .AND. CH(I+1:I+1)/=' ') K = K+1
      END DO
      BACKSPACE J
      RETURN
50    WRITE(6,'(/" File ",A," is defective.")') F1
      END SUBROUTINE
C
      SUBROUTINE WAIT(N)
C  N < 0 calls for space before screen display
      IF(N>0) WRITE(6,'()')
      WRITE(6,'(" Hit RETURN to continue")')
      READ(5,'(A1)')
      RETURN
      END
C
      FUNCTION QFMT(F1)
C This determines the status of file F1, returning 'Y' if it is Formatted,
C 'N' if it is Not, and 'U' if it is Unknown (does not exist).
      CHARACTER QFMT, F1*(*)
      INQUIRE(FILE=F1,FORMATTED=QFMT)
      RETURN
      END
C
      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12, LST(12)*10
      COMMON /CF/ CF
      DATA LST/'January  7','February 8','March    5','April    5',
     +         'May      3','June     4','July     4','August   6',
     +         'September9','October  7','November 8','December 8'/
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48  ! M gets day of month
      READ(ZZZ(5:6),*) L; K = ICHAR(LST(L)(10:10))-48
      WORD = CF(:JF(M))//' '//LST(L)(:K)//' '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE
C
      FUNCTION RANDY()
C Use the compiler's random generator for a random number in the unit interval
      DATA NEW/1/
      SAVE NEW
      IF(NEW>0) THEN
        NEW = 0
        CALL RANDOM_SEED()
      END IF
      CALL RANDOM_NUMBER(RANDY)
      END FUNCTION
C
      FUNCTION TM(KSET)
C The value (real) returned by function TM is seconds since last timer reset.
C After this value is determined, the timer is reset if KSET > 0 but continues
C to accumulate if KSET = 0.
      SAVE PREV
      DATA PREV/0./
C       CALL SYSTEM_CLOCK(J,KR,KMAX)  ! Arguments are optional
C       J = tick count since zero; KR = ticks per second; KMAX = max count
C       In LF90 clock: KR = 100, KMAX = 8,640,000
      CALL SYSTEM_CLOCK(J)
      X = J*.01
      TM = X - PREV
      IF(TM < 0.) TM = TM + 86400
      IF(TM >= 16400.) TM = 0. ! Why this?? (Not in HYDATA copy)
      IF(KSET==0) RETURN
      PREV = X
      END FUNCTION

c====================================================================

C ##### Original IMSL code is in C:\IMSL\F3CTR.FOR

C MODA:  ( CY(NVV), CS(NV,NV+2), RR(NV), W(NVV), W1(NVV) )

C      MFAC=4 => MTH=3 calls Maximum Liklihood
C      MFAC=5 => MTH=2 calls generalized least squares

C  Arguments:
C     NY     - Number of variables.  (Input)
C     CY     - NY by NY matrix containing the variance-covariance
C                or correlation matrix.  (Input)
C     MY     - Leading dimension of CY exactly as specified in the
C                dimension statement in the calling program.  (Input)
C     NF     - Number of factors in the model.  (Input)
C     MTH    - Method used to obtain the estimates.  (Input)
C              MTH    Method
C                0    Principal component (principal component model) or
C                     principal factor (common factor model).  If INIT = 1
C                     and UNIQ contains zeros, solution is for principal
C                     components; otherwise, for principal factors.
C                1    Unweighted least squares (common factor model).
C                2    Generalized least squares (common factor model).
C                3    Maximum likelihood (common factor model).
C                4    Image factor analysis (common factor model).
C                5    Alpha factor analysis (common factor model).
C     NDF    - Number of degrees of freedom in COV.  (Input)
C              NDF is not required when MFAC = 0, 1, or 4.  NDF defaults to
C              100 if NDF = 0.  The formula for df in Mulaik (1972, p. 168) is
C                    df = [(n-r) -(n+r)]/2 = (n-r)(n-r-1)/2 - r
C              where n is sample size and r is number of factors.
C     IMAX   - Maximum number of iterations in the iterative
C              procedure.  (Input)
C              30 is typical for methods 1 to 3, while 60 is typical for
C              method 5.  IMAX is not referenced when MFAC = 0 or 4.
C     MAXSTP - Maximum number of step halvings allowed during any
C              one iteration.  (Input)
C              8 is typical.   Used only for MFAC = 2 or 3
C     EPS    - Convergence criterion used to terminate the iterations. (Input)
C              For methods 1 to 3, convergence is assumed when the
C              relative change in the criterion is less than EPS.  For
C              method 5, convergence is assumed when the maximum
C              change (relative to the variance) of a uniqueness is less
C              than EPS.  EPS is not referenced when IMTH=0 or 4.
C              EPS = 0.0001 is typical.
C     EPSE   - Convergence criterion used to switch to exact second
C              derivatives.  (Input)
C              When the largest relative change in the unique
C              standard deviation vector is less than EPSE, exact
C              second derivative vectors are used.  0.1 is typical.
C     UNIQ   - Vector of length NY containing the unique variances.
C              Input UNIQ contains the initial estimates of these
C              variances.  On output, UNIQ contains the estimated
C              unique variances.  MFAC = 0 assumes the unique
C              variances to be known and leaves them unchanged.
C     A      - NY by NF matrix of unrotated factor loadings.  (Output)
C     LDA    - Leading dimension of A exactly as specified in the
C              dimension statement of the calling program.  (Input)
C     EVAL   - Vector of length NY containing the eigenvalues of the
C              matrix from which the factors were extracted.  (Output)
C              If MFAC = 5 then the first NF positions of EVAL contain
C              the ALPHA coefficients.  Note that EVAL does not usually
C              contain eigenvalues for matrix COV.
C     DER    - Vector of length NY containing the parameter updates
C              when convergence was reached (or the iterations
C              terminated).  (Output) [I can't find any point to returning this]

C     STAT   - Vector of length 6 containing some output statistics.
C              (Output)  [deleted]
C                I   STAT(I)
C                1   Value of the function minimum.
C                2   Tucker reliability coefficient.
C                3   Chi-squared test statistic for testing that NF
C                    common factors are adequate for the data.
C                4   Degrees of freedom in chi-squared.  This is
C                    computed as ((NY-NF)**2-NY-NF)/2.
C                5   Probability of a greater chi-squared statistic.
C                6   Number of iterations.

C ******* Add screen report after each cycle

C     CALL MLFA(CY,KK,MFAC,RR,A,T,CS,CS,IER)
C       Return reproduction errors in T for copy to sym-storage W on return
C       NY and IMAX (input), and useless output ITER, are passed in COMMON

      SUBROUTINE MLFA(CY,NF,MFAC,UNIQ,A,EVEC,HESS,IER)
C                     ^Input of sym-storage Y-set covariances
C     IW     - Integer work vector of length NY.  (No longer needed)
C     CW     - Real work vector of length NY(NY+1)/2
C     WK     - Real work vector of length NY
C     WR     - Real work vector of length NY
C     OLD    - Real work vector of length NY
C     EVEC   - Real work vector of length NY*NY
C     HESS   - Real work vector of length NY*NY

      PARAMETER  (C2=1.0E-6, D2=-13.851 ) !, D3=-2.302585) ! D2 = Ln(C2)
      CHARACTER  CF*12, CH4*4, CLN*12, CH5*5
CC      REAL CY(*), UNIQ(*), A(NY,*), HESS(NY,*), EVEC(NY,NY), CNV(2,4)
      REAL CY(*), UNIQ(*), A(NY,*), HESS(NY,NY), EVEC(NY,NY), CNV(2,4)
      REAL EVAL(NY), DER(NY), OLD(NY), WK(NY), WR(NY), HOLD(NY,NY)
      DOUBLE PRECISION DTEMP, SSS, SUM, VVV
      DATA EPS,EPSE/.0001,.1/    ! <<<< Make interactively adjustable ???
      COMMON NY,ICYC,IMAX,TOL,SE,XE,RVAR,G,IB,JB,TIM,CNV
      COMMON /CF/ CF
      LO(I,J) = J*(J-1)/2 + I
      MTH = 7-MFAC
C      IF(MFAC==4) MTH = 3; IF(MFAC==5) MTH = 2; IF(MFAC==6) MTH = 1
      IF(MFAC<4 .OR. MFAC>6) THEN
        WRITE(6,'(/" Method",I2," is not implemented by subroutine ",
     +    "MLFA.")') MFAC; IER = 100; STOP  ! Possible only by programming error
      END IF
      IF(MFAC==4) WRITE(7,'(/" Details of MLFA solution for ",A,
     +  " common factors:")') CF(:JF(NF))
      IF(MFAC==5) WRITE(7,'(/" Details of GLS solution for ",A," comm",
     +  "on factors (ML code):")') CF(:JF(NF))
      IF(MFAC==6)   WRITE(7,'(/" Details of ML-code solution for ",A,
     +  "Principal Factors:")') CF(:JF(NF))
      EPS = .0001; EPSE = .10; MAXSTP = 8 ! Recommended settings
      CH5=' MLFA'; IF(MTH==2) CH5=' GLS '; IF(MTH==1) CH5=' IMSL'
      IER = 0; EVEC = 0.; I = TM(1)
C Initialize iteration
      IHTYPE = 0   !  IHTYPE <= 1 when  ZER  < EPSE, which is convergence
      F0 = 3.402E38
CC      F0 = AMACH(2) = B**EMAX*(1 - B**(-T)) = 3.40204E38, the largest magnitude.

      DO J = 1,NY
        DO I = 1,J
          HESS(I,J) = CY(LO(I,J)); HESS(J,I) = HESS(I,J)
        END DO              !      ^ Don't need lower triangle, but do for principle
        WK(J) = HESS(J,J)   ! Save diagonal of CY in WK (updated by DER at Label 340)
      END DO

C             Compute factored covariance matrix.
      TTOL = 5.962E-6   ! TTOL = 100*AMACH(3)   ! Double-T avoids changing TOL in COMMON
C           AMACH(3) = B**(-T) = 5.96184E-8, the smallest relative spacing.

C  Put inverse of Gramian CY (in EVEC) into HESS
      CALL EIGS(NY,NY,HESS,NY,WR,EVEC,NY,NY,JER,7)  ! JOB=NY calls return of Inv[HESS]
      IER = ABS(JER)
      IF(JER<0) THEN
        CH4 = 'n). '; IF(IER>1) CH4 = 'ns).'
        WRITE(6,'(/" ***> MLFA aborts job on input it takes to be ",
     +    "ill-conditioned in ",A," dimensio",A)') CF(:JF(IER)), CH4
        WRITE(7,'(/" ***> MLFA aborts job on input it takes to be ",
     +    "ill-conditioned in ",A," dimensio",A)') CF(:JF(IER)), CH4
        RETURN
      END IF
C >>> Initial HESS is the the inverse of the input CY
      DO I = 1,NY    ! Unique error initial estimates
        UNIQ(I) = MAX(0.,MIN(UNIQ(I),CY(LO(I,I))))
C        IF(MTH==5) CYCLE  ! Not implementead
        IF(MTH==1) UNIQ(I) = SQRT(UNIQ(I))
        IF(MTH>1) UNIQ(I) = LOG(UNIQ(I))   !  Transform UNIQ
      END DO
      ITER = 0
      DO I = 1,NY  ! Save UNIQ in OLD
        OLD(I) =  UNIQ(I)
      END DO

      HOLD = HESS
CCC Save initial HESS in direct-access file 16.  It does not change hereafter
CCC and rows wanted are called from file
CC        OPEN(16,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
CC       +  RECL=4*(NY+2))
CC        DO I = 1,NY
CC          WRITE(16,REC=I) (HESS(I,J),J=1,NY)
CC        END DO

C Iterations start here for HESS retrieval
C                     Begin factoring the S matrix  ( S is COV? )
50    ISTEP = 0   !!! Start main iteration loop; ends just before Label 370
C                     ISTEP doesn't seem to change much; most is in ITER
C                 Calculate the adjusted matrix
60    IF(MTH==1) THEN
        DO I = 1,NY   ! Reinitialize HESS with startup HESS ( = Inv(CY) for MTH > 1 )
          DO J = 1,I                ! UNIQ holds Unique var for MTH=5
            HESS(J,I) = CY(LO(J,I)) !   "    "     "    SD for MTH=1
          END DO                    !   "    "   log Unique var for MTH 2,3,4
          HESS(I,I) = HESS(I,I) - UNIQ(I)*UNIQ(I)
        END DO
      ELSE
        HESS = HOLD
CC          READ(16,REC=I) (HESS(I,J),J=1,NY)  ! Retrieve Inv[CY]
      END IF
C                        Scale the matrix
      IF(MTH>1) THEN
        DO J = 1,NY         ! For MTH=2,3,4, rescale each item's HESS terms
          IF(MTH==5) THEN   !    to equalize its estimated uniqunesses
            TMP = 1.0/SQRT(MAX(1.0E-12,CY(LO(J,J))-UNIQ(J))) !  Need only diagonal of CY
          ELSE ! MTH = 2,3,4
            TMP = EXP(UNIQ(J)/2.)   ! Estimated uniqueness SD
          END IF
          DO I = 1,J  ! Only need the upper triangle for EIGS call
            HESS(I,J) = TMP*HESS(I,J)  ! Multiply because Hess is inverse of CY
            HESS(J,I) = HESS(I,J)  ! Need for bug search
          END DO
          DO K = J,NY
            HESS(J,K) = TMP*HESS(J,K)
            HESS(K,J) = HESS(J,K)  ! Need for bug search
          END DO
        END DO
      END IF
C        Calculate the eigenvalues of Inv[HESS(U)] { unit-uniqueness rescaling }
C        NOTE: If EIGS fails for any one choice of NF, it fails for all
      CALL EIGS(NY,NY,HESS,NY,EVAL,EVEC,NY,1,IER,7)
      IER = 0
      DO J = 1,NY   ! Test whether any eigvec is returned as all zero
        S = 0       ! (IER will count number of nonconvergent eigvecs)
        DO I = 1,NY
          S = S + EVEC(I,J)**2
        END DO
        IF(S<.1) IER = IER+1
      END DO
      IF(IER/=0) WRITE(6,'(/" MLFA gets a Hessian with ",A,
     +  " nonconvergent eigenvectors.  No go.")') CF(:JF(IER))
      IF(IER/=0) GOTO 420  ! Err 4: IER = J flags nonconvergence of J eigenvectors.
C  For MTH = 2,3,4, put eivals/vecs in ascending order (so descending when inverted)
C  EIGS call is on Inv(CY-U), so ascending is the order of decreasing eigs of CY-U
C  while EVAL(j) is inverse of jth eigenvalue of CY-U
      IF(MTH==1) GOTO 75
      DO J = 1,NY/2
        Z = EVAL(J); EVAL(J) = EVAL(NY+1-J); EVAL(NY+1-J) = Z
      END DO
      DO I = 1,NY
        DO J = 1,NY/2
          Z = EVEC(I,J); EVEC(I,J) = EVEC(I,NY+1-J); EVEC(I,NY+1-J) = Z
        END DO
      END DO
C      IF(MTH==0.OR.MTH==4) GOTO 370  ! Exit for the non-iterative methods
C      [ Large block of code ending MTH=5 (Alpha factoring) deleted here ] (F3CTR lines 256 - 312

C                  First derivatives of the ml methods
75    DO I = 1,NY
        DTEMP = 0.0D0
        DO J = NF+1,NY
          IF(MTH==1) THEN
            SSS = EVAL(J)
          ELSE IF(MTH==2) THEN
            EVAL(J) = MIN(EVAL(J),SQRT(3.40204E36))
ccc           EVAL(J) = MIN( EVAL(J),SQRT(AMACH(2)/100.0) )
ccc           AMACH(2) = B**EMAX*(1 - B**(-T)) = 3.40204E38, the largest magnitude.
            SSS = EVAL(J)*(EVAL(J)-1.0D0)
          ELSE IF(MTH==3) THEN           ! Eval(j) is jth eigval of Inv(CY-U)
            SSS = 1.0D0 - 1.0D0/EVAL(J)  ! so 1/Eval(j) is jth eigval of CY-U
          END IF
          DTEMP = DTEMP + SSS*EVEC(I,J)**2  ! The eigstuff part of formula
        END DO                              ! 7-80 in Mulaik p. 166
        IF(MTH==1) THEN
          DER(I) = -2.0*UNIQ(I)*DTEMP
        ELSE
          DER(I) = DTEMP   ! DER abbreviates "derivative"
        END IF
      END DO
C                        Evaluate Loss function to be minimized
      DTEMP = .0D0
      DO J = NF+1,NY
        IF(MTH==1) THEN
          DTEMP = DTEMP + EVAL(J)**2
        ELSE IF(MTH==2) THEN
          DTEMP = DTEMP + (EVAL(J)-1.0D0)**2
        ELSE IF(MTH==3) THEN  ! Core of Mulaik formula 7-78, p. 166
          DTEMP = DTEMP + 1.0D0/EVAL(J) + LOG(EVAL(J)) ! Note: ln(e) = -ln(1/e)
        END IF     ! except that Mulaik has eval rather than presnt 1/eval
      END DO
C
      IF(MTH/=3) THEN
        F = .5D0*DTEMP
      ELSE   ! Mulaik's value
        F = DTEMP + (NF-NY)
      END IF
C                            Is new Loss better?
      IF(ABS(F0)>1.0) THEN    ! F0 is huge just on 1st cycle, whence
        ZER = (F0-F)/F0      !    1st-cycle ZER = 1.0.
      ELSE                    ! ZER is called T57 in original code
        ZER = F0 - F
      END IF
      IF(ZER>=.0) THEN
        F0 = F
        DO I = 1,NY        ! Save unique SDs
          OLD(I) = UNIQ(I)
        END DO
      ELSE IF(ABS(ZER)>EPS) THEN      !  Step halving
        ISTEP = ISTEP + 1
        DSTEP = 0.5**ISTEP
        IF(ISTEP>MAXSTP) THEN
cc          WRITE(7,'(/" MLFA factoring reaches halving limit; conv",
cc     +      "ergence presumed.")')
          GOTO 370  ! Exit
        END IF
        DO I = 1,NY  !!! Line 334 in MLFA.FOR; Line 376 in F3CTR
          UNIQ(I) = OLD(I) - DSTEP*WK(I)  ! WK from L. 3152 below on prior loop on label 50
          IF(MTH==1) UNIQ(I) = MAX(UNIQ(I),C2)  ! C2 = 1.0E-6
          IF(MTH/=1) UNIQ(I) = MAX(UNIQ(I),D2)  ! D2 = -13.851 = Log(C2)
        END DO
        GOTO 60   ! Only loop back to 60
      END IF
      ITER = ITER + 1; ICYC = ITER
      IF(ITER>IMAX) THEN
        WRITE(6,'(/" MLFA factoring reaches iteration limit; conv",
     +    "ergence presumed.")')
         GOTO 370   ! Exit    ! *** NOTE: Last solution for EVEC is checked
      END IF                  !     on exit for nonconvergence
      IF(ZER<EPS) GOTO 370    ! Exit; convergence attained
C
      IF(IHTYPE==0) THEN        ! Approximate second derivatives
        WRITE(6,'(6X,"Iteration ",A," by approximate Hessian (fast)")')
     +    CF(:JF(ITER))
        DO I = 1,NY
          DO J = 1,I
            HESS(J,I) = 0.
            DO K = NF+1,NY
              HESS(J,I) = HESS(J,I) + (EVEC(I,K)*EVEC(J,K))
            END DO
              HESS(J,I) = HESS(J,I)**2; HESS(I,J) = HESS(J,I)
          END DO
        END DO
        IF(MTH==1) THEN
          DO I = 1,NY
            DO J = 1,I
              HESS(I,J) = 2.*OLD(I)*HESS(I,J)
            END DO
            DO J = I,NY   ! J = 1,NY-I+1
              HESS(I,J) = 2.*OLD(I)*HESS(I,J)
            END DO
          END DO
        END IF
        GO TO 340
      END IF
C            IHTYPE = 1: exact Hessian
      WRITE(6,'(6X,"Iteration ",A," by exact Hessian (slow - be pati",
     +  "ent)")') CF(:JF(ITER))
      IF(MTH==1) THEN                ! Exact for MTH=1
        DOI = 1, NY
          VVV = UNIQ(I); SAVE = VVV**2; VVV = 4.0D0*VVV
          DO J = 1,I
            DTEMP = 0.
            DO M = NF+1,NY
              SUM = 0.
              DO N = 1,NF
                SUM = SUM + (EVEC(I,N)*EVEC(J,N)*(EVAL(M)+EVAL(N)))/
     +            (EVAL(M)-EVAL(N))
              END DO
              DTEMP = DTEMP + SUM*EVEC(I,M)*EVEC(J,M)
            END DO
            HESS(J,I) = VVV*UNIQ(J)*DTEMP; HESS(I,J) = HESS(J,I)
          END DO
          DTEMP = HESS(I,I)
          DO J = NF+1,NY
            DTEMP = DTEMP + 4.0D0*(SAVE-EVAL(J)*0.5D0)*EVEC(I,J)**2
          END DO
          HESS(I,I) = DTEMP
        END DO
      ELSE IF(MTH==2.OR.MTH==3) THEN   ! Hessian exact for MTH=2 or 3
        IF(MTH==3) THEN
          DD = -1.0
        ELSE
          DD = 1.0
          DO J = 1,NY
            S = SQRT(EVAL(J))  ! Improved efficiency over original code
            DO I = 1,NY  ! Multiply Jth eigenvector by SQRT of eigenvalue
              EVEC(I,J) = S*EVEC(I,J)
            END DO
          END DO
        END IF
        DO I = 1,NY     ! I indexes columns of HESS in inner loop
          DO J = 1,I
            IF(MTH==2) THEN
               SSS = HOLD(I,J)*EXP((UNIQ(I)+UNIQ(J))/2.0)
C                      ^ COVI in original code = original Inv(CY) stored in scratchfile 16
C              HESS has changed above, so can't be COVI here.
            ELSE
               SSS = .0; IF(I==J) SSS =  1.0
            END IF
            DTEMP = .0D0
            DO M = NF+1,NY
              VVV = EVAL(M)   ! Would crash if EVAL(M) = EVAL(N);
              SUM = SSS       ! however, N  NF < M
              DO N = 1,NF
                SUM = SUM + EVEC(I,N)*EVEC(J,N)*(-2.0D0+VVV+
     +                      EVAL(N))/(VVV-EVAL(N))
              END DO
              DTEMP = DTEMP + SUM*EVEC(I,M)*EVEC(J,M)
            END DO
          HESS(J,I) = DTEMP  ! Starting HESS for exact 2nd-derivative solution
          HESS(I,J) = DTEMP  ! Shouldn't be needed except for bug search
          END DO
          HESS(I,I) = HESS(I,I) + DD*DER(I)  ! Diagonal of starting 2nd-der Hess
        END DO
        IF(MTH==2) THEN
          DO J = 1,NY
            S = SQRT(MAX(1.E-35,EVAL(J)))
            DO I = 1,NY
              EVEC(I,J) = EVEC(I,J)/S
            END DO
          END DO
        END IF
      END IF
C
340   DO I = 1,NY    ! Label 340 used only by MTH 1
        WK(I) = DER(I)
      END DO
      K = 1
      DO J = 2,NY   ! Find index of the largest diagonal element in HESS
        IF(HESS(J,J)>HESS(K,K)) K = J
      END DO
      DD = TTOL*HESS(K,K); IER = 0
      DO I = 1,NY   ! Add DD to each diagonal term of HESS
        HESS(I,I) = HESS(I,I) + DD
      END DO
cc      IF(IHTYPE/=0) THEN  ! The 2nd of two places where IHTYPE has an effect
cc        DO I = 1,NY
cc          IF(HESS(I,I)<0.) THEN   ! ******* Here is where the crashes occur
cc            IER = IER - 1         ! But if this is to avoid ill-conditioned
cc          END IF                  ! HESS, EIGS now accomodates that
cc        END DO
cc        IF(IER<0) GOTO 344
cc      END IF
C Replace d(er) by Inv(HESS)d    !! See Mulaik, p.154 (7-56)
      CALL EIGS(NY,NY,HESS,NY,WR,EVEC,NY,NY,IER,7)  ! JOB=NY calls return of Inv[HESS]
      WK = DER; DER = 0.      !   ^ Checked at exit for nonconvergence
      DO I = 1,NY
        DO J = 1,NY
          DER(I) = DER(I) + HESS(I,J)*WK(J)
        END DO
      END DO
344   IF(IER/=0) THEN
        CH4 = 'MLFA'; IF(MTH==2) CH4 = ' GLS'
        DO K = 6,7
          WRITE(K,'(/1X,A," solution aborts on iteration ",A," due to",
     +      " unusable Hessian")') CH4(:MTH+1), CF(:JF(ITER))
          IF(IER==1)WRITE(K,'(6X,"(failure of eigvector convergence)")')
          IF(IER==2) WRITE(K,'(6X,"(failure of eigvalue convergence)")')
          IF(IER<0) WRITE(K,'(6X,"(ill-conditioned in ",A," dimensi",
     +      "ons")') CF(:JF(-IER))
        END DO
        GOTO 400
      END IF
      DO I = 1,NY  ! Update unique error variances
C**        IF(HESS(I,I)==0.0) THEN   !  Set DER to 0.0 if singular
C**          DER(I) = 0.0        !  HESS no longer as before; need to save
C**        END IF                !    its diag before inversion if still needed
        WK(I) = DER(I)  !  Used on L. 2998 of next loop on label 50
        UNIQ(I) = OLD(I) - DER(I)
        SSS = D2; IF(MTH==1) SSS = C2  ! Keep from getting too small
        UNIQ(I) = MAX(UNIQ(I),SSS/CY(LO(I,I)))
      END DO

C           Set IHTYPE: 1 when nearly convergent; 0 otherwise
      IHTYPE = 0; IF(ZER<EPSE) IHTYPE = 1
CC      WRITE(6,'(12X,"Iteration ",A," completed.")')  CF(:JF(ITER))
      GOTO 50   ! Iterate again
C ***** No more iterations *****
C                      Scale loading matrix
370   DO J = 1,NF
        DD = 0.       ! Put DD equal to inverse of the Jth eigenvector's
        DO I = 1,NY   ! euclidian length (should always equal 1.0??)
          DD = DD + EVEC(I,J)**2
        END DO
        DD = 1/SQRT(DD)
        IF(EVAL(J)<=0.0) THEN
          WRITE(6,'(/4X,"ML solution for ",A," factors crashes after ",
     +      A," leading axes yielded acceptable"/4X,"eigenvalues.  Tr",
     +      "y again with fewer factors.")') CF(:JF(NF)), CF(:JF(J))
          IER = J
          GOTO 420
        END IF
        IF(MTH<=1) THEN
          DD = DD*SQRT(EVAL(J))
        ELSE IF(MTH/=4) THEN
          DD = DD*SQRT(1.0/EVAL(J)-1.0)
        ELSE
          DD = DD*(1.0/EVAL(J)-1.0)*SQRT(EVAL(J))
        END IF
        DO I = 1,NY
          EVEC(I,J) = DD*EVEC(I,J)
          A(I,J) = EVEC(I,J)      ! Only specification of A (J=1,NF)
        END DO                    ! A is the pattern solution
      END DO
C
      IF(MTH>1) THEN
        DO I = 1,NY
          DD = EXP(UNIQ(I)/2.0)
          WK(I) = DD
          DO J = 1,NF
            A(I,J) = DD*A(I,J)
          END DO
        END DO
        DO I = 1,NY   !  Put squared elements of WK into UNIQ
          UNIQ(I) = WK(I)**2
        END DO
      ELSE IF(MTH<=1) THEN
        DO I = 1,NY  ! Replace UNIQ with its elements squared
          UNIQ(I) = UNIQ(I)**2
        END DO
      END IF
      IF(MTH==0 .OR. MTH==4) GOTO 420
400   DO I = 1,NY
        DD = OLD(I)
        IF(MTH<=1) THEN
          DD = MAX(0.,DD); UNIQ(I) = DD**2
        ELSE
          DD = MAX(D2,DD); UNIQ(I) = EXP(DD)
        END IF
      END DO
420   CLOSE(16); IF(IER>0) RETURN

C Examine accuracy of CY reproduction
      SE = 0.; XE = 0.; RVAR = 0.  ! Returned in COMMON
      DO J = 1,NY
        DO I = 1,J
          S = 0.
          DO K = 1,NF
            S = S + A(I,K)*A(J,K)
          END DO
          S = CY(LO(I,J)) - S
          EVEC(I,J) = S     !   <<<< Return errors of reproduction
          IF(I==J) THEN
            RVAR = RVAR + S
            CYCLE
          END IF
          S = ABS(S)
          SE = SE + S*S
          IF(S<=XE) CYCLE
          XE = S; IB = I; JB = J
        END DO
      END DO
      SE = SQRT(SE/(NY*(NY-1)/2))
      WRITE(6,'(I3,A," factors: <Stand.Err/Max.Err/Resid.Var> = <",
     +  A4, ",",A5,",",A6,">")') NF, CH5, CLN(SE,4,3), CLN(XE,5,3),
     +  CLN(RVAR,6,2)
      TIM = TM(1)
      END SUBROUTINE

C =======================================================================

      SUBROUTINE FIXCOV(NY,NYY,NR,CY,RR,T,YSET,SMAL,JB)
C Tidy up ill-conditioned covariance matrix CY: Replace NY-NR unacceptable
C roots by zero and renorm to input variances in CY.  (Replacement by SMAL > 0
C sometimes results in bizarre failure.)
      CHARACTER CF*12, CLN*8
      INTEGER LST(NYY), ITS(NY), YSET(*)
      REAL CY(NYY), T(NY,NY), RR(NY),R(NY), CC(NYY), TT(NY,NY), A(NY,NY)
      DOUBLE PRECISION S   !, RS(NY)
      COMMON /CF/ CF
      EXTERNAL SCAN
      LO(I,J) = J*(J-1)/2 + I
      TT = T; END = RR(NY)   ! ; RS = RR
10    KK = 3
12    KK = KK+1
      NOK = NY+2
14    NOK = NOK-1  ! Index of largest not OK, scanned backward in scree
      IF(RR(NOK-1)<=0.) GOTO 14
      NGOOD = NOK-1; NBAD = NY-NGOOD
      IF(NBAD>KK) GOTO 12
      IF(NY>100) WRITE(6,'(" Covariance problems encountered: Be pat",
     +  "ient while details are diagnosed.")')
CC      DO J = 1,NBAD  ! Need this if SMAL > 0;
CC        RS(NGOOD+J) = SMAL
CC      END DO
      DO J = 1,NGOOD    ! ****** Is this worth doing in double precision???
        S = SQRT(RR(J))
        DO I = 1,NY     ! With noniterated SMAL=0, can use T rather than TT
          A(I,J) = SNGL(TT(I,J)*S)
        END DO
      END DO
      DO I = 1,NY
        S = 0.; VI = CY(LO(I,I)); CC(LO(I,I)) = VI  ! Generally, VI < 1 when
        DO K = 1,NGOOD                              ! there are X-set items,
          S = S + A(I,K)**2
        END DO
        S = SQRT(VI/S)
        DO K = 1,NGOOD
          A(I,K) = SNGL(S*A(I,K))  ! Restore received Y-variances
        END DO
      END DO
      DO J = 2,NY
        DO I = 1,J-1; CC(LO(I,J)) = 0.
          DO K = 1,NGOOD
            CC(LO(I,J)) = CC(LO(I,J)) + A(I,K)*A(J,K)
          END DO
        END DO
      END DO
      CALL EIGS(NY,NY,CC,NYY,R,TT,NY,1,IER,7)  ! Need eivecs for Option 3
      D = 0.
      DO I = 1,NY
        D = MAX(D,ABS(CY(LO(I,I))-CC(LO(I,I))))
      END DO
      BIG = 0.; SQ = 0.; LST = 0; ITS = 0
      DO J = 2,NY            !  J = 2,NY  after TEST above is deleted
        DO I = 1,J-1         !  I = 1,J-1
          D = ABS(CY(LO(I,J))-CC(LO(I,J))); SQ = SQ + D*D
          LST(LO(I,J)) = NINT(D*1000)*10**6 + YSET(J)*10**3 + YSET(I)
          IF(D>BIG) BIG = D
          N = NINT(D*1000)**2; ITS(J) = ITS(J)+N; ITS(I) = ITS(I)+N
        END DO
      END DO
      NY0 = NYY-NY; SQ = SQRT(SQ/NY0)
      DO I = 1,NY
        S = SQRT( ITS(I)*1./(NY-1) )
        ITS(I) = NINT(S)*1000 + I
      END DO
      CUT = .0001*INT(BIG*5000); MM = 10
      CALL ISORT(NYY,LST); CALL ISORT(NY,ITS)  ! <<< major time consumer
      KOUNT = 0; K = 0
20    K = K+1; IF(LST(K)/10.**9>CUT) KOUNT=KOUNT+1; IF(K<NYY) GOTO 20

c  WARNING:
c     The covariance matrix Cyy ready to factor here is ill-conditioned,
C     presumably due to inclusion of partial records when computing
C     covariances from the raw data.  This is no problem for principal
c     factoring but precludes maximum-likelihood solutions and may
c     degrade Minres results.               [ Hit RETURN to continue.]

c You can deal with this situation in several ways:
C 1   Continue factoring this unadjusted Cyy with smallest eigenvalue .xxxx
c 2.  Quit this run and recompute the covariances after using FIXDATA or
c       some other imputation program to estmate the missing scores.
c 3.  Continue this run with Cyy replaced by a well-conditioned approximation
c       that changes xxx out of xxx covariances by more than xxx.  The xx
c       largest changes, with item indices shown in brackets, would be
C           .xx[nnn,nnn] .xx[nnn,nnn] .xx[nnn,nnn] .xx[nnn,nnn] .xx[nnn,nnn]
c 4.  Return to item selection and exclude items whose covariances appear most
c       troubled by ill-conditioning in the change listing above.
C N.  Increase the number of largest-changes listed here from xx to N

      WRITE(6,'(/"  WARNING:"/5X,"The covariance matrix Cyy ready to ",
     +  "factor here is ill-conditioned,"/5X,"presumably due to inclu",
     +  "sion of partial records when computing"/5X,"covariances from",
     +  " the raw data.  This is no problem for principal",/5X,"facto",
     +  "ring but precludes maximum-likelihood solutions and may"/5X,
     +  "degrade Minres results.",14X,"[ Hit RETURN to continue. ]")')
      READ(5,'()')
51    WRITE(6,'(" You can deal with this complication in several ways",
     +  ":"/" 1.  Continue factoring this unadjusted Cyy with smalles",
     +  "t eigenvalue ",A5,"."/" 2.  Quit this MODA run and recompute",
     +  " the covariances after using FIXDATA"/7X,"or some other impu",
     +  "tation program to estimate the missing scores."/" 3.  Contin",
     +  "ue this run with Cyy replaced by a well-conditioned approxim",
     +  "ation"/7X,"that changes ",A," out of ",A," covariances by mo",
     +  "re than ",A4,".  The ",A/7X,"largest changes, with item indi",
     +  "ces shown in brackets, will be")') CLN(RR(NY),5,4),
     +  CF(:JF(KOUNT)), CF(:JF(NY0)), CLN(CUT,4,3), CF(:JF(MM))
      WRITE(6,'(10(9X,5(A3,"[",A,",",A,"]  "):/))')
     +  (CLN(LST(K)/10.**9,3,2), CF(:JF(MOD(LST(K),10**6)/10**3)),
     +  CF(:JF(MOD(LST(K),10**3))), K=1,MM)
      WRITE(6,'(" 4.  Return to item selection and exclude items whos",
     +  "e covariances appear most"/7X,"disturbed by ill-conditioning",
     +  " in the change listing above.  Measuring"/7X,"this for each ",
     +  "item by the RMS change that Option 3 would induce in its"/7X,
     +  "covariances with the other Y-set items, the input indices o",
     +  "f the "/7X,A," most disturbed items (each followed in brack",
     +  "ets by its"/7X,"disturbance rating) are")') CF(:JF(MM))
      WRITE(6,'(10(9X,6(A,"[",A4,"]  "):/))') (CF(:JF(YSET(MOD(ITS(K),
     +  10**3)))), CLN(ITS(K)/10.**6,4,3), K=1,MM)
      WRITE(6,'(" N.  Increase the number of largest-changes listed ",
     +  "here from ",A," to N."/)') CF(:JF(MM))
55    WRITE(6,'(7X,"Enter one of option indices 1,2,3,4 or, to see ",
     +  "more information"/7X,"on Option 3, the number N of largest",
     +  " changes to show."/)')
      CALL SCAN(J,1,'I',5)
      IF(J/=1) GOTO 55; JB = 0
      READ(2,*) N; N = MIN(100,MAX(1,N))
      IF(N==1) THEN
        WRITE(7,'(/" The Cyy matrix factored here is ill-conditioned;",
     +    " its smallest eigenvalue is ",A5)') CLN(RR(NY),5,4)
        WRITE(6,'(/" Continuing with ill-conditioned covariances.")')
        RETURN
      ELSE IF(N==2) THEN
        GOTO 60
      ELSE IF(N==3) THEN
        CY = CC; NR = NY; RR = R ! ; T = TT
        K = MOD(LST(1),10**6)/10**3; L = MOD(LST(1),10**3)
        WRITE(6,'(/" Continuing after adjustment with well-condition",
     +    "ed covariances.")')
        WRITE(7,'(/" The matrix selected for factoring, ill-condition",
     +    "ed with smallest eigenvalue"/1X,A6,", was adjusted by inc",
     +    "reasing its negative roots to zero.  The RMS"/" covariance",
     +    " change was ",A5,", with largest change ",A5," (items ",A,
     +    ",",A,"),"/" and ",A," out of ",A," exceeding ",A5,".")')
     +    CLN(END,6,5), CLN(SQ,5,4), CLN(BIG,5,4), CF(:JF(K)),
     +    CF(:JF(L)), CF(:JF(KOUNT)), CF(:JF(NY0)), CLN(CUT,5,4)
        RETURN
      ELSE IF(N==4) THEN
        JB = 1; GOTO 60
      ELSE
        MM = MIN(100,MAX(MM+1,N)); GOTO 51
      END IF
60    WRITE(7,'(/" The matrix whose factoring here has been aborted i",
     +  "s ill-condiioned (smallest"/" eigenvalue, ",A5,").  Its repl",
     +  "acment by a well-conditioned approximation would"/" have cha",
     +  "nged ",A," out of ",A," covariances by ",A3," or more.  The ",
     +  A," largest"/" changes, with item indices shown in brackets, ",
     +  "would have been")') CLN(RR(NY),5,4), CF(:JF(KOUNT)),
     +  CF(:JF(NY0)), CLN(CUT,3,2), CF(:JF(MM))
      WRITE(7,'(50(4X,6(A3,"[",A,",",A,"]  "):/))')
     +  (CLN(LST(K)/10.**9,3,2), CF(:JF(MOD(LST(K),10**6)/10**3)),
     +  CF(:JF(MOD(LST(K),10**3))), K=1,MM)
      WRITE(7,'(/" Measuring each item''s ill-conditioning disturbanc",
     +  "e by the RMS change that"/" this replacement would have indu"
     +  "ced in its covariances with the other Y-set"/" items, the in",
     +  "put indices of the ",A," most disturbed items (each followed",
     +  " in"/" brackets by its disturbance rating) are")') CF(:JF(MM))
      WRITE(7,'(10(4X,7(A,"[",A4,"]  "):/))') (CF(:JF(YSET(MOD(ITS(K),
     +  10**3)))), CLN(ITS(K)/10.**6,4,3), K=1,MM)
      IF(N==4) WRITE(7,'(/" Factoring will continue with exclusion",
     +  " of some pick of the most disturbed items."/80("")/)')
      IF(N==4) RETURN
      STOP
      END SUBROUTINE

