C          PROGRAM "ORDER".  (Source code, FORTRAN-90,)
C
C                 Last revised: 2 October 2002
C
C This receives from keyboard a list of node-index pairs interpreted as a
C binary order linkage from the 1st to the 2nd node in each pair; adds
C whatever additional linkages are needed to make the relation explicitly
C transitive; checks the relation for equivalence-groups of nodes; and
C reports the resultant partial ordering after selecting one node index
C to represnt each equivalence group.
      LOGICAL QY
      CHARACTER LBR, RBR, BL, WORD*999, CH1, CH8*8, CF*12, F1*9
CC      INTEGER PR(MV,2),LST1(MV),LST2(MV),MAP1(MV),MAP2(MV),KTL(MV,MV)
      INTEGER,ALLOCATABLE:: KTL(:,:), LST(:), LST1(:), LST2(:),
     +                      MAP1(:), MAP2(:), PR(:,:)
      EXTERNAL SCAN
      COMMON /CF/ CF
      DATA  BL/' '/, LBR/'['/, RBR/']'/, MV/100/
      OPEN(2,FILE='SCRATCH')
      OPEN(7,FILE='ORDER.SEE')
      NP = 0; F1 = 'ORDER.DAT'
      INQUIRE(FILE=F1,EXIST=QY)

c                Welcome to utility program ORDER.
c  INPUT: You are here to enter a set of paired positive integers taken to
c  stand for the nodes in a directed graph.  You will enter these pairs in
c  arbitrary order by typing one or more lines of input in which entry
c         ( previous pairs)  I J, K L,  (subsequent pairs)
c is interpreted by ORDER as declaring a direct paths => from node I to node
c J and from node K to node L.  The same node can be listed repeatedly if it
c is on more than one direct path.  Punctuation between pairs is optional,
c but will help you notice entry errors.

c OUTPUT: If your node indices can be ordered in a sequence wherein no
c direct or indirect path can be traced from any node to another one prior
c to it in the sequence, ORDER will identify one such sequence and indicate
c its sections wherein the order is arbitrary.  Whereas if your nodes cannot
c be so-ordered, you will be advised where loops occur.

C TEST LINES
CC      OPEN(21,FILE='JUNK')

      WRITE(6,'(16X,"Welcome to utility program ORDER."//" INPUT: You ",
     +  "are here to enter a set of paired positive integers taken to"/
     +  " stand for the nodes in a directed graph.  You will enter th",
     +  "ese pairs in"/" arbitrary order by typing one or more lines ",
     +  "of input in which entry"//9X,"( previous pairs)  I J, K L, ",
     +  "  (subsequent pairs)"//" is interpreted by ORDER as declarin",
     +  "g a direct path => from node I to node"/" J and from node K",
     +  " to node L.  The same node can be listed repeatedly if it"/
     +  " is on more than one direct path.  Punctuation between pairs",
     +  " is optional,"/" but will help you notice entry errors."/)')
      WRITE(6,'(" OUTPUT: If your node indices can be ordered in a se",
     +  "quence wherein no"/" direct or indirect path can be traced f",
     +   "rom any node to another one prior"/" to it in the sequence,",
     +   " ORDER will identify one such sequence and indicate"/" its ",
     +   "sections wherein the order is arbitrary.  Whereas if your ",
     +   "nodes cannot"/" be so ordered, you will be advised where lo",
     +   "ops occur.  Indices in a"/" closed loop will be called an",
     +   " ""equivalence group"".")')

10    WRITE(6,'(/7X,"If ",A," is larger than any node index you inte",
     +  "nd to enter,"/7X,"hit RETURN. Otherwise, enter another uppe",
     +  "r-bound on this."/)') CF(:JF(MV))
      CALL SCAN(J,0,'I',5)
      IF(J>0) THEN
        READ(2,*) MV; MV = MAX(10,MIN(999,MV)); GOTO 10
      END IF
      ALLOCATE ( LST(MV), KTL(MV,MV), MAP1(MV), MAP2(MV), PR(MV,2) )
      IF(.NOT.QY) GOTO 30
      WRITE(6,'(/" Enter anything if you would like to reload the la",
     +  "st set of index pairs you"/" examined.  (It can be revised).",
     +  "  Otherwise, hit RETURN to start afresh.")')
      CALL SCAN(J,0,'B',5); IF(J==0) GOTO 30
      OPEN(9,FILE=F1)
      READ(9,*,ERR=30) KV, NP, (LST(I),I=1,NP)
      CLOSE(9)
      IF(KV>MV) THEN
        MV = KV; DEALLOCATE ( PR, MAP1, MAP2, KTL )
        ALLOCATE ( PR(MV,2), LST(MV), MAP1(MV), MAP2(MV), KTL(MV,MV) )
      END IF
      GOTO 40
30    WRITE(6,'(/" Enter one or more pairs of node indices such that ",
     +  "the first path-precedes"/" (connects by => to) the second.  ",
     +  "If you have already entered a pair that"/" you now want to ",
     +  "delete, enter it with a minus sign on one of its terms.")')
      IF(NP>0) WRITE(6,'(" To start over, enter any letter.")')
      WRITE(6,'()'); CALL SCAN(J,0,'I',5)
      IF(J>0) GOTO 31
      NP = 0; GOTO 30    ! Reset count of entries to zero
31    IF(MOD(J,2).NE. 0) THEN; WRITE(6,'(/" Your entries are not all",
     +  " paired.  Try again.")'); GOTO 30; END IF
      N = J/2
      READ(2,*) ((PR(I,J),J=1,2),I=NP+1,NP+N)
      L = NP; NP = NP+N
      DO K = L+1,NP
        NN = 1000*MIN(ABS(PR(K,1)),MV) + MIN(ABS(PR(K,2)),MV)
        IF(PR(K,1)>0 .AND. PR(K,2)>0) THEN
          LST(K) = NN
        ELSE; LST(K) = 0
          DO I = 1,L
            IF(LST(I)==NN) LST(I) = 0
          END DO
        END IF
      END DO
35    WRITE(6,'(/"  Add/delete more index pairs, or hit RETURN to see ",
     +  "your current listing.")')
      CALL SCAN(J,0,'I',5)
      IF(J<0) GOTO 35
      IF(J>0) GOTO 31   ! Read additional entries
      CALL ISORT(NP,LST); ND = 0  ! Tidy up the list order
      DO J = NP,2,-1  ! Eliminate any duplicates or self-pairs
        IF(LST(J)==LST(J-1) .OR. LST(J)/1000==MOD(LST(J),1000)) THEN
          LST(J) = 0; ND = ND+1
        END IF      ! ^ Number to delete
      END DO
      IF(ND>0) THEN; N = NP; NP = 0
        DO I = 1,N
          IF(LST(I)/=0) THEN; NP = NP+1; LST(NP) = LST(I); END IF
        END DO
      END IF
40    DO I = 1,NP
        PR(I,1) = LST(I)/1000; PR(I,2) = MOD(LST(I),1000)
      END DO
      WRITE(6,'(/" Your index pairs are now",10(/10(1X,A,1X,A,:,
     +  ";"))))') ((CF(:JF(PR(I,J))),J=1,2),I=1,NP)
      WRITE(6,'(/" Hit RETURN if OK, or enter anything to initiate ",
     +  "revision/extension.")')
      CALL SCAN(J,0,'B',5)
      IF(J.NE.0) GOTO 30
CC      WRITE(6,'(/15X,"Results are on the way . . .")')
      OPEN(9,FILE=F1)
      WRITE(9,'(20(1X,A))',ERR=30) CF(:JF(MV)), CF(:JF(NP)),
     +  (CF(:JF(LST(I))),I=1,NP)
      CLOSE(9)
      WRITE(7,'(/" Report on the Directed-Path Structure of ",A," No",
     +  "de-index Pairs entered as"/100(/4X,12(A,1X,A,"; ")))')
     +  CF(:JF(NP)), ((CF(:JF(PR(I,J))),J=1,2),I=1,NP)
      WRITE(7,'(/" ""I J;"" stipulates I => J for a relation ",
     + "=> such that I => J => K entails I => K")')
      WRITE(7,'(/80("="))')
      MAP1 = 0
C
C Sort nodes into sequential list. MAP1(_) maps each node's operational index
C into its input-code; MAP2(_) maps each node's input-code into its index
      MX = 1
      DO I = 1,NP
        DO J = 1,2
          MX = MAX(MX,PR(I,J))
          MAP1(PR(I,J)) = 1    ! Flags which integers less than NP numbers in the pairs
        END DO
      END DO
      MV = 0
      DO I = 1,MX      ! MX not allowed to exceed MV
        IF(MAP1(I)==0) CYCLE
        MV = MV+1
        MAP1(MV) = I
        MAP2(I) = MV
      END DO
C     Put relational structure as entered into matrix KTL
      DO I = 1,MV
        DO J = 1,MV
          KTL(I,J) = 0
        END DO
      END DO
      DO I = 1,NP
        KTL(MAP2(PR(I,1)),MAP2(PR(I,2))) = 1
      END DO   ! Last use of PR
      DO I = 1,MV
        KTL(I,I) = 0
      END DO
C        Hence after transitivity expansion, KTL(I,I)=1 will signal that node
C        index I is in an equivalence group.

      DEALLOCATE ( PR )
      ALLOCATE ( LST1(NP), LST2(NP) )

C  Make all extended-path (transitive) connections explicit in KTL, so that
C  KTL(I,J) = 1 just in case I precedes J.
      LP = 1
65    DO I = 1,MV
        DO J = 1,MV
          DO K = 1,MV
            IF(KTL(I,K)*KTL(K,J)==1) KTL(I,J) = 1
          END DO
        END DO
      END DO
      LP = LP*2
      IF(LP<MV) GOTO 65
C
C  Look for equivalence groups
      DO I = 1,MV
        IF(KTL(I,I)<=0) CYCLE
        DO J = I+1,MV
          IF(KTL(I,J)*KTL(J,I)==0) CYCLE
          DO K = 1,MV
            KTL(J,K) = 0; KTL(K,J) = 0
          END DO
        KTL(J,J) = -I
        END DO
      KTL(I,I) = MIN(KTL(I,I),0)
      END DO
C
C  Count depth of antecedence and find order that reflects this
      DO I = 1,MV
        LST1(I) = I
        IF(KTL(I,I)<0) LST2(I) = KTL(I,I)
        IF(KTL(I,I)<0) CYCLE
        LST2(I) = 0
        DO J = 1,MV
          LST2(I) = LST2(I) + KTL(I,J)
        END DO
      END DO
      CALL SEQ(MV,LST1,LST2)
C        LST1(_) now lists equivalence-pruned indices in order of dependency,
C        followed by the higher members of any equivalence groups.
C      WRITE(7,'(/" TEST: LST1 is",20I3)') (LST1(I),I=1,MV)
C      WRITE(7,'(" TEST: LST2 is",20I3)') (LST2(I),I=1,MV)
      NL = MV+1
60    NL = NL - 1
      IF(LST2(NL)<0) GOTO 60
C       NL is the last position in LST1(_) before any higher-equiv. indices.
C
C  For nonequivalent indices, make KTL(I,J) the maximum path length from I to J
      DO I = NL-1,1,-1
        I1 = LST1(I)
        DO J = I+1,NL
          J1 = LST1(J)
          IF(KTL(I1,J1)==0) CYCLE
          DO K = I+1,J-1
             K1 = LST1(K)
             KTL(I1,J1) = MAX(KTL(I1,J1),KTL(I1,K1)*KTL(K1,J1)+1)
          END DO
        END DO
      END DO
C
C  Order items by maximum maximum-path length
      DO I = 1,NL
        I1 = LST1(I)
        LST2(I) = 0
        DO J = I+1,NL
          LST2(I) = MAX(LST2(I),KTL(I1,LST1(J)))
        END DO
      END DO
      CALL SEQ(NL,LST1,LST2)
C
C  Put dependency-ordered input codes into character string
      DO I = 1,4*NL
        WORD(I:I) = BL
      END DO
      DO I = 1,NL
        K = (I-1)*4 + 2
        N = MAP1(LST1(I))/10
        IF(N>0) WORD(K:K) = CHAR(48+N)
        WORD(K+1:K+1) = CHAR(48+MOD(MAP1(LST1(I)),10))
      END DO
C
C  List equivalence groups
      WRITE(6,'()')
      WRITE(7,'()')
      IF(NL==MV) WRITE(6,'(" Equivalence groups: None")')
      IF(NL==MV) WRITE(7,'(" Equivalence groups: None")')
      IF(NL==MV) GOTO 70
      NG = NL
      IG = 0
72    I = NG+1
      IG = IG+1
      NG = I
75    IF(LST2(I) == LST2(NG+1)) THEN
        NG = NG+1
        GOTO 75
      ELSE
        WRITE(6,'(" Equivalence group ",A,":",20(1X,A))') CHAR(64+IG),
     +    CF(:JF(MAP1(-LST2(I)))), (CF(:JF(MAP1(LST1(J)))),J=I,NG)
        WRITE(7,'(" Equivalence group ",A,":",20(1X,A))') CHAR(64+IG),
     +    CF(:JF(MAP1(-LST2(I)))), (CF(:JF(MAP1(LST1(J)))),J=I,NG)
        IF(NG<MV) GOTO 72
      END IF
      WRITE(7,'(/" An ""equivalence group"" is cyclic; each node pat",
     +  "h-precedes all others in"/" its group.  In the structure re",
     +  "port below, only the first index in each"/" equivalence gro",
     +  "up is made explicit.")')
C
C  List permutable subsequences in the dependency order
70    IB = 0
      KT = 0
80    IA = IB+1
      IF(IA>=NL) GOTO 88
      IB = IA
82    IF(IB<NL) THEN
        JB = LST1(IB+1)
        DO K = IA,IB
          IF(KTL(LST1(K),JB).NE.0) GOTO 84
      END DO
        IB = IB+1
        GOTO 82
      END IF
84    IF(IB==IA) GOTO 80
      K = 4*IA - 3
      WORD(K:K) = LBR
      K = 4*IB
      WORD(K:K) = RBR
      KT = 1
      GOTO 80
88    WRITE(6,'(/" The dependency order of these nodes, from least ",
     +  "to most dependent (that is,"/" no listed node is path-prec",
     +  "ded by any node listed to its right) and with"/" freely pe",
     +  "rmutable subsequences in brackets:"/5(/1X,80A))')
     +  (WORD(K:K),K=1,4*NL+1)
      WRITE(7,'(/" The dependency order of these nodes, from least ",
     +  "to most dependent (that is,"/" no listed node is path-prec",
     +  "ded by any node listed to its right) and with"/" freely pe",
     +  "rmutable subsequences in brackets:"/5(/1X,80A))')
     +  (WORD(K:K),K=1,4*NL+1); WRITE(7,'()')
      IF(KT>0) WRITE(7,'(" There may be other sequences that als",
     +  "o embed the partial-order of these"/" nodes, but only this ",
     +  "set corresponds in its bracketing arrangement to the"/" max",
     +  "imum-path-distance groupings below.")')
      IF(KT==0) WRITE(7,'(" No subsequences in this order can ",
     +  "be freely permuted.")')
C
C  Print matrix of maximum path lengths
      CH1 = ''; CH8 = ' '
      WRITE(7,'(/" Element Dij of the following matrix is the maximum",
     +  " => path distance from"/" node I to node J.  That is, with e",
     +  "quivalence groups counted as single nodes,"/" Dij minus 1 is",
     +  " the largest number of other nodes that intervene on a path"/
     +  " from I to J.")')
      WRITE(7,WORD)  (MAP1(LST1(J)),J=1,NL), ' '
      WRITE(7,'(A,100A)') CH8, (CH8(2:4),I=1,NL), ''
      DO I = 1,NL
        DO J = 1,NL
          K = JF(KTL(LST1(I),LST1(J))); K = 3*J
          WORD(K-2:K) = ADJUSTR(CF(:3))
          IF(WORD(K-1:K)==' 0') WORD(K:K) = '.'
        END DO
        WRITE(7,'(3X,I3,3A)') MAP1(LST1(I)), CH1, WORD(:K), ' '
      END DO
      CH8(7:7) = '';  WRITE(7,'(A,100A)') CH8, (CH8(2:4),I=1,NL), ''
C
C  List each node's dependencies
      WRITE(7,'(/" Per-node forward dependencies.")')
      DO I = 1,NL
        N = 0
        DO J = I+1,NL
          IF(KTL(LST1(I),LST1(J))==0) CYCLE
          N = N+1
          LST2(N) = LST1(J)
          END DO
        WRITE(7,'(" Node ",A," => ",22(1X,A),5(/15X,21(1X,A)))')
     +    CF(:JF(MAP1(LST1(I)))), (CF(:JF(MAP1(LST2(J)))),J=1,N)
      END DO
      WRITE(7,'(/" Per-node backward dependencies.  Use to enter ",
     +  "block structure in HYBLOCK.")')
      DO I = 1,NL
        N = 0
        DO J = 1,I-1
          IF(KTL(LST1(J),LST1(I))==0) CYCLE
          N = N+1
          LST2(N) = LST1(J)
        END DO
        WRITE(7,'(" Node ",A," <= ",22(1X,A),5(/15X,21(1X,A)))')
     +    CF(:JF(MAP1(LST1(I)))), (CF(:JF(MAP1(LST2(J)))),J=1,N)
      END DO
      WRITE(6,'(/" A more detailed report on this directed-graph ",
     + "structure is in file ORDER.SEE.")')
      IF(NP>26) STOP

      WRITE(7,'(/" For HYBLOCK coding of these nodes as letters (1=A,",
     +  " 2=B, etc.), the <= table is")')
      DO I = 1,NL
        N = 0
        DO J = 1,I-1
          IF(KTL(LST1(J),LST1(I))==0) CYCLE
          N = N+1
          LST2(N) = LST1(J)
        END DO
        WRITE(7,'(" Node ",A," <= ",22(1X,A),5(/15X,21(1X,A)))')
     +    CHAR(64+MAP1(LST1(I))), (CHAR(64+MAP1(LST2(J))),J=1,N)
      END DO
      WRITE(7,'()')

      STOP
      END
C
      SUBROUTINE ISORT(N,LST)
C Sort LST integers into descending or ascending order
      INTEGER LST(*)
      DO J = 2,N
        L = LST(J)
        DO I = J-1,1,-1
          IF(LST(I)<=L) GOTO 12    ! Increasing order
C          IF(LST(I)>=L) GOTO 12    ! Decreasing order
          LST(I+1) = LST(I)
        END DO
        I = 0
12      LST(I+1) = L
      END DO
      END SUBROUTINE

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
C      SAVE /CF/  ! This doesn't appear to be needed
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      SUBROUTINE SCAN(NL,NS,SEQ,KF)
C     Copyright (c) 1999 by W. W. Rozeboom.   All rights reserved.
C This reads the keyboard string, cleans it for list-directed reading of
C the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.  Termination of an input line by "*" allows up to
C two continuation lines.) NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number
C string returned in File 2 is non-null but does not match SEQ, and
C gives the total count of numbers in the returned string otherwise.
C *** If SEQ is "B", NL returns 0 if the input line is blank, and
C     returns -1 otherwise.
      CHARACTER  AA, SEQ*(*), WA*240, WB*240
      NL = 0
5     NLL = NL + 80
      READ(KF,'(A80)') WA(NL+1:NLL)
      IP = NL
      NL = NLL+1
10    NL = NL-1
      IF(NL==0) RETURN
      IF(WA(NL:NL)==' ') GOTO 10
      IF(WA(NL:NL)=='*' .AND. NL>IP) GOTO 5
      IF(SEQ(1:1)=='B') NL = -1
      IF(SEQ(1:1)=='B') RETURN
      WB(NL+1:NL+1) = ' '
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +      WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
        ELSE IF (WA(I:I) .NE. '0') THEN
          IP = 0
        END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1).NE.' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF (WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) RETURN
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I).NE.'I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I).NE.SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     + "number sequence requested. Try again.")')
      RETURN
60    REWIND 2
      WRITE(2,'(A)') WB(1:NL)
      NL = NN
      REWIND 2
      END SUBROUTINE
C
      SUBROUTINE SEQ(MV,LST1,LST2)
C This permutes the paired terms in LST1/2 into ascending order in LST2
      INTEGER LST1(*), LST2(*)
      DO L = 1,MV-1
        DO I = 1,MV-L
          IF(LST2(I)>=LST2(I+1)) CYCLE
          K = LST1(I+1)
          LST1(I+1) = LST1(I)
          LST1(I) = K
          K = LST2(I+1)
          LST2(I+1) = LST2(I)
          LST2(I) = K
        END DO
      END DO
      END SUBROUTINE
C
