C Program RESCORE.  (Source code: FORTRAN-90. Subroutine pack EIGS also needed)
C
C                  Last revised:  9 February 2003
C
C This composites and derives assorted functions of selected variables in a
C chosen Hydata-standard rawdata file.
C
      PARAMETER ( MOP=40, ML=139 )  ! ML=139 is limit for entry on single line
C       MOP is max steps in a defined-formula derivation (see notes in FORMLA);
C       ML the length of a formula word
      LOGICAL QYF, ALT, USE, QSH, QRS
      CHARACTER(12) CF, F1,F2,F3,F4,F5, CH*1,CH2*2, FM1*37,FM2*37, PL*2
C >>>   F1[3], input D-file.  F2[7], initially the source of F1, later
C >>>   the output D-file.  F3[8], logfile with basename taken from F1.
C >>>   F4[4], W-matrix from HYFAC.  F5, rawdata source of F4.
      CHARACTER(8) CLN, CH8, WORD*400, CSTYL(6)*9
      INTEGER WD, WDD  !, WH(3), WL(3)
C       OPTABL documentation is in subroutine FORMLA
C       Use HI/LO for high/low derived scores.  High/low input scores go into
C       BIG/SML and their selected sublists for COMPUT into TOP/BTM.

CCC      LOGICAL QINT(MV)
CCC      CHARACTER(8) IDENT(MV), NAME(60)
CCC      INTEGER JB(MJ,-2:MV+1), MISS(MV), KNT(MV), LST(MV),
CCC      REAL HI(MV), LO(MV), X1(MV), X2(MV), YY(MV), MORE(MJ+1,0:1)
CCC     +     MEAN(MV), SD(MV), AV(MV), SIG(MV), WTS(MV), WV(MY,MF),
CCC     +     BIG(MV), SML(MV), TOP(MV), BTM(MV)
C ****** WARNING: Distinguish between NV of input vars and NTOT of new ones
C                 Main allocations are done (MT = NTOT) after NTOT is finalized

      LOGICAL,ALLOCATABLE :: IINT(:), QINT(:)
      CHARACTER(8),ALLOCATABLE :: IDENT(:), NAME(:)*12, FORMS(:)*(ML)
      INTEGER,ALLOCATABLE :: JB(:,:), MORE(:,:), KNT(:), LST(:),
     +  NAML(:), OPTABL(:,:,:), ITMP(:), KX(:)
      REAL,ALLOCATABLE :: HI(:), LO(:), X1(:), X2(:), YY(:), MEAN(:),
     +     SD(:), SSD(:), AV(:), AAV(:), SIG(:), WTS(:), WV(:,:),
     +     BIG(:), SML(:), TOP(:), BTM(:), FWRK(:,:)
      COMMON /F/ MFRM, NFRM
      COMMON /B/ BAD
      COMMON /CF/ CF
      DATA CSTYL/'Sum     3','Maximum 7','Minimum 7','Length  6',
     +  'Deviance8','Outlie  6'/, ALT,USE,QSH,QRS/4*.FALSE./, NFILE/40/,
     +   NVAR,LPWR,ENUF/1,2,10./, LASTF,LASTC,NFIX/3*0/, PL/'s '/
      MATCH(I,J) = 1-MIN(1,ABS(I-J))
      PBD(K) = MIN(NR-KNT(K),KNT(K))*100./NR   ! Percent extremity of K relative to NumRec
      BLANK = -99.0   ! WD=4 later will reset BLANK
      BAD = HUGE(1.)-1.
      OPEN(2,STATUS='SCRATCH')
      CALL SYSTEM('cls')
      WRITE(6,'(/" The HYDATA-standardized datafiles available in ",
     +  "this subdirectory are:")')
      ALLOCATE ( NAME(60) )
      CALL LOOK(1,'*.D*',NAME,40,NW)
8     IF(NW==0) THEN; WRITE(6,'(/" No work for RESCORE here. Go find",
     +  " something else to do.")'); STOP; END IF
      NN = 1
10    F1 = NAME(NN); LF1 = LAST(F1)
      WRITE(6,'(/" The datafile now picked for compositing or resca",
     +  "ling of selected variables is"/1X,A,".  Hit RETURN if OK,",
     +  " or enter the index of another from this list."/)') F1(:LF1)
      CALL SCANC(J,1,'I',5,CH,L)
      IF(J<0) GOTO 10
      IF(J>0) THEN
        READ(2,*) NN; NN = MAX(1,MIN(NN,NW)); GOTO 10
      END IF
      OPEN(3,FILE=F1)
      READ(3,'(A)') WORD(:7)
      IF(WORD(2:7)/='HYDATA') THEN
        WRITE(6,'(/1X,A," is not a Hydata-standard datafile. ",
     +    "Abort run or try again.")') F1(:LF1)
        CALL TAKOUT(NN,NAME,NW); GOTO 8
      END IF
      REWIND 3
      READ(3,'(A)') WORD  !!! NOTE: SCAN call L-justifies WORD
C[ HYDATA-standard datafile   WAIS.D1   :  16 variables, 1880 r]
      CALL SCANC(J,4,'IIIR',-1,WORD(39:),L)
      IF(J<4) THEN
        LL = LAST(WORD)
        WRITE(6,'(" ERROR: Header of ",A," is"/1X,A)') F1(:LF1),
     +     WORD(:LL)
        STOP
      END IF
      READ(2,*) NV, NRR, MXX, DV; F3 = WORD(26:37)
      READ(3,'(A)') WORD; F2 = WORD(29:40); LF2=LAST(F2)
      CALL SCANC(J,2,'II',-1,WORD(43:),L)  ! Both terms wanted, L not used
C[        from rawdata source  WAIS.RAW   ; datafix  0; 3 miss]
      READ(2,*)  NFIX, MMIS ; L=LAST(F3)
      WRITE(6,'(/1X,A," is a ",A,"-variable datafile with record ",
     +  "IDs up to ",A)') F1(:LF1), CF(:JF(NV)), CF(:JF(MXX))
      IF(F3/=F1) WRITE(6,'(" This file was originally wr",
     +  "itten under name ",A)') F3(:L)
      IF(MMIS==0) GOTO 12; K = NINT(MMIS/(.15*NRR))
      IF(K>NV/3) THEN
        WRITE(6,'(/" Some of these records are incomplete (",A," score",
     +    "s are defective), so unless"/" you want to create indicator",
     +    " variables that shadow those, you should")') CF(:JF(MMIS))
      ELSE IF(K>=1) THEN
        WRITE(6,'(/" Some of these records are incomplete, and unless "
     +    "their ",A," missing scores"/" are concentrated on a modest ",
     +    "number of variables (",A," or so), you should")')
     +    CF(:JF(MMIS)), CF(:JF(K))
      ELSE
        WRITE(6,'(/" Some of these records are incomplete, and the num"
     +    "ber of defective scores"/" (",A,") is too small to define u"
     +    "seful missing-data shadows.  So you should")') CF(:JF(MMIS))
      END IF
      WRITE(6,'(" first impute the missing data using Hyball''s FIXD",
     +  "ATA program.")')
      WRITE(6,'(/5X,"To exit now with intent to fix the missing score",
     +  "s, hit RETURN."/5X,"Otherwise, enter anything to continue.")')
      CALL SCANC(J,0,'B',5,CH,L)
      IF(J==0) STOP
12    DEALLOCATE ( NAME )
      MV = NV+1  ! +1 is for JB; needed only for Op 4 on all input variables
      MJ = 100; NSX = 0; NSAV = 0; NFRM = 0; MFRM = 20
      JB = 0; MORE = 0   ! Allow resizing of MORE and JB (max number of jobs)
      ALLOCATE ( MEAN(NV), SD(NV), BIG(NV), SML(NV), KNT(NV), X1(NV) )
      ALLOCATE ( IINT(MV), QINT(MJ), IDENT(MV+MJ+1), MORE(MJ+1,0:1),
     +           WTS(MV), LST(NV), NAML(NV), JB(MJ,-2:MV), X2(MV) )
C        JB(JX,-1),JB(JX,0): the Operation,Number-of-operand-variables for Job JX
C        JB(JX,i),i=1,..,JB(JX,0): Indices of the operand variables
C        JB(JX,-2): For JOP=1, the line in direct-access file 20 holding item weights;
C                     for JOP=26, index of scratchfile holding weight matrix
C        MORE(J,1): number of new variables defined by Job J
C        MORE(J,0): number of new variables defined prior to Job J
      READ(3,*) (IDENT(I),I=1,NV)   ! IDENT is namelist in D-file
      DO I = 1,NV; NAML(I) = LAST(IDENT(I)); END DO  ! Lengths of item names
      LMR = JF(MXX)  ! Length of largest input ID
      CH2 = CF(:JF(LMR))//' '   ! 2nd position almost always left blank; no sweat
      FM1 = '(F'//CH2//'.0,1X,50F3.0,20(:/'//CH2//'X,1X,50F3.0))' ! F-format required
      FM2 = '(I'//CH2//',":",50I3,20(:/'//CH2//'X,1X,50I3))'
      READ(3,'(A)') WORD  ! Maybe start of 1st score line
      ALLOCATE ( KX(NV) ); KX = 0; IINT = .TRUE.  ! May be needed even if missing from input
      IF(WORD(:7)=='Rescale') THEN
        BACKSPACE 3
        READ(3,'(20(8X,8(2X,5I3):/))') (KX(I),I=1,NV)
        DO I = 1,NV
          IF(KX(I)/=0) NSX = NSX+1
          IF(KX(I)/=KX(MAX(1,I-1))) QSH = .TRUE. ! Flag for later warning display
          IF(KX(I)>0) IINT(I) = .FALSE. ! Item I was powered up to capture decimals
        END DO
        READ(3,'(A)') WORD ! Get start of 1st score line
      END IF
C New code for diagnosing and reading fieldwidth 4 or 5
      BACKSPACE 3
      WORD(:1) = 'X'; LL = LAST(WORD) ! Start of WORD mustn't be blank
      LL = LL-LMR-1  ! Length of scorelist in line
      L4 = 4*MIN(45,NV); L5 = 5*MIN(40,NY)   ! ; L3 = 3*MIN(50,NV);
      WD = 3; IF(LL==L4) WD = 4; IF(LL==L5) WD = 5
      IF(WD==4) THEN
        FM1 = '(F'//CH2//'.0,1X,45F4.0,20(:/'//CH2//'X,1X,45F4.0))' ! F-format required
        FM2 = '(I'//CH2//',":",45I4,20(:/'//CH2//'X,1X,45I4))'
        BLANK = -999.0
      ELSE IF(WD==5) THEN  ! Shouldn't ever occur, but may as well leave in place
        FM1 = '(F'//CH2//'.0,1X,40F4.0,20(:/'//CH2//'X,1X,40F4.0))' ! F-format required
        FM2 = '(I'//CH2//',":",40I4,20(:/'//CH2//'X,1X,40I4))'
        BLANK = -9999.0
      END IF
      MEAN = 0.; SD = 0.; BIG = -999.; SML = 9999.; KNT = 0

c Hydata-standard transcription of these data has shifted scales for xxx of the
c variables by one or more orders of magnitude.  Scores derived from them are
c generally affected by their scaling, so RESCORE lets you choose whether to
c
c => 1. Operate on the Hydata-standard scaling of these variables; or
c    2. Restore their orignal scales before deriving other scores from them.
c
C Hit RETURN to go with scaling option x, or enter anything to choose the other.
C Enter anything to confirm choice of Option x, or hit RETURN to reconsider.

      IF(NSX>0) THEN; LL = 1
14      WRITE(6,'(/" Hydata-standard transcription of these data has",
     +    " shifted scales for ",A," of the"/" variables by one or ",
     +    "more orders of magnitude.  Scores derived from them are"/
     +    " generally affected by their scaling, so RESCORE lets you",
     +    " choose whether to")') CF(:JF(NSX))
15      CH8 = ' '; CH8(3*LL-2:3*LL) = ' =>'
        WRITE(6,'(/A," 1. Operate on the Hydata-standard scaling of ",
     +    "these variables; or."/A," 2. Restore their orignal scales ",
     +    "before deriving other scores from them."//" Hit RETURN to ",
     +    "go with scaling Option",I2,", or enter anything to choose ",
     +    "the other.")') CH8(:3), CH8(4:6), LL
        READ(5,'(A)') CH
        IF(CH/=' ') THEN; LL = 3-LL; GOTO 15; END IF
        WRITE(6,'(/" Enter anything to confirm choice of Option",I2,
     +    ", or hit RETURN to reconsider.")') LL
        READ(5,'(A)') CH; IF(CH==' ') GOTO 14
        IF(LL==2) QRS = .TRUE.   !  QRS=True iff original scaling is restored
      END IF
      IF(.NOT.QRS) IINT = .TRUE.
      OPEN(13,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(6,'(/" Computing marginal statistics")')
      NR = 0; NKNT = 0; NGB1=0; NGB2=0; NGB3=0; MXGB = 0
      CALL POSITN(3,LMR+1)
30    READ(3,FM1,END=32) ID, (X1(I),I=1,NV)
      DO I = 1,NV
        IF(X1(I)==BLANK) THEN; X1 = BAD
        ELSE IF(QRS) THEN
          X1(I) = X1(I)*10.0**(-KX(I))
        END IF
      END DO
      WRITE(13) ID, (X1(I),I=1,NV)
      NR = NR+1
      DO I = 1,NV
        IF(X1(I)==BAD) CYCLE
        MEAN(I) = MEAN(I) + X1(I)
        SD(I) = SD(I) + X1(I)**2
        BIG(I) = MAX(BIG(I),X1(I))
        SML(I) = MIN(SML(I),X1(I))
        KNT(I) = KNT(I) + 1   ! Accumulate good-score count
      END DO
      GOTO 30
32    CLOSE(3); REWIND 13
      DO I = 1,NV
        N = MAX(1,KNT(I)); MEAN(I) = MEAN(I)/KNT(I)
        SD(I) = SQRT(MAX(.0001,SD(I)/KNT(I) - MEAN(I)**2))
        NKNT = NKNT + KNT(I); MXGB = MAX(MXGB,KNT(I))
        P = PBD(I)  ! Percent missing scores (or complement) on variable I
        IF(P>.99) NGB1 = NGB1+1; IF(P>5.) NGB2 = NGB2+1
        IF(P>10.) NGB3 = NGB3+1
      END DO
      MIS = NR*NV - NKNT
      IF(NR/=NRR) WRITE(6,'(/" WARNING. The number ",A," of records f",
     +  "ound in this datafile does not"/10X,"match the number ",A,1X,
     +  "declared in the file''s header.")') CF(:JF(NR)), CF(:JF(NRR))
      IF(MMIS/=MIS) WRITE(6,'(/" WARNING. The number ",A," of scores ",
     +  "flagged missing in this datafile does"/10X,"not match the nu",
     +  "mber ",A,1X,"declared in the file''s header.")') CF(:JF(MIS)),
     +  CF(:JF(MMIS))
      OPEN(20,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +  RECL=4*(MV+8))   ! Save weights for Jobs calling for one weight vector
      ALLOCATE ( OPTABL(MFRM,0:MOP,3), FWRK(MFRM,MOP), FORMS(MFRM) )
C Load Formulas file if existant
      NU = 0  ! Initial loading of formulas if store exists
      INQUIRE(FILE='FORMULAS',EXIST=QYF)
      IF(.NOT.QYF) GOTO 36
      WRITE(6,'(" Loading previous FORMULAS file.")')
34    OPEN(4,FILE='FORMULAS',FORM='UNFORMATTED') ! Return here if register is full
      READ(4) NFRM
      MFRM = MAX(MFRM,2*NFRM)
      IF(ALLOCATED(OPTABL)) DEALLOCATE ( OPTABL, FWRK, FORMS )
      ALLOCATE ( OPTABL(MFRM,0:MOP,3), FWRK(MFRM,MOP), FORMS(MFRM) )
      READ(4) (FORMS(J),J=1,NFRM)  ! OK???
      READ(4) (((OPTABL(I,J,K),I=1,NFRM),J=0,MOP),K=1,3)
      READ(4) ((FWRK(I,J),I=1,NFRM),J=1,MOP)
      CLOSE(4)
      IF(NU>0) GOTO 390
C
36    WRITE(6,'(/" The variables are named")')
      CALL SEENAM(NV,IDENT,1,NK,6)
      IF(NK==0) WRITE(6,'(/" When ready to proceed, hit RETURN.")')
      IF(NK>0) WRITE(6,'(/" Enter anything to repeat the full ",
     +  "namelist, or hit RETURN to proceed.")')
      CALL SCANC(J,0,'B',5,CH,L)
      IF(J/=0) GOTO 36

C   Ŀ
c    You can set multiple compositing or rescaling Jobs for this run:      5
c    Each Job is defined by four steps of keyboard entry, namely,          9
c      1. Select the Job operation from the displayed list of options.     4
c      2. Specify operation details as instructed.                        24
c      3. Enter indices of the variables on which this Job is to operate.  1
c      4. Name the derived variables (defaults provided).                 17
C   
c At nearly any point in Job specification you can restart by entering a letter.

      WRITE(6,'(/3X,"",70(""),"")')
      WRITE(6,'(3X," You can set multiple compositing or rescaling J",
     +  "obs for this run:",5X,""/3X," Each Job is defined by four ",
     +  "steps of keyboard entry, namely,",9X,""/3X,"   1. Select ",
     +  "the Job operation from the displayed list of options.",4X,""/
     +  3X,"   2. Specify operation details as instructed.",24X,""/
     +  3X,"   3. Enter indices of the variables on which this Job ",
     +  "is to operate. "/3X,"   4. Name the derived variables (de",
     +  "faults provided.",17X,"")')
      WRITE(6,'(3X,"",70(""),"")')
      WRITE(6,'(" At nearly any point in Job specification you can",
     +  " restart by entering a letter.")')
C
      JOB = 0; QINT = .TRUE.
      JB(1,-1) = 3000        ! Initialization  (MORE already initialized)
C Specify Job details, starting with Operation. JOB is the largest Job number
C defined; JX is the currently active Job.
40    JOB = JOB+1; IF(JOB>1) JB(JOB,-1)=MIN(3000,MAX(2000,JB(JOB-1,-1)))
C     If JOB-space nearly exhausted, reallocate with increased MJ
        IF(MJ-JOB<2) NVP = -2  ! Flag for IF-loop at label 911
        IF(MJ-JOB<2) GOTO 911
922   JX = JOB
      WRITE(6,'(//4X,"*** Setting Job ",A," ***")') CF(:JF(JX))
41    WRITE(6,'(/" The Operation alternatives for Job ",A," are")')
     +  CF(:JF(JX))
      WRITE(6,'(3X,"1. Estimate factor scores by HYFAC-provid",
     +  "ed item weights.")')
      WRITE(6,'(3X,"2. Define the Sum, Max, Min, Length, Deviance, or",
     +  " Outlie of many variables."/3X,"3. Derive new variables as ",
     +  "stipulated functions of old ones, or create/edit"/8X,"formu",
     +  "las for such derivations.")')
      IF(MXGB>1) WRITE(6,'(3X,"4. Define binary good-score/bad-score ",
     +  "shadows of selected variables.")')
44    IF(JB(JX,-1)==0 .AND. JX>1) WRITE(6,'(/" Enter index of ",
     +  "the Operation wanted, or any letter to abort Job ",A," and"/
     +  " start execution of Jobs already set."/)') CF(:JF(JX))
      IF(JB(JX,-1)>0) WRITE(6,'(/" Operation",I2," is now on call for",
     +  " Job ",A,". Hit RETURN if OK, or enter wanted"/" operation i",
     +  "ndex.  (To abort new-Job selection, enter any letter.)"/)')
     +  JB(JX,-1)/1000, CF(:JF(JX))
      CALL SCANC(J,1,'I',5,CH,L)
      IF(JX>1 .AND. J<0) THEN; JOB = JOB-1; GOTO 111; ENDIF
      IF(JB(JX,-1)>0 .AND. J==0) GOTO 50     !   ^ Execution
      IF(J<=0) WRITE(6,'(" No work requested, so come again when ",
     +  "you decide on something.")'); IF(J<=0) STOP
      READ(2,*) M
      IF(M<1 .OR. M>3+MIN(1,MXGB)) THEN
        WRITE(6,'(/I4," is not an available choice. Try again.")') M
        GOTO 44
      END IF
      JB(JX,-1) = M*1000
      GOTO 44
C
50    JOP = JB(JX,-1)/1000
      IF(JOP==1) GOTO 75    ! Special branch for HYFAC weight matrix
      IF(JOP>2) GOTO 400
C Set Jobs using concatenation operations
      JTYP = MAX(1,LASTC)   ! LASTC is last concatenation used
      L = ICHAR(CSTYL(JTYP)(9:9))-48
      CALL SYSTEM('cls')

C Operation 2 combines any selection of variables by one of concatenators
C
C      1:Sum   2:Maximum   3:Minimum   4:Length   5:Deviance   6:Outlie
C
C  "Length" is Euclidian distance from zero, that is, root-sum-square of
C  a record's scores on the selected variables.  (You may replace Power 2
C  in the length metric by some other positive integer.)  "Deviance" is
C  Euclidian Length after the scores are standardized as deviancies
C  (sigma-distance from mean) on their respective variables.  And "Outlie"
C  is Deviance on the normalized principal axes of the selected items.
C
CNOTE: The scores in a..........a are rescalings of your original rawdata by
C      multipliers S, reported in the data's D-conversion logfile, that are
C      generally not the same for all the variables.  These S do not affect
C      Deviance and Outlie.  But they may well have altered the rank-order of
C      subjects on Concatenations 1-4 unless all variables selected for the
C      present concatenation have been rescaled by the same S (as should be
C      true if their original scales have the same rationale).  In that case,
C      the effect of S is merely this same rescaling of the concatenation.
C              [ This NOTE will not reappear on this run. ]

      WRITE(6,'(/" Operation 2 combines any selection of variables by",
     +  " one of concatenators"//7X,"1:Sum   2:Maximum   3:Minimum   ",
     +  "4:Length   5:Deviance   6:Outlie ."//"   ""Length"" is Eucli",
     +  "dian distance from zero, that is, root-sum-square of"/"   a r"
     +  "ecord''s scores on the selected variables.  (You may replace ",
     +  "Power 2"/"   in the length metric by some other positive inte",
     +  "ger.)  ""Deviance"" is"/"   Euclidian Length after the scores",
     +  " are standardized as deviancies"/"   (sigma-distance from mea",
     +  "n) on their respective variables.  And ""Outlie"""/"   is De",
     +  "viance on the normalized selected items'' principal axes."/)')
      IF(QSH) WRITE(6,'(" NOTE: The scores in ",A," are rescalings of ",
     +  "your original rawdata by"/7X,"multipliers S, reported in the ",
     +  "data''s D-conversion logfile, that are"/7X,"generally not the",
     +  " same for all the variables.  These S do not affect"/7X,"Devi",
     +  "ance and Outlie.  But they may well have altered the rank-ord",
     +  "er of"/7X,"subjects on Concatenations 1-4 unless all variable",
     +  "s selected for the"/7X,"present concatenation have been resca",
     +  "led by the same S (as should be"/7X,"true if their original ",
     +  "scales have the same rationale).  In that case,"/7X,"the eff",
     +  "ect of S is merely this same rescaling of the concatenation."/
     +  14X,"[ This NOTE will not reappear on this run. ]"/)')
     +  F1(:LF1); QSH = .FALSE.
310   WRITE(6,'(" The concatenation operation now picked is No.",I2,
     +  " (",A,"). Hit RETURN if OK,"/" or enter the index of your ",
     +  "preferred concatenator."/)') JTYP, CSTYL(JTYP)(:L)
      CALL SCANC(J,0,'I',5,CH,L)
      IF(J<0) GOTO 41
      IF(J==0) GOTO 320
      READ(2,*) JTYP
      JTYP = MAX(1,MIN(6,JTYP))
      L = ICHAR(CSTYL(JTYP)(9:9))-48    ! Length of type name
      GOTO 310
320   IF(JTYP==4) THEN
        IF(LPWR==2) WRITE(6,'(/" Your Length measure is now Eucl",
     +    "idian (Power 2).  Hit RETURN if OK,"/" or enter altern",
     +    "ative length power (positive integer under 100)."/)')
        IF(LPWR/=2) WRITE(6,'(/" Your Length measure is now set fo",
     +    "r Power ",A,".  Hit RETURN if OK,"/" or enter alternative",
     +    "e length power (integer less than 100)."/)') CF(:JF(LPWR))
        CALL SCANC(J,0,'I',5,CH,L)
        IF(J<0) GOTO 310
        IF(J==0) GOTO 321
        READ(2,*) LPWR
        LPWR = MAX(1,MIN(99,LPWR))
        GOTO 320
      END IF
321   IF(MIS>0 .AND. JTYP==5) WRITE(6,'(" Note: Any Deviance score",
     +  " is treated as missing if any of its constituent"/" devianc",
     +  "ies exceed 10.  And all deviancies on variables with SDs le",
     +  "ss than .10"/" are scored as 1.")')
      JB(JX,-1) = 1000*JOP+JTYP
      IF(JTYP==4) JB(JX,-1) = 1000*JOP+10*LPWR+JTYP
      LASTC = JTYP
C   Now select the variables for concatenation
      CALL VARLST(JOP,JX,NV,JB,LST,IDENT,IER,MJ)  ! Sets list in JB
      IF(IER/=0) GOTO 41
      MIS = 0; NVAR = JB(JX,0)
      IF(JTYP==6) THEN
        DO I = 1,NVAR                ! This spec of LST also used
          K = K + KNT(LST(I))        !   by ORTH if called below
        END DO
        PM = (NR*NVAR-K)*100./(NR*NVAR)
        JB(JX,MV) = NINT(10*PM)
        IF(PM>1.) THEN
          WRITE(6,'(/" Advisory: The score distribution on which thi",
     +      "s Outlie rating will be"/11X,"based is",A5," percent mi",
     +      "ssing.  Enter anything to continue with"/11X,"principal",
     +      " axes imputed with good-score means for the missing"/11X,
     +      "data.  Otherwise, hit RETURN to abort this Outlie job.")')
     +      CLN(PM,5,1)
          CALL SCANC(J,0,'B',5,CH,L)
          IF(J==0) GOTO 41
        END IF
      END IF
      MORE(JX,1) = 1
      MORE(JX+1,0) = MORE(JX,0) + 1
CC      QINT(MORE(JX,0)+1) = .TRUE.  ! Set in default
      IF(JTYP>=4) QINT(MORE(JX,0)+1) = .FALSE.
C       QINT(K)=T codes that new variable K is inherently integer
      IF(JTYP<=5) GOTO 500
      CALL ORTH(JX,NV,NVAR,LST,NFILE,X1,X2,MEAN,LMR,FM1,IER)
      IF(IER>0.) THEN  ! Should never occur
        WRITE(6,'(7X,"******  Sorry. Eigensolution failure aborts this"
     +    " job.  ******")')
        GOTO 41
      END IF
      JB(JX,-2) = NFILE
      GOTO 500
C
C Set Jobs by created formulas { JOP=3 but JTYP=0 }
400   IF(JOP==4) GOTO 405
      JTYP = MAX(1,LASTF)     ! LASTF is last formula used
      IF(NFRM==0) WRITE(6,'(/" To invoke Operation 3, you must first",
     +  " write some formulas to apply.  (You"/" may prepare a list ",
     +  "of these before putting any to use.)  Enter any letter to"/
     +  " see information on formula creation, hit RETURN to get on ",
     +  "with definitions,"/" or abort Operation 3 by entering a nu",
     +  "mber.")')
      IF(NFRM>0) WRITE(6,'(/" Hit RETURN to use a formula already cre",
     +  "ated.  Otherwise enter letter "" S """/" to See the formula-",
     +  "information screen, or any other letter to work on the"/" fo",
     +  "rmula list.  To abort Operation 3, enter a number."/)')
      CALL SCANC(J,1,'I',5,CH,L)
      IF(J>0) GOTO 41
      IF(NFRM==0.AND.J/=0.OR.CH=='S'.OR.CH=='s') CALL INFO  ! INFO(KND)
      IF(NFRM>0 .AND. J==0) GOTO 402
390   CALL FORMLA(FORMS,MES,ALT,USE,OPTABL,FWRK)
      IF(NFRM<0) THEN; NU=NU+1; GOTO 34; END IF  ! Expand the formula registers
C       ALT returns whether formulas have been altered; USE sends whether any
C       have been used for Operation 3.  Formulas are in named file 4
      JTYP = NFRM
      IF(MES<0) GOTO 41
      IF(MES==99) GOTO 111
      IF(MES==1 .OR. NFRM<1) GOTO 400
      IF(MES>0) GOTO 403
402   WRITE(6,'(/" Your available formulas are")')
      CALL SEEFRM(NFRM,MFRM,FORMS)
403   WRITE(6,'(" No. ",A," is the formula now picked for this job.",
     +  " Hit RETURN if OK, or enter"/" preferred formula index."/)')
     +  CF(:JF(JTYP))
      CALL SCANC(J,0,'I',5,CH,L)
      IF(J<0) GOTO 41
      IF(J>0) THEN
        READ(2,*) JTYP
        JTYP = MAX(1,MIN(NFRM,JTYP))
        GOTO 403
      ELSE
        JB(JX,-1) = 1000*JOP+JTYP
        NVAR = OPTABL(JTYP,0,2)   ! Number of operation's arguments
        IER = NVAR      ! Port NVAR into VARLST by IER
      END IF
      LASTF = JTYP
      GOTO 410
C   Shadows next on list; nearly the same as derivation by 1-arg formula
405   WRITE(6,'(/" For your choice of parameter ENUF, missing-data s",
     +  "hadows will be created"/" only for selected items on which ",
     +  "the percent of scores missing lies between"/" ENUF and 100-",
     +  "ENUF.  (Shadow also mandates at least two scores missing on"/
     +  " the shadowed item.)  ENUF not less than 10% or at least 5% ",
     +  "is recommended."/" Bad-score prevalence lies between 10% and",
     +  " 90% for ",A," items here, while"/" the count in interval 5%",
     +  " - 95% is ",A,".")') CF(:JF(NGB3)), CF(:JF(NGB2))
406   NJ = 0
      DO J = 1,NV
        IF(PBD(J)<ENUF) CYCLE
        NJ = NJ+1; JB(JX,NJ) = J
      END DO
      JB(JX,0) = NJ; NVAR = 1
      WRITE(6,'(/4X,"ENUF is now set at",F5.1,"%, which approves ",A,
     +  " shadow variables."/4X,"Hit RETURN if OK, or enter alternati",
     +  "ve cutoff.  (Due to the"/4X,"two-missing requirement, lower ",
     +  "than",F5.1,"% doesn''t matter.)"/)') ENUF, CF(:JF(NJ)), 200./NR
      CALL SCANC(J,0,'R',5,CH,L)        !! NR*(P/100.)=2 => P = 200./NR
      IF(J==0) GOTO 414; IF(J<0) GOTO 41
      READ(2,*) ENUF
407   IF(ENUF<1.) ENUF = ENUF*10; IF(ENUF>=100.) ENUF = ENUF/10
      IF(ENUF<1. OR. ENUF>=100.) GOTO 407; ENUF = MIN(ENUF,200.*NR)-.001
      GOTO 406
C   Now select variables on which this formula is to operate.  JB(JX,0) holds
C   the total count of input variables in list. Only JOPs 3,4 execute this segment
410   CALL VARLST(JOP,JX,NV,JB,LST,IDENT,IER,MJ) ! Only JOP=3 enters here
      IF(IER/=0) GOTO 41   !   ^Workspace free on return
414   M = MORE(JX,1)                                 ! Only JOP=4 enters here
      MORE(JX,1) = JB(JX,0)/NVAR
      MORE(JX+1,0) = MORE(JX,0) + MORE(JX,1)
      DO I = 1,MORE(JX,1)  ! QINT(K)=T flags that new var K is inherently integer
CC        QINT(MORE(JX,0)+I) = .TRUE.  ! Set in default
        IF(JOP==4) CYCLE
        IF(FORMS(JTYP)(ML:ML)/='I') QINT(MORE(JX,0)+I) = .FALSE.
      END DO

C Test formula acceptability for these input items
      IF(JOP/=3) GOTO 420
      ALLOCATE ( AV(NVAR), SIG(NVAR), TOP(NVAR), BTM(NVAR) )
      JVAR = JB(JX,0)    ! Complete input-item list for this Job
      JC = MOD(JB(JX,-1),1000)   ! Computation formula
      DO L = 1,MORE(JX,1)  ! <<< Subloop creating different items within Job
        KB = NVAR*(L-1) ! = number of selection terms already used
        DO I = 1,NVAR
          J = JB(JX,KB+I); IF(.NOT.IINT(J)) QINT(MORE(JX,0)+I)=.FALSE.
          X2(I) = SML(J); WTS(I) = BIG(J)   ! Try formula on extreme scores
          AV(I)=MEAN(J); SIG(I)=SD(J); TOP(I)=BIG(J); BTM(I)=SML(J)
        END DO
        CALL COMPUT(W,JC,WTS(1),NVAR,AV,SIG,TOP,BTM,OPTABL,FWRK)
        CALL COMPUT(Y,JC, X2(1),NVAR,AV,SIG,TOP,BTM,OPTABL,FWRK)
        IF(Y==BAD .OR. W==BAD) THEN
          IF(W==BAD) WORD(:4)= 'high';IF(Y==BAD) WORD(:4)='low '
          WRITE(6,'(/19X,"*****> BAD-RESULTS ALERT <*****")')
          WRITE(6,'("  Computation by formula ",A," fails when applie",
     +      "d in Job ",A," to scores at ",A/"  end of the input dist",
     +      "ribution, most likely due to"/6X,"a) division by or non-",
     +      "positive powering of a zero score, or"/6X,"b) logarithm ",
     +      "or non-integer power of a negative score."/"  You should",
     +      " abort Job ",A," to modify its formula (perhaps by addin",
     +      "g a suitble"/"  constant) or drop from its argument list",
     +      " the item(s) this formula cannot")') CF(:JF(JC)),
     +      CF(:JF(JX)), WORD(:4), CF(:JF(JX))
          J = JB(JX,KB+1); M = LAST(IDENT(J))
          IF(NVAR==1) WRITE(6,'("  abide, notably variable ",A," (",A,
     +      ").")') CF(:JF(J)), IDENT(J)(:M)
          IF(NVAR>1) WRITE(6,'("  abide.  The argument ",A,"-tuple he",
     +      "re identified as troublesome starts with",A," (",A,").")')
     +      CF(:JF(NVAR)), CF(:JF(J)), IDENT(J)(:M)
          WRITE(6,'(/" To revise specification of this Job, hit RETU",
     +      "RN.  Otherwise, enter anything"/" to set production of a",
     +      " new variable that may well be worthless.")')
          CALL SCANC(J,0,'B',5,CH,L)
          IF(J==0) GOTO 41
        END IF
      END DO
      DEALLOCATE ( AV, SIG, TOP, BTM )

C  Computation by formula xx in Job xx fails when tested on scores at xxx
C  end of the input distribution, most likely due to attempting
C      a) division by or non-positive powering of a zero score, or
C      b) logarithm or non-integer power of a negative score.

c  However, since tests at two score levels have both failed, the formula
c  itself may be misbegotten.

C  You should abort Job xx to modify its formula (perhaps by adding a suitable
C  constant) or drop from its argument list the item(a) this formula cannot

C  abide, variable xx (aaaaa) in particular.
C  abide. The argument xx-tuple here identifed as troublesome starts with
C  variable xxx (aaaaa).
c To revise specification of this Job, hit RETURN.  Otherwise, enter anything
c to continue production of a new variable that may well be worthless.

420   CONTINUE

C Name the variable(s) derived by this Job
c ***** Can allow deletions here
500   JOP = JB(JX,-1)/1000       ! JOP=1,2 enter here
      IF(JOP<3) NVAR = JB(JX,0)  ! Already set for JOP=3,4
      DO K = 1,MORE(JX,1)
        JL = (K-1)*NVAR   ! Position in JB-list of last variable already used.
        CH8 = IDENT(JB(JX,JL+1))
        IF(JOP==4) THEN
          L = LAST(CH8)
          IF(L<8) CH8 = '$'//CH8(:7)
          IF(L==8) CH8(1:1) = '$'
          GOTO 440
        ELSE
          CALL MAKNAM(CH8,IDENT,NV)
        END IF
        LM = 3 ! Get maximum namelength in local input set
        DO I = 1,NVAR
          LST(I) = JB(JX,JL+I)
          L = LAST(IDENT(JB(JX,JL+I)))
          LM = MAX(LM,L)
        END DO
        WORD(:1) = ','; LW = 1
        IF(JOP==2) THEN
          LW = ICHAR(CSTYL(JTYP)(9:9))-48
          WORD(:4+LW) = ' ('//CSTYL(JTYP)(:LW)//'),'; LW = LW+4
        END IF
430     IF(NVAR==1) THEN
          WRITE(6,'(/" The variable derived by Job ",A,", Operation ",
     +      2A," from item ",A)') CF(:JF(JX)), CF(:JF(JOP)), WORD(:LW),
     +      IDENT(JB(JX,JL+1))(:LM)
        ELSE
          WRITE(6,'(/" The variable derived by Job ",A,", Operation ",
     +      2A," from items")') CF(:JF(JX)), CF(:JF(JOP)), WORD(:LW)
          CALL SHONAM('   ',NVAR,LST,NAML,IDENT,3,6)
        END IF
        L = LAST(CH8); CALL CAP(CH8,L)
        WRITE(6,'(" is now named ",A,".  Hit RETURN if OK, or enter ",
     +    "preferred name."/)') CH8(:L)
        READ(5,'(A)') WORD(101:120); L = LAST(WORD(101:120))
        IF(L==0) GOTO 440; CH8 = WORD(101:108); GOTO 430
440     IDENT(NV+MORE(JX,0)+K) = CH8
      END DO
C Now set missing-data treatment for all variables defined by Job
      IF(JOP==4) JB(JX,JB(JX,0)+1) = 0
      IF(JOP==4) GOTO 70
      CH = ' '; M = 1
      IF(MIS>0) CALL DOFIX(M,JOP,CH)
C       DOFIX chooses missing-data treatment; + says to skip preliminaries
      JB(JX,JB(JX,0)+1) = M   ! Location of Fix marker
      IF(JX>=MJ) GOTO 111
C
70    WRITE(6,'(/" Hit RETURN to set new Job No. ",A,"; enter "" J n ",
     +  """ to review, maybe cancel, a"/" Job No. n already set; or e",
     +  "nter "" C "" to cancel last Job (No. ",A,")."/" Otherwise",
     +  ", enter anything else to start execution."/)') CF(:JF(JOB+1)),
     +  CF(:JF(JX))
72    CALL SCANC(J,0,'I',5,CH,L)
      IF(J==0) GOTO 40; IF(J<0) GOTO 404
      READ(2,*) JX; JX = MAX(1,MIN(JX,JOB))
404   IF(CH=='J' .OR. CH=='j') THEN
cc        IF(J<0) WRITE(6,'(/" You didn''t enter a Job number after",
cc     +    " "" J "".  Try again.")')
cc        IF(J<0) GOTO 70
        GOTO 401  ! Start review
      ELSE IF(CH=='C' .OR. CH=='c') THEN
        IF(JX<=JOB) THEN   !  Branch when
          WORD(:8) = 'set     '; IF(JX<JOB) WORD(:8) = 'reviewed'
          WRITE(6,'(6X,"Enter anything to confirm that you want to ",
     +      "delete Job ",A,", which"/6X,"you have just ",A,".  ",
     +      "Otherwise, hit RETURN to reconsider.")') CF(:JF(JX)),
     +      WORD(:LEN_TRIM(WORD(:8)))
        ELSE ! IF(JX>JOB) THEN ! Occurs when last job was just deleted
          WRITE(6,'(6X,"If you''re sure you want to delete Job ",A,
     +      " without reviewing it,"/6X,"enter anything.  Otherwise,",
     +      " hit RETURN to check it first.")') CF(:JF(JOB))
        END IF
        CALL SCANC(J,0,'B',5,CH,L)
        IF(J==0) THEN
          IF(JX<=JOB) GOTO 70
          JX = JOB; GOTO 401  ! Review
        END IF
        IF(JX<=JOB) THEN
          DO J = JX+1,JOB
            DO I = -2,JB(J,0)+1
              JB(J-1,I) = JB(J,I)
            END DO
          END DO
        END IF
        JOB = JOB-1
        IF(JX>JOB) WRITE(6,'(" Former Job ",A," has been deleted:",
     +    " last Job is now ",A)') CF(:JF(JOB+1)), CF(:JF(JOB))
        IF(JX<=JOB) WRITE(6,'(" Former Job ",A," has been deleted;",
     +    " subsequent Jobs have been renumbered.")') CF(:JF(JX))
        WRITE(6,'(/" Hit RETURN to set new Job ",A,"; enter "" J n ",
     +    """ to review, maybe cancel, a Job n"/" already set (n  ",
     +    A,"); or enter anything else except "" C "" to start exec",
     +    "ution."/)') CF(:JF(JOB+1)), CF(:JF(JOB))
        GOTO 72
      END IF
      GOTO 111
C
C Special specification of Jobs by Operation 1
75    WRITE(6,'(/" The item-weight matrix you want should be one of:")')
76    CALL LOOK(1,'*.W*',NAME,40,NW)
      IF(NW==0) THEN
        IF(NW==0) WRITE(6,'(/" No item-weights matrix is identif",
     +    "ied here by a W-extension filename."/" Hit RETURN to make",
     +    " a different Job selection, or enter anything to quit.")')
        READ(5,'(A)') CH
        IF(CH/=' ') STOP
        GOTO 41  ! Present JX still OK
      END IF
      NN = 1
77    F4 = NAME(NN)
      LF4 = LAST(F4)
      WRITE(6,'(/" The weight matrix now picked to define factor est",
     +  "imates is ",A,".")') F4(:LF4)
      IF(NW>1) WRITE(6,'(" Hit RETURN if OK.  Otherwise, enter the i",
     +  "ndex of another on this list"/" or any letter to cancel thi",
     +  "s Job and pick another.")')
      IF(NW==1) WRITE(6,'(" Hit RETURN if OK, or enter anything to ",
     +  "cancel this Job.")')
      CALL SCANC(J,1,'I',5,CH,L)
      IF(J<0 .OR. J>0.AND.NW==1) GOTO 41
      IF(J>0) THEN
        READ(2,*) NN; NN = MAX(1,MIN(NN,NW)); GOTO 77
      END IF

C Broaden factor-estimate weights from HYFAC to include other weight inputs
      OPEN(4,FILE=F4); LF4 = LAST(F4)    ! $$$$$$$$$$$$$$$$$
      READ(4,'(A)') WORD(:6); L = LAST(WORD(:6))
      IF(WORD(:L)/='HYFAC' .AND.WORD(:L)/='Improv') THEN
        WRITE(6,'(/" File ",A," is not a HYFAC or improvised weight ",
     +    "matrix.  Abort run or try again.")') F4(:LF4)
        CLOSE(4); CALL TAKOUT(NN,NAME,NW); IF(NW>0) GOTO 77; GOTO 41
      END IF
      REWIND 4
      READ(4,'(A)') WORD(:120); LL = LAST(WORD(:120))
C HYFAC raw-score weights of xxx items for xx factors; details in aaaaaaaaaaaa; rawdata source, xxxxxxxxxxxx
C Improvised raw weights of xxx items for xx composites; details in aaaaaaaaaaaa; rawdata source, xxxxxxxxxxxx
      CALL SCANC(J,2,'II',-1,WORD(:50),L)
      READ(2,*) NVP, NFP
      READ(WORD(:LL),*) (CH,I=1,11), WORD(:12), CH, CH, F5
      L =  LAST(WORD(:12)); LF5 = LAST(F5) ! ^ Copy from later to earlier
      IF(WORD(:L)==';') L = L-1            !   in string this way OK???
      IF(WORD(:L)/='HYFAC') THEN           !
        WRITE(6,'(/" File ",A,", containing regression weights for ",A,
     +    " factors on ",A," items"/" has been loaded.  (Details are ",
     +    "available in SEE-file ",A,").  If you"/" don''t want estim",
     +    "ates of all these factors, you should abort this job and"/
     +    " re-run HYFAC to provide estimator weights for just the on",
     +    "es you do want."/" (Or you can estimate all and later run ",
     +    "SELECT to delete any not wanted.)")') F4(:LF4), CF(:JF(NFP)),
     +    CF(:JF(NVP)), WORD(:L)
        IF(F5(:LF5)/=F1(:LF1)) THEN
          WRITE(6,'(/" WARNING: The factors for whose estimation this ",
     +      "W-file gives item weights"/5X,"were not inferred from the",
     +      " covariances of scores in the present D-file.")')
          IF(F5(:LF5)==F2(:LF2)) THEN
            WRITE(6,'(5X,"They were, however, derived from datafile ",
     +      A," antecedent to that.")') F2(:LF2)
          ELSE
            WRITE(6,'(5X,"Neither were they derived from datafile ",
     +        A," antecedent to that.")') F2(:LF2)
          END IF
        END IF
      ELSE
        WRITE(6,'(/" File ",A,", containing weights for ",A," linear ",
     +    "composites of ",A," items"/" has been loaded.  (See file ",
     +    A," for details).")') F4(:LF4), CF(:JF(NFP)), CF(:JF(NVP)),
     +    WORD(:L)
      END IF
      WRITE(6,'(/" If this is satisfactory, hit RETURN to continue."/
     +  " Otherwise, enter anything to cancel this selection.")')
      READ(5,'(A)') CH
      IF(CH/=' ') THEN
        CLOSE(4); CALL TAKOUT(NN,NAME,NW); IF(NW>1) GOTO 77; GOTO 41
      END IF
C  Set block of Jobs from received weight-matrix, extending MJ if needed
      IF(ALLOCATED(WV)) DEALLOCATE (WV); ALLOCATE ( WV(NVP,NFP) )
911   IF(MJ-JOB-ABS(NVP)>MJ-5) THEN  ! Extend space for Job listing
        OPEN(14,STATUS='SCRATCH',FORM='UNFORMATTED')  ! This shd seldom be needed
        WRITE(14) ((MORE(I,J),I=1,JOB),J=0,2)
        WRITE(14) (QINT(I),I=1,JOB)
        WRITE(14) (IDENT(I),I=1,MV+MJ+1)
        WRITE(14) ((JB(I,J),J=-2,JB(I,0)),I=1,JOB)
        REWIND 14
        DEALLOCATE ( MORE, JB, QINT, IDENT )
        MJB = MJ;  MJ = MJ+MAX(20,ABS(NVP))
        ALLOCATE ( MORE(MJ+1,0:2),JB(MJ,-2:MV),QINT(MJ),IDENT(MV+MJ+1) )
        JB = 0; MORE = 0; QINT = .FALSE. ; IDENT = ' '
        READ(14) ((MORE(I,J),I=1,JOB),J=0,2)
        READ(14) (QINT(I),I=1,JOB)
        READ(14) (IDENT(I),I=1,MV+MJB+1)
        READ(14) ((JB(I,J),J=-2,0),I=1,JOB) ! ****** Rethink this
        BACKSPACE(14)
        READ(14) ((JB(I,J),J=-2,JB(I,0)),I=1,JOB)
        CLOSE(14)
        IF(NVP<=0) GOTO 922  ! Return to point of branch; scratchfile 4 not open
      END IF   ! Continue if reading weights from HYFAC
C Read item weights into array WV, and indices of the item names into NUM
      NL = 0                   ! $$$$$$$$$$$$$$$$$$$$$
82    READ(4,'()',END=88)      ! Test whether input file is exhausted
      BACKSPACE 4; NL = NL+1   ! NL is new line of input file
      READ(4,'(A)') WORD; M = LAST(WORD); M = 1
84    M=M+1; CH=WORD(M:M); IF(CH/=' '.AND.CH/=','.AND.CH/=';') GOTO 84
      BACKSPACE 4; CH8 = ' '
      CALL SCANC(J,0,'R',4,CH8,-M)  ! SCANC reads 1st M characters into CH8
      IF(J/=NFP) THEN               ! and deletes from scan for numbers
        WRITE(6,'(" This matrix has the wrong number of compositing w",
     +    "eights for variable ",A/" (",A," rather than ",A,").  Fix ",
     +    "the problem and try again on another run.")') CF(:JF(NL)),
     +    CF(:JF(J)), CF(:JF(NFP))  ! This should never happen
        CALL TAKOUT(NN,NAME,NW); CLOSE(4); GOTO 41
      END IF
      N1 = 0; J = LAST(CH8); CH = CH8(J:J)  ! Delete delimiter if nonblank
      IF(CH==','.OR.CH==';') CH8(J:J) = ' '
86    N1 = N1+1     ! Find rawdata index of named pattern variable
      IF(CH8==IDENT(N1)) THEN  ! Scan D-file namelist for match
        LST(NL) = N1   ! Records that pattern row NL is for data variable N1
        READ(2,*) (WV(NL,I),I=1,NFP)
        GOTO 82  ! Get next line of weight matrix
      END IF
      IF(N1<NV) GOTO 86
      WRITE(6,'(/" Some of these weights are for variables not in the",
     +  " input file.  Fix the"/" problem and try again later.")')
      DEALLOCATE ( WV ); CLOSE(4); IF(NW==1) GOTO 41; GOTO 76

88    IF(NL/=NVP) THEN
        WRITE(6,'(" The number ",A," of variables for which this mat",
     +    "rix gives weights differs from"/" the declared number ",A,
     +    ".  Fix the problem and try again on another run.")')
     +    CF(:JF(NL)), CF(:JF(NFP))
        DEALLOCATE ( WV ); CLOSE(4); GOTO 41
      END IF

CC      WRITE(6,'(/" Weight file ",A," won''t upload properly.", ! Enter here after
CC     + "  Fix the problem and"/" try again later.")') F4(:LF4) ! complete namescan
CC      DEALLOCATE ( WV ); CLOSE(4); IF(NW==1) GOTO 41; GOTO 76

      JX = JX-1   ! Warning: Do NOT re-initialize NSAV; also used for JOP=3 jobs
      DO JP = 1,NFP
        JX = JX+1
        JB(JX,-1) = 1000
        MORE(JX,1) = 1
        MORE(JX+1,0) = MORE(JX,0)+1
        QINT(MORE(JX,0)+1) = .FALSE.
        JJ = 0; IB = 1
C    Reminder: Ported HYFAC weights for factor JP are integers in column of matrix
C    Keep only items with nonzero weight and find the max-weight one not yet used
        DO I = 1,NVP    ! Max-weight item provides default name for composite if
          IF(NINT(WV(I,JP))==0) CYCLE   ! that name hasn't been used already
          JJ = JJ+1
          JB(JX,JJ) = ABS(LST(I))
          WTS(JJ) = WV(I,JP)
          IF(ABS(WV(I,JP))>ABS(WV(IB,JP)) .AND. LST(I)>0) IB = I  ! Provisional name root
        END DO               !  Negatives in list (^) are exclusion flags
        NSAV = NSAV+1
        WRITE(20,REC=NSAV) JJ, (WTS(I),I=1,JJ), JP, F4
        JB(JX,-2) = NSAV
        JB(JX,0) = JJ
        CH8 = IDENT(IB); L = LEN_TRIM(CH8)
        LST(IB) = -LST(IB)  ! Withdraw chosen name IB from future IB candidacy
        WRITE(6,'(/" The eligible item with largest raw regression ",
     +    "weight for factor ",A," is ",A)') CF(:JF(JP)), CH8(:L)
        IF(L==8) CH8(1:1) = '#'
        IF(L<8) CH8 = '#'//CH8(:7); IF(L<8) L=L+1
92      WRITE(6,'(/" This factor''s regression estimate is provisional",
     +    "ly named ",A/" Hit RETURN if OK, or enter preferred name.")')
     +     CH8(:L)
        READ(5,'(A)') WORD(:20); L = LAST(WORD(:20))
        IF(L==0) GOTO 94
        CH8 = WORD(:8); CALL CAP(CH8,8); GOTO 92
94      IDENT(NV+MORE(JX,0)+1) = CH8
      END DO
      DEALLOCATE ( WV )
      JOB = JX
      CALL DOFIX(M,JOP,' ')
      DO I = JX-NFP+1,JX
        JB(I,JB(I,0)+1) = M
      END DO
      GOTO 70
C
C Execute Jobs after saving latest formula file
111   IF(ALT) THEN
        IF(QYF) CALL SYSTEM('copy FORMULAS FORMULAS.OLD>nul')
        OPEN(4,FILE='FORMULAS',FORM='UNFORMATTED')
        WRITE(4) NFRM
        WRITE(4) (FORMS(J),J=1,NFRM)
        WRITE(4) (((OPTABL(I,J,K),I=1,NFRM),J=0,MOP),K=1,3)
        WRITE(4) ((FWRK(I,J),I=1,NFRM),J=1,MOP)
        CLOSE(4)
      END IF
      IF(MES==99) THEN
        IF(ALT) WRITE(6,'(/" As commanded, the run terminates after",
     +    " saving the revised FORMULAS file.")')
        IF(.NOT.ALT) WRITE(6,'(/" As commanded, the run terminates.",
     +    " The FORMULAS file remains unchanged.")')
        STOP
      END IF
      WRITE(6,'(/4X,"Hit RETURN to confirm that you want to get on ",
     +  "with score computation."/4X,"Otherwise, enter anything to ",
     +  "retrieve the Job-selection menu.")')
      CALL SCANC(J,0,'I',5,CH,L)
      IF(J/=0) GOTO 41
      WRITE(6,'(/" Computation of derived scores is underway.")')
      NTOT = MORE(JOB+1,0)
      DEALLOCATE ( X2, LST )
      MT = NTOT     ! Total number of new variables (MT not used??)
      ALLOCATE ( HI(MT), LO(MT), TOP(NV), BTM(NV), LST(MV+MT), YY(MT),
     +     AV(NV), SIG(NV), X2(MV+MT) )
      CLOSE(17)
      HI = -BAD; LO = BAD
      LST = 1 ! (not used) LST will flag if Job is to be executed/excluded
C
      IF(MIS/=0) THEN
        DO J = 1,JOB  ! Missing-data adjustments
          M = JB(J,JB(J,0)+1) ! Recall missing-data treatment
          IF(M<=1) CYCLE    ! Treatment 1 doesn't impose Real status
          DO I = 1,MORE(J,1)
            K = MORE(J,0) + I  ! Index of new variable in the derived list
            IF(KNT(K)<NR .AND. M>1) QINT(K) = .FALSE.
          END DO
        END DO
      END IF

C *** Additional exclusions from the Derived-vars list can also be added here
CCC   CONTINUE         ! Code for deleting Jobs listed in LST for exclusion;
cc114   NTT = 0        ! ****** not now used, but if activated, NTT must
Cxxx  DO I = 1,NTOT    ! ****** replace NTOT below.
cc        IF(LST(I)==0) CYCLE
cc        NTT = NTT+1
cc        LST(NTT) = I
cc        IDENT(NV+NTT) = IDENT(NV+I)
Cxxx    LST(I) = I  ! ****** No point ??????
cc        IDENT(NV+NTT) = IDENT(NV+I)
Cxxx  END DO
      OPEN(9,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +  RECL=4*(NTOT+2)); LR = 0
C Begin computation of derived scores
      ALLOCATE (AAV(NTOT), SSD(NTOT), ITMP(NTOT) ) ! Prepare to trim outliers
      LR = 0; MIS2 = 0; AAV = 0.; SSD = 0.
      REWIND 13  ! Done already
120   READ(13,END=140) ID, (X1(I),I=1,NV)
      LR = LR+1
      IF(MOD(N,100)==0) WRITE(6,'(4X," Deriving scores for Record ",
     +  A)') CF(:JF(LR))
C   Start Job list
      BBG: DO JX = 1,JOB
        JVAR = JB(JX,0)
        KFIX = JB(JX,JVAR+1)    ! = JB(JX,JB(JX,0)+1)
        KND = 10*(JB(JX,-1)/1000) + MOD(JB(JX,-1),10)
C         1st and 4th digit in JB(_,-1) pick operation branch
        IF(KFIX>=3) CALL DEV(DV,JX,X1,JB,MEAN,SD,MJ)  ! DV gets mean deviancy
        DO I = 1,JVAR                                     ! in JX-part of X1
          J = JB(JX,I)
          X2(I) = X1(J)
          IF(KND>=40) THEN;  X2(I)=1; IF(X2(I)==BAD) X2(I)=0; END IF  ! Set shadow score
          IF(KFIX<=1 .OR. X2(I)>BAD) CYCLE
C         Fix missing data as specified by KFIX
            IF(KFIX==2) X2(I) = MEAN(J)
            IF(SD(J)<.10) CYCLE
            IF(KFIX==3) X2(I) = MEAN(J) + DV*SD(J)
        END DO
        IF(KND>21 .AND. KND<40) THEN
          DO I = 1,JVAR
            AV(I) = MEAN(JB(JX,I)); SIG(I) = SD(JB(JX,I))
            IF(KND/10==2) CYCLE
            TOP(I) = BIG(JB(JX,I)); BTM(I) = SML(JB(JX,I))
          END DO   ! Data needed for this Job copied to working score lists
        END IF
        MOR = MORE(JX,0)
C         MOR is the number of new variables defined prior to Job JX
        DO L = 1,MORE(JX,1)  ! <<< Subloop creating different items within Job
C         L ranges over the new variables defined by Job JX; local indexing
C  Derivations by Operation 4
          IF(KND>=40) THEN
            Y = X2(L); GOTO 134
C  Derivations by Operations 1/2
          ELSE IF(KND<30) THEN
            Y = 9999999.*(MATCH(KND,23)-MATCH(KND,22))
C             Initial Y is -9999999 for KND=22, 9999999 for KND=23, and 0 otherwise.
            IF(KND==10) READ(20,REC=JB(JX,-2)) N, (WTS(I),I=1,N)
            DO I = 1,JVAR
              IF(X2(I)==BAD) Y = BAD; IF(Y==BAD) GOTO 134
              IF(KND==10) Y = Y + WTS(I)*X2(I)
              IF(KND==21) Y = Y + X2(I)    ! Sum
              IF(KND==22) Y = MAX(Y,X2(I)) ! Maximum
              IF(KND==23) Y = MIN(Y,X2(I)) ! Minimum
              IF(KND==24) THEN             ! Length
                LPWR = MOD(JB(JX,-1),1000)/10
                Y = Y + ABS(X2(I))**LPWR
              ELSE IF(KND==25) THEN        ! Deviance
                Z = (X2(I)-AV(I))/SIG(I);  IF(SIG(I)<.10) Z = 1.
                Y = Y + Z*Z;  IF(ABS(Z)>10.) Y = BAD
              END IF
            END DO
            IF(KND==26) THEN               ! Outlie
              NFILE = JB(JX,-2)
              DO I = 1,JVAR
                IF(X2(I)==BAD) Y = BAD; IF(Y==BAD) GOTO 134
                X2(I) = (X2(I)-AV(I))/SIG(I)
              END DO
              CALL OUTLAY(NFILE,JVAR,X2,Y,PM)  ! JVAR is read from scratchfile
            END IF ! PM is percent of missing scores in the X2-distribution
            IF(KND==24 .AND. Y>=0.) Y = MAX(0.,Y)**(1./LPWR)
            IF(KND==25) Y = SQRT(MAX(0.,Y))
C   Derivations by Operation 3
          ELSE
            JC = MOD(JB(JX,-1),1000)
            NVAR = MAX(1,OPTABL(JC,0,2))
            KB = NVAR*(L-1) ! = the number of selection terms already used
            CALL COMPUT(Y,JC,X2(KB+1),JVAR-KB,AV(KB+1),SIG(KB+1),
     +                 TOP(KB+1),BTM(KB+1),OPTABL,FWRK)
C            4th argument is the number of variables sent in X2 to COMPUT.
C            JC is the function index.  Y is returned function value.
          END IF
134       YY(MOR+L) = Y                ! OK for WD=3: -(10**3) + 1 to 10**4 - 1
          IF(Y==BAD) CYCLE             ! OK for WD=4: -(10**4) + 1 to 10**5 - 1
          HI(MOR+L) = MAX(HI(MOR+L),Y) ! OK for WD=5: -(10**5) + 1 to 10**6 - 1
          LO(MOR+L) = MIN(LO(MOR+L),Y) ! OK: -(10**WD - .6) to 10**(WD+1)
        END DO  ! Repeat for next new score in list for this Job
      END DO BBG
      WRITE(9,REC=LR) ID, (YY(I),I=1,NTOT)
CC =============== End of newscore computation for record LR ===============

      DO I = 1,NTOT
        IF(YY(I)==BAD) THEN; MIS2 = MIS2+1  ! Count new MIS
        ELSE
          AAV(I) = AAV(I) + YY(I); SSD(I) = SSD(I) + YY(I)**2
          ITMP(I) = ITMP(I) + 1
        END IF
      END DO
      GOTO 120  ! Do next record
140   IF(LR/=NR) WRITE(6,'(" ERROR: Count ",A," of new-score records",
     +  " doesn''t match the number ",A/" of input records.  Fix the",
     +  " problem.")') CF(:JF(LR)), CF(:JF(NR))
      IF(LR/=NR) STOP
      DDV = DV; QSH = .FALSE. ! QSH=T says to combine old/new
CC      OPEN(19,STATUS='SCRATCH',FORM='UNFORMATTED')  ! Save in case needed for output
CC      WRITE(19) (AV(I),I=1,NV), (SD(I),I=1,NV); REWIND 19  ! Not now needed
      IF(NTOT>NV) THEN
        DEALLOCATE ( TOP, BTM, AV, SD, WTS )
        ALLOCATE ( TOP(NTOT), BTM(NTOT), AV(NTOT), SD(NTOT), WTS(NTOT) )
      END IF
      DO I = 1,NTOT
        AAV(I) = AAV(I)/ITMP(I)
        SSD(I) = SQRT(MAX(.0001, SSD(I)/ITMP(I) - AAV(I)**2))
        YY(I) = MAX((HI(I)-AAV(I))/SSD(I), (AAV(I)-LO(I))/SSD(I))
        LPOS=MAX(LPOS,JF(NINT(HI(I)))); LNEG=MAX(LNEG,JF(NINT(LO(I))))
      END DO
      WDD = 3; IF(LNEG>=LPOS) WDD = 4; MM = 0;
142   ZM=0.; NN=0; NOP=1  ! NN counts new items larger than DDV;
      DO I = 1,NTOT       ! NOP is option index; MM flags change in DV
        IF(YY(I)>DDV) THEN; ZM = MAX(ZM,YY(I)); NN = NN+1; END IF
      END DO
      IF(NN==0) THEN; ITMP = 0; WTS = 1.; GOTO 150; END IF

144   WORD(:9) = ' '; WORD(3*NOP-2:3*NOP) = ' =>'; CH8(:3) = 'sve'
      M=MIN(2,NOP)                               ! n : 2n-1 (n=1,2)
      WRITE(6,'(/1X,A," of your new variables ha",A," scores whose d",
     +  "eviancies (sigma distance from"/)') CF(:JF(NN)),CH8(M:2*M-1)
      IF(MM==0) WRITE(6,'(" mean) up to ",A4," exceed discard level",
     +  1X,A4," set in the"," input datafile."/" Your options:")')
     +  CLN(ZM,4,2), CLN(DDV,4,2)
      IF(MM>0) WRITE(6,'(" mean) up to ",A4," exceed discard level ",
     +  A4,".  Your options remain")') CLN(ZM,4,2), CLN(DDV,4,2)
      WRITE(6,'(A," 1. Treat new scores more deviant than ",A4," as",
     +  " missing."/A," 2. Trim grotesquely large new scores to dev",
     +  "iancy ",A4,"."/A," 3. Set a new deviancy cutoff with new ",
     +  " scores recorded in a separate D-file.")')
     +  WORD(3*NOP-2:3*NOP), CLN(DDV,4,2), WORD(3*NOP-2:3*NOP),
     +  CLN(DDV,4,2), WORD(3*NOP-2:3*NOP)
      WRITE(6,'("  Hit RETURN to approve Option",I2,".  Otherwise e",
     +  "nter any letter to pick Option",I2/" or, alternatively, yo",
     +  "ur numeric choice of revised deviancy cutoff.")') NOP, 3-NOP

c xxx of your new variables have scores whose deviancies (sigma distance from
c mean) up to xxxx exceed discard level xxxx set in the input datafile. / Your options:
c mean) up to xxxx exceed discard level xxxx.  Your options:
c => 1. Treat new scores more deviant than xxxxx as missing,
c    2. Trim grotesquely large new scores to deviancy xxxxx.
c    3. Set a new deviancy cutoff with new scores recorded in a separate file.
c Hit RETURN to approve Option x.  Otherwise enter any letter to pick Option x
c or, alternatively, your numeric choice of revised deviancy cutoff.

      CALL SCANC(J,1,'I',5,CH,L)
      IF(J/=0) THEN
        IF(J<0) THEN; NOP = 3-NOP; GOTO 144; END IF
        READ(2,*) DDV; DDV = MAX(3.,MIN(99.9,DDV))
        MM = 1; IF(ABS(DDV-DV)<.1) MM = 0
        GOTO 142  ! Return resets NOP = 1
      END IF

C In each record of newscores, trim (NOP=1) or BAD-mark (NOP=2) each score more
C deviant than DDV and tabulate new stats with this change; iterate if needed
      KPAS = 0
146   YY = SSD*DDV; TOP = AAV+YY; BTM = AAV-YY; ITMP=0; KREV=0; MIS=0
      DO L = 1,LR
        READ(9,REC=L) J, (YY(I),I=1,NTOT)
        DO I = 1,NTOT
          IF(YY(I)==BAD) THEN; MIS = MIS+1; CYCLE; END IF
          D = (YY(I)-AAV(I))/SSD(I)
          IF(ABS(D) > DDV) THEN
            KREV = KREV+1
            IF(NOP==2) THEN; YY(I) = BAD; MIS = MIS+1; CYCLE; END IF
            IF(D<0) YY(I) = BTM(I); IF(D>0) YY(I) = TOP(I)
          END IF
          AV(I)=AV(I)+YY(I); SD(I)=SD(I)+YY(I)**2; ITMP(I)=ITMP(I+1)
        END DO
        WRITE(9,REC=L) J, (YY(I),I=1,NTOT)
      END DO; KPAS = KPAS+1
      DO I = 1,NTOT
        AAV(I) = AV(I)/ITMP(I)
        SSD(I) = SQRT(MAX(.0001, SD(I)/ITMP(I) - AAV(I)**2 ))
      END DO
      IF(KREV>1 .AND. KPAS<10) GOTO 146  ! KPAS shouldn't matter
      IF(KPAS>9) WRITE(6,'(/" #-#-#-# 10 outlier-control cycles have",
     +  " failed to converge:"/10X,"Surely a programming error."/)')
150   KY = 0; ITMP = 0; WTS = 1.;   ! KY>0 iff new variables need Rescale list
      DO I = 1,NTOT  ! WTS will hold rescaling multipliers, ITMP their power
        IF(HI(I)==-BAD) CYCLE  ! All scores on item I are bad
        JW = MAX(JF(NINT(HI(I))),JF(NINT(LO(I)))) ! Last use of LO for lowest newscore
        IF(QINT(I).AND.JW<=WDD) CYCLE      ! ITMP holds KX for new variables
        ITMP(I) = WDD-JW       ! Want JW+ITMP(I) = WDD
        WTS(I) = 10.**ITMP(I)  ! Rem: WD and WWD are declared integers
        IF(ITMP(I)/=0) KY = KY+1 ! Don't need accumulation
      END DO
C   Ŀ
C     These derived scores can be saved (a) either conjoined with their   
C     originating data or separately from those, in (b) a D-file having   
C     either the current basename xxxxxxx or a new one of your choosing.  
C   
      WRITE(6,'(/3X,"",70(""),"")')
      LFF = LF1-3; IF(F1(LFF:LFF)=='.') LFF=LFF-1
      WRITE(6,'(3X,"  These derived scores can be saved (a) either c",
     +  "onjoined with their   "/3X,"  originating data or separate",
     +  "ly from those, in (b) a D-file having   "/3X,"  either the",
     +  " current basename ",A," or a new one of your choosing.",9A)')
     +  F1(:LFF), (' ',I=1,9-LFF), ""    ! Need 9-LFF spaces
      WRITE(6,'(3X,"",70(""),"")')
C
C Append derived scores to old F1 (if QSH=T) or copy to new (if QSH=F) D-file
151   IF(QSH) WRITE(6,'(/" If you want these derived variables append",
     +  "ed to the ones in ",A,","/" hit RETURN.  Otherwise, enter an",
     +  "ything to file them separately.")') F1(:LF1)
      IF(.NOT.QSH) WRITE(6,'(/" To put scores on these derived variabl",
     +  "es into a separate datafile, hit RETURN."/" Otherwise, enter ",
     +  "anything to combine them with the data in ",A,". ")') F1(:LF1)
      IF(WD<WDD) WRITE(6,'(" Note: Combining will increase the source",
     +  " scores'' fieldwidths from 3 to 4.")')
      CALL SCANC(J,0,'B',5,CH,L)
      IF(J/=0) THEN; QSH = .NOT.QSH; GOTO 151; END IF
      IF(QSH) THEN
        MIS2 = MIS+MIS2; WDD = MAX(WDD,WD)  ! Newscore WDD was set just before Label 144
      END IF
CCC      NY = NV + NTT  ! See note above on code not currently used
      BLANK = -10**WDD + 1
      NY = NV + NTOT
      F2 = F1
      CALL NAME1(F2,F3,6,LF2)
      WRITE(6,'(/3X,"The output file''s basename defaults to ",A,", "
     +  "extending the current series."/3X,"Hit RETURN if OK, or ent",
     +  "er your preference for a different basename."/)') F2(:LF2-4)
      READ(5,'(A)') WORD; L = LAST(WORD)
      IF(L==0) GOTO 155
154   CALL CAP(WORD,L)
      F2 = WORD(:12)
      CALL NAME1(F2,F3,6,LL2); LF2 = LAST(F2)
      WRITE(6,'(/" The output file''s basename is now set to be ",A/
     +  " Hit RETURN if OK, or enter an alternative."/)') F2(:LL2-3)
      READ(5,'(A)') WORD; L = LAST(WORD)
      IF(L>0) GOTO 154
      IF(F2(:LL2-3)/=F1(:LL2-3) .OR. .NOT.QSH) GOTO 158

155   WRITE(6,'(/" New scores can be combined with their sources in ",
     +  "a D-file continuing the"/" series'' basename either by over",
     +  "writing the originating D-file with its"/" expansion or by ",
     +  "saving the combination under a new extension while also"/
     +  " retaining the unexpanded original.")')
156   WRITE(6,'(/" To combine the derived scores with their sources ",
     +  "in new file ",A,","/" hit RETURN.  Otherwise, enter anythin",
     +  "g to expand ",A," with this.")') F2(:LF2), F1(:LF1)
      CALL SCANC(J,0,'B',5,CH,L)
      ALT = .FALSE.; IF(J==0) ALT = .TRUE.  ! ALT=T chooses newfile for combo
      IF(J/=0) WRITE(6,'(" Hit RETURN to confirm overwriting the inp",
     +  "ut D-file by its expansion.")')
      IF(J==0) WRITE(6,'(" Hit RETURN again to confirm writing the ",
     +  "expanded dataset to a new file.")')
      WRITE(6,'(" Otherwise, enter anything to reconsider.")')
      CALL SCANC(J,0,'B',5,CH,L)
      IF(J/=0) GOTO 156
      IF(.NOT.ALT) THEN; F2 = F1; LF2 = LF1; END IF
CC      END IF   ! QSH=T says to append, F2=F1 says to overwrite old F1
158   IF(F1/=F2) OPEN(7,FILE=F2)
      IF(F1==F2) OPEN(7,FILE='ZYXWVU')
      WRITE(6,'(/" Recording of output records is now in progress.")')
      N0 = 1; IF(.NOT.QSH) N0 = NV+1
      WORD = ' '
      WORD((13-LF2)/2:12) = F2      !  If QSH, 'expanded'; else ' derived'
      WORD(12+(13-LF1)/2:24) = F1   !               8                8
      WORD(25:32) = ' derived'; IF(QSH) WORD(25:33) = 'expanded'
      WRITE(7,'(" HYDATA-standard datafile ",A,": ",A," variables, ",A,
     +  " records; largest ID, ",A,"; ",A," under DEV =",F5.1," by ",
     +  "RESCORE from"/5X,"Hydata-standard source ",A,"; datafix ",A,
     +  "; ",A," missing scores.")') WORD(:12), CF(:JF(NY-N0+1)),
     +  CF(:JF(NR)), CF(:JF(MXX)), WORD(25:32), DDV, WORD(13:24),
     +  CF(:JF(NFIX)), CF(:JF(MIS2))
C *** Note: The leading "HYDATA" in this header MUST remain capitalized.
      LW = 3
      DO I = N0,NY   ! Rem: NY = NV+NTOT (old + new)
        LW = MAX(LW,LAST(IDENT(I)))
      END DO
      NW = 150/(LW+1)
      CH8(:2) = CHAR(48+NW/10)//CHAR(48+MOD(NW,10))
      WORD(:17) = '(50('//CH8(:2)//'(1X,A),:/))'//'  '
      WRITE(7,WORD(:17)) (IDENT(I)(:LW),I=N0,NY)
      IF(QSH .AND. NSX+KY>0) WRITE(7,'("Rescale",8(2X,5I3),20(/8X,
     +  8(2X,5I3)))')  (KX(I),I=1,NV), (ITMP(I),I=1,NTOT)
      IF(.NOT.QSH .AND. KY>0 ) WRITE(7,'("Rescale",8(2X,5I3),20(/8X,
     +  8(2X,5I3)))') (ITMP(I),I=1,NTOT)
      IF(QSH) REWIND 13      ! v CH2 defined at line 131 or thereabouts
      IF(WDD>WD)  FM2 = '(I'//CH2//',":",45I4,20(:/'//CH2//'X,1X,45I4))'
      DO N = 1,LR
        READ(9,REC=N) ID, (X2(NV+I),I=1,NTOT)
        IF(MOD(N,100)==0) WRITE(6,'(4X," Assembling Record ",A)')
     +    CF(:JF(N))
        IF(.NOT.QSH) GOTO 166  ! Don't prepend old data
        READ(13,END=184) IJ, (X2(I),I=1,NV)
        IF(QRS) THEN  ! Need to restore original rescaling
          DO I = 1,NV; X2(I) = X2(I)*10.0**KX(I); END DO
        END IF
        IF(IJ/=ID) THEN
          WRITE(6,'(/" *** ERROR: The program has tried to match old",
     +      " file ID #",A," with newfile ID #",A)') CF(:JF(IJ)),
     +      CF(:JF(ID)); STOP
        END IF
166     DO I = 1,NTOT
          IF(X2(NV+I)==BAD) THEN
            X2(NV+I) = BLANK
          ELSE
            X2(NV+I) = X2(NV+I)*WTS(I)
          END IF
        END DO
        WRITE(7,FM2) ID, (NINT(X2(I)),I=N0,NY)
      END DO
184   CLOSE(7)
      IF(F1==F2) THEN
        CALL SYSTEM('DEL '//F1)
        CALL SYSTEM('RENAME ZYXWVU '//F1)
      END IF

      OPEN(8,FILE=F3)  ! Finish with logfile
      CALL FNDEND(8)
      WRITE(8,'(/40("* ")//" Report on derivation of datafile ",A,1X,
     +  "from datafile ",A," by program RESCORE.")') F2(:LF2),F1(:LF1)
      CALL DAY(8)
      WRITE(8,'(/" The variables in source file ",A," are named")')
     +  F1(:LF1)
      CALL SEENAM(NV,IDENT,1,NK,8)
      WRITE(8,'(/" while those in derived file ",A," are named")')
     +  F2(:LF2)
      CALL SEENAM(NY-N0+1,IDENT(N0),1,NK,8)   ! N0 = NV+1, save in newfile
      WRITE(8,'(//20X," DETAILS OF DERIVATIONS")')
C NSX > 0 says that input scores were rescalings of original (though maybe all the same)
C QRS=true says that original scaling has been reinstated. If NSX = 0, QRS=false
C >>> NOTE: These new variables were computed from the rescaled scores made
C           explicit in datafile xxxxxxx, which is not their original scaling.
C >>> NOTE: These new variables were computed from the xxxxxxxxxx variables'
C           original scalings, not from their rescalings explicit in xxxxxxx
      IF(NSX==0) WORD(:28) = 'also their original scaling.'
      IF(NSX>0) WORD(:28) = 'not their original scaling. '
      IF(.NOT.QRS) WRITE(8,'(/" >>> NOTE: These new variables were co",
     +  "mputed from the rescaled scores made"/11X,"explicit in dataf",
     +  "ile ",A,", which is ",A)') F1(:LF1), WORD(:28)
      IF(QRS) WRITE(8,'(/" >>> NOTE: These new variables were compute",
     +  "d from the ",A," variables'' "/11X,"original scalings, not f",
     +  "rom their rescalings explicit in ",A,".")') F1(:LF1), F1(:LF1)
      DO K = 1,JOB
        JOP = JB(K,-1)/1000
        JTYP = MOD(JB(K,-1),10)
        LPWR = MOD(JB(K,-1),1000)/10  ! Nonzero only for Length
        WRITE(8,'(/" Job ",A,", using Operation ",A,":")') CF(:JF(K)),
     +    CF(:JF(JOP))
        MOR = MORE(K,1)
        CH8 = IDENT(NV+MORE(K,0)+1); L8 = LAST(CH8)
        LL = 3; LW = 0; NVAR = JB(K,0)
        DO I = 1,NVAR
          N = LAST(IDENT(JB(K,I)))
          LL = MAX(LL,N)
        END DO
        DO I = 1,MORE(K,1)
          N = LAST(IDENT(NV+MORE(K,0)+I))
          LL = MAX(LL,N)
        END DO
        IF(JOP==2 .OR. JOP==3) THEN  ! Index list for writing out long namelist
          DO I = 1,NVAR
            LST(I) = JB(K,I)
          END DO
        END IF
        IF(JOP==1) THEN
          READ(20,REC=JB(K,-2)) N, (WTS(I),I=1,N), JP, F4
          B=0.; A=0.; ND=0; L=6; LF4 = LAST(F4)
          DO I = 1,N   ! All weights should be integers
            W=WTS(I); B=MAX(B,W); A=MIN(A,W); IF(MOD(W,1.)/=0.) ND=1;
          END DO
          M=JF(MAX(INT(B),INT(ABS(10*A))))
          IF(JF(INT(A))>JF(INT(B))) L = 5; IF(M==1) ND=ND*2
          IF(ND>0) M = M+1+ND; IF(ND==0) ND = 11
          MM = MAX(LL+1,M) ! M is WTS fieldwidth, LL+1 is for names
          NN = MIN(8,MAX(0,MM-M))  ! Number of spaces after weightfield
          WORD(:21) = '(60('//CF(:JF(L))//'X,15(A'//CF(:JF(M))//','//
     +      CF(:JF(NN))//'X):/))'//'  '
          WRITE(8,'(4X,"New variable ",A," was composited from old ",
     +      "variables",60(:/6X,15(A,1X)))') CH8(:L8), (IDENT(JB(K,I))
     +      (:MM-1),I=1,NVAR) ! ***** Don't use SHONAM; want names aligned with weights
          WRITE(8,'(4X,"by the item weights for estimating factor ",A,
     +      " in HYBUF-export file ",A,", namely")')CF(:JF(JP)),F4(:LF4)
          WRITE(8,WORD(:21)) (CLN(WTS(I),M,ND),I=1,N)
        ELSE IF(JOP==2) THEN
          LW = ICHAR(CSTYL(JTYP)(9:9))-48; J = JF(LPWR)
          WORD(:LW) = CSTYL(JTYP)(:LW)
          N = 0; IF(LPWR>0) N = 9+J; IF(LPWR==2) N = 12
          IF(LPWR>0) WORD(LW+1:LW+N) = ' (Power '//CF(:J)//')'
          IF(LPWR==2) WORD(LW+1:LW+N) = ' (Euclidian)'
          WRITE(8,'(4X,"New variable ",A," is concatenation ",A," of ",
     +      "old variables")') CH8(:L8), WORD(:LW+N)
          CALL SHONAM('      ',NVAR,LST,NAML,IDENT,6,8); LW = 0
        ELSE IF(JOP==3) THEN
          WORD(:6) = '      '
          IF(MOR==1 .AND. NVAR<3) THEN
            WRITE(8,'(4X,"New variable ",A," was derived from old ",
     +        "variable",2A,2X,A)') CH8(:L8), PL(3-MIN(2,NVAR):),
     +        (IDENT(JB(K,I))(:NAML(JB(K,I))),I=1,NVAR)
          ELSE IF(MOR==1 .AND. NVAR>2) THEN
            WRITE(8,'(4X,"New variable ",A," was derived from old",
     +        " variables")') CH8(:L8)
              CALL SHONAM('      ',NVAR,LST,NAML,IDENT,6,8)
          ELSE
            WRITE(8,'(4X,"New variables ",60(:/4X,15(2X,A)))') (IDENT(NV
     +        +MORE(K,0)+I)(:LAST(IDENT(NV+MORE(K,0)+I))),I=1,MORE(K,1))
            WRITE(8,'(4X,"were derived from old variables")')
            CALL SHONAM('      ',NVAR,LST,NAML,IDENT,6,8)
          END IF
          N = OPTABL(JTYP,0,3)-2; M = 18+N+2 ! N is form length without outer parens
          WORD(:M) = ' by formula [ Y = '//FORMS(JTYP)(2:N+1)//' ]'
          LW = M  ! No space at running end
        ELSE IF(JOP==4 .AND. MORE(K,1)>0) THEN
          WORD(:6) = '      '
          WRITE(8,'(4X,"New variables ",60(:/6X,15(A,2X)))') (IDENT(NV
     +      +MORE(K,0)+I)(:LAST(IDENT(NV+MORE(K,0)+I))),I=1,MORE(K,1))
          WRITE(8,'(4X,"are missing-data shadows of old variables")')
          CALL SHONAM('      ',NVAR,LST,NAML,IDENT,6,8)
        END IF
        IF(JOP==4) GOTO 190 ; MM = 1
        DO I = 1,MOR
          IF(ABS(KNT(MORE(K,0)+I)-1.)>.01) GOTO 188  ! Rescaling not unity
        END DO
        M = JF(JB(K,NVAR+1)); MM = 0
        IF(MMIS==0) THEN
          WORD(LW+1:LW+19) = ' without rescaling.'; LW = LW+19
        ELSE
          WORD(LW+1:LW+51) = ' using missing-data Option '//CF(:M)//
     +      ' and without rescaling.' ; LW = LW+51
        END IF

        WRITE(8,'(3X,A)') WORD(:LW)   ! WORD starts with space
        GOTO 190
188     IF(MMIS>0 .AND. JP/=2) THEN
          M = JF(JB(K,NVAR+1))
          WORD(LW+1:LW+28) = ' using missing-data Option '//CF(:M)
          LW=LW+28
        END IF
        IF(MM==0) WRITE(8,'(3X,A)') WORD(:LW)
        IF(MM>0) THEN
          IF(MOR==1) WRITE(8,'(3X,A," and rescaled by multiplier ",A)')
     +      WORD(:LW), CLN(WTS(MORE(K,0)+1),5,2)
          IF(MOR>1) WRITE(8,'(3X,A,", and rescaled by respective ",
     +      "multipliers",50(:/4X,12(2X,A)))') WORD(:LW),
     +      (CLN(WTS(MORE(K,0)+I),5,2),I=1,MOR)
        END IF
190     IF(JOP==2 .AND. JTYP==6) THEN
          PM = .1*JB(K,MV)  ! 1st three proportion decimals saved in JB
          IF(PM>1.) WRITE(8,'(4X,"(",F5.1," percent of scores to wh",
     +      "ich this Outlie is relative were missing.)")') PM
        END IF
      END DO
      WRITE(6,'(/" The derived scores are now stored in datafile ",A/
     +  " Input/output filenames and labels assigned to the variables"/
     +  " have been appended to ASCII file ",A)') F2(:LF2), F3(:LL2)
      STOP

C Code block for Job review
401   JOP = JB(JX,-1)/1000 ; JTYP = MOD(JB(JX,-1),10); NJ = JB(JX,0)
      LP = MOD(JB(JX,-1)/10,10)  ! Nonzero only for Length
ccc      IF(JTYP==4) JB(JX,-1) = 1000*JOP+10*LPWR+JTYP
      IF(JOP==2 .OR. JOP==3) THEN  ! Index list for writing out long namelist
        DO I = 1,NJ
          LST(I) = JB(JX,I)
        END DO
      END IF
C  JX is Job selected for review, JOP is its Op index, NJ its length of item list
      IF(JOP==1) THEN
        READ(20,REC=JB(JX,-2)) N,(S,I=1,N), M, F4; LF4 = LAST(F4)   ! S is a wastebasket
        WRITE(6,'(/" Job ",A,": Operation-1 composite of ",A," items",
     +    " estimating weight-import"/9X,"matrix ",A,"''s factor ",A,
     +    ".")')  CF(:JF(JX)), CF(:JF(NJ)), F4(:LF4), CF(:JF(M))
      ELSE IF(JOP==2) THEN
        N = ICHAR(CSTYL(JTYP)(9:9))-48
        WORD(:N) = CSTYL(JTYP)(:N); J = JF(LP)
        IF(LP>0) WORD(N+1:N+9+J) = ' (Power '//CF(:J)//')'
        IF(LP==2) WORD(N+1:N+12) = ' (Euclidian)'
        IF(LP>0) N = N+9+J; IF(LP==2) N = N+12
        WRITE(6,'(/" Job ",A,": Operation-2 concatenation ",A,
     +    " of items")') WORD(:N); WORD(:8) = '        '
        CALL SHONAM('        ',NJ,LST,NAML,IDENT,3,6)
      ELSE IF(JOP==3) THEN
        N = OPTABL(JTYP,0,3)-2; M = N+8; MOR = MORE(JX,1);
        WORD(:M) = '[ Y = '//FORMS(JTYP)(2:N+1)//' ]'
        WRITE(6,'(/" Job ",A,": Operation-3 derivation of ",A," new ",
     +    "variable",A,"by formula")') CF(:JF(JX)), CF(:JF(MOR)),
     +    PL(3-MIN(2,MOR):)
        IF(NJ==1) THEN
          J = JB(JX,1); CH8 = IDENT(J); LL = NAML(J)
          IF(M+11+LL <= 70) WRITE(6,'(8X,A," from item ",A)') WORD(:M),
     +      CH8(:LL)
          IF(M+11+LL>70) WRITE(6,'(11X,A/8X,"from item ",A)') WORD(:M),
     +      CH8(:LL)
        ELSE IF(NJ>1) THEN
          WORD(:18) = '        from items'
          CALL SHONAM(WORD,NJ,LST,NAML,IDENT,8,6)
        END IF
      ELSE IF(JOP==4) THEN
        WRITE(6,'(/" Job ",A,": Operation-4 derivation of item ",A,
     +    "''s missing-data shadow.")') CF(:JF(JX))
      END IF
      WRITE(6,'(/3X,"If you wish to cancel the Job just reviewed, en",
     +  "ter anything."/3X,"Otherwise, hit RETURN to make another ",
     +  "Job decision.")')
      CALL SCANC(J,0,'B',5,CH,L)
      IF(J==0) JX = JOB; IF(J==0) GOTO 70     ! Reset JX to last job set
      CH = 'C'; K = 0
      GOTO 404
      END
C
      FUNCTION BAS(I)
C Determine whether term I In WRD is one of the five basic operators.
      PARAMETER ( ML=139 )    ! (ML=139)
      LOGICAL BAS
      CHARACTER WRD*(ML), CH
      COMMON /W/ LL, WRD
      BAS = .FALSE.
      CH = WRD(I:I)
      IF(CH=='^'.OR.CH=='*'.OR.CH=='/'.OR.CH=='+'.OR.CH=='-')
     +  BAS = .TRUE.
      END FUNCTION
C
      SUBROUTINE CAP(WORD,L)
C This makes the first L letters in WORD all upper-case.
      CHARACTER WORD*(*)
      DO I = 1,L
        N = ICHAR(WORD(I:I))
        IF(N>=97 .AND. N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      END SUBROUTINE

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      CLN = '        '
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      LD = ABS(ND)
      IF(ABS(X)<1.0E-12) THEN !  Special for vanishingly small X
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X))) !  M is space free for decimal (or M-1 if X<0) )
      IF(M<0 .OR.  M<1.AND.X<0.) GOTO 55
      IF(ND>=10) LD = 0; LD = MIN(LD,M)
      DO I = 1,KW
        WK(I) = ' '
      END DO
      IF(LD==0) N = NINT(ABS(X))         ! Shouldn't be needed, but is
      IF(LD/=0) N = NINT(ABS(X)*10**LD)  ! This can overflow if LD is large
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' *******'
      END FUNCTION
C
      SUBROUTINE COMPUT(Y,JC,XX,NV,MEAN,SD,HI,LO,OPTABL,FWRK)
C This computes formula JC previously defined by FORMLA in OPTABL.  XX is the
C input score array not more than NV terms. Y is the computed output.
      PARAMETER ( MOP=40 )
      CHARACTER(12) CF
      INTEGER OPTABL(MFRM,0:MOP,3)
      REAL FWRK(MFRM,MOP), XX(*), MEAN(*), SD(*), HI(*), LO(*)
      COMMON /F/ MFRM, NFRM
      COMMON /B/ BAD
      COMMON /CF/ CF
C      FNS/'MAX ','MIN ','MOD','KUT ',' ',' ','ABS ','SQRT',
C          'EXP ','LN  ','LOG ','SIN','ASIN','COS ','ACOS','TAN ',
C          'ATAN','NINT','INT'/
C     Other operation codes: ^,1; *,2; /,3; +,4; -,5; reflect,6;
C       input-variable,0; input constant,-1. FNS indexing starts at 7.
C       Function KUT(X,c) is 1 if X  c and is 0 otherwise.
      RAD = 90/ACOS(0.); SML = TINY(.1)
      KOP = OPTABL(JC,0,1)
      IF(NV < OPTABL(JC,0,2)) THEN
        WRITE(6,'(" Only ",A," old variables have been provided for ",
     +    "deriving a new one by "/" formula No. ",A,"; the number ",
     +    "required is ",A,".")') CF(:JF(NV)), CF(:JF(JC)),
     +    CF(:JF(OPTABL(JC,0,2)))
        RETURN
      ELSE IF(JC>NFRM) THEN
        WRITE(6,'(" Only ",A," formulas have been defined. Your call ",
     +    "for No. ",A," is disallowed.")') CF(:JF(NFRM)), CF(:JF(JC))
      END IF
      DO K = 1,KOP
        IF(OPTABL(JC,K,1)<0) CYCLE
        IF(OPTABL(JC,K,1)==0) THEN
          JTYP = OPTABL(JC,K,2)/100
          JVAR = MOD(OPTABL(JC,K,2),100)
C         If JTYP = -1, FWRK(JC,K) is an input constant
          IF(JTYP==0) THEN
            IF(XX(JVAR)==BAD) GOTO 50
            FWRK(JC,K) = XX(JVAR)
          ELSE IF(JTYP==1) THEN
            IF(MEAN(JVAR)==BAD) GOTO 50
            FWRK(JC,K) = MEAN(JVAR)
          ELSE IF(JTYP==2) THEN
            IF(SD(JVAR)<.10) GOTO 50
            FWRK(JC,K) = SD(JVAR)
          ELSE IF(JTYP==3) THEN
            IF(HI(JVAR)==BAD) GOTO 50
            FWRK(JC,K) = HI(JVAR)
          ELSE IF(JTYP==4) THEN
            IF(LO(JVAR)==BAD) GOTO 50
            FWRK(JC,K) = LO(JVAR)
          ELSE IF(JTYP==5) THEN
            IF(MEAN(JVAR)==BAD .OR. SD(JVAR)<.10) GOTO 50
            FWRK(JC,K) = MIN(10., (XX(JVAR)-MEAN(JVAR))/SD(JVAR))
          END IF
        ELSE IF(OPTABL(JC,K,1)==4) THEN
          FWRK(JC,K) = FWRK(JC,OPTABL(JC,K,2)) + FWRK(JC,OPTABL(
     +                 JC,K,3))
        ELSE IF(OPTABL(JC,K,1)==5) THEN
          FWRK(JC,K) = FWRK(JC,OPTABL(JC,K,2)) - FWRK(JC,OPTABL(
     +                 JC,K,3))
        ELSE IF(OPTABL(JC,K,1)==2) THEN
          FWRK(JC,K) = FWRK(JC,OPTABL(JC,K,2)) * FWRK(JC,OPTABL(
     +                 JC,K,3))
        ELSE IF(OPTABL(JC,K,1)==6) THEN
          FWRK(JC,K) = -FWRK(JC,OPTABL(JC,K,2))
        ELSE IF(OPTABL(JC,K,1)==3) THEN
          Z = FWRK(JC,OPTABL(JC,K,3))
          IF(ABS(Z)<.000001) GOTO 50
          FWRK(JC,K) = FWRK(JC,OPTABL(JC,K,2)) / Z
        ELSE IF(OPTABL(JC,K,1)==1) THEN  ! Power 1st term by 2nd
          Z = FWRK(JC,OPTABL(JC,K,2))
          P = FWRK(JC,OPTABL(JC,K,3))
C           Exclude cases (a) z=0 with P0, and (b) z<0 with P non-integer
C           Z=0 requires P>0; Z<0 requires integer P
          IF(ABS(Z)<SML .AND. P<=0.) GOTO 50   ! Case A
          IF(Z<0. .AND. P/=NINT(P)) GOTO 50    ! Case B
          FWRK(JC,K) = Z**P
        ELSE IF(OPTABL(JC,K,1)==14) THEN
          Z = FWRK(JC,OPTABL(JC,K,2)); IF(Z<0.) GOTO 50
          FWRK(JC,K) = SQRT(Z)
        ELSE IF(OPTABL(JC,K,1)==7) THEN
          FWRK(JC,K) = MAX(FWRK(JC,OPTABL(JC,K,2)),FWRK(JC,OPTABL(
     +                 JC,K,3)))
        ELSE IF(OPTABL(JC,K,1)==8) THEN
          FWRK(JC,K) = MIN(FWRK(JC,OPTABL(JC,K,2)),FWRK(JC,OPTABL(
     +                 JC,K,3)))
        ELSE IF(OPTABL(JC,K,1)==9) THEN
          FWRK(JC,K) = AMOD(FWRK(JC,OPTABL(JC,K,2)),FWRK(JC,OPTABL(
     +                 JC,K,3)))
        ELSE IF(OPTABL(JC,K,1)==10) THEN
C           KUT(X,c) = MAX(0,MIN(1,INT(1+X-c)))    ! 1  1+X-c iff X  c
          FWRK(JC,K) = MAX(0.,MIN(1.,AINT(1+FWRK(JC,OPTABL(JC,K,2))-
     +                 FWRK(JC,OPTABL(JC,K,3)))))
        ELSE IF(OPTABL(JC,K,1)==13) THEN
          FWRK(JC,K) = ABS(FWRK(JC,OPTABL(JC,K,2)))
        ELSE IF(OPTABL(JC,K,1)==15) THEN
          FWRK(JC,K) = EXP(FWRK(JC,OPTABL(JC,K,2)))
        ELSE IF(OPTABL(JC,K,1)==16) THEN
          Z = FWRK(JC,OPTABL(JC,K,2)); IF(Z<=0.) GOTO 50
          FWRK(JC,K) = LOG10(Z)
        ELSE IF(OPTABL(JC,K,1)==17) THEN
          Z = FWRK(JC,OPTABL(JC,K,2)); IF(Z<=0.) GOTO 50
          FWRK(JC,K) = LOG(Z)
        ELSE IF(OPTABL(JC,K,1)==18) THEN
          FWRK(JC,K) = SIN(FWRK(JC,OPTABL(JC,K,2))/RAD)
        ELSE IF(OPTABL(JC,K,1)==19) THEN
          FWRK(JC,K) = ASIN(FWRK(JC,OPTABL(JC,K,2)))*RAD
        ELSE IF(OPTABL(JC,K,1)==20) THEN
          FWRK(JC,K) = COS(FWRK(JC,OPTABL(JC,K,2))/RAD)
        ELSE IF(OPTABL(JC,K,1)==21) THEN
          FWRK(JC,K) = ACOS(FWRK(JC,OPTABL(JC,K,2)))*RAD
        ELSE IF(OPTABL(JC,K,1)==22) THEN
          FWRK(JC,K) = TAN(FWRK(JC,OPTABL(JC,K,2))/RAD)
        ELSE IF(OPTABL(JC,K,1)==23) THEN
          FWRK(JC,K) = ATAN(FWRK(JC,OPTABL(JC,K,2)))*RAD
        ELSE IF(OPTABL(JC,K,1)==24) THEN
          FWRK(JC,K) = ANINT(FWRK(JC,OPTABL(JC,K,2)))
        ELSE IF(OPTABL(JC,K,1)==25) THEN
          FWRK(JC,K) = AINT(FWRK(JC,OPTABL(JC,K,2)))
        END IF
      END DO
      Y = FWRK(JC,KOP)
      IF(ABS(Y)<BAD) RETURN
50    Y = BAD
      END SUBROUTINE
C
      SUBROUTINE DEV(D,JX,XX,JB,MEAN,SD,MJ)
C Find average deviancy in XX-scores picked out by JB
      INTEGER JB(MJ,-2:*)
      REAL XX(*), MEAN(*), SD(*)
      COMMON /B/ BAD
      D = 0.; ND = 0       ! For I = 9, JB(1,I) = 9
      DO I = 1,JB(JX,0)    ! but 9 is larger than 2nd dimension of JB
        J = JB(JX,I)
        IF(MEAN(J)==BAD .OR. SD(J)<.2) CYCLE
        D = D + (XX(J)-MEAN(J))/SD(J)
        ND = ND+1
      END DO
      IF(ND>0) D = D/ND
      END SUBROUTINE
C
      FUNCTION DIGT(CH)
C Return DIGT = T if CH is digit character, otherwise F.
      LOGICAL DIGT
      CHARACTER CH
      DIGT = .FALSE.
      IF(ICHAR(CH)>=48 .AND.ICHAR(CH)<=57) DIGT = .TRUE.
      END FUNCTION
C
      SUBROUTINE DOFIX(METH,JOP,CH)
C This specifies the method, METH, of treating missing scores in composites
      CHARACTER CH
      IF(CH=='+') GOTO 10
      METH = 1
      IF(JOP==1) WRITE(6,'(/" You can treat missing scores in ",
     +  "these factor regressions in three ways:")')
      IF(JOP==2) WRITE(6,'(/" You can treat missing scores in ",
     +  "this concatenation in three ways:")')
      IF(JOP==3) WRITE(6,'(/" You can treat missing scores in ",
     +  "this formula definition in two ways:")')
      WRITE(6,'(3X,"1. Code the composite as missing."/3X,"2. Esti",
     +  "mate each missing score to equal the variable''s mean.")')
      IF(JOP<=2) WRITE(6,'(3X,"3. Estimate each missing score''s",
     + " deviancy to equal that record''s"/6X,"average deviancy ",
     + "over the other composited scores.")')
10    WRITE(6,'(/" Missing scores are now set for Treatment",I2,
     +  ". Hit RETURN if OK,")') METH
      IF(JOP<=2) WRITE(6,'(" or enter preferred Treatment index ",
     +  "1, 2, or 3."/)')
      IF(JOP==3) WRITE(6,'(" or enter preferred Treatment index ",
     +  "1 or 2."/)')
      CALL SCANC(J,1,'I',5,CH,L)
      IF(J<=0) RETURN
      READ(2,*) N
      METH = MAX(1,MIN(3,N))
      IF(JOP==3) METH = MIN(2,METH)
      GOTO 10
      END SUBROUTINE
C
      SUBROUTINE DUPL(CH8,IDENT,N1,N2)
C Check whether name CH8 duplicates any of names N1 to N2 in list IDENT
C and, if it does, find new end character next in sequence STR.
      CHARACTER(8) CH8, IDENT(*), STR(7)*1
      DATA STR/'&','@','#','=','!','+','*'/
      K = 0
5     L = LAST(CH8)
      IF(L==0) L = 8
10    DO I = N1,N2
        IF(CH8==IDENT(I)) GOTO 30
      END DO
      RETURN
30    IF(MOD(K,7)==0) L = MIN(L+1,8)
      CH8(L:L) = STR(1+MOD(K,7))
      K = K+1
      IF(MOD(K,7)>0) GOTO 10
      CH8 = CH8(1:1)//CH8(1:7)
      IF(K/7<=2) GOTO 5
      CH8 = '???     '
      END SUBROUTINE
C
      SUBROUTINE EVAL(K,L,KOP,MFRM,OPTABL,JC,MLST,IER)
C Evaluate WRD-string from paren K to paren L, containing only Med-terms and
C basic operators (no parens), for its computation instructions in OPTABL.
      PARAMETER ( MOP=40, ML=139 )  ! ML=139)
      CHARACTER WRD*(ML), CH
      INTEGER OPTABL(MFRM,0:MOP,3), MLST(*)
      COMMON /W/ LL, WRD
      IER = 0
      DO I = L-1,K+1,-1
        IF(WRD(I:I)/='^') CYCLE
        KOP = KOP+1
        CALL SSUB(I,KOP,MFRM,OPTABL,JC,MLST,IER)
        IF(IER/=0) RETURN
        OPTABL(JC,KOP,1) = 1
        WRD(I:I) = '$'
        MLST(I) = KOP
        CONTINUE
      END DO
      DO I = K+1,L-1
        IF(WRD(I:I)/='*' .AND. WRD(I:I)/='/') CYCLE
        KOP = KOP+1
        CALL SSUB(I,KOP,MFRM,OPTABL,JC,MLST,IER)
        IF(IER/=0) RETURN
        IF(WRD(I:I)=='*') OPTABL(JC,KOP,1) = 2
        IF(WRD(I:I)=='/') OPTABL(JC,KOP,1) = 3
        WRD(I:I) = '$'
        MLST(I) = KOP
      END DO
      J = JBL(K-1,1)+1
C       J is the first nonblank position in the [K,L] input interval
      CH = WRD(J:J)
      IF(CH=='$') GOTO 21
      IF(CH=='+') WRD(J:J) = ' '
      IF(CH=='+') CH = ' '
      IF(CH/='-') IER = J
      IF(IER/=0) RETURN
      KOP = KOP+1
      J1 = JBL(J,1)+1
      IF(WRD(J1:J1)/='$') IER = J1
      IF(IER/=0) RETURN
      OPTABL(JC,KOP,1) = 6
      OPTABL(JC,KOP,2) = MLST(J1)
C      WRD(J1:J1) = '$' ! Not needed because position is already coded $
      MLST(J1) = KOP
      WRD(J:J) = ' '
21    DO I = K+1,L-1
        IF(WRD(I:I)/='+' .AND. WRD(I:I)/='-') CYCLE
        KOP = KOP+1
        CALL SSUB(I,KOP,MFRM,OPTABL,JC,MLST,IER)
        IF(IER/=0) RETURN
        IF(WRD(I:I)=='+') OPTABL(JC,KOP,1) = 4
        IF(WRD(I:I)=='-') OPTABL(JC,KOP,1) = 5
        WRD(I:I) = '$'
        MLST(I) = KOP
      END DO
      END SUBROUTINE
C
      SUBROUTINE FNDEND(K)
C Finds end of file K for appending; Lahey and Microsoft compilers requires
C backspace. Also UNIX compiler
      BACKSPACE K
10    READ(K,'()',END=20)
      GOTO 10
20    BACKSPACE K
      END SUBROUTINE
C
      SUBROUTINE FORMLA(FORMS,MES,ALT,USE,OPTABL,FWRK)
C This reads character string WORD for a formula defining a variable from input
C variables listed by name in IDENT, and creates a set of instructions in OPTABL
C that compute this variable from any score record on the IDENT variables.
C FORMS lists the NFRM formulas already set.
C Basic functions in alphebetical order:
C   ABS( ), ACOS( ), ASIN( ), ATAN( ), COS( ), EXP( ), INT( ),
C   KUT( , ), LOG( ), LN( ), MAX( , ), MIN( , ), MOD( , ), NINT( ),
C   SQRT( ), SIN(), TAN( ),
C   Variables: X, M, S, H, L, or Z followed by a positive integer.
      PARAMETER ( MFN=25, MOP=40, ML=139 ) ! ML increased from 82 to max capacity less 1 as precaution
      LOGICAL QLET, DIGT, BAS, ALT, USE, QNEW
      CHARACTER FORMS(MFRM)*(ML), WORD*(ML), WRD*(ML), FNS(7:MFN)*4,
     +  CH6*6, CH, CHL, CHR, CF*12
      REAL FWRK(MFRM,MOP), TX(MFN),T1(MFN),T2(MFN),T3(MFN),T4(MFN),Y(5)
      INTEGER OPTABL(MFRM,0:MOP,3), LPN(3,MOP), FLST(ML), MLST(ML)
C       <LPN(1,J),LPN(2,J)> are the L/R location in WRD of the Jth pair of
C         parentheses, LPN(3,J) is its hierarchy level.
C       In OPTABL(N,I,J), N is the defined formula No.; I indexes steps
C         defining this formula; J=1 holds code for this step's operation,
C         J=2/3 hold Med-term indices of this operation's 1st/2nd arguments.
C         OPTABL(N,0,J) is number of operations in formula N if J=1, number of
C         variables in formula N if J=2, and length of formula N if J=3
C       FLST(L) is integer code for the operation called at position L in WRD.
C       MLST(L) is the index of the Med-term called at WRD position L.
C       FWRK(N,J) is the current value of Med-term J for function N.  Only
C         the constants are loaded when FORMULA is run.  The other terms are
C         computed when COMPUT is called.
      COMMON /F/ MFRM, NFRM
      COMMON /W/ LL, WRD
      COMMON /WORD/ WORD
      COMMON /B/ BAD
      COMMON /CF/ CF
      DATA FNS/'MAX ','MIN ','MOD ','KUT ',' ',' ','ABS ','SQRT',
     +         'EXP ','LN  ','LOG ','SIN ','ASIN','COS ','ACOS','TAN ',
     +         'ATAN','NINT','INT '/
C     Also assign OPTABL codes: ^,1; *,2; /,3; +,4; binary-,5; unary-,6;
C       input-variable,0; input-constant,-1. Indexing of FNS starts at 7.
C       Functions 7-10 are dyadic, 13-up are monadic. The  are open slots
C       for two dyadic functions that can be added with no reprogramming except
C       in COMPUT. New function KUT(X,c) is 1 if X  c and is 0 otherwise.
C     Code for intermediate formula parsing: @, named function; $, input
C          term (either constant or variable; ^, power (replaces **).
      MES = 0; QNEW = .TRUE.; NTRY = 0
C       QNEW=T flags work on a new formula rather than revision of an old one.
      IF(NFRM>=MFRM) GOTO 59
      CALL SYSTEM('cls')
490   IF(NFRM<=0) THEN
        WRITE(6,'(/" Type a formula defining a function of inputs ha",
     +    "ving dummy names d1, d2, ..."/" where d is X, M, S, H, L,",
     +    " or Z.  Otherwise, hit RETURN to abort definition."//" Re",
     +    "minder: Xi is an input variable; Mi/Si/Hi/Li are Mean/SD/",
     +    "High/Low"/11X,"on Xi; Zi is Xi rescaled as deviancy."//)')
        READ(5,'(A)') WORD
        LL = LAST(WORD)
        IF(LL==0) RETURN
        NFRM = 1
        JC = 1
      GOTO 10
      ELSE
        WRITE(6,'(/" Your formulas already defined are")')
        CALL SEEFRM(NFRM,MFRM,FORMS)
        IF(NFRM<20) WRITE(6,'()')
        IF(.NOT.USE) WRITE(6,'(" To revise one of these enter its ind",
     +    "ex, or its index preceded by "" D "" to"/" Delete it compl",
     +    "etely.  Otherwise hit RETURN to create another formula, or"/
     +    " any letter except Q to exit formula editing. ("" Q "" qui",
     +    "ts entirely while"/" saving FORMULAS if changed.)"/)')
        IF(USE) WRITE(6,'(" Since Jobs have been set from these formu",
     +    "las, their revision is no longer"/" allowed.  Hit RETURN t",
     +    "o create another, or any letter except Q to exit"/" formul",
     +    "la editing. ("" Q "" quits entirely while"/" saving FORMUL",
     +    "AS if changed.)"/)')
        CALL SCANC(J,0,'I',5,CH,L)
        IF(J<0) MES = 1
        IF(CH=='Q' .OR. CH=='q') MES = 99
        IF(MES>=1 .OR. USE.AND.J/=0) RETURN
        IF(J>0 .AND. (CH=='D'.OR. CH=='d')) THEN
          READ(2,*) JC
          JC = MAX(1,MIN(NFRM,JC))
          WRITE(6,'(" Hit RETURN if you are sure that you want formu",
     +      "la ",A," eliminated. If not,"/" enter "" S "" to save ",
     +      "it in last place, or anything else to cancel order.")')
     +      CF(:JF(JC))
          CALL SCANC(J,0,'I',5,CH,L)
          IF(CH=='s') CH = 'S'
          IF(J/=0 .AND. CH/='S') GOTO 490
          WRD = FORMS(JC)
          DO I = JC+1,NFRM
            FORMS(I-1) = FORMS(I)
          END DO
          IF(CH=='S') FORMS(NFRM) = WRD
          IF(CH/='S') NFRM = NFRM-1
          ALT = .TRUE.
          GOTO 490
        ELSE IF(DIGT(CH)) THEN
          READ(2,*) JC
          JC = MAX(1,MIN(NFRM,JC))
          LL = OPTABL(JC,0,3)
          WORD = FORMS(JC)
          QNEW = .FALSE.;
          GOTO 499
        ELSE IF(J>0) THEN
          WRITE(6,'(" You didn''t pick an old formula, so presum",
     +      "ably you want to start a new one.")')
        END IF
        NFRM = NFRM+1; JC = NFRM; IER = 0
        WORD = '()'; LL = 10
      END IF
499   IER = 0; NTRY = -1
500   NTRY = NTRY+1
      IF(NTRY>35) THEN  ! Limit under 10 more than enough
        IF(QNEW) NFRM = NFRM-1; RETURN
      END IF
      IF(NTRY>1. AND. IER/=0) WRITE(6,'(/1X,A," Attempt ",A,1X,35A)')
     +  '', CF(:JF(NTRY)), ('',I=1,MIN(35,NTRY-1))
cc      IF(IER==0) WRITE(6,'(/" Formula No. ",A," for defining new vari",
      IF(NTRY<=1) WRITE(6,'(/" Formula No. ",A," for defining new var",
     +  "iables is now"//1X,A//" Hit RETURN if what you want.  Other",
     +  "wise, enter a revision or "" = "" to abort."/)') CF(:JF(JC)),
     +  WORD(2:LL-1)
      IF(IER/=0) WRITE(6,'(/" Enter a corrected version of this form",
     +  "ula, or "" = "" to abort."/)')

      READ(5,'(A)') WRD; J = LAST(WRD)
      IF(WRD(:1)=='=') THEN
        IF(QNEW) NFRM = NFRM-1; MES = -1; RETURN
      END IF
      IF(J==0) GOTO 16
      IF(J>ML-3) THEN
        WRITE(6,'(/" A formula can be at most ",A," characters long."
     +    "  Try again.")') CF(:JF(ML-3)); IER = 1; GOTO 500
      END IF
      WORD = WRD; LL = J
C Delete any blanks, convert any l.c. letters to u.c., and surround with parens
10    NVAR = 1; N = 0; MK = 0
      DO L = 1,LL-2
        IF(WORD(L:L+1)=='**') WORD(L:L+1) = '^ '
        IF(WORD(L:L+2)=='CUT') WORD(L:L) = 'K'
        IF((WORD(L:L)=='D'.OR.WORD(L:L)=='Y') .AND. DIGT(WORD(L+1:L+1)))
     +    WORD(L:L) = 'X'    ! D or Y for X is a tempting error
      END DO
      DO L = 1,LL
        K = ICHAR(WORD(L:L))
        IF(K==32) CYCLE
        IF(K>=97 .AND. K<=122) K = K-32
        N = N+1
        WORD(N:N) = CHAR(K)
        IF(WORD(N:N)=='=') MK = N
      END DO
      LL = N+2-MK
      WORD(:LL) = '('//WORD(MK+1:N)//')'
      WORD(LL+1:) = ' '
      IF(IER==0) GOTO 500
      WRITE(6,'(" Parsing revised formula . . . . .")')
16    WRD = WORD; MLST = -9; FLST = -9; IER = 0
      DO I = 1,MOP
        DO J = 1,3
          OPTABL(JC,I,J) = -9
        END DO
      END DO
C Parse WRD
      KOP = 0; KSKP = 0; NRL = 0
      BG: DO J = 2,LL-1
        N = 0
        CH = WORD(J:J); K = ICHAR(CH)  ! Shd have WORD = WRD at this point
        IF(J<=KSKP .OR. K==40 .OR. K==41 .OR. K==42 .OR. K==43 .OR.
     +    K==45 .OR. K==47. OR. K==94) CYCLE BG
        IF(QLET(CH)) THEN   ! Is CH a letter?
          L = NAMEND(J,1); M = L-J+1   ! M is length of character string
          IF(M>4) GOTO 19     ! ! L is position in WRD of string end
          KSKP = L            ! WRD position after which next parse pass begins
          CH6 = WRD(J:L)      ! Trailing blanks shd be automatic
          IF(WRD(L+1:L+1)=='(') N = ISFN(CH6,FNS,MFN)  ! Index of FNS function
          IF(N>0) THEN
            FLST(J) = N; WRD(J:L) = '@   '; CYCLE BG
          ELSE IF(CH=='X' .OR. CH=='M' .OR. CH=='S' .OR. CH=='H' .OR.
     +          CH=='L' .OR. CH=='Z') THEN
            IF(.NOT.DIGT(WRD(J+1:J+1))) GOTO 19
            N = ICHAR(WRD(J+1:J+1))-48
            IF(DIGT(WRD(J+2:J+2))) N = 10*N + ICHAR(WRD(J+2:J+2))-48
            LEN = 1+JF(N)  ! Term is a variable N whose name has length LEN
            NVAR = MAX(NVAR,N)
            KSKP = J+LEN-1
            KOP = KOP+1
            OPTABL(JC,KOP,1) = 0
            IF(CH=='X') OPTABL(JC,KOP,2) = N
            IF(CH=='M') OPTABL(JC,KOP,2) = N+100
            IF(CH=='S') OPTABL(JC,KOP,2) = N+200
            IF(CH=='H') OPTABL(JC,KOP,2) = N+300
            IF(CH=='L') OPTABL(JC,KOP,2) = N+400
            IF(CH=='Z') OPTABL(JC,KOP,2) = N+500
C             For operation No. 0, 1st argument term is index of input variable
C             preceded by code for kind X, M, S, H, L, or Z.
            WRD(J:KSKP) = '$     '
            MLST(J) = KOP
            CYCLE BG
          END IF
19        CALL SHOERR(J,' Unrecognizable name:')
          IER = 1; GOTO 500
        ELSE IF(DIGT(WRD(J:J)) .OR. WRD(J:J)=='.') THEN
          L = NUMEND(J,1,IER)
          KSKP = L
          IF(IER/=0) CALL SHOERR(IER,' Improper decimal:')
          IF(WRD(J:J)=='.'.AND.L==J) CALL SHOERR(J,' Isolated decimal:')
          IF(WRD(J:J)=='.'.AND.L==J .OR. IER/=0) GOTO 500
          READ(WRD(J:L),*,ERR=500) R
          KOP = KOP+1
          OPTABL(JC,KOP,1) = -1
C           When operation is a constant, no OPTABL arguments are needed.
          FWRK(JC,KOP) = R
          IF(R==0. .AND. WRD(J-1:J-1)=='/') THEN
            CALL SHOERR(J,' Division by zero is inadmissible:')
            IER = 1; GOTO 500
          END IF
          IF(ANINT(R)/=R) NRL = NRL+1
          WRD(J:L) = '$     '
          MLST(J) = KOP
          CYCLE BG
        END IF
      END DO BG

C Scan for remaining errors
      DO J = 1,LL-1
        CH = WRD(J:J)
        JR = J+1
CC        IF(CH=='^') JR = J+2
        CHR = WRD(JR:JR)
        IF(BAS(J).AND.(BAS(JR).OR.CHR==')') .OR. CH=='('.AND.BAS(JR)
     +     .AND.CHR/='-') THEN
          CALL SHOERR(J,' Inacceptable construction:')
          IER = 1; GOTO 500
        END IF
      END DO
      DO J = 1,LL
        CH = WRD(J:J)
        IF(CH==' ' .OR. CH=='(' .OR. CH==')' .OR. CH==',' .OR.
     +   CH=='-') CYCLE
        JL = JBL(J,-1)-1
        JR = JBL(J,1)+1
        CHL = WRD(JL:JL)
        CHR = WRD(JR:JR)
        IF(CH=='@') THEN
          IF(CHR/='(') THEN
            CALL SHOERR(J,' Argument improperly identified:')
            IER = 1; GOTO 500
          END IF
          IF(CHL/='('.AND.CHL/='^'.AND.CHL/='*'.AND.CHL/='/'.AND.
     +      CHL/='+'.AND.CHL/='-'.AND.CHL/=',') THEN
            CALL SHOERR(J,' Function improperly flanked on left:')
            IER = 1; GOTO 500
          END IF
          CYCLE
        ELSE IF(CH=='$') THEN
          IF(CHR/=')'.AND.CHR/=','.AND.CHR/='^'.AND.CHR/='*'.
     +      AND.CHR/='/'.AND.CHR/='+'.AND.CHR/='-') THEN
            CALL SHOERR(J,' Term improperly flanked on right:')
            IER = 1; GOTO 500
          END IF
          IF(CHL/='('.AND.CHL/=','.AND.CHL/='^'.AND.CHL/='*'.
     +      AND.CHL/='/'.AND.CHL/='+'.AND.CHL/='-') THEN
            CALL SHOERR(J,' Term improperly flanked on left:')
            IER = 1; GOTO 500
          END IF
          CYCLE
        ELSE IF(CH==',') THEN
          IF(CHR/='('.AND.CHR/='$'.AND.CHR/='-') THEN
            CALL SHOERR(J,' Term improperly flanked on right:')
            IER = 1; GOTO 500
          ELSE IF(CHL/=')'.AND.CHL/='$') THEN
            CALL SHOERR(J,' Term improperly flanked on left:')
            IER = 1; GOTO 500
          END IF
        END IF
        IF(CH=='^'.OR.CH=='*'.OR.CH=='/'.OR.CH=='+'.OR.CH.
     +      EQ.'-') THEN
          IF(CHR/='@'.AND.CHR/='$'.AND.CHR/='-'.AND.CHR/='(') THEN
            CALL SHOERR(J,' Righhand argument unrecognizable:')
            IER = 1; GOTO 500
          END IF
          IF(CHL/='$'.AND.CHL/='-'.AND.CHL/=')') THEN
            CALL SHOERR(J,' lefthand argument unrecognizable:')
            IER = 1; GOTO 500
          END IF
          CYCLE
        END IF
        CALL SHOERR(J,' Unclassifiable error:')
        IER = 1; GOTO 500
      END DO

C Check sequence of input variables
      DO I = 1,NVAR  ! Match all dummy-variable indices up to max declared
        K = 0
        DO J = 1,KOP  ! against all declared in an input step
          IF(OPTABL(JC,J,1)==0.AND.MOD(OPTABL(JC,J,2),100)==I) K=1
        END DO
        IF(K==1 .OR. NVAR==1) CYCLE
        WRITE(6,'(" Absence of dummy index ",A," breaks your formula",
     +    "''s sequence of input terms --"/" allowed but maybe unint",
     +    "ended. Enter anything if OK, or hit RETURN to revise.")')
     +    CF(:JF(I))
        CALL SCANC(J,0,'B',5,CH,L)
        IF(J==0) GOTO 500
      END DO
C Parse the parenthese
      CALL PARENS(LPN,NP,MAXLEV,WORD,IER)
      IF(IER/=0) GOTO 500
C Finally, assemble OPTABL
      DO LEVL = 1,MAXLEV
        DO KK = 1,NP
          IF(LPN(3,KK)/=LEVL) CYCLE
          KL = LPN(1,KK)
          KR = LPN(2,KK)
          LF = MAX(1,JBL(KL,-1)-1)
          CH = WRD(LF:LF)
C   Find comma, if any
          KOMMA = 0
          DO L = KL+1,KR-1
            IF(WRD(L:L)==',') KOMMA = KOMMA + 1
            IF(WRD(L:L)==',') LKOM = L
          END DO
          IF(KOMMA>0) THEN
            IF(CH/='@') THEN
              CALL SHOERR(L,' Function not identifiable:')
              IER = 1;  GOTO 500
            END IF
            IF(FLST(LF)>12 .OR. KOMMA>1.AND.FLST(LF)<7) THEN
              CALL SHOERR(LKOM,' Too many arguments:')
              IER = 1; GOTO 500
            END IF
            CALL EVAL(KL+1,LKOM-1,KOP,MFRM,OPTABL,JC,MLST,IER)
            CALL EVAL(LKOM+1,KR-1,KOP,MFRM,OPTABL,JC,MLST,IER)
            KOP = KOP+1
            OPTABL(JC,KOP,1) = FLST(LF)
            OPTABL(JC,KOP,2) = MLST(JBL(KL,1)+1)
            OPTABL(JC,KOP,3) = MLST(JBL(LKOM,1)+1)
            WRD(LF:LF) = '$'
            MLST(LF) = KOP
            CALL WIPE(KL,KR)
          ELSE IF(KOMMA==0) THEN
            CALL EVAL(KL+1,KR-1,KOP,MFRM,OPTABL,JC,MLST,IER)
            IF(CH=='@' .OR. CH=='-') THEN
              KOP = KOP+1
              IF(CH=='@') THEN
                OPTABL(JC,KOP,1) = FLST(LF)
                IF(FLST(LF)>=7 .AND. FLST(LF)<=12) THEN
                  CALL SHOERR(LF,' Not enough arguments:')
                  IER = 1; GOTO 500
                END IF
              END IF
              IF(CH=='-') OPTABL(JC,KOP,1) = 6
              OPTABL(JC,KOP,2) = MLST(JBL(KL,1)+1)
              WRD(LF:LF) = '$'
              MLST(LF) = KOP
              CALL WIPE(KL,KR)
            ELSE
              WRD(KL:KL) = ' '
              WRD(KR:KR) = ' '
            END IF
          END IF
          IF(IER/=0) GOTO 60
        END DO
      END DO
      OPTABL(JC,0,1) = KOP
      OPTABL(JC,0,2) = NVAR
      OPTABL(JC,0,3) = LL
      FORMS(JC) = WORD
C       OPTABL is now complete. The formula's output will be in FRWK(KOP)
C Determine whether formula maps integer X-dummies into integer output
      CH = 'I'
      LP: DO I = 1,KOP
        JOP = OPTABL(JC,I,1)
        IF(JOP<0) THEN
          IF(NRL>0) CH = 'R'   ! Non-integer constant
        ELSE IF(JOP==0) THEN
          K = OPTABL(JC,I,2)
          IF(K<100 .OR. K>=300.AND.K<500) CYCLE LP  ! Raw, Hi, or Lo score
          CH = 'R'
        ELSE IF(JOP==3 .OR. JOP>=14.AND.JOP<=23) THEN
C ******* Warning. This line may need change if blank slot 11 or 12 is filled.
          CH = 'R'
        END IF
      END DO LP
      FORMS(JC)(ML:ML) = CH
C Flag in near-end of FORMS(_) whether formula uses the variable's statistics
      IF(OPTABL(JC,0,3)>=ML-1) GOTO 59  ! Formulas shouldn't ever be this long
      DO I = 1,OPTABL(JC,0,3)   ! Not sure whether this is ever wanted
        CH = FORMS(JC)(I:I)
        IF(CH=='M'.OR.CH=='S'.OR.CH=='H'.OR.CH=='L'.OR.CH=='Z') THEN
          FORMS(JC)(ML-1:ML-1) = 'N'
        END IF
      END DO
59    IF(JC>=MFRM) THEN
        WRITE(6,'(/" The function-definition register, now full, is ",
     +    "being resized.")'); IF(JC>=MFRM) RETURN
        OPEN(4,FILE='FORMULAS',FORM='UNFORMATTED')
        WRITE(4) NFRM
        WRITE(4) (FORMS(J),J=1,NFRM)  ! Must save flags in posions ML-1:ML
        WRITE(4) (((OPTABL(I,J,K),I=1,NFRM),J=0,MOP),K=1,3)
        WRITE(4) ((FWRK(I,J),I=1,NFRM),J=1,MOP)
        CLOSE(4); NFRM = -NFRM; RETURN
      END IF

C  Test formula JC just created
      T1=0.; T2=1.; T3=100.; T4=-100.; K = 0
      DO I = 1,5
        Z = I-3; IF(ABS(I-3)>1) Z = Z*50.; TX=Z  ! All terms in TX set to Z
        CALL COMPUT(Y(I),JC,TX,NVAR,T1,T2,T3,T4,OPTABL,FWRK)
        Y(I) = MAX(0.,Y(I)-BAD+1.); K = K + NINT(Y(I))
      END DO
      IF(K>0) THEN
        IF(K==5) THEN
          M = 10; WRD(:M) = 'all of its'
        ELSE IF(K==4) THEN
          M = 11; WRD(:M) = 'most of its'
        ELSE IF(K==1 .AND. Y(3)>0) THEN
          M = 4; WRD(:M) = 'zero'
        ELSE IF(K==2 .AND. Y(1)+Y(2)==2) THEN
          M = 8; WRD(:M) = 'negative'
        ELSE IF(K==2 .AND. Y(4)+Y(5)==2) THEN
          M = 8; WRD(:M) = 'positive'
        ELSE IF(K==3 .AND. Y(4)+Y(5)==0) THEN
          M = 12; WRD(:M) = 'non-positive'
        ELSE
          M = 11; WRD(:M) = 'some of its'
        END IF
        WRITE(6,'(/" >>>> WARNING: This formula''s value is corrupt ",
     +    "for ",A," arguments."/15X,"Hit RETURN to re-think what yo",
     +    "u want here, or enter anything"/15X,"to continue at risk ",
     +    "of creating garbage variables with this.")') WRD(:M)
        CALL SCANC(J,0,'B',5,CH,L)
        IF(J==0) THEN
          IF(QNEW) NFRM = NFRM-1; MES = 1; RETURN
        END IF
      END IF
      ALT = .TRUE.
      WRITE(6,'(/" Function ",A," is ready for use. Hit RETURN to def",
     +  "ine or revise another, or"/" enter anything except ""Q"" to",
     +  " move on.  (The exception Quits this run"/" while saving ",
     +  "the current created-formulas list.) ")') CF(:JF(JC))
      CALL SCANC(J,1,'I',5,CH,L)
      IF(J==0) GOTO 490
      IF(CH=='Q' .OR. CH=='q') MES = 99
      RETURN
60    CALL SHOERR(IER,' Improper construction in this vicinity:')
      GOTO 500
      END SUBROUTINE
C
      SUBROUTINE INFO       ! INFO(KND)
      CHARACTER C11,C12,C21,C22,BAR,LIN
      DATA C11,C12,C21,C22,BAR,LIN/'','','','','',''/
CC      IF(KND>0) THEN
CC        C11='+'; C12='+'; C21='+'; C22='+'; BAR='|'; LIN='-'
CC      END IF
      WRITE(6,'(/2X,76A)') C11, (LIN,I=1,74), C12
      WRITE(6,'(2X,A,5X,"Function creation here follows the standard",
     +  " Fortran format for",7X,A/2X,A," line-function definitions.",
     +  "  Each formula is written as the righthand",5X,A/2X,A," sid",
     +  "e (you can omit lefthand part "" Y = "") of some equation ",
     +  "having form",3X,A)') (BAR,I=1,6)
      WRITE(6,'(2X,A,74X,A)') BAR, BAR
      WRITE(6,'(2X,A,24X,"Y = f(Di,Dj,...)",34X,A/2X,A,74X,A/2X,A,
     +  " wherein f( , ,...) is a schema consisting of names for pri",
     +  "mitive oper-",3X,A/2X,A," ators/functions, parentheses, and",
     +  " occasionally commas to separate the",4X,A/2X,A," arguments",
     +  " of binary functions; while its D-terms are dummies that mu",
     +  "st",3X,A/2X,A," always be written as X, M, S, H, L, or Z fo",
     +  "llowed by a positive integer. ",A/2X,A," X-dummies will bec",
     +  "ome raw-score variables from your input file; dummies  ",A/2X,
     +  A," Mi, Si, Hi, Li are respectively the Mean, SD, High, and ",
     +  "Low of raw-score ",A)') (BAR,I=1,16)
      WRITE(6,'(2X,A," variable Xi; and Z-dummies are deviancy scores",
     +  " on the corresponding raw  ",A/2X,A," variables.  That is, ",
     +  "Zi = (Xi-Mi)/Si.  In applications, each dummy term  ",A/2X,A,
     +  " Dj''s nominal index j is replaced by the jth real index in ",
     +  "a list thereof ",A/2X,A," selecting the particular input var",
     +  "iables for this derivation.  Dummy",5X,A/2X,A," terms can h",
     +  "ave nominal indices in arbitrary order with any number of",5X,
     +  A/2X,A," repetitions; but an application must list as many re",
     +  "al input indices as  ",A/2X,A," the largest nominal index in",
     +  " the formula. (The computation ignores any",3X,A/2X,A," list",
     +  "ed input not picked by a dummy index.)",31X,A)') (BAR,I=1,16)
      CALL WAIT
      WRITE(6,'(2X,A,4X,"When composing formulas, standard rules hold",
     +  " for parentheses and",6X,A/2X,A," precedence among arithmeti",
     +  "c operators. The latter can never be written",3X,A/2X,A," co",
     +  "nsecutively.  For example, -X1+X2*X3 is the same as (-X1)+(X",
     +  "2*X3)",6X,A/2X,A," while X1/-X2 is illegal but can be accept",
     +  "ably entered as X1/(-X2).",7X,A/2X,A,74X,A/2X,A,5X,"The admi",
     +  "ssible primitives and their required notation are ordinary",
     +  3X,A/2X,A," arithmetic operators +, -, *, /, and ** (or ^ if ",
     +  "you prefer), which are  ",A/2X,A," placed between (or for un",
     +  "ary minus in front of) their arguments, and the ",A/2X,A,
     +  " functions named MAX( , ), MIN( , ), MOD( , ), KUT( , ), A",
     +  "BS( ), SQRT( ), ",A/2X,A," EXP( ), LOG( ), LN( ), SIN(), COS",
     +  "( ), TAN( ), ASIN( ), ACOS( ), ATAN( ), ",A/2X,A," NINT( ), ",
     +  "and INT( ), which must always be followed in parentheses by",
     +  5X,A/2X,A," one or two argument expressions as indicated.  ",
     +  "Function names can be",5X,A)') (BAR,I=1,24)
      WRITE(6,'(2X,A," entered in lower case, but their spelling mus",
     +  "t be exactly as shown apart ",A/2X,A," from blanks (which a",
     +  "re ignored) and omission of trailing letters not",5X,A/2X,A,
     "  " needed to distinguish that name from the others.  All thes",
     +  "e but one are",2X,A/2X,A," standard Fortran functions, using ",
     +  "generic names (no distintion between",3X,A/2X,A," Integer an",
     +  "d Real), and writing LN"," and LOG respectively for natural",
     +  7X,A/2X,A," logarithms and logs to base 10.  All the trigono",
     +  "metric functions measure ",A/2X,A," angles in degrees.  The",
     +  " nonstandard function is KUT(x,y), which takes",4X,A/2X,A,
     +  " value 0 if x < y and 1 if x  y.  (As explained in this pr",
     +  "ogram''s",8X,A/2X,A," documentation, KUT can be used to cre",
     +  "ate multistage step-functions.)",5X,A)') (BAR,I=1,18)
      CALL WAIT
      WRITE(6,'(2X,A,5X,"Each Operation-3 job applies a particular fo",
     +  "rmula chosen from the",4X,A/2X,A," created-formulas list to ",
     +  "a selection of the datafile''s input variables.  ",A/2X,A," L",
     +  "et n be the largest nominal index explicit in the chosen form",
     +  "ula''s",6X,A/2X,A," dummies.  Then execution of this Job defi",
     +  "nes a new variable by applying  ",A/2X,A," this formula to th",
     +  "e first n selected variables in the order listed, a",4X,A/2X,A,
     +  " second new variable by applying the formula to the next n se",
     +  "lection-list ",A/2X,A," variables, and so on until fewer than",
     +  " n selected variables remain.  You",2X,A/2X,A," will probably",
     +  " find this provision for deriving several new variables in  ",
     +  A/2X,A," one Operation-3 job to be useful mainly for rescaling",
     +  " large groups of",4X,A/2X,A," old variables by the same singl",
     +  "e-argument transformation.",16X,A/2X,A,74X,A)') (BAR,I=1,22)
      WRITE(6,'(2X,A,7X,"Note.  Each derived variable is finally resc",
     +  "aled by some integral  ",A/2X,A,3X,"power of 10 to optimize ",
     +  "discrimination in integer range [-998, 999].",3X,A/2X,A,3X,
     +  "The rescaling multipliers are reported in this data set''s",
     +  " logfile.",5X,A)') (BAR,I=1,6)
      WRITE(6,'(2X,76A)') C21, (LIN,I=1,74), C22
      CALL WAIT

C Ŀ
C      Function creation here follows the standard Fortran format for       
C  line-function definitions.  Each formula is written as the righthand     
C  side (you can omit lefthand part " Y = ") of some equation having form   
C                                                                           
C                         Y = f(Di,Dj,...)                                  
C                                                                           
C  wherein f( , ,...) is a schema consisting of names for primitive oper-   
C  ators/functions, parentheses, and occasionally commas to separate the    
C  arguments of binary functions; while its D-terms are dummies that must   
C  always be written as X, M, S, H, L, or Z followed by a positive integer. 
C  X-dummies will become raw-score variables from your input file; dummies  
C  Mi, Si, Hi, Li are respectively the Mean, SD, High, and Low of raw-score 
C  variable Xi; and Z-dummies are deviancy scores on the corresponding raw  
C  variables.  That is, Zi = (Xi-Mi)/Si.  In applications, each dummy term  
C  Dj's nominal index j is replaced by the jth real index in a list thereof 
C  selecting the particular input variables for this derivation.  Dummy     
C  terms can have nominal indices in arbitrary order with any number of     
C  repetitions; but an application must list as many real input indices as  
C  the largest nominal index in the formula. (The computation ignores any   
C  listed input not picked by a dummy index.)                               
C                          { pause}                                         
C     When composing formulas, standard rules hold for parentheses and      
C  precedence among arithmetic operators. The latter can never be written   
C  consecutively.  For example, -X1+X2*X3 is the same as (-X1)+(X2*X3)      
C  while X1/-X2 is illegal but can be acceptably entered as X1/(-X2).       
C                                                                           
C      The admissible primitives and their required notation are ordinary   
C  arithmetic operators +, -, *, /, and ** (or ^ if you prefer), which are  
C  placed between (or for unary minus in front of) their arguments, and the 
C  functions named MAX( , ), MIN( , ), MOD( , ), KUT( , ), ABS( ), SQRT( ), 
C  EXP( ), LOG( ), LN( ), SIN(), COS( ), TAN( ), ASIN( ), ACOS( ), ATAN( ), 
C  NINT( ), and INT( ), which must always be followed in parentheses by     
C  one or two argument expressions as indicated.  Function names can be     
C  entered in lower case, but their spelling must be exactly as shown apart 
C  from blanks (which are ignored) and omission of trailing letters not     
C  needed to distinguish that name from the others.  All these but one are  
C  standard Fortran functions, using generic names (no distinction between  
C  Integer and Real), and writing LN and LOG respectively for natural       
C  logarithms and logs to base 10.  All the trigonometric functions measure 
C  angles in degrees.  The nonstandard function is KUT(x,y), which takes    
C  value 0 if x < y and 1 if x  y.  (As explained in this program's        
C  documentation, KUT can be used to create multistage step-functions.)     
C                          { pause}                                         
C      Each Operation-3 job applies a particular formula chosen from the    
C  created-formulas list to a selection of the datafile's input variables.  
C  Let n be the largest nominal index explicit in the chosen formula's      
C  dummies.  Then execution of this Job defines a new variable by applying  
C  this formula to the first n selected variables in the order listed, a    
C  second new variable by applying the formula to the next n selection-list 
C  variables, and so on until fewer than n selected variables remain.  You  
C  will probably find this provision for deriving several new variables in  
C  one Operation-3 job to be useful mainly for rescaling large groups of    
C  old variables by the same single-argument transformation.                
C                                                                           
C        Note.  Each derived variable is finally rescaled by some integral  
C    power of 10 to optimize discrimination in integer range [-998, 999].   
C    The rescaling multipliers are reported in this data set's logfile.     
C 

      END SUBROUTINE
C
      FUNCTION ISFN(CH,FNS,MFN)
C Returns 0 if CH does not name a function; otherwise, the function's index.
C FNS is defined by data statement in subroutine FORMLA
cc      DATA FNS/'MAX ','MIN ','MOD','KUT ',' ',' ','ABS ','SQRT',
cc     +         'EXP ','LN  ','LOG ','SIN','ASIN','COS ','ACOS','TAN ',
cc     +         'ATAN','NINT','INT '/
      CHARACTER FNS(7:*)*4, CH*(*), CH1*1
      ISFN = 0
      CH1 = CH(:1)
      DO J = 7,MFN
        K = 1; IF(CH1=='A'.OR.CH1=='L'.OR.CH1=='M'.OR.CH1=='S') K = 2
        IF(CH(:K)==FNS(J)(:K)) THEN
          ISFN = J; RETURN
        END IF
      END DO
      END FUNCTION
C
      FUNCTION JBL(J,KD)
C Finds start position in WRD if KD0, or end position if KD>0, of the
C unbroken string of blanks adjacent to or surrounding index J.
      PARAMETER ( ML=139 )    ! ( ML=139 )
      CHARACTER WRD*(ML)
      COMMON /W/ LL, WRD
      M = 1; IF(KD<=0) M = -1
      JBL = MAX(1,MIN(ML,J))
      IF(J<=1.AND.KD<=0 .OR. J>ML-3.AND.KD>0) RETURN
10    IF(WRD(JBL+M:JBL+M)/=' ') RETURN
      JBL = JBL+M
      IF(JBL<=1 .OR. JBL>=ML) RETURN
      GOTO 10
      END FUNCTION
C
      FUNCTION LAST(WORD)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as L. If the string is empty, LAST is returned as 0.
      CHARACTER WORD*(*)
      M = LEN(WORD)
      WORD(:M) = ADJUSTL(WORD(:M))
      LAST = LEN_TRIM(WORD(:ABS(M)))
      END
C
      FUNCTION QLET(CH)
C Return QLET = T if CH is letter, otherwise F.
      LOGICAL QLET
      CHARACTER CH
      QLET = .FALSE.
      IF(ICHAR(CH)>=65 .AND. ICHAR(CH)<=90) QLET = .TRUE.
      IF(ICHAR(CH)>=97 .AND. ICHAR(CH)<=122) QLET = .TRUE.
      END
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
      LOGICAL PRM, QY
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP
      CHARACTER E   ! <<<  Special characters as needed
      WD = GET
      M = LAST(WD)
      LL = 1
5     LL = LL+1; IF(LL<M) GOTO 5
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(WORD(:1)==' ' .OR. WORD(:1)=='.') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
C       Filter out lines other than filenames
      L = LAST(WORD)
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
      J = ICHAR(WORD(11:11)); IF(J<48 .OR. J>57) GOTO 10
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4) .AND. NAME(I)(L+5:L+5)==' ')
     +    GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NL)
      IF(NL>0) WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      L1 = LAST(NAM1); L2 = LAST(NAM2)
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      L1 = LAST(WRD1); L2 = LAST(WRD2)
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A number terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION
C
      SUBROUTINE MAKNAM(CH8,IDENT,NV)
C Construct new name from name CH8 by prepending/overwriting start of CH8 with
C letter string picked by NXT. And check old names in IDENT to avoid duplicates
      CHARACTER(8) CH8, IDENT(*), CHB
      DATA NXT/0/
      L = LAST(CH8)
      IF(L==0) RETURN  ! Should never happen
10    CHB = CH8   !  MOD(J-1,K)+1 cycles from 1 to K with start at 1 with J=1
      NXT = NXT+1    !   MOD(J,K) cycles from 0 to K-1 with start at 0 with J=1
      NA = MOD(NXT-1,26)+1
      NB = MOD((NXT-1)/26,26); IF(NXT>702) NB = MOD(((NXT-702)/26)+1,26)+1
      NC = (NXT-1)/702
      MOV = MIN(8-L,MIN(1,NA)+MIN(1,NB)+MIN(1,NC))
      CHB(MOV+1:) = CH8(:8-MOV)
      CHB(1:1) = CHAR(64+NA)
      IF(NB>0) CHB(2:2) = CHAR(64+NB)
      IF(NC>0) CHB(3:3) = CHAR(64+NC)
      DO I = 1,NV
        IF(CHB==IDENT(I)) GOTO 10
      END DO
      CH8 = CHB
      END SUBROUTINE
C
      SUBROUTINE NAME1(F1,F2,M,L)
C This receives a filename in F1 (presumed to start in position 1), solves
C for <base> to be the part of F1 prior to '.' up to M characters, scans the
C subdirectory for the lowest i=1,2,...,99 such that file <base>.Di does not
C already exist, returns <base>.Di in F1(:12), <base>.LOG in F2, and the end
C position of the latter in L.
      LOGICAL QY
      CHARACTER F1*(*), F2*(*), DIGIT
      DIGIT(I) = CHAR(48+I)
      L = 0
10    L = L+1
      IF(L<=M .AND. F1(L:L)/=' ' .AND. F1(L:L)/='.') GOTO 10
      DO I = L+2,12
        F1(I:I) = ' '
      END DO
      F2 = F1
      F1(L:L+1) = '.D'
      F2(L:L+3) = '.LOG'
      L = L+2
      I = 0
20    I = I+1
      IF(I<=9) F1(L:L) = DIGIT(I)
      IF(I>9) F1(L:L+1) = DIGIT(I/10)//DIGIT(MOD(I,10))
      INQUIRE(FILE=F1,EXIST=QY)
      IF(QY .AND. I<99) GOTO 20
      IF(QY .AND. I==99) F1(L:L+1) = DIGIT(0)//DIGIT(0)
      L = L+1
      END SUBROUTINE
C
      FUNCTION NAMEND(J,KD)
C Finds start position in WRD if KD0, or end position if KD>0, of the
C unbroken letter string picked by index J.
      PARAMETER ( ML=139 )    ! ( ML=139 )
      LOGICAL QLET
      CHARACTER WRD*(ML)
      INTEGER NAMEND
      COMMON /W/ LL, WRD
      M = 1
      IF(KD<=0) M = -1
      NAMEND = J
10    IF(.NOT.QLET(WRD(NAMEND+M:NAMEND+M))) RETURN
      NAMEND = NAMEND+M
      IF(NAMEND==1 .OR. NAMEND==80) RETURN
      GOTO 10
      END FUNCTION
C
      FUNCTION NUMEND(J,KD,IER)
C Finds start position in WRD if KD0, or end position if KD>0, of the
C unbroken number-naming string picked by index J.  NOTE: IER > 0 if the
C identified string contains more than one decimal (2nd is at position IER).
      PARAMETER ( ML=139 )    ! ( ML=139 )
      LOGICAL DIGT
      CHARACTER WRD*(ML), CH
      INTEGER NUMEND
      COMMON /W/ LL, WRD
      IER = 0
      JOT = 0
      M = 1
      IF(KD<=0) M = -1
      NUMEND = J
10    CH = WRD(NUMEND+M:NUMEND+M)
      IF(.NOT.DIGT(CH) .AND. CH/='.') RETURN
      NUMEND = NUMEND+M
      IF(CH=='.') JOT = JOT+1
      IF(JOT>1) IER = NUMEND
      IF(IER/=0) RETURN
      IF(NUMEND==1 .OR. NUMEND==80) RETURN
      GOTO 10
      END FUNCTION

      SUBROUTINE ORTH(JX,NV,NY,LST,NFILE,XX,ZZ,AV,LMR,FM1,IER)
C Compute normed Covs for NY items Y indexed in LST; find their NP leading
C principal axes P after variance and from there the NY-by-NP matrix WW of
C weights that transform scores Y into scores on P. ERR returns the percent
C of Y-scores that are missing.
      CHARACTER FM1*37, CF*12
      INTEGER LST(*)
      REAL CV(NY,NY), XX(*), ZZ(*), AV(*), R(NY), T(NY,NY), SD(NY)
      COMMON /B/ BAD
      COMMON /CF/ CF
      WRITE(6,'(/4X,"Solving the Job ",A," normed items for orthonor",
     +  "mal axes")') CF(:JF(JX))
      CV = 0.; T = 0.; MIS = 0; NR = 0
5     REWIND 13  ! Formerly REWIND 3
10    READ(13,END=20) ID, (XX(I),I=1,NV); NR = NR+1
      DO I = 1,NY
        ZZ(I) = XX(LST(I))
        IF(ZZ(I)==BAD) MIS = MIS + 1
        IF(ZZ(I)==BAD) ZZ(I) = AV(LST(I))
      END DO
      DO J = 1,NY
        DO I = 1,J
          CV(I,J) = CV(I,J) + ZZ(I)*ZZ(J)
        END DO
      END DO
      GOTO 10
20    ERR = MIS*100./(NR*NY)
      DO J = 1,NY
        DO I = 1,J
          CV(I,J) = (CV(I,J)/NR-AV(LST(I))*AV(LST(J)))
        END DO
      END DO
      DO J = 1,NY
        SD(J) = SQRT(MAX(.0001,CV(J,J))); CV(J,J) = 1.
        DO I = 1,J-1
          CV(I,J) = CV(I,J)/(SD(I)*SD(J)); CV(J,I) = CV(I,J)
        END DO
      END DO
      CALL EIGS(NY,NY,CV,NY,R,T,NY,1,IER,6)
      IF(IER>0) RETURN
      NP = 0  ! Number of appreciably positive eigenvalues
      DO J = 1,NY                ! When Y = RDF with R rectinormal,
        IF(R(J)<1.E-4) GOTO 50   !      F = Inv[D]R'Y
        NP = NP+1
        S = 1./SQRT(R(J))
        DO I = 1,NY
          T(I,J) = S*T(I,J)
        END DO
      END DO
50    CONTINUE
      NFILE = NFILE+1
      OPEN(NFILE,STATUS='SCRATCH',FORM='UNFORMATTED')
      WRITE(NFILE) NY, NP, ((T(I,J),I=1,NY),J=1,NP), ERR
      WRITE(6,'(4X,"Storing Outlie weights for Job ",A)') CF(:JF(JX))
      END SUBROUTINE

      SUBROUTINE OUTLAY(NFILE,NX,X,Y,PM)
C Return in Y the Outlie of N scores (normed) in X using NXxNP weights in
C NFILE.  PM is the percent of missing scores in this subdistribution.
      REAL,ALLOCATABLE :: W(:,:)
      REAL X(*)
      REWIND NFILE
      READ(NFILE) N, NP
      IF(N/=NX) WRITE(6,'(/" ***** Inconsistency of item number in ",
     +  "subroutine OUTLAY.  The run should crash.")')  ! ***** Should never occur
      ALLOCATE ( W(NX,NP) )
      BACKSPACE NFILE
      READ(NFILE) N, NP, ((W(I,J),I=1,N),J=1,NP), PM
      Y = 0.
      DO J = 1,NP   ! Get X*W
        Z = 0.
        DO I = 1,NX
          Z = Z + X(I)*W(I,J)  ! Score on orthonormal factor J
        END DO
      END DO
      Y = SQRT(Y)  ! Euclidian length of Y-vector
      DEALLOCATE ( W )
      END SUBROUTINE
C
      SUBROUTINE PARENS(LPN,NP,MAXLEV,WORD,IER)
C List the WRD positions of matching parentheses in order of left occurrence.
C LL is the received length of WRD, while NP returns the number of paren pairs.
C LPN(1/2,J) the L/R positions of the Jth paren bracket; LPN(3,J) is its level.
      PARAMETER ( ML=139 )
      CHARACTER WRD*(ML), WORD*(*)
      INTEGER LPN(3,*)
      COMMON /W/ LL, WRD
      IP = 0; JP = 0
      DO L = 2,LL-1
        IF(WRD(L:L)=='(') IP = IP+1; IF(WRD(L:L)==')') JP = JP+1
      END DO
      IER = ABS(IP-JP)
      IF(IP>JP) WRITE(6,'(" Unbalanced parentheses:",I3," lefthand",
     +    " but only",I3," righthand.")') IP, JP
      IF(IP<JP) WRITE(6,'(" Unbalanced parentheses:",I3," rightthand",
     +    " but only",I3," leftthand.")') IP, JP
      IF(IER>0) RETURN
      NP = 0; MAXLEV = 1
      BG: DO I = 1,LL-1
        IF(WRD(I:I)/='(') CYCLE
        NP = NP+1; LPN(1,NP) = I; LPN(3,NP) = 1
        K = 1
        DO J = I+1,LL
          IF(WRD(J:J)/='(' .AND. WRD(J:J)/=')') CYCLE
          IF(WRD(J:J)=='(') THEN
            K = K+1
            LPN(3,NP) = MAX(K,LPN(3,NP))
            MAXLEV = MAX(MAXLEV,K)
          ELSE
            K = K-1
          END IF
          IF(K==0) THEN; LPN(2,NP) = J; CYCLE BG; END IF
        END DO
      END DO BG
      END SUBROUTINE
C
      SUBROUTINE POSITN(K,L)
C This positions file K at its 1st line with ":" in position L.
      CHARACTER CH*12
      REWIND K
10    READ(K,'(A)',END=30) CH
      IF(CH(L:L)/=':') GOTO 10
      BACKSPACE K
      IF(CH(L:L)==':') RETURN
30    WRITE(6,'(/" Cannot position input file at data start.")')
      END SUBROUTINE
C
      SUBROUTINE SCANC(NL,NS,SEQ,KFILE,CH,KK)
C This reads a string in I/O unit KFILE, cleans it for list-directed reading
C of the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.)  NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number string
C returned in File 2 is non-null but does not match SEQ, and gives the total
C count of numbers in the returned string otherwise.  WA and WB are workspaces.
C ***** If SEQ is "B", NL returns 0 if the input line is blank, and
C       returns -1 otherwise.
C ***** In original SCANB, CH returns the input string's first unbroken sequence
C       up to ABS(KK) terms while deleting any numbers in this if KK < 0.
C  ##### In this augmentation, KFILE  0 calls CH to return the initial letter
C       string in KFILE !!NO>> while KK returns its length<<.  If KFILE < 0,
C       CH is read as an input string while KK is length of its alphabetic start.
c Cases: (1) Ordinary read from KFILE, but fill CH with start of input and
c              return length of alphabetic start in KK ( KFILE > 0 )
c        (2) Read CH as input, continue as in Case 1 ( KFILE < 0 )
c        (3) Read KFILE, move 1st KK chars (with deletion at source) to
c              output CH ( KFILE > 0, negative input KK; only in RESCORE )
C WARNING: KK must be a variable in Cases 1,2.  Case 3 occurs only in RESCORE

      CHARACTER AA, SEQ*(*), WA*240, WB*241, CH*(*)
      LCH = LEN(CH); LA = LEN(WA)
      IF(KFILE>=0) THEN
        READ(KFILE,'(A)') WA
        NL = LAST(WA(:LA)); N = MIN(LCH,LA)
        CH(:N) = WA(:N)
      ELSE
        NL = LAST(CH(:LCH))
        IF(NL>0) WA(:NL) = CH
      END IF
      IF(NL==0) GOTO 70
      IF(SEQ(1:1)=='B') NL = -1         !  Original SCAN
      IF(SEQ(1:1)=='B') GOTO 70         !     "       "
      IF(KK<0) THEN   ! Case 3
        DO I = 1,ABS(KK)
          CH(I:I) = WA(I:I); WA(I:I) = ' '
        END DO     !  Case 3 now complete except for numbers read
        GOTO 15
      END IF
      KK = 0   ! Cases 1,2: KK gets length of the initial non-numeric sequence
11    N = IACHAR(WA(KK+1:KK+1))
      IF(N>=97) N = N-32    ! Capitalize lowercase letters
      IF(N<35 .OR. N>90 .OR. N>38.AND.N<60) GOTO 15
C   Accept characters in ranges 35-38, 60-90, but watch out for key reassignents
      KK = KK+1
      IF(KK<=LCH) CH(KK:KK) = CHAR(N)
      IF(KK<NL) GOTO 11   ! Last occurrence of KK
15    WB(NL+1:NL+1) = ' '    ! Crashes if LEN(WB)  LEN(WA) and NL=LN
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +    WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
       ELSE IF (WA(I:I) /= '0') THEN
         IP = 0
       END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1   ! Will crash if WB isn't longer than WA
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF(WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) GOTO 70
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     +  "number sequence requested. Try again.")')
      GOTO 70
60    REWIND 2
      WRITE(2,'(A)') WB(:NL)
      NL = NN
70    REWIND 2
      END SUBROUTINE
C
      SUBROUTINE SEEFRM(NFRM,MFRM,FORMS)
      PARAMETER ( ML=139 )
      CHARACTER FORMS(MFRM)*(ML)
      DO I = 1,NFRM  ! Last two positions in FORM line are flags
        L = LAST(FORMS(I)(:ML-2)) - 1  ! Omit the global right parens
        IF(MOD(I+1,20)==1) CALL WAIT
        WRITE(6,'(I3,". ",A)') I, FORMS(I)(2:MIN(74,L))
        IF(L>74) WRITE(6,'(7X,A)') FORMS(I)(75:L)
      END DO
      END SUBROUTINE
C
      SUBROUTINE SEENAM(NX,IDENT,LS,NK,KF)
C This writes to file KF the NX names in IDENT. LM is max namelength.  LS is
C number of lines to leave at top of screen. NK is num of extra screen displays
      CHARACTER(8) IDENT(*), FMT*30, CH2*2
      LM = 3
      DO I = 1,NX
        N = LAST(IDENT(I)); LM = MAX(LM,N)
      END DO
      LL = 79/(6+LM)   ! Number of fields per line
      LB = (23-LS)*LL  ! Number of fields in 23-LS lines
      NS = MIN(1,MOD(79,6+LM)/2)  ! Number of spaces starting display line
      NK = 0
      CH2 = CHAR(48+NS)//CHAR(48+LL)
      FMT = '(80('//CH2(1:1)//'X,'//CH2(2:2)//'(I4,": ",A),:/))'
20    WRITE(KF,FMT) (I,IDENT(I)(:LM),I=NK+1,NK+MIN(LB,NX-NK))
      IF(1+(NX-NK)/LL<=18) RETURN   ! Number of lines needed to finish
      WRITE(6,'(" Hit RETURN to continue")')
      READ(5,'()')
      NK = NK+LB
      LB = 23*LL  ! Hereafter use full screen
      IF(NK>=NX) RETURN
      GOTO 20
      END
C
      SUBROUTINE SSUB(I,KOP,MFRM,OPTABL,JC,MLST,IER)
C This is a fragment of subroutine EVAL that deals with both the left and the
C right argument of a binary function at WRD location I.
      PARAMETER ( MOP=40, ML=139 )  ! ML=139 )
      CHARACTER WRD*(ML)
      INTEGER OPTABL(MFRM,0:MOP,3), MLST(*)
      COMMON /W/ LL, WRD
      DO J = -1,1,2
        IX = JBL(I,J)+J
C         IX is the WRD position of the left/right argument marker.
        IF(WRD(IX:IX)/='$') IER = IX
        IF(IER/=0) RETURN
        OPTABL(JC,KOP,2+(J+1)/2) = MLST(IX)
10      CALL WIPE(I+J,IX)
      END DO
      END SUBROUTINE
C
      SUBROUTINE TAKOUT(NN,NAME,NW)
C Delete NAME(NN) from Namelist close up gap, and display
      CHARACTER(12) NAME(*)
      DO I = NN,NW-1
        NAME(I) = NAME(I+1)
      END DO
      NW = NW-1; NN = 1
      WRITE(6,'(" Maybe one of these will do:")')
      IF(NW>0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NW)
cc      IF(NW>0) WORD(:12) = NAME(NW)
      END SUBROUTINE
C
      SUBROUTINE VARLST(JOP,JX,NV,JB,LST,IDENT,IER,MJ)
C Set the list of variables for Job JX           ! ^ Virtual parameter; do not touch
      CHARACTER(8) IDENT(*), CH*1, CF*12
      INTEGER JB(MJ,-2:*), LST(*), OK
      COMMON /CF/ CF
      NVAR = MAX(1,IER)
C       For Operations 3,4 IER inputs number of variables required by formula
      IER = 0; OK = 0
      IF(JOP==2) THEN
        WRITE(6,'(/" Next, choose INDICES of the variables to be conc",
     +    "atenated in Job ",A,"."/" (Your list length or entry meth",
     +    "od may require more than one line.)")') CF(:JF(JX))
      ELSE IF(JOP==4) THEN
        WRITE(6,'(/" Next, choose INDICES of variables to which Job ",A,
     +    " is to apply this formula."/" (Your list length or entry me",
     +    "thod may require more than one line.)")') CF(:JF(JX))
      END IF
30    WRITE(6,'(/" Enter all or part of the selection wanted as a str",
     +  "ing of indices, or include"/" index sequence from N1 to N2 b",
     +  "y entering "" All N1 N2 "".  ("" All "" by itself"/" selects",
     +  " all indices while "" All N1 "" picks all from N1 up.)  Othe",
     +  "rwise, enter"/" "" V "" to see the list of variables again, ",
     +  "or any other letter to abort."/)')
      NJ = 0
      CALL SCANC(J,0,'I',5,CH,L)
      IF(CH=='V' .OR. CH=='v') CALL SEENAM(NV,IDENT,1,NK,6)
      IF(CH=='V' .OR. CH=='v') GOTO 30
      IF(J<0 .AND. (CH=='A'.OR.CH=='a')) GOTO 36
      IF(J<0) IER = 1
      IF(J<0) RETURN
      IF(J==0) GOTO 30
35    READ(2,*) (JB(JX,I),I=1,MIN(J,NV))
36    IF(CH/='A' .AND. CH/='a') THEN
        IX = 0
        DO I = 1,J
          IF(JB(JX,I)<1 .OR. JB(JX,I)>NV) CYCLE
          IX = IX+1
          LST(NJ+IX) = JB(JX,I)
        END DO
        NJ = NJ+IX
      ELSE
        IF(J==0) JB(JX,1) = 1
        IF(J<=1) JB(JX,2) = NV
        L = MAX(1,MIN(NV,JB(JX,1),JB(JX,2)))
        M = MIN(NV,MAX(1,JB(JX,1),JB(JX,2)))
        DO I = L,M
          LST(NJ+I-L+1) = I
        END DO
        NJ = NJ+M-L+1
      END IF
45    WRITE(6,'(/" The variables now selected for Job ",A," are ind",
     +  "exed",50(:/20I4))') CF(:JF(JX)), (LST(I),I=1,NJ)
      WRITE(6,'(/" Hit RETURN if list is complete and correct. Otherw",
     +  "ise, enter additional"/" indices or sequence entered in form",
     +  " "" All N1 N2 "". (To start again,"/" enter any letter.)"/)')
      CALL SCANC(J,0,'I',5,CH,L)
      IF(J<0) GOTO 30
      IF(J>0) GOTO 35
C Check whether any items are duplicated or out of order
      IF(JOP==3 .AND. MOD(NJ,NVAR)/=0) WRITE(6,'(" WARNING: When",
     +  " this ",A,"-argument formula is applied ",A," times to this",
     +  " selection"/" of variables, ",A," selected variables will ",
     +  "be left over.")') CF(:JF(NVAR)), CF(:JF(NJ/NVAR)),
     +  CF(:JF(MOD(NJ,NVAR)))
      IF(OK>0) GOTO 52
      NO = 0
      DO I = 2,NJ
        IF(LST(I)<=LST(I-1)) NO = LST(I)
        IF(NO>0) THEN
          WRITE(6,'(" Some variables in this list, No. ",A," in parti",
     +      "cular, are duplicated or"/" out of sequence.  Hit RETURN",
     +      " if OK, or enter anything to correct this.")') CF(:JF(NO))
          CALL SCANC(J,0,'B',5,CH,L)
          OK = 1
          IF(J/=0) OK = -1
          GOTO 52
        END IF
      END DO
52    IF(NO/=0 .AND. OK<0) THEN
        LP: DO I = 2,NJ
          LL = LST(I)
          DO J = I-1,1,-1
            IF(LL>=LST(J)) CYCLE LP
            LST(J) = LST(J+1)
          END DO
          LST(J+1) = LL
        END DO LP
        LL = 1
        DO I = 2,NJ
          IF(LST(I)==LST(I-1)) CYCLE
          LL = LL+1
          LST(LL) = LST(I)
        END DO
        NJ = LL+1
60      NJ = NJ-1
        IF(LST(NJ)>NV) GOTO 60
        GOTO 45
      END IF
      JB(JX,0) = NJ
      DO I = 1,NJ
        JB(JX,I) = LST(I)
      END DO   ! If Job is Outlie concatenation, LST will be used in Main
      END SUBROUTINE
C
      SUBROUTINE WIPE(K,L)
C Blank out all of WRD between positions K and L, inclusive.
      PARAMETER ( ML=139 )    ! ( ML=139 )
      CHARACTER WRD*(ML)
      COMMON /W/ LL, WRD
      DO I = MIN(K,L),MAX(K,L)
        WRD(I:I) = ' '
      END DO
      END SUBROUTINE
C
      SUBROUTINE WAIT
      WRITE(6,'(/" Hit RETURN to continue")')
      READ(5,'()')
      END SUBROUTINE
C
      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12, LST(12)*10
      COMMON /CF/ CF
      DATA LST/'January  7','February 8','March    5','April    5',
     +         'May      3','June     4','July     4','August   6',
     +         'September9','October  7','November 8','December 8'/
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48  ! M gets day of month
      READ(ZZZ(5:6),*) L; K = ICHAR(LST(L)(10:10))-48
      WORD = CF(:JF(M))//' '//LST(L)(:K)//' '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE
C
      FUNCTION TM(KSET)
C The value (real) returned by function TM is seconds since last timer reset.
C After this value is determined, the timer is reset if KSET > 0 but continues
C to accumulate if KSET = 0.
      DATA PREV/0./
C       CALL SYSTEM_CLOCK(J,KR,KMAX)  ! Arguments are optional
C       J = tick count since zero; KR = ticks per second; KMAX = max count
C       In LF90 clock: KR = 100, KMAX = 8,640,000
      CALL SYSTEM_CLOCK(J)
      X = J*.01
      TM = X - PREV
      IF(TM<=0.) TM = TM + 86400
      IF(KSET==0) RETURN
      PREV = X
      END FUNCTION

      FUNCTION LLN(R,LD)
C Enables printing real number R (input) in minimal fieldwidth LLN (output)
C such that at least LD (input) leading digits are shown.  The length-LLN
C character for R is printed as CF(:LLN(R,LD))
      CHARACTER(12) CF, CLN*8
      INTEGER LLN
      COMMON /CF/ CF
      S = ABS(R); K = INT(S);  N = JF(K); IF(K==0) N = 0
      IF(K>0) ND = MAX(0,LD-N)
      IF(K==0) THEN  ! Count leading zeros in decimal
        L = 0
10      L = L+1
        IF(INT(S*10**L)<1.) GOTO 10
        ND = L-1+LD  ! L-1 is number of leading zeros after decimal
      END IF
      LN = N+1+ND; IF(R<0.) LN = LN+1
      CF = CLN(R,LN,ND)
      LLN = MIN(12,LN)
      END FUNCTION

      SUBROUTINE SHONAM(WORD,NJ,LST,NAML,IDENT,NBL,KF)
C List NJ names compactly in multiple lines without space loss at line end.
C NBL is number of blanks starting continuation lines.  KF is WRITE-file.
      CHARACTER IDENT(*)*8, WORD*(*), BLANK*20
      INTEGER NAML(*), LST(*)
      COMMON /CF/ CF
      LW = LEN(WORD); LK = 0; LL = LW; BLANK = ' '
10    LK = LK+1; LL = LL+NAML(LST(LK))+2
      IF(LK<NJ .AND. NAML(LST(LK)+1)+2<=80-LL) GOTO 10
      WRITE(KF,'(A,40(A,2X))') WORD(:LW), (IDENT(LST(I))
     +  (: NAML(LST(I))),I=1,LK)
      IF(LK>=NJ) RETURN
20    L0 = LK+1; LL = 0
30    LK = LK+1; LL = LL+NAML(LST(LK))+2  ! Count LK continues
      IF(LK<NJ .AND. NAML(LST(LK)+1)+2<=80-NBL-LL) GOTO 30
      WRITE(KF,'(40(A,40(A,2X),:/))') BLANK(:NBL), (IDENT(LST(I))
     +  (:NAML(LST(I))),I=L0,LK)
      IF(LK<NJ) GOTO 20
      END SUBROUTINE

      SUBROUTINE SHOERR(J,MSG)
C Formula is in WORD(2:LL-1), J is the site of error, MSG gives message.
      PARAMETER ( ML=139 )    ! ( ML=139 )
      CHARACTER WORD*(ML), MSG*(*)
      COMMON /W/ LL, WRD   ! WRD isn't used here
      COMMON /WORD/ WORD
      WRITE(6,'(A)') MSG
      IF(J<79) THEN
        WRITE(6,'(1X,A/80A)') WORD(2:MIN(LL-1,80)),(' ',I=1,J-1),'^'
      ELSE  ! Omit (LL-1)-79 + 5 = LL-75 starting chars
        LS = LL-75; WRITE(6,'(1X," ... ",A)') WORD(LS+1:LL-1)
        WRITE(6,'(80A)') (' ',I=LS+1,J-1), '^'
      END IF ! ^ J count includes left paren at start of WORD
      END SUBROUTINE

