C          Program SELECT.  (Source code: FORTRAN-90)
C
C                  Last revised: 14 May 2002
C
C This copies scores on selected blocks of variables/subjects in any HYDARA-
C standard datafile into a separate file.  Subjects selection can be either
C through entering intervals of record indices and/or by a FAIL level that
C excludes records whose bad-score percentage exceeds FAIL
C
      CHARACTER(12) F1, F2, F3, CF, CH2*2, CH4*4, CH5*5, NAME(40)
      CHARACTER(33) FM1, FM2, WORD*170, LBL*7, CH*1, CLN*8
      LOGICAL KEEP, QR, QV  ! QV = T iff all items are wanted
C       QR = .TRUE. just in case record selection is on index, not ID
      CHARACTER(8),ALLOCATABLE :: IDENT(:)
      INTEGER,ALLOCATABLE :: LSTR(:,:), LSTV(:,:), LIST(:), KK(:),
     +  LR(:), KX(:)
      COMMON /CF/ CF
      DATA QR,QV/.TRUE.,.FALSE./, NFIX,NUL,KWD/0,-99,3/
      OPEN(2,STATUS='SCRATCH')
      CALL SYSTEM('cls')
C
      WRITE(6,'(//3X,"",71(""),"")')
      WRITE(6,'(3X,"  Program SELECT enables deletion of unwanted it",
     +  "ems and score records  "/3X,"  from Hydata-standard datafi",
     +  "les. The selected data can either replace "/3X,"  the D-f",
     +  "ile from which it is read, or be copied to a new D-file.",6X,
     +  "")')
      WRITE(6,'(3X,"",71(""),"")')

C   |  Program SELECT enables deletion of unwanted items and score records  |
C   |  from Hydata-standard datafiles. The selected data can either replace |
C   |  the D-file from which it is read, or be copied to a new D-file.      |

      WRITE(6,'(//" The D-files available in this subdirectory are:")')
      CALL LOOK(1,'*.D*',NAME,40,N)
      IF(N==0) WRITE(6,'(/ " No work for SELECT here. Go find ",
     +  "something else to do.")')
      IF(N==0) STOP
      NN = 1
9     F1 = NAME(NN)
      CALL CAP(F1,12)
      CALL LAST(LF1,F1,12)

      IF(N==1) GOTO 13
10    WRITE(6,'(/" The datafile from which variables and/or score rec",
     +  "ords are to be selected is"/1X,A,".  Hit RETURN if OK, or en",
     +  "ter the index of another listed D-file."/)') F1(:LF1)
      CALL SCANC(J,1,'I',5,CH,L)
      IF(J<0) GOTO 10
11    IF(J>0) THEN
        READ(2,*) NN
        NN = MAX(1,MIN(NN,N))
        GOTO 9
      END IF
13    OPEN(3,FILE=F1)
      READ(3,'(A7)') WORD(:7)
      IF(WORD(2:7)/='HYDATA') THEN
        WRITE(6,'(/A," is not a HYDATA-standardized data file. Abort",
     +    " run or try again.")') F1(:LF1)
        GOTO 10
      END IF
      REWIND 3
      READ(3,'(A)') WORD    !!! NOTE: SCAN call L-justifies WORD
      CALL SCANC(J,4,'IIIR',-1,WORD(39:),L)
      IF(J<4) THEN
        CALL LAST(LL,WORD,130)
        WRITE(6,'(" ERROR: Header of ",A," is"/1X,A)') F1(:LF1),
     +     WORD(:LL)
        STOP
      END IF
      READ(2,*) NV, NR, MXX, DV; WORD(:12) = WORD(26:37)
      CALL LAST(L,WORD,12)
      IF(WORD(:LF1)/=F1(:LF1)) WRITE(6,'(/" File ",A," was origina",
     +  "lly written under name ",A)') F1(:LF1), WORD(:L)
      READ(3,'(A)') WORD
      CALL SCANC(J,2,'II',-1,WORD(43:),L)  ! Both terms wanted, L not used
      READ(2,*)  NFIX, MIS
      BAD = MIS*100./(NV*NR); FAIL = 100.0
      WRITE(6,'(/" Datafile ",A," has ",A," variables on ",A," record",
     +  "s; largest ID is ",A,".")') F1(:LF1), CF(:JF(NV)),CF(:JF(NR)),
     +  CF(:JF(MXX))
      IF(N==1) WRITE(6,'(" Hit RETURN if OK, or enter anything to ",
     +  "abort this run.")')
      IF(N>1) WRITE(6,'(" Hit RETURN if OK.  Otherwise enter the inde",
     +  "x of another choice, or"/" any letter to abort this run."/)')
      CALL SCANC(J,0,'I',5,CH,L)
      IF(J<0) STOP
      IF(J>0) THEN; CLOSE(3); GOTO 11; END IF
      ALLOCATE ( IDENT(NV) )
      ALLOCATE ( LSTR(2,99), LSTV(2,NV), LIST(NV), KK(0:NV), LR(NR) )
      READ(3,*) (IDENT(I),I=1,NV)
      READ(3,'(A)') WORD
      NSX = 0
ccc      IF(NSX>0) WRITE(7,'("Rescale",8(2X,5I3),20(/8X,8(2X,5I3)))') (KX(I),I=1,NY)
      IF(WORD(:7)=='Rescale') THEN
        ALLOCATE ( KX(NV) ); KX = 0
        BACKSPACE 3
        READ(3,'(20(8X,8(2X,5I3):/))') (KX(I),I=1,NV)
        DO I = 1,NV; IF(KX(I)/=0) NSX = NSX+1; END DO
        READ(3,'(A)') WORD
      END IF

C Code for diagnosing and reading fieldwidths 4 and 5
      BACKSPACE 3
      WORD(:1) = 'X'; CALL LAST(LL,WORD,LEN(WORD)) ! Start of WORD mustn't be blank
      LXX = JF(MXX)
      LL = LL-LXX-1  ! Length of scorelist in line
      IF(LL==4*MIN(45,NV)) THEN
        KWD = 4; NUL = -999
      ELSE IF(LL==5*MIN(40,NV)) THEN
        KWD = 5; NUL = -9999
      END IF
      CH4 = '50I3'; IF(KWD==4) CH4 = '45I4'; IF(KWD==5) CH4 = '40I5'
      CH2 = CF(:JF(LXX))//' '   ! 2nd position almost always left blank; no sweat
      FM1 = '(I'//CH2//',1X,'//CH4//',20(:/'//CH2//'X,1X,'//CH4//'))'
      OPEN(15,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +  RECL=4*(NV+3)); NS = 0
901   READ(3,FM1,END=910) ID, (KK(I),I=1,NV)
      NS = NS+1
      WRITE(15,REC=NS) ID, (KK(I),I=1,NV)
      LR(NS) = ID; GOTO 901
910   CLOSE(3)
      IF(NR/=NS) THEN
        WRITE(6,'(" >>>> ERROR: Datafile ",A," header claims ",A,
     +    " records, but only ",A/" are found.  fix the discrepancy",
     +    " and try again.")') F1(:LF1), CF(:JF(NR)), CF(:JF(NS))
        STOP
      END IF
C
      WRITE(6,'(/" You must enter indices for the variables to be sel",
     +  "ected, as well as IDs or"/" indices of the records from whic",
     +  "h scores on those variables are to be copied."/" Each of the",
     +  "se lists is built by entering the first and last index (or, ",
     +  "for"/" records, ID number) in each consecutive subsequence ",
     +  "to be included.  For"/" selecting from gappy IDs, suitably ",
     +  "tight lower/upper bounds are acceptable.")')
15    WRITE(6,'(/" First, identify the variables to be selected. If y",
     +  "ou want all, enter anything."/" Otherwise, hit RETURN to see",
     +  " the list of item index/name pairings. As  this"/" is displa",
     +  "yed, write down the indices you wish to select unless you ",
     +  "have a copy"/" of this list already in hand.")')
      CALL SCANC(J,0,'B',5,CH,L)
      IF(J/=0) THEN
        JVAR = 1; LSTV(1,1) = 1; LSTV(2,1) = NV
        WRITE(6,'(" ALL variables are set for selection. If that is",
     +    " incorrect, hit CTRL-C to"/" abort run and try again.")')
        QV = .TRUE.; GOTO 40
      END IF
C
C Put indices of variables wanted into LSTV
      WRITE(6,'(" The variables now available are named")')
      CALL SEENAM(NV,IDENT,LM,1,79,6)
      JVAR = 0
      WRITE(6,'(/" Enter INDICES of variables to be selected by typi",
     +  "ng the first and last index"/" of an unbroken sequence to b",
     +  "e included, followed by RETURN. (Entry of just"/" one index",
     +  " will be read as a one-term sequence.)  After each entry yo",
     +  "u will"/" be shown the list selected so far and given optio",
     +  "n to extend it.")')
20    WRITE(6,'(/" Enter the first and last index of your first sequ",
     +  "ence of selected variables."/)')
      CALL SCANC(J,0,'I',5,CH,L)
      IF(J<=0) GOTO 20
25    READ(2,*) (KK(I),I=1,MIN(J,2))
      IF(JVAR>0 .AND. KK(1)>NV) THEN
        WRITE(6,'("  No variables have indices larger than ",A,
     +    ", but you can still make changes.")') CF(:JF(NV)); GOTO 30
      END IF
      N1 = MAX(1,MIN(KK(1),KK(2),NV)); N2 = MIN(NV,MAX(KK(1),KK(2),1))
      IF(JVAR>0 .AND. N2<=LSTV(2,JVAR)) THEN
        WRITE(6,'("  Selection over this range has already been",
     +    " specified.  Try again.")'); GOTO 30
      END IF
      JVAR = JVAR+1
      IF(JVAR>1 .AND. N1<=1+LSTV(2,JVAR-1)) THEN ! Extend previous block
        JVAR = JVAR-1; LSTV(2,JVAR) = N2
      ELSE
        LSTV(1,JVAR) = N1; LSTV(2,JVAR) = N2
      END IF
30    WRITE(6,'(" The indices of your selected variables are now",
     +  20(/2X,7(1X,A," - ",A,:",")))') ((CF(:JF(LSTV(J,I))),J=1,2),
     +  I=1,JVAR)
      WRITE(6,'(/" Hit RETURN if this list is correct and complet",
     +  "e, or enter any new index pair"/" to extend the list. To ",
     +  "corret errors, enter "" C "" to cancel the last entry"/
     +  " or any other letter to start again."/)')
      CALL SCANC(J,0,'I',5,CH,L)
      IF(J/=0) THEN
        IF(CH=='C'.OR. CH=='c') THEN; JVAR = JVAR-1; GOTO 30; END IF
        IF(J<0) GOTO 15
        GOTO 25
      END IF
C
C Put record IDs or indices into LSTR
40    WRITE(6,'(/" Next, identify the data records to be selected. ",
     +  "If you want scores on the")')
      IF(MIS==0) WRITE(6,'(" selected variables for all ",A," recor",
     +  "ds, enter anything.  Otherwise, hit"/" RETURN to select gr",
     +  "oups of records.")') CF(:JF(NR))
      KBD = INT(BAD); DBD = MOD(BAD,1.)
      IF(MIS>0) WRITE(6,'(" selected variables for all sufficiently c",
     +  "omplete records, enter anything."/" Otherwise, hit RETURN to",
     +  " select groups of records on which afterward you can"/" impo",
     +  "se a completeness threshold.  (",A,A2,"% of all scores in da",
     +  "tafile ",A/" are bad.)")') CF(:JF(KBD)),CLN(DBD,2,1),F1(:LF1)
      CALL SCANC(J,0,'B',5,CH,L)
      IF(J/=0) THEN  ! All records declared
        JREC = 1  ! JREC becomes the number of rec groups listed in LSTR
        LSTR(1,1) = 1; LSTR(2,1) = NR
        WRITE(6,'(" ALL sufficiently complete records are set for se",
     +    "lection. If that"/" is incorrect, hit Ctrl-C to abort thi",
     +    "s run and try again.")')
        NS = NR
        GOTO 60
      END IF
      WRITE(6,'(/" You can specify records either by INDEX (count-",
     +  "position in sequence) or by ID.")')
      IF(NR==MXX) WRITE(6,'(" (NOTE: In this instance, all record ",
     +  "IDs are identical with their indices.)")')
41    IF(QR) WRITE(6,'(" If you want record-selection entries to be ",
     +  "read as record INDICES, hit RETURN."/" Otherwise, enter any",
     +  "thing to treat these as ID numbers.")')
      IF(.NOT.QR) WRITE(6,'(" If you want your record-selection entr",
     +  "ies to be read as ID numbers, hit RETURN."/" Otherwise, ent",
     +  "er anything to treat these as record Indices.")')
      CALL SCANC(J,0,'B',5,CH,L)
      IF(J/=0) QR = .NOT.QR; IF(J/=0) GOTO 41
      IF(QR) WRITE(6,'(/" The total number of records in this data",
     +  "file is ",A)') CF(:JF(NR))
      IF(.NOT.QR) WRITE(6,'(/" The largest ID number in this datafi",
     +  "le is ",A,". It will not matter if"/" many IDs prior to it ",
     +  "are missing.")') CF(:JF(MXX))
      JREC = 0
      IF(QR) THEN
        KL = 7; LBL(:KL) = 'Indices'; CH5 = 'index'; LL = 5; M = NR
      ELSE
        KL = 3; LBL(:KL) = 'IDs'; CH5 = 'ID'; LL = 2; M = MXX
      END IF
      WRITE(6,'(/" First, enter ",A," of records to be selected by ",
     +  "typing the first and last"/1X,A," of an unbroken sequence ",
     +  "to be included, followed by RETURN. (Entry"/" of just one ",
     +  A," will be read as a one-term sequence.)  After each entry"/
     +  " you will be shown the list selected so far and given opt",
     +  "ion to extend it"/" by ",A," larger than those already en",
     +  "tered.")') LBL(:KL), CH5(:LL), CH5(:LL), LBL(:KL)
44    WRITE(6,'(/" Enter the first and last ",A," in your first seq",
     +  "uence of selected records."/)') CH5(:LL)
      CALL SCANC(J,0,'I',5,CH,L)
      IF(J<=0) GOTO 44
46    READ(2,*) (KK(I),I=1,MIN(J,2))
      IF(JREC>0 .AND. KK(1)>M) THEN
        WRITE(6,'("  No ",A," are larger than ",A,", but you can ",
     +    "still make changes.")') LBL(:KL), CF(:JF(M)); GOTO 55
      END IF
      N1 = MAX(1,MIN(KK(1),KK(2),M)); N2 = MIN(M,MAX(KK(1),KK(2),1))
      IF(JREC>0 .AND. N2<=LSTR(2,JREC)) THEN
        WRITE(6,'("  Selection over this range has already been",
     +    " specified.  Try again.")'); GOTO 55
      END IF
      JREC = JREC+1
      IF(JREC>1 .AND. N1<=1+LSTR(2,JREC-1)) THEN ! Extend previous block
        JREC = JREC-1; LSTR(2,JREC) = N2
      ELSE
        LSTR(1,JREC) = N1; LSTR(2,JREC) = N2
      END IF
55    LX = JF(N2)
      FM1 = '(10('//CHAR(48+80/(6+2*LX))//'(2X,A," - ",A,:,",")/)) '
      WRITE(6,'(" The ",A," of your selected records are now")')
     +  LBL(:KL)
      WRITE(6,FM1) ((CF(:JF(LSTR(J,I))),J=1,2),I=1,JREC)
      WRITE(6,'(/" Hit RETURN if this list is correct and complete;",
     +  " or enter any new ",A," pair"/" to extend list.  To correc",
     +  "t errors, enter ""C"" to cancel the last entry"/" or any o",
     +  "ther letter to start again."/)') CH5(:LL)
      CALL SCANC(J,0,'I',5,CH,L)
      IF(J/=0) THEN
        IF(CH=='C'.OR.CH=='c') THEN; JREC = JREC-1; GOTO 55; END IF
        IF(J<0) GOTO 40
        GOTO 46
      END IF
      IF(.NOT.QR) THEN  ! Convert ID-specified groups to Index specs
        DO J = 1,JREC; DO I = 1,2
            K = INDX(LSTR(I,J),LR,NR)
            IF(K<0) THEN  ! Stay up if lower bound, go down 1 if upper bound
              IF(I==1) K = ABS(K); IF(I==2) K = ABS(K) - 1
            END IF
            LSTR(I,J) = K
        END DO; END DO
      END IF
60    IF(MIS==0) GOTO 66; IF(FAIL<100.) GOTO 62
      WRITE(6,'(/" Considering that ",A,A2,"% of scores in this data",
     +  "set are defective, enter anything"/" if you want to exclude",
     +  " records having more bad scores than a threshold FAIL"/" of",
     +  " your choosing.  Otherwise, hit RETURN to tolerate all bad-",
     +  "score levels.")') CF(:JF(KBD)), CLN(DBD,2,1)  ! CLN(BAD,5,1)
      IF(NVAR<NV) WRITE(6,'(" (This threshold applies only to scores",
     +  " on the selected subset of variables.)")')
      WRITE(6,'(" Bad-score information in this dataset''s LOG file ",
     +  "will help you choose FAIL.")')
      READ(5,'(A)') CH
      IF(CH==' ') GOTO 66; CH2 = 's '
62    WRITE(6,'(" The maximal percent of bad scores to be allowed in ",
     +  "any selected record is"/" now set at FAIL = ",A4,"%.  Hit RE",
     +  "TURN if OK, or enter preferred FAIL percent.")') CLN(FAIL,4,1)
      TOP = (NV-1)*100./NV
      IF(FAIL>=99.9) WRITE(6,'(" Note: FAIL over ",A4,"% but under ",
     +  "100% excludes just blank records."/7X,"FAIL under",A4,"% exc",
     +  "ludes all that are incomplete."/)') CLN(.1+TOP,4,1),
     +  CLN(100./NV,4,1)
      CALL SCANC(J,0,'R',5,CH,L)
      IF(J==0) GOTO 66; IF(J<0) GOTO 62
      READ(2,*) FAIL; FAIL = MAX(0.,FAIL)
64    IF(FAIL>100.) THEN; FAIL = FAIL/10; GOTO 64; END IF
      GOTO 62
66    WRITE(6,'(/" Review record selections:")')
      M = LSTR(2,1)-LSTR(2,1)+1  ! Number of records in 1st block
      IF(M==NR .AND. FAIL>=100.) WRITE(6,'(/4X,"All records are sel",
     +  "ected.")')
      IF(M==NR .AND. FAIL<100.) WRITE(6,'(/4X,"Your record selection",
     +  " excludes only those that are over ",A4,"% incomplete.")')
     +  CLN(FAIL,4,1)
      L = 3-MIN(2,JREC)
      IF(M<NR .AND. FAIL>=100.) WRITE(6,'(/4X,"Your record selection",
     +  " comprises ",A," subsequence",A,"from which no"/4X,"incompl",
     +  "ete records are excluded.")') CF(:JF(JREC)), CH2(L:)
      IF(M<NR .AND. FAIL<100.) WRITE(6,'(/4X,"Your record selection ",
     +  "comprises ",A," subsequence",A,"from which records"/" more ",
     +  "than ",A4,"% incomplete are also excluded.")') CF(:JF(JREC)),
     +  CH2(L:), CLN(FAIL,4,1)
      IF(QV) THEN
        NVAR = NV; DO I = 1,NV; LIST(I) = I; END DO
      ELSE
        NVAR = 0; NN = NSX; NSX = 0
        DO I = 1,NV    ! Install item selection
          IF(.NOT.KEEP(I,LSTV,JVAR)) CYCLE   ! Rem: KEEP is a function
          NVAR = NVAR+1
          LIST(NVAR) = I
          IF(NN>0) THEN  ! Otherwise, KX shouldn't even be allocated
            KX(NVAR) = KX(I); IF(KX(I)/=0) NSX = NSX+1
          END IF
        END DO
      END IF
      NEND = 0       ! Install record selection
      DO I = 1,JREC
        NEND = MAX(NEND,LSTR(2,I)) ! Max selected rec index
      END DO
CC      MID = LR(NEND); LID = JF(MID)  ! Max ID and its length

C Strip specified exclusions out of record buffer 15
      IF(LSTR(2,1)-LSTR(1,1)==NR-1) GOTO 80  ! No specified record exclusions
      LREC = 0
      DO J = 1,LSTR(2,JREC)
        IF(.NOT.KEEP(J,LSTR,JREC)) CYCLE   ! Rem: KEEP is a function
        READ(15,REC=J) LID, (KK(I),I=1,NV)
        LREC = LREC+1
        WRITE(15,REC=LREC) LID, (KK(LIST(I)),I=1,NVAR)
      END DO   ! The last index,ID are LREC,LID
C Now delete unacceptably incomplete records
80    NS = LREC; NMIS=MIS; KMPR=LREC
      IF(MIS==0) GOTO 85
      NS = 0; NMIS=0; KMPR=0; LEVL=INT(NVAR*FAIL/100.); NFAIL=0
      DO J = 1,LREC
        READ(15,REC=J) ID, (KK(I),I=1,NVAR)
        DO I = 1,NVAR  ! Count bad scores
          IF(KK(LIST(I))==NUL) M = M+1
        END DO
        IF(M==0) KMPR = KMPR+1
        IF(M>LEVL) NFAIL = NFAIL+1
        IF(M>LEVL) CYCLE
        NS = NS+1; NMIS = NMIS+M
        WRITE(15,REC=NS) ID, (KK(LIST(I)),I=1,NVAR)
      END DO
C
C Copy selected HYDATA-standard scores to new ASCII datafile
85    F2 = F1; LID = LR(NS) ! Last record index is NS with ID = LID
      CALL NAME1(F2,F3,6,LFF)  ! LFF is the LOG-file namelength
      WRITE(6,'(/" By default, the selection file''s basename will b",
     +  "e ",A/" Hit RETURN if OK, or enter alternative basename."/)')
     +  F2(:LFF-3)
      READ(5,'(A)') WORD(:12); CALL LAST(LF2,WORD,12)
      IF(LF2==0) GOTO 93
90    CALL CAP(WORD,LF2)
      F2 = WORD(:12)
      CALL NAME1(F2,F3,6,LFF); CALL LAST(LF2,F2,12)
      WRITE(6,'(/" The selection file''s basename is now set to be ",
     +  A/" Hit RETURN if OK, or enter alternative."/)') F2(:LFF-3)
      READ(5,'(A)') WORD(:12); CALL LAST(LF2,WORD,12); N = LF2
      IF(N/=0) GOTO 90
      IF(F2(:LFF-3)/=F1(:LFF-3)) GOTO 94  ! Test OK on LFF even if different basename lengths
93    WRITE(6,'(/" If you want the selected data to replace input fi",
     +  "le ",A," under that"/" same name, enter anything. Otherwise",
     +  ", hit RETURN to write the selection"/" file under name ",A)')
     +  F1(:LF1), F2(:LFF)
      CALL SCANC(J,0,'B',5,CH,L); IF(J/=0) F2 = F1
      IF(F2==F1) THEN
        WRITE(6,'(" Enter anything to confirm that you want present ",
     +    "datafile ",A," to be"/" overwritten by this reduction of ",
     +    "it.  Otherwise, hit RETURN to reconsider.")') F1(:LF1)
        CALL SCANC(J,0,'B',5,CH,L); IF(J==0) GOTO 93
      END IF
C
94    OPEN(8,FILE=F3) ! Logfile
      CALL FNDEND(8)
      CALL LAST(LF2,F2,12)
      IF(F2/=F1) WRITE(8,'(/40("* ")//" Report on derivation of dataf",
     +  "ile ",A," from datafile ",A," by program SELECT.")') F2(:LF2),
     +  F1(:LF1)
      IF(F2==F1) WRITE(8,'(/40("* ")//" Report on reduction of dataf",
     +  "ile ",A," by program SELECT.")') F1(:LF1)
      CALL DAY(8)
      WORD(:15) = 'reducedselected' !  1:7  8:15
      K=1; L=7; IF(F2/=F1) THEN; K=8; L=15; END IF
      IF(NVAR==NV) WRITE(8,'(/" The variables in ",A," file ",A," are",
     +  " all in the origin file, namely ")') WORD(K:L), F2(:LF2)
      IF(NVAR/=NV) WRITE(8,'(/" The variables in origin file ",A,
     +  " are")') F1(:LF1)
      CALL SEENAM(NV,IDENT,LM,1,130,8)
      IF(NVAR/=NV) THEN
        DO I = 1,NVAR
          IDENT(I) = IDENT(LIST(I))  ! IDENT how holds names of the selected vars
        END DO
        WRITE(8,'(/" while those in ",A," file ",A," are")') WORD(K:L),
     +    F2(:LF2)
        CALL SEENAM(NVAR,IDENT,LM,1,130,8) ! IDENT is now the reduced list
      END IF
      WORD(:24) = ' '
      WORD((13-LF2)/2:12) = F2
      WORD(12+(13-LF1)/2:24) = F1
      CH4 = '50I3'; IF(KWD==4) CH4 = '45I4'; IF(KWD==5) CH4 = '40I5'
      L = JF(LID)  ! Length of largest selected ID
      CH2 = CF(:JF(L))//' '   ! 2nd position almost always left blank; no sweat
      FM2 = '(I'//CH2//',":",'//CH4//',20(:/'//CH2//'X,1X,'//CH4//'))'
      WRITE(6,'(/" Transcription of selected data is underway.")')
      OPEN(7,FILE=F2)
      WRITE(7,'(" HYDATA-standard datafile ",A,": ",A," variables, ",
     +  A," records; largest ID, ",A,"; transcribed under DEV =",F5.1,
     +  " by SELECT"/8X,"from rawdata source ",A,"; datafix ",A,"; ",
     +  A," missing scores; ",A," complete records.")') WORD(:12),
     +  CF(:JF(NVAR)), CF(:JF(NS)), CF(:JF(LID)), DV, WORD(13:24),
     +  CF(:JF(NFIX)), CF(:JF(NMIS)), CF(:JF(KMPR))
      L = 130/(LM+1)
      WORD(:18)='(50('//CF(:JF(L))//'(1X,A),:/))  '
      WRITE(7,WORD(:17)) (IDENT(I)(:LM),I=1,NVAR)
      IF(NSX>0) WRITE(7,'("Rescale",8(2X,5I3),20(/8X,8(2X,5I3)))')
     +  (KX(I),I=1,NVAR)
      DO J = 1,NS
        READ(15,REC=J) N, (KK(I),I=1,NVAR)
        WRITE(7,FM2) N, (KK(I),I=1,NVAR)
      END DO
C
110   WRITE(8,'(/20X," DETAILS OF SELECTION")')
      IF(NVAR==NV) WRITE(8,'(/" All variables were selected.")')
      IF(NVAR<NV) WRITE(8,'(/" The ",A," selected variables were ",
     +  "called by index entries",90(/2X,10(A,"-",A,:,2X)))')
     +  CF(:JF(NVAR)), ((CF(:JF(LSTV(J,I))),J=1,2),I=1,JVAR)
      IF(NS==NR) WRITE(8,'(/" All records were selected.")')
      IF(NS<NR) THEN
        WRITE(8,'(/1X,A," of the ",A," records transferred on these ",
     +    "selected variables were called by ",A," specifications")')
     +    LBL(:KL), CF(:JF(NS)), CH5(:LL)
        N = MIN(9,130/(6+2*LX))
        FM1 = '(10('//CHAR(48+N)//'(2X,A," - ",A,:,",")/)) '
        IF(QR) WRITE(8,FM1) ((CF(:JF(LSTR(J,I))),J=1,2),I=1,JREC)
        IF(.NOT.QR)  WRITE(8,FM1) ((CF(:JF(LR(LSTR(J,I)))),J=1,2),
     +    I=1,JREC)
        IF(NFAIL>0) WRITE(8,'(/1X,A," more records would have been ",
     +    "transferred had not each of those"/" contained more than",
     +    A5,"% bad scores.")') CF(:JF(NFAIL)), CLN(FAIL,5,1)
      END IF
      WRITE(6,'(/" The selected scores are now stored in datafile ",A/
     +  " Input/output filenames and labels assigned to the variables",
     +  " have been appended"/" to LOG file ",A)') F2(:LF2), F3(:LFF)
      STOP
      END
C
      SUBROUTINE CAP(WORD,L)
C This makes the first L letters in WORD all upper-case.
      CHARACTER WORD*(*)
      DO I = 1,L
        N = ICHAR(WORD(I:I))
        IF(N>=97 .AND. N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      RETURN
      END

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
C      SAVE /CF/  ! This doesn't appear to be needed
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      CLN = '        '
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      LD = ABS(ND)
      IF(ABS(X)<1.0E-12) THEN !  Special for vanishingly small X
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X))) !  M is space free for decimal (or M-1 if X<0) )
      IF(M<0 .OR. M<1.AND.X<0.) GOTO 55
      IF(ND>=10) LD = 0; LD = MIN(LD,M)
      DO I = 1,KW
        WK(I) = ' '
      END DO
      IF(LD==0) N = NINT(ABS(X))         ! Shouldn't be needed, but is
      IF(LD/=0) N = NINT(ABS(X)*10**LD)  ! This can overflow if LD is large
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' *******'
      END FUNCTION
C
      SUBROUTINE FNDEND(K)
C Finds end of file K for appending; Lahey and Microsoft compilers requires
C backspace.
      BACKSPACE K
10    READ(K,'()',END=20)
      GOTO 10
20    BACKSPACE K
      END SUBROUTINE

      FUNCTION INDX(IN,LST,L)
C Given length-L list LST of increasing IDs, find the index J of the smallest
C that equals or exceeds input IN, and return J or, if an inequality, -J.
      INTEGER LST(*)
      DO J = 1,L-1
        IF(IN>LST(J)) CYCLE    ! Either IN = LST(J) or LST(J-1) < IN < LST(J)
        INDX = J; IF(IN<LST(J)) INDX = -INDX; RETURN
      END DO
      INDX = L
      END FUNCTION
C
      FUNCTION KEEP(N,LIST,NX)
C This checks whether integer N is in an interval specified by one of the
C first NX columns of LIST, and returns KEEP = .TRUE. just in case it is.
      INTEGER LIST(2,*)
      LOGICAL KEEP
      KEEP = .TRUE.
      DO I = 1,NX
        IF(N>=LIST(1,I) .AND. N<=LIST(2,I)) RETURN
      END DO
      KEEP = .FALSE.
      RETURN
      END
C
      SUBROUTINE LAST(L,WORD,M)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as L. If the string is empty, LAST is returned as 0.
C **** In this modification, negative M waives left-justification.
      CHARACTER WORD*(*)
      IF(M>=0) WORD(:M) = ADJUSTL(WORD(:M))
      L = LEN_TRIM(WORD(:ABS(M)))
      END SUBROUTINE
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
      LOGICAL PRM, QY
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP
      CHARACTER E   ! <<<  Special characters as needed
      WD = GET
      CALL LAST(M,WD,40)
      LL = 1
5     LL = LL+1; IF(LL<M) GOTO 5
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>.0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(WORD(:1)==' ' .OR. WORD(:1)=='.') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
C       Filter out lines other than filenames
      CALL LAST(L,WORD,14)
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
      J = ICHAR(WORD(11:11));  IF(J<48 .OR. J>57) GOTO 10
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4) .AND. NAME(I)(L+5:L+5)==' ')
     +    GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>.0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NL)
      IF(NL>.0) WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      CALL LAST(L1,NAM1,LEN(NAM1)); CALL LAST(L2,NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      CALL LAST(L1,WRD1,LEN(WRD1)); CALL LAST(L2,WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A number terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION
C
      SUBROUTINE NAME1(F1,F2,M,L)
C This receives a filename in F1 (presumed to start in positeion 1), solves
C for <head> to be the part of F1 prior to '.' up to M characters, scans the
C subdirectory for the lowest i=1,2,...,99 such that file <head>.Di does not
C already exist, returns <head>.Di in F1(:12), <head>.LOG in F2, and the end
C position of the latter in L.
      LOGICAL QY
      CHARACTER F1*(*), F2*(*), DIGIT
      DIGIT(I) = CHAR(48+I)
      L = 0
10    L = L+1
      IF(L<=M .AND. F1(L:L)/=' ' .AND. F1(L:L)/='.') GOTO 10
      DO I = L+2,12
        F1(I:I) = ' '
      END DO
      F2 = F1
      F1(L:L+1) = '.D'
      F2(L:L+3) = '.LOG'
      L = L+2
      I = 0
20    I = I+1
      IF(I<=9) F1(L:L) = DIGIT(I)
      IF(I>9) F1(L:L+1) = DIGIT(I/10)//DIGIT(MOD(I,10))
      INQUIRE(FILE=F1,EXIST=QY)
      IF(QY .AND. I<99) GOTO 20
      IF(QY .AND. I==99) F1(L:L+1) = DIGIT(0)//DIGIT(0)
      L = L+1
      RETURN
      END
C
      SUBROUTINE POSITN(K,L)
C This positions file K at its 1st line with ":" in position L+1.
      CHARACTER CH*12
      REWIND K; M = L+1
10    READ(K,'(A)',END=30) CH
      IF(CH(M:M)/=':') GOTO 10
      BACKSPACE K
      IF(CH(M:M)==':') RETURN
30    WRITE(6,'(/" ERROR: Cannot position input file at data start.")')
      STOP
      END
C
      SUBROUTINE SCANC(NL,NS,SEQ,KFILE,CH,KK)
C This reads a string in I/O unit KFILE, cleans it for list-directed reading
C of the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.)  NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number string
C returned in File 2 is non-null but does not match SEQ, and gives the total
C count of numbers in the returned string otherwise.  WA and WB are workspaces.
C ***** If SEQ is "B", NL returns 0 if the input line is blank, and
C       returns -1 otherwise.
C ***** In original SCANB, CH returns the input string's first unbroken sequence
C       up to ABS(KK) terms while deleting any numbers in this if KK < 0.
C ##### In this augmentation, KFILE  0 calls CH to return the initial letter
C       string in KFILE while KK returns its length.  If KFILE < 0, CH is
C       read as an input string while KK is length of its alphabetic start.
ccc             Line ##### info was true of old HYDATA
c Cases: (1) Ordinary read from KFILE, but fill CH with start of input and
c              return length of alphabetic start in KK ( KFILE > 0 )
c        (2) Read CH as input, continue as in Case 1 ( KFILE < 0 )
c        (3) Read KFILE, move 1st KK chars (with deletion at source) to
c              output CH ( KFILE > 0, negative input KK; only in RESCORE )
C WARNING: KK must be a variable in Cases 1,2.  Case 3 occurs only in RESCORE

      CHARACTER AA, SEQ*(*), WA*270, WB*271, CH*(*)
      LCH = LEN(CH); LA = LEN(WA)
      IF(KFILE>=0) THEN
        READ(KFILE,'(A)') WA
        CALL LAST(NL,WA,LA); N = MIN(LCH,LA)
        CH(:N) = WA(:N)
      ELSE
        CALL LAST(NL,CH,LCH) ! $$$$$$$$ Also in RESCORE2, MERGE2, SELECT2
        IF(NL>0) WA(:NL) = CH
      END IF
      IF(NL==0) GOTO 70
      IF(SEQ(1:1)=='B') NL = -1         !  Original SCAN
      IF(SEQ(1:1)=='B') GOTO 70         !     "       "
      IF(KK<0) THEN   ! Case 3    *** Doesn't occur in HYDATA
        DO I = 1,ABS(KK)
          CH(I:I) = WA(I:I); WA(I:I) = ' '
        END DO     !  Case 3 now complete except for numbers read
        GOTO 15
      END IF
      KK = 0   ! Cases 1,2: KK gets length of the initial non-numeric sequence
11    N = IACHAR(WA(KK+1:KK+1))
      IF(N>=97) N = N-32    ! Capitalize lowercase letters
      IF(N<35 .OR. N>90 .OR. N>38.AND.N<60) GOTO 15
C   Accept characters in ranges 35-38, 60-90, but watch out for key reassignents
      KK = KK+1
      IF(KK<=LCH) CH(KK:KK) = CHAR(N)
      IF(KK<NL) GOTO 11   ! Last occurrence of KK
15    WB(NL+1:NL+1) = ' '    ! Crashes if LEN(WB)  LEN(WA) and NL=LN
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +    WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
       ELSE IF (WA(I:I) /= '0') THEN
         IP = 0
       END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1   ! Will crash if WB isn't longer than WA
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF(WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) GOTO 70
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/" Your input does not contain the ",
     +  "number sequence requested. Try again.")')
      GOTO 70
60    REWIND 2
      WRITE(2,'(A)') WB(:NL)
      NL = NN
70    REWIND 2
      END SUBROUTINE
C
      SUBROUTINE SEENAM(NX,IDENT,LM,LS,NW,KF)
C This writes to file KF the NX names in IDENT. LM is max namelength.  LS is
C number of lines to leave at top of screen. NW is characters in line
      CHARACTER*8 IDENT(*), FMT*30, CH3*3
      LM = 3
      DO I = 1,NX
        CALL LAST(N,IDENT(I),8)
        IF(N<=8) LM = MAX(LM,N)
      END DO
      LL = NW/(6+LM)   ! Number of fields per line
      LB = (23-LS)*LL  ! Number of fields in 23-LS lines
      NS = MIN(1,MOD(NW,6+LM)/2)  ! Number of spaces starting display line
      NK = 0
      CH3 = CHAR(48+NS)//CHAR(48+LL/10)//CHAR(48+MOD(LL,10))
      FMT = '(80('//CH3(1:1)//'X,'//CH3(2:3)//'(I4,": ",A),:/))'
20    WRITE(KF,FMT) (I,IDENT(I)(:LM),I=NK+1,NK+MIN(LB,NX-NK))
      IF(1+(NX-NK)/LL<=18) RETURN   ! Number of lines needed to finish
      IF(KF/=6) GOTO 21
      WRITE(6,'(" Hit RETURN to continue")'); READ(5,'()')
21    NK = NK+LB
      LB = 23*LL  ! Hereafter use full screen
      IF(NK>=NX) RETURN
      GOTO 20
      END
C
      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12, LST(12)*10
      COMMON /CF/ CF
      DATA LST/'January  7','February 8','March    5','April    5',
     +         'May      3','June     4','July     4','August   6',
     +         'September9','October  7','November 8','December 8'/
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48  ! M gets day of month
      READ(ZZZ(5:6),*) L; K = ICHAR(LST(L)(10:10))-48
      WORD = CF(:JF(M))//' '//LST(L)(:K)//' '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE

