C         Program TWOLOGS.  Source code, FORTRAN-90.
C This is a modification of HYLOG to compute congruences between two HYBUF
C files.  It allows printing of selected patterns with juxtaposition of
C matched columns.
C
C                 Last revised: 15 February 2005
C
C ******* Puzzle: Why not conflict between array LH and function LH ???

      LOGICAL QY, QK, QN(2), QI(2)
      CHARACTER BAR, COL, ANG, U2, CS, QFMT, CH1, CLN*8, CH2*2
      CHARACTER(12) FH(2),FM(2),FC(2),FD(2), CF, F3, F4
C                  Filenames FH/FM/FC/FD are Hybuf/Moda/Cov/Data
      CHARACTER(41) FMT,FMT1,FMT2, WORD*80
      INTEGER  FIND, KOD(2), LA(2), LB(2), LC(2), LD(2), LH(2), LM(2),
     +         MST(14), NF(2), NV(2), NV1(2), NT(2), NX(2)
      REAL     GP(10), CVAR(2)

CCC      CHARACTER(8)  IDENT(4*MV,2), IDN(4*MV), NAME(60)*12
CCC      INTEGER FX(MV,2), KC(MK,MREC,MREC), KNT1(MK,MREC,MF),
CCC     +          KNT2(MK,MREC,MF), MATCH(MV,2)
CCC      INTEGER KNG(MF), KTMP(MREC), LPIK(MREC,2), LST(MV,2),
CCC     +         LLST(4*MV,2), ORDER(MF)
CCCC       LPIK lists indices of patterns to be compared.
CCC      REAL AA(MV,MF,2), CC(MFF,2), CV(MREC,MREC), COMM(MV,2), DG(MF),
CCC     +      W1(MV,MF)

      CHARACTER(8), ALLOCATABLE ::  IDENT(:,:), IDN(:), NAME(:)*12
      INTEGER, ALLOCATABLE :: FX(:,:), KC(:,:,:), KNT1(:,:,:),
     +                        KNT2(:,:,:), MATCH(:,:)
      INTEGER, ALLOCATABLE :: KNG(:), KTMP(:), LPIK(:,:), LST(:,:),
     +                        LLST(:,:), ORDER(:)
C       LPIK lists indices of patterns to be compared.
      REAL, ALLOCATABLE :: AA(:,:,:), CC(:,:), CV(:,:), COMM(:,:),
     +                     DG(:), W1(:,:)
      EXTERNAL SCAN
      COMMON  MV, MF, MREC
      COMMON /CF/ CF
      LO(I,J) = J*(J-1)/2 + I
      LOC(I,J) = LO(MIN(I,J),MAX(I,J))
      FIND(J,K) = NT(2)*(J-1) + K      ! F18 line for old KNG(-,J,K)
      DATA BAR,COL,ANG,U2/'','','',''/, QY,QK,QI,QN/6*.FALSE./
C         QN,QI record whether the COV-files contain item Names,Indices
      CS = '$'
      OPEN(2,STATUS='SCRATCH')
C  Set default parameters and other initializations
ccc      EXP = 1/2.
      EXP = 1.
      CUT = .1
      KP = 132
      CALL SYSTEM('cls')
      CALL PRNT(0,KP,6)
      FMT1 = '(4X,8X,3(2X,5A5))'
      FMT2 = '(4X,8X,2(2X,5A5),90(:/14X,2(2X,5A5)))'
      IF(KP<100) THEN
        FMT = '(4X,8X,2(2X,5A5),90(:/14X,2(2X,5A5)))'
      ELSE
        FMT = '(4X,8X,3(2X,5A5),60(:/14X,2(2X,5A5)))'
      END IF
C
      WRITE(6,'(/" This program computes congruence divergences bet",
     +  "ween the patterns in two"/" HYBALL log files.  They must ",
     +  "have variables in common, but not necessarily"/" the same ",
     +  "number of factors or the same totality of variables.")')
      WRITE(6,'(/" The Hybuf records available for comparison here ",
     +  "are:")')
      ALLOCATE ( NAME(80) )
      CALL LOOK(1,'*.*',NAME,80,NN)
      IF(NN==0) WRITE(6,'(/ " There are no HYBUF logfiles in this",
     +  " subdirectory.")')
      IF(NN==0) STOP
      N1 = 1
      N2 = 2
      IF(NN==1) N2 = 1  ! Only one logfile available
20    FH(1) = NAME(N1)
      LH(1) = LAST(FH(1),12)
      FH(2) = NAME(N2)
      LH(2) = LAST(FH(2),12)
25    WRITE(6,'(/" Log files No. ",A," (",A,") and No. ",A," (",A,
     +  ") are now set for"/" comparison. Hit RETURN if OK, or selec",
     +  "t indices of preferred pair."/)') CF(:JF(N1)), FH(1)(:LH(1)),
     +  CF(:JF(N2)), FH(2)(:LH(2))
      CALL SCAN(J,0,'I',5)
      IF(J<0) GOTO 25
      IF(J==0) GOTO 30
      IF(J==1) THEN
        READ(2,*) N1
        N2 = N1
      ELSE
        READ(2,*) N1, N2
      END IF
      N1 = MAX(1,MIN(N1,NN))
      N2 = MAX(1,MIN(N2,NN))
      GOTO 20
C
C  Read in initial unrotated patterns, reordered if necessary
30    WRITE(6,'(" Checking file contents."/)')
      DEALLOCATE ( NAME )
      OPEN(3,FILE=FH(1),FORM='UNFORMATTED')
      READ(3) N, MV, K   ! K used in size ordering below
      CLOSE(3)
      OPEN(4,FILE=FH(2),FORM='UNFORMATTED')
      READ(4) N, N, L
      CLOSE(4)
      MV = MAX(MV,N); MF = MAX(K,L); MFF = LO(MF,MF)
      IF(L>K) THEN
        WORD(:12) = FH(1)
        L = LH(1)
        FH(1) = FH(2)
        LH(1) = LH(2)
        FH(2) = WORD(:12)
        LH(2) = L
C         Number of factors in FH(2) is no greater than the number in FH(1)
      END IF
      ALLOCATE ( IDENT(MV,2), NAME(2) )
      ALLOCATE ( FX(MV,2),LLST(MV,2),LST(MV,2),MATCH(MV,2),ORDER(MF) )
      ALLOCATE ( AA(MV,MF,2), CC(MFF,2), W1(MV,MF) )

cccC Form of HYBUF record No. 0 (input pattern)
ccc      WRITE(8) NTOT, NV1, NF1, KODE, NFF1, NFQ, MTH, ((A0(I,J),I=1,NV1),
ccc     + J=1,NF1), (CFF(I),I=1,NFQ), F1, F2, (LST1(I),I=1,NV1), N,
ccc     + (LST2(I),I=1,N), NB, (FIX1(I),I=1,NB)
cccC        HYBLOCK writes NV1 for NX; otherwise, LST2 is empty.
ccc      IF(NX==NV1) NX = 0
ccc      IF(NF1==NFF1 .AND. KODE<0) QB = .TRUE. ! HYBLOCK input
cccC       LST1 gets raw-score indices in COV-file F2; F1 is Hyball-input name
cccC Form of HYBUF records after No. 0 (rotated patterns)
ccc      READ(8) NL, ((X,I=1,NV),J=1,NF), ((X,I=1,NF),J=1,NF), L, BBH,
ccc     + CCV, JJA, JJB, WWSAL, PPD1, MX, ((OMT(I,J),I=1,NFF),J=0,MX),
ccc     + (FX(I),I=1,NF), NNB, (FX1(I),I=1,NNB), NNPFX, (PFX1(I),I=1,
ccc     + NNPFX),BB0, BB1, DDB, DDF, CCLOSE, IIMAX, IICYC, T, JFLAG

CCC >>>>>> CHECK: righthand NF appears larger than left one: VERBOTEN


      LOGS = 2    ! Two logs or one?
      IF(FH(1)==FH(2)) LOGS = 1
      DO K = 1,2  ! Want both K even if LOGS=1
        NAME(K) = FH(K)
        IF(FH(K)(6:6)=='(' .OR. FH(K)(6:6)==')') KFB = 1
        OPEN(K+2,FILE=FH(K),FORM='UNFORMATTED')
        READ(K+2) I,NV(K),NF(K), KOD(K),I,NFF,I, ((AA(I,J,K),I=1,NV(K)),
     +    J=1,NF(K)),(CC(I,K),I=1,NFF),FM(K),FC(K),(LST(I,K),I=1,NV(K))
        LC(K) = LAST(FC(K),12)
        IF(NX(K)==NV(K)) NX(K) = 0
C         NX(K) = NV(K) flags HYBLOCK origin; else is count of X-set variables
C         FM(K) gets MODA-output filename. LST lists variables: LST(I,K) is the
C           Ith item's index in the COV-file source FC(K) of pattern file FH(K)
C ****    This read of Input is no longer correct for QUADFAC results.
        OPEN(10+K,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +    RECL=4*(NV(K)*NF(K)+4))  ! Now positioned to read Record 1
54      READ(2+K,END=55) N, ((W1(I,J),I=1,NV(K)),J=1,NF(K))
        NT(K) = N  ! Number of patterns in logfile (Must save before hitting EoF)
        WRITE(10+K,REC=N) ((W1(I,J),I=1,NV(K)),J=1,NF(K))
        GOTO 54
55      CLOSE(2+K)
        KK = ABS(KOD(K))  ! Minus flag not really operative at present
        CVAR(K) = (KK/1000000)*.01  ! Division by INTEGER avoids rounding up in CVAR
        KOD(K) = MOD(KK,1000000)  ! Strip off variant head
        LM(K) = LAST(FM(K),12)
        IF(K>LOGS) CYCLE
        WRITE(6,'(" Log ",A," contains ",A," rotations of input patte",
     +    "rn ",A," (",A," x ",A,").")') FH(K)(:LH(K)), CF(:JF(NT(K))),
     +    FM(K)(:LM(K)), CF(:JF(NV(K))), CF(:JF(NF(K)))
      END DO
      DEALLOCATE ( W1 )
      MREC = MAX(NT(1),NT(2))

C   Item matching:
C   1.  Same COV-file: match by COV-item indices in logfile.  If COV-file lacks
C         namelist, use indices as proxies (raw-data indices if available).
C   2.  Different COV-files: If same datafile, match by rawdata indices.  If
C         a COV-file lacks namelist, use rawdata indices as proxies.

C       Same COV?    QN  QI     get IDENT        get LLST   
C      Ĵ
C          YES       T        from COVfile     default    
C                    F        default proxy        "       
C      Ĵ
C          NO       T*  T*     from COVfile     from COV   
C                   F*  T*     LLST proxy          "   "    
C       F*: notT*  T*  F*     construct LLST from Cov IDENT 
C       F*: notT*  F*  F*                   STOP            
C      

      DO K = 1,2    ! Try to retrieve COV-file info on variables
        DO I = 1,NV(K)  ! Default IDENT and LLST
          LLST(I,K) = ABS(LST(I,K))  ! COV-file name indices without refl flags
          IDENT(I,K) = '['//CF(:JF(LLST(I,K))) //']      '
        END DO
        FD(K)(:1) = '?'; LD(K) = 1
        IF(K==2 .AND. FC(1)(:1)/='?') THEN  ! FC(1) can get '?' on K=1 pass
          WORD(:LL-LC(1)+12) = WORD(:LL-LC(1))//FC(2)  ! LL defined on 1st pass
          LL = LL-LC(1)+LC(2)
          IF(QFMT(WORD(:LL))=='Y') GOTO 62
        END IF
        IF(K>LOGS .AND. FC(1)(:1)=='?') THEN
          FC(2)(:1) = '?'; GOTO 60
        END IF
        CALL GETNAM(FC(K),WORD,LL)   ! LL returns length of full pathname put into NAME
        IF(FC(K)(:1)=='?') QY = .FALSE.  ! FC(K) returns with '?' if file not found
        IF(FC(K)(:1)=='?') GOTO 60
62      CALL START(9,WORD(:LL))      ! WORD returns full pathname if file located
        READ(9,*,ERR=67,END=67) NV1(K), (CH1,I=1,3), FD(K)
        ALLOCATE ( IDN(NV1(K)), KNG(NV1(K)) )     !   ^  Rawdata filename
        LD(K) = LAST(FD(K),12)
64      READ(9,'(A)',END=60) CH1    ! Retrieve info from COV-file
        IF(CH1=='N') THEN           ! Namelist found
          FC(K)(12:12) = ' '        ! Delete no-names flag  ( needed ?? )
          READ(9,*,ERR=67,END=67) (IDN(I),I=1,NV1(K))   ! Recover COV namelist
          QN(K) = .TRUE.  ! COV-items namelist retrieved
          DO I = 1,NV(K)  ! Rem: LST is item-index list in hybuf input
            IDENT(I,K) = IDN(ABS(LST(I,K)))  ! IDENT(I,K) is name of Ith variable in logfile K
          END DO
        ELSE IF(CH1=='T') THEN
          READ(9,*,ERR=67,END=67) (KNG(I),I=1,NV1(K))  ! Recover rawdata indices of COV variables
          DO I = 1,NV(K)
            LLST(I,K) = KNG(ABS(LST(I,K)))   ! Rawdata index of item I
          END DO
          QI(K) = .TRUE.  !  Items' rawdata indices recovered
          GOTO 60
        END IF
        GOTO 64  ! Read next line of COV-file
67      FC(K)(12:12) = '#'  ! flags corrupt COV-file
60      IF(ALLOCATED(IDN)) DEALLOCATE ( IDN, KNG )
        CLOSE(9)
      END DO     ! End loop on K
      LQI = 0; LQN = 0
      IF(LOGS==1 .OR. QI(1).AND.QI(2)) LQI = 1  ! One log, or two with raw indices
      IF(LOGS==1 .OR. QN(1).AND.QN(2)) LQN = 1  ! One log, or two with names
      IF(FC(1)/=FC(2) .AND. FD(1)/=FD(2)) LQI = 0  ! Raw indices don't matter in this case
      IF(LQI+LQN==0) THEN   ! No go
        WRITE(6,'(/" Inadequate input:")')
        DO K = 1,2
          IF(.NOT.QN(K)) WRITE(6,'(3X,"Sourcefile ",A," lacks item ",
     +      "names.")') FC(K)(:LC(K))
          IF(.NOT.QI(K)) WRITE(6,'(3X,"Sourcefile ",A," lacks raw-",
     +      "data indices.")') FC(K)(:LC(K))
        END DO
        WRITE(6,'(" Run is aborted.")')
        STOP
      END IF
      IF(LQI==0) THEN   ! Construct LLST from matching names
        JL = 1; IF(NV(2)>NV(1)) JL = 2   ! Log JL has the larger NV if different
        IL = 3-JL  ! The other log
        NN = 1
        DO I = 1,NV(IL)  ! Find largest index in match-to list JL
          NN = MAX(NN,LLST(I,JL))  !
        END DO
        LP: DO I = 1,NV(IL)  ! Construct LLST( ,IL); keep received LLST( ,JL)
          DO J = 1,NV(JL)    ! LLST(-,JL) holds unsigned item list from HYBUF but
            IF(IDENT(I,IL)==IDENT(J,JL)) THEN    ! Numbers irrelevant later so long as distinct
              LLST(I,IL) = LLST(J,JL); CYCLE LP  ! Only whether LLST(I,IL) = LLST(J,JL) matters
            END IF
            NN = NN+1; LLST(I,IL) = NN
          END DO
        END DO LP
      END IF
      IF(FD(1)/=FD(2)) THEN
        WRITE(6,'(/25X,">>>>>  WARNING  <<<<<"//3X,"These logfiles",
     +    " have different rawdata origins, ",A," vs. ",A,".")')
     +    FD(1)(:LD(1)), FD(2)(:LD(2))
        IF(LQN==1) WRITE(6,'(3X,"Variables are matched betwen files",
     +    " by their names found in")')
        IF(LQN==0) WRITE(6,'(3X,"Variables are matched betwen files",
     +    " by their rawdata indices in")')
        WRITE(6,'(3X,A," and ",A,", respectively; but unless you are s",
     +    "ure"/3X,"that those matches are correct, hit RETURN to abo",
     +    "rt this run."/3X,"Otherwise, enter anything to continue.")')
     +    FC(1)(:LC(1)), FC(2)(:LC(2))
        CALL SCAN(J,0,'B',5)
        IF(J==0) STOP
      END IF
      WRITE(6,'()')
      MAXN = 2     ! Initialize maximum namelength
      DO K = 1,2
        IF(QN(K)) THEN
          IF(K==1.OR.LOGS==2) WRITE(6,'(" Names of ",A,"''s var",
     +      "iables have been retrieved from file ",A,".")')
     +      FH(K)(:LH(K)), FC(K)(:LC(K))
          DO J = 1,NV(K)
            N = LAST(IDENT(J,K),8)
            IF(N==0) IDENT(J,K)(:2) = '??'   ! Case should never arise
            MAXN = MAX(N,MAXN)
          END DO
        ELSE
          IF((K==1.OR.LOGS==2) .AND. FC(K)(12:12)=='?') WRITE(6,
     +      '(4X,"Source-file ",A," has not been located, so names ",
     +      "for the variables"/8X,"in ",A," remain unidentified.")')
     +      FC(K)(:LC(K)), FH(K)(:LM(K))
          IF((K==1.OR.LOGS==2) .AND. FC(K)(12:12)=='#') WRITE(6,
     +      '(4X,"Source-file ",A," has been located, but recovery ",
     +      "of names from it"/8X,"for ",A,"''s variables has been ",
     +      "unsuccessful.")') FC(K)(:LC(K)), FH(K)(:LH(K))
        END IF
        IF(NX(K)==0) CYCLE
        DO J = 1,NX(K)  ! Put indices of X-set variables into FX
          FX(J,K) = LST(NV1(K)-NX(K)+J,K)
        END DO
      END DO

      IF(KOD(1)==KOD(2)) QK = .TRUE. ! Flag whether same COV-origin
C  Consistency check almost surely not really needed:
      IF(QK .AND. FC(1)(:LC(1))/=FC(2)(:LC(2))) THEN
        WRITE(6,'(/12X,"RUN JEOPARDIZED BY INPUT INCONSISTENCY:"/3X,
     +    "These two pattern collections identify the same COV-sour",
     +    "ce by Code"/  "(No. ",A,") but disagree on its name (",A,
     +    " vs. ",A,").")') CF(:JF(KOD(1))), FC(1)(:LC(1)),
     +    FC(2)(:LC(2))
      ELSE IF(.NOT.QK .AND. FC(1)(:LC(1))==FC(2)(:LC(2)) .AND.
     +     KFB==0) THEN
        WRITE(6,'(/12X,"RUN JEOPARDIZED BY INPUT INCONSISTENCY:"/3X,
     +    "These two pattern collections identify the same COV-sour",
     +    "ce by name"/  "(",A,") but disagree on its Code (No. ",A,
     +    " vs. No. ",A,").")') FC(1)(:LC(1)), CF(:JF(KOD(1))),
     +    CF(:JF(KOD(2)))
      ELSE
        GOTO 85
      END IF
      WRITE(6,'(/" Hit RETURN to abort.  Otherwise, enter anything ",
     +  "to continue anyway.")')
      CALL SCAN(J,0,'B',5)
      IF(J==0) STOP

C Match variables between log-files on LLST tag:  Create MATCH listing in the
C order of common LST(2) items; put the unmatched indices into LLST(-,K),
C retaining their original order.
85    NY = 0; NAML = 3
      ALLOCATE ( IDN(MV) )
      OUTER:DO K2 = 1,NV(2)
        DO K1 = 1,NV(1)
          IF(LLST(K2,2)==LLST(K1,1)) THEN
            NY = NY+1
            MATCH(NY,1) = SIGN(K1,LST(K1,1))   ! LST terms may have negative
            MATCH(NY,2) = SIGN(K2,LST(K2,2))   !      reflection flags
            IDN(NY) = IDENT(K2,2)
            IF(IDN(NY)(:1)=='[') IDN(NY) = IDENT(K1,1)  ! Will probably never matter
            NAML = MAX(NAML,LAST(IDN(NY),8))
            IF(IDENT(K2,2)/=IDENT(K1,1)) WRITE(6,'(" ERROR: #1 item ",
     +        A, " (",A,") matched with #2 item ",A," (",A,")")')
     +        CF(:JF(K1)), IDENT(K1,1)(:LAST(IDENT(K1,1),8)),
     +        CF(:JF(K2)), IDN(NY)(:LAST(IDN(NY),8))
            LST(K1,1) = ABS(LST(K1,1)) + 1000*K1  ! MATCH saves reflection
            LST(K2,2) = ABS(LST(K2,2)) + 1000*K2  ! info, so can drop here
            CYCLE OUTER  ! ^ LST(I,K) holds unsigned item index in input-file K
          END IF         !   preceded by index of its name in IDENT(-,K)
        END DO
      END DO OUTER
      DO K = 1,2
        NY = 0; NV1(K) = 0
        DO I = 1,NV(K)
          IF(LST(I,K)>=1000) THEN  ! Just if matched in other namelist
            NY = NY+1
            LST(NY,K) = I   ! LST(K) now has Hybuf indices of matched items
          ELSE
            NV1(K) = NV1(K)+1
            LLST(NV1(K),K) = I  ! LLST(K) now has Hybuf indices of unmatched items
          END IF
        END DO
      END DO
      IF(NY<5) THEN
        WRITE(6,'(/" These two patterns have only",I2," variables",
     +   " in common; scarcely enough for"/" meaningful congruenc",
     +   "es.  Enter anything to continue anyway; otherwise,"/
     +   " hit RETURN to quit.")') NY
        CALL SCAN(J,0,'B',5)
        IF(J/=0.AND.NY<=1) WRITE(6,'(" Oh, don''t be silly.")')
        IF(J==0 .OR. NY<=1) STOP
      END IF
      ALLOCATE ( COMM(MV,2) )
      COMM = 99999    ! So CLN will print flags not overwritten as '=='
      DO K = 1,2
        DO I2 = 1,NY   ! Replace 99999 by communalities for common variables
          I = LST(I2,K); COMM(I,K) = 0.
          DO J = 1,NF(K); DO M = 1,NF(K)
             COMM(I,K) = COMM(I,K) + AA(I,J,K)*CC(LOC(J,M),K)*AA(I,M,K)
          END DO; END DO
        END DO
      END DO
C  Put results filename in F3: $2 (or #2 for Unix) followed by start of the two
C  MODA-output basenames up to six chars so far as these agree, with letter-index extension
      QK = .FALSE.      ! Becomes T if any call of SCHEMA
      L = 1; F4 = FM(1) ! Find L = length of common basename start
      DO WHILE (F4(L:L)==FM(2)(L:L) .AND. F4(L:L)/='.'); L=L+1; END DO
      L = L-1; K = 0
      DO WHILE (ICHAR(F4(L-K:L-K))<61); K = K+1; END DO ! Count of common base-digits
      F3 = CS//'2'//F4; J = MAX(0,L-6) ! J is number of trailing letters to delete
      IF(J>0) F3(3:) = F4(:L-J-K)//F4(L-K+1:)  ! Headname length is 2+L-J
      M = L-J+3   ! Position of decimal in output name
      F3(M:) = '.       '
      LF3 = M+1; J = 64       ! LF3 is start of extension
122   J = J+1
      F3(LF3:LF3) = CHAR(J)
      INQUIRE(FILE=F3,EXIST=QY)
      IF(QY.AND.J<90) GOTO 122
      F4 = F3(:LF3)//'P     '  ! Pattern-display flag in 2nd extension place
      WRITE(6,'(/" Comparisons will be written to file ",A)') F3
      WRITE(6,'(/" Hit RETURN to continue.")')
      READ(5,'(A1)')
      OPEN(7,FILE=F3)
      CALL PRNT(1,KP,7)
      WRITE(7,'(" TWOLOG comparisons of patterns in ",A," with ",
     +  "patterns in ",A,".")') FH(1)(:LH(1)), FH(2)(:LH(2))
      CALL DAY(7)
C
C Display factor pattern/covariances to be rotated
      DO K = 1,LOGS
        WRITE(6,'(/" Initial pattern of ",A," variables on ",A," fac",
     +    "tors in ",A/" Communalities, or == flags for unmatched it",
     +    "ems, are in parentheses:")') CF(:JF(NV(K))),
     +    CF(:JF(NF(K))), FH(K)(:LH(K))
        IF(NF(K)<=12) CALL SHOW(NV(K),NF(K),FMT1,AA(1,1,K),COMM(1,K))
        IF(NF(K)>12) CALL SHOW(NV(K),NF(K),FMT2,AA(1,1,K),COMM(1,K))
      END DO
      DEALLOCATE ( COMM, CC )
      LL = 120/(6+MAX(3,MAXN))   ! Number of fields per line
      IF(LL>=10) CH2 = CF(:JF(LL))
      IF(LL<10) CH2 = ' '//CF(:JF(LL))
      FMT1 = '(80(1X,'//CH2//'(I4,": ",A),:/))'//'                  '
      DO K = 1,LOGS
        WRITE(7,'(/1X,A," comprises rotations of initial pattern ",A,
     +    " (No. ",A,A3,") of ",A," variables on ",A," factors.")')
     +    FH(K)(:LH(K)), FM(K)(:LM(K)), CF(:JF(KOD(K))), CLN(CVAR(K),
     +    3,2), CF(:JF(NV(K))), CF(:JF(NF(K)))
        WRITE(7,'(1X,A," was extracted from the covariances in ",A,
     +    " derived from rawdata file ",A)') FM(K)(:LM(K)),
     +    FC(K)(:LC(K)), FD(K)(:LD(K))
        IF(LOGS==2 .AND. NV1(K)==0) THEN
          WRITE(7,'(" Each data variable in the ",A," patterns match",
     +      "es a variable in the ",A," patterns.")') FH(K)(:LH(K)),
     +      FH(3-K)(:LH(3-K))
        ELSE IF(LOGS==2) THEN
          WRITE(7,'(/" Data variables in the ",A," patterns, pre",
     +      "ceded by their indices in this pattern collection,"/
     +      " that match a variable in the ",A," patterns:")')
     +      FH(K)(:LH(K)), FH(3-K)(:LH(3-K))
          WRITE(7,FMT1) (LST(I,K),IDENT(LST(I,K),K),I=1,NY)
          WRITE(7,'(/" Data variables in the ",A," patterns that",
     +      " do NOT match any variable in the ",A," patterns:")')
     +      FH(K)(:LH(K)), FH(3-K)(:LH(3-K))
          WRITE(7,FMT1) (LLST(I,K),IDENT(LLST(I,K),K),I=1,NV1(K))
        END IF    ! LLST and LST are now free
        IF(NX(K)>0) THEN
          WRITE(7,'(/" Fixed-input (X-set) variables in the ",A,
     +      " patterns:")') FH(K)(:LH(K))
          WRITE(7,FMT1) (FX(I,K),IDENT(FX(I,K),K),I=1,NX(K))
        END IF
        N = 0    ! Count number of reflections
        DO I = 1,NV(K)
          IF(MATCH(I,K)<0) N = N+1
        END DO     !  ********* A phantom reflection was counted
        IF(N>0) WRITE(7,'(/" All reflected variables (",A,") are",
     +    " returned to their rawdata orientation.")') CF(:JF(N))
      END DO     !  IDENT is now free

C Show misfit ratings for both sets of solutions relative to the best
C pattern in both sets.
      DEALLOCATE ( IDENT )
      ALLOCATE (  KTMP(MREC), LPIK(MREC,2) )
      IF(LOGS==1) WRITE(6,'(/" If you want hyperplane-misfit rat",
     +  "ings of all patterns relative to the best"/" one, hit RE",
     +  "TURN.  Otherwise, enter anything to move on.")')
      IF(LOGS==2) WRITE(6,'(/" If you want hyperplane-misfit rati",
     +  "ngs of both sets of patterns relative"/" to the best of ",
     +  "both, hit RETURN.  Otherwise, enter anything to move on.")')
      CALL SCAN(J,0,'B',5)
      LPIK(1,1) = J  ! Negative value flags no misfit ratings
      IF(J==0) CALL RATE(FH,FM,LPIK,MV,NV,NF,NT,LOGS)  ! LPIK returns each index set in Best order
C Record congruence information
      QY = .FALSE.
140   IF(QY) WRITE(6,'(/" If you want congruence reports to include",
     +  " identification of matching factors,"/" hit RETURN.  Oth",
     +  "erwise, enter anything for less cluttered reports.")')
      IF(.NOT.QY) WRITE(6,'(/" If you want congruence reports to wa",
     +  "ive identification of matching factors,"/" hit RETURN.  ",
     +  "Otherwise, enter anything for more fulsome reports.")')
      CALL SCAN(J,0,'B',5)
      IF(J==0) GOTO 142
      GOTO 140

142   BIG:DO K = 1,LOGS
143     KTMP(1) = 1
        KTMP(2) = NT(K)
        LA(K) = 0   ! Number of patterns set for print
        IF(LOGS==2) THEN
          IF(K==1) WRITE(6,'(/18X,"SELECT FIRST-FILE PATTERNS")')
          IF(K==2) WRITE(6,'(/17X,"SELECT SECOND-FILE PATTERNS")')
          WRITE(6,'(" Logfile ",A,":  You may choose any subset of t",
     +      "he patterns in"/9X,"this for congruence comparisons to ",
     +      "your pick from the other"/9X,"logfile by entering indic",
     +      "es in one of the following ways:")') NAME(K)(:LH(K))
        END IF
        IF(LOGS==1) WRITE(6,'(/" Logfile ",A,":  You may choose any ",
     +    "subset of the patterns in"/9X,"this for congruence compar",
     +    "isons by entering indices in one"/9X,"of the following ",
     +    "ways:")') NAME(K)(:LH(K))
        WRITE(6,'(3X,"1. To choose all ",A," patterns in ",A,", hit ",
     +    "RETURN.")') CF(:JF(NT(K))), NAME(K)(:LH(K))
        WRITE(6,'(3X,"2. To choose all with index N or higher, enter ",
     +    "N."/3X,"3. To choose all from N1 to N2 inclusive, enter th",
     +    "is pair of indices."/3X,"4. To scatter-pick three or more,",
     +    " enter the string of their indices up"/9X,"to a maximum ",
     +    "of ",A,". (You can fake three by entering duplications).")')
     +     CF(:JF(MIN(25,NT(K))))
        IF(LPIK(1,K)>=0) WRITE(6,'("   5. To pick the N best in your ",
     +    "last Misfit listing, enter -N (negative N)."/)')
        IF(K==1.OR.LA(1)>0) WRITE(6,'(3X,"NOTE: Choice of option 4 or",
     +    " 5 will avail perspicuous printouts of"/9X,"pattern pairs",
     +    " with their matched-factor columns juxtaposed."/9X,"(Only",
     +    " your approved subset of those pairs will be recorded.)"/
     +    9X,"To Quit, enter any letter."/)')

C   1. To choose all xx patterns in XXXXXXXXXXX, hit RETURN.
C   2. To choose all with index N or higher, enter N.
C   3. To choose all from N1 to N2 inclusive, enter this pair of indices.
C   4. To scatter-pick three or more, enter the string of their indices up
C         to a maximum of 25.  (You can fake three by entering duplications.)
C   5. To pick the N best on your last misfit listing, enter -N (negatve N).
C   NOTE: Choice of option 4 or 5 will avail perspicuous printouts of
C         pattern pairs with their matched-factor columns juxtaposed.
C         (Only your approved subset of those pairings will be recorded.)
C         To Quit, enter any letter.

        CALL SCAN(J,0,'I',5)  ! Save in LPIK(-,K), list length in LB(K)
        IF(J==-1) THEN; CLOSE(7,STATUS='DELETE'); STOP; END IF
        IF(J>0) READ(2,*) (KTMP(I),I=1,J)
        IF(J==-2) THEN  ! Initial LPIK is Best ordering from last Misfit appraisal
          WRITE(6,'(/" Integers only, stupid!")'); GOTO 143
        ELSE IF(KTMP(1)<0 .AND. LPIK(1,K)>=0) THEN  ! Option 5
          LA(K) = 4; LB(K) = MIN(NT(K),ABS(KTMP(1)))    ! $$$$$$$ temp Bookmark
        ELSE IF(J<=2) THEN   ! Option 1, 2, or 3
          M = MAX(1,MIN(NT(K),MIN(KTMP(1),KTMP(2))))
          N = MAX(1,MIN(NT(K),MAX(KTMP(1),KTMP(2))))
          LB(K) = 0
          DO I = M,N
            LB(K) = LB(K)+1; LPIK(LB(K),K) = I
          END DO
        ELSE  ! J  3 sets Option 4     ! ******** LB=4 from only three entries
          LA(K) = MIN(4,NT(K)) ! LA is default number on K-list to compare
          LB(K) = 1; LPIK(1,K) = KTMP(1)
          LPB: DO I = 2,J
            M = KTMP(I); IF(M<1 .OR. M>NT(K)) CYCLE LPB  ! M out of range
            DO L = 1,I-1; IF(M==LPIK(L,K)) CYCLE LPB; END DO ! already PIKed
            LB(K) = LB(K)+1; LPIK(LB(K),K) = M
          END DO LPB   ! $$$$$$ LPIK(_,K) lists selection from logfile K
        END IF
        WORD(:17) = ' to the other set'  ! 0 vs. 17 => (LOGS-1)*17
        WRITE(6,'(/" The ",A," pattern indices selected for com",
     +    "parison",A," are",3(:/26(1X,A)))') NAME(K)(:LH(K)),
     +    WORD(:(LOGS-1)*17), (CF(:JF(LPIK(I,K))),I=1,LB(K))
        WRITE(6,'(" Hit RETURN if OK, or enter anything to try ",
     +    "again.")')
        READ(5,'(A)') CH1
        IF(CH1/=' ') GOTO 143
      END DO BIG      ! End of LPIK declaration loop
      DEALLOCATE ( KTMP, LLST, LST, NAME )

      IF(LOGS==1) THEN
        LB(2) = LB(1); LA(2) = LA(1)
        DO I = 1,LB(2)
          LPIK(I,2) = LPIK(I,1)
        END DO
      END IF
      IF(LA(2)==0) LA(1) = 0
      IF(LA(1)==0) GOTO 165
      LA(1) = MIN(4,LB(1)); LA(2) = MIN(4,LB(2))
160   IF(LOGS==2) THEN   ! Default LA-limit adjustable here
        WRITE(6,'(" For each of the first N1 patterns in your select",
     +    "ion list from ",A/" crossed with the first N2 in your sel",
     +    "ection from ",A,", you will be"/" queried whether to prin",
     +    "t this pair''s matched columns.  Hit RETURN to"/" accept",
     +    " present limits N1 = ",A,", N2 = ",A,".  Otherwise, ent",
     +    "er new N1/N2 pair."/)') FH(1)(:LH(1)), FH(2)(:LH(2)),
     +    CF(:JF(LA(1))), CF(:JF(LA(2)))
      ELSE
        WRITE(6,'(4X,"For each pair of the first N patterns in your ",
     +    "selection list, you will"/4X,"be queried whether to print",
     +    " this pair''s matched columns. To accept"/4X,"present lim",
     +    "it N = ",A,", hit RETURN.  Otherwise, enter new choice ",
     +    "of N."/)') CF(:JF(LA(1)))
      END IF
      CALL SCAN(J,0,'I',5)
      IF(J==0) GOTO 165
      IF(J<0) THEN
        LA(2) = 0
      ELSE
        READ(2,*) (LA(I),I=1,J)
        LA(1) = MAX(0,MIN(NT(1),LA(1)))
        IF(J==1) LA(2) = LA(1)
        IF(J==2) LA(2) = MAX(0,MIN(NT(2),LA(2)))
        GOTO 160
      END IF

165   IF(LA(2)==0) LA(1) = 0
      LOW = 900   ! Initialize finding smallest divergence-times-10
      WRITE(7,'(//1X,10("* ")," PATTERN CONGRUENCES",10(" *"))')
      WRITE(7,'(/" Each congruence subtable M gives the congruences",
     +  " of all selected patterns"/" in ",A," with the Mth pattern",
     +  " in ",A,".")') FH(1)(:LH(1)), FH(2)(:LH(2))
      WRITE(7,'(/" In each row M of the congruence report for a ",
     +  "pattern pair <L,M>, entry J is the angle in degrees of"/
     +  " congruence divergence between the Jth column of pattern L ",
     +  "and its counterpart in the best-matching"/" permutation of",
     +  " pattern M.  AV is the Mean of these matched-",
     +  "factor congruences.")')
CCC     +  " pattern M.  AV is the Power-",A3," Mean of these matched-",
CCC     +  "factor congruences.")') CLN(EXP,3,2)
      IF(QY) WRITE(7,'(" Each entry J includes in brackets the index ",
     +  "of the pattern-M column matched to pattern L''s column J.")')
      MST = 0  ! Not needed if LOGS = 1
ccc      IF(LOGS==1) GOTO 180
ccc      DO I = 1,14
ccc        MST(I) = 0   ! Initialize combined distribution count for DIST print
ccc      END DO
C
C Make congruence comparisions; target pattern has the smaller NF (= NF(2))
180   IF(LA(1)>0) OPEN(8,FILE=F4)
      OPEN(18,STATUS='SCRATCH',FORM='UNFORMATTED',ACCESS='DIRECT',
     +  RECL=4*NF(2)+4)     ! ***** Why do I need 4*NF here and elsewhere ???
      DO J = 1,NT(1)*NT(2)
        WRITE(18,REC=J) 0             ! Initialize KNG store
      END DO
      MQ = MAX(MF,1+(2*(MF+1)**2)/MV)  ! Insure MV*MQ  2(MF+2MF) for real*8 WK in AALIGN
      ALLOCATE ( CV(MREC,MREC), W1(MV,MQ), DG(MF), KNG(MF) )
      BBIG: DO K2 = 1,LB(2)
        N2 = LPIK(K2,2)
        READ(12,REC=N2) ((W1(I,J),I=1,NV(2)),J=1,NF(2))  ! Read 10+K for K=2
        DO I = 1,NY
          R = 1.
          IF(MATCH(I,2)<0) R = -1.
C           MATCH(I,2) is signed index in COV-file list of Ith item in common
          DO J = 1,NF(2)
            AA(I,J,2) = R*W1(ABS(MATCH(I,2)),J)    ! Negative R reverses reflection
          END DO
        END DO
        IF(LOGS==1 .AND. K2==LB(2)) GOTO 206
        WRITE(6,'(" Computing comparisons for ",A, " pattern No. ",A)')
     +    FH(2)(:LH(2)), CF(:JF(N2))
        WRITE(7,'(/" Congruence match (degrees divergence) to ",A,
     +    " pattern No. ",A," of ",A," pattern")') FH(2)(:LH(2)),
     +    CF(:JF(N2)), FH(1)(:LH(1))
206     LP40: DO K1 = 1,LB(1)
          N1 = LPIK(K1,1)
          READ(11,REC=N1) ((W1(I,L),I=1,NV(1)),L=1,NF(1))  ! Read 10+K for K=1
          DO I = 1,NY
            R = 1.
            IF(MATCH(I,1)<0) R = -1.
            DO J = 1,NF(1)
              AA(I,J,1) = R*W1(ABS(MATCH(I,1)),J)    ! Negative R reverses reflection
            END DO
          END DO
          CALL AALIGN(AA(1,1,1),AA(1,1,2),ORDER,DG,NY,NF,EXP,AV)
C            N1 is the A-pattern which AALIGN permutes to match B-pattern N2.
C            ORDER(I) is the N1-factor matched with N2-factor I, while DG(I)
C            is the Ith N2-factor's congruence with the matched N1-factor.
C              (ORDER doesn't return any negative reflection flags.)
C            AV now returns the Power-EXP Mean divergence
          WRITE(18,REC=FIND(K1,K2)) (INT(DG(J)*10)*1000+ORDER(J),
     +      J=1,NF(2))
C            Old KNG stored for each pattern comparison the list of their matched-factor
C            divergences times 10, followed by the match-mapping from #2 to #1.
C            Information is now saved in scratchfile 18 and retrieved to new KNG when needed
CCC          CALL ISORT(NF(2),KNG(1,K1,K2))  ! Don't need this at present (old KNG)
          CV(K1,K2) = AV
          IF(LOGS==1 .AND. K1<=K2) CYCLE LP40
          IF(QY) WRITE(7,'(I4,": (AV =",A5,") ",10(A5," [",I2,
     +      "]":","),20(/18X,10(A5," [",I2,"]":",")))')
     +      LPIK(K1,1),CLN(AV,5,1), (CLN(DG(I),5,1),ORDER(I),I=1,NF(2))
          IF(.NOT.QY) WRITE(7,'(I4,": (AV =",A5,") ",20A5,20(:/18X,
     +      20A5))') LPIK(K1,1),CLN(AV,5,1), (CLN(DG(I),5,1),I=1,NF(2))
          IF(K1>LA(1) .OR. K2>LA(2)) CYCLE LP40
230       IF(LOGS==2) WRITE(6,'(/3X,"If you want matched-column pr",
     +      "intout of No. ",A, " in ",A," and No. ",A/3X,"in ",A,1X,
     +      "with loadings less than CUT =",A4," blanked, hit RETURN."/
     +      3X,"Otherwise enter an alternative CUT, or any letter to",
     +      " omit this pair."/)') CF(:JF(N1)), FH(1)(:LH(1)),
     +      CF(:JF(N2)), FH(2)(:LH(2)), CLN(CUT,4,2)
          IF(LOGS==1) WRITE(6,'(/3X,"If you want a matched-column p",
     +      "rintout of patterns No. ",A," and No. ",A/3X,"with loadi",
     +      "ngs less than CUT =",A4," blanked, hit RETURN.  Otherwi",
     +      "se,"/ 3X,"enter an alternative CUT or any letter to omit",
     +      " this pair."/)') CF(:JF(N1)), CF(:JF(N2)), CLN(CUT,4,2)
          CALL SCAN(J,0,'R',5)
          IF(J==-1) CYCLE LP40
          IF(J>=1) THEN
            READ(2,*) CUT
231         IF(CUT>=1.) CUT = CUT/10
            IF(CUT>=1.) GOTO 231
            GOTO 230
          END IF
          WRITE(8,'(//"",30A)') ('',I=1,NF(2))

C column-pair's congruence divergence, RMSd is the root-mean-square difference of
C their corresponding elements, and RMSj (j = 1,2) is pattern No.j's RMS loading on
C this factor.  Variables have the order of their received occurrence in Pattern #2;
C and if paired factors are negatively congruent as received, #1 is reflected when
C computing Div and RMSd

          WRITE(8,'(" Patterns No. ",A," (#1 below) in ",A," and No. ",
     +      A," (#2) in ",A," juxtaposed by"/" matching columns.  Ea",
     +      "ch vertical cell of the table headed ''M N'' comprises"/
     +      " column M of #1 followed by its best-matching column N i",
     +      "n #2.  Pattern loadings"/" are given to 2 decimals with ",
     +      "point omitted; values larger than .99 are rounded"/" dow",
     +      "n; and paired values both smaller than parameter CUT are",
     +      " blanked.  At the"/" table''s foot, Div is the column-p",
     +      "air''s congruence divergence, RMSd is the"/" root-mean-",
     +      "square difference (x 100) of their corresponding element",
     +      "s, and RMSj"/" (j = 1,2) is pattern No.j''s RMS (x 100) ",
     +      "loading on this factor.  Variables"/" have the order of",
     +      " their received occurrence in Pattern #2; and if paired"/
     +      " factors are negatively congruent as received, #1 is ref",
     +      "lected when computing"/" Div and RMSd.  [Reminder. The " ,
     +      """divergence"" of two conforming real vectors is"/" the ",
     +      "angle in degrees whose cosine is their unsigned congruen",
     +      "ce coefficient.]")') CF(:JF(N1)), FH(1)(:LH(1)),
     +      CF(:JF(N2)), FH(2)(:LH(2))
          IF(.NOT.QN(1) .AND. .NOT.QN(2)) WRITE(8,'(/" NOTE: The var",
     +      "iables'' sourcefile indices are substituted for their ",
     +      "unavailable names.")')
          CALL SCHEMA(NY,NF(2),CUT,NAML,AA,ORDER,DG,W1,IDN,8)
          QK = .TRUE.
240     END DO LP40
200   END DO BBIG

C Display congruence information more perspicuously
      KF = 7   ! Output to SEE-file
      N = 1+5*LB(1)*LB(2)
      IF(LOGS==1) N = 1+5*LB(1)*(LB(1)-1)/2
      WRITE(6,'(/4X,"To record each of these pattern comparisons al",
     +  "so as a distribution of"/4X,"matched-factor divergences, ",
     +  "hit RETURN.  Otherwise, enter anything"/4X,"to omit this.",
     +  "  (It will add ",A," lines to your output file.)")')
     +  CF(:JF(N))
      READ(5,'(A)') CH1
      IF(CH1/=' ') KF = 0  ! Null output
      IF(KF>0) WRITE(7,'(//" CONGRUENCES REPORTED AS DISTRIBUTI",
     +  "ONS:  For each pattern comparison listed"/" above, the ",
     +  "distribution of its ",A," matched-factor divergences.")')
     +    CF(:JF(NF(2)))
      DO K2 = 1,LB(2)+(LOGS-2)
        DO K1 = 1,LB(1)
          IF(LOGS==1 .AND. K1<=K2) CYCLE
          IF(KF>0) WRITE(7,'(/11X,"Congruence of ",A," No. ",A,
     +      " with ",A," No. ",A)') FH(1)(:LH(1)), CF(:JF(LPIK(K1,
     +      1))) , FH(2)(:LH(2)), CF(:JF(LPIK(K2,1)))
          READ(18,REC=FIND(K1,K2)) (KNG(J),J=1,NF(2))
          DO J = 1,NF(2)
            KNG(J) = KNG(J)/1000   ! Original Divergence times 10
          END DO
          CALL DIST(NF(2),KNG,MST,LOW,KF,1)
        END DO
      END DO

      WRITE(7,'(//" CONGRUENCE SUMMARY: For each solution pair ",
     + "tabled above, the Power-",A3," mean divergence of their ",
     + "matched columns.")') CLN(EXP,3,2)
      WRITE(7,'(" Row L is the Lth pattern in ",A,"; column M is ",
     + "the Mth pattern in ",A,".")') FH(1)(:LH(1)), FH(2)(:LH(2))
      K2 = MIN(25,LB(2))
      WRITE(7,'(/4X,25I5,3(/4X,25I5))') (LPIK(I,2),I=1,LB(2))
      FMT = '(4X,"'//ANG//'",200A)                               '
      WRITE(7,FMT) (BAR,I=1,1+5*K2)
      FMT1 = '(I4,"'//COL//'",25A5,2(:/4X,"'//COL//'",25A5)) '
      DO  I = 1,LB(1)
        WRITE(7,FMT1) LPIK(I,1), (CLN(CV(I,J),5,1),J=1,LB(2))
      END DO
      DEALLOCATE ( CV )

C  Display averaged distributions
      WRITE(6,'()')
      CALL DIST(NF(2),KNG,MST,LOW,6,2)     ! KNG doesn't matter for JOB=2
      CALL DIST(NF(2),KNG,MST,LOW,7,2)
      GAP = (1+LOW/50)*5.     ! LOW comes from JOB=1 calls
      NGAP = 1
      GP(1) = GAP

C   You may finish with tables showing for all the between-log solution pairs
C   how many of their matched columns diverge by less than GAP at one or more
C   levels (your choice) and, for each solution, how frequently each of its
C   columns is matched within distance GAP by pattern columns in the other
C   logfile.  To omit this information, enter any letter.  Otherwise, enter
C   one or more GAP choices between 1.0 and 90.0 in light of the global
C   Divergence distribution above, or hit RETURN to select just GAP = 5.0

      WRITE(6,'(/3X,"You may finish with tables showing for all the ",
     +  "between-log solution pairs"/3X,"how many of their matched co",
     +  "lumns diverge by less that GAP at one or more"/3X,"levels (y",
     +  "our choice) and, for each solution, how frequently each of i",
     +  "ts"/3X,"columns is matched within distance GAP by pattern co",
     +  "lumns in the other"/3X,"logfile.  To omit this information, ",
     +  "enter any letter.  Otherwise, enter"/3X,"one or more GAP cho",
     +  "ices between 1.0 and 90.0 in light of the global"/3X,"Diverg",
     +  "ence distribution above, or hit RETURN to select just GAP = ",
     +  A3/)') CLN(GAP,3,1)
170   IF(NGAP>0) THEN
        WRITE(6,'(/" Your GAP selection is now",1X,10A5)')
     +   (CLN(GP(I),5,1),I=1,NGAP)
        WRITE(6,'(" Hit RETURN if OK.  Otherwise, enter revised",
     +   " selection or any letter to Quit."/)')
      END IF
      CALL SCAN(J,0,'R',5)
      IF(J<0) GOTO 350
      IF(J==0) GOTO 172
      NGAP = MIN(10,J)
      READ(2,*) (GP(I),I=1,NGAP)
      DO I = 1,NGAP
        GP(I) = MAX(1.,MIN(90.,GP(I)))
      END DO
      GOTO 170
172   CONTINUE
      ALLOCATE ( KC(NGAP,MREC,MREC), KNT1(NGAP,MREC,MF),
     +             KNT2(NGAP,MREC,MF) )
      DO I = 1,MREC
        DO J = 1,MF
          DO L = 1,MAX(1,NGAP)
            KNT1(L,I,J) = 0
            KNT2(L,I,J) = 0
          END DO
        END DO
      END DO
399   DO K2 = 1,LB(2)
        DO K1 = 1,LB(1)
           READ(18,REC=FIND(K1,K2)) (KNG(J),J=1,NF(2))
           DO J = 1,NF(2)
             DG(J) = (KNG(J)/1000)*.1
             ORDER(J) = MOD(KNG(J),1000)
           END DO
           DO L = 1,NGAP
             GAP = GP(L)
             KT = 0
             DO K = 1,NF(2)
               IF(DG(K)<GAP) THEN
                 KT = KT+1
                 KNT2(L,K2,K) = KNT2(L,K2,K) + 1
                 KNT1(L,K1,ORDER(K)) = KNT1(L,K1,ORDER(K)) + 1
               END IF
             END DO
             KC(L,K1,K2) = KT
             IF(LOGS==1) KC(L,K2,K1) = KT
           END DO
         END DO
      END DO

      DO L = 1,NGAP
        GAP = GP(L)
        DO M = 1,LOGS
          WRITE(7,'(//" CONGRUENCE CROSS-CENTRALITY COUNT for the ",A,
     +      " solutions, GAP =",A5,":"/" For each factor J in each ",A,
     +      " solution, the number of ",A/" solutions in which J''s ",
     +      "closest match diverges from it by at most",A5,A,".")')
     +      FH(M)(:LH(M)), CLN(GAP,5,1), FH(M)(:LH(M)),
     +      FH(3-M)(:LH(3-M)), CLN(GAP,5,1), U2
          WRITE(7,'(/12X,"Factor: ",30I3,10(:/20X,30I3))') (J,J=1,NF(M))
          WRITE(7,'(1X,200A)') ('',I=1,MIN(110,20+3*NF(M)))
          DO I = 1,LB(M)
            K = 0
            DO J = 1,NF(M)
              IF(M==1) K = K + KNT1(L,I,J)
              IF(M==2) K = K + KNT2(L,I,J)
            END DO
            IF(M==1) WRITE(7,'(I4,": (Total =",I4,") ",30I3,5(:/20X,
     +        30I3))') LPIK(I,1), K, (KNT1(L,I,J),J=1,NF(M))
            IF(M==2) WRITE(7,'(I4,": (Total =",I4,") ",30I3,5(:/20X,
     +        30I3))') LPIK(I,1), K, (KNT2(L,I,J),J=1,NF(M))
          END DO
          IF(LOGS==1) GOTO 337
        END DO

CCC          WRITE(7,'(//" CONGRUENCE CROSS-CENTRALITY COUNT for the ",A,
CCC     +      " solutions, GAP =",F5.1,":"/" For each factor J in ea",
CCC     +      "ch ",A," solution, the number of ",A/" solutions in ",
CCC     +      "which J''s closest match diverges from it by at most",
CCC     +      F5.1,A,".")') FH(2)(:LH(2)), GAP, FH(2)(:LH(2)),
CCC     +      FH(1)(:LH(1)), GAP, U2
CCC          DO I = 1,LB(2)
CCC            K = 0
CCC            DO J = 1,NF(2)
CCC              K = K + KNT2(L,I,J)
CCC            END DO
CCC            WRITE(7,'(I4,": (Total =",I4,") ",30I3,5(:/20X,30I3))')
CCC     +        LPIK(I,2), K, (KNT2(L,I,J),J=1,NF(2))
CCC          END DO

337     WRITE(7,'(//" CONGRUENCE SIMILARITY COUNT, GAP =",F5.1,":"/
     +  " For each solution pair <L,M>, their number of matched patte",
     +  "rn columns with"/" divergence less than",F5.1,A,".  (H"
     +  "ighest possible count is",I3,".)")') GAP, GAP, U2, NF(2)
        WRITE(7,'(" Row L is the Lth pattern in ",A,"; column M is ",
     +   "the Mth pattern in ",A,".")') FH(1)(:LH(1)), FH(2)(:LH(2))
CC        IF(K2<=42) WRITE(7,'(/5X,60I3)') (LPIK(I,2),I=1,LB(2))
CC        IF(K2<=42) WRITE(7,FMT) (BAR,I=1,1+K2*4)
        WRITE(7,'(/5X,42I3)') (LPIK(I,2),I=1,LB(2))
        WRITE(7,FMT) (BAR,I=1,1+MIN(125,K2*3))
CC        IF(K2<=42) FMT1 = '(I4,"'//COL//'",50I4,:/4X,"'//COL//
CC      +  '",50I4)      ' ! Part after 1st 50I4 not needed but fills space
        FMT1 = '(I4,"'//COL//'",42I3,:/4X,"'//COL//'",50I3)      '
        DO I = 1,LB(1)
          WRITE(7,FMT1) LPIK(I,1), (KC(L,I,J),J=1,LB(2))
        END DO
      END DO

350   IF(.NOT.QK) WRITE(6,'(/" Job is complete.  Logfile comparisons",
     +   " are in file ", A)') F3(:LF3)
      IF(QK) WRITE(6,'(/" Job is complete.  Logfile comparisons are",
     +   " in files ",A," and ",A)') F3(:LF3), F4(:LF3+2)
      WRITE(7,'()')
      STOP
      END
C
      SUBROUTINE AALIGN(A,B,ORDER,DG,NV,NF,EXP,AV)
C This compares the columns of NV-by-NF(1) matrix A to those of NV-by-NF(2) matrix
C B, and puts into vector ORDER the permutation (and reflection if signalled
C by negative ORDER value) of A's columns that aligns A with B most closely.
C The congruence coefficients for the best match are converted to degrees
C difference and reported in vector DG with their average in AV.
C NOTE 1: The number of terms returned in ORDER and DG is NF(2).
C NOTE 2: Unlike ALIGN in HYBALL, ORDER is here returned in Get-sequence.
C NOTE 3: AV returns the Power-EXP Mean of the matched-factor divergences.
C >>>>> Double Precision computations here appear to make no appreciable difference.
      INTEGER ORDER(*), NF(2)
      REAL A(MV,*), B(MV,*), DG(*)
      REAL(8) SAB, R, X, RAD, WORK(MF,MF), WK(MV,2)
      COMMON  MV, MF, MREC
      RAD = 90/DACOS(0.D0)
      DO J = 1,NF(2)
        ORDER(J) = 0
        WK(J,2) = 0.D0
        DO I = 1,NV
          WK(J,2) = WK(J,2) + B(I,J)*B(I,J)
        END DO
        WK(J,2) = MAX(WK(J,2),1.D-20)
      END DO
      DO J = 1,NF(1)
        WK(J,1) = 0.D0
        DO I = 1,NV
          WK(J,1) = WK(J,1) + A(I,J)*A(I,J)
        END DO
        WK(J,1) = MAX(WK(J,1),1.D-20)
      END DO
      DO J = 1,NF(1)
        DO K = 1,NF(2)
          SAB = 0.D0
          DO I = 1,NV
            SAB = SAB + A(I,J)*B(I,K)
          END DO
          WORK(J,K) = SAB/SQRT(MAX(WK(J,1)*WK(K,2),1.D-20))
        END DO
      END DO
      AV = 0.
C Return in ORDER(N) the column of A that best matches the Nth column of B.
      BIG: DO K = 1,NF(2)   ! K just a counter here, doesn't index anything.
        NI = 0
        NJ = 0
         X = 0.
        BG: DO I = 1,NF(1)               ! Examine all free I
          DO L = 1,NF(2)
            IF(ABS(ORDER(L))==I) CYCLE BG
          END DO
C             Skip I if already matched
          DO J = 1,NF(2)                 ! paired with all free J
            IF(ORDER(J)/=0) CYCLE
C             Skip J if already matched
            R = DABS(WORK(I,J))  ! Sign of angle dropped here
            IF(R<X) CYCLE   ! If R isn't largest found, try next
C  ***** Must use R < X rather than R  X here because for the last J,
C           there may be no free I such that R(I,J) > 0.
            X = MIN(1.D0,R)
            NI = I     ! This <I,J> is provisionally saved in NI,NJ
            NJ = J     ! if R(I,J) is the largest remaining found so far
          END DO
        END DO BG
CC       ORDER(NI) = SIGN(NJ,FLOOR(SNGL(WORK(NI,NJ))))   ! HYBALL code flags negative cong.
CCC        A-factor NI matches B-factor NJ while negative NJ tells PERM to reflect.
        ORDER(NJ) = NI   ! Don't need sign of NI in this application
C         A-factor NI matches B-factor NJ. (GET-ordering; inverse of ALIGN's PUT-output.)
        DG(NJ) = SNGL(ACOS(MIN(1.D0,X))*RAD)
C         DG(J) is congruence of B-factor J with its matching A-factor
CCC        AV = AV+DG(NJ)   ! Arithmetic mean
        AV = AV + DG(NJ)**EXP   ! Power-EXP mean   ! ??? Reinstate ???
      END DO BIG
CCC      AV = AV/NF(2)
      AV = (AV/NF(2))**(1/EXP)   ! ??? Reinstate ???
      END SUBROUTINE
C
      FUNCTION COMP2(AJ,AK,SS)
C Given an item I's squared loadings AJ and AK on factors J,K and its sum
C of squared loadings SS, compute its Comp2 salience in plane JK as follows:
C P = (AJ+AK)/SS is its prominance of this plane in I's composition, and
C R = Min(|AJ|,|AK|)/MAX(|AJ|,|AK|) [or some monotone increasing function
C f(R) thereof] reflects the degree to which these two factors are equally
C prominant in I.  Then COMP2 = P*R (or [P*f(R)] equals 1.0 when item I lies
C entirely in plane JK with the same weight on both factors, and decreases
C to zero as either factor P or R decreases.
      P = (AJ**2 + AK**2)/SS
      BJ = ABS(AJ); BK = ABS(AK)
      R = MIN(BJ,BK)/MAX(BJ,BK,.0001)  ! AJ and AK can both be negligible
      COMP2 = P*R
      END FUNCTION

      FUNCTION JF(N)
C Return character expression of integer N left-justified in field CF; then
C CF(:JF(N)) writes N with exactly the right length in format specifier A.
C *** Haven't found any way to avoid requiring N to be INTEGER(4).
      CHARACTER(12) CF
      INTEGER(4) K
      COMMON /CF/ CF
C      SAVE /CF/  ! This doesn't appear to be needed
      K = ABS(N)
      CF = '            '
      J = 13
10    J = J-1
      CF(J:J) = CHAR(48+MOD(K,10))
      K = K/10
      IF(K>0) GOTO 10
      IF(N<0) CF(J-1:J-1) = '-'
      CF = ADJUSTL(CF)
      JF = LEN_TRIM(CF)
      END FUNCTION
C
      FUNCTION CLN(X,NFF,ND)
C Express real number X as a character string in fieldwidth NF with LD decimals
C when room, where LD = ABS(ND).  ND<0 tries to precede all positive numbers
C with a blank. LD > 9 displays zero decimals and no decimal point while
C returning X = 0 as ND-10 zeros right-justified in selected field.
C ***** WARNING: If a call of CLN prints garbage, you have forgotten to
C       declare CLN as CHARACTER*8 in the calling routine.
      PARAMETER (KW=16)
      CHARACTER CLN*8, WK(KW)
      CLN = '        '
      NF = MIN(8,NFF)  ! Limit fieldwidth to 8 chars
      LD = ABS(ND)
      IF(ABS(X)<1.0E-12) THEN !  Special for vanishingly small X
        N = MIN(NF-1,MOD(LD,10))
        IF(LD<10) CLN(NF-N:NF+1-N) = '.0'
        IF(LD<10) RETURN
        DO I = 1,N
          CLN(NF+1-I:NF+1-I) = '0'
        END DO
        RETURN
      END IF
      M = NF; IF(ABS(X)>1.) M = NF-1-INT(LOG10(ABS(X))) !  M is space free for decimal (or M-1 if X<0) )
      IF(M<0 .OR.  M<1.AND.X<0.) GOTO 55
      IF(ND>=10) LD = 0; LD = MIN(LD,M)
      DO I = 1,KW
        WK(I) = ' '
      END DO
      IF(LD==0) N = NINT(ABS(X))         ! Shouldn't be needed, but is
      IF(LD/=0) N = NINT(ABS(X)*10**LD)  ! This can overflow if LD is large
      DO I = KW,KW-LD+1,-1
        WK(I) = CHAR(48+MOD(N,10))
        N = N/10
      END DO
      WK(KW-LD) = '.'
      IF(N==0 .AND. LD==0) WK(KW-LD-1) = '0'
      IF(N==0 .AND. X<0. .AND. LD>0) WK(KW-LD-1) = '-'
      DO I = KW-LD-1,2,-1
        IF(N>0) WK(I) = CHAR(48+MOD(N,10))
        IF(N>0 .AND. X<0.) WK(I-1) = '-'
        N = N/10
      END DO
      KS = KW-NF+1
25    KS = KS-1
C       Field returned will start at WK(KS+1) for initial KS
      IF(KS<=0) GOTO 50
      IF(ND>=0) THEN
        IF(WK(KS)/=' ' .AND. WK(KS+NF)/='.') GOTO 25
      ELSE
        IF(WK(KS+1)/=' '. AND. WK(KS+1)/='-' .AND. WK(KS+NF)/='.')
     +    GOTO 25
      END IF
      IF(ND>=10) KS = MAX(1,KS-1)
      DO I = 1,NF
        CLN(I:I) = WK(KS+I)
      END DO
50    IF(WK(KS)==' ') RETURN
55    CLN = ' ======='
      END FUNCTION
C
      SUBROUTINE DIST(N,KD,MST,LOW,KF,JOB)
C JOB=1: The N entries in list KD are divergences (times 10).  The number that
C lie in interval (J-1)*8 to J*8 for J = 1,...,11 is written to file KF.
C JOB=2: Convert entries in MST to percents of total, display in KF.
      CHARACTER CLN*8
      INTEGER KD(*), LST(14), MST(14)
      SAVE NEW
      DATA NEW/1/
      IF(JOB>1) GOTO 30
      DO J = 1,14
        LST(J) = 0.
      END DO
      DO I = 1,N
        K = 1 + MIN(13,KD(I)/50)
        LST(K) = LST(K)+1.
        MST(K) = MST(K)+1.   ! MST accumulates LST over JOB=1 calls
        LOW = MIN(LOW,KD(I))
      END DO
      GOTO 50
30    IF(NEW>1) GOTO 51
      SUM = 0.
      DO J = 1,14
        SUM = SUM + MST(J)    ! MST = 0 until JOB=1 is called
      END DO
      DO J = 1,14
        LST(J) = NINT(100*MST(J)/MAX(1.,SUM))
      END DO
      NEW = 2

C           Congruence of XXXXXXXX.XXX No. xx with XXXXXXXX.XXX No. xx
C             Distribution of matched-factor divergences in degrees
C  Percentage distribution of matched-axes divergences, all comparisons combined
C  Freq  xx  xx  xx  xx  xx  xx  xx  xx  xx  xx  xx  xx  xx  xx 
C Ŀ
C Div  0   5  10  15  20  25  30  35  40  45  50  55  60  65  90

CC      Frequency  xx  xx  xx  xx  xx  xx  xx  xx  xx  xx  xx 
CC   Ŀ
CC   Divergence  0   8  16  24  32  40  48  56  64  72  80  90

50    IF(KF==0) RETURN
51    IF(NEW==1) WRITE(KF,'(13X,"Distribution of matched-factor ",
     +  "divergences in degrees")')
      IF(JOB>1) WRITE(KF,'(//"  Percentage distribution of match",
     +  "ed-axes divergences, all comparisons combined")')
C             WRITE(KF,'(6X,"Frequency ",14(A3," "))')
      WRITE(KF,'("  Freq ",14(A3," "))') (CLN(1.*LST(I),3,10),I=1,14)
C             WRITE(KF,'(3X,14(""),"",14(""),"Ŀ")')
      WRITE(KF,'(" ",14(""),"Ŀ")')
C             WRITE(KF,'(3X,14(""),"",14(""),"Ŀ")')
      WRITE(KF,'(" Div  0",14(A4,""),"")')
     +  (CLN(I*1.,4,13),I=5,65,5), CLN(90.,4,10)
      NEW = 0
      END SUBROUTINE
C
      SUBROUTINE DVRG(N,A1,A2,CUT,W,DV,S0,S1,S2)
C Compute the truncated/weighted divergence DV, RMS difference S0, and norms
C S1,S2 of order-N vectors A1 and A2.  Truncation assigns zero weight to element
C pairs wherein both items are less than CUT in magnitude.  Weighting by input
C parameter W (between 0 and 1) assigns each pair not ignored by CUT the weight
C [(1-W) + WV], where V is the mean absolute value of the paired elements.
      REAL A1(*), A2(*)
      REAL(8) DDV, SS0, SS1, SS2, SSW, T  ! Dble Precision not really needed
      R = 1.
20    DDV = 0.
      SS0 = 0.
      SS1 = 0.
      SS2 = 0.
      SSW = 0.
      DO I = 1,N
        IF(ABS(A1(I))<CUT .AND. ABS(A2(I))<CUT) CYCLE
        T = 1 - W + W*(ABS(A1(I))+ABS(A2(I)))/2
        DDV = DDV + T*R*A1(I)*A2(I)
        SS0 = SS0 + T*(R*A1(I)-A2(I))**2
        SS1 = SS1 + T*A1(I)*A1(I)
        SS2 = SS2 + T*A2(I)*A2(I)
        SSW = SSW + T
      END DO
      IF(DDV<0.) R = -1.
      IF(DDV<0.) GOTO 20
      IF(SSW<1-W) RETURN      ! No entries passing cut
      DV = DDV/SQRT(MAX(SS1*SS2,1.D-10))
      S0 = SNGL(SQRT(SS0/SSW))
      S1 = SNGL(SQRT(SS1/SSW))
      S2 = SNGL(SQRT(SS2/SSW))
      END SUBROUTINE
C
      SUBROUTINE GETNAM(F1,WORD,LLL)
C Recover full pathname of originating COV-file
      CHARACTER QFMT, F1*12, WORD*(*)
      LF1 = LAST(F1,12)
      IF(QFMT(F1)=='Y') THEN
        WORD = F1
        LLL = LF1
        RETURN
      END IF
      LLL = 1
      WORD(:12) = '            '
      WRITE(6,'(/8X,63A)') '', ('',I=1,61), ''
      WRITE(6,'(8X,A," WARNING. File ",A," containing needed variab",
     +  "le names ",2A/8X,A," has not been copied to this subdirect",
     +  "ory. To read it, enter ",A/8X,A," the full subdirectory na",
     +  "me (with leading but not trailing   ",A/8X,A," path-slash,",
     +  " and drive letter if needed) which contains this.",A)')
     +  '', F1(:LF1), WORD(:12-LF1), ('',I=1,7)
      WRITE(6,'(8X,A," Otherwise, hit RETURN to continue without ",
     +  "variable names.   ",A)') '', ''
      WRITE(6,'(8X,63A//)') '', ('',I=1,61), ''
10    READ(5,'(A)') WORD(:40)
      LL = LAST(WORD,40)
      IF(LL==0) F1(:1) = '?'; IF(LL==0) RETURN
      DO I = 1,LL
        N = ICHAR(WORD(I:I))
        IF(N>=97.AND.N<=122) WORD(I:I) = CHAR(N-32)
      END DO
      LLL = LL+1+LF1
      WORD(LL+1:LLL) = '\'//F1(:LF1)
      F1(12:12) = ' '
      IF(QFMT(WORD(:LLL))/='Y') THEN
        WRITE(6,'(" File ",A," has eluded detection.")') WORD(:LLL)
        F1(:1) = '?'
        WRITE(6,'(" Hit RETURN to continue, or enter another path ",
     +    "head to try again."/)')
        GOTO 10
      END IF
      END SUBROUTINE
C
      SUBROUTINE ISORT(N,LST)
C Sort Integers into ascending order and return permutation order in LST
      INTEGER LST(*)
10    DO J = 2,N
        L = LST(J)
        DO I = J-1,1,-1
          IF(LST(I)<=L) GOTO 12
          LST(I+1) = LST(I)
        END DO
        I = 0
12      LST(I+1) = L
      END DO
      END SUBROUTINE
C
      FUNCTION LAST(WORD,M)
C This left-justifies leading substring WORD(:M) of WORD, and returns its
C length as the function value. If the string is empty, LAST is returned as 0.
      CHARACTER WORD*(*)
      WORD(:M) = ADJUSTL(WORD(:M))
      LAST = LEN_TRIM(WORD(:M))
      END FUNCTION

      FUNCTION LH(WORD,LN)
C Look for extension dot in WORD.  If found, LH returns number of characters
C prior to that; otherwise, LH returns full length LN of WORD.
      CHARACTER WORD*(*)
      N = LEN(WORD)
      LN = LAST(WORD,N)
      LH = LN
      IF(LN==0) RETURN
      DO LH = 1,LN-1
        IF(WORD(LH+1:LH+1)=='.') RETURN
      END DO
      END FUNCTION
C
      SUBROUTINE LOOK(K,GET,NAME,ML,NL)
C LOOK calls DOS to delete or report files named in GET, with action set by K.
C K/2 = 0,1 initial-lists/append-lists GET in buffer file ZZZ. MOD(K,2) = 0,1
C stores/shows-to-screen the GET list. So K=0 initial-stores; K=1 initial-
C shows; K=2 append-stores; and K=3 append-shows. The last filename matching
C the GET template is returned in WORD with its length M.  NAME returns the
C list of template matches, the number of which is NL, and prints the numbered
C list to screen.  ML is max NL allowed by array allocation.
      LOGICAL PRM, QY, QLOG
      CHARACTER*12 GET*(*), NAME(*), WORD*40, WD*40, TMP
      CHARACTER E   ! <<<  Special characters as needed
      WD = GET
      M = LAST(WD,40)
      LL = 1
5     LL = LL+1
      E = WD(LL+1:LL+1)
      IF(E/='|' .AND. E/='/' .AND. LL<M) GOTO 5  ! *** No longer relevant??
      WD(M+2:M+LL+1) = WD(:LL); WD(40:40) = ' '  ! Shd now always have LL = M
      DO I = M+2,M+LL+1
        IF(WD(I:I)=='*' .OR. WD(I:I)=='?' ) THEN
          WD(40:40) = '!'; WD(I:I) = '!'
        END IF
      END DO
      INQUIRE(FILE=WD(M+2:M+LL+1),EXIST=QY)
      IF(.NOT.QY) OPEN(19,FILE=WD(M+2:M+LL+1)) ! Precludes no-match error message
      IF(K/2==0) CALL SYSTEM('dir '//WD(:M)//' >ZZZ')
      IF(K/2>0) CALL SYSTEM('dir '//WD(:M)//'>>ZZZ')
      IF(.NOT.QY) CLOSE(19,STATUS='DELETE')
      IF(MOD(K,2)==0) RETURN
      OPEN(4,FILE='ZZZ')
      NL = 0
10    READ(4,'(A)',END=50) WORD
      IF(.NOT.QLOG(WORD(:12))) GOTO 10
      IF(WORD(:1)==' ' .OR. WORD(:1)=='.') GOTO 10
      IF(WORD(25:26)==' 0' .OR. WORD(16:16)=='<') GOTO 10  ! No directory names
C       Filter out lines other than filenames
      L = LAST(WORD,14)
      DO I = 1,L
        IF(WORD(I:I)=='!') GOTO 10
      END DO
19    L = 0
20    L = L+1
      IF(WORD(L+1:L+1)/=' ' .AND. L<8) GOTO 20
      IF(WORD(10:10)/=' ') WORD(L+1:L+4) = '.'//WORD(10:12)
      DO I = 1,NL  !  Eliminate possible duplications
        IF(NAME(I)(:L+4)==WORD(:L+4) .AND. NAME(I)(L+5:L+5)==' ')
     +    GOTO 10
      END DO
      NL = NL+1
      NAME(NL) = WORD(:L+4)//'     '
      M = L+4
      IF(NL<ML) GOTO 10
50    IF(NL==0) M = 0
      CLOSE(4,STATUS='DELETE')
      DO J = 2,NL
        TMP = NAME(J)
        DO I = J-1,1,-1
          IF(.NOT.PRM(NAME(I),TMP)) GOTO 55    ! Increasing order
          NAME(I+1) = NAME(I)
        END DO
        I = 0
55      NAME(I+1) = TMP
      END DO
      IF(NL>0) WRITE(6,'(20(:/4(I5,". ",A,:)))') (I,NAME(I),I=1,NL)
      IF(NL>0) WORD(:12) = NAME(NL)
      RETURN
      END

      FUNCTION PRM(NAM1,NAM2)
C Consider both base and extension when flagging which filename comes first
C in alphanumeric listing.  PRM=t says that NAM2 comes before NAM1.
      LOGICAL PRM
      CHARACTER NAM1*(*), NAM2*(*)
      PRM = .FALSE.
      L1 = LAST(NAM1,LEN(NAM1)); L2 = LAST(NAM2,LEN(NAM2))
      N1 = L1+1; N2 = L2+1  ! Find dot positions, if any
10    N1 = N1-1; IF(NAM1(N1:N1)/='.' .AND. N1>1) GOTO 10
20    N2 = N2-1; IF(NAM2(N2:N2)/='.' .AND. N2>1) GOTO 20
      IF(N1==1) N1=L1+1; IF(N2==1) N2=L2+1  ! Where dot would be were there one
      JJ = KPRM(NAM1(:N1-1),NAM2(:N2-1))
      IF(JJ==-1) PRM = .TRUE.; IF(JJ/=0) RETURN  ! JJ=0 if basenames are same
      IF(JJ==0 .AND. (N1>L1 .OR. N2>L2)) THEN  ! An extension is blank
        IF(N2>L2) PRM = .TRUE.; RETURN
      END IF
      JJ = KPRM(NAM1(N1:L1),NAM2(N2:L2))  ! Include extension dot
      PRM = .FALSE.; IF(JJ==-1) PRM = .TRUE.
      END FUNCTION

      FUNCTION KPRM(WRD1,WRD2)
C Return value 0 if WRD1=WRD2; otherwise  -1 or +1 according to whether WRD2
C comes before or after WRD1 in alphanumeric sequence.
      INTEGER KPRM
      CHARACTER WRD1*(*), WRD2*(*)
      L1 = LAST(WRD1,LEN(WRD1)); L2 = LAST(WRD2,LEN(WRD2))
      KPRM = 0; IF(WRD1(:L1)==WRD2(:L2)) RETURN
      N1 = L1+1; N2 = L2+1    ! Find position preceding terminal number string
10    N1 = N1-1; N = ICHAR(WRD1(N1:N1))
         IF(N>47.AND.N<58 .AND. N1>1) GOTO 10
20    N2 = N2-1; N = ICHAR(WRD2(N2:N2))
         IF(N>47.AND.N<58 .AND. N2>1) GOTO 20
      IF(LLT(WRD1(:N1),WRD2(:N2))) KPRM = 1
      IF(LLT(WRD2(:N2),WRD1(:N1))) KPRM = -1
      IF(WRD1(:N1)/=WRD2(:N2)) RETURN
      IF(N1==L1 .OR. N2==L2) THEN  ! A number terminus is blank
        KPRM = 1; IF(N2==L2) KPRM = -1; RETURN
      END IF
      READ(WRD1(N1+1:L1),*) K1; READ(WRD2(N2+1:L2),*) K2
      KPRM = 1; IF(K2<K1) KPRM = -1
      END FUNCTION
C
      SUBROUTINE LOSS(K,L,NV,NF,A1,STOR, JA,JB,BH,CV1,WSAL,ADD,R0,R1)
C Returns Hyperplane-misfit of the Lth pattern measured by the chosen rotation
C parameters.  STOR(L,J) is the misfit of pattern column J; STOR(L,0) is mean.
C Actual arguments needed are NV,NF,A1,BH,JA,JB; also CV1/ADD/R0/R1
      LOGICAL QY, QZ
      REAL A1(MV,MF), STOR(MREC,0:MF,2), SS(NV), W(MV,0:MF)
      COMMON  MV, MF, MREC
      T = 0.; SS = 0.
      QY = .FALSE.; QZ = QY
      DO I = 0,NF       ! Col NF+1 not used by LOSS
        STOR(L,I,K) = 0.
      END DO
      IF(WSAL<0.) GOTO 60
      IF(WSAL>=.01) QY = .TRUE.
      IF(.NOT.QY) GOTO 20
C Compute matrix of salience weights rescaled to average 1.
      IF(ABS(WSAL-1.)<.01) QZ = .TRUE.   ! QZ=T omits powering by WSAL=1
      DO I = 1,NV
        S = 0.
        DO J = 1,NF
          IF(QZ) W(I,J) = ABS(A1(I,J))
          IF(.NOT.QZ) W(I,J) = ABS(A1(I,J))**WSAL
          S = S + W(I,J)
        END DO
        W(I,0) = S   !  raw weights for item i over all factors
        T = T+S
      END DO
      T = (NF-1)*T/(NF*NV)   ! NF-1 times overall mean raw weight for norming
      DO I = 1,NV
        DO J = 1,NF ! Get mean weight over factors excluding j with globally
          W(I,J) = (W(I,0)-W(I,J))/T  ! I's weight when rotating Fac J
        END DO
      END DO
20    DO J = 1,NF
        DO I = 1,NV
          X = FIT(A1(I,J),BH,JA,JB,CV1,ADD,R0,R1)
          IF(QY) X = X*W(I,J)
          STOR(L,J,K) = STOR(L,J,K) + X
        END DO
        STOR(L,0,K) = STOR(L,0,K) + STOR(L,J,K)
      END DO
      GOTO 70
60    DO I = 1,NV   ! Start Comp2 weighting
        DO J = 1,NF
          SS(I) = SS(I) + A1(I,J)**2
        END DO
      END DO
      DO I = 1,NV
        DO J = 2,NF
          DO JJ = 1,J-1
            FJ = FIT(A1(I,J),BH,JA,JB,CV1,ADD,R0,R1)
            FK = FIT(A1(I,JJ),BH,JA,JB,CV1,ADD,R0,R1)
            WI = 1. + WSAL*COMP2(A1(I,J),A1(I,JJ),SS(I))
ccc            LOSS = LOSS + (FJ+FK)*WI
            STOR(L,J,K) = STOR(L,J,K) + FJ*WI
            STOR(L,JJ,K) = STOR(L,JJ,K) + FK*WI
          END DO
        END DO
      END DO
      DO J = 1,NF
        NF0 = NF-1; STOR(L,J,K) = STOR(L,J,K)/NF0
        STOR(L,0,K) = STOR(L,0,K) + STOR(L,J,K)
      END DO
70    STOR(L,0,K) = STOR(L,0,K)/NF
      RETURN
      END SUBROUTINE

      FUNCTION FIT(A,BH,JA,JB,CV1,ADD,R0,R1)
C Get the unweighted misfit of coefficient A under current loss parameters
CCC      COMMON /BL3/ BH,JA,JB,CV1,ADD,R0,R1
      D = A/BH; E = D*D
      IF(E>=1.) GOTO 30
      IF(JA==0) X = E
      IF(JA>0) X = (CV1 - R0*(E**JA))*E
      IF(JA==-1) X = 2*ABS(D)
      IF(JA<-1) X = (E**R0)/R0
      GOTO 50
30    X = 1./E
      IF(JB<=2) GOTO 45
      DO K = 3,JB
        X = X/E
      END DO
45    X = ADD - R1*X
50    FIT = X
      RETURN
      END FUNCTION
C
      SUBROUTINE PRNT(JOB,KP,KFILE)
C Set printer codes. JOB=0/1/2 if job is find-linewidth/set-normal-print/set-
C HYBALL-pattern-plots.  KP is linewidth. KFILE is file to write.
      CHARACTER QFMT, WORD*55
      IF(QFMT('PRNTR')=='U') THEN
        IF(JOB==0) WRITE(KFILE,'(/" WARNING: There is no printer ",
     +    "definition in this subdirectory.")')
        IF(JOB==1) WRITE(KFILE,'(" %")')
        IF(JOB==2) WRITE(KFILE,'(" #")')
        RETURN
      END IF
      OPEN(1,FILE='PRNTR')
      READ(1,'(A)') WORD
      IF(WORD(:1)=='*') KP = 80
      IF(JOB==0) GOTO 10
      IF(WORD(:1)/='%') READ(1,'(A)') WORD
      IF(JOB==1) WRITE(KFILE,'(A)') WORD(3:)
      IF(JOB==1) GOTO 10
      READ(1,'(A)') WORD
      WRITE(KFILE,'(A)') WORD(3:)
10    CLOSE(1)
      RETURN
      END
C
      FUNCTION QLOG(WORD)
C  Return .TRUE. if WORD is a HYBUF file, otherwise .FALSE.
      LOGICAL QLOG
      CHARACTER WORD*(*)
      QLOG = .FALSE.
      IF(WORD(:5)=='HYBUF' .OR. WORD(9:10)==' #') QLOG = .TRUE.
      N = LH(WORD,LN)
      IF(QLOG .OR. N>=LN-1) RETURN
      IF(WORD(N+2:N+2)=='#') QLOG = .TRUE.
      RETURN
      END
C
      SUBROUTINE RATE(FH,FM,LPIK,MC,NV,NF,NT,LOGS)
C Load into STOR(_,_,K) (K=1,LOGS) a misfit appraisal of the HYBUF records.
      CHARACTER(12) CLN*8, FH(2), FM(2), CF
      INTEGER NV(2), NF(2), LPIK(MREC,2), NT(2)
      REAL A1(MV,MF), STOR(MREC,0:MF,2), XX(4)
      COMMON  MV, MF, MREC
      EXTERNAL SCAN
      COMMON /CF/ CF
      DATA JA,JB,BH,CV,WSAL/2,2,.20,1.,1./
C      SAVE JA, JB, BH, CV, WSAL
C Enter parameters
10    STOR = 0.
      WRITE(6,'(/10X,5("* ")," Pick your Misfit measure ",5(" *"))')
15    WRITE(6,'(/" Hyperplane-misfit parameters <BH,JA,JB,CV> are n",
     +  "ow <",A3,",",I2,",",I2,",",A4," >."/" Hit RETURN if OK; ot",
     +  "herwise, enter new 4-tuple of settings wanted."/3X,"Notes:",
     +  " Item weighting WSAL will be approved or adjusted next."/10X,
     +  "Entering fewer than 4 terms applies those to start of list."/
     +  10X,"Entry of a letter cancels misfit appraisal."/)')
     +  CLN(BH,3,2), JA, JB, CLN(CV,4,1)
      CALL SCAN(J,0,'R',5)
      IF(J==0) GOTO 30
      IF(J<=-1) RETURN
      READ(2,*) (XX(I),I=1,J)
      B = XX(1); IF(B>=.1 .AND. B<=99.) BH = B
20    IF(BH>=1.) BH = BH/10; IF(BH>=1.) GOTO 20
      IF(J<2) GOTO 15
      N = NINT(XX(2)); IF(N>=-9 .AND. N<=10) JA = N
      IF(J<3) GOTO 15
      N =  NINT(XX(3)); IF(N>=2.AND.N<=10) JB = N
      IF(J<4) GOTO 15
      B = XX(4)
      IF(B>=-1. .AND. B<=10.) CV = B
25    GOTO 15
30    CV1 = CV+1
      IF(JA>=0) R0 = CV/(JA+1)
      IF(JA<0) R0 = 1./(1.-JA)
      IF(JA<0) CV1 = R0-1.
      R1 = 1./(JB-1)
      IF(JA>=0) ADD = JB*R1 + JA*R0
      IF(JA<0) ADD = (1.-JA) + R1
35    WRITE(6,'(/" Item weighting is now WSAL = ",A4,".  Hit RETURN i",
     +  "f OK; otherwise, enter a"/" non-negative power (advisedly n",
     +  "ot greater than 2) for salience weighting,"/" or a number i",
     +  "n the unit interval with negative sign for Comp2 weighting."/
     +  " WSAL = 0 is no weighting."/)') CLN(WSAL,4,2)
      CALL SCAN(J,0,'R',5)
      IF(J==0) GOTO 40
      IF(J<=-1) GOTO 35
      READ(2,*) WSAL
      WSAL = MAX(-1.,MIN(10.,WSAL))
      GOTO 35
C Load STOR with ratings
40    FLR = 1.E8  ! Initialize low common to both sets
      DO K = 1,LOGS
        DO L = 1,NT(K)
          READ(10+K,REC=L) ((A1(I,J),I=1,NV(K)),J=1,NF(K))
          CALL LOSS(K,L,NV(K),NF(K),A1,STOR,JA,JB,BH,CV1,WSAL,ADD,R0,R1)
          FLR = MIN(FLR,STOR(L,0,K))
        END DO
      END DO
C Write results files
      BIG: DO KF = 6,7
        WRITE(KF,'(/" Relative Misfit ratings under <BH,JA,JB,CV,WS",
     +    "AL> = <",A4,",",I2,",",I2,",",A4,",",A4,">"/" on the indi"
     +    "vidual factors in each stored pattern:")') CLN(BH,4,2),
     +    JA, JB, CLN(CV,4,1), CLN(WSAL,4,1)
        DO K = 1,LOGS
          WRITE(KF,'(/" Records in log file ",A," (from ",A,"):"
     +      )') FH(K)(:LAST(FH(K),12)), FM(K)(:LAST(FM(K),12))
          M = 20
CC          IF(NF(K)>10) M = 10
          DO L = 1,NT(K)
            SG = 0.
            DO J = 1,NF(K)
              SG = SG + (STOR(L,J,K)-STOR(L,0,K))**2
            END DO
            IF(NF(K)>1) SG = SQRT(MAX(.000001,SG/NF(K)))/FLR
CC            IF(KF==6) WRITE(KF,'(I4,". (Mean = ",A5,", SD =",A4,
CC     +        ")",10A5,3(:/20X,15A5))') L, CLN(STOR(L,0,K)/FLR,5,3),
CC     +        CLN(SG,4,2), (CLN(STOR(L,J,K)/FLR,5,2),J=1,NF(K))
            IF(KF==6) WRITE(KF,'(I4,". Mean = ",A5,", SD =",A4)')
     +         L, CLN(STOR(L,0,K)/FLR,5,3), CLN(SG,4,2)
            IF(KF/=6) WRITE(KF,'(I4,". (Mean = ",A5,", SD =",A4,
     +        ") ", 20A5, 3(:/20X,22A5))') L,CLN(STOR(L,0,K)/FLR,5,3),
     +        CLN(SG,4,2), (CLN(STOR(L,J,K)/FLR,5,2),J=1,NF(K))
            LPIK(L,K) = 100*NINT(1000*STOR(L,0,K)/FLR) + L
            IF(KF==6 .AND. MOD(L,M)==0) CALL WAIT(0)
          END DO
          CALL ISORT(NT(K),LPIK(1,K))
          DO L = 1,NT(K)
            LPIK(L,K) = MOD(LPIK(L,K),100) ! LPIK now holds indices ordered by LOSS
          END DO
          M = NT(K)
          IF(KF==6) M = MIN(M,29)
          WRITE(KF,'(" The preference ranking of these patterns by ",
     +      "this measure is",5(:/40(1X,A)))') (CF(:JF(LPIK(I,K))),
     +      I=1,M)
          IF(KF==6) CALL WAIT(0)
        END DO
      END DO BIG
      WRITE(6,'(/" If you want to appraise these stored patterns by",
     + " another setting of the misfit"/" parameters, enter anyth",
     + "ing.  Otherwise, hit RETURN to get on with congruences.")')
      CALL SCAN(J,0,'B',5)
      IF(J<0) GOTO 10
      END SUBROUTINE
C
      SUBROUTINE SCAN(NL,NS,SEQ,KF)
C     Copyright (c) 1999 by W. W. Rozeboom.   All rights reserved.
C This reads the keyboard string, cleans it for list-directed reading of
C the numbers therein, and checks whether it contains NS integers/reals in
C the sequence of Is and Rs received in SEQ if NS>0, or, if NS<1, whether
C all its numbers are of the first I/R kind listed in SEQ. (Integers are
C accepted also as reals.  Termination of an input line by "*" allows up to
C two continuation lines.) NL returns 0 if the input string is blank, -1 if
C this contains only non-numeric characters, -2 if the cleaned number
C string returned in File 2 is non-null but does not match SEQ, and
C gives the total count of numbers in the returned string otherwise.
C *** If SEQ is "B", NL returns 0 if the input line is blank, and
C     returns -1 otherwise.
      CHARACTER  AA, SEQ*(*), WA*240, WB*240
      NL = 0
5     NLL = NL + 80
      READ(KF,'(A80)') WA(NL+1:NLL)
      IP = NL
      NL = NLL+1
10    NL = NL-1
      IF(NL==0) RETURN
      IF(WA(NL:NL)==' ') GOTO 10
      IF(WA(NL:NL)=='*' .AND. NL>IP) GOTO 5
      IF(SEQ(1:1)=='B') NL = -1
      IF(SEQ(1:1)=='B') RETURN
      WB(NL+1:NL+1) = ' '
      DO I = 1,NL
        WB(I:I) = ' '
        IF(WA(I:I)<CHAR(48) .OR. WA(I:I)>CHAR(57)) CYCLE
        WB(I:I) = WA(I:I)
        WA(I:I) = '0'
      END DO
      IP = 0
      IF(WA(:3)=='-.0') WB(:1) = '-'
      IF(WA(:2)=='-0') WB(:1) = '-'
      IF(WA(:2)=='.0') WB(:1) = '.'
      IF(WA(:2)=='.0') IP = 1
      DO I = 2,NL
        IF(WA(I:I)=='-') THEN
          IF(WB(I-1:I-1)==' ' .AND. (WA(I+1:I+1)=='.'.OR.WA(I+1:I+1)
     +      =='0')) WB(I:I) = '-'
          IP = 0
        ELSE IF (WA(I:I)=='.') THEN
          IF((WA(I-1:I-1)=='0'.OR.WA(I+1:I+1)=='0') .AND. IP==0)
     +      WB(I:I) = '.'
          IF(WB(I:I) == '.') IP = 1
        ELSE IF (WA(I:I) /= '0') THEN
          IP = 0
        END IF
      END DO
C Identify Integer/Real sequence in WB and put in start of WA
      AA = 'I'
      IF(WB(1:1)=='.') AA = 'R'
      NN = 0
      DO I = 2,NL+1
        IF(WB(I:I)==' ' .AND. WB(I-1:I-1)/=' ') THEN
          NN = NN + 1
          WA(NN:NN) = AA
          AA = 'I'
        ELSE IF (WB(I:I)=='.') THEN
          AA = 'R'
        END IF
      END DO
      IF(NN==0) NL = -1
      IF(NN==0) RETURN
      AA = '+'
      IF(NS<=0 .AND. SEQ(1:1)=='R') GOTO 60
      IF(NS<=0) GOTO 50
      IF(NN<NS) GOTO 57
      DO I = 1,NS
        IF(SEQ(I:I)=='I' .AND. WA(I:I)/='I') AA = '0'
      END DO
      GOTO 55
50    DO I = 1,NN
        IF(WA(I:I)/=SEQ(1:1)) AA = '0'
      END DO
55    IF(AA=='+') GOTO 60
57    NL = -2
      IF(NL<=-2) WRITE(6,'(/'' Your input does not contain the '',
     + ''number sequence requested. Try again.'')')
      RETURN
60    REWIND 2
      WRITE(2,'(A)') WB(1:NL)
      NL = NN
      REWIND 2
      END SUBROUTINE
C
      SUBROUTINE SCHEMA(NV,NF,CUT,NAML,AA,GET,DG,WK,IDENT,KF)
C Display schematized factor patterns in AA paired by GET, with dots for
C loadings smaller than CUT and others rounded to nearest two decimals.
C DG inputs matched-fctor divergences computed along with GET by AALIGN.
      CHARACTER*7 LN(30)*7, CLN*8, IDENT(*)*8, CH5*5  ! Can treat IDENT as vector here
      INTEGER GET(*)
      REAL AA(MV,MF,2), DD(MV), DG(*), WK(*)
      COMMON  MV, MF, MREC
      EXTERNAL SCAN

C Patterns No. xx (#1) in cccccccc.ccc and No. xx (#2) in cccccccc.ccc juxtaposed
C by matching columns.  Each vertical cell of the table headed "M N" comprises
C column M of #1 followed by its best-matching column N of #2. Pattern loadings are
C given to 2 decimals with point omitted; values larger than .99 are rounded down;
C and values smaller than parameter CUT are blanked.  At the table's foot, Div is
C the column-pair's congruence divergence, RMSd is the root-mean-square difference
C (x 100) of their corresponding elements, and RMSj (j = 1,2) is pattern No.j's
C RMS (x 100) loading on this factor.  Variables have the order of their received
C occurrence in Pattern #2; and if paired factors are negatively congruent as
C received, #1 is reflected when computing Div and RMSd.
101   DO I = 1,MF
        WK(I) = I
      END DO
      CH5 = '     '
      WRITE(KF,'(/4X,"CUT =",A4)') CLN(CUT,4,2)
      WRITE(KF,'("  #1  #2",30(2I3,""))') (NINT(WK(GET(I))),I,I=1,NF)
      WRITE(KF,'("",30A)') ('',I=1,NF-1),'͵'
      DO I = 1,NV
        DO J = 1,NF
          LN(J) = ' .  . '
          X = AA(I,GET(J),1)
          Y = AA(I,J,2)
          IF(ABS(X)<=CUT .AND. ABS(Y)<=CUT) CYCLE  ! ********** Not working for double negative???
          X = MAX(-99.,MIN(99.,ANINT(100*X)))
          Y = MAX(-99.,MIN(99.,ANINT(100*Y)))
          LN(J)(1:3) = CLN(X,3,11)
          LN(J)(4:6) = CLN(Y,3,11)
        END DO
        WRITE(KF,'(2A,"",30A)') CH5(:8-NAML), IDENT(I)(:NAML),
     +    (LN(J),J=1,NF)
      END DO
      WRITE(KF,'("",30A)') ('',I=1,NF-1),'Ĵ'
      WRITE(KF,'("   Div  ",30(A5,""))') (CLN(DG(I),5,1),I=1,NF)
      DO J = 1,NF
        S = 0.            ! S collects A1-A2 diff
        WK(J) = 0.        ! WK(_) collects A1-squared
        WK(NF+J) = 0.     ! WK(NF+_) collects A2-squared
        DO I = 1,NV
          S = S + (AA(I,GET(J),1)-AA(I,J,2))**2
          WK(J) = WK(J) + AA(I,GET(J),1)**2
          WK(NF+J) = WK(NF+J) + AA(I,J,2)**2
        END DO
        DD(J) = 100*SQRT(S/NV)
        WK(J) = 100*SQRT(WK(J)/NV)
        WK(NF+J) = 100*SQRT(WK(NF+J)/NV)
      END DO
      WRITE(KF,'("   RMSd ",30(A5," "))') (CLN(DD(J),5,1),J=1,NF)
      WRITE(KF,'("   RMS1 ",30(A5," "))') (CLN(WK(J),5,1),J=1,NF)
      WRITE(KF,'("   RMS2 ",30(A5," "))') (CLN(WK(NF+J),5,1),J=1,NF)
C Also look at truncated and weighted diverg/diff/norms
      RAD = 90/ACOS(0.)
      NF2 = 2*NF
      W = 0.   ! Can be set anywhere in unit interval. W=0 is equal weighting
      DO J = 1,NF
        CALL DVRG(NV,AA(1,GET(J),1),AA(1,J,2),CUT,W,DV,S0,S1,S2) ! Reflects as needed
        DD(J) = ACOS(MIN(1.,DV))*RAD
        WK(J) = 100*S1
        WK(NF+J) = 100*S2
        WK(NF2+J) = 100*S0
      END DO
      WRITE(KF,'("",30A)') ('',I=1,NF-1),'Ĵ'
      WRITE(KF,'(" > Div  ",30(A5,""))') (CLN(DD(J),5,1),J=1,NF)
      WRITE(KF,'(" > RMSd ",30(A5," "))') (CLN(WK(NF2+J),5,1),J=1,NF)
      WRITE(KF,'(" > RMS1 ",30(A5," "))') (CLN(WK(J),5,1),J=1,NF)
      WRITE(KF,'(" > RMS2 ",30(A5," "))') (CLN(WK(NF+J),5,1),J=1,NF)

C      W = 1.   ! W=1 is pure salience weighting.
C      DO J = 1,NF
C        CALL DVRG(NV,AA(1,GET(J),1),AA(1,J,2),0.,W,DV,S0,S1,S2)
C        DD(J) = ACOS(MIN(1.,DV))*RAD
C        WK(J) = 100*S1
C        WK(NF+J) = 100*S2
C        WK(NF2+J) = 100*S0
C      END DO
C      WRITE(KF,'('''',30A)') ('',I=1,NF-1),'Ĵ'
C      WRITE(KF,'('' w Div  '',30(A5,''"))') (CLN(DD(J),5,1),J=1,NF)
C      WRITE(KF,'(" w RMSd ",30(A5," "))') (CLN(WK(NF2+J),5,1),J=1,NF)
C      WRITE(KF,'(" w RMS1 ",30(A5," "))') (CLN(WK(J),5,1),J=1,NF)
C      WRITE(KF,'(" w RMS2 ",30(A5," "))') (CLN(WK(NF+J),5,1),J=1,NF)

      WRITE(KF,'("",30A)') ('',I=1,NF-1),''
      WRITE(KF,'(" >: Measures ignoring item pairs in which both ",
     +  "loadings are smaller than ",A4," (really",A4,").")')
     +  CLN(CUT*100,4,1), CLN(CUT,4,2)
C      WRITE(KF,'(" w: Measures that weight each pair (none ignored)",
C     + " by the mean size of its loadings (Salience weighting).")')
      WRITE(6,'(/" Comparison has been recorded at CUT-level",A4,
     +  ".  If you would like to repeat"/" this with a different CUT,",
     +  " enter its value.  Otherwise, hit RETURN."/)') CLN(CUT,4,2)
      CALL SCAN(J,0,'R',5)
      If(J<=0) RETURN
      READ(2,*) CUT
105   IF(CUT<0. .OR. CUT>1.5) CUT = ABS(CUT/10)
      IF(CUT>1.5) GOTO 105
      GOTO 101
      END SUBROUTINE
C
      SUBROUTINE SHOW(NV,NF,FMT1,A1,COMM)
C This writes to screen (if IO=6) or to RESULTS file (if IO=7) the current
C factor pattern/covariances
      CHARACTER FMT1*(*), FMT2*53, CLN*8, CH1
      REAL A1(MV,*), COMM(*)
      COMMON  MV, MF, MREC
      FMT2 = '(I4,". (",A3,")"'//FMT1(7:)
      FMT2(23:23) = '6'
      FMT2(42:42) = '6'
CC      NL = 1+(NF-1)/12  ! Number of display lines per record
      DO I = 1,NV
        IF(MOD(I-1,5)==0) WRITE(6,'()')
        WRITE(6,FMT2) I, CLN(COMM(I),3,2), (CLN(A1(I,J),5,2),J=1,NF)
        IF(MOD(I,10)/=0 .OR. I>=NV-2) CYCLE
        WRITE(6,'(" Hit RETURN to continue, or enter anything to ",
     +    "quit this display.")')
        READ(5,'(A)') CH1
        IF(CH1/=' ') RETURN
      END DO
      CALL WAIT(0)
      END SUBROUTINE
C
      SUBROUTINE START(J,F1)
C This opens formatted file F1 with unit-number J, and finds its first line
C beginning with a digit.
      CHARACTER F1*(*), CH*80
      OPEN(J,FILE=F1)
10    READ(J,'(A)',END=50) CH
      K = 0
12    K = K+1
      L = ICHAR(CH(K:K))
      IF((L==32 .OR. L==0) .AND. K<80) GOTO 12
      IF(L<48 .OR. L>57) GOTO 10
      BACKSPACE J
      RETURN
50    WRITE(6,'(/" File ",A," is defective.")') F1
      STOP
      END
C
      SUBROUTINE WAIT(K)
      IF(K>0) WRITE(6,'()')
      WRITE(6,'(" Hit RETURN to continue")')
      READ(5,'(A1)')
      END SUBROUTINE
C
      SUBROUTINE DAY(N)
C This date-stamps output file N
      CHARACTER ZZZ*8, WORD*18, CF*12, LST(12)*10
      COMMON /CF/ CF
      DATA LST/'January  7','February 8','March    5','April    5',
     +         'May      3','June     4','July     4','August   6',
     +         'September9','October  7','November 8','December 8'/
      CALL DATE_AND_TIME(ZZZ)  ! Last three outputs not used here
      M = 10*(ICHAR(ZZZ(7:7))-48) + ICHAR(ZZZ(8:8))-48  ! M gets day of month
      READ(ZZZ(5:6),*) L; K = ICHAR(LST(L)(10:10))-48
      WORD = CF(:JF(M))//' '//LST(L)(:K)//' '//ZZZ(:4)
      WRITE(N,'(/20X,"Date of this run:  ",A)') WORD
      END SUBROUTINE
C
      FUNCTION QFMT(F1)
C This determines the status of file F1, returning 'Y' if it is Formatted,
C 'N' if it is Not, and 'U' if it is Unknown (does not exist).
      CHARACTER QFMT, F1*(*)
      INQUIRE(FILE=F1,FORMATTED=QFMT)
      RETURN
      END

